; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mcpu=tahiti -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX67,GFX6
; RUN: llc -mcpu=hawaii -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX67,GFX7
; RUN: llc -mcpu=fiji -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefix=GFX8
; RUN: llc -mcpu=gfx900 -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX910,GFX9
; RUN: llc -mcpu=gfx1010 -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GFX910,GFX10
; RUN: llc -mcpu=gfx1100 -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefix=GFX11
; RUN: llc -mcpu=gfx1200 -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck %s -check-prefix=GFX12

define amdgpu_ps void @struct_buffer_load_i8_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX67-LABEL: struct_buffer_load_i8_tfe:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    v_mov_b32_e32 v4, 0
; GFX67-NEXT:    v_mov_b32_e32 v5, v4
; GFX67-NEXT:    buffer_load_ubyte v[4:5], v4, s[0:3], 0 idxen tfe
; GFX67-NEXT:    s_mov_b32 s2, 0
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s0, s2
; GFX67-NEXT:    s_mov_b32 s1, s2
; GFX67-NEXT:    s_waitcnt vmcnt(0)
; GFX67-NEXT:    buffer_store_byte v4, v[0:1], s[0:3], 0 addr64
; GFX67-NEXT:    buffer_store_dword v5, v[2:3], s[0:3], 0 addr64
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_i8_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    buffer_load_ubyte v[4:5], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_byte v[0:1], v4
; GFX8-NEXT:    flat_store_dword v[2:3], v5
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_i8_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    buffer_load_ubyte v[4:5], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_byte v[0:1], v4, off
; GFX910-NEXT:    global_store_dword v[2:3], v5, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_i8_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    buffer_load_u8 v[4:5], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b8 v[0:1], v4, off
; GFX11-NEXT:    global_store_b32 v[2:3], v5, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_i8_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mov_b32_e32 v5, v4
; GFX12-NEXT:    buffer_load_u8 v[4:5], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b8 v[0:1], v4, off
; GFX12-NEXT:    global_store_b32 v[2:3], v5, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { i8, i32 } @llvm.amdgcn.struct.buffer.load.sl_i8i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { i8, i32 } %res, 0
  store i8 %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { i8, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_i16_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX67-LABEL: struct_buffer_load_i16_tfe:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    v_mov_b32_e32 v4, 0
; GFX67-NEXT:    v_mov_b32_e32 v5, v4
; GFX67-NEXT:    buffer_load_ushort v[4:5], v4, s[0:3], 0 idxen tfe
; GFX67-NEXT:    s_mov_b32 s2, 0
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s0, s2
; GFX67-NEXT:    s_mov_b32 s1, s2
; GFX67-NEXT:    s_waitcnt vmcnt(0)
; GFX67-NEXT:    buffer_store_short v4, v[0:1], s[0:3], 0 addr64
; GFX67-NEXT:    buffer_store_dword v5, v[2:3], s[0:3], 0 addr64
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_i16_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    buffer_load_ushort v[4:5], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_short v[0:1], v4
; GFX8-NEXT:    flat_store_dword v[2:3], v5
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_i16_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    buffer_load_ushort v[4:5], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_short v[0:1], v4, off
; GFX910-NEXT:    global_store_dword v[2:3], v5, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_i16_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    buffer_load_u16 v[4:5], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b16 v[0:1], v4, off
; GFX11-NEXT:    global_store_b32 v[2:3], v5, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_i16_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mov_b32_e32 v5, v4
; GFX12-NEXT:    buffer_load_u16 v[4:5], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b16 v[0:1], v4, off
; GFX12-NEXT:    global_store_b32 v[2:3], v5, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { i16, i32 } @llvm.amdgcn.struct.buffer.load.sl_i16i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { i16, i32 } %res, 0
  store i16 %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { i16, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_f16_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX67-LABEL: struct_buffer_load_f16_tfe:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    v_mov_b32_e32 v4, 0
; GFX67-NEXT:    v_mov_b32_e32 v5, v4
; GFX67-NEXT:    buffer_load_ushort v[4:5], v4, s[0:3], 0 idxen tfe
; GFX67-NEXT:    s_mov_b32 s2, 0
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s0, s2
; GFX67-NEXT:    s_mov_b32 s1, s2
; GFX67-NEXT:    s_waitcnt vmcnt(0)
; GFX67-NEXT:    buffer_store_short v4, v[0:1], s[0:3], 0 addr64
; GFX67-NEXT:    buffer_store_dword v5, v[2:3], s[0:3], 0 addr64
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_f16_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    buffer_load_ushort v[4:5], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_short v[0:1], v4
; GFX8-NEXT:    flat_store_dword v[2:3], v5
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_f16_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    buffer_load_ushort v[4:5], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_short v[0:1], v4, off
; GFX910-NEXT:    global_store_dword v[2:3], v5, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_f16_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    buffer_load_u16 v[4:5], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b16 v[0:1], v4, off
; GFX11-NEXT:    global_store_b32 v[2:3], v5, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_f16_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mov_b32_e32 v5, v4
; GFX12-NEXT:    buffer_load_u16 v[4:5], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b16 v[0:1], v4, off
; GFX12-NEXT:    global_store_b32 v[2:3], v5, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { half, i32 } @llvm.amdgcn.struct.buffer.load.sl_f16i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { half, i32 } %res, 0
  store half %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { half, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_i32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX67-LABEL: struct_buffer_load_i32_tfe:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    v_mov_b32_e32 v4, 0
; GFX67-NEXT:    v_mov_b32_e32 v5, v4
; GFX67-NEXT:    buffer_load_dword v[4:5], v4, s[0:3], 0 idxen tfe
; GFX67-NEXT:    s_mov_b32 s2, 0
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s0, s2
; GFX67-NEXT:    s_mov_b32 s1, s2
; GFX67-NEXT:    s_waitcnt vmcnt(0)
; GFX67-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64
; GFX67-NEXT:    buffer_store_dword v5, v[2:3], s[0:3], 0 addr64
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_i32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    buffer_load_dword v[4:5], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dword v[0:1], v4
; GFX8-NEXT:    flat_store_dword v[2:3], v5
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_i32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    buffer_load_dword v[4:5], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dword v[0:1], v4, off
; GFX910-NEXT:    global_store_dword v[2:3], v5, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    buffer_load_b32 v[4:5], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v4, off
; GFX11-NEXT:    global_store_b32 v[2:3], v5, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_i32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mov_b32_e32 v5, v4
; GFX12-NEXT:    buffer_load_b32 v[4:5], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v4, off
; GFX12-NEXT:    global_store_b32 v[2:3], v5, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { i32, i32 } @llvm.amdgcn.struct.buffer.load.sl_i32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { i32, i32 } %res, 0
  store i32 %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { i32, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_v2i32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX6-LABEL: struct_buffer_load_v2i32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v4, 0
; GFX6-NEXT:    v_mov_b32_e32 v5, v4
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v7, v4
; GFX6-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_store_dword v6, v[2:3], s[0:3], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: struct_buffer_load_v2i32_tfe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_load_dwordx2 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_store_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    buffer_store_dword v6, v[2:3], s[0:3], 0 addr64
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_v2i32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    buffer_load_dwordx2 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[4:5]
; GFX8-NEXT:    flat_store_dword v[2:3], v6
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_v2i32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    v_mov_b32_e32 v6, v4
; GFX910-NEXT:    buffer_load_dwordx2 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dwordx2 v[0:1], v[4:5], off
; GFX910-NEXT:    global_store_dword v[2:3], v6, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_v2i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    buffer_load_b64 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b64 v[0:1], v[4:5], off
; GFX11-NEXT:    global_store_b32 v[2:3], v6, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_v2i32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    buffer_load_b64 v[4:6], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b64 v[0:1], v[4:5], off
; GFX12-NEXT:    global_store_b32 v[2:3], v6, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { <2 x i32>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v2i32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <2 x i32>, i32 } %res, 0
  store <2 x i32> %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { <2 x i32>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_v2f32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX6-LABEL: struct_buffer_load_v2f32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v4, 0
; GFX6-NEXT:    v_mov_b32_e32 v5, v4
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v7, v4
; GFX6-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_store_dword v6, v[2:3], s[0:3], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: struct_buffer_load_v2f32_tfe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_load_dwordx2 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_store_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    buffer_store_dword v6, v[2:3], s[0:3], 0 addr64
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_v2f32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    buffer_load_dwordx2 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx2 v[0:1], v[4:5]
; GFX8-NEXT:    flat_store_dword v[2:3], v6
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_v2f32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    v_mov_b32_e32 v6, v4
; GFX910-NEXT:    buffer_load_dwordx2 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dwordx2 v[0:1], v[4:5], off
; GFX910-NEXT:    global_store_dword v[2:3], v6, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_v2f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    buffer_load_b64 v[4:6], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b64 v[0:1], v[4:5], off
; GFX11-NEXT:    global_store_b32 v[2:3], v6, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_v2f32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    buffer_load_b64 v[4:6], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b64 v[0:1], v[4:5], off
; GFX12-NEXT:    global_store_b32 v[2:3], v6, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { <2 x float>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v2f32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <2 x float>, i32 } %res, 0
  store <2 x float> %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { <2 x float>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_v3i32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX6-LABEL: struct_buffer_load_v3i32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v4, 0
; GFX6-NEXT:    v_mov_b32_e32 v5, v4
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v7, v4
; GFX6-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v6, v[0:1], s[0:3], 0 addr64 offset:8
; GFX6-NEXT:    buffer_store_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_store_dword v7, v[2:3], s[0:3], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: struct_buffer_load_v3i32_tfe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v7, v4
; GFX7-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_store_dwordx3 v[4:6], v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    buffer_store_dword v7, v[2:3], s[0:3], 0 addr64
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_v3i32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, v4
; GFX8-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx3 v[0:1], v[4:6]
; GFX8-NEXT:    flat_store_dword v[2:3], v7
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_v3i32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    v_mov_b32_e32 v6, v4
; GFX910-NEXT:    v_mov_b32_e32 v7, v4
; GFX910-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dwordx3 v[0:1], v[4:6], off
; GFX910-NEXT:    global_store_dword v[2:3], v7, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_v3i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    v_mov_b32_e32 v7, v4
; GFX11-NEXT:    buffer_load_b96 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b96 v[0:1], v[4:6], off
; GFX11-NEXT:    global_store_b32 v[2:3], v7, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_v3i32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    v_mov_b32_e32 v7, v4
; GFX12-NEXT:    buffer_load_b96 v[4:7], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b96 v[0:1], v[4:6], off
; GFX12-NEXT:    global_store_b32 v[2:3], v7, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { <3 x i32>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v3i32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <3 x i32>, i32 } %res, 0
  store <3 x i32> %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { <3 x i32>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_v3f32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX6-LABEL: struct_buffer_load_v3f32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v4, 0
; GFX6-NEXT:    v_mov_b32_e32 v5, v4
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v7, v4
; GFX6-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v6, v[0:1], s[0:3], 0 addr64 offset:8
; GFX6-NEXT:    buffer_store_dwordx2 v[4:5], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    buffer_store_dword v7, v[2:3], s[0:3], 0 addr64
; GFX6-NEXT:    s_endpgm
;
; GFX7-LABEL: struct_buffer_load_v3f32_tfe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mov_b32_e32 v4, 0
; GFX7-NEXT:    v_mov_b32_e32 v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v7, v4
; GFX7-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s0, s2
; GFX7-NEXT:    s_mov_b32 s1, s2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_store_dwordx3 v[4:6], v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    buffer_store_dword v7, v[2:3], s[0:3], 0 addr64
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_v3f32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, v4
; GFX8-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx3 v[0:1], v[4:6]
; GFX8-NEXT:    flat_store_dword v[2:3], v7
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_v3f32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    v_mov_b32_e32 v6, v4
; GFX910-NEXT:    v_mov_b32_e32 v7, v4
; GFX910-NEXT:    buffer_load_dwordx3 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dwordx3 v[0:1], v[4:6], off
; GFX910-NEXT:    global_store_dword v[2:3], v7, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_v3f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    v_mov_b32_e32 v7, v4
; GFX11-NEXT:    buffer_load_b96 v[4:7], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b96 v[0:1], v[4:6], off
; GFX11-NEXT:    global_store_b32 v[2:3], v7, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_v3f32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    v_mov_b32_e32 v7, v4
; GFX12-NEXT:    buffer_load_b96 v[4:7], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b96 v[0:1], v[4:6], off
; GFX12-NEXT:    global_store_b32 v[2:3], v7, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { <3 x float>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v3f32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <3 x float>, i32 } %res, 0
  store <3 x float> %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { <3 x float>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_v4i32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX67-LABEL: struct_buffer_load_v4i32_tfe:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    v_mov_b32_e32 v4, 0
; GFX67-NEXT:    v_mov_b32_e32 v5, v4
; GFX67-NEXT:    v_mov_b32_e32 v6, v4
; GFX67-NEXT:    v_mov_b32_e32 v7, v4
; GFX67-NEXT:    v_mov_b32_e32 v8, v4
; GFX67-NEXT:    buffer_load_dwordx4 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX67-NEXT:    s_mov_b32 s2, 0
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s0, s2
; GFX67-NEXT:    s_mov_b32 s1, s2
; GFX67-NEXT:    s_waitcnt vmcnt(0)
; GFX67-NEXT:    buffer_store_dwordx4 v[4:7], v[0:1], s[0:3], 0 addr64
; GFX67-NEXT:    buffer_store_dword v8, v[2:3], s[0:3], 0 addr64
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_v4i32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, v4
; GFX8-NEXT:    v_mov_b32_e32 v8, v4
; GFX8-NEXT:    buffer_load_dwordx4 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NEXT:    flat_store_dword v[2:3], v8
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_v4i32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    v_mov_b32_e32 v6, v4
; GFX910-NEXT:    v_mov_b32_e32 v7, v4
; GFX910-NEXT:    v_mov_b32_e32 v8, v4
; GFX910-NEXT:    buffer_load_dwordx4 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dwordx4 v[0:1], v[4:7], off
; GFX910-NEXT:    global_store_dword v[2:3], v8, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_v4i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    v_mov_b32_e32 v7, v4
; GFX11-NEXT:    v_mov_b32_e32 v8, v4
; GFX11-NEXT:    buffer_load_b128 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b128 v[0:1], v[4:7], off
; GFX11-NEXT:    global_store_b32 v[2:3], v8, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_v4i32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    v_dual_mov_b32 v7, v4 :: v_dual_mov_b32 v8, v4
; GFX12-NEXT:    buffer_load_b128 v[4:8], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b128 v[0:1], v[4:7], off
; GFX12-NEXT:    global_store_b32 v[2:3], v8, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { <4 x i32>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v4i32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <4 x i32>, i32 } %res, 0
  store <4 x i32> %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { <4 x i32>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

define amdgpu_ps void @struct_buffer_load_v4f32_tfe(<4 x i32> inreg %rsrc, ptr addrspace(1) %data_addr, ptr addrspace(1) %tfe_addr) {
; GFX67-LABEL: struct_buffer_load_v4f32_tfe:
; GFX67:       ; %bb.0:
; GFX67-NEXT:    v_mov_b32_e32 v4, 0
; GFX67-NEXT:    v_mov_b32_e32 v5, v4
; GFX67-NEXT:    v_mov_b32_e32 v6, v4
; GFX67-NEXT:    v_mov_b32_e32 v7, v4
; GFX67-NEXT:    v_mov_b32_e32 v8, v4
; GFX67-NEXT:    buffer_load_dwordx4 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX67-NEXT:    s_mov_b32 s2, 0
; GFX67-NEXT:    s_mov_b32 s3, 0xf000
; GFX67-NEXT:    s_mov_b32 s0, s2
; GFX67-NEXT:    s_mov_b32 s1, s2
; GFX67-NEXT:    s_waitcnt vmcnt(0)
; GFX67-NEXT:    buffer_store_dwordx4 v[4:7], v[0:1], s[0:3], 0 addr64
; GFX67-NEXT:    buffer_store_dword v8, v[2:3], s[0:3], 0 addr64
; GFX67-NEXT:    s_endpgm
;
; GFX8-LABEL: struct_buffer_load_v4f32_tfe:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v4, 0
; GFX8-NEXT:    v_mov_b32_e32 v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, v4
; GFX8-NEXT:    v_mov_b32_e32 v8, v4
; GFX8-NEXT:    buffer_load_dwordx4 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GFX8-NEXT:    flat_store_dword v[2:3], v8
; GFX8-NEXT:    s_endpgm
;
; GFX910-LABEL: struct_buffer_load_v4f32_tfe:
; GFX910:       ; %bb.0:
; GFX910-NEXT:    v_mov_b32_e32 v4, 0
; GFX910-NEXT:    v_mov_b32_e32 v5, v4
; GFX910-NEXT:    v_mov_b32_e32 v6, v4
; GFX910-NEXT:    v_mov_b32_e32 v7, v4
; GFX910-NEXT:    v_mov_b32_e32 v8, v4
; GFX910-NEXT:    buffer_load_dwordx4 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX910-NEXT:    s_waitcnt vmcnt(0)
; GFX910-NEXT:    global_store_dwordx4 v[0:1], v[4:7], off
; GFX910-NEXT:    global_store_dword v[2:3], v8, off
; GFX910-NEXT:    s_endpgm
;
; GFX11-LABEL: struct_buffer_load_v4f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v5, v4
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    v_mov_b32_e32 v7, v4
; GFX11-NEXT:    v_mov_b32_e32 v8, v4
; GFX11-NEXT:    buffer_load_b128 v[4:8], v4, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b128 v[0:1], v[4:7], off
; GFX11-NEXT:    global_store_b32 v[2:3], v8, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: struct_buffer_load_v4f32_tfe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v4, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    v_dual_mov_b32 v7, v4 :: v_dual_mov_b32 v8, v4
; GFX12-NEXT:    buffer_load_b128 v[4:8], v4, s[0:3], null idxen tfe
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b128 v[0:1], v[4:7], off
; GFX12-NEXT:    global_store_b32 v[2:3], v8, off
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
  %res = call { <4 x float>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v4f32i32s(<4 x i32> %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <4 x float>, i32 } %res, 0
  store <4 x float> %data, ptr addrspace(1) %data_addr
  %tfe = extractvalue { <4 x float>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) %tfe_addr
  ret void
}

declare { i8, i32 } @llvm.amdgcn.struct.buffer.load.sl_i8i32s(<4 x i32>, i32, i32, i32, i32)
declare { i16, i32 } @llvm.amdgcn.struct.buffer.load.sl_i16i32s(<4 x i32>, i32, i32, i32, i32)
declare { half, i32 } @llvm.amdgcn.struct.buffer.load.sl_f16i32s(<4 x i32>, i32, i32, i32, i32)
declare { i32, i32 } @llvm.amdgcn.struct.buffer.load.sl_i32i32s(<4 x i32>, i32, i32, i32, i32)
declare { <2 x i32>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v2i32i32s(<4 x i32>, i32, i32, i32, i32)
declare { <2 x float>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v2f32i32s(<4 x i32>, i32, i32, i32, i32)
declare { <3 x i32>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v3i32i32s(<4 x i32>, i32, i32, i32, i32)
declare { <3 x float>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v3f32i32s(<4 x i32>, i32, i32, i32, i32)
declare { <4 x i32>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v4i32i32s(<4 x i32>, i32, i32, i32, i32)
declare { <4 x float>, i32 } @llvm.amdgcn.struct.buffer.load.sl_v4f32i32s(<4 x i32>, i32, i32, i32, i32)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10: {{.*}}
; GFX9: {{.*}}
