# RUN: llvm-mc -triple x86_64 -show-encoding -x86-asm-syntax=intel -output-asm-variant=1 %s | FileCheck %s

# CHECK: ctestb {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0xf6,0x44,0x80,0x7b,0x7b]
         ctestb {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestb {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestb {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestb {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestb {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestb {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestb {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestb {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x84,0x5c,0x80,0x7b]
         ctestb {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestb {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0x85,0x54,0x80,0x7b]
         ctestb {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestb {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x85,0x4c,0x80,0x7b]
         ctestb {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestb {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x85,0x4c,0x80,0x7b]
         ctestb {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestb {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0xf6,0xc3,0x7b]
         ctestb {dfv=of} bl, 123
# CHECK: ctestb {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0xf7,0xc2,0xd2,0x04]
         ctestb {dfv=of} dx, 1234
# CHECK: ctestb {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestb {dfv=of} ecx, 123456
# CHECK: ctestb {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestb {dfv=of} r9, 123456
# CHECK: ctestb {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x84,0xda]
         ctestb {dfv=of} dl, bl
# CHECK: ctestb {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0x85,0xd0]
         ctestb {dfv=of} ax, dx
# CHECK: ctestb {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x85,0xca]
         ctestb {dfv=of} edx, ecx
# CHECK: ctestb {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x85,0xcf]
         ctestb {dfv=of} r15, r9
# CHECK: ctestbe {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0xf6,0x44,0x80,0x7b,0x7b]
         ctestbe {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestbe {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x06,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestbe {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestbe {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x06,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestbe {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestbe {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestbe {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestbe {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0x84,0x5c,0x80,0x7b]
         ctestbe {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestbe {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x06,0x85,0x54,0x80,0x7b]
         ctestbe {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestbe {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0x85,0x4c,0x80,0x7b]
         ctestbe {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestbe {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x06,0x85,0x4c,0x80,0x7b]
         ctestbe {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestbe {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0xf6,0xc3,0x7b]
         ctestbe {dfv=of} bl, 123
# CHECK: ctestbe {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x06,0xf7,0xc2,0xd2,0x04]
         ctestbe {dfv=of} dx, 1234
# CHECK: ctestbe {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestbe {dfv=of} ecx, 123456
# CHECK: ctestbe {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x06,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestbe {dfv=of} r9, 123456
# CHECK: ctestbe {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0x84,0xda]
         ctestbe {dfv=of} dl, bl
# CHECK: ctestbe {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x06,0x85,0xd0]
         ctestbe {dfv=of} ax, dx
# CHECK: ctestbe {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0x85,0xca]
         ctestbe {dfv=of} edx, ecx
# CHECK: ctestbe {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x06,0x85,0xcf]
         ctestbe {dfv=of} r15, r9
# CHECK: ctestf {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0xf6,0x44,0x80,0x7b,0x7b]
         ctestf {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestf {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestf {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestf {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestf {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestf {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestf {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestf {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x84,0x5c,0x80,0x7b]
         ctestf {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestf {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0x85,0x54,0x80,0x7b]
         ctestf {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestf {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x85,0x4c,0x80,0x7b]
         ctestf {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestf {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x85,0x4c,0x80,0x7b]
         ctestf {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestf {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0xf6,0xc3,0x7b]
         ctestf {dfv=of} bl, 123
# CHECK: ctestf {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0xf7,0xc2,0xd2,0x04]
         ctestf {dfv=of} dx, 1234
# CHECK: ctestf {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestf {dfv=of} ecx, 123456
# CHECK: ctestf {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestf {dfv=of} r9, 123456
# CHECK: ctestf {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x84,0xda]
         ctestf {dfv=of} dl, bl
# CHECK: ctestf {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0x85,0xd0]
         ctestf {dfv=of} ax, dx
# CHECK: ctestf {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x85,0xca]
         ctestf {dfv=of} edx, ecx
# CHECK: ctestf {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x85,0xcf]
         ctestf {dfv=of} r15, r9
# CHECK: ctestl {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0xf6,0x44,0x80,0x7b,0x7b]
         ctestl {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestl {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestl {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestl {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestl {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestl {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestl {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestl {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x84,0x5c,0x80,0x7b]
         ctestl {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestl {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0x85,0x54,0x80,0x7b]
         ctestl {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestl {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x85,0x4c,0x80,0x7b]
         ctestl {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestl {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x85,0x4c,0x80,0x7b]
         ctestl {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestl {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0xf6,0xc3,0x7b]
         ctestl {dfv=of} bl, 123
# CHECK: ctestl {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0xf7,0xc2,0xd2,0x04]
         ctestl {dfv=of} dx, 1234
# CHECK: ctestl {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestl {dfv=of} ecx, 123456
# CHECK: ctestl {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestl {dfv=of} r9, 123456
# CHECK: ctestl {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x84,0xda]
         ctestl {dfv=of} dl, bl
# CHECK: ctestl {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0x85,0xd0]
         ctestl {dfv=of} ax, dx
# CHECK: ctestl {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x85,0xca]
         ctestl {dfv=of} edx, ecx
# CHECK: ctestl {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x85,0xcf]
         ctestl {dfv=of} r15, r9
# CHECK: ctestle {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0xf6,0x44,0x80,0x7b,0x7b]
         ctestle {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestle {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestle {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestle {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestle {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestle {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestle {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestle {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x84,0x5c,0x80,0x7b]
         ctestle {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestle {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0x85,0x54,0x80,0x7b]
         ctestle {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestle {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x85,0x4c,0x80,0x7b]
         ctestle {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestle {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x85,0x4c,0x80,0x7b]
         ctestle {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestle {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0xf6,0xc3,0x7b]
         ctestle {dfv=of} bl, 123
# CHECK: ctestle {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0xf7,0xc2,0xd2,0x04]
         ctestle {dfv=of} dx, 1234
# CHECK: ctestle {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestle {dfv=of} ecx, 123456
# CHECK: ctestle {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestle {dfv=of} r9, 123456
# CHECK: ctestle {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x84,0xda]
         ctestle {dfv=of} dl, bl
# CHECK: ctestle {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0x85,0xd0]
         ctestle {dfv=of} ax, dx
# CHECK: ctestle {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x85,0xca]
         ctestle {dfv=of} edx, ecx
# CHECK: ctestle {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x85,0xcf]
         ctestle {dfv=of} r15, r9
# CHECK: ctestae {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0xf6,0x44,0x80,0x7b,0x7b]
         ctestae {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestae {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestae {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestae {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestae {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestae {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestae {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestae {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x84,0x5c,0x80,0x7b]
         ctestae {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestae {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0x85,0x54,0x80,0x7b]
         ctestae {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestae {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x85,0x4c,0x80,0x7b]
         ctestae {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestae {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x85,0x4c,0x80,0x7b]
         ctestae {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestae {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0xf6,0xc3,0x7b]
         ctestae {dfv=of} bl, 123
# CHECK: ctestae {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0xf7,0xc2,0xd2,0x04]
         ctestae {dfv=of} dx, 1234
# CHECK: ctestae {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestae {dfv=of} ecx, 123456
# CHECK: ctestae {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestae {dfv=of} r9, 123456
# CHECK: ctestae {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x84,0xda]
         ctestae {dfv=of} dl, bl
# CHECK: ctestae {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0x85,0xd0]
         ctestae {dfv=of} ax, dx
# CHECK: ctestae {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x85,0xca]
         ctestae {dfv=of} edx, ecx
# CHECK: ctestae {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x85,0xcf]
         ctestae {dfv=of} r15, r9
# CHECK: ctesta {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0xf6,0x44,0x80,0x7b,0x7b]
         ctesta {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctesta {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctesta {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctesta {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesta {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctesta {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesta {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctesta {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x84,0x5c,0x80,0x7b]
         ctesta {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctesta {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0x85,0x54,0x80,0x7b]
         ctesta {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctesta {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x85,0x4c,0x80,0x7b]
         ctesta {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctesta {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x85,0x4c,0x80,0x7b]
         ctesta {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctesta {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0xf6,0xc3,0x7b]
         ctesta {dfv=of} bl, 123
# CHECK: ctesta {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0xf7,0xc2,0xd2,0x04]
         ctesta {dfv=of} dx, 1234
# CHECK: ctesta {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesta {dfv=of} ecx, 123456
# CHECK: ctesta {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesta {dfv=of} r9, 123456
# CHECK: ctesta {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x84,0xda]
         ctesta {dfv=of} dl, bl
# CHECK: ctesta {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0x85,0xd0]
         ctesta {dfv=of} ax, dx
# CHECK: ctesta {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x85,0xca]
         ctesta {dfv=of} edx, ecx
# CHECK: ctesta {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x85,0xcf]
         ctesta {dfv=of} r15, r9
# CHECK: ctestge {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0xf6,0x44,0x80,0x7b,0x7b]
         ctestge {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestge {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestge {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestge {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestge {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestge {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestge {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestge {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x84,0x5c,0x80,0x7b]
         ctestge {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestge {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0x85,0x54,0x80,0x7b]
         ctestge {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestge {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x85,0x4c,0x80,0x7b]
         ctestge {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestge {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x85,0x4c,0x80,0x7b]
         ctestge {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestge {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0xf6,0xc3,0x7b]
         ctestge {dfv=of} bl, 123
# CHECK: ctestge {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0xf7,0xc2,0xd2,0x04]
         ctestge {dfv=of} dx, 1234
# CHECK: ctestge {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestge {dfv=of} ecx, 123456
# CHECK: ctestge {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestge {dfv=of} r9, 123456
# CHECK: ctestge {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x84,0xda]
         ctestge {dfv=of} dl, bl
# CHECK: ctestge {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0x85,0xd0]
         ctestge {dfv=of} ax, dx
# CHECK: ctestge {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x85,0xca]
         ctestge {dfv=of} edx, ecx
# CHECK: ctestge {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x85,0xcf]
         ctestge {dfv=of} r15, r9
# CHECK: ctestg {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0xf6,0x44,0x80,0x7b,0x7b]
         ctestg {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestg {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestg {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestg {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestg {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestg {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestg {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestg {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x84,0x5c,0x80,0x7b]
         ctestg {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestg {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0x85,0x54,0x80,0x7b]
         ctestg {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestg {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x85,0x4c,0x80,0x7b]
         ctestg {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestg {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x85,0x4c,0x80,0x7b]
         ctestg {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestg {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0xf6,0xc3,0x7b]
         ctestg {dfv=of} bl, 123
# CHECK: ctestg {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0xf7,0xc2,0xd2,0x04]
         ctestg {dfv=of} dx, 1234
# CHECK: ctestg {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestg {dfv=of} ecx, 123456
# CHECK: ctestg {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestg {dfv=of} r9, 123456
# CHECK: ctestg {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x84,0xda]
         ctestg {dfv=of} dl, bl
# CHECK: ctestg {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0x85,0xd0]
         ctestg {dfv=of} ax, dx
# CHECK: ctestg {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x85,0xca]
         ctestg {dfv=of} edx, ecx
# CHECK: ctestg {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x85,0xcf]
         ctestg {dfv=of} r15, r9
# CHECK: ctestno {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0xf6,0x44,0x80,0x7b,0x7b]
         ctestno {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestno {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestno {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestno {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestno {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestno {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestno {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestno {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x84,0x5c,0x80,0x7b]
         ctestno {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestno {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0x85,0x54,0x80,0x7b]
         ctestno {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestno {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x85,0x4c,0x80,0x7b]
         ctestno {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestno {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x85,0x4c,0x80,0x7b]
         ctestno {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestno {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0xf6,0xc3,0x7b]
         ctestno {dfv=of} bl, 123
# CHECK: ctestno {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0xf7,0xc2,0xd2,0x04]
         ctestno {dfv=of} dx, 1234
# CHECK: ctestno {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestno {dfv=of} ecx, 123456
# CHECK: ctestno {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestno {dfv=of} r9, 123456
# CHECK: ctestno {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x84,0xda]
         ctestno {dfv=of} dl, bl
# CHECK: ctestno {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0x85,0xd0]
         ctestno {dfv=of} ax, dx
# CHECK: ctestno {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x85,0xca]
         ctestno {dfv=of} edx, ecx
# CHECK: ctestno {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x85,0xcf]
         ctestno {dfv=of} r15, r9
# CHECK: ctestns {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0xf6,0x44,0x80,0x7b,0x7b]
         ctestns {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestns {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestns {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestns {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestns {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestns {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestns {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestns {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x84,0x5c,0x80,0x7b]
         ctestns {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestns {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0x85,0x54,0x80,0x7b]
         ctestns {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestns {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x85,0x4c,0x80,0x7b]
         ctestns {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestns {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x85,0x4c,0x80,0x7b]
         ctestns {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestns {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0xf6,0xc3,0x7b]
         ctestns {dfv=of} bl, 123
# CHECK: ctestns {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0xf7,0xc2,0xd2,0x04]
         ctestns {dfv=of} dx, 1234
# CHECK: ctestns {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestns {dfv=of} ecx, 123456
# CHECK: ctestns {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestns {dfv=of} r9, 123456
# CHECK: ctestns {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x84,0xda]
         ctestns {dfv=of} dl, bl
# CHECK: ctestns {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0x85,0xd0]
         ctestns {dfv=of} ax, dx
# CHECK: ctestns {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x85,0xca]
         ctestns {dfv=of} edx, ecx
# CHECK: ctestns {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x85,0xcf]
         ctestns {dfv=of} r15, r9
# CHECK: ctestne {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0xf6,0x44,0x80,0x7b,0x7b]
         ctestne {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestne {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestne {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestne {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestne {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestne {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestne {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestne {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x84,0x5c,0x80,0x7b]
         ctestne {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestne {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0x85,0x54,0x80,0x7b]
         ctestne {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestne {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x85,0x4c,0x80,0x7b]
         ctestne {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestne {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x85,0x4c,0x80,0x7b]
         ctestne {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestne {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0xf6,0xc3,0x7b]
         ctestne {dfv=of} bl, 123
# CHECK: ctestne {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0xf7,0xc2,0xd2,0x04]
         ctestne {dfv=of} dx, 1234
# CHECK: ctestne {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestne {dfv=of} ecx, 123456
# CHECK: ctestne {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestne {dfv=of} r9, 123456
# CHECK: ctestne {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x84,0xda]
         ctestne {dfv=of} dl, bl
# CHECK: ctestne {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0x85,0xd0]
         ctestne {dfv=of} ax, dx
# CHECK: ctestne {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x85,0xca]
         ctestne {dfv=of} edx, ecx
# CHECK: ctestne {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x85,0xcf]
         ctestne {dfv=of} r15, r9
# CHECK: ctesto {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0xf6,0x44,0x80,0x7b,0x7b]
         ctesto {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctesto {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctesto {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctesto {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesto {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctesto {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesto {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctesto {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x84,0x5c,0x80,0x7b]
         ctesto {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctesto {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0x85,0x54,0x80,0x7b]
         ctesto {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctesto {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x85,0x4c,0x80,0x7b]
         ctesto {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctesto {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x85,0x4c,0x80,0x7b]
         ctesto {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctesto {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0xf6,0xc3,0x7b]
         ctesto {dfv=of} bl, 123
# CHECK: ctesto {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0xf7,0xc2,0xd2,0x04]
         ctesto {dfv=of} dx, 1234
# CHECK: ctesto {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesto {dfv=of} ecx, 123456
# CHECK: ctesto {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesto {dfv=of} r9, 123456
# CHECK: ctesto {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x84,0xda]
         ctesto {dfv=of} dl, bl
# CHECK: ctesto {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0x85,0xd0]
         ctesto {dfv=of} ax, dx
# CHECK: ctesto {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x85,0xca]
         ctesto {dfv=of} edx, ecx
# CHECK: ctesto {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x85,0xcf]
         ctesto {dfv=of} r15, r9
# CHECK: ctests {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0xf6,0x44,0x80,0x7b,0x7b]
         ctests {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctests {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctests {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctests {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctests {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctests {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctests {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctests {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x84,0x5c,0x80,0x7b]
         ctests {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctests {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0x85,0x54,0x80,0x7b]
         ctests {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctests {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x85,0x4c,0x80,0x7b]
         ctests {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctests {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x85,0x4c,0x80,0x7b]
         ctests {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctests {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0xf6,0xc3,0x7b]
         ctests {dfv=of} bl, 123
# CHECK: ctests {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0xf7,0xc2,0xd2,0x04]
         ctests {dfv=of} dx, 1234
# CHECK: ctests {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctests {dfv=of} ecx, 123456
# CHECK: ctests {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctests {dfv=of} r9, 123456
# CHECK: ctests {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x84,0xda]
         ctests {dfv=of} dl, bl
# CHECK: ctests {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0x85,0xd0]
         ctests {dfv=of} ax, dx
# CHECK: ctests {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x85,0xca]
         ctests {dfv=of} edx, ecx
# CHECK: ctests {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x85,0xcf]
         ctests {dfv=of} r15, r9
# CHECK: ctestt {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0xf6,0x44,0x80,0x7b,0x7b]
         ctestt {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: ctestt {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestt {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: ctestt {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestt {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestt {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestt {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: ctestt {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x84,0x5c,0x80,0x7b]
         ctestt {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: ctestt {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0x85,0x54,0x80,0x7b]
         ctestt {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: ctestt {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x85,0x4c,0x80,0x7b]
         ctestt {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: ctestt {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x85,0x4c,0x80,0x7b]
         ctestt {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: ctestt {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0xf6,0xc3,0x7b]
         ctestt {dfv=of} bl, 123
# CHECK: ctestt {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0xf7,0xc2,0xd2,0x04]
         ctestt {dfv=of} dx, 1234
# CHECK: ctestt {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestt {dfv=of} ecx, 123456
# CHECK: ctestt {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestt {dfv=of} r9, 123456
# CHECK: ctestt {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x84,0xda]
         ctestt {dfv=of} dl, bl
# CHECK: ctestt {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0x85,0xd0]
         ctestt {dfv=of} ax, dx
# CHECK: ctestt {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x85,0xca]
         ctestt {dfv=of} edx, ecx
# CHECK: ctestt {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x85,0xcf]
         ctestt {dfv=of} r15, r9
# CHECK: cteste {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0xf6,0x44,0x80,0x7b,0x7b]
         cteste {dfv=of} byte ptr [r8 + 4*rax + 123], 123
# CHECK: cteste {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         cteste {dfv=of} word ptr [r8 + 4*rax + 123], 1234
# CHECK: cteste {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         cteste {dfv=of} qword ptr [r8 + 4*rax + 123], 123456
# CHECK: cteste {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         cteste {dfv=of} dword ptr [r8 + 4*rax + 123], 123456
# CHECK: cteste {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x84,0x5c,0x80,0x7b]
         cteste {dfv=of} byte ptr [r8 + 4*rax + 123], bl
# CHECK: cteste {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0x85,0x54,0x80,0x7b]
         cteste {dfv=of} word ptr [r8 + 4*rax + 123], dx
# CHECK: cteste {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x85,0x4c,0x80,0x7b]
         cteste {dfv=of} dword ptr [r8 + 4*rax + 123], ecx
# CHECK: cteste {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x85,0x4c,0x80,0x7b]
         cteste {dfv=of} qword ptr [r8 + 4*rax + 123], r9
# CHECK: cteste {dfv=of} bl, 123
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0xf6,0xc3,0x7b]
         cteste {dfv=of} bl, 123
# CHECK: cteste {dfv=of} dx, 1234
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0xf7,0xc2,0xd2,0x04]
         cteste {dfv=of} dx, 1234
# CHECK: cteste {dfv=of} ecx, 123456
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         cteste {dfv=of} ecx, 123456
# CHECK: cteste {dfv=of} r9, 123456
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         cteste {dfv=of} r9, 123456
# CHECK: cteste {dfv=of} dl, bl
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x84,0xda]
         cteste {dfv=of} dl, bl
# CHECK: cteste {dfv=of} ax, dx
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0x85,0xd0]
         cteste {dfv=of} ax, dx
# CHECK: cteste {dfv=of} edx, ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x85,0xca]
         cteste {dfv=of} edx, ecx
# CHECK: cteste {dfv=of} r15, r9
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x85,0xcf]
         cteste {dfv=of} r15, r9
