; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX512,AVX512BW
;
; Just two 32-bit runs to make sure we do reasonable things there.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86-SSE,X86-SSE2
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=X86-SSE,X86-SSE41

define <8 x i16> @sext_16i8_to_8i16(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_8i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psraw $8, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_8i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psraw $8, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_8i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_16i8_to_8i16:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_8i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psraw $8, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_8i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <16 x i8> %A, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %C = sext <8 x i8> %B to <8 x i16>
  ret <8 x i16> %C
}

define <16 x i16> @sext_16i8_to_16i16(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_16i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE2-NEXT:    psraw $8, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; SSE2-NEXT:    psraw $8, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_16i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSSE3-NEXT:    psraw $8, %xmm2
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; SSSE3-NEXT:    psraw $8, %xmm1
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_16i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_16i8_to_16i16:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_16i8_to_16i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_16i8_to_16i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_16i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE2-NEXT:    psraw $8, %xmm2
; X86-SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; X86-SSE2-NEXT:    psraw $8, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_16i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <16 x i8> %A to <16 x i16>
  ret <16 x i16> %B
}

define <32 x i16> @sext_32i8_to_32i16(<32 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_32i8_to_32i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSE2-NEXT:    psraw $8, %xmm4
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; SSE2-NEXT:    psraw $8, %xmm5
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE2-NEXT:    psraw $8, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE2-NEXT:    psraw $8, %xmm3
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_32i8_to_32i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; SSSE3-NEXT:    psraw $8, %xmm4
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; SSSE3-NEXT:    psraw $8, %xmm5
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSSE3-NEXT:    psraw $8, %xmm2
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSSE3-NEXT:    psraw $8, %xmm3
; SSSE3-NEXT:    movdqa %xmm4, %xmm0
; SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_32i8_to_32i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm5
; SSE41-NEXT:    pmovsxbw %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    movdqa %xmm4, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_32i8_to_32i16:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_32i8_to_32i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sext_32i8_to_32i16:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpmovsxbw %xmm0, %ymm1
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: sext_32i8_to_32i16:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    vpmovsxbw %ymm0, %zmm0
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: sext_32i8_to_32i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; X86-SSE2-NEXT:    psraw $8, %xmm4
; X86-SSE2-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; X86-SSE2-NEXT:    psraw $8, %xmm5
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; X86-SSE2-NEXT:    psraw $8, %xmm2
; X86-SSE2-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; X86-SSE2-NEXT:    psraw $8, %xmm3
; X86-SSE2-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm5, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_32i8_to_32i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm5
; X86-SSE41-NEXT:    pmovsxbw %xmm1, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm3
; X86-SSE41-NEXT:    movdqa %xmm5, %xmm0
; X86-SSE41-NEXT:    movdqa %xmm4, %xmm1
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <32 x i8> %A to <32 x i16>
  ret <32 x i16> %B
}

define <4 x i32> @sext_16i8_to_4i32(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_4i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_4i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_4i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_16i8_to_4i32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_4i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_4i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <16 x i8> %A, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %C = sext <4 x i8> %B to <4 x i32>
  ret <4 x i32> %C
}

define <8 x i32> @sext_16i8_to_8i32(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_8i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_8i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_8i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_16i8_to_8i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_16i8_to_8i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_16i8_to_8i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_8i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_8i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbd %xmm0, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X86-SSE41-NEXT:    pmovsxbd %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <16 x i8> %A, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %C = sext <8 x i8> %B to <8 x i32>
  ret <8 x i32> %C
}

define <16 x i32> @sext_16i8_to_16i32(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_16i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSE2-NEXT:    psrad $24, %xmm3
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_16i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSSE3-NEXT:    psrad $24, %xmm4
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSSE3-NEXT:    psrad $24, %xmm2
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSSE3-NEXT:    psrad $24, %xmm3
; SSSE3-NEXT:    movdqa %xmm4, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_16i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxbd %xmm1, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxbd %xmm2, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_16i8_to_16i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxbd %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbd %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_16i8_to_16i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_16i8_to_16i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_16i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $24, %xmm4
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $24, %xmm2
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X86-SSE2-NEXT:    psrad $24, %xmm3
; X86-SSE2-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_16i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbd %xmm0, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-SSE41-NEXT:    pmovsxbd %xmm1, %xmm1
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxbd %xmm2, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X86-SSE41-NEXT:    pmovsxbd %xmm0, %xmm3
; X86-SSE41-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <16 x i8> %A to <16 x i32>
  ret <16 x i32> %B
}

define <2 x i64> @sext_16i8_to_2i64(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_2i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_2i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_2i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_16i8_to_2i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <16 x i8> %A, <16 x i8> undef, <2 x i32> <i32 0, i32 1>
  %C = sext <2 x i8> %B to <2 x i64>
  ret <2 x i64> %C
}

define <4 x i64> @sext_16i8_to_4i64(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm2
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_16i8_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_16i8_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_16i8_to_4i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm2
; X86-SSE41-NEXT:    psrld $16, %xmm0
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <16 x i8> %A, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %C = sext <4 x i8> %B to <4 x i64>
  ret <4 x i64> %C
}

define <8 x i64> @sext_16i8_to_8i64(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i8_to_8i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    psrad $24, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i8_to_8i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSSE3-NEXT:    psrad $24, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i8_to_8i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    pmovsxbq %xmm1, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxbq %xmm2, %xmm2
; SSE41-NEXT:    psrlq $48, %xmm0
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_16i8_to_8i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_16i8_to_8i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_16i8_to_8i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbq %xmm0, %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i8_to_8i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    pxor %xmm4, %xmm4
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; X86-SSE2-NEXT:    psrad $24, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i8_to_8i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm4
; X86-SSE41-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE41-NEXT:    psrld $16, %xmm1
; X86-SSE41-NEXT:    pmovsxbq %xmm1, %xmm1
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; X86-SSE41-NEXT:    pmovsxbq %xmm2, %xmm2
; X86-SSE41-NEXT:    psrlq $48, %xmm0
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm3
; X86-SSE41-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <16 x i8> %A, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %C = sext <8 x i8> %B to <8 x i64>
  ret <8 x i64> %C
}

define <4 x i32> @sext_8i16_to_4i32(<8 x i16> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i16_to_4i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i16_to_4i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i16_to_4i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_8i16_to_4i32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i16_to_4i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i16_to_4i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <8 x i16> %A, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %C = sext <4 x i16> %B to <4 x i32>
  ret <4 x i32> %C
}

define <8 x i32> @sext_8i16_to_8i32(<8 x i16> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i16_to_8i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i16_to_8i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSSE3-NEXT:    psrad $16, %xmm2
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i16_to_8i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_8i16_to_8i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_8i16_to_8i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_8i16_to_8i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i16_to_8i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $16, %xmm2
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i16_to_8i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxwd %xmm0, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxwd %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <8 x i16> %A to <8 x i32>
  ret <8 x i32> %B
}

define <16 x i32> @sext_16i16_to_16i32(<16 x i16> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_16i16_to_16i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm4
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm0[4],xmm5[5],xmm0[5],xmm5[6],xmm0[6],xmm5[7],xmm0[7]
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_16i16_to_16i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; SSSE3-NEXT:    psrad $16, %xmm4
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm0[4],xmm5[5],xmm0[5],xmm5[6],xmm0[6],xmm5[7],xmm0[7]
; SSSE3-NEXT:    psrad $16, %xmm5
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSSE3-NEXT:    psrad $16, %xmm2
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; SSSE3-NEXT:    psrad $16, %xmm3
; SSSE3-NEXT:    movdqa %xmm4, %xmm0
; SSSE3-NEXT:    movdqa %xmm5, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_16i16_to_16i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm5
; SSE41-NEXT:    pmovsxwd %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    movdqa %xmm4, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_16i16_to_16i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwd %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_16i16_to_16i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxwd %xmm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpmovsxwd %xmm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_16i16_to_16i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_16i16_to_16i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $16, %xmm4
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm0[4],xmm5[5],xmm0[5],xmm5[6],xmm0[6],xmm5[7],xmm0[7]
; X86-SSE2-NEXT:    psrad $16, %xmm5
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $16, %xmm2
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; X86-SSE2-NEXT:    psrad $16, %xmm3
; X86-SSE2-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm5, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_16i16_to_16i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxwd %xmm0, %xmm5
; X86-SSE41-NEXT:    pmovsxwd %xmm1, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxwd %xmm0, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxwd %xmm0, %xmm3
; X86-SSE41-NEXT:    movdqa %xmm5, %xmm0
; X86-SSE41-NEXT:    movdqa %xmm4, %xmm1
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <16 x i16> %A to <16 x i32>
  ret <16 x i32> %B
}

define <2 x i64> @sext_8i16_to_2i64(<8 x i16> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i16_to_2i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i16_to_2i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i16_to_2i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwq %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_8i16_to_2i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i16_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i16_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxwq %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <8 x i16> %A, <8 x i16> undef, <2 x i32> <i32 0, i32 1>
  %C = sext <2 x i16> %B to <2 x i64>
  ret <2 x i64> %C
}

define <4 x i64> @sext_8i16_to_4i64(<8 x i16> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i16_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i16_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i16_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwq %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxwq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_8i16_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_8i16_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_8i16_to_4i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i16_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i16_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxwq %xmm0, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X86-SSE41-NEXT:    pmovsxwq %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <8 x i16> %A, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %C = sext <4 x i16> %B to <4 x i64>
  ret <4 x i64> %C
}

define <8 x i64> @sext_8i16_to_8i64(<8 x i16> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i16_to_8i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i16_to_8i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSSE3-NEXT:    psrad $16, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSSE3-NEXT:    movdqa %xmm4, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i16_to_8i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwq %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxwq %xmm1, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxwq %xmm2, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE41-NEXT:    pmovsxwq %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_8i16_to_8i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_8i16_to_8i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_8i16_to_8i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i16_to_8i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    pxor %xmm5, %xmm5
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm4
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; X86-SSE2-NEXT:    psrad $16, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; X86-SSE2-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i16_to_8i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxwq %xmm0, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-SSE41-NEXT:    pmovsxwq %xmm1, %xmm1
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxwq %xmm2, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X86-SSE41-NEXT:    pmovsxwq %xmm0, %xmm3
; X86-SSE41-NEXT:    movdqa %xmm4, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <8 x i16> %A to <8 x i64>
  ret <8 x i64> %B
}

define <2 x i64> @sext_4i32_to_2i64(<4 x i32> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_4i32_to_2i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_4i32_to_2i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_4i32_to_2i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_4i32_to_2i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_4i32_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_4i32_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = shufflevector <4 x i32> %A, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %C = sext <2 x i32> %B to <2 x i64>
  ret <2 x i64> %C
}

define <4 x i64> @sext_4i32_to_4i64(<4 x i32> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_4i32_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_4i32_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_4i32_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_4i32_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_4i32_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_4i32_to_4i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_4i32_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_4i32_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <4 x i32> %A to <4 x i64>
  ret <4 x i64> %B
}

define <8 x i64> @sext_8i32_to_8i64(<8 x i32> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i32_to_8i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i32_to_8i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm3
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i32_to_8i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm5
; SSE41-NEXT:    pmovsxdq %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    movdqa %xmm4, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_8i32_to_8i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_8i32_to_8i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm1
; AVX2-NEXT:    vmovdqa %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_8i32_to_8i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxdq %ymm0, %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i32_to_8i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X86-SSE2-NEXT:    pxor %xmm4, %xmm4
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; X86-SSE2-NEXT:    pxor %xmm5, %xmm5
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm5
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; X86-SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i32_to_8i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm5
; X86-SSE41-NEXT:    pmovsxdq %xmm1, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm3
; X86-SSE41-NEXT:    movdqa %xmm5, %xmm0
; X86-SSE41-NEXT:    movdqa %xmm4, %xmm1
; X86-SSE41-NEXT:    retl
entry:
  %B = sext <8 x i32> %A to <8 x i64>
  ret <8 x i64> %B
}

define <2 x i64> @load_sext_2i1_to_2i64(ptr%ptr) {
; SSE-LABEL: load_sext_2i1_to_2i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movzbl (%rdi), %eax
; SSE-NEXT:    movzbl %al, %ecx
; SSE-NEXT:    shrb %al
; SSE-NEXT:    movzbl %al, %eax
; SSE-NEXT:    negq %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    andl $1, %ecx
; SSE-NEXT:    negq %rcx
; SSE-NEXT:    movq %rcx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_sext_2i1_to_2i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    movzbl %al, %ecx
; AVX1-NEXT:    shrb %al
; AVX1-NEXT:    movzbl %al, %eax
; AVX1-NEXT:    negq %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    andl $1, %ecx
; AVX1-NEXT:    negq %rcx
; AVX1-NEXT:    vmovq %rcx, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_2i1_to_2i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    movzbl (%rdi), %eax
; AVX2-NEXT:    movzbl %al, %ecx
; AVX2-NEXT:    shrb %al
; AVX2-NEXT:    movzbl %al, %eax
; AVX2-NEXT:    negq %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    andl $1, %ecx
; AVX2-NEXT:    negq %rcx
; AVX2-NEXT:    vmovq %rcx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_2i1_to_2i64:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movzbl (%rdi), %eax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_2i1_to_2i64:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    movzbl (%rdi), %eax
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_2i1_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl (%eax), %eax
; X86-SSE2-NEXT:    movzbl %al, %ecx
; X86-SSE2-NEXT:    shrb %al
; X86-SSE2-NEXT:    movzbl %al, %eax
; X86-SSE2-NEXT:    negl %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; X86-SSE2-NEXT:    andl $1, %ecx
; X86-SSE2-NEXT:    negl %ecx
; X86-SSE2-NEXT:    movd %ecx, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; X86-SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_2i1_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzbl (%eax), %eax
; X86-SSE41-NEXT:    movzbl %al, %ecx
; X86-SSE41-NEXT:    andl $1, %ecx
; X86-SSE41-NEXT:    negl %ecx
; X86-SSE41-NEXT:    movd %ecx, %xmm0
; X86-SSE41-NEXT:    pinsrd $1, %ecx, %xmm0
; X86-SSE41-NEXT:    shrb %al
; X86-SSE41-NEXT:    movzbl %al, %eax
; X86-SSE41-NEXT:    negl %eax
; X86-SSE41-NEXT:    pinsrd $2, %eax, %xmm0
; X86-SSE41-NEXT:    pinsrd $3, %eax, %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <2 x i1>, ptr %ptr
 %Y = sext <2 x i1> %X to <2 x i64>
 ret <2 x i64> %Y
}

define <2 x i64> @load_sext_2i8_to_2i64(ptr%ptr) {
; SSE2-LABEL: load_sext_2i8_to_2i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_2i8_to_2i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_2i8_to_2i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbq (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_sext_2i8_to_2i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbq (%rdi), %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_2i8_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzwl (%eax), %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_2i8_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbq (%eax), %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <2 x i8>, ptr %ptr
 %Y = sext <2 x i8> %X to <2 x i64>
 ret <2 x i64> %Y
}

define <4 x i32> @load_sext_4i1_to_4i32(ptr%ptr) {
; SSE2-LABEL: load_sext_4i1_to_4i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shrb $3, %cl
; SSE2-NEXT:    movzbl %cl, %ecx
; SSE2-NEXT:    negl %ecx
; SSE2-NEXT:    movd %ecx, %xmm0
; SSE2-NEXT:    movzbl %al, %ecx
; SSE2-NEXT:    shrb $2, %al
; SSE2-NEXT:    movzbl %al, %eax
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    negl %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movl %ecx, %eax
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    negl %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    shrb %cl
; SSE2-NEXT:    movzbl %cl, %eax
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    negl %eax
; SSE2-NEXT:    movd %eax, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i1_to_4i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzbl (%rdi), %eax
; SSSE3-NEXT:    movl %eax, %ecx
; SSSE3-NEXT:    shrb $3, %cl
; SSSE3-NEXT:    movzbl %cl, %ecx
; SSSE3-NEXT:    negl %ecx
; SSSE3-NEXT:    movd %ecx, %xmm0
; SSSE3-NEXT:    movzbl %al, %ecx
; SSSE3-NEXT:    shrb $2, %al
; SSSE3-NEXT:    movzbl %al, %eax
; SSSE3-NEXT:    andl $1, %eax
; SSSE3-NEXT:    negl %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSSE3-NEXT:    movl %ecx, %eax
; SSSE3-NEXT:    andl $1, %eax
; SSSE3-NEXT:    negl %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    shrb %cl
; SSSE3-NEXT:    movzbl %cl, %eax
; SSSE3-NEXT:    andl $1, %eax
; SSSE3-NEXT:    negl %eax
; SSSE3-NEXT:    movd %eax, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i1_to_4i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movzbl (%rdi), %eax
; SSE41-NEXT:    movzbl %al, %ecx
; SSE41-NEXT:    shrb %al
; SSE41-NEXT:    movzbl %al, %eax
; SSE41-NEXT:    andl $1, %eax
; SSE41-NEXT:    negl %eax
; SSE41-NEXT:    movl %ecx, %edx
; SSE41-NEXT:    andl $1, %edx
; SSE41-NEXT:    negl %edx
; SSE41-NEXT:    movd %edx, %xmm0
; SSE41-NEXT:    pinsrd $1, %eax, %xmm0
; SSE41-NEXT:    movl %ecx, %eax
; SSE41-NEXT:    shrb $2, %al
; SSE41-NEXT:    movzbl %al, %eax
; SSE41-NEXT:    andl $1, %eax
; SSE41-NEXT:    negl %eax
; SSE41-NEXT:    pinsrd $2, %eax, %xmm0
; SSE41-NEXT:    shrb $3, %cl
; SSE41-NEXT:    movzbl %cl, %eax
; SSE41-NEXT:    negl %eax
; SSE41-NEXT:    pinsrd $3, %eax, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_4i1_to_4i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    movzbl %al, %ecx
; AVX1-NEXT:    shrb %al
; AVX1-NEXT:    movzbl %al, %eax
; AVX1-NEXT:    andl $1, %eax
; AVX1-NEXT:    negl %eax
; AVX1-NEXT:    movl %ecx, %edx
; AVX1-NEXT:    andl $1, %edx
; AVX1-NEXT:    negl %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; AVX1-NEXT:    movl %ecx, %eax
; AVX1-NEXT:    shrb $2, %al
; AVX1-NEXT:    movzbl %al, %eax
; AVX1-NEXT:    andl $1, %eax
; AVX1-NEXT:    negl %eax
; AVX1-NEXT:    vpinsrd $2, %eax, %xmm0, %xmm0
; AVX1-NEXT:    shrb $3, %cl
; AVX1-NEXT:    movzbl %cl, %eax
; AVX1-NEXT:    negl %eax
; AVX1-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_4i1_to_4i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    movzbl (%rdi), %eax
; AVX2-NEXT:    movzbl %al, %ecx
; AVX2-NEXT:    shrb %al
; AVX2-NEXT:    movzbl %al, %eax
; AVX2-NEXT:    andl $1, %eax
; AVX2-NEXT:    negl %eax
; AVX2-NEXT:    movl %ecx, %edx
; AVX2-NEXT:    andl $1, %edx
; AVX2-NEXT:    negl %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; AVX2-NEXT:    movl %ecx, %eax
; AVX2-NEXT:    shrb $2, %al
; AVX2-NEXT:    movzbl %al, %eax
; AVX2-NEXT:    andl $1, %eax
; AVX2-NEXT:    negl %eax
; AVX2-NEXT:    vpinsrd $2, %eax, %xmm0, %xmm0
; AVX2-NEXT:    shrb $3, %cl
; AVX2-NEXT:    movzbl %cl, %eax
; AVX2-NEXT:    negl %eax
; AVX2-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_4i1_to_4i32:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movzbl (%rdi), %eax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_4i1_to_4i32:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    movzbl (%rdi), %eax
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i1_to_4i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl (%eax), %eax
; X86-SSE2-NEXT:    movl %eax, %ecx
; X86-SSE2-NEXT:    shrb $3, %cl
; X86-SSE2-NEXT:    movzbl %cl, %ecx
; X86-SSE2-NEXT:    negl %ecx
; X86-SSE2-NEXT:    movd %ecx, %xmm0
; X86-SSE2-NEXT:    movl %eax, %ecx
; X86-SSE2-NEXT:    shrb $2, %cl
; X86-SSE2-NEXT:    movzbl %cl, %ecx
; X86-SSE2-NEXT:    andl $1, %ecx
; X86-SSE2-NEXT:    negl %ecx
; X86-SSE2-NEXT:    movd %ecx, %xmm1
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-SSE2-NEXT:    movzbl %al, %ecx
; X86-SSE2-NEXT:    andl $1, %ecx
; X86-SSE2-NEXT:    negl %ecx
; X86-SSE2-NEXT:    movd %ecx, %xmm0
; X86-SSE2-NEXT:    shrb %al
; X86-SSE2-NEXT:    movzbl %al, %eax
; X86-SSE2-NEXT:    andl $1, %eax
; X86-SSE2-NEXT:    negl %eax
; X86-SSE2-NEXT:    movd %eax, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i1_to_4i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzbl (%eax), %eax
; X86-SSE41-NEXT:    movl %eax, %ecx
; X86-SSE41-NEXT:    shrb %cl
; X86-SSE41-NEXT:    movzbl %cl, %ecx
; X86-SSE41-NEXT:    andl $1, %ecx
; X86-SSE41-NEXT:    negl %ecx
; X86-SSE41-NEXT:    movzbl %al, %edx
; X86-SSE41-NEXT:    andl $1, %edx
; X86-SSE41-NEXT:    negl %edx
; X86-SSE41-NEXT:    movd %edx, %xmm0
; X86-SSE41-NEXT:    pinsrd $1, %ecx, %xmm0
; X86-SSE41-NEXT:    movl %eax, %ecx
; X86-SSE41-NEXT:    shrb $2, %cl
; X86-SSE41-NEXT:    movzbl %cl, %ecx
; X86-SSE41-NEXT:    andl $1, %ecx
; X86-SSE41-NEXT:    negl %ecx
; X86-SSE41-NEXT:    pinsrd $2, %ecx, %xmm0
; X86-SSE41-NEXT:    shrb $3, %al
; X86-SSE41-NEXT:    movzbl %al, %eax
; X86-SSE41-NEXT:    negl %eax
; X86-SSE41-NEXT:    pinsrd $3, %eax, %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i1>, ptr %ptr
 %Y = sext <4 x i1> %X to <4 x i32>
 ret <4 x i32> %Y
}

define <4 x i32> @load_sext_4i8_to_4i32(ptr%ptr) {
; SSE2-LABEL: load_sext_4i8_to_4i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i8_to_4i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i8_to_4i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbd (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_sext_4i8_to_4i32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbd (%rdi), %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i8_to_4i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i8_to_4i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbd (%eax), %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i8>, ptr %ptr
 %Y = sext <4 x i8> %X to <4 x i32>
 ret <4 x i32> %Y
}

define <4 x i64> @load_sext_4i1_to_4i64(ptr%ptr) {
; SSE2-LABEL: load_sext_4i1_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shrb %cl
; SSE2-NEXT:    andb $1, %cl
; SSE2-NEXT:    movzbl %cl, %ecx
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    andb $1, %dl
; SSE2-NEXT:    movzbl %dl, %edx
; SSE2-NEXT:    movd %edx, %xmm1
; SSE2-NEXT:    pinsrw $2, %ecx, %xmm1
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shrb $2, %cl
; SSE2-NEXT:    andb $1, %cl
; SSE2-NEXT:    movzbl %cl, %ecx
; SSE2-NEXT:    pinsrw $4, %ecx, %xmm1
; SSE2-NEXT:    shrb $3, %al
; SSE2-NEXT:    movzbl %al, %eax
; SSE2-NEXT:    pinsrw $6, %eax, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,1,1]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i1_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzbl (%rdi), %eax
; SSSE3-NEXT:    movl %eax, %ecx
; SSSE3-NEXT:    shrb %cl
; SSSE3-NEXT:    andb $1, %cl
; SSSE3-NEXT:    movzbl %cl, %ecx
; SSSE3-NEXT:    movl %eax, %edx
; SSSE3-NEXT:    andb $1, %dl
; SSSE3-NEXT:    movzbl %dl, %edx
; SSSE3-NEXT:    movd %edx, %xmm1
; SSSE3-NEXT:    pinsrw $2, %ecx, %xmm1
; SSSE3-NEXT:    movl %eax, %ecx
; SSSE3-NEXT:    shrb $2, %cl
; SSSE3-NEXT:    andb $1, %cl
; SSSE3-NEXT:    movzbl %cl, %ecx
; SSSE3-NEXT:    pinsrw $4, %ecx, %xmm1
; SSSE3-NEXT:    shrb $3, %al
; SSSE3-NEXT:    movzbl %al, %eax
; SSSE3-NEXT:    pinsrw $6, %eax, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,1,1]
; SSSE3-NEXT:    pslld $31, %xmm0
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSSE3-NEXT:    pslld $31, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i1_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movzbl (%rdi), %eax
; SSE41-NEXT:    movl %eax, %ecx
; SSE41-NEXT:    shrb %cl
; SSE41-NEXT:    andb $1, %cl
; SSE41-NEXT:    movzbl %cl, %ecx
; SSE41-NEXT:    movl %eax, %edx
; SSE41-NEXT:    andb $1, %dl
; SSE41-NEXT:    movzbl %dl, %edx
; SSE41-NEXT:    movd %edx, %xmm1
; SSE41-NEXT:    pinsrb $4, %ecx, %xmm1
; SSE41-NEXT:    movl %eax, %ecx
; SSE41-NEXT:    shrb $2, %cl
; SSE41-NEXT:    andb $1, %cl
; SSE41-NEXT:    movzbl %cl, %ecx
; SSE41-NEXT:    pinsrb $8, %ecx, %xmm1
; SSE41-NEXT:    shrb $3, %al
; SSE41-NEXT:    movzbl %al, %eax
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,1,1]
; SSE41-NEXT:    pinsrb $12, %eax, %xmm1
; SSE41-NEXT:    pslld $31, %xmm0
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; SSE41-NEXT:    pslld $31, %xmm1
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_4i1_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    movzbl %al, %ecx
; AVX1-NEXT:    shrb %al
; AVX1-NEXT:    movzbl %al, %eax
; AVX1-NEXT:    andl $1, %eax
; AVX1-NEXT:    negl %eax
; AVX1-NEXT:    movl %ecx, %edx
; AVX1-NEXT:    andl $1, %edx
; AVX1-NEXT:    negl %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; AVX1-NEXT:    movl %ecx, %eax
; AVX1-NEXT:    shrb $2, %al
; AVX1-NEXT:    movzbl %al, %eax
; AVX1-NEXT:    andl $1, %eax
; AVX1-NEXT:    negl %eax
; AVX1-NEXT:    vpinsrd $2, %eax, %xmm0, %xmm0
; AVX1-NEXT:    shrb $3, %cl
; AVX1-NEXT:    movzbl %cl, %eax
; AVX1-NEXT:    negl %eax
; AVX1-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_4i1_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    movzbl (%rdi), %eax
; AVX2-NEXT:    movl %eax, %ecx
; AVX2-NEXT:    shrb $3, %cl
; AVX2-NEXT:    movzbl %cl, %ecx
; AVX2-NEXT:    negq %rcx
; AVX2-NEXT:    vmovq %rcx, %xmm0
; AVX2-NEXT:    movzbl %al, %ecx
; AVX2-NEXT:    shrb $2, %al
; AVX2-NEXT:    movzbl %al, %eax
; AVX2-NEXT:    andl $1, %eax
; AVX2-NEXT:    negq %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    movl %ecx, %eax
; AVX2-NEXT:    andl $1, %eax
; AVX2-NEXT:    negq %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    shrb %cl
; AVX2-NEXT:    movzbl %cl, %eax
; AVX2-NEXT:    andl $1, %eax
; AVX2-NEXT:    negq %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_4i1_to_4i64:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movzbl (%rdi), %eax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_4i1_to_4i64:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    movzbl (%rdi), %eax
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpternlogq $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i1_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl (%eax), %eax
; X86-SSE2-NEXT:    movl %eax, %ecx
; X86-SSE2-NEXT:    shrb %cl
; X86-SSE2-NEXT:    andb $1, %cl
; X86-SSE2-NEXT:    movzbl %cl, %ecx
; X86-SSE2-NEXT:    movl %eax, %edx
; X86-SSE2-NEXT:    andb $1, %dl
; X86-SSE2-NEXT:    movzbl %dl, %edx
; X86-SSE2-NEXT:    movd %edx, %xmm1
; X86-SSE2-NEXT:    pinsrw $2, %ecx, %xmm1
; X86-SSE2-NEXT:    movl %eax, %ecx
; X86-SSE2-NEXT:    shrb $2, %cl
; X86-SSE2-NEXT:    andb $1, %cl
; X86-SSE2-NEXT:    movzbl %cl, %ecx
; X86-SSE2-NEXT:    pinsrw $4, %ecx, %xmm1
; X86-SSE2-NEXT:    shrb $3, %al
; X86-SSE2-NEXT:    movzbl %al, %eax
; X86-SSE2-NEXT:    pinsrw $6, %eax, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,1,1]
; X86-SSE2-NEXT:    pslld $31, %xmm0
; X86-SSE2-NEXT:    psrad $31, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; X86-SSE2-NEXT:    pslld $31, %xmm1
; X86-SSE2-NEXT:    psrad $31, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i1_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzbl (%eax), %eax
; X86-SSE41-NEXT:    movl %eax, %ecx
; X86-SSE41-NEXT:    shrb %cl
; X86-SSE41-NEXT:    andb $1, %cl
; X86-SSE41-NEXT:    movzbl %cl, %ecx
; X86-SSE41-NEXT:    movl %eax, %edx
; X86-SSE41-NEXT:    andb $1, %dl
; X86-SSE41-NEXT:    movzbl %dl, %edx
; X86-SSE41-NEXT:    movd %edx, %xmm1
; X86-SSE41-NEXT:    pinsrb $4, %ecx, %xmm1
; X86-SSE41-NEXT:    movl %eax, %ecx
; X86-SSE41-NEXT:    shrb $2, %cl
; X86-SSE41-NEXT:    andb $1, %cl
; X86-SSE41-NEXT:    movzbl %cl, %ecx
; X86-SSE41-NEXT:    pinsrb $8, %ecx, %xmm1
; X86-SSE41-NEXT:    shrb $3, %al
; X86-SSE41-NEXT:    movzbl %al, %eax
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,0,1,1]
; X86-SSE41-NEXT:    pinsrb $12, %eax, %xmm1
; X86-SSE41-NEXT:    pslld $31, %xmm0
; X86-SSE41-NEXT:    psrad $31, %xmm0
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; X86-SSE41-NEXT:    pslld $31, %xmm1
; X86-SSE41-NEXT:    psrad $31, %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i1>, ptr %ptr
 %Y = sext <4 x i1> %X to <4 x i64>
 ret <4 x i64> %Y
}

define <4 x i64> @load_sext_4i8_to_4i64(ptr%ptr) {
; SSE2-LABEL: load_sext_4i8_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i8_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i8_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbq (%rdi), %xmm0
; SSE41-NEXT:    pmovsxbq 2(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_4i8_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbq 2(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxbq (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_4i8_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbq (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_4i8_to_4i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbq (%rdi), %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i8_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i8_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbq (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxbq 2(%eax), %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i8>, ptr %ptr
 %Y = sext <4 x i8> %X to <4 x i64>
 ret <4 x i64> %Y
}

define <2 x i64> @load_sext_4i8_to_4i64_extract(ptr%ptr) {
; SSE2-LABEL: load_sext_4i8_to_4i64_extract:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i8_to_4i64_extract:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i8_to_4i64_extract:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbq 2(%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_4i8_to_4i64_extract:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbq 2(%rdi), %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_4i8_to_4i64_extract:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbq (%rdi), %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_4i8_to_4i64_extract:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq (%rdi), %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i8_to_4i64_extract:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i8_to_4i64_extract:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbq 2(%eax), %xmm0
; X86-SSE41-NEXT:    retl
 %ld = load <4 x i8>, ptr %ptr
 %sext = sext <4 x i8> %ld to <4 x i64>
 %extract = shufflevector <4 x i64> %sext, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
 ret <2 x i64> %extract
}

define <8 x i16> @load_sext_8i1_to_8i16(ptr%ptr) {
; SSE2-LABEL: load_sext_8i1_to_8i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_8i1_to_8i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzbl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pcmpeqw %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_8i1_to_8i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movzbl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_8i1_to_8i16:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_8i1_to_8i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpbroadcastb (%rdi), %xmm0
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_8i1_to_8i16:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movzbl (%rdi), %eax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_8i1_to_8i16:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    movzbl (%rdi), %eax
; AVX512BW-NEXT:    kmovd %eax, %k0
; AVX512BW-NEXT:    vpmovm2w %k0, %zmm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_8i1_to_8i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl (%eax), %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    pcmpeqw %xmm1, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_8i1_to_8i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzbl (%eax), %eax
; X86-SSE41-NEXT:    movd %eax, %xmm0
; X86-SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; X86-SSE41-NEXT:    pmovzxbw {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128]
; X86-SSE41-NEXT:    pand %xmm1, %xmm0
; X86-SSE41-NEXT:    pcmpeqw %xmm1, %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <8 x i1>, ptr %ptr
 %Y = sext <8 x i1> %X to <8 x i16>
 ret <8 x i16> %Y
}

define <8 x i16> @load_sext_8i8_to_8i16(ptr%ptr) {
; SSE2-LABEL: load_sext_8i8_to_8i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psraw $8, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_8i8_to_8i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psraw $8, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_8i8_to_8i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbw (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_sext_8i8_to_8i16:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbw (%rdi), %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_8i8_to_8i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psraw $8, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_8i8_to_8i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbw (%eax), %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <8 x i8>, ptr %ptr
 %Y = sext <8 x i8> %X to <8 x i16>
 ret <8 x i16> %Y
}

define <8 x i64> @load_sext_8i8_to_8i64(ptr%ptr) {
; SSE2-LABEL: load_sext_8i8_to_8i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSE2-NEXT:    psrad $24, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_8i8_to_8i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm3
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; SSSE3-NEXT:    psrad $24, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm4
; SSSE3-NEXT:    movdqa %xmm3, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_8i8_to_8i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbq (%rdi), %xmm0
; SSE41-NEXT:    pmovsxbq 2(%rdi), %xmm1
; SSE41-NEXT:    pmovsxbq 4(%rdi), %xmm2
; SSE41-NEXT:    pmovsxbq 6(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_8i8_to_8i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbq 6(%rdi), %xmm1
; AVX1-NEXT:    vpmovsxbq 4(%rdi), %xmm2
; AVX1-NEXT:    vpmovsxbq 2(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxbq (%rdi), %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_8i8_to_8i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbq (%rdi), %ymm0
; AVX2-NEXT:    vpmovsxbq 4(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_8i8_to_8i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbq (%rdi), %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_8i8_to_8i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    pxor %xmm4, %xmm4
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm3
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; X86-SSE2-NEXT:    psrad $24, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_8i8_to_8i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbq (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxbq 2(%eax), %xmm1
; X86-SSE41-NEXT:    pmovsxbq 4(%eax), %xmm2
; X86-SSE41-NEXT:    pmovsxbq 6(%eax), %xmm3
; X86-SSE41-NEXT:    retl
entry:
 %X = load <8 x i8>, ptr %ptr
 %Y = sext <8 x i8> %X to <8 x i64>
 ret <8 x i64> %Y
}

define <8 x i32> @load_sext_8i1_to_8i32(ptr%ptr) {
; SSE2-LABEL: load_sext_8i1_to_8i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [16,32,64,128]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_8i1_to_8i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzbl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8]
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [16,32,64,128]
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_8i1_to_8i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movzbl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSE41-NEXT:    pmovsxbd {{.*#+}} xmm2 = [1,2,4,8]
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm2 = [16,32,64,128]
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_8i1_to_8i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzbl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vcmpeqps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_8i1_to_8i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpbroadcastb (%rdi), %ymm0
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_8i1_to_8i32:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movzbl (%rdi), %eax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_8i1_to_8i32:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    movzbl (%rdi), %eax
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_8i1_to_8i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzbl (%eax), %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [16,32,64,128]
; X86-SSE2-NEXT:    pand %xmm2, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_8i1_to_8i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzbl (%eax), %eax
; X86-SSE41-NEXT:    movd %eax, %xmm0
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; X86-SSE41-NEXT:    pmovsxbd {{.*#+}} xmm2 = [1,2,4,8]
; X86-SSE41-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE41-NEXT:    pand %xmm2, %xmm0
; X86-SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; X86-SSE41-NEXT:    pmovzxbd {{.*#+}} xmm2 = [16,32,64,128]
; X86-SSE41-NEXT:    pand %xmm2, %xmm1
; X86-SSE41-NEXT:    pcmpeqd %xmm2, %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <8 x i1>, ptr %ptr
 %Y = sext <8 x i1> %X to <8 x i32>
 ret <8 x i32> %Y
}

define <8 x i32> @load_sext_8i8_to_8i32(ptr%ptr) {
; SSE2-LABEL: load_sext_8i8_to_8i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_8i8_to_8i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_8i8_to_8i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbd (%rdi), %xmm0
; SSE41-NEXT:    pmovsxbd 4(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_8i8_to_8i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbd 4(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxbd (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_8i8_to_8i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbd (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_8i8_to_8i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbd (%rdi), %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_8i8_to_8i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_8i8_to_8i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbd (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxbd 4(%eax), %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <8 x i8>, ptr %ptr
 %Y = sext <8 x i8> %X to <8 x i32>
 ret <8 x i32> %Y
}

define <16 x i8> @load_sext_16i1_to_16i8(ptr%ptr) nounwind readnone {
; SSE2-LABEL: load_sext_16i1_to_16i8:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,1,1,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_16i1_to_16i8:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    pcmpeqb %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_16i1_to_16i8:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_16i1_to_16i8:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_16i1_to_16i8:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    movzwl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_16i1_to_16i8:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    kmovw (%rdi), %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_16i1_to_16i8:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    kmovw (%rdi), %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_16i1_to_16i8:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzwl (%eax), %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,1,1,4,5,6,7]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_16i1_to_16i8:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzwl (%eax), %eax
; X86-SSE41-NEXT:    movd %eax, %xmm0
; X86-SSE41-NEXT:    pshufb {{.*#+}} xmm0 = xmm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1]
; X86-SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; X86-SSE41-NEXT:    pand %xmm1, %xmm0
; X86-SSE41-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <16 x i1>, ptr %ptr
 %Y = sext <16 x i1> %X to <16 x i8>
 ret <16 x i8> %Y
}

define <16 x i16> @load_sext_16i1_to_16i16(ptr%ptr) {
; SSE2-LABEL: load_sext_16i1_to_16i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [256,512,1024,2048,4096,8192,16384,32768]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_16i1_to_16i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128]
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [256,512,1024,2048,4096,8192,16384,32768]
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_16i1_to_16i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128]
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [256,512,1024,2048,4096,8192,16384,32768]
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_16i1_to_16i16:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_16i1_to_16i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpbroadcastw (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_16i1_to_16i16:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    kmovw (%rdi), %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_16i1_to_16i16:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    kmovw (%rdi), %k0
; AVX512BW-NEXT:    vpmovm2w %k0, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_16i1_to_16i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzwl (%eax), %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqw %xmm2, %xmm0
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [256,512,1024,2048,4096,8192,16384,32768]
; X86-SSE2-NEXT:    pand %xmm2, %xmm1
; X86-SSE2-NEXT:    pcmpeqw %xmm2, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_16i1_to_16i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzwl (%eax), %eax
; X86-SSE41-NEXT:    movd %eax, %xmm0
; X86-SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,0,0]
; X86-SSE41-NEXT:    pmovzxbw {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128]
; X86-SSE41-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE41-NEXT:    pand %xmm2, %xmm0
; X86-SSE41-NEXT:    pcmpeqw %xmm2, %xmm0
; X86-SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [256,512,1024,2048,4096,8192,16384,32768]
; X86-SSE41-NEXT:    pand %xmm2, %xmm1
; X86-SSE41-NEXT:    pcmpeqw %xmm2, %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <16 x i1>, ptr %ptr
 %Y = sext <16 x i1> %X to <16 x i16>
 ret <16 x i16> %Y
}

define <32 x i8> @load_sext_32i1_to_32i8(ptr%ptr) nounwind readnone {
; SSE-LABEL: load_sext_32i1_to_32i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,0,1,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,3,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_sext_32i1_to_32i8:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,0,1,1,4,5,6,7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[2,2,3,3,4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,0,1,1,4,4,5,5]
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovddup {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; AVX1-NEXT:    # xmm2 = mem[0,0]
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_32i1_to_32i8:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_sext_32i1_to_32i8:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    kmovw (%rdi), %k1
; AVX512F-NEXT:    kmovw 2(%rdi), %k2
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k2} {z}
; AVX512F-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_sext_32i1_to_32i8:
; AVX512BW:       # %bb.0: # %entry
; AVX512BW-NEXT:    kmovd (%rdi), %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; X86-SSE-LABEL: load_sext_32i1_to_32i8:
; X86-SSE:       # %bb.0: # %entry
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,0,1,1,4,5,6,7]
; X86-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,1,1]
; X86-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; X86-SSE-NEXT:    pand %xmm2, %xmm0
; X86-SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; X86-SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,2,3,3,4,5,6,7]
; X86-SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; X86-SSE-NEXT:    pand %xmm2, %xmm1
; X86-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X86-SSE-NEXT:    retl
entry:
 %X = load <32 x i1>, ptr %ptr
 %Y = sext <32 x i1> %X to <32 x i8>
 ret <32 x i8> %Y
}

define <16 x i16> @load_sext_16i8_to_16i16(ptr%ptr) {
; SSE2-LABEL: load_sext_16i8_to_16i16:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    psraw $8, %xmm0
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    psraw $8, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_16i8_to_16i16:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa (%rdi), %xmm1
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSSE3-NEXT:    psraw $8, %xmm0
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSSE3-NEXT:    psraw $8, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_16i8_to_16i16:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbw (%rdi), %xmm0
; SSE41-NEXT:    pmovsxbw 8(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_16i8_to_16i16:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxbw 8(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxbw (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_16i8_to_16i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxbw (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_16i8_to_16i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxbw (%rdi), %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_16i8_to_16i16:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movdqa (%eax), %xmm1
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X86-SSE2-NEXT:    psraw $8, %xmm0
; X86-SSE2-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; X86-SSE2-NEXT:    psraw $8, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_16i8_to_16i16:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxbw (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxbw 8(%eax), %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <16 x i8>, ptr %ptr
 %Y = sext <16 x i8> %X to <16 x i16>
 ret <16 x i16> %Y
}

define <2 x i64> @load_sext_2i16_to_2i64(ptr%ptr) {
; SSE2-LABEL: load_sext_2i16_to_2i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_2i16_to_2i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_2i16_to_2i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwq (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_sext_2i16_to_2i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxwq (%rdi), %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_2i16_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_2i16_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxwq (%eax), %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <2 x i16>, ptr %ptr
 %Y = sext <2 x i16> %X to <2 x i64>
 ret <2 x i64> %Y
}

define <4 x i32> @load_sext_4i16_to_4i32(ptr%ptr) {
; SSE2-LABEL: load_sext_4i16_to_4i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i16_to_4i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i16_to_4i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwd (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_sext_4i16_to_4i32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxwd (%rdi), %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i16_to_4i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i16_to_4i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxwd (%eax), %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i16>, ptr %ptr
 %Y = sext <4 x i16> %X to <4 x i32>
 ret <4 x i32> %Y
}

define <4 x i64> @load_sext_4i16_to_4i64(ptr%ptr) {
; SSE2-LABEL: load_sext_4i16_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i16_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i16_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwq (%rdi), %xmm0
; SSE41-NEXT:    pmovsxwq 4(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_4i16_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxwq 4(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxwq (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_4i16_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxwq (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_4i16_to_4i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxwq (%rdi), %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i16_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i16_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxwq (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxwq 4(%eax), %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i16>, ptr %ptr
 %Y = sext <4 x i16> %X to <4 x i64>
 ret <4 x i64> %Y
}

define <8 x i32> @load_sext_8i16_to_8i32(ptr%ptr) {
; SSE2-LABEL: load_sext_8i16_to_8i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_8i16_to_8i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa (%rdi), %xmm1
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_8i16_to_8i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxwd (%rdi), %xmm0
; SSE41-NEXT:    pmovsxwd 8(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_8i16_to_8i32:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxwd 8(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxwd (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_8i16_to_8i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxwd (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_8i16_to_8i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxwd (%rdi), %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_8i16_to_8i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movdqa (%eax), %xmm1
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_8i16_to_8i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxwd (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxwd 8(%eax), %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <8 x i16>, ptr %ptr
 %Y = sext <8 x i16> %X to <8 x i32>
 ret <8 x i32> %Y
}

define <2 x i64> @load_sext_2i32_to_2i64(ptr%ptr) {
; SSE2-LABEL: load_sext_2i32_to_2i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_2i32_to_2i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_2i32_to_2i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxdq (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: load_sext_2i32_to_2i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxdq (%rdi), %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_2i32_to_2i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_2i32_to_2i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxdq (%eax), %xmm0
; X86-SSE41-NEXT:    retl
entry:
 %X = load <2 x i32>, ptr %ptr
 %Y = sext <2 x i32> %X to <2 x i64>
 ret <2 x i64> %Y
}

define <4 x i64> @load_sext_4i32_to_4i64(ptr%ptr) {
; SSE2-LABEL: load_sext_4i32_to_4i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: load_sext_4i32_to_4i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movdqa (%rdi), %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm0, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: load_sext_4i32_to_4i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxdq (%rdi), %xmm0
; SSE41-NEXT:    pmovsxdq 8(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: load_sext_4i32_to_4i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpmovsxdq 8(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxdq (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_sext_4i32_to_4i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpmovsxdq (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_sext_4i32_to_4i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpmovsxdq (%rdi), %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: load_sext_4i32_to_4i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movdqa (%eax), %xmm0
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: load_sext_4i32_to_4i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    pmovsxdq (%eax), %xmm0
; X86-SSE41-NEXT:    pmovsxdq 8(%eax), %xmm1
; X86-SSE41-NEXT:    retl
entry:
 %X = load <4 x i32>, ptr %ptr
 %Y = sext <4 x i32> %X to <4 x i64>
 ret <4 x i64> %Y
}

define i32 @sext_2i8_to_i32(<16 x i8> %A) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_2i8_to_i32:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psraw $8, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_2i8_to_i32:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psraw $8, %xmm0
; SSSE3-NEXT:    movd %xmm0, %eax
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_2i8_to_i32:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    pmovsxbw %xmm0, %xmm0
; SSE41-NEXT:    movd %xmm0, %eax
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_2i8_to_i32:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, %eax
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_2i8_to_i32:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psraw $8, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_2i8_to_i32:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    pmovsxbw %xmm0, %xmm0
; X86-SSE41-NEXT:    movd %xmm0, %eax
; X86-SSE41-NEXT:    retl
entry:
  %Shuf = shufflevector <16 x i8> %A, <16 x i8> undef, <2 x i32> <i32 0, i32 1>
  %Ex = sext <2 x i8> %Shuf to <2 x i16>
  %Bc = bitcast <2 x i16> %Ex to i32
  ret i32 %Bc
}

define <4 x i64> @sext_4i1_to_4i64(<4 x i1> %mask) {
; SSE2-LABEL: sext_4i1_to_4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,1,1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_4i1_to_4i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pslld $31, %xmm0
; SSSE3-NEXT:    psrad $31, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,1,1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_4i1_to_4i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pslld $31, %xmm0
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pmovsxdq %xmm0, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_4i1_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_4i1_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_4i1_to_4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX512-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_4i1_to_4i64:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pslld $31, %xmm0
; X86-SSE2-NEXT:    psrad $31, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,1,1]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_4i1_to_4i64:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    pslld $31, %xmm0
; X86-SSE41-NEXT:    psrad $31, %xmm0
; X86-SSE41-NEXT:    pmovsxdq %xmm0, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
  %extmask = sext <4 x i1> %mask to <4 x i64>
  ret <4 x i64> %extmask
}

define <4 x i64> @sext_4i8_to_4i64(<4 x i8> %mask) {
; SSE2-LABEL: sext_4i8_to_4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_4i8_to_4i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSSE3-NEXT:    psrad $24, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_4i8_to_4i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm2
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    pmovsxbq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_4i8_to_4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_4i8_to_4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_4i8_to_4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_4i8_to_4i64:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; X86-SSE2-NEXT:    psrad $24, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_4i8_to_4i64:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm2
; X86-SSE41-NEXT:    psrld $16, %xmm0
; X86-SSE41-NEXT:    pmovsxbq %xmm0, %xmm1
; X86-SSE41-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE41-NEXT:    retl
  %extmask = sext <4 x i8> %mask to <4 x i64>
  ret <4 x i64> %extmask
}

define <32 x i8> @sext_32xi1_to_32xi8(<32 x i16> %c1, <32 x i16> %c2)nounwind {
; SSE-LABEL: sext_32xi1_to_32xi8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqw %xmm5, %xmm1
; SSE-NEXT:    pcmpeqw %xmm4, %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pcmpeqw %xmm7, %xmm3
; SSE-NEXT:    pcmpeqw %xmm6, %xmm2
; SSE-NEXT:    packsswb %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: sext_32xi1_to_32xi8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpcmpeqw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_32xi1_to_32xi8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sext_32xi1_to_32xi8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpacksswb %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: sext_32xi1_to_32xi8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512BW-NEXT:    retq
;
; X86-SSE-LABEL: sext_32xi1_to_32xi8:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %ebp
; X86-SSE-NEXT:    movl %esp, %ebp
; X86-SSE-NEXT:    andl $-16, %esp
; X86-SSE-NEXT:    subl $16, %esp
; X86-SSE-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE-NEXT:    pcmpeqw 40(%ebp), %xmm1
; X86-SSE-NEXT:    pcmpeqw 24(%ebp), %xmm0
; X86-SSE-NEXT:    packsswb %xmm1, %xmm0
; X86-SSE-NEXT:    pcmpeqw 72(%ebp), %xmm3
; X86-SSE-NEXT:    pcmpeqw 56(%ebp), %xmm2
; X86-SSE-NEXT:    packsswb %xmm3, %xmm2
; X86-SSE-NEXT:    movdqa %xmm2, %xmm1
; X86-SSE-NEXT:    movl %ebp, %esp
; X86-SSE-NEXT:    popl %ebp
; X86-SSE-NEXT:    retl
  %a = icmp eq <32 x i16> %c1, %c2
  %b = sext <32 x i1> %a to <32 x i8>
  ret <32 x i8> %b
}

define <2 x i32> @sext_2i8_to_2i32(ptr %addr) {
; SSE2-LABEL: sext_2i8_to_2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    paddd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_2i8_to_2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSSE3-NEXT:    psrad $24, %xmm0
; SSSE3-NEXT:    paddd %xmm0, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_2i8_to_2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    paddd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_2i8_to_2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    vmovd %eax, %xmm0
; AVX-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_2i8_to_2i32:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    movzwl (%eax), %eax
; X86-SSE2-NEXT:    movd %eax, %xmm0
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; X86-SSE2-NEXT:    psrad $24, %xmm0
; X86-SSE2-NEXT:    paddd %xmm0, %xmm0
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_2i8_to_2i32:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE41-NEXT:    movzwl (%eax), %eax
; X86-SSE41-NEXT:    movd %eax, %xmm0
; X86-SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; X86-SSE41-NEXT:    paddd %xmm0, %xmm0
; X86-SSE41-NEXT:    retl
  %x = load <2 x i8>, ptr %addr, align 1
  %y = sext <2 x i8> %x to <2 x i32>
  %z = add <2 x i32>%y, %y
  ret <2 x i32>%z
}

define <4 x i32> @sext_4i17_to_4i32(ptr %ptr) {
; SSE2-LABEL: sext_4i17_to_4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq (%rdi), %rax
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shll $15, %ecx
; SSE2-NEXT:    sarl $15, %ecx
; SSE2-NEXT:    movd %ecx, %xmm0
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq $17, %rcx
; SSE2-NEXT:    shll $15, %ecx
; SSE2-NEXT:    sarl $15, %ecx
; SSE2-NEXT:    movd %ecx, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movl 8(%rdi), %ecx
; SSE2-NEXT:    shll $28, %ecx
; SSE2-NEXT:    movq %rax, %rdx
; SSE2-NEXT:    shrq $51, %rdx
; SSE2-NEXT:    shll $15, %edx
; SSE2-NEXT:    orl %ecx, %edx
; SSE2-NEXT:    sarl $15, %edx
; SSE2-NEXT:    movd %edx, %xmm1
; SSE2-NEXT:    shrq $34, %rax
; SSE2-NEXT:    shll $15, %eax
; SSE2-NEXT:    sarl $15, %eax
; SSE2-NEXT:    movd %eax, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_4i17_to_4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movq (%rdi), %rax
; SSSE3-NEXT:    movl %eax, %ecx
; SSSE3-NEXT:    shll $15, %ecx
; SSSE3-NEXT:    sarl $15, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm0
; SSSE3-NEXT:    movq %rax, %rcx
; SSSE3-NEXT:    shrq $17, %rcx
; SSSE3-NEXT:    shll $15, %ecx
; SSSE3-NEXT:    sarl $15, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    movl 8(%rdi), %ecx
; SSSE3-NEXT:    shll $28, %ecx
; SSSE3-NEXT:    movq %rax, %rdx
; SSSE3-NEXT:    shrq $51, %rdx
; SSSE3-NEXT:    shll $15, %edx
; SSSE3-NEXT:    orl %ecx, %edx
; SSSE3-NEXT:    sarl $15, %edx
; SSSE3-NEXT:    movd %edx, %xmm1
; SSSE3-NEXT:    shrq $34, %rax
; SSSE3-NEXT:    shll $15, %eax
; SSSE3-NEXT:    sarl $15, %eax
; SSSE3-NEXT:    movd %eax, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_4i17_to_4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq (%rdi), %rax
; SSE41-NEXT:    movq %rax, %rcx
; SSE41-NEXT:    shrq $17, %rcx
; SSE41-NEXT:    shll $15, %ecx
; SSE41-NEXT:    sarl $15, %ecx
; SSE41-NEXT:    movl %eax, %edx
; SSE41-NEXT:    shll $15, %edx
; SSE41-NEXT:    sarl $15, %edx
; SSE41-NEXT:    movd %edx, %xmm0
; SSE41-NEXT:    pinsrd $1, %ecx, %xmm0
; SSE41-NEXT:    movq %rax, %rcx
; SSE41-NEXT:    shrq $34, %rcx
; SSE41-NEXT:    shll $15, %ecx
; SSE41-NEXT:    sarl $15, %ecx
; SSE41-NEXT:    pinsrd $2, %ecx, %xmm0
; SSE41-NEXT:    movl 8(%rdi), %ecx
; SSE41-NEXT:    shll $28, %ecx
; SSE41-NEXT:    shrq $51, %rax
; SSE41-NEXT:    shll $15, %eax
; SSE41-NEXT:    orl %ecx, %eax
; SSE41-NEXT:    sarl $15, %eax
; SSE41-NEXT:    pinsrd $3, %eax, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sext_4i17_to_4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    movq (%rdi), %rax
; AVX-NEXT:    movq %rax, %rcx
; AVX-NEXT:    shrq $17, %rcx
; AVX-NEXT:    shll $15, %ecx
; AVX-NEXT:    sarl $15, %ecx
; AVX-NEXT:    movl %eax, %edx
; AVX-NEXT:    shll $15, %edx
; AVX-NEXT:    sarl $15, %edx
; AVX-NEXT:    vmovd %edx, %xmm0
; AVX-NEXT:    vpinsrd $1, %ecx, %xmm0, %xmm0
; AVX-NEXT:    movq %rax, %rcx
; AVX-NEXT:    shrq $34, %rcx
; AVX-NEXT:    shll $15, %ecx
; AVX-NEXT:    sarl $15, %ecx
; AVX-NEXT:    vpinsrd $2, %ecx, %xmm0, %xmm0
; AVX-NEXT:    movl 8(%rdi), %ecx
; AVX-NEXT:    shll $28, %ecx
; AVX-NEXT:    shrq $51, %rax
; AVX-NEXT:    shll $15, %eax
; AVX-NEXT:    orl %ecx, %eax
; AVX-NEXT:    sarl $15, %eax
; AVX-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; X86-SSE2-LABEL: sext_4i17_to_4i32:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE2-NEXT:    movl (%edx), %ecx
; X86-SSE2-NEXT:    movl 4(%edx), %eax
; X86-SSE2-NEXT:    movl 8(%edx), %edx
; X86-SSE2-NEXT:    shldl $13, %eax, %edx
; X86-SSE2-NEXT:    shll $15, %edx
; X86-SSE2-NEXT:    sarl $15, %edx
; X86-SSE2-NEXT:    movd %edx, %xmm0
; X86-SSE2-NEXT:    movl %eax, %edx
; X86-SSE2-NEXT:    shll $13, %edx
; X86-SSE2-NEXT:    sarl $15, %edx
; X86-SSE2-NEXT:    movd %edx, %xmm1
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X86-SSE2-NEXT:    shldl $15, %ecx, %eax
; X86-SSE2-NEXT:    shll $15, %ecx
; X86-SSE2-NEXT:    sarl $15, %ecx
; X86-SSE2-NEXT:    movd %ecx, %xmm0
; X86-SSE2-NEXT:    shll $15, %eax
; X86-SSE2-NEXT:    sarl $15, %eax
; X86-SSE2-NEXT:    movd %eax, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X86-SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_4i17_to_4i32:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    pushl %esi
; X86-SSE41-NEXT:    .cfi_def_cfa_offset 8
; X86-SSE41-NEXT:    .cfi_offset %esi, -8
; X86-SSE41-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SSE41-NEXT:    movl (%edx), %eax
; X86-SSE41-NEXT:    movl 4(%edx), %ecx
; X86-SSE41-NEXT:    movl %ecx, %esi
; X86-SSE41-NEXT:    movl 8(%edx), %edx
; X86-SSE41-NEXT:    shldl $13, %ecx, %edx
; X86-SSE41-NEXT:    shldl $15, %eax, %ecx
; X86-SSE41-NEXT:    shll $15, %ecx
; X86-SSE41-NEXT:    sarl $15, %ecx
; X86-SSE41-NEXT:    shll $15, %eax
; X86-SSE41-NEXT:    sarl $15, %eax
; X86-SSE41-NEXT:    movd %eax, %xmm0
; X86-SSE41-NEXT:    pinsrd $1, %ecx, %xmm0
; X86-SSE41-NEXT:    shll $13, %esi
; X86-SSE41-NEXT:    sarl $15, %esi
; X86-SSE41-NEXT:    pinsrd $2, %esi, %xmm0
; X86-SSE41-NEXT:    shll $15, %edx
; X86-SSE41-NEXT:    sarl $15, %edx
; X86-SSE41-NEXT:    pinsrd $3, %edx, %xmm0
; X86-SSE41-NEXT:    popl %esi
; X86-SSE41-NEXT:    .cfi_def_cfa_offset 4
; X86-SSE41-NEXT:    retl
  %a = load <4 x i17>, ptr %ptr
  %b = sext <4 x i17> %a to <4 x i32>
  ret <4 x i32> %b
}

define <8 x i64> @sext_8i6_to_8i64(i32 %x) nounwind uwtable readnone ssp {
; SSE2-LABEL: sext_8i6_to_8i64:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,0,0]
; SSE2-NEXT:    paddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,0,0]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    psllq $58, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    psrad $26, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    psllq $58, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    psrad $26, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,2,2,2]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    psllq $58, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,3,2,3]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    psrad $26, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    psllq $58, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,3,2,3]
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psrad $31, %xmm4
; SSE2-NEXT:    psrad $26, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: sext_8i6_to_8i64:
; SSSE3:       # %bb.0: # %entry
; SSSE3-NEXT:    movd %edi, %xmm0
; SSSE3-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,0,0]
; SSSE3-NEXT:    paddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,0,0]
; SSSE3-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSSE3-NEXT:    psllq $58, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    psrad $26, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSSE3-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSSE3-NEXT:    psllq $58, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    psrad $31, %xmm2
; SSSE3-NEXT:    psrad $26, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,2,2,2]
; SSSE3-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSSE3-NEXT:    psllq $58, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,3,2,3]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    psrad $31, %xmm4
; SSSE3-NEXT:    psrad $26, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; SSSE3-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,5,5,5]
; SSSE3-NEXT:    psllq $58, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,3,2,3]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    psrad $31, %xmm4
; SSSE3-NEXT:    psrad $26, %xmm3
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: sext_8i6_to_8i64:
; SSE41:       # %bb.0: # %entry
; SSE41-NEXT:    movd %edi, %xmm0
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,0,0]
; SSE41-NEXT:    paddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE41-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; SSE41-NEXT:    psllq $58, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE41-NEXT:    psrad $31, %xmm1
; SSE41-NEXT:    psrad $26, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; SSE41-NEXT:    pmovzxwq {{.*#+}} xmm2 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; SSE41-NEXT:    psllq $58, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE41-NEXT:    psrad $31, %xmm2
; SSE41-NEXT:    psrad $26, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,3,2,3]
; SSE41-NEXT:    pmovzxwq {{.*#+}} xmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; SSE41-NEXT:    psllq $58, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; SSE41-NEXT:    psrad $31, %xmm4
; SSE41-NEXT:    psrad $26, %xmm2
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; SSE41-NEXT:    pmovzxwq {{.*#+}} xmm4 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; SSE41-NEXT:    psllq $58, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE41-NEXT:    psrad $31, %xmm4
; SSE41-NEXT:    psrad $26, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3],xmm3[4,5],xmm4[6,7]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sext_8i6_to_8i64:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vmovd %edi, %xmm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $10, %xmm0, %xmm0
; AVX1-NEXT:    vpsraw $10, %xmm0, %xmm1
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sext_8i6_to_8i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vmovd %edi, %xmm0
; AVX2-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX2-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpsllw $10, %xmm0, %xmm0
; AVX2-NEXT:    vpsraw $10, %xmm0, %xmm1
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sext_8i6_to_8i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vmovd %edi, %xmm0
; AVX512-NEXT:    vpbroadcastw %xmm0, %xmm0
; AVX512-NEXT:    vpaddw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vpsllq $58, %zmm0, %zmm0
; AVX512-NEXT:    vpsraq $58, %zmm0, %zmm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: sext_8i6_to_8i64:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,0,0]
; X86-SSE2-NEXT:    paddw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,0,0]
; X86-SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; X86-SSE2-NEXT:    psllq $58, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrad $31, %xmm1
; X86-SSE2-NEXT:    psrad $26, %xmm0
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; X86-SSE2-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; X86-SSE2-NEXT:    psllq $58, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X86-SSE2-NEXT:    psrad $31, %xmm2
; X86-SSE2-NEXT:    psrad $26, %xmm1
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,2,2,2]
; X86-SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; X86-SSE2-NEXT:    psllq $58, %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm4
; X86-SSE2-NEXT:    psrad $31, %xmm4
; X86-SSE2-NEXT:    psrad $26, %xmm2
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; X86-SSE2-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,5,5,5]
; X86-SSE2-NEXT:    psllq $58, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm4
; X86-SSE2-NEXT:    psrad $31, %xmm4
; X86-SSE2-NEXT:    psrad $26, %xmm3
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: sext_8i6_to_8i64:
; X86-SSE41:       # %bb.0: # %entry
; X86-SSE41-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,0,0]
; X86-SSE41-NEXT:    paddw {{\.?LCPI[0-9]+_[0-9]+}}, %xmm3
; X86-SSE41-NEXT:    pmovzxwq {{.*#+}} xmm1 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; X86-SSE41-NEXT:    psllq $58, %xmm1
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; X86-SSE41-NEXT:    psrad $31, %xmm1
; X86-SSE41-NEXT:    psrad $26, %xmm0
; X86-SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; X86-SSE41-NEXT:    pmovzxwq {{.*#+}} xmm2 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; X86-SSE41-NEXT:    psllq $58, %xmm2
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; X86-SSE41-NEXT:    psrad $31, %xmm2
; X86-SSE41-NEXT:    psrad $26, %xmm1
; X86-SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,3,2,3]
; X86-SSE41-NEXT:    pmovzxwq {{.*#+}} xmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; X86-SSE41-NEXT:    psllq $58, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; X86-SSE41-NEXT:    psrad $31, %xmm4
; X86-SSE41-NEXT:    psrad $26, %xmm2
; X86-SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; X86-SSE41-NEXT:    pmovzxwq {{.*#+}} xmm4 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; X86-SSE41-NEXT:    psllq $58, %xmm4
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; X86-SSE41-NEXT:    psrad $31, %xmm4
; X86-SSE41-NEXT:    psrad $26, %xmm3
; X86-SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3],xmm3[4,5],xmm4[6,7]
; X86-SSE41-NEXT:    retl
entry:
  %a = trunc i32 %x to i6
  %b = insertelement <8 x i6> undef, i6 %a, i32 0
  %c = shufflevector <8 x i6> %b, <8 x i6> undef, <8 x i32> zeroinitializer
  %d = add <8 x i6> %c, <i6 0, i6 1, i6 2, i6 3, i6 4, i6 5, i6 6, i6 7>
  %e = sext <8 x i6> %d to <8 x i64>
  ret <8 x i64> %e
}

define <8 x i32> @zext_negate_sext(<8 x i8> %x) {
; SSE2-LABEL: zext_negate_sext:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    psubw %xmm0, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: zext_negate_sext:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSSE3-NEXT:    psubw %xmm0, %xmm1
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: zext_negate_sext:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    psubw %xmm0, %xmm1
; SSE41-NEXT:    pmovsxwd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    pmovsxwd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: zext_negate_sext:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpsubd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: zext_negate_sext:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: zext_negate_sext:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: zext_negate_sext:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X86-SSE2-NEXT:    psubw %xmm0, %xmm1
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: zext_negate_sext:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; X86-SSE41-NEXT:    pxor %xmm1, %xmm1
; X86-SSE41-NEXT:    psubw %xmm0, %xmm1
; X86-SSE41-NEXT:    pmovsxwd %xmm1, %xmm0
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxwd %xmm1, %xmm1
; X86-SSE41-NEXT:    retl
  %z = zext <8 x i8> %x to <8 x i16>
  %neg = sub nsw <8 x i16> zeroinitializer, %z
  %r = sext <8 x i16> %neg to <8 x i32>
  ret <8 x i32> %r
}

define <8 x i32> @zext_decremenet_sext(<8 x i8> %x) {
; SSE2-LABEL: zext_decremenet_sext:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    paddw %xmm0, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: zext_decremenet_sext:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pxor %xmm1, %xmm1
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSSE3-NEXT:    paddw %xmm0, %xmm1
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSSE3-NEXT:    psrad $16, %xmm0
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSSE3-NEXT:    psrad $16, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: zext_decremenet_sext:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    paddw %xmm0, %xmm1
; SSE41-NEXT:    pmovsxwd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    pmovsxwd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: zext_decremenet_sext:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: zext_decremenet_sext:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: zext_decremenet_sext:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-SSE2-LABEL: zext_decremenet_sext:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pxor %xmm1, %xmm1
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    psrad $16, %xmm1
; X86-SSE2-NEXT:    retl
;
; X86-SSE41-LABEL: zext_decremenet_sext:
; X86-SSE41:       # %bb.0:
; X86-SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; X86-SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE41-NEXT:    paddw %xmm0, %xmm1
; X86-SSE41-NEXT:    pmovsxwd %xmm1, %xmm0
; X86-SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; X86-SSE41-NEXT:    pmovsxwd %xmm1, %xmm1
; X86-SSE41-NEXT:    retl
  %z = zext <8 x i8> %x to <8 x i16>
  %dec = add <8 x i16> %z, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %r = sext <8 x i16> %dec to <8 x i32>
  ret <8 x i32> %r
}
