; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-linux-gnu | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s --check-prefixes=CHECK,X64

@ok = internal constant [4 x i8] c"%d\0A\00"
@no = internal constant [4 x i8] c"no\0A\00"

define i1 @test1(i32 %v1, i32 %v2) nounwind {
; X86-LABEL: test1:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull {{[0-9]+}}(%esp), %eax
; X86-NEXT:    jno .LBB0_1
; X86-NEXT:  # %bb.2: # %overflow
; X86-NEXT:    movl $no, (%esp)
; X86-NEXT:    calll printf@PLT
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
; X86-NEXT:  .LBB0_1: # %normal
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl $ok, (%esp)
; X86-NEXT:    calll printf@PLT
; X86-NEXT:    movb $1, %al
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; X64-LABEL: test1:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    imull %esi, %eax
; X64-NEXT:    jno .LBB0_1
; X64-NEXT:  # %bb.2: # %overflow
; X64-NEXT:    movl $no, %edi
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    callq printf@PLT
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
; X64-NEXT:  .LBB0_1: # %normal
; X64-NEXT:    movl $ok, %edi
; X64-NEXT:    movl %eax, %esi
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    callq printf@PLT
; X64-NEXT:    movb $1, %al
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %overflow, label %normal

normal:
  %t1 = tail call i32 (ptr, ...) @printf( ptr @ok, i32 %sum ) nounwind
  ret i1 true

overflow:
  %t2 = tail call i32 (ptr, ...) @printf( ptr @no ) nounwind
  ret i1 false
}

define i1 @test2(i32 %v1, i32 %v2) nounwind {
; X86-LABEL: test2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull {{[0-9]+}}(%esp), %eax
; X86-NEXT:    jno .LBB1_2
; X86-NEXT:  # %bb.1: # %overflow
; X86-NEXT:    movl $no, (%esp)
; X86-NEXT:    calll printf@PLT
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
; X86-NEXT:  .LBB1_2: # %normal
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl $ok, (%esp)
; X86-NEXT:    calll printf@PLT
; X86-NEXT:    movb $1, %al
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; X64-LABEL: test2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    imull %esi, %eax
; X64-NEXT:    jno .LBB1_2
; X64-NEXT:  # %bb.1: # %overflow
; X64-NEXT:    movl $no, %edi
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    callq printf@PLT
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
; X64-NEXT:  .LBB1_2: # %normal
; X64-NEXT:    movl $ok, %edi
; X64-NEXT:    movl %eax, %esi
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    callq printf@PLT
; X64-NEXT:    movb $1, %al
; X64-NEXT:    popq %rcx
; X64-NEXT:    retq
entry:
  %t = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %overflow, label %normal

overflow:
  %t2 = tail call i32 (ptr, ...) @printf( ptr @no ) nounwind
  ret i1 false

normal:
  %t1 = tail call i32 (ptr, ...) @printf( ptr @ok, i32 %sum ) nounwind
  ret i1 true
}

declare i32 @printf(ptr, ...) nounwind
declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32)

define i32 @test3(i32 %a, i32 %b) nounwind readnone {
; X86-LABEL: test3:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test3:
; X64:       # %bb.0: # %entry
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    addl %eax, %eax
; X64-NEXT:    retq
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 %tmp0, i32 2)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}

define i32 @test4(i32 %a, i32 %b) nounwind readnone {
; X86-LABEL: test4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    imull $4, %eax, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    addl %esi, %edi
; X64-NEXT:    imull $4, %edi, %eax
; X64-NEXT:    retq
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 %tmp0, i32 4)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}

declare { i63, i1 } @llvm.smul.with.overflow.i63(i63, i63) nounwind readnone

; Was returning false, should return true (not constant folded yet though).
; PR13991
define i1 @test5() nounwind {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %res = call { i63, i1 } @llvm.smul.with.overflow.i63(i63 4, i63 4611686018427387903)
  %sum = extractvalue { i63, i1 } %res, 0
  %overflow = extractvalue { i63, i1 } %res, 1
  ret i1 %overflow
}



declare { i129, i1 } @llvm.smul.with.overflow.i129(i129, i129)

define { i129, i1 } @smul_ovf(i129 %x, i129 %y) nounwind {
; X86-LABEL: smul_ovf:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $188, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    andl $1, %ebp
; X86-NEXT:    negl %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %edx, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movzbl %bl, %esi
; X86-NEXT:    adcl %edx, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    movl %edi, (%esp) # 4-byte Spill
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %edx, %ebx
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %eax, %ebx
; X86-NEXT:    adcl %edx, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %edx, %eax
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl %ebx, %esi
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %edi, %ebp
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    addl (%esp), %ebp # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    setb %al
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %esi, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    adcl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    addl %esi, %ebx
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    mull %ebp
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    addl %ebx, %esi
; X86-NEXT:    adcl %ecx, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ebp
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %ecx, %ebp
; X86-NEXT:    setb %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    addl %ebp, %ecx
; X86-NEXT:    movzbl %bl, %eax
; X86-NEXT:    adcl %eax, %edi
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    adcl %esi, %edi
; X86-NEXT:    adcl $0, (%esp) # 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %esi
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ebx, %ebp
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    mull %edx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    addl %ebp, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %esi, %ebx
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %ebx, %ebp
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %esi
; X86-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    addl (%esp), %ebp # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    setb (%esp) # 1-byte Folded Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %ecx, %ebx
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    addl %ebx, %edi
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    movl %edx, %ebx
; X86-NEXT:    adcl %eax, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl %ebp, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    adcl %esi, %edx
; X86-NEXT:    movzbl (%esp), %eax # 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %edi
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %esi, %ecx
; X86-NEXT:    movl %edx, %edi
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    addl %ebx, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %esi, %edi
; X86-NEXT:    setb %al
; X86-NEXT:    addl %ebp, %edi
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    adcl %edx, %eax
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %esi, %ecx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    addl %ebp, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %eax, %esi
; X86-NEXT:    setb %al
; X86-NEXT:    addl %ebx, %esi
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    adcl %edx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    addl %esi, %edx
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    adcl %eax, %esi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl (%esp), %ebp # 4-byte Reload
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    addl %ebx, %eax
; X86-NEXT:    adcl %ebp, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movzbl %bl, %ebx
; X86-NEXT:    adcl %edi, %ebx
; X86-NEXT:    adcl $0, (%esp) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    addl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    adcl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl (%esp), %eax # 4-byte Reload
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    mull {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    addl %edx, %ebp
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    addl %eax, %ebp
; X86-NEXT:    adcl %edx, %ecx
; X86-NEXT:    setb %bl
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movzbl %bl, %esi
; X86-NEXT:    adcl %edx, %esi
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %ecx, %ebx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    adcl %ebp, %edi
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    addl %ebx, %edx
; X86-NEXT:    adcl %ecx, %eax
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    addl %ebx, %edx
; X86-NEXT:    movl %ebp, %esi
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %ebp, %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    movzbl %cl, %eax
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    addl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    adcl (%esp), %edi # 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    adcl %eax, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    movl %edi, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    movl %esi, %ebx
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    adcl %ecx, %ebx
; X86-NEXT:    setb %al
; X86-NEXT:    addl %edi, %ebx
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    addl %esi, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %esi, %edi
; X86-NEXT:    setb %al
; X86-NEXT:    addl %ebp, %edi
; X86-NEXT:    movzbl %al, %esi
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl %edi, %ecx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    movl (%esp), %ebp # 4-byte Reload
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    addl %eax, %edi
; X86-NEXT:    adcl %ebp, %esi
; X86-NEXT:    setb %al
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl %ecx, %edi
; X86-NEXT:    adcl %edx, %esi
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    adcl %ebx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, (%esp) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    addl %ebx, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    adcl %ecx, %edx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    imull {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    adcl %edx, %ebp
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    adcl %ebp, %edx
; X86-NEXT:    addl %edi, %ebx
; X86-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl (%esp), %edx # 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    movl %eax, %ebx
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    adcl %esi, %edx
; X86-NEXT:    setb %al
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    movzbl %al, %ebp
; X86-NEXT:    adcl %esi, %ebp
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    adcl %ebp, %eax
; X86-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    adcl %esi, %edx
; X86-NEXT:    setb %bl
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movzbl %bl, %ebx
; X86-NEXT:    adcl %esi, %ebx
; X86-NEXT:    addl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl %edi, %esi
; X86-NEXT:    adcl %eax, (%esp) # 4-byte Folded Spill
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %ebx, %edi
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    adcl %ebp, %edi
; X86-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X86-NEXT:    movl %esi, %ebp
; X86-NEXT:    addl %esi, %edx
; X86-NEXT:    adcl %eax, %edi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    adcl %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl $0, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl %ecx, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    adcl %esi, %eax
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    adcl %esi, %ecx
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    addl %edx, %esi
; X86-NEXT:    adcl %edi, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    adcl %ebx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    movl (%esp), %ebx # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X86-NEXT:    movl %ebx, (%esp) # 4-byte Spill
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    xorl %edx, %ebp
; X86-NEXT:    xorl %edx, %eax
; X86-NEXT:    orl %ebp, %eax
; X86-NEXT:    movl %ecx, %ebx
; X86-NEXT:    xorl %edx, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    xorl %edx, %ecx
; X86-NEXT:    orl %ebx, %ecx
; X86-NEXT:    orl %eax, %ecx
; X86-NEXT:    movl (%esp), %ebx # 4-byte Reload
; X86-NEXT:    xorl %edx, %ebx
; X86-NEXT:    xorl %edx, %esi
; X86-NEXT:    orl %ebx, %esi
; X86-NEXT:    xorl %edx, %edi
; X86-NEXT:    xorl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X86-NEXT:    orl %edi, %edx
; X86-NEXT:    orl %esi, %edx
; X86-NEXT:    orl %ecx, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X86-NEXT:    movl %edi, %ecx
; X86-NEXT:    andl $1, %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    xorl %eax, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X86-NEXT:    xorl %eax, %esi
; X86-NEXT:    orl %ebx, %esi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    xorl %eax, %ebx
; X86-NEXT:    xorl %edi, %eax
; X86-NEXT:    orl %ebx, %eax
; X86-NEXT:    orl %esi, %eax
; X86-NEXT:    orl %edx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl %edx, 4(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl %edx, (%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl %edx, 8(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    movb %cl, 16(%eax)
; X86-NEXT:    setne 32(%eax)
; X86-NEXT:    addl $188, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: smul_ovf:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    movq %r9, %r15
; X64-NEXT:    movq %rcx, %r9
; X64-NEXT:    movq %rdx, %r14
; X64-NEXT:    movq %rsi, %r12
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; X64-NEXT:    andl $1, %r11d
; X64-NEXT:    negq %r11
; X64-NEXT:    andl $1, %r9d
; X64-NEXT:    negq %r9
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    addq %rdx, %rbp
; X64-NEXT:    adcq $0, %rcx
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %r15
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    addq %rax, %rbp
; X64-NEXT:    adcq %rdx, %rcx
; X64-NEXT:    setb %sil
; X64-NEXT:    movzbl %sil, %edi
; X64-NEXT:    addq %rax, %rcx
; X64-NEXT:    adcq %rdx, %rdi
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %r10
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %r14, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    addq %r10, %r13
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    mulq %r15
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    addq %r13, %rax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq %rbx, %rsi
; X64-NEXT:    setb %r8b
; X64-NEXT:    movq %r14, %rax
; X64-NEXT:    mulq %r15
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    addq %rsi, %rax
; X64-NEXT:    movzbl %r8b, %edx
; X64-NEXT:    adcq %rdx, %rbx
; X64-NEXT:    addq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Folded Reload
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    adcq %rbp, %rbx
; X64-NEXT:    adcq $0, %rcx
; X64-NEXT:    adcq $0, %rdi
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %r12
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    movq %rax, %r15
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %rax, %r14
; X64-NEXT:    movq %rax, %r8
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    addq %r13, %r14
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    addq %r15, %r14
; X64-NEXT:    adcq %r13, %rbp
; X64-NEXT:    setb %al
; X64-NEXT:    addq %r8, %rbp
; X64-NEXT:    movzbl %al, %r12d
; X64-NEXT:    adcq %rdx, %r12
; X64-NEXT:    addq %r15, %rsi
; X64-NEXT:    movq %rsi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq %rbx, %r14
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    adcq $0, %r12
; X64-NEXT:    addq %rcx, %rbp
; X64-NEXT:    adcq %rdi, %r12
; X64-NEXT:    setb %cl
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rax, %r10
; X64-NEXT:    addq %rdx, %r10
; X64-NEXT:    movq %rdx, %rdi
; X64-NEXT:    adcq $0, %rdi
; X64-NEXT:    addq %rax, %r10
; X64-NEXT:    adcq %rdx, %rdi
; X64-NEXT:    setb %bl
; X64-NEXT:    addq %rax, %rdi
; X64-NEXT:    movzbl %bl, %esi
; X64-NEXT:    adcq %rdx, %rsi
; X64-NEXT:    addq %rax, %rbp
; X64-NEXT:    adcq %r12, %r10
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    adcq %rax, %rdi
; X64-NEXT:    adcq $0, %rsi
; X64-NEXT:    movq %rsi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; X64-NEXT:    movq %rsi, %r8
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    addq %rax, %r8
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Reload
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    adcq $0, %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbx # 8-byte Reload
; X64-NEXT:    addq %rbx, %r8
; X64-NEXT:    adcq %rax, %rcx
; X64-NEXT:    setb %al
; X64-NEXT:    addq %rsi, %rcx
; X64-NEXT:    movzbl %al, %esi
; X64-NEXT:    adcq %rdx, %rsi
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    imulq %r11
; X64-NEXT:    movq %rbx, %r11
; X64-NEXT:    addq %rax, %r11
; X64-NEXT:    movq %r8, %r12
; X64-NEXT:    adcq %rdx, %r12
; X64-NEXT:    addq %rcx, %r11
; X64-NEXT:    adcq %rsi, %r12
; X64-NEXT:    movq %r15, %r9
; X64-NEXT:    addq %r13, %r9
; X64-NEXT:    adcq $0, %r13
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    addq %rcx, %r9
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; X64-NEXT:    adcq %rsi, %r13
; X64-NEXT:    setb %bl
; X64-NEXT:    addq %rcx, %r13
; X64-NEXT:    movzbl %bl, %ecx
; X64-NEXT:    adcq %rsi, %rcx
; X64-NEXT:    addq %r15, %rax
; X64-NEXT:    adcq %r9, %rdx
; X64-NEXT:    addq %r13, %rax
; X64-NEXT:    adcq %rcx, %rdx
; X64-NEXT:    addq {{[-0-9]+}}(%r{{[sb]}}p), %r15 # 8-byte Folded Reload
; X64-NEXT:    adcq %r8, %r9
; X64-NEXT:    adcq %r11, %rax
; X64-NEXT:    adcq %r12, %rdx
; X64-NEXT:    addq %rbp, %r15
; X64-NEXT:    adcq %r10, %r9
; X64-NEXT:    adcq %rdi, %rax
; X64-NEXT:    adcq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Folded Reload
; X64-NEXT:    movq %r14, %rcx
; X64-NEXT:    sarq $63, %rcx
; X64-NEXT:    xorq %rcx, %rdx
; X64-NEXT:    xorq %rcx, %r9
; X64-NEXT:    orq %rdx, %r9
; X64-NEXT:    xorq %rcx, %rax
; X64-NEXT:    xorq %r15, %rcx
; X64-NEXT:    orq %rax, %rcx
; X64-NEXT:    orq %r9, %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    movl %eax, %esi
; X64-NEXT:    andl $1, %esi
; X64-NEXT:    movq %rsi, %rdx
; X64-NEXT:    negq %rdx
; X64-NEXT:    xorq %rdx, %r14
; X64-NEXT:    xorq %rax, %rdx
; X64-NEXT:    orq %r14, %rdx
; X64-NEXT:    orq %rcx, %rdx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, 8(%rax)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, (%rax)
; X64-NEXT:    movb %sil, 16(%rax)
; X64-NEXT:    setne 32(%rax)
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
  %r = tail call { i129, i1 } @llvm.smul.with.overflow.i129(i129 %x, i129 %y)
  ret { i129, i1 } %r
}
