; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s                               -mtriple=x86_64-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefix=SDAG-X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefix=FAST-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X64
; RUN: llc < %s                               -mtriple=i686-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=SDAG-X86
; Allow fast-isel to fallback to selection dag on x86
; RUN: llc < %s -fast-isel -mtriple=i686-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=FAST-X86
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X86

define i32 @test_icmp_eq_i8(i8 %a, i8 %b) {
; SDAG-X64-LABEL: test_icmp_eq_i8:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpb %sil, %dil
; SDAG-X64-NEXT:    sete %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_eq_i8:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpb %sil, %dil
; FAST-X64-NEXT:    sete %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_eq_i8:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpb %sil, %dil
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_eq_i8:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpb {{[0-9]+}}(%esp), %cl
; SDAG-X86-NEXT:    sete %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_eq_i8:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpb %al, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    sete %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_eq_i8:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpb %dl, %cl
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp eq i8 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_eq_i16(i16 %a, i16 %b) {
; SDAG-X64-LABEL: test_icmp_eq_i16:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpw %si, %di
; SDAG-X64-NEXT:    sete %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_eq_i16:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpw %si, %di
; FAST-X64-NEXT:    sete %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_eq_i16:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpw %si, %di
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_eq_i16:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpw {{[0-9]+}}(%esp), %cx
; SDAG-X86-NEXT:    sete %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_eq_i16:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpw %ax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    sete %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_eq_i16:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpw %dx, %cx
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp eq i16 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_eq_i64(i64 %a, i64 %b) {
; SDAG-X64-LABEL: test_icmp_eq_i64:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpq %rsi, %rdi
; SDAG-X64-NEXT:    sete %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_eq_i64:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpq %rsi, %rdi
; FAST-X64-NEXT:    sete %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_eq_i64:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpq %rsi, %rdi
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_eq_i64:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    orl %edx, %ecx
; SDAG-X86-NEXT:    sete %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_eq_i64:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; FAST-X86-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; FAST-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    orl %ecx, %eax
; FAST-X86-NEXT:    sete %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_eq_i64:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    orl %eax, %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl $0, %ecx
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp eq i64 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_eq_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_eq_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    sete %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_eq_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    sete %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_eq_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_eq_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    sete %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_eq_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    sete %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_eq_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp eq i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ne_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_ne_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setne %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_ne_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setne %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_ne_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_ne_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setne %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_ne_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setne %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_ne_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setne %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp ne i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ugt_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_ugt_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    seta %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_ugt_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    seta %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_ugt_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_ugt_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    seta %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_ugt_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    seta %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_ugt_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp ugt i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_uge_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_uge_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setae %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_uge_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setae %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_uge_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_uge_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setae %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_uge_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setae %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_uge_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp uge i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ult_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_ult_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setb %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_ult_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setb %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_ult_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_ult_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setb %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_ult_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setb %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_ult_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp ult i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ule_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_ule_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setbe %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_ule_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setbe %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_ule_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_ule_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setbe %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_ule_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setbe %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_ule_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp ule i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_sgt_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_sgt_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setg %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_sgt_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setg %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_sgt_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setg %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_sgt_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setg %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_sgt_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setg %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_sgt_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setg %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp sgt i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_sge_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_sge_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setge %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_sge_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setge %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_sge_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setge %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_sge_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setge %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_sge_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setge %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_sge_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setge %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp sge i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_slt_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_slt_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setl %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_slt_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setl %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_slt_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setl %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_slt_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setl %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_slt_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setl %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_slt_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setl %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp slt i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_sle_i32(i32 %a, i32 %b) {
; SDAG-X64-LABEL: test_icmp_sle_i32:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %esi, %edi
; SDAG-X64-NEXT:    setle %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: test_icmp_sle_i32:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    cmpl %esi, %edi
; FAST-X64-NEXT:    setle %al
; FAST-X64-NEXT:    andb $1, %al
; FAST-X64-NEXT:    movzbl %al, %eax
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_icmp_sle_i32:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setle %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: test_icmp_sle_i32:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    setle %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: test_icmp_sle_i32:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    setle %al
; FAST-X86-NEXT:    andb $1, %al
; FAST-X86-NEXT:    movzbl %al, %eax
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_icmp_sle_i32:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setle %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    retl
  %r = icmp sle i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}
