; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

define half @extractelt_nxv1f16_0(<vscale x 1 x half> %v) {
; CHECK-LABEL: extractelt_nxv1f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv1f16_imm(<vscale x 1 x half> %v) {
; CHECK-LABEL: extractelt_nxv1f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv1f16_idx(<vscale x 1 x half> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv1f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv2f16_0(<vscale x 2 x half> %v) {
; CHECK-LABEL: extractelt_nxv2f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv2f16_imm(<vscale x 2 x half> %v) {
; CHECK-LABEL: extractelt_nxv2f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv2f16_idx(<vscale x 2 x half> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv2f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv4f16_0(<vscale x 4 x half> %v) {
; CHECK-LABEL: extractelt_nxv4f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv4f16_imm(<vscale x 4 x half> %v) {
; CHECK-LABEL: extractelt_nxv4f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv4f16_idx(<vscale x 4 x half> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv4f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv8f16_0(<vscale x 8 x half> %v) {
; CHECK-LABEL: extractelt_nxv8f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv8f16_imm(<vscale x 8 x half> %v) {
; CHECK-LABEL: extractelt_nxv8f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv8f16_idx(<vscale x 8 x half> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv8f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv16f16_0(<vscale x 16 x half> %v) {
; CHECK-LABEL: extractelt_nxv16f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv16f16_imm(<vscale x 16 x half> %v) {
; CHECK-LABEL: extractelt_nxv16f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv16f16_idx(<vscale x 16 x half> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv16f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv32f16_0(<vscale x 32 x half> %v) {
; CHECK-LABEL: extractelt_nxv32f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 32 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv32f16_imm(<vscale x 32 x half> %v) {
; CHECK-LABEL: extractelt_nxv32f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 32 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv32f16_idx(<vscale x 32 x half> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv32f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 32 x half> %v, i32 %idx
  ret half %r
}

define float @extractelt_nxv1f32_0(<vscale x 1 x float> %v) {
; CHECK-LABEL: extractelt_nxv1f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv1f32_imm(<vscale x 1 x float> %v) {
; CHECK-LABEL: extractelt_nxv1f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv1f32_idx(<vscale x 1 x float> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv1f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv2f32_0(<vscale x 2 x float> %v) {
; CHECK-LABEL: extractelt_nxv2f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv2f32_imm(<vscale x 2 x float> %v) {
; CHECK-LABEL: extractelt_nxv2f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv2f32_idx(<vscale x 2 x float> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv2f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv4f32_0(<vscale x 4 x float> %v) {
; CHECK-LABEL: extractelt_nxv4f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv4f32_imm(<vscale x 4 x float> %v) {
; CHECK-LABEL: extractelt_nxv4f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv4f32_idx(<vscale x 4 x float> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv4f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv8f32_0(<vscale x 8 x float> %v) {
; CHECK-LABEL: extractelt_nxv8f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv8f32_imm(<vscale x 8 x float> %v) {
; CHECK-LABEL: extractelt_nxv8f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv8f32_idx(<vscale x 8 x float> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv8f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv16f32_0(<vscale x 16 x float> %v) {
; CHECK-LABEL: extractelt_nxv16f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv16f32_imm(<vscale x 16 x float> %v) {
; CHECK-LABEL: extractelt_nxv16f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv16f32_idx(<vscale x 16 x float> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv16f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x float> %v, i32 %idx
  ret float %r
}

define double @extractelt_nxv1f64_0(<vscale x 1 x double> %v) {
; CHECK-LABEL: extractelt_nxv1f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv1f64_imm(<vscale x 1 x double> %v) {
; CHECK-LABEL: extractelt_nxv1f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv1f64_idx(<vscale x 1 x double> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv1f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x double> %v, i32 %idx
  ret double %r
}

define double @extractelt_nxv2f64_0(<vscale x 2 x double> %v) {
; CHECK-LABEL: extractelt_nxv2f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv2f64_imm(<vscale x 2 x double> %v) {
; CHECK-LABEL: extractelt_nxv2f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv2f64_idx(<vscale x 2 x double> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv2f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x double> %v, i32 %idx
  ret double %r
}

define double @extractelt_nxv4f64_0(<vscale x 4 x double> %v) {
; CHECK-LABEL: extractelt_nxv4f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv4f64_imm(<vscale x 4 x double> %v) {
; CHECK-LABEL: extractelt_nxv4f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv4f64_idx(<vscale x 4 x double> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv4f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x double> %v, i32 %idx
  ret double %r
}

define double @extractelt_nxv8f64_0(<vscale x 8 x double> %v) {
; CHECK-LABEL: extractelt_nxv8f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv8f64_imm(<vscale x 8 x double> %v) {
; CHECK-LABEL: extractelt_nxv8f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv8f64_idx(<vscale x 8 x double> %v, i32 zeroext %idx) {
; CHECK-LABEL: extractelt_nxv8f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x double> %v, i32 %idx
  ret double %r
}

define void @store_extractelt_nxv8f64(ptr %x, ptr %p) {
; CHECK-LABEL: store_extractelt_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re64.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 1
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <vscale x 8 x double>, ptr %x
  %b = extractelement <vscale x 8 x double> %a, i64 1
  store double %b, ptr %p
  ret void
}

define void @store_vfmv_f_s_nxv8f64(ptr %x, ptr %p) {
; CHECK-LABEL: store_vfmv_f_s_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re64.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <vscale x 8 x double>, ptr %x
  %b = call double @llvm.riscv.vfmv.f.s.nxv8f64(<vscale x 8 x double> %a)
  store double %b, ptr %p
  ret void
}

declare double @llvm.riscv.vfmv.f.s.nxv8f64(<vscale x 8 x double>)

define float @extractelt_fadd_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fadd_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    lui a0, 263168
; CHECK-NEXT:    fmv.w.x fa4, a0
; CHECK-NEXT:    fadd.s fa0, fa5, fa4
; CHECK-NEXT:    ret
  %bo = fadd <vscale x 4 x float> %x, splat (float 3.0)
  %ext = extractelement <vscale x 4 x float> %bo, i32 2
  ret float %ext
}

define float @extractelt_fsub_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fsub_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 1
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    lui a0, 263168
; CHECK-NEXT:    fmv.w.x fa4, a0
; CHECK-NEXT:    fsub.s fa0, fa4, fa5
; CHECK-NEXT:    ret
  %bo = fsub <vscale x 4 x float> splat (float 3.0), %x
  %ext = extractelement <vscale x 4 x float> %bo, i32 1
  ret float %ext
}

define float @extractelt_fmul_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fmul_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 3
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    lui a0, 263168
; CHECK-NEXT:    fmv.w.x fa4, a0
; CHECK-NEXT:    fmul.s fa0, fa5, fa4
; CHECK-NEXT:    ret
  %bo = fmul <vscale x 4 x float> %x, splat (float 3.0)
  %ext = extractelement <vscale x 4 x float> %bo, i32 3
  ret float %ext
}

define float @extractelt_fdiv_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fdiv_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    lui a0, 263168
; CHECK-NEXT:    fmv.w.x fa4, a0
; CHECK-NEXT:    fdiv.s fa0, fa5, fa4
; CHECK-NEXT:    ret
  %bo = fdiv <vscale x 4 x float> %x, splat (float 3.0)
  %ext = extractelement <vscale x 4 x float> %bo, i32 0
  ret float %ext
}

define double @extractelt_nxv16f64_0(<vscale x 16 x double> %v) {
; CHECK-LABEL: extractelt_nxv16f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv16f64_neg1(<vscale x 16 x double> %v) {
; RV32-LABEL: extractelt_nxv16f64_neg1:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -80
; RV32-NEXT:    .cfi_def_cfa_offset 80
; RV32-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 72(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    addi s0, sp, 80
; RV32-NEXT:    .cfi_def_cfa s0, 0
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    sub sp, sp, a0
; RV32-NEXT:    andi sp, sp, -64
; RV32-NEXT:    addi a0, sp, 64
; RV32-NEXT:    vs8r.v v8, (a0)
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a2, a1, 3
; RV32-NEXT:    add a2, a0, a2
; RV32-NEXT:    vs8r.v v16, (a2)
; RV32-NEXT:    slli a1, a1, 4
; RV32-NEXT:    add a0, a1, a0
; RV32-NEXT:    fld fa0, -8(a0)
; RV32-NEXT:    addi sp, s0, -80
; RV32-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 72(sp) # 4-byte Folded Reload
; RV32-NEXT:    addi sp, sp, 80
; RV32-NEXT:    ret
;
; RV64-LABEL: extractelt_nxv16f64_neg1:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -80
; RV64-NEXT:    .cfi_def_cfa_offset 80
; RV64-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    addi s0, sp, 80
; RV64-NEXT:    .cfi_def_cfa s0, 0
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 4
; RV64-NEXT:    sub sp, sp, a0
; RV64-NEXT:    andi sp, sp, -64
; RV64-NEXT:    addi a0, sp, 64
; RV64-NEXT:    vs8r.v v8, (a0)
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    slli a1, a2, 3
; RV64-NEXT:    add a3, a0, a1
; RV64-NEXT:    li a1, -1
; RV64-NEXT:    srli a1, a1, 32
; RV64-NEXT:    slli a2, a2, 1
; RV64-NEXT:    addi a2, a2, -1
; RV64-NEXT:    vs8r.v v16, (a3)
; RV64-NEXT:    bltu a2, a1, .LBB52_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a1
; RV64-NEXT:  .LBB52_2:
; RV64-NEXT:    slli a2, a2, 3
; RV64-NEXT:    add a0, a0, a2
; RV64-NEXT:    fld fa0, 0(a0)
; RV64-NEXT:    addi sp, s0, -80
; RV64-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; RV64-NEXT:    addi sp, sp, 80
; RV64-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 -1
  ret double %r
}

define double @extractelt_nxv16f64_imm(<vscale x 16 x double> %v) {
; CHECK-LABEL: extractelt_nxv16f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv16f64_idx(<vscale x 16 x double> %v, i32 zeroext %idx) {
; RV32-LABEL: extractelt_nxv16f64_idx:
; RV32:       # %bb.0:
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a2, a1, 1
; RV32-NEXT:    addi a2, a2, -1
; RV32-NEXT:    bltu a0, a2, .LBB54_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB54_2:
; RV32-NEXT:    addi sp, sp, -80
; RV32-NEXT:    .cfi_def_cfa_offset 80
; RV32-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 72(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    addi s0, sp, 80
; RV32-NEXT:    .cfi_def_cfa s0, 0
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    slli a2, a2, 4
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    andi sp, sp, -64
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    addi a2, sp, 64
; RV32-NEXT:    add a0, a2, a0
; RV32-NEXT:    vs8r.v v8, (a2)
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    add a1, a2, a1
; RV32-NEXT:    vs8r.v v16, (a1)
; RV32-NEXT:    fld fa0, 0(a0)
; RV32-NEXT:    addi sp, s0, -80
; RV32-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 72(sp) # 4-byte Folded Reload
; RV32-NEXT:    addi sp, sp, 80
; RV32-NEXT:    ret
;
; RV64-LABEL: extractelt_nxv16f64_idx:
; RV64:       # %bb.0:
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a2, a1, 1
; RV64-NEXT:    addi a2, a2, -1
; RV64-NEXT:    bltu a0, a2, .LBB54_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB54_2:
; RV64-NEXT:    addi sp, sp, -80
; RV64-NEXT:    .cfi_def_cfa_offset 80
; RV64-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    addi s0, sp, 80
; RV64-NEXT:    .cfi_def_cfa s0, 0
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    slli a2, a2, 4
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    andi sp, sp, -64
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    addi a2, sp, 64
; RV64-NEXT:    add a0, a2, a0
; RV64-NEXT:    vs8r.v v8, (a2)
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    add a1, a2, a1
; RV64-NEXT:    vs8r.v v16, (a1)
; RV64-NEXT:    fld fa0, 0(a0)
; RV64-NEXT:    addi sp, s0, -80
; RV64-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; RV64-NEXT:    addi sp, sp, 80
; RV64-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 %idx
  ret double %r
}
