; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv64 -mattr=+m \
; RUN:   -riscv-experimental-rv64-legal-i32 | FileCheck %s --check-prefix=RV64I
; RUN: llc < %s -mtriple=riscv64 -mattr=+m,+zbb \
; RUN:   -riscv-experimental-rv64-legal-i32 | FileCheck %s --check-prefix=RV64IZbb

declare i4 @llvm.usub.sat.i4(i4, i4)
declare i8 @llvm.usub.sat.i8(i8, i8)
declare i16 @llvm.usub.sat.i16(i16, i16)
declare i32 @llvm.usub.sat.i32(i32, i32)
declare i64 @llvm.usub.sat.i64(i64, i64)

define signext i32 @func(i32 signext %x, i32 signext %y) nounwind {
; RV64I-LABEL: func:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a1, a0, a1
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64IZbb-LABEL: func:
; RV64IZbb:       # %bb.0:
; RV64IZbb-NEXT:    maxu a0, a0, a1
; RV64IZbb-NEXT:    subw a0, a0, a1
; RV64IZbb-NEXT:    ret
  %tmp = call i32 @llvm.usub.sat.i32(i32 %x, i32 %y);
  ret i32 %tmp;
}

define i64 @func2(i64 %x, i64 %y) nounwind {
; RV64I-LABEL: func2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sub a1, a0, a1
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64IZbb-LABEL: func2:
; RV64IZbb:       # %bb.0:
; RV64IZbb-NEXT:    maxu a0, a0, a1
; RV64IZbb-NEXT:    sub a0, a0, a1
; RV64IZbb-NEXT:    ret
  %tmp = call i64 @llvm.usub.sat.i64(i64 %x, i64 %y);
  ret i64 %tmp;
}

define zeroext i16 @func16(i16 zeroext %x, i16 zeroext %y) nounwind {
; RV64I-LABEL: func16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a1, a0, a1
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64IZbb-LABEL: func16:
; RV64IZbb:       # %bb.0:
; RV64IZbb-NEXT:    maxu a0, a0, a1
; RV64IZbb-NEXT:    subw a0, a0, a1
; RV64IZbb-NEXT:    slli a0, a0, 32
; RV64IZbb-NEXT:    srli a0, a0, 32
; RV64IZbb-NEXT:    ret
  %tmp = call i16 @llvm.usub.sat.i16(i16 %x, i16 %y);
  ret i16 %tmp;
}

define zeroext i8 @func8(i8 zeroext %x, i8 zeroext %y) nounwind {
; RV64I-LABEL: func8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a1, a0, a1
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64IZbb-LABEL: func8:
; RV64IZbb:       # %bb.0:
; RV64IZbb-NEXT:    maxu a0, a0, a1
; RV64IZbb-NEXT:    subw a0, a0, a1
; RV64IZbb-NEXT:    slli a0, a0, 32
; RV64IZbb-NEXT:    srli a0, a0, 32
; RV64IZbb-NEXT:    ret
  %tmp = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y);
  ret i8 %tmp;
}

define zeroext i4 @func3(i4 zeroext %x, i4 zeroext %y) nounwind {
; RV64I-LABEL: func3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a1, a0, a1
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64IZbb-LABEL: func3:
; RV64IZbb:       # %bb.0:
; RV64IZbb-NEXT:    maxu a0, a0, a1
; RV64IZbb-NEXT:    subw a0, a0, a1
; RV64IZbb-NEXT:    slli a0, a0, 32
; RV64IZbb-NEXT:    srli a0, a0, 32
; RV64IZbb-NEXT:    ret
  %tmp = call i4 @llvm.usub.sat.i4(i4 %x, i4 %y);
  ret i4 %tmp;
}
