; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs | FileCheck %s -check-prefixes=GFX89,SI
; RUN: llc < %s -mtriple=amdgcn -mcpu=tonga  -verify-machineinstrs | FileCheck %s -check-prefixes=GFX89,VI
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX89,GFX9
; RUN: llc < %s -mtriple=r600 -mcpu=redwood  -verify-machineinstrs | FileCheck %s --check-prefix=R600
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX10
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX11

declare i32 @llvm.fshr.i32(i32, i32, i32)
declare <2 x i32> @llvm.fshr.v2i32(<2 x i32>, <2 x i32>, <2 x i32>)
declare <3 x i32> @llvm.fshr.v3i32(<3 x i32>, <3 x i32>, <3 x i32>)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare <2 x i16> @llvm.fshr.v2i16(<2 x i16>, <2 x i16>, <2 x i16>)
declare <3 x i16> @llvm.fshr.v3i16(<3 x i16>, <3 x i16>, <3 x i16>)
declare <4 x i16> @llvm.fshr.v4i16(<4 x i16>, <4 x i16>, <4 x i16>)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <2 x i64> @llvm.fshr.v2i64(<2 x i64>, <2 x i64>, <2 x i64>)
declare i24 @llvm.fshr.i24(i24, i24, i24)
declare <2 x i24> @llvm.fshr.v2i24(<2 x i24>, <2 x i24>, <2 x i24>)

define amdgpu_kernel void @fshr_i32(ptr addrspace(1) %in, i32 %x, i32 %y, i32 %z) {
; SI-LABEL: fshr_i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    v_alignbit_b32 v0, s4, v0, v1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fshr_i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v1, s6
; VI-NEXT:    v_alignbit_b32 v2, s4, v0, v1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fshr_i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_alignbit_b32 v1, s4, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; R600-LABEL: fshr_i32:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; R600-NEXT:     BIT_ALIGN_INT * T1.X, KC0[2].Z, KC0[2].W, KC0[3].X,
;
; GFX10-LABEL: fshr_i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_alignbit_b32 v0, s4, s5, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fshr_i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_alignbit_b32 v0, s4, s5, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %0 = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %z)
  store i32 %0, ptr addrspace(1) %in
  ret void
}

define amdgpu_kernel void @fshr_i32_imm(ptr addrspace(1) %in, i32 %x, i32 %y) {
; SI-LABEL: fshr_i32_imm:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s3
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_alignbit_b32 v0, s2, v0, 7
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fshr_i32_imm:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_alignbit_b32 v2, s2, v0, 7
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fshr_i32_imm:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_alignbit_b32 v1, s6, v1, 7
; GFX9-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX9-NEXT:    s_endpgm
;
; R600-LABEL: fshr_i32_imm:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; R600-NEXT:     BIT_ALIGN_INT * T1.X, KC0[2].Z, KC0[2].W, literal.x,
; R600-NEXT:    7(9.809089e-45), 0(0.000000e+00)
;
; GFX10-LABEL: fshr_i32_imm:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v1, s6, s7, 7
; GFX10-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fshr_i32_imm:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v1, s2, s3, 7
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %0 = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 7)
  store i32 %0, ptr addrspace(1) %in
  ret void
}

define amdgpu_kernel void @fshr_v2i32(ptr addrspace(1) %in, <2 x i32> %x, <2 x i32> %y, <2 x i32> %z) {
; SI-LABEL: fshr_v2i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xf
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    v_mov_b32_e32 v1, s9
; SI-NEXT:    v_alignbit_b32 v1, s5, v0, v1
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v2, s8
; SI-NEXT:    v_alignbit_b32 v0, s4, v0, v2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fshr_v2i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x3c
; VI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s7
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_alignbit_b32 v1, s5, v0, v1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_alignbit_b32 v0, s4, v2, v0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fshr_v2i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x3c
; GFX9-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_alignbit_b32 v1, s5, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_alignbit_b32 v0, s4, v0, v3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[8:9]
; GFX9-NEXT:    s_endpgm
;
; R600-LABEL: fshr_v2i32:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, KC0[4].X,
; R600-NEXT:     BIT_ALIGN_INT T0.Y, KC0[3].X, KC0[3].Z, PV.W,
; R600-NEXT:     MOV * T0.W, KC0[3].W,
; R600-NEXT:     BIT_ALIGN_INT * T0.X, KC0[2].W, KC0[3].Y, PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: fshr_v2i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x3c
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    v_alignbit_b32 v1, s5, s7, v0
; GFX10-NEXT:    v_alignbit_b32 v0, s4, s6, v2
; GFX10-NEXT:    global_store_dwordx2 v3, v[0:1], s[8:9]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fshr_v2i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x3c
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[2:3], s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_mov_b32 v0, s1
; GFX11-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_alignbit_b32 v1, s5, s7, v0
; GFX11-NEXT:    v_alignbit_b32 v0, s4, s6, v2
; GFX11-NEXT:    global_store_b64 v3, v[0:1], s[2:3]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %0 = call <2 x i32> @llvm.fshr.v2i32(<2 x i32> %x, <2 x i32> %y, <2 x i32> %z)
  store <2 x i32> %0, ptr addrspace(1) %in
  ret void
}

define amdgpu_kernel void @fshr_v2i32_imm(ptr addrspace(1) %in, <2 x i32> %x, <2 x i32> %y) {
; SI-LABEL: fshr_v2i32_imm:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_alignbit_b32 v1, s5, v0, 9
; SI-NEXT:    v_alignbit_b32 v0, s4, v2, 7
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fshr_v2i32_imm:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s7
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_alignbit_b32 v1, s5, v0, 9
; VI-NEXT:    v_alignbit_b32 v0, s4, v2, 7
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fshr_v2i32_imm:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s7
; GFX9-NEXT:    v_mov_b32_e32 v3, s6
; GFX9-NEXT:    v_alignbit_b32 v1, s5, v0, 9
; GFX9-NEXT:    v_alignbit_b32 v0, s4, v3, 7
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; R600-LABEL: fshr_v2i32_imm:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 5, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     BIT_ALIGN_INT * T0.Y, KC0[3].X, KC0[3].Z, literal.x,
; R600-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; R600-NEXT:     BIT_ALIGN_INT * T0.X, KC0[2].W, KC0[3].Y, literal.x,
; R600-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: fshr_v2i32_imm:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v1, s5, s7, 9
; GFX10-NEXT:    v_alignbit_b32 v0, s4, s6, 7
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fshr_v2i32_imm:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v1, s5, s7, 9
; GFX11-NEXT:    v_alignbit_b32 v0, s4, s6, 7
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %0 = call <2 x i32> @llvm.fshr.v2i32(<2 x i32> %x, <2 x i32> %y, <2 x i32> <i32 7, i32 9>)
  store <2 x i32> %0, ptr addrspace(1) %in
  ret void
}

define amdgpu_kernel void @fshr_v4i32(ptr addrspace(1) %in, <4 x i32> %x, <4 x i32> %y, <4 x i32> %z) {
; SI-LABEL: fshr_v4i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0xd
; SI-NEXT:    s_load_dwordx4 s[12:15], s[2:3], 0x15
; SI-NEXT:    s_load_dwordx2 s[16:17], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s19, 0xf000
; SI-NEXT:    s_mov_b32 s18, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    v_mov_b32_e32 v1, s15
; SI-NEXT:    v_alignbit_b32 v3, s7, v0, v1
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    v_mov_b32_e32 v1, s14
; SI-NEXT:    v_alignbit_b32 v2, s6, v0, v1
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_alignbit_b32 v1, s5, v0, v1
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mov_b32_e32 v4, s12
; SI-NEXT:    v_alignbit_b32 v0, s4, v0, v4
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[16:19], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fshr_v4i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x34
; VI-NEXT:    s_load_dwordx4 s[12:15], s[2:3], 0x54
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s11
; VI-NEXT:    v_mov_b32_e32 v1, s15
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_alignbit_b32 v3, s7, v0, v1
; VI-NEXT:    v_mov_b32_e32 v0, s14
; VI-NEXT:    v_alignbit_b32 v2, s6, v2, v0
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_alignbit_b32 v1, s5, v0, v1
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v4, s12
; VI-NEXT:    v_alignbit_b32 v0, s4, v0, v4
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fshr_v4i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[12:15], s[2:3], 0x54
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s11
; GFX9-NEXT:    v_mov_b32_e32 v1, s15
; GFX9-NEXT:    v_alignbit_b32 v3, s7, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s10
; GFX9-NEXT:    v_mov_b32_e32 v1, s14
; GFX9-NEXT:    v_alignbit_b32 v2, s6, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s9
; GFX9-NEXT:    v_mov_b32_e32 v1, s13
; GFX9-NEXT:    v_alignbit_b32 v1, s5, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v5, s12
; GFX9-NEXT:    v_alignbit_b32 v0, s4, v0, v5
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; R600-LABEL: fshr_v4i32:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 9, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, KC0[6].X,
; R600-NEXT:     BIT_ALIGN_INT * T0.W, KC0[4].X, KC0[5].X, PV.W,
; R600-NEXT:     MOV * T1.W, KC0[5].W,
; R600-NEXT:     BIT_ALIGN_INT * T0.Z, KC0[3].W, KC0[4].W, PV.W,
; R600-NEXT:     MOV * T1.W, KC0[5].Z,
; R600-NEXT:     BIT_ALIGN_INT * T0.Y, KC0[3].Z, KC0[4].Z, PV.W,
; R600-NEXT:     MOV * T1.W, KC0[5].Y,
; R600-NEXT:     BIT_ALIGN_INT * T0.X, KC0[3].Y, KC0[4].Y, PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: fshr_v4i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    s_load_dwordx4 s[12:15], s[2:3], 0x54
; GFX10-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x34
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v6, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s15
; GFX10-NEXT:    v_mov_b32_e32 v1, s14
; GFX10-NEXT:    v_mov_b32_e32 v4, s13
; GFX10-NEXT:    v_mov_b32_e32 v5, s12
; GFX10-NEXT:    v_alignbit_b32 v3, s7, s11, v0
; GFX10-NEXT:    v_alignbit_b32 v2, s6, s10, v1
; GFX10-NEXT:    v_alignbit_b32 v1, s5, s9, v4
; GFX10-NEXT:    v_alignbit_b32 v0, s4, s8, v5
; GFX10-NEXT:    global_store_dwordx4 v6, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fshr_v4i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b128 s[12:15], s[2:3], 0x54
; GFX11-NEXT:    s_load_b256 s[4:11], s[2:3], 0x34
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v6, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s15 :: v_dual_mov_b32 v1, s14
; GFX11-NEXT:    v_dual_mov_b32 v4, s13 :: v_dual_mov_b32 v5, s12
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_alignbit_b32 v3, s7, s11, v0
; GFX11-NEXT:    v_alignbit_b32 v2, s6, s10, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_alignbit_b32 v1, s5, s9, v4
; GFX11-NEXT:    v_alignbit_b32 v0, s4, s8, v5
; GFX11-NEXT:    global_store_b128 v6, v[0:3], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %0 = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z)
  store <4 x i32> %0, ptr addrspace(1) %in
  ret void
}

define amdgpu_kernel void @fshr_v4i32_imm(ptr addrspace(1) %in, <4 x i32> %x, <4 x i32> %y) {
; SI-LABEL: fshr_v4i32_imm:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0xd
; SI-NEXT:    s_load_dwordx2 s[12:13], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s15, 0xf000
; SI-NEXT:    s_mov_b32 s14, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    v_mov_b32_e32 v1, s10
; SI-NEXT:    v_alignbit_b32 v3, s7, v0, 1
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    v_alignbit_b32 v2, s6, v1, 9
; SI-NEXT:    v_alignbit_b32 v1, s5, v0, 7
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_alignbit_b32 v0, s4, v0, 1
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[12:15], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: fshr_v4i32_imm:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x34
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s11
; VI-NEXT:    v_mov_b32_e32 v1, s10
; VI-NEXT:    v_mov_b32_e32 v4, s9
; VI-NEXT:    v_alignbit_b32 v3, s7, v0, 1
; VI-NEXT:    v_alignbit_b32 v2, s6, v1, 9
; VI-NEXT:    v_alignbit_b32 v1, s5, v4, 7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_alignbit_b32 v0, s4, v0, 1
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fshr_v4i32_imm:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s11
; GFX9-NEXT:    v_mov_b32_e32 v1, s10
; GFX9-NEXT:    v_alignbit_b32 v3, s7, v0, 1
; GFX9-NEXT:    v_mov_b32_e32 v0, s9
; GFX9-NEXT:    v_alignbit_b32 v2, s6, v1, 9
; GFX9-NEXT:    v_alignbit_b32 v1, s5, v0, 7
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_alignbit_b32 v0, s4, v0, 1
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; R600-LABEL: fshr_v4i32_imm:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     BIT_ALIGN_INT * T0.W, KC0[4].X, KC0[5].X, 1,
; R600-NEXT:     BIT_ALIGN_INT * T0.Z, KC0[3].W, KC0[4].W, literal.x,
; R600-NEXT:    9(1.261169e-44), 0(0.000000e+00)
; R600-NEXT:     BIT_ALIGN_INT * T0.Y, KC0[3].Z, KC0[4].Z, literal.x,
; R600-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; R600-NEXT:     BIT_ALIGN_INT * T0.X, KC0[3].Y, KC0[4].Y, 1,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: fshr_v4i32_imm:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x34
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v3, s7, s11, 1
; GFX10-NEXT:    v_alignbit_b32 v2, s6, s10, 9
; GFX10-NEXT:    v_alignbit_b32 v1, s5, s9, 7
; GFX10-NEXT:    v_alignbit_b32 v0, s4, s8, 1
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: fshr_v4i32_imm:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b256 s[4:11], s[2:3], 0x34
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v3, s7, s11, 1
; GFX11-NEXT:    v_alignbit_b32 v2, s6, s10, 9
; GFX11-NEXT:    v_alignbit_b32 v1, s5, s9, 7
; GFX11-NEXT:    v_alignbit_b32 v0, s4, s8, 1
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
entry:
  %0 = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 1, i32 7, i32 9, i32 33>)
  store <4 x i32> %0, ptr addrspace(1) %in
  ret void
}

define i32 @v_fshr_i32(i32 %src0, i32 %src1, i32 %src2) {
; GFX89-LABEL: v_fshr_i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_i32:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call i32 @llvm.fshr.i32(i32 %src0, i32 %src1, i32 %src2)
  ret i32 %ret
}

define <2 x i32> @v_fshr_v2i32(<2 x i32> %src0, <2 x i32> %src1, <2 x i32> %src2) {
; GFX89-LABEL: v_fshr_v2i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; GFX89-NEXT:    v_alignbit_b32 v1, v1, v3, v5
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v2i32:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; GFX10-NEXT:    v_alignbit_b32 v1, v1, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; GFX11-NEXT:    v_alignbit_b32 v1, v1, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <2 x i32> @llvm.fshr.v2i32(<2 x i32> %src0, <2 x i32> %src1, <2 x i32> %src2)
  ret <2 x i32> %ret
}

define <3 x i32> @v_fshr_v3i32(<3 x i32> %src0, <3 x i32> %src1, <3 x i32> %src2) {
; GFX89-LABEL: v_fshr_v3i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_alignbit_b32 v0, v0, v3, v6
; GFX89-NEXT:    v_alignbit_b32 v1, v1, v4, v7
; GFX89-NEXT:    v_alignbit_b32 v2, v2, v5, v8
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v3i32:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v3i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v3, v6
; GFX10-NEXT:    v_alignbit_b32 v1, v1, v4, v7
; GFX10-NEXT:    v_alignbit_b32 v2, v2, v5, v8
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v0, v0, v3, v6
; GFX11-NEXT:    v_alignbit_b32 v1, v1, v4, v7
; GFX11-NEXT:    v_alignbit_b32 v2, v2, v5, v8
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <3 x i32> @llvm.fshr.v3i32(<3 x i32> %src0, <3 x i32> %src1, <3 x i32> %src2)
  ret <3 x i32> %ret
}

define <4 x i32> @v_fshr_v4i32(<4 x i32> %src0, <4 x i32> %src1, <4 x i32> %src2) {
; GFX89-LABEL: v_fshr_v4i32:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_alignbit_b32 v0, v0, v4, v8
; GFX89-NEXT:    v_alignbit_b32 v1, v1, v5, v9
; GFX89-NEXT:    v_alignbit_b32 v2, v2, v6, v10
; GFX89-NEXT:    v_alignbit_b32 v3, v3, v7, v11
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v4i32:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v4, v8
; GFX10-NEXT:    v_alignbit_b32 v1, v1, v5, v9
; GFX10-NEXT:    v_alignbit_b32 v2, v2, v6, v10
; GFX10-NEXT:    v_alignbit_b32 v3, v3, v7, v11
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v4i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_alignbit_b32 v0, v0, v4, v8
; GFX11-NEXT:    v_alignbit_b32 v1, v1, v5, v9
; GFX11-NEXT:    v_alignbit_b32 v2, v2, v6, v10
; GFX11-NEXT:    v_alignbit_b32 v3, v3, v7, v11
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %src0, <4 x i32> %src1, <4 x i32> %src2)
  ret <4 x i32> %ret
}

define i16 @v_fshr_i16(i16 %src0, i16 %src1, i16 %src2) {
; SI-LABEL: v_fshr_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_or_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; VI-NEXT:    v_xor_b32_e32 v3, -1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v0, v3, v0
; VI-NEXT:    v_lshrrev_b16_e32 v1, v2, v1
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, v3, v0
; GFX9-NEXT:    v_lshrrev_b16_e32 v1, v2, v1
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_i16:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b16 v0, 1, v0
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX10-NEXT:    v_lshrrev_b16 v1, v2, v1
; GFX10-NEXT:    v_lshlrev_b16 v0, v3, v0
; GFX10-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b16 v0, 1, v0
; GFX11-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX11-NEXT:    v_lshrrev_b16 v1, v2, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b16 v0, v3, v0
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call i16 @llvm.fshr.i16(i16 %src0, i16 %src1, i16 %src2)
  ret i16 %ret
}

define <2 x i16> @v_fshr_v2i16(<2 x i16> %src0, <2 x i16> %src1, <2 x i16> %src2) {
; SI-LABEL: v_fshr_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_or_b32_e32 v5, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v4, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v1, v3, v5
; SI-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v0, v3
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v4, 1
; VI-NEXT:    v_mov_b32_e32 v5, -1
; VI-NEXT:    v_lshlrev_b16_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_xor_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_lshrrev_b16_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b16_e32 v4, v5, v4
; VI-NEXT:    v_or_b32_sdwa v3, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; VI-NEXT:    v_xor_b32_e32 v4, -1, v2
; VI-NEXT:    v_lshlrev_b16_e32 v0, v4, v0
; VI-NEXT:    v_lshrrev_b16_e32 v1, v2, v1
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, 1, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_and_b32_e32 v3, 0xf000f, v3
; GFX9-NEXT:    v_and_b32_e32 v2, 0xf000f, v2
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, v3, v0
; GFX9-NEXT:    v_pk_lshrrev_b16 v1, v2, v1
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v2i16:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v2i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX10-NEXT:    v_pk_lshlrev_b16 v0, 1, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_and_b32_e32 v2, 0xf000f, v2
; GFX10-NEXT:    v_and_b32_e32 v3, 0xf000f, v3
; GFX10-NEXT:    v_pk_lshrrev_b16 v1, v2, v1
; GFX10-NEXT:    v_pk_lshlrev_b16 v0, v3, v0
; GFX10-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v2i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v3, -1, v2
; GFX11-NEXT:    v_pk_lshlrev_b16 v0, 1, v0 op_sel_hi:[0,1]
; GFX11-NEXT:    v_and_b32_e32 v2, 0xf000f, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v3, 0xf000f, v3
; GFX11-NEXT:    v_pk_lshrrev_b16 v1, v2, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_pk_lshlrev_b16 v0, v3, v0
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <2 x i16> @llvm.fshr.v2i16(<2 x i16> %src0, <2 x i16> %src1, <2 x i16> %src2)
  ret <2 x i16> %ret
}

define <3 x i16> @v_fshr_v3i16(<3 x i16> %src0, <3 x i16> %src1, <3 x i16> %src2) {
; SI-LABEL: v_fshr_v3i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_or_b32_e32 v7, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_alignbit_b32 v1, v1, v4, v7
; SI-NEXT:    v_or_b32_e32 v4, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v3, v4
; SI-NEXT:    v_or_b32_e32 v3, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_alignbit_b32 v3, v2, v4, v3
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; SI-NEXT:    v_alignbit_b32 v1, v3, v1, 16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_v3i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v7, 1
; VI-NEXT:    v_mov_b32_e32 v8, -1
; VI-NEXT:    v_lshlrev_b16_sdwa v7, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_xor_b32_sdwa v8, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_lshrrev_b16_sdwa v6, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b16_e32 v7, v8, v7
; VI-NEXT:    v_or_b32_sdwa v6, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; VI-NEXT:    v_xor_b32_e32 v7, -1, v5
; VI-NEXT:    v_lshlrev_b16_e32 v1, v7, v1
; VI-NEXT:    v_lshrrev_b16_e32 v3, v5, v3
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; VI-NEXT:    v_xor_b32_e32 v3, -1, v4
; VI-NEXT:    v_lshlrev_b16_e32 v0, v3, v0
; VI-NEXT:    v_lshrrev_b16_e32 v2, v4, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_v3i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v7, 1
; GFX9-NEXT:    v_mov_b32_e32 v8, -1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v7, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_xor_b32_sdwa v8, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b16_sdwa v6, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, v8, v7
; GFX9-NEXT:    v_or_b32_e32 v6, v7, v6
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; GFX9-NEXT:    v_xor_b32_e32 v7, -1, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, v7, v1
; GFX9-NEXT:    v_lshrrev_b16_e32 v3, v5, v3
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v4
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, v3, v0
; GFX9-NEXT:    v_lshrrev_b16_e32 v2, v4, v2
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v6, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v3i16:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v3i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX10-NEXT:    v_lshlrev_b16 v0, 1, v0
; GFX10-NEXT:    v_xor_b32_e32 v10, -1, v4
; GFX10-NEXT:    v_lshlrev_b16 v6, 1, v6
; GFX10-NEXT:    v_xor_b32_e32 v9, -1, v7
; GFX10-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX10-NEXT:    v_lshrrev_b16 v7, v7, v8
; GFX10-NEXT:    v_lshlrev_b16 v0, v10, v0
; GFX10-NEXT:    v_lshrrev_b16 v2, v4, v2
; GFX10-NEXT:    v_lshlrev_b16 v6, v9, v6
; GFX10-NEXT:    v_xor_b32_e32 v4, -1, v5
; GFX10-NEXT:    v_lshrrev_b16 v3, v5, v3
; GFX10-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX10-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX10-NEXT:    v_lshlrev_b16 v1, v4, v1
; GFX10-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX10-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v3i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX11-NEXT:    v_lshlrev_b16 v0, 1, v0
; GFX11-NEXT:    v_xor_b32_e32 v10, -1, v4
; GFX11-NEXT:    v_lshlrev_b16 v6, 1, v6
; GFX11-NEXT:    v_xor_b32_e32 v9, -1, v7
; GFX11-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX11-NEXT:    v_lshrrev_b16 v7, v7, v8
; GFX11-NEXT:    v_lshlrev_b16 v0, v10, v0
; GFX11-NEXT:    v_lshrrev_b16 v2, v4, v2
; GFX11-NEXT:    v_lshlrev_b16 v6, v9, v6
; GFX11-NEXT:    v_xor_b32_e32 v4, -1, v5
; GFX11-NEXT:    v_lshrrev_b16 v3, v5, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b16 v1, v4, v1
; GFX11-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <3 x i16> @llvm.fshr.v3i16(<3 x i16> %src0, <3 x i16> %src1, <3 x i16> %src2)
  ret <3 x i16> %ret
}

define <4 x i16> @v_fshr_v4i16(<4 x i16> %src0, <4 x i16> %src1, <4 x i16> %src2) {
; SI-LABEL: v_fshr_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_or_b32_e32 v9, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_alignbit_b32 v1, v1, v5, v9
; SI-NEXT:    v_or_b32_e32 v5, 16, v8
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_alignbit_b32 v0, v0, v4, v5
; SI-NEXT:    v_or_b32_e32 v4, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v7
; SI-NEXT:    v_alignbit_b32 v3, v3, v5, v4
; SI-NEXT:    v_or_b32_e32 v5, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_alignbit_b32 v2, v2, v6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v2, v2, v4
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v7, 1
; VI-NEXT:    v_mov_b32_e32 v9, -1
; VI-NEXT:    v_lshlrev_b16_sdwa v8, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_xor_b32_sdwa v10, v5, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_lshrrev_b16_sdwa v6, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b16_e32 v8, v10, v8
; VI-NEXT:    v_lshlrev_b16_sdwa v7, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_xor_b32_sdwa v9, v4, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v8, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_lshrrev_b16_sdwa v8, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b16_e32 v7, v9, v7
; VI-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; VI-NEXT:    v_xor_b32_e32 v8, -1, v5
; VI-NEXT:    v_lshlrev_b16_e32 v1, v8, v1
; VI-NEXT:    v_lshrrev_b16_e32 v3, v5, v3
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; VI-NEXT:    v_xor_b32_e32 v3, -1, v4
; VI-NEXT:    v_lshlrev_b16_e32 v0, v3, v0
; VI-NEXT:    v_lshrrev_b16_e32 v2, v4, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    v_or_b32_sdwa v0, v0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v7, 1
; GFX9-NEXT:    v_mov_b32_e32 v9, -1
; GFX9-NEXT:    v_lshlrev_b16_sdwa v8, v7, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_xor_b32_sdwa v10, v5, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b16_sdwa v6, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, v10, v8
; GFX9-NEXT:    v_lshlrev_b16_sdwa v7, v7, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_xor_b32_sdwa v9, v4, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v6, v8, v6
; GFX9-NEXT:    v_lshrrev_b16_sdwa v8, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_lshlrev_b16_e32 v7, v9, v7
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; GFX9-NEXT:    v_xor_b32_e32 v8, -1, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, v8, v1
; GFX9-NEXT:    v_lshrrev_b16_e32 v3, v5, v3
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 1, v0
; GFX9-NEXT:    v_xor_b32_e32 v3, -1, v4
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, v3, v0
; GFX9-NEXT:    v_lshrrev_b16_e32 v2, v4, v2
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v7, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v4i16:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v4i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX10-NEXT:    v_lshrrev_b16 v6, v7, v6
; GFX10-NEXT:    v_lshlrev_b16 v8, 1, v8
; GFX10-NEXT:    v_xor_b32_e32 v7, -1, v7
; GFX10-NEXT:    v_lshlrev_b16 v9, 1, v9
; GFX10-NEXT:    v_xor_b32_e32 v12, -1, v10
; GFX10-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX10-NEXT:    v_xor_b32_e32 v13, -1, v5
; GFX10-NEXT:    v_lshlrev_b16 v0, 1, v0
; GFX10-NEXT:    v_xor_b32_e32 v14, -1, v4
; GFX10-NEXT:    v_lshlrev_b16 v7, v7, v8
; GFX10-NEXT:    v_lshrrev_b16 v8, v10, v11
; GFX10-NEXT:    v_lshlrev_b16 v9, v12, v9
; GFX10-NEXT:    v_lshlrev_b16 v1, v13, v1
; GFX10-NEXT:    v_lshlrev_b16 v0, v14, v0
; GFX10-NEXT:    v_lshrrev_b16 v2, v4, v2
; GFX10-NEXT:    v_lshrrev_b16 v3, v5, v3
; GFX10-NEXT:    v_or_b32_e32 v4, v7, v6
; GFX10-NEXT:    v_or_b32_e32 v5, v9, v8
; GFX10-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX10-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX10-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX10-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX11-NEXT:    v_lshrrev_b16 v6, v7, v6
; GFX11-NEXT:    v_lshlrev_b16 v8, 1, v8
; GFX11-NEXT:    v_xor_b32_e32 v7, -1, v7
; GFX11-NEXT:    v_lshlrev_b16 v9, 1, v9
; GFX11-NEXT:    v_xor_b32_e32 v12, -1, v10
; GFX11-NEXT:    v_lshlrev_b16 v1, 1, v1
; GFX11-NEXT:    v_xor_b32_e32 v13, -1, v5
; GFX11-NEXT:    v_lshlrev_b16 v0, 1, v0
; GFX11-NEXT:    v_xor_b32_e32 v14, -1, v4
; GFX11-NEXT:    v_lshlrev_b16 v7, v7, v8
; GFX11-NEXT:    v_lshrrev_b16 v8, v10, v11
; GFX11-NEXT:    v_lshlrev_b16 v9, v12, v9
; GFX11-NEXT:    v_lshlrev_b16 v1, v13, v1
; GFX11-NEXT:    v_lshlrev_b16 v0, v14, v0
; GFX11-NEXT:    v_lshrrev_b16 v2, v4, v2
; GFX11-NEXT:    v_lshrrev_b16 v3, v5, v3
; GFX11-NEXT:    v_or_b32_e32 v4, v7, v6
; GFX11-NEXT:    v_or_b32_e32 v5, v9, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX11-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <4 x i16> @llvm.fshr.v4i16(<4 x i16> %src0, <4 x i16> %src1, <4 x i16> %src2)
  ret <4 x i16> %ret
}

define i64 @v_fshr_i64(i64 %src0, i64 %src1, i64 %src2) {
; SI-LABEL: v_fshr_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; SI-NEXT:    v_lshr_b64 v[2:3], v[2:3], v4
; SI-NEXT:    v_not_b32_e32 v4, v4
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], v4
; SI-NEXT:    v_or_b32_e32 v1, v1, v3
; SI-NEXT:    v_or_b32_e32 v0, v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; VI-NEXT:    v_lshrrev_b64 v[2:3], v4, v[2:3]
; VI-NEXT:    v_not_b32_e32 v4, v4
; VI-NEXT:    v_lshlrev_b64 v[0:1], v4, v[0:1]
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX9-NEXT:    v_lshrrev_b64 v[2:3], v4, v[2:3]
; GFX9-NEXT:    v_not_b32_e32 v4, v4
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], v4, v[0:1]
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_i64:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX10-NEXT:    v_not_b32_e32 v5, v4
; GFX10-NEXT:    v_lshrrev_b64 v[2:3], v4, v[2:3]
; GFX10-NEXT:    v_lshlrev_b64 v[0:1], v5, v[0:1]
; GFX10-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX10-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX11-NEXT:    v_not_b32_e32 v5, v4
; GFX11-NEXT:    v_lshrrev_b64 v[2:3], v4, v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b64 v[0:1], v5, v[0:1]
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call i64 @llvm.fshr.i64(i64 %src0, i64 %src1, i64 %src2)
  ret i64 %ret
}

define <2 x i64> @v_fshr_v2i64(<2 x i64> %src0, <2 x i64> %src1, <2 x i64> %src2) {
; SI-LABEL: v_fshr_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], 1
; SI-NEXT:    v_lshr_b64 v[4:5], v[4:5], v8
; SI-NEXT:    v_not_b32_e32 v8, v8
; SI-NEXT:    v_lshl_b64 v[0:1], v[0:1], v8
; SI-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; SI-NEXT:    v_or_b32_e32 v1, v1, v5
; SI-NEXT:    v_lshr_b64 v[5:6], v[6:7], v10
; SI-NEXT:    v_not_b32_e32 v7, v10
; SI-NEXT:    v_lshl_b64 v[2:3], v[2:3], v7
; SI-NEXT:    v_or_b32_e32 v0, v0, v4
; SI-NEXT:    v_or_b32_e32 v3, v3, v6
; SI-NEXT:    v_or_b32_e32 v2, v2, v5
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_v2i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; VI-NEXT:    v_lshrrev_b64 v[4:5], v8, v[4:5]
; VI-NEXT:    v_not_b32_e32 v8, v8
; VI-NEXT:    v_lshlrev_b64 v[0:1], v8, v[0:1]
; VI-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; VI-NEXT:    v_or_b32_e32 v1, v1, v5
; VI-NEXT:    v_lshrrev_b64 v[5:6], v10, v[6:7]
; VI-NEXT:    v_not_b32_e32 v7, v10
; VI-NEXT:    v_lshlrev_b64 v[2:3], v7, v[2:3]
; VI-NEXT:    v_or_b32_e32 v0, v0, v4
; VI-NEXT:    v_or_b32_e32 v3, v3, v6
; VI-NEXT:    v_or_b32_e32 v2, v2, v5
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX9-NEXT:    v_lshrrev_b64 v[4:5], v8, v[4:5]
; GFX9-NEXT:    v_not_b32_e32 v8, v8
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], v8, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX9-NEXT:    v_lshrrev_b64 v[5:6], v10, v[6:7]
; GFX9-NEXT:    v_not_b32_e32 v7, v10
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], v7, v[2:3]
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX9-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v2i64:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v2i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX10-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; GFX10-NEXT:    v_not_b32_e32 v9, v8
; GFX10-NEXT:    v_not_b32_e32 v11, v10
; GFX10-NEXT:    v_lshrrev_b64 v[4:5], v8, v[4:5]
; GFX10-NEXT:    v_lshrrev_b64 v[6:7], v10, v[6:7]
; GFX10-NEXT:    v_lshlrev_b64 v[0:1], v9, v[0:1]
; GFX10-NEXT:    v_lshlrev_b64 v[2:3], v11, v[2:3]
; GFX10-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX10-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX10-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX10-NEXT:    v_or_b32_e32 v3, v3, v7
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v2i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX11-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; GFX11-NEXT:    v_not_b32_e32 v9, v8
; GFX11-NEXT:    v_not_b32_e32 v11, v10
; GFX11-NEXT:    v_lshrrev_b64 v[4:5], v8, v[4:5]
; GFX11-NEXT:    v_lshrrev_b64 v[6:7], v10, v[6:7]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshlrev_b64 v[0:1], v9, v[0:1]
; GFX11-NEXT:    v_lshlrev_b64 v[2:3], v11, v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX11-NEXT:    v_or_b32_e32 v3, v3, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %src0, <2 x i64> %src1, <2 x i64> %src2)
  ret <2 x i64> %ret
}

define i24 @v_fshr_i24(i24 %src0, i24 %src1, i24 %src2) {
; SI-LABEL: v_fshr_i24:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v3, 0xffffff, v2
; SI-NEXT:    s_mov_b32 s4, 0xaaaaaab
; SI-NEXT:    v_mul_hi_u32 v3, v3, s4
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; SI-NEXT:    v_mul_u32_u24_e32 v3, 24, v3
; SI-NEXT:    v_sub_i32_e32 v2, vcc, v2, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v2
; SI-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_i24:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v3, 0xffffff, v2
; VI-NEXT:    s_mov_b32 s4, 0xaaaaaab
; VI-NEXT:    v_mul_hi_u32 v3, v3, s4
; VI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; VI-NEXT:    v_mul_u32_u24_e32 v3, 24, v3
; VI-NEXT:    v_sub_u32_e32 v2, vcc, v2, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 8, v2
; VI-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_i24:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffffff, v2
; GFX9-NEXT:    s_mov_b32 s4, 0xaaaaaab
; GFX9-NEXT:    v_mul_hi_u32 v3, v3, s4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v3, 24, v3
; GFX9-NEXT:    v_sub_u32_e32 v2, v2, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 8, v2
; GFX9-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_i24:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_i24:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffffff, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX10-NEXT:    v_mul_hi_u32 v3, 0xaaaaaab, v3
; GFX10-NEXT:    v_mul_u32_u24_e32 v3, 24, v3
; GFX10-NEXT:    v_sub_nc_u32_e32 v2, v2, v3
; GFX10-NEXT:    v_add_nc_u32_e32 v2, 8, v2
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_i24:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffffff, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_hi_u32 v3, 0xaaaaaab, v3
; GFX11-NEXT:    v_mul_u32_u24_e32 v3, 24, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_sub_nc_u32_e32 v2, v2, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 8, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_alignbit_b32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call i24 @llvm.fshr.i24(i24 %src0, i24 %src1, i24 %src2)
  ret i24 %ret
}

define <2 x i24> @v_fshr_v2i24(<2 x i24> %src0, <2 x i24> %src1, <2 x i24> %src2) {
; SI-LABEL: v_fshr_v2i24:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v6, 0xffffff, v4
; SI-NEXT:    s_mov_b32 s4, 0xaaaaaab
; SI-NEXT:    v_mul_hi_u32 v6, v6, s4
; SI-NEXT:    v_and_b32_e32 v7, 0xffffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-NEXT:    v_mul_u32_u24_e32 v6, 24, v6
; SI-NEXT:    v_sub_i32_e32 v4, vcc, v4, v6
; SI-NEXT:    v_mul_hi_u32 v6, v7, s4
; SI-NEXT:    v_add_i32_e32 v4, vcc, 8, v4
; SI-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 8, v3
; SI-NEXT:    v_mul_u32_u24_e32 v3, 24, v6
; SI-NEXT:    v_sub_i32_e32 v3, vcc, v5, v3
; SI-NEXT:    v_add_i32_e32 v3, vcc, 8, v3
; SI-NEXT:    v_alignbit_b32 v1, v1, v2, v3
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fshr_v2i24:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v6, 0xffffff, v4
; VI-NEXT:    s_mov_b32 s4, 0xaaaaaab
; VI-NEXT:    v_mul_hi_u32 v6, v6, s4
; VI-NEXT:    v_and_b32_e32 v7, 0xffffff, v5
; VI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-NEXT:    v_mul_u32_u24_e32 v6, 24, v6
; VI-NEXT:    v_sub_u32_e32 v4, vcc, v4, v6
; VI-NEXT:    v_mul_hi_u32 v6, v7, s4
; VI-NEXT:    v_add_u32_e32 v4, vcc, 8, v4
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; VI-NEXT:    v_lshlrev_b32_e32 v2, 8, v3
; VI-NEXT:    v_mul_u32_u24_e32 v3, 24, v6
; VI-NEXT:    v_sub_u32_e32 v3, vcc, v5, v3
; VI-NEXT:    v_add_u32_e32 v3, vcc, 8, v3
; VI-NEXT:    v_alignbit_b32 v1, v1, v2, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fshr_v2i24:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v6, 0xffffff, v4
; GFX9-NEXT:    s_mov_b32 s4, 0xaaaaaab
; GFX9-NEXT:    v_mul_hi_u32 v6, v6, s4
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffffff, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v6, 24, v6
; GFX9-NEXT:    v_sub_u32_e32 v4, v4, v6
; GFX9-NEXT:    v_mul_hi_u32 v6, v7, s4
; GFX9-NEXT:    v_add_u32_e32 v4, 8, v4
; GFX9-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 8, v3
; GFX9-NEXT:    v_mul_u32_u24_e32 v3, 24, v6
; GFX9-NEXT:    v_sub_u32_e32 v3, v5, v3
; GFX9-NEXT:    v_add_u32_e32 v3, 8, v3
; GFX9-NEXT:    v_alignbit_b32 v1, v1, v2, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; R600-LABEL: v_fshr_v2i24:
; R600:       ; %bb.0:
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
;
; GFX10-LABEL: v_fshr_v2i24:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffffff, v4
; GFX10-NEXT:    v_and_b32_e32 v7, 0xffffff, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX10-NEXT:    v_mul_hi_u32 v6, 0xaaaaaab, v6
; GFX10-NEXT:    v_mul_hi_u32 v7, 0xaaaaaab, v7
; GFX10-NEXT:    v_mul_u32_u24_e32 v6, 24, v6
; GFX10-NEXT:    v_mul_u32_u24_e32 v7, 24, v7
; GFX10-NEXT:    v_sub_nc_u32_e32 v4, v4, v6
; GFX10-NEXT:    v_sub_nc_u32_e32 v5, v5, v7
; GFX10-NEXT:    v_add_nc_u32_e32 v4, 8, v4
; GFX10-NEXT:    v_add_nc_u32_e32 v5, 8, v5
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; GFX10-NEXT:    v_alignbit_b32 v1, v1, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fshr_v2i24:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffffff, v4
; GFX11-NEXT:    v_and_b32_e32 v7, 0xffffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_mul_hi_u32 v6, 0xaaaaaab, v6
; GFX11-NEXT:    v_mul_hi_u32 v7, 0xaaaaaab, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mul_u32_u24_e32 v6, 24, v6
; GFX11-NEXT:    v_mul_u32_u24_e32 v7, 24, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_sub_nc_u32_e32 v4, v4, v6
; GFX11-NEXT:    v_sub_nc_u32_e32 v5, v5, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 8, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 8, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_alignbit_b32 v0, v0, v2, v4
; GFX11-NEXT:    v_alignbit_b32 v1, v1, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %ret = call <2 x i24> @llvm.fshr.v2i24(<2 x i24> %src0, <2 x i24> %src1, <2 x i24> %src2)
  ret <2 x i24> %ret
}
