; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx940 < %s | FileCheck -check-prefix=GFX940 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx90a < %s | FileCheck -check-prefix=GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx908 < %s | FileCheck -check-prefix=GFX908 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tonga < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=hawaii < %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tahiti < %s | FileCheck -check-prefix=GFX6 %s

; --------------------------------------------------------------------
; float
; --------------------------------------------------------------------

define float @buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset(ptr addrspace(7) inreg %ptr, float %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], null offen offset:1024 th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, s6
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], 0 offen offset:1024 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, s6
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], 0 offen offset:1024 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_mov_b32_e32 v3, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v5
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB0_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s18
; GFX90A-NEXT:    buffer_atomic_add_f32 v0, v1, s[8:11], 0 offen offset:1024 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v0
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v0, s18
; GFX908-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_add_i32 s6, s18, 0x400
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_mov_b32_e32 v3, s6
; GFX908-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v5, v0
; GFX908-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB0_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s6, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v5, v0
; GFX8-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB0_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s6
; GFX7-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v0
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, v4
; GFX7-NEXT:    v_mov_b32_e32 v1, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB0_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v0, s18
; GFX6-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v0
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v4
; GFX6-NEXT:    v_mov_b32_e32 v1, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB0_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, float %val syncscope("agent") seq_cst
  ret float %result
}

define void @buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset(ptr addrspace(7) inreg %ptr, float %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], null offen offset:1024
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, s6
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], 0 offen offset:1024
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, s6
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], 0 offen offset:1024
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v2, v1, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_mov_b32_e32 v3, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v4, v1
; GFX10-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB1_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s18
; GFX90A-NEXT:    buffer_atomic_add_f32 v0, v1, s[8:11], 0 offen offset:1024
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v1, s18
; GFX908-NEXT:    buffer_atomic_add_f32 v0, v1, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s18
; GFX8-NEXT:    buffer_load_dword v2, v1, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s6, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, v1
; GFX8-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB1_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s18
; GFX7-NEXT:    buffer_load_dword v2, v1, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s6
; GFX7-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX7-NEXT:    v_mov_b32_e32 v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v2
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v2, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB1_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f32__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v1, s18
; GFX6-NEXT:    buffer_load_dword v2, v1, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v2
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v2, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB1_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(7) %ptr, i32 256
  %unused = atomicrmw fadd ptr addrspace(7) %gep, float %val syncscope("agent") seq_cst
  ret void
}

define float @buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall(ptr addrspace(7) %ptr, float %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_atomic_add_f32 v5, v4, s[4:7], null offen offset:1024 th:TH_ATOMIC_RETURN
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX12-NEXT:    ; implicit-def: $vgpr4
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB2_1
; GFX12-NEXT:  ; %bb.2:
; GFX12-NEXT:    s_mov_b32 exec_lo, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, v5
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[2:3], exec
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_atomic_add_f32 v5, v4, s[4:7], 0 offen offset:1024 sc0
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX940-NEXT:    ; implicit-def: $vgpr4
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB2_1
; GFX940-NEXT:  ; %bb.2:
; GFX940-NEXT:    s_mov_b64 exec, s[2:3]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, v5
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_atomic_add_f32 v5, v4, s[4:7], 0 offen offset:1024 glc
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX11-NEXT:    ; implicit-def: $vgpr4
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB2_1
; GFX11-NEXT:  ; %bb.2:
; GFX11-NEXT:    s_mov_b32 exec_lo, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, v5
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v9, 0x400, v4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    ; implicit-def: $vgpr4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB2_1
; GFX10-NEXT:  ; %bb.2:
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:  .LBB2_3: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB2_4 Depth 2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v7, v8, v5
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v6, v7
; GFX10-NEXT:    v_mov_b32_e32 v7, v8
; GFX10-NEXT:  .LBB2_4: ; Parent Loop BB2_3 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB2_4
; GFX10-NEXT:  ; %bb.5: ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v6, v8
; GFX10-NEXT:    v_mov_b32_e32 v8, v6
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB2_3
; GFX10-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v6
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[6:7], exec
; GFX90A-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_atomic_add_f32 v5, v4, s[8:11], 0 offen offset:1024 glc
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX90A-NEXT:    ; implicit-def: $vgpr4
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB2_1
; GFX90A-NEXT:  ; %bb.2:
; GFX90A-NEXT:    s_mov_b64 exec, s[6:7]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v9, 0x400, v4
; GFX908-NEXT:    s_mov_b64 s[6:7], exec
; GFX908-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_nop 0
; GFX908-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    ; implicit-def: $vgpr4
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB2_1
; GFX908-NEXT:  ; %bb.2:
; GFX908-NEXT:    s_mov_b64 exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB2_3: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Loop Header: Depth=1
; GFX908-NEXT:    ; Child Loop BB2_4 Depth 2
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v7, v8, v5
; GFX908-NEXT:    v_mov_b32_e32 v6, v7
; GFX908-NEXT:    s_mov_b64 s[12:13], exec
; GFX908-NEXT:    v_mov_b32_e32 v7, v8
; GFX908-NEXT:  .LBB2_4: ; Parent Loop BB2_3 Depth=1
; GFX908-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB2_4
; GFX908-NEXT:  ; %bb.5: ; in Loop: Header=BB2_3 Depth=1
; GFX908-NEXT:    s_mov_b64 exec, s[12:13]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v8
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v8, v6
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB2_3
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v6
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x400, v4
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    ; implicit-def: $vgpr4
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB2_1
; GFX8-NEXT:  ; %bb.2:
; GFX8-NEXT:    s_mov_b64 exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB2_3: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Loop Header: Depth=1
; GFX8-NEXT:    ; Child Loop BB2_4 Depth 2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v7, v8, v5
; GFX8-NEXT:    v_mov_b32_e32 v6, v7
; GFX8-NEXT:    s_mov_b64 s[12:13], exec
; GFX8-NEXT:    v_mov_b32_e32 v7, v8
; GFX8-NEXT:  .LBB2_4: ; Parent Loop BB2_3 Depth=1
; GFX8-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB2_4
; GFX8-NEXT:  ; %bb.5: ; in Loop: Header=BB2_3 Depth=1
; GFX8-NEXT:    s_mov_b64 exec, s[12:13]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v8
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v8, v6
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB2_3
; GFX8-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v6
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v9, vcc, 0x400, v4
; GFX7-NEXT:    s_mov_b64 s[6:7], exec
; GFX7-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    ; implicit-def: $vgpr4
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB2_1
; GFX7-NEXT:  ; %bb.2:
; GFX7-NEXT:    s_mov_b64 exec, s[6:7]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB2_3: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Loop Header: Depth=1
; GFX7-NEXT:    ; Child Loop BB2_4 Depth 2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v7, v8, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v7
; GFX7-NEXT:    s_mov_b64 s[12:13], exec
; GFX7-NEXT:    v_mov_b32_e32 v7, v8
; GFX7-NEXT:  .LBB2_4: ; Parent Loop BB2_3 Depth=1
; GFX7-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB2_4
; GFX7-NEXT:  ; %bb.5: ; in Loop: Header=BB2_3 Depth=1
; GFX7-NEXT:    s_mov_b64 exec, s[12:13]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v8
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB2_3
; GFX7-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v0, v6
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f32__offset__waterfall:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v9, vcc, 0x400, v4
; GFX6-NEXT:    s_mov_b64 s[6:7], exec
; GFX6-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    ; implicit-def: $vgpr4
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB2_1
; GFX6-NEXT:  ; %bb.2:
; GFX6-NEXT:    s_mov_b64 exec, s[6:7]
; GFX6-NEXT:    s_mov_b64 s[6:7], 0
; GFX6-NEXT:  .LBB2_3: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Loop Header: Depth=1
; GFX6-NEXT:    ; Child Loop BB2_4 Depth 2
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v7, v8, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, v7
; GFX6-NEXT:    s_mov_b64 s[12:13], exec
; GFX6-NEXT:    v_mov_b32_e32 v7, v8
; GFX6-NEXT:  .LBB2_4: ; Parent Loop BB2_3 Depth=1
; GFX6-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB2_4
; GFX6-NEXT:  ; %bb.5: ; in Loop: Header=BB2_3 Depth=1
; GFX6-NEXT:    s_mov_b64 exec, s[12:13]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v8
; GFX6-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_execnz .LBB2_3
; GFX6-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v0, v6
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, float %val syncscope("agent") seq_cst
  ret float %result
}

; --------------------------------------------------------------------
; double
; --------------------------------------------------------------------

define double @buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset(ptr addrspace(7) inreg %ptr, double %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_mov_b32 v4, v0
; GFX12-NEXT:    v_mov_b32_e32 v0, s6
; GFX12-NEXT:    s_add_co_i32 s4, s6, 0x800
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v6, s4
; GFX12-NEXT:    s_mov_b32 s4, 0
; GFX12-NEXT:    buffer_load_b64 v[0:1], v0, s[0:3], null offen offset:2048
; GFX12-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v10, v1 :: v_dual_mov_b32 v9, v0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[7:8], v[9:10], v[4:5]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, v7 :: v_dual_mov_b32 v1, v8
; GFX12-NEXT:    v_dual_mov_b32 v2, v9 :: v_dual_mov_b32 v3, v10
; GFX12-NEXT:    buffer_atomic_cmpswap_b64 v[0:3], v6, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[9:10]
; GFX12-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX12-NEXT:    s_cbranch_execnz .LBB3_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_add_f64 v[0:1], v2, s[0:3], 0 offen offset:2048 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_mov_b32 v4, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-NEXT:    s_add_i32 s4, s6, 0x800
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v6, s4
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    buffer_load_b64 v[0:1], v0, s[0:3], 0 offen offset:2048
; GFX11-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v10, v1 :: v_dual_mov_b32 v9, v0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[7:8], v[9:10], v[4:5]
; GFX11-NEXT:    v_dual_mov_b32 v0, v7 :: v_dual_mov_b32 v1, v8
; GFX11-NEXT:    v_dual_mov_b32 v2, v9 :: v_dual_mov_b32 v3, v10
; GFX11-NEXT:    buffer_atomic_cmpswap_b64 v[0:3], v6, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[9:10]
; GFX11-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_execnz .LBB3_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    v_mov_b32_e32 v5, v1
; GFX10-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[8:11], 0 offen offset:2048
; GFX10-NEXT:    s_add_i32 s4, s18, 0x800
; GFX10-NEXT:    v_mov_b32_e32 v6, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v10, v1
; GFX10-NEXT:    v_mov_b32_e32 v9, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f64 v[7:8], v[9:10], v[4:5]
; GFX10-NEXT:    v_mov_b32_e32 v0, v7
; GFX10-NEXT:    v_mov_b32_e32 v1, v8
; GFX10-NEXT:    v_mov_b32_e32 v2, v9
; GFX10-NEXT:    v_mov_b32_e32 v3, v10
; GFX10-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v6, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[9:10]
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB3_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v2, s18
; GFX90A-NEXT:    buffer_atomic_add_f64 v[0:1], v2, s[8:11], 0 offen offset:2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v4, v0
; GFX908-NEXT:    v_mov_b32_e32 v0, s18
; GFX908-NEXT:    v_mov_b32_e32 v5, v1
; GFX908-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[8:11], 0 offen offset:2048
; GFX908-NEXT:    s_add_i32 s6, s18, 0x800
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_mov_b32_e32 v6, s6
; GFX908-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v10, v1
; GFX908-NEXT:    v_mov_b32_e32 v9, v0
; GFX908-NEXT:    v_add_f64 v[7:8], v[9:10], v[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v7
; GFX908-NEXT:    v_mov_b32_e32 v1, v8
; GFX908-NEXT:    v_mov_b32_e32 v2, v9
; GFX908-NEXT:    v_mov_b32_e32 v3, v10
; GFX908-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v6, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[9:10]
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB3_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[8:11], 0 offen offset:2048
; GFX8-NEXT:    s_add_i32 s6, s18, 0x800
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v6, s6
; GFX8-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v10, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, v0
; GFX8-NEXT:    v_add_f64 v[7:8], v[9:10], v[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v7
; GFX8-NEXT:    v_mov_b32_e32 v1, v8
; GFX8-NEXT:    v_mov_b32_e32 v2, v9
; GFX8-NEXT:    v_mov_b32_e32 v3, v10
; GFX8-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v6, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[9:10]
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB3_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v4, v0
; GFX7-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-NEXT:    v_mov_b32_e32 v5, v1
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[8:11], 0 offen offset:2048
; GFX7-NEXT:    s_add_i32 s6, s18, 0x800
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v6, s6
; GFX7-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v10, v1
; GFX7-NEXT:    v_mov_b32_e32 v9, v0
; GFX7-NEXT:    v_add_f64 v[7:8], v[9:10], v[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v7
; GFX7-NEXT:    v_mov_b32_e32 v1, v8
; GFX7-NEXT:    v_mov_b32_e32 v2, v9
; GFX7-NEXT:    v_mov_b32_e32 v3, v10
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v6, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[9:10]
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB3_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v4, v0
; GFX6-NEXT:    v_mov_b32_e32 v0, s18
; GFX6-NEXT:    v_mov_b32_e32 v5, v1
; GFX6-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[8:11], 0 offen offset:2048
; GFX6-NEXT:    s_add_i32 s6, s18, 0x800
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_mov_b32_e32 v6, s6
; GFX6-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, v1
; GFX6-NEXT:    v_mov_b32_e32 v9, v0
; GFX6-NEXT:    v_add_f64 v[7:8], v[9:10], v[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v7
; GFX6-NEXT:    v_mov_b32_e32 v1, v8
; GFX6-NEXT:    v_mov_b32_e32 v2, v9
; GFX6-NEXT:    v_mov_b32_e32 v3, v10
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v6, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[9:10]
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB3_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, double %val syncscope("agent") seq_cst
  ret double %result
}

define void @buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset(ptr addrspace(7) inreg %ptr, double %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    s_add_co_i32 s4, s6, 0x800
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v6, s4
; GFX12-NEXT:    s_mov_b32 s4, 0
; GFX12-NEXT:    buffer_load_b64 v[4:5], v2, s[0:3], null offen offset:2048
; GFX12-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[2:3], v[4:5], v[0:1]
; GFX12-NEXT:    v_dual_mov_b32 v10, v5 :: v_dual_mov_b32 v9, v4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v8, v3 :: v_dual_mov_b32 v7, v2
; GFX12-NEXT:    buffer_atomic_cmpswap_b64 v[7:10], v6, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[7:8], v[4:5]
; GFX12-NEXT:    v_dual_mov_b32 v4, v7 :: v_dual_mov_b32 v5, v8
; GFX12-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX12-NEXT:    s_cbranch_execnz .LBB4_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_add_f64 v[0:1], v2, s[0:3], 0 offen offset:2048
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, s6
; GFX11-NEXT:    s_add_i32 s4, s6, 0x800
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v6, s4
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    buffer_load_b64 v[4:5], v2, s[0:3], 0 offen offset:2048
; GFX11-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX11-NEXT:    v_dual_mov_b32 v10, v5 :: v_dual_mov_b32 v9, v4
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_dual_mov_b32 v8, v3 :: v_dual_mov_b32 v7, v2
; GFX11-NEXT:    buffer_atomic_cmpswap_b64 v[7:10], v6, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[7:8], v[4:5]
; GFX11-NEXT:    v_dual_mov_b32 v4, v7 :: v_dual_mov_b32 v5, v8
; GFX11-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_execnz .LBB4_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x800
; GFX10-NEXT:    buffer_load_dwordx2 v[4:5], v2, s[8:11], 0 offen offset:2048
; GFX10-NEXT:    v_mov_b32_e32 v6, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX10-NEXT:    v_mov_b32_e32 v10, v5
; GFX10-NEXT:    v_mov_b32_e32 v9, v4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v8, v3
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    buffer_atomic_cmpswap_x2 v[7:10], v6, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[7:8], v[4:5]
; GFX10-NEXT:    v_mov_b32_e32 v4, v7
; GFX10-NEXT:    v_mov_b32_e32 v5, v8
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB4_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v2, s18
; GFX90A-NEXT:    buffer_atomic_add_f64 v[0:1], v2, s[8:11], 0 offen offset:2048
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v2, s18
; GFX908-NEXT:    buffer_load_dwordx2 v[4:5], v2, s[8:11], 0 offen offset:2048
; GFX908-NEXT:    s_add_i32 s6, s18, 0x800
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_mov_b32_e32 v6, s6
; GFX908-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX908-NEXT:    v_mov_b32_e32 v10, v5
; GFX908-NEXT:    v_mov_b32_e32 v9, v4
; GFX908-NEXT:    v_mov_b32_e32 v8, v3
; GFX908-NEXT:    v_mov_b32_e32 v7, v2
; GFX908-NEXT:    buffer_atomic_cmpswap_x2 v[7:10], v6, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v5, v8
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB4_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s18
; GFX8-NEXT:    buffer_load_dwordx2 v[4:5], v2, s[8:11], 0 offen offset:2048
; GFX8-NEXT:    s_add_i32 s6, s18, 0x800
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v6, s6
; GFX8-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v10, v5
; GFX8-NEXT:    v_mov_b32_e32 v9, v4
; GFX8-NEXT:    v_mov_b32_e32 v8, v3
; GFX8-NEXT:    v_mov_b32_e32 v7, v2
; GFX8-NEXT:    buffer_atomic_cmpswap_x2 v[7:10], v6, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v7
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v5, v8
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB4_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-NEXT:    buffer_load_dwordx2 v[4:5], v2, s[8:11], 0 offen offset:2048
; GFX7-NEXT:    s_add_i32 s6, s18, 0x800
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v6, s6
; GFX7-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v10, v5
; GFX7-NEXT:    v_mov_b32_e32 v9, v4
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[7:10], v6, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v4, v7
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v5, v8
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB4_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f64__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    buffer_load_dwordx2 v[4:5], v2, s[8:11], 0 offen offset:2048
; GFX6-NEXT:    s_add_i32 s6, s18, 0x800
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_mov_b32_e32 v6, s6
; GFX6-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v10, v5
; GFX6-NEXT:    v_mov_b32_e32 v9, v4
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[7:10], v6, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v4, v7
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v5, v8
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB4_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(7) %ptr, i32 256
  %unused = atomicrmw fadd ptr addrspace(7) %gep, double %val syncscope("agent") seq_cst
  ret void
}

define double @buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall(ptr addrspace(7) %ptr, double %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v8, v3 :: v_dual_mov_b32 v7, v2
; GFX12-NEXT:    v_dual_mov_b32 v10, v1 :: v_dual_mov_b32 v9, v0
; GFX12-NEXT:    v_add_nc_u32_e32 v15, 0x800, v4
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_readfirstlane_b32 s4, v9
; GFX12-NEXT:    v_readfirstlane_b32 s5, v10
; GFX12-NEXT:    v_readfirstlane_b32 s6, v7
; GFX12-NEXT:    v_readfirstlane_b32 s7, v8
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[9:10]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[7:8]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_load_b64 v[13:14], v4, s[4:7], null offen offset:2048
; GFX12-NEXT:    ; implicit-def: $vgpr4
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB5_1
; GFX12-NEXT:  ; %bb.2:
; GFX12-NEXT:    s_mov_b32 exec_lo, s1
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Loop Header: Depth=1
; GFX12-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[11:12], v[13:14], v[5:6]
; GFX12-NEXT:    s_mov_b32 s2, exec_lo
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, v11 :: v_dual_mov_b32 v1, v12
; GFX12-NEXT:    v_dual_mov_b32 v2, v13 :: v_dual_mov_b32 v3, v14
; GFX12-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX12-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX12-NEXT:    v_readfirstlane_b32 s4, v9
; GFX12-NEXT:    v_readfirstlane_b32 s5, v10
; GFX12-NEXT:    v_readfirstlane_b32 s6, v7
; GFX12-NEXT:    v_readfirstlane_b32 s7, v8
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[9:10]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[7:8]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_atomic_cmpswap_b64 v[0:3], v15, s[4:7], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB5_4
; GFX12-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX12-NEXT:    s_mov_b32 exec_lo, s2
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[13:14]
; GFX12-NEXT:    v_dual_mov_b32 v14, v1 :: v_dual_mov_b32 v13, v0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB5_3
; GFX12-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v6
; GFX940-NEXT:    v_mov_b32_e32 v6, v5
; GFX940-NEXT:    s_mov_b64 s[2:3], exec
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_atomic_add_f64 v[6:7], v4, s[4:7], 0 offen offset:2048 sc0
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX940-NEXT:    ; implicit-def: $vgpr4
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB5_1
; GFX940-NEXT:  ; %bb.2:
; GFX940-NEXT:    s_mov_b64 exec, s[2:3]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v8, v3 :: v_dual_mov_b32 v7, v2
; GFX11-NEXT:    v_dual_mov_b32 v10, v1 :: v_dual_mov_b32 v9, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 0x800, v4
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_readfirstlane_b32 s4, v9
; GFX11-NEXT:    v_readfirstlane_b32 s5, v10
; GFX11-NEXT:    v_readfirstlane_b32 s6, v7
; GFX11-NEXT:    v_readfirstlane_b32 s7, v8
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[9:10]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[7:8]
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    buffer_load_b64 v[13:14], v4, s[4:7], 0 offen offset:2048
; GFX11-NEXT:    ; implicit-def: $vgpr4
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB5_1
; GFX11-NEXT:  ; %bb.2:
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Loop Header: Depth=1
; GFX11-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[11:12], v[13:14], v[5:6]
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, v11 :: v_dual_mov_b32 v1, v12
; GFX11-NEXT:    v_dual_mov_b32 v2, v13 :: v_dual_mov_b32 v3, v14
; GFX11-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX11-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX11-NEXT:    v_readfirstlane_b32 s4, v9
; GFX11-NEXT:    v_readfirstlane_b32 s5, v10
; GFX11-NEXT:    v_readfirstlane_b32 s6, v7
; GFX11-NEXT:    v_readfirstlane_b32 s7, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[9:10]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[7:8]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_atomic_cmpswap_b64 v[0:3], v15, s[4:7], 0 offen glc
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB5_4
; GFX11-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[13:14]
; GFX11-NEXT:    v_dual_mov_b32 v14, v1 :: v_dual_mov_b32 v13, v0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB5_3
; GFX11-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v8, v3
; GFX10-NEXT:    v_mov_b32_e32 v7, v2
; GFX10-NEXT:    v_mov_b32_e32 v10, v1
; GFX10-NEXT:    v_mov_b32_e32 v9, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v15, 0x800, v4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_readfirstlane_b32 s8, v9
; GFX10-NEXT:    v_readfirstlane_b32 s9, v10
; GFX10-NEXT:    v_readfirstlane_b32 s10, v7
; GFX10-NEXT:    v_readfirstlane_b32 s11, v8
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[9:10]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[7:8]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    buffer_load_dwordx2 v[13:14], v4, s[8:11], 0 offen offset:2048
; GFX10-NEXT:    ; implicit-def: $vgpr4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB5_1
; GFX10-NEXT:  ; %bb.2:
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[11:12], v[13:14], v[5:6]
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, v11
; GFX10-NEXT:    v_mov_b32_e32 v1, v12
; GFX10-NEXT:    v_mov_b32_e32 v2, v13
; GFX10-NEXT:    v_mov_b32_e32 v3, v14
; GFX10-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_readfirstlane_b32 s8, v9
; GFX10-NEXT:    v_readfirstlane_b32 s9, v10
; GFX10-NEXT:    v_readfirstlane_b32 s10, v7
; GFX10-NEXT:    v_readfirstlane_b32 s11, v8
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[9:10]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[7:8]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v15, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB5_4
; GFX10-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[13:14]
; GFX10-NEXT:    v_mov_b32_e32 v14, v1
; GFX10-NEXT:    v_mov_b32_e32 v13, v0
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB5_3
; GFX10-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v6
; GFX90A-NEXT:    v_mov_b32_e32 v6, v5
; GFX90A-NEXT:    s_mov_b64 s[6:7], exec
; GFX90A-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_atomic_add_f64 v[6:7], v4, s[8:11], 0 offen offset:2048 glc
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX90A-NEXT:    ; implicit-def: $vgpr4
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB5_1
; GFX90A-NEXT:  ; %bb.2:
; GFX90A-NEXT:    s_mov_b64 exec, s[6:7]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v8, v3
; GFX908-NEXT:    v_mov_b32_e32 v7, v2
; GFX908-NEXT:    v_mov_b32_e32 v10, v1
; GFX908-NEXT:    v_mov_b32_e32 v9, v0
; GFX908-NEXT:    v_add_u32_e32 v15, 0x800, v4
; GFX908-NEXT:    s_mov_b64 s[6:7], exec
; GFX908-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    v_readfirstlane_b32 s8, v9
; GFX908-NEXT:    v_readfirstlane_b32 s9, v10
; GFX908-NEXT:    v_readfirstlane_b32 s10, v7
; GFX908-NEXT:    v_readfirstlane_b32 s11, v8
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_nop 0
; GFX908-NEXT:    buffer_load_dwordx2 v[13:14], v4, s[8:11], 0 offen offset:2048
; GFX908-NEXT:    ; implicit-def: $vgpr4
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB5_1
; GFX908-NEXT:  ; %bb.2:
; GFX908-NEXT:    s_mov_b64 exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Loop Header: Depth=1
; GFX908-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[11:12], v[13:14], v[5:6]
; GFX908-NEXT:    s_mov_b64 s[12:13], exec
; GFX908-NEXT:    v_mov_b32_e32 v0, v11
; GFX908-NEXT:    v_mov_b32_e32 v1, v12
; GFX908-NEXT:    v_mov_b32_e32 v2, v13
; GFX908-NEXT:    v_mov_b32_e32 v3, v14
; GFX908-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX908-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX908-NEXT:    v_readfirstlane_b32 s8, v9
; GFX908-NEXT:    v_readfirstlane_b32 s9, v10
; GFX908-NEXT:    v_readfirstlane_b32 s10, v7
; GFX908-NEXT:    v_readfirstlane_b32 s11, v8
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v15, s[8:11], 0 offen glc
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB5_4
; GFX908-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX908-NEXT:    s_mov_b64 exec, s[12:13]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[13:14]
; GFX908-NEXT:    v_mov_b32_e32 v14, v1
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v13, v0
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB5_3
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v8, v3
; GFX8-NEXT:    v_mov_b32_e32 v7, v2
; GFX8-NEXT:    v_mov_b32_e32 v10, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, v0
; GFX8-NEXT:    v_add_u32_e32 v15, vcc, 0x800, v4
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_readfirstlane_b32 s8, v9
; GFX8-NEXT:    v_readfirstlane_b32 s9, v10
; GFX8-NEXT:    v_readfirstlane_b32 s10, v7
; GFX8-NEXT:    v_readfirstlane_b32 s11, v8
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_load_dwordx2 v[13:14], v4, s[8:11], 0 offen offset:2048
; GFX8-NEXT:    ; implicit-def: $vgpr4
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB5_1
; GFX8-NEXT:  ; %bb.2:
; GFX8-NEXT:    s_mov_b64 exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Loop Header: Depth=1
; GFX8-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[11:12], v[13:14], v[5:6]
; GFX8-NEXT:    s_mov_b64 s[12:13], exec
; GFX8-NEXT:    v_mov_b32_e32 v0, v11
; GFX8-NEXT:    v_mov_b32_e32 v1, v12
; GFX8-NEXT:    v_mov_b32_e32 v2, v13
; GFX8-NEXT:    v_mov_b32_e32 v3, v14
; GFX8-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX8-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX8-NEXT:    v_readfirstlane_b32 s8, v9
; GFX8-NEXT:    v_readfirstlane_b32 s9, v10
; GFX8-NEXT:    v_readfirstlane_b32 s10, v7
; GFX8-NEXT:    v_readfirstlane_b32 s11, v8
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v15, s[8:11], 0 offen glc
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB5_4
; GFX8-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX8-NEXT:    s_mov_b64 exec, s[12:13]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[13:14]
; GFX8-NEXT:    v_mov_b32_e32 v14, v1
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v13, v0
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB5_3
; GFX8-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v10, v1
; GFX7-NEXT:    v_mov_b32_e32 v9, v0
; GFX7-NEXT:    v_add_i32_e32 v15, vcc, 0x800, v4
; GFX7-NEXT:    s_mov_b64 s[6:7], exec
; GFX7-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_readfirstlane_b32 s8, v9
; GFX7-NEXT:    v_readfirstlane_b32 s9, v10
; GFX7-NEXT:    v_readfirstlane_b32 s10, v7
; GFX7-NEXT:    v_readfirstlane_b32 s11, v8
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    buffer_load_dwordx2 v[13:14], v4, s[8:11], 0 offen offset:2048
; GFX7-NEXT:    ; implicit-def: $vgpr4
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB5_1
; GFX7-NEXT:  ; %bb.2:
; GFX7-NEXT:    s_mov_b64 exec, s[6:7]
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Loop Header: Depth=1
; GFX7-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[11:12], v[13:14], v[5:6]
; GFX7-NEXT:    s_mov_b64 s[12:13], exec
; GFX7-NEXT:    v_mov_b32_e32 v0, v11
; GFX7-NEXT:    v_mov_b32_e32 v1, v12
; GFX7-NEXT:    v_mov_b32_e32 v2, v13
; GFX7-NEXT:    v_mov_b32_e32 v3, v14
; GFX7-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX7-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX7-NEXT:    v_readfirstlane_b32 s8, v9
; GFX7-NEXT:    v_readfirstlane_b32 s9, v10
; GFX7-NEXT:    v_readfirstlane_b32 s10, v7
; GFX7-NEXT:    v_readfirstlane_b32 s11, v8
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v15, s[8:11], 0 offen glc
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB5_4
; GFX7-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX7-NEXT:    s_mov_b64 exec, s[12:13]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[13:14]
; GFX7-NEXT:    v_mov_b32_e32 v14, v1
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v13, v0
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB5_3
; GFX7-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f64__offset__waterfall:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v10, v1
; GFX6-NEXT:    v_mov_b32_e32 v9, v0
; GFX6-NEXT:    v_add_i32_e32 v15, vcc, 0x800, v4
; GFX6-NEXT:    s_mov_b64 s[6:7], exec
; GFX6-NEXT:  .LBB5_1: ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_readfirstlane_b32 s8, v9
; GFX6-NEXT:    v_readfirstlane_b32 s9, v10
; GFX6-NEXT:    v_readfirstlane_b32 s10, v7
; GFX6-NEXT:    v_readfirstlane_b32 s11, v8
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    buffer_load_dwordx2 v[13:14], v4, s[8:11], 0 offen offset:2048
; GFX6-NEXT:    ; implicit-def: $vgpr4
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB5_1
; GFX6-NEXT:  ; %bb.2:
; GFX6-NEXT:    s_mov_b64 exec, s[6:7]
; GFX6-NEXT:    s_mov_b64 s[6:7], 0
; GFX6-NEXT:  .LBB5_3: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Loop Header: Depth=1
; GFX6-NEXT:    ; Child Loop BB5_4 Depth 2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f64 v[11:12], v[13:14], v[5:6]
; GFX6-NEXT:    s_mov_b64 s[12:13], exec
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v11
; GFX6-NEXT:    v_mov_b32_e32 v1, v12
; GFX6-NEXT:    v_mov_b32_e32 v2, v13
; GFX6-NEXT:    v_mov_b32_e32 v3, v14
; GFX6-NEXT:  .LBB5_4: ; Parent Loop BB5_3 Depth=1
; GFX6-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX6-NEXT:    v_readfirstlane_b32 s8, v9
; GFX6-NEXT:    v_readfirstlane_b32 s9, v10
; GFX6-NEXT:    v_readfirstlane_b32 s10, v7
; GFX6-NEXT:    v_readfirstlane_b32 s11, v8
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[9:10]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[7:8]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v15, s[8:11], 0 offen glc
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB5_4
; GFX6-NEXT:  ; %bb.5: ; in Loop: Header=BB5_3 Depth=1
; GFX6-NEXT:    s_mov_b64 exec, s[12:13]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[13:14]
; GFX6-NEXT:    v_mov_b32_e32 v14, v1
; GFX6-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v13, v0
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_execnz .LBB5_3
; GFX6-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, double %val syncscope("agent") seq_cst
  ret double %result
}

; --------------------------------------------------------------------
; half
; --------------------------------------------------------------------

define half @buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset(ptr addrspace(7) inreg %ptr, half %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_addk_co_i32 s6, 0x200
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s4, s6, -4
; GFX12-NEXT:    v_mov_b32_e32 v5, s4
; GFX12-NEXT:    s_and_b32 s4, s6, 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_lshl_b32 s4, s4, 3
; GFX12-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX12-NEXT:    buffer_load_b32 v2, v5, s[0:3], null offen
; GFX12-NEXT:    s_not_b32 s6, s5
; GFX12-NEXT:    s_mov_b32 s5, 0
; GFX12-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v1, s4, v2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, s4, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX12-NEXT:    v_dual_mov_b32 v4, v2 :: v_dual_mov_b32 v3, v1
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[3:4], v5, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX12-NEXT:    v_mov_b32_e32 v2, v3
; GFX12-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    s_cbranch_execnz .LBB6_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, s4, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_addk_i32 s6, 0x200
; GFX940-NEXT:    s_and_b32 s4, s6, -4
; GFX940-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-NEXT:    buffer_load_dword v3, v1, s[0:3], 0 offen
; GFX940-NEXT:    s_and_b32 s4, s6, 3
; GFX940-NEXT:    s_lshl_b32 s6, s4, 3
; GFX940-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX940-NEXT:    s_not_b32 s7, s4
; GFX940-NEXT:    s_mov_b64 s[4:5], 0
; GFX940-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, s6, v3
; GFX940-NEXT:    v_add_f16_e32 v2, v2, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, s6, v2
; GFX940-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX940-NEXT:    v_mov_b64_e32 v[4:5], v[2:3]
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_cmpswap v[4:5], v1, s[0:3], 0 offen sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX940-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX940-NEXT:    v_mov_b32_e32 v3, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX940-NEXT:    s_cbranch_execnz .LBB6_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, s6, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_addk_i32 s6, 0x200
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s4, s6, -4
; GFX11-NEXT:    v_mov_b32_e32 v5, s4
; GFX11-NEXT:    s_and_b32 s4, s6, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s4, s4, 3
; GFX11-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX11-NEXT:    buffer_load_b32 v2, v5, s[0:3], 0 offen
; GFX11-NEXT:    s_not_b32 s6, s5
; GFX11-NEXT:    s_mov_b32 s5, 0
; GFX11-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, s4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, s4, v1
; GFX11-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v4, v2 :: v_dual_mov_b32 v3, v1
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[3:4], v5, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v3
; GFX11-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB6_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, s4, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_addk_i32 s18, 0x200
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_and_b32 s4, s18, -4
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    v_mov_b32_e32 v5, s4
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_and_b32 s4, s18, 3
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    buffer_load_dword v2, v5, s[8:11], 0 offen
; GFX10-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX10-NEXT:    s_not_b32 s6, s5
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, s4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX10-NEXT:    v_mov_b32_e32 v4, v2
; GFX10-NEXT:    v_mov_b32_e32 v3, v1
; GFX10-NEXT:    buffer_atomic_cmpswap v[3:4], v5, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v3
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB6_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, s4, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_addk_i32 s18, 0x200
; GFX90A-NEXT:    s_and_b32 s4, s18, -4
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NEXT:    buffer_load_dword v3, v1, s[8:11], 0 offen
; GFX90A-NEXT:    s_and_b32 s4, s18, 3
; GFX90A-NEXT:    s_lshl_b32 s6, s4, 3
; GFX90A-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX90A-NEXT:    s_not_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, s6, v3
; GFX90A-NEXT:    v_add_f16_e32 v2, v2, v0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, s6, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX90A-NEXT:    v_pk_mov_b32 v[4:5], v[2:3], v[2:3] op_sel:[0,1]
; GFX90A-NEXT:    buffer_atomic_cmpswap v[4:5], v1, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB6_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, s6, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_addk_i32 s18, 0x200
; GFX908-NEXT:    s_and_b32 s4, s18, -4
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v5, s4
; GFX908-NEXT:    buffer_load_dword v2, v5, s[8:11], 0 offen
; GFX908-NEXT:    s_and_b32 s4, s18, 3
; GFX908-NEXT:    s_lshl_b32 s6, s4, 3
; GFX908-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX908-NEXT:    s_not_b32 s7, s4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v1, s6, v2
; GFX908-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX908-NEXT:    v_lshlrev_b32_e32 v1, s6, v1
; GFX908-NEXT:    v_and_or_b32 v1, v2, s7, v1
; GFX908-NEXT:    v_mov_b32_e32 v4, v2
; GFX908-NEXT:    v_mov_b32_e32 v3, v1
; GFX908-NEXT:    buffer_atomic_cmpswap v[3:4], v5, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v2, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB6_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, s6, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_addk_i32 s18, 0x200
; GFX8-NEXT:    s_and_b32 s4, s18, -4
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v5, s4
; GFX8-NEXT:    buffer_load_dword v2, v5, s[8:11], 0 offen
; GFX8-NEXT:    s_and_b32 s4, s18, 3
; GFX8-NEXT:    s_lshl_b32 s6, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX8-NEXT:    s_not_b32 s7, s4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, s6, v2
; GFX8-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX8-NEXT:    v_and_b32_e32 v3, s7, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, s6, v1
; GFX8-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    buffer_atomic_cmpswap v[3:4], v5, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB6_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s6, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_addk_i32 s18, 0x200
; GFX7-NEXT:    s_and_b32 s4, s18, -4
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    s_and_b32 s4, s18, 3
; GFX7-NEXT:    s_lshl_b32 s6, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v0
; GFX7-NEXT:    s_not_b32 s7, s4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s7, v1
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB6_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_addk_i32 s18, 0x200
; GFX6-NEXT:    s_and_b32 s4, s18, -4
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_and_b32 s4, s18, 3
; GFX6-NEXT:    s_lshl_b32 s6, s4, 3
; GFX6-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v0
; GFX6-NEXT:    s_not_b32 s7, s4
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, s7, v1
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX6-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB6_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, half %val syncscope("agent") seq_cst
  ret half %result
}

define void @buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset(ptr addrspace(7) inreg %ptr, half %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_addk_co_i32 s6, 0x200
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s4, s6, -4
; GFX12-NEXT:    v_mov_b32_e32 v3, s4
; GFX12-NEXT:    s_and_b32 s4, s6, 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_lshl_b32 s4, s4, 3
; GFX12-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX12-NEXT:    buffer_load_b32 v2, v3, s[0:3], null offen
; GFX12-NEXT:    s_not_b32 s6, s5
; GFX12-NEXT:    s_mov_b32 s5, 0
; GFX12-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v1, s4, v2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, s4, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX12-NEXT:    v_dual_mov_b32 v5, v2 :: v_dual_mov_b32 v4, v1
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v3, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX12-NEXT:    v_mov_b32_e32 v2, v4
; GFX12-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    s_cbranch_execnz .LBB7_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_addk_i32 s6, 0x200
; GFX940-NEXT:    s_and_b32 s4, s6, -4
; GFX940-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-NEXT:    buffer_load_dword v3, v1, s[0:3], 0 offen
; GFX940-NEXT:    s_and_b32 s4, s6, 3
; GFX940-NEXT:    s_lshl_b32 s6, s4, 3
; GFX940-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX940-NEXT:    s_not_b32 s7, s4
; GFX940-NEXT:    s_mov_b64 s[4:5], 0
; GFX940-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, s6, v3
; GFX940-NEXT:    v_add_f16_e32 v2, v2, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, s6, v2
; GFX940-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX940-NEXT:    v_mov_b64_e32 v[4:5], v[2:3]
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_cmpswap v[4:5], v1, s[0:3], 0 offen sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX940-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX940-NEXT:    v_mov_b32_e32 v3, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX940-NEXT:    s_cbranch_execnz .LBB7_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_addk_i32 s6, 0x200
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s4, s6, -4
; GFX11-NEXT:    v_mov_b32_e32 v3, s4
; GFX11-NEXT:    s_and_b32 s4, s6, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s4, s4, 3
; GFX11-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX11-NEXT:    buffer_load_b32 v2, v3, s[0:3], 0 offen
; GFX11-NEXT:    s_not_b32 s6, s5
; GFX11-NEXT:    s_mov_b32 s5, 0
; GFX11-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, s4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, s4, v1
; GFX11-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, v2 :: v_dual_mov_b32 v4, v1
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v3, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v4
; GFX11-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB7_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_addk_i32 s18, 0x200
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_and_b32 s4, s18, -4
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    v_mov_b32_e32 v3, s4
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_and_b32 s4, s18, 3
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    buffer_load_dword v2, v3, s[8:11], 0 offen
; GFX10-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX10-NEXT:    s_not_b32 s6, s5
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, s4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v1, v2, s6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v2
; GFX10-NEXT:    v_mov_b32_e32 v4, v1
; GFX10-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB7_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_addk_i32 s18, 0x200
; GFX90A-NEXT:    s_and_b32 s4, s18, -4
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s4
; GFX90A-NEXT:    buffer_load_dword v3, v1, s[8:11], 0 offen
; GFX90A-NEXT:    s_and_b32 s4, s18, 3
; GFX90A-NEXT:    s_lshl_b32 s6, s4, 3
; GFX90A-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX90A-NEXT:    s_not_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, s6, v3
; GFX90A-NEXT:    v_add_f16_e32 v2, v2, v0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, s6, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX90A-NEXT:    v_pk_mov_b32 v[4:5], v[2:3], v[2:3] op_sel:[0,1]
; GFX90A-NEXT:    buffer_atomic_cmpswap v[4:5], v1, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB7_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_addk_i32 s18, 0x200
; GFX908-NEXT:    s_and_b32 s4, s18, -4
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v3, s4
; GFX908-NEXT:    buffer_load_dword v2, v3, s[8:11], 0 offen
; GFX908-NEXT:    s_and_b32 s4, s18, 3
; GFX908-NEXT:    s_lshl_b32 s6, s4, 3
; GFX908-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX908-NEXT:    s_not_b32 s7, s4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v1, s6, v2
; GFX908-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX908-NEXT:    v_lshlrev_b32_e32 v1, s6, v1
; GFX908-NEXT:    v_and_or_b32 v1, v2, s7, v1
; GFX908-NEXT:    v_mov_b32_e32 v5, v2
; GFX908-NEXT:    v_mov_b32_e32 v4, v1
; GFX908-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v2
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v2, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB7_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_addk_i32 s18, 0x200
; GFX8-NEXT:    s_and_b32 s4, s18, -4
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    buffer_load_dword v2, v3, s[8:11], 0 offen
; GFX8-NEXT:    s_and_b32 s4, s18, 3
; GFX8-NEXT:    s_lshl_b32 s6, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX8-NEXT:    s_not_b32 s7, s4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, s6, v2
; GFX8-NEXT:    v_add_f16_e32 v1, v1, v0
; GFX8-NEXT:    v_and_b32_e32 v4, s7, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, s6, v1
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, v1
; GFX8-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB7_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_addk_i32 s18, 0x200
; GFX7-NEXT:    s_and_b32 s4, s18, -4
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    s_and_b32 s4, s18, 3
; GFX7-NEXT:    s_lshl_b32 s6, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX7-NEXT:    s_not_b32 s7, s4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s7, v1
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_mov_b32_e32 v5, v1
; GFX7-NEXT:    v_mov_b32_e32 v4, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB7_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_addk_i32 s18, 0x200
; GFX6-NEXT:    s_and_b32 s4, s18, -4
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_and_b32 s4, s18, 3
; GFX6-NEXT:    s_lshl_b32 s6, s4, 3
; GFX6-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX6-NEXT:    s_not_b32 s7, s4
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, s7, v1
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX6-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX6-NEXT:    v_mov_b32_e32 v5, v1
; GFX6-NEXT:    v_mov_b32_e32 v4, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB7_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(7) %ptr, i32 256
  %unused = atomicrmw fadd ptr addrspace(7) %gep, half %val syncscope("agent") seq_cst
  ret void
}

define half @buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall(ptr addrspace(7) %ptr, half %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v6, 0x200, v4
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v6
; GFX12-NEXT:    v_and_b32_e32 v10, -4, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e64 v7, v4, 0xffff
; GFX12-NEXT:    v_not_b32_e32 v11, v7
; GFX12-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_load_b32 v7, v10, s[4:7], null offen
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB8_1
; GFX12-NEXT:  ; %bb.2:
; GFX12-NEXT:    s_mov_b32 exec_lo, s1
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Loop Header: Depth=1
; GFX12-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX12-NEXT:    s_mov_b32 s2, exec_lo
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, v4, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v6, v7, v11, v6
; GFX12-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX12-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX12-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[8:9], v10, s[4:7], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB8_4
; GFX12-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX12-NEXT:    s_mov_b32 exec_lo, s2
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v8, v7
; GFX12-NEXT:    v_mov_b32_e32 v7, v8
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB8_3
; GFX12-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v4, 0x200, v4
; GFX940-NEXT:    v_and_b32_e32 v10, -4, v4
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v6, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v11, v6
; GFX940-NEXT:    s_mov_b64 s[2:3], exec
; GFX940-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    buffer_load_dword v7, v10, s[4:7], 0 offen
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB8_1
; GFX940-NEXT:  ; %bb.2:
; GFX940-NEXT:    s_mov_b64 exec, s[2:3]
; GFX940-NEXT:    s_mov_b64 s[2:3], 0
; GFX940-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Loop Header: Depth=1
; GFX940-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX940-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, v4, v6
; GFX940-NEXT:    v_and_or_b32 v6, v7, v11, v6
; GFX940-NEXT:    s_mov_b64 s[8:9], exec
; GFX940-NEXT:    v_mov_b64_e32 v[8:9], v[6:7]
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX940-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_atomic_cmpswap v[8:9], v10, s[4:7], 0 offen sc0
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB8_4
; GFX940-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX940-NEXT:    s_mov_b64 exec, s[8:9]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX940-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX940-NEXT:    v_mov_b32_e32 v7, v8
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX940-NEXT:    s_cbranch_execnz .LBB8_3
; GFX940-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x200, v4
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v6
; GFX11-NEXT:    v_and_b32_e32 v10, -4, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e64 v7, v4, 0xffff
; GFX11-NEXT:    v_not_b32_e32 v11, v7
; GFX11-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    buffer_load_b32 v7, v10, s[4:7], 0 offen
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB8_1
; GFX11-NEXT:  ; %bb.2:
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Loop Header: Depth=1
; GFX11-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, v4, v6
; GFX11-NEXT:    v_and_or_b32 v6, v7, v11, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX11-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX11-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[8:9], v10, s[4:7], 0 offen glc
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB8_4
; GFX11-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v8, v7
; GFX11-NEXT:    v_mov_b32_e32 v7, v8
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB8_3
; GFX11-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v6, 0x200, v4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v6
; GFX10-NEXT:    v_and_b32_e32 v10, -4, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v7, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v11, v7
; GFX10-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    buffer_load_dword v7, v10, s[8:11], 0 offen
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB8_1
; GFX10-NEXT:  ; %bb.2:
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, v4, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v6, v7, v11, v6
; GFX10-NEXT:    v_mov_b32_e32 v9, v7
; GFX10-NEXT:    v_mov_b32_e32 v8, v6
; GFX10-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_atomic_cmpswap v[8:9], v10, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB8_4
; GFX10-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v8, v7
; GFX10-NEXT:    v_mov_b32_e32 v7, v8
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB8_3
; GFX10-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v4, 0x200, v4
; GFX90A-NEXT:    v_and_b32_e32 v10, -4, v4
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v6, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v11, v6
; GFX90A-NEXT:    s_mov_b64 s[6:7], exec
; GFX90A-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_nop 0
; GFX90A-NEXT:    buffer_load_dword v7, v10, s[8:11], 0 offen
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB8_1
; GFX90A-NEXT:  ; %bb.2:
; GFX90A-NEXT:    s_mov_b64 exec, s[6:7]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Loop Header: Depth=1
; GFX90A-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX90A-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, v4, v6
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v11, v6
; GFX90A-NEXT:    s_mov_b64 s[12:13], exec
; GFX90A-NEXT:    v_pk_mov_b32 v[8:9], v[6:7], v[6:7] op_sel:[0,1]
; GFX90A-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX90A-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_atomic_cmpswap v[8:9], v10, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB8_4
; GFX90A-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX90A-NEXT:    s_mov_b64 exec, s[12:13]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v7, v8
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB8_3
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v4, 0x200, v4
; GFX908-NEXT:    v_and_b32_e32 v10, -4, v4
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v6, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v11, v6
; GFX908-NEXT:    s_mov_b64 s[6:7], exec
; GFX908-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_nop 0
; GFX908-NEXT:    buffer_load_dword v7, v10, s[8:11], 0 offen
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB8_1
; GFX908-NEXT:  ; %bb.2:
; GFX908-NEXT:    s_mov_b64 exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Loop Header: Depth=1
; GFX908-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX908-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, v4, v6
; GFX908-NEXT:    v_and_or_b32 v6, v7, v11, v6
; GFX908-NEXT:    v_mov_b32_e32 v9, v7
; GFX908-NEXT:    s_mov_b64 s[12:13], exec
; GFX908-NEXT:    v_mov_b32_e32 v8, v6
; GFX908-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX908-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_atomic_cmpswap v[8:9], v10, s[8:11], 0 offen glc
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB8_4
; GFX908-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX908-NEXT:    s_mov_b64 exec, s[12:13]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v8
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB8_3
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x200, v4
; GFX8-NEXT:    v_and_b32_e32 v10, -4, v4
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v6, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v11, v6
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_load_dword v7, v10, s[8:11], 0 offen
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB8_1
; GFX8-NEXT:  ; %bb.2:
; GFX8-NEXT:    s_mov_b64 exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Loop Header: Depth=1
; GFX8-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, v4, v7
; GFX8-NEXT:    v_add_f16_e32 v6, v6, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, v4, v6
; GFX8-NEXT:    v_and_b32_e32 v8, v7, v11
; GFX8-NEXT:    v_or_b32_e32 v6, v8, v6
; GFX8-NEXT:    v_mov_b32_e32 v9, v7
; GFX8-NEXT:    s_mov_b64 s[12:13], exec
; GFX8-NEXT:    v_mov_b32_e32 v8, v6
; GFX8-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX8-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_atomic_cmpswap v[8:9], v10, s[8:11], 0 offen glc
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB8_4
; GFX8-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX8-NEXT:    s_mov_b64 exec, s[12:13]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v8
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB8_3
; GFX8-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v4, v8
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x200, v4
; GFX7-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v7
; GFX7-NEXT:    v_not_b32_e32 v9, v4
; GFX7-NEXT:    s_mov_b64 s[6:7], exec
; GFX7-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB8_1
; GFX7-NEXT:  ; %bb.2:
; GFX7-NEXT:    s_mov_b64 exec, s[6:7]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v5
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v10, v4
; GFX7-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Loop Header: Depth=1
; GFX7-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, v7, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v6, v9
; GFX7-NEXT:    s_mov_b64 s[12:13], exec
; GFX7-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, v7, v4
; GFX7-NEXT:    v_or_b32_e32 v5, v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    v_mov_b32_e32 v5, v6
; GFX7-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX7-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB8_4
; GFX7-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX7-NEXT:    s_mov_b64 exec, s[12:13]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB8_3
; GFX7-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_f16__offset__waterfall:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x200, v4
; GFX6-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v4, 0xffff, v7
; GFX6-NEXT:    v_not_b32_e32 v9, v4
; GFX6-NEXT:    s_mov_b64 s[6:7], exec
; GFX6-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB8_1
; GFX6-NEXT:  ; %bb.2:
; GFX6-NEXT:    s_mov_b64 exec, s[6:7]
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v5
; GFX6-NEXT:    s_mov_b64 s[6:7], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v10, v4
; GFX6-NEXT:  .LBB8_3: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Loop Header: Depth=1
; GFX6-NEXT:    ; Child Loop BB8_4 Depth 2
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, v7, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_and_b32_e32 v5, v6, v9
; GFX6-NEXT:    s_mov_b64 s[12:13], exec
; GFX6-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v7, v4
; GFX6-NEXT:    v_or_b32_e32 v5, v5, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    v_mov_b32_e32 v5, v6
; GFX6-NEXT:  .LBB8_4: ; Parent Loop BB8_3 Depth=1
; GFX6-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB8_4
; GFX6-NEXT:  ; %bb.5: ; in Loop: Header=BB8_3 Depth=1
; GFX6-NEXT:    s_mov_b64 exec, s[12:13]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX6-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_execnz .LBB8_3
; GFX6-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, half %val syncscope("agent") seq_cst
  ret half %result
}

; --------------------------------------------------------------------
; bfloat
; --------------------------------------------------------------------

define bfloat @buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset(ptr addrspace(7) inreg %ptr, bfloat %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_addk_co_i32 s6, 0x200
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX12-NEXT:    s_and_b32 s4, s6, -4
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v4, s4
; GFX12-NEXT:    s_and_b32 s4, s6, 3
; GFX12-NEXT:    s_lshl_b32 s4, s4, 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX12-NEXT:    buffer_load_b32 v1, v4, s[0:3], null offen
; GFX12-NEXT:    s_not_b32 s6, s5
; GFX12-NEXT:    s_mov_b32 s5, 0
; GFX12-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, s4, v1
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX12-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v0, v1, s6, v0
; GFX12-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], v4, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX12-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    s_cbranch_execnz .LBB9_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, s4, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_addk_i32 s6, 0x200
; GFX940-NEXT:    s_and_b32 s4, s6, -4
; GFX940-NEXT:    v_mov_b32_e32 v4, s4
; GFX940-NEXT:    buffer_load_dword v1, v4, s[0:3], 0 offen
; GFX940-NEXT:    s_and_b32 s4, s6, 3
; GFX940-NEXT:    s_lshl_b32 s6, s4, 3
; GFX940-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX940-NEXT:    s_not_b32 s7, s4
; GFX940-NEXT:    s_mov_b64 s[4:5], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX940-NEXT:    s_movk_i32 s8, 0x7fff
; GFX940-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v0, s6, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX940-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX940-NEXT:    v_add3_u32 v2, v2, v0, s8
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v0, v1, s7, v0
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], v[0:1]
; GFX940-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[0:3], 0 offen sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX940-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX940-NEXT:    v_mov_b32_e32 v1, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX940-NEXT:    s_cbranch_execnz .LBB9_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_addk_i32 s6, 0x200
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX11-NEXT:    s_and_b32 s4, s6, -4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v4, s4
; GFX11-NEXT:    s_and_b32 s4, s6, 3
; GFX11-NEXT:    s_lshl_b32 s4, s4, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX11-NEXT:    buffer_load_b32 v1, v4, s[0:3], 0 offen
; GFX11-NEXT:    s_not_b32 s6, s5
; GFX11-NEXT:    s_mov_b32 s5, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, s4, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX11-NEXT:    v_and_or_b32 v0, v1, s6, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], v4, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB9_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, s4, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_addk_i32 s18, 0x200
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_and_b32 s4, s18, -4
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_and_b32 s4, s18, 3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX10-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX10-NEXT:    s_not_b32 s6, s5
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v0, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX10-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX10-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v0, v1, s6, v0
; GFX10-NEXT:    v_mov_b32_e32 v3, v1
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB9_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, s4, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_addk_i32 s18, 0x200
; GFX90A-NEXT:    s_and_b32 s4, s18, -4
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v4, s4
; GFX90A-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX90A-NEXT:    s_and_b32 s4, s18, 3
; GFX90A-NEXT:    s_lshl_b32 s6, s4, 3
; GFX90A-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX90A-NEXT:    s_not_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX90A-NEXT:    s_movk_i32 s12, 0x7fff
; GFX90A-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v0, s6, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX90A-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX90A-NEXT:    v_add3_u32 v2, v2, v0, s12
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v0, v1, s7, v0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[0,1]
; GFX90A-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB9_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_addk_i32 s18, 0x200
; GFX908-NEXT:    s_and_b32 s4, s18, -4
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v4, s4
; GFX908-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX908-NEXT:    s_and_b32 s4, s18, 3
; GFX908-NEXT:    s_lshl_b32 s6, s4, 3
; GFX908-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX908-NEXT:    s_not_b32 s7, s4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX908-NEXT:    s_movk_i32 s12, 0x7fff
; GFX908-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v0, s6, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX908-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX908-NEXT:    v_add3_u32 v2, v2, v0, s12
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX908-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v0, v1, s7, v0
; GFX908-NEXT:    v_mov_b32_e32 v3, v1
; GFX908-NEXT:    v_mov_b32_e32 v2, v0
; GFX908-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v1, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB9_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_addk_i32 s18, 0x200
; GFX8-NEXT:    s_and_b32 s4, s18, -4
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX8-NEXT:    s_and_b32 s4, s18, 3
; GFX8-NEXT:    s_lshl_b32 s6, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX8-NEXT:    s_not_b32 s7, s4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v3
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v6, v7, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, s7, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB9_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_addk_i32 s18, 0x200
; GFX7-NEXT:    s_and_b32 s4, s18, -4
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX7-NEXT:    s_and_b32 s4, s18, 3
; GFX7-NEXT:    s_lshl_b32 s6, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    s_not_b32 s7, s4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX7-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v2, s7, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_mov_b32_e32 v3, v1
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB9_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_addk_i32 s18, 0x200
; GFX6-NEXT:    s_and_b32 s4, s18, -4
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v4, s4
; GFX6-NEXT:    buffer_load_dword v1, v4, s[8:11], 0 offen
; GFX6-NEXT:    s_and_b32 s4, s18, 3
; GFX6-NEXT:    s_lshl_b32 s6, s4, 3
; GFX6-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    s_not_b32 s7, s4
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX6-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, s7, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX6-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[2:3], v4, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB9_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, s6, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, bfloat %val syncscope("agent") seq_cst
  ret bfloat %result
}

define void @buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset(ptr addrspace(7) inreg %ptr, bfloat %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_addk_co_i32 s6, 0x200
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-NEXT:    s_and_b32 s4, s6, -4
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v2, s4
; GFX12-NEXT:    s_and_b32 s4, s6, 3
; GFX12-NEXT:    s_lshl_b32 s4, s4, 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX12-NEXT:    buffer_load_b32 v1, v2, s[0:3], null offen
; GFX12-NEXT:    s_not_b32 s6, s5
; GFX12-NEXT:    s_mov_b32 s5, 0
; GFX12-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, s4, v1
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX12-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v4, v4, v0, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v0, v1, s6, v0
; GFX12-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_mov_b32 v4, v0
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v2, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v1
; GFX12-NEXT:    v_mov_b32_e32 v1, v4
; GFX12-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    s_cbranch_execnz .LBB10_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_addk_i32 s6, 0x200
; GFX940-NEXT:    s_and_b32 s4, s6, -4
; GFX940-NEXT:    v_mov_b32_e32 v2, s4
; GFX940-NEXT:    buffer_load_dword v1, v2, s[0:3], 0 offen
; GFX940-NEXT:    s_and_b32 s4, s6, 3
; GFX940-NEXT:    s_lshl_b32 s6, s4, 3
; GFX940-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX940-NEXT:    s_not_b32 s7, s4
; GFX940-NEXT:    s_mov_b64 s[4:5], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX940-NEXT:    s_movk_i32 s8, 0x7fff
; GFX940-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v0, s6, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX940-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX940-NEXT:    v_add3_u32 v4, v4, v0, s8
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v0, v1, s7, v0
; GFX940-NEXT:    v_mov_b64_e32 v[4:5], v[0:1]
; GFX940-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[0:3], 0 offen sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX940-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX940-NEXT:    v_mov_b32_e32 v1, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX940-NEXT:    s_cbranch_execnz .LBB10_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_addk_i32 s6, 0x200
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    s_and_b32 s4, s6, -4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v2, s4
; GFX11-NEXT:    s_and_b32 s4, s6, 3
; GFX11-NEXT:    s_lshl_b32 s4, s4, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX11-NEXT:    buffer_load_b32 v1, v2, s[0:3], 0 offen
; GFX11-NEXT:    s_not_b32 s6, s5
; GFX11-NEXT:    s_mov_b32 s5, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, s4, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_add3_u32 v4, v4, v0, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, s4, v0
; GFX11-NEXT:    v_and_or_b32 v0, v1, s6, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, v1 :: v_dual_mov_b32 v4, v0
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v2, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB10_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_addk_i32 s18, 0x200
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_and_b32 s4, s18, -4
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_and_b32 s4, s18, 3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX10-NEXT:    s_lshl_b32 s4, s4, 3
; GFX10-NEXT:    s_lshl_b32 s5, 0xffff, s4
; GFX10-NEXT:    s_not_b32 s6, s5
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v0, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX10-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX10-NEXT:    v_add3_u32 v4, v4, v0, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v0, v1, s6, v0
; GFX10-NEXT:    v_mov_b32_e32 v5, v1
; GFX10-NEXT:    v_mov_b32_e32 v4, v0
; GFX10-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, v4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB10_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_addk_i32 s18, 0x200
; GFX90A-NEXT:    s_and_b32 s4, s18, -4
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v2, s4
; GFX90A-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX90A-NEXT:    s_and_b32 s4, s18, 3
; GFX90A-NEXT:    s_lshl_b32 s6, s4, 3
; GFX90A-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX90A-NEXT:    s_not_b32 s7, s4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX90A-NEXT:    s_movk_i32 s12, 0x7fff
; GFX90A-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v0, s6, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX90A-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX90A-NEXT:    v_add3_u32 v4, v4, v0, s12
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX90A-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v0, v1, s7, v0
; GFX90A-NEXT:    v_pk_mov_b32 v[4:5], v[0:1], v[0:1] op_sel:[0,1]
; GFX90A-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB10_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_addk_i32 s18, 0x200
; GFX908-NEXT:    s_and_b32 s4, s18, -4
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v2, s4
; GFX908-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX908-NEXT:    s_and_b32 s4, s18, 3
; GFX908-NEXT:    s_lshl_b32 s6, s4, 3
; GFX908-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX908-NEXT:    s_not_b32 s7, s4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX908-NEXT:    s_movk_i32 s12, 0x7fff
; GFX908-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v0, s6, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX908-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX908-NEXT:    v_add3_u32 v4, v4, v0, s12
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX908-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v0, s6, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v0, v1, s7, v0
; GFX908-NEXT:    v_mov_b32_e32 v5, v1
; GFX908-NEXT:    v_mov_b32_e32 v4, v0
; GFX908-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v1, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB10_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_addk_i32 s18, 0x200
; GFX8-NEXT:    s_and_b32 s4, s18, -4
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX8-NEXT:    s_and_b32 s4, s18, 3
; GFX8-NEXT:    s_lshl_b32 s6, s4, 3
; GFX8-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX8-NEXT:    s_not_b32 s7, s4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX8-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v5
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc
; GFX8-NEXT:    v_and_b32_e32 v4, s7, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v1, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB10_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_addk_i32 s18, 0x200
; GFX7-NEXT:    s_and_b32 s4, s18, -4
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX7-NEXT:    s_and_b32 s4, s18, 3
; GFX7-NEXT:    s_lshl_b32 s6, s4, 3
; GFX7-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    s_not_b32 s7, s4
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX7-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s7, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_mov_b32_e32 v5, v1
; GFX7-NEXT:    v_mov_b32_e32 v4, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB10_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_addk_i32 s18, 0x200
; GFX6-NEXT:    s_and_b32 s4, s18, -4
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    buffer_load_dword v1, v2, s[8:11], 0 offen
; GFX6-NEXT:    s_and_b32 s4, s18, 3
; GFX6-NEXT:    s_lshl_b32 s6, s4, 3
; GFX6-NEXT:    s_lshl_b32 s4, 0xffff, s6
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    s_not_b32 s7, s4
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX6-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, s6, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, s7, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, s6, v0
; GFX6-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX6-NEXT:    v_mov_b32_e32 v5, v1
; GFX6-NEXT:    v_mov_b32_e32 v4, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v2, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB10_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(7) %ptr, i32 256
  %unused = atomicrmw fadd ptr addrspace(7) %gep, bfloat %val syncscope("agent") seq_cst
  ret void
}

define bfloat @buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall(ptr addrspace(7) %ptr, bfloat %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v4, 0x200, v4
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_and_b32_e32 v6, 3, v4
; GFX12-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX12-NEXT:    v_lshlrev_b32_e32 v7, 3, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e64 v6, v7, 0xffff
; GFX12-NEXT:    v_not_b32_e32 v9, v6
; GFX12-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_load_b32 v6, v8, s[4:7], null offen
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB11_1
; GFX12-NEXT:  ; %bb.2:
; GFX12-NEXT:    s_mov_b32 exec_lo, s1
; GFX12-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX12-NEXT:    s_mov_b32 s1, 0
; GFX12-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Loop Header: Depth=1
; GFX12-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, v7, v6
; GFX12-NEXT:    s_mov_b32 s2, exec_lo
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX12-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v4, v5, v11, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, v7, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v9, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v5
; GFX12-NEXT:    v_mov_b32_e32 v5, v6
; GFX12-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX12-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v8, s[4:7], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB11_4
; GFX12-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX12-NEXT:    s_mov_b32 exec_lo, s2
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v6
; GFX12-NEXT:    v_mov_b32_e32 v6, v4
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    s_cbranch_execnz .LBB11_3
; GFX12-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v4, 0x200, v4
; GFX940-NEXT:    v_and_b32_e32 v9, -4, v4
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v8, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v8, s0
; GFX940-NEXT:    v_not_b32_e32 v10, v4
; GFX940-NEXT:    s_mov_b64 s[2:3], exec
; GFX940-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    buffer_load_dword v7, v9, s[4:7], 0 offen
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB11_1
; GFX940-NEXT:  ; %bb.2:
; GFX940-NEXT:    s_mov_b64 exec, s[2:3]
; GFX940-NEXT:    s_mov_b64 s[2:3], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX940-NEXT:    s_movk_i32 s10, 0x7fff
; GFX940-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Loop Header: Depth=1
; GFX940-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v4, v8, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_mov_b64 s[8:9], exec
; GFX940-NEXT:    v_add_f32_e32 v4, v4, v11
; GFX940-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX940-NEXT:    v_add3_u32 v5, v5, v4, s10
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v4, v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v10, v4
; GFX940-NEXT:    v_mov_b64_e32 v[4:5], v[6:7]
; GFX940-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX940-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_atomic_cmpswap v[4:5], v9, s[4:7], 0 offen sc0
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB11_4
; GFX940-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX940-NEXT:    s_mov_b64 exec, s[8:9]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX940-NEXT:    s_cbranch_execnz .LBB11_3
; GFX940-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v8, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x200, v4
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v6, 3, v4
; GFX11-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 3, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e64 v6, v7, 0xffff
; GFX11-NEXT:    v_not_b32_e32 v9, v6
; GFX11-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    buffer_load_b32 v6, v8, s[4:7], 0 offen
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB11_1
; GFX11-NEXT:  ; %bb.2:
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Loop Header: Depth=1
; GFX11-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, v7, v6
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v5, v11, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, v7, v4
; GFX11-NEXT:    v_and_or_b32 v5, v6, v9, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v4, v5
; GFX11-NEXT:    v_mov_b32_e32 v5, v6
; GFX11-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX11-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v8, s[4:7], 0 offen glc
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB11_4
; GFX11-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v6
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB11_3
; GFX11-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v4, 0x200, v4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    v_and_b32_e32 v6, 3, v4
; GFX10-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 3, v6
; GFX10-NEXT:    v_lshlrev_b32_e64 v6, v7, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v9, v6
; GFX10-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB11_1
; GFX10-NEXT:  ; %bb.2:
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX10-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v4, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX10-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_add3_u32 v5, v5, v4, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v11, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v9, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v5
; GFX10-NEXT:    v_mov_b32_e32 v5, v6
; GFX10-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB11_4
; GFX10-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v6
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB11_3
; GFX10-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v4, 0x200, v4
; GFX90A-NEXT:    v_and_b32_e32 v9, -4, v4
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v8, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v8, s4
; GFX90A-NEXT:    v_not_b32_e32 v10, v4
; GFX90A-NEXT:    s_mov_b64 s[6:7], exec
; GFX90A-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_nop 0
; GFX90A-NEXT:    buffer_load_dword v7, v9, s[8:11], 0 offen
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB11_1
; GFX90A-NEXT:  ; %bb.2:
; GFX90A-NEXT:    s_mov_b64 exec, s[6:7]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX90A-NEXT:    s_movk_i32 s14, 0x7fff
; GFX90A-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Loop Header: Depth=1
; GFX90A-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v4, v8, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v4, v4, v11
; GFX90A-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX90A-NEXT:    v_add3_u32 v5, v5, v4, s14
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v4, v8, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v10, v4
; GFX90A-NEXT:    s_mov_b64 s[12:13], exec
; GFX90A-NEXT:    v_pk_mov_b32 v[4:5], v[6:7], v[6:7] op_sel:[0,1]
; GFX90A-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX90A-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_atomic_cmpswap v[4:5], v9, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB11_4
; GFX90A-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX90A-NEXT:    s_mov_b64 exec, s[12:13]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB11_3
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v8, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v4, 0x200, v4
; GFX908-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v7, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v7, s4
; GFX908-NEXT:    v_not_b32_e32 v9, v4
; GFX908-NEXT:    s_mov_b64 s[6:7], exec
; GFX908-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_nop 0
; GFX908-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB11_1
; GFX908-NEXT:  ; %bb.2:
; GFX908-NEXT:    s_mov_b64 exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX908-NEXT:    s_movk_i32 s14, 0x7fff
; GFX908-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Loop Header: Depth=1
; GFX908-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v4, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX908-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX908-NEXT:    v_add3_u32 v5, v5, v4, s14
; GFX908-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX908-NEXT:    v_cndmask_b32_e32 v4, v5, v11, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v4, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v9, v4
; GFX908-NEXT:    v_mov_b32_e32 v4, v5
; GFX908-NEXT:    s_mov_b64 s[12:13], exec
; GFX908-NEXT:    v_mov_b32_e32 v5, v6
; GFX908-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX908-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB11_4
; GFX908-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX908-NEXT:    s_mov_b64 exec, s[12:13]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB11_3
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x200, v4
; GFX8-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v7, s4
; GFX8-NEXT:    v_not_b32_e32 v9, v4
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB11_1
; GFX8-NEXT:  ; %bb.2:
; GFX8-NEXT:    s_mov_b64 exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX8-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Loop Header: Depth=1
; GFX8-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v4, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX8-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v4
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; GFX8-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v11, vcc
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v7, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_and_b32_e32 v5, v6, v9
; GFX8-NEXT:    v_or_b32_e32 v5, v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, v5
; GFX8-NEXT:    s_mov_b64 s[12:13], exec
; GFX8-NEXT:    v_mov_b32_e32 v5, v6
; GFX8-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX8-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB11_4
; GFX8-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX8-NEXT:    s_mov_b64 exec, s[12:13]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB11_3
; GFX8-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x200, v4
; GFX7-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v7
; GFX7-NEXT:    v_not_b32_e32 v9, v4
; GFX7-NEXT:    s_mov_b64 s[6:7], exec
; GFX7-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB11_1
; GFX7-NEXT:  ; %bb.2:
; GFX7-NEXT:    s_mov_b64 exec, s[6:7]
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v5
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v4
; GFX7-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Loop Header: Depth=1
; GFX7-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, v7, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, v7, v4
; GFX7-NEXT:    v_and_b32_e32 v5, v6, v9
; GFX7-NEXT:    v_or_b32_e32 v5, v5, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_mov_b64 s[12:13], exec
; GFX7-NEXT:    v_mov_b32_e32 v5, v6
; GFX7-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX7-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB11_4
; GFX7-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX7-NEXT:    s_mov_b64 exec, s[12:13]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB11_3
; GFX7-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_bf16__offset__waterfall:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x200, v4
; GFX6-NEXT:    v_and_b32_e32 v8, -4, v4
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v4, 0xffff, v7
; GFX6-NEXT:    v_not_b32_e32 v9, v4
; GFX6-NEXT:    s_mov_b64 s[6:7], exec
; GFX6-NEXT:  .LBB11_1: ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    buffer_load_dword v6, v8, s[8:11], 0 offen
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB11_1
; GFX6-NEXT:  ; %bb.2:
; GFX6-NEXT:    s_mov_b64 exec, s[6:7]
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v5
; GFX6-NEXT:    s_mov_b64 s[6:7], 0
; GFX6-NEXT:    v_and_b32_e32 v10, 0xffff0000, v4
; GFX6-NEXT:  .LBB11_3: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Loop Header: Depth=1
; GFX6-NEXT:    ; Child Loop BB11_4 Depth 2
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, v7, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, v7, v4
; GFX6-NEXT:    v_and_b32_e32 v5, v6, v9
; GFX6-NEXT:    v_or_b32_e32 v5, v5, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_mov_b64 s[12:13], exec
; GFX6-NEXT:    v_mov_b32_e32 v5, v6
; GFX6-NEXT:  .LBB11_4: ; Parent Loop BB11_3 Depth=1
; GFX6-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB11_4
; GFX6-NEXT:  ; %bb.5: ; in Loop: Header=BB11_3 Depth=1
; GFX6-NEXT:    s_mov_b64 exec, s[12:13]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX6-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_execnz .LBB11_3
; GFX6-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v7, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, bfloat %val syncscope("agent") seq_cst
  ret bfloat %result
}

; --------------------------------------------------------------------
; <2 x half>
; --------------------------------------------------------------------

define <2 x half> @buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset(ptr addrspace(7) inreg %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[0:3], null offen offset:1024 th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, s6
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[0:3], 0 offen offset:1024 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s4, s6, 0x400
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, v0 :: v_dual_mov_b32 v3, s4
; GFX11-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    buffer_load_b32 v0, v0, s[0:3], 0 offen offset:1024
; GFX11-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[0:1], v3, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v5
; GFX11-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_execnz .LBB12_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_mov_b32_e32 v3, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v5
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB12_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s18
; GFX90A-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[8:11], 0 offen offset:1024 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v0
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v0, s18
; GFX908-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_add_i32 s6, s18, 0x400
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_mov_b32_e32 v3, s6
; GFX908-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v5, v0
; GFX908-NEXT:    v_pk_add_f16 v4, v5, v2
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB12_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s6, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v5, v0
; GFX8-NEXT:    v_add_f16_sdwa v0, v5, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v1, v5, v2
; GFX8-NEXT:    v_or_b32_e32 v4, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB12_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-NEXT:    buffer_load_dword v3, v2, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v0
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v0
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v4, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB12_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    buffer_load_dword v3, v2, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v0
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, s6
; GFX6-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v6
; GFX6-NEXT:    v_or_b32_e32 v6, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX6-NEXT:    v_or_b32_e32 v5, v7, v0
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v4, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB12_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret <2 x half> %result
}

define void @buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset(ptr addrspace(7) inreg %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[0:3], null offen offset:1024
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, s6
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[0:3], 0 offen offset:1024
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, s6
; GFX11-NEXT:    s_add_i32 s4, s6, 0x400
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, s4
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    buffer_load_b32 v2, v1, s[0:3], 0 offen offset:1024
; GFX11-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v1, v2, v0
; GFX11-NEXT:    v_mov_b32_e32 v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v4, v1
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v3, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v2, v4
; GFX11-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_execnz .LBB13_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v2, v1, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_mov_b32_e32 v3, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v1, v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v4, v1
; GFX10-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v2
; GFX10-NEXT:    v_mov_b32_e32 v2, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB13_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s18
; GFX90A-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[8:11], 0 offen offset:1024
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v1, s18
; GFX908-NEXT:    buffer_atomic_pk_add_f16 v0, v1, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s18
; GFX8-NEXT:    buffer_load_dword v2, v1, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s6, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v1, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v4, v2, v0
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, v1
; GFX8-NEXT:    buffer_atomic_cmpswap v[4:5], v3, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v2
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB13_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-NEXT:    buffer_load_dword v2, v2, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v0
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v0
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_or_b32_e32 v5, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX7-NEXT:    v_or_b32_e32 v4, v6, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v2, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB13_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2f16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    buffer_load_dword v2, v2, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v0
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v5
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v0
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_or_b32_e32 v5, v3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX6-NEXT:    v_or_b32_e32 v4, v6, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v2, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB13_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(7) %ptr, i32 256
  %unused = atomicrmw fadd ptr addrspace(7) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret void
}

define <2 x half> @buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall(ptr addrspace(7) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_atomic_pk_add_f16 v5, v4, s[4:7], null offen offset:1024 th:TH_ATOMIC_RETURN
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX12-NEXT:    ; implicit-def: $vgpr4
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB14_1
; GFX12-NEXT:  ; %bb.2:
; GFX12-NEXT:    s_mov_b32 exec_lo, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, v5
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[2:3], exec
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_atomic_pk_add_f16 v5, v4, s[4:7], 0 offen offset:1024 sc0
; GFX940-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX940-NEXT:    ; implicit-def: $vgpr4
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB14_1
; GFX940-NEXT:  ; %bb.2:
; GFX940-NEXT:    s_mov_b64 exec, s[2:3]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, v5
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x400, v4
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    buffer_load_b32 v8, v4, s[4:7], 0 offen offset:1024
; GFX11-NEXT:    ; implicit-def: $vgpr4
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB14_1
; GFX11-NEXT:  ; %bb.2:
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB14_3: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Loop Header: Depth=1
; GFX11-NEXT:    ; Child Loop BB14_4 Depth 2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v7, v8, v5
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v6, v7
; GFX11-NEXT:    v_mov_b32_e32 v7, v8
; GFX11-NEXT:  .LBB14_4: ; Parent Loop BB14_3 Depth=1
; GFX11-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[6:7], v9, s[4:7], 0 offen glc
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB14_4
; GFX11-NEXT:  ; %bb.5: ; in Loop: Header=BB14_3 Depth=1
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v6, v8
; GFX11-NEXT:    v_mov_b32_e32 v8, v6
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB14_3
; GFX11-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v6
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v9, 0x400, v4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    ; implicit-def: $vgpr4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB14_1
; GFX10-NEXT:  ; %bb.2:
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:  .LBB14_3: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB14_4 Depth 2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v7, v8, v5
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v6, v7
; GFX10-NEXT:    v_mov_b32_e32 v7, v8
; GFX10-NEXT:  .LBB14_4: ; Parent Loop BB14_3 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB14_4
; GFX10-NEXT:  ; %bb.5: ; in Loop: Header=BB14_3 Depth=1
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v6, v8
; GFX10-NEXT:    v_mov_b32_e32 v8, v6
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB14_3
; GFX10-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v6
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b64 s[6:7], exec
; GFX90A-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_atomic_pk_add_f16 v5, v4, s[8:11], 0 offen offset:1024 glc
; GFX90A-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX90A-NEXT:    ; implicit-def: $vgpr4
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB14_1
; GFX90A-NEXT:  ; %bb.2:
; GFX90A-NEXT:    s_mov_b64 exec, s[6:7]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v0, v5
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v9, 0x400, v4
; GFX908-NEXT:    s_mov_b64 s[6:7], exec
; GFX908-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_nop 0
; GFX908-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    ; implicit-def: $vgpr4
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB14_1
; GFX908-NEXT:  ; %bb.2:
; GFX908-NEXT:    s_mov_b64 exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:  .LBB14_3: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Loop Header: Depth=1
; GFX908-NEXT:    ; Child Loop BB14_4 Depth 2
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v7, v8, v5
; GFX908-NEXT:    v_mov_b32_e32 v6, v7
; GFX908-NEXT:    s_mov_b64 s[12:13], exec
; GFX908-NEXT:    v_mov_b32_e32 v7, v8
; GFX908-NEXT:  .LBB14_4: ; Parent Loop BB14_3 Depth=1
; GFX908-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB14_4
; GFX908-NEXT:  ; %bb.5: ; in Loop: Header=BB14_3 Depth=1
; GFX908-NEXT:    s_mov_b64 exec, s[12:13]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v8
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v8, v6
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB14_3
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v6
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x400, v4
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_load_dword v8, v4, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    ; implicit-def: $vgpr4
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_1
; GFX8-NEXT:  ; %bb.2:
; GFX8-NEXT:    s_mov_b64 exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:  .LBB14_3: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Loop Header: Depth=1
; GFX8-NEXT:    ; Child Loop BB14_4 Depth 2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v4, v8, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v6, v8, v5
; GFX8-NEXT:    v_or_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_mov_b32_e32 v6, v7
; GFX8-NEXT:    s_mov_b64 s[12:13], exec
; GFX8-NEXT:    v_mov_b32_e32 v7, v8
; GFX8-NEXT:  .LBB14_4: ; Parent Loop BB14_3 Depth=1
; GFX8-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_atomic_cmpswap v[6:7], v9, s[8:11], 0 offen glc
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_4
; GFX8-NEXT:  ; %bb.5: ; in Loop: Header=BB14_3 Depth=1
; GFX8-NEXT:    s_mov_b64 exec, s[12:13]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v8
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v8, v6
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_3
; GFX8-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v6
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v9, vcc, 0x400, v4
; GFX7-NEXT:    s_mov_b64 s[6:7], exec
; GFX7-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    buffer_load_dword v7, v4, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    ; implicit-def: $vgpr4
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB14_1
; GFX7-NEXT:  ; %bb.2:
; GFX7-NEXT:    s_mov_b64 exec, s[6:7]
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v5
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v10, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v11, v8
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:  .LBB14_3: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Loop Header: Depth=1
; GFX7-NEXT:    ; Child Loop BB14_4 Depth 2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    s_mov_b64 s[12:13], exec
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v10
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v11
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:  .LBB14_4: ; Parent Loop BB14_3 Depth=1
; GFX7-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v9, s[8:11], 0 offen glc
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB14_4
; GFX7-NEXT:  ; %bb.5: ; in Loop: Header=BB14_3 Depth=1
; GFX7-NEXT:    s_mov_b64 exec, s[12:13]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB14_3
; GFX7-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v0, v4
; GFX7-NEXT:    v_mov_b32_e32 v1, v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2f16__offset__waterfall:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v9, vcc, 0x400, v4
; GFX6-NEXT:    s_mov_b64 s[6:7], exec
; GFX6-NEXT:  .LBB14_1: ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    buffer_load_dword v7, v4, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    ; implicit-def: $vgpr4
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB14_1
; GFX6-NEXT:  ; %bb.2:
; GFX6-NEXT:    s_mov_b64 exec, s[6:7]
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v5
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v10, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v11, v8
; GFX6-NEXT:    s_mov_b64 s[6:7], 0
; GFX6-NEXT:  .LBB14_3: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Loop Header: Depth=1
; GFX6-NEXT:    ; Child Loop BB14_4 Depth 2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    s_mov_b64 s[12:13], exec
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v10
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v11
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX6-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:  .LBB14_4: ; Parent Loop BB14_3 Depth=1
; GFX6-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v9, s[8:11], 0 offen glc
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB14_4
; GFX6-NEXT:  ; %bb.5: ; in Loop: Header=BB14_3 Depth=1
; GFX6-NEXT:    s_mov_b64 exec, s[12:13]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX6-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_execnz .LBB14_3
; GFX6-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v0, v4
; GFX6-NEXT:    v_mov_b32_e32 v1, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret <2 x half> %result
}

; --------------------------------------------------------------------
; <2 x bfloat>
; --------------------------------------------------------------------

define <2 x bfloat> @buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset(ptr addrspace(7) inreg %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    buffer_atomic_pk_add_bf16 v0, v1, s[0:3], null offen offset:1024 th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, v0
; GFX940-NEXT:    v_mov_b32_e32 v0, s6
; GFX940-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen offset:1024
; GFX940-NEXT:    s_add_i32 s4, s6, 0x400
; GFX940-NEXT:    s_mov_b64 s[6:7], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX940-NEXT:    s_movk_i32 s8, 0x7fff
; GFX940-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX940-NEXT:    s_mov_b32 s9, 0x7060302
; GFX940-NEXT:    v_mov_b32_e32 v4, s4
; GFX940-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 16, v7
; GFX940-NEXT:    v_and_b32_e32 v1, 0xffff0000, v7
; GFX940-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX940-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX940-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX940-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX940-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX940-NEXT:    v_add3_u32 v5, v5, v0, s8
; GFX940-NEXT:    v_add3_u32 v8, v8, v1, s8
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX940-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; GFX940-NEXT:    v_cndmask_b32_e64 v0, v5, v6, s[4:5]
; GFX940-NEXT:    v_perm_b32 v6, v1, v0, s9
; GFX940-NEXT:    v_mov_b64_e32 v[0:1], v[6:7]
; GFX940-NEXT:    buffer_atomic_cmpswap v[0:1], v4, s[0:3], 0 offen sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v7
; GFX940-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX940-NEXT:    s_cbranch_execnz .LBB15_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_add_i32 s4, s6, 0x400
; GFX11-NEXT:    s_mov_b32 s5, 0
; GFX11-NEXT:    v_mov_b32_e32 v4, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    buffer_load_b32 v0, v0, s[0:3], 0 offen offset:1024
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v7, v9 :: v_dual_lshlrev_b32 v0, 16, v6
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX11-NEXT:    v_add3_u32 v5, v5, v0, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v5, v8, s4
; GFX11-NEXT:    v_perm_b32 v5, v1, v0, 0x7060302
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, v5 :: v_dual_mov_b32 v1, v6
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[0:1], v4, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX11-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB15_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX10-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX10-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX10-NEXT:    v_add3_u32 v5, v5, v0, 0x7fff
; GFX10-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v7, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v5, v8, s4
; GFX10-NEXT:    v_perm_b32 v5, v1, v0, 0x7060302
; GFX10-NEXT:    v_mov_b32_e32 v0, v5
; GFX10-NEXT:    v_mov_b32_e32 v1, v6
; GFX10-NEXT:    buffer_atomic_cmpswap v[0:1], v4, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB15_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v0, s18
; GFX90A-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX90A-NEXT:    s_add_i32 s4, s18, 0x400
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    s_movk_i32 s12, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX90A-NEXT:    s_mov_b32 s13, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, s4
; GFX90A-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v1, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX90A-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX90A-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX90A-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX90A-NEXT:    v_add3_u32 v5, v5, v0, s12
; GFX90A-NEXT:    v_add3_u32 v8, v8, v1, s12
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX90A-NEXT:    v_cndmask_b32_e64 v0, v5, v6, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v1, v0, s13
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[6:7], v[6:7] op_sel:[0,1]
; GFX90A-NEXT:    buffer_atomic_cmpswap v[0:1], v4, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB15_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v1, v0
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v0, s18
; GFX908-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_add_i32 s4, s18, 0x400
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX908-NEXT:    s_movk_i32 s12, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX908-NEXT:    s_mov_b32 s13, 0x7060302
; GFX908-NEXT:    v_mov_b32_e32 v4, s4
; GFX908-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v0
; GFX908-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX908-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX908-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX908-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX908-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX908-NEXT:    v_add3_u32 v5, v5, v0, s12
; GFX908-NEXT:    v_add3_u32 v8, v8, v1, s12
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX908-NEXT:    v_cndmask_b32_e64 v0, v5, v7, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; GFX908-NEXT:    v_perm_b32 v5, v1, v0, s13
; GFX908-NEXT:    v_mov_b32_e32 v0, v5
; GFX908-NEXT:    v_mov_b32_e32 v1, v6
; GFX908-NEXT:    buffer_atomic_cmpswap v[0:1], v4, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB15_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s4, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v0
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v5, v7, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX8-NEXT:    v_alignbit_b32 v5, v1, v0, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, v5
; GFX8-NEXT:    v_mov_b32_e32 v1, v6
; GFX8-NEXT:    buffer_atomic_cmpswap v[0:1], v4, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB15_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-NEXT:    buffer_load_dword v4, v2, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, s6
; GFX7-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; GFX7-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; GFX7-NEXT:    v_mov_b32_e32 v6, v1
; GFX7-NEXT:    v_mov_b32_e32 v5, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v4, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v5
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB15_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    buffer_load_dword v4, v2, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, s6
; GFX6-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX6-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v6
; GFX6-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; GFX6-NEXT:    v_mov_b32_e32 v6, v1
; GFX6-NEXT:    v_mov_b32_e32 v5, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v4, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v5
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB15_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret <2 x bfloat> %result
}

define void @buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset(ptr addrspace(7) inreg %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    buffer_atomic_pk_add_bf16 v0, v1, s[0:3], null offen offset:1024
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, s6
; GFX940-NEXT:    buffer_load_dword v1, v1, s[0:3], 0 offen offset:1024
; GFX940-NEXT:    s_add_i32 s4, s6, 0x400
; GFX940-NEXT:    s_mov_b64 s[6:7], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX940-NEXT:    s_movk_i32 s8, 0x7fff
; GFX940-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX940-NEXT:    s_mov_b32 s9, 0x7060302
; GFX940-NEXT:    v_mov_b32_e32 v4, s4
; GFX940-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX940-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX940-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX940-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX940-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX940-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v0, s8
; GFX940-NEXT:    v_add3_u32 v8, v8, v5, s8
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX940-NEXT:    v_cndmask_b32_e64 v0, v6, v7, s[4:5]
; GFX940-NEXT:    v_perm_b32 v0, v5, v0, s9
; GFX940-NEXT:    v_mov_b64_e32 v[6:7], v[0:1]
; GFX940-NEXT:    buffer_atomic_cmpswap v[6:7], v4, s[0:3], 0 offen sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v1
; GFX940-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX940-NEXT:    v_mov_b32_e32 v1, v6
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX940-NEXT:    s_cbranch_execnz .LBB16_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, s6 :: v_dual_lshlrev_b32 v2, 16, v0
; GFX11-NEXT:    s_add_i32 s4, s6, 0x400
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_and_b32 v3, 0xffff0000, v0
; GFX11-NEXT:    buffer_load_b32 v1, v1, s[0:3], 0 offen offset:1024
; GFX11-NEXT:    s_mov_b32 s5, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_add_f32 v5, v5, v3 :: v_dual_add_f32 v0, v0, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v6, v8, s4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v0, v5, v0, 0x7060302
; GFX11-NEXT:    v_dual_mov_b32 v6, v1 :: v_dual_mov_b32 v5, v0
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[5:6], v4, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v5
; GFX11-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_cbranch_execnz .LBB16_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX10-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v9, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v6, v8, s4
; GFX10-NEXT:    v_perm_b32 v0, v5, v0, 0x7060302
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    buffer_atomic_cmpswap v[5:6], v4, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB16_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v1, s18
; GFX90A-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen offset:1024
; GFX90A-NEXT:    s_add_i32 s4, s18, 0x400
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX90A-NEXT:    s_movk_i32 s12, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX90A-NEXT:    s_mov_b32 s13, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, s4
; GFX90A-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX90A-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX90A-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX90A-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v0, s12
; GFX90A-NEXT:    v_add3_u32 v8, v8, v5, s12
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX90A-NEXT:    v_cndmask_b32_e64 v0, v6, v7, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX90A-NEXT:    v_perm_b32 v0, v5, v0, s13
; GFX90A-NEXT:    v_pk_mov_b32 v[6:7], v[0:1], v[0:1] op_sel:[0,1]
; GFX90A-NEXT:    buffer_atomic_cmpswap v[6:7], v4, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v1
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB16_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v1, s18
; GFX908-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_add_i32 s4, s18, 0x400
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX908-NEXT:    s_movk_i32 s12, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX908-NEXT:    s_mov_b32 s13, 0x7060302
; GFX908-NEXT:    v_mov_b32_e32 v4, s4
; GFX908-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX908-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX908-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX908-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX908-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v6, v6, v0, s12
; GFX908-NEXT:    v_add3_u32 v8, v8, v5, s12
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX908-NEXT:    v_cndmask_b32_e64 v0, v6, v7, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX908-NEXT:    v_perm_b32 v0, v5, v0, s13
; GFX908-NEXT:    v_mov_b32_e32 v6, v1
; GFX908-NEXT:    v_mov_b32_e32 v5, v0
; GFX908-NEXT:    buffer_atomic_cmpswap v[5:6], v4, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB16_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s18
; GFX8-NEXT:    buffer_load_dword v1, v1, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s4, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX8-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v0
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v6, v7, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v0, v5, v0, 16
; GFX8-NEXT:    v_mov_b32_e32 v6, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[5:6], v4, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v1
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB16_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s18
; GFX7-NEXT:    buffer_load_dword v2, v2, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v1
; GFX7-NEXT:    v_add_f32_e32 v5, v5, v0
; GFX7-NEXT:    v_alignbit_b32 v4, v3, v4, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    v_alignbit_b32 v3, v3, v5, 16
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v2, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v5
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB16_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_noret_v2bf16__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    buffer_load_dword v2, v2, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX6-NEXT:    v_mov_b32_e32 v2, s6
; GFX6-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v1
; GFX6-NEXT:    v_add_f32_e32 v5, v5, v0
; GFX6-NEXT:    v_alignbit_b32 v4, v3, v4, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v6
; GFX6-NEXT:    v_alignbit_b32 v3, v3, v5, 16
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v2, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v5
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB16_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(7) %ptr, i32 256
  %unused = atomicrmw fadd ptr addrspace(7) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret void
}

define <2 x bfloat> @buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall(ptr addrspace(7) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    v_readfirstlane_b32 s4, v0
; GFX12-NEXT:    v_readfirstlane_b32 s5, v1
; GFX12-NEXT:    v_readfirstlane_b32 s6, v2
; GFX12-NEXT:    v_readfirstlane_b32 s7, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX12-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_and_saveexec_b32 s0, s0
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    buffer_atomic_pk_add_bf16 v5, v4, s[4:7], null offen offset:1024 th:TH_ATOMIC_RETURN
; GFX12-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3
; GFX12-NEXT:    ; implicit-def: $vgpr4
; GFX12-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB17_1
; GFX12-NEXT:  ; %bb.2:
; GFX12-NEXT:    s_mov_b32 exec_lo, s1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, v5
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v8, 0x400, v4
; GFX940-NEXT:    s_mov_b64 s[2:3], exec
; GFX940-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    buffer_load_dword v7, v4, s[4:7], 0 offen offset:1024
; GFX940-NEXT:    ; implicit-def: $vgpr4
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB17_1
; GFX940-NEXT:  ; %bb.2:
; GFX940-NEXT:    s_mov_b64 exec, s[2:3]
; GFX940-NEXT:    s_mov_b64 s[2:3], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX940-NEXT:    s_movk_i32 s10, 0x7fff
; GFX940-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX940-NEXT:    s_mov_b32 s11, 0x7060302
; GFX940-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Loop Header: Depth=1
; GFX940-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX940-NEXT:    v_add_f32_e32 v4, v4, v9
; GFX940-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX940-NEXT:    v_add3_u32 v5, v5, v4, s10
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX940-NEXT:    s_mov_b64 s[8:9], exec
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX940-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v10
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s10
; GFX940-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v11, vcc
; GFX940-NEXT:    v_perm_b32 v6, v5, v4, s11
; GFX940-NEXT:    v_mov_b64_e32 v[4:5], v[6:7]
; GFX940-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX940-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX940-NEXT:    v_readfirstlane_b32 s4, v0
; GFX940-NEXT:    v_readfirstlane_b32 s5, v1
; GFX940-NEXT:    v_readfirstlane_b32 s6, v2
; GFX940-NEXT:    v_readfirstlane_b32 s7, v3
; GFX940-NEXT:    v_cmp_eq_u64_e32 vcc, s[4:5], v[0:1]
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_cmp_eq_u64_e64 s[0:1], s[6:7], v[2:3]
; GFX940-NEXT:    s_and_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_and_saveexec_b64 s[0:1], s[0:1]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[4:7], 0 offen sc0
; GFX940-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB17_4
; GFX940-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX940-NEXT:    s_mov_b64 exec, s[8:9]
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX940-NEXT:    s_cbranch_execnz .LBB17_3
; GFX940-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX940-NEXT:    v_mov_b32_e32 v0, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 0x400, v4
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    buffer_load_b32 v6, v4, s[4:7], 0 offen offset:1024
; GFX11-NEXT:    ; implicit-def: $vgpr4
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB17_1
; GFX11-NEXT:  ; %bb.2:
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Loop Header: Depth=1
; GFX11-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX11-NEXT:    s_mov_b32 s2, exec_lo
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_add_f32 v5, v5, v9 :: v_dual_add_f32 v4, v4, v8
; GFX11-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-NEXT:    v_add3_u32 v11, v11, v5, 0x7fff
; GFX11-NEXT:    v_add3_u32 v10, v10, v4, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v10, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v11, v13, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v5, v5, v4, 0x7060302
; GFX11-NEXT:    v_mov_b32_e32 v4, v5
; GFX11-NEXT:    v_mov_b32_e32 v5, v6
; GFX11-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX11-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX11-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-NEXT:    v_readfirstlane_b32 s5, v1
; GFX11-NEXT:    v_readfirstlane_b32 s6, v2
; GFX11-NEXT:    v_readfirstlane_b32 s7, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[4:5], v[0:1]
; GFX11-NEXT:    v_cmp_eq_u64_e64 s0, s[6:7], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_and_saveexec_b32 s0, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[4:5], v7, s[4:7], 0 offen glc
; GFX11-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB17_4
; GFX11-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX11-NEXT:    s_mov_b32 exec_lo, s2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v6
; GFX11-NEXT:    v_mov_b32_e32 v6, v4
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB17_3
; GFX11-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v7, 0x400, v4
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    buffer_load_dword v6, v4, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    ; implicit-def: $vgpr4
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB17_1
; GFX10-NEXT:  ; %bb.2:
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX10-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX10-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    s_mov_b32 s6, exec_lo
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v4, v4, v8
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX10-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX10-NEXT:    v_bfe_u32 v11, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v12, 0x400000, v4
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX10-NEXT:    v_add3_u32 v10, v10, v4, 0x7fff
; GFX10-NEXT:    v_add3_u32 v11, v11, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v10, v12, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v11, v13, vcc_lo
; GFX10-NEXT:    v_perm_b32 v5, v5, v4, 0x7060302
; GFX10-NEXT:    v_mov_b32_e32 v4, v5
; GFX10-NEXT:    v_mov_b32_e32 v5, v6
; GFX10-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_readfirstlane_b32 s8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s9, v1
; GFX10-NEXT:    v_readfirstlane_b32 s10, v2
; GFX10-NEXT:    v_readfirstlane_b32 s11, v3
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[8:9], v[0:1]
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, s[10:11], v[2:3]
; GFX10-NEXT:    s_and_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_and_saveexec_b32 s4, s4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_atomic_cmpswap v[4:5], v7, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_xor_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB17_4
; GFX10-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX10-NEXT:    s_mov_b32 exec_lo, s6
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v6
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB17_3
; GFX10-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_u32_e32 v8, 0x400, v4
; GFX90A-NEXT:    s_mov_b64 s[6:7], exec
; GFX90A-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_nop 0
; GFX90A-NEXT:    buffer_load_dword v7, v4, s[8:11], 0 offen offset:1024
; GFX90A-NEXT:    ; implicit-def: $vgpr4
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB17_1
; GFX90A-NEXT:  ; %bb.2:
; GFX90A-NEXT:    s_mov_b64 exec, s[6:7]
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX90A-NEXT:    s_movk_i32 s14, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX90A-NEXT:    s_mov_b32 s15, 0x7060302
; GFX90A-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Loop Header: Depth=1
; GFX90A-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX90A-NEXT:    v_add_f32_e32 v4, v4, v9
; GFX90A-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX90A-NEXT:    v_add3_u32 v5, v5, v4, s14
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v4
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, v5, v6, vcc
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v10
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s14
; GFX90A-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v11, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v4, s15
; GFX90A-NEXT:    s_mov_b64 s[12:13], exec
; GFX90A-NEXT:    v_pk_mov_b32 v[4:5], v[6:7], v[6:7] op_sel:[0,1]
; GFX90A-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX90A-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX90A-NEXT:    v_readfirstlane_b32 s8, v0
; GFX90A-NEXT:    v_readfirstlane_b32 s9, v1
; GFX90A-NEXT:    v_readfirstlane_b32 s10, v2
; GFX90A-NEXT:    v_readfirstlane_b32 s11, v3
; GFX90A-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX90A-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX90A-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_atomic_cmpswap v[4:5], v8, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB17_4
; GFX90A-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX90A-NEXT:    s_mov_b64 exec, s[12:13]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB17_3
; GFX90A-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_u32_e32 v7, 0x400, v4
; GFX908-NEXT:    s_mov_b64 s[6:7], exec
; GFX908-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_nop 0
; GFX908-NEXT:    buffer_load_dword v6, v4, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    ; implicit-def: $vgpr4
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_1
; GFX908-NEXT:  ; %bb.2:
; GFX908-NEXT:    s_mov_b64 exec, s[6:7]
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX908-NEXT:    s_movk_i32 s14, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX908-NEXT:    s_mov_b32 s15, 0x7060302
; GFX908-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Loop Header: Depth=1
; GFX908-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX908-NEXT:    v_add_f32_e32 v4, v4, v8
; GFX908-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX908-NEXT:    v_add3_u32 v5, v5, v4, s14
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX908-NEXT:    v_cndmask_b32_e32 v4, v5, v10, vcc
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX908-NEXT:    v_bfe_u32 v10, v5, 16, 1
; GFX908-NEXT:    v_add3_u32 v10, v10, v5, s14
; GFX908-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v10, v11, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v4, s15
; GFX908-NEXT:    v_mov_b32_e32 v4, v5
; GFX908-NEXT:    s_mov_b64 s[12:13], exec
; GFX908-NEXT:    v_mov_b32_e32 v5, v6
; GFX908-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX908-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX908-NEXT:    v_readfirstlane_b32 s8, v0
; GFX908-NEXT:    v_readfirstlane_b32 s9, v1
; GFX908-NEXT:    v_readfirstlane_b32 s10, v2
; GFX908-NEXT:    v_readfirstlane_b32 s11, v3
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX908-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX908-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_atomic_cmpswap v[4:5], v7, s[8:11], 0 offen glc
; GFX908-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_4
; GFX908-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX908-NEXT:    s_mov_b64 exec, s[12:13]
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_3
; GFX908-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x400, v4
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_nop 0
; GFX8-NEXT:    buffer_load_dword v6, v4, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    ; implicit-def: $vgpr4
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_1
; GFX8-NEXT:  ; %bb.2:
; GFX8-NEXT:    s_mov_b64 exec, s[6:7]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX8-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Loop Header: Depth=1
; GFX8-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX8-NEXT:    v_add_f32_e32 v4, v4, v8
; GFX8-NEXT:    v_bfe_u32 v5, v4, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v4
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v10, vcc
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX8-NEXT:    v_bfe_u32 v10, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v10, vcc, v10, v5
; GFX8-NEXT:    v_add_u32_e32 v10, vcc, 0x7fff, v10
; GFX8-NEXT:    v_or_b32_e32 v11, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v10, v11, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v4, 16
; GFX8-NEXT:    v_mov_b32_e32 v4, v5
; GFX8-NEXT:    s_mov_b64 s[12:13], exec
; GFX8-NEXT:    v_mov_b32_e32 v5, v6
; GFX8-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX8-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX8-NEXT:    v_readfirstlane_b32 s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s9, v1
; GFX8-NEXT:    v_readfirstlane_b32 s10, v2
; GFX8-NEXT:    v_readfirstlane_b32 s11, v3
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX8-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_atomic_cmpswap v[4:5], v7, s[8:11], 0 offen glc
; GFX8-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_4
; GFX8-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX8-NEXT:    s_mov_b64 exec, s[12:13]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_3
; GFX8-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v8, vcc, 0x400, v4
; GFX7-NEXT:    s_mov_b64 s[6:7], exec
; GFX7-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    buffer_load_dword v7, v4, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    ; implicit-def: $vgpr4
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB17_1
; GFX7-NEXT:  ; %bb.2:
; GFX7-NEXT:    s_mov_b64 exec, s[6:7]
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX7-NEXT:    s_mov_b64 s[6:7], 0
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX7-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Loop Header: Depth=1
; GFX7-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v7
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v9
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    s_mov_b64 s[12:13], exec
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX7-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX7-NEXT:    v_readfirstlane_b32 s8, v0
; GFX7-NEXT:    v_readfirstlane_b32 s9, v1
; GFX7-NEXT:    v_readfirstlane_b32 s10, v2
; GFX7-NEXT:    v_readfirstlane_b32 s11, v3
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX7-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX7-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v8, s[8:11], 0 offen glc
; GFX7-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB17_4
; GFX7-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX7-NEXT:    s_mov_b64 exec, s[12:13]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX7-NEXT:    s_cbranch_execnz .LBB17_3
; GFX7-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v0, v7
; GFX7-NEXT:    v_mov_b32_e32 v1, v4
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_agent_atomic_fadd_ret_v2bf16__offset__waterfall:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v8, vcc, 0x400, v4
; GFX6-NEXT:    s_mov_b64 s[6:7], exec
; GFX6-NEXT:  .LBB17_1: ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    buffer_load_dword v7, v4, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    ; implicit-def: $vgpr4
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB17_1
; GFX6-NEXT:  ; %bb.2:
; GFX6-NEXT:    s_mov_b64 exec, s[6:7]
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX6-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v6
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX6-NEXT:    s_mov_b64 s[6:7], 0
; GFX6-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX6-NEXT:  .LBB17_3: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Loop Header: Depth=1
; GFX6-NEXT:    ; Child Loop BB17_4 Depth 2
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v7
; GFX6-NEXT:    v_mul_f32_e32 v7, 1.0, v4
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v7
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX6-NEXT:    v_add_f32_e32 v4, v4, v10
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v9
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    s_mov_b64 s[12:13], exec
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:  .LBB17_4: ; Parent Loop BB17_3 Depth=1
; GFX6-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX6-NEXT:    v_readfirstlane_b32 s8, v0
; GFX6-NEXT:    v_readfirstlane_b32 s9, v1
; GFX6-NEXT:    v_readfirstlane_b32 s10, v2
; GFX6-NEXT:    v_readfirstlane_b32 s11, v3
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 s[4:5], s[10:11], v[2:3]
; GFX6-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_and_saveexec_b64 s[4:5], s[4:5]
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v8, s[8:11], 0 offen glc
; GFX6-NEXT:    s_xor_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB17_4
; GFX6-NEXT:  ; %bb.5: ; in Loop: Header=BB17_3 Depth=1
; GFX6-NEXT:    s_mov_b64 exec, s[12:13]
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX6-NEXT:    s_cbranch_execnz .LBB17_3
; GFX6-NEXT:  ; %bb.6: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v0, v7
; GFX6-NEXT:    v_mov_b32_e32 v1, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret <2 x bfloat> %result
}

; --------------------------------------------------------------------
; misc
; --------------------------------------------------------------------

define float @buffer_fat_ptr_system_atomic_fadd_ret_f32__offset(ptr addrspace(7) inreg %ptr, float %val) #0 {
; GFX12-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_co_i32 s4, s6, 0x400
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_dual_mov_b32 v2, v0 :: v_dual_mov_b32 v3, s4
; GFX12-NEXT:    v_mov_b32_e32 v0, s6
; GFX12-NEXT:    s_mov_b32 s4, 0
; GFX12-NEXT:    buffer_load_b32 v0, v0, s[0:3], null offen offset:1024
; GFX12-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v5, v0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX12-NEXT:    buffer_atomic_cmpswap_b32 v[0:1], v3, s[0:3], null offen th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v5
; GFX12-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX12-NEXT:    s_cbranch_execnz .LBB18_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, s6
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    buffer_atomic_add_f32 v0, v1, s[0:3], 0 offen offset:1024 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_add_i32 s4, s6, 0x400
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, v0 :: v_dual_mov_b32 v3, s4
; GFX11-NEXT:    v_mov_b32_e32 v0, s6
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    buffer_load_b32 v0, v0, s[0:3], 0 offen offset:1024
; GFX11-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v5, v0
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    buffer_atomic_cmpswap_b32 v[0:1], v3, s[0:3], 0 offen glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v5
; GFX11-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_execnz .LBB18_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, s18
; GFX10-NEXT:    s_mov_b32 s11, s17
; GFX10-NEXT:    s_mov_b32 s10, s16
; GFX10-NEXT:    s_mov_b32 s9, s7
; GFX10-NEXT:    s_mov_b32 s8, s6
; GFX10-NEXT:    s_add_i32 s4, s18, 0x400
; GFX10-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX10-NEXT:    v_mov_b32_e32 v3, s4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v5
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB18_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    v_mov_b32_e32 v0, s18
; GFX90A-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX90A-NEXT:    s_add_i32 s6, s18, 0x400
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_mov_b32_e32 v3, s6
; GFX90A-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v0
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[0,1]
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB18_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v2, v0
; GFX908-NEXT:    s_mov_b32 s11, s17
; GFX908-NEXT:    s_mov_b32 s10, s16
; GFX908-NEXT:    s_mov_b32 s9, s7
; GFX908-NEXT:    s_mov_b32 s8, s6
; GFX908-NEXT:    v_mov_b32_e32 v0, s18
; GFX908-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX908-NEXT:    s_add_i32 s6, s18, 0x400
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_mov_b32_e32 v3, s6
; GFX908-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v5, v0
; GFX908-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB18_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    s_mov_b32 s11, s17
; GFX8-NEXT:    s_mov_b32 s10, s16
; GFX8-NEXT:    s_mov_b32 s9, s7
; GFX8-NEXT:    s_mov_b32 s8, s6
; GFX8-NEXT:    v_mov_b32_e32 v0, s18
; GFX8-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX8-NEXT:    s_add_i32 s6, s18, 0x400
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s6
; GFX8-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v5, v0
; GFX8-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB18_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    s_mov_b32 s11, s17
; GFX7-NEXT:    s_mov_b32 s10, s16
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    v_mov_b32_e32 v0, s18
; GFX7-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX7-NEXT:    s_add_i32 s6, s18, 0x400
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    v_mov_b32_e32 v3, s6
; GFX7-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v0
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, v4
; GFX7-NEXT:    v_mov_b32_e32 v1, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB18_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: buffer_fat_ptr_system_atomic_fadd_ret_f32__offset:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    s_mov_b32 s11, s17
; GFX6-NEXT:    s_mov_b32 s10, s16
; GFX6-NEXT:    s_mov_b32 s9, s7
; GFX6-NEXT:    s_mov_b32 s8, s6
; GFX6-NEXT:    v_mov_b32_e32 v0, s18
; GFX6-NEXT:    buffer_load_dword v0, v0, s[8:11], 0 offen offset:1024
; GFX6-NEXT:    s_add_i32 s6, s18, 0x400
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    v_mov_b32_e32 v3, s6
; GFX6-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v0
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v4
; GFX6-NEXT:    v_mov_b32_e32 v1, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[0:1], v3, s[8:11], 0 offen glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v5
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB18_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(7) %ptr, i32 256
  %result = atomicrmw fadd ptr addrspace(7) %gep, float %val seq_cst
  ret float %result
}

attributes #0 = { nounwind "amdgpu-unsafe-fp-atomics"="true" }


