; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=amdgcn-- -mcpu=tahiti -verify-machineinstrs | FileCheck %s --check-prefix=SI
; RUN: llc < %s -mtriple=amdgcn-- -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs | FileCheck %s --check-prefix=FLAT
; RUN: llc < %s -mtriple=amdgcn-- -mcpu=fiji -mattr=-flat-for-global -verify-machineinstrs | FileCheck %s --check-prefix=FLAT
; RUN: llc < %s -mtriple=amdgcn-- -mcpu=fiji -global-isel -verify-machineinstrs | FileCheck %s --check-prefix=GISEL
; RUN: llc < %s -mtriple=amdgcn-- -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs | FileCheck %s --check-prefix=GFX11-FLAT
; RUN: llc < %s -mtriple=amdgcn-- -mcpu=gfx1100 -global-isel -verify-machineinstrs | FileCheck %s --check-prefix=GFX11-GISEL

declare i32 @llvm.amdgcn.workitem.id.x() #1

declare i16 @llvm.bitreverse.i16(i16) #1
declare i32 @llvm.bitreverse.i32(i32) #1
declare i64 @llvm.bitreverse.i64(i64) #1

declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>) #1
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>) #1

declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>) #1
declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>) #1

define amdgpu_kernel void @s_brev_i16(ptr addrspace(1) noalias %out, i16 %val) #0 {
; SI-LABEL: s_brev_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_brev_b32 s4, s4
; SI-NEXT:    s_lshr_b32 s4, s4, 16
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: s_brev_i16:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dword s4, s[2:3], 0x2c
; FLAT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    s_brev_b32 s4, s4
; FLAT-NEXT:    s_lshr_b32 s4, s4, 16
; FLAT-NEXT:    v_mov_b32_e32 v0, s4
; FLAT-NEXT:    buffer_store_short v0, off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: s_brev_i16:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_and_b32 s2, s4, 0xffff
; GISEL-NEXT:    s_brev_b32 s2, s2
; GISEL-NEXT:    s_lshr_b32 s2, s2, 16
; GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-NEXT:    flat_store_short v[0:1], v2
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: s_brev_i16:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_clause 0x1
; GFX11-FLAT-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-FLAT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    s_brev_b32 s2, s4
; GFX11-FLAT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FLAT-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-FLAT-NEXT:    global_store_d16_hi_b16 v0, v1, s[0:1]
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: s_brev_i16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_and_b32 s2, s4, 0xffff
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    s_brev_b32 s2, s2
; GFX11-GISEL-NEXT:    s_lshr_b32 s2, s2, 16
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-GISEL-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %brev = call i16 @llvm.bitreverse.i16(i16 %val) #1
  store i16 %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_brev_i16(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) #0 {
; SI-LABEL: v_brev_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bfrev_b32_e32 v0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: v_brev_i16:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    s_mov_b32 s7, 0xf000
; FLAT-NEXT:    s_mov_b32 s6, -1
; FLAT-NEXT:    s_mov_b32 s10, s6
; FLAT-NEXT:    s_mov_b32 s11, s7
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    s_mov_b32 s8, s2
; FLAT-NEXT:    s_mov_b32 s9, s3
; FLAT-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; FLAT-NEXT:    s_mov_b32 s4, s0
; FLAT-NEXT:    s_mov_b32 s5, s1
; FLAT-NEXT:    s_waitcnt vmcnt(0)
; FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; FLAT-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; FLAT-NEXT:    buffer_store_short v0, off, s[4:7], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: v_brev_i16:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    flat_load_ushort v0, v[0:1]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    v_bfrev_b32_e32 v0, v0
; GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-NEXT:    flat_store_short v[0:1], v2
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: v_brev_i16:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s6, -1
; GFX11-FLAT-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    s_mov_b32 s4, s2
; GFX11-FLAT-NEXT:    s_mov_b32 s5, s3
; GFX11-FLAT-NEXT:    buffer_load_u16 v0, off, s[4:7], 0
; GFX11-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-FLAT-NEXT:    global_store_d16_hi_b16 v1, v0, s[0:1]
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_brev_i16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v1, v1
; GFX11-GISEL-NEXT:    global_store_d16_hi_b16 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %val = load i16, ptr addrspace(1) %valptr
  %brev = call i16 @llvm.bitreverse.i16(i16 %val) #1
  store i16 %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_brev_i32(ptr addrspace(1) noalias %out, i32 %val) #0 {
; SI-LABEL: s_brev_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_brev_b32 s4, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: s_brev_i32:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dword s4, s[2:3], 0x2c
; FLAT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    s_brev_b32 s4, s4
; FLAT-NEXT:    v_mov_b32_e32 v0, s4
; FLAT-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: s_brev_i32:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dword s4, s[2:3], 0x2c
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_brev_b32 s2, s4
; GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-NEXT:    flat_store_dword v[0:1], v2
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: s_brev_i32:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_clause 0x1
; GFX11-FLAT-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-FLAT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    s_brev_b32 s2, s4
; GFX11-FLAT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FLAT-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: s_brev_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b32 s4, s[2:3], 0x2c
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_brev_b32 s2, s4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %brev = call i32 @llvm.bitreverse.i32(i32 %val) #1
  store i32 %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_brev_i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) #0 {
; SI-LABEL: v_brev_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bfrev_b32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: v_brev_i32:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    v_mov_b32_e32 v1, s3
; FLAT-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; FLAT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; FLAT-NEXT:    flat_load_dword v0, v[0:1]
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt vmcnt(0)
; FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; FLAT-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: v_brev_i32:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GISEL-NEXT:    flat_load_dword v0, v[0:1]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    v_bfrev_b32_e32 v2, v0
; GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-NEXT:    flat_store_dword v[0:1], v2
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: v_brev_i32:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLAT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLAT-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-FLAT-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_brev_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %gep
  %brev = call i32 @llvm.bitreverse.i32(i32 %val) #1
  store i32 %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_brev_v2i32(ptr addrspace(1) noalias %out, <2 x i32> %val) #0 {
; SI-LABEL: s_brev_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_brev_b32 s0, s3
; SI-NEXT:    s_brev_b32 s1, s2
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    v_mov_b32_e32 v1, s0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: s_brev_v2i32:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    s_mov_b32 s7, 0xf000
; FLAT-NEXT:    s_mov_b32 s6, -1
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    s_mov_b32 s4, s0
; FLAT-NEXT:    s_mov_b32 s5, s1
; FLAT-NEXT:    s_brev_b32 s0, s3
; FLAT-NEXT:    s_brev_b32 s1, s2
; FLAT-NEXT:    v_mov_b32_e32 v0, s1
; FLAT-NEXT:    v_mov_b32_e32 v1, s0
; FLAT-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: s_brev_v2i32:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_brev_b32 s2, s2
; GISEL-NEXT:    s_brev_b32 s3, s3
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: s_brev_v2i32:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s6, -1
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    s_brev_b32 s2, s2
; GFX11-FLAT-NEXT:    s_brev_b32 s3, s3
; GFX11-FLAT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FLAT-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-FLAT-NEXT:    s_mov_b32 s4, s0
; GFX11-FLAT-NEXT:    s_mov_b32 s5, s1
; GFX11-FLAT-NEXT:    buffer_store_b64 v[0:1], off, s[4:7], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: s_brev_v2i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_brev_b32 s2, s2
; GFX11-GISEL-NEXT:    s_brev_b32 s3, s3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %brev = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %val) #1
  store <2 x i32> %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_brev_v2i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) #0 {
; SI-LABEL: v_brev_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bfrev_b32_e32 v1, v1
; SI-NEXT:    v_bfrev_b32_e32 v0, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: v_brev_v2i32:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    v_mov_b32_e32 v1, s3
; FLAT-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; FLAT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; FLAT-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt vmcnt(0)
; FLAT-NEXT:    v_bfrev_b32_e32 v1, v1
; FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; FLAT-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: v_brev_v2i32:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GISEL-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    v_bfrev_b32_e32 v0, v0
; GISEL-NEXT:    v_bfrev_b32_e32 v1, v1
; GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: v_brev_v2i32:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLAT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLAT-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    global_load_b64 v[0:1], v0, s[2:3]
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v1, v1
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-FLAT-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_brev_v2i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b64 v[0:1], v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v1, v1
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x i32>, ptr addrspace(1) %valptr, i32 %tid
  %val = load <2 x i32>, ptr addrspace(1) %gep
  %brev = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %val) #1
  store <2 x i32> %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_brev_i64(ptr addrspace(1) noalias %out, i64 %val) #0 {
; SI-LABEL: s_brev_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_brev_b64 s[0:1], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: s_brev_i64:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    s_mov_b32 s7, 0xf000
; FLAT-NEXT:    s_mov_b32 s6, -1
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    s_mov_b32 s4, s0
; FLAT-NEXT:    s_mov_b32 s5, s1
; FLAT-NEXT:    s_brev_b64 s[0:1], s[2:3]
; FLAT-NEXT:    v_mov_b32_e32 v0, s0
; FLAT-NEXT:    v_mov_b32_e32 v1, s1
; FLAT-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: s_brev_i64:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_brev_b64 s[2:3], s[2:3]
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: s_brev_i64:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    s_brev_b64 s[4:5], s[2:3]
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: s_brev_i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_brev_b64 s[2:3], s[2:3]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %brev = call i64 @llvm.bitreverse.i64(i64 %val) #1
  store i64 %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_brev_i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) #0 {
; SI-LABEL: v_brev_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bfrev_b32_e32 v2, v0
; SI-NEXT:    v_bfrev_b32_e32 v1, v1
; SI-NEXT:    buffer_store_dwordx2 v[1:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: v_brev_i64:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    v_mov_b32_e32 v1, s3
; FLAT-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; FLAT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; FLAT-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt vmcnt(0)
; FLAT-NEXT:    v_bfrev_b32_e32 v2, v0
; FLAT-NEXT:    v_bfrev_b32_e32 v1, v1
; FLAT-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: v_brev_i64:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GISEL-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GISEL-NEXT:    v_mov_b32_e32 v4, s1
; GISEL-NEXT:    v_mov_b32_e32 v3, s0
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    v_bfrev_b32_e32 v1, v1
; GISEL-NEXT:    v_bfrev_b32_e32 v2, v0
; GISEL-NEXT:    flat_store_dwordx2 v[3:4], v[1:2]
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: v_brev_i64:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLAT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLAT-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    global_load_b64 v[0:1], v0, s[2:3]
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v2, v0
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v1, v1
; GFX11-FLAT-NEXT:    buffer_store_b64 v[1:2], off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_brev_i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b64 v[0:1], v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v1, v1
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v2, v0
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    global_store_b64 v0, v[1:2], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr i64, ptr addrspace(1) %valptr, i32 %tid
  %val = load i64, ptr addrspace(1) %gep
  %brev = call i64 @llvm.bitreverse.i64(i64 %val) #1
  store i64 %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_brev_v2i64(ptr addrspace(1) noalias %out, <2 x i64> %val) #0 {
; SI-LABEL: s_brev_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0xd
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_brev_b64 s[6:7], s[6:7]
; SI-NEXT:    s_brev_b64 s[4:5], s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: s_brev_v2i64:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x34
; FLAT-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    s_brev_b64 s[6:7], s[6:7]
; FLAT-NEXT:    s_brev_b64 s[4:5], s[4:5]
; FLAT-NEXT:    v_mov_b32_e32 v0, s4
; FLAT-NEXT:    v_mov_b32_e32 v1, s5
; FLAT-NEXT:    v_mov_b32_e32 v2, s6
; FLAT-NEXT:    v_mov_b32_e32 v3, s7
; FLAT-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: s_brev_v2i64:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x34
; GISEL-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_brev_b64 s[0:1], s[4:5]
; GISEL-NEXT:    s_brev_b64 s[2:3], s[6:7]
; GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-NEXT:    v_mov_b32_e32 v4, s8
; GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GISEL-NEXT:    v_mov_b32_e32 v3, s3
; GISEL-NEXT:    v_mov_b32_e32 v5, s9
; GISEL-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: s_brev_v2i64:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_clause 0x1
; GFX11-FLAT-NEXT:    s_load_b128 s[4:7], s[2:3], 0x34
; GFX11-FLAT-NEXT:    s_load_b64 s[0:1], s[2:3], 0x24
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    s_brev_b64 s[2:3], s[4:5]
; GFX11-FLAT-NEXT:    s_brev_b64 s[4:5], s[6:7]
; GFX11-FLAT-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-FLAT-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    buffer_store_b128 v[0:3], off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: s_brev_v2i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b128 s[4:7], s[2:3], 0x34
; GFX11-GISEL-NEXT:    s_load_b64 s[8:9], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_brev_b64 s[0:1], s[4:5]
; GFX11-GISEL-NEXT:    s_brev_b64 s[2:3], s[6:7]
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-GISEL-NEXT:    global_store_b128 v4, v[0:3], s[8:9]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %brev = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %val) #1
  store <2 x i64> %brev, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_brev_v2i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) #0 {
; SI-LABEL: v_brev_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_bfrev_b32_e32 v4, v2
; SI-NEXT:    v_bfrev_b32_e32 v3, v3
; SI-NEXT:    v_bfrev_b32_e32 v2, v0
; SI-NEXT:    v_bfrev_b32_e32 v1, v1
; SI-NEXT:    buffer_store_dwordx4 v[1:4], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; FLAT-LABEL: v_brev_v2i64:
; FLAT:       ; %bb.0:
; FLAT-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; FLAT-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; FLAT-NEXT:    v_mov_b32_e32 v1, s3
; FLAT-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; FLAT-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; FLAT-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; FLAT-NEXT:    s_mov_b32 s3, 0xf000
; FLAT-NEXT:    s_mov_b32 s2, -1
; FLAT-NEXT:    s_waitcnt vmcnt(0)
; FLAT-NEXT:    v_bfrev_b32_e32 v4, v2
; FLAT-NEXT:    v_bfrev_b32_e32 v3, v3
; FLAT-NEXT:    v_bfrev_b32_e32 v2, v0
; FLAT-NEXT:    v_bfrev_b32_e32 v1, v1
; FLAT-NEXT:    buffer_store_dwordx4 v[1:4], off, s[0:3], 0
; FLAT-NEXT:    s_endpgm
;
; GISEL-LABEL: v_brev_v2i64:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; GISEL-NEXT:    v_lshlrev_b32_e32 v2, 4, v0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GISEL-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    v_bfrev_b32_e32 v4, v1
; GISEL-NEXT:    v_bfrev_b32_e32 v5, v0
; GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-NEXT:    v_bfrev_b32_e32 v6, v3
; GISEL-NEXT:    v_bfrev_b32_e32 v7, v2
; GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GISEL-NEXT:    s_endpgm
;
; GFX11-FLAT-LABEL: v_brev_v2i64:
; GFX11-FLAT:       ; %bb.0:
; GFX11-FLAT-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-FLAT-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FLAT-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLAT-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX11-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLAT-NEXT:    global_load_b128 v[0:3], v0, s[2:3]
; GFX11-FLAT-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-FLAT-NEXT:    s_mov_b32 s2, -1
; GFX11-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v4, v2
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v3, v3
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v2, v0
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v1, v1
; GFX11-FLAT-NEXT:    buffer_store_b128 v[1:4], off, s[0:3], 0
; GFX11-FLAT-NEXT:    s_nop 0
; GFX11-FLAT-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLAT-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_brev_v2i64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b128 v[0:3], v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v4, v1
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v5, v0
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v6, v3
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v7, v2
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    global_store_b128 v0, v[4:7], s[0:1]
; GFX11-GISEL-NEXT:    s_nop 0
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x i64> , ptr addrspace(1) %valptr, i32 %tid
  %val = load <2 x i64>, ptr addrspace(1) %gep
  %brev = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %val) #1
  store <2 x i64> %brev, ptr addrspace(1) %out
  ret void
}

define float @missing_truncate_promote_bitreverse(i32 %arg) {
; SI-LABEL: missing_truncate_promote_bitreverse:
; SI:       ; %bb.0: ; %bb
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_bfrev_b32_e32 v0, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; FLAT-LABEL: missing_truncate_promote_bitreverse:
; FLAT:       ; %bb.0: ; %bb
; FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; FLAT-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: missing_truncate_promote_bitreverse:
; GISEL:       ; %bb.0: ; %bb
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    v_bfrev_b32_e32 v0, v0
; GISEL-NEXT:    v_cvt_f32_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FLAT-LABEL: missing_truncate_promote_bitreverse:
; GFX11-FLAT:       ; %bb.0: ; %bb
; GFX11-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FLAT-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-FLAT-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FLAT-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FLAT-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: missing_truncate_promote_bitreverse:
; GFX11-GISEL:       ; %bb.0: ; %bb
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfrev_b32_e32 v0, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
bb:
  %tmp = trunc i32 %arg to i16
  %tmp1 = call i16 @llvm.bitreverse.i16(i16 %tmp)
  %tmp2 = bitcast i16 %tmp1 to half
  %tmp3 = fpext half %tmp2 to float
  ret float %tmp3
}

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
