; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=hawaii -mattr=+flat-for-global < %s | FileCheck -enable-var-scope --check-prefixes=GCN,GCN-SAFE,SI,SI-SAFE %s
; RUN: llc -enable-no-signed-zeros-fp-math -mtriple=amdgcn -mcpu=hawaii -mattr=+flat-for-global < %s | FileCheck -enable-var-scope --check-prefixes=GCN,GCN-NSZ,SI,SI-NSZ %s

; RUN: llc -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -enable-var-scope --check-prefixes=GCN,GCN-SAFE,VI,VI-SAFE %s
; RUN: llc -enable-no-signed-zeros-fp-math -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -enable-var-scope --check-prefixes=GCN,GCN-NSZ,VI,VI-NSZ %s

; --------------------------------------------------------------------------------
; fadd tests
; --------------------------------------------------------------------------------

define float @v_fneg_add_f32(float %a, float %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_add_f32_e32 v0, v0, v1
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_sub_f32_e64 v0, -v0, v1
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd float %a, %b
  %fneg = fneg float %add
  ret float %fneg
}

define { float, float } @v_fneg_add_store_use_add_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_add_store_use_add_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f32_e32 v1, v0, v1
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd float %a, %b
  %fneg = fneg float %add
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %add, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_add_multi_use_add_f32(float %a, float %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_multi_use_add_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_add_f32_e32 v1, v0, v1
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_multi_use_add_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_sub_f32_e64 v0, -v0, v1
; GCN-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd float %a, %b
  %fneg = fneg float %add
  %use1 = fmul float %add, 4.0

  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

define float @v_fneg_add_fneg_x_f32(float %a, float %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_fneg_x_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_sub_f32_e32 v0, v1, v0
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_fneg_x_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_sub_f32_e32 v0, v0, v1
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %add = fadd float %fneg.a, %b
  %fneg = fneg float %add
  ret float %fneg
}

define float @v_fneg_add_x_fneg_f32(float %a, float %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_x_fneg_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_sub_f32_e32 v0, v0, v1
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_x_fneg_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_sub_f32_e32 v0, v1, v0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg float %b
  %add = fadd float %a, %fneg.b
  %fneg = fneg float %add
  ret float %fneg
}

define float @v_fneg_add_fneg_fneg_f32(float %a, float %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_fneg_fneg_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_sub_f32_e64 v0, -v0, v1
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_fneg_fneg_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f32_e32 v0, v0, v1
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fneg.b = fneg float %b
  %add = fadd float %fneg.a, %fneg.b
  %fneg = fneg float %add
  ret float %fneg
}

define { float, float } @v_fneg_add_store_use_fneg_x_f32(float %a, float %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_store_use_fneg_x_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; GCN-SAFE-NEXT:    v_sub_f32_e32 v0, v1, v0
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    v_mov_b32_e32 v1, v2
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_store_use_fneg_x_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; GCN-NSZ-NEXT:    v_sub_f32_e32 v0, v0, v1
; GCN-NSZ-NEXT:    v_mov_b32_e32 v1, v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %add = fadd float %fneg.a, %b
  %fneg = fneg float %add
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fneg.a, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_add_multi_use_fneg_x_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_add_multi_use_fneg_x_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_sub_f32_e32 v1, v1, v0
; GCN-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v1
; GCN-SAFE-NEXT:    v_mul_f32_e64 v1, -v0, v2
; GCN-SAFE-NEXT:    v_mov_b32_e32 v0, v3
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_multi_use_fneg_x_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_sub_f32_e32 v3, v0, v1
; GCN-NSZ-NEXT:    v_mul_f32_e64 v1, -v0, v2
; GCN-NSZ-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %add = fadd float %fneg.a, %b
  %fneg = fneg float %add
  %use1 = fmul float %fneg.a, %c

  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

; This one asserted with -enable-no-signed-zeros-fp-math
define amdgpu_ps float @fneg_fadd_0_f32(float inreg %tmp2, float inreg %tmp6, <4 x i32> %arg) #0 {
; SI-SAFE-LABEL: fneg_fadd_0_f32:
; SI-SAFE:       ; %bb.0: ; %.entry
; SI-SAFE-NEXT:    v_div_scale_f32 v0, s[2:3], s1, s1, 1.0
; SI-SAFE-NEXT:    v_rcp_f32_e32 v1, v0
; SI-SAFE-NEXT:    v_div_scale_f32 v2, vcc, 1.0, s1, 1.0
; SI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; SI-SAFE-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; SI-SAFE-NEXT:    v_fma_f32 v1, v3, v1, v1
; SI-SAFE-NEXT:    v_mul_f32_e32 v3, v2, v1
; SI-SAFE-NEXT:    v_fma_f32 v4, -v0, v3, v2
; SI-SAFE-NEXT:    v_fma_f32 v3, v4, v1, v3
; SI-SAFE-NEXT:    v_fma_f32 v0, -v0, v3, v2
; SI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; SI-SAFE-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; SI-SAFE-NEXT:    v_div_fixup_f32 v0, v0, s1, 1.0
; SI-SAFE-NEXT:    v_mad_f32 v0, v0, 0, 0
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, s0
; SI-SAFE-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; SI-SAFE-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; SI-SAFE-NEXT:    ; return to shader part epilog
;
; SI-NSZ-LABEL: fneg_fadd_0_f32:
; SI-NSZ:       ; %bb.0: ; %.entry
; SI-NSZ-NEXT:    v_div_scale_f32 v0, s[2:3], s1, s1, 1.0
; SI-NSZ-NEXT:    v_rcp_f32_e32 v1, v0
; SI-NSZ-NEXT:    v_div_scale_f32 v2, vcc, 1.0, s1, 1.0
; SI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; SI-NSZ-NEXT:    v_fma_f32 v3, -v0, v1, 1.0
; SI-NSZ-NEXT:    v_fma_f32 v1, v3, v1, v1
; SI-NSZ-NEXT:    v_mul_f32_e32 v3, v2, v1
; SI-NSZ-NEXT:    v_fma_f32 v4, -v0, v3, v2
; SI-NSZ-NEXT:    v_fma_f32 v3, v4, v1, v3
; SI-NSZ-NEXT:    v_fma_f32 v0, -v0, v3, v2
; SI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; SI-NSZ-NEXT:    v_div_fmas_f32 v0, v0, v1, v3
; SI-NSZ-NEXT:    v_div_fixup_f32 v0, v0, s1, 1.0
; SI-NSZ-NEXT:    v_mul_f32_e32 v0, 0, v0
; SI-NSZ-NEXT:    v_mov_b32_e32 v1, s0
; SI-NSZ-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; SI-NSZ-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; SI-NSZ-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; SI-NSZ-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; SI-NSZ-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; SI-NSZ-NEXT:    ; return to shader part epilog
;
; VI-SAFE-LABEL: fneg_fadd_0_f32:
; VI-SAFE:       ; %bb.0: ; %.entry
; VI-SAFE-NEXT:    v_div_scale_f32 v0, s[2:3], s1, s1, 1.0
; VI-SAFE-NEXT:    v_div_scale_f32 v1, vcc, 1.0, s1, 1.0
; VI-SAFE-NEXT:    v_rcp_f32_e32 v2, v0
; VI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; VI-SAFE-NEXT:    v_fma_f32 v3, -v0, v2, 1.0
; VI-SAFE-NEXT:    v_fma_f32 v2, v3, v2, v2
; VI-SAFE-NEXT:    v_mul_f32_e32 v3, v1, v2
; VI-SAFE-NEXT:    v_fma_f32 v4, -v0, v3, v1
; VI-SAFE-NEXT:    v_fma_f32 v3, v4, v2, v3
; VI-SAFE-NEXT:    v_fma_f32 v0, -v0, v3, v1
; VI-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; VI-SAFE-NEXT:    v_div_fmas_f32 v0, v0, v2, v3
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, s0
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; VI-SAFE-NEXT:    v_div_fixup_f32 v0, v0, s1, 1.0
; VI-SAFE-NEXT:    v_mad_f32 v0, v0, 0, 0
; VI-SAFE-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, vcc
; VI-SAFE-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-SAFE-NEXT:    ; return to shader part epilog
;
; VI-NSZ-LABEL: fneg_fadd_0_f32:
; VI-NSZ:       ; %bb.0: ; %.entry
; VI-NSZ-NEXT:    v_div_scale_f32 v0, s[2:3], s1, s1, 1.0
; VI-NSZ-NEXT:    v_div_scale_f32 v1, vcc, 1.0, s1, 1.0
; VI-NSZ-NEXT:    v_rcp_f32_e32 v2, v0
; VI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; VI-NSZ-NEXT:    v_fma_f32 v3, -v0, v2, 1.0
; VI-NSZ-NEXT:    v_fma_f32 v2, v3, v2, v2
; VI-NSZ-NEXT:    v_mul_f32_e32 v3, v1, v2
; VI-NSZ-NEXT:    v_fma_f32 v4, -v0, v3, v1
; VI-NSZ-NEXT:    v_fma_f32 v3, v4, v2, v3
; VI-NSZ-NEXT:    v_fma_f32 v0, -v0, v3, v1
; VI-NSZ-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; VI-NSZ-NEXT:    v_div_fmas_f32 v0, v0, v2, v3
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, s0
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; VI-NSZ-NEXT:    v_div_fixup_f32 v0, v0, s1, 1.0
; VI-NSZ-NEXT:    v_mul_f32_e32 v0, 0, v0
; VI-NSZ-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, vcc
; VI-NSZ-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-NSZ-NEXT:    ; return to shader part epilog
.entry:
  %tmp7 = fdiv float 1.000000e+00, %tmp6
  %tmp8 = fmul float 0.000000e+00, %tmp7
  %tmp9 = fmul reassoc nnan arcp contract float 0.000000e+00, %tmp8
  %.i188 = fadd float %tmp9, 0.000000e+00
  %tmp10 = fcmp uge float %.i188, %tmp2
  %tmp11 = fneg float %.i188
  %.i092 = select i1 %tmp10, float %tmp2, float %tmp11
  %tmp12 = fcmp ule float %.i092, 0.000000e+00
  %.i198 = select i1 %tmp12, float 0.000000e+00, float 0x7FF8000000000000
  ret float %.i198
}

; This is a workaround because -enable-no-signed-zeros-fp-math does not set up
; function attribute unsafe-fp-math automatically. Combine with the previous test
; when that is done.
define amdgpu_ps float @fneg_fadd_0_nsz_f32(float inreg %tmp2, float inreg %tmp6, <4 x i32> %arg) #2 {
; SI-SAFE-LABEL: fneg_fadd_0_nsz_f32:
; SI-SAFE:       ; %bb.0: ; %.entry
; SI-SAFE-NEXT:    v_min_legacy_f32_e64 v0, 0, s0
; SI-SAFE-NEXT:    s_brev_b32 s0, 1
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; SI-SAFE-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; SI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; SI-SAFE-NEXT:    ; return to shader part epilog
;
; GCN-NSZ-LABEL: fneg_fadd_0_nsz_f32:
; GCN-NSZ:       ; %bb.0: ; %.entry
; GCN-NSZ-NEXT:    v_rcp_f32_e32 v0, s1
; GCN-NSZ-NEXT:    v_mov_b32_e32 v1, s0
; GCN-NSZ-NEXT:    v_mul_f32_e32 v0, 0, v0
; GCN-NSZ-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; GCN-NSZ-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; GCN-NSZ-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; GCN-NSZ-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; GCN-NSZ-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; GCN-NSZ-NEXT:    ; return to shader part epilog
;
; VI-SAFE-LABEL: fneg_fadd_0_nsz_f32:
; VI-SAFE:       ; %bb.0: ; %.entry
; VI-SAFE-NEXT:    v_rcp_f32_e32 v0, s1
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, s0
; VI-SAFE-NEXT:    v_mul_f32_e32 v0, 0, v0
; VI-SAFE-NEXT:    v_add_f32_e32 v0, 0, v0
; VI-SAFE-NEXT:    v_cmp_ngt_f32_e32 vcc, s0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; VI-SAFE-NEXT:    v_mov_b32_e32 v1, 0x7fc00000
; VI-SAFE-NEXT:    v_cmp_nlt_f32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; VI-SAFE-NEXT:    ; return to shader part epilog
.entry:
  %tmp7 = fdiv afn float 1.000000e+00, %tmp6
  %tmp8 = fmul float 0.000000e+00, %tmp7
  %tmp9 = fmul reassoc nnan arcp contract float 0.000000e+00, %tmp8
  %.i188 = fadd float %tmp9, 0.000000e+00
  %tmp10 = fcmp uge float %.i188, %tmp2
  %tmp11 = fneg float %.i188
  %.i092 = select i1 %tmp10, float %tmp2, float %tmp11
  %tmp12 = fcmp ule float %.i092, 0.000000e+00
  %.i198 = select i1 %tmp12, float 0.000000e+00, float 0x7FF8000000000000
  ret float %.i198
}

define double @v_fneg_add_f64(double %a, double %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_f64:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GCN-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_f64:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f64 v[0:1], -v[0:1], -v[2:3]
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd double %a, %b
  %fneg = fneg double %add
  ret double %fneg
}

define { double, double } @v_fneg_add_store_use_add_f64(double %a, double %b) #0 {
; GCN-LABEL: v_fneg_add_store_use_add_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; GCN-NEXT:    v_mov_b32_e32 v0, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd double %a, %b
  %fneg = fneg double %add
  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %add, 1
  ret { double, double } %insert.1
}

define { double, double } @v_fneg_add_multi_use_add_f64(double %a, double %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_multi_use_add_f64:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; SI-SAFE-NEXT:    v_xor_b32_e32 v4, 0x80000000, v1
; SI-SAFE-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, v4
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_multi_use_add_f64:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f64 v[0:1], -v[0:1], -v[2:3]
; GCN-NSZ-NEXT:    v_mul_f64 v[2:3], v[0:1], -4.0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_multi_use_add_f64:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; VI-SAFE-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %add = fadd double %a, %b
  %fneg = fneg double %add
  %use1 = fmul double %add, 4.0

  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %use1, 1
  ret { double, double } %insert.1
}

define double @v_fneg_add_fneg_x_f64(double %a, double %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_fneg_x_f64:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_add_f64 v[0:1], v[2:3], -v[0:1]
; GCN-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_fneg_x_f64:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f64 v[0:1], v[0:1], -v[2:3]
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %add = fadd double %fneg.a, %b
  %fneg = fneg double %add
  ret double %fneg
}

define double @v_fneg_add_x_fneg_f64(double %a, double %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_x_fneg_f64:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_add_f64 v[0:1], v[0:1], -v[2:3]
; GCN-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_x_fneg_f64:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f64 v[0:1], v[2:3], -v[0:1]
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg double %b
  %add = fadd double %a, %fneg.b
  %fneg = fneg double %add
  ret double %fneg
}

define double @v_fneg_add_fneg_fneg_f64(double %a, double %b) #0 {
; GCN-SAFE-LABEL: v_fneg_add_fneg_fneg_f64:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_add_f64 v[0:1], -v[0:1], -v[2:3]
; GCN-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_fneg_fneg_f64:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fneg.b = fneg double %b
  %add = fadd double %fneg.a, %fneg.b
  %fneg = fneg double %add
  ret double %fneg
}

define { double, double } @v_fneg_add_store_use_fneg_x_f64(double %a, double %b) #0 {
; SI-SAFE-LABEL: v_fneg_add_store_use_fneg_x_f64:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_mov_b32_e32 v5, v1
; SI-SAFE-NEXT:    v_mov_b32_e32 v4, v0
; SI-SAFE-NEXT:    v_add_f64 v[0:1], v[2:3], -v[4:5]
; SI-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v5
; SI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; SI-SAFE-NEXT:    v_mov_b32_e32 v2, v4
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-NSZ-LABEL: v_fneg_add_store_use_fneg_x_f64:
; SI-NSZ:       ; %bb.0:
; SI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NSZ-NEXT:    v_mov_b32_e32 v5, v1
; SI-NSZ-NEXT:    v_mov_b32_e32 v4, v0
; SI-NSZ-NEXT:    v_add_f64 v[0:1], v[4:5], -v[2:3]
; SI-NSZ-NEXT:    v_xor_b32_e32 v3, 0x80000000, v5
; SI-NSZ-NEXT:    v_mov_b32_e32 v2, v4
; SI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_store_use_fneg_x_f64:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f64 v[4:5], v[2:3], -v[0:1]
; VI-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v1
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, v0
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v5
; VI-SAFE-NEXT:    v_mov_b32_e32 v0, v4
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: v_fneg_add_store_use_fneg_x_f64:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_add_f64 v[4:5], v[0:1], -v[2:3]
; VI-NSZ-NEXT:    v_xor_b32_e32 v3, 0x80000000, v1
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, v0
; VI-NSZ-NEXT:    v_mov_b32_e32 v0, v4
; VI-NSZ-NEXT:    v_mov_b32_e32 v1, v5
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %add = fadd double %fneg.a, %b
  %fneg = fneg double %add
  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %fneg.a, 1
  ret { double, double } %insert.1
}

define { double, double } @v_fneg_add_multi_use_fneg_x_f64(double %a, double %b, double %c) #0 {
; SI-SAFE-LABEL: v_fneg_add_multi_use_fneg_x_f64:
; SI-SAFE:       ; %bb.0:
; SI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SAFE-NEXT:    v_add_f64 v[6:7], v[2:3], -v[0:1]
; SI-SAFE-NEXT:    v_mul_f64 v[2:3], -v[0:1], v[4:5]
; SI-SAFE-NEXT:    v_xor_b32_e32 v7, 0x80000000, v7
; SI-SAFE-NEXT:    v_mov_b32_e32 v0, v6
; SI-SAFE-NEXT:    v_mov_b32_e32 v1, v7
; SI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_add_multi_use_fneg_x_f64:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_add_f64 v[6:7], v[0:1], -v[2:3]
; GCN-NSZ-NEXT:    v_mul_f64 v[2:3], -v[0:1], v[4:5]
; GCN-NSZ-NEXT:    v_mov_b32_e32 v0, v6
; GCN-NSZ-NEXT:    v_mov_b32_e32 v1, v7
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: v_fneg_add_multi_use_fneg_x_f64:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f64 v[6:7], v[2:3], -v[0:1]
; VI-SAFE-NEXT:    v_mul_f64 v[2:3], -v[0:1], v[4:5]
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v7
; VI-SAFE-NEXT:    v_mov_b32_e32 v0, v6
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %add = fadd double %fneg.a, %b
  %fneg = fneg double %add
  %use1 = fmul double %fneg.a, %c

  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %use1, 1
  ret { double, double } %insert.1
}

; This one asserted with -enable-no-signed-zeros-fp-math
define amdgpu_ps double @fneg_fadd_0_f64(double inreg %tmp2, double inreg %tmp6, <4 x i32> %arg) #0 {
; SI-SAFE-LABEL: fneg_fadd_0_f64:
; SI-SAFE:       ; %bb.0: ; %.entry
; SI-SAFE-NEXT:    v_div_scale_f64 v[0:1], s[4:5], s[2:3], s[2:3], 1.0
; SI-SAFE-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SAFE-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SAFE-NEXT:    v_fma_f64 v[2:3], v[2:3], v[4:5], v[2:3]
; SI-SAFE-NEXT:    v_div_scale_f64 v[4:5], vcc, 1.0, s[2:3], 1.0
; SI-SAFE-NEXT:    v_fma_f64 v[6:7], -v[0:1], v[2:3], 1.0
; SI-SAFE-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SAFE-NEXT:    v_mul_f64 v[6:7], v[4:5], v[2:3]
; SI-SAFE-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[6:7], v[4:5]
; SI-SAFE-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[6:7]
; SI-SAFE-NEXT:    v_mov_b32_e32 v2, s1
; SI-SAFE-NEXT:    v_mov_b32_e32 v3, s0
; SI-SAFE-NEXT:    v_div_fixup_f64 v[0:1], v[0:1], s[2:3], 1.0
; SI-SAFE-NEXT:    v_mul_f64 v[0:1], v[0:1], 0
; SI-SAFE-NEXT:    v_add_f64 v[0:1], v[0:1], 0
; SI-SAFE-NEXT:    v_cmp_ngt_f64_e32 vcc, s[0:1], v[0:1]
; SI-SAFE-NEXT:    v_xor_b32_e32 v4, 0x80000000, v1
; SI-SAFE-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; SI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-SAFE-NEXT:    v_cmp_nlt_f64_e32 vcc, 0, v[0:1]
; SI-SAFE-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-SAFE-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; SI-SAFE-NEXT:    s_mov_b32 s0, 0
; SI-SAFE-NEXT:    ; return to shader part epilog
;
; SI-NSZ-LABEL: fneg_fadd_0_f64:
; SI-NSZ:       ; %bb.0: ; %.entry
; SI-NSZ-NEXT:    v_div_scale_f64 v[0:1], s[4:5], s[2:3], s[2:3], 1.0
; SI-NSZ-NEXT:    s_mov_b32 s4, 0
; SI-NSZ-NEXT:    s_brev_b32 s5, 1
; SI-NSZ-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-NSZ-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-NSZ-NEXT:    v_fma_f64 v[2:3], v[2:3], v[4:5], v[2:3]
; SI-NSZ-NEXT:    v_div_scale_f64 v[4:5], vcc, 1.0, s[2:3], 1.0
; SI-NSZ-NEXT:    v_fma_f64 v[6:7], -v[0:1], v[2:3], 1.0
; SI-NSZ-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-NSZ-NEXT:    v_mul_f64 v[6:7], v[4:5], v[2:3]
; SI-NSZ-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[6:7], v[4:5]
; SI-NSZ-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[6:7]
; SI-NSZ-NEXT:    v_mov_b32_e32 v2, s1
; SI-NSZ-NEXT:    v_mov_b32_e32 v3, s0
; SI-NSZ-NEXT:    v_div_fixup_f64 v[0:1], v[0:1], s[2:3], 1.0
; SI-NSZ-NEXT:    v_mul_f64 v[0:1], v[0:1], s[4:5]
; SI-NSZ-NEXT:    v_cmp_nlt_f64_e64 vcc, -v[0:1], s[0:1]
; SI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-NSZ-NEXT:    v_cmp_nlt_f64_e32 vcc, 0, v[0:1]
; SI-NSZ-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-NSZ-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; SI-NSZ-NEXT:    s_mov_b32 s0, 0
; SI-NSZ-NEXT:    ; return to shader part epilog
;
; VI-SAFE-LABEL: fneg_fadd_0_f64:
; VI-SAFE:       ; %bb.0: ; %.entry
; VI-SAFE-NEXT:    v_div_scale_f64 v[0:1], s[4:5], s[2:3], s[2:3], 1.0
; VI-SAFE-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SAFE-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SAFE-NEXT:    v_fma_f64 v[2:3], v[2:3], v[4:5], v[2:3]
; VI-SAFE-NEXT:    v_div_scale_f64 v[4:5], vcc, 1.0, s[2:3], 1.0
; VI-SAFE-NEXT:    v_fma_f64 v[6:7], -v[0:1], v[2:3], 1.0
; VI-SAFE-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SAFE-NEXT:    v_mul_f64 v[6:7], v[4:5], v[2:3]
; VI-SAFE-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[6:7], v[4:5]
; VI-SAFE-NEXT:    v_mov_b32_e32 v4, s0
; VI-SAFE-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[6:7]
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, s1
; VI-SAFE-NEXT:    v_div_fixup_f64 v[0:1], v[0:1], s[2:3], 1.0
; VI-SAFE-NEXT:    v_mul_f64 v[0:1], v[0:1], 0
; VI-SAFE-NEXT:    v_add_f64 v[0:1], v[0:1], 0
; VI-SAFE-NEXT:    v_cmp_ngt_f64_e32 vcc, s[0:1], v[0:1]
; VI-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v1
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; VI-SAFE-NEXT:    v_cmp_nlt_f64_e32 vcc, 0, v[0:1]
; VI-SAFE-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-SAFE-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; VI-SAFE-NEXT:    s_mov_b32 s0, 0
; VI-SAFE-NEXT:    ; return to shader part epilog
;
; VI-NSZ-LABEL: fneg_fadd_0_f64:
; VI-NSZ:       ; %bb.0: ; %.entry
; VI-NSZ-NEXT:    v_div_scale_f64 v[0:1], s[4:5], s[2:3], s[2:3], 1.0
; VI-NSZ-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-NSZ-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-NSZ-NEXT:    v_fma_f64 v[2:3], v[2:3], v[4:5], v[2:3]
; VI-NSZ-NEXT:    v_div_scale_f64 v[4:5], vcc, 1.0, s[2:3], 1.0
; VI-NSZ-NEXT:    v_fma_f64 v[6:7], -v[0:1], v[2:3], 1.0
; VI-NSZ-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-NSZ-NEXT:    v_mul_f64 v[6:7], v[4:5], v[2:3]
; VI-NSZ-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[6:7], v[4:5]
; VI-NSZ-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[6:7]
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, s1
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, s0
; VI-NSZ-NEXT:    v_div_fixup_f64 v[0:1], v[0:1], s[2:3], 1.0
; VI-NSZ-NEXT:    s_mov_b32 s2, 0
; VI-NSZ-NEXT:    s_brev_b32 s3, 1
; VI-NSZ-NEXT:    v_mul_f64 v[0:1], v[0:1], s[2:3]
; VI-NSZ-NEXT:    v_cmp_nlt_f64_e64 vcc, -v[0:1], s[0:1]
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; VI-NSZ-NEXT:    v_cmp_nlt_f64_e32 vcc, 0, v[0:1]
; VI-NSZ-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-NSZ-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; VI-NSZ-NEXT:    s_mov_b32 s0, 0
; VI-NSZ-NEXT:    ; return to shader part epilog
.entry:
  %tmp7 = fdiv double 1.000000e+00, %tmp6
  %tmp8 = fmul double 0.000000e+00, %tmp7
  %tmp9 = fmul reassoc nnan arcp contract double 0.000000e+00, %tmp8
  %.i188 = fadd double %tmp9, 0.000000e+00
  %tmp10 = fcmp uge double %.i188, %tmp2
  %tmp11 = fneg double %.i188
  %.i092 = select i1 %tmp10, double %tmp2, double %tmp11
  %tmp12 = fcmp ule double %.i092, 0.000000e+00
  %.i198 = select i1 %tmp12, double 0.000000e+00, double 0x7FF8000000000000
  ret double %.i198
}

; This is a workaround because -enable-no-signed-zeros-fp-math does not set up
; function attribute unsafe-fp-math automatically. Combine with the previous test
; when that is done.
define amdgpu_ps double @fneg_fadd_0_nsz_f64(double inreg %tmp2, double inreg %tmp6, <4 x i32> %arg) #2 {
; GCN-SAFE-LABEL: fneg_fadd_0_nsz_f64:
; GCN-SAFE:       ; %bb.0: ; %.entry
; GCN-SAFE-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[0:1], 0
; GCN-SAFE-NEXT:    s_and_b64 s[2:3], s[2:3], exec
; GCN-SAFE-NEXT:    s_cselect_b32 s1, s1, 0x80000000
; GCN-SAFE-NEXT:    s_cselect_b32 s0, s0, 0
; GCN-SAFE-NEXT:    v_cmp_ngt_f64_e64 s[0:1], s[0:1], 0
; GCN-SAFE-NEXT:    s_and_b64 s[0:1], s[0:1], exec
; GCN-SAFE-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; GCN-SAFE-NEXT:    s_mov_b32 s0, 0
; GCN-SAFE-NEXT:    ; return to shader part epilog
;
; SI-NSZ-LABEL: fneg_fadd_0_nsz_f64:
; SI-NSZ:       ; %bb.0: ; %.entry
; SI-NSZ-NEXT:    v_rcp_f64_e32 v[0:1], s[2:3]
; SI-NSZ-NEXT:    v_fma_f64 v[2:3], -s[2:3], v[0:1], 1.0
; SI-NSZ-NEXT:    v_fma_f64 v[0:1], v[2:3], v[0:1], v[0:1]
; SI-NSZ-NEXT:    v_fma_f64 v[2:3], -s[2:3], v[0:1], 1.0
; SI-NSZ-NEXT:    v_fma_f64 v[0:1], v[2:3], v[0:1], v[0:1]
; SI-NSZ-NEXT:    v_fma_f64 v[2:3], -s[2:3], v[0:1], 1.0
; SI-NSZ-NEXT:    s_mov_b32 s2, 0
; SI-NSZ-NEXT:    v_fma_f64 v[0:1], v[2:3], v[0:1], v[0:1]
; SI-NSZ-NEXT:    s_brev_b32 s3, 1
; SI-NSZ-NEXT:    v_mul_f64 v[0:1], v[0:1], s[2:3]
; SI-NSZ-NEXT:    v_mov_b32_e32 v2, s1
; SI-NSZ-NEXT:    v_cmp_nlt_f64_e64 vcc, -v[0:1], s[0:1]
; SI-NSZ-NEXT:    v_mov_b32_e32 v3, s0
; SI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-NSZ-NEXT:    v_cmp_nlt_f64_e32 vcc, 0, v[0:1]
; SI-NSZ-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-NSZ-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; SI-NSZ-NEXT:    s_mov_b32 s0, 0
; SI-NSZ-NEXT:    ; return to shader part epilog
;
; VI-NSZ-LABEL: fneg_fadd_0_nsz_f64:
; VI-NSZ:       ; %bb.0: ; %.entry
; VI-NSZ-NEXT:    v_rcp_f64_e32 v[0:1], s[2:3]
; VI-NSZ-NEXT:    v_fma_f64 v[2:3], -s[2:3], v[0:1], 1.0
; VI-NSZ-NEXT:    v_fma_f64 v[0:1], v[2:3], v[0:1], v[0:1]
; VI-NSZ-NEXT:    v_fma_f64 v[2:3], -s[2:3], v[0:1], 1.0
; VI-NSZ-NEXT:    v_fma_f64 v[0:1], v[2:3], v[0:1], v[0:1]
; VI-NSZ-NEXT:    v_fma_f64 v[2:3], -s[2:3], v[0:1], 1.0
; VI-NSZ-NEXT:    s_mov_b32 s2, 0
; VI-NSZ-NEXT:    s_brev_b32 s3, 1
; VI-NSZ-NEXT:    v_fma_f64 v[0:1], v[2:3], v[0:1], v[0:1]
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, s1
; VI-NSZ-NEXT:    v_mov_b32_e32 v3, s0
; VI-NSZ-NEXT:    v_mul_f64 v[0:1], v[0:1], s[2:3]
; VI-NSZ-NEXT:    v_cmp_nlt_f64_e64 vcc, -v[0:1], s[0:1]
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; VI-NSZ-NEXT:    v_cmp_nlt_f64_e32 vcc, 0, v[0:1]
; VI-NSZ-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-NSZ-NEXT:    s_cselect_b32 s1, 0, 0x7ff80000
; VI-NSZ-NEXT:    s_mov_b32 s0, 0
; VI-NSZ-NEXT:    ; return to shader part epilog
.entry:
  %tmp7 = fdiv afn double 1.000000e+00, %tmp6
  %tmp8 = fmul double 0.000000e+00, %tmp7
  %tmp9 = fmul reassoc nnan arcp contract double 0.000000e+00, %tmp8
  %.i188 = fadd double %tmp9, 0.000000e+00
  %tmp10 = fcmp uge double %.i188, %tmp2
  %tmp11 = fneg double %.i188
  %.i092 = select i1 %tmp10, double %tmp2, double %tmp11
  %tmp12 = fcmp ule double %.i092, 0.000000e+00
  %.i198 = select i1 %tmp12, double 0.000000e+00, double 0x7FF8000000000000
  ret double %.i198
}

; --------------------------------------------------------------------------------
; fmul tests
; --------------------------------------------------------------------------------

define float @v_fneg_mul_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  ret float %fneg
}

define { float, float } @v_fneg_mul_store_use_mul_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_store_use_mul_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v1, v0, v1
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_mul_multi_use_mul_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_multi_use_mul_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, v0, -v1
; GCN-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  %use1 = fmul float %mul, 4.0
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

define float @v_fneg_mul_fneg_x_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_fneg_x_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul = fmul float %fneg.a, %b
  %fneg = fneg float %mul
  ret float %fneg
}

define float @v_fneg_mul_x_fneg_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_x_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg float %b
  %mul = fmul float %a, %fneg.b
  %fneg = fneg float %mul
  ret float %fneg
}

define float @v_fneg_mul_fneg_fneg_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_fneg_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fneg.b = fneg float %b
  %mul = fmul float %fneg.a, %fneg.b
  %fneg = fneg float %mul
  ret float %fneg
}

define { float, float } @v_fneg_mul_store_use_fneg_x_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_store_use_fneg_x_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    v_mov_b32_e32 v1, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul = fmul float %fneg.a, %b
  %fneg = fneg float %mul
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fneg.a, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_mul_multi_use_fneg_x_f32(float %a, float %b, float %c) #0 {
; GCN-LABEL: v_fneg_mul_multi_use_fneg_x_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v3, v0, v1
; GCN-NEXT:    v_mul_f32_e64 v1, -v0, v2
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul = fmul float %fneg.a, %b
  %fneg = fneg float %mul
  %use1 = fmul float %fneg.a, %c
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; fminnum tests
; --------------------------------------------------------------------------------

define float @v_fneg_minnum_f32_ieee(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_minnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_max_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float %a, float %b)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_minnum_f32_no_ieee(float %a, float %b) #4 {
; GCN-LABEL: v_fneg_minnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e64 v0, -v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float %a, float %b)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_self_minnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_self_minnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float %a, float %a)
  %min.fneg = fneg float %min
  ret float %min.fneg
}

define float @v_fneg_self_minnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_self_minnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float %a, float %a)
  %min.fneg = fneg float %min
  ret float %min.fneg
}

define float @v_fneg_posk_minnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_posk_minnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_max_f32_e32 v0, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 4.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_posk_minnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_posk_minnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e64 v0, -v0, -4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 4.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_negk_minnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_negk_minnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_max_f32_e32 v0, 4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float -4.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_negk_minnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_negk_minnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e64 v0, -v0, 4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float -4.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_0_minnum_f32(float %a) #0 {
; GCN-LABEL: v_fneg_0_minnum_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e32 v0, 0, v0
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call nnan float @llvm.minnum.f32(float 0.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_neg0_minnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_neg0_minnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_max_f32_e32 v0, 0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float -0.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_inv2pi_minnum_f32(float %a) #0 {
; SI-LABEL: v_fneg_inv2pi_minnum_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0xbe22f983, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inv2pi_minnum_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_min_f32_e32 v0, 0.15915494, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 0x3FC45F3060000000, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_neg_inv2pi_minnum_f32(float %a) #0 {
; SI-LABEL: v_fneg_neg_inv2pi_minnum_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0x3e22f983, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg_inv2pi_minnum_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; VI-NEXT:    v_max_f32_e32 v0, 0.15915494, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 0xBFC45F3060000000, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define half @v_fneg_inv2pi_minnum_f16(half %a) #0 {
; SI-LABEL: v_fneg_inv2pi_minnum_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0xbe230000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inv2pi_minnum_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e32 v0, v0, v0
; VI-NEXT:    v_min_f16_e32 v0, 0.15915494, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0xH3118, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define half @v_fneg_neg_inv2pi_minnum_f16(half %a) #0 {
; SI-LABEL: v_fneg_neg_inv2pi_minnum_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0x3e230000, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg_inv2pi_minnum_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f16_e64 v0, -v0, -v0
; VI-NEXT:    v_max_f16_e32 v0, 0.15915494, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call half @llvm.minnum.f16(half 0xHB118, half %a)
  %fneg = fneg half %min
  ret half %fneg
}

define double @v_fneg_inv2pi_minnum_f64(double %a) #0 {
; SI-LABEL: v_fneg_inv2pi_minnum_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; SI-NEXT:    s_mov_b32 s4, 0x6dc9c882
; SI-NEXT:    s_mov_b32 s5, 0xbfc45f30
; SI-NEXT:    v_max_f64 v[0:1], v[0:1], s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inv2pi_minnum_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; VI-NEXT:    v_min_f64 v[0:1], v[0:1], 0.15915494309189532
; VI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call double @llvm.minnum.f64(double 0x3fc45f306dc9c882, double %a)
  %fneg = fneg double %min
  ret double %fneg
}

define double @v_fneg_neg_inv2pi_minnum_f64(double %a) #0 {
; SI-LABEL: v_fneg_neg_inv2pi_minnum_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; SI-NEXT:    s_mov_b32 s4, 0x6dc9c882
; SI-NEXT:    s_mov_b32 s5, 0x3fc45f30
; SI-NEXT:    v_max_f64 v[0:1], v[0:1], s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_neg_inv2pi_minnum_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; VI-NEXT:    v_max_f64 v[0:1], v[0:1], 0.15915494309189532
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call double @llvm.minnum.f64(double 0xbfc45f306dc9c882, double %a)
  %fneg = fneg double %min
  ret double %fneg
}

define float @v_fneg_neg0_minnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_neg0_minnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e64 v0, -v0, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float -0.0, float %a)
  %fneg = fneg float %min
  ret float %fneg
}

define float @v_fneg_0_minnum_foldable_use_f32_ieee(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_0_minnum_foldable_use_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GCN-NEXT:    v_min_f32_e32 v0, 0, v0
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 0.0, float %a)
  %fneg = fneg float %min
  %mul = fmul float %fneg, %b
  ret float %mul
}

define float @v_fneg_inv2pi_minnum_foldable_use_f32(float %a, float %b) #0 {
; SI-LABEL: v_fneg_inv2pi_minnum_foldable_use_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; SI-NEXT:    v_max_f32_e32 v0, 0xbe22f983, v0
; SI-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_inv2pi_minnum_foldable_use_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_min_f32_e32 v0, 0.15915494, v0
; VI-NEXT:    v_mul_f32_e64 v0, -v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 0x3FC45F3060000000, float %a)
  %fneg = fneg float %min
  %mul = fmul float %fneg, %b
  ret float %mul
}

define float @v_fneg_0_minnum_foldable_use_f32_no_ieee(float %a, float %b) #4 {
; GCN-LABEL: v_fneg_0_minnum_foldable_use_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e32 v0, 0, v0
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float 0.0, float %a)
  %fneg = fneg float %min
  %mul = fmul float %fneg, %b
  ret float %mul
}

define { float, float } @v_fneg_minnum_multi_use_minnum_f32_ieee(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_minnum_multi_use_minnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_max_f32_e32 v0, v0, v1
; GCN-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float %a, float %b)
  %fneg = fneg float %min
  %use1 = fmul float %min, 4.0
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

define <2 x float> @v_fneg_minnum_multi_use_minnum_f32_no_ieee(float %a, float %b) #4 {
; GCN-LABEL: v_fneg_minnum_multi_use_minnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e64 v0, -v0, -v1
; GCN-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %min = call float @llvm.minnum.f32(float %a, float %b)
  %fneg = fneg float %min
  %use1 = fmul float %min, 4.0
  %ins0 = insertelement <2 x float> undef, float %fneg, i32 0
  %ins1 = insertelement <2 x float> %ins0, float %use1, i32 1
  ret <2 x float> %ins1
}

; --------------------------------------------------------------------------------
; fmaxnum tests
; --------------------------------------------------------------------------------

define float @v_fneg_maxnum_f32_ieee(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_maxnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float %a, float %b)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_maxnum_f32_no_ieee(float %a, float %b) #4 {
; GCN-LABEL: v_fneg_maxnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e64 v0, -v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float %a, float %b)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_self_maxnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_self_maxnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float %a, float %a)
  %max.fneg = fneg float %max
  ret float %max.fneg
}

define float @v_fneg_self_maxnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_self_maxnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float %a, float %a)
  %max.fneg = fneg float %max
  ret float %max.fneg
}

define float @v_fneg_posk_maxnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_posk_maxnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_min_f32_e32 v0, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float 4.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_posk_maxnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_posk_maxnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e64 v0, -v0, -4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float 4.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_negk_maxnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_negk_maxnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_min_f32_e32 v0, 4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float -4.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_negk_maxnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_negk_maxnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e64 v0, -v0, 4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float -4.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_0_maxnum_f32(float %a) #0 {
; GCN-LABEL: v_fneg_0_maxnum_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e32 v0, 0, v0
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call nnan float @llvm.maxnum.f32(float 0.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_neg0_maxnum_f32_ieee(float %a) #0 {
; GCN-LABEL: v_fneg_neg0_maxnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_min_f32_e32 v0, 0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float -0.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_neg0_maxnum_f32_no_ieee(float %a) #4 {
; GCN-LABEL: v_fneg_neg0_maxnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e64 v0, -v0, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float -0.0, float %a)
  %fneg = fneg float %max
  ret float %fneg
}

define float @v_fneg_0_maxnum_foldable_use_f32_ieee(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_0_maxnum_foldable_use_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GCN-NEXT:    v_max_f32_e32 v0, 0, v0
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float 0.0, float %a)
  %fneg = fneg float %max
  %mul = fmul float %fneg, %b
  ret float %mul
}

define float @v_fneg_0_maxnum_foldable_use_f32_no_ieee(float %a, float %b) #4 {
; GCN-LABEL: v_fneg_0_maxnum_foldable_use_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e32 v0, 0, v0
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float 0.0, float %a)
  %fneg = fneg float %max
  %mul = fmul float %fneg, %b
  ret float %mul
}

define { float, float } @v_fneg_maxnum_multi_use_maxnum_f32_ieee(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_maxnum_multi_use_maxnum_f32_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float %a, float %b)
  %fneg = fneg float %max
  %use1 = fmul float %max, 4.0
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

define <2 x float> @v_fneg_maxnum_multi_use_maxnum_f32_no_ieee(float %a, float %b) #4 {
; GCN-LABEL: v_fneg_maxnum_multi_use_maxnum_f32_no_ieee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e64 v0, -v0, -v1
; GCN-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %max = call float @llvm.maxnum.f32(float %a, float %b)
  %fneg = fneg float %max
  %use1 = fmul float %max, 4.0
  %ins0 = insertelement <2 x float> undef, float %fneg, i32 0
  %ins1 = insertelement <2 x float> %ins0, float %use1, i32 1
  ret <2 x float> %ins1
}

; --------------------------------------------------------------------------------
; fma tests
; --------------------------------------------------------------------------------

define float @v_fneg_fma_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v0, v0, v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, -v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.fma.f32(float %a, float %b, float %c)
  %fneg = fneg float %fma
  ret float %fneg
}

define { float, float } @v_fneg_fma_store_use_fma_f32(float %a, float %b, float %c) #0 {
; GCN-LABEL: v_fneg_fma_store_use_fma_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f32 v1, v0, v1, v2
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.fma.f32(float %a, float %b, float %c)
  %fneg = fneg float %fma
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fma, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_fma_multi_use_fma_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_multi_use_fma_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v1, v0, v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_multi_use_fma_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, -v2
; GCN-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.fma.f32(float %a, float %b, float %c)
  %fneg = fneg float %fma
  %use1 = fmul float %fma, 4.0
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

define float @v_fneg_fma_fneg_x_y_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_fneg_x_y_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v0, -v0, v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_fneg_x_y_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, v1, -v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fma = call float @llvm.fma.f32(float %fneg.a, float %b, float %c)
  %fneg = fneg float %fma
  ret float %fneg
}

define float @v_fneg_fma_x_fneg_y_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_x_fneg_y_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v0, v0, -v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_x_fneg_y_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, v1, -v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg float %b
  %fma = call float @llvm.fma.f32(float %a, float %fneg.b, float %c)
  %fneg = fneg float %fma
  ret float %fneg
}

define float @v_fneg_fma_fneg_fneg_y_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_fneg_fneg_y_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v0, v0, v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_fneg_fneg_y_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, -v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fneg.b = fneg float %b
  %fma = call float @llvm.fma.f32(float %fneg.a, float %fneg.b, float %c)
  %fneg = fneg float %fma
  ret float %fneg
}

define float @v_fneg_fma_fneg_x_fneg_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_fneg_x_fneg_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v0, -v0, v1, -v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_fneg_x_fneg_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, v1, v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fneg.c = fneg float %c
  %fma = call float @llvm.fma.f32(float %fneg.a, float %b, float %fneg.c)
  %fneg = fneg float %fma
  ret float %fneg
}

define float @v_fneg_fma_x_y_fneg_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_x_y_fneg_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v0, v0, v1, -v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_x_y_fneg_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, -v1, v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.c = fneg float %c
  %fma = call float @llvm.fma.f32(float %a, float %b, float %fneg.c)
  %fneg = fneg float %fma
  ret float %fneg
}

define { float, float } @v_fneg_fma_store_use_fneg_x_y_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_store_use_fneg_x_y_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v0
; GCN-SAFE-NEXT:    v_fma_f32 v0, -v0, v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    v_mov_b32_e32 v1, v3
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_store_use_fneg_x_y_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_xor_b32_e32 v3, 0x80000000, v0
; GCN-NSZ-NEXT:    v_fma_f32 v0, v0, v1, -v2
; GCN-NSZ-NEXT:    v_mov_b32_e32 v1, v3
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fma = call float @llvm.fma.f32(float %fneg.a, float %b, float %c)
  %fneg = fneg float %fma
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fneg.a, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_fma_multi_use_fneg_x_y_f32(float %a, float %b, float %c, float %d) #0 {
; GCN-SAFE-LABEL: v_fneg_fma_multi_use_fneg_x_y_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v1, -v0, v1, v2
; GCN-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; GCN-SAFE-NEXT:    v_mul_f32_e64 v1, -v0, v3
; GCN-SAFE-NEXT:    v_mov_b32_e32 v0, v2
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fma_multi_use_fneg_x_y_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v2, v0, v1, -v2
; GCN-NSZ-NEXT:    v_mul_f32_e64 v1, -v0, v3
; GCN-NSZ-NEXT:    v_mov_b32_e32 v0, v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fma = call float @llvm.fma.f32(float %fneg.a, float %b, float %c)
  %fneg = fneg float %fma
  %use1 = fmul float %fneg.a, %d
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; fmad tests
; --------------------------------------------------------------------------------

define float @v_fneg_fmad_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fmad_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_mac_f32_e32 v2, v0, v1
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v2
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fmad_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_mad_f32 v0, v0, -v1, -v2
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.fmuladd.f32(float %a, float %b, float %c)
  %fneg = fneg float %fma
  ret float %fneg
}

define <4 x float> @v_fneg_fmad_v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fmad_v4f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_mac_f32_e32 v11, v3, v7
; GCN-SAFE-NEXT:    v_mac_f32_e32 v10, v2, v6
; GCN-SAFE-NEXT:    v_mac_f32_e32 v9, v1, v5
; GCN-SAFE-NEXT:    v_mac_f32_e32 v8, v0, v4
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v8
; GCN-SAFE-NEXT:    v_xor_b32_e32 v1, 0x80000000, v9
; GCN-SAFE-NEXT:    v_xor_b32_e32 v2, 0x80000000, v10
; GCN-SAFE-NEXT:    v_xor_b32_e32 v3, 0x80000000, v11
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fmad_v4f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_mad_f32 v0, v0, -v4, -v8
; GCN-NSZ-NEXT:    v_mad_f32 v1, v1, -v5, -v9
; GCN-NSZ-NEXT:    v_mad_f32 v2, v2, -v6, -v10
; GCN-NSZ-NEXT:    v_mad_f32 v3, v3, -v7, -v11
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call <4 x float> @llvm.fmuladd.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c)
  %fneg = fneg <4 x float> %fma
  ret <4 x float> %fneg
}

define { float, float } @v_fneg_fmad_multi_use_fmad_f32(float %a, float %b, float %c) #0 {
; GCN-SAFE-LABEL: v_fneg_fmad_multi_use_fmad_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_mac_f32_e32 v2, v0, v1
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v2
; GCN-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v2
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_fmad_multi_use_fmad_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_mad_f32 v0, v0, -v1, -v2
; GCN-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma = call float @llvm.fmuladd.f32(float %a, float %b, float %c)
  %fneg = fneg float %fma
  %use1 = fmul float %fma, 4.0
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; fp_extend tests
; --------------------------------------------------------------------------------

define double @v_fneg_fp_extend_f32_to_f64(float %a) #0 {
; GCN-LABEL: v_fneg_fp_extend_f32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f64_f32_e64 v[0:1], -v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext float %a to double
  %fneg = fneg double %fpext
  ret double %fneg
}

define double @v_fneg_fp_extend_fneg_f32_to_f64(float %a) #0 {
; GCN-LABEL: v_fneg_fp_extend_fneg_f32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fpext = fpext float %fneg.a to double
  %fneg = fneg double %fpext
  ret double %fneg
}

define { double, float } @v_fneg_fp_extend_store_use_fneg_f32_to_f64(float %a) #0 {
; GCN-LABEL: v_fneg_fp_extend_store_use_fneg_f32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v2, v0
; GCN-NEXT:    v_cvt_f64_f32_e32 v[0:1], v2
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fpext = fpext float %fneg.a to double
  %fneg = fneg double %fpext
  %insert.0 = insertvalue { double, float } poison, double %fneg, 0
  %insert.1 = insertvalue { double, float } %insert.0, float %fneg.a, 1
  ret { double, float } %insert.1
}

define { double, double } @v_fneg_multi_use_fp_extend_fneg_f32_to_f64(float %a) #0 {
; GCN-LABEL: v_fneg_multi_use_fp_extend_fneg_f32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f64_f32_e32 v[2:3], v0
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; GCN-NEXT:    v_mov_b32_e32 v0, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext float %a to double
  %fneg = fneg double %fpext
  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %fpext, 1
  ret { double, double } %insert.1
}

define { double, double } @v_fneg_multi_foldable_use_fp_extend_fneg_f32_to_f64(float %a) #0 {
; SI-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f32_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; SI-NEXT:    v_xor_b32_e32 v4, 0x80000000, v1
; SI-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; SI-NEXT:    v_mov_b32_e32 v1, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f32_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f64_f32_e32 v[0:1], v0
; VI-NEXT:    v_mul_f64 v[2:3], v[0:1], 4.0
; VI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext float %a to double
  %fneg = fneg double %fpext
  %mul = fmul double %fpext, 4.0
  %insert.0 = insertvalue { double, double } poison, double %fneg, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %mul, 1
  ret { double, double } %insert.1
}

; FIXME: Source modifiers not folded for f16->f32
define { float, float } @v_fneg_multi_use_fp_extend_fneg_f16_to_f32(half %a) #0 {
; SI-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, v0
; SI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_use_fp_extend_fneg_f16_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext half %a to float
  %fneg = fneg float %fpext
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fpext, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f32(half %a) #0 {
; SI-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; SI-NEXT:    v_mul_f32_e32 v1, 4.0, v0
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_multi_foldable_use_fp_extend_fneg_f16_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; VI-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; VI-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fpext = fpext half %a to float
  %fneg = fneg float %fpext
  %mul = fmul float %fpext, 4.0
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; fp_round tests
; --------------------------------------------------------------------------------

define float @v_fneg_fp_round_f64_to_f32(double %a) #0 {
; GCN-LABEL: v_fneg_fp_round_f64_to_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_f64_e64 v0, -v[0:1]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fpround = fptrunc double %a to float
  %fneg = fneg float %fpround
  ret float %fneg
}

define float @v_fneg_fp_round_fneg_f64_to_f32(double %a) #0 {
; GCN-LABEL: v_fneg_fp_round_fneg_f64_to_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fpround = fptrunc double %fneg.a to float
  %fneg = fneg float %fpround
  ret float %fneg
}

define { float, double } @v_fneg_fp_round_store_use_fneg_f64_to_f32(double %a) #0 {
; GCN-LABEL: v_fneg_fp_round_store_use_fneg_f64_to_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_f64_e32 v3, v[0:1]
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; GCN-NEXT:    v_mov_b32_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fpround = fptrunc double %fneg.a to float
  %fneg = fneg float %fpround
  %insert.0 = insertvalue { float, double } poison, float %fneg, 0
  %insert.1 = insertvalue { float, double } %insert.0, double %fneg.a, 1
  ret { float, double } %insert.1
}

define { float, double } @v_fneg_fp_round_multi_use_fneg_f64_to_f32(double %a, double %c) #0 {
; SI-LABEL: v_fneg_fp_round_multi_use_fneg_f64_to_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_f64_e32 v4, v[0:1]
; SI-NEXT:    v_mul_f64 v[1:2], -v[0:1], v[2:3]
; SI-NEXT:    v_mov_b32_e32 v0, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_multi_use_fneg_f64_to_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f64 v[2:3], -v[0:1], v[2:3]
; VI-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, v2
; VI-NEXT:    v_mov_b32_e32 v2, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg double %a
  %fpround = fptrunc double %fneg.a to float
  %fneg = fneg float %fpround
  %use1 = fmul double %fneg.a, %c
  %insert.0 = insertvalue { float, double } poison, float %fneg, 0
  %insert.1 = insertvalue { float, double } %insert.0, double %use1, 1
  ret { float, double } %insert.1
}

define half @v_fneg_fp_round_f32_to_f16(float %a) #0 {
; SI-LABEL: v_fneg_fp_round_f32_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_f32_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fpround = fptrunc float %a to half
  %fneg = fneg half %fpround
  ret half %fneg
}

define half @v_fneg_fp_round_fneg_f32_to_f16(float %a) #0 {
; SI-LABEL: v_fneg_fp_round_fneg_f32_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_fneg_f32_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fpround = fptrunc float %fneg.a to half
  %fneg = fneg half %fpround
  ret half %fneg
}

define { float, float } @v_fneg_multi_use_fp_round_fneg_f64_to_f32(double %a) #0 {
; GCN-LABEL: v_fneg_multi_use_fp_round_fneg_f64_to_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_f64_e32 v1, v[0:1]
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fpround = fptrunc double %a to float
  %fneg = fneg float %fpround
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fpround, 1
  ret { float, float } %insert.1
}

define { half, float } @v_fneg_fp_round_store_use_fneg_f32_to_f16(float %a) #0 {
; SI-LABEL: v_fneg_fp_round_store_use_fneg_f32_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v0
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_store_use_fneg_f32_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f16_f32_e32 v2, v0
; VI-NEXT:    v_xor_b32_e32 v1, 0x80000000, v0
; VI-NEXT:    v_mov_b32_e32 v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fpround = fptrunc float %fneg.a to half
  %fneg = fneg half %fpround
  %insert.0 = insertvalue { half, float } poison, half %fneg, 0
  %insert.1 = insertvalue { half, float } %insert.0, float %fneg.a, 1
  ret { half, float } %insert.1
}

define { half, float } @v_fneg_fp_round_multi_use_fneg_f32_to_f16(float %a, float %c) #0 {
; SI-LABEL: v_fneg_fp_round_multi_use_fneg_f32_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v0
; SI-NEXT:    v_mul_f32_e64 v1, -v0, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_mov_b32_e32 v0, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_fp_round_multi_use_fneg_f32_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f16_f32_e32 v2, v0
; VI-NEXT:    v_mul_f32_e64 v1, -v0, v1
; VI-NEXT:    v_mov_b32_e32 v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fpround = fptrunc float %fneg.a to half
  %fneg = fneg half %fpround
  %use1 = fmul float %fneg.a, %c
  %insert.0 = insertvalue { half, float } poison, half %fneg, 0
  %insert.1 = insertvalue { half, float } %insert.0, float %use1, 1
  ret { half, float } %insert.1
}

; --------------------------------------------------------------------------------
; rcp tests
; --------------------------------------------------------------------------------

define float @v_fneg_rcp_f32(float %a) #0 {
; GCN-LABEL: v_fneg_rcp_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %rcp = call float @llvm.amdgcn.rcp.f32(float %a)
  %fneg = fneg float %rcp
  ret float %fneg
}

define float @v_fneg_rcp_fneg_f32(float %a) #0 {
; GCN-LABEL: v_fneg_rcp_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %rcp = call float @llvm.amdgcn.rcp.f32(float %fneg.a)
  %fneg = fneg float %rcp
  ret float %fneg
}

define void @v_fneg_rcp_store_use_fneg_f32(float %a, ptr addrspace(1) %ptr0, ptr addrspace(1) %ptr1) #0 {
; GCN-LABEL: v_fneg_rcp_store_use_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v5, v0
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    flat_store_dword v[1:2], v5
; GCN-NEXT:    flat_store_dword v[3:4], v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %rcp = call float @llvm.amdgcn.rcp.f32(float %fneg.a)
  %fneg = fneg float %rcp
  store float %fneg, ptr addrspace(1) %ptr0
  store float %fneg.a, ptr addrspace(1) %ptr1
  ret void
}

define { float, float } @v_fneg_rcp_multi_use_fneg_f32(float %a, float %c) #0 {
; GCN-LABEL: v_fneg_rcp_multi_use_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rcp_f32_e32 v2, v0
; GCN-NEXT:    v_mul_f32_e64 v1, -v0, v1
; GCN-NEXT:    v_mov_b32_e32 v0, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %rcp = call float @llvm.amdgcn.rcp.f32(float %fneg.a)
  %fneg = fneg float %rcp
  %use1 = fmul float %fneg.a, %c
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

; Test getNegatedExpression works for rcp nodes
define float @v_negated_rcp_f32(float %arg0, float %arg1) #1 {
; GCN-LABEL: v_negated_rcp_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f32 v0, v0, v1, 2.0
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    v_add_f32_e32 v0, v1, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %neg.arg0 = fneg float %arg0
  %fma = call nsz float @llvm.fma.f32(float %neg.arg0, float %arg1, float -2.0)
  %rcp0 = call float @llvm.amdgcn.rcp.f32(float %fma)
  %mul = fsub nsz float %arg1, %rcp0
  ret float %mul
}

; --------------------------------------------------------------------------------
; fmul_legacy tests
; --------------------------------------------------------------------------------

define float @v_fneg_mul_legacy_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = call float @llvm.amdgcn.fmul.legacy(float %a, float %b)
  %fneg = fneg float %mul
  ret float %fneg
}

define { float, float } @v_fneg_mul_legacy_store_use_mul_legacy_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_store_use_mul_legacy_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v1, v0, v1
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = call float @llvm.amdgcn.fmul.legacy(float %a, float %b)
  %fneg = fneg float %mul
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_mul_legacy_multi_use_mul_legacy_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_multi_use_mul_legacy_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GCN-NEXT:    v_mul_legacy_f32_e64 v1, -v0, 4.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = call float @llvm.amdgcn.fmul.legacy(float %a, float %b)
  %fneg = fneg float %mul
  %use1 = call float @llvm.amdgcn.fmul.legacy(float %mul, float 4.0)
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

define float @v_fneg_mul_legacy_fneg_x_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_fneg_x_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul = call float @llvm.amdgcn.fmul.legacy(float %fneg.a, float %b)
  %fneg = fneg float %mul
  ret float %fneg
}

define float @v_fneg_mul_legacy_x_fneg_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_x_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.b = fneg float %b
  %mul = call float @llvm.amdgcn.fmul.legacy(float %a, float %fneg.b)
  %fneg = fneg float %mul
  ret float %fneg
}

define float @v_fneg_mul_legacy_fneg_fneg_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_fneg_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fneg.b = fneg float %b
  %mul = call float @llvm.amdgcn.fmul.legacy(float %fneg.a, float %fneg.b)
  %fneg = fneg float %mul
  ret float %fneg
}

define { float, float } @v_fneg_mul_legacy_store_use_fneg_x_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_mul_legacy_store_use_fneg_x_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; GCN-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GCN-NEXT:    v_mov_b32_e32 v1, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul = call float @llvm.amdgcn.fmul.legacy(float %fneg.a, float %b)
  %fneg = fneg float %mul

  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fneg.a, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_mul_legacy_multi_use_fneg_x_f32(float %a, float %b, float %c) #0 {
; GCN-LABEL: v_fneg_mul_legacy_multi_use_fneg_x_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_legacy_f32_e32 v3, v0, v1
; GCN-NEXT:    v_mul_legacy_f32_e64 v1, -v0, v2
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul = call float @llvm.amdgcn.fmul.legacy(float %fneg.a, float %b)
  %fneg = fneg float %mul
  %use1 = call float @llvm.amdgcn.fmul.legacy(float %fneg.a, float %c)
  %insert.0 = insertvalue { float, float } poison, float %fneg, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %use1, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; sin tests
; --------------------------------------------------------------------------------

define float @v_fneg_sin_f32(float %a) #0 {
; GCN-LABEL: v_fneg_sin_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 0xbe22f983, v0
; GCN-NEXT:    v_fract_f32_e32 v0, v0
; GCN-NEXT:    v_sin_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %sin = call float @llvm.sin.f32(float %a)
  %fneg = fneg float %sin
  ret float %fneg
}

define float @v_fneg_amdgcn_sin_f32(float %a) #0 {
; GCN-LABEL: v_fneg_amdgcn_sin_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sin_f32_e64 v0, -v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %sin = call float @llvm.amdgcn.sin.f32(float %a)
  %fneg = fneg float %sin
  ret float %fneg
}

; --------------------------------------------------------------------------------
; ftrunc tests
; --------------------------------------------------------------------------------

define float @v_fneg_trunc_f32(float %a) #0 {
; GCN-LABEL: v_fneg_trunc_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_trunc_f32_e64 v0, -v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %trunc = call float @llvm.trunc.f32(float %a)
  %fneg = fneg float %trunc
  ret float %fneg
}

; --------------------------------------------------------------------------------
; fround tests
; --------------------------------------------------------------------------------

define float @v_fneg_round_f32(float %a) #0 {
; GCN-SAFE-LABEL: v_fneg_round_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_trunc_f32_e32 v1, v0
; GCN-SAFE-NEXT:    v_sub_f32_e32 v2, v0, v1
; GCN-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v2|, 0.5
; GCN-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 1.0, s[4:5]
; GCN-SAFE-NEXT:    s_brev_b32 s4, -2
; GCN-SAFE-NEXT:    v_bfi_b32 v0, s4, v2, v0
; GCN-SAFE-NEXT:    v_add_f32_e32 v0, v1, v0
; GCN-SAFE-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fneg_round_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_trunc_f32_e32 v1, v0
; GCN-NSZ-NEXT:    v_sub_f32_e32 v2, v0, v1
; GCN-NSZ-NEXT:    v_cmp_ge_f32_e64 s[4:5], |v2|, 0.5
; GCN-NSZ-NEXT:    v_cndmask_b32_e64 v2, 0, 1.0, s[4:5]
; GCN-NSZ-NEXT:    s_brev_b32 s4, -2
; GCN-NSZ-NEXT:    v_bfi_b32 v0, s4, v2, v0
; GCN-NSZ-NEXT:    v_sub_f32_e64 v0, -v1, v0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %round = call float @llvm.round.f32(float %a)
  %fneg = fneg float %round
  ret float %fneg
}

; --------------------------------------------------------------------------------
; rint tests
; --------------------------------------------------------------------------------

define float @v_fneg_rint_f32(float %a) #0 {
; GCN-LABEL: v_fneg_rint_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rndne_f32_e64 v0, -v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %rint = call float @llvm.rint.f32(float %a)
  %fneg = fneg float %rint
  ret float %fneg
}

; --------------------------------------------------------------------------------
; nearbyint tests
; --------------------------------------------------------------------------------

define float @v_fneg_nearbyint_f32(float %a) #0 {
; GCN-LABEL: v_fneg_nearbyint_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_rndne_f32_e64 v0, -v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %nearbyint = call float @llvm.nearbyint.f32(float %a)
  %fneg = fneg float %nearbyint
  ret float %fneg
}

; --------------------------------------------------------------------------------
; fcanonicalize tests
; --------------------------------------------------------------------------------

define float @v_fneg_canonicalize_f32(float %a) #0 {
; GCN-LABEL: v_fneg_canonicalize_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %trunc = call float @llvm.canonicalize.f32(float %a)
  %fneg = fneg float %trunc
  ret float %fneg
}

; --------------------------------------------------------------------------------
; arithmetic.fence tests
; --------------------------------------------------------------------------------

define float @v_fneg_arithmetic_fence_f32(float %a) #0 {
; GCN-LABEL: v_fneg_arithmetic_fence_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    ;ARITH_FENCE
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fence = call float @llvm.arithmetic.fence.f32(float %a)
  %fneg = fneg float %fence
  ret float %fneg
}

define float @v_fneg_arithmetic_fence_fmul_f32(float %a, float %b) #0 {
; GCN-LABEL: v_fneg_arithmetic_fence_fmul_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    ;ARITH_FENCE
; GCN-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fence = call float @llvm.arithmetic.fence.f32(float %mul)
  %fneg = fneg float %fence
  ret float %fneg
}

; --------------------------------------------------------------------------------
; vintrp tests
; --------------------------------------------------------------------------------

define { float, float } @v_fneg_interp_p1_f32(float %a, float %b) #0 {
; SI-LABEL: v_fneg_interp_p1_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e64 v1, v0, -v1
; SI-NEXT:    s_mov_b32 m0, 0
; SI-NEXT:    v_interp_p1_f32 v0, v1, attr0.x
; SI-NEXT:    v_interp_p1_f32 v1, v1, attr0.y
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_interp_p1_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e64 v1, v0, -v1
; VI-NEXT:    s_mov_b32 m0, 0
; VI-NEXT:    v_interp_p1_f32_e32 v0, v1, attr0.x
; VI-NEXT:    v_interp_p1_f32_e32 v1, v1, attr0.y
; VI-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  %intrp0 = call float @llvm.amdgcn.interp.p1(float %fneg, i32 0, i32 0, i32 0)
  %intrp1 = call float @llvm.amdgcn.interp.p1(float %fneg, i32 1, i32 0, i32 0)
  %insert.0 = insertvalue { float, float } poison, float %intrp0, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %intrp1, 1
  ret { float, float } %insert.1
}

define { float, float } @v_fneg_interp_p2_f32(float %a, float %b) #0 {
; SI-LABEL: v_fneg_interp_p2_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mul_f32_e64 v2, v0, -v1
; SI-NEXT:    v_mov_b32_e32 v1, 4.0
; SI-NEXT:    v_mov_b32_e32 v0, 4.0
; SI-NEXT:    s_mov_b32 m0, 0
; SI-NEXT:    v_interp_p2_f32 v0, v2, attr0.x
; SI-NEXT:    v_interp_p2_f32 v1, v2, attr0.y
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_interp_p2_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f32_e64 v2, v0, -v1
; VI-NEXT:    v_mov_b32_e32 v1, 4.0
; VI-NEXT:    v_mov_b32_e32 v0, 4.0
; VI-NEXT:    s_mov_b32 m0, 0
; VI-NEXT:    v_interp_p2_f32_e32 v0, v2, attr0.x
; VI-NEXT:    v_interp_p2_f32_e32 v1, v2, attr0.y
; VI-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  %intrp0 = call float @llvm.amdgcn.interp.p2(float 4.0, float %fneg, i32 0, i32 0, i32 0)
  %intrp1 = call float @llvm.amdgcn.interp.p2(float 4.0, float %fneg, i32 1, i32 0, i32 0)
  %insert.0 = insertvalue { float, float } poison, float %intrp0, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %intrp1, 1
  ret { float, float } %insert.1
}

; --------------------------------------------------------------------------------
; CopyToReg tests
; --------------------------------------------------------------------------------

define void @v_fneg_copytoreg_f32(ptr addrspace(1) %out, float %a, float %b, float %c, i32 %d) #0 {
; SI-LABEL: v_fneg_copytoreg_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v6, 0x3ff, v31
; SI-NEXT:    v_lshlrev_b32_e32 v6, 2, v6
; SI-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:    v_mul_f32_e32 v2, v2, v3
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_cbranch_execz .LBB118_2
; SI-NEXT:  ; %bb.1: ; %if
; SI-NEXT:    v_mul_f32_e64 v3, -v2, v4
; SI-NEXT:    flat_store_dword v[0:1], v3
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:  .LBB118_2: ; %endif
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    flat_store_dword v[0:1], v2
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_copytoreg_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v6, 0x3ff, v31
; VI-NEXT:    v_lshlrev_b32_e32 v6, 2, v6
; VI-NEXT:    v_add_u32_e32 v0, vcc, v0, v6
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_mul_f32_e32 v2, v2, v3
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_cbranch_execz .LBB118_2
; VI-NEXT:  ; %bb.1: ; %if
; VI-NEXT:    v_mul_f32_e64 v3, -v2, v4
; VI-NEXT:    flat_store_dword v[0:1], v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:  .LBB118_2: ; %endif
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %out.gep = getelementptr inbounds float, ptr addrspace(1) %out, i64 %tid.ext
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  %cmp0 = icmp eq i32 %d, 0
  br i1 %cmp0, label %if, label %endif

if:
  %mul1 = fmul float %fneg, %c
  store volatile float %mul1, ptr addrspace(1) %out.gep
  br label %endif

endif:
  store volatile float %mul, ptr addrspace(1) %out.gep
  ret void
}

; --------------------------------------------------------------------------------
; inlineasm tests
; --------------------------------------------------------------------------------

; Can't fold into use, so should fold into source
define float @v_fneg_inlineasm_f32(float %a, float %b, float %c, i32 %d) #0 {
; GCN-LABEL: v_fneg_inlineasm_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, v0, -v1
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ; use v0
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  call void asm sideeffect "; use $0", "v"(float %fneg) #0
  ret float %fneg
}

; --------------------------------------------------------------------------------
; inlineasm tests
; --------------------------------------------------------------------------------

; Can't fold into use, so should fold into source
define float @v_fneg_inlineasm_multi_use_src_f32(ptr addrspace(1) %out, float %a, float %b, float %c, i32 %d) #0 {
; GCN-LABEL: v_fneg_inlineasm_multi_use_src_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, v2, v3
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v0
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ; use v1
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  call void asm sideeffect "; use $0", "v"(float %fneg) #0
  ret float %mul
}

; --------------------------------------------------------------------------------
; code size regression tests
; --------------------------------------------------------------------------------

; There are multiple users of the fneg that must use a VOP3
; instruction, so there is no penalty
define { float, float } @multiuse_fneg_2_vop3_users_f32(float %a, float %b, float %c) #0 {
; GCN-LABEL: multiuse_fneg_2_vop3_users_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f32 v3, -v0, v1, v2
; GCN-NEXT:    v_fma_f32 v1, -v0, v2, 2.0
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fma0 = call float @llvm.fma.f32(float %fneg.a, float %b, float %c)
  %fma1 = call float @llvm.fma.f32(float %fneg.a, float %c, float 2.0)
  %insert.0 = insertvalue { float, float } poison, float %fma0, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %fma1, 1
  ret { float, float } %insert.1
}

; There are multiple users, but both require using a larger encoding
; for the modifier.
define { float, float } @multiuse_fneg_2_vop2_users_f32(float %a, float %b, float %c) #0 {
; GCN-LABEL: multiuse_fneg_2_vop2_users_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v3, -v0, v1
; GCN-NEXT:    v_mul_f32_e64 v1, -v0, v2
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %mul0 = fmul float %fneg.a, %b
  %mul1 = fmul float %fneg.a, %c
  %insert.0 = insertvalue { float, float } poison, float %mul0, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul1, 1
  ret { float, float } %insert.1
}

; One user is VOP3 so has no cost to folding the modifier, the other does.
define { float, float } @multiuse_fneg_vop2_vop3_users_f32(float %a, float %b, float %c) #0 {
; GCN-LABEL: multiuse_fneg_vop2_vop3_users_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f32 v3, -v0, v1, 2.0
; GCN-NEXT:    v_mul_f32_e64 v1, -v0, v2
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fneg.a = fneg float %a
  %fma0 = call float @llvm.fma.f32(float %fneg.a, float %b, float 2.0)
  %mul1 = fmul float %fneg.a, %c

  %insert.0 = insertvalue { float, float } poison, float %fma0, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul1, 1
  ret { float, float } %insert.1
}

; The use of the fneg requires a code size increase, but folding into
; the source does not
define { float, float } @free_fold_src_code_size_cost_use_f32(ptr addrspace(1) %out, float %a, float %b, float %c, float %d) #0 {
; GCN-SAFE-LABEL: free_fold_src_code_size_cost_use_f32:
; GCN-SAFE:       ; %bb.0:
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_fma_f32 v1, v2, v3, 2.0
; GCN-SAFE-NEXT:    v_mul_f32_e64 v0, -v1, v4
; GCN-SAFE-NEXT:    v_mul_f32_e64 v1, -v1, v5
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: free_fold_src_code_size_cost_use_f32:
; GCN-NSZ:       ; %bb.0:
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_fma_f32 v1, v2, -v3, -2.0
; GCN-NSZ-NEXT:    v_mul_f32_e32 v0, v1, v4
; GCN-NSZ-NEXT:    v_mul_f32_e32 v1, v1, v5
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %fma0 = call float @llvm.fma.f32(float %a, float %b, float 2.0)
  %fneg.fma0 = fneg float %fma0
  %mul1 = fmul float %fneg.fma0, %c
  %mul2 = fmul float %fneg.fma0, %d

  %insert.0 = insertvalue { float, float } poison, float %mul1, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul2, 1
  ret { float, float } %insert.1
}

define { double, double } @free_fold_src_code_size_cost_use_f64(double %a, double %b, double %c, double %d) #0 {
; GCN-LABEL: free_fold_src_code_size_cost_use_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_fma_f64 v[2:3], v[0:1], v[2:3], 2.0
; GCN-NEXT:    v_mul_f64 v[0:1], -v[2:3], v[4:5]
; GCN-NEXT:    v_mul_f64 v[2:3], -v[2:3], v[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fma0 = call double @llvm.fma.f64(double %a, double %b, double 2.0)
  %fneg.fma0 = fneg double %fma0
  %mul1 = fmul double %fneg.fma0, %c
  %mul2 = fmul double %fneg.fma0, %d

  %insert.0 = insertvalue { double, double } poison, double %mul1, 0
  %insert.1 = insertvalue { double, double } %insert.0, double %mul2, 1
  ret { double, double } %insert.1
}

; %trunc.a has one fneg use, but it requires a code size increase and
; %the fneg can instead be folded for free into the fma.
define float @one_use_cost_to_fold_into_src_f32(float %a, float %b, float %c, float %d) #0 {
; GCN-LABEL: one_use_cost_to_fold_into_src_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_trunc_f32_e32 v0, v0
; GCN-NEXT:    v_fma_f32 v0, -v0, v1, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %trunc.a = call float @llvm.trunc.f32(float %a)
  %trunc.fneg.a = fneg float %trunc.a
  %fma0 = call float @llvm.fma.f32(float %trunc.fneg.a, float %b, float %c)
  ret float %fma0
}

define { float, float } @multi_use_cost_to_fold_into_src(float %a, float %b, float %c, float %d) #0 {
; GCN-LABEL: multi_use_cost_to_fold_into_src:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_trunc_f32_e32 v4, v0
; GCN-NEXT:    v_fma_f32 v0, -v4, v1, v2
; GCN-NEXT:    v_mul_f32_e32 v1, v4, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %trunc.a = call float @llvm.trunc.f32(float %a)
  %trunc.fneg.a = fneg float %trunc.a
  %fma0 = call float @llvm.fma.f32(float %trunc.fneg.a, float %b, float %c)
  %mul1 = fmul float %trunc.a, %d
  %insert.0 = insertvalue { float, float } poison, float %fma0, 0
  %insert.1 = insertvalue { float, float } %insert.0, float %mul1, 1
  ret { float, float } %insert.1
}

; The AMDGPU combine to pull fneg into the FMA operands was being
; undone by the generic combine to pull the fneg out of the fma if
; !isFNegFree. We were reporting false for v2f32 even though it will
; be split into f32 where it will be free.
define <2 x float> @fneg_fma_fneg_dagcombine_loop(<2 x float> %arg, <2 x float> %arg1, <2 x float> %arg2) #0 {
; GCN-LABEL: fneg_fma_fneg_dagcombine_loop:
; GCN:       ; %bb.0: ; %bb
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_brev_b32 s4, 1
; GCN-NEXT:    v_fma_f32 v3, v3, -v5, s4
; GCN-NEXT:    v_fma_f32 v2, v2, -v4, s4
; GCN-NEXT:    v_sub_f32_e32 v1, v3, v1
; GCN-NEXT:    v_sub_f32_e32 v0, v2, v0
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v4
; GCN-NEXT:    v_mul_f32_e32 v1, v1, v5
; GCN-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i3 = call fast <2 x float> @llvm.fma.v2f32(<2 x float> %arg1, <2 x float> %arg2, <2 x float> zeroinitializer)
  %i4 = fadd fast <2 x float> %i3, %arg
  %i5 = fneg <2 x float> %i4
  %i6 = fmul fast <2 x float> %i5, %arg2
  ret <2 x float> %i6
}

; This expects denormal flushing, so can't turn this fmul into fneg
; TODO: Keeping this as fmul saves encoding size
define float @nnan_fmul_neg1_to_fneg(float %x, float %y) #0 {
; GCN-LABEL: nnan_fmul_neg1_to_fneg:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul float %x, -1.0
  %add = fmul nnan float %mul, %y
  ret float %add
}

; It's legal to turn this fmul into an fneg since denormals are
; preserved and we know an snan can't happen from the flag.
define float @denormal_fmul_neg1_to_fneg(float %x, float %y) {
; GCN-LABEL: denormal_fmul_neg1_to_fneg:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %mul = fmul nnan float %x, -1.0
  %add = fmul float %mul, %y
  ret float %add
}

; know the source can't be an snan
define float @denorm_snan_fmul_neg1_to_fneg(float %x, float %y) {
; GCN-LABEL: denorm_snan_fmul_neg1_to_fneg:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e64 v0, v0, -v0
; GCN-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %canonical = fmul float %x, %x
  %mul = fmul float %canonical, -1.0
  %add = fmul float %mul, %y
  ret float %add
}

define float @flush_snan_fmul_neg1_to_fneg(float %x, float %y) #0 {
; GCN-LABEL: flush_snan_fmul_neg1_to_fneg:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %quiet = call float @llvm.canonicalize.f32(float %x)
  %mul = fmul float %quiet, -1.0
  %add = fmul float %mul, %y
  ret float %add
}

define float @fadd_select_fneg_fneg_f32(i32 %arg0, float %x, float %y, float %z) {
; GCN-LABEL: fadd_select_fneg_fneg_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GCN-NEXT:    v_sub_f32_e32 v0, v3, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %arg0, 0
  %neg.x = fneg float %x
  %neg.y  = fneg float %y
  %select = select i1 %cmp, float %neg.x, float %neg.y
  %add = fadd float %select, %z
  ret float %add
}

define double @fadd_select_fneg_fneg_f64(i32 %arg0, double %x, double %y, double %z) {
; GCN-LABEL: fadd_select_fneg_fneg_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    v_add_f64 v[0:1], v[5:6], -v[1:2]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %arg0, 0
  %neg.x = fneg double %x
  %neg.y  = fneg double %y
  %select = select i1 %cmp, double %neg.x, double %neg.y
  %add = fadd double %select, %z
  ret double %add
}

define half @fadd_select_fneg_fneg_f16(i32 %arg0, half %x, half %y, half %z) {
; SI-LABEL: fadd_select_fneg_fneg_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; SI-NEXT:    v_sub_f32_e32 v0, v3, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: fadd_select_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %arg0, 0
  %neg.x = fneg half %x
  %neg.y = fneg half %y
  %select = select i1 %cmp, half %neg.x, half %neg.y
  %add = fadd half %select, %z
  ret half %add
}

; FIXME: Terrible code for SI
define <2 x half> @fadd_select_fneg_fneg_v2f16(i32 %arg0, <2 x half> %x, <2 x half> %y, <2 x half> %z) {
; SI-LABEL: fadd_select_fneg_fneg_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v6
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_sub_f32_e32 v0, v4, v0
; SI-NEXT:    v_sub_f32_e32 v1, v3, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: fadd_select_fneg_fneg_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_sdwa v1, v3, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %arg0, 0
  %neg.x = fneg <2 x half> %x
  %neg.y = fneg <2 x half> %y
  %select = select i1 %cmp, <2 x half> %neg.x, <2 x half> %neg.y
  %add = fadd <2 x half> %select, %z
  ret <2 x half> %add
}

; --------------------------------------------------------------------------------
; select tests
; --------------------------------------------------------------------------------

define amdgpu_kernel void @s_fneg_select_infloop_regression_f32(float %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fneg_select_infloop_regression_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bitcmp1_b32 s1, 0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; SI-NEXT:    v_cndmask_b32_e64 v2, -v0, 0, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    flat_store_dword v[0:1], v2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fneg_select_infloop_regression_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bitcmp1_b32 s1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; VI-NEXT:    v_cndmask_b32_e64 v2, -v0, 0, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float 0.0, float %i2
  store float %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define float @v_fneg_select_infloop_regression_f32(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float 0.0, float %i2
  ret float %i3
}

define float @v_fneg_select_infloop_regression_f32_commute0(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_f32_commute0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float %arg, float 0.0
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float 0.0, float %i2
  ret float %i3
}

define float @v_fneg_select_infloop_regression_f32_commute1(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_f32_commute1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float %i2, float 0.0
  ret float %i3
}

define float @v_fneg_select_infloop_regression_f32_commute2(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_f32_commute2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float %arg, float 0.0
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float %i2, float 0.0
  ret float %i3
}

; Check with an inline constant that's equally cheap to negate
define float @v_fneg_select_infloop_regression_inline_imm_f32(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_inline_imm_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 2.0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, 2.0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float 2.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float 2.0, float %i2
  ret float %i3
}

define float @v_fneg_select_infloop_regression_inline_imm_f32_commute0(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_inline_imm_f32_commute0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, 2.0, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, 2.0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float %arg, float 2.0
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float 2.0, float %i2
  ret float %i3
}

define float @v_fneg_select_infloop_regression_inline_imm_f32_commute1(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_inline_imm_f32_commute1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 2.0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 2.0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float 2.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float %i2, float 2.0
  ret float %i3
}

define float @v_fneg_select_infloop_regression_inline_imm_f32_commute2(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_inline_imm_f32_commute2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, 2.0, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, 2.0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float %arg, float 2.0
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float %i2, float 2.0
  ret float %i3
}

; Check with an inline constant that's equally cheap to negate
define float @v_fneg_select_infloop_regression_neg_inline_imm_f32(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_neg_inline_imm_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, -2.0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, -2.0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float -2.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float -2.0, float %i2
  ret float %i3
}

define float @v_fneg_select_infloop_regression_neg_inline_imm_f32_commute0(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_neg_inline_imm_f32_commute0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, -2.0, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, -2.0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float %arg, float -2.0
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float -2.0, float %i2
  ret float %i3
}

define float @v_fneg_select_infloop_regression_neg_inline_imm_f32_commute1(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_neg_inline_imm_f32_commute1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, -2.0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -2.0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float -2.0, float %arg
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float %i2, float -2.0
  ret float %i3
}

define float @v_fneg_select_infloop_regression_neg_inline_imm_f32_commute2(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_neg_inline_imm_f32_commute2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, -2.0, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -2.0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float %arg, float -2.0
  %i2 = fneg float %i
  %i3 = select i1 %arg1, float %i2, float -2.0
  ret float %i3
}

define amdgpu_kernel void @s_fneg_select_infloop_regression_f64(double %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fneg_select_infloop_regression_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x9
; SI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0xd
; SI-NEXT:    v_bfrev_b32_e32 v0, 1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bitcmp1_b32 s4, 0
; SI-NEXT:    s_cselect_b64 s[4:5], -1, 0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    s_and_b64 s[6:7], s[4:5], exec
; SI-NEXT:    v_cndmask_b32_e64 v0, -v1, v0, s[4:5]
; SI-NEXT:    s_cselect_b32 s0, 0, s0
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fneg_select_infloop_regression_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x34
; VI-NEXT:    v_bfrev_b32_e32 v0, 1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bitcmp1_b32 s4, 0
; VI-NEXT:    s_cselect_b64 s[4:5], -1, 0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_and_b64 s[6:7], s[4:5], exec
; VI-NEXT:    v_cndmask_b32_e64 v0, -v1, v0, s[4:5]
; VI-NEXT:    s_cselect_b32 s0, 0, s0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, double 0.0, double %arg
  %i2 = fneg double %i
  %i3 = select i1 %arg1, double 0.0, double %i2
  store double %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define double @v_fneg_select_infloop_regression_f64(double %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v2, 1, v2
; GCN-NEXT:    v_bfrev_b32_e32 v3, 1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GCN-NEXT:    v_cndmask_b32_e64 v1, -v1, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, double 0.0, double %arg
  %i2 = fneg double %i
  %i3 = select i1 %arg1, double 0.0, double %i2
  ret double %i3
}

define amdgpu_kernel void @s_fneg_select_infloop_regression_f16(half %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fneg_select_infloop_regression_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[2:3], 0x9
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xb
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    s_bitcmp1_b32 s4, 16
; SI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[2:3]
; SI-NEXT:    v_cndmask_b32_e64 v0, -v0, 0, s[2:3]
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    flat_store_short v[0:1], v2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fneg_select_infloop_regression_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x2c
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bitcmp1_b32 s4, 16
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[2:3]
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    v_cndmask_b32_e64 v2, v0, 0, s[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, half 0.0, half %arg
  %i2 = fneg half %i
  %i3 = select i1 %arg1, half 0.0, half %i2
  store half %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define half @v_fneg_select_infloop_regression_f16(half %arg, i1 %arg1) {
; SI-LABEL: v_fneg_select_infloop_regression_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_and_b32_e32 v1, 1, v1
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; SI-NEXT:    v_cndmask_b32_e64 v0, -v0, 0, vcc
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_select_infloop_regression_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 1, v1
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; VI-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; VI-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, half 0.0, half %arg
  %i2 = fneg half %i
  %i3 = select i1 %arg1, half 0.0, half %i2
  ret half %i3
}

define amdgpu_kernel void @s_fneg_select_infloop_regression_v2f16(<2 x half> %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fneg_select_infloop_regression_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_and_b32 s1, 1, s1
; SI-NEXT:    s_cselect_b32 s0, 0, s0
; SI-NEXT:    s_xor_b32 s0, s0, 0x80008000
; SI-NEXT:    s_cmp_eq_u32 s1, 1
; SI-NEXT:    s_cselect_b32 s0, 0, s0
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    v_mov_b32_e32 v2, s0
; SI-NEXT:    flat_store_dword v[0:1], v2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fneg_select_infloop_regression_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s1, 1, s1
; VI-NEXT:    s_cselect_b32 s0, 0, s0
; VI-NEXT:    s_xor_b32 s0, s0, 0x80008000
; VI-NEXT:    s_cmp_eq_u32 s1, 1
; VI-NEXT:    s_cselect_b32 s0, 0, s0
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, <2 x half> zeroinitializer, <2 x half> %arg
  %i2 = fneg <2 x half> %i
  %i3 = select i1 %arg1, <2 x half> zeroinitializer, <2 x half> %i2
  store <2 x half> %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define <2 x half> @v_fneg_select_infloop_regression_v2f16(<2 x half> %arg, i1 %arg1) {
; SI-LABEL: v_fneg_select_infloop_regression_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 1, v2
; SI-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; SI-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; SI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, vcc
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_fneg_select_infloop_regression_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 1, v1
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; VI-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; VI-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, <2 x half> zeroinitializer, <2 x half> %arg
  %i2 = fneg <2 x half> %i
  %i3 = select i1 %arg1, <2 x half> zeroinitializer, <2 x half> %i2
  ret <2 x half> %i3
}

define amdgpu_kernel void @s_fneg_select_infloop_regression_v2f32(<2 x float> %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fneg_select_infloop_regression_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; SI-NEXT:    v_bfrev_b32_e32 v0, 1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bitcmp1_b32 s6, 0
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v2, -v1, v0, s[2:3]
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_cndmask_b32_e64 v0, -v1, v0, s[2:3]
; SI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[2:3]
; SI-NEXT:    v_cndmask_b32_e64 v0, v2, 0, s[2:3]
; SI-NEXT:    v_mov_b32_e32 v3, s1
; SI-NEXT:    v_mov_b32_e32 v2, s0
; SI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fneg_select_infloop_regression_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    v_bfrev_b32_e32 v0, 1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bitcmp1_b32 s6, 0
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v2, -v1, v0, s[2:3]
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_cndmask_b32_e64 v0, -v1, v0, s[2:3]
; VI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[2:3]
; VI-NEXT:    v_cndmask_b32_e64 v0, v2, 0, s[2:3]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, <2 x float> zeroinitializer, <2 x float> %arg
  %i2 = fneg <2 x float> %i
  %i3 = select i1 %arg1, <2 x float> zeroinitializer, <2 x float> %i2
  store <2 x float> %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define <2 x float> @v_fneg_select_infloop_regression_v2f32(<2 x float> %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_select_infloop_regression_v2f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v2, 1, v2
; GCN-NEXT:    v_bfrev_b32_e32 v3, 1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GCN-NEXT:    v_cndmask_b32_e64 v1, -v1, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v0, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, <2 x float> zeroinitializer, <2 x float> %arg
  %i2 = fneg <2 x float> %i
  %i3 = select i1 %arg1, <2 x float> zeroinitializer, <2 x float> %i2
  ret <2 x float> %i3
}

define amdgpu_kernel void @s_fabs_select_infloop_regression_f32(float %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fabs_select_infloop_regression_f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bitcmp1_b32 s1, 0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; SI-NEXT:    v_cndmask_b32_e64 v2, |v0|, 0, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    flat_store_dword v[0:1], v2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fabs_select_infloop_regression_f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bitcmp1_b32 s1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; VI-NEXT:    v_cndmask_b32_e64 v2, |v0|, 0, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = call float @llvm.fabs.f32(float %i)
  %i3 = select i1 %arg1, float 0.0, float %i2
  store float %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define float @v_fabs_select_infloop_regression_f32(float %arg, i1 %arg1) {
; GCN-LABEL: v_fabs_select_infloop_regression_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, |v0|, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = call float @llvm.fabs.f32(float %i)
  %i3 = select i1 %arg1, float 0.0, float %i2
  ret float %i3
}

define amdgpu_kernel void @s_fneg_fabs_select_infloop_regression(float %arg, i1 %arg1, ptr addrspace(1) %ptr) {
; SI-LABEL: s_fneg_fabs_select_infloop_regression:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_bitcmp1_b32 s1, 0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; SI-NEXT:    v_cndmask_b32_e64 v2, -|v0|, 0, s[0:1]
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    flat_store_dword v[0:1], v2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_fneg_fabs_select_infloop_regression:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_bitcmp1_b32 s1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, s[0:1]
; VI-NEXT:    v_cndmask_b32_e64 v2, -|v0|, 0, s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = call float @llvm.fabs.f32(float %i)
  %neg.i2 = fneg float %i2
  %i3 = select i1 %arg1, float 0.0, float %neg.i2
  store float %i3, ptr addrspace(1) %ptr, align 4
  ret void
}

define float @v_fneg_fabs_select_infloop_regression(float %arg, i1 %arg1) {
; GCN-LABEL: v_fneg_fabs_select_infloop_regression:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, -|v0|, 0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = select i1 %arg1, float 0.0, float %arg
  %i2 = call float @llvm.fabs.f32(float %i)
  %neg.i2 = fneg float %i2
  %i3 = select i1 %arg1, float 0.0, float %neg.i2
  ret float %i3
}

define float @v_fmul_0_fsub_0_infloop_regression(float %arg) {
; GCN-SAFE-LABEL: v_fmul_0_fsub_0_infloop_regression:
; GCN-SAFE:       ; %bb.0: ; %bb
; GCN-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-SAFE-NEXT:    v_mul_f32_e32 v0, 0, v0
; GCN-SAFE-NEXT:    v_sub_f32_e32 v0, 0, v0
; GCN-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-NSZ-LABEL: v_fmul_0_fsub_0_infloop_regression:
; GCN-NSZ:       ; %bb.0: ; %bb
; GCN-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NSZ-NEXT:    v_mul_f32_e32 v0, 0x80000000, v0
; GCN-NSZ-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = fmul float %arg, 0.0
  %i1 = fsub float 0.0, %i
  ret float %i1
}

declare i32 @llvm.amdgcn.workitem.id.x() #1
declare float @llvm.fma.f32(float, float, float) #1
declare <2 x float> @llvm.fma.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare float @llvm.fmuladd.f32(float, float, float) #1
declare <4 x float> @llvm.fmuladd.v4f32(<4 x float>, <4 x float>, <4 x float>) #1
declare float @llvm.fabs.f32(float) #1
declare float @llvm.sin.f32(float) #1
declare float @llvm.trunc.f32(float) #1
declare float @llvm.round.f32(float) #1
declare float @llvm.rint.f32(float) #1
declare float @llvm.nearbyint.f32(float) #1
declare float @llvm.roundeven.f32(float) #1
declare float @llvm.canonicalize.f32(float) #1
declare float @llvm.arithmetic.fence.f32(float) #1
declare float @llvm.minnum.f32(float, float) #1
declare float @llvm.maxnum.f32(float, float) #1
declare double @llvm.minnum.f64(double, double) #1
declare double @llvm.fma.f64(double, double, double) #1

declare float @llvm.amdgcn.sin.f32(float) #1
declare float @llvm.amdgcn.rcp.f32(float) #1
declare float @llvm.amdgcn.rcp.legacy(float) #1
declare float @llvm.amdgcn.fmul.legacy(float, float) #1
declare float @llvm.amdgcn.interp.p1(float, i32, i32, i32) #0
declare float @llvm.amdgcn.interp.p2(float, float, i32, i32, i32) #0

declare half @llvm.fma.f16(half, half, half) #1
declare <2 x half> @llvm.fma.v2f16(<2 x half>, <2 x half>, <2 x half>)
declare half @llvm.fmuladd.f16(half, half, half) #1
declare <4 x half> @llvm.fmuladd.v4f16(<4 x half>, <4 x half>, <4 x half>) #1
declare half @llvm.sin.f16(half) #1
declare half @llvm.trunc.f16(half) #1
declare half @llvm.round.f16(half) #1
declare half @llvm.rint.f16(half) #1
declare half @llvm.nearbyint.f16(half) #1
declare half @llvm.canonicalize.f16(half) #1
declare half @llvm.minnum.f16(half, half) #1
declare half @llvm.maxnum.f16(half, half) #1
declare half @llvm.amdgcn.sin.f16(half) #1
declare half @llvm.amdgcn.rcp.f16(half) #1

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #1 = { nounwind readnone }
attributes #2 = { nounwind "unsafe-fp-math"="true" }
attributes #3 = { nounwind "no-signed-zeros-fp-math"="true" }
attributes #4 = { nounwind "amdgpu-ieee"="false" "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
