; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S < %s -passes=infer-alignment | FileCheck %s

; ------------------------------------------------------------------------------
; load/store of null
; ------------------------------------------------------------------------------

define void @load_null() {
; CHECK-LABEL: define void @load_null() {
; CHECK-NEXT:    [[X_0:%.*]] = load atomic i32, ptr null unordered, align 4294967296
; CHECK-NEXT:    [[X_1:%.*]] = load atomic i32, ptr null monotonic, align 4294967296
; CHECK-NEXT:    [[X_2:%.*]] = load atomic i32, ptr null seq_cst, align 4294967296
; CHECK-NEXT:    ret void
;
  %x.0 = load atomic i32, ptr null unordered, align 4
  %x.1 = load atomic i32, ptr null monotonic, align 4
  %x.2 = load atomic i32, ptr null seq_cst, align 4
  ret void
}

define void @store_null() {
; CHECK-LABEL: define void @store_null() {
; CHECK-NEXT:    store atomic i32 0, ptr null unordered, align 4294967296
; CHECK-NEXT:    store atomic i32 0, ptr null monotonic, align 4294967296
; CHECK-NEXT:    store atomic i32 0, ptr null seq_cst, align 4294967296
; CHECK-NEXT:    ret void
;
  store atomic i32 0, ptr null unordered, align 4
  store atomic i32 0, ptr null monotonic, align 4
  store atomic i32 0, ptr null seq_cst, align 4
  ret void
}

; ------------------------------------------------------------------------------
; load/store of global
; ------------------------------------------------------------------------------
@c = global i64 42

define void @load_nonnull() {
; CHECK-LABEL: define void @load_nonnull() {
; CHECK-NEXT:    [[X_0:%.*]] = load atomic i32, ptr @c unordered, align 8
; CHECK-NEXT:    [[X_1:%.*]] = load atomic i32, ptr @c monotonic, align 8
; CHECK-NEXT:    [[X_2:%.*]] = load atomic i32, ptr @c seq_cst, align 8
; CHECK-NEXT:    ret void
;
  %x.0 = load atomic i32, ptr @c unordered, align 4
  %x.1 = load atomic i32, ptr @c monotonic, align 4
  %x.2 = load atomic i32, ptr @c seq_cst, align 4
  ret void
}

define void @store_nonnull() {
; CHECK-LABEL: define void @store_nonnull() {
; CHECK-NEXT:    store atomic i32 0, ptr @c unordered, align 8
; CHECK-NEXT:    store atomic i32 0, ptr @c monotonic, align 8
; CHECK-NEXT:    store atomic i32 0, ptr @c seq_cst, align 8
; CHECK-NEXT:    ret void
;
  store atomic i32 0, ptr @c unordered, align 4
  store atomic i32 0, ptr @c monotonic, align 4
  store atomic i32 0, ptr @c seq_cst, align 4
  ret void
}

; ------------------------------------------------------------------------------
; load/store of alloca
; ------------------------------------------------------------------------------

define void @load_alloca() {
; CHECK-LABEL: define void @load_alloca() {
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[X_0:%.*]] = load atomic i32, ptr [[ALLOCA]] unordered, align 4
; CHECK-NEXT:    [[X_1:%.*]] = load atomic i32, ptr [[ALLOCA]] monotonic, align 4
; CHECK-NEXT:    [[X_2:%.*]] = load atomic i32, ptr [[ALLOCA]] seq_cst, align 4
; CHECK-NEXT:    ret void
;
  %alloca = alloca i32
  %x.0 = load atomic i32, ptr %alloca unordered, align 1
  %x.1 = load atomic i32, ptr %alloca monotonic, align 1
  %x.2 = load atomic i32, ptr %alloca seq_cst, align 1
  ret void
}

define void @store_alloca() {
; CHECK-LABEL: define void @store_alloca() {
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store atomic i32 0, ptr [[ALLOCA]] unordered, align 4
; CHECK-NEXT:    store atomic i32 0, ptr [[ALLOCA]] monotonic, align 4
; CHECK-NEXT:    store atomic i32 0, ptr [[ALLOCA]] seq_cst, align 4
; CHECK-NEXT:    ret void
;
  %alloca = alloca i32
  store atomic i32 0, ptr %alloca unordered, align 1
  store atomic i32 0, ptr %alloca monotonic, align 1
  store atomic i32 0, ptr %alloca seq_cst, align 1
  ret void
}
