; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=X64,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=X64,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X64,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+avx512bw,+avx512dq | FileCheck %s --check-prefixes=X64,AVX512VLBWDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512cd,+avx512vl | FileCheck %s --check-prefixes=X64,AVX512,AVX512VLCD
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512cd | FileCheck %s --check-prefixes=X64,AVX512,AVX512CD
;
; Just one 32-bit run to make sure we do reasonable things for i64 lzcnt.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X86-AVX

define <4 x i64> @testv4i64(<4 x i64> %in) nounwind {
; AVX1-LABEL: testv4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm5, %xmm1, %xmm6
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm6, %xmm7
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm6, %xmm3, %xmm6
; AVX1-NEXT:    vpaddb %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm6
; AVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpaddw %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm2, %xmm6
; AVX1-NEXT:    vpsrld $16, %xmm6, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX1-NEXT:    vpaddd %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm6
; AVX1-NEXT:    vpand %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm5, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm3, %xmm1
; AVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv4i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX512VL-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsrlq $32, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv4i64:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VLBWDQ-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv4i64:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntq %ymm0, %ymm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv4i64:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512CD-NEXT:    retq
;
; X86-AVX-LABEL: testv4i64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm3, %ymm3
; X86-AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; X86-AVX-NEXT:    vpand %ymm5, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm2, %ymm2
; X86-AVX-NEXT:    vpand %ymm2, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; X86-AVX-NEXT:    vpsrld $16, %ymm2, %ymm2
; X86-AVX-NEXT:    vpand %ymm2, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrld $16, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpsrlq $32, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpsrlq $32, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    retl

  %out = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %in, i1 0)
  ret <4 x i64> %out
}

define <4 x i64> @testv4i64u(<4 x i64> %in) nounwind {
; AVX1-LABEL: testv4i64u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm2, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm5, %xmm1, %xmm6
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm6, %xmm7
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm6, %xmm3, %xmm6
; AVX1-NEXT:    vpaddb %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm6
; AVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpaddw %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm2, %xmm6
; AVX1-NEXT:    vpsrld $16, %xmm6, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX1-NEXT:    vpaddd %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpshufb %xmm0, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm6
; AVX1-NEXT:    vpand %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm5, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm3, %xmm1
; AVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv4i64u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv4i64u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX512VL-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsrlq $32, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv4i64u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VLBWDQ-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv4i64u:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntq %ymm0, %ymm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv4i64u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512CD-NEXT:    retq
;
; X86-AVX-LABEL: testv4i64u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm3, %ymm3
; X86-AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; X86-AVX-NEXT:    vpand %ymm5, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm2, %ymm2
; X86-AVX-NEXT:    vpand %ymm2, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm2
; X86-AVX-NEXT:    vpsrld $16, %ymm2, %ymm2
; X86-AVX-NEXT:    vpand %ymm2, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrld $16, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddd %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    vpcmpeqd %ymm4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpsrlq $32, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpsrlq $32, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    retl

  %out = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %in, i1 -1)
  ret <4 x i64> %out
}

define <8 x i32> @testv8i32(<8 x i32> %in) nounwind {
; AVX1-LABEL: testv8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm1, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm0, %xmm3
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv8i32:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VLBWDQ-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv8i32:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv8i32:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512CD-NEXT:    retq
;
; X86-AVX-LABEL: testv8i32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm3, %ymm3
; X86-AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; X86-AVX-NEXT:    vpand %ymm5, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm2, %ymm2
; X86-AVX-NEXT:    vpand %ymm2, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpsrld $16, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpsrld $16, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    retl

  %out = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %in, i1 0)
  ret <8 x i32> %out
}

define <8 x i32> @testv8i32u(<8 x i32> %in) nounwind {
; AVX1-LABEL: testv8i32u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm1, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm0, %xmm3
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv8i32u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv8i32u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv8i32u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VLBWDQ-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv8i32u:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv8i32u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512CD-NEXT:    retq
;
; X86-AVX-LABEL: testv8i32u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm3, %ymm3
; X86-AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; X86-AVX-NEXT:    vpand %ymm5, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm2, %ymm2
; X86-AVX-NEXT:    vpand %ymm2, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $8, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpsrld $16, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpsrld $16, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    retl

  %out = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %in, i1 -1)
  ret <8 x i32> %out
}

define <16 x i16> @testv16i16(<16 x i16> %in) nounwind {
; AVX1-LABEL: testv16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv16i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv16i16:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VLBWDQ-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512-LABEL: testv16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpsubw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-AVX-LABEL: testv16i16:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm3, %ymm3
; X86-AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; X86-AVX-NEXT:    vpand %ymm5, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpsrlw $8, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpsrlw $8, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %in, i1 0)
  ret <16 x i16> %out
}

define <16 x i16> @testv16i16u(<16 x i16> %in) nounwind {
; AVX1-LABEL: testv16i16u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX1-NEXT:    vpaddb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv16i16u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv16i16u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv16i16u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm3, %ymm3
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX512VLBWDQ-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VLBWDQ-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512-LABEL: testv16i16u:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpsubw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-AVX-LABEL: testv16i16u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm3, %ymm3
; X86-AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; X86-AVX-NEXT:    vpand %ymm5, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; X86-AVX-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpsrlw $8, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpsrlw $8, %ymm1, %ymm1
; X86-AVX-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %in, i1 -1)
  ret <16 x i16> %out
}

define <32 x i8> @testv32i8(<32 x i8> %in) nounwind {
; AVX1-LABEL: testv32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm1, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpaddb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv32i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv32i8:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512-LABEL: testv32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vpsubb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-AVX-LABEL: testv32i8:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; X86-AVX-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand %ymm3, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; X86-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %in, i1 0)
  ret <32 x i8> %out
}

define <32 x i8> @testv32i8u(<32 x i8> %in) nounwind {
; AVX1-LABEL: testv32i8u:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm1, %xmm6
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm5, %xmm0, %xmm4
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpaddb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: testv32i8u:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: testv32i8u:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VL-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv32i8u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VLBWDQ-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VLBWDQ-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; AVX512VLBWDQ-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VLBWDQ-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; AVX512VLBWDQ-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512-LABEL: testv32i8u:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vplzcntd %zmm1, %zmm1
; AVX512-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    vpsubb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
;
; X86-AVX-LABEL: testv32i8u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X86-AVX-NEXT:    # ymm1 = mem[0,1,0,1]
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; X86-AVX-NEXT:    vpsrlw $4, %ymm0, %ymm0
; X86-AVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; X86-AVX-NEXT:    vpcmpeqb %ymm3, %ymm0, %ymm3
; X86-AVX-NEXT:    vpand %ymm3, %ymm2, %ymm2
; X86-AVX-NEXT:    vpshufb %ymm0, %ymm1, %ymm0
; X86-AVX-NEXT:    vpaddb %ymm0, %ymm2, %ymm0
; X86-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %in, i1 -1)
  ret <32 x i8> %out
}

define <4 x i64> @foldv4i64() nounwind {
; X64-LABEL: foldv4i64:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [55,0,64,56]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv4i64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [55,0,0,0,64,0,56,0]
; X86-AVX-NEXT:    retl
  %out = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> <i64 256, i64 -1, i64 0, i64 255>, i1 0)
  ret <4 x i64> %out
}

define <4 x i64> @foldv4i64u() nounwind {
; X64-LABEL: foldv4i64u:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [55,0,64,56]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv4i64u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [55,0,0,0,64,0,56,0]
; X86-AVX-NEXT:    retl
  %out = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> <i64 256, i64 -1, i64 0, i64 255>, i1 -1)
  ret <4 x i64> %out
}

define <8 x i32> @foldv8i32() nounwind {
; X64-LABEL: foldv8i32:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [23,0,32,24,0,29,27,25]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv8i32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [23,0,32,24,0,29,27,25]
; X86-AVX-NEXT:    retl
  %out = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> <i32 256, i32 -1, i32 0, i32 255, i32 -65536, i32 7, i32 24, i32 88>, i1 0)
  ret <8 x i32> %out
}

define <8 x i32> @foldv8i32u() nounwind {
; X64-LABEL: foldv8i32u:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [23,0,32,24,0,29,27,25]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv8i32u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [23,0,32,24,0,29,27,25]
; X86-AVX-NEXT:    retl
  %out = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> <i32 256, i32 -1, i32 0, i32 255, i32 -65536, i32 7, i32 24, i32 88>, i1 -1)
  ret <8 x i32> %out
}

define <16 x i16> @foldv16i16() nounwind {
; X64-LABEL: foldv16i16:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [7,0,16,8,16,13,11,9,0,8,15,14,13,12,11,10]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv16i16:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [7,0,16,8,16,13,11,9,0,8,15,14,13,12,11,10]
; X86-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> <i16 256, i16 -1, i16 0, i16 255, i16 -65536, i16 7, i16 24, i16 88, i16 -2, i16 254, i16 1, i16 2, i16 4, i16 8, i16 16, i16 32>, i1 0)
  ret <16 x i16> %out
}

define <16 x i16> @foldv16i16u() nounwind {
; X64-LABEL: foldv16i16u:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [7,0,16,8,16,13,11,9,0,8,15,14,13,12,11,10]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv16i16u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [7,0,16,8,16,13,11,9,0,8,15,14,13,12,11,10]
; X86-AVX-NEXT:    retl
  %out = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> <i16 256, i16 -1, i16 0, i16 255, i16 -65536, i16 7, i16 24, i16 88, i16 -2, i16 254, i16 1, i16 2, i16 4, i16 8, i16 16, i16 32>, i1 -1)
  ret <16 x i16> %out
}

define <32 x i8> @foldv32i8() nounwind {
; X64-LABEL: foldv32i8:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2,1,0,8,8,0,0,0,0,0,0,0,0,6,5,5,1]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv32i8:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2,1,0,8,8,0,0,0,0,0,0,0,0,6,5,5,1]
; X86-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> <i8 256, i8 -1, i8 0, i8 255, i8 -65536, i8 7, i8 24, i8 88, i8 -2, i8 254, i8 1, i8 2, i8 4, i8 8, i8 16, i8 32, i8 64, i8 128, i8 256, i8 -256, i8 -128, i8 -64, i8 -32, i8 -16, i8 -8, i8 -4, i8 -2, i8 -1, i8 3, i8 5, i8 7, i8 127>, i1 0)
  ret <32 x i8> %out
}

define <32 x i8> @foldv32i8u() nounwind {
; X64-LABEL: foldv32i8u:
; X64:       # %bb.0:
; X64-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2,1,0,8,8,0,0,0,0,0,0,0,0,6,5,5,1]
; X64-NEXT:    retq
;
; X86-AVX-LABEL: foldv32i8u:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2,1,0,8,8,0,0,0,0,0,0,0,0,6,5,5,1]
; X86-AVX-NEXT:    retl
  %out = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> <i8 256, i8 -1, i8 0, i8 255, i8 -65536, i8 7, i8 24, i8 88, i8 -2, i8 254, i8 1, i8 2, i8 4, i8 8, i8 16, i8 32, i8 64, i8 128, i8 256, i8 -256, i8 -128, i8 -64, i8 -32, i8 -16, i8 -8, i8 -4, i8 -2, i8 -1, i8 3, i8 5, i8 7, i8 127>, i1 -1)
  ret <32 x i8> %out
}

declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1)
declare <8 x i32> @llvm.ctlz.v8i32(<8 x i32>, i1)
declare <16 x i16> @llvm.ctlz.v16i16(<16 x i16>, i1)
declare <32 x i8> @llvm.ctlz.v32i8(<32 x i8>, i1)
