; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X64

; FIXME: Missing fsub(x,fneg(y)) -> fadd(x,y) fold
define float @fneg_strict_fsub_to_strict_fadd(float %x, float %y) nounwind {
; X86-LABEL: fneg_strict_fsub_to_strict_fadd:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-NEXT:    subss %xmm1, %xmm0
; X86-NEXT:    movss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: fneg_strict_fsub_to_strict_fadd:
; X64:       # %bb.0:
; X64-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-NEXT:    subss %xmm1, %xmm0
; X64-NEXT:    retq
  %neg = fneg float %y
  %sub = call float @llvm.experimental.constrained.fsub.f32(float %x, float %neg, metadata!"round.dynamic", metadata!"fpexcept.strict")
  ret float %sub
}

; FIXME: Missing fsub(x,fneg(y)) -> fadd(x,y) fold
define double @fneg_strict_fsub_to_strict_fadd_d(double %x, double %y) nounwind {
; X86-LABEL: fneg_strict_fsub_to_strict_fadd_d:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; X86-NEXT:    xorpd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-NEXT:    subsd %xmm1, %xmm0
; X86-NEXT:    movsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: fneg_strict_fsub_to_strict_fadd_d:
; X64:       # %bb.0:
; X64-NEXT:    xorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-NEXT:    subsd %xmm1, %xmm0
; X64-NEXT:    retq
  %neg = fneg double %y
  %sub = call double @llvm.experimental.constrained.fsub.f64(double %x, double %neg, metadata!"round.dynamic", metadata!"fpexcept.strict")
  ret double %sub
}

; FIXME: Missing fneg(fsub(x,y)) -> fsub(y,x) fold
define float @strict_fsub_fneg_to_strict_fsub(float %x, float %y) nounwind {
; X86-LABEL: strict_fsub_fneg_to_strict_fsub:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    subss {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-NEXT:    movss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: strict_fsub_fneg_to_strict_fsub:
; X64:       # %bb.0:
; X64-NEXT:    subss %xmm1, %xmm0
; X64-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
  %sub = call float @llvm.experimental.constrained.fsub.f32(float %x, float %y, metadata!"round.dynamic", metadata!"fpexcept.strict")
  %neg = fneg float %sub
  ret float %neg
}

; FIXME: Missing fneg(fsub(x,y)) -> fsub(y,x) fold
define double @strict_fsub_fneg_to_strict_fsub_d(double %x, double %y) nounwind {
; X86-LABEL: strict_fsub_fneg_to_strict_fsub_d:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X86-NEXT:    subsd 16(%ebp), %xmm0
; X86-NEXT:    xorpd {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-NEXT:    movlpd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; X64-LABEL: strict_fsub_fneg_to_strict_fsub_d:
; X64:       # %bb.0:
; X64-NEXT:    subsd %xmm1, %xmm0
; X64-NEXT:    xorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-NEXT:    retq
  %sub = call double @llvm.experimental.constrained.fsub.f64(double %x, double %y, metadata!"round.dynamic", metadata!"fpexcept.strict")
  %neg = fneg double %sub
  ret double %neg
}


declare float @llvm.experimental.constrained.fsub.f32(float, float, metadata, metadata)
declare double @llvm.experimental.constrained.fsub.f64(double, double, metadata, metadata)
