; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -verify-machineinstrs < %s | FileCheck -check-prefixes=NO-PRELOAD %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=1 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRELOAD-1 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=2 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRELOAD-2 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=4 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRELOAD-4 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=8 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRELOAD-8 %s

define amdgpu_kernel void @ptr1_i8(ptr addrspace(1) %out, i8 %arg0) {
; NO-PRELOAD-LABEL: ptr1_i8:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    s_and_b32 s0, s4, 0xff
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: ptr1_i8:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    s_and_b32 s0, s0, 0xff
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: ptr1_i8:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_and_b32 s0, s4, 0xff
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: ptr1_i8:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_and_b32 s0, s4, 0xff
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: ptr1_i8:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_and_b32 s0, s4, 0xff
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i8 %arg0 to i32
  store i32 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @ptr1_i8_zext_arg(ptr addrspace(1) %out, i8 zeroext %arg0) {
; NO-PRELOAD-LABEL: ptr1_i8_zext_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    s_and_b32 s0, s4, 0xff
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: ptr1_i8_zext_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    s_and_b32 s0, s0, 0xff
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: ptr1_i8_zext_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_mov_b32 s0, 0xffff
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    v_and_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: ptr1_i8_zext_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_mov_b32 s0, 0xffff
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_and_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: ptr1_i8_zext_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_mov_b32 s0, 0xffff
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_and_b32_sdwa v1, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i8 %arg0 to i32
  store i32 %ext, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ptr1_i16_preload_arg(ptr addrspace(1) %out, i16 %arg0) {
; NO-PRELOAD-LABEL: ptr1_i16_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    s_and_b32 s0, s4, 0xffff
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: ptr1_i16_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    s_and_b32 s0, s0, 0xffff
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: ptr1_i16_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_and_b32 s0, s4, 0xffff
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: ptr1_i16_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_and_b32 s0, s4, 0xffff
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: ptr1_i16_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_and_b32 s0, s4, 0xffff
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i16 %arg0 to i32
  store i32 %ext, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ptr1_i32_preload_arg(ptr addrspace(1) %out, i32 %arg0) {
; NO-PRELOAD-LABEL: ptr1_i32_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s4
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: ptr1_i32_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: ptr1_i32_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: ptr1_i32_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: ptr1_i32_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store i32 %arg0, ptr addrspace(1) %out
  ret void
}

; Check alignment on the second preloaded arg.

define amdgpu_kernel void @i32_ptr1_i32_preload_arg(i32 %arg0, ptr addrspace(1) %out, i32 %arg1) {
; NO-PRELOAD-LABEL: i32_ptr1_i32_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x10
; NO-PRELOAD-NEXT:    s_load_dword s5, s[0:1], 0x0
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x8
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    s_add_i32 s0, s5, s4
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: i32_ptr1_i32_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s3, s[0:1], 0x10
; PRELOAD-1-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    s_add_i32 s0, s2, s3
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: i32_ptr1_i32_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_load_dword s0, s[0:1], 0x10
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-2-NEXT:    s_add_i32 s0, s2, s0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: i32_ptr1_i32_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_add_i32 s0, s2, s6
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: i32_ptr1_i32_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_add_i32 s0, s2, s6
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  %add = add i32 %arg0, %arg1
  store i32 %add, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @ptr1_i16_i16_preload_arg(ptr addrspace(1) %out, i16 %arg0, i16 %arg1) {
; NO-PRELOAD-LABEL: ptr1_i16_i16_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    s_lshr_b32 s0, s4, 16
; NO-PRELOAD-NEXT:    s_and_b32 s1, s4, 0xffff
; NO-PRELOAD-NEXT:    s_add_i32 s0, s1, s0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: ptr1_i16_i16_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    s_lshr_b32 s1, s0, 16
; PRELOAD-1-NEXT:    s_and_b32 s0, s0, 0xffff
; PRELOAD-1-NEXT:    s_add_i32 s0, s0, s1
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: ptr1_i16_i16_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-2-NEXT:    s_and_b32 s1, s4, 0xffff
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s0, 16
; PRELOAD-2-NEXT:    s_add_i32 s0, s1, s0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: ptr1_i16_i16_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-4-NEXT:    s_and_b32 s1, s4, 0xffff
; PRELOAD-4-NEXT:    s_add_i32 s0, s1, s0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: ptr1_i16_i16_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-8-NEXT:    s_and_b32 s1, s4, 0xffff
; PRELOAD-8-NEXT:    s_add_i32 s0, s1, s0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i16 %arg0 to i32
  %ext1 = zext i16 %arg1 to i32
  %add = add i32 %ext, %ext1
  store i32 %add, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ptr1_v2i8_preload_arg(ptr addrspace(1) %out, <2 x i8> %in) {
; NO-PRELOAD-LABEL: ptr1_v2i8_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s4
; NO-PRELOAD-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: ptr1_v2i8_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dword s0, s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: ptr1_v2i8_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-2-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, 0
; PRELOAD-2-NEXT:    global_store_short v1, v0, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: ptr1_v2i8_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-4-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, 0
; PRELOAD-4-NEXT:    global_store_short v1, v0, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: ptr1_v2i8_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-8-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, 0
; PRELOAD-8-NEXT:    global_store_short v1, v0, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <2 x i8> %in, ptr addrspace(1) %out
  ret void
}

; Don't try to preload byref args.

define amdgpu_kernel void @byref_preload_arg(ptr addrspace(1) %out, ptr addrspace(4) byref(i32) align(256) %in.byref, i32 %after.offset) {
; NO-PRELOAD-LABEL: byref_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x100
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s3
; NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; NO-PRELOAD-NEXT:    s_waitcnt vmcnt(0)
; NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; NO-PRELOAD-NEXT:    s_waitcnt vmcnt(0)
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: byref_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x100
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s1
; PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-1-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: byref_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x100
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s1
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-2-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: byref_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x100
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s1
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-4-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: byref_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x100
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s1
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-8-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_waitcnt vmcnt(0)
; PRELOAD-8-NEXT:    s_endpgm
  %in = load i32, ptr addrspace(4) %in.byref
  store volatile i32 %in, ptr addrspace(1) %out, align 4
  store volatile i32 %after.offset, ptr addrspace(1) %out, align 4
  ret void
}

; TODO: Should do partial preload in cases like these where only part of the arg
; can be preloaded.

define amdgpu_kernel void @v8i32_arg(ptr addrspace(1) nocapture %out, <8 x i32> %in) nounwind {
; NO-PRELOAD-LABEL: v8i32_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v4, 0
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s8
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s9
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s10
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s11
; NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16 sc0 sc1
; NO-PRELOAD-NEXT:    s_nop 1
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s7
; NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v8i32_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; PRELOAD-1-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-1-NEXT:    s_nop 1
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v8i32_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; PRELOAD-2-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-2-NEXT:    s_nop 1
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v8i32_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; PRELOAD-4-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-4-NEXT:    s_nop 1
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v8i32_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; PRELOAD-8-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-8-NEXT:    s_nop 1
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <8 x i32> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v3i16_preload_arg(ptr addrspace(1) nocapture %out, <3 x i16> %in) nounwind {
; NO-PRELOAD-LABEL: v3i16_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; NO-PRELOAD-NEXT:    global_store_short v0, v1, s[0:1] offset:4 sc0 sc1
; NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v3i16_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s1
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s0
; PRELOAD-1-NEXT:    global_store_short v0, v1, s[2:3] offset:4 sc0 sc1
; PRELOAD-1-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v3i16_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-2-NEXT:    global_store_short v0, v1, s[2:3] offset:4 sc0 sc1
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v3i16_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-4-NEXT:    global_store_short v0, v1, s[2:3] offset:4 sc0 sc1
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v3i16_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-8-NEXT:    global_store_short v0, v1, s[2:3] offset:4 sc0 sc1
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s4
; PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <3 x i16> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v3i32_preload_arg(ptr addrspace(1) nocapture %out, <3 x i32> %in) nounwind {
; NO-PRELOAD-LABEL: v3i32_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; NO-PRELOAD-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v3i32_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; PRELOAD-1-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-1-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v3i32_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s6
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s7
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s8
; PRELOAD-2-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-2-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v3i32_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s6
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s7
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s8
; PRELOAD-4-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-4-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v3i32_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s6
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s7
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s8
; PRELOAD-8-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-8-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <3 x i32> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v3f32_preload_arg(ptr addrspace(1) nocapture %out, <3 x float> %in) nounwind {
; NO-PRELOAD-LABEL: v3f32_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; NO-PRELOAD-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v3f32_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; PRELOAD-1-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-1-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v3f32_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s6
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s7
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s8
; PRELOAD-2-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v3f32_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s6
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s7
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s8
; PRELOAD-4-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v3f32_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    v_mov_b32_e32 v3, 0
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s6
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s7
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s8
; PRELOAD-8-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <3 x float> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v5i8_preload_arg(ptr addrspace(1) nocapture %out, <5 x i8> %in) nounwind {
; NO-PRELOAD-LABEL: v5i8_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; NO-PRELOAD-NEXT:    global_store_byte v0, v1, s[0:1] offset:4 sc0 sc1
; NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v5i8_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s1
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s0
; PRELOAD-1-NEXT:    global_store_byte v0, v1, s[2:3] offset:4 sc0 sc1
; PRELOAD-1-NEXT:    global_store_dword v0, v2, s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v5i8_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 24
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v1, 8, s0
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-2-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_or_b32_sdwa v1, s0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s5
; PRELOAD-2-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, 0
; PRELOAD-2-NEXT:    global_store_byte v1, v2, s[2:3] offset:4 sc0 sc1
; PRELOAD-2-NEXT:    global_store_dword v1, v0, s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v5i8_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 24
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v1, 8, s0
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-4-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_or_b32_sdwa v1, s0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s5
; PRELOAD-4-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, 0
; PRELOAD-4-NEXT:    global_store_byte v1, v2, s[2:3] offset:4 sc0 sc1
; PRELOAD-4-NEXT:    global_store_dword v1, v0, s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v5i8_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 24
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v1, 8, s0
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-8-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_or_b32_sdwa v1, s0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s5
; PRELOAD-8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, 0
; PRELOAD-8-NEXT:    global_store_byte v1, v2, s[2:3] offset:4 sc0 sc1
; PRELOAD-8-NEXT:    global_store_dword v1, v0, s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <5 x i8> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v5f64_arg(ptr addrspace(1) nocapture %out, <5 x double> %in) nounwind {
; NO-PRELOAD-LABEL: v5f64_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x60
; NO-PRELOAD-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; NO-PRELOAD-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v4, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s8
; NO-PRELOAD-NEXT:    global_store_dwordx2 v4, v[2:3], s[12:13] offset:32 sc0 sc1
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s9
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s10
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s11
; NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] offset:16 sc0 sc1
; NO-PRELOAD-NEXT:    s_nop 1
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s7
; NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v5f64_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x60
; PRELOAD-1-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; PRELOAD-1-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b64_e32 v[2:3], s[12:13]
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-1-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32 sc0 sc1
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-1-NEXT:    s_nop 1
; PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v5f64_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x60
; PRELOAD-2-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; PRELOAD-2-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-2-NEXT:    v_mov_b64_e32 v[2:3], s[12:13]
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-2-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32 sc0 sc1
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-2-NEXT:    s_nop 1
; PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v5f64_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x60
; PRELOAD-4-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; PRELOAD-4-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-4-NEXT:    v_mov_b64_e32 v[2:3], s[12:13]
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-4-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32 sc0 sc1
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-4-NEXT:    s_nop 1
; PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v5f64_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x60
; PRELOAD-8-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; PRELOAD-8-NEXT:    v_mov_b32_e32 v4, 0
; PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-8-NEXT:    v_mov_b64_e32 v[2:3], s[12:13]
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s8
; PRELOAD-8-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32 sc0 sc1
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s9
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s10
; PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s11
; PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16 sc0 sc1
; PRELOAD-8-NEXT:    s_nop 1
; PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s4
; PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s6
; PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s7
; PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <5 x double> %in, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v8i8_preload_arg(ptr addrspace(1) %out, <8 x i8> %in) {
; NO-PRELOAD-LABEL: v8i8_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b64_e32 v[0:1], s[2:3]
; NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: v8i8_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: v8i8_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s5, 8
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s5, 24
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v1, 8, s0
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s5, 16
; PRELOAD-2-NEXT:    v_or_b32_sdwa v0, s5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_or_b32_sdwa v1, s0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-2-NEXT:    v_or_b32_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 24
; PRELOAD-2-NEXT:    v_lshlrev_b16_e64 v2, 8, s0
; PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-2-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_or_b32_sdwa v2, s0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: v8i8_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s5, 8
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s5, 24
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v1, 8, s0
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s5, 16
; PRELOAD-4-NEXT:    v_or_b32_sdwa v0, s5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_or_b32_sdwa v1, s0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-4-NEXT:    v_or_b32_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 24
; PRELOAD-4-NEXT:    v_lshlrev_b16_e64 v2, 8, s0
; PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-4-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_or_b32_sdwa v2, s0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: v8i8_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s5, 8
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s5, 24
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v1, 8, s0
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s5, 16
; PRELOAD-8-NEXT:    v_or_b32_sdwa v0, s5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_or_b32_sdwa v1, s0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 8
; PRELOAD-8-NEXT:    v_or_b32_sdwa v1, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v0, 8, s0
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 24
; PRELOAD-8-NEXT:    v_lshlrev_b16_e64 v2, 8, s0
; PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 16
; PRELOAD-8-NEXT:    v_or_b32_sdwa v0, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_or_b32_sdwa v2, s0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store <8 x i8> %in, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @i64_kernel_preload_arg(ptr addrspace(1) %out, i64 %a) {
; NO-PRELOAD-LABEL: i64_kernel_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s2
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: i64_kernel_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: i64_kernel_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-2-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: i64_kernel_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-4-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: i64_kernel_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-8-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store i64 %a, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @f64_kernel_preload_arg(ptr addrspace(1) %out, double %in) {
; NO-PRELOAD-LABEL: f64_kernel_preload_arg:
; NO-PRELOAD:       ; %bb.0:
; NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s2
; NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; NO-PRELOAD-NEXT:    s_endpgm
;
; PRELOAD-1-LABEL: f64_kernel_preload_arg:
; PRELOAD-1:         s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:    s_nop 0
; PRELOAD-1-NEXT:  ; %bb.0:
; PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x8
; PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; PRELOAD-1-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-1-NEXT:    s_endpgm
;
; PRELOAD-2-LABEL: f64_kernel_preload_arg:
; PRELOAD-2:         s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:    s_nop 0
; PRELOAD-2-NEXT:  ; %bb.0:
; PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-2-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-2-NEXT:    s_endpgm
;
; PRELOAD-4-LABEL: f64_kernel_preload_arg:
; PRELOAD-4:         s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:    s_nop 0
; PRELOAD-4-NEXT:  ; %bb.0:
; PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-4-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-4-NEXT:    s_endpgm
;
; PRELOAD-8-LABEL: f64_kernel_preload_arg:
; PRELOAD-8:         s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:    s_nop 0
; PRELOAD-8-NEXT:  ; %bb.0:
; PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; PRELOAD-8-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3] sc0 sc1
; PRELOAD-8-NEXT:    s_endpgm
  store double %in, ptr addrspace(1) %out
  ret void
}
