; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s

define i1 @test_srem_odd(i29 %X) nounwind {
; CHECK-LABEL: test_srem_odd:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #33099 // =0x814b
; CHECK-NEXT:    mov w9, #24493 // =0x5fad
; CHECK-NEXT:    movk w8, #8026, lsl #16
; CHECK-NEXT:    movk w9, #41, lsl #16
; CHECK-NEXT:    madd w8, w0, w8, w9
; CHECK-NEXT:    mov w9, #48987 // =0xbf5b
; CHECK-NEXT:    movk w9, #82, lsl #16
; CHECK-NEXT:    and w8, w8, #0x1fffffff
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
  %srem = srem i29 %X, 99
  %cmp = icmp eq i29 %srem, 0
  ret i1 %cmp
}

define i1 @test_srem_even(i4 %X) nounwind {
; CHECK-LABEL: test_srem_even:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w8, w0, #0, #4
; CHECK-NEXT:    add w8, w8, w8, lsl #1
; CHECK-NEXT:    ubfx w9, w8, #7, #1
; CHECK-NEXT:    add w8, w9, w8, lsr #4
; CHECK-NEXT:    mov w9, #6 // =0x6
; CHECK-NEXT:    msub w8, w8, w9, w0
; CHECK-NEXT:    and w8, w8, #0xf
; CHECK-NEXT:    cmp w8, #1
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %srem = srem i4 %X, 6
  %cmp = icmp eq i4 %srem, 1
  ret i1 %cmp
}

define i1 @test_srem_pow2_setne(i6 %X) nounwind {
; CHECK-LABEL: test_srem_pow2_setne:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w8, w0, #0, #6
; CHECK-NEXT:    ubfx w8, w8, #9, #2
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    and w8, w8, #0x3c
; CHECK-NEXT:    sub w8, w0, w8
; CHECK-NEXT:    tst w8, #0x3f
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %srem = srem i6 %X, 4
  %cmp = icmp ne i6 %srem, 0
  ret i1 %cmp
}

define <3 x i1> @test_srem_vec(<3 x i33> %X) nounwind {
; CHECK-LABEL: test_srem_vec:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x9, #7282 // =0x1c72
; CHECK-NEXT:    sbfx x8, x0, #0, #33
; CHECK-NEXT:    sbfx x10, x1, #0, #33
; CHECK-NEXT:    movk x9, #29127, lsl #16
; CHECK-NEXT:    mov x13, #7281 // =0x1c71
; CHECK-NEXT:    sbfx x12, x2, #0, #33
; CHECK-NEXT:    movk x9, #50972, lsl #32
; CHECK-NEXT:    movk x13, #29127, lsl #16
; CHECK-NEXT:    movk x9, #7281, lsl #48
; CHECK-NEXT:    movk x13, #50972, lsl #32
; CHECK-NEXT:    smulh x11, x8, x9
; CHECK-NEXT:    movk x13, #7281, lsl #48
; CHECK-NEXT:    smulh x9, x10, x9
; CHECK-NEXT:    smulh x13, x12, x13
; CHECK-NEXT:    add x11, x11, x11, lsr #63
; CHECK-NEXT:    add x9, x9, x9, lsr #63
; CHECK-NEXT:    add x11, x11, x11, lsl #3
; CHECK-NEXT:    add x9, x9, x9, lsl #3
; CHECK-NEXT:    sub x8, x8, x11
; CHECK-NEXT:    sub x11, x13, x12
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    mov x8, #8589934591 // =0x1ffffffff
; CHECK-NEXT:    sub x9, x10, x9
; CHECK-NEXT:    asr x10, x11, #3
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    mov v0.d[1], x9
; CHECK-NEXT:    add x9, x10, x11, lsr #63
; CHECK-NEXT:    add x8, x9, x9, lsl #3
; CHECK-NEXT:    adrp x9, .LCPI3_0
; CHECK-NEXT:    ldr q2, [x9, :lo12:.LCPI3_0]
; CHECK-NEXT:    add x8, x12, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    fmov d3, x8
; CHECK-NEXT:    adrp x8, .LCPI3_1
; CHECK-NEXT:    cmeq v0.2d, v0.2d, v2.2d
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI3_1]
; CHECK-NEXT:    and v1.16b, v3.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    cmeq v1.2d, v1.2d, v2.2d
; CHECK-NEXT:    xtn v0.2s, v0.2d
; CHECK-NEXT:    mvn v1.16b, v1.16b
; CHECK-NEXT:    xtn v1.2s, v1.2d
; CHECK-NEXT:    mov w1, v0.s[1]
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    fmov w2, s1
; CHECK-NEXT:    ret
  %srem = srem <3 x i33> %X, <i33 9, i33 9, i33 -9>
  %cmp = icmp ne <3 x i33> %srem, <i33 3, i33 -3, i33 3>
  ret <3 x i1> %cmp
}
