; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1-ONLY,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2,AVX2-SLOW,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2,AVX2-FAST,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512F,AVX512F-SLOW,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512F,AVX512F-FAST,FALLBACK7

define void @load_single_128bit_elt_vector(ptr %in, ptr %off, ptr %out) nounwind {
; SSE-LABEL: load_single_128bit_elt_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    xorps %xmm1, %xmm1
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_single_128bit_elt_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vmovaps %xmm1, 16(%rdx)
; AVX-NEXT:    vmovaps %xmm0, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_single_128bit_elt_vector:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vmovaps %xmm1, 16(%rdx)
; AVX2-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_single_128bit_elt_vector:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; AVX512F-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vmovaps %xmm1, 16(%rdx)
; AVX512F-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512F-NEXT:    retq
  %i0 = load <16 x i8>, ptr %in, align 64
  %i1 = bitcast <16 x i8> %i0 to <1 x i128>
  %i2 = shufflevector <1 x i128> %i1, <1 x i128> zeroinitializer, <2 x i32> <i32 0, i32 1>
  %i3 = bitcast <2 x i128> %i2 to <32 x i8>
  store <32 x i8> %i3, ptr %out, align 64
  ret void
}
define void @store_single_128bit_elt_vector(ptr %in, ptr %off, ptr %out) nounwind {
; SSE-LABEL: store_single_128bit_elt_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_single_128bit_elt_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps %xmm0, (%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_single_128bit_elt_vector:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_single_128bit_elt_vector:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; AVX512F-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
  %i0 = load <32 x i8>, ptr %in, align 64
  %i1 = bitcast <32 x i8> %i0 to <2 x i128>
  %i2 = shufflevector <2 x i128> %i1, <2 x i128> poison, <1 x i32> <i32 0>
  %i3 = bitcast <1 x i128> %i2 to <16 x i8>
  store <16 x i8> %i3, ptr %out, align 64
  ret void
}

define void @load_single_256bit_elt_vector(ptr %in, ptr %off, ptr %out) nounwind {
; SSE-LABEL: load_single_256bit_elt_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    xorps %xmm2, %xmm2
; SSE-NEXT:    movaps %xmm2, 48(%rdx)
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_single_256bit_elt_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_single_256bit_elt_vector:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_single_256bit_elt_vector:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; AVX512F-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX512F-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
  %i0 = load <32 x i8>, ptr %in, align 64
  %i1 = bitcast <32 x i8> %i0 to <1 x i256>
  %i2 = shufflevector <1 x i256> %i1, <1 x i256> zeroinitializer, <2 x i32> <i32 0, i32 1>
  %i3 = bitcast <2 x i256> %i2 to <64 x i8>
  store <64 x i8> %i3, ptr %out, align 64
  ret void
}
define void @store_single_256bit_elt_vector(ptr %in, ptr %off, ptr %out) nounwind {
; SSE-LABEL: store_single_256bit_elt_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_single_256bit_elt_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_single_256bit_elt_vector:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_single_256bit_elt_vector:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %zmm0
; AVX512F-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
  %i0 = load <64 x i8>, ptr %in, align 64
  %i1 = bitcast <64 x i8> %i0 to <2 x i256>
  %i2 = shufflevector <2 x i256> %i1, <2 x i256> poison, <1 x i32> <i32 0>
  %i3 = bitcast <1 x i256> %i2 to <32 x i8>
  store <32 x i8> %i3, ptr %out, align 64
  ret void
}

define void @load_single_512bit_elt_vector(ptr %in, ptr %off, ptr %out) nounwind {
; SSE-LABEL: load_single_512bit_elt_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rdi), %xmm3
; SSE-NEXT:    xorps %xmm4, %xmm4
; SSE-NEXT:    movaps %xmm4, 112(%rdx)
; SSE-NEXT:    movaps %xmm4, 96(%rdx)
; SSE-NEXT:    movaps %xmm4, 80(%rdx)
; SSE-NEXT:    movaps %xmm4, 64(%rdx)
; SSE-NEXT:    movaps %xmm3, 48(%rdx)
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_single_512bit_elt_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vmovaps %ymm2, 96(%rdx)
; AVX-NEXT:    vmovaps %ymm2, 64(%rdx)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_single_512bit_elt_vector:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vmovaps %ymm2, 96(%rdx)
; AVX2-NEXT:    vmovaps %ymm2, 64(%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_single_512bit_elt_vector:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %zmm0
; AVX512F-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vmovaps %zmm1, 64(%rdx)
; AVX512F-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
  %i0 = load <64 x i8>, ptr %in, align 128
  %i1 = bitcast <64 x i8> %i0 to <1 x i512>
  %i2 = shufflevector <1 x i512> %i1, <1 x i512> zeroinitializer, <2 x i32> <i32 0, i32 1>
  %i3 = bitcast <2 x i512> %i2 to <128 x i8>
  store <128 x i8> %i3, ptr %out, align 128
  ret void
}
define void @store_single_512bit_elt_vector(ptr %in, ptr %off, ptr %out) nounwind {
; SSE-LABEL: store_single_512bit_elt_vector:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, 48(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_single_512bit_elt_vector:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_single_512bit_elt_vector:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_single_512bit_elt_vector:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %zmm0
; AVX512F-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
  %i0 = load <128 x i8>, ptr %in, align 128
  %i1 = bitcast <128 x i8> %i0 to <2 x i512>
  %i2 = shufflevector <2 x i512> %i1, <2 x i512> poison, <1 x i32> <i32 0>
  %i3 = bitcast <1 x i512> %i2 to <64 x i8>
  store <64 x i8> %i3, ptr %out, align 128
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX1-ONLY: {{.*}}
; AVX2-FAST: {{.*}}
; AVX2-FAST-PERLANE: {{.*}}
; AVX2-SLOW: {{.*}}
; AVX512F-FAST: {{.*}}
; AVX512F-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; SSE2: {{.*}}
; SSE42: {{.*}}
