; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --relocation-model=pic < %s | FileCheck %s --check-prefix=LA32PIC
; RUN: llc --mtriple=loongarch64 --relocation-model=pic < %s | FileCheck %s --check-prefix=LA64PIC
; RUN: llc --mtriple=loongarch32 < %s | FileCheck %s --check-prefix=LA32NOPIC
; RUN: llc --mtriple=loongarch64 < %s | FileCheck %s --check-prefix=LA64NOPIC

;; Check that TLS symbols are lowered correctly based on the specified
;; model. Make sure they're external to avoid them all being optimised to Local
;; Exec for the executable.

@unspecified = external thread_local global i32
@ld = external thread_local(localdynamic) global i32
@ie = external thread_local(initialexec) global i32
@le = external thread_local(localexec) global i32

;; No model specified (global dynamic)

define ptr @f1() nounwind {
; LA32PIC-LABEL: f1:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    addi.w $sp, $sp, -16
; LA32PIC-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32PIC-NEXT:    pcalau12i $a0, %gd_pc_hi20(unspecified)
; LA32PIC-NEXT:    addi.w $a0, $a0, %got_pc_lo12(unspecified)
; LA32PIC-NEXT:    bl %plt(__tls_get_addr)
; LA32PIC-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32PIC-NEXT:    addi.w $sp, $sp, 16
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f1:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    addi.d $sp, $sp, -16
; LA64PIC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64PIC-NEXT:    pcalau12i $a0, %gd_pc_hi20(unspecified)
; LA64PIC-NEXT:    addi.d $a0, $a0, %got_pc_lo12(unspecified)
; LA64PIC-NEXT:    bl %plt(__tls_get_addr)
; LA64PIC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64PIC-NEXT:    addi.d $sp, $sp, 16
; LA64PIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f1:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(unspecified)
; LA32NOPIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(unspecified)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f1:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(unspecified)
; LA64NOPIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(unspecified)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
entry:
  ret ptr @unspecified
}

;; localdynamic specified

define ptr @f2() nounwind {
; LA32PIC-LABEL: f2:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    addi.w $sp, $sp, -16
; LA32PIC-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32PIC-NEXT:    pcalau12i $a0, %ld_pc_hi20(ld)
; LA32PIC-NEXT:    addi.w $a0, $a0, %got_pc_lo12(ld)
; LA32PIC-NEXT:    bl %plt(__tls_get_addr)
; LA32PIC-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32PIC-NEXT:    addi.w $sp, $sp, 16
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f2:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    addi.d $sp, $sp, -16
; LA64PIC-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64PIC-NEXT:    pcalau12i $a0, %ld_pc_hi20(ld)
; LA64PIC-NEXT:    addi.d $a0, $a0, %got_pc_lo12(ld)
; LA64PIC-NEXT:    bl %plt(__tls_get_addr)
; LA64PIC-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; LA64PIC-NEXT:    addi.d $sp, $sp, 16
; LA64PIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f2:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ld)
; LA32NOPIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ld)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f2:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ld)
; LA64NOPIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ld)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
entry:
  ret ptr @ld
}

;; initialexec specified

define ptr @f3() nounwind {
; LA32PIC-LABEL: f3:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA32PIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ie)
; LA32PIC-NEXT:    add.w $a0, $a0, $tp
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f3:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64PIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ie)
; LA64PIC-NEXT:    add.d $a0, $a0, $tp
; LA64PIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f3:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA32NOPIC-NEXT:    ld.w $a0, $a0, %ie_pc_lo12(ie)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f3:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    pcalau12i $a0, %ie_pc_hi20(ie)
; LA64NOPIC-NEXT:    ld.d $a0, $a0, %ie_pc_lo12(ie)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
entry:
  ret ptr @ie
}

;; localexec specified

define ptr @f4() nounwind {
; LA32PIC-LABEL: f4:
; LA32PIC:       # %bb.0: # %entry
; LA32PIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA32PIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA32PIC-NEXT:    add.w $a0, $a0, $tp
; LA32PIC-NEXT:    ret
;
; LA64PIC-LABEL: f4:
; LA64PIC:       # %bb.0: # %entry
; LA64PIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64PIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64PIC-NEXT:    add.d $a0, $a0, $tp
; LA64PIC-NEXT:    ret
;
; LA32NOPIC-LABEL: f4:
; LA32NOPIC:       # %bb.0: # %entry
; LA32NOPIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA32NOPIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA32NOPIC-NEXT:    add.w $a0, $a0, $tp
; LA32NOPIC-NEXT:    ret
;
; LA64NOPIC-LABEL: f4:
; LA64NOPIC:       # %bb.0: # %entry
; LA64NOPIC-NEXT:    lu12i.w $a0, %le_hi20(le)
; LA64NOPIC-NEXT:    ori $a0, $a0, %le_lo12(le)
; LA64NOPIC-NEXT:    add.d $a0, $a0, $tp
; LA64NOPIC-NEXT:    ret
entry:
  ret ptr @le
}
