; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -march=amdgcn -verify-machineinstrs | FileCheck %s -enable-var-scope --check-prefix=SI
; RUN: llc < %s -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs | FileCheck %s -enable-var-scope --check-prefix=VI
; RUN: llc < %s -march=r600 -mcpu=cypress -verify-machineinstrs | FileCheck %s -enable-var-scope --check-prefix=EG
; RUN: llc < %s -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -enable-var-scope --check-prefix=GFX10
; RUN: llc < %s -global-isel -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -enable-var-scope --check-prefix=GFX10-GISEL
; RUN: llc < %s -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck %s -enable-var-scope --check-prefix=GFX11

declare i7 @llvm.ctlz.i7(i7, i1) nounwind readnone
declare i8 @llvm.ctlz.i8(i8, i1) nounwind readnone
declare i16 @llvm.ctlz.i16(i16, i1) nounwind readnone

declare i32 @llvm.ctlz.i32(i32, i1) nounwind readnone
declare <2 x i32> @llvm.ctlz.v2i32(<2 x i32>, i1) nounwind readnone
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1) nounwind readnone

declare i64 @llvm.ctlz.i64(i64, i1) nounwind readnone
declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1) nounwind readnone
declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1) nounwind readnone

declare i32 @llvm.amdgcn.workitem.id.x() nounwind readnone

define amdgpu_kernel void @s_ctlz_i32(ptr addrspace(1) noalias %out, i32 %val) nounwind {
; SI-LABEL: s_ctlz_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s2, s[0:1], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b32 s2, s2
; SI-NEXT:    s_min_u32 s4, s2, 32
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[0:1], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b32 s4, s4
; VI-NEXT:    s_min_u32 s4, s4, 32
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 3, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     FFBH_UINT * T0.W, KC0[2].Z,
; EG-NEXT:     CNDE_INT T0.X, KC0[2].Z, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    32(4.484155e-44), 2(2.802597e-45)
;
; GFX10-LABEL: s_ctlz_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_flbit_i32_b32 s0, s4
; GFX10-NEXT:    s_min_u32 s0, s0, 32
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: s_ctlz_i32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_clause 0x1
; GFX10-GISEL-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_flbit_i32_b32 s0, s4
; GFX10-GISEL-NEXT:    s_min_u32 s0, s0, 32
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: s_ctlz_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clz_i32_u32 s2, s2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_min_u32 s2, s2, 32
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 false) nounwind readnone
  store i32 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v0, 32, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 3, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    32(4.484155e-44), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep, align 4
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 false) nounwind readnone
  store i32 %ctlz, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_ctlz_v2i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v1, 32, v1
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v1, 32, v1
; VI-NEXT:    v_min_u32_e32 v0, 32, v0
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_v2i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 6, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.Y,
; EG-NEXT:     CNDE_INT T0.Y, T0.Y, literal.x, PV.W,
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    32(4.484155e-44), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_v2i32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dwordx2 v[0:1], v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v1, v1
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX11-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr <2 x i32>, ptr addrspace(1) %valptr, i32 %tid
  %val = load <2 x i32>, ptr addrspace(1) %in.gep, align 8
  %ctlz = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %val, i1 false) nounwind readnone
  store <2 x i32> %ctlz, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v_ctlz_v4i32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v3, v3
; SI-NEXT:    v_ffbh_u32_e32 v2, v2
; SI-NEXT:    v_ffbh_u32_e32 v1, v1
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v3, 32, v3
; SI-NEXT:    v_min_u32_e32 v2, 32, v2
; SI-NEXT:    v_min_u32_e32 v1, 32, v1
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v3, v3
; VI-NEXT:    v_ffbh_u32_e32 v2, v2
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v3, 32, v3
; VI-NEXT:    v_min_u32_e32 v2, 32, v2
; VI-NEXT:    v_min_u32_e32 v1, 32, v1
; VI-NEXT:    v_min_u32_e32 v0, 32, v0
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_v4i32:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    4(5.605194e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T1.W, T0.W,
; EG-NEXT:     FFBH_UINT T2.W, T0.Z,
; EG-NEXT:     CNDE_INT * T0.W, T0.W, literal.x, PV.W, BS:VEC_021/SCL_122
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.Z, T0.Z, literal.x, PV.W,
; EG-NEXT:     FFBH_UINT * T1.W, T0.Y,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.Y, T0.Y, literal.x, PV.W,
; EG-NEXT:     FFBH_UINT * T1.W, T0.X,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    32(4.484155e-44), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v3, v3
; GFX10-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX10-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_min_u32_e32 v3, 32, v3
; GFX10-NEXT:    v_min_u32_e32 v2, 32, v2
; GFX10-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_v4i32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dwordx4 v[0:3], v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v3, v3
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    v_min_u32_e32 v2, 32, v2
; GFX10-GISEL-NEXT:    v_min_u32_e32 v3, 32, v3
; GFX10-GISEL-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_v4i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b128 v[0:3], v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v3, v3
; GFX11-NEXT:    v_clz_i32_u32_e32 v2, v2
; GFX11-NEXT:    v_clz_i32_u32_e32 v1, v1
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_min_u32_e32 v3, 32, v3
; GFX11-NEXT:    v_min_u32_e32 v2, 32, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX11-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr <4 x i32>, ptr addrspace(1) %valptr, i32 %tid
  %val = load <4 x i32>, ptr addrspace(1) %in.gep, align 16
  %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %val, i1 false) nounwind readnone
  store <4 x i32> %ctlz, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @v_ctlz_i8(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    v_subrev_i32_e32 v0, vcc, 24, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ubyte v0, off, s[8:11], 0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v0, 32, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, -16, v0
; VI-NEXT:    v_add_u16_e32 v0, -8, v0
; VI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i8:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 15, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.y,
; EG-NEXT:    32(4.484155e-44), 3(4.203895e-45)
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    -24(nan), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, T1.W, literal.y,
; EG-NEXT:    255(3.573311e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: v_ctlz_i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ubyte v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v1, -16, v1
; GFX10-NEXT:    v_add_nc_u16 v1, v1, -8
; GFX10-NEXT:    global_store_byte v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i8:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_ubyte v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    v_subrev_nc_u32_e32 v1, 24, v1
; GFX10-GISEL-NEXT:    global_store_byte v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i8:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u8 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v1, -16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u16 v1, v1, -8
; GFX11-NEXT:    global_store_b8 v0, v1, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %val = load i8, ptr addrspace(1) %valptr
  %ctlz = call i8 @llvm.ctlz.i8(i8 %val, i1 false) nounwind readnone
  store i8 %ctlz, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_ctlz_i64(ptr addrspace(1) noalias %out, [8 x i32], i64 %val) nounwind {
; SI-LABEL: s_ctlz_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_flbit_i32_b32 s4, s4
; SI-NEXT:    s_flbit_i32_b32 s5, s5
; SI-NEXT:    s_min_u32 s4, s4, 0xffffffdf
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    s_add_i32 s4, s4, 32
; SI-NEXT:    v_min3_u32 v0, s4, v0, 64
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_flbit_i32_b32 s4, s4
; VI-NEXT:    v_add_u32_e64 v0, s[6:7], s4, 32 clamp
; VI-NEXT:    s_flbit_i32_b32 s4, s5
; VI-NEXT:    v_min3_u32 v0, v0, s4, 64
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 9, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     FFBH_UINT * T0.W, KC0[4].W,
; EG-NEXT:     CNDE_INT * T0.W, KC0[4].W, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T1.W, KC0[5].X,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, KC0[5].X, PS, PV.W,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: s_ctlz_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x4c
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_flbit_i32_b32 s0, s2
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s0, 32 clamp
; GFX10-NEXT:    s_flbit_i32_b32 s0, s3
; GFX10-NEXT:    v_min3_u32 v0, v0, s0, 64
; GFX10-NEXT:    global_store_dwordx2 v1, v[0:1], s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: s_ctlz_i64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_clause 0x1
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x4c
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-GISEL-NEXT:    s_mov_b32 s1, 0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_flbit_i32_b64 s0, s[2:3]
; GFX10-GISEL-NEXT:    s_min_u32 s0, s0, 64
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: s_ctlz_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x4c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clz_i32_u32 s2, s2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_add_nc_u32_e64 v0, s2, 32 clamp
; GFX11-NEXT:    s_clz_i32_u32 s2, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_min3_u32 v0, v0, s2, 64
; GFX11-NEXT:    global_store_b64 v1, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 false)
  store i64 %ctlz, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_ctlz_i64_trunc(ptr addrspace(1) noalias %out, i64 %val) nounwind {
; SI-LABEL: s_ctlz_i64_trunc:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_flbit_i32_b32 s0, s2
; SI-NEXT:    s_min_u32 s0, s0, 0xffffffdf
; SI-NEXT:    s_flbit_i32_b32 s1, s3
; SI-NEXT:    s_add_i32 s0, s0, 32
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    v_min3_u32 v0, s0, v0, 64
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_ctlz_i64_trunc:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_flbit_i32_b32 s0, s2
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_add_u32_e64 v0, s[0:1], s0, 32 clamp
; VI-NEXT:    s_flbit_i32_b32 s0, s3
; VI-NEXT:    v_min3_u32 v0, v0, s0, 64
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: s_ctlz_i64_trunc:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 8, @4, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    ALU clause starting at 4:
; EG-NEXT:     FFBH_UINT * T0.W, KC0[2].W,
; EG-NEXT:     CNDE_INT * T0.W, KC0[2].W, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T1.W, KC0[3].X,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, KC0[3].X, PS, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: s_ctlz_i64_trunc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_flbit_i32_b32 s2, s2
; GFX10-NEXT:    v_add_nc_u32_e64 v0, s2, 32 clamp
; GFX10-NEXT:    s_flbit_i32_b32 s2, s3
; GFX10-NEXT:    v_min3_u32 v0, v0, s2, 64
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: s_ctlz_i64_trunc:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    s_flbit_i32_b64 s2, s[2:3]
; GFX10-GISEL-NEXT:    s_min_u32 s2, s2, 64
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: s_ctlz_i64_trunc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clz_i32_u32 s2, s2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_add_nc_u32_e64 v0, s2, 32 clamp
; GFX11-NEXT:    s_clz_i32_u32 s2, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_min3_u32 v0, v0, s2, 64
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 false)
  %trunc = trunc i64 %ctlz to i32
  store i32 %trunc, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_i64(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctlz_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v2, v2
; SI-NEXT:    v_min_u32_e32 v2, 0xffffffdf, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v2
; SI-NEXT:    v_ffbh_u32_e32 v3, v3
; SI-NEXT:    v_min3_u32 v2, v2, v3, 64
; SI-NEXT:    v_mov_b32_e32 v3, v1
; SI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v3, 3, v0
; VI-NEXT:    v_mov_b32_e32 v2, 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v3
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s0, v3
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_add_u32_e64 v0, s[0:1], v0, 32 clamp
; VI-NEXT:    v_ffbh_u32_e32 v1, v1
; VI-NEXT:    v_min3_u32 v1, v0, v1, 64
; VI-NEXT:    flat_store_dwordx2 v[3:4], v[1:2]
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i64:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 10, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T1.W, T0.X,
; EG-NEXT:     CNDE_INT * T1.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     FFBH_UINT T2.W, T0.Y,
; EG-NEXT:     ADD_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.Y, PS, PV.W,
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, T0.W,
; EG-NEXT:     LSHR * T1.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: v_ctlz_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-NEXT:    v_add_nc_u32_e64 v0, v0, 32 clamp
; GFX10-NEXT:    v_min3_u32 v0, v0, v1, 64
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e64 v0, v0, 32 clamp
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, v1, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, 64, v0
; GFX10-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    v_clz_i32_u32_e32 v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e64 v0, v0, 32 clamp
; GFX11-NEXT:    v_min3_u32 v0, v0, v1, 64
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %tid
  %out.gep = getelementptr i64, ptr addrspace(1) %out, i32 %tid
  %val = load i64, ptr addrspace(1) %in.gep
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 false)
  store i64 %ctlz, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_ctlz_i64_trunc(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; SI-LABEL: v_ctlz_i64_trunc:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; SI-NEXT:    v_mov_b32_e32 v2, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[3:4], v[1:2], s[4:7], 0 addr64
; SI-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v3
; SI-NEXT:    v_min_u32_e32 v0, 0xffffffdf, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 32, v0
; SI-NEXT:    v_ffbh_u32_e32 v3, v4
; SI-NEXT:    v_min3_u32 v0, v0, v3, 64
; SI-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i64_trunc:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s3
; VI-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    flat_load_dwordx2 v[1:2], v[1:2]
; VI-NEXT:    v_add_u32_e32 v3, vcc, s0, v0
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v1
; VI-NEXT:    v_add_u32_e64 v0, s[0:1], v0, 32 clamp
; VI-NEXT:    v_ffbh_u32_e32 v1, v2
; VI-NEXT:    v_min3_u32 v0, v0, v1, 64
; VI-NEXT:    flat_store_dword v[3:4], v0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i64_trunc:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 10, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T1.XY, T1.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T1.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T1.X,
; EG-NEXT:     CNDE_INT * T0.W, T1.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     LSHL T0.Z, T0.X, literal.x,
; EG-NEXT:     FFBH_UINT T1.W, T1.Y,
; EG-NEXT:     ADD_INT * T0.W, PV.W, literal.y,
; EG-NEXT:    2(2.802597e-45), 32(4.484155e-44)
; EG-NEXT:     CNDE_INT T0.X, T1.Y, PS, PV.W,
; EG-NEXT:     ADD_INT * T0.W, KC0[2].Y, PV.Z,
; EG-NEXT:     LSHR * T1.X, PV.W, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: v_ctlz_i64_trunc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[1:2], v1, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX10-NEXT:    v_add_nc_u32_e64 v1, v1, 32 clamp
; GFX10-NEXT:    v_min3_u32 v1, v1, v2, 64
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i64_trunc:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dwordx2 v[1:2], v1, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v1
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v2, v2
; GFX10-GISEL-NEXT:    v_add_nc_u32_e64 v1, v1, 32 clamp
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, v2, v1
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 64, v1
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i64_trunc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[1:2], v1, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v1, v1
; GFX11-NEXT:    v_clz_i32_u32_e32 v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e64 v1, v1, 32 clamp
; GFX11-NEXT:    v_min3_u32 v1, v1, v2, 64
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i64, ptr addrspace(1) %in, i32 %tid
  %out.gep = getelementptr i32, ptr addrspace(1) %out, i32 %tid
  %val = load i64, ptr addrspace(1) %in.gep
  %ctlz = call i64 @llvm.ctlz.i64(i64 %val, i1 false)
  %trunc = trunc i64 %ctlz to i32
  store i32 %trunc, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_ctlz_i32_sel_eq_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i32_sel_eq_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i32_sel_eq_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i32_sel_eq_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 5, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT * T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_i32_sel_eq_neg1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i32_sel_eq_neg1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc_lo
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i32_sel_eq_neg1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 false) nounwind readnone
  %cmp = icmp eq i32 %val, 0
  %sel = select i1 %cmp, i32 -1, i32 %ctlz
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_i32_sel_ne_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i32_sel_ne_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i32_sel_ne_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i32_sel_ne_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 5, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT * T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, T0.X, literal.x, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_i32_sel_ne_neg1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i32_sel_ne_neg1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX10-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, -1, v1, vcc_lo
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i32_sel_ne_neg1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 false) nounwind readnone
  %cmp = icmp ne i32 %val, 0
  %sel = select i1 %cmp, i32 %ctlz, i32 -1
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

; TODO: Should be able to eliminate select here as well.
define amdgpu_kernel void @v_ctlz_i32_sel_eq_bitwidth(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i32_sel_eq_bitwidth:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 32, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i32_sel_eq_bitwidth:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v0, 32, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 32, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i32_sel_eq_bitwidth:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 7, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT * T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     SETE_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, PV.W, T0.W, literal.x,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_i32_sel_eq_bitwidth:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 32, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc_lo
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i32_sel_eq_bitwidth:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 32, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, v0, -1, vcc_lo
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i32_sel_eq_bitwidth:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 32, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc_lo
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 false) nounwind readnone
  %cmp = icmp eq i32 %ctlz, 32
  %sel = select i1 %cmp, i32 -1, i32 %ctlz
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_ctlz_i32_sel_ne_bitwidth(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i32_sel_ne_bitwidth:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_min_u32_e32 v0, 32, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 32, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i32_sel_ne_bitwidth:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_min_u32_e32 v0, 32, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 32, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i32_sel_ne_bitwidth:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 2, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 7, @11, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     LSHL * T0.W, T0.X, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, PV.W,
; EG-NEXT:    ALU clause starting at 11:
; EG-NEXT:     FFBH_UINT * T0.W, T0.X,
; EG-NEXT:     CNDE_INT * T0.W, T0.X, literal.x, PV.W,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     SETNE_INT * T1.W, PV.W, literal.x,
; EG-NEXT:    32(4.484155e-44), 0(0.000000e+00)
; EG-NEXT:     CNDE_INT T0.X, PV.W, literal.x, T0.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; EG-NEXT:    -1(nan), 2(2.802597e-45)
;
; GFX10-LABEL: v_ctlz_i32_sel_ne_bitwidth:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 32, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc_lo
; GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i32_sel_ne_bitwidth:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX10-GISEL-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 32, v0
; GFX10-GISEL-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc_lo
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i32_sel_ne_bitwidth:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_u32_e32 v0, 32, v0
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 32, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, -1, v0, vcc_lo
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %in.gep = getelementptr i32, ptr addrspace(1) %valptr, i32 %tid
  %val = load i32, ptr addrspace(1) %in.gep
  %ctlz = call i32 @llvm.ctlz.i32(i32 %val, i1 false) nounwind readnone
  %cmp = icmp ne i32 %ctlz, 32
  %sel = select i1 %cmp, i32 %ctlz, i32 -1
  store i32 %sel, ptr addrspace(1) %out
  ret void
}

 define amdgpu_kernel void @v_ctlz_i8_sel_eq_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i8_sel_eq_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i8_sel_eq_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i8_sel_eq_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, T0.X,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     FFBH_UINT T0.W, T0.X,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    255(3.573311e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: v_ctlz_i8_sel_eq_neg1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ubyte v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    global_store_byte v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i8_sel_eq_neg1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_ashrrev_i32_e32 v3, 31, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v1, v0
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v2, v3, vcc_lo
; GFX10-GISEL-NEXT:    global_load_ubyte v0, v[0:1], off
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    v_subrev_nc_u32_e32 v1, 24, v1
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, v1, -1, vcc_lo
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    global_store_byte v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i8_sel_eq_neg1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    global_store_b8 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %valptr.gep = getelementptr i8, ptr addrspace(1) %valptr, i32 %tid
  %val = load i8, ptr addrspace(1) %valptr.gep
  %ctlz = call i8 @llvm.ctlz.i8(i8 %val, i1 false) nounwind readnone
  %cmp = icmp eq i8 %val, 0
  %sel = select i1 %cmp, i8 -1, i8 %ctlz
  store i8 %sel, ptr addrspace(1) %out
  ret void
}

 define amdgpu_kernel void @v_ctlz_i16_sel_eq_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i16_sel_eq_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i16_sel_eq_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s10, s6
; VI-NEXT:    s_mov_b32 s11, s7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_load_ushort v0, off, s[8:11], 0
; VI-NEXT:    v_mov_b32_e32 v1, 0xffff
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v2, v0
; VI-NEXT:    v_min_u32_e32 v2, 32, v2
; VI-NEXT:    v_add_u32_e32 v2, vcc, -16, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i16_sel_eq_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_16 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     MOV * T0.X, KC0[2].Z,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     FFBH_UINT T0.W, T0.X,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    65535(9.183409e-41), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: v_ctlz_i16_sel_eq_neg1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v2, v1
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_min_u32_e32 v2, 32, v2
; GFX10-NEXT:    v_add_nc_u32_e32 v2, -16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0xffff, v2, vcc_lo
; GFX10-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i16_sel_eq_neg1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v2, v1
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX10-GISEL-NEXT:    v_min_u32_e32 v2, 32, v2
; GFX10-GISEL-NEXT:    v_subrev_nc_u32_e32 v2, 16, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v1, v2, 0xffff, vcc_lo
; GFX10-GISEL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i16_sel_eq_neg1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v2, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_min_u32_e32 v2, 32, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v2, -16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0xffff, v2, vcc_lo
; GFX11-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %val = load i16, ptr addrspace(1) %valptr
  %ctlz = call i16 @llvm.ctlz.i16(i16 %val, i1 false) nounwind readnone
  %cmp = icmp eq i16 %val, 0
  %sel = select i1 %cmp, i16 -1, i16 %ctlz
  store i16 %sel, ptr addrspace(1) %out
  ret void
}

; FIXME: Need to handle non-uniform case for function below (load without gep).
define amdgpu_kernel void @v_ctlz_i7_sel_eq_neg1(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %valptr) nounwind {
; SI-LABEL: v_ctlz_i7_sel_eq_neg1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_mov_b32 s10, 0
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_ubyte v0, v[0:1], s[8:11], 0 addr64
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_ffbh_u32_e32 v0, v0
; SI-NEXT:    v_and_b32_e32 v0, 0x7f, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_ctlz_i7_sel_eq_neg1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_ubyte v0, v[0:1]
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_ffbh_u32_e32 v0, v0
; VI-NEXT:    v_and_b32_e32 v0, 0x7f, v0
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: v_ctlz_i7_sel_eq_neg1:
; EG:       ; %bb.0:
; EG-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 0 @6
; EG-NEXT:    ALU 12, @9, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_8 T0.X, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 8:
; EG-NEXT:     ADD_INT * T0.X, KC0[2].Z, T0.X,
; EG-NEXT:    ALU clause starting at 9:
; EG-NEXT:     FFBH_UINT T0.W, T0.X,
; EG-NEXT:     AND_INT * T1.W, KC0[2].Y, literal.x,
; EG-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; EG-NEXT:     AND_INT T0.W, PV.W, literal.x,
; EG-NEXT:     LSHL * T1.W, PS, literal.y,
; EG-NEXT:    127(1.779649e-43), 3(4.203895e-45)
; EG-NEXT:     LSHL T0.X, PV.W, PS,
; EG-NEXT:     LSHL * T0.W, literal.x, PS,
; EG-NEXT:    255(3.573311e-43), 0(0.000000e+00)
; EG-NEXT:     MOV T0.Y, 0.0,
; EG-NEXT:     MOV * T0.Z, 0.0,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX10-LABEL: v_ctlz_i7_sel_eq_neg1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_ubyte v0, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ffbh_u32_e32 v0, v0
; GFX10-NEXT:    v_and_b32_e32 v0, 0x7f, v0
; GFX10-NEXT:    global_store_byte v1, v0, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_ctlz_i7_sel_eq_neg1:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_ashrrev_i32_e32 v3, 31, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v1, v0
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v2, v3, vcc_lo
; GFX10-GISEL-NEXT:    global_load_ubyte v0, v[0:1], off
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0x7f, v0
; GFX10-GISEL-NEXT:    v_ffbh_u32_e32 v1, v0
; GFX10-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-GISEL-NEXT:    v_min_u32_e32 v1, 32, v1
; GFX10-GISEL-NEXT:    v_subrev_nc_u32_e32 v1, 25, v1
; GFX10-GISEL-NEXT:    v_cndmask_b32_e64 v0, v1, 0x7f, vcc_lo
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, 0x7f, v0
; GFX10-GISEL-NEXT:    global_store_byte v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-LABEL: v_ctlz_i7_sel_eq_neg1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_u8 v0, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_clz_i32_u32_e32 v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x7f, v0
; GFX11-NEXT:    global_store_b8 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %valptr.gep = getelementptr i7, ptr addrspace(1) %valptr, i32 %tid
  %val = load i7, ptr addrspace(1) %valptr.gep
  %ctlz = call i7 @llvm.ctlz.i7(i7 %val, i1 false) nounwind readnone
  %cmp = icmp eq i7 %val, 0
  %sel = select i1 %cmp, i7 -1, i7 %ctlz
  store i7 %sel, ptr addrspace(1) %out
  ret void
}
