; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Verify that strlen calls with elements of constant arrays are folded.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i64 @strlen(i8*)

@a5_4 = constant [5 x [4 x i8]] [[4 x i8] c"123\00", [4 x i8] c"12\00\00", [4 x i8] c"1\00\00\00", [4 x i8] zeroinitializer, [4 x i8] zeroinitializer]


; Fold strlen(a5_4[0]) to 3.

define i64 @fold_a5_4_i0_to_3() {
; CHECK-LABEL: @fold_a5_4_i0_to_3(
; CHECK-NEXT:    ret i64 3
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 0, i64 0
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[0][1]) to 2.

define i64 @fold_a5_4_i0_p1_to_2() {
; CHECK-LABEL: @fold_a5_4_i0_p1_to_2(
; CHECK-NEXT:    ret i64 2
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 0, i64 1
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[0][2]) to 1.

define i64 @fold_a5_4_i0_p2_to_1() {
; CHECK-LABEL: @fold_a5_4_i0_p2_to_1(
; CHECK-NEXT:    ret i64 1
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 0, i64 2
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[0][3]) to 0.

define i64 @fold_a5_4_i0_p3_to_0() {
; CHECK-LABEL: @fold_a5_4_i0_p3_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 0, i64 3
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(a5_4[1]) to 2.

define i64 @fold_a5_4_i1_to_2() {
; CHECK-LABEL: @fold_a5_4_i1_to_2(
; CHECK-NEXT:    ret i64 2
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 1, i64 0
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[1][1]) to 1.

define i64 @fold_a5_4_i1_p1_to_1() {
; CHECK-LABEL: @fold_a5_4_i1_p1_to_1(
; CHECK-NEXT:    ret i64 1
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 1, i64 1
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[1][2]) to 0.

define i64 @fold_a5_4_i1_p2_to_0() {
; CHECK-LABEL: @fold_a5_4_i1_p2_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 1, i64 2
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[1][3]) to 0.

define i64 @fold_a5_4_i1_p3_to_0() {
; CHECK-LABEL: @fold_a5_4_i1_p3_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 1, i64 3
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(a5_4[2]) to 1.

define i64 @fold_a5_4_i2_to_1() {
; CHECK-LABEL: @fold_a5_4_i2_to_1(
; CHECK-NEXT:    ret i64 1
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 2, i64 0
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[2][1]) to 0.

define i64 @fold_a5_4_i2_p1_to_0() {
; CHECK-LABEL: @fold_a5_4_i2_p1_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 2, i64 1
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[2][2]) to 0.

define i64 @fold_a5_4_i2_p2_to_0() {
; CHECK-LABEL: @fold_a5_4_i2_p2_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 2, i64 2
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[2][3]) to 0.

define i64 @fold_a5_4_i2_p3_to_0() {
; CHECK-LABEL: @fold_a5_4_i2_p3_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 2, i64 3
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(a5_4[3]) to 0

define i64 @fold_a5_4_i3_to_0() {
; CHECK-LABEL: @fold_a5_4_i3_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 3, i64 0
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[3][1]) to 0

define i64 @fold_a5_4_i3_p1_to_0() {
; CHECK-LABEL: @fold_a5_4_i3_p1_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 3, i64 1
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[3][2]) to 0

define i64 @fold_a5_4_i3_p2_to_0() {
; CHECK-LABEL: @fold_a5_4_i3_p2_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 3, i64 2
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[3][3]) to 0

define i64 @fold_a5_3_i4_p3_to_0() {
; CHECK-LABEL: @fold_a5_3_i4_p3_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 3, i64 3
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(a5_4[4]) to 0

define i64 @fold_a5_4_i4_to_0() {
; CHECK-LABEL: @fold_a5_4_i4_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 4, i64 0
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[4][1]) to 0

define i64 @fold_a5_4_i4_p1_to_0() {
; CHECK-LABEL: @fold_a5_4_i4_p1_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 4, i64 1
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[4][2]) to 0

define i64 @fold_a5_4_i4_p2_to_0() {
; CHECK-LABEL: @fold_a5_4_i4_p2_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 4, i64 2
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}


; Fold strlen(&a5_4[4][3]) to 0

define i64 @fold_a5_4_i4_p3_to_0() {
; CHECK-LABEL: @fold_a5_4_i4_p3_to_0(
; CHECK-NEXT:    ret i64 0
;
  %ptr = getelementptr [5 x [4 x i8]], [5 x [4 x i8]]* @a5_4, i64 0, i64 4, i64 3
  %len = call i64 @strlen(i8* %ptr)
  ret i64 %len
}
