; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i1 @test_slt() {
; CHECK-LABEL: @test_slt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[T_0:%.*]] = icmp slt i8 10, 11
; CHECK-NEXT:    [[F_0:%.*]] = icmp slt i8 10, 10
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 true, false
; CHECK-NEXT:    [[F_1:%.*]] = icmp slt i8 10, 9
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 [[RES_1]], false
; CHECK-NEXT:    [[F_2:%.*]] = icmp slt i8 10, -10
; CHECK-NEXT:    [[RES_3:%.*]] = xor i1 [[RES_2]], false
; CHECK-NEXT:    [[T_1:%.*]] = icmp slt i8 10, 11
; CHECK-NEXT:    [[RES_4:%.*]] = xor i1 [[RES_3]], true
; CHECK-NEXT:    ret i1 [[RES_4]]
;
entry:
  %t.0 = icmp slt i8 10, 11
  %f.0 = icmp slt i8 10, 10
  %res.1 = xor i1 %t.0, %f.0
  %f.1 = icmp slt i8 10, 9
  %res.2 = xor i1 %res.1, %f.1
  %f.2 = icmp slt i8 10, -10
  %res.3 = xor i1 %res.2, %f.2
  %t.1 = icmp slt i8 10, 11
  %res.4 = xor i1 %res.3, %t.1
  ret i1 %res.4
}

define i1 @test_sgt() {
; CHECK-LABEL: @test_sgt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[T_0:%.*]] = icmp sgt i8 11, 10
; CHECK-NEXT:    [[F_0:%.*]] = icmp sgt i8 10, 10
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 true, false
; CHECK-NEXT:    [[F_1:%.*]] = icmp sgt i8 9, 10
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 [[RES_1]], false
; CHECK-NEXT:    [[F_2:%.*]] = icmp sgt i8 -10, 10
; CHECK-NEXT:    [[RES_3:%.*]] = xor i1 [[RES_2]], false
; CHECK-NEXT:    [[T_1:%.*]] = icmp sgt i8 -1, -2
; CHECK-NEXT:    [[RES_4:%.*]] = xor i1 [[RES_3]], true
; CHECK-NEXT:    ret i1 [[RES_4]]
;
entry:
  %t.0 = icmp sgt i8 11, 10
  %f.0 = icmp sgt i8 10, 10
  %res.1 = xor i1 %t.0, %f.0
  %f.1 = icmp sgt i8 9, 10
  %res.2 = xor i1 %res.1, %f.1
  %f.2 = icmp sgt i8 -10, 10
  %res.3 = xor i1 %res.2, %f.2
  %t.1 = icmp sgt i8 -1, -2
  %res.4 = xor i1 %res.3, %t.1
  ret i1 %res.4
}

; Test cases where lhs - rhs results in constant offset.
define i1 @test_slt_gep_1(ptr %base) {
; CHECK-LABEL: @test_slt_gep_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds i8, ptr [[BASE:%.*]], i8 1
; CHECK-NEXT:    [[T_0:%.*]] = icmp slt ptr [[BASE]], [[GEP_1]]
; CHECK-NEXT:    [[GEP_0:%.*]] = getelementptr inbounds i8, ptr [[BASE]], i8 0
; CHECK-NEXT:    [[F_0:%.*]] = icmp slt ptr [[BASE]], [[GEP_0]]
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 [[T_0]], false
; CHECK-NEXT:    [[C_1:%.*]] = icmp slt ptr [[GEP_1]], [[BASE]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 [[RES_1]], [[C_1]]
; CHECK-NEXT:    ret i1 [[RES_2]]
;
entry:
  %gep.1 = getelementptr inbounds i8, ptr %base, i8 1
  %t.0 = icmp slt ptr %base, %gep.1
  %gep.0 = getelementptr inbounds i8, ptr %base, i8 0
  %f.0 = icmp slt ptr %base, %gep.0
  %res.1 = xor i1 %t.0, %f.0
  %c.1 = icmp slt ptr %gep.1, %base
  %res.2 = xor i1 %res.1, %c.1
  ret i1 %res.2
}

define i1 @test_slt_gep_2(ptr %base) {
; CHECK-LABEL: @test_slt_gep_2(
; CHECK-NEXT:    [[GEP_SUB_1:%.*]] = getelementptr inbounds i8, ptr [[BASE:%.*]], i8 -1
; CHECK-NEXT:    [[C_1:%.*]] = icmp slt ptr [[BASE]], [[GEP_SUB_1]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
  %gep.sub.1 = getelementptr inbounds i8, ptr %base, i8 -1
  %c.1 = icmp slt ptr %base, %gep.sub.1
  ret i1 %c.1
}

define i1 @test_slt_gep_3(ptr %base) {
; CHECK-LABEL: @test_slt_gep_3(
; CHECK-NEXT:    [[GEP_1_NOINBOUNDS:%.*]] = getelementptr i8, ptr [[BASE:%.*]], i8 1
; CHECK-NEXT:    [[C_1:%.*]] = icmp slt ptr [[BASE]], [[GEP_1_NOINBOUNDS]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
  %gep.1.noinbounds = getelementptr i8, ptr %base, i8 1
  %c.1 = icmp slt ptr %base, %gep.1.noinbounds
  ret i1 %c.1
}
