; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv32 -verify-machineinstrs -mattr=+m | FileCheck %s -check-prefixes=RV32
; RUN: llc < %s -mtriple=riscv64 -verify-machineinstrs -mattr=+m | FileCheck %s -check-prefixes=RV64

; Test case:
; - Addition should be cheaper than multiplication

; The following LLVM IR simulates:
; int8_t flag2[8193];
; void test(int i) {
;   int tmp = i * 2;
; 	if (i * 2 > 8192) return ;
;   for (int j = 0; ; ++j) {
; 		int offset = j * i + tmp;
; 		flag2[offset] = 0;
; 		if (offset + i > 8192) break;
;   }
; }

; After LSR:
; int8_t flag2[8193];
; void test(int i) {
; 	int j = i * 2;
; 	if (j > 8193) return ;
;   do {
; 		flag2[j] = 0;
; 		j += i;
;   } while (j < 8193);
; }

@flags2 = internal global [8193 x i8] zeroinitializer, align 32		; <[8193 x i8]*> [#uses=1]

define void @test(i32 signext %i) nounwind {
; RV32-LABEL: test:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    slli a1, a0, 1
; RV32-NEXT:    lui a3, 2
; RV32-NEXT:    blt a3, a1, .LBB0_3
; RV32-NEXT:  # %bb.1: # %bb.preheader
; RV32-NEXT:    lui a2, %hi(flags2)
; RV32-NEXT:    addi a2, a2, %lo(flags2)
; RV32-NEXT:    addi a3, a3, 1
; RV32-NEXT:  .LBB0_2: # %bb
; RV32-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32-NEXT:    add a4, a2, a1
; RV32-NEXT:    add a1, a1, a0
; RV32-NEXT:    sb zero, 0(a4)
; RV32-NEXT:    blt a1, a3, .LBB0_2
; RV32-NEXT:  .LBB0_3: # %return
; RV32-NEXT:    ret
;
; RV64-LABEL: test:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    slliw a1, a0, 1
; RV64-NEXT:    lui a4, 2
; RV64-NEXT:    blt a4, a1, .LBB0_3
; RV64-NEXT:  # %bb.1: # %bb.preheader
; RV64-NEXT:    li a2, 0
; RV64-NEXT:    lui a3, %hi(flags2)
; RV64-NEXT:    addi a3, a3, %lo(flags2)
; RV64-NEXT:    addiw a4, a4, 1
; RV64-NEXT:  .LBB0_2: # %bb
; RV64-NEXT:    # =>This Inner Loop Header: Depth=1
; RV64-NEXT:    mulw a5, a2, a0
; RV64-NEXT:    addw a5, a5, a1
; RV64-NEXT:    slli a6, a5, 32
; RV64-NEXT:    srli a6, a6, 32
; RV64-NEXT:    add a6, a3, a6
; RV64-NEXT:    sb zero, 0(a6)
; RV64-NEXT:    addw a5, a5, a0
; RV64-NEXT:    addiw a2, a2, 1
; RV64-NEXT:    blt a5, a4, .LBB0_2
; RV64-NEXT:  .LBB0_3: # %return
; RV64-NEXT:    ret
entry:
	%k_addr.012 = shl i32 %i, 1
	%tmp14 = icmp sgt i32 %k_addr.012, 8192
	%tmp. = shl i32 %i, 1
	br i1 %tmp14, label %return, label %bb

bb:
	%indvar = phi i32 [ 0, %entry ], [ %indvar.next, %bb ]
	%tmp.15 = mul i32 %indvar, %i
	%tmp.16 = add i32 %tmp.15, %tmp.
	%gep.upgrd.1 = zext i32 %tmp.16 to i64
	%tmp = getelementptr [8193 x i8], [8193 x i8]* @flags2, i32 0, i64 %gep.upgrd.1
	store i8 0, i8* %tmp
	%tmp.17 = add i32 %tmp.16, %i
	%tmp.upgrd.2 = icmp sgt i32 %tmp.17, 8192
	%indvar.next = add i32 %indvar, 1
	br i1 %tmp.upgrd.2, label %return, label %bb

return:
	ret void
}
