; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11 %s

define i8 @v_ashr_i8(i8 %value, i8 %amount) {
; GFX6-LABEL: v_ashr_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v1, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i16_sdwa v0, v1, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX10PLUS-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10PLUS-NEXT:    v_ashrrev_i16 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i8 %value, %amount
  ret i8 %result
}

define i8 @v_ashr_i8_7(i8 %value) {
; GFX6-LABEL: v_ashr_i8_7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 7, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i8_7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_ashrrev_i16_e32 v0, 15, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i8_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 7
; GFX9-NEXT:    v_ashrrev_i16_sdwa v0, v1, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i8_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX10PLUS-NEXT:    v_ashrrev_i16 v0, 7, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i8 %value, 7
  ret i8 %result
}

define amdgpu_ps i8 @s_ashr_i8(i8 inreg %value, i8 inreg %amount) {
; GFX6-LABEL: s_ashr_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_sext_i32_i8 s0, s0
; GFX6-NEXT:    s_ashr_i32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_ashr_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i8 s0, s0
; GFX8-NEXT:    s_sext_i32_i8 s1, s1
; GFX8-NEXT:    s_ashr_i32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_ashr_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_sext_i32_i8 s0, s0
; GFX9-NEXT:    s_sext_i32_i8 s1, s1
; GFX9-NEXT:    s_ashr_i32 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i8 s0, s0
; GFX10PLUS-NEXT:    s_sext_i32_i8 s1, s1
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i8 %value, %amount
  ret i8 %result
}

define amdgpu_ps i8 @s_ashr_i8_7(i8 inreg %value) {
; GCN-LABEL: s_ashr_i8_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_sext_i32_i8 s0, s0
; GCN-NEXT:    s_ashr_i32 s0, s0, 7
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i8_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i8 s0, s0
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 7
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i8 %value, 7
  ret i8 %result
}


define i24 @v_ashr_i24(i24 %value, i24 %amount) {
; GCN-LABEL: v_ashr_i24:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GCN-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v1, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i24:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_and_b32_e32 v1, 0xffffff, v1
; GFX10PLUS-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i24 %value, %amount
  ret i24 %result
}

define i24 @v_ashr_i24_7(i24 %value) {
; GCN-LABEL: v_ashr_i24_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 7, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i24_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, 7, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i24 %value, 7
  ret i24 %result
}

define amdgpu_ps i24 @s_ashr_i24(i24 inreg %value, i24 inreg %amount) {
; GCN-LABEL: s_ashr_i24:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-NEXT:    s_ashr_i32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i24:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i24 %value, %amount
  ret i24 %result
}

define amdgpu_ps i24 @s_ashr_i24_7(i24 inreg %value) {
; GCN-LABEL: s_ashr_i24_7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-NEXT:    s_ashr_i32 s0, s0, 7
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i24_7:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 7
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i24 %value, 7
  ret i24 %result
}

define i32 @v_ashr_i32(i32 %value, i32 %amount) {
; GCN-LABEL: v_ashr_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v1, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i32 %value, %amount
  ret i32 %result
}

define i32 @v_ashr_i32_31(i32 %value) {
; GCN-LABEL: v_ashr_i32_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 31, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i32_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, 31, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i32 %value, 31
  ret i32 %result
}

define amdgpu_ps i32 @s_ashr_i32(i32 inreg %value, i32 inreg %amount) {
; GCN-LABEL: s_ashr_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i32 %value, %amount
  ret i32 %result
}

define amdgpu_ps i32 @s_ashr_i32_31(i32 inreg %value) {
; GCN-LABEL: s_ashr_i32_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, 31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i32_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i32 %value, 31
  ret i32 %result
}

define amdgpu_ps float @ashr_i32_sv(i32 inreg %value, i32 %amount) {
; GFX6-LABEL: ashr_i32_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_ashr_i32_e32 v0, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_i32_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_ashrrev_i32_e64 v0, v0, s0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_i32_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_ashrrev_i32_e64 v0, v0, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_i32_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_ashrrev_i32_e64 v0, v0, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i32 %value, %amount
  %cast = bitcast i32 %result to float
  ret float %cast
}

define amdgpu_ps float @ashr_i32_vs(i32 %value, i32 inreg %amount) {
; GCN-LABEL: ashr_i32_vs:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_ashrrev_i32_e32 v0, s0, v0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_i32_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, s0, v0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i32 %value, %amount
  %cast = bitcast i32 %result to float
  ret float %cast
}

define <2 x i32> @v_ashr_v2i32(<2 x i32> %value, <2 x i32> %amount) {
; GCN-LABEL: v_ashr_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v2, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v1, v3, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v2i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, v2, v0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, v3, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <2 x i32> %value, %amount
  ret <2 x i32> %result
}

define <2 x i32> @v_ashr_v2i32_31(<2 x i32> %value) {
; GCN-LABEL: v_ashr_v2i32_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 31, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v2i32_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, 31, v0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, 31, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <2 x i32> %value, <i32 31, i32 31>
  ret <2 x i32> %result
}

define amdgpu_ps <2 x i32> @s_ashr_v2i32(<2 x i32> inreg %value, <2 x i32> inreg %amount) {
; GCN-LABEL: s_ashr_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, s2
; GCN-NEXT:    s_ashr_i32 s1, s1, s3
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v2i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s2
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s3
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <2 x i32> %value, %amount
  ret <2 x i32> %result
}

define <3 x i32> @v_ashr_v3i32(<3 x i32> %value, <3 x i32> %amount) {
; GCN-LABEL: v_ashr_v3i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v3, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v1, v4, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v2, v5, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v3i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, v3, v0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, v4, v1
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v2, v5, v2
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <3 x i32> %value, %amount
  ret <3 x i32> %result
}

define amdgpu_ps <3 x i32> @s_ashr_v3i32(<3 x i32> inreg %value, <3 x i32> inreg %amount) {
; GCN-LABEL: s_ashr_v3i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, s3
; GCN-NEXT:    s_ashr_i32 s1, s1, s4
; GCN-NEXT:    s_ashr_i32 s2, s2, s5
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v3i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s3
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s4
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <3 x i32> %value, %amount
  ret <3 x i32> %result
}

define <4 x i32> @v_ashr_v4i32(<4 x i32> %value, <4 x i32> %amount) {
; GCN-LABEL: v_ashr_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v4, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v1, v5, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v2, v6, v2
; GCN-NEXT:    v_ashrrev_i32_e32 v3, v7, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v4i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, v4, v0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, v5, v1
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v2, v6, v2
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v3, v7, v3
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <4 x i32> %value, %amount
  ret <4 x i32> %result
}

define amdgpu_ps <4 x i32> @s_ashr_v4i32(<4 x i32> inreg %value, <4 x i32> inreg %amount) {
; GCN-LABEL: s_ashr_v4i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, s4
; GCN-NEXT:    s_ashr_i32 s1, s1, s5
; GCN-NEXT:    s_ashr_i32 s2, s2, s6
; GCN-NEXT:    s_ashr_i32 s3, s3, s7
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v4i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s4
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s5
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s6
; GFX10PLUS-NEXT:    s_ashr_i32 s3, s3, s7
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <4 x i32> %value, %amount
  ret <4 x i32> %result
}

define <5 x i32> @v_ashr_v5i32(<5 x i32> %value, <5 x i32> %amount) {
; GCN-LABEL: v_ashr_v5i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v5, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v1, v6, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v2, v7, v2
; GCN-NEXT:    v_ashrrev_i32_e32 v3, v8, v3
; GCN-NEXT:    v_ashrrev_i32_e32 v4, v9, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v5i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, v5, v0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, v6, v1
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v2, v7, v2
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v3, v8, v3
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v4, v9, v4
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <5 x i32> %value, %amount
  ret <5 x i32> %result
}

define amdgpu_ps <5 x i32> @s_ashr_v5i32(<5 x i32> inreg %value, <5 x i32> inreg %amount) {
; GCN-LABEL: s_ashr_v5i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, s5
; GCN-NEXT:    s_ashr_i32 s1, s1, s6
; GCN-NEXT:    s_ashr_i32 s2, s2, s7
; GCN-NEXT:    s_ashr_i32 s3, s3, s8
; GCN-NEXT:    s_ashr_i32 s4, s4, s9
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v5i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s5
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s6
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s7
; GFX10PLUS-NEXT:    s_ashr_i32 s3, s3, s8
; GFX10PLUS-NEXT:    s_ashr_i32 s4, s4, s9
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <5 x i32> %value, %amount
  ret <5 x i32> %result
}

define <16 x i32> @v_ashr_v16i32(<16 x i32> %value, <16 x i32> %amount) {
; GCN-LABEL: v_ashr_v16i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, v16, v0
; GCN-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GCN-NEXT:    v_ashrrev_i32_e32 v1, v17, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v2, v18, v2
; GCN-NEXT:    v_ashrrev_i32_e32 v3, v19, v3
; GCN-NEXT:    v_ashrrev_i32_e32 v4, v20, v4
; GCN-NEXT:    v_ashrrev_i32_e32 v5, v21, v5
; GCN-NEXT:    v_ashrrev_i32_e32 v6, v22, v6
; GCN-NEXT:    v_ashrrev_i32_e32 v7, v23, v7
; GCN-NEXT:    v_ashrrev_i32_e32 v8, v24, v8
; GCN-NEXT:    v_ashrrev_i32_e32 v9, v25, v9
; GCN-NEXT:    v_ashrrev_i32_e32 v10, v26, v10
; GCN-NEXT:    v_ashrrev_i32_e32 v11, v27, v11
; GCN-NEXT:    v_ashrrev_i32_e32 v12, v28, v12
; GCN-NEXT:    v_ashrrev_i32_e32 v13, v29, v13
; GCN-NEXT:    v_ashrrev_i32_e32 v14, v30, v14
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v15, v16, v15
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_ashr_v16i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-NEXT:    v_ashrrev_i32_e32 v0, v16, v0
; GFX10-NEXT:    v_ashrrev_i32_e32 v1, v17, v1
; GFX10-NEXT:    v_ashrrev_i32_e32 v2, v18, v2
; GFX10-NEXT:    v_ashrrev_i32_e32 v3, v19, v3
; GFX10-NEXT:    v_ashrrev_i32_e32 v4, v20, v4
; GFX10-NEXT:    v_ashrrev_i32_e32 v5, v21, v5
; GFX10-NEXT:    v_ashrrev_i32_e32 v6, v22, v6
; GFX10-NEXT:    v_ashrrev_i32_e32 v7, v23, v7
; GFX10-NEXT:    v_ashrrev_i32_e32 v8, v24, v8
; GFX10-NEXT:    v_ashrrev_i32_e32 v9, v25, v9
; GFX10-NEXT:    v_ashrrev_i32_e32 v10, v26, v10
; GFX10-NEXT:    v_ashrrev_i32_e32 v11, v27, v11
; GFX10-NEXT:    v_ashrrev_i32_e32 v12, v28, v12
; GFX10-NEXT:    v_ashrrev_i32_e32 v13, v29, v13
; GFX10-NEXT:    v_ashrrev_i32_e32 v14, v30, v14
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_ashrrev_i32_e32 v15, v31, v15
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_ashr_v16i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    v_ashrrev_i32_e32 v0, v16, v0
; GFX11-NEXT:    v_ashrrev_i32_e32 v1, v17, v1
; GFX11-NEXT:    v_ashrrev_i32_e32 v2, v18, v2
; GFX11-NEXT:    v_ashrrev_i32_e32 v3, v19, v3
; GFX11-NEXT:    v_ashrrev_i32_e32 v4, v20, v4
; GFX11-NEXT:    v_ashrrev_i32_e32 v5, v21, v5
; GFX11-NEXT:    v_ashrrev_i32_e32 v6, v22, v6
; GFX11-NEXT:    v_ashrrev_i32_e32 v7, v23, v7
; GFX11-NEXT:    v_ashrrev_i32_e32 v8, v24, v8
; GFX11-NEXT:    v_ashrrev_i32_e32 v9, v25, v9
; GFX11-NEXT:    v_ashrrev_i32_e32 v10, v26, v10
; GFX11-NEXT:    v_ashrrev_i32_e32 v11, v27, v11
; GFX11-NEXT:    v_ashrrev_i32_e32 v12, v28, v12
; GFX11-NEXT:    v_ashrrev_i32_e32 v13, v29, v13
; GFX11-NEXT:    v_ashrrev_i32_e32 v14, v30, v14
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_ashrrev_i32_e32 v15, v31, v15
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <16 x i32> %value, %amount
  ret <16 x i32> %result
}

define amdgpu_ps <16 x i32> @s_ashr_v16i32(<16 x i32> inreg %value, <16 x i32> inreg %amount) {
; GCN-LABEL: s_ashr_v16i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s0, s16
; GCN-NEXT:    s_ashr_i32 s1, s1, s17
; GCN-NEXT:    s_ashr_i32 s2, s2, s18
; GCN-NEXT:    s_ashr_i32 s3, s3, s19
; GCN-NEXT:    s_ashr_i32 s4, s4, s20
; GCN-NEXT:    s_ashr_i32 s5, s5, s21
; GCN-NEXT:    s_ashr_i32 s6, s6, s22
; GCN-NEXT:    s_ashr_i32 s7, s7, s23
; GCN-NEXT:    s_ashr_i32 s8, s8, s24
; GCN-NEXT:    s_ashr_i32 s9, s9, s25
; GCN-NEXT:    s_ashr_i32 s10, s10, s26
; GCN-NEXT:    s_ashr_i32 s11, s11, s27
; GCN-NEXT:    s_ashr_i32 s12, s12, s28
; GCN-NEXT:    s_ashr_i32 s13, s13, s29
; GCN-NEXT:    s_ashr_i32 s14, s14, s30
; GCN-NEXT:    s_ashr_i32 s15, s15, s31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v16i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s16
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s17
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s18
; GFX10PLUS-NEXT:    s_ashr_i32 s3, s3, s19
; GFX10PLUS-NEXT:    s_ashr_i32 s4, s4, s20
; GFX10PLUS-NEXT:    s_ashr_i32 s5, s5, s21
; GFX10PLUS-NEXT:    s_ashr_i32 s6, s6, s22
; GFX10PLUS-NEXT:    s_ashr_i32 s7, s7, s23
; GFX10PLUS-NEXT:    s_ashr_i32 s8, s8, s24
; GFX10PLUS-NEXT:    s_ashr_i32 s9, s9, s25
; GFX10PLUS-NEXT:    s_ashr_i32 s10, s10, s26
; GFX10PLUS-NEXT:    s_ashr_i32 s11, s11, s27
; GFX10PLUS-NEXT:    s_ashr_i32 s12, s12, s28
; GFX10PLUS-NEXT:    s_ashr_i32 s13, s13, s29
; GFX10PLUS-NEXT:    s_ashr_i32 s14, s14, s30
; GFX10PLUS-NEXT:    s_ashr_i32 s15, s15, s31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <16 x i32> %value, %amount
  ret <16 x i32> %result
}

define i16 @v_ashr_i16(i16 %value, i16 %amount) {
; GFX6-LABEL: v_ashr_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i16_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i16 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i16 %value, %amount
  ret i16 %result
}

define i16 @v_ashr_i16_31(i16 %value) {
; GCN-LABEL: v_ashr_i16_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i16_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i16 %value, 31
  ret i16 %result
}

define amdgpu_ps i16 @s_ashr_i16(i16 inreg %value, i16 inreg %amount) {
; GFX6-LABEL: s_ashr_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_sext_i32_i16 s0, s0
; GFX6-NEXT:    s_ashr_i32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_ashr_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s0, s0
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_ashr_i32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_ashr_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_sext_i32_i16 s0, s0
; GFX9-NEXT:    s_sext_i32_i16 s1, s1
; GFX9-NEXT:    s_ashr_i32 s0, s0, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i16 s0, s0
; GFX10PLUS-NEXT:    s_sext_i32_i16 s1, s1
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i16 %value, %amount
  ret i16 %result
}

define amdgpu_ps i16 @s_ashr_i16_15(i16 inreg %value) {
; GCN-LABEL: s_ashr_i16_15:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_sext_i32_i16 s0, s0
; GCN-NEXT:    s_ashr_i32 s0, s0, 15
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i16_15:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i16 s0, s0
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 15
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i16 %value, 15
  ret i16 %result
}

define amdgpu_ps half @ashr_i16_sv(i16 inreg %value, i16 %amount) {
; GFX6-LABEL: ashr_i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    s_sext_i32_i16 s0, s0
; GFX6-NEXT:    v_ashr_i32_e32 v0, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_ashrrev_i16_e64 v0, v0, s0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_ashrrev_i16_e64 v0, v0, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_i16_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_ashrrev_i16 v0, v0, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i16 %value, %amount
  %cast = bitcast i16 %result to half
  ret half %cast
}

define amdgpu_ps half @ashr_i16_vs(i16 %value, i16 inreg %amount) {
; GFX6-LABEL: ashr_i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_ashrrev_i16_e32 v0, s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_i16_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_ashrrev_i16 v0, s0, v0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i16 %value, %amount
  %cast = bitcast i16 %result to half
  ret half %cast
}

define <2 x i16> @v_ashr_v2i16(<2 x i16> %value, <2 x i16> %amount) {
; GFX6-LABEL: v_ashr_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, v2, v0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX6-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, v2, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i16_e32 v2, v1, v0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v2i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v0, v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <2 x i16> %value, %amount
  ret <2 x i16> %result
}

define <2 x i16> @v_ashr_v2i16_15(<2 x i16> %value) {
; GFX6-LABEL: v_ashr_v2i16_15:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 15, v0
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 15, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_v2i16_15:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 15
; GFX8-NEXT:    v_ashrrev_i16_e32 v1, 15, v0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_v2i16_15:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 15, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v2i16_15:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v0, 15, v0 op_sel_hi:[0,1]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <2 x i16> %value, <i16 15, i16 15>
  ret <2 x i16> %result
}

define amdgpu_ps i32 @s_ashr_v2i16(<2 x i16> inreg %value, <2 x i16> inreg %amount) {
; GFX6-LABEL: s_ashr_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_sext_i32_i16 s1, s1
; GFX6-NEXT:    s_sext_i32_i16 s0, s0
; GFX6-NEXT:    s_ashr_i32 s1, s1, s3
; GFX6-NEXT:    s_ashr_i32 s0, s0, s2
; GFX6-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_ashr_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s2, s0
; GFX8-NEXT:    s_bfe_i32 s0, s0, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s3, s1
; GFX8-NEXT:    s_bfe_i32 s1, s1, 0x100010
; GFX8-NEXT:    s_ashr_i32 s2, s2, s3
; GFX8-NEXT:    s_ashr_i32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_and_b32 s1, s2, 0xffff
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_ashr_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_sext_i32_i16 s2, s0
; GFX9-NEXT:    s_ashr_i32 s0, s0, 16
; GFX9-NEXT:    s_sext_i32_i16 s3, s1
; GFX9-NEXT:    s_ashr_i32 s1, s1, 16
; GFX9-NEXT:    s_ashr_i32 s2, s2, s3
; GFX9-NEXT:    s_ashr_i32 s0, s0, s1
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s2, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v2i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i16 s2, s0
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 16
; GFX10PLUS-NEXT:    s_sext_i32_i16 s3, s1
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s3
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s1
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s0, s2, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <2 x i16> %value, %amount
  %cast = bitcast <2 x i16> %result to i32
  ret i32 %cast
}

define amdgpu_ps float @ashr_v2i16_sv(<2 x i16> inreg %value, <2 x i16> %amount) {
; GFX6-LABEL: ashr_v2i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    s_sext_i32_i16 s0, s0
; GFX6-NEXT:    v_ashr_i32_e32 v0, s0, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    s_sext_i32_i16 s0, s1
; GFX6-NEXT:    v_ashr_i32_e32 v1, s0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_v2i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_ashrrev_i16_e64 v1, v0, s0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_v2i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, v0, s0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_v2i16_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v0, v0, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <2 x i16> %value, %amount
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

define amdgpu_ps float @ashr_v2i16_vs(<2 x i16> %value, <2 x i16> inreg %amount) {
; GFX6-LABEL: ashr_v2i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, s0, v0
; GFX6-NEXT:    s_and_b32 s0, s1, 0xffff
; GFX6-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, s0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_v2i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_ashrrev_i16_e32 v1, s0, v0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_v2i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_v2i16_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v0, s0, v0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <2 x i16> %value, %amount
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

; FIXME
; define <3 x i16> @v_ashr_v3i16(<3 x i16> %value, <3 x i16> %amount) {
;   %result = ashr <3 x i16> %value, %amount
;   ret <3 x i16> %result
; }

; define amdgpu_ps <3 x i16> @s_ashr_v3i16(<3 x i16> inreg %value, <3 x i16> inreg %amount) {
;   %result = ashr <3 x i16> %value, %amount
;   ret <3 x i16> %result
; }

define <2 x float> @v_ashr_v4i16(<4 x i16> %value, <4 x i16> %amount) {
; GFX6-LABEL: v_ashr_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, v4, v0
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v5
; GFX6-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, v4, v1
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, v4, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX6-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, v4, v3
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i16_e32 v4, v2, v0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_ashrrev_i16_e32 v2, v3, v1
; GFX8-NEXT:    v_ashrrev_i16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX8-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, v2, v0
; GFX9-NEXT:    v_pk_ashrrev_i16 v1, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v4i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v0, v2, v0
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v1, v3, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <4 x i16> %value, %amount
  %cast = bitcast <4 x i16> %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x i32> @s_ashr_v4i16(<4 x i16> inreg %value, <4 x i16> inreg %amount) {
; GFX6-LABEL: s_ashr_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_sext_i32_i16 s1, s1
; GFX6-NEXT:    s_sext_i32_i16 s0, s0
; GFX6-NEXT:    s_ashr_i32 s1, s1, s5
; GFX6-NEXT:    s_ashr_i32 s0, s0, s4
; GFX6-NEXT:    s_sext_i32_i16 s2, s2
; GFX6-NEXT:    s_sext_i32_i16 s3, s3
; GFX6-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX6-NEXT:    s_ashr_i32 s2, s2, s6
; GFX6-NEXT:    s_ashr_i32 s3, s3, s7
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, 0xffff
; GFX6-NEXT:    s_and_b32 s2, s3, 0xffff
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_ashr_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s4, s0
; GFX8-NEXT:    s_bfe_i32 s0, s0, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s5, s1
; GFX8-NEXT:    s_bfe_i32 s1, s1, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s6, s2
; GFX8-NEXT:    s_bfe_i32 s2, s2, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s7, s3
; GFX8-NEXT:    s_bfe_i32 s3, s3, 0x100010
; GFX8-NEXT:    s_ashr_i32 s4, s4, s6
; GFX8-NEXT:    s_ashr_i32 s0, s0, s2
; GFX8-NEXT:    s_ashr_i32 s2, s5, s7
; GFX8-NEXT:    s_ashr_i32 s1, s1, s3
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_and_b32 s3, s4, 0xffff
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX8-NEXT:    s_or_b32 s0, s0, s3
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_ashr_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_sext_i32_i16 s4, s0
; GFX9-NEXT:    s_ashr_i32 s0, s0, 16
; GFX9-NEXT:    s_sext_i32_i16 s5, s2
; GFX9-NEXT:    s_ashr_i32 s2, s2, 16
; GFX9-NEXT:    s_ashr_i32 s4, s4, s5
; GFX9-NEXT:    s_ashr_i32 s0, s0, s2
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s4, s0
; GFX9-NEXT:    s_sext_i32_i16 s2, s1
; GFX9-NEXT:    s_ashr_i32 s1, s1, 16
; GFX9-NEXT:    s_sext_i32_i16 s4, s3
; GFX9-NEXT:    s_ashr_i32 s3, s3, 16
; GFX9-NEXT:    s_ashr_i32 s2, s2, s4
; GFX9-NEXT:    s_ashr_i32 s1, s1, s3
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s2, s1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v4i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i16 s4, s0
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 16
; GFX10PLUS-NEXT:    s_sext_i32_i16 s5, s2
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s4, s4, s5
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s2
; GFX10PLUS-NEXT:    s_sext_i32_i16 s2, s1
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, 16
; GFX10PLUS-NEXT:    s_sext_i32_i16 s5, s3
; GFX10PLUS-NEXT:    s_ashr_i32 s3, s3, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s5
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s3
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s0, s4, s0
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s1, s2, s1
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <4 x i16> %value, %amount
  %cast = bitcast <4 x i16> %result to <2 x i32>
  ret <2 x i32> %cast
}

; FIXME
; define <5 x i16> @v_ashr_v5i16(<5 x i16> %value, <5 x i16> %amount) {
;   %result = ashr <5 x i16> %value, %amount
;   ret <5 x i16> %result
; }

; define amdgpu_ps <5 x i16> @s_ashr_v5i16(<5 x i16> inreg %value, <5 x i16> inreg %amount) {
;   %result = ashr <5 x i16> %value, %amount
;   ret <5 x i16> %result
; }

; define <3 x float> @v_ashr_v6i16(<6 x i16> %value, <6 x i16> %amount) {
;   %result = ashr <6 x i16> %value, %amount
;   %cast = bitcast <6 x i16> %result to <3 x float>
;   ret <3 x float> %cast
; }

; define amdgpu_ps <3 x i32> @s_ashr_v6i16(<6 x i16> inreg %value, <6 x i16> inreg %amount) {
;   %result = ashr <6 x i16> %value, %amount
;   %cast = bitcast <6 x i16> %result to <3 x i32>
;   ret <3 x i32> %cast
; }

define <4 x float> @v_ashr_v8i16(<8 x i16> %value, <8 x i16> %amount) {
; GFX6-LABEL: v_ashr_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX6-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, v8, v0
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v9
; GFX6-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, v8, v1
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v10
; GFX6-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, v8, v2
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v11
; GFX6-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, v8, v3
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v12
; GFX6-NEXT:    v_bfe_i32 v4, v4, 0, 16
; GFX6-NEXT:    v_ashrrev_i32_e32 v4, v8, v4
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v13
; GFX6-NEXT:    v_bfe_i32 v5, v5, 0, 16
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, v8, v5
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v14
; GFX6-NEXT:    v_bfe_i32 v6, v6, 0, 16
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v6, v8, v6
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff, v15
; GFX6-NEXT:    v_bfe_i32 v7, v7, 0, 16
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX6-NEXT:    v_ashrrev_i32_e32 v7, v8, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff, v5
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff, v7
; GFX6-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i16_e32 v8, v4, v0
; GFX8-NEXT:    v_ashrrev_i16_sdwa v0, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_ashrrev_i16_e32 v4, v5, v1
; GFX8-NEXT:    v_ashrrev_i16_sdwa v1, v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v1, v4, v1
; GFX8-NEXT:    v_ashrrev_i16_e32 v4, v6, v2
; GFX8-NEXT:    v_ashrrev_i16_sdwa v2, v6, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX8-NEXT:    v_ashrrev_i16_e32 v4, v7, v3
; GFX8-NEXT:    v_ashrrev_i16_sdwa v3, v7, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX8-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, v4, v0
; GFX9-NEXT:    v_pk_ashrrev_i16 v1, v5, v1
; GFX9-NEXT:    v_pk_ashrrev_i16 v2, v6, v2
; GFX9-NEXT:    v_pk_ashrrev_i16 v3, v7, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v8i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v0, v4, v0
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v1, v5, v1
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v2, v6, v2
; GFX10PLUS-NEXT:    v_pk_ashrrev_i16 v3, v7, v3
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <8 x i16> %value, %amount
  %cast = bitcast <8 x i16> %result to <4 x float>
  ret <4 x float> %cast
}

define amdgpu_ps <4 x i32> @s_ashr_v8i16(<8 x i16> inreg %value, <8 x i16> inreg %amount) {
; GFX6-LABEL: s_ashr_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_sext_i32_i16 s1, s1
; GFX6-NEXT:    s_sext_i32_i16 s0, s0
; GFX6-NEXT:    s_ashr_i32 s1, s1, s9
; GFX6-NEXT:    s_ashr_i32 s0, s0, s8
; GFX6-NEXT:    s_sext_i32_i16 s2, s2
; GFX6-NEXT:    s_sext_i32_i16 s3, s3
; GFX6-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX6-NEXT:    s_ashr_i32 s2, s2, s10
; GFX6-NEXT:    s_ashr_i32 s3, s3, s11
; GFX6-NEXT:    s_sext_i32_i16 s5, s5
; GFX6-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_sext_i32_i16 s4, s4
; GFX6-NEXT:    s_ashr_i32 s5, s5, s13
; GFX6-NEXT:    s_sext_i32_i16 s7, s7
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, 0xffff
; GFX6-NEXT:    s_and_b32 s2, s3, 0xffff
; GFX6-NEXT:    s_ashr_i32 s4, s4, s12
; GFX6-NEXT:    s_sext_i32_i16 s6, s6
; GFX6-NEXT:    s_ashr_i32 s7, s7, s15
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_and_b32 s3, s5, 0xffff
; GFX6-NEXT:    s_ashr_i32 s6, s6, s14
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    s_and_b32 s2, s4, 0xffff
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_and_b32 s4, s7, 0xffff
; GFX6-NEXT:    s_or_b32 s2, s2, s3
; GFX6-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_or_b32 s3, s3, s4
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_ashr_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s8, s0
; GFX8-NEXT:    s_bfe_i32 s0, s0, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s9, s1
; GFX8-NEXT:    s_bfe_i32 s1, s1, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s12, s4
; GFX8-NEXT:    s_bfe_i32 s4, s4, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s13, s5
; GFX8-NEXT:    s_bfe_i32 s5, s5, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s10, s2
; GFX8-NEXT:    s_bfe_i32 s2, s2, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s14, s6
; GFX8-NEXT:    s_bfe_i32 s6, s6, 0x100010
; GFX8-NEXT:    s_ashr_i32 s0, s0, s4
; GFX8-NEXT:    s_ashr_i32 s4, s9, s13
; GFX8-NEXT:    s_ashr_i32 s1, s1, s5
; GFX8-NEXT:    s_sext_i32_i16 s11, s3
; GFX8-NEXT:    s_bfe_i32 s3, s3, 0x100010
; GFX8-NEXT:    s_sext_i32_i16 s15, s7
; GFX8-NEXT:    s_bfe_i32 s7, s7, 0x100010
; GFX8-NEXT:    s_ashr_i32 s5, s10, s14
; GFX8-NEXT:    s_ashr_i32 s2, s2, s6
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX8-NEXT:    s_ashr_i32 s8, s8, s12
; GFX8-NEXT:    s_ashr_i32 s6, s11, s15
; GFX8-NEXT:    s_ashr_i32 s3, s3, s7
; GFX8-NEXT:    s_or_b32 s1, s1, s4
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_and_b32 s4, s5, 0xffff
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_and_b32 s7, s8, 0xffff
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_and_b32 s4, s6, 0xffff
; GFX8-NEXT:    s_or_b32 s0, s0, s7
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_ashr_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_sext_i32_i16 s8, s0
; GFX9-NEXT:    s_ashr_i32 s0, s0, 16
; GFX9-NEXT:    s_sext_i32_i16 s9, s4
; GFX9-NEXT:    s_ashr_i32 s4, s4, 16
; GFX9-NEXT:    s_ashr_i32 s8, s8, s9
; GFX9-NEXT:    s_ashr_i32 s0, s0, s4
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s8, s0
; GFX9-NEXT:    s_sext_i32_i16 s4, s1
; GFX9-NEXT:    s_ashr_i32 s1, s1, 16
; GFX9-NEXT:    s_sext_i32_i16 s8, s5
; GFX9-NEXT:    s_ashr_i32 s5, s5, 16
; GFX9-NEXT:    s_ashr_i32 s4, s4, s8
; GFX9-NEXT:    s_ashr_i32 s1, s1, s5
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s4, s1
; GFX9-NEXT:    s_sext_i32_i16 s4, s2
; GFX9-NEXT:    s_ashr_i32 s2, s2, 16
; GFX9-NEXT:    s_sext_i32_i16 s5, s6
; GFX9-NEXT:    s_ashr_i32 s6, s6, 16
; GFX9-NEXT:    s_ashr_i32 s4, s4, s5
; GFX9-NEXT:    s_ashr_i32 s2, s2, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s4, s2
; GFX9-NEXT:    s_sext_i32_i16 s4, s3
; GFX9-NEXT:    s_ashr_i32 s3, s3, 16
; GFX9-NEXT:    s_sext_i32_i16 s5, s7
; GFX9-NEXT:    s_ashr_i32 s6, s7, 16
; GFX9-NEXT:    s_ashr_i32 s4, s4, s5
; GFX9-NEXT:    s_ashr_i32 s3, s3, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s4, s3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v8i16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_sext_i32_i16 s8, s0
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, 16
; GFX10PLUS-NEXT:    s_sext_i32_i16 s9, s4
; GFX10PLUS-NEXT:    s_ashr_i32 s4, s4, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s8, s8, s9
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s0, s4
; GFX10PLUS-NEXT:    s_sext_i32_i16 s4, s1
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, 16
; GFX10PLUS-NEXT:    s_sext_i32_i16 s9, s5
; GFX10PLUS-NEXT:    s_ashr_i32 s5, s5, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s4, s4, s9
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, s5
; GFX10PLUS-NEXT:    s_sext_i32_i16 s5, s6
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s1, s4, s1
; GFX10PLUS-NEXT:    s_sext_i32_i16 s4, s2
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s6, s6, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s4, s4, s5
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s2, s6
; GFX10PLUS-NEXT:    s_sext_i32_i16 s5, s3
; GFX10PLUS-NEXT:    s_ashr_i32 s3, s3, 16
; GFX10PLUS-NEXT:    s_sext_i32_i16 s6, s7
; GFX10PLUS-NEXT:    s_ashr_i32 s7, s7, 16
; GFX10PLUS-NEXT:    s_ashr_i32 s5, s5, s6
; GFX10PLUS-NEXT:    s_ashr_i32 s3, s3, s7
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s0, s8, s0
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s2, s4, s2
; GFX10PLUS-NEXT:    s_pack_ll_b32_b16 s3, s5, s3
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <8 x i16> %value, %amount
  %cast = bitcast <8 x i16> %result to <4 x i32>
  ret <4 x i32> %cast
}

define i64 @v_ashr_i64(i64 %value, i64 %amount) {
; GFX6-LABEL: v_ashr_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[0:1], v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], v2, v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], v2, v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[0:1], v2, v[0:1]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i64 %value, %amount
  ret i64 %result
}

define i64 @v_ashr_i64_63(i64 %value) {
; GCN-LABEL: v_ashr_i64_63:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 31, v1
; GCN-NEXT:    v_mov_b32_e32 v1, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i64_63:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, 31, v1
; GFX10PLUS-NEXT:    v_mov_b32_e32 v1, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i64 %value, 63
  ret i64 %result
}

define i64 @v_ashr_i64_33(i64 %value) {
; GCN-LABEL: v_ashr_i64_33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v0, 1, v1
; GCN-NEXT:    v_mov_b32_e32 v1, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i64_33:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v0, 1, v1
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, 31, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i64 %value, 33
  ret i64 %result
}

define i64 @v_ashr_i64_32(i64 %value) {
; GCN-LABEL: v_ashr_i64_32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, v1
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i64_32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v0, v1
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i64 %value, 32
  ret i64 %result
}

define i64 @v_ashr_i64_31(i64 %value) {
; GFX6-LABEL: v_ashr_i64_31:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[0:1], 31
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i64_31:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], 31, v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i64_31:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], 31, v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i64_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[0:1], 31, v[0:1]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i64 %value, 31
  ret i64 %result
}

define amdgpu_ps i64 @s_ashr_i64(i64 inreg %value, i64 inreg %amount) {
; GCN-LABEL: s_ashr_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i64 s[0:1], s[0:1], s2
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i64 s[0:1], s[0:1], s2
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, %amount
  ret i64 %result
}

define amdgpu_ps i64 @s_ashr_i64_63(i64 inreg %value) {
; GCN-LABEL: s_ashr_i64_63:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s0, s1, 31
; GCN-NEXT:    s_mov_b32 s1, s0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i64_63:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s1, 31
; GFX10PLUS-NEXT:    s_mov_b32 s1, s0
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, 63
  ret i64 %result
}

define amdgpu_ps i64 @s_ashr_i64_33(i64 inreg %value) {
; GCN-LABEL: s_ashr_i64_33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i32 s2, s1, 31
; GCN-NEXT:    s_ashr_i32 s0, s1, 1
; GCN-NEXT:    s_mov_b32 s1, s2
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i64_33:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i32 s0, s1, 1
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, 31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, 33
  ret i64 %result
}

define amdgpu_ps i64 @s_ashr_i64_32(i64 inreg %value) {
; GCN-LABEL: s_ashr_i64_32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s0, s1
; GCN-NEXT:    s_ashr_i32 s1, s1, 31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i64_32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_mov_b32 s0, s1
; GFX10PLUS-NEXT:    s_ashr_i32 s1, s1, 31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, 32
  ret i64 %result
}

define amdgpu_ps i64 @s_ashr_i64_31(i64 inreg %value) {
; GCN-LABEL: s_ashr_i64_31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i64 s[0:1], s[0:1], 31
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i64_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i64 s[0:1], s[0:1], 31
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, 31
  ret i64 %result
}

define amdgpu_ps <2 x float> @ashr_i64_sv(i64 inreg %value, i64 %amount) {
; GFX6-LABEL: ashr_i64_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_ashr_i64 v[0:1], s[0:1], v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_i64_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], v0, s[0:1]
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_i64_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], v0, s[0:1]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_i64_sv:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[0:1], v0, s[0:1]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, %amount
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x float> @ashr_i64_vs(i64 %value, i64 inreg %amount) {
; GFX6-LABEL: ashr_i64_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[0:1], s0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: ashr_i64_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], s0, v[0:1]
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ashr_i64_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], s0, v[0:1]
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: ashr_i64_vs:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[0:1], s0, v[0:1]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i64 %value, %amount
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define <2 x i64> @v_ashr_v2i64(<2 x i64> %value, <2 x i64> %amount) {
; GFX6-LABEL: v_ashr_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[0:1], v4
; GFX6-NEXT:    v_ashr_i64 v[2:3], v[2:3], v6
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], v4, v[0:1]
; GFX8-NEXT:    v_ashrrev_i64 v[2:3], v6, v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], v4, v[0:1]
; GFX9-NEXT:    v_ashrrev_i64 v[2:3], v6, v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v2i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[0:1], v4, v[0:1]
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[2:3], v6, v[2:3]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <2 x i64> %value, %amount
  ret <2 x i64> %result
}

define <2 x i64> @v_ashr_v2i64_31(<2 x i64> %value) {
; GFX6-LABEL: v_ashr_v2i64_31:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[0:1], 31
; GFX6-NEXT:    v_ashr_i64 v[2:3], v[2:3], 31
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_v2i64_31:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], 31, v[0:1]
; GFX8-NEXT:    v_ashrrev_i64 v[2:3], 31, v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_v2i64_31:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], 31, v[0:1]
; GFX9-NEXT:    v_ashrrev_i64 v[2:3], 31, v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_v2i64_31:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[0:1], 31, v[0:1]
; GFX10PLUS-NEXT:    v_ashrrev_i64 v[2:3], 31, v[2:3]
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr <2 x i64> %value, <i64 31, i64 31>
  ret <2 x i64> %result
}

define amdgpu_ps <2 x i64> @s_ashr_v2i64(<2 x i64> inreg %value, <2 x i64> inreg %amount) {
; GCN-LABEL: s_ashr_v2i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_ashr_i64 s[0:1], s[0:1], s4
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], s6
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_v2i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_ashr_i64 s[0:1], s[0:1], s4
; GFX10PLUS-NEXT:    s_ashr_i64 s[2:3], s[2:3], s6
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr <2 x i64> %value, %amount
  ret <2 x i64> %result
}

define i65 @v_ashr_i65(i65 %value, i65 %amount) {
; GFX6-LABEL: v_ashr_i65:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_bfe_i32 v4, v2, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, 64, v3
; GFX6-NEXT:    v_lshr_b64 v[6:7], v[0:1], v3
; GFX6-NEXT:    v_lshl_b64 v[8:9], v[4:5], v8
; GFX6-NEXT:    v_subrev_i32_e32 v2, vcc, 64, v3
; GFX6-NEXT:    v_ashr_i64 v[10:11], v[4:5], v3
; GFX6-NEXT:    v_or_b32_e32 v6, v6, v8
; GFX6-NEXT:    v_ashrrev_i32_e32 v8, 31, v5
; GFX6-NEXT:    v_ashr_i64 v[4:5], v[4:5], v2
; GFX6-NEXT:    v_or_b32_e32 v7, v7, v9
; GFX6-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v5, v7, vcc
; GFX6-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v3
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v2, v0, s[4:5]
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v8, v10, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i65:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v4, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX8-NEXT:    v_sub_u32_e32 v8, vcc, 64, v3
; GFX8-NEXT:    v_lshrrev_b64 v[6:7], v3, v[0:1]
; GFX8-NEXT:    v_lshlrev_b64 v[8:9], v8, v[4:5]
; GFX8-NEXT:    v_subrev_u32_e32 v2, vcc, 64, v3
; GFX8-NEXT:    v_ashrrev_i64 v[10:11], v3, v[4:5]
; GFX8-NEXT:    v_or_b32_e32 v6, v6, v8
; GFX8-NEXT:    v_ashrrev_i32_e32 v8, 31, v5
; GFX8-NEXT:    v_ashrrev_i64 v[4:5], v2, v[4:5]
; GFX8-NEXT:    v_or_b32_e32 v7, v7, v9
; GFX8-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v3
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, v0, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v10, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i65:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_bfe_i32 v4, v2, 0, 1
; GFX9-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX9-NEXT:    v_sub_u32_e32 v8, 64, v3
; GFX9-NEXT:    v_lshrrev_b64 v[6:7], v3, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], v8, v[4:5]
; GFX9-NEXT:    v_subrev_u32_e32 v2, 64, v3
; GFX9-NEXT:    v_ashrrev_i64 v[10:11], v3, v[4:5]
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v8
; GFX9-NEXT:    v_ashrrev_i32_e32 v8, 31, v5
; GFX9-NEXT:    v_ashrrev_i64 v[4:5], v2, v[4:5]
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v9
; GFX9-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v7, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v3
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, v0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v8, v10, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_ashr_i65:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_bfe_i32 v4, v2, 0, 1
; GFX10-NEXT:    v_sub_nc_u32_e32 v2, 64, v3
; GFX10-NEXT:    v_subrev_nc_u32_e32 v10, 64, v3
; GFX10-NEXT:    v_lshrrev_b64 v[6:7], v3, v[0:1]
; GFX10-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 64, v3
; GFX10-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX10-NEXT:    v_cmp_eq_u32_e64 s4, 0, v3
; GFX10-NEXT:    v_lshlrev_b64 v[8:9], v2, v[4:5]
; GFX10-NEXT:    v_ashrrev_i64 v[10:11], v10, v[4:5]
; GFX10-NEXT:    v_or_b32_e32 v2, v6, v8
; GFX10-NEXT:    v_or_b32_e32 v8, v7, v9
; GFX10-NEXT:    v_ashrrev_i64 v[6:7], v3, v[4:5]
; GFX10-NEXT:    v_ashrrev_i32_e32 v3, 31, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v11, v8, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, v0, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s4
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v3, v6, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_ashr_i65:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_bfe_i32 v4, v2, 0, 1
; GFX11-NEXT:    v_sub_nc_u32_e32 v2, 64, v3
; GFX11-NEXT:    v_subrev_nc_u32_e32 v10, 64, v3
; GFX11-NEXT:    v_lshrrev_b64 v[6:7], v3, v[0:1]
; GFX11-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 64, v3
; GFX11-NEXT:    v_ashrrev_i32_e32 v5, 31, v4
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 0, v3
; GFX11-NEXT:    v_lshlrev_b64 v[8:9], v2, v[4:5]
; GFX11-NEXT:    v_ashrrev_i64 v[10:11], v10, v[4:5]
; GFX11-NEXT:    v_or_b32_e32 v2, v6, v8
; GFX11-NEXT:    v_or_b32_e32 v8, v7, v9
; GFX11-NEXT:    v_ashrrev_i64 v[6:7], v3, v[4:5]
; GFX11-NEXT:    v_ashrrev_i32_e32 v3, 31, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v10, v2, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v11, v8, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, v0, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s0
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v6, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i65 %value, %amount
  ret i65 %result
}

define i65 @v_ashr_i65_33(i65 %value) {
; GFX6-LABEL: v_ashr_i65_33:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v3, v1
; GFX6-NEXT:    v_bfe_i32 v1, v2, 0, 1
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX6-NEXT:    v_lshl_b64 v[0:1], v[1:2], 31
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 1, v3
; GFX6-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_ashr_i65_33:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_bfe_i32 v1, v2, 0, 1
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX8-NEXT:    v_lshlrev_b64 v[0:1], 31, v[1:2]
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_ashr_i65_33:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_bfe_i32 v1, v2, 0, 1
; GFX9-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 31, v[1:2]
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 1, v3
; GFX9-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX9-NEXT:    v_ashrrev_i32_e32 v2, 1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ashr_i65_33:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10PLUS-NEXT:    v_mov_b32_e32 v3, v1
; GFX10PLUS-NEXT:    v_bfe_i32 v1, v2, 0, 1
; GFX10PLUS-NEXT:    v_lshrrev_b32_e32 v3, 1, v3
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GFX10PLUS-NEXT:    v_lshlrev_b64 v[0:1], 31, v[1:2]
; GFX10PLUS-NEXT:    v_ashrrev_i32_e32 v2, 1, v2
; GFX10PLUS-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %result = ashr i65 %value, 33
  ret i65 %result
}

define amdgpu_ps i65 @s_ashr_i65(i65 inreg %value, i65 inreg %amount) {
; GCN-LABEL: s_ashr_i65:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_bfe_i64 s[4:5], s[2:3], 0x10000
; GCN-NEXT:    s_sub_i32 s10, s3, 64
; GCN-NEXT:    s_sub_i32 s8, 64, s3
; GCN-NEXT:    s_cmp_lt_u32 s3, 64
; GCN-NEXT:    s_cselect_b32 s11, 1, 0
; GCN-NEXT:    s_cmp_eq_u32 s3, 0
; GCN-NEXT:    s_cselect_b32 s12, 1, 0
; GCN-NEXT:    s_ashr_i64 s[6:7], s[4:5], s3
; GCN-NEXT:    s_lshr_b64 s[2:3], s[0:1], s3
; GCN-NEXT:    s_lshl_b64 s[8:9], s[4:5], s8
; GCN-NEXT:    s_or_b64 s[2:3], s[2:3], s[8:9]
; GCN-NEXT:    s_ashr_i32 s8, s5, 31
; GCN-NEXT:    s_ashr_i64 s[4:5], s[4:5], s10
; GCN-NEXT:    s_cmp_lg_u32 s11, 0
; GCN-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GCN-NEXT:    s_cmp_lg_u32 s12, 0
; GCN-NEXT:    s_mov_b32 s9, s8
; GCN-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[2:3]
; GCN-NEXT:    s_cmp_lg_u32 s11, 0
; GCN-NEXT:    s_cselect_b64 s[2:3], s[6:7], s[8:9]
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i65:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_bfe_i64 s[4:5], s[2:3], 0x10000
; GFX10PLUS-NEXT:    s_sub_i32 s12, s3, 64
; GFX10PLUS-NEXT:    s_sub_i32 s8, 64, s3
; GFX10PLUS-NEXT:    s_cmp_lt_u32 s3, 64
; GFX10PLUS-NEXT:    s_cselect_b32 s13, 1, 0
; GFX10PLUS-NEXT:    s_cmp_eq_u32 s3, 0
; GFX10PLUS-NEXT:    s_cselect_b32 s14, 1, 0
; GFX10PLUS-NEXT:    s_ashr_i64 s[6:7], s[4:5], s3
; GFX10PLUS-NEXT:    s_lshr_b64 s[2:3], s[0:1], s3
; GFX10PLUS-NEXT:    s_lshl_b64 s[8:9], s[4:5], s8
; GFX10PLUS-NEXT:    s_ashr_i32 s10, s5, 31
; GFX10PLUS-NEXT:    s_or_b64 s[2:3], s[2:3], s[8:9]
; GFX10PLUS-NEXT:    s_ashr_i64 s[4:5], s[4:5], s12
; GFX10PLUS-NEXT:    s_cmp_lg_u32 s13, 0
; GFX10PLUS-NEXT:    s_mov_b32 s11, s10
; GFX10PLUS-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GFX10PLUS-NEXT:    s_cmp_lg_u32 s14, 0
; GFX10PLUS-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[2:3]
; GFX10PLUS-NEXT:    s_cmp_lg_u32 s13, 0
; GFX10PLUS-NEXT:    s_cselect_b64 s[2:3], s[6:7], s[10:11]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i65 %value, %amount
  ret i65 %result
}

define amdgpu_ps i65 @s_ashr_i65_33(i65 inreg %value) {
; GCN-LABEL: s_ashr_i65_33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_bfe_i64 s[2:3], s[2:3], 0x10000
; GCN-NEXT:    s_lshr_b32 s0, s1, 1
; GCN-NEXT:    s_mov_b32 s1, 0
; GCN-NEXT:    s_lshl_b64 s[4:5], s[2:3], 31
; GCN-NEXT:    s_or_b64 s[0:1], s[0:1], s[4:5]
; GCN-NEXT:    s_ashr_i32 s2, s3, 1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ashr_i65_33:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_bfe_i64 s[2:3], s[2:3], 0x10000
; GFX10PLUS-NEXT:    s_lshr_b32 s0, s1, 1
; GFX10PLUS-NEXT:    s_mov_b32 s1, 0
; GFX10PLUS-NEXT:    s_lshl_b64 s[4:5], s[2:3], 31
; GFX10PLUS-NEXT:    s_ashr_i32 s2, s3, 1
; GFX10PLUS-NEXT:    s_or_b64 s[0:1], s[0:1], s[4:5]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %result = ashr i65 %value, 33
  ret i65 %result
}

; FIXME: Argument lowering asserts
; define <2 x i65> @v_ashr_v2i65(<2 x i65> %value, <2 x i65> %amount) {
;   %result = ashr <2 x i65> %value, %amount
;   ret <2 x i65> %result
; }

; define amdgpu_ps <2 x i65> @s_ashr_v2i65(<2 x i65> inreg %value, <2 x i65> inreg %amount) {
;   %result = ashr <2 x i65> %value, %amount
;   ret <2 x i65> %result
; }
