# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=znver3 -iterations=100 -timeline -register-file-stats < %s | FileCheck %s

movq %mm0, %mm1
movq %mm1, %mm2
movq %mm2, %mm3
movq %mm3, %mm4
movq %mm4, %mm5
movq %mm5, %mm6
movq %mm6, %mm7
movq %mm7, %mm0

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      800
# CHECK-NEXT: Total Cycles:      803
# CHECK-NEXT: Total uOps:        800

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    1.00
# CHECK-NEXT: IPC:               1.00
# CHECK-NEXT: Block RThroughput: 2.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.25                        movq	%mm0, %mm1
# CHECK-NEXT:  1      1     0.25                        movq	%mm1, %mm2
# CHECK-NEXT:  1      1     0.25                        movq	%mm2, %mm3
# CHECK-NEXT:  1      1     0.25                        movq	%mm3, %mm4
# CHECK-NEXT:  1      1     0.25                        movq	%mm4, %mm5
# CHECK-NEXT:  1      1     0.25                        movq	%mm5, %mm6
# CHECK-NEXT:  1      1     0.25                        movq	%mm6, %mm7
# CHECK-NEXT:  1      1     0.25                        movq	%mm7, %mm0

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    800
# CHECK-NEXT: Max number of mappings used:         66

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 800
# CHECK-NEXT:    Max number of mappings used:      66

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FPP0
# CHECK-NEXT: [9]   - Zn3FPP1
# CHECK-NEXT: [10]  - Zn3FPP2
# CHECK-NEXT: [11]  - Zn3FPP3
# CHECK-NEXT: [12.0] - Zn3FPP45
# CHECK-NEXT: [12.1] - Zn3FPP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00   2.00    -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     movq	%mm0, %mm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -     movq	%mm1, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%mm2, %mm3
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%mm3, %mm4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     movq	%mm4, %mm5
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -     movq	%mm5, %mm6
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%mm6, %mm7
# CHECK-NEXT:  -      -      -      -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%mm7, %mm0

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          0123456789

# CHECK:      [0,0]     DeER .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [0,1]     D=eER.    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [0,2]     D==eER    .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [0,3]     D===eER   .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [0,4]     D====eER  .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [0,5]     D=====eER .    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [0,6]     .D=====eER.    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [0,7]     .D======eER    .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [1,0]     .D=======eER   .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [1,1]     .D========eER  .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [1,2]     .D=========eER .    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [1,3]     .D==========eER.    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [1,4]     . D==========eER    .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [1,5]     . D===========eER   .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [1,6]     . D============eER  .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [1,7]     . D=============eER .    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [2,0]     . D==============eER.    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [2,1]     . D===============eER    .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [2,2]     .  D===============eER   .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [2,3]     .  D================eER  .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [2,4]     .  D=================eER .    .    .    .    .    .    .    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [2,5]     .  D==================eER.    .    .    .    .    .    .    .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [2,6]     .  D===================eER    .    .    .    .    .    .    .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [2,7]     .  D====================eER   .    .    .    .    .    .    .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [3,0]     .   D====================eER  .    .    .    .    .    .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [3,1]     .   D=====================eER .    .    .    .    .    .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [3,2]     .   D======================eER.    .    .    .    .    .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [3,3]     .   D=======================eER    .    .    .    .    .    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [3,4]     .   D========================eER   .    .    .    .    .    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [3,5]     .   D=========================eER  .    .    .    .    .    .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [3,6]     .    D=========================eER .    .    .    .    .    .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [3,7]     .    D==========================eER.    .    .    .    .    .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [4,0]     .    D===========================eER    .    .    .    .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [4,1]     .    D============================eER   .    .    .    .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [4,2]     .    D=============================eER  .    .    .    .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [4,3]     .    D==============================eER .    .    .    .    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [4,4]     .    .D==============================eER.    .    .    .    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [4,5]     .    .D===============================eER    .    .    .    .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [4,6]     .    .D================================eER   .    .    .    .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [4,7]     .    .D=================================eER  .    .    .    .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [5,0]     .    .D==================================eER .    .    .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [5,1]     .    .D===================================eER.    .    .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [5,2]     .    . D===================================eER    .    .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [5,3]     .    . D====================================eER   .    .    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [5,4]     .    . D=====================================eER  .    .    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [5,5]     .    . D======================================eER .    .    .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [5,6]     .    . D=======================================eER.    .    .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [5,7]     .    . D========================================eER    .    .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [6,0]     .    .  D========================================eER   .    .    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [6,1]     .    .  D=========================================eER  .    .    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [6,2]     .    .  D==========================================eER .    .    .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [6,3]     .    .  D===========================================eER.    .    .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [6,4]     .    .  D============================================eER    .    .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [6,5]     .    .  D=============================================eER   .    .    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [6,6]     .    .   D=============================================eER  .    .    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [6,7]     .    .   D==============================================eER .    .    .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [7,0]     .    .   D===============================================eER.    .    .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [7,1]     .    .   D================================================eER    .    .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [7,2]     .    .   D=================================================eER   .    .    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [7,3]     .    .   D==================================================eER  .    .    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [7,4]     .    .    D==================================================eER .    .    .   .   movq	%mm4, %mm5
# CHECK-NEXT: [7,5]     .    .    D===================================================eER.    .    .   .   movq	%mm5, %mm6
# CHECK-NEXT: [7,6]     .    .    D====================================================eER    .    .   .   movq	%mm6, %mm7
# CHECK-NEXT: [7,7]     .    .    D=====================================================eER   .    .   .   movq	%mm7, %mm0
# CHECK-NEXT: [8,0]     .    .    D======================================================eER  .    .   .   movq	%mm0, %mm1
# CHECK-NEXT: [8,1]     .    .    D=======================================================eER .    .   .   movq	%mm1, %mm2
# CHECK-NEXT: [8,2]     .    .    .D=======================================================eER.    .   .   movq	%mm2, %mm3
# CHECK-NEXT: [8,3]     .    .    .D========================================================eER    .   .   movq	%mm3, %mm4
# CHECK-NEXT: [8,4]     .    .    .D=========================================================eER   .   .   movq	%mm4, %mm5
# CHECK-NEXT: [8,5]     .    .    .D==========================================================eER  .   .   movq	%mm5, %mm6
# CHECK-NEXT: [8,6]     .    .    .D===========================================================eER .   .   movq	%mm6, %mm7
# CHECK-NEXT: [8,7]     .    .    .D============================================================eER.   .   movq	%mm7, %mm0
# CHECK-NEXT: [9,0]     .    .    . D============================================================eER   .   movq	%mm0, %mm1
# CHECK-NEXT: [9,1]     .    .    . D=============================================================eER  .   movq	%mm1, %mm2
# CHECK-NEXT: [9,2]     .    .    . D==============================================================eER .   movq	%mm2, %mm3
# CHECK-NEXT: [9,3]     .    .    . D===============================================================eER.   movq	%mm3, %mm4
# CHECK-NEXT: [9,4]     .    .    .  D===============================================================eER   movq	%mm4, %mm5
# CHECK-NEXT: Truncated display due to cycle limit

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     10    31.3   0.1    0.0       movq	%mm0, %mm1
# CHECK-NEXT: 1.     10    32.3   0.0    0.0       movq	%mm1, %mm2
# CHECK-NEXT: 2.     10    33.0   0.0    0.0       movq	%mm2, %mm3
# CHECK-NEXT: 3.     10    34.0   0.0    0.0       movq	%mm3, %mm4
# CHECK-NEXT: 4.     10    34.6   0.0    0.0       movq	%mm4, %mm5
# CHECK-NEXT: 5.     10    35.5   0.0    0.0       movq	%mm5, %mm6
# CHECK-NEXT: 6.     10    36.1   0.0    0.0       movq	%mm6, %mm7
# CHECK-NEXT: 7.     10    37.0   0.0    0.0       movq	%mm7, %mm0
# CHECK-NEXT:        10    34.2   0.0    0.0       <total>
