; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S < %s | FileCheck %s


target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare dso_local noalias noundef i8* @malloc(i64 noundef) local_unnamed_addr
declare i64 @llvm.objectsize.i64.p0i8(i8*, i1 immarg, i1 immarg, i1 immarg)
declare noalias i8* @strdup(i8*);
declare noalias i8* @__strdup(i8*);
declare noalias i8* @strndup(i8*, i64);
declare noalias i8* @__strndup(i8*, i64);

@str = dso_local constant [11 x i8] c"toulbroc'h\00"

define dso_local i64 @check_strdup(i32 noundef %n) local_unnamed_addr {
; CHECK-LABEL: @check_strdup(
; CHECK-NEXT:    ret i64 11
;
  %ptr = call noalias i8* @strdup(i8* noundef getelementptr inbounds ([11 x i8], [11 x i8]* @str, i64 0, i64 0))
  %size = call i64 @llvm.objectsize.i64.p0i8(i8* %ptr, i1 false, i1 true, i1 false)
  ret i64 %size
}

define dso_local i64 @check_dunder_strdup(i32 noundef %n) local_unnamed_addr {
; CHECK-LABEL: @check_dunder_strdup(
; CHECK-NEXT:    ret i64 11
;
  %ptr = call noalias i8* @__strdup(i8* noundef getelementptr inbounds ([11 x i8], [11 x i8]* @str, i64 0, i64 0))
  %size = call i64 @llvm.objectsize.i64.p0i8(i8* %ptr, i1 false, i1 true, i1 false)
  ret i64 %size
}

define dso_local i64 @check_strndup(i32 noundef %n) local_unnamed_addr {
; CHECK-LABEL: @check_strndup(
; CHECK-NEXT:    ret i64 5
;
  %ptr = call noalias i8* @strndup(i8* noundef getelementptr inbounds ([11 x i8], [11 x i8]* @str, i64 0, i64 0), i64 4)
  %size = call i64 @llvm.objectsize.i64.p0i8(i8* %ptr, i1 false, i1 true, i1 false)
  ret i64 %size
}

define dso_local i64 @check_dunder_strndup(i32 noundef %n) local_unnamed_addr {
; CHECK-LABEL: @check_dunder_strndup(
; CHECK-NEXT:    ret i64 5
;
  %ptr = call noalias i8* @__strndup(i8* noundef getelementptr inbounds ([11 x i8], [11 x i8]* @str, i64 0, i64 0), i64 4)
  %size = call i64 @llvm.objectsize.i64.p0i8(i8* %ptr, i1 false, i1 true, i1 false)
  ret i64 %size
}
