// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefixes=W32-ERR %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefixes=W64-ERR %s

v_cmp_f_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x20,0x7c]

v_cmp_f_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x20,0x7c]

v_cmp_f_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0xff,0x05,0x02,0x00]

v_cmp_f_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x04,0x02,0x00]

v_cmp_f_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x65,0x04,0x02,0x00]

v_cmp_f_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_f_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_f_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_f_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_f_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_f_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xff,0x03,0x00]

v_cmp_f_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x00,0x00]

v_cmp_f_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_f_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_f_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_f_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xff,0x00,0x00]

v_cmp_f_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_f_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xef,0x01,0x00]

v_cmp_f_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x20]

v_cmp_f_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x40]

v_cmp_f_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x60]

v_cmp_f_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x10,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x22,0x7c]

v_cmp_lt_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x22,0x7c]

v_cmp_lt_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lt_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lt_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lt_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lt_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lt_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lt_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lt_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lt_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lt_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lt_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lt_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lt_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lt_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lt_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lt_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lt_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x40]

v_cmp_lt_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x60]

v_cmp_lt_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x11,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x24,0x7c]

v_cmp_eq_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x24,0x7c]

v_cmp_eq_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0xff,0x05,0x02,0x00]

v_cmp_eq_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x04,0x02,0x00]

v_cmp_eq_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x65,0x04,0x02,0x00]

v_cmp_eq_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_eq_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_eq_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_eq_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_eq_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_eq_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xff,0x03,0x00]

v_cmp_eq_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x00,0x00]

v_cmp_eq_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_eq_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_eq_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_eq_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xff,0x00,0x00]

v_cmp_eq_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_eq_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xef,0x01,0x00]

v_cmp_eq_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x20]

v_cmp_eq_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x40]

v_cmp_eq_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x60]

v_cmp_eq_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x12,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x26,0x7c]

v_cmp_le_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x26,0x7c]

v_cmp_le_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0xff,0x05,0x02,0x00]

v_cmp_le_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x04,0x02,0x00]

v_cmp_le_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x65,0x04,0x02,0x00]

v_cmp_le_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_le_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_le_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_le_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_le_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_le_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xff,0x03,0x00]

v_cmp_le_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x00,0x00]

v_cmp_le_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_le_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_le_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_le_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xff,0x00,0x00]

v_cmp_le_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_le_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xef,0x01,0x00]

v_cmp_le_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x20]

v_cmp_le_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x40]

v_cmp_le_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x60]

v_cmp_le_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x13,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x28,0x7c]

v_cmp_gt_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x28,0x7c]

v_cmp_gt_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0xff,0x05,0x02,0x00]

v_cmp_gt_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x04,0x02,0x00]

v_cmp_gt_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x65,0x04,0x02,0x00]

v_cmp_gt_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_gt_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_gt_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_gt_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_gt_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_gt_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xff,0x03,0x00]

v_cmp_gt_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x00,0x00]

v_cmp_gt_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_gt_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_gt_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_gt_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xff,0x00,0x00]

v_cmp_gt_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_gt_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xef,0x01,0x00]

v_cmp_gt_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x20]

v_cmp_gt_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x40]

v_cmp_gt_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x60]

v_cmp_gt_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x14,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x2a,0x7c]

v_cmp_lg_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x2a,0x7c]

v_cmp_lg_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lg_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lg_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lg_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lg_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lg_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lg_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lg_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lg_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lg_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lg_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lg_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lg_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lg_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lg_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lg_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lg_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lg_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lg_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lg_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lg_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lg_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lg_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lg_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lg_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lg_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x40]

v_cmp_lg_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x60]

v_cmp_lg_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x15,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x2c,0x7c]

v_cmp_ge_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x2c,0x7c]

v_cmp_ge_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ge_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ge_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ge_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ge_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ge_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ge_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ge_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ge_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ge_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ge_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ge_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ge_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ge_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ge_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ge_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ge_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x20]

v_cmp_ge_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x40]

v_cmp_ge_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x60]

v_cmp_ge_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x16,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x2e,0x7c]

v_cmp_o_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x2e,0x7c]

v_cmp_o_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0xff,0x05,0x02,0x00]

v_cmp_o_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x04,0x02,0x00]

v_cmp_o_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x65,0x04,0x02,0x00]

v_cmp_o_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_o_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_o_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_o_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_o_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_o_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x80,0x04,0x02,0x00]

v_cmp_o_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_o_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_o_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_o_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xff,0x03,0x00]

v_cmp_o_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x00,0x00]

v_cmp_o_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_o_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_o_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_o_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_o_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_o_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xff,0x00,0x00]

v_cmp_o_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x01,0x01,0x00]

v_cmp_o_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x83,0x01,0x00]

v_cmp_o_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_o_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xef,0x01,0x00]

v_cmp_o_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x20]

v_cmp_o_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x40]

v_cmp_o_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x60]

v_cmp_o_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x17,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x30,0x7c]

v_cmp_u_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x30,0x7c]

v_cmp_u_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0xff,0x05,0x02,0x00]

v_cmp_u_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x04,0x02,0x00]

v_cmp_u_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x65,0x04,0x02,0x00]

v_cmp_u_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_u_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_u_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_u_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_u_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_u_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x80,0x04,0x02,0x00]

v_cmp_u_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_u_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_u_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_u_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xff,0x03,0x00]

v_cmp_u_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x00,0x00]

v_cmp_u_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_u_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_u_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_u_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_u_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_u_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xff,0x00,0x00]

v_cmp_u_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x01,0x01,0x00]

v_cmp_u_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x83,0x01,0x00]

v_cmp_u_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_u_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xef,0x01,0x00]

v_cmp_u_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x20]

v_cmp_u_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x40]

v_cmp_u_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x60]

v_cmp_u_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x18,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x32,0x7c]

v_cmp_nge_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x32,0x7c]

v_cmp_nge_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nge_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nge_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nge_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nge_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nge_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nge_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nge_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nge_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nge_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nge_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nge_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nge_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nge_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nge_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nge_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nge_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nge_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nge_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nge_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nge_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nge_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nge_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nge_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nge_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nge_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nge_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nge_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x19,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x34,0x7c]

v_cmp_nlg_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x34,0x7c]

v_cmp_nlg_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nlg_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nlg_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nlg_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nlg_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nlg_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nlg_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nlg_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nlg_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nlg_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nlg_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nlg_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nlg_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nlg_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x1a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x36,0x7c]

v_cmp_ngt_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x36,0x7c]

v_cmp_ngt_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ngt_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ngt_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ngt_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ngt_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ngt_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ngt_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ngt_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ngt_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ngt_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ngt_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x20]

v_cmp_ngt_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x40]

v_cmp_ngt_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x60]

v_cmp_ngt_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x1b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x38,0x7c]

v_cmp_nle_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x38,0x7c]

v_cmp_nle_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nle_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nle_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nle_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nle_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nle_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nle_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nle_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nle_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nle_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nle_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nle_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nle_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nle_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nle_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nle_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nle_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nle_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nle_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nle_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nle_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nle_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nle_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nle_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nle_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nle_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nle_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nle_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x1c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x3a,0x7c]

v_cmp_neq_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x3a,0x7c]

v_cmp_neq_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0xff,0x05,0x02,0x00]

v_cmp_neq_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x04,0x02,0x00]

v_cmp_neq_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x65,0x04,0x02,0x00]

v_cmp_neq_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_neq_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_neq_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_neq_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_neq_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_neq_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x80,0x04,0x02,0x00]

v_cmp_neq_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_neq_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_neq_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_neq_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xff,0x03,0x00]

v_cmp_neq_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x00,0x00]

v_cmp_neq_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_neq_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_neq_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_neq_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_neq_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_neq_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xff,0x00,0x00]

v_cmp_neq_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x01,0x01,0x00]

v_cmp_neq_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x83,0x01,0x00]

v_cmp_neq_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_neq_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xef,0x01,0x00]

v_cmp_neq_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x20]

v_cmp_neq_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x40]

v_cmp_neq_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x60]

v_cmp_neq_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x1d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x3c,0x7c]

v_cmp_nlt_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x3c,0x7c]

v_cmp_nlt_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nlt_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nlt_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nlt_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nlt_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nlt_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nlt_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nlt_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nlt_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nlt_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nlt_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nlt_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nlt_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nlt_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x1e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x3e,0x7c]

v_cmp_tru_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x3e,0x7c]

v_cmp_tru_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0xff,0x05,0x02,0x00]

v_cmp_tru_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x04,0x02,0x00]

v_cmp_tru_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x65,0x04,0x02,0x00]

v_cmp_tru_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_tru_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_tru_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_tru_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_tru_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_tru_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x80,0x04,0x02,0x00]

v_cmp_tru_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_tru_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_tru_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_tru_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xff,0x03,0x00]

v_cmp_tru_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x00,0x00]

v_cmp_tru_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_tru_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_tru_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_tru_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_tru_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_tru_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xff,0x00,0x00]

v_cmp_tru_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x01,0x01,0x00]

v_cmp_tru_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x83,0x01,0x00]

v_cmp_tru_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_tru_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xef,0x01,0x00]

v_cmp_tru_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x20]

v_cmp_tru_f32 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x40]

v_cmp_tru_f32 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x60]

v_cmp_tru_f32 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x1f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x40,0x7c]

v_cmp_f_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x20,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x20,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x40,0x7c]

v_cmp_f_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_f_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x02,0x04,0x02,0x00]

v_cmp_f_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x04,0x04,0x02,0x00]

v_cmp_f_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x64,0x04,0x02,0x00]

v_cmp_f_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_f_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_f_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_f_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x09,0x00,0x00]

v_cmp_f_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_f_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_f_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_f_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xef,0x01,0x00]

v_cmp_f_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x20]

v_cmp_f_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x40]

v_cmp_f_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x60]

v_cmp_f_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x20,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x42,0x7c]

v_cmp_lt_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x21,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x21,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x42,0x7c]

v_cmp_lt_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_lt_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x02,0x04,0x02,0x00]

v_cmp_lt_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x04,0x04,0x02,0x00]

v_cmp_lt_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x64,0x04,0x02,0x00]

v_cmp_lt_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lt_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lt_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_lt_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x09,0x00,0x00]

v_cmp_lt_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_lt_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_lt_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lt_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lt_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x40]

v_cmp_lt_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x60]

v_cmp_lt_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x21,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x44,0x7c]

v_cmp_eq_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x22,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x22,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x44,0x7c]

v_cmp_eq_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_eq_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x02,0x04,0x02,0x00]

v_cmp_eq_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x04,0x04,0x02,0x00]

v_cmp_eq_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x64,0x04,0x02,0x00]

v_cmp_eq_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_eq_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_eq_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_eq_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x09,0x00,0x00]

v_cmp_eq_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_eq_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_eq_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_eq_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xef,0x01,0x00]

v_cmp_eq_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x20]

v_cmp_eq_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x40]

v_cmp_eq_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x60]

v_cmp_eq_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x22,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x46,0x7c]

v_cmp_le_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x23,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x23,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x46,0x7c]

v_cmp_le_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_le_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x02,0x04,0x02,0x00]

v_cmp_le_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x04,0x04,0x02,0x00]

v_cmp_le_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x64,0x04,0x02,0x00]

v_cmp_le_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_le_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_le_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_le_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x09,0x00,0x00]

v_cmp_le_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_le_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_le_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_le_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xef,0x01,0x00]

v_cmp_le_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x20]

v_cmp_le_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x40]

v_cmp_le_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x60]

v_cmp_le_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x23,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x48,0x7c]

v_cmp_gt_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x24,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x24,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x48,0x7c]

v_cmp_gt_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_gt_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x02,0x04,0x02,0x00]

v_cmp_gt_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x04,0x04,0x02,0x00]

v_cmp_gt_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x64,0x04,0x02,0x00]

v_cmp_gt_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_gt_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_gt_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_gt_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x09,0x00,0x00]

v_cmp_gt_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_gt_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_gt_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_gt_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xef,0x01,0x00]

v_cmp_gt_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x20]

v_cmp_gt_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x40]

v_cmp_gt_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x60]

v_cmp_gt_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x24,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x4a,0x7c]

v_cmp_lg_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x25,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x25,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x4a,0x7c]

v_cmp_lg_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_lg_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x02,0x04,0x02,0x00]

v_cmp_lg_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x04,0x04,0x02,0x00]

v_cmp_lg_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x64,0x04,0x02,0x00]

v_cmp_lg_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lg_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lg_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lg_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lg_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lg_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lg_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_lg_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x09,0x00,0x00]

v_cmp_lg_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_lg_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_lg_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lg_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lg_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lg_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lg_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lg_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lg_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lg_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x40]

v_cmp_lg_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x60]

v_cmp_lg_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x25,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x4c,0x7c]

v_cmp_ge_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x26,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x26,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x4c,0x7c]

v_cmp_ge_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_ge_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x02,0x04,0x02,0x00]

v_cmp_ge_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x04,0x04,0x02,0x00]

v_cmp_ge_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x64,0x04,0x02,0x00]

v_cmp_ge_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ge_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ge_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_ge_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x09,0x00,0x00]

v_cmp_ge_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_ge_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_ge_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ge_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ge_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x20]

v_cmp_ge_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x40]

v_cmp_ge_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x60]

v_cmp_ge_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x26,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x4e,0x7c]

v_cmp_o_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x27,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x27,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x4e,0x7c]

v_cmp_o_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_o_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x02,0x04,0x02,0x00]

v_cmp_o_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x04,0x04,0x02,0x00]

v_cmp_o_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x64,0x04,0x02,0x00]

v_cmp_o_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_o_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_o_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x80,0x04,0x02,0x00]

v_cmp_o_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_o_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_o_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_o_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_o_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x09,0x00,0x00]

v_cmp_o_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_o_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_o_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_o_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_o_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x01,0x01,0x00]

v_cmp_o_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x83,0x01,0x00]

v_cmp_o_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_o_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xef,0x01,0x00]

v_cmp_o_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x20]

v_cmp_o_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x40]

v_cmp_o_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x60]

v_cmp_o_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x27,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x50,0x7c]

v_cmp_u_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x28,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x28,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x50,0x7c]

v_cmp_u_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_u_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x02,0x04,0x02,0x00]

v_cmp_u_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x04,0x04,0x02,0x00]

v_cmp_u_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x64,0x04,0x02,0x00]

v_cmp_u_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_u_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_u_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x80,0x04,0x02,0x00]

v_cmp_u_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_u_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_u_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_u_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_u_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x09,0x00,0x00]

v_cmp_u_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_u_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_u_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_u_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_u_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x01,0x01,0x00]

v_cmp_u_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x83,0x01,0x00]

v_cmp_u_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_u_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xef,0x01,0x00]

v_cmp_u_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x20]

v_cmp_u_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x40]

v_cmp_u_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x60]

v_cmp_u_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x28,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x52,0x7c]

v_cmp_nge_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x29,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x29,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x52,0x7c]

v_cmp_nge_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_nge_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x02,0x04,0x02,0x00]

v_cmp_nge_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x04,0x04,0x02,0x00]

v_cmp_nge_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x64,0x04,0x02,0x00]

v_cmp_nge_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nge_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nge_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nge_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nge_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nge_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nge_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_nge_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x09,0x00,0x00]

v_cmp_nge_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_nge_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_nge_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nge_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nge_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nge_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nge_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nge_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nge_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nge_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nge_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nge_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x29,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x54,0x7c]

v_cmp_nlg_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x2a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x2a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x54,0x7c]

v_cmp_nlg_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_nlg_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x02,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x04,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x64,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_nlg_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x09,0x00,0x00]

v_cmp_nlg_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_nlg_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_nlg_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nlg_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nlg_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nlg_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nlg_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nlg_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nlg_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x2a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x56,0x7c]

v_cmp_ngt_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x2b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x2b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x56,0x7c]

v_cmp_ngt_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_ngt_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x02,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x04,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x64,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_ngt_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x09,0x00,0x00]

v_cmp_ngt_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_ngt_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_ngt_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ngt_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ngt_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ngt_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x20]

v_cmp_ngt_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x40]

v_cmp_ngt_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x60]

v_cmp_ngt_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x2b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x58,0x7c]

v_cmp_nle_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x2c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x2c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x58,0x7c]

v_cmp_nle_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_nle_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x02,0x04,0x02,0x00]

v_cmp_nle_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x04,0x04,0x02,0x00]

v_cmp_nle_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x64,0x04,0x02,0x00]

v_cmp_nle_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nle_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nle_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nle_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nle_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nle_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nle_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_nle_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x09,0x00,0x00]

v_cmp_nle_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_nle_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_nle_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nle_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nle_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nle_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nle_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nle_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nle_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nle_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nle_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nle_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x2c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x5a,0x7c]

v_cmp_neq_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x2d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x2d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x5a,0x7c]

v_cmp_neq_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_neq_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x02,0x04,0x02,0x00]

v_cmp_neq_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x04,0x04,0x02,0x00]

v_cmp_neq_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x64,0x04,0x02,0x00]

v_cmp_neq_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_neq_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_neq_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x80,0x04,0x02,0x00]

v_cmp_neq_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_neq_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_neq_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_neq_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_neq_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x09,0x00,0x00]

v_cmp_neq_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_neq_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_neq_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_neq_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_neq_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x01,0x01,0x00]

v_cmp_neq_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x83,0x01,0x00]

v_cmp_neq_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_neq_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xef,0x01,0x00]

v_cmp_neq_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x20]

v_cmp_neq_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x40]

v_cmp_neq_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x60]

v_cmp_neq_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x2d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x5c,0x7c]

v_cmp_nlt_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x2e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x2e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x5c,0x7c]

v_cmp_nlt_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_nlt_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x02,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x04,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x64,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_nlt_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x09,0x00,0x00]

v_cmp_nlt_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_nlt_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_nlt_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nlt_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nlt_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xef,0x01,0x00]

v_cmp_nlt_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nlt_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nlt_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nlt_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x2e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0x5e,0x7c]

v_cmp_tru_f64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x2f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x2f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0x5e,0x7c]

v_cmp_tru_f64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_tru_f64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x02,0x04,0x02,0x00]

v_cmp_tru_f64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x04,0x04,0x02,0x00]

v_cmp_tru_f64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x64,0x04,0x02,0x00]

v_cmp_tru_f64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_tru_f64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_tru_f64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x80,0x04,0x02,0x00]

v_cmp_tru_f64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_tru_f64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_tru_f64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_tru_f64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_tru_f64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x09,0x00,0x00]

v_cmp_tru_f64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_tru_f64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_tru_f64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_tru_f64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_tru_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x01,0x01,0x00]

v_cmp_tru_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x83,0x01,0x00]

v_cmp_tru_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_tru_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xef,0x01,0x00]

v_cmp_tru_f64 s10, -v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x20]

v_cmp_tru_f64 s10, v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x40]

v_cmp_tru_f64 s10, -v[1:2], -v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x60]

v_cmp_tru_f64 s10, v[1:2], v[2:3] clamp
// W32: encoding: [0x0a,0x80,0x2f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x80,0x7c]

v_cmp_lt_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x82,0x7c]

v_cmp_eq_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x84,0x7c]

v_cmp_le_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x86,0x7c]

v_cmp_gt_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x88,0x7c]

v_cmp_ne_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x8a,0x7c]

v_cmp_ge_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x8c,0x7c]

v_cmp_t_i32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x8e,0x7c]

v_cmp_f_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x40,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x40,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x80,0x7c]

v_cmp_f_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0xff,0x05,0x02,0x00]

v_cmp_f_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x04,0x02,0x00]

v_cmp_f_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x65,0x04,0x02,0x00]

v_cmp_f_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_f_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_f_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_f_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_f_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_f_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xff,0x03,0x00]

v_cmp_f_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x05,0x00,0x00]

v_cmp_f_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_f_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_f_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_f_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xff,0x00,0x00]

v_cmp_f_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_f_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x41,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x41,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x82,0x7c]

v_cmp_lt_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lt_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lt_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lt_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lt_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lt_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lt_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lt_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lt_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lt_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lt_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lt_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lt_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lt_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lt_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lt_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xef,0x01,0x00]

v_cmp_eq_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x42,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x42,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x84,0x7c]

v_cmp_eq_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0xff,0x05,0x02,0x00]

v_cmp_eq_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x04,0x02,0x00]

v_cmp_eq_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x65,0x04,0x02,0x00]

v_cmp_eq_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_eq_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_eq_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_eq_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_eq_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_eq_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xff,0x03,0x00]

v_cmp_eq_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x05,0x00,0x00]

v_cmp_eq_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_eq_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_eq_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_eq_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xff,0x00,0x00]

v_cmp_eq_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_eq_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xef,0x01,0x00]

v_cmp_le_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x43,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x43,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x86,0x7c]

v_cmp_le_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0xff,0x05,0x02,0x00]

v_cmp_le_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x04,0x02,0x00]

v_cmp_le_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x65,0x04,0x02,0x00]

v_cmp_le_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_le_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_le_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_le_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_le_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_le_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xff,0x03,0x00]

v_cmp_le_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x05,0x00,0x00]

v_cmp_le_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_le_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_le_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_le_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xff,0x00,0x00]

v_cmp_le_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_le_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xef,0x01,0x00]

v_cmp_gt_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x44,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x44,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x88,0x7c]

v_cmp_gt_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0xff,0x05,0x02,0x00]

v_cmp_gt_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x04,0x02,0x00]

v_cmp_gt_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x65,0x04,0x02,0x00]

v_cmp_gt_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_gt_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_gt_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_gt_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_gt_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_gt_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xff,0x03,0x00]

v_cmp_gt_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x05,0x00,0x00]

v_cmp_gt_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_gt_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_gt_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_gt_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xff,0x00,0x00]

v_cmp_gt_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_gt_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ne_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x45,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x45,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x8a,0x7c]

v_cmp_ne_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ne_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ne_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ne_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ne_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ne_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ne_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ne_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ne_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ne_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ne_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ne_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ne_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ne_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ne_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ne_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ne_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ne_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ne_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ne_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ne_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ne_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ne_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ne_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ge_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x46,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x46,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x8c,0x7c]

v_cmp_ge_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ge_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ge_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ge_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ge_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ge_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ge_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ge_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ge_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ge_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ge_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ge_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ge_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ge_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ge_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ge_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xef,0x01,0x00]

v_cmp_t_i32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_i32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x47,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_i32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x47,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_i32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x8e,0x7c]

v_cmp_t_i32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0xff,0x05,0x02,0x00]

v_cmp_t_i32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x04,0x02,0x00]

v_cmp_t_i32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x65,0x04,0x02,0x00]

v_cmp_t_i32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_t_i32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_t_i32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_t_i32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_t_i32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_t_i32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x80,0x04,0x02,0x00]

v_cmp_t_i32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_t_i32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_t_i32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_t_i32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xff,0x03,0x00]

v_cmp_t_i32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x05,0x00,0x00]

v_cmp_t_i32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_t_i32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_t_i32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_t_i32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_t_i32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_t_i32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xff,0x00,0x00]

v_cmp_t_i32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x01,0x01,0x00]

v_cmp_t_i32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x83,0x01,0x00]

v_cmp_t_i32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_t_i32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xef,0x01,0x00]

v_cmp_class_f32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0xfc,0x7c]

v_cmp_class_f32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_class_f32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x7e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_class_f32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x7e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_class_f32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0xfc,0x7c]

v_cmp_class_f32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0xff,0x05,0x02,0x00]

v_cmp_class_f32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x04,0x02,0x00]

v_cmp_class_f32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x65,0x04,0x02,0x00]

v_cmp_class_f32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_class_f32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_class_f32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_class_f32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_class_f32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_class_f32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_class_f32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_class_f32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_class_f32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_class_f32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xff,0x03,0x00]

v_cmp_class_f32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x05,0x00,0x00]

v_cmp_class_f32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_class_f32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_class_f32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_class_f32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_class_f32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_class_f32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xff,0x00,0x00]

v_cmp_class_f32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_class_f32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_class_f32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_class_f32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xef,0x01,0x00]

v_cmp_class_f32 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lt_i16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x62,0x7c]

v_cmp_eq_i16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x64,0x7c]

v_cmp_le_i16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x66,0x7c]

v_cmp_gt_i16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x68,0x7c]

v_cmp_ne_i16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x6a,0x7c]

v_cmp_ge_i16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x6c,0x7c]

v_cmp_lt_i16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x62,0x7c]

v_cmp_lt_i16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lt_i16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lt_i16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lt_i16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_i16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lt_i16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lt_i16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_i16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lt_i16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_i16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_i16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lt_i16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lt_i16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lt_i16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_i16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lt_i16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lt_i16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_i16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lt_i16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_i16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_i16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x64,0x7c]

v_cmp_eq_i16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0xff,0x05,0x02,0x00]

v_cmp_eq_i16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x04,0x02,0x00]

v_cmp_eq_i16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x65,0x04,0x02,0x00]

v_cmp_eq_i16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_i16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_eq_i16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_eq_i16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_i16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_eq_i16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_i16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_i16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xff,0x03,0x00]

v_cmp_eq_i16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x05,0x00,0x00]

v_cmp_eq_i16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_eq_i16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_i16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_eq_i16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_eq_i16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_i16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xff,0x00,0x00]

v_cmp_eq_i16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_i16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_i16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x66,0x7c]

v_cmp_le_i16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0xff,0x05,0x02,0x00]

v_cmp_le_i16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x04,0x02,0x00]

v_cmp_le_i16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x65,0x04,0x02,0x00]

v_cmp_le_i16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_i16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_le_i16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_le_i16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_i16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_le_i16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_i16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_i16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xff,0x03,0x00]

v_cmp_le_i16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x05,0x00,0x00]

v_cmp_le_i16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_le_i16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_i16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_le_i16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_le_i16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_i16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xff,0x00,0x00]

v_cmp_le_i16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_i16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_i16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x68,0x7c]

v_cmp_gt_i16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0xff,0x05,0x02,0x00]

v_cmp_gt_i16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x04,0x02,0x00]

v_cmp_gt_i16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x65,0x04,0x02,0x00]

v_cmp_gt_i16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_i16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_gt_i16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_gt_i16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_i16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_gt_i16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_i16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_i16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xff,0x03,0x00]

v_cmp_gt_i16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x05,0x00,0x00]

v_cmp_gt_i16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_gt_i16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_i16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_gt_i16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_gt_i16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_i16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xff,0x00,0x00]

v_cmp_gt_i16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_i16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ne_i16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x6a,0x7c]

v_cmp_ne_i16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ne_i16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ne_i16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ne_i16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ne_i16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ne_i16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ne_i16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ne_i16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ne_i16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ne_i16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ne_i16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ne_i16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ne_i16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ne_i16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ne_i16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ne_i16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ne_i16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ne_i16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ne_i16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ne_i16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_i16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x6c,0x7c]

v_cmp_ge_i16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ge_i16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ge_i16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ge_i16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_i16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ge_i16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ge_i16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_i16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ge_i16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_i16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_i16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ge_i16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ge_i16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ge_i16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_i16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ge_i16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ge_i16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_i16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ge_i16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_i16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x83,0x01,0x00]

v_cmp_class_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0xfa,0x7c]

v_cmp_f_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xa0,0x7c]

v_cmp_lt_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xa2,0x7c]

v_cmp_eq_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xa4,0x7c]

v_cmp_le_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xa6,0x7c]

v_cmp_gt_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xa8,0x7c]

v_cmp_ne_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xaa,0x7c]

v_cmp_ge_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xac,0x7c]

v_cmp_t_i64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xae,0x7c]

v_cmp_class_f64 vcc, v[1:2], v2
// W64: encoding: [0x01,0x05,0xfe,0x7c]

v_cmp_f_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xb0,0x7c]

v_cmp_lt_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xb2,0x7c]

v_cmp_eq_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xb4,0x7c]

v_cmp_le_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xb6,0x7c]

v_cmp_gt_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xb8,0x7c]

v_cmp_ne_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xba,0x7c]

v_cmp_ge_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xbc,0x7c]

v_cmp_t_u64 vcc, v[1:2], v[2:3]
// W64: encoding: [0x01,0x05,0xbe,0x7c]

v_cmp_f_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x50,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x50,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xa0,0x7c]

v_cmp_f_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_f_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x02,0x04,0x02,0x00]

v_cmp_f_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x04,0x04,0x02,0x00]

v_cmp_f_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x64,0x04,0x02,0x00]

v_cmp_f_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_f_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_f_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_f_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x09,0x00,0x00]

v_cmp_f_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_f_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_f_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_f_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x51,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x51,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xa2,0x7c]

v_cmp_lt_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_lt_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x02,0x04,0x02,0x00]

v_cmp_lt_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x04,0x04,0x02,0x00]

v_cmp_lt_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x64,0x04,0x02,0x00]

v_cmp_lt_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lt_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lt_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_lt_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x09,0x00,0x00]

v_cmp_lt_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_lt_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_lt_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lt_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xef,0x01,0x00]

v_cmp_eq_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x52,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x52,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xa4,0x7c]

v_cmp_eq_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_eq_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x02,0x04,0x02,0x00]

v_cmp_eq_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x04,0x04,0x02,0x00]

v_cmp_eq_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x64,0x04,0x02,0x00]

v_cmp_eq_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_eq_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_eq_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_eq_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x09,0x00,0x00]

v_cmp_eq_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_eq_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_eq_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_eq_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xef,0x01,0x00]

v_cmp_le_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x53,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x53,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xa6,0x7c]

v_cmp_le_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_le_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x02,0x04,0x02,0x00]

v_cmp_le_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x04,0x04,0x02,0x00]

v_cmp_le_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x64,0x04,0x02,0x00]

v_cmp_le_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_le_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_le_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_le_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x09,0x00,0x00]

v_cmp_le_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_le_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_le_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_le_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xef,0x01,0x00]

v_cmp_gt_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x54,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x54,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xa8,0x7c]

v_cmp_gt_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_gt_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x02,0x04,0x02,0x00]

v_cmp_gt_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x04,0x04,0x02,0x00]

v_cmp_gt_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x64,0x04,0x02,0x00]

v_cmp_gt_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_gt_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_gt_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_gt_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x09,0x00,0x00]

v_cmp_gt_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_gt_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_gt_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_gt_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ne_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x55,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x55,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xaa,0x7c]

v_cmp_ne_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_ne_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x02,0x04,0x02,0x00]

v_cmp_ne_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x04,0x04,0x02,0x00]

v_cmp_ne_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x64,0x04,0x02,0x00]

v_cmp_ne_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ne_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ne_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ne_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ne_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ne_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ne_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_ne_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x09,0x00,0x00]

v_cmp_ne_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_ne_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_ne_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ne_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ne_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ne_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ne_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ne_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ge_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x56,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x56,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xac,0x7c]

v_cmp_ge_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_ge_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x02,0x04,0x02,0x00]

v_cmp_ge_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x04,0x04,0x02,0x00]

v_cmp_ge_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x64,0x04,0x02,0x00]

v_cmp_ge_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ge_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ge_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_ge_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x09,0x00,0x00]

v_cmp_ge_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_ge_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_ge_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ge_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xef,0x01,0x00]

v_cmp_t_i64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_i64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x57,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_i64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x57,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_i64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xae,0x7c]

v_cmp_t_i64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_t_i64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x02,0x04,0x02,0x00]

v_cmp_t_i64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x04,0x04,0x02,0x00]

v_cmp_t_i64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x64,0x04,0x02,0x00]

v_cmp_t_i64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_t_i64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_t_i64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x80,0x04,0x02,0x00]

v_cmp_t_i64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_t_i64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_t_i64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_t_i64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_t_i64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x09,0x00,0x00]

v_cmp_t_i64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_t_i64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_t_i64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_t_i64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_t_i64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x01,0x01,0x00]

v_cmp_t_i64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x83,0x01,0x00]

v_cmp_t_i64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_t_i64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xef,0x01,0x00]

v_cmp_class_f64 s10, v[1:2], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_class_f64 s12, v[1:2], v2
// W32: encoding: [0x0c,0x00,0x7f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_class_f64 s100, v[1:2], v2
// W32: encoding: [0x64,0x00,0x7f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_class_f64 vcc_lo, v[1:2], v2
// W32: encoding: [0x01,0x05,0xfe,0x7c]

v_cmp_class_f64 s10, v[254:255], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_class_f64 s10, s[2:3], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x02,0x04,0x02,0x00]

v_cmp_class_f64 s10, s[4:5], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x04,0x04,0x02,0x00]

v_cmp_class_f64 s10, s[100:101], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x64,0x04,0x02,0x00]

v_cmp_class_f64 s10, vcc, v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_class_f64 s10, exec, v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_class_f64 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x80,0x04,0x02,0x00]

v_cmp_class_f64 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_class_f64 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_class_f64 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_class_f64 s10, v[1:2], v255
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xff,0x03,0x00]

v_cmp_class_f64 s10, v[1:2], s2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x05,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], s101
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], vcc_lo
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], vcc_hi
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], m0
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], exec_lo
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], exec_hi
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xff,0x00,0x00]

v_cmp_class_f64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x01,0x01,0x00]

v_cmp_class_f64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x83,0x01,0x00]

v_cmp_class_f64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_class_f64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xef,0x01,0x00]

v_cmp_class_f64 s10, -v[1:2], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x05,0x02,0x20]

v_cmp_f_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x58,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x58,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xb0,0x7c]

v_cmp_f_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_f_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x02,0x04,0x02,0x00]

v_cmp_f_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x04,0x04,0x02,0x00]

v_cmp_f_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x64,0x04,0x02,0x00]

v_cmp_f_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_f_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_f_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_f_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x09,0x00,0x00]

v_cmp_f_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_f_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_f_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_f_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x59,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x59,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xb2,0x7c]

v_cmp_lt_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_lt_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x02,0x04,0x02,0x00]

v_cmp_lt_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x04,0x04,0x02,0x00]

v_cmp_lt_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x64,0x04,0x02,0x00]

v_cmp_lt_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lt_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lt_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_lt_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x09,0x00,0x00]

v_cmp_lt_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_lt_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_lt_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lt_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xef,0x01,0x00]

v_cmp_eq_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x5a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x5a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xb4,0x7c]

v_cmp_eq_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_eq_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x02,0x04,0x02,0x00]

v_cmp_eq_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x04,0x04,0x02,0x00]

v_cmp_eq_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x64,0x04,0x02,0x00]

v_cmp_eq_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_eq_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_eq_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_eq_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x09,0x00,0x00]

v_cmp_eq_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_eq_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_eq_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_eq_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xef,0x01,0x00]

v_cmp_le_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x5b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x5b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xb6,0x7c]

v_cmp_le_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_le_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x02,0x04,0x02,0x00]

v_cmp_le_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x04,0x04,0x02,0x00]

v_cmp_le_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x64,0x04,0x02,0x00]

v_cmp_le_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_le_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_le_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_le_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x09,0x00,0x00]

v_cmp_le_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_le_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_le_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_le_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xef,0x01,0x00]

v_cmp_gt_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x5c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x5c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xb8,0x7c]

v_cmp_gt_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_gt_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x02,0x04,0x02,0x00]

v_cmp_gt_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x04,0x04,0x02,0x00]

v_cmp_gt_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x64,0x04,0x02,0x00]

v_cmp_gt_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_gt_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_gt_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_gt_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x09,0x00,0x00]

v_cmp_gt_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_gt_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_gt_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_gt_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ne_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x5d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x5d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xba,0x7c]

v_cmp_ne_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_ne_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x02,0x04,0x02,0x00]

v_cmp_ne_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x04,0x04,0x02,0x00]

v_cmp_ne_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x64,0x04,0x02,0x00]

v_cmp_ne_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ne_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ne_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ne_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ne_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ne_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ne_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_ne_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x09,0x00,0x00]

v_cmp_ne_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_ne_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_ne_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ne_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ne_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ne_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ne_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ne_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ge_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x5e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x5e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xbc,0x7c]

v_cmp_ge_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_ge_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x02,0x04,0x02,0x00]

v_cmp_ge_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x04,0x04,0x02,0x00]

v_cmp_ge_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x64,0x04,0x02,0x00]

v_cmp_ge_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ge_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ge_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_ge_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x09,0x00,0x00]

v_cmp_ge_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_ge_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_ge_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ge_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xef,0x01,0x00]

v_cmp_t_u64 s10, v[1:2], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_u64 s12, v[1:2], v[2:3]
// W32: encoding: [0x0c,0x00,0x5f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_u64 s100, v[1:2], v[2:3]
// W32: encoding: [0x64,0x00,0x5f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_u64 vcc_lo, v[1:2], v[2:3]
// W32: encoding: [0x01,0x05,0xbe,0x7c]

v_cmp_t_u64 s10, v[254:255], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0xfe,0x05,0x02,0x00]

v_cmp_t_u64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x02,0x04,0x02,0x00]

v_cmp_t_u64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x04,0x04,0x02,0x00]

v_cmp_t_u64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x64,0x04,0x02,0x00]

v_cmp_t_u64 s10, vcc, v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_t_u64 s10, exec, v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_t_u64 s10, 0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x80,0x04,0x02,0x00]

v_cmp_t_u64 s10, -1, v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_t_u64 s10, 0.5, v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_t_u64 s10, -4.0, v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_t_u64 s10, v[1:2], v[254:255]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xfd,0x03,0x00]

v_cmp_t_u64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x09,0x00,0x00]

v_cmp_t_u64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x0d,0x00,0x00]

v_cmp_t_u64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xc9,0x00,0x00]

v_cmp_t_u64 s10, v[1:2], vcc
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_t_u64 s10, v[1:2], exec
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_t_u64 s10, v[1:2], 0
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x01,0x01,0x00]

v_cmp_t_u64 s10, v[1:2], -1
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x83,0x01,0x00]

v_cmp_t_u64 s10, v[1:2], 0.5
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_t_u64 s10, v[1:2], -4.0
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_u16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x72,0x7c]

v_cmp_eq_u16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x74,0x7c]

v_cmp_le_u16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x76,0x7c]

v_cmp_gt_u16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x78,0x7c]

v_cmp_ne_u16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x7a,0x7c]

v_cmp_ge_u16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x7c,0x7c]

v_cmp_f_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x90,0x7c]

v_cmp_lt_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x92,0x7c]

v_cmp_eq_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x94,0x7c]

v_cmp_le_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x96,0x7c]

v_cmp_gt_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x98,0x7c]

v_cmp_ne_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x9a,0x7c]

v_cmp_ge_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x9c,0x7c]

v_cmp_t_u32 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x9e,0x7c]

v_cmp_f_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x00,0x7c]

v_cmp_lt_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x02,0x7c]

v_cmp_eq_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x04,0x7c]

v_cmp_le_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x06,0x7c]

v_cmp_gt_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x08,0x7c]

v_cmp_lg_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x0a,0x7c]

v_cmp_ge_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x0c,0x7c]

v_cmp_o_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x0e,0x7c]

v_cmp_u_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x10,0x7c]

v_cmp_nge_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x12,0x7c]

v_cmp_nlg_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x14,0x7c]

v_cmp_ngt_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x16,0x7c]

v_cmp_nle_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x18,0x7c]

v_cmp_neq_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x1a,0x7c]

v_cmp_nlt_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x1c,0x7c]

v_cmp_tru_f16 vcc, v1, v2
// W64: encoding: [0x01,0x05,0x1e,0x7c]

v_cmp_lt_u16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x72,0x7c]

v_cmp_lt_u16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lt_u16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lt_u16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lt_u16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_u16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lt_u16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lt_u16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_u16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lt_u16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_u16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_u16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lt_u16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lt_u16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lt_u16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_u16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lt_u16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lt_u16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_u16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lt_u16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_u16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_u16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x74,0x7c]

v_cmp_eq_u16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0xff,0x05,0x02,0x00]

v_cmp_eq_u16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x04,0x02,0x00]

v_cmp_eq_u16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x65,0x04,0x02,0x00]

v_cmp_eq_u16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_u16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_eq_u16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_eq_u16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_u16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_eq_u16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_u16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_u16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xff,0x03,0x00]

v_cmp_eq_u16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x05,0x00,0x00]

v_cmp_eq_u16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_eq_u16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_u16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_eq_u16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_eq_u16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_u16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xff,0x00,0x00]

v_cmp_eq_u16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_u16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_u16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x76,0x7c]

v_cmp_le_u16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0xff,0x05,0x02,0x00]

v_cmp_le_u16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x04,0x02,0x00]

v_cmp_le_u16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x65,0x04,0x02,0x00]

v_cmp_le_u16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_u16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_le_u16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_le_u16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_u16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_le_u16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_u16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_u16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xff,0x03,0x00]

v_cmp_le_u16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x05,0x00,0x00]

v_cmp_le_u16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_le_u16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_u16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_le_u16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_le_u16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_u16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xff,0x00,0x00]

v_cmp_le_u16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_u16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_u16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x78,0x7c]

v_cmp_gt_u16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0xff,0x05,0x02,0x00]

v_cmp_gt_u16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x04,0x02,0x00]

v_cmp_gt_u16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x65,0x04,0x02,0x00]

v_cmp_gt_u16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_u16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_gt_u16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_gt_u16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_u16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_gt_u16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_u16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_u16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xff,0x03,0x00]

v_cmp_gt_u16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x05,0x00,0x00]

v_cmp_gt_u16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_gt_u16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_u16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_gt_u16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_gt_u16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_u16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xff,0x00,0x00]

v_cmp_gt_u16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_u16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ne_u16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x7a,0x7c]

v_cmp_ne_u16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ne_u16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ne_u16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ne_u16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ne_u16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ne_u16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ne_u16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ne_u16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ne_u16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ne_u16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ne_u16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ne_u16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ne_u16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ne_u16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ne_u16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ne_u16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ne_u16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ne_u16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ne_u16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ne_u16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_u16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x7c,0x7c]

v_cmp_ge_u16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ge_u16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ge_u16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ge_u16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_u16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ge_u16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ge_u16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_u16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ge_u16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_u16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_u16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ge_u16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ge_u16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ge_u16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_u16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ge_u16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ge_u16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_u16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ge_u16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_u16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x48,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x48,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x90,0x7c]

v_cmp_f_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0xff,0x05,0x02,0x00]

v_cmp_f_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x04,0x02,0x00]

v_cmp_f_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x65,0x04,0x02,0x00]

v_cmp_f_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_f_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_f_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_f_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_f_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_f_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xff,0x03,0x00]

v_cmp_f_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x05,0x00,0x00]

v_cmp_f_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_f_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_f_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_f_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xff,0x00,0x00]

v_cmp_f_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_f_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xef,0x01,0x00]

v_cmp_lt_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x49,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x49,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x92,0x7c]

v_cmp_lt_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lt_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lt_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lt_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lt_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lt_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lt_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_lt_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_lt_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lt_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lt_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lt_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lt_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lt_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lt_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_lt_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xef,0x01,0x00]

v_cmp_eq_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x4a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x4a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x94,0x7c]

v_cmp_eq_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0xff,0x05,0x02,0x00]

v_cmp_eq_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x04,0x02,0x00]

v_cmp_eq_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x65,0x04,0x02,0x00]

v_cmp_eq_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_eq_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_eq_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_eq_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_eq_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_eq_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xff,0x03,0x00]

v_cmp_eq_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x05,0x00,0x00]

v_cmp_eq_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_eq_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_eq_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_eq_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xff,0x00,0x00]

v_cmp_eq_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_eq_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xef,0x01,0x00]

v_cmp_le_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x4b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x4b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x96,0x7c]

v_cmp_le_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0xff,0x05,0x02,0x00]

v_cmp_le_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x04,0x02,0x00]

v_cmp_le_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x65,0x04,0x02,0x00]

v_cmp_le_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_le_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_le_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_le_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_le_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_le_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xff,0x03,0x00]

v_cmp_le_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x05,0x00,0x00]

v_cmp_le_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_le_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_le_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_le_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xff,0x00,0x00]

v_cmp_le_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_le_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xef,0x01,0x00]

v_cmp_gt_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x4c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x4c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x98,0x7c]

v_cmp_gt_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0xff,0x05,0x02,0x00]

v_cmp_gt_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x04,0x02,0x00]

v_cmp_gt_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x65,0x04,0x02,0x00]

v_cmp_gt_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_gt_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_gt_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_gt_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_gt_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_gt_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xff,0x03,0x00]

v_cmp_gt_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x05,0x00,0x00]

v_cmp_gt_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_gt_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_gt_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_gt_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xff,0x00,0x00]

v_cmp_gt_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_gt_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ne_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x4d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x4d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ne_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x9a,0x7c]

v_cmp_ne_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ne_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ne_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ne_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ne_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ne_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ne_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ne_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ne_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ne_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ne_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ne_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ne_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ne_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ne_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ne_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ne_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ne_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ne_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ne_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ne_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ne_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ne_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ne_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xef,0x01,0x00]

v_cmp_ge_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x4e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x4e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x9c,0x7c]

v_cmp_ge_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ge_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ge_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ge_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ge_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ge_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ge_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_ge_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_ge_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ge_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ge_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ge_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ge_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ge_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ge_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_ge_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xef,0x01,0x00]

v_cmp_t_u32 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_u32 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x4f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_u32 s100, v1, v2
// W32: encoding: [0x64,0x00,0x4f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_t_u32 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x9e,0x7c]

v_cmp_t_u32 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0xff,0x05,0x02,0x00]

v_cmp_t_u32 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x04,0x02,0x00]

v_cmp_t_u32 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x65,0x04,0x02,0x00]

v_cmp_t_u32 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_t_u32 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_t_u32 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_t_u32 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_t_u32 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_t_u32 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x80,0x04,0x02,0x00]

v_cmp_t_u32 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_t_u32 s10, 0.5, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0xf0,0x04,0x02,0x00]

v_cmp_t_u32 s10, -4.0, v2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0xf7,0x04,0x02,0x00]

v_cmp_t_u32 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xff,0x03,0x00]

v_cmp_t_u32 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x05,0x00,0x00]

v_cmp_t_u32 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_t_u32 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_t_u32 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_t_u32 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_t_u32 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_t_u32 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xff,0x00,0x00]

v_cmp_t_u32 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x01,0x01,0x00]

v_cmp_t_u32 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x83,0x01,0x00]

v_cmp_t_u32 s10, v1, 0.5
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xe1,0x01,0x00]

v_cmp_t_u32 s10, v1, -4.0
// W32: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xef,0x01,0x00]

v_cmp_f_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x00,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x00,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x00,0x7c]

v_cmp_f_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0xff,0x05,0x02,0x00]

v_cmp_f_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x04,0x02,0x00]

v_cmp_f_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x65,0x04,0x02,0x00]

v_cmp_f_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_f_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_f_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_f_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_f_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_f_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x80,0x04,0x02,0x00]

v_cmp_f_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_f_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xff,0x03,0x00]

v_cmp_f_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x00,0x00]

v_cmp_f_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_f_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_f_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_f_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_f_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_f_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xff,0x00,0x00]

v_cmp_f_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x01,0x01,0x00]

v_cmp_f_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x83,0x01,0x00]

v_cmp_f_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x20]

v_cmp_f_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x40]

v_cmp_f_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x60]

v_cmp_f_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x00,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x01,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x01,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lt_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x02,0x7c]

v_cmp_lt_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lt_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lt_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lt_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lt_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lt_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lt_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lt_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lt_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lt_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lt_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lt_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lt_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lt_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lt_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lt_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lt_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lt_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lt_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lt_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lt_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lt_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x40]

v_cmp_lt_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x60]

v_cmp_lt_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x01,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x02,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x02,0xd4,0x01,0x05,0x02,0x00]

v_cmp_eq_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x04,0x7c]

v_cmp_eq_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0xff,0x05,0x02,0x00]

v_cmp_eq_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x04,0x02,0x00]

v_cmp_eq_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x65,0x04,0x02,0x00]

v_cmp_eq_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_eq_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_eq_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_eq_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_eq_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_eq_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x80,0x04,0x02,0x00]

v_cmp_eq_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_eq_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xff,0x03,0x00]

v_cmp_eq_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x00,0x00]

v_cmp_eq_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_eq_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_eq_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_eq_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_eq_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_eq_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xff,0x00,0x00]

v_cmp_eq_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x01,0x01,0x00]

v_cmp_eq_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x83,0x01,0x00]

v_cmp_eq_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x20]

v_cmp_eq_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x40]

v_cmp_eq_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x60]

v_cmp_eq_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x02,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x03,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x03,0xd4,0x01,0x05,0x02,0x00]

v_cmp_le_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x06,0x7c]

v_cmp_le_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0xff,0x05,0x02,0x00]

v_cmp_le_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x04,0x02,0x00]

v_cmp_le_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x65,0x04,0x02,0x00]

v_cmp_le_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_le_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_le_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_le_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_le_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_le_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x80,0x04,0x02,0x00]

v_cmp_le_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_le_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xff,0x03,0x00]

v_cmp_le_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x00,0x00]

v_cmp_le_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_le_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_le_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_le_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_le_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_le_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xff,0x00,0x00]

v_cmp_le_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x01,0x01,0x00]

v_cmp_le_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x83,0x01,0x00]

v_cmp_le_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x20]

v_cmp_le_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x40]

v_cmp_le_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x60]

v_cmp_le_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x03,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x04,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x04,0xd4,0x01,0x05,0x02,0x00]

v_cmp_gt_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x08,0x7c]

v_cmp_gt_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0xff,0x05,0x02,0x00]

v_cmp_gt_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x04,0x02,0x00]

v_cmp_gt_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x65,0x04,0x02,0x00]

v_cmp_gt_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_gt_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_gt_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_gt_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_gt_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_gt_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x80,0x04,0x02,0x00]

v_cmp_gt_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_gt_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xff,0x03,0x00]

v_cmp_gt_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x00,0x00]

v_cmp_gt_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_gt_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_gt_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_gt_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_gt_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_gt_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xff,0x00,0x00]

v_cmp_gt_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x01,0x01,0x00]

v_cmp_gt_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x83,0x01,0x00]

v_cmp_gt_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x20]

v_cmp_gt_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x40]

v_cmp_gt_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x60]

v_cmp_gt_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x04,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x05,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x05,0xd4,0x01,0x05,0x02,0x00]

v_cmp_lg_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x0a,0x7c]

v_cmp_lg_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0xff,0x05,0x02,0x00]

v_cmp_lg_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x04,0x02,0x00]

v_cmp_lg_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x65,0x04,0x02,0x00]

v_cmp_lg_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_lg_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_lg_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_lg_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_lg_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_lg_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x80,0x04,0x02,0x00]

v_cmp_lg_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_lg_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xff,0x03,0x00]

v_cmp_lg_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x00,0x00]

v_cmp_lg_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_lg_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_lg_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_lg_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_lg_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_lg_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xff,0x00,0x00]

v_cmp_lg_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x01,0x01,0x00]

v_cmp_lg_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x83,0x01,0x00]

v_cmp_lg_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x20]

v_cmp_lg_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x40]

v_cmp_lg_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x60]

v_cmp_lg_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x05,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x06,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x06,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ge_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x0c,0x7c]

v_cmp_ge_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ge_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ge_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ge_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ge_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ge_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ge_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ge_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ge_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ge_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ge_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ge_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ge_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ge_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ge_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ge_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ge_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ge_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ge_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ge_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ge_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x20]

v_cmp_ge_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x40]

v_cmp_ge_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x60]

v_cmp_ge_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x06,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x07,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x07,0xd4,0x01,0x05,0x02,0x00]

v_cmp_o_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x0e,0x7c]

v_cmp_o_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0xff,0x05,0x02,0x00]

v_cmp_o_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x04,0x02,0x00]

v_cmp_o_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x65,0x04,0x02,0x00]

v_cmp_o_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_o_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_o_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_o_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_o_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_o_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x80,0x04,0x02,0x00]

v_cmp_o_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_o_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xff,0x03,0x00]

v_cmp_o_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x00,0x00]

v_cmp_o_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_o_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_o_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_o_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_o_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_o_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xff,0x00,0x00]

v_cmp_o_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x01,0x01,0x00]

v_cmp_o_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x83,0x01,0x00]

v_cmp_o_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x20]

v_cmp_o_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x40]

v_cmp_o_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x60]

v_cmp_o_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x07,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x08,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x08,0xd4,0x01,0x05,0x02,0x00]

v_cmp_u_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x10,0x7c]

v_cmp_u_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0xff,0x05,0x02,0x00]

v_cmp_u_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x04,0x02,0x00]

v_cmp_u_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x65,0x04,0x02,0x00]

v_cmp_u_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_u_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_u_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_u_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_u_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_u_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x80,0x04,0x02,0x00]

v_cmp_u_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_u_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xff,0x03,0x00]

v_cmp_u_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x00,0x00]

v_cmp_u_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_u_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_u_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_u_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_u_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_u_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xff,0x00,0x00]

v_cmp_u_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x01,0x01,0x00]

v_cmp_u_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x83,0x01,0x00]

v_cmp_u_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x20]

v_cmp_u_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x40]

v_cmp_u_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x60]

v_cmp_u_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x08,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x09,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x09,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nge_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x12,0x7c]

v_cmp_nge_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nge_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nge_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nge_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nge_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nge_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nge_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nge_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nge_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nge_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nge_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nge_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nge_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nge_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nge_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nge_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nge_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nge_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nge_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nge_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nge_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nge_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nge_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nge_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x09,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x0a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x0a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x14,0x7c]

v_cmp_nlg_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nlg_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nlg_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nlg_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nlg_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nlg_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nlg_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nlg_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nlg_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nlg_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nlg_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nlg_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nlg_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x0a,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x0b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x0b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x16,0x7c]

v_cmp_ngt_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0xff,0x05,0x02,0x00]

v_cmp_ngt_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x65,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x80,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xff,0x03,0x00]

v_cmp_ngt_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x00,0x00]

v_cmp_ngt_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_ngt_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_ngt_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_ngt_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xff,0x00,0x00]

v_cmp_ngt_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x01,0x01,0x00]

v_cmp_ngt_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x83,0x01,0x00]

v_cmp_ngt_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x20]

v_cmp_ngt_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x40]

v_cmp_ngt_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x60]

v_cmp_ngt_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x0b,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x0c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x0c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nle_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x18,0x7c]

v_cmp_nle_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nle_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nle_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nle_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nle_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nle_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nle_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nle_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nle_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nle_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nle_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nle_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nle_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nle_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nle_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nle_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nle_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nle_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nle_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nle_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nle_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nle_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nle_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nle_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x0c,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x0d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x0d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_neq_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x1a,0x7c]

v_cmp_neq_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0xff,0x05,0x02,0x00]

v_cmp_neq_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x04,0x02,0x00]

v_cmp_neq_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x65,0x04,0x02,0x00]

v_cmp_neq_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_neq_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_neq_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_neq_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_neq_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_neq_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x80,0x04,0x02,0x00]

v_cmp_neq_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_neq_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xff,0x03,0x00]

v_cmp_neq_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x00,0x00]

v_cmp_neq_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_neq_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_neq_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_neq_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_neq_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_neq_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xff,0x00,0x00]

v_cmp_neq_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x01,0x01,0x00]

v_cmp_neq_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x83,0x01,0x00]

v_cmp_neq_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x20]

v_cmp_neq_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x40]

v_cmp_neq_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x60]

v_cmp_neq_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x0d,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x0e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x0e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x1c,0x7c]

v_cmp_nlt_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0xff,0x05,0x02,0x00]

v_cmp_nlt_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x65,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x80,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xff,0x03,0x00]

v_cmp_nlt_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x00,0x00]

v_cmp_nlt_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_nlt_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_nlt_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_nlt_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xff,0x00,0x00]

v_cmp_nlt_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x01,0x01,0x00]

v_cmp_nlt_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x83,0x01,0x00]

v_cmp_nlt_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x20]

v_cmp_nlt_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x40]

v_cmp_nlt_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x60]

v_cmp_nlt_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x0e,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f16 s10, v1, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f16 s12, v1, v2
// W32: encoding: [0x0c,0x00,0x0f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f16 s100, v1, v2
// W32: encoding: [0x64,0x00,0x0f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_tru_f16 vcc_lo, v1, v2
// W32: encoding: [0x01,0x05,0x1e,0x7c]

v_cmp_tru_f16 s10, v255, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0xff,0x05,0x02,0x00]

v_cmp_tru_f16 s10, s1, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x04,0x02,0x00]

v_cmp_tru_f16 s10, s101, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x65,0x04,0x02,0x00]

v_cmp_tru_f16 s10, vcc_lo, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x6a,0x04,0x02,0x00]

v_cmp_tru_f16 s10, vcc_hi, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x6b,0x04,0x02,0x00]

v_cmp_tru_f16 s10, m0, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x7d,0x04,0x02,0x00]

v_cmp_tru_f16 s10, exec_lo, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x7e,0x04,0x02,0x00]

v_cmp_tru_f16 s10, exec_hi, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x7f,0x04,0x02,0x00]

v_cmp_tru_f16 s10, 0, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x80,0x04,0x02,0x00]

v_cmp_tru_f16 s10, -1, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0xc1,0x04,0x02,0x00]

v_cmp_tru_f16 s10, v1, v255
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xff,0x03,0x00]

v_cmp_tru_f16 s10, v1, s2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x00,0x00]

v_cmp_tru_f16 s10, v1, s101
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xcb,0x00,0x00]

v_cmp_tru_f16 s10, v1, vcc_lo
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xd5,0x00,0x00]

v_cmp_tru_f16 s10, v1, vcc_hi
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xd7,0x00,0x00]

v_cmp_tru_f16 s10, v1, m0
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xfb,0x00,0x00]

v_cmp_tru_f16 s10, v1, exec_lo
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xfd,0x00,0x00]

v_cmp_tru_f16 s10, v1, exec_hi
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xff,0x00,0x00]

v_cmp_tru_f16 s10, v1, 0
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x01,0x01,0x00]

v_cmp_tru_f16 s10, v1, -1
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x83,0x01,0x00]

v_cmp_tru_f16 s10, -v1, v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x20]

v_cmp_tru_f16 s10, v1, -v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x40]

v_cmp_tru_f16 s10, -v1, -v2
// W32: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x60]

v_cmp_tru_f16 s10, v1, v2 clamp
// W32: encoding: [0x0a,0x80,0x0f,0xd4,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x10,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x10,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x10,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x11,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x11,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x11,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x12,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x12,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x12,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x13,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x13,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x13,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x14,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x14,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x14,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x15,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x15,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x15,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x16,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x16,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x16,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x17,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x17,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x17,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x18,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x18,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x18,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x19,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x19,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x19,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x1a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x1a,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x1a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x1b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x1b,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x1b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x1c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x1c,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x1c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x1d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x1d,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x1d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x1e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x1e,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x1e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x1f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x1f,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x1f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x20,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x20,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x20,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x20,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x21,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x21,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x21,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x21,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x22,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x22,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x22,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x22,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x23,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x23,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x23,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x23,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x24,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x24,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x24,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x24,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x25,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x25,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x25,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x25,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x26,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x26,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x26,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x26,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x27,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x27,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x27,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x27,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x28,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x28,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x28,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x28,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x29,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x29,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x29,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x29,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x2a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x2a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x2a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2a,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x2b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x2b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x2b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2b,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x2c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x2c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x2c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2c,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x2d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x2d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x2d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2d,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x2e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x2e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x2e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2e,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x2f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x2f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// W64: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// W64: encoding: [0x0a,0x80,0x2f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x2f,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x40,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x40,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x40,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x41,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x41,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x41,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x42,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x42,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x42,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x43,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x43,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x43,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x44,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x44,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x44,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x45,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x45,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x45,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x46,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x46,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x46,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x47,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x47,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x47,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x7e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x7e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x7e,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x31,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x31,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x32,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x32,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x33,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x33,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x34,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x34,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x35,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x35,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x36,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x36,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x7d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x7d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x7d,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x50,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x50,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x51,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x51,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x52,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x52,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x53,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x53,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x54,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x54,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x55,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x55,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x56,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x56,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x57,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x57,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[12:13], v[1:2], v2
// W64: encoding: [0x0c,0x00,0x7f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[100:101], v[1:2], v2
// W64: encoding: [0x64,0x00,0x7f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[254:255], v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], s[2:3], v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], s[4:5], v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], s[100:101], v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], vcc, v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], exec, v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], v255
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], s2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], s101
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], vcc_lo
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], vcc_hi
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], m0
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], exec_lo
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], exec_hi
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s[10:11], -v[1:2], v2
// W64: encoding: [0x0a,0x00,0x7f,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x58,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x58,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x59,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x59,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x5a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x5a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x5b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x5b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x5c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x5c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x5d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x5d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x5e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x5e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[12:13], v[1:2], v[2:3]
// W64: encoding: [0x0c,0x00,0x5f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[100:101], v[1:2], v[2:3]
// W64: encoding: [0x64,0x00,0x5f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[254:255], v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0xfe,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], s[2:3], v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x02,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], s[4:5], v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x04,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], s[100:101], v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x64,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], vcc, v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], exec, v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], 0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], -1, v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], 0.5, v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], -4.0, v[2:3]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], v[254:255]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xfd,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], s[4:5]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x09,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], s[6:7]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x0d,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], s[100:101]
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xc9,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], vcc
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], exec
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], 0
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], -1
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], 0.5
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s[10:11], v[1:2], -4.0
// W64: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x50,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x51,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x52,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x53,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x54,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x55,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x56,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x57,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s10, s[2:3], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s10, s[4:5], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f64_e64 s10, s[100:101], v2
// W32: encoding: [0x0a,0x00,0x7f,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x58,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x59,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5a,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5b,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5c,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5d,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5e,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s10, s[2:3], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x02,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s10, s[4:5], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x04,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s10, s[100:101], v[2:3]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x64,0x04,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s10, v[1:2], s[4:5]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x09,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s10, v[1:2], s[6:7]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0x0d,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u64_e64 s10, v[1:2], s[100:101]
// W32: encoding: [0x0a,0x00,0x5f,0xd4,0x01,0xc9,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x39,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x39,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x3a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x3a,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x3b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x3b,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x3c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x3c,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x3d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x3d,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x3e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0xff,0x04,0x02,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0xff,0x04,0x02,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xff,0x01,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x3e,0xd4,0x01,0xff,0x01,0x00,0x00,0xc4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x48,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x48,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x48,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x49,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x49,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x49,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x4a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x4a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x4a,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x4b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x4b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x4b,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x4c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x4c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x4c,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x4d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x4d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x4d,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x4e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x4e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x4e,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x4f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x4f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x4f,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x00,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x00,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x00,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x00,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x01,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x01,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x01,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x01,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x02,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x02,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x02,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x02,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x03,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x03,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x03,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x03,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x04,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x04,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x04,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x04,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x05,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x05,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x05,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x05,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x06,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x06,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x06,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x06,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x07,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x07,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x07,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x07,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x08,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x08,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x08,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x08,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x09,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x09,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x09,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x09,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x0a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x0a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x0a,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x0a,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x0b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x0b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x0b,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x0b,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x0c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x0c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x0c,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x0c,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x0d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x0d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x0d,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x0d,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x0e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x0e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x0e,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x0e,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[12:13], v1, v2
// W64: encoding: [0x0c,0x00,0x0f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[100:101], v1, v2
// W64: encoding: [0x64,0x00,0x0f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v255, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0xff,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], s1, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], s101, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x65,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], vcc_lo, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x6a,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], vcc_hi, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x6b,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], m0, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x7d,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], exec_lo, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x7e,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], exec_hi, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x7f,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], 0, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x80,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], -1, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0xc1,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], 0.5, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0xf0,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], -4.0, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0xf7,0x04,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, v255
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, s2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, s101
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xcb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, vcc_lo
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xd5,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, vcc_hi
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xd7,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, m0
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xfb,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, exec_lo
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xfd,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, exec_hi
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xff,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, 0
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x01,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, -1
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x83,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, 0.5
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, -4.0
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0xef,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], -v1, v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x20]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, -v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x40]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], -v1, -v2
// W64: encoding: [0x0a,0x00,0x0f,0xd4,0x01,0x05,0x02,0x60]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64 s[10:11], v1, v2 clamp
// W64: encoding: [0x0a,0x80,0x0f,0xd4,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

