; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i64_stride3_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i64_stride3_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd (%rdi), %xmm0
; SSE-NEXT:    movapd 16(%rdi), %xmm1
; SSE-NEXT:    movapd 32(%rdi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm0[0],xmm3[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm2[0]
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm1[0],xmm2[1]
; SSE-NEXT:    movapd %xmm3, (%rsi)
; SSE-NEXT:    movapd %xmm0, (%rdx)
; SSE-NEXT:    movapd %xmm2, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i64_stride3_vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm0[0,1,2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],mem[4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX1-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX1-NEXT:    vmovdqa %xmm1, (%rcx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride3_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0,1],xmm1[2,3]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX2-NEXT:    vmovdqa %xmm1, (%rcx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride3_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0,1],xmm1[2,3]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3]
; AVX512-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm1, (%rcx)
; AVX512-NEXT:    retq
  %wide.vec = load <6 x i64>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <6 x i64> %wide.vec, <6 x i64> poison, <2 x i32> <i32 0, i32 3>
  %strided.vec1 = shufflevector <6 x i64> %wide.vec, <6 x i64> poison, <2 x i32> <i32 1, i32 4>
  %strided.vec2 = shufflevector <6 x i64> %wide.vec, <6 x i64> poison, <2 x i32> <i32 2, i32 5>

  store <2 x i64> %strided.vec0, ptr %out.vec0, align 32
  store <2 x i64> %strided.vec1, ptr %out.vec1, align 32
  store <2 x i64> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i64_stride3_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i64_stride3_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd 80(%rdi), %xmm0
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    movapd 16(%rdi), %xmm2
; SSE-NEXT:    movapd 32(%rdi), %xmm3
; SSE-NEXT:    movapd 48(%rdi), %xmm4
; SSE-NEXT:    movapd 64(%rdi), %xmm5
; SSE-NEXT:    movapd %xmm5, %xmm6
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm4[0],xmm6[1]
; SSE-NEXT:    movapd %xmm2, %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm1[0],xmm7[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm0[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm3[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm5[0],xmm0[1]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm2[0],xmm3[1]
; SSE-NEXT:    movapd %xmm6, 16(%rsi)
; SSE-NEXT:    movapd %xmm7, (%rsi)
; SSE-NEXT:    movapd %xmm4, 16(%rdx)
; SSE-NEXT:    movapd %xmm1, (%rdx)
; SSE-NEXT:    movapd %xmm0, 16(%rcx)
; SSE-NEXT:    movapd %xmm3, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i64_stride3_vf4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovapd 32(%rdi), %ymm0
; AVX1-NEXT:    vmovapd (%rdi), %ymm1
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm1[0,1],ymm0[2],ymm1[3]
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm3
; AVX1-NEXT:    vinsertf128 $1, 64(%rdi), %ymm3, %ymm3
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm0[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],ymm0[0],ymm1[3],ymm0[2]
; AVX1-NEXT:    vbroadcastsd 80(%rdi), %ymm4
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0],ymm0[1],ymm3[2],ymm0[3]
; AVX1-NEXT:    vmovapd %ymm2, (%rsi)
; AVX1-NEXT:    vmovapd %ymm1, (%rdx)
; AVX1-NEXT:    vmovapd %ymm0, (%rcx)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride3_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-NEXT:    vinsertf128 $1, 64(%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm1[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm0[4,5],ymm3[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 80(%rdi), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride3_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,3,6,9]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,4,7,10]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [2,5,8,11]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm4
; AVX512-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <12 x i64>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <12 x i64> %wide.vec, <12 x i64> poison, <4 x i32> <i32 0, i32 3, i32 6, i32 9>
  %strided.vec1 = shufflevector <12 x i64> %wide.vec, <12 x i64> poison, <4 x i32> <i32 1, i32 4, i32 7, i32 10>
  %strided.vec2 = shufflevector <12 x i64> %wide.vec, <12 x i64> poison, <4 x i32> <i32 2, i32 5, i32 8, i32 11>

  store <4 x i64> %strided.vec0, ptr %out.vec0, align 32
  store <4 x i64> %strided.vec1, ptr %out.vec1, align 32
  store <4 x i64> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i64_stride3_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i64_stride3_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd 128(%rdi), %xmm14
; SSE-NEXT:    movapd 176(%rdi), %xmm13
; SSE-NEXT:    movapd 80(%rdi), %xmm12
; SSE-NEXT:    movapd 96(%rdi), %xmm4
; SSE-NEXT:    movapd 112(%rdi), %xmm8
; SSE-NEXT:    movapd 144(%rdi), %xmm3
; SSE-NEXT:    movapd 160(%rdi), %xmm9
; SSE-NEXT:    movapd (%rdi), %xmm6
; SSE-NEXT:    movapd 16(%rdi), %xmm10
; SSE-NEXT:    movapd 32(%rdi), %xmm5
; SSE-NEXT:    movapd 48(%rdi), %xmm7
; SSE-NEXT:    movapd 64(%rdi), %xmm11
; SSE-NEXT:    movapd %xmm11, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm7[0],xmm15[1]
; SSE-NEXT:    movapd %xmm9, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm3[0],xmm1[1]
; SSE-NEXT:    movapd %xmm8, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm4[0],xmm2[1]
; SSE-NEXT:    movapd %xmm10, %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm6[0],xmm0[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm12[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm3 = xmm3[1],xmm13[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm14[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm5[0]
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm11[0],xmm12[1]
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm9[0],xmm13[1]
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm8[0],xmm14[1]
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm10[0],xmm5[1]
; SSE-NEXT:    movapd %xmm2, 32(%rsi)
; SSE-NEXT:    movapd %xmm0, (%rsi)
; SSE-NEXT:    movapd %xmm1, 48(%rsi)
; SSE-NEXT:    movapd %xmm15, 16(%rsi)
; SSE-NEXT:    movapd %xmm4, 32(%rdx)
; SSE-NEXT:    movapd %xmm6, (%rdx)
; SSE-NEXT:    movapd %xmm3, 48(%rdx)
; SSE-NEXT:    movapd %xmm7, 16(%rdx)
; SSE-NEXT:    movapd %xmm14, 32(%rcx)
; SSE-NEXT:    movapd %xmm5, (%rcx)
; SSE-NEXT:    movapd %xmm13, 48(%rcx)
; SSE-NEXT:    movapd %xmm12, 16(%rcx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i64_stride3_vf8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovapd 32(%rdi), %ymm0
; AVX1-NEXT:    vmovapd (%rdi), %ymm1
; AVX1-NEXT:    vmovapd 128(%rdi), %ymm2
; AVX1-NEXT:    vmovapd 96(%rdi), %ymm3
; AVX1-NEXT:    vblendpd {{.*#+}} ymm4 = ymm3[0,1],ymm2[2],ymm3[3]
; AVX1-NEXT:    vmovaps 112(%rdi), %xmm5
; AVX1-NEXT:    vinsertf128 $1, 160(%rdi), %ymm5, %ymm5
; AVX1-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2],ymm5[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm6 = ymm1[0,1],ymm0[2],ymm1[3]
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm7
; AVX1-NEXT:    vinsertf128 $1, 64(%rdi), %ymm7, %ymm7
; AVX1-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm0[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],ymm0[0],ymm1[3],ymm0[2]
; AVX1-NEXT:    vbroadcastsd 80(%rdi), %ymm8
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1,2],ymm8[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm2[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[1],ymm2[0],ymm3[3],ymm2[2]
; AVX1-NEXT:    vbroadcastsd 176(%rdi), %ymm8
; AVX1-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1,2],ymm8[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm7[0],ymm0[1],ymm7[2],ymm0[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm5[0],ymm2[1],ymm5[2],ymm2[3]
; AVX1-NEXT:    vmovapd %ymm6, (%rsi)
; AVX1-NEXT:    vmovapd %ymm4, 32(%rsi)
; AVX1-NEXT:    vmovapd %ymm3, 32(%rdx)
; AVX1-NEXT:    vmovapd %ymm1, (%rdx)
; AVX1-NEXT:    vmovapd %ymm2, 32(%rcx)
; AVX1-NEXT:    vmovapd %ymm0, (%rcx)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride3_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm2
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm4
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm3[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm2[4,5],ymm5[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vinsertf128 $1, 64(%rdi), %ymm0, %ymm5
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm1[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm0[4,5],ymm6[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 80(%rdi), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm3[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 176(%rdi), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vmovaps 16(%rdi), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovaps 112(%rdi), %xmm3
; AVX2-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX2-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm3, 32(%rcx)
; AVX2-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride3_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqu64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <0,3,6,9,12,15,u,u>
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,3,4,5,10,13]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <1,4,7,10,13,u,u,u>
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [0,1,2,3,4,8,11,14]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <10,13,0,3,6,u,u,u>
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,2,3,4,9,12,15]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm4, (%rsi)
; AVX512-NEXT:    vmovdqu64 %zmm5, (%rdx)
; AVX512-NEXT:    vmovdqu64 %zmm0, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <24 x i64>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <24 x i64> %wide.vec, <24 x i64> poison, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %strided.vec1 = shufflevector <24 x i64> %wide.vec, <24 x i64> poison, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %strided.vec2 = shufflevector <24 x i64> %wide.vec, <24 x i64> poison, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>

  store <8 x i64> %strided.vec0, ptr %out.vec0, align 32
  store <8 x i64> %strided.vec1, ptr %out.vec1, align 32
  store <8 x i64> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i64_stride3_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i64_stride3_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps 224(%rdi), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdi), %xmm0
; SSE-NEXT:    movapd 272(%rdi), %xmm6
; SSE-NEXT:    movapd 176(%rdi), %xmm5
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 192(%rdi), %xmm7
; SSE-NEXT:    movapd 208(%rdi), %xmm11
; SSE-NEXT:    movapd 96(%rdi), %xmm8
; SSE-NEXT:    movapd 112(%rdi), %xmm12
; SSE-NEXT:    movapd 240(%rdi), %xmm4
; SSE-NEXT:    movapd 256(%rdi), %xmm13
; SSE-NEXT:    movapd 144(%rdi), %xmm15
; SSE-NEXT:    movapd 160(%rdi), %xmm9
; SSE-NEXT:    movapd 48(%rdi), %xmm14
; SSE-NEXT:    movapd 64(%rdi), %xmm3
; SSE-NEXT:    movapd %xmm3, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm14[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm14 = xmm14[1],xmm1[0]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm3[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm9, %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm15[0],xmm10[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm15 = xmm15[1],xmm5[0]
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm9[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm12, %xmm9
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm8[0],xmm9[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm8 = xmm8[1],xmm0[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm12[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm13, %xmm12
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm4[0],xmm12[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm6[0]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm13[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm11, %xmm13
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm7[0],xmm13[1]
; SSE-NEXT:    movapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm0[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm11[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm11
; SSE-NEXT:    movapd 352(%rdi), %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm8
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm11[0],xmm8[1]
; SSE-NEXT:    movapd 368(%rdi), %xmm6
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm6[0]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm1[0],xmm6[1]
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    movapd 304(%rdi), %xmm4
; SSE-NEXT:    movapd %xmm4, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm1[0],xmm2[1]
; SSE-NEXT:    movapd 320(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm0[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    movapd (%rdi), %xmm4
; SSE-NEXT:    movapd 16(%rdi), %xmm7
; SSE-NEXT:    movapd %xmm7, %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm4[0],xmm5[1]
; SSE-NEXT:    movapd 32(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm3[0]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm7[0],xmm3[1]
; SSE-NEXT:    movapd %xmm2, 96(%rsi)
; SSE-NEXT:    movapd %xmm13, 64(%rsi)
; SSE-NEXT:    movapd %xmm9, 32(%rsi)
; SSE-NEXT:    movapd %xmm5, (%rsi)
; SSE-NEXT:    movapd %xmm8, 112(%rsi)
; SSE-NEXT:    movapd %xmm12, 80(%rsi)
; SSE-NEXT:    movapd %xmm10, 48(%rsi)
; SSE-NEXT:    movaps (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rsi)
; SSE-NEXT:    movapd %xmm1, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 32(%rdx)
; SSE-NEXT:    movapd %xmm4, (%rdx)
; SSE-NEXT:    movapd %xmm11, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 80(%rdx)
; SSE-NEXT:    movapd %xmm15, 48(%rdx)
; SSE-NEXT:    movapd %xmm14, 16(%rdx)
; SSE-NEXT:    movapd %xmm0, 96(%rcx)
; SSE-NEXT:    movapd %xmm6, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movapd %xmm3, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i64_stride3_vf16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovapd 224(%rdi), %ymm0
; AVX1-NEXT:    vmovapd 192(%rdi), %ymm1
; AVX1-NEXT:    vmovapd 320(%rdi), %ymm2
; AVX1-NEXT:    vmovapd 288(%rdi), %ymm3
; AVX1-NEXT:    vmovapd 32(%rdi), %ymm4
; AVX1-NEXT:    vmovapd (%rdi), %ymm5
; AVX1-NEXT:    vmovapd 128(%rdi), %ymm6
; AVX1-NEXT:    vmovapd 96(%rdi), %ymm8
; AVX1-NEXT:    vblendpd {{.*#+}} ymm7 = ymm8[0,1],ymm6[2],ymm8[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm9 = ymm1[0,1],ymm0[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[1],ymm0[0],ymm9[3],ymm0[2]
; AVX1-NEXT:    vbroadcastsd 272(%rdi), %ymm10
; AVX1-NEXT:    vblendpd {{.*#+}} ymm9 = ymm9[0,1,2],ymm10[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm8 = ymm8[0,1],ymm6[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm8 = ymm8[1],ymm6[0],ymm8[3],ymm6[2]
; AVX1-NEXT:    vbroadcastsd 176(%rdi), %ymm10
; AVX1-NEXT:    vblendpd {{.*#+}} ymm8 = ymm8[0,1,2],ymm10[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm10 = ymm5[0,1],ymm4[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm10 = ymm10[1],ymm4[0],ymm10[3],ymm4[2]
; AVX1-NEXT:    vbroadcastsd 80(%rdi), %ymm11
; AVX1-NEXT:    vblendpd {{.*#+}} ymm10 = ymm10[0,1,2],ymm11[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm11 = ymm3[0,1],ymm2[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm11 = ymm11[1],ymm2[0],ymm11[3],ymm2[2]
; AVX1-NEXT:    vbroadcastsd 368(%rdi), %ymm12
; AVX1-NEXT:    vblendpd {{.*#+}} ymm11 = ymm11[0,1,2],ymm12[3]
; AVX1-NEXT:    vmovaps 112(%rdi), %xmm12
; AVX1-NEXT:    vinsertf128 $1, 160(%rdi), %ymm12, %ymm12
; AVX1-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0],ymm12[1],ymm7[2],ymm12[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm4[2],ymm5[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm6 = ymm12[0],ymm6[1],ymm12[2],ymm6[3]
; AVX1-NEXT:    vmovaps 16(%rdi), %xmm12
; AVX1-NEXT:    vinsertf128 $1, 64(%rdi), %ymm12, %ymm12
; AVX1-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0],ymm12[1],ymm5[2],ymm12[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm2[2],ymm3[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm4 = ymm12[0],ymm4[1],ymm12[2],ymm4[3]
; AVX1-NEXT:    vmovaps 304(%rdi), %xmm12
; AVX1-NEXT:    vinsertf128 $1, 352(%rdi), %ymm12, %ymm12
; AVX1-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0],ymm12[1],ymm3[2],ymm12[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm0[2],ymm1[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm12[0],ymm2[1],ymm12[2],ymm2[3]
; AVX1-NEXT:    vmovaps 208(%rdi), %xmm12
; AVX1-NEXT:    vinsertf128 $1, 256(%rdi), %ymm12, %ymm12
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm12[1],ymm1[2],ymm12[3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2,3]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm12[0],ymm0[1],ymm12[2],ymm0[3]
; AVX1-NEXT:    vmovapd %ymm1, 64(%rsi)
; AVX1-NEXT:    vmovapd %ymm3, 96(%rsi)
; AVX1-NEXT:    vmovapd %ymm5, (%rsi)
; AVX1-NEXT:    vmovapd %ymm7, 32(%rsi)
; AVX1-NEXT:    vmovapd %ymm11, 96(%rdx)
; AVX1-NEXT:    vmovapd %ymm10, (%rdx)
; AVX1-NEXT:    vmovapd %ymm8, 32(%rdx)
; AVX1-NEXT:    vmovapd %ymm9, 64(%rdx)
; AVX1-NEXT:    vmovapd %ymm0, 64(%rcx)
; AVX1-NEXT:    vmovapd %ymm2, 96(%rcx)
; AVX1-NEXT:    vmovapd %ymm4, (%rcx)
; AVX1-NEXT:    vmovapd %ymm6, 32(%rcx)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride3_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-NEXT:    vmovaps 320(%rdi), %ymm6
; AVX2-NEXT:    vmovaps 288(%rdi), %ymm7
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm8
; AVX2-NEXT:    vmovaps (%rdi), %ymm9
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm10
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm11
; AVX2-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm11[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5],ymm1[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vinsertf128 $1, 64(%rdi), %ymm0, %ymm1
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm9[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5],ymm2[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vinsertf128 $1, 352(%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm7[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5],ymm4[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vinsertf128 $1, 256(%rdi), %ymm0, %ymm4
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm5[0,3,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm3[4,5],ymm12[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm12[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 272(%rdi), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 176(%rdi), %ymm10
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm10[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm8 = ymm8[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 80(%rdi), %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm9[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm7[2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vpermilps {{.*#+}} ymm6 = ymm6[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vbroadcastsd 368(%rdi), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vmovaps 112(%rdi), %xmm7
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vmovaps 16(%rdi), %xmm0
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vmovaps 304(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vmovaps 208(%rdi), %xmm2
; AVX2-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = mem[0,1,0,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm4, 64(%rsi)
; AVX2-NEXT:    vmovaps %ymm15, 96(%rsi)
; AVX2-NEXT:    vmovaps %ymm14, (%rsi)
; AVX2-NEXT:    vmovaps %ymm13, 32(%rsi)
; AVX2-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-NEXT:    vmovaps %ymm8, (%rdx)
; AVX2-NEXT:    vmovaps %ymm5, 32(%rdx)
; AVX2-NEXT:    vmovaps %ymm3, 64(%rdx)
; AVX2-NEXT:    vmovaps %ymm2, 64(%rcx)
; AVX2-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-NEXT:    vmovaps %ymm7, 32(%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride3_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqu64 320(%rdi), %zmm0
; AVX512-NEXT:    vmovdqu64 256(%rdi), %zmm1
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm3
; AVX512-NEXT:    vmovdqu64 128(%rdi), %zmm4
; AVX512-NEXT:    vmovdqu64 192(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,3,6,9,12,15,u,u>
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm7
; AVX512-NEXT:    vpermt2q %zmm1, %zmm6, %zmm7
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,2,3,4,5,10,13]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm8, %zmm7
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512-NEXT:    vpermt2q %zmm4, %zmm8, %zmm6
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <1,4,7,10,13,u,u,u>
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512-NEXT:    vpermt2q %zmm1, %zmm8, %zmm9
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm10 = [0,1,2,3,4,8,11,14]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm10, %zmm9
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512-NEXT:    vpermt2q %zmm4, %zmm10, %zmm8
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <10,13,0,3,6,u,u,u>
; AVX512-NEXT:    vpermt2q %zmm5, %zmm10, %zmm1
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [0,1,2,3,4,9,12,15]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm5, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm10, %zmm3
; AVX512-NEXT:    vpermt2q %zmm4, %zmm5, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm7, 64(%rsi)
; AVX512-NEXT:    vmovdqu64 %zmm6, (%rsi)
; AVX512-NEXT:    vmovdqu64 %zmm9, 64(%rdx)
; AVX512-NEXT:    vmovdqu64 %zmm8, (%rdx)
; AVX512-NEXT:    vmovdqu64 %zmm1, 64(%rcx)
; AVX512-NEXT:    vmovdqu64 %zmm3, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <48 x i64>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <48 x i64> %wide.vec, <48 x i64> poison, <16 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21, i32 24, i32 27, i32 30, i32 33, i32 36, i32 39, i32 42, i32 45>
  %strided.vec1 = shufflevector <48 x i64> %wide.vec, <48 x i64> poison, <16 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22, i32 25, i32 28, i32 31, i32 34, i32 37, i32 40, i32 43, i32 46>
  %strided.vec2 = shufflevector <48 x i64> %wide.vec, <48 x i64> poison, <16 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23, i32 26, i32 29, i32 32, i32 35, i32 38, i32 41, i32 44, i32 47>

  store <16 x i64> %strided.vec0, ptr %out.vec0, align 32
  store <16 x i64> %strided.vec1, ptr %out.vec1, align 32
  store <16 x i64> %strided.vec2, ptr %out.vec2, align 32

  ret void
}
