/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_jk.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  double t174, t181, t183, t189, t192, t196, t197, t198;
  double t199, t200, t203, t204, t205, t210, t212, t215;
  double t216, t219, t222, t225, t226, t229, t230, t231;
  double t235, t236, t237, t238, t239, t246, t247, t251;
  double t254, t255, t256, t259, t264, tv2rho20, t277, t280;
  double t281, t282, t286, t287, t295, t296, t298, t303;
  double t304, t305, t308, t311, t312, t316, t317, t318;
  double t322, t326, t327, t328, t331, t336, tv2rhosigma0, t339;
  double t344, t345, t346, t348, t352, t355, tv2rholapl0, tv2rhotau0;
  double t362, t363, t364, t367, t373, t376, t379, t382;
  double t383, t386, t387, t388, t391, t392, t393, t397;
  double t398, t399, t402, t403, t404, t407, t411, tv2sigma20;
  double t414, t418, t421, tv2sigmalapl0, tv2sigmatau0, t423, t426, t428;
  double t431, tv2lapl20, tv2lapltau0, tv2tau20;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t174 = t18 * t53;
  t181 = t32 * t32;
  t183 = 0.1e1 / t33 / t181;
  t189 = t96 * t104;
  t192 = t96 * t122;
  t196 = 0.1e1 / t87 / t47;
  t197 = t196 * t61;
  t198 = t103 * t103;
  t199 = t197 * t198;
  t200 = t86 * t199;
  t203 = t86 * t88;
  t204 = t109 * t103;
  t205 = t204 * t121;
  t210 = 0.1e1 / t19 / t76;
  t212 = t29 * t210 * t44;
  t215 = t30 * t183;
  t216 = t215 * t99;
  t219 = t36 * t148;
  t222 = 0.1e1 / t19 / t181 / t76;
  t225 = 0.1e1 / t98 / t97;
  t226 = t29 * t222 * t225;
  t229 = 0.28e2 / 0.9e1 * t38 * t212 + 0.2e2 / 0.3e1 * t95 * t216 - 0.32e2 / 0.9e1 * t219 * t226;
  t230 = t89 * t229;
  t231 = t86 * t230;
  t235 = 0.1e1 / t108 / t60;
  t236 = t48 * t235;
  t237 = t121 * t121;
  t238 = t236 * t237;
  t239 = t86 * t238;
  t246 = 0.88e2 / 0.9e1 * t31 * t183 - 0.4e2 / 0.9e1 * t51 * t78;
  t247 = t246 * t56;
  t251 = t29 * t33;
  t254 = t247 * t58 + 0.16e2 / 0.3e1 * t116 * t118 + 0.4e2 / 0.9e1 * t57 * t251;
  t255 = t110 * t254;
  t256 = t86 * t255;
  t259 = 0.176e3 / 0.81e2 * t28 * t31 * t183 * t48 * t61 + 0.32e2 / 0.27e2 * t85 * t189 + 0.32e2 / 0.27e2 * t85 * t192 + 0.4e1 / 0.9e1 * t85 * t200 + 0.4e1 / 0.9e1 * t85 * t203 * t205 - 0.2e1 / 0.9e1 * t85 * t231 + 0.4e1 / 0.9e1 * t85 * t239 - 0.2e1 / 0.9e1 * t85 * t256;
  t264 = my_piecewise3(t3, 0, t7 * t174 * t66 / 0.12e2 - t7 * t72 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t259);
  tv2rho20 = 0.2e1 * rho[0] * t264 + 0.4e1 * t131;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t277 = t96 * t144;
  t280 = t86 * t196;
  t281 = t61 * t143;
  t282 = t281 * t103;
  t286 = t109 * t143;
  t287 = t286 * t121;
  t295 = t36 * t29;
  t296 = t181 * t32;
  t298 = 0.1e1 / t19 / t296;
  t303 = -0.2e1 / 0.3e1 * t138 * t93 - 0.2e1 * t36 * t100 + 0.4e1 / 0.3e1 * t295 * t298 * t225 * sigma[0];
  t304 = t89 * t303;
  t305 = t86 * t304;
  t308 = t96 * t153;
  t311 = t109 * t152;
  t312 = t311 * t103;
  t316 = t86 * t48;
  t317 = t235 * t152;
  t318 = t317 * t121;
  t322 = t115 * t149;
  t326 = -t322 * t58 - 0.8e1 / 0.3e1 * t150 * t118;
  t327 = t110 * t326;
  t328 = t86 * t327;
  t331 = -0.16e2 / 0.27e2 * t28 * t96 * t134 - 0.2e1 / 0.9e1 * t28 * t105 - 0.2e1 / 0.9e1 * t28 * t123 + 0.16e2 / 0.27e2 * t85 * t277 + 0.4e1 / 0.9e1 * t85 * t280 * t282 + 0.2e1 / 0.9e1 * t85 * t203 * t287 - 0.2e1 / 0.9e1 * t85 * t305 + 0.16e2 / 0.27e2 * t85 * t308 + 0.2e1 / 0.9e1 * t85 * t203 * t312 + 0.4e1 / 0.9e1 * t85 * t316 * t318 - 0.2e1 / 0.9e1 * t85 * t328;
  t336 = my_piecewise3(t3, 0, -t7 * t72 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t331);
  tv2rhosigma0 = 0.2e1 * rho[0] * t336 + 0.2e1 * t161;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t339 = t91 * params->beta;
  t344 = t163 * t164 * t25;
  t345 = t26 * t30;
  t346 = t88 * t109;
  t348 = t345 * t346 * t103;
  t352 = t345 * t236 * t121;
  t355 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t163 * t339 * t168 + t344 * t348 / 0.2e1 + t344 * t352);
  tv2rholapl0 = 0.2e1 * rho[0] * t355 + 0.2e1 * t171;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t362 = t143 * t143;
  t363 = t197 * t362;
  t364 = t86 * t363;
  t367 = t286 * t152;
  t373 = t36 / t37 / sigma[0];
  t376 = t36 * t56;
  t379 = t181 * rho[0];
  t382 = t29 / t19 / t379;
  t383 = t382 * t225;
  t386 = -t373 * t45 / 0.4e1 + t376 * t140 / 0.4e1 - t36 * t383 / 0.2e1;
  t387 = t89 * t386;
  t388 = t86 * t387;
  t391 = t152 * t152;
  t392 = t236 * t391;
  t393 = t86 * t392;
  t397 = t148 * sigma[0];
  t398 = 0.1e1 / t397;
  t399 = t55 * t398;
  t402 = 0.2e1 * t399 * t58 - 0.4e1 * t149;
  t403 = t110 * t402;
  t404 = t86 * t403;
  t407 = -0.4e1 / 0.9e1 * t28 * t145 - 0.4e1 / 0.9e1 * t28 * t154 + 0.4e1 / 0.9e1 * t85 * t364 + 0.4e1 / 0.9e1 * t85 * t203 * t367 - 0.2e1 / 0.9e1 * t85 * t388 + 0.4e1 / 0.9e1 * t85 * t393 - 0.2e1 / 0.9e1 * t85 * t404;
  t411 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t407);
  tv2sigma20 = 0.2e1 * rho[0] * t411;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t414 = t345 * t346 * t143;
  t418 = t345 * t236 * t152;
  t421 = my_piecewise3(t3, 0, t344 * t414 / 0.2e1 + t344 * t418);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t421;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t423 = 0.1e1 / t19;
  t426 = t163 * t423 * params->beta * t25;
  t428 = t345 * t236 * t56;
  t431 = my_piecewise3(t3, 0, -0.2e1 * t426 * t428);
  tv2lapl20 = 0.2e1 * rho[0] * t431;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  double t174, t181, t183, t189, t192, t196, t197, t198;
  double t199, t200, t203, t204, t205, t210, t212, t215;
  double t216, t219, t222, t225, t226, t229, t230, t231;
  double t235, t236, t237, t238, t239, t246, t247, t251;
  double t254, t255, t256, t259, t264, tv2rho20, t277, t280;
  double t281, t282, t286, t287, t295, t296, t298, t303;
  double t304, t305, t308, t311, t312, t316, t317, t318;
  double t322, t326, t327, t328, t331, t336, tv2rhosigma0, t339;
  double t344, t345, t346, t348, t352, t355, tv2rholapl0, tv2rhotau0;
  double t362, t363, t364, t367, t373, t376, t379, t382;
  double t383, t386, t387, t388, t391, t392, t393, t397;
  double t398, t399, t402, t403, t404, t407, t411, tv2sigma20;
  double t414, t418, t421, tv2sigmalapl0, tv2sigmatau0, t423, t426, t428;
  double t431, tv2lapl20, tv2lapltau0, tv2tau20;

  double t434, t444, t445, t449, t450, t451, t452, t453;
  double t454, t457, t458, t462, t463, t464, t465, t466;
  double t467, t470, t471, t475, t476, t480, t481, t485;
  double t489, t492, t496, t500, t502, t506, t507, t508;
  double t511, t513, t518, t519, t521, t523, t527, t528;
  double t529, t536, t537, t543, t546, t547, t548, t556;
  double t559, t562, t565, t568, t573, tv3rho30, t589, t590;
  double t594, t598, t599, t603, t607, t608, t612, t613;
  double t617, t621, t622, t629, t633, t634, t638, t642;
  double t643, t647, t651, t652, t671, t672, t673, t674;
  double t675, t676, t679, t680, t681, t682, t683, t686;
  double t692, t693, t694, t698, t702, t705, t708, t719;
  double t721, t725, t726, t727, t730, t733, t734, t739;
  double tv3rho2sigma0, t743, t748, t753, t755, t757, t759, t763;
  double t767, t771, t774, tv3rho2lapl0, tv3rho2tau0, t783, t784, t788;
  double t789, t793, t794, t798, t799, t803, t807, t808;
  double t812, t813, t817, t818, t822, t823, t827, t831;
  double t835, t841, t848, t849, t850, t853, t854, t871;
  double t874, t876, t880, t881, t882, t885, t888, t891;
  double t894, t897, t902, t903, t904, t910, t911, t916;
  double tv3rhosigma20, t921, t923, t926, t929, t935, t937, t939;
  double t943, t946, tv3rhosigmalapl0, tv3rhosigmatau0, t951, t953, t956, t958;
  double t962, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t965, t966, t967, t970;
  double t974, t975, t976, t979, t983, t987, t991, t1000;
  double t1001, t1002, t1005, t1006, t1007, t1019, t1022, t1027;
  double t1031, t1032, t1033, t1036, t1040, t1044, tv3sigma30, t1047;
  double t1050, t1054, t1058, t1062, t1065, tv3sigma2lapl0, tv3sigma2tau0, t1068;
  double t1072, t1076, t1080, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20, t1084, t1086;
  double t1089, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t174 = t18 * t53;
  t181 = t32 * t32;
  t183 = 0.1e1 / t33 / t181;
  t189 = t96 * t104;
  t192 = t96 * t122;
  t196 = 0.1e1 / t87 / t47;
  t197 = t196 * t61;
  t198 = t103 * t103;
  t199 = t197 * t198;
  t200 = t86 * t199;
  t203 = t86 * t88;
  t204 = t109 * t103;
  t205 = t204 * t121;
  t210 = 0.1e1 / t19 / t76;
  t212 = t29 * t210 * t44;
  t215 = t30 * t183;
  t216 = t215 * t99;
  t219 = t36 * t148;
  t222 = 0.1e1 / t19 / t181 / t76;
  t225 = 0.1e1 / t98 / t97;
  t226 = t29 * t222 * t225;
  t229 = 0.28e2 / 0.9e1 * t38 * t212 + 0.2e2 / 0.3e1 * t95 * t216 - 0.32e2 / 0.9e1 * t219 * t226;
  t230 = t89 * t229;
  t231 = t86 * t230;
  t235 = 0.1e1 / t108 / t60;
  t236 = t48 * t235;
  t237 = t121 * t121;
  t238 = t236 * t237;
  t239 = t86 * t238;
  t246 = 0.88e2 / 0.9e1 * t31 * t183 - 0.4e2 / 0.9e1 * t51 * t78;
  t247 = t246 * t56;
  t251 = t29 * t33;
  t254 = t247 * t58 + 0.16e2 / 0.3e1 * t116 * t118 + 0.4e2 / 0.9e1 * t57 * t251;
  t255 = t110 * t254;
  t256 = t86 * t255;
  t259 = 0.176e3 / 0.81e2 * t28 * t31 * t183 * t48 * t61 + 0.32e2 / 0.27e2 * t85 * t189 + 0.32e2 / 0.27e2 * t85 * t192 + 0.4e1 / 0.9e1 * t85 * t200 + 0.4e1 / 0.9e1 * t85 * t203 * t205 - 0.2e1 / 0.9e1 * t85 * t231 + 0.4e1 / 0.9e1 * t85 * t239 - 0.2e1 / 0.9e1 * t85 * t256;
  t264 = my_piecewise3(t3, 0, t7 * t174 * t66 / 0.12e2 - t7 * t72 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t259);
  tv2rho20 = 0.2e1 * rho[0] * t264 + 0.4e1 * t131;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t277 = t96 * t144;
  t280 = t86 * t196;
  t281 = t61 * t143;
  t282 = t281 * t103;
  t286 = t109 * t143;
  t287 = t286 * t121;
  t295 = t36 * t29;
  t296 = t181 * t32;
  t298 = 0.1e1 / t19 / t296;
  t303 = -0.2e1 / 0.3e1 * t138 * t93 - 0.2e1 * t36 * t100 + 0.4e1 / 0.3e1 * t295 * t298 * t225 * sigma[0];
  t304 = t89 * t303;
  t305 = t86 * t304;
  t308 = t96 * t153;
  t311 = t109 * t152;
  t312 = t311 * t103;
  t316 = t86 * t48;
  t317 = t235 * t152;
  t318 = t317 * t121;
  t322 = t115 * t149;
  t326 = -t322 * t58 - 0.8e1 / 0.3e1 * t150 * t118;
  t327 = t110 * t326;
  t328 = t86 * t327;
  t331 = -0.16e2 / 0.27e2 * t28 * t96 * t134 - 0.2e1 / 0.9e1 * t28 * t105 - 0.2e1 / 0.9e1 * t28 * t123 + 0.16e2 / 0.27e2 * t85 * t277 + 0.4e1 / 0.9e1 * t85 * t280 * t282 + 0.2e1 / 0.9e1 * t85 * t203 * t287 - 0.2e1 / 0.9e1 * t85 * t305 + 0.16e2 / 0.27e2 * t85 * t308 + 0.2e1 / 0.9e1 * t85 * t203 * t312 + 0.4e1 / 0.9e1 * t85 * t316 * t318 - 0.2e1 / 0.9e1 * t85 * t328;
  t336 = my_piecewise3(t3, 0, -t7 * t72 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t331);
  tv2rhosigma0 = 0.2e1 * rho[0] * t336 + 0.2e1 * t161;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t339 = t91 * params->beta;
  t344 = t163 * t164 * t25;
  t345 = t26 * t30;
  t346 = t88 * t109;
  t348 = t345 * t346 * t103;
  t352 = t345 * t236 * t121;
  t355 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t163 * t339 * t168 + t344 * t348 / 0.2e1 + t344 * t352);
  tv2rholapl0 = 0.2e1 * rho[0] * t355 + 0.2e1 * t171;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t362 = t143 * t143;
  t363 = t197 * t362;
  t364 = t86 * t363;
  t367 = t286 * t152;
  t373 = t36 / t37 / sigma[0];
  t376 = t36 * t56;
  t379 = t181 * rho[0];
  t382 = t29 / t19 / t379;
  t383 = t382 * t225;
  t386 = -t373 * t45 / 0.4e1 + t376 * t140 / 0.4e1 - t36 * t383 / 0.2e1;
  t387 = t89 * t386;
  t388 = t86 * t387;
  t391 = t152 * t152;
  t392 = t236 * t391;
  t393 = t86 * t392;
  t397 = t148 * sigma[0];
  t398 = 0.1e1 / t397;
  t399 = t55 * t398;
  t402 = 0.2e1 * t399 * t58 - 0.4e1 * t149;
  t403 = t110 * t402;
  t404 = t86 * t403;
  t407 = -0.4e1 / 0.9e1 * t28 * t145 - 0.4e1 / 0.9e1 * t28 * t154 + 0.4e1 / 0.9e1 * t85 * t364 + 0.4e1 / 0.9e1 * t85 * t203 * t367 - 0.2e1 / 0.9e1 * t85 * t388 + 0.4e1 / 0.9e1 * t85 * t393 - 0.2e1 / 0.9e1 * t85 * t404;
  t411 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t407);
  tv2sigma20 = 0.2e1 * rho[0] * t411;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t414 = t345 * t346 * t143;
  t418 = t345 * t236 * t152;
  t421 = my_piecewise3(t3, 0, t344 * t414 / 0.2e1 + t344 * t418);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t421;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t423 = 0.1e1 / t19;
  t426 = t163 * t423 * params->beta * t25;
  t428 = t345 * t236 * t56;
  t431 = my_piecewise3(t3, 0, -0.2e1 * t426 * t428);
  tv2lapl20 = 0.2e1 * rho[0] * t431;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t434 = t18 * t35;
  t444 = t235 * t103;
  t445 = t444 * t237;
  t449 = t108 * t108;
  t450 = 0.1e1 / t449;
  t451 = t48 * t450;
  t452 = t237 * t121;
  t453 = t451 * t452;
  t454 = t86 * t453;
  t457 = t235 * t121;
  t458 = t457 * t254;
  t462 = t87 * t87;
  t463 = 0.1e1 / t462;
  t464 = t463 * t61;
  t465 = t198 * t103;
  t466 = t464 * t465;
  t467 = t86 * t466;
  t470 = t109 * t198;
  t471 = t470 * t121;
  t475 = t61 * t103;
  t476 = t475 * t229;
  t480 = t109 * t229;
  t481 = t480 * t121;
  t485 = t204 * t254;
  t489 = t96 * t199;
  t492 = t96 * t88;
  t496 = t96 * t238;
  t500 = 0.1e1 / t19 / t181;
  t502 = t29 * t500 * t44;
  t506 = 0.1e1 / t33 / t379;
  t507 = t30 * t506;
  t508 = t507 * t99;
  t511 = t181 * t181;
  t513 = 0.1e1 / t19 / t511;
  t518 = t511 * t76;
  t519 = 0.1e1 / t518;
  t521 = t97 * t97;
  t523 = 0.1e1 / t98 / t521;
  t527 = -0.28e3 / 0.27e2 * t38 * t502 - 0.952e3 / 0.27e2 * t95 * t508 + 0.1184e4 / 0.27e2 * t219 * t29 * t513 * t225 - 0.256e3 / 0.9e1 * t36 * t397 * t519 * t523;
  t528 = t89 * t527;
  t529 = t86 * t528;
  t536 = -0.1232e4 / 0.27e2 * t31 * t506 + 0.44e3 / 0.27e2 * t51 * t183;
  t537 = t536 * t56;
  t543 = t29 * t423;
  t546 = t537 * t58 + 0.8e1 * t247 * t118 + 0.4e2 / 0.3e1 * t116 * t251 + 0.8e2 / 0.27e2 * t57 * t543;
  t547 = t110 * t546;
  t548 = t86 * t547;
  t556 = t215 * t104;
  t559 = t215 * t122;
  t562 = t96 * t230;
  t565 = t96 * t255;
  t568 = -0.4e1 / 0.3e1 * t85 * t203 * t445 - 0.4e1 / 0.3e1 * t85 * t454 + 0.4e1 / 0.3e1 * t85 * t316 * t458 - 0.4e1 / 0.3e1 * t85 * t467 - 0.4e1 / 0.3e1 * t85 * t280 * t471 + 0.4e1 / 0.3e1 * t85 * t280 * t476 + 0.2e1 / 0.3e1 * t85 * t203 * t481 + 0.2e1 / 0.3e1 * t85 * t203 * t485 - 0.32e2 / 0.9e1 * t85 * t489 - 0.32e2 / 0.9e1 * t85 * t492 * t205 - 0.32e2 / 0.9e1 * t85 * t496 - 0.2e1 / 0.9e1 * t85 * t529 - 0.2e1 / 0.9e1 * t85 * t548 - 0.2464e4 / 0.243e3 * t28 * t31 * t506 * t48 * t61 - 0.176e3 / 0.27e2 * t85 * t556 - 0.176e3 / 0.27e2 * t85 * t559 + 0.16e2 / 0.9e1 * t85 * t562 + 0.16e2 / 0.9e1 * t85 * t565;
  t573 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t434 * t66 + t7 * t174 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t72 * t259 - 0.3e1 / 0.8e1 * t7 * t20 * t568);
  tv3rho30 = 0.2e1 * rho[0] * t573 + 0.6e1 * t264;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t589 = t61 * t303;
  t590 = t589 * t103;
  t594 = t281 * t229;
  t598 = t109 * t303;
  t599 = t598 * t121;
  t603 = t286 * t254;
  t607 = t450 * t152;
  t608 = t607 * t237;
  t612 = t235 * t143;
  t613 = t612 * t237;
  t617 = t311 * t198;
  t621 = t86 * t463;
  t622 = t281 * t198;
  t629 = t96 * t48;
  t633 = t109 * t326;
  t634 = t633 * t103;
  t638 = t311 * t229;
  t642 = t235 * t326;
  t643 = t642 * t121;
  t647 = t317 * t254;
  t651 = 0.176e3 / 0.81e2 * t28 * t215 * t134 - 0.32e2 / 0.27e2 * t85 * t492 * t287 + 0.8e1 / 0.9e1 * t85 * t280 * t590 + 0.4e1 / 0.9e1 * t85 * t280 * t594 + 0.4e1 / 0.9e1 * t85 * t203 * t599 + 0.2e1 / 0.9e1 * t85 * t203 * t603 - 0.4e1 / 0.3e1 * t85 * t316 * t608 - 0.4e1 / 0.9e1 * t85 * t203 * t613 - 0.4e1 / 0.9e1 * t85 * t280 * t617 - 0.4e1 / 0.3e1 * t85 * t621 * t622 - 0.32e2 / 0.27e2 * t85 * t492 * t312 - 0.64e2 / 0.27e2 * t85 * t629 * t318 + 0.4e1 / 0.9e1 * t85 * t203 * t634 + 0.2e1 / 0.9e1 * t85 * t203 * t638 + 0.8e1 / 0.9e1 * t85 * t316 * t643 + 0.4e1 / 0.9e1 * t85 * t316 * t647;
  t652 = t96 * t196;
  t671 = t22 * t25 * t26 * sigma[0] * t30;
  t672 = t35 * t88;
  t673 = t672 * t235;
  t674 = t152 * t103;
  t675 = t674 * t121;
  t676 = t673 * t675;
  t679 = t35 * t196;
  t680 = t679 * t109;
  t681 = t143 * t103;
  t682 = t681 * t121;
  t683 = t680 * t682;
  t686 = t246 * t149;
  t692 = -t686 * t58 - 0.16e2 / 0.3e1 * t322 * t118 - 0.4e2 / 0.9e1 * t150 * t251;
  t693 = t110 * t692;
  t694 = t86 * t693;
  t698 = t22 * t27 * t30;
  t702 = t215 * t153;
  t705 = t215 * t144;
  t708 = t96 * t304;
  t719 = t511 * t32;
  t721 = 0.1e1 / t719 * t523;
  t725 = 0.14e2 / 0.9e1 * t138 * t212 + 0.74e2 / 0.9e1 * t36 * t216 - 0.124e3 / 0.9e1 * t295 * t222 * t225 * sigma[0] + 0.32e2 / 0.3e1 * t36 * t721 * t148;
  t726 = t89 * t725;
  t727 = t86 * t726;
  t730 = t96 * t327;
  t733 = -0.64e2 / 0.27e2 * t85 * t652 * t282 - 0.2e1 / 0.9e1 * t28 * t256 + 0.32e2 / 0.27e2 * t28 * t189 + 0.32e2 / 0.27e2 * t28 * t192 - 0.2e1 / 0.9e1 * t28 * t231 + 0.4e1 / 0.9e1 * t28 * t200 + 0.4e1 / 0.9e1 * t28 * t239 - 0.8e1 / 0.9e1 * t671 * t676 - 0.8e1 / 0.9e1 * t671 * t683 - 0.2e1 / 0.9e1 * t85 * t694 + 0.4e1 / 0.9e1 * t698 * t672 * t205 - 0.176e3 / 0.81e2 * t85 * t702 - 0.176e3 / 0.81e2 * t85 * t705 + 0.32e2 / 0.27e2 * t85 * t708 - 0.2e1 / 0.9e1 * t85 * t727 + 0.32e2 / 0.27e2 * t85 * t730;
  t734 = t651 + t733;
  t739 = my_piecewise3(t3, 0, t7 * t174 * t157 / 0.12e2 - t7 * t72 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t734);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t739 + 0.4e1 * t336;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t743 = t210 * params->beta;
  t748 = t163 * t339 * t25;
  t753 = t196 * t109;
  t755 = t345 * t753 * t198;
  t757 = t345 * t88;
  t759 = t757 * t444 * t121;
  t763 = t345 * t346 * t229;
  t767 = t345 * t451 * t237;
  t771 = t345 * t236 * t254;
  t774 = my_piecewise3(t3, 0, -0.14e2 / 0.9e1 * t163 * t743 * t168 - 0.4e1 / 0.3e1 * t748 * t348 - 0.8e1 / 0.3e1 * t748 * t352 - t344 * t755 - 0.2e1 * t344 * t759 + t344 * t763 / 0.2e1 - 0.3e1 * t344 * t767 + t344 * t771);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t774 + 0.4e1 * t355;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t783 = t61 * t386;
  t784 = t783 * t103;
  t788 = t109 * t386;
  t789 = t788 * t121;
  t793 = t235 * t391;
  t794 = t793 * t103;
  t798 = t450 * t391;
  t799 = t798 * t121;
  t803 = t317 * t326;
  t807 = t109 * t402;
  t808 = t807 * t103;
  t812 = t235 * t402;
  t813 = t812 * t121;
  t817 = t61 * t362;
  t818 = t817 * t103;
  t822 = t109 * t362;
  t823 = t822 * t121;
  t827 = t281 * t303;
  t831 = t598 * t152;
  t835 = t286 * t326;
  t841 = -0.32e2 / 0.27e2 * t85 * t492 * t367 + 0.4e1 / 0.9e1 * t85 * t280 * t784 + 0.2e1 / 0.9e1 * t85 * t203 * t789 - 0.4e1 / 0.9e1 * t85 * t203 * t794 - 0.4e1 / 0.3e1 * t85 * t316 * t799 + 0.8e1 / 0.9e1 * t85 * t316 * t803 + 0.2e1 / 0.9e1 * t85 * t203 * t808 + 0.4e1 / 0.9e1 * t85 * t316 * t813 - 0.4e1 / 0.3e1 * t85 * t621 * t818 - 0.4e1 / 0.9e1 * t85 * t280 * t823 + 0.8e1 / 0.9e1 * t85 * t280 * t827 + 0.4e1 / 0.9e1 * t85 * t203 * t831 + 0.4e1 / 0.9e1 * t85 * t203 * t835 + 0.32e2 / 0.27e2 * t28 * t308;
  t848 = t143 * t152;
  t849 = t848 * t103;
  t850 = t680 * t849;
  t853 = t848 * t121;
  t854 = t673 * t853;
  t871 = t29 * t298 * t225;
  t874 = t511 * rho[0];
  t876 = 0.1e1 / t874 * t523;
  t880 = t373 * t93 / 0.3e1 - t376 * t100 / 0.3e1 + 0.1e2 / 0.3e1 * t36 * t871 - 0.4e1 * t36 * t876 * sigma[0];
  t881 = t89 * t880;
  t882 = t86 * t881;
  t885 = t96 * t387;
  t888 = t96 * t392;
  t891 = t96 * t403;
  t894 = t96 * t363;
  t897 = t115 * t398;
  t902 = 0.2e1 * t897 * t58 + 0.16e2 / 0.3e1 * t399 * t118;
  t903 = t110 * t902;
  t904 = t86 * t903;
  t910 = -0.4e1 / 0.9e1 * t28 * t305 - 0.4e1 / 0.9e1 * t28 * t328 + 0.32e2 / 0.27e2 * t28 * t277 - 0.8e1 / 0.9e1 * t671 * t850 - 0.8e1 / 0.9e1 * t671 * t854 + 0.4e1 / 0.9e1 * t698 * t672 * t287 + 0.4e1 / 0.9e1 * t698 * t672 * t312 + 0.8e1 / 0.9e1 * t698 * t49 * t318 - 0.2e1 / 0.9e1 * t85 * t882 + 0.16e2 / 0.27e2 * t85 * t885 - 0.32e2 / 0.27e2 * t85 * t888 + 0.16e2 / 0.27e2 * t85 * t891 - 0.32e2 / 0.27e2 * t85 * t894 - 0.2e1 / 0.9e1 * t85 * t904 + 0.8e1 / 0.9e1 * t698 * t679 * t282;
  t911 = t841 + t910;
  t916 = my_piecewise3(t3, 0, -t7 * t72 * t407 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t911);
  tv3rhosigma20 = 0.2e1 * rho[0] * t916 + 0.2e1 * t411;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t921 = t345 * t196;
  t923 = t921 * t286 * t103;
  t926 = t757 * t612 * t121;
  t929 = t345 * t346 * t303;
  t935 = t757 * t317 * t103;
  t937 = t345 * t48;
  t939 = t937 * t607 * t121;
  t943 = t345 * t236 * t326;
  t946 = my_piecewise3(t3, 0, -0.2e1 / 0.3e1 * t748 * t414 - t344 * t923 - t344 * t926 + t344 * t929 / 0.2e1 - 0.4e1 / 0.3e1 * t748 * t418 - t344 * t935 - 0.3e1 * t344 * t939 + t344 * t943);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t946 + 0.2e1 * t421;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t951 = t235 * t56;
  t953 = t757 * t951 * t103;
  t956 = t450 * t56;
  t958 = t937 * t956 * t121;
  t962 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t344 * t428 + 0.2e1 * t426 * t953 + 0.6e1 * t426 * t958);
  tv3rholapl20 = 0.2e1 * rho[0] * t962 + 0.2e1 * t431;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t965 = t391 * t152;
  t966 = t451 * t965;
  t967 = t86 * t966;
  t970 = t317 * t402;
  t974 = t362 * t143;
  t975 = t464 * t974;
  t976 = t86 * t975;
  t979 = t822 * t152;
  t983 = t281 * t386;
  t987 = t788 * t152;
  t991 = t286 * t402;
  t1000 = t148 * t148;
  t1001 = 0.1e1 / t1000;
  t1002 = t55 * t1001;
  t1005 = -0.6e1 * t1002 * t58 + 0.12e2 * t398;
  t1006 = t110 * t1005;
  t1007 = t86 * t1006;
  t1019 = t36 / t37 / t148;
  t1022 = t36 * t149;
  t1027 = 0.1e1 / t511;
  t1031 = 0.3e1 / 0.8e1 * t1019 * t45 - 0.3e1 / 0.8e1 * t1022 * t140 - t376 * t383 / 0.4e1 + 0.3e1 / 0.2e1 * t36 * t1027 * t523;
  t1032 = t89 * t1031;
  t1033 = t86 * t1032;
  t1036 = t612 * t391;
  t1040 = -0.4e1 / 0.3e1 * t85 * t967 + 0.4e1 / 0.3e1 * t85 * t316 * t970 - 0.4e1 / 0.3e1 * t85 * t976 - 0.4e1 / 0.3e1 * t85 * t280 * t979 + 0.4e1 / 0.3e1 * t85 * t280 * t983 + 0.2e1 / 0.3e1 * t85 * t203 * t987 + 0.2e1 / 0.3e1 * t85 * t203 * t991 - 0.2e1 / 0.3e1 * t28 * t388 - 0.2e1 / 0.3e1 * t28 * t404 - 0.2e1 / 0.9e1 * t85 * t1007 + 0.4e1 / 0.3e1 * t28 * t364 + 0.4e1 / 0.3e1 * t698 * t672 * t367 + 0.4e1 / 0.3e1 * t28 * t393 - 0.2e1 / 0.9e1 * t85 * t1033 - 0.4e1 / 0.3e1 * t85 * t203 * t1036;
  t1044 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1040);
  tv3sigma30 = 0.2e1 * rho[0] * t1044;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1047 = t345 * t753 * t362;
  t1050 = t757 * t612 * t152;
  t1054 = t345 * t346 * t386;
  t1058 = t345 * t451 * t391;
  t1062 = t345 * t236 * t402;
  t1065 = my_piecewise3(t3, 0, -t344 * t1047 - 0.2e1 * t344 * t1050 + t344 * t1054 / 0.2e1 - 0.3e1 * t344 * t1058 + t344 * t1062);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1065;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1068 = t757 * t951 * t143;
  t1072 = t937 * t956 * t152;
  t1076 = t345 * t236 * t149;
  t1080 = my_piecewise3(t3, 0, 0.2e1 * t426 * t1068 + 0.6e1 * t426 * t1072 + 0.2e1 * t426 * t1076);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1080;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1084 = t163 * t33 * params->beta * t25;
  t1086 = t345 * t451 * t149;
  t1089 = my_piecewise3(t3, 0, -0.12e2 * t1084 * t1086);
  tv3lapl30 = 0.2e1 * rho[0] * t1089;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t7, t8, t9, t11;
  double t12, t14, t16, t18, t19, t20, t21, t22;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t38, t40;
  double t41, t44, t45, t47, t48, t49, t50, t51;
  double t52, t53, t55, t56, t57, t58, t60, t61;
  double t66, t70, tzk0;

  double t72, t76, t78, t79, t85, t86, t87, t88;
  double t89, t91, t93, t95, t96, t97, t98, t99;
  double t100, t103, t104, t105, t108, t109, t110, t115;
  double t116, t118, t121, t122, t123, t126, t131, tvrho0;
  double t134, t138, t140, t143, t144, t145, t148, t149;
  double t150, t152, t153, t154, t157, t161, tvsigma0, t163;
  double t164, t166, t168, t171, tvlapl0, tvtau0;

  double t174, t181, t183, t189, t192, t196, t197, t198;
  double t199, t200, t203, t204, t205, t210, t212, t215;
  double t216, t219, t222, t225, t226, t229, t230, t231;
  double t235, t236, t237, t238, t239, t246, t247, t251;
  double t254, t255, t256, t259, t264, tv2rho20, t277, t280;
  double t281, t282, t286, t287, t295, t296, t298, t303;
  double t304, t305, t308, t311, t312, t316, t317, t318;
  double t322, t326, t327, t328, t331, t336, tv2rhosigma0, t339;
  double t344, t345, t346, t348, t352, t355, tv2rholapl0, tv2rhotau0;
  double t362, t363, t364, t367, t373, t376, t379, t382;
  double t383, t386, t387, t388, t391, t392, t393, t397;
  double t398, t399, t402, t403, t404, t407, t411, tv2sigma20;
  double t414, t418, t421, tv2sigmalapl0, tv2sigmatau0, t423, t426, t428;
  double t431, tv2lapl20, tv2lapltau0, tv2tau20;

  double t434, t444, t445, t449, t450, t451, t452, t453;
  double t454, t457, t458, t462, t463, t464, t465, t466;
  double t467, t470, t471, t475, t476, t480, t481, t485;
  double t489, t492, t496, t500, t502, t506, t507, t508;
  double t511, t513, t518, t519, t521, t523, t527, t528;
  double t529, t536, t537, t543, t546, t547, t548, t556;
  double t559, t562, t565, t568, t573, tv3rho30, t589, t590;
  double t594, t598, t599, t603, t607, t608, t612, t613;
  double t617, t621, t622, t629, t633, t634, t638, t642;
  double t643, t647, t651, t652, t671, t672, t673, t674;
  double t675, t676, t679, t680, t681, t682, t683, t686;
  double t692, t693, t694, t698, t702, t705, t708, t719;
  double t721, t725, t726, t727, t730, t733, t734, t739;
  double tv3rho2sigma0, t743, t748, t753, t755, t757, t759, t763;
  double t767, t771, t774, tv3rho2lapl0, tv3rho2tau0, t783, t784, t788;
  double t789, t793, t794, t798, t799, t803, t807, t808;
  double t812, t813, t817, t818, t822, t823, t827, t831;
  double t835, t841, t848, t849, t850, t853, t854, t871;
  double t874, t876, t880, t881, t882, t885, t888, t891;
  double t894, t897, t902, t903, t904, t910, t911, t916;
  double tv3rhosigma20, t921, t923, t926, t929, t935, t937, t939;
  double t943, t946, tv3rhosigmalapl0, tv3rhosigmatau0, t951, t953, t956, t958;
  double t962, tv3rholapl20, tv3rholapltau0, tv3rhotau20, t965, t966, t967, t970;
  double t974, t975, t976, t979, t983, t987, t991, t1000;
  double t1001, t1002, t1005, t1006, t1007, t1019, t1022, t1027;
  double t1031, t1032, t1033, t1036, t1040, t1044, tv3sigma30, t1047;
  double t1050, t1054, t1058, t1062, t1065, tv3sigma2lapl0, tv3sigma2tau0, t1068;
  double t1072, t1076, t1080, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20, t1084, t1086;
  double t1089, tv3lapl30, tv3lapl2tau0, tv3lapltau20, tv3tau30;

  double t1105, t1110, t1151, t1156, t1182, t1184, t1190, t1200;
  double t1201, t1202, t1207, t1216, t1217, t1218, t1242, t1254;
  double t1302, t1310, t1316, tv4rho40, t1357, t1377, t1382, t1386;
  double t1391, t1406, t1407, t1428, t1473, t1474, t1484, t1495;
  double t1501, t1529, t1535, t1536, t1541, t1547, t1548, t1552;
  double t1553, t1572, t1655, t1662, tv4rho3sigma0, t1689, t1718, t1727;
  double t1728, tv4rho3lapl0, tv4rho3tau0, t1742, t1751, t1756, t1765, t1784;
  double t1809, t1826, t1868, t1914, t1978, t1982, t2017, t2034;
  double t2049, t2075, t2080, t2101, t2109, tv4rho2sigma20, t2130, t2131;
  double t2133, t2146, t2150, t2159, t2197, t2199, tv4rho2sigmalapl0, tv4rho2sigmatau0;
  double t2214, t2224, t2234, tv4rho2lapl20, tv4rho2lapltau0, tv4rho2tau20, t2245, t2259;
  double t2268, t2281, t2286, t2295, t2308, t2313, t2353, t2375;
  double t2451, t2495, t2509, t2516, tv4rhosigma30, t2588, t2590, tv4rhosigma2lapl0;
  double tv4rhosigma2tau0, t2595, t2610, t2626, t2631, t2636, t2637, tv4rhosigmalapl20;
  double tv4rhosigmalapltau0, tv4rhosigmatau20, t2646, t2652, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30;
  double t2711, t2716, t2756, t2764, t2775, t2794, t2799, tv4sigma40;
  double t2841, tv4sigma3lapl0, tv4sigma3tau0, t2876, tv4sigma2lapl20, tv4sigma2lapltau0, tv4sigma2tau20, t2891;
  double tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30, t2900, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20;
  double tv4lapltau30, tv4tau40;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t6 = 0.1e1 / t5;
  t7 = t4 * t6;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = t4 * t4;
  t22 = params->beta * t21;
  t24 = POW_1_3(0.1e1 / M_PI);
  t25 = 0.1e1 / t24;
  t26 = M_CBRT4;
  t27 = t25 * t26;
  t28 = t22 * t27;
  t29 = M_CBRT2;
  t30 = t29 * t29;
  t31 = sigma[0] * t30;
  t32 = rho[0] * rho[0];
  t33 = t19 * t19;
  t34 = t33 * t32;
  t35 = 0.1e1 / t34;
  t36 = params->gamma * params->beta;
  t37 = sqrt(sigma[0]);
  t38 = t36 * t37;
  t40 = 0.1e1 / t19 / rho[0];
  t41 = t29 * t40;
  t44 = log(t37 * t29 * t40 + sqrt(POW_2(t37 * t29 * t40) + 0.1e1));
  t45 = t41 * t44;
  t47 = t38 * t45 + 0.1e1;
  t48 = 0.1e1 / t47;
  t49 = t35 * t48;
  t50 = t31 * t35;
  t51 = lapl[0] * t30;
  t52 = t33 * rho[0];
  t53 = 0.1e1 / t52;
  t55 = -t51 * t53 + t50;
  t56 = 0.1e1 / sigma[0];
  t57 = t55 * t56;
  t58 = t29 * t34;
  t60 = t57 * t58 + 0.1e1;
  t61 = 0.1e1 / t60;
  t66 = 0.1e1 + 0.2e1 / 0.9e1 * t28 * t31 * t49 * t61;
  t70 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t66);
  tzk0 = 0.2e1 * t70;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t72 = t18 / t33;
  t76 = t32 * rho[0];
  t78 = 0.1e1 / t33 / t76;
  t79 = t78 * t48;
  t85 = t22 * t27 * sigma[0];
  t86 = t30 * t35;
  t87 = t47 * t47;
  t88 = 0.1e1 / t87;
  t89 = t88 * t61;
  t91 = 0.1e1 / t19 / t32;
  t93 = t29 * t91 * t44;
  t95 = t36 * sigma[0];
  t96 = t30 * t78;
  t97 = t50 + 0.1e1;
  t98 = sqrt(t97);
  t99 = 0.1e1 / t98;
  t100 = t96 * t99;
  t103 = -0.4e1 / 0.3e1 * t95 * t100 - 0.4e1 / 0.3e1 * t38 * t93;
  t104 = t89 * t103;
  t105 = t86 * t104;
  t108 = t60 * t60;
  t109 = 0.1e1 / t108;
  t110 = t48 * t109;
  t115 = -0.8e1 / 0.3e1 * t31 * t78 + 0.5e1 / 0.3e1 * t51 * t35;
  t116 = t115 * t56;
  t118 = t29 * t52;
  t121 = t116 * t58 + 0.8e1 / 0.3e1 * t57 * t118;
  t122 = t110 * t121;
  t123 = t86 * t122;
  t126 = -0.16e2 / 0.27e2 * t28 * t31 * t79 * t61 - 0.2e1 / 0.9e1 * t85 * t105 - 0.2e1 / 0.9e1 * t85 * t123;
  t131 = my_piecewise3(t3, 0, -t7 * t72 * t66 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t126);
  tvrho0 = 0.2e1 * rho[0] * t131 + 0.2e1 * t70;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t134 = t48 * t61;
  t138 = t36 / t37;
  t140 = t86 * t99;
  t143 = t138 * t45 / 0.2e1 + t36 * t140 / 0.2e1;
  t144 = t89 * t143;
  t145 = t86 * t144;
  t148 = sigma[0] * sigma[0];
  t149 = 0.1e1 / t148;
  t150 = t55 * t149;
  t152 = -t150 * t58 + 0.2e1 * t56;
  t153 = t110 * t152;
  t154 = t86 * t153;
  t157 = 0.2e1 / 0.9e1 * t28 * t86 * t134 - 0.2e1 / 0.9e1 * t85 * t145 - 0.2e1 / 0.9e1 * t85 * t154;
  t161 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t157);
  tvsigma0 = 0.2e1 * rho[0] * t161;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t163 = t6 * t18;
  t164 = t40 * params->beta;
  t166 = t30 * t48;
  t168 = t27 * t166 * t109;
  t171 = my_piecewise3(t3, 0, -t163 * t164 * t168 / 0.2e1);
  tvlapl0 = 0.2e1 * rho[0] * t171;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t174 = t18 * t53;
  t181 = t32 * t32;
  t183 = 0.1e1 / t33 / t181;
  t189 = t96 * t104;
  t192 = t96 * t122;
  t196 = 0.1e1 / t87 / t47;
  t197 = t196 * t61;
  t198 = t103 * t103;
  t199 = t197 * t198;
  t200 = t86 * t199;
  t203 = t86 * t88;
  t204 = t109 * t103;
  t205 = t204 * t121;
  t210 = 0.1e1 / t19 / t76;
  t212 = t29 * t210 * t44;
  t215 = t30 * t183;
  t216 = t215 * t99;
  t219 = t36 * t148;
  t222 = 0.1e1 / t19 / t181 / t76;
  t225 = 0.1e1 / t98 / t97;
  t226 = t29 * t222 * t225;
  t229 = 0.28e2 / 0.9e1 * t38 * t212 + 0.2e2 / 0.3e1 * t95 * t216 - 0.32e2 / 0.9e1 * t219 * t226;
  t230 = t89 * t229;
  t231 = t86 * t230;
  t235 = 0.1e1 / t108 / t60;
  t236 = t48 * t235;
  t237 = t121 * t121;
  t238 = t236 * t237;
  t239 = t86 * t238;
  t246 = 0.88e2 / 0.9e1 * t31 * t183 - 0.4e2 / 0.9e1 * t51 * t78;
  t247 = t246 * t56;
  t251 = t29 * t33;
  t254 = t247 * t58 + 0.16e2 / 0.3e1 * t116 * t118 + 0.4e2 / 0.9e1 * t57 * t251;
  t255 = t110 * t254;
  t256 = t86 * t255;
  t259 = 0.176e3 / 0.81e2 * t28 * t31 * t183 * t48 * t61 + 0.32e2 / 0.27e2 * t85 * t189 + 0.32e2 / 0.27e2 * t85 * t192 + 0.4e1 / 0.9e1 * t85 * t200 + 0.4e1 / 0.9e1 * t85 * t203 * t205 - 0.2e1 / 0.9e1 * t85 * t231 + 0.4e1 / 0.9e1 * t85 * t239 - 0.2e1 / 0.9e1 * t85 * t256;
  t264 = my_piecewise3(t3, 0, t7 * t174 * t66 / 0.12e2 - t7 * t72 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t259);
  tv2rho20 = 0.2e1 * rho[0] * t264 + 0.4e1 * t131;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t277 = t96 * t144;
  t280 = t86 * t196;
  t281 = t61 * t143;
  t282 = t281 * t103;
  t286 = t109 * t143;
  t287 = t286 * t121;
  t295 = t36 * t29;
  t296 = t181 * t32;
  t298 = 0.1e1 / t19 / t296;
  t303 = -0.2e1 / 0.3e1 * t138 * t93 - 0.2e1 * t36 * t100 + 0.4e1 / 0.3e1 * t295 * t298 * t225 * sigma[0];
  t304 = t89 * t303;
  t305 = t86 * t304;
  t308 = t96 * t153;
  t311 = t109 * t152;
  t312 = t311 * t103;
  t316 = t86 * t48;
  t317 = t235 * t152;
  t318 = t317 * t121;
  t322 = t115 * t149;
  t326 = -t322 * t58 - 0.8e1 / 0.3e1 * t150 * t118;
  t327 = t110 * t326;
  t328 = t86 * t327;
  t331 = -0.16e2 / 0.27e2 * t28 * t96 * t134 - 0.2e1 / 0.9e1 * t28 * t105 - 0.2e1 / 0.9e1 * t28 * t123 + 0.16e2 / 0.27e2 * t85 * t277 + 0.4e1 / 0.9e1 * t85 * t280 * t282 + 0.2e1 / 0.9e1 * t85 * t203 * t287 - 0.2e1 / 0.9e1 * t85 * t305 + 0.16e2 / 0.27e2 * t85 * t308 + 0.2e1 / 0.9e1 * t85 * t203 * t312 + 0.4e1 / 0.9e1 * t85 * t316 * t318 - 0.2e1 / 0.9e1 * t85 * t328;
  t336 = my_piecewise3(t3, 0, -t7 * t72 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t331);
  tv2rhosigma0 = 0.2e1 * rho[0] * t336 + 0.2e1 * t161;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t339 = t91 * params->beta;
  t344 = t163 * t164 * t25;
  t345 = t26 * t30;
  t346 = t88 * t109;
  t348 = t345 * t346 * t103;
  t352 = t345 * t236 * t121;
  t355 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t163 * t339 * t168 + t344 * t348 / 0.2e1 + t344 * t352);
  tv2rholapl0 = 0.2e1 * rho[0] * t355 + 0.2e1 * t171;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t362 = t143 * t143;
  t363 = t197 * t362;
  t364 = t86 * t363;
  t367 = t286 * t152;
  t373 = t36 / t37 / sigma[0];
  t376 = t36 * t56;
  t379 = t181 * rho[0];
  t382 = t29 / t19 / t379;
  t383 = t382 * t225;
  t386 = -t373 * t45 / 0.4e1 + t376 * t140 / 0.4e1 - t36 * t383 / 0.2e1;
  t387 = t89 * t386;
  t388 = t86 * t387;
  t391 = t152 * t152;
  t392 = t236 * t391;
  t393 = t86 * t392;
  t397 = t148 * sigma[0];
  t398 = 0.1e1 / t397;
  t399 = t55 * t398;
  t402 = 0.2e1 * t399 * t58 - 0.4e1 * t149;
  t403 = t110 * t402;
  t404 = t86 * t403;
  t407 = -0.4e1 / 0.9e1 * t28 * t145 - 0.4e1 / 0.9e1 * t28 * t154 + 0.4e1 / 0.9e1 * t85 * t364 + 0.4e1 / 0.9e1 * t85 * t203 * t367 - 0.2e1 / 0.9e1 * t85 * t388 + 0.4e1 / 0.9e1 * t85 * t393 - 0.2e1 / 0.9e1 * t85 * t404;
  t411 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t407);
  tv2sigma20 = 0.2e1 * rho[0] * t411;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t414 = t345 * t346 * t143;
  t418 = t345 * t236 * t152;
  t421 = my_piecewise3(t3, 0, t344 * t414 / 0.2e1 + t344 * t418);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t421;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t423 = 0.1e1 / t19;
  t426 = t163 * t423 * params->beta * t25;
  t428 = t345 * t236 * t56;
  t431 = my_piecewise3(t3, 0, -0.2e1 * t426 * t428);
  tv2lapl20 = 0.2e1 * rho[0] * t431;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t434 = t18 * t35;
  t444 = t235 * t103;
  t445 = t444 * t237;
  t449 = t108 * t108;
  t450 = 0.1e1 / t449;
  t451 = t48 * t450;
  t452 = t237 * t121;
  t453 = t451 * t452;
  t454 = t86 * t453;
  t457 = t235 * t121;
  t458 = t457 * t254;
  t462 = t87 * t87;
  t463 = 0.1e1 / t462;
  t464 = t463 * t61;
  t465 = t198 * t103;
  t466 = t464 * t465;
  t467 = t86 * t466;
  t470 = t109 * t198;
  t471 = t470 * t121;
  t475 = t61 * t103;
  t476 = t475 * t229;
  t480 = t109 * t229;
  t481 = t480 * t121;
  t485 = t204 * t254;
  t489 = t96 * t199;
  t492 = t96 * t88;
  t496 = t96 * t238;
  t500 = 0.1e1 / t19 / t181;
  t502 = t29 * t500 * t44;
  t506 = 0.1e1 / t33 / t379;
  t507 = t30 * t506;
  t508 = t507 * t99;
  t511 = t181 * t181;
  t513 = 0.1e1 / t19 / t511;
  t518 = t511 * t76;
  t519 = 0.1e1 / t518;
  t521 = t97 * t97;
  t523 = 0.1e1 / t98 / t521;
  t527 = -0.28e3 / 0.27e2 * t38 * t502 - 0.952e3 / 0.27e2 * t95 * t508 + 0.1184e4 / 0.27e2 * t219 * t29 * t513 * t225 - 0.256e3 / 0.9e1 * t36 * t397 * t519 * t523;
  t528 = t89 * t527;
  t529 = t86 * t528;
  t536 = -0.1232e4 / 0.27e2 * t31 * t506 + 0.44e3 / 0.27e2 * t51 * t183;
  t537 = t536 * t56;
  t543 = t29 * t423;
  t546 = t537 * t58 + 0.8e1 * t247 * t118 + 0.4e2 / 0.3e1 * t116 * t251 + 0.8e2 / 0.27e2 * t57 * t543;
  t547 = t110 * t546;
  t548 = t86 * t547;
  t556 = t215 * t104;
  t559 = t215 * t122;
  t562 = t96 * t230;
  t565 = t96 * t255;
  t568 = -0.4e1 / 0.3e1 * t85 * t203 * t445 - 0.4e1 / 0.3e1 * t85 * t454 + 0.4e1 / 0.3e1 * t85 * t316 * t458 - 0.4e1 / 0.3e1 * t85 * t467 - 0.4e1 / 0.3e1 * t85 * t280 * t471 + 0.4e1 / 0.3e1 * t85 * t280 * t476 + 0.2e1 / 0.3e1 * t85 * t203 * t481 + 0.2e1 / 0.3e1 * t85 * t203 * t485 - 0.32e2 / 0.9e1 * t85 * t489 - 0.32e2 / 0.9e1 * t85 * t492 * t205 - 0.32e2 / 0.9e1 * t85 * t496 - 0.2e1 / 0.9e1 * t85 * t529 - 0.2e1 / 0.9e1 * t85 * t548 - 0.2464e4 / 0.243e3 * t28 * t31 * t506 * t48 * t61 - 0.176e3 / 0.27e2 * t85 * t556 - 0.176e3 / 0.27e2 * t85 * t559 + 0.16e2 / 0.9e1 * t85 * t562 + 0.16e2 / 0.9e1 * t85 * t565;
  t573 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t434 * t66 + t7 * t174 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t72 * t259 - 0.3e1 / 0.8e1 * t7 * t20 * t568);
  tv3rho30 = 0.2e1 * rho[0] * t573 + 0.6e1 * t264;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t589 = t61 * t303;
  t590 = t589 * t103;
  t594 = t281 * t229;
  t598 = t109 * t303;
  t599 = t598 * t121;
  t603 = t286 * t254;
  t607 = t450 * t152;
  t608 = t607 * t237;
  t612 = t235 * t143;
  t613 = t612 * t237;
  t617 = t311 * t198;
  t621 = t86 * t463;
  t622 = t281 * t198;
  t629 = t96 * t48;
  t633 = t109 * t326;
  t634 = t633 * t103;
  t638 = t311 * t229;
  t642 = t235 * t326;
  t643 = t642 * t121;
  t647 = t317 * t254;
  t651 = 0.176e3 / 0.81e2 * t28 * t215 * t134 - 0.32e2 / 0.27e2 * t85 * t492 * t287 + 0.8e1 / 0.9e1 * t85 * t280 * t590 + 0.4e1 / 0.9e1 * t85 * t280 * t594 + 0.4e1 / 0.9e1 * t85 * t203 * t599 + 0.2e1 / 0.9e1 * t85 * t203 * t603 - 0.4e1 / 0.3e1 * t85 * t316 * t608 - 0.4e1 / 0.9e1 * t85 * t203 * t613 - 0.4e1 / 0.9e1 * t85 * t280 * t617 - 0.4e1 / 0.3e1 * t85 * t621 * t622 - 0.32e2 / 0.27e2 * t85 * t492 * t312 - 0.64e2 / 0.27e2 * t85 * t629 * t318 + 0.4e1 / 0.9e1 * t85 * t203 * t634 + 0.2e1 / 0.9e1 * t85 * t203 * t638 + 0.8e1 / 0.9e1 * t85 * t316 * t643 + 0.4e1 / 0.9e1 * t85 * t316 * t647;
  t652 = t96 * t196;
  t671 = t22 * t25 * t26 * sigma[0] * t30;
  t672 = t35 * t88;
  t673 = t672 * t235;
  t674 = t152 * t103;
  t675 = t674 * t121;
  t676 = t673 * t675;
  t679 = t35 * t196;
  t680 = t679 * t109;
  t681 = t143 * t103;
  t682 = t681 * t121;
  t683 = t680 * t682;
  t686 = t246 * t149;
  t692 = -t686 * t58 - 0.16e2 / 0.3e1 * t322 * t118 - 0.4e2 / 0.9e1 * t150 * t251;
  t693 = t110 * t692;
  t694 = t86 * t693;
  t698 = t22 * t27 * t30;
  t702 = t215 * t153;
  t705 = t215 * t144;
  t708 = t96 * t304;
  t719 = t511 * t32;
  t721 = 0.1e1 / t719 * t523;
  t725 = 0.14e2 / 0.9e1 * t138 * t212 + 0.74e2 / 0.9e1 * t36 * t216 - 0.124e3 / 0.9e1 * t295 * t222 * t225 * sigma[0] + 0.32e2 / 0.3e1 * t36 * t721 * t148;
  t726 = t89 * t725;
  t727 = t86 * t726;
  t730 = t96 * t327;
  t733 = -0.64e2 / 0.27e2 * t85 * t652 * t282 - 0.2e1 / 0.9e1 * t28 * t256 + 0.32e2 / 0.27e2 * t28 * t189 + 0.32e2 / 0.27e2 * t28 * t192 - 0.2e1 / 0.9e1 * t28 * t231 + 0.4e1 / 0.9e1 * t28 * t200 + 0.4e1 / 0.9e1 * t28 * t239 - 0.8e1 / 0.9e1 * t671 * t676 - 0.8e1 / 0.9e1 * t671 * t683 - 0.2e1 / 0.9e1 * t85 * t694 + 0.4e1 / 0.9e1 * t698 * t672 * t205 - 0.176e3 / 0.81e2 * t85 * t702 - 0.176e3 / 0.81e2 * t85 * t705 + 0.32e2 / 0.27e2 * t85 * t708 - 0.2e1 / 0.9e1 * t85 * t727 + 0.32e2 / 0.27e2 * t85 * t730;
  t734 = t651 + t733;
  t739 = my_piecewise3(t3, 0, t7 * t174 * t157 / 0.12e2 - t7 * t72 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t734);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t739 + 0.4e1 * t336;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t743 = t210 * params->beta;
  t748 = t163 * t339 * t25;
  t753 = t196 * t109;
  t755 = t345 * t753 * t198;
  t757 = t345 * t88;
  t759 = t757 * t444 * t121;
  t763 = t345 * t346 * t229;
  t767 = t345 * t451 * t237;
  t771 = t345 * t236 * t254;
  t774 = my_piecewise3(t3, 0, -0.14e2 / 0.9e1 * t163 * t743 * t168 - 0.4e1 / 0.3e1 * t748 * t348 - 0.8e1 / 0.3e1 * t748 * t352 - t344 * t755 - 0.2e1 * t344 * t759 + t344 * t763 / 0.2e1 - 0.3e1 * t344 * t767 + t344 * t771);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t774 + 0.4e1 * t355;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t783 = t61 * t386;
  t784 = t783 * t103;
  t788 = t109 * t386;
  t789 = t788 * t121;
  t793 = t235 * t391;
  t794 = t793 * t103;
  t798 = t450 * t391;
  t799 = t798 * t121;
  t803 = t317 * t326;
  t807 = t109 * t402;
  t808 = t807 * t103;
  t812 = t235 * t402;
  t813 = t812 * t121;
  t817 = t61 * t362;
  t818 = t817 * t103;
  t822 = t109 * t362;
  t823 = t822 * t121;
  t827 = t281 * t303;
  t831 = t598 * t152;
  t835 = t286 * t326;
  t841 = -0.32e2 / 0.27e2 * t85 * t492 * t367 + 0.4e1 / 0.9e1 * t85 * t280 * t784 + 0.2e1 / 0.9e1 * t85 * t203 * t789 - 0.4e1 / 0.9e1 * t85 * t203 * t794 - 0.4e1 / 0.3e1 * t85 * t316 * t799 + 0.8e1 / 0.9e1 * t85 * t316 * t803 + 0.2e1 / 0.9e1 * t85 * t203 * t808 + 0.4e1 / 0.9e1 * t85 * t316 * t813 - 0.4e1 / 0.3e1 * t85 * t621 * t818 - 0.4e1 / 0.9e1 * t85 * t280 * t823 + 0.8e1 / 0.9e1 * t85 * t280 * t827 + 0.4e1 / 0.9e1 * t85 * t203 * t831 + 0.4e1 / 0.9e1 * t85 * t203 * t835 + 0.32e2 / 0.27e2 * t28 * t308;
  t848 = t143 * t152;
  t849 = t848 * t103;
  t850 = t680 * t849;
  t853 = t848 * t121;
  t854 = t673 * t853;
  t871 = t29 * t298 * t225;
  t874 = t511 * rho[0];
  t876 = 0.1e1 / t874 * t523;
  t880 = t373 * t93 / 0.3e1 - t376 * t100 / 0.3e1 + 0.1e2 / 0.3e1 * t36 * t871 - 0.4e1 * t36 * t876 * sigma[0];
  t881 = t89 * t880;
  t882 = t86 * t881;
  t885 = t96 * t387;
  t888 = t96 * t392;
  t891 = t96 * t403;
  t894 = t96 * t363;
  t897 = t115 * t398;
  t902 = 0.2e1 * t897 * t58 + 0.16e2 / 0.3e1 * t399 * t118;
  t903 = t110 * t902;
  t904 = t86 * t903;
  t910 = -0.4e1 / 0.9e1 * t28 * t305 - 0.4e1 / 0.9e1 * t28 * t328 + 0.32e2 / 0.27e2 * t28 * t277 - 0.8e1 / 0.9e1 * t671 * t850 - 0.8e1 / 0.9e1 * t671 * t854 + 0.4e1 / 0.9e1 * t698 * t672 * t287 + 0.4e1 / 0.9e1 * t698 * t672 * t312 + 0.8e1 / 0.9e1 * t698 * t49 * t318 - 0.2e1 / 0.9e1 * t85 * t882 + 0.16e2 / 0.27e2 * t85 * t885 - 0.32e2 / 0.27e2 * t85 * t888 + 0.16e2 / 0.27e2 * t85 * t891 - 0.32e2 / 0.27e2 * t85 * t894 - 0.2e1 / 0.9e1 * t85 * t904 + 0.8e1 / 0.9e1 * t698 * t679 * t282;
  t911 = t841 + t910;
  t916 = my_piecewise3(t3, 0, -t7 * t72 * t407 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t911);
  tv3rhosigma20 = 0.2e1 * rho[0] * t916 + 0.2e1 * t411;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t921 = t345 * t196;
  t923 = t921 * t286 * t103;
  t926 = t757 * t612 * t121;
  t929 = t345 * t346 * t303;
  t935 = t757 * t317 * t103;
  t937 = t345 * t48;
  t939 = t937 * t607 * t121;
  t943 = t345 * t236 * t326;
  t946 = my_piecewise3(t3, 0, -0.2e1 / 0.3e1 * t748 * t414 - t344 * t923 - t344 * t926 + t344 * t929 / 0.2e1 - 0.4e1 / 0.3e1 * t748 * t418 - t344 * t935 - 0.3e1 * t344 * t939 + t344 * t943);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t946 + 0.2e1 * t421;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t951 = t235 * t56;
  t953 = t757 * t951 * t103;
  t956 = t450 * t56;
  t958 = t937 * t956 * t121;
  t962 = my_piecewise3(t3, 0, 0.2e1 / 0.3e1 * t344 * t428 + 0.2e1 * t426 * t953 + 0.6e1 * t426 * t958);
  tv3rholapl20 = 0.2e1 * rho[0] * t962 + 0.2e1 * t431;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t965 = t391 * t152;
  t966 = t451 * t965;
  t967 = t86 * t966;
  t970 = t317 * t402;
  t974 = t362 * t143;
  t975 = t464 * t974;
  t976 = t86 * t975;
  t979 = t822 * t152;
  t983 = t281 * t386;
  t987 = t788 * t152;
  t991 = t286 * t402;
  t1000 = t148 * t148;
  t1001 = 0.1e1 / t1000;
  t1002 = t55 * t1001;
  t1005 = -0.6e1 * t1002 * t58 + 0.12e2 * t398;
  t1006 = t110 * t1005;
  t1007 = t86 * t1006;
  t1019 = t36 / t37 / t148;
  t1022 = t36 * t149;
  t1027 = 0.1e1 / t511;
  t1031 = 0.3e1 / 0.8e1 * t1019 * t45 - 0.3e1 / 0.8e1 * t1022 * t140 - t376 * t383 / 0.4e1 + 0.3e1 / 0.2e1 * t36 * t1027 * t523;
  t1032 = t89 * t1031;
  t1033 = t86 * t1032;
  t1036 = t612 * t391;
  t1040 = -0.4e1 / 0.3e1 * t85 * t967 + 0.4e1 / 0.3e1 * t85 * t316 * t970 - 0.4e1 / 0.3e1 * t85 * t976 - 0.4e1 / 0.3e1 * t85 * t280 * t979 + 0.4e1 / 0.3e1 * t85 * t280 * t983 + 0.2e1 / 0.3e1 * t85 * t203 * t987 + 0.2e1 / 0.3e1 * t85 * t203 * t991 - 0.2e1 / 0.3e1 * t28 * t388 - 0.2e1 / 0.3e1 * t28 * t404 - 0.2e1 / 0.9e1 * t85 * t1007 + 0.4e1 / 0.3e1 * t28 * t364 + 0.4e1 / 0.3e1 * t698 * t672 * t367 + 0.4e1 / 0.3e1 * t28 * t393 - 0.2e1 / 0.9e1 * t85 * t1033 - 0.4e1 / 0.3e1 * t85 * t203 * t1036;
  t1044 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1040);
  tv3sigma30 = 0.2e1 * rho[0] * t1044;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1047 = t345 * t753 * t362;
  t1050 = t757 * t612 * t152;
  t1054 = t345 * t346 * t386;
  t1058 = t345 * t451 * t391;
  t1062 = t345 * t236 * t402;
  t1065 = my_piecewise3(t3, 0, -t344 * t1047 - 0.2e1 * t344 * t1050 + t344 * t1054 / 0.2e1 - 0.3e1 * t344 * t1058 + t344 * t1062);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1065;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1068 = t757 * t951 * t143;
  t1072 = t937 * t956 * t152;
  t1076 = t345 * t236 * t149;
  t1080 = my_piecewise3(t3, 0, 0.2e1 * t426 * t1068 + 0.6e1 * t426 * t1072 + 0.2e1 * t426 * t1076);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1080;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1084 = t163 * t33 * params->beta * t25;
  t1086 = t345 * t451 * t149;
  t1089 = my_piecewise3(t3, 0, -0.12e2 * t1084 * t1086);
  tv3lapl30 = 0.2e1 * rho[0] * t1089;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1105 = t235 * t198;
  t1110 = t450 * t103;
  t1151 = t235 * t229;
  t1156 = t215 * t88;
  t1182 = 0.16e2 / 0.3e1 * t85 * t280 * t1105 * t237 + 0.16e2 / 0.3e1 * t85 * t203 * t1110 * t452 + 0.16e2 / 0.9e1 * t85 * t280 * t475 * t527 + 0.8e1 / 0.9e1 * t85 * t203 * t109 * t527 * t121 + 0.4e1 / 0.3e1 * t85 * t203 * t480 * t254 + 0.8e1 / 0.9e1 * t85 * t203 * t204 * t546 - 0.8e1 * t85 * t316 * t450 * t237 * t254 + 0.16e2 / 0.9e1 * t85 * t316 * t457 * t546 + 0.16e2 / 0.3e1 * t85 * t621 * t109 * t465 * t121 - 0.8e1 * t85 * t621 * t61 * t198 * t229 - 0.8e1 / 0.3e1 * t85 * t203 * t1151 * t237 + 0.704e3 / 0.27e2 * t85 * t1156 * t205 - 0.64e2 / 0.9e1 * t85 * t492 * t481 - 0.64e2 / 0.9e1 * t85 * t492 * t485 - 0.128e3 / 0.9e1 * t85 * t629 * t458 + 0.128e3 / 0.9e1 * t85 * t652 * t471 - 0.128e3 / 0.9e1 * t85 * t652 * t476 + 0.128e3 / 0.9e1 * t85 * t492 * t445 - 0.8e1 / 0.3e1 * t85 * t280 * t470 * t254;
  t1184 = 0.1e1 / t33 / t296;
  t1190 = t103 * t121;
  t1200 = 0.1e1 / t449 / t60;
  t1201 = t48 * t1200;
  t1202 = t237 * t237;
  t1207 = t254 * t254;
  t1216 = 0.1e1 / t462 / t47;
  t1217 = t1216 * t61;
  t1218 = t198 * t198;
  t1242 = t511 * t181;
  t1254 = 0.1e1 / t98 / t521 / t97;
  t1302 = t229 * t229;
  t1310 = 0.41888e5 / 0.729e3 * t28 * t31 * t1184 * t48 * t61 - 0.16e2 / 0.3e1 * t671 * t673 * t1190 * t254 - 0.16e2 / 0.3e1 * t671 * t680 * t1190 * t229 + 0.16e2 / 0.3e1 * t85 * t86 * t1201 * t1202 + 0.4e1 / 0.3e1 * t85 * t86 * t236 * t1207 + 0.128e3 / 0.9e1 * t85 * t96 * t466 + 0.16e2 / 0.3e1 * t85 * t86 * t1217 * t1218 - 0.352e3 / 0.27e2 * t85 * t215 * t230 - 0.352e3 / 0.27e2 * t85 * t215 * t255 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (0.364e4 / 0.81e2 * t38 * t382 * t44 + 0.5768e4 / 0.27e2 * t95 * t30 * t1184 * t99 - 0.37216e5 / 0.81e2 * t219 * t29 / t19 / t874 * t225 + 0.1792e5 / 0.27e2 * t36 * t397 / t1242 * t523 - 0.512e4 / 0.27e2 * t36 * t1000 / t33 / t511 / t296 * t1254 * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * ((0.20944e5 / 0.81e2 * t31 * t1184 - 0.616e4 / 0.81e2 * t51 * t506) * t56 * t58 + 0.32e2 / 0.3e1 * t537 * t118 + 0.8e2 / 0.3e1 * t247 * t251 + 0.32e3 / 0.27e2 * t116 * t543 - 0.8e2 / 0.81e2 * t57 * t41) + 0.9856e4 / 0.243e3 * t85 * t507 * t104 + 0.9856e4 / 0.243e3 * t85 * t507 * t122 + 0.64e2 / 0.27e2 * t85 * t96 * t547 + 0.704e3 / 0.27e2 * t85 * t215 * t199 + 0.704e3 / 0.27e2 * t85 * t215 * t238 + 0.64e2 / 0.27e2 * t85 * t96 * t528 + 0.4e1 / 0.3e1 * t85 * t86 * t197 * t1302 + 0.128e3 / 0.9e1 * t85 * t96 * t453;
  t1316 = my_piecewise3(t3, 0, 0.1e2 / 0.27e2 * t7 * t18 * t78 * t66 - 0.5e1 / 0.9e1 * t7 * t434 * t126 + t7 * t174 * t259 / 0.2e1 - t7 * t72 * t568 / 0.2e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t1182 + t1310));
  tv4rho40 = 0.2e1 * rho[0] * t1316 + 0.8e1 * t573;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1357 = t235 * t303;
  t1377 = t450 * t326;
  t1382 = t96 * t463;
  t1386 = t86 * t1216;
  t1391 = t450 * t143;
  t1406 = -0.2464e4 / 0.243e3 * t28 * t507 * t134 - 0.32e2 / 0.9e1 * t85 * t629 * t647 + 0.2e1 / 0.3e1 * t85 * t203 * t109 * t692 * t103 + 0.2e1 / 0.3e1 * t85 * t203 * t633 * t229 + 0.2e1 / 0.9e1 * t85 * t203 * t311 * t527 + 0.4e1 / 0.3e1 * t85 * t316 * t235 * t692 * t121 + 0.4e1 / 0.3e1 * t85 * t316 * t642 * t254 - 0.4e1 / 0.3e1 * t85 * t203 * t1357 * t237 - 0.4e1 / 0.3e1 * t85 * t280 * t633 * t198 - 0.4e1 * t85 * t621 * t589 * t198 + 0.176e3 / 0.27e2 * t85 * t1156 * t312 + 0.352e3 / 0.27e2 * t85 * t215 * t48 * t318 - 0.4e1 * t85 * t316 * t1377 * t237 + 0.32e2 / 0.3e1 * t85 * t1382 * t622 + 0.16e2 / 0.3e1 * t85 * t1386 * t281 * t465 + 0.4e1 / 0.3e1 * t85 * t203 * t1391 * t452 + 0.32e2 / 0.9e1 * t85 * t652 * t617 + 0.4e1 / 0.3e1 * t85 * t621 * t311 * t465 + 0.32e2 / 0.3e1 * t85 * t629 * t608;
  t1407 = t1200 * t152;
  t1428 = t109 * t725;
  t1473 = t35 * t463;
  t1474 = t1473 * t61;
  t1484 = 0.16e2 / 0.3e1 * t85 * t316 * t1407 * t452 + 0.32e2 / 0.9e1 * t85 * t492 * t613 + 0.4e1 / 0.3e1 * t85 * t280 * t61 * t725 * t103 + 0.4e1 / 0.3e1 * t85 * t280 * t589 * t229 + 0.4e1 / 0.9e1 * t85 * t280 * t281 * t527 + 0.2e1 / 0.3e1 * t85 * t203 * t1428 * t121 + 0.2e1 / 0.3e1 * t85 * t203 * t598 * t254 + 0.2e1 / 0.9e1 * t85 * t203 * t286 * t546 + 0.4e1 / 0.9e1 * t85 * t316 * t317 * t546 + 0.352e3 / 0.27e2 * t85 * t215 * t196 * t282 + 0.176e3 / 0.27e2 * t85 * t1156 * t287 - 0.64e2 / 0.9e1 * t85 * t652 * t590 - 0.32e2 / 0.9e1 * t85 * t652 * t594 - 0.32e2 / 0.9e1 * t85 * t492 * t599 - 0.16e2 / 0.9e1 * t85 * t492 * t603 - 0.32e2 / 0.9e1 * t85 * t492 * t634 - 0.16e2 / 0.9e1 * t85 * t492 * t638 - 0.64e2 / 0.9e1 * t85 * t629 * t643 - 0.4e1 * t671 * t1474 * t681 * t229 - 0.8e1 / 0.3e1 * t671 * t680 * t303 * t103 * t121;
  t1495 = t679 * t235;
  t1501 = t143 * t121;
  t1529 = t672 * t450;
  t1535 = t49 * t450;
  t1536 = t152 * t121;
  t1541 = t1473 * t109;
  t1547 = t78 * t196;
  t1548 = t1547 * t109;
  t1552 = t78 * t88;
  t1553 = t1552 * t235;
  t1572 = -0.4e1 / 0.3e1 * t671 * t680 * t143 * t229 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t681 * t254 + 0.8e1 / 0.3e1 * t671 * t1495 * t143 * t237 * t103 - 0.4e1 / 0.3e1 * t671 * t673 * t1501 * t254 + 0.8e1 / 0.3e1 * t671 * t1495 * t152 * t198 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t674 * t229 - 0.8e1 / 0.3e1 * t671 * t673 * t326 * t103 * t121 - 0.4e1 / 0.3e1 * t671 * t673 * t152 * t229 * t121 - 0.4e1 / 0.3e1 * t671 * t673 * t674 * t254 + 0.4e1 * t671 * t1529 * t152 * t237 * t103 - 0.4e1 * t671 * t1535 * t1536 * t254 + 0.4e1 * t671 * t1541 * t143 * t198 * t121 + 0.64e2 / 0.9e1 * t671 * t1548 * t682 + 0.64e2 / 0.9e1 * t671 * t1553 * t675 + 0.2464e4 / 0.243e3 * t85 * t507 * t144 + 0.2464e4 / 0.243e3 * t85 * t507 * t153 - 0.4e1 / 0.3e1 * t698 * t672 * t445 - 0.4e1 / 0.3e1 * t698 * t679 * t471 - 0.176e3 / 0.27e2 * t85 * t215 * t304;
  t1655 = 0.16e2 / 0.9e1 * t85 * t96 * t726 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-0.14e3 / 0.27e2 * t138 * t502 - 0.364e3 / 0.9e1 * t36 * t508 + 0.332e4 / 0.27e2 * t295 * t513 * t225 * sigma[0] - 0.1952e4 / 0.9e1 * t36 * t519 * t523 * t148 + 0.64e3 / 0.9e1 * t36 / t33 / t511 / t379 * t1254 * t397 * t30) + 0.16e2 / 0.9e1 * t85 * t96 * t693 - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (-t536 * t149 * t58 - 0.8e1 * t686 * t118 - 0.4e2 / 0.3e1 * t322 * t251 - 0.8e2 / 0.27e2 * t150 * t543) - 0.32e2 / 0.9e1 * t698 * t1552 * t205 + 0.4e1 / 0.3e1 * t698 * t679 * t476 + 0.2e1 / 0.3e1 * t698 * t672 * t481 - 0.176e3 / 0.27e2 * t85 * t215 * t327 + 0.2e1 / 0.3e1 * t698 * t672 * t485 + 0.4e1 / 0.3e1 * t698 * t49 * t458 - 0.4e1 / 0.3e1 * t28 * t467 - 0.4e1 / 0.3e1 * t28 * t454 - 0.32e2 / 0.9e1 * t28 * t489 - 0.32e2 / 0.9e1 * t28 * t496 + 0.16e2 / 0.9e1 * t28 * t565 - 0.2e1 / 0.9e1 * t28 * t548 - 0.176e3 / 0.27e2 * t28 * t556 - 0.176e3 / 0.27e2 * t28 * t559 + 0.16e2 / 0.9e1 * t28 * t562 - 0.2e1 / 0.9e1 * t28 * t529;
  t1662 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t434 * t157 + t7 * t174 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t72 * t734 - 0.3e1 / 0.8e1 * t7 * t20 * (t1406 + t1484 + t1572 + t1655));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t1662 + 0.6e1 * t739;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t1689 = t463 * t109;
  t1718 = t163 * t743 * t25;
  t1727 = -0.3e1 * t344 * t757 * t1151 * t121 - 0.3e1 * t344 * t757 * t444 * t254 + 0.12e2 * t344 * t345 * t1201 * t452 - 0.9e1 * t344 * t937 * t450 * t121 * t254 + 0.4e1 * t748 * t755 + 0.8e1 * t748 * t759 + 0.12e2 * t748 * t767 + 0.3e1 * t344 * t345 * t1689 * t465 + 0.6e1 * t344 * t921 * t1105 * t121 - 0.3e1 * t344 * t921 * t204 * t229 - 0.2e1 * t748 * t763 - 0.4e1 * t748 * t771 + t344 * t345 * t346 * t527 / 0.2e1 + t344 * t345 * t236 * t546 + 0.14e3 / 0.27e2 * t163 * t500 * params->beta * t168 + 0.14e2 / 0.3e1 * t1718 * t348 + 0.28e2 / 0.3e1 * t1718 * t352 + 0.9e1 * t344 * t757 * t1110 * t237;
  t1728 = my_piecewise3(t3, 0, t1727);
  tv4rho3lapl0 = 0.2e1 * rho[0] * t1728 + 0.6e1 * t774;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t1742 = t235 * t362;
  t1751 = t450 * t402;
  t1756 = t1200 * t391;
  t1765 = t235 * t386;
  t1784 = 0.16e2 / 0.3e1 * t85 * t1386 * t817 * t198 + 0.8e1 / 0.9e1 * t85 * t280 * t1742 * t237 - 0.4e1 / 0.9e1 * t85 * t280 * t807 * t198 - 0.4e1 / 0.3e1 * t85 * t316 * t1751 * t237 + 0.16e2 / 0.3e1 * t85 * t316 * t1756 * t237 - 0.4e1 / 0.3e1 * t85 * t621 * t783 * t198 - 0.4e1 / 0.9e1 * t85 * t203 * t1765 * t237 + 0.8e1 / 0.9e1 * t85 * t280 * t793 * t198 + 0.352e3 / 0.81e2 * t85 * t1156 * t367 + 0.8e1 / 0.9e1 * t85 * t316 * t317 * t692 - 0.64e2 / 0.27e2 * t85 * t492 * t831;
  t1809 = t109 * t880;
  t1826 = -0.64e2 / 0.27e2 * t85 * t492 * t835 - 0.64e2 / 0.27e2 * t85 * t652 * t784 - 0.32e2 / 0.27e2 * t85 * t492 * t789 + 0.4e1 / 0.9e1 * t85 * t280 * t783 * t229 + 0.2e1 / 0.9e1 * t85 * t203 * t788 * t254 - 0.16e2 / 0.9e1 * t698 * t676 + 0.8e1 / 0.9e1 * t85 * t280 * t61 * t880 * t103 + 0.4e1 / 0.9e1 * t85 * t203 * t1809 * t121 - 0.16e2 / 0.9e1 * t698 * t683 + 0.4e1 / 0.9e1 * t85 * t203 * t109 * t902 * t103 + 0.8e1 / 0.9e1 * t85 * t316 * t235 * t902 * t121;
  t1868 = -0.128e3 / 0.27e2 * t85 * t652 * t827 - 0.4e1 / 0.3e1 * t85 * t621 * t817 * t229 - 0.4e1 / 0.9e1 * t85 * t280 * t822 * t254 + 0.8e1 / 0.9e1 * t85 * t280 * t281 * t725 + 0.4e1 / 0.9e1 * t85 * t203 * t1428 * t152 + 0.8e1 / 0.9e1 * t85 * t203 * t598 * t326 - 0.32e2 / 0.27e2 * t85 * t492 * t808 - 0.64e2 / 0.27e2 * t85 * t629 * t813 + 0.2e1 / 0.9e1 * t85 * t203 * t807 * t229 + 0.4e1 / 0.9e1 * t85 * t316 * t812 * t254 + 0.64e2 / 0.9e1 * t85 * t1382 * t818;
  t1914 = 0.64e2 / 0.27e2 * t85 * t652 * t823 + 0.64e2 / 0.27e2 * t85 * t492 * t794 + 0.64e2 / 0.9e1 * t85 * t629 * t799 - 0.128e3 / 0.27e2 * t85 * t629 * t803 - 0.4e1 / 0.9e1 * t85 * t203 * t793 * t229 - 0.4e1 / 0.3e1 * t85 * t316 * t798 * t254 + 0.4e1 / 0.9e1 * t85 * t203 * t286 * t692 + 0.32e2 / 0.9e1 * t671 * t1495 * t848 * t1190 + 0.8e1 / 0.3e1 * t671 * t1541 * t848 * t198 + 0.8e1 / 0.3e1 * t671 * t1529 * t848 * t237 + 0.8e1 / 0.3e1 * t671 * t1541 * t362 * t103 * t121 - 0.16e2 / 0.3e1 * t671 * t1474 * t681 * t303;
  t1978 = -0.16e2 / 0.9e1 * t671 * t680 * t1501 * t303 + 0.128e3 / 0.27e2 * t671 * t1548 * t849 + 0.128e3 / 0.27e2 * t671 * t1553 * t853 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-0.7e1 / 0.9e1 * t373 * t212 + 0.7e1 / 0.9e1 * t376 * t216 - 0.22e2 * t36 * t226 + 0.188e3 / 0.3e1 * t36 * t721 * sigma[0] - 0.8e2 / 0.3e1 * t36 / t33 / t1242 * t1254 * t148 * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (0.2e1 * t246 * t398 * t58 + 0.32e2 / 0.3e1 * t897 * t118 + 0.8e2 / 0.9e1 * t399 * t251) + 0.16e2 / 0.9e1 * t698 * t679 * t590 + 0.8e1 / 0.9e1 * t698 * t679 * t594 + 0.8e1 / 0.9e1 * t698 * t672 * t599 + 0.4e1 / 0.9e1 * t698 * t672 * t603 - 0.176e3 / 0.81e2 * t85 * t215 * t403 + 0.352e3 / 0.81e2 * t85 * t215 * t363;
  t1982 = t326 * t326;
  t2017 = 0.352e3 / 0.81e2 * t85 * t215 * t392 + 0.8e1 / 0.9e1 * t85 * t86 * t236 * t1982 - 0.176e3 / 0.81e2 * t85 * t215 * t387 - 0.8e1 / 0.3e1 * t698 * t49 * t608 + 0.32e2 / 0.27e2 * t85 * t96 * t881 - 0.128e3 / 0.27e2 * t698 * t1547 * t282 - 0.8e1 / 0.3e1 * t698 * t1473 * t622 - 0.64e2 / 0.27e2 * t698 * t1552 * t287 - 0.8e1 / 0.9e1 * t698 * t672 * t613 - 0.8e1 / 0.9e1 * t698 * t679 * t617 + 0.32e2 / 0.27e2 * t85 * t96 * t903 - 0.64e2 / 0.27e2 * t698 * t1552 * t312;
  t2034 = t303 * t303;
  t2049 = -0.128e3 / 0.27e2 * t698 * t79 * t318 + 0.8e1 / 0.9e1 * t698 * t672 * t634 + 0.4e1 / 0.9e1 * t698 * t672 * t638 + 0.16e2 / 0.9e1 * t698 * t49 * t643 + 0.8e1 / 0.9e1 * t698 * t49 * t647 + 0.8e1 / 0.9e1 * t85 * t86 * t197 * t2034 - 0.4e1 / 0.9e1 * t28 * t694 + 0.64e2 / 0.27e2 * t28 * t730 - 0.4e1 / 0.9e1 * t28 * t727 - 0.352e3 / 0.81e2 * t28 * t705 + 0.64e2 / 0.27e2 * t28 * t708;
  t2075 = t303 * t152;
  t2080 = t143 * t326;
  t2101 = -0.352e3 / 0.81e2 * t28 * t702 - 0.8e1 / 0.9e1 * t671 * t673 * t402 * t103 * t121 - 0.16e2 / 0.3e1 * t671 * t1535 * t1536 * t326 - 0.8e1 / 0.9e1 * t671 * t680 * t386 * t103 * t121 + 0.8e1 / 0.3e1 * t671 * t1529 * t391 * t103 * t121 - 0.16e2 / 0.9e1 * t671 * t673 * t674 * t326 - 0.16e2 / 0.9e1 * t671 * t680 * t2075 * t103 - 0.16e2 / 0.9e1 * t671 * t680 * t2080 * t103 - 0.8e1 / 0.9e1 * t671 * t680 * t848 * t229 - 0.16e2 / 0.9e1 * t671 * t673 * t2075 * t121 - 0.16e2 / 0.9e1 * t671 * t673 * t2080 * t121 - 0.8e1 / 0.9e1 * t671 * t673 * t848 * t254;
  t2109 = my_piecewise3(t3, 0, t7 * t174 * t407 / 0.12e2 - t7 * t72 * t911 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t1784 + t1826 + t1868 + t1914 + t1978 + t2017 + t2049 + t2101));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2109 + 0.4e1 * t916;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2130 = params->beta * t25 * t26;
  t2131 = t163 * t40 * t2130;
  t2133 = t30 * t196 * t235;
  t2146 = t30 * t88 * t450;
  t2150 = t345 * t463;
  t2159 = -0.4e1 / 0.3e1 * t748 * t929 + t344 * t345 * t346 * t725 / 0.2e1 - 0.8e1 / 0.3e1 * t748 * t943 + t344 * t345 * t236 * t692 + 0.12e2 * t344 * t937 * t1407 * t237 + 0.4e1 * t2131 * t2133 * t682 + 0.3e1 * t344 * t757 * t1391 * t237 + 0.2e1 * t344 * t921 * t317 * t198 + 0.6e1 * t2131 * t2146 * t675 + 0.3e1 * t344 * t2150 * t286 * t198 + 0.28e2 / 0.9e1 * t1718 * t418 + 0.8e1 / 0.3e1 * t748 * t935;
  t2197 = 0.8e1 * t748 * t939 - 0.2e1 * t344 * t757 * t642 * t103 - t344 * t757 * t317 * t229 - 0.6e1 * t344 * t937 * t1377 * t121 - 0.3e1 * t344 * t937 * t607 * t254 + 0.8e1 / 0.3e1 * t748 * t923 + 0.8e1 / 0.3e1 * t748 * t926 - 0.2e1 * t344 * t921 * t598 * t103 - t344 * t921 * t286 * t229 - 0.2e1 * t344 * t757 * t1357 * t121 - t344 * t757 * t612 * t254 + 0.14e2 / 0.9e1 * t1718 * t414;
  t2199 = my_piecewise3(t3, 0, t2159 + t2197);
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t2199 + 0.4e1 * t946;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t2214 = t163 * t423 * t2130;
  t2224 = t1200 * t56;
  t2234 = my_piecewise3(t3, 0, -0.8e1 / 0.9e1 * t748 * t428 - 0.4e1 / 0.3e1 * t344 * t953 - 0.4e1 * t344 * t958 - 0.4e1 * t426 * t921 * t951 * t198 - 0.12e2 * t2214 * t2146 * t56 * t103 * t121 + 0.2e1 * t426 * t757 * t951 * t229 - 0.24e2 * t426 * t937 * t2224 * t237 + 0.6e1 * t426 * t937 * t956 * t254);
  tv4rho2lapl20 = 0.2e1 * rho[0] * t2234 + 0.4e1 * t962;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t2245 = t109 * t1031;
  t2259 = t152 * t402;
  t2268 = t143 * t391;
  t2281 = t386 * t152;
  t2286 = t143 * t402;
  t2295 = t362 * t152;
  t2308 = t143 * t386;
  t2313 = 0.4e1 / 0.9e1 * t85 * t280 * t61 * t1031 * t103 + 0.2e1 / 0.9e1 * t85 * t203 * t2245 * t121 - 0.4e1 / 0.3e1 * t85 * t203 * t1357 * t391 + 0.2e1 / 0.9e1 * t85 * t203 * t109 * t1005 * t103 - 0.4e1 / 0.3e1 * t671 * t673 * t2259 * t103 - 0.4e1 * t671 * t1535 * t2259 * t121 + 0.8e1 / 0.3e1 * t671 * t1495 * t2268 * t103 + 0.4e1 * t671 * t1529 * t2268 * t121 - 0.8e1 / 0.3e1 * t671 * t673 * t848 * t326 - 0.4e1 / 0.3e1 * t671 * t673 * t2281 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t2286 * t103 - 0.4e1 / 0.3e1 * t671 * t673 * t2286 * t121 + 0.4e1 * t671 * t1541 * t2295 * t103 + 0.8e1 / 0.3e1 * t671 * t1495 * t2295 * t121 - 0.8e1 / 0.3e1 * t671 * t680 * t848 * t303 - 0.4e1 * t671 * t1474 * t2308 * t103;
  t2353 = t109 * t974;
  t2375 = -0.4e1 / 0.3e1 * t671 * t680 * t2308 * t121 - 0.4e1 / 0.3e1 * t671 * t680 * t2281 * t103 + 0.32e2 / 0.9e1 * t85 * t492 * t1036 - 0.16e2 / 0.9e1 * t85 * t492 * t991 + 0.32e2 / 0.9e1 * t85 * t652 * t979 - 0.32e2 / 0.9e1 * t85 * t652 * t983 - 0.16e2 / 0.9e1 * t85 * t492 * t987 - 0.32e2 / 0.9e1 * t85 * t629 * t970 + 0.4e1 / 0.3e1 * t85 * t316 * t642 * t402 + 0.4e1 / 0.3e1 * t85 * t316 * t317 * t902 + 0.16e2 / 0.3e1 * t85 * t1386 * t61 * t974 * t103 + 0.4e1 / 0.3e1 * t85 * t621 * t2353 * t121 - 0.4e1 * t85 * t621 * t817 * t303 - 0.4e1 / 0.3e1 * t85 * t280 * t822 * t326 + 0.4e1 / 0.3e1 * t698 * t679 * t784 + 0.2e1 / 0.3e1 * t698 * t672 * t789 + 0.2e1 / 0.3e1 * t698 * t672 * t808;
  t2451 = 0.4e1 / 0.3e1 * t698 * t49 * t813 + 0.16e2 / 0.27e2 * t85 * t96 * t1032 + 0.16e2 / 0.27e2 * t85 * t96 * t1006 - 0.32e2 / 0.9e1 * t698 * t1552 * t367 + 0.32e2 / 0.9e1 * t85 * t96 * t966 + 0.32e2 / 0.9e1 * t85 * t96 * t975 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-t1019 * t93 / 0.2e1 + t1022 * t100 / 0.2e1 + t376 * t871 / 0.3e1 - 0.14e2 * t36 * t876 + 0.1e2 * t36 / t33 / t518 * t1254 * sigma[0] * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (-0.6e1 * t115 * t1001 * t58 - 0.16e2 * t1002 * t118) - 0.4e1 * t698 * t1473 * t818 - 0.4e1 / 0.3e1 * t698 * t679 * t823 + 0.8e1 / 0.3e1 * t698 * t679 * t827 + 0.4e1 / 0.3e1 * t698 * t672 * t831 + 0.4e1 / 0.3e1 * t698 * t672 * t835 - 0.4e1 / 0.3e1 * t698 * t672 * t794 - 0.4e1 * t698 * t49 * t799 + 0.8e1 / 0.3e1 * t698 * t49 * t803 - 0.2e1 / 0.3e1 * t28 * t882;
  t2495 = t450 * t965;
  t2509 = -0.2e1 / 0.3e1 * t28 * t904 - 0.32e2 / 0.9e1 * t28 * t894 - 0.32e2 / 0.9e1 * t28 * t888 + 0.16e2 / 0.9e1 * t28 * t885 + 0.16e2 / 0.9e1 * t28 * t891 + 0.4e1 / 0.9e1 * t85 * t316 * t235 * t1005 * t121 - 0.8e1 / 0.3e1 * t698 * t850 - 0.8e1 / 0.3e1 * t698 * t854 + 0.4e1 / 0.3e1 * t85 * t280 * t589 * t386 + 0.4e1 / 0.3e1 * t85 * t280 * t281 * t880 + 0.2e1 / 0.3e1 * t85 * t203 * t1809 * t152 + 0.2e1 / 0.3e1 * t85 * t203 * t788 * t326 + 0.2e1 / 0.3e1 * t85 * t203 * t598 * t402 + 0.2e1 / 0.3e1 * t85 * t203 * t286 * t902 + 0.4e1 / 0.3e1 * t85 * t203 * t2495 * t103 + 0.16e2 / 0.3e1 * t85 * t316 * t1200 * t965 * t121 - 0.4e1 * t85 * t316 * t798 * t326;
  t2516 = my_piecewise3(t3, 0, -t7 * t72 * t1040 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2313 + t2375 + t2451 + t2509));
  tv4rhosigma30 = 0.2e1 * rho[0] * t2516 + 0.2e1 * t1044;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t2588 = -t344 * t921 * t788 * t103 - t344 * t757 * t1765 * t121 + t344 * t345 * t346 * t880 / 0.2e1 + 0.4e1 * t748 * t1058 + 0.3e1 * t344 * t757 * t798 * t103 + 0.12e2 * t344 * t937 * t1756 * t121 - 0.6e1 * t344 * t937 * t607 * t326 - 0.4e1 / 0.3e1 * t748 * t1062 - t344 * t757 * t812 * t103 - 0.3e1 * t344 * t937 * t1751 * t121 + t344 * t345 * t236 * t902;
  t2590 = my_piecewise3(t3, 0, 0.4e1 / 0.3e1 * t748 * t1047 + 0.3e1 * t344 * t2150 * t822 * t103 + 0.2e1 * t344 * t921 * t1742 * t121 - 0.2e1 * t344 * t921 * t286 * t303 + 0.8e1 / 0.3e1 * t748 * t1050 + 0.4e1 * t2131 * t2133 * t849 + 0.6e1 * t2131 * t2146 * t853 - 0.2e1 * t344 * t757 * t1357 * t152 - 0.2e1 * t344 * t757 * t612 * t326 - 0.2e1 / 0.3e1 * t748 * t1054 + t2588);
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t2590 + 0.2e1 * t1065;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t2595 = t56 * t143;
  t2610 = t56 * t152;
  t2626 = t235 * t149;
  t2631 = t450 * t149;
  t2636 = -0.2e1 / 0.3e1 * t344 * t1068 - 0.4e1 * t2214 * t2133 * t2595 * t103 - 0.6e1 * t2214 * t2146 * t2595 * t121 + 0.2e1 * t426 * t757 * t951 * t303 - 0.2e1 * t344 * t1072 - 0.6e1 * t2214 * t2146 * t2610 * t103 - 0.24e2 * t2214 * t166 * t1200 * t2610 * t121 + 0.6e1 * t426 * t937 * t956 * t326 - 0.2e1 / 0.3e1 * t344 * t1076 - 0.2e1 * t426 * t757 * t2626 * t103 - 0.6e1 * t426 * t937 * t2631 * t121;
  t2637 = my_piecewise3(t3, 0, t2636);
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t2637 + 0.2e1 * t1080;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t2646 = t1200 * t149;
  t2652 = my_piecewise3(t3, 0, 0.12e2 * t1084 * t757 * t2631 * t103 + 0.48e2 * t1084 * t937 * t2646 * t121 - 0.8e1 * t426 * t1086);
  tv4rholapl30 = 0.2e1 * rho[0] * t2652 + 0.2e1 * t1089;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t2711 = t386 * t386;
  t2716 = -0.16e2 / 0.3e1 * t671 * t680 * t848 * t386 - 0.16e2 / 0.3e1 * t671 * t673 * t2259 * t143 + 0.16e2 / 0.9e1 * t85 * t316 * t317 * t1005 - 0.8e1 / 0.3e1 * t85 * t203 * t1765 * t391 + 0.16e2 / 0.3e1 * t85 * t280 * t1742 * t391 + 0.8e1 / 0.9e1 * t85 * t203 * t286 * t1005 + 0.16e2 / 0.3e1 * t85 * t621 * t2353 * t152 - 0.8e1 * t85 * t621 * t817 * t386 - 0.8e1 / 0.3e1 * t85 * t280 * t822 * t402 + 0.16e2 / 0.9e1 * t85 * t280 * t281 * t1031 + 0.8e1 / 0.9e1 * t85 * t203 * t2245 * t152 + 0.4e1 / 0.3e1 * t85 * t203 * t788 * t402 + 0.16e2 / 0.3e1 * t85 * t203 * t2495 * t143 - 0.8e1 * t85 * t316 * t798 * t402 + 0.4e1 / 0.3e1 * t85 * t86 * t197 * t2711;
  t2756 = t391 * t391;
  t2764 = t402 * t402;
  t2775 = t362 * t362;
  t2794 = 0.8e1 / 0.3e1 * t698 * t672 * t987 - 0.2e1 / 0.9e1 * t85 * t86 * t89 * (-0.15e2 / 0.16e2 * t36 / t37 / t397 * t45 + 0.15e2 / 0.16e2 * t36 * t398 * t140 + 0.5e1 / 0.8e1 * t1022 * t383 + 0.3e1 / 0.4e1 * t36 * t56 * t1027 * t523 - 0.15e2 / 0.4e1 * t36 / t33 / t719 * t1254 * t30) - 0.2e1 / 0.9e1 * t85 * t86 * t110 * (-0.48e2 * t1001 + 0.24e2 * t55 / t1000 / sigma[0] * t58) + 0.16e2 / 0.3e1 * t85 * t86 * t1201 * t2756 + 0.16e2 / 0.3e1 * t698 * t49 * t970 + 0.4e1 / 0.3e1 * t85 * t86 * t236 * t2764 - 0.16e2 / 0.3e1 * t698 * t672 * t1036 + 0.8e1 / 0.3e1 * t698 * t672 * t991 + 0.16e2 / 0.3e1 * t85 * t86 * t1217 * t2775 - 0.16e2 / 0.3e1 * t698 * t679 * t979 + 0.16e2 / 0.3e1 * t698 * t679 * t983 - 0.16e2 / 0.3e1 * t28 * t976 - 0.8e1 / 0.9e1 * t28 * t1033 - 0.8e1 / 0.9e1 * t28 * t1007 - 0.16e2 / 0.3e1 * t28 * t967;
  t2799 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t2716 + t2794));
  tv4sigma40 = 0.2e1 * rho[0] * t2799;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t2841 = my_piecewise3(t3, 0, 0.3e1 * t344 * t345 * t1689 * t974 + 0.6e1 * t344 * t921 * t1742 * t152 - 0.3e1 * t344 * t921 * t286 * t386 + 0.9e1 * t344 * t757 * t1391 * t391 - 0.3e1 * t344 * t757 * t1765 * t152 - 0.3e1 * t344 * t757 * t612 * t402 + t344 * t345 * t346 * t1031 / 0.2e1 + 0.12e2 * t344 * t345 * t1201 * t965 - 0.9e1 * t344 * t937 * t607 * t402 + t344 * t345 * t236 * t1005);
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t2841;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t2876 = my_piecewise3(t3, 0, -0.4e1 * t426 * t757 * t2626 * t143 - 0.12e2 * t2214 * t2146 * t2595 * t152 - 0.12e2 * t426 * t937 * t2631 * t152 - 0.24e2 * t426 * t937 * t2224 * t391 - 0.4e1 * t426 * t345 * t236 * t398 - 0.4e1 * t426 * t921 * t951 * t362 + 0.2e1 * t426 * t757 * t951 * t386 + 0.6e1 * t426 * t937 * t956 * t402);
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t2876;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t2891 = my_piecewise3(t3, 0, 0.12e2 * t1084 * t757 * t2631 * t143 + 0.48e2 * t1084 * t937 * t2646 * t152 + 0.24e2 * t1084 * t345 * t451 * t398);
  tv4sigmalapl30 = 0.2e1 * rho[0] * t2891;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t2900 = my_piecewise3(t3, 0, -0.96e2 * t163 * t52 * params->beta * t25 * t345 * t1201 * t398);
  tv4lapl40 = 0.2e1 * rho[0] * t2900;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t40 * t58 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t40 * t58 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  double t350, t351, t352, t355, t356, t357, t360, t364;
  double t365, t369, t371, t377, t378, t381, t383, t385;
  double t387, t388, t399, t400, t401, t402, t407, t408;
  double t409, t410, t411, t415, t425, t428, t432, t433;
  double t438, t439, t440, t441, t448, t449, t456, t457;
  double t461, t466, t467, t468, t469, t472, t475, t479;
  double t480, t484, t486, t488, t491, t493, tv2rho20, t496;
  double t500, t504, t505, t509, t511, t519, t520, t524;
  double t528, t529, t533, t535, t542, t545, tv2rho21, t550;
  double t555, t559, t560, t566, t567, t572, t576, t577;
  double t586, t588, t589, t600, t601, t602, t603, t608;
  double t609, t610, t611, t612, t616, t626, t629, t633;
  double t634, t639, t640, t641, t642, t649, t650, t657;
  double t658, t662, t667, tv2rho22, t675, t676, t680, t684;
  double t685, t692, t693, t694, t695, t698, t699, t700;
  double t710, t712, t713, t717, t718, t725, t726, t727;
  double t730, t731, t732, t735, t740, t741, t745, t750;
  double tv2rhosigma0, tv2rhosigma1, t757, t759, tv2rhosigma2, t765, tv2rhosigma3, tv2rhosigma4;
  double t770, t774, t778, t779, t786, t787, t788, t789;
  double t792, t793, t794, t804, t806, t807, t811, t812;
  double t819, t820, t821, t824, t825, t826, t829, t834;
  double t835, t839, t844, tv2rhosigma5, t846, t847, t850, t851;
  double t853, t855, t858, t859, t860, t861, t862, t863;
  double t866, t867, t870, tv2rholapl0, t872, t873, t876, t878;
  double t880, tv2rholapl1, t882, t883, t887, tv2rholapl2, t889, t890;
  double t894, t897, t898, t899, t900, t901, t904, t905;
  double t908, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t916, t917;
  double t921, t922, t926, t933, t935, t939, t940, t944;
  double t945, t949, t950, t951, t954, t955, t959, t963;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t970, t971, t975;
  double t976, t980, t987, t989, t993, t994, t998, t999;
  double t1003, t1004, t1005, t1008, t1009, t1013, t1017, tv2sigma25;
  double t1018, t1019, t1022, t1023, t1026, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1027, t1028, t1031, t1032, t1035, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1036, t1037;
  double t1038, t1039, t1042, tv2lapl20, tv2lapl21, t1043, t1044, t1045;
  double t1046, t1049, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t40 * t58 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t350 = t24 * t24;
  t351 = 0.1e1 / t350;
  t352 = t120 * t120;
  t355 = t116 * t7;
  t356 = 0.1e1 / t355;
  t357 = t17 * t356;
  t360 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t117 + 0.2e1 * t357);
  t364 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t352 + 0.4e1 / 0.3e1 * t24 * t360);
  t365 = t364 * t27;
  t369 = t123 * t129;
  t371 = t6 * t369 * t67;
  t377 = 0.1e1 / t128 / t7;
  t378 = t26 * t377;
  t381 = t6 * t378 * t67 / 0.12e2;
  t383 = t6 * t130 * t177;
  t385 = t37 * t37;
  t387 = 0.1e1 / t39 / t385;
  t388 = sigma[0] * t387;
  t399 = 0.1e1 / t141 / t51;
  t400 = t399 * t62;
  t401 = t155 * t155;
  t402 = t400 * t401;
  t407 = t30 * t35 * sigma[0];
  t408 = t41 * t142;
  t409 = t161 * t155;
  t410 = t409 * t172;
  t411 = t408 * t410;
  t415 = 0.1e1 / t38 / t134;
  t425 = 0.1e1 / t38 / t385 / t134;
  t428 = 0.1e1 / t150 / t149;
  t432 = 0.28e2 / 0.9e1 * t43 * t44 * t415 * t48 + 0.2e2 / 0.3e1 * t43 * t388 * t151 - 0.16e2 / 0.9e1 * t43 * t287 * t425 * t428;
  t433 = t143 * t432;
  t438 = 0.1e1 / t160 / t61;
  t439 = t52 * t438;
  t440 = t172 * t172;
  t441 = t439 * t440;
  t448 = 0.88e2 / 0.9e1 * t388 - 0.4e2 / 0.9e1 * lapl[0] * t136;
  t449 = t448 * t57;
  t456 = 0.2e1 * t449 * t40 + 0.32e2 / 0.3e1 * t167 * t53 + 0.8e2 / 0.9e1 * t58 * t39;
  t457 = t162 * t456;
  t461 = 0.176e3 / 0.81e2 * t36 * t388 * t63 + 0.32e2 / 0.27e2 * t36 * t137 * t156 + 0.32e2 / 0.27e2 * t36 * t137 * t173 + 0.4e1 / 0.9e1 * t36 * t42 * t402 + 0.4e1 / 0.9e1 * t407 * t411 - 0.2e1 / 0.9e1 * t36 * t42 * t433 + 0.4e1 / 0.9e1 * t36 * t42 * t441 - 0.2e1 / 0.9e1 * t36 * t42 * t457;
  t466 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t67 - t371 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t177 + t381 - t383 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t461);
  t467 = t78 * t78;
  t468 = 0.1e1 / t467;
  t469 = t185 * t185;
  t472 = t73 * t356;
  t475 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t117 + 0.2e1 * t472);
  t479 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t469 + 0.4e1 / 0.3e1 * t78 * t475);
  t480 = t479 * t27;
  t484 = t188 * t129;
  t486 = t6 * t484 * t111;
  t488 = t80 * t377;
  t491 = t6 * t488 * t111 / 0.12e2;
  t493 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t111 - t486 / 0.4e1 + t491);
  tv2rho20 = 0.2e1 * t182 + 0.2e1 * t198 + t7 * (t466 + t493);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t496 = t351 * t202;
  t500 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t357);
  t504 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t496 * t120 + 0.4e1 / 0.3e1 * t24 * t500);
  t505 = t504 * t27;
  t509 = t205 * t129;
  t511 = t6 * t509 * t67;
  t519 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t67 - t511 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t177 - t371 / 0.8e1 + t381 - t383 / 0.8e1);
  t520 = t468 * t213;
  t524 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t472);
  t528 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t520 * t185 + 0.4e1 / 0.3e1 * t78 * t524);
  t529 = t528 * t27;
  t533 = t216 * t129;
  t535 = t6 * t533 * t111;
  t542 = t6 * t193 * t264;
  t545 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t111 - t535 / 0.8e1 - t486 / 0.8e1 + t491 - 0.3e1 / 0.8e1 * t6 * t189 * t264 - t542 / 0.8e1);
  tv2rho21 = t182 + t198 + t211 + t269 + t7 * (t519 + t545);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t550 = t202 * t202;
  t555 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t117 + 0.2e1 * t357);
  t559 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t550 + 0.4e1 / 0.3e1 * t24 * t555);
  t560 = t559 * t27;
  t566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t67 - t511 / 0.4e1 + t381);
  t567 = t213 * t213;
  t572 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t117 + 0.2e1 * t472);
  t576 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t567 + 0.4e1 / 0.3e1 * t78 * t572);
  t577 = t576 * t27;
  t586 = t82 * t82;
  t588 = 0.1e1 / t84 / t586;
  t589 = sigma[2] * t588;
  t600 = 0.1e1 / t228 / t95;
  t601 = t600 * t106;
  t602 = t242 * t242;
  t603 = t601 * t602;
  t608 = t30 * t35 * sigma[2];
  t609 = t86 * t229;
  t610 = t248 * t242;
  t611 = t610 * t259;
  t612 = t609 * t611;
  t616 = 0.1e1 / t83 / t221;
  t626 = 0.1e1 / t83 / t586 / t221;
  t629 = 0.1e1 / t237 / t236;
  t633 = 0.28e2 / 0.9e1 * t43 * t88 * t616 * t92 + 0.2e2 / 0.3e1 * t43 * t589 * t238 - 0.16e2 / 0.9e1 * t43 * t316 * t626 * t629;
  t634 = t230 * t633;
  t639 = 0.1e1 / t247 / t105;
  t640 = t96 * t639;
  t641 = t259 * t259;
  t642 = t640 * t641;
  t649 = 0.88e2 / 0.9e1 * t589 - 0.4e2 / 0.9e1 * lapl[1] * t223;
  t650 = t649 * t101;
  t657 = 0.2e1 * t650 * t85 + 0.32e2 / 0.3e1 * t254 * t97 + 0.8e2 / 0.9e1 * t102 * t84;
  t658 = t249 * t657;
  t662 = 0.176e3 / 0.81e2 * t36 * t589 * t107 + 0.32e2 / 0.27e2 * t36 * t224 * t243 + 0.32e2 / 0.27e2 * t36 * t224 * t260 + 0.4e1 / 0.9e1 * t36 * t87 * t603 + 0.4e1 / 0.9e1 * t608 * t612 - 0.2e1 / 0.9e1 * t36 * t87 * t634 + 0.4e1 / 0.9e1 * t36 * t87 * t642 - 0.2e1 / 0.9e1 * t36 * t87 * t658;
  t667 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t111 - t535 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t264 + t491 - t542 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t662);
  tv2rho22 = 0.2e1 * t211 + 0.2e1 * t269 + t7 * (t566 + t667);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t675 = t6 * t130 * t297 / 0.8e1;
  t676 = t34 * t136;
  t680 = t62 * t155;
  t684 = t41 * t52;
  t685 = t161 * t172;
  t692 = t41 * t399;
  t693 = t62 * t283;
  t694 = t693 * t155;
  t695 = t692 * t694;
  t698 = t161 * t283;
  t699 = t698 * t172;
  t700 = t408 * t699;
  t710 = t385 * t37;
  t712 = 0.1e1 / t38 / t710;
  t713 = t712 * t428;
  t717 = -0.2e1 / 0.3e1 * t43 * t276 * t145 * t48 - 0.2e1 * t43 * t136 * t151 + 0.2e1 / 0.3e1 * t43 * t713 * sigma[0];
  t718 = t143 * t717;
  t725 = t161 * t292;
  t726 = t725 * t155;
  t727 = t408 * t726;
  t730 = t438 * t292;
  t731 = t730 * t172;
  t732 = t684 * t731;
  t735 = t166 * t288;
  t740 = -0.2e1 * t735 * t40 - 0.16e2 / 0.3e1 * t289 * t53;
  t741 = t162 * t740;
  t745 = -0.16e2 / 0.27e2 * t272 * t676 * t63 - 0.2e1 / 0.9e1 * t36 * t408 * t680 - 0.2e1 / 0.9e1 * t36 * t684 * t685 + 0.16e2 / 0.27e2 * t36 * t137 * t284 + 0.4e1 / 0.9e1 * t407 * t695 + 0.2e1 / 0.9e1 * t407 * t700 - 0.2e1 / 0.9e1 * t36 * t42 * t718 + 0.16e2 / 0.27e2 * t36 * t137 * t293 + 0.2e1 / 0.9e1 * t407 * t727 + 0.4e1 / 0.9e1 * t407 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t741;
  t750 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t297 - t675 - 0.3e1 / 0.8e1 * t6 * t28 * t745);
  tv2rhosigma0 = t7 * t750 + t301;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t757 = t6 * t193 * t326 / 0.8e1;
  t759 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t326 - t757);
  tv2rhosigma2 = t7 * t759 + t330;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t765 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t297 - t675);
  tv2rhosigma3 = t7 * t765 + t301;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t770 = t34 * t223;
  t774 = t106 * t242;
  t778 = t86 * t96;
  t779 = t248 * t259;
  t786 = t86 * t600;
  t787 = t106 * t312;
  t788 = t787 * t242;
  t789 = t786 * t788;
  t792 = t248 * t312;
  t793 = t792 * t259;
  t794 = t609 * t793;
  t804 = t586 * t82;
  t806 = 0.1e1 / t83 / t804;
  t807 = t806 * t629;
  t811 = -0.2e1 / 0.3e1 * t43 * t305 * t232 * t92 - 0.2e1 * t43 * t223 * t238 + 0.2e1 / 0.3e1 * t43 * t807 * sigma[2];
  t812 = t230 * t811;
  t819 = t248 * t321;
  t820 = t819 * t242;
  t821 = t609 * t820;
  t824 = t639 * t321;
  t825 = t824 * t259;
  t826 = t778 * t825;
  t829 = t253 * t317;
  t834 = -0.2e1 * t829 * t85 - 0.16e2 / 0.3e1 * t318 * t97;
  t835 = t249 * t834;
  t839 = -0.16e2 / 0.27e2 * t272 * t770 * t107 - 0.2e1 / 0.9e1 * t36 * t609 * t774 - 0.2e1 / 0.9e1 * t36 * t778 * t779 + 0.16e2 / 0.27e2 * t36 * t224 * t313 + 0.4e1 / 0.9e1 * t608 * t789 + 0.2e1 / 0.9e1 * t608 * t794 - 0.2e1 / 0.9e1 * t36 * t87 * t812 + 0.16e2 / 0.27e2 * t36 * t224 * t322 + 0.2e1 / 0.9e1 * t608 * t821 + 0.4e1 / 0.9e1 * t608 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t835;
  t844 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t326 - t757 - 0.3e1 / 0.8e1 * t6 * t81 * t839);
  tv2rhosigma5 = t7 * t844 + t330;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t846 = t5 * t123;
  t847 = t846 * t332;
  t850 = t129 * params->beta;
  t851 = t331 * t850;
  t853 = t851 * t336 / 0.6e1;
  t855 = t35 * t684 * t161;
  t858 = t332 * t33;
  t859 = t331 * t858;
  t860 = t34 * t54;
  t861 = t142 * t161;
  t862 = t861 * t155;
  t863 = t860 * t862;
  t866 = t439 * t172;
  t867 = t860 * t866;
  t870 = my_piecewise3(t2, 0, -t847 * t336 / 0.2e1 - t853 + 0.5e1 / 0.6e1 * t333 * t855 + t859 * t863 / 0.2e1 + t859 * t867);
  tv2rholapl0 = t7 * t870 + t339;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t872 = t5 * t188;
  t873 = t872 * t332;
  t876 = t340 * t850;
  t878 = t876 * t344 / 0.6e1;
  t880 = my_piecewise3(t72, 0, -t873 * t344 / 0.2e1 - t878);
  tv2rholapl1 = t7 * t880 + t347;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t882 = t5 * t205;
  t883 = t882 * t332;
  t887 = my_piecewise3(t2, 0, -t883 * t336 / 0.2e1 - t853);
  tv2rholapl2 = t7 * t887 + t339;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t889 = t5 * t216;
  t890 = t889 * t332;
  t894 = t35 * t778 * t248;
  t897 = t340 * t858;
  t898 = t34 * t98;
  t899 = t229 * t248;
  t900 = t899 * t242;
  t901 = t898 * t900;
  t904 = t640 * t259;
  t905 = t898 * t904;
  t908 = my_piecewise3(t72, 0, -t890 * t344 / 0.2e1 - t878 + 0.5e1 / 0.6e1 * t341 * t894 + t897 * t901 / 0.2e1 + t897 * t905);
  tv2rholapl3 = t7 * t908 + t347;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t916 = t283 * t283;
  t917 = t400 * t916;
  t921 = t698 * t292;
  t922 = t408 * t921;
  t926 = 0.1e1 / t44 / sigma[0];
  t933 = t385 * rho[0];
  t935 = 0.1e1 / t38 / t933;
  t939 = t43 * t57 * t41 * t151 / 0.4e1 - t43 * t926 * t46 * t48 / 0.4e1 - t43 * t935 * t428 / 0.4e1;
  t940 = t143 * t939;
  t944 = t292 * t292;
  t945 = t439 * t944;
  t949 = t287 * sigma[0];
  t950 = 0.1e1 / t949;
  t951 = t56 * t950;
  t954 = 0.4e1 * t40 * t951 - 0.4e1 * t288;
  t955 = t162 * t954;
  t959 = -0.4e1 / 0.9e1 * t36 * t408 * t693 - 0.4e1 / 0.9e1 * t36 * t684 * t725 + 0.4e1 / 0.9e1 * t36 * t42 * t917 + 0.4e1 / 0.9e1 * t407 * t922 - 0.2e1 / 0.9e1 * t36 * t42 * t940 + 0.4e1 / 0.9e1 * t36 * t42 * t945 - 0.2e1 / 0.9e1 * t36 * t42 * t955;
  t963 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t959);
  tv2sigma20 = t7 * t963;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t970 = t312 * t312;
  t971 = t601 * t970;
  t975 = t792 * t321;
  t976 = t609 * t975;
  t980 = 0.1e1 / t88 / sigma[2];
  t987 = t586 * rho[1];
  t989 = 0.1e1 / t83 / t987;
  t993 = t43 * t101 * t86 * t238 / 0.4e1 - t43 * t980 * t90 * t92 / 0.4e1 - t43 * t989 * t629 / 0.4e1;
  t994 = t230 * t993;
  t998 = t321 * t321;
  t999 = t640 * t998;
  t1003 = t316 * sigma[2];
  t1004 = 0.1e1 / t1003;
  t1005 = t100 * t1004;
  t1008 = 0.4e1 * t1005 * t85 - 0.4e1 * t317;
  t1009 = t249 * t1008;
  t1013 = -0.4e1 / 0.9e1 * t36 * t609 * t787 - 0.4e1 / 0.9e1 * t36 * t778 * t819 + 0.4e1 / 0.9e1 * t36 * t87 * t971 + 0.4e1 / 0.9e1 * t608 * t976 - 0.2e1 / 0.9e1 * t36 * t87 * t994 + 0.4e1 / 0.9e1 * t36 * t87 * t999 - 0.2e1 / 0.9e1 * t36 * t87 * t1009;
  t1017 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t1013);
  tv2sigma25 = t7 * t1017;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1018 = t861 * t283;
  t1019 = t860 * t1018;
  t1022 = t439 * t292;
  t1023 = t860 * t1022;
  t1026 = my_piecewise3(t2, 0, t859 * t1019 / 0.2e1 + t859 * t1023);
  tv2sigmalapl0 = t7 * t1026;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1027 = t899 * t312;
  t1028 = t898 * t1027;
  t1031 = t640 * t321;
  t1032 = t898 * t1031;
  t1035 = my_piecewise3(t72, 0, t897 * t1028 / 0.2e1 + t897 * t1032);
  tv2sigmalapl5 = t7 * t1035;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1036 = 0.1e1 / t39;
  t1037 = t34 * t1036;
  t1038 = t439 * t57;
  t1039 = t1037 * t1038;
  t1042 = my_piecewise3(t2, 0, -0.2e1 * t859 * t1039);
  tv2lapl20 = t7 * t1042;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1043 = 0.1e1 / t84;
  t1044 = t34 * t1043;
  t1045 = t640 * t101;
  t1046 = t1044 * t1045;
  t1049 = my_piecewise3(t72, 0, -0.2e1 * t897 * t1046);
  tv2lapl22 = t7 * t1049;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  double t350, t351, t352, t355, t356, t357, t360, t364;
  double t365, t369, t371, t377, t378, t381, t383, t385;
  double t387, t388, t399, t400, t401, t402, t407, t408;
  double t409, t410, t411, t415, t425, t428, t432, t433;
  double t438, t439, t440, t441, t448, t449, t456, t457;
  double t461, t466, t467, t468, t469, t472, t475, t479;
  double t480, t484, t486, t488, t491, t493, tv2rho20, t496;
  double t500, t504, t505, t509, t511, t519, t520, t524;
  double t528, t529, t533, t535, t542, t545, tv2rho21, t550;
  double t555, t559, t560, t566, t567, t572, t576, t577;
  double t586, t588, t589, t600, t601, t602, t603, t608;
  double t609, t610, t611, t612, t616, t626, t629, t633;
  double t634, t639, t640, t641, t642, t649, t650, t657;
  double t658, t662, t667, tv2rho22, t675, t676, t680, t684;
  double t685, t692, t693, t694, t695, t698, t699, t700;
  double t710, t712, t713, t717, t718, t725, t726, t727;
  double t730, t731, t732, t735, t740, t741, t745, t750;
  double tv2rhosigma0, tv2rhosigma1, t757, t759, tv2rhosigma2, t765, tv2rhosigma3, tv2rhosigma4;
  double t770, t774, t778, t779, t786, t787, t788, t789;
  double t792, t793, t794, t804, t806, t807, t811, t812;
  double t819, t820, t821, t824, t825, t826, t829, t834;
  double t835, t839, t844, tv2rhosigma5, t846, t847, t850, t851;
  double t853, t855, t858, t859, t860, t861, t862, t863;
  double t866, t867, t870, tv2rholapl0, t872, t873, t876, t878;
  double t880, tv2rholapl1, t882, t883, t887, tv2rholapl2, t889, t890;
  double t894, t897, t898, t899, t900, t901, t904, t905;
  double t908, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t916, t917;
  double t921, t922, t926, t933, t935, t939, t940, t944;
  double t945, t949, t950, t951, t954, t955, t959, t963;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t970, t971, t975;
  double t976, t980, t987, t989, t993, t994, t998, t999;
  double t1003, t1004, t1005, t1008, t1009, t1013, t1017, tv2sigma25;
  double t1018, t1019, t1022, t1023, t1026, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1027, t1028, t1031, t1032, t1035, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1036, t1037;
  double t1038, t1039, t1042, tv2lapl20, tv2lapl21, t1043, t1044, t1045;
  double t1046, t1049, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t1053, t1054, t1057, t1060, t1061, t1062, t1065, t1069;
  double t1070, t1074, t1076, t1081, t1083, t1086, t1092, t1093;
  double t1096, t1098, t1101, t1104, t1110, t1111, t1115, t1117;
  double t1122, t1123, t1125, t1127, t1131, t1132, t1139, t1140;
  double t1147, t1150, t1151, t1155, t1156, t1157, t1160, t1161;
  double t1162, t1163, t1164, t1169, t1170, t1176, t1177, t1178;
  double t1179, t1180, t1184, t1185, t1186, t1189, t1190, t1193;
  double t1194, t1195, t1198, t1199, t1205, t1206, t1224, t1229;
  double t1231, t1232, t1235, t1238, t1241, t1245, t1246, t1250;
  double t1252, t1254, t1256, t1258, t1261, t1263, tv3rho30, t1266;
  double t1267, t1268, t1271, t1276, t1277, t1279, t1283, t1284;
  double t1288, t1291, t1295, t1297, t1301, t1310, t1311, t1312;
  double t1315, t1320, t1322, t1326, t1327, t1331, t1334, t1335;
  double t1337, t1346, t1348, t1351, tv3rho31, t1354, t1359, t1363;
  double t1367, t1368, t1372, t1374, t1383, t1384, t1389, t1393;
  double t1397, t1398, t1402, t1404, t1411, t1419, t1421, t1422;
  double tv3rho32, t1427, t1434, t1438, t1439, t1446, t1447, t1454;
  double t1458, t1459, t1475, t1476, t1480, t1481, t1488, t1491;
  double t1492, t1512, t1520, t1522, t1527, t1528, t1530, t1532;
  double t1536, t1537, t1541, t1542, t1543, t1546, t1547, t1548;
  double t1549, t1550, t1555, t1556, t1562, t1563, t1564, t1565;
  double t1566, t1570, t1571, t1572, t1575, t1576, t1579, t1580;
  double t1581, t1584, t1585, t1591, t1592, t1595, t1600, tv3rho33;
  double t1608, t1615, t1617, t1619, t1623, t1630, t1634, t1638;
  double t1646, t1647, t1648, t1652, t1653, t1654, t1658, t1659;
  double t1660, t1663, t1664, t1665, t1668, t1669, t1670, t1673;
  double t1674, t1677, t1678, t1679, t1682, t1683, t1686, t1687;
  double t1688, t1691, t1692, t1693, t1696, t1697, t1698, t1701;
  double t1702, t1705, t1708, t1711, t1712, t1715, t1718, t1719;
  double t1722, t1723, t1724, t1737, t1741, t1743, t1747, t1748;
  double t1755, t1762, t1763, t1775, t1776, t1781, tv3rho2sigma0, tv3rho2sigma1;
  double t1788, t1792, t1794, tv3rho2sigma2, t1800, t1808, tv3rho2sigma3, tv3rho2sigma4;
  double t1814, t1821, t1824, tv3rho2sigma5, t1832, tv3rho2sigma6, tv3rho2sigma7, t1843;
  double t1847, t1851, t1855, t1862, t1870, t1871, t1872, t1876;
  double t1877, t1878, t1892, t1896, t1898, t1902, t1903, t1910;
  double t1917, t1918, t1930, t1931, t1932, t1933, t1936, t1937;
  double t1940, t1941, t1944, t1947, t1948, t1949, t1952, t1953;
  double t1956, t1957, t1958, t1961, t1962, t1965, t1966, t1967;
  double t1970, t1971, t1972, t1975, t1976, t1977, t1980, t1981;
  double t1984, t1987, t1990, t1991, t1992, t1995, t1996, t1999;
  double t2000, t2005, tv3rho2sigma8, t2008, t2009, t2012, t2013, t2014;
  double t2016, t2017, t2018, t2021, t2022, t2025, t2026, t2030;
  double t2034, t2035, t2037, t2038, t2040, t2041, t2042, t2044;
  double t2047, t2050, t2053, t2056, t2057, t2060, t2061, t2063;
  double t2064, tv3rho2lapl0, t2067, t2068, t2071, t2072, t2074, t2076;
  double t2078, tv3rho2lapl1, t2080, t2081, t2084, t2085, t2089, t2098;
  double tv3rho2lapl2, t2100, t2101, t2104, t2105, t2110, t2112, t2115;
  double t2116, t2119, t2122, tv3rho2lapl3, t2125, t2126, t2131, tv3rho2lapl4;
  double t2135, t2138, t2141, t2144, t2145, t2148, t2149, t2153;
  double t2159, t2160, t2163, t2164, t2165, t2167, t2168, t2169;
  double t2172, t2173, t2178, t2179, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2;
  double tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2186, t2199, t2200, t2204, t2220;
  double t2225, t2226, t2236, t2249, t2251, t2254, t2255, t2259;
  double t2262, t2263, t2264, t2267, t2268, t2269, t2272, t2273;
  double t2274, t2277, t2278, t2279, t2282, t2283, t2286, t2287;
  double t2288, t2291, t2292, t2293, t2296, t2297, t2298, t2301;
  double t2302, t2303, t2306, t2307, t2310, t2311, t2314, t2315;
  double t2318, t2319, t2324, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2331, t2333, tv3rhosigma25, t2339, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2356, t2357, t2361, t2391, t2393, t2396, t2397;
  double t2401, t2406, t2407, t2411, t2416, t2417, t2420, t2421;
  double t2422, t2425, t2426, t2427, t2430, t2431, t2432, t2435;
  double t2438, t2439, t2440, t2443, t2444, t2447, t2448, t2451;
  double t2452, t2455, t2456, t2457, t2460, t2461, t2462, t2465;
  double t2466, t2467, t2470, t2471, t2472, t2475, t2476, t2481;
  double tv3rhosigma211, t2486, t2487, t2490, t2491, t2492, t2494, t2495;
  double t2497, t2498, t2503, t2504, t2507, t2508, t2510, t2511;
  double t2512, t2515, t2516, t2518, t2519, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2;
  double tv3rhosigmalapl3, tv3rhosigmalapl4, t2524, t2527, t2529, tv3rhosigmalapl5, t2535, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2539, t2542, t2543, t2544;
  double t2546, t2547, t2549, t2550, t2554, t2557, t2558, t2560;
  double t2561, t2562, t2565, t2566, t2568, t2569, tv3rhosigmalapl11, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2574, t2575, t2578, t2579, t2580;
  double t2581, t2584, t2585, t2586, t2587, t2591, tv3rholapl20, tv3rholapl21;
  double t2596, t2598, tv3rholapl22, t2603, tv3rholapl23, tv3rholapl24, t2607, t2610;
  double t2611, t2612, t2613, t2616, t2617, t2618, t2619, t2623;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2631;
  double t2632, t2635, t2636, t2637, t2640, t2641, t2654, t2667;
  double t2671, t2672, t2676, t2677, t2680, t2681, t2684, t2685;
  double t2688, t2689, t2692, t2693, t2697, t2698, t2701, t2702;
  double t2706, t2710, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t2717, t2718, t2721, t2722, t2723;
  double t2726, t2727, t2740, t2753, t2757, t2758, t2762, t2763;
  double t2766, t2767, t2771, t2772, t2775, t2776, t2779, t2780;
  double t2783, t2784, t2787, t2788, t2792, t2796, tv3sigma39, t2797;
  double t2798, t2800, t2801, t2804, t2805, t2808, t2809, t2812;
  double t2813, t2816, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t2817, t2818, t2820;
  double t2821, t2824, t2825, t2828, t2829, t2832, t2833, t2836;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t2837, t2838, t2841;
  double t2842, t2845, t2846, t2850, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t2851, t2852, t2855, t2856;
  double t2859, t2860, t2864, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3;
  double tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11;
  double tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27;
  double tv3sigmatau28, t2865, t2866, t2867, t2870, tv3lapl30, tv3lapl31, tv3lapl32;
  double t2871, t2872, t2873, t2876, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t40 * t58 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t350 = t24 * t24;
  t351 = 0.1e1 / t350;
  t352 = t120 * t120;
  t355 = t116 * t7;
  t356 = 0.1e1 / t355;
  t357 = t17 * t356;
  t360 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t117 + 0.2e1 * t357);
  t364 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t352 + 0.4e1 / 0.3e1 * t24 * t360);
  t365 = t364 * t27;
  t369 = t123 * t129;
  t371 = t6 * t369 * t67;
  t377 = 0.1e1 / t128 / t7;
  t378 = t26 * t377;
  t381 = t6 * t378 * t67 / 0.12e2;
  t383 = t6 * t130 * t177;
  t385 = t37 * t37;
  t387 = 0.1e1 / t39 / t385;
  t388 = sigma[0] * t387;
  t399 = 0.1e1 / t141 / t51;
  t400 = t399 * t62;
  t401 = t155 * t155;
  t402 = t400 * t401;
  t407 = t30 * t35 * sigma[0];
  t408 = t41 * t142;
  t409 = t161 * t155;
  t410 = t409 * t172;
  t411 = t408 * t410;
  t415 = 0.1e1 / t38 / t134;
  t425 = 0.1e1 / t38 / t385 / t134;
  t428 = 0.1e1 / t150 / t149;
  t432 = 0.28e2 / 0.9e1 * t43 * t44 * t415 * t48 + 0.2e2 / 0.3e1 * t43 * t388 * t151 - 0.16e2 / 0.9e1 * t43 * t287 * t425 * t428;
  t433 = t143 * t432;
  t438 = 0.1e1 / t160 / t61;
  t439 = t52 * t438;
  t440 = t172 * t172;
  t441 = t439 * t440;
  t448 = 0.88e2 / 0.9e1 * t388 - 0.4e2 / 0.9e1 * lapl[0] * t136;
  t449 = t448 * t57;
  t456 = 0.2e1 * t449 * t40 + 0.32e2 / 0.3e1 * t167 * t53 + 0.8e2 / 0.9e1 * t58 * t39;
  t457 = t162 * t456;
  t461 = 0.176e3 / 0.81e2 * t36 * t388 * t63 + 0.32e2 / 0.27e2 * t36 * t137 * t156 + 0.32e2 / 0.27e2 * t36 * t137 * t173 + 0.4e1 / 0.9e1 * t36 * t42 * t402 + 0.4e1 / 0.9e1 * t407 * t411 - 0.2e1 / 0.9e1 * t36 * t42 * t433 + 0.4e1 / 0.9e1 * t36 * t42 * t441 - 0.2e1 / 0.9e1 * t36 * t42 * t457;
  t466 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t67 - t371 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t177 + t381 - t383 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t461);
  t467 = t78 * t78;
  t468 = 0.1e1 / t467;
  t469 = t185 * t185;
  t472 = t73 * t356;
  t475 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t117 + 0.2e1 * t472);
  t479 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t469 + 0.4e1 / 0.3e1 * t78 * t475);
  t480 = t479 * t27;
  t484 = t188 * t129;
  t486 = t6 * t484 * t111;
  t488 = t80 * t377;
  t491 = t6 * t488 * t111 / 0.12e2;
  t493 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t111 - t486 / 0.4e1 + t491);
  tv2rho20 = 0.2e1 * t182 + 0.2e1 * t198 + t7 * (t466 + t493);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t496 = t351 * t202;
  t500 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t357);
  t504 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t496 * t120 + 0.4e1 / 0.3e1 * t24 * t500);
  t505 = t504 * t27;
  t509 = t205 * t129;
  t511 = t6 * t509 * t67;
  t519 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t67 - t511 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t177 - t371 / 0.8e1 + t381 - t383 / 0.8e1);
  t520 = t468 * t213;
  t524 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t472);
  t528 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t520 * t185 + 0.4e1 / 0.3e1 * t78 * t524);
  t529 = t528 * t27;
  t533 = t216 * t129;
  t535 = t6 * t533 * t111;
  t542 = t6 * t193 * t264;
  t545 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t111 - t535 / 0.8e1 - t486 / 0.8e1 + t491 - 0.3e1 / 0.8e1 * t6 * t189 * t264 - t542 / 0.8e1);
  tv2rho21 = t182 + t198 + t211 + t269 + t7 * (t519 + t545);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t550 = t202 * t202;
  t555 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t117 + 0.2e1 * t357);
  t559 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t550 + 0.4e1 / 0.3e1 * t24 * t555);
  t560 = t559 * t27;
  t566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t67 - t511 / 0.4e1 + t381);
  t567 = t213 * t213;
  t572 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t117 + 0.2e1 * t472);
  t576 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t567 + 0.4e1 / 0.3e1 * t78 * t572);
  t577 = t576 * t27;
  t586 = t82 * t82;
  t588 = 0.1e1 / t84 / t586;
  t589 = sigma[2] * t588;
  t600 = 0.1e1 / t228 / t95;
  t601 = t600 * t106;
  t602 = t242 * t242;
  t603 = t601 * t602;
  t608 = t30 * t35 * sigma[2];
  t609 = t86 * t229;
  t610 = t248 * t242;
  t611 = t610 * t259;
  t612 = t609 * t611;
  t616 = 0.1e1 / t83 / t221;
  t626 = 0.1e1 / t83 / t586 / t221;
  t629 = 0.1e1 / t237 / t236;
  t633 = 0.28e2 / 0.9e1 * t43 * t88 * t616 * t92 + 0.2e2 / 0.3e1 * t43 * t589 * t238 - 0.16e2 / 0.9e1 * t43 * t316 * t626 * t629;
  t634 = t230 * t633;
  t639 = 0.1e1 / t247 / t105;
  t640 = t96 * t639;
  t641 = t259 * t259;
  t642 = t640 * t641;
  t649 = 0.88e2 / 0.9e1 * t589 - 0.4e2 / 0.9e1 * lapl[1] * t223;
  t650 = t649 * t101;
  t657 = 0.2e1 * t650 * t85 + 0.32e2 / 0.3e1 * t254 * t97 + 0.8e2 / 0.9e1 * t102 * t84;
  t658 = t249 * t657;
  t662 = 0.176e3 / 0.81e2 * t36 * t589 * t107 + 0.32e2 / 0.27e2 * t36 * t224 * t243 + 0.32e2 / 0.27e2 * t36 * t224 * t260 + 0.4e1 / 0.9e1 * t36 * t87 * t603 + 0.4e1 / 0.9e1 * t608 * t612 - 0.2e1 / 0.9e1 * t36 * t87 * t634 + 0.4e1 / 0.9e1 * t36 * t87 * t642 - 0.2e1 / 0.9e1 * t36 * t87 * t658;
  t667 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t111 - t535 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t264 + t491 - t542 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t662);
  tv2rho22 = 0.2e1 * t211 + 0.2e1 * t269 + t7 * (t566 + t667);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t675 = t6 * t130 * t297 / 0.8e1;
  t676 = t34 * t136;
  t680 = t62 * t155;
  t684 = t41 * t52;
  t685 = t161 * t172;
  t692 = t41 * t399;
  t693 = t62 * t283;
  t694 = t693 * t155;
  t695 = t692 * t694;
  t698 = t161 * t283;
  t699 = t698 * t172;
  t700 = t408 * t699;
  t710 = t385 * t37;
  t712 = 0.1e1 / t38 / t710;
  t713 = t712 * t428;
  t717 = -0.2e1 / 0.3e1 * t43 * t276 * t145 * t48 - 0.2e1 * t43 * t136 * t151 + 0.2e1 / 0.3e1 * t43 * t713 * sigma[0];
  t718 = t143 * t717;
  t725 = t161 * t292;
  t726 = t725 * t155;
  t727 = t408 * t726;
  t730 = t438 * t292;
  t731 = t730 * t172;
  t732 = t684 * t731;
  t735 = t166 * t288;
  t740 = -0.2e1 * t735 * t40 - 0.16e2 / 0.3e1 * t289 * t53;
  t741 = t162 * t740;
  t745 = -0.16e2 / 0.27e2 * t272 * t676 * t63 - 0.2e1 / 0.9e1 * t36 * t408 * t680 - 0.2e1 / 0.9e1 * t36 * t684 * t685 + 0.16e2 / 0.27e2 * t36 * t137 * t284 + 0.4e1 / 0.9e1 * t407 * t695 + 0.2e1 / 0.9e1 * t407 * t700 - 0.2e1 / 0.9e1 * t36 * t42 * t718 + 0.16e2 / 0.27e2 * t36 * t137 * t293 + 0.2e1 / 0.9e1 * t407 * t727 + 0.4e1 / 0.9e1 * t407 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t741;
  t750 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t297 - t675 - 0.3e1 / 0.8e1 * t6 * t28 * t745);
  tv2rhosigma0 = t7 * t750 + t301;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t757 = t6 * t193 * t326 / 0.8e1;
  t759 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t326 - t757);
  tv2rhosigma2 = t7 * t759 + t330;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t765 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t297 - t675);
  tv2rhosigma3 = t7 * t765 + t301;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t770 = t34 * t223;
  t774 = t106 * t242;
  t778 = t86 * t96;
  t779 = t248 * t259;
  t786 = t86 * t600;
  t787 = t106 * t312;
  t788 = t787 * t242;
  t789 = t786 * t788;
  t792 = t248 * t312;
  t793 = t792 * t259;
  t794 = t609 * t793;
  t804 = t586 * t82;
  t806 = 0.1e1 / t83 / t804;
  t807 = t806 * t629;
  t811 = -0.2e1 / 0.3e1 * t43 * t305 * t232 * t92 - 0.2e1 * t43 * t223 * t238 + 0.2e1 / 0.3e1 * t43 * t807 * sigma[2];
  t812 = t230 * t811;
  t819 = t248 * t321;
  t820 = t819 * t242;
  t821 = t609 * t820;
  t824 = t639 * t321;
  t825 = t824 * t259;
  t826 = t778 * t825;
  t829 = t253 * t317;
  t834 = -0.2e1 * t829 * t85 - 0.16e2 / 0.3e1 * t318 * t97;
  t835 = t249 * t834;
  t839 = -0.16e2 / 0.27e2 * t272 * t770 * t107 - 0.2e1 / 0.9e1 * t36 * t609 * t774 - 0.2e1 / 0.9e1 * t36 * t778 * t779 + 0.16e2 / 0.27e2 * t36 * t224 * t313 + 0.4e1 / 0.9e1 * t608 * t789 + 0.2e1 / 0.9e1 * t608 * t794 - 0.2e1 / 0.9e1 * t36 * t87 * t812 + 0.16e2 / 0.27e2 * t36 * t224 * t322 + 0.2e1 / 0.9e1 * t608 * t821 + 0.4e1 / 0.9e1 * t608 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t835;
  t844 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t326 - t757 - 0.3e1 / 0.8e1 * t6 * t81 * t839);
  tv2rhosigma5 = t7 * t844 + t330;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t846 = t5 * t123;
  t847 = t846 * t332;
  t850 = t129 * params->beta;
  t851 = t331 * t850;
  t853 = t851 * t336 / 0.6e1;
  t855 = t35 * t684 * t161;
  t858 = t332 * t33;
  t859 = t331 * t858;
  t860 = t34 * t54;
  t861 = t142 * t161;
  t862 = t861 * t155;
  t863 = t860 * t862;
  t866 = t439 * t172;
  t867 = t860 * t866;
  t870 = my_piecewise3(t2, 0, -t847 * t336 / 0.2e1 - t853 + 0.5e1 / 0.6e1 * t333 * t855 + t859 * t863 / 0.2e1 + t859 * t867);
  tv2rholapl0 = t7 * t870 + t339;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t872 = t5 * t188;
  t873 = t872 * t332;
  t876 = t340 * t850;
  t878 = t876 * t344 / 0.6e1;
  t880 = my_piecewise3(t72, 0, -t873 * t344 / 0.2e1 - t878);
  tv2rholapl1 = t7 * t880 + t347;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t882 = t5 * t205;
  t883 = t882 * t332;
  t887 = my_piecewise3(t2, 0, -t883 * t336 / 0.2e1 - t853);
  tv2rholapl2 = t7 * t887 + t339;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t889 = t5 * t216;
  t890 = t889 * t332;
  t894 = t35 * t778 * t248;
  t897 = t340 * t858;
  t898 = t34 * t98;
  t899 = t229 * t248;
  t900 = t899 * t242;
  t901 = t898 * t900;
  t904 = t640 * t259;
  t905 = t898 * t904;
  t908 = my_piecewise3(t72, 0, -t890 * t344 / 0.2e1 - t878 + 0.5e1 / 0.6e1 * t341 * t894 + t897 * t901 / 0.2e1 + t897 * t905);
  tv2rholapl3 = t7 * t908 + t347;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t916 = t283 * t283;
  t917 = t400 * t916;
  t921 = t698 * t292;
  t922 = t408 * t921;
  t926 = 0.1e1 / t44 / sigma[0];
  t933 = t385 * rho[0];
  t935 = 0.1e1 / t38 / t933;
  t939 = t43 * t57 * t41 * t151 / 0.4e1 - t43 * t926 * t46 * t48 / 0.4e1 - t43 * t935 * t428 / 0.4e1;
  t940 = t143 * t939;
  t944 = t292 * t292;
  t945 = t439 * t944;
  t949 = t287 * sigma[0];
  t950 = 0.1e1 / t949;
  t951 = t56 * t950;
  t954 = 0.4e1 * t40 * t951 - 0.4e1 * t288;
  t955 = t162 * t954;
  t959 = -0.4e1 / 0.9e1 * t36 * t408 * t693 - 0.4e1 / 0.9e1 * t36 * t684 * t725 + 0.4e1 / 0.9e1 * t36 * t42 * t917 + 0.4e1 / 0.9e1 * t407 * t922 - 0.2e1 / 0.9e1 * t36 * t42 * t940 + 0.4e1 / 0.9e1 * t36 * t42 * t945 - 0.2e1 / 0.9e1 * t36 * t42 * t955;
  t963 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t959);
  tv2sigma20 = t7 * t963;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t970 = t312 * t312;
  t971 = t601 * t970;
  t975 = t792 * t321;
  t976 = t609 * t975;
  t980 = 0.1e1 / t88 / sigma[2];
  t987 = t586 * rho[1];
  t989 = 0.1e1 / t83 / t987;
  t993 = t43 * t101 * t86 * t238 / 0.4e1 - t43 * t980 * t90 * t92 / 0.4e1 - t43 * t989 * t629 / 0.4e1;
  t994 = t230 * t993;
  t998 = t321 * t321;
  t999 = t640 * t998;
  t1003 = t316 * sigma[2];
  t1004 = 0.1e1 / t1003;
  t1005 = t100 * t1004;
  t1008 = 0.4e1 * t1005 * t85 - 0.4e1 * t317;
  t1009 = t249 * t1008;
  t1013 = -0.4e1 / 0.9e1 * t36 * t609 * t787 - 0.4e1 / 0.9e1 * t36 * t778 * t819 + 0.4e1 / 0.9e1 * t36 * t87 * t971 + 0.4e1 / 0.9e1 * t608 * t976 - 0.2e1 / 0.9e1 * t36 * t87 * t994 + 0.4e1 / 0.9e1 * t36 * t87 * t999 - 0.2e1 / 0.9e1 * t36 * t87 * t1009;
  t1017 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t1013);
  tv2sigma25 = t7 * t1017;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1018 = t861 * t283;
  t1019 = t860 * t1018;
  t1022 = t439 * t292;
  t1023 = t860 * t1022;
  t1026 = my_piecewise3(t2, 0, t859 * t1019 / 0.2e1 + t859 * t1023);
  tv2sigmalapl0 = t7 * t1026;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1027 = t899 * t312;
  t1028 = t898 * t1027;
  t1031 = t640 * t321;
  t1032 = t898 * t1031;
  t1035 = my_piecewise3(t72, 0, t897 * t1028 / 0.2e1 + t897 * t1032);
  tv2sigmalapl5 = t7 * t1035;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1036 = 0.1e1 / t39;
  t1037 = t34 * t1036;
  t1038 = t439 * t57;
  t1039 = t1037 * t1038;
  t1042 = my_piecewise3(t2, 0, -0.2e1 * t859 * t1039);
  tv2lapl20 = t7 * t1042;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1043 = 0.1e1 / t84;
  t1044 = t34 * t1043;
  t1045 = t640 * t101;
  t1046 = t1044 * t1045;
  t1049 = my_piecewise3(t72, 0, -0.2e1 * t897 * t1046);
  tv2lapl22 = t7 * t1049;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1053 = 0.1e1 / t350 / t20;
  t1054 = t352 * t120;
  t1057 = t351 * t120;
  t1060 = t116 * t116;
  t1061 = 0.1e1 / t1060;
  t1062 = t17 * t1061;
  t1065 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t356 - 0.6e1 * t1062);
  t1069 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1054 + 0.4e1 / 0.3e1 * t1057 * t360 + 0.4e1 / 0.3e1 * t24 * t1065);
  t1070 = t1069 * t27;
  t1074 = t364 * t129;
  t1076 = t6 * t1074 * t67;
  t1081 = t123 * t377;
  t1083 = t6 * t1081 * t67;
  t1086 = t6 * t369 * t177;
  t1092 = 0.1e1 / t128 / t116;
  t1093 = t26 * t1092;
  t1096 = 0.5e1 / 0.36e2 * t6 * t1093 * t67;
  t1098 = t6 * t378 * t177;
  t1101 = t6 * t130 * t461;
  t1104 = 0.1e1 / t38 / t385;
  t1110 = 0.1e1 / t39 / t933;
  t1111 = sigma[0] * t1110;
  t1115 = t385 * t385;
  t1117 = 0.1e1 / t38 / t1115;
  t1122 = t1115 * t134;
  t1123 = 0.1e1 / t1122;
  t1125 = t149 * t149;
  t1127 = 0.1e1 / t150 / t1125;
  t1131 = -0.28e3 / 0.27e2 * t43 * t44 * t1104 * t48 - 0.952e3 / 0.27e2 * t43 * t1111 * t151 + 0.592e3 / 0.27e2 * t43 * t287 * t1117 * t428 - 0.64e2 / 0.9e1 * t43 * t949 * t1123 * t1127;
  t1132 = t143 * t1131;
  t1139 = -0.1232e4 / 0.27e2 * t1111 + 0.44e3 / 0.27e2 * lapl[0] * t387;
  t1140 = t1139 * t57;
  t1147 = 0.1e1 / t38;
  t1150 = 0.2e1 * t1140 * t40 + 0.16e2 * t449 * t53 + 0.8e2 / 0.3e1 * t167 * t39 + 0.16e3 / 0.27e2 * t58 * t1147;
  t1151 = t162 * t1150;
  t1155 = t438 * t155;
  t1156 = t1155 * t440;
  t1157 = t408 * t1156;
  t1160 = t160 * t160;
  t1161 = 0.1e1 / t1160;
  t1162 = t52 * t1161;
  t1163 = t440 * t172;
  t1164 = t1162 * t1163;
  t1169 = t438 * t172 * t456;
  t1170 = t684 * t1169;
  t1176 = t141 * t141;
  t1177 = 0.1e1 / t1176;
  t1178 = t1177 * t62;
  t1179 = t401 * t155;
  t1180 = t1178 * t1179;
  t1184 = t161 * t401;
  t1185 = t1184 * t172;
  t1186 = t692 * t1185;
  t1189 = t680 * t432;
  t1190 = t692 * t1189;
  t1193 = t161 * t432;
  t1194 = t1193 * t172;
  t1195 = t408 * t1194;
  t1198 = t409 * t456;
  t1199 = t408 * t1198;
  t1205 = t136 * t142;
  t1206 = t1205 * t410;
  t1224 = -0.2e1 / 0.9e1 * t36 * t42 * t1132 - 0.2e1 / 0.9e1 * t36 * t42 * t1151 - 0.4e1 / 0.3e1 * t407 * t1157 - 0.4e1 / 0.3e1 * t36 * t42 * t1164 + 0.4e1 / 0.3e1 * t407 * t1170 - 0.32e2 / 0.9e1 * t36 * t137 * t441 - 0.4e1 / 0.3e1 * t36 * t42 * t1180 - 0.4e1 / 0.3e1 * t407 * t1186 + 0.4e1 / 0.3e1 * t407 * t1190 + 0.2e1 / 0.3e1 * t407 * t1195 + 0.2e1 / 0.3e1 * t407 * t1199 - 0.32e2 / 0.9e1 * t36 * t137 * t402 - 0.32e2 / 0.9e1 * t407 * t1206 + 0.16e2 / 0.9e1 * t36 * t137 * t457 - 0.2464e4 / 0.243e3 * t36 * t1111 * t63 - 0.176e3 / 0.27e2 * t36 * t388 * t156 - 0.176e3 / 0.27e2 * t36 * t388 * t173 + 0.16e2 / 0.9e1 * t36 * t137 * t433;
  t1229 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1070 * t67 - 0.3e1 / 0.8e1 * t1076 - 0.9e1 / 0.8e1 * t6 * t365 * t177 + t1083 / 0.4e1 - 0.3e1 / 0.4e1 * t1086 - 0.9e1 / 0.8e1 * t6 * t124 * t461 - t1096 + t1098 / 0.4e1 - 0.3e1 / 0.8e1 * t1101 - 0.3e1 / 0.8e1 * t6 * t28 * t1224);
  t1231 = 0.1e1 / t467 / t76;
  t1232 = t469 * t185;
  t1235 = t468 * t185;
  t1238 = t73 * t1061;
  t1241 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t356 - 0.6e1 * t1238);
  t1245 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1232 + 0.4e1 / 0.3e1 * t1235 * t475 + 0.4e1 / 0.3e1 * t78 * t1241);
  t1246 = t1245 * t27;
  t1250 = t479 * t129;
  t1252 = t6 * t1250 * t111;
  t1254 = t188 * t377;
  t1256 = t6 * t1254 * t111;
  t1258 = t80 * t1092;
  t1261 = 0.5e1 / 0.36e2 * t6 * t1258 * t111;
  t1263 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1246 * t111 - 0.3e1 / 0.8e1 * t1252 + t1256 / 0.4e1 - t1261);
  tv3rho30 = 0.3e1 * t466 + 0.3e1 * t493 + t7 * (t1229 + t1263);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1266 = 0.2e1 * t519;
  t1267 = 0.2e1 * t545;
  t1268 = t1053 * t202;
  t1271 = t351 * t500;
  t1276 = 0.2e1 * t356;
  t1277 = 0.6e1 * t1062;
  t1279 = my_piecewise5(t11, 0, t15, 0, t1276 - t1277);
  t1283 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1268 * t352 + 0.8e1 / 0.9e1 * t1271 * t120 + 0.4e1 / 0.9e1 * t496 * t360 + 0.4e1 / 0.3e1 * t24 * t1279);
  t1284 = t1283 * t27;
  t1288 = t504 * t129;
  t1291 = t6 * t1288 * t67 / 0.4e1;
  t1295 = t205 * t377;
  t1297 = t6 * t1295 * t67;
  t1301 = t6 * t509 * t177 / 0.4e1;
  t1310 = -0.3e1 / 0.8e1 * t6 * t1284 * t67 - t1291 - 0.3e1 / 0.4e1 * t6 * t505 * t177 + t1297 / 0.12e2 - t1301 - 0.3e1 / 0.8e1 * t6 * t206 * t461 - t1076 / 0.8e1 + t1083 / 0.6e1 - t1086 / 0.4e1 - t1096 + t1098 / 0.6e1 - t1101 / 0.8e1;
  t1311 = my_piecewise3(t2, 0, t1310);
  t1312 = t1231 * t213;
  t1315 = t468 * t524;
  t1320 = 0.6e1 * t1238;
  t1322 = my_piecewise5(t15, 0, t11, 0, -t1276 - t1320);
  t1326 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1312 * t469 + 0.8e1 / 0.9e1 * t1315 * t185 + 0.4e1 / 0.9e1 * t520 * t475 + 0.4e1 / 0.3e1 * t78 * t1322);
  t1327 = t1326 * t27;
  t1331 = t528 * t129;
  t1334 = t6 * t1331 * t111 / 0.4e1;
  t1335 = t216 * t377;
  t1337 = t6 * t1335 * t111;
  t1346 = t6 * t484 * t264 / 0.4e1;
  t1348 = t6 * t488 * t264;
  t1351 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1327 * t111 - t1334 + t1337 / 0.12e2 - t1252 / 0.8e1 + t1256 / 0.6e1 - t1261 - 0.3e1 / 0.8e1 * t6 * t480 * t264 - t1346 + t1348 / 0.12e2);
  tv3rho31 = t466 + t493 + t1266 + t1267 + t7 * (t1311 + t1351);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1354 = t1053 * t550;
  t1359 = t351 * t555;
  t1363 = my_piecewise5(t11, 0, t15, 0, -t1276 - t1277);
  t1367 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1354 * t120 + 0.8e1 / 0.9e1 * t496 * t500 + 0.4e1 / 0.9e1 * t1359 * t120 + 0.4e1 / 0.3e1 * t24 * t1363);
  t1368 = t1367 * t27;
  t1372 = t559 * t129;
  t1374 = t6 * t1372 * t67;
  t1383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1368 * t67 - t1374 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t560 * t177 - t1291 + t1297 / 0.6e1 - t1301 + t1083 / 0.12e2 - t1096 + t1098 / 0.12e2);
  t1384 = t1231 * t567;
  t1389 = t468 * t572;
  t1393 = my_piecewise5(t15, 0, t11, 0, t1276 - t1320);
  t1397 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1384 * t185 + 0.8e1 / 0.9e1 * t520 * t524 + 0.4e1 / 0.9e1 * t1389 * t185 + 0.4e1 / 0.3e1 * t78 * t1393);
  t1398 = t1397 * t27;
  t1402 = t576 * t129;
  t1404 = t6 * t1402 * t111;
  t1411 = t6 * t533 * t264;
  t1419 = t6 * t193 * t662;
  t1421 = -0.3e1 / 0.8e1 * t6 * t1398 * t111 - t1404 / 0.8e1 - t1334 + t1337 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t529 * t264 - t1411 / 0.4e1 + t1256 / 0.12e2 - t1261 - t1346 + t1348 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t189 * t662 - t1419 / 0.8e1;
  t1422 = my_piecewise3(t72, 0, t1421);
  tv3rho32 = t1266 + t1267 + t566 + t667 + t7 * (t1383 + t1422);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1427 = t550 * t202;
  t1434 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t356 - 0.6e1 * t1062);
  t1438 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1427 + 0.4e1 / 0.3e1 * t496 * t555 + 0.4e1 / 0.3e1 * t24 * t1434);
  t1439 = t1438 * t27;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1439 * t67 - 0.3e1 / 0.8e1 * t1374 + t1297 / 0.4e1 - t1096);
  t1447 = t567 * t213;
  t1454 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t356 - 0.6e1 * t1238);
  t1458 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1447 + 0.4e1 / 0.3e1 * t520 * t572 + 0.4e1 / 0.3e1 * t78 * t1454);
  t1459 = t1458 * t27;
  t1475 = 0.1e1 / t84 / t987;
  t1476 = sigma[2] * t1475;
  t1480 = -0.1232e4 / 0.27e2 * t1476 + 0.44e3 / 0.27e2 * lapl[1] * t588;
  t1481 = t1480 * t101;
  t1488 = 0.1e1 / t83;
  t1491 = 0.2e1 * t1481 * t85 + 0.16e2 * t650 * t97 + 0.8e2 / 0.3e1 * t254 * t84 + 0.16e3 / 0.27e2 * t102 * t1488;
  t1492 = t249 * t1491;
  t1512 = 0.1e1 / t83 / t586;
  t1520 = t586 * t586;
  t1522 = 0.1e1 / t83 / t1520;
  t1527 = t1520 * t221;
  t1528 = 0.1e1 / t1527;
  t1530 = t236 * t236;
  t1532 = 0.1e1 / t237 / t1530;
  t1536 = -0.28e3 / 0.27e2 * t43 * t88 * t1512 * t92 - 0.952e3 / 0.27e2 * t43 * t1476 * t238 + 0.592e3 / 0.27e2 * t43 * t316 * t1522 * t629 - 0.64e2 / 0.9e1 * t43 * t1003 * t1528 * t1532;
  t1537 = t230 * t1536;
  t1541 = t639 * t242;
  t1542 = t1541 * t641;
  t1543 = t609 * t1542;
  t1546 = t247 * t247;
  t1547 = 0.1e1 / t1546;
  t1548 = t96 * t1547;
  t1549 = t641 * t259;
  t1550 = t1548 * t1549;
  t1555 = t639 * t259 * t657;
  t1556 = t778 * t1555;
  t1562 = t228 * t228;
  t1563 = 0.1e1 / t1562;
  t1564 = t1563 * t106;
  t1565 = t602 * t242;
  t1566 = t1564 * t1565;
  t1570 = t248 * t602;
  t1571 = t1570 * t259;
  t1572 = t786 * t1571;
  t1575 = t774 * t633;
  t1576 = t786 * t1575;
  t1579 = t248 * t633;
  t1580 = t1579 * t259;
  t1581 = t609 * t1580;
  t1584 = t610 * t657;
  t1585 = t609 * t1584;
  t1591 = t223 * t229;
  t1592 = t1591 * t611;
  t1595 = -0.2e1 / 0.9e1 * t36 * t87 * t1492 - 0.2464e4 / 0.243e3 * t36 * t1476 * t107 - 0.176e3 / 0.27e2 * t36 * t589 * t243 - 0.176e3 / 0.27e2 * t36 * t589 * t260 + 0.16e2 / 0.9e1 * t36 * t224 * t634 + 0.16e2 / 0.9e1 * t36 * t224 * t658 - 0.2e1 / 0.9e1 * t36 * t87 * t1537 - 0.4e1 / 0.3e1 * t608 * t1543 - 0.4e1 / 0.3e1 * t36 * t87 * t1550 + 0.4e1 / 0.3e1 * t608 * t1556 - 0.32e2 / 0.9e1 * t36 * t224 * t642 - 0.4e1 / 0.3e1 * t36 * t87 * t1566 - 0.4e1 / 0.3e1 * t608 * t1572 + 0.4e1 / 0.3e1 * t608 * t1576 + 0.2e1 / 0.3e1 * t608 * t1581 + 0.2e1 / 0.3e1 * t608 * t1585 - 0.32e2 / 0.9e1 * t36 * t224 * t603 - 0.32e2 / 0.9e1 * t608 * t1592;
  t1600 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1459 * t111 - 0.3e1 / 0.8e1 * t1404 - 0.9e1 / 0.8e1 * t6 * t577 * t264 + t1337 / 0.4e1 - 0.3e1 / 0.4e1 * t1411 - 0.9e1 / 0.8e1 * t6 * t217 * t662 - t1261 + t1348 / 0.4e1 - 0.3e1 / 0.8e1 * t1419 - 0.3e1 / 0.8e1 * t6 * t81 * t1595);
  tv3rho33 = 0.3e1 * t566 + 0.3e1 * t667 + t7 * (t1446 + t1600);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1608 = t6 * t369 * t297;
  t1615 = t6 * t378 * t297 / 0.12e2;
  t1617 = t6 * t130 * t745;
  t1619 = t438 * t440;
  t1623 = t62 * t401;
  t1630 = t136 * t52;
  t1634 = t62 * t432;
  t1638 = t161 * t456;
  t1646 = t408 * t438;
  t1647 = t292 * t155;
  t1648 = t1647 * t172;
  t1652 = t692 * t161;
  t1653 = t283 * t155;
  t1654 = t1653 * t172;
  t1658 = t41 * t1177;
  t1659 = t693 * t401;
  t1660 = t1658 * t1659;
  t1663 = t438 * t283;
  t1664 = t1663 * t440;
  t1665 = t408 * t1664;
  t1668 = t161 * t740;
  t1669 = t1668 * t155;
  t1670 = t408 * t1669;
  t1673 = t725 * t432;
  t1674 = t408 * t1673;
  t1677 = t438 * t740;
  t1678 = t1677 * t172;
  t1679 = t684 * t1678;
  t1682 = t730 * t456;
  t1683 = t684 * t1682;
  t1686 = t62 * t717;
  t1687 = t1686 * t155;
  t1688 = t692 * t1687;
  t1691 = 0.4e1 / 0.9e1 * t36 * t684 * t1619 + 0.4e1 / 0.9e1 * t36 * t692 * t1623 + 0.32e2 / 0.27e2 * t36 * t1205 * t680 + 0.32e2 / 0.27e2 * t36 * t1630 * t685 - 0.2e1 / 0.9e1 * t36 * t408 * t1634 - 0.2e1 / 0.9e1 * t36 * t684 * t1638 + 0.176e3 / 0.81e2 * t272 * t34 * t387 * t63 - 0.8e1 / 0.9e1 * t407 * t1646 * t1648 - 0.8e1 / 0.9e1 * t407 * t1652 * t1654 - 0.4e1 / 0.3e1 * t407 * t1660 - 0.4e1 / 0.9e1 * t407 * t1665 + 0.4e1 / 0.9e1 * t407 * t1670 + 0.2e1 / 0.9e1 * t407 * t1674 + 0.8e1 / 0.9e1 * t407 * t1679 + 0.4e1 / 0.9e1 * t407 * t1683 + 0.8e1 / 0.9e1 * t407 * t1688;
  t1692 = t693 * t432;
  t1693 = t692 * t1692;
  t1696 = t161 * t717;
  t1697 = t1696 * t172;
  t1698 = t408 * t1697;
  t1701 = t698 * t456;
  t1702 = t408 * t1701;
  t1705 = t1205 * t726;
  t1708 = t1630 * t731;
  t1711 = t136 * t399;
  t1712 = t1711 * t694;
  t1715 = t1205 * t699;
  t1718 = t725 * t401;
  t1719 = t692 * t1718;
  t1722 = t1161 * t292;
  t1723 = t1722 * t440;
  t1724 = t684 * t1723;
  t1737 = t425 * t428;
  t1741 = t1115 * t37;
  t1743 = 0.1e1 / t1741 * t1127;
  t1747 = 0.14e2 / 0.9e1 * t43 * t276 * t415 * t48 + 0.74e2 / 0.9e1 * t43 * t387 * t151 - 0.62e2 / 0.9e1 * t43 * t1737 * sigma[0] + 0.8e1 / 0.3e1 * t43 * t1743 * t287;
  t1748 = t143 * t1747;
  t1755 = t448 * t288;
  t1762 = -0.2e1 * t1755 * t40 - 0.32e2 / 0.3e1 * t735 * t53 - 0.8e2 / 0.9e1 * t289 * t39;
  t1763 = t162 * t1762;
  t1775 = 0.4e1 / 0.9e1 * t407 * t1693 + 0.4e1 / 0.9e1 * t407 * t1698 + 0.2e1 / 0.9e1 * t407 * t1702 - 0.32e2 / 0.27e2 * t407 * t1705 - 0.64e2 / 0.27e2 * t407 * t1708 - 0.64e2 / 0.27e2 * t407 * t1712 - 0.32e2 / 0.27e2 * t407 * t1715 - 0.4e1 / 0.9e1 * t407 * t1719 - 0.4e1 / 0.3e1 * t407 * t1724 + 0.32e2 / 0.27e2 * t36 * t137 * t718 - 0.2e1 / 0.9e1 * t36 * t42 * t1748 + 0.32e2 / 0.27e2 * t36 * t137 * t741 - 0.2e1 / 0.9e1 * t36 * t42 * t1763 + 0.4e1 / 0.9e1 * t36 * t411 - 0.176e3 / 0.81e2 * t36 * t388 * t293 - 0.176e3 / 0.81e2 * t36 * t388 * t284;
  t1776 = t1691 + t1775;
  t1781 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t297 - t1608 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t745 + t1615 - t1617 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1776);
  tv3rho2sigma0 = t1781 * t7 + 0.2e1 * t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1788 = t6 * t484 * t326;
  t1792 = t6 * t488 * t326 / 0.12e2;
  t1794 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t326 - t1788 / 0.4e1 + t1792);
  tv3rho2sigma2 = t1794 * t7 + 0.2e1 * t759;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1800 = t6 * t509 * t297;
  t1808 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t297 - t1800 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t745 - t1608 / 0.8e1 + t1615 - t1617 / 0.8e1);
  tv3rho2sigma3 = t1808 * t7 + t750 + t765;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1814 = t6 * t533 * t326;
  t1821 = t6 * t193 * t839;
  t1824 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t326 - t1814 / 0.8e1 - t1788 / 0.8e1 + t1792 - 0.3e1 / 0.8e1 * t6 * t189 * t839 - t1821 / 0.8e1);
  tv3rho2sigma5 = t1824 * t7 + t759 + t844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1832 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t297 - t1800 / 0.4e1 + t1615);
  tv3rho2sigma6 = t1832 * t7 + 0.2e1 * t765;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1843 = t106 * t633;
  t1847 = t248 * t657;
  t1851 = t639 * t641;
  t1855 = t106 * t602;
  t1862 = t223 * t96;
  t1870 = t609 * t639;
  t1871 = t321 * t242;
  t1872 = t1871 * t259;
  t1876 = t786 * t248;
  t1877 = t312 * t242;
  t1878 = t1877 * t259;
  t1892 = t626 * t629;
  t1896 = t1520 * t82;
  t1898 = 0.1e1 / t1896 * t1532;
  t1902 = 0.14e2 / 0.9e1 * t43 * t305 * t616 * t92 + 0.74e2 / 0.9e1 * t43 * t588 * t238 - 0.62e2 / 0.9e1 * t43 * t1892 * sigma[2] + 0.8e1 / 0.3e1 * t43 * t1898 * t316;
  t1903 = t230 * t1902;
  t1910 = t649 * t317;
  t1917 = -0.2e1 * t1910 * t85 - 0.32e2 / 0.3e1 * t829 * t97 - 0.8e2 / 0.9e1 * t318 * t84;
  t1918 = t249 * t1917;
  t1930 = -0.2e1 / 0.9e1 * t36 * t609 * t1843 - 0.2e1 / 0.9e1 * t36 * t778 * t1847 + 0.4e1 / 0.9e1 * t36 * t778 * t1851 + 0.4e1 / 0.9e1 * t36 * t786 * t1855 + 0.32e2 / 0.27e2 * t36 * t1591 * t774 + 0.32e2 / 0.27e2 * t36 * t1862 * t779 + 0.176e3 / 0.81e2 * t272 * t34 * t588 * t107 - 0.8e1 / 0.9e1 * t608 * t1870 * t1872 - 0.8e1 / 0.9e1 * t608 * t1876 * t1878 + 0.32e2 / 0.27e2 * t36 * t224 * t812 - 0.2e1 / 0.9e1 * t36 * t87 * t1903 + 0.32e2 / 0.27e2 * t36 * t224 * t835 - 0.2e1 / 0.9e1 * t36 * t87 * t1918 + 0.4e1 / 0.9e1 * t36 * t612 - 0.176e3 / 0.81e2 * t36 * t589 * t322 - 0.176e3 / 0.81e2 * t36 * t589 * t313;
  t1931 = t639 * t834;
  t1932 = t1931 * t259;
  t1933 = t778 * t1932;
  t1936 = t824 * t657;
  t1937 = t778 * t1936;
  t1940 = t223 * t600;
  t1941 = t1940 * t788;
  t1944 = t1591 * t793;
  t1947 = t106 * t811;
  t1948 = t1947 * t242;
  t1949 = t786 * t1948;
  t1952 = t787 * t633;
  t1953 = t786 * t1952;
  t1956 = t639 * t312;
  t1957 = t1956 * t641;
  t1958 = t609 * t1957;
  t1961 = t819 * t602;
  t1962 = t786 * t1961;
  t1965 = t1547 * t321;
  t1966 = t1965 * t641;
  t1967 = t778 * t1966;
  t1970 = t86 * t1563;
  t1971 = t787 * t602;
  t1972 = t1970 * t1971;
  t1975 = t248 * t811;
  t1976 = t1975 * t259;
  t1977 = t609 * t1976;
  t1980 = t792 * t657;
  t1981 = t609 * t1980;
  t1984 = t1591 * t820;
  t1987 = t1862 * t825;
  t1990 = t248 * t834;
  t1991 = t1990 * t242;
  t1992 = t609 * t1991;
  t1995 = t819 * t633;
  t1996 = t609 * t1995;
  t1999 = 0.8e1 / 0.9e1 * t608 * t1933 + 0.4e1 / 0.9e1 * t608 * t1937 - 0.64e2 / 0.27e2 * t608 * t1941 - 0.32e2 / 0.27e2 * t608 * t1944 + 0.8e1 / 0.9e1 * t608 * t1949 + 0.4e1 / 0.9e1 * t608 * t1953 - 0.4e1 / 0.9e1 * t608 * t1958 - 0.4e1 / 0.9e1 * t608 * t1962 - 0.4e1 / 0.3e1 * t608 * t1967 - 0.4e1 / 0.3e1 * t608 * t1972 + 0.4e1 / 0.9e1 * t608 * t1977 + 0.2e1 / 0.9e1 * t608 * t1981 - 0.32e2 / 0.27e2 * t608 * t1984 - 0.64e2 / 0.27e2 * t608 * t1987 + 0.4e1 / 0.9e1 * t608 * t1992 + 0.2e1 / 0.9e1 * t608 * t1996;
  t2000 = t1930 + t1999;
  t2005 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t326 - t1814 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t839 + t1792 - t1821 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t2000);
  tv3rho2sigma8 = t2005 * t7 + 0.2e1 * t844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t2008 = t5 * t364;
  t2009 = t2008 * t332;
  t2012 = t399 * t161;
  t2013 = t2012 * t401;
  t2014 = t860 * t2013;
  t2016 = t860 * t142;
  t2017 = t1155 * t172;
  t2018 = t2016 * t2017;
  t2021 = t1162 * t440;
  t2022 = t860 * t2021;
  t2025 = t846 * t850;
  t2026 = t2025 * t336;
  t2030 = t846 * t858;
  t2034 = t377 * params->beta;
  t2035 = t331 * t2034;
  t2037 = t2035 * t336 / 0.9e1;
  t2038 = t851 * t855;
  t2040 = t850 * t33;
  t2041 = t331 * t2040;
  t2042 = t2041 * t863;
  t2044 = t2041 * t867;
  t2047 = t35 * t1630 * t161;
  t2050 = t273 * t862;
  t2053 = t273 * t866;
  t2056 = t861 * t432;
  t2057 = t860 * t2056;
  t2060 = t439 * t456;
  t2061 = t860 * t2060;
  t2063 = -t2009 * t336 / 0.2e1 - t859 * t2014 - 0.2e1 * t859 * t2018 - 0.3e1 * t859 * t2022 - t2026 / 0.3e1 + 0.5e1 / 0.3e1 * t847 * t855 + t2030 * t863 + 0.2e1 * t2030 * t867 + t2037 + 0.5e1 / 0.9e1 * t2038 + t2042 / 0.3e1 + 0.2e1 / 0.3e1 * t2044 - 0.2e2 / 0.9e1 * t333 * t2047 - 0.5e1 / 0.3e1 * t859 * t2050 - 0.1e2 / 0.3e1 * t859 * t2053 + t859 * t2057 / 0.2e1 + t859 * t2061;
  t2064 = my_piecewise3(t2, 0, t2063);
  tv3rho2lapl0 = t2064 * t7 + 0.2e1 * t870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2067 = t5 * t479;
  t2068 = t2067 * t332;
  t2071 = t872 * t850;
  t2072 = t2071 * t344;
  t2074 = t340 * t2034;
  t2076 = t2074 * t344 / 0.9e1;
  t2078 = my_piecewise3(t72, 0, -t2068 * t344 / 0.2e1 - t2072 / 0.3e1 + t2076);
  tv3rho2lapl1 = t2078 * t7 + 0.2e1 * t880;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2080 = t5 * t504;
  t2081 = t2080 * t332;
  t2084 = t882 * t850;
  t2085 = t2084 * t336;
  t2089 = t882 * t858;
  t2098 = my_piecewise3(t2, 0, -t2081 * t336 / 0.2e1 - t2085 / 0.6e1 + 0.5e1 / 0.6e1 * t883 * t855 + t2089 * t863 / 0.2e1 + t2089 * t867 - t2026 / 0.6e1 + t2037 + 0.5e1 / 0.18e2 * t2038 + t2042 / 0.6e1 + t2044 / 0.3e1);
  tv3rho2lapl2 = t2098 * t7 + t870 + t887;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2100 = t5 * t528;
  t2101 = t2100 * t332;
  t2104 = t889 * t850;
  t2105 = t2104 * t344;
  t2110 = t876 * t894;
  t2112 = t872 * t858;
  t2115 = t340 * t2040;
  t2116 = t2115 * t901;
  t2119 = t2115 * t905;
  t2122 = my_piecewise3(t72, 0, -t2101 * t344 / 0.2e1 - t2105 / 0.6e1 - t2072 / 0.6e1 + t2076 + 0.5e1 / 0.6e1 * t873 * t894 + 0.5e1 / 0.18e2 * t2110 + t2112 * t901 / 0.2e1 + t2116 / 0.6e1 + t2112 * t905 + t2119 / 0.3e1);
  tv3rho2lapl3 = t2122 * t7 + t880 + t908;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2125 = t5 * t559;
  t2126 = t2125 * t332;
  t2131 = my_piecewise3(t2, 0, -t2126 * t336 / 0.2e1 - t2085 / 0.3e1 + t2037);
  tv3rho2lapl4 = t2131 * t7 + 0.2e1 * t887;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2135 = t35 * t1862 * t248;
  t2138 = t302 * t900;
  t2141 = t302 * t904;
  t2144 = t899 * t633;
  t2145 = t898 * t2144;
  t2148 = t640 * t657;
  t2149 = t898 * t2148;
  t2153 = t889 * t858;
  t2159 = t5 * t576;
  t2160 = t2159 * t332;
  t2163 = t600 * t248;
  t2164 = t2163 * t602;
  t2165 = t898 * t2164;
  t2167 = t898 * t229;
  t2168 = t1541 * t259;
  t2169 = t2167 * t2168;
  t2172 = t1548 * t641;
  t2173 = t898 * t2172;
  t2178 = -0.2e2 / 0.9e1 * t341 * t2135 - 0.5e1 / 0.3e1 * t897 * t2138 - 0.1e2 / 0.3e1 * t897 * t2141 + t897 * t2145 / 0.2e1 + t897 * t2149 + 0.5e1 / 0.3e1 * t890 * t894 + t2153 * t901 + 0.2e1 * t2153 * t905 + 0.5e1 / 0.9e1 * t2110 - t2105 / 0.3e1 - t2160 * t344 / 0.2e1 - t897 * t2165 - 0.2e1 * t897 * t2169 - 0.3e1 * t897 * t2173 + t2116 / 0.3e1 + 0.2e1 / 0.3e1 * t2119 + t2076;
  t2179 = my_piecewise3(t72, 0, t2178);
  tv3rho2lapl5 = t2179 * t7 + 0.2e1 * t908;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2186 = t6 * t130 * t959 / 0.8e1;
  t2199 = t283 * t292;
  t2200 = t2199 * t155;
  t2204 = t2199 * t172;
  t2220 = t166 * t950;
  t2225 = 0.4e1 * t2220 * t40 + 0.32e2 / 0.3e1 * t951 * t53;
  t2226 = t162 * t2225;
  t2236 = -0.4e1 / 0.9e1 * t36 * t408 * t1686 - 0.4e1 / 0.9e1 * t36 * t684 * t1668 + 0.32e2 / 0.27e2 * t36 * t1205 * t693 + 0.32e2 / 0.27e2 * t36 * t1630 * t725 - 0.8e1 / 0.9e1 * t407 * t1652 * t2200 - 0.8e1 / 0.9e1 * t407 * t1646 * t2204 + 0.16e2 / 0.27e2 * t36 * t137 * t940 - 0.32e2 / 0.27e2 * t36 * t137 * t945 + 0.16e2 / 0.27e2 * t36 * t137 * t955 - 0.32e2 / 0.27e2 * t36 * t137 * t917 - 0.2e1 / 0.9e1 * t36 * t42 * t2226 + 0.8e1 / 0.9e1 * t36 * t695 + 0.4e1 / 0.9e1 * t36 * t700 + 0.4e1 / 0.9e1 * t36 * t727;
  t2249 = t1115 * rho[0];
  t2251 = 0.1e1 / t2249 * t1127;
  t2254 = t43 * t926 * t145 * t48 / 0.3e1 - t43 * t57 * t136 * t151 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t713 - t43 * t2251 * sigma[0];
  t2255 = t143 * t2254;
  t2259 = t1205 * t921;
  t2262 = t62 * t939;
  t2263 = t2262 * t155;
  t2264 = t692 * t2263;
  t2267 = t161 * t939;
  t2268 = t2267 * t172;
  t2269 = t408 * t2268;
  t2272 = t438 * t944;
  t2273 = t2272 * t155;
  t2274 = t408 * t2273;
  t2277 = t1161 * t944;
  t2278 = t2277 * t172;
  t2279 = t684 * t2278;
  t2282 = t730 * t740;
  t2283 = t684 * t2282;
  t2286 = t161 * t954;
  t2287 = t2286 * t155;
  t2288 = t408 * t2287;
  t2291 = t438 * t954;
  t2292 = t2291 * t172;
  t2293 = t684 * t2292;
  t2296 = t62 * t916;
  t2297 = t2296 * t155;
  t2298 = t1658 * t2297;
  t2301 = t161 * t916;
  t2302 = t2301 * t172;
  t2303 = t692 * t2302;
  t2306 = t693 * t717;
  t2307 = t692 * t2306;
  t2310 = t1696 * t292;
  t2311 = t408 * t2310;
  t2314 = t698 * t740;
  t2315 = t408 * t2314;
  t2318 = 0.8e1 / 0.9e1 * t36 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t2255 - 0.32e2 / 0.27e2 * t407 * t2259 + 0.4e1 / 0.9e1 * t407 * t2264 + 0.2e1 / 0.9e1 * t407 * t2269 - 0.4e1 / 0.9e1 * t407 * t2274 - 0.4e1 / 0.3e1 * t407 * t2279 + 0.8e1 / 0.9e1 * t407 * t2283 + 0.2e1 / 0.9e1 * t407 * t2288 + 0.4e1 / 0.9e1 * t407 * t2293 - 0.4e1 / 0.3e1 * t407 * t2298 - 0.4e1 / 0.9e1 * t407 * t2303 + 0.8e1 / 0.9e1 * t407 * t2307 + 0.4e1 / 0.9e1 * t407 * t2311 + 0.4e1 / 0.9e1 * t407 * t2315;
  t2319 = t2236 + t2318;
  t2324 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t959 - t2186 - 0.3e1 / 0.8e1 * t6 * t28 * t2319);
  tv3rhosigma20 = t2324 * t7 + t963;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2331 = t6 * t193 * t1013 / 0.8e1;
  t2333 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t1013 - t2331);
  tv3rhosigma25 = t2333 * t7 + t1017;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2339 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t959 - t2186);
  tv3rhosigma26 = t2339 * t7 + t963;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2356 = t312 * t321;
  t2357 = t2356 * t242;
  t2361 = t2356 * t259;
  t2391 = t1520 * rho[1];
  t2393 = 0.1e1 / t2391 * t1532;
  t2396 = t43 * t980 * t232 * t92 / 0.3e1 - t43 * t101 * t223 * t238 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t807 - t43 * t2393 * sigma[2];
  t2397 = t230 * t2396;
  t2401 = t253 * t1004;
  t2406 = 0.4e1 * t2401 * t85 + 0.32e2 / 0.3e1 * t1005 * t97;
  t2407 = t249 * t2406;
  t2411 = -0.4e1 / 0.9e1 * t36 * t609 * t1947 - 0.4e1 / 0.9e1 * t36 * t778 * t1990 + 0.32e2 / 0.27e2 * t36 * t1862 * t819 + 0.32e2 / 0.27e2 * t36 * t1591 * t787 - 0.8e1 / 0.9e1 * t608 * t1876 * t2357 - 0.8e1 / 0.9e1 * t608 * t1870 * t2361 + 0.16e2 / 0.27e2 * t36 * t224 * t994 - 0.32e2 / 0.27e2 * t36 * t224 * t999 + 0.16e2 / 0.27e2 * t36 * t224 * t1009 - 0.32e2 / 0.27e2 * t36 * t224 * t971 + 0.4e1 / 0.9e1 * t36 * t821 + 0.8e1 / 0.9e1 * t36 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t2397 - 0.2e1 / 0.9e1 * t36 * t87 * t2407;
  t2416 = t824 * t834;
  t2417 = t778 * t2416;
  t2420 = t248 * t1008;
  t2421 = t2420 * t242;
  t2422 = t609 * t2421;
  t2425 = t106 * t970;
  t2426 = t2425 * t242;
  t2427 = t1970 * t2426;
  t2430 = t248 * t970;
  t2431 = t2430 * t259;
  t2432 = t786 * t2431;
  t2435 = t1591 * t975;
  t2438 = t639 * t1008;
  t2439 = t2438 * t259;
  t2440 = t778 * t2439;
  t2443 = t787 * t811;
  t2444 = t786 * t2443;
  t2447 = t1975 * t321;
  t2448 = t609 * t2447;
  t2451 = t792 * t834;
  t2452 = t609 * t2451;
  t2455 = t106 * t993;
  t2456 = t2455 * t242;
  t2457 = t786 * t2456;
  t2460 = t248 * t993;
  t2461 = t2460 * t259;
  t2462 = t609 * t2461;
  t2465 = t639 * t998;
  t2466 = t2465 * t242;
  t2467 = t609 * t2466;
  t2470 = t1547 * t998;
  t2471 = t2470 * t259;
  t2472 = t778 * t2471;
  t2475 = 0.8e1 / 0.9e1 * t36 * t789 + 0.4e1 / 0.9e1 * t36 * t794 + 0.8e1 / 0.9e1 * t608 * t2417 + 0.2e1 / 0.9e1 * t608 * t2422 - 0.4e1 / 0.3e1 * t608 * t2427 - 0.4e1 / 0.9e1 * t608 * t2432 - 0.32e2 / 0.27e2 * t608 * t2435 + 0.4e1 / 0.9e1 * t608 * t2440 + 0.8e1 / 0.9e1 * t608 * t2444 + 0.4e1 / 0.9e1 * t608 * t2448 + 0.4e1 / 0.9e1 * t608 * t2452 + 0.4e1 / 0.9e1 * t608 * t2457 + 0.2e1 / 0.9e1 * t608 * t2462 - 0.4e1 / 0.9e1 * t608 * t2467 - 0.4e1 / 0.3e1 * t608 * t2472;
  t2476 = t2411 + t2475;
  t2481 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t1013 - t2331 - 0.3e1 / 0.8e1 * t6 * t81 * t2476);
  tv3rhosigma211 = t2481 * t7 + t1017;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2486 = t2041 * t1019 / 0.6e1;
  t2487 = t273 * t1018;
  t2490 = t860 * t399;
  t2491 = t698 * t155;
  t2492 = t2490 * t2491;
  t2494 = t1663 * t172;
  t2495 = t2016 * t2494;
  t2497 = t861 * t717;
  t2498 = t860 * t2497;
  t2503 = t2041 * t1023 / 0.3e1;
  t2504 = t273 * t1022;
  t2507 = t730 * t155;
  t2508 = t2016 * t2507;
  t2510 = t860 * t52;
  t2511 = t1722 * t172;
  t2512 = t2510 * t2511;
  t2515 = t439 * t740;
  t2516 = t860 * t2515;
  t2518 = t2030 * t1019 / 0.2e1 + t2486 - 0.5e1 / 0.6e1 * t859 * t2487 - t859 * t2492 - t859 * t2495 + t859 * t2498 / 0.2e1 + t2030 * t1023 + t2503 - 0.5e1 / 0.3e1 * t859 * t2504 - t859 * t2508 - 0.3e1 * t859 * t2512 + t859 * t2516;
  t2519 = my_piecewise3(t2, 0, t2518);
  tv3rhosigmalapl0 = t2519 * t7 + t1026;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2524 = t2115 * t1028 / 0.6e1;
  t2527 = t2115 * t1032 / 0.3e1;
  t2529 = my_piecewise3(t72, 0, t2112 * t1028 / 0.2e1 + t2524 + t2112 * t1032 + t2527);
  tv3rhosigmalapl5 = t2529 * t7 + t1035;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2535 = my_piecewise3(t2, 0, t2089 * t1019 / 0.2e1 + t2486 + t2089 * t1023 + t2503);
  tv3rhosigmalapl6 = t2535 * t7 + t1026;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2539 = t302 * t1027;
  t2542 = t898 * t600;
  t2543 = t792 * t242;
  t2544 = t2542 * t2543;
  t2546 = t1956 * t259;
  t2547 = t2167 * t2546;
  t2549 = t899 * t811;
  t2550 = t898 * t2549;
  t2554 = t302 * t1031;
  t2557 = t824 * t242;
  t2558 = t2167 * t2557;
  t2560 = t898 * t96;
  t2561 = t1965 * t259;
  t2562 = t2560 * t2561;
  t2565 = t640 * t834;
  t2566 = t898 * t2565;
  t2568 = t2153 * t1028 / 0.2e1 + t2524 - 0.5e1 / 0.6e1 * t897 * t2539 - t897 * t2544 - t897 * t2547 + t897 * t2550 / 0.2e1 + t2153 * t1032 + t2527 - 0.5e1 / 0.3e1 * t897 * t2554 - t897 * t2558 - 0.3e1 * t897 * t2562 + t897 * t2566;
  t2569 = my_piecewise3(t72, 0, t2568);
  tv3rhosigmalapl11 = t2569 * t7 + t1035;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2574 = 0.2e1 / 0.3e1 * t2041 * t1039;
  t2575 = t860 * t1038;
  t2578 = t1037 * t142;
  t2579 = t438 * t57;
  t2580 = t2579 * t155;
  t2581 = t2578 * t2580;
  t2584 = t1037 * t52;
  t2585 = t1161 * t57;
  t2586 = t2585 * t172;
  t2587 = t2584 * t2586;
  t2591 = my_piecewise3(t2, 0, -0.2e1 * t2030 * t1039 - t2574 + 0.4e1 / 0.3e1 * t859 * t2575 + 0.2e1 * t859 * t2581 + 0.6e1 * t859 * t2587);
  tv3rholapl20 = t2591 * t7 + t1042;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2596 = 0.2e1 / 0.3e1 * t2115 * t1046;
  t2598 = my_piecewise3(t72, 0, -0.2e1 * t1046 * t2112 - t2596);
  tv3rholapl22 = t2598 * t7 + t1049;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2603 = my_piecewise3(t2, 0, -0.2e1 * t1039 * t2089 - t2574);
  tv3rholapl23 = t2603 * t7 + t1042;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2607 = t898 * t1045;
  t2610 = t1044 * t229;
  t2611 = t639 * t101;
  t2612 = t2611 * t242;
  t2613 = t2610 * t2612;
  t2616 = t1044 * t96;
  t2617 = t1547 * t101;
  t2618 = t2617 * t259;
  t2619 = t2616 * t2618;
  t2623 = my_piecewise3(t72, 0, -0.2e1 * t2153 * t1046 - t2596 + 0.4e1 / 0.3e1 * t897 * t2607 + 0.2e1 * t897 * t2613 + 0.6e1 * t897 * t2619);
  tv3rholapl25 = t2623 * t7 + t1049;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2631 = t1663 * t944;
  t2632 = t408 * t2631;
  t2635 = t287 * t287;
  t2636 = 0.1e1 / t2635;
  t2637 = t56 * t2636;
  t2640 = -0.12e2 * t2637 * t40 + 0.12e2 * t950;
  t2641 = t162 * t2640;
  t2654 = 0.1e1 / t44 / t287;
  t2667 = 0.1e1 / t1115;
  t2671 = 0.3e1 / 0.8e1 * t43 * t2654 * t46 * t48 - 0.3e1 / 0.8e1 * t43 * t288 * t41 * t151 - t43 * t57 * t935 * t428 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2667 * t1127;
  t2672 = t143 * t2671;
  t2676 = t2301 * t292;
  t2677 = t692 * t2676;
  t2680 = t693 * t939;
  t2681 = t692 * t2680;
  t2684 = t2267 * t292;
  t2685 = t408 * t2684;
  t2688 = t698 * t954;
  t2689 = t408 * t2688;
  t2692 = t944 * t292;
  t2693 = t1162 * t2692;
  t2697 = t730 * t954;
  t2698 = t684 * t2697;
  t2701 = t916 * t283;
  t2702 = t1178 * t2701;
  t2706 = -0.2e1 / 0.3e1 * t36 * t408 * t2262 - 0.2e1 / 0.3e1 * t36 * t684 * t2286 - 0.4e1 / 0.3e1 * t407 * t2632 - 0.2e1 / 0.9e1 * t36 * t42 * t2641 + 0.4e1 / 0.3e1 * t36 * t692 * t2296 + 0.4e1 / 0.3e1 * t36 * t922 + 0.4e1 / 0.3e1 * t36 * t684 * t2272 - 0.2e1 / 0.9e1 * t36 * t42 * t2672 - 0.4e1 / 0.3e1 * t407 * t2677 + 0.4e1 / 0.3e1 * t407 * t2681 + 0.2e1 / 0.3e1 * t407 * t2685 + 0.2e1 / 0.3e1 * t407 * t2689 - 0.4e1 / 0.3e1 * t36 * t42 * t2693 + 0.4e1 / 0.3e1 * t407 * t2698 - 0.4e1 / 0.3e1 * t36 * t42 * t2702;
  t2710 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t2706);
  tv3sigma30 = t7 * t2710;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2717 = t1956 * t998;
  t2718 = t609 * t2717;
  t2721 = t316 * t316;
  t2722 = 0.1e1 / t2721;
  t2723 = t100 * t2722;
  t2726 = -0.12e2 * t2723 * t85 + 0.12e2 * t1004;
  t2727 = t249 * t2726;
  t2740 = 0.1e1 / t88 / t316;
  t2753 = 0.1e1 / t1520;
  t2757 = 0.3e1 / 0.8e1 * t43 * t2740 * t90 * t92 - 0.3e1 / 0.8e1 * t43 * t317 * t86 * t238 - t43 * t101 * t989 * t629 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2753 * t1532;
  t2758 = t230 * t2757;
  t2762 = t824 * t1008;
  t2763 = t778 * t2762;
  t2766 = t970 * t312;
  t2767 = t1564 * t2766;
  t2771 = t2430 * t321;
  t2772 = t786 * t2771;
  t2775 = t787 * t993;
  t2776 = t786 * t2775;
  t2779 = t2460 * t321;
  t2780 = t609 * t2779;
  t2783 = t792 * t1008;
  t2784 = t609 * t2783;
  t2787 = t998 * t321;
  t2788 = t1548 * t2787;
  t2792 = -0.2e1 / 0.3e1 * t36 * t609 * t2455 - 0.2e1 / 0.3e1 * t36 * t778 * t2420 - 0.4e1 / 0.3e1 * t608 * t2718 - 0.2e1 / 0.9e1 * t36 * t87 * t2727 + 0.4e1 / 0.3e1 * t36 * t786 * t2425 + 0.4e1 / 0.3e1 * t36 * t976 + 0.4e1 / 0.3e1 * t36 * t778 * t2465 - 0.2e1 / 0.9e1 * t36 * t87 * t2758 + 0.4e1 / 0.3e1 * t608 * t2763 - 0.4e1 / 0.3e1 * t36 * t87 * t2767 - 0.4e1 / 0.3e1 * t608 * t2772 + 0.4e1 / 0.3e1 * t608 * t2776 + 0.2e1 / 0.3e1 * t608 * t2780 + 0.2e1 / 0.3e1 * t608 * t2784 - 0.4e1 / 0.3e1 * t36 * t87 * t2788;
  t2796 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t2792);
  tv3sigma39 = t7 * t2796;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t2797 = t2012 * t916;
  t2798 = t860 * t2797;
  t2800 = t1663 * t292;
  t2801 = t2016 * t2800;
  t2804 = t861 * t939;
  t2805 = t860 * t2804;
  t2808 = t1162 * t944;
  t2809 = t860 * t2808;
  t2812 = t439 * t954;
  t2813 = t860 * t2812;
  t2816 = my_piecewise3(t2, 0, -t859 * t2798 - 0.2e1 * t859 * t2801 + t859 * t2805 / 0.2e1 - 0.3e1 * t859 * t2809 + t859 * t2813);
  tv3sigma2lapl0 = t7 * t2816;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t2817 = t2163 * t970;
  t2818 = t898 * t2817;
  t2820 = t1956 * t321;
  t2821 = t2167 * t2820;
  t2824 = t899 * t993;
  t2825 = t898 * t2824;
  t2828 = t1548 * t998;
  t2829 = t898 * t2828;
  t2832 = t640 * t1008;
  t2833 = t898 * t2832;
  t2836 = my_piecewise3(t72, 0, -t897 * t2818 - 0.2e1 * t897 * t2821 + t897 * t2825 / 0.2e1 - 0.3e1 * t897 * t2829 + t897 * t2833);
  tv3sigma2lapl11 = t7 * t2836;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t2837 = t2579 * t283;
  t2838 = t2578 * t2837;
  t2841 = t2585 * t292;
  t2842 = t2584 * t2841;
  t2845 = t439 * t288;
  t2846 = t1037 * t2845;
  t2850 = my_piecewise3(t2, 0, 0.2e1 * t2838 * t859 + 0.6e1 * t2842 * t859 + 0.2e1 * t2846 * t859);
  tv3sigmalapl20 = t7 * t2850;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t2851 = t2611 * t312;
  t2852 = t2610 * t2851;
  t2855 = t2617 * t321;
  t2856 = t2616 * t2855;
  t2859 = t640 * t317;
  t2860 = t1044 * t2859;
  t2864 = my_piecewise3(t72, 0, 0.2e1 * t2852 * t897 + 0.6e1 * t2856 * t897 + 0.2e1 * t2860 * t897);
  tv3sigmalapl28 = t7 * t2864;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t2865 = t34 * t38;
  t2866 = t1162 * t288;
  t2867 = t2865 * t2866;
  t2870 = my_piecewise3(t2, 0, -0.12e2 * t859 * t2867);
  tv3lapl30 = t7 * t2870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t2871 = t34 * t83;
  t2872 = t1548 * t317;
  t2873 = t2871 * t2872;
  t2876 = my_piecewise3(t72, 0, -0.12e2 * t897 * t2873);
  tv3lapl33 = t7 * t2876;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t30, t32;
  double t33, t34, t35, t36, t37, t38, t39, t40;
  double t41, t42, t43, t44, t45, t46, t47, t48;
  double t51, t52, t53, t54, t56, t57, t58, t61;
  double t62, t63, t67, t71, t72, t73, t75, t76;
  double t77, t78, t80, t81, t82, t83, t84, t85;
  double t86, t87, t88, t89, t90, t91, t92, t95;
  double t96, t97, t98, t100, t101, t102, t105, t106;
  double t107, t111, t115, tzk0;

  double t116, t117, t118, t120, t123, t124, t128, t129;
  double t130, t133, t134, t136, t137, t141, t142, t143;
  double t145, t149, t150, t151, t155, t156, t160, t161;
  double t162, t166, t167, t172, t173, t177, t182, t183;
  double t185, t188, t189, t193, t196, t198, tvrho0, t202;
  double t205, t206, t211, t213, t216, t217, t221, t223;
  double t224, t228, t229, t230, t232, t236, t237, t238;
  double t242, t243, t247, t248, t249, t253, t254, t259;
  double t260, t264, t269, tvrho1, t272, t273, t276, t283;
  double t284, t287, t288, t289, t292, t293, t297, t301;
  double tvsigma0, tvsigma1, t302, t305, t312, t313, t316, t317;
  double t318, t321, t322, t326, t330, tvsigma2, t331, t332;
  double t333, t336, t339, tvlapl0, t340, t341, t344, t347;
  double tvlapl1, tvtau0, tvtau1;

  double t350, t351, t352, t355, t356, t357, t360, t364;
  double t365, t369, t371, t377, t378, t381, t383, t385;
  double t387, t388, t399, t400, t401, t402, t407, t408;
  double t409, t410, t411, t415, t425, t428, t432, t433;
  double t438, t439, t440, t441, t448, t449, t456, t457;
  double t461, t466, t467, t468, t469, t472, t475, t479;
  double t480, t484, t486, t488, t491, t493, tv2rho20, t496;
  double t500, t504, t505, t509, t511, t519, t520, t524;
  double t528, t529, t533, t535, t542, t545, tv2rho21, t550;
  double t555, t559, t560, t566, t567, t572, t576, t577;
  double t586, t588, t589, t600, t601, t602, t603, t608;
  double t609, t610, t611, t612, t616, t626, t629, t633;
  double t634, t639, t640, t641, t642, t649, t650, t657;
  double t658, t662, t667, tv2rho22, t675, t676, t680, t684;
  double t685, t692, t693, t694, t695, t698, t699, t700;
  double t710, t712, t713, t717, t718, t725, t726, t727;
  double t730, t731, t732, t735, t740, t741, t745, t750;
  double tv2rhosigma0, tv2rhosigma1, t757, t759, tv2rhosigma2, t765, tv2rhosigma3, tv2rhosigma4;
  double t770, t774, t778, t779, t786, t787, t788, t789;
  double t792, t793, t794, t804, t806, t807, t811, t812;
  double t819, t820, t821, t824, t825, t826, t829, t834;
  double t835, t839, t844, tv2rhosigma5, t846, t847, t850, t851;
  double t853, t855, t858, t859, t860, t861, t862, t863;
  double t866, t867, t870, tv2rholapl0, t872, t873, t876, t878;
  double t880, tv2rholapl1, t882, t883, t887, tv2rholapl2, t889, t890;
  double t894, t897, t898, t899, t900, t901, t904, t905;
  double t908, tv2rholapl3, tv2rhotau0, tv2rhotau1, tv2rhotau2, tv2rhotau3, t916, t917;
  double t921, t922, t926, t933, t935, t939, t940, t944;
  double t945, t949, t950, t951, t954, t955, t959, t963;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t970, t971, t975;
  double t976, t980, t987, t989, t993, t994, t998, t999;
  double t1003, t1004, t1005, t1008, t1009, t1013, t1017, tv2sigma25;
  double t1018, t1019, t1022, t1023, t1026, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2;
  double tv2sigmalapl3, tv2sigmalapl4, t1027, t1028, t1031, t1032, t1035, tv2sigmalapl5;
  double tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t1036, t1037;
  double t1038, t1039, t1042, tv2lapl20, tv2lapl21, t1043, t1044, t1045;
  double t1046, t1049, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3, tv2tau20;
  double tv2tau21, tv2tau22;

  double t1053, t1054, t1057, t1060, t1061, t1062, t1065, t1069;
  double t1070, t1074, t1076, t1081, t1083, t1086, t1092, t1093;
  double t1096, t1098, t1101, t1104, t1110, t1111, t1115, t1117;
  double t1122, t1123, t1125, t1127, t1131, t1132, t1139, t1140;
  double t1147, t1150, t1151, t1155, t1156, t1157, t1160, t1161;
  double t1162, t1163, t1164, t1169, t1170, t1176, t1177, t1178;
  double t1179, t1180, t1184, t1185, t1186, t1189, t1190, t1193;
  double t1194, t1195, t1198, t1199, t1205, t1206, t1224, t1229;
  double t1231, t1232, t1235, t1238, t1241, t1245, t1246, t1250;
  double t1252, t1254, t1256, t1258, t1261, t1263, tv3rho30, t1266;
  double t1267, t1268, t1271, t1276, t1277, t1279, t1283, t1284;
  double t1288, t1291, t1295, t1297, t1301, t1310, t1311, t1312;
  double t1315, t1320, t1322, t1326, t1327, t1331, t1334, t1335;
  double t1337, t1346, t1348, t1351, tv3rho31, t1354, t1359, t1363;
  double t1367, t1368, t1372, t1374, t1383, t1384, t1389, t1393;
  double t1397, t1398, t1402, t1404, t1411, t1419, t1421, t1422;
  double tv3rho32, t1427, t1434, t1438, t1439, t1446, t1447, t1454;
  double t1458, t1459, t1475, t1476, t1480, t1481, t1488, t1491;
  double t1492, t1512, t1520, t1522, t1527, t1528, t1530, t1532;
  double t1536, t1537, t1541, t1542, t1543, t1546, t1547, t1548;
  double t1549, t1550, t1555, t1556, t1562, t1563, t1564, t1565;
  double t1566, t1570, t1571, t1572, t1575, t1576, t1579, t1580;
  double t1581, t1584, t1585, t1591, t1592, t1595, t1600, tv3rho33;
  double t1608, t1615, t1617, t1619, t1623, t1630, t1634, t1638;
  double t1646, t1647, t1648, t1652, t1653, t1654, t1658, t1659;
  double t1660, t1663, t1664, t1665, t1668, t1669, t1670, t1673;
  double t1674, t1677, t1678, t1679, t1682, t1683, t1686, t1687;
  double t1688, t1691, t1692, t1693, t1696, t1697, t1698, t1701;
  double t1702, t1705, t1708, t1711, t1712, t1715, t1718, t1719;
  double t1722, t1723, t1724, t1737, t1741, t1743, t1747, t1748;
  double t1755, t1762, t1763, t1775, t1776, t1781, tv3rho2sigma0, tv3rho2sigma1;
  double t1788, t1792, t1794, tv3rho2sigma2, t1800, t1808, tv3rho2sigma3, tv3rho2sigma4;
  double t1814, t1821, t1824, tv3rho2sigma5, t1832, tv3rho2sigma6, tv3rho2sigma7, t1843;
  double t1847, t1851, t1855, t1862, t1870, t1871, t1872, t1876;
  double t1877, t1878, t1892, t1896, t1898, t1902, t1903, t1910;
  double t1917, t1918, t1930, t1931, t1932, t1933, t1936, t1937;
  double t1940, t1941, t1944, t1947, t1948, t1949, t1952, t1953;
  double t1956, t1957, t1958, t1961, t1962, t1965, t1966, t1967;
  double t1970, t1971, t1972, t1975, t1976, t1977, t1980, t1981;
  double t1984, t1987, t1990, t1991, t1992, t1995, t1996, t1999;
  double t2000, t2005, tv3rho2sigma8, t2008, t2009, t2012, t2013, t2014;
  double t2016, t2017, t2018, t2021, t2022, t2025, t2026, t2030;
  double t2034, t2035, t2037, t2038, t2040, t2041, t2042, t2044;
  double t2047, t2050, t2053, t2056, t2057, t2060, t2061, t2063;
  double t2064, tv3rho2lapl0, t2067, t2068, t2071, t2072, t2074, t2076;
  double t2078, tv3rho2lapl1, t2080, t2081, t2084, t2085, t2089, t2098;
  double tv3rho2lapl2, t2100, t2101, t2104, t2105, t2110, t2112, t2115;
  double t2116, t2119, t2122, tv3rho2lapl3, t2125, t2126, t2131, tv3rho2lapl4;
  double t2135, t2138, t2141, t2144, t2145, t2148, t2149, t2153;
  double t2159, t2160, t2163, t2164, t2165, t2167, t2168, t2169;
  double t2172, t2173, t2178, t2179, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2;
  double tv3rho2tau3, tv3rho2tau4, tv3rho2tau5, t2186, t2199, t2200, t2204, t2220;
  double t2225, t2226, t2236, t2249, t2251, t2254, t2255, t2259;
  double t2262, t2263, t2264, t2267, t2268, t2269, t2272, t2273;
  double t2274, t2277, t2278, t2279, t2282, t2283, t2286, t2287;
  double t2288, t2291, t2292, t2293, t2296, t2297, t2298, t2301;
  double t2302, t2303, t2306, t2307, t2310, t2311, t2314, t2315;
  double t2318, t2319, t2324, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2331, t2333, tv3rhosigma25, t2339, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t2356, t2357, t2361, t2391, t2393, t2396, t2397;
  double t2401, t2406, t2407, t2411, t2416, t2417, t2420, t2421;
  double t2422, t2425, t2426, t2427, t2430, t2431, t2432, t2435;
  double t2438, t2439, t2440, t2443, t2444, t2447, t2448, t2451;
  double t2452, t2455, t2456, t2457, t2460, t2461, t2462, t2465;
  double t2466, t2467, t2470, t2471, t2472, t2475, t2476, t2481;
  double tv3rhosigma211, t2486, t2487, t2490, t2491, t2492, t2494, t2495;
  double t2497, t2498, t2503, t2504, t2507, t2508, t2510, t2511;
  double t2512, t2515, t2516, t2518, t2519, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2;
  double tv3rhosigmalapl3, tv3rhosigmalapl4, t2524, t2527, t2529, tv3rhosigmalapl5, t2535, tv3rhosigmalapl6;
  double tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2539, t2542, t2543, t2544;
  double t2546, t2547, t2549, t2550, t2554, t2557, t2558, t2560;
  double t2561, t2562, t2565, t2566, t2568, t2569, tv3rhosigmalapl11, tv3rhosigmatau0;
  double tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2574, t2575, t2578, t2579, t2580;
  double t2581, t2584, t2585, t2586, t2587, t2591, tv3rholapl20, tv3rholapl21;
  double t2596, t2598, tv3rholapl22, t2603, tv3rholapl23, tv3rholapl24, t2607, t2610;
  double t2611, t2612, t2613, t2616, t2617, t2618, t2619, t2623;
  double tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4, tv3rholapltau5, tv3rholapltau6;
  double tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23, tv3rhotau24, tv3rhotau25, t2631;
  double t2632, t2635, t2636, t2637, t2640, t2641, t2654, t2667;
  double t2671, t2672, t2676, t2677, t2680, t2681, t2684, t2685;
  double t2688, t2689, t2692, t2693, t2697, t2698, t2701, t2702;
  double t2706, t2710, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t2717, t2718, t2721, t2722, t2723;
  double t2726, t2727, t2740, t2753, t2757, t2758, t2762, t2763;
  double t2766, t2767, t2771, t2772, t2775, t2776, t2779, t2780;
  double t2783, t2784, t2787, t2788, t2792, t2796, tv3sigma39, t2797;
  double t2798, t2800, t2801, t2804, t2805, t2808, t2809, t2812;
  double t2813, t2816, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t2817, t2818, t2820;
  double t2821, t2824, t2825, t2828, t2829, t2832, t2833, t2836;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t2837, t2838, t2841;
  double t2842, t2845, t2846, t2850, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t2851, t2852, t2855, t2856;
  double t2859, t2860, t2864, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3;
  double tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11;
  double tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27;
  double tv3sigmatau28, t2865, t2866, t2867, t2870, tv3lapl30, tv3lapl31, tv3lapl32;
  double t2871, t2872, t2873, t2876, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2;
  double tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24;
  double tv3lapltau25, tv3tau30, tv3tau31, tv3tau32, tv3tau33;

  double t2881, t2885, t2916, t2928, t2970, t2971, t2972, t2977;
  double t2989, t2990, t2991, t2996, t3004, t3005, t3018, t3037;
  double t3059, t3069, t3079, t3084, t3089, t3091, t3092, t3098;
  double t3104, t3105, t3108, t3112, t3121, t3127, t3129, t3135;
  double t3138, t3141, t3145, t3149, t3153, t3156, t3160, t3161;
  double t3162, t3163, t3165, t3166, t3172, t3177, t3180, t3184;
  double t3191, t3195, t3199, t3204, t3206, tv4rho40, t3227, t3228;
  double t3230, t3234, t3243, t3249, t3250, t3252, t3265, t3269;
  double t3270, t3273, t3278, t3279, t3296, t3298, t3302, t3309;
  double t3313, t3314, t3317, t3326, t3329, t3330, t3332, t3334;
  double t3335, tv4rho41, t3344, t3354, t3367, t3371, t3380, t3393;
  double t3400, t3401, t3410, t3423, t3427, t3434, t3438, t3447;
  double t3450, t3461, t3464, t3466, t3467, tv4rho42, t3488, t3492;
  double t3499, t3510, t3511, t3528, t3532, t3539, t3547, t3556;
  double t3566, t3568, t3569, tv4rho43, t3574, t3579, t3586, t3590;
  double t3599, t3609, t3614, t3642, t3652, t3662, t3683, t3688;
  double t3689, t3698, t3699, t3700, t3705, t3725, t3735, t3747;
  double t3795, t3796, t3797, t3802, t3814, t3819, t3824, t3831;
  double t3835, t3848, t3849, tv4rho44, t3857, t3863, t3866, t3873;
  double t3875, t3878, t3891, t3902, t3921, t3949, t3954, t3959;
  double t3968, t3985, t3996, t4001, t4005, t4031, t4100, t4106;
  double t4110, t4115, t4123, t4124, t4129, t4130, t4136, t4155;
  double t4210, t4217, tv4rho3sigma0, tv4rho3sigma1, t4224, t4227, t4231, t4233;
  double tv4rho3sigma2, t4235, t4241, t4246, t4250, t4259, t4260, tv4rho3sigma3;
  double tv4rho3sigma4, t4262, t4268, t4270, t4279, t4281, t4284, tv4rho3sigma5;
  double t4290, t4299, tv4rho3sigma6, tv4rho3sigma7, t4305, t4312, t4320, t4322;
  double t4323, tv4rho3sigma8, t4332, tv4rho3sigma9, tv4rho3sigma10, t4353, t4358, t4362;
  double t4370, t4388, t4398, t4409, t4414, t4426, t4451, t4473;
  double t4511, t4569, t4580, t4584, t4588, t4598, t4631, t4632;
  double t4637, t4643, t4680, t4687, tv4rho3sigma11, t4694, t4695, t4696;
  double t4697, t4707, t4714, t4720, t4725, t4743, t4744, t4745;
  double t4747, t4749, t4751, t4753, t4755, t4757, t4768, t4771;
  double t4772, t4774, t4777, t4779, t4783, t4785, t4808, t4810;
  double t4826, t4829, tv4rho3lapl0, t4837, t4840, t4844, t4846, tv4rho3lapl1;
  double t4848, t4854, t4858, t4860, t4862, t4874, t4880, t4893;
  double t4896, t4902, t4904, tv4rho3lapl2, t4906, t4913, t4915, t4922;
  double t4923, t4925, t4928, t4930, t4931, t4932, t4936, t4937;
  double t4939, t4940, tv4rho3lapl3, t4947, t4951, t4960, t4961, tv4rho3lapl4;
  double t4965, t4966, t4967, t4969, t4971, t4973, t4975, t4977;
  double t4979, t4981, t4993, t4997, t4999, t5001, t5014, t5018;
  double t5020, tv4rho3lapl5, t5030, tv4rho3lapl6, t5054, t5067, t5068, t5088;
  double t5109, t5116, t5145, t5148, tv4rho3lapl7, tv4rho3tau0, tv4rho3tau1, tv4rho3tau2;
  double tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7, t5155, t5162, t5164;
  double t5174, t5183, t5208, t5213, t5221, t5234, t5243, t5259;
  double t5264, t5286, t5287, t5304, t5343, t5401, t5418, t5423;
  double t5438, t5455, t5487, t5501, t5531, t5539, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t5546, t5550, t5552, tv4rho2sigma25, t5558;
  double t5566, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t5572, t5579;
  double t5582, tv4rho2sigma211, t5590, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216;
  double t5629, t5638, t5650, t5651, t5659, t5691, t5719, t5729;
  double t5737, t5738, t5745, t5764, t5810, t5835, t5859, t5864;
  double t5869, t5874, t5876, t5911, t5925, t5967, t5975, tv4rho2sigma217;
  double t5980, t5981, t5983, t5988, t5992, t5997, t6007, t6011;
  double t6013, t6014, t6022, t6027, t6030, t6038, t6040, t6042;
  double t6052, t6065, t6067, t6076, t6117, t6120, tv4rho2sigmalapl0, tv4rho2sigmalapl1;
  double tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, t6125, t6128, t6130, t6133, t6135;
  double tv4rho2sigmalapl5, t6139, t6152, t6154, t6166, t6168, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, t6172, t6177, t6180, t6183, t6187;
  double t6189, t6191, t6196, t6199, t6203, t6205, t6207, t6209;
  double tv4rho2sigmalapl11, t6218, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t6222;
  double t6224, t6229, t6254, t6273, t6279, t6313, t6344, t6347;
  double tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, tv4rho2sigmatau6;
  double tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14;
  double tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t6350, t6352, t6354, t6373, t6382;
  double t6385, t6391, t6397, t6402, t6403, tv4rho2lapl20, tv4rho2lapl21, t6408;
  double t6411, t6413, tv4rho2lapl22, t6417, t6430, tv4rho2lapl23, tv4rho2lapl24, t6434;
  double t6439, t6443, t6447, t6450, tv4rho2lapl25, t6457, tv4rho2lapl26, tv4rho2lapl27;
  double t6487, t6493, t6499, t6506, t6507, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1;
  double tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9;
  double tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20, tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24, tv4rho2tau25;
  double tv4rho2tau26, tv4rho2tau27, tv4rho2tau28, t6514, t6521, t6526, t6566, t6571;
  double t6576, t6609, t6618, t6623, t6661, t6675, t6688, t6697;
  double t6706, t6715, t6728, t6740, t6784, t6791, tv4rhosigma30, tv4rhosigma31;
  double tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t6798;
  double t6800, tv4rhosigma39, t6806, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314;
  double tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t6876, t6881, t6920, t6940;
  double t6945, t6947, t6960, t6965, t6978, t6999, t7008, t7013;
  double t7018, t7031, t7040, t7053, t7080, t7087, tv4rhosigma319, t7096;
  double t7101, t7106, t7111, t7125, t7141, t7180, t7182, tv4rhosigma2lapl0;
  double tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8;
  double tv4rhosigma2lapl9, tv4rhosigma2lapl10, t7186, t7190, t7194, t7197, t7200, t7202;
  double tv4rhosigma2lapl11, t7213, tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17;
  double tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, t7243, t7297, t7299;
  double tv4rhosigma2lapl23, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6;
  double tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14;
  double tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22;
  double tv4rhosigma2tau23, t7304, t7310, t7326, t7330, t7348, t7352, t7357;
  double t7362, t7363, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25;
  double tv4rhosigmalapl26, tv4rhosigmalapl27, t7368, t7372, t7376, t7378, tv4rhosigmalapl28, t7387;
  double tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216;
  double t7396, t7414, t7434, t7439, t7444, t7445, tv4rhosigmalapl217, tv4rhosigmalapltau0;
  double tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8;
  double tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16;
  double tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20;
  double tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28;
  double tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216;
  double tv4rhosigmatau217, t7450, t7454, t7459, t7460, t7466, tv4rholapl30, tv4rholapl31;
  double tv4rholapl32, t7471, t7473, tv4rholapl33, t7478, tv4rholapl34, tv4rholapl35, tv4rholapl36;
  double t7485, t7490, t7491, t7497, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2;
  double tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10;
  double tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26;
  double tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, tv4rhotau30, tv4rhotau31, tv4rhotau32;
  double tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37, t7537, t7542, t7547;
  double t7552, t7581, t7638, t7643, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43;
  double tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411;
  double tv4sigma412, tv4sigma413, t7656, t7661, t7666, t7671, t7726, t7783;
  double t7788, tv4sigma414, t7829, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t7870, tv4sigma3lapl19;
  double tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7;
  double tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15;
  double tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19, t7904, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22;
  double tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210;
  double tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, t7938, tv4sigma2lapl217;
  double tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7;
  double tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15;
  double tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23;
  double tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27;
  double tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215;
  double tv4sigma2tau216, tv4sigma2tau217, t7952, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34;
  double tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310, t7966, tv4sigmalapl311;
  double tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7;
  double tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15;
  double tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25;
  double tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213;
  double tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33;
  double tv4sigmatau34, tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311;
  double t7972, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, t7978, tv4lapl44, tv4lapl3tau0;
  double tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20;
  double tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28;
  double tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, tv4lapltau37;
  double tv4tau40, tv4tau41, tv4tau42, tv4tau43, tv4tau44;

  mgga_x_jk_params *params;

  assert(p->params != NULL);
  params = (mgga_x_jk_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t5 = 0.1e1 / t4;
  t6 = t3 * t5;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = t3 * t3;
  t30 = params->beta * t29;
  t32 = POW_1_3(0.1e1 / M_PI);
  t33 = 0.1e1 / t32;
  t34 = M_CBRT4;
  t35 = t33 * t34;
  t36 = t30 * t35;
  t37 = rho[0] * rho[0];
  t38 = POW_1_3(rho[0]);
  t39 = t38 * t38;
  t40 = t39 * t37;
  t41 = 0.1e1 / t40;
  t42 = sigma[0] * t41;
  t43 = params->gamma * params->beta;
  t44 = sqrt(sigma[0]);
  t45 = t38 * rho[0];
  t46 = 0.1e1 / t45;
  t47 = t44 * t46;
  t48 = log(t47 + sqrt(t47 * t47 + 0.1e1));
  t51 = t43 * t47 * t48 + 0.1e1;
  t52 = 0.1e1 / t51;
  t53 = t39 * rho[0];
  t54 = 0.1e1 / t53;
  t56 = -lapl[0] * t54 + t42;
  t57 = 0.1e1 / sigma[0];
  t58 = t56 * t57;
  t61 = 0.2e1 * t40 * t58 + 0.1e1;
  t62 = 0.1e1 / t61;
  t63 = t52 * t62;
  t67 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t42 * t63;
  t71 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t67);
  t72 = rho[1] <= p->dens_threshold;
  t73 = -t17;
  t75 = my_piecewise5(t15, t12, t11, t16, t73 * t8);
  t76 = 0.1e1 + t75;
  t77 = t76 <= p->zeta_threshold;
  t78 = POW_1_3(t76);
  t80 = my_piecewise3(t77, t23, t78 * t76);
  t81 = t80 * t27;
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t85 = t84 * t82;
  t86 = 0.1e1 / t85;
  t87 = sigma[2] * t86;
  t88 = sqrt(sigma[2]);
  t89 = t83 * rho[1];
  t90 = 0.1e1 / t89;
  t91 = t88 * t90;
  t92 = log(t91 + sqrt(t91 * t91 + 0.1e1));
  t95 = t43 * t91 * t92 + 0.1e1;
  t96 = 0.1e1 / t95;
  t97 = t84 * rho[1];
  t98 = 0.1e1 / t97;
  t100 = -lapl[1] * t98 + t87;
  t101 = 0.1e1 / sigma[2];
  t102 = t100 * t101;
  t105 = 0.2e1 * t102 * t85 + 0.1e1;
  t106 = 0.1e1 / t105;
  t107 = t96 * t106;
  t111 = 0.1e1 + 0.2e1 / 0.9e1 * t36 * t87 * t107;
  t115 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t111);
  tzk0 = t71 + t115;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t116 = t7 * t7;
  t117 = 0.1e1 / t116;
  t118 = t17 * t117;
  t120 = my_piecewise5(t11, 0, t15, 0, t8 - t118);
  t123 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t120);
  t124 = t123 * t27;
  t128 = t27 * t27;
  t129 = 0.1e1 / t128;
  t130 = t26 * t129;
  t133 = t6 * t130 * t67 / 0.8e1;
  t134 = t37 * rho[0];
  t136 = 0.1e1 / t39 / t134;
  t137 = sigma[0] * t136;
  t141 = t51 * t51;
  t142 = 0.1e1 / t141;
  t143 = t142 * t62;
  t145 = 0.1e1 / t38 / t37;
  t149 = t42 + 0.1e1;
  t150 = sqrt(t149);
  t151 = 0.1e1 / t150;
  t155 = -0.4e1 / 0.3e1 * t43 * t44 * t145 * t48 - 0.4e1 / 0.3e1 * t43 * t137 * t151;
  t156 = t143 * t155;
  t160 = t61 * t61;
  t161 = 0.1e1 / t160;
  t162 = t52 * t161;
  t166 = -0.8e1 / 0.3e1 * t137 + 0.5e1 / 0.3e1 * lapl[0] * t41;
  t167 = t166 * t57;
  t172 = 0.2e1 * t167 * t40 + 0.16e2 / 0.3e1 * t58 * t53;
  t173 = t162 * t172;
  t177 = -0.16e2 / 0.27e2 * t36 * t137 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t156 - 0.2e1 / 0.9e1 * t36 * t42 * t173;
  t182 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t67 - t133 - 0.3e1 / 0.8e1 * t6 * t28 * t177);
  t183 = t73 * t117;
  t185 = my_piecewise5(t15, 0, t11, 0, -t8 - t183);
  t188 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t185);
  t189 = t188 * t27;
  t193 = t80 * t129;
  t196 = t6 * t193 * t111 / 0.8e1;
  t198 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t111 - t196);
  tvrho0 = t71 + t115 + t7 * (t182 + t198);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t202 = my_piecewise5(t11, 0, t15, 0, -t8 - t118);
  t205 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t202);
  t206 = t205 * t27;
  t211 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t67 - t133);
  t213 = my_piecewise5(t15, 0, t11, 0, t8 - t183);
  t216 = my_piecewise3(t77, 0, 0.4e1 / 0.3e1 * t78 * t213);
  t217 = t216 * t27;
  t221 = t82 * rho[1];
  t223 = 0.1e1 / t84 / t221;
  t224 = sigma[2] * t223;
  t228 = t95 * t95;
  t229 = 0.1e1 / t228;
  t230 = t229 * t106;
  t232 = 0.1e1 / t83 / t82;
  t236 = t87 + 0.1e1;
  t237 = sqrt(t236);
  t238 = 0.1e1 / t237;
  t242 = -0.4e1 / 0.3e1 * t43 * t88 * t232 * t92 - 0.4e1 / 0.3e1 * t43 * t224 * t238;
  t243 = t230 * t242;
  t247 = t105 * t105;
  t248 = 0.1e1 / t247;
  t249 = t96 * t248;
  t253 = -0.8e1 / 0.3e1 * t224 + 0.5e1 / 0.3e1 * lapl[1] * t86;
  t254 = t253 * t101;
  t259 = 0.2e1 * t254 * t85 + 0.16e2 / 0.3e1 * t102 * t97;
  t260 = t249 * t259;
  t264 = -0.16e2 / 0.27e2 * t36 * t224 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t243 - 0.2e1 / 0.9e1 * t36 * t87 * t260;
  t269 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t111 - t196 - 0.3e1 / 0.8e1 * t6 * t81 * t264);
  tvrho1 = t71 + t115 + t7 * (t211 + t269);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t272 = t30 * t33;
  t273 = t34 * t41;
  t276 = 0.1e1 / t44;
  t283 = t43 * t276 * t46 * t48 / 0.2e1 + t43 * t41 * t151 / 0.2e1;
  t284 = t143 * t283;
  t287 = sigma[0] * sigma[0];
  t288 = 0.1e1 / t287;
  t289 = t56 * t288;
  t292 = -0.2e1 * t289 * t40 + 0.2e1 * t57;
  t293 = t162 * t292;
  t297 = 0.2e1 / 0.9e1 * t272 * t273 * t63 - 0.2e1 / 0.9e1 * t36 * t42 * t284 - 0.2e1 / 0.9e1 * t36 * t42 * t293;
  t301 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t297);
  tvsigma0 = t7 * t301;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t302 = t34 * t86;
  t305 = 0.1e1 / t88;
  t312 = t43 * t305 * t90 * t92 / 0.2e1 + t43 * t86 * t238 / 0.2e1;
  t313 = t230 * t312;
  t316 = sigma[2] * sigma[2];
  t317 = 0.1e1 / t316;
  t318 = t100 * t317;
  t321 = -0.2e1 * t318 * t85 + 0.2e1 * t101;
  t322 = t249 * t321;
  t326 = 0.2e1 / 0.9e1 * t272 * t302 * t107 - 0.2e1 / 0.9e1 * t36 * t87 * t313 - 0.2e1 / 0.9e1 * t36 * t87 * t322;
  t330 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t326);
  tvsigma2 = t7 * t330;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t331 = t5 * t26;
  t332 = t27 * params->beta;
  t333 = t331 * t332;
  t336 = t35 * t54 * t52 * t161;
  t339 = my_piecewise3(t2, 0, -t333 * t336 / 0.2e1);
  tvlapl0 = t7 * t339;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t340 = t5 * t80;
  t341 = t340 * t332;
  t344 = t35 * t98 * t96 * t248;
  t347 = my_piecewise3(t72, 0, -t341 * t344 / 0.2e1);
  tvlapl1 = t7 * t347;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t350 = t24 * t24;
  t351 = 0.1e1 / t350;
  t352 = t120 * t120;
  t355 = t116 * t7;
  t356 = 0.1e1 / t355;
  t357 = t17 * t356;
  t360 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t117 + 0.2e1 * t357);
  t364 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t352 + 0.4e1 / 0.3e1 * t24 * t360);
  t365 = t364 * t27;
  t369 = t123 * t129;
  t371 = t6 * t369 * t67;
  t377 = 0.1e1 / t128 / t7;
  t378 = t26 * t377;
  t381 = t6 * t378 * t67 / 0.12e2;
  t383 = t6 * t130 * t177;
  t385 = t37 * t37;
  t387 = 0.1e1 / t39 / t385;
  t388 = sigma[0] * t387;
  t399 = 0.1e1 / t141 / t51;
  t400 = t399 * t62;
  t401 = t155 * t155;
  t402 = t400 * t401;
  t407 = t30 * t35 * sigma[0];
  t408 = t41 * t142;
  t409 = t161 * t155;
  t410 = t409 * t172;
  t411 = t408 * t410;
  t415 = 0.1e1 / t38 / t134;
  t425 = 0.1e1 / t38 / t385 / t134;
  t428 = 0.1e1 / t150 / t149;
  t432 = 0.28e2 / 0.9e1 * t43 * t44 * t415 * t48 + 0.2e2 / 0.3e1 * t43 * t388 * t151 - 0.16e2 / 0.9e1 * t43 * t287 * t425 * t428;
  t433 = t143 * t432;
  t438 = 0.1e1 / t160 / t61;
  t439 = t52 * t438;
  t440 = t172 * t172;
  t441 = t439 * t440;
  t448 = 0.88e2 / 0.9e1 * t388 - 0.4e2 / 0.9e1 * lapl[0] * t136;
  t449 = t448 * t57;
  t456 = 0.2e1 * t449 * t40 + 0.32e2 / 0.3e1 * t167 * t53 + 0.8e2 / 0.9e1 * t58 * t39;
  t457 = t162 * t456;
  t461 = 0.176e3 / 0.81e2 * t36 * t388 * t63 + 0.32e2 / 0.27e2 * t36 * t137 * t156 + 0.32e2 / 0.27e2 * t36 * t137 * t173 + 0.4e1 / 0.9e1 * t36 * t42 * t402 + 0.4e1 / 0.9e1 * t407 * t411 - 0.2e1 / 0.9e1 * t36 * t42 * t433 + 0.4e1 / 0.9e1 * t36 * t42 * t441 - 0.2e1 / 0.9e1 * t36 * t42 * t457;
  t466 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t67 - t371 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t177 + t381 - t383 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t461);
  t467 = t78 * t78;
  t468 = 0.1e1 / t467;
  t469 = t185 * t185;
  t472 = t73 * t356;
  t475 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t117 + 0.2e1 * t472);
  t479 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t469 + 0.4e1 / 0.3e1 * t78 * t475);
  t480 = t479 * t27;
  t484 = t188 * t129;
  t486 = t6 * t484 * t111;
  t488 = t80 * t377;
  t491 = t6 * t488 * t111 / 0.12e2;
  t493 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t111 - t486 / 0.4e1 + t491);
  tv2rho20 = 0.2e1 * t182 + 0.2e1 * t198 + t7 * (t466 + t493);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t496 = t351 * t202;
  t500 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t357);
  t504 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t496 * t120 + 0.4e1 / 0.3e1 * t24 * t500);
  t505 = t504 * t27;
  t509 = t205 * t129;
  t511 = t6 * t509 * t67;
  t519 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t67 - t511 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t177 - t371 / 0.8e1 + t381 - t383 / 0.8e1);
  t520 = t468 * t213;
  t524 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t472);
  t528 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t520 * t185 + 0.4e1 / 0.3e1 * t78 * t524);
  t529 = t528 * t27;
  t533 = t216 * t129;
  t535 = t6 * t533 * t111;
  t542 = t6 * t193 * t264;
  t545 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t111 - t535 / 0.8e1 - t486 / 0.8e1 + t491 - 0.3e1 / 0.8e1 * t6 * t189 * t264 - t542 / 0.8e1);
  tv2rho21 = t182 + t198 + t211 + t269 + t7 * (t519 + t545);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t550 = t202 * t202;
  t555 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t117 + 0.2e1 * t357);
  t559 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t351 * t550 + 0.4e1 / 0.3e1 * t24 * t555);
  t560 = t559 * t27;
  t566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t67 - t511 / 0.4e1 + t381);
  t567 = t213 * t213;
  t572 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t117 + 0.2e1 * t472);
  t576 = my_piecewise3(t77, 0, 0.4e1 / 0.9e1 * t468 * t567 + 0.4e1 / 0.3e1 * t78 * t572);
  t577 = t576 * t27;
  t586 = t82 * t82;
  t588 = 0.1e1 / t84 / t586;
  t589 = sigma[2] * t588;
  t600 = 0.1e1 / t228 / t95;
  t601 = t600 * t106;
  t602 = t242 * t242;
  t603 = t601 * t602;
  t608 = t30 * t35 * sigma[2];
  t609 = t86 * t229;
  t610 = t248 * t242;
  t611 = t610 * t259;
  t612 = t609 * t611;
  t616 = 0.1e1 / t83 / t221;
  t626 = 0.1e1 / t83 / t586 / t221;
  t629 = 0.1e1 / t237 / t236;
  t633 = 0.28e2 / 0.9e1 * t43 * t88 * t616 * t92 + 0.2e2 / 0.3e1 * t43 * t589 * t238 - 0.16e2 / 0.9e1 * t43 * t316 * t626 * t629;
  t634 = t230 * t633;
  t639 = 0.1e1 / t247 / t105;
  t640 = t96 * t639;
  t641 = t259 * t259;
  t642 = t640 * t641;
  t649 = 0.88e2 / 0.9e1 * t589 - 0.4e2 / 0.9e1 * lapl[1] * t223;
  t650 = t649 * t101;
  t657 = 0.2e1 * t650 * t85 + 0.32e2 / 0.3e1 * t254 * t97 + 0.8e2 / 0.9e1 * t102 * t84;
  t658 = t249 * t657;
  t662 = 0.176e3 / 0.81e2 * t36 * t589 * t107 + 0.32e2 / 0.27e2 * t36 * t224 * t243 + 0.32e2 / 0.27e2 * t36 * t224 * t260 + 0.4e1 / 0.9e1 * t36 * t87 * t603 + 0.4e1 / 0.9e1 * t608 * t612 - 0.2e1 / 0.9e1 * t36 * t87 * t634 + 0.4e1 / 0.9e1 * t36 * t87 * t642 - 0.2e1 / 0.9e1 * t36 * t87 * t658;
  t667 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t111 - t535 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t264 + t491 - t542 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t662);
  tv2rho22 = 0.2e1 * t211 + 0.2e1 * t269 + t7 * (t566 + t667);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t675 = t6 * t130 * t297 / 0.8e1;
  t676 = t34 * t136;
  t680 = t62 * t155;
  t684 = t41 * t52;
  t685 = t161 * t172;
  t692 = t41 * t399;
  t693 = t62 * t283;
  t694 = t693 * t155;
  t695 = t692 * t694;
  t698 = t161 * t283;
  t699 = t698 * t172;
  t700 = t408 * t699;
  t710 = t385 * t37;
  t712 = 0.1e1 / t38 / t710;
  t713 = t712 * t428;
  t717 = -0.2e1 / 0.3e1 * t43 * t276 * t145 * t48 - 0.2e1 * t43 * t136 * t151 + 0.2e1 / 0.3e1 * t43 * t713 * sigma[0];
  t718 = t143 * t717;
  t725 = t161 * t292;
  t726 = t725 * t155;
  t727 = t408 * t726;
  t730 = t438 * t292;
  t731 = t730 * t172;
  t732 = t684 * t731;
  t735 = t166 * t288;
  t740 = -0.2e1 * t735 * t40 - 0.16e2 / 0.3e1 * t289 * t53;
  t741 = t162 * t740;
  t745 = -0.16e2 / 0.27e2 * t272 * t676 * t63 - 0.2e1 / 0.9e1 * t36 * t408 * t680 - 0.2e1 / 0.9e1 * t36 * t684 * t685 + 0.16e2 / 0.27e2 * t36 * t137 * t284 + 0.4e1 / 0.9e1 * t407 * t695 + 0.2e1 / 0.9e1 * t407 * t700 - 0.2e1 / 0.9e1 * t36 * t42 * t718 + 0.16e2 / 0.27e2 * t36 * t137 * t293 + 0.2e1 / 0.9e1 * t407 * t727 + 0.4e1 / 0.9e1 * t407 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t741;
  t750 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t297 - t675 - 0.3e1 / 0.8e1 * t6 * t28 * t745);
  tv2rhosigma0 = t7 * t750 + t301;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t757 = t6 * t193 * t326 / 0.8e1;
  t759 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t326 - t757);
  tv2rhosigma2 = t7 * t759 + t330;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t765 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t297 - t675);
  tv2rhosigma3 = t7 * t765 + t301;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t770 = t34 * t223;
  t774 = t106 * t242;
  t778 = t86 * t96;
  t779 = t248 * t259;
  t786 = t86 * t600;
  t787 = t106 * t312;
  t788 = t787 * t242;
  t789 = t786 * t788;
  t792 = t248 * t312;
  t793 = t792 * t259;
  t794 = t609 * t793;
  t804 = t586 * t82;
  t806 = 0.1e1 / t83 / t804;
  t807 = t806 * t629;
  t811 = -0.2e1 / 0.3e1 * t43 * t305 * t232 * t92 - 0.2e1 * t43 * t223 * t238 + 0.2e1 / 0.3e1 * t43 * t807 * sigma[2];
  t812 = t230 * t811;
  t819 = t248 * t321;
  t820 = t819 * t242;
  t821 = t609 * t820;
  t824 = t639 * t321;
  t825 = t824 * t259;
  t826 = t778 * t825;
  t829 = t253 * t317;
  t834 = -0.2e1 * t829 * t85 - 0.16e2 / 0.3e1 * t318 * t97;
  t835 = t249 * t834;
  t839 = -0.16e2 / 0.27e2 * t272 * t770 * t107 - 0.2e1 / 0.9e1 * t36 * t609 * t774 - 0.2e1 / 0.9e1 * t36 * t778 * t779 + 0.16e2 / 0.27e2 * t36 * t224 * t313 + 0.4e1 / 0.9e1 * t608 * t789 + 0.2e1 / 0.9e1 * t608 * t794 - 0.2e1 / 0.9e1 * t36 * t87 * t812 + 0.16e2 / 0.27e2 * t36 * t224 * t322 + 0.2e1 / 0.9e1 * t608 * t821 + 0.4e1 / 0.9e1 * t608 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t835;
  t844 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t326 - t757 - 0.3e1 / 0.8e1 * t6 * t81 * t839);
  tv2rhosigma5 = t7 * t844 + t330;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t846 = t5 * t123;
  t847 = t846 * t332;
  t850 = t129 * params->beta;
  t851 = t331 * t850;
  t853 = t851 * t336 / 0.6e1;
  t855 = t35 * t684 * t161;
  t858 = t332 * t33;
  t859 = t331 * t858;
  t860 = t34 * t54;
  t861 = t142 * t161;
  t862 = t861 * t155;
  t863 = t860 * t862;
  t866 = t439 * t172;
  t867 = t860 * t866;
  t870 = my_piecewise3(t2, 0, -t847 * t336 / 0.2e1 - t853 + 0.5e1 / 0.6e1 * t333 * t855 + t859 * t863 / 0.2e1 + t859 * t867);
  tv2rholapl0 = t7 * t870 + t339;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t872 = t5 * t188;
  t873 = t872 * t332;
  t876 = t340 * t850;
  t878 = t876 * t344 / 0.6e1;
  t880 = my_piecewise3(t72, 0, -t873 * t344 / 0.2e1 - t878);
  tv2rholapl1 = t7 * t880 + t347;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t882 = t5 * t205;
  t883 = t882 * t332;
  t887 = my_piecewise3(t2, 0, -t883 * t336 / 0.2e1 - t853);
  tv2rholapl2 = t7 * t887 + t339;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t889 = t5 * t216;
  t890 = t889 * t332;
  t894 = t35 * t778 * t248;
  t897 = t340 * t858;
  t898 = t34 * t98;
  t899 = t229 * t248;
  t900 = t899 * t242;
  t901 = t898 * t900;
  t904 = t640 * t259;
  t905 = t898 * t904;
  t908 = my_piecewise3(t72, 0, -t890 * t344 / 0.2e1 - t878 + 0.5e1 / 0.6e1 * t341 * t894 + t897 * t901 / 0.2e1 + t897 * t905);
  tv2rholapl3 = t7 * t908 + t347;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t916 = t283 * t283;
  t917 = t400 * t916;
  t921 = t698 * t292;
  t922 = t408 * t921;
  t926 = 0.1e1 / t44 / sigma[0];
  t933 = t385 * rho[0];
  t935 = 0.1e1 / t38 / t933;
  t939 = t43 * t57 * t41 * t151 / 0.4e1 - t43 * t926 * t46 * t48 / 0.4e1 - t43 * t935 * t428 / 0.4e1;
  t940 = t143 * t939;
  t944 = t292 * t292;
  t945 = t439 * t944;
  t949 = t287 * sigma[0];
  t950 = 0.1e1 / t949;
  t951 = t56 * t950;
  t954 = 0.4e1 * t40 * t951 - 0.4e1 * t288;
  t955 = t162 * t954;
  t959 = -0.4e1 / 0.9e1 * t36 * t408 * t693 - 0.4e1 / 0.9e1 * t36 * t684 * t725 + 0.4e1 / 0.9e1 * t36 * t42 * t917 + 0.4e1 / 0.9e1 * t407 * t922 - 0.2e1 / 0.9e1 * t36 * t42 * t940 + 0.4e1 / 0.9e1 * t36 * t42 * t945 - 0.2e1 / 0.9e1 * t36 * t42 * t955;
  t963 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t959);
  tv2sigma20 = t7 * t963;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t970 = t312 * t312;
  t971 = t601 * t970;
  t975 = t792 * t321;
  t976 = t609 * t975;
  t980 = 0.1e1 / t88 / sigma[2];
  t987 = t586 * rho[1];
  t989 = 0.1e1 / t83 / t987;
  t993 = t43 * t101 * t86 * t238 / 0.4e1 - t43 * t980 * t90 * t92 / 0.4e1 - t43 * t989 * t629 / 0.4e1;
  t994 = t230 * t993;
  t998 = t321 * t321;
  t999 = t640 * t998;
  t1003 = t316 * sigma[2];
  t1004 = 0.1e1 / t1003;
  t1005 = t100 * t1004;
  t1008 = 0.4e1 * t1005 * t85 - 0.4e1 * t317;
  t1009 = t249 * t1008;
  t1013 = -0.4e1 / 0.9e1 * t36 * t609 * t787 - 0.4e1 / 0.9e1 * t36 * t778 * t819 + 0.4e1 / 0.9e1 * t36 * t87 * t971 + 0.4e1 / 0.9e1 * t608 * t976 - 0.2e1 / 0.9e1 * t36 * t87 * t994 + 0.4e1 / 0.9e1 * t36 * t87 * t999 - 0.2e1 / 0.9e1 * t36 * t87 * t1009;
  t1017 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t1013);
  tv2sigma25 = t7 * t1017;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1018 = t861 * t283;
  t1019 = t860 * t1018;
  t1022 = t439 * t292;
  t1023 = t860 * t1022;
  t1026 = my_piecewise3(t2, 0, t859 * t1019 / 0.2e1 + t859 * t1023);
  tv2sigmalapl0 = t7 * t1026;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t1027 = t899 * t312;
  t1028 = t898 * t1027;
  t1031 = t640 * t321;
  t1032 = t898 * t1031;
  t1035 = my_piecewise3(t72, 0, t897 * t1028 / 0.2e1 + t897 * t1032);
  tv2sigmalapl5 = t7 * t1035;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t1036 = 0.1e1 / t39;
  t1037 = t34 * t1036;
  t1038 = t439 * t57;
  t1039 = t1037 * t1038;
  t1042 = my_piecewise3(t2, 0, -0.2e1 * t859 * t1039);
  tv2lapl20 = t7 * t1042;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t1043 = 0.1e1 / t84;
  t1044 = t34 * t1043;
  t1045 = t640 * t101;
  t1046 = t1044 * t1045;
  t1049 = my_piecewise3(t72, 0, -0.2e1 * t897 * t1046);
  tv2lapl22 = t7 * t1049;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1053 = 0.1e1 / t350 / t20;
  t1054 = t352 * t120;
  t1057 = t351 * t120;
  t1060 = t116 * t116;
  t1061 = 0.1e1 / t1060;
  t1062 = t17 * t1061;
  t1065 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t356 - 0.6e1 * t1062);
  t1069 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1054 + 0.4e1 / 0.3e1 * t1057 * t360 + 0.4e1 / 0.3e1 * t24 * t1065);
  t1070 = t1069 * t27;
  t1074 = t364 * t129;
  t1076 = t6 * t1074 * t67;
  t1081 = t123 * t377;
  t1083 = t6 * t1081 * t67;
  t1086 = t6 * t369 * t177;
  t1092 = 0.1e1 / t128 / t116;
  t1093 = t26 * t1092;
  t1096 = 0.5e1 / 0.36e2 * t6 * t1093 * t67;
  t1098 = t6 * t378 * t177;
  t1101 = t6 * t130 * t461;
  t1104 = 0.1e1 / t38 / t385;
  t1110 = 0.1e1 / t39 / t933;
  t1111 = sigma[0] * t1110;
  t1115 = t385 * t385;
  t1117 = 0.1e1 / t38 / t1115;
  t1122 = t1115 * t134;
  t1123 = 0.1e1 / t1122;
  t1125 = t149 * t149;
  t1127 = 0.1e1 / t150 / t1125;
  t1131 = -0.28e3 / 0.27e2 * t43 * t44 * t1104 * t48 - 0.952e3 / 0.27e2 * t43 * t1111 * t151 + 0.592e3 / 0.27e2 * t43 * t287 * t1117 * t428 - 0.64e2 / 0.9e1 * t43 * t949 * t1123 * t1127;
  t1132 = t143 * t1131;
  t1139 = -0.1232e4 / 0.27e2 * t1111 + 0.44e3 / 0.27e2 * lapl[0] * t387;
  t1140 = t1139 * t57;
  t1147 = 0.1e1 / t38;
  t1150 = 0.2e1 * t1140 * t40 + 0.16e2 * t449 * t53 + 0.8e2 / 0.3e1 * t167 * t39 + 0.16e3 / 0.27e2 * t58 * t1147;
  t1151 = t162 * t1150;
  t1155 = t438 * t155;
  t1156 = t1155 * t440;
  t1157 = t408 * t1156;
  t1160 = t160 * t160;
  t1161 = 0.1e1 / t1160;
  t1162 = t52 * t1161;
  t1163 = t440 * t172;
  t1164 = t1162 * t1163;
  t1169 = t438 * t172 * t456;
  t1170 = t684 * t1169;
  t1176 = t141 * t141;
  t1177 = 0.1e1 / t1176;
  t1178 = t1177 * t62;
  t1179 = t401 * t155;
  t1180 = t1178 * t1179;
  t1184 = t161 * t401;
  t1185 = t1184 * t172;
  t1186 = t692 * t1185;
  t1189 = t680 * t432;
  t1190 = t692 * t1189;
  t1193 = t161 * t432;
  t1194 = t1193 * t172;
  t1195 = t408 * t1194;
  t1198 = t409 * t456;
  t1199 = t408 * t1198;
  t1205 = t136 * t142;
  t1206 = t1205 * t410;
  t1224 = -0.2e1 / 0.9e1 * t36 * t42 * t1132 - 0.2e1 / 0.9e1 * t36 * t42 * t1151 - 0.4e1 / 0.3e1 * t407 * t1157 - 0.4e1 / 0.3e1 * t36 * t42 * t1164 + 0.4e1 / 0.3e1 * t407 * t1170 - 0.32e2 / 0.9e1 * t36 * t137 * t441 - 0.4e1 / 0.3e1 * t36 * t42 * t1180 - 0.4e1 / 0.3e1 * t407 * t1186 + 0.4e1 / 0.3e1 * t407 * t1190 + 0.2e1 / 0.3e1 * t407 * t1195 + 0.2e1 / 0.3e1 * t407 * t1199 - 0.32e2 / 0.9e1 * t36 * t137 * t402 - 0.32e2 / 0.9e1 * t407 * t1206 + 0.16e2 / 0.9e1 * t36 * t137 * t457 - 0.2464e4 / 0.243e3 * t36 * t1111 * t63 - 0.176e3 / 0.27e2 * t36 * t388 * t156 - 0.176e3 / 0.27e2 * t36 * t388 * t173 + 0.16e2 / 0.9e1 * t36 * t137 * t433;
  t1229 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1070 * t67 - 0.3e1 / 0.8e1 * t1076 - 0.9e1 / 0.8e1 * t6 * t365 * t177 + t1083 / 0.4e1 - 0.3e1 / 0.4e1 * t1086 - 0.9e1 / 0.8e1 * t6 * t124 * t461 - t1096 + t1098 / 0.4e1 - 0.3e1 / 0.8e1 * t1101 - 0.3e1 / 0.8e1 * t6 * t28 * t1224);
  t1231 = 0.1e1 / t467 / t76;
  t1232 = t469 * t185;
  t1235 = t468 * t185;
  t1238 = t73 * t1061;
  t1241 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t356 - 0.6e1 * t1238);
  t1245 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1232 + 0.4e1 / 0.3e1 * t1235 * t475 + 0.4e1 / 0.3e1 * t78 * t1241);
  t1246 = t1245 * t27;
  t1250 = t479 * t129;
  t1252 = t6 * t1250 * t111;
  t1254 = t188 * t377;
  t1256 = t6 * t1254 * t111;
  t1258 = t80 * t1092;
  t1261 = 0.5e1 / 0.36e2 * t6 * t1258 * t111;
  t1263 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1246 * t111 - 0.3e1 / 0.8e1 * t1252 + t1256 / 0.4e1 - t1261);
  tv3rho30 = 0.3e1 * t466 + 0.3e1 * t493 + t7 * (t1229 + t1263);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1266 = 0.2e1 * t519;
  t1267 = 0.2e1 * t545;
  t1268 = t1053 * t202;
  t1271 = t351 * t500;
  t1276 = 0.2e1 * t356;
  t1277 = 0.6e1 * t1062;
  t1279 = my_piecewise5(t11, 0, t15, 0, t1276 - t1277);
  t1283 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1268 * t352 + 0.8e1 / 0.9e1 * t1271 * t120 + 0.4e1 / 0.9e1 * t496 * t360 + 0.4e1 / 0.3e1 * t24 * t1279);
  t1284 = t1283 * t27;
  t1288 = t504 * t129;
  t1291 = t6 * t1288 * t67 / 0.4e1;
  t1295 = t205 * t377;
  t1297 = t6 * t1295 * t67;
  t1301 = t6 * t509 * t177 / 0.4e1;
  t1310 = -0.3e1 / 0.8e1 * t6 * t1284 * t67 - t1291 - 0.3e1 / 0.4e1 * t6 * t505 * t177 + t1297 / 0.12e2 - t1301 - 0.3e1 / 0.8e1 * t6 * t206 * t461 - t1076 / 0.8e1 + t1083 / 0.6e1 - t1086 / 0.4e1 - t1096 + t1098 / 0.6e1 - t1101 / 0.8e1;
  t1311 = my_piecewise3(t2, 0, t1310);
  t1312 = t1231 * t213;
  t1315 = t468 * t524;
  t1320 = 0.6e1 * t1238;
  t1322 = my_piecewise5(t15, 0, t11, 0, -t1276 - t1320);
  t1326 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1312 * t469 + 0.8e1 / 0.9e1 * t1315 * t185 + 0.4e1 / 0.9e1 * t520 * t475 + 0.4e1 / 0.3e1 * t78 * t1322);
  t1327 = t1326 * t27;
  t1331 = t528 * t129;
  t1334 = t6 * t1331 * t111 / 0.4e1;
  t1335 = t216 * t377;
  t1337 = t6 * t1335 * t111;
  t1346 = t6 * t484 * t264 / 0.4e1;
  t1348 = t6 * t488 * t264;
  t1351 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1327 * t111 - t1334 + t1337 / 0.12e2 - t1252 / 0.8e1 + t1256 / 0.6e1 - t1261 - 0.3e1 / 0.8e1 * t6 * t480 * t264 - t1346 + t1348 / 0.12e2);
  tv3rho31 = t466 + t493 + t1266 + t1267 + t7 * (t1311 + t1351);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1354 = t1053 * t550;
  t1359 = t351 * t555;
  t1363 = my_piecewise5(t11, 0, t15, 0, -t1276 - t1277);
  t1367 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1354 * t120 + 0.8e1 / 0.9e1 * t496 * t500 + 0.4e1 / 0.9e1 * t1359 * t120 + 0.4e1 / 0.3e1 * t24 * t1363);
  t1368 = t1367 * t27;
  t1372 = t559 * t129;
  t1374 = t6 * t1372 * t67;
  t1383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1368 * t67 - t1374 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t560 * t177 - t1291 + t1297 / 0.6e1 - t1301 + t1083 / 0.12e2 - t1096 + t1098 / 0.12e2);
  t1384 = t1231 * t567;
  t1389 = t468 * t572;
  t1393 = my_piecewise5(t15, 0, t11, 0, t1276 - t1320);
  t1397 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1384 * t185 + 0.8e1 / 0.9e1 * t520 * t524 + 0.4e1 / 0.9e1 * t1389 * t185 + 0.4e1 / 0.3e1 * t78 * t1393);
  t1398 = t1397 * t27;
  t1402 = t576 * t129;
  t1404 = t6 * t1402 * t111;
  t1411 = t6 * t533 * t264;
  t1419 = t6 * t193 * t662;
  t1421 = -0.3e1 / 0.8e1 * t6 * t1398 * t111 - t1404 / 0.8e1 - t1334 + t1337 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t529 * t264 - t1411 / 0.4e1 + t1256 / 0.12e2 - t1261 - t1346 + t1348 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t189 * t662 - t1419 / 0.8e1;
  t1422 = my_piecewise3(t72, 0, t1421);
  tv3rho32 = t1266 + t1267 + t566 + t667 + t7 * (t1383 + t1422);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1427 = t550 * t202;
  t1434 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t356 - 0.6e1 * t1062);
  t1438 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1053 * t1427 + 0.4e1 / 0.3e1 * t496 * t555 + 0.4e1 / 0.3e1 * t24 * t1434);
  t1439 = t1438 * t27;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1439 * t67 - 0.3e1 / 0.8e1 * t1374 + t1297 / 0.4e1 - t1096);
  t1447 = t567 * t213;
  t1454 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t356 - 0.6e1 * t1238);
  t1458 = my_piecewise3(t77, 0, -0.8e1 / 0.27e2 * t1231 * t1447 + 0.4e1 / 0.3e1 * t520 * t572 + 0.4e1 / 0.3e1 * t78 * t1454);
  t1459 = t1458 * t27;
  t1475 = 0.1e1 / t84 / t987;
  t1476 = sigma[2] * t1475;
  t1480 = -0.1232e4 / 0.27e2 * t1476 + 0.44e3 / 0.27e2 * lapl[1] * t588;
  t1481 = t1480 * t101;
  t1488 = 0.1e1 / t83;
  t1491 = 0.2e1 * t1481 * t85 + 0.16e2 * t650 * t97 + 0.8e2 / 0.3e1 * t254 * t84 + 0.16e3 / 0.27e2 * t102 * t1488;
  t1492 = t249 * t1491;
  t1512 = 0.1e1 / t83 / t586;
  t1520 = t586 * t586;
  t1522 = 0.1e1 / t83 / t1520;
  t1527 = t1520 * t221;
  t1528 = 0.1e1 / t1527;
  t1530 = t236 * t236;
  t1532 = 0.1e1 / t237 / t1530;
  t1536 = -0.28e3 / 0.27e2 * t43 * t88 * t1512 * t92 - 0.952e3 / 0.27e2 * t43 * t1476 * t238 + 0.592e3 / 0.27e2 * t43 * t316 * t1522 * t629 - 0.64e2 / 0.9e1 * t43 * t1003 * t1528 * t1532;
  t1537 = t230 * t1536;
  t1541 = t639 * t242;
  t1542 = t1541 * t641;
  t1543 = t609 * t1542;
  t1546 = t247 * t247;
  t1547 = 0.1e1 / t1546;
  t1548 = t96 * t1547;
  t1549 = t641 * t259;
  t1550 = t1548 * t1549;
  t1555 = t639 * t259 * t657;
  t1556 = t778 * t1555;
  t1562 = t228 * t228;
  t1563 = 0.1e1 / t1562;
  t1564 = t1563 * t106;
  t1565 = t602 * t242;
  t1566 = t1564 * t1565;
  t1570 = t248 * t602;
  t1571 = t1570 * t259;
  t1572 = t786 * t1571;
  t1575 = t774 * t633;
  t1576 = t786 * t1575;
  t1579 = t248 * t633;
  t1580 = t1579 * t259;
  t1581 = t609 * t1580;
  t1584 = t610 * t657;
  t1585 = t609 * t1584;
  t1591 = t223 * t229;
  t1592 = t1591 * t611;
  t1595 = -0.2e1 / 0.9e1 * t36 * t87 * t1492 - 0.2464e4 / 0.243e3 * t36 * t1476 * t107 - 0.176e3 / 0.27e2 * t36 * t589 * t243 - 0.176e3 / 0.27e2 * t36 * t589 * t260 + 0.16e2 / 0.9e1 * t36 * t224 * t634 + 0.16e2 / 0.9e1 * t36 * t224 * t658 - 0.2e1 / 0.9e1 * t36 * t87 * t1537 - 0.4e1 / 0.3e1 * t608 * t1543 - 0.4e1 / 0.3e1 * t36 * t87 * t1550 + 0.4e1 / 0.3e1 * t608 * t1556 - 0.32e2 / 0.9e1 * t36 * t224 * t642 - 0.4e1 / 0.3e1 * t36 * t87 * t1566 - 0.4e1 / 0.3e1 * t608 * t1572 + 0.4e1 / 0.3e1 * t608 * t1576 + 0.2e1 / 0.3e1 * t608 * t1581 + 0.2e1 / 0.3e1 * t608 * t1585 - 0.32e2 / 0.9e1 * t36 * t224 * t603 - 0.32e2 / 0.9e1 * t608 * t1592;
  t1600 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1459 * t111 - 0.3e1 / 0.8e1 * t1404 - 0.9e1 / 0.8e1 * t6 * t577 * t264 + t1337 / 0.4e1 - 0.3e1 / 0.4e1 * t1411 - 0.9e1 / 0.8e1 * t6 * t217 * t662 - t1261 + t1348 / 0.4e1 - 0.3e1 / 0.8e1 * t1419 - 0.3e1 / 0.8e1 * t6 * t81 * t1595);
  tv3rho33 = 0.3e1 * t566 + 0.3e1 * t667 + t7 * (t1446 + t1600);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1608 = t6 * t369 * t297;
  t1615 = t6 * t378 * t297 / 0.12e2;
  t1617 = t6 * t130 * t745;
  t1619 = t438 * t440;
  t1623 = t62 * t401;
  t1630 = t136 * t52;
  t1634 = t62 * t432;
  t1638 = t161 * t456;
  t1646 = t408 * t438;
  t1647 = t292 * t155;
  t1648 = t1647 * t172;
  t1652 = t692 * t161;
  t1653 = t283 * t155;
  t1654 = t1653 * t172;
  t1658 = t41 * t1177;
  t1659 = t693 * t401;
  t1660 = t1658 * t1659;
  t1663 = t438 * t283;
  t1664 = t1663 * t440;
  t1665 = t408 * t1664;
  t1668 = t161 * t740;
  t1669 = t1668 * t155;
  t1670 = t408 * t1669;
  t1673 = t725 * t432;
  t1674 = t408 * t1673;
  t1677 = t438 * t740;
  t1678 = t1677 * t172;
  t1679 = t684 * t1678;
  t1682 = t730 * t456;
  t1683 = t684 * t1682;
  t1686 = t62 * t717;
  t1687 = t1686 * t155;
  t1688 = t692 * t1687;
  t1691 = 0.4e1 / 0.9e1 * t36 * t684 * t1619 + 0.4e1 / 0.9e1 * t36 * t692 * t1623 + 0.32e2 / 0.27e2 * t36 * t1205 * t680 + 0.32e2 / 0.27e2 * t36 * t1630 * t685 - 0.2e1 / 0.9e1 * t36 * t408 * t1634 - 0.2e1 / 0.9e1 * t36 * t684 * t1638 + 0.176e3 / 0.81e2 * t272 * t34 * t387 * t63 - 0.8e1 / 0.9e1 * t407 * t1646 * t1648 - 0.8e1 / 0.9e1 * t407 * t1652 * t1654 - 0.4e1 / 0.3e1 * t407 * t1660 - 0.4e1 / 0.9e1 * t407 * t1665 + 0.4e1 / 0.9e1 * t407 * t1670 + 0.2e1 / 0.9e1 * t407 * t1674 + 0.8e1 / 0.9e1 * t407 * t1679 + 0.4e1 / 0.9e1 * t407 * t1683 + 0.8e1 / 0.9e1 * t407 * t1688;
  t1692 = t693 * t432;
  t1693 = t692 * t1692;
  t1696 = t161 * t717;
  t1697 = t1696 * t172;
  t1698 = t408 * t1697;
  t1701 = t698 * t456;
  t1702 = t408 * t1701;
  t1705 = t1205 * t726;
  t1708 = t1630 * t731;
  t1711 = t136 * t399;
  t1712 = t1711 * t694;
  t1715 = t1205 * t699;
  t1718 = t725 * t401;
  t1719 = t692 * t1718;
  t1722 = t1161 * t292;
  t1723 = t1722 * t440;
  t1724 = t684 * t1723;
  t1737 = t425 * t428;
  t1741 = t1115 * t37;
  t1743 = 0.1e1 / t1741 * t1127;
  t1747 = 0.14e2 / 0.9e1 * t43 * t276 * t415 * t48 + 0.74e2 / 0.9e1 * t43 * t387 * t151 - 0.62e2 / 0.9e1 * t43 * t1737 * sigma[0] + 0.8e1 / 0.3e1 * t43 * t1743 * t287;
  t1748 = t143 * t1747;
  t1755 = t448 * t288;
  t1762 = -0.2e1 * t1755 * t40 - 0.32e2 / 0.3e1 * t735 * t53 - 0.8e2 / 0.9e1 * t289 * t39;
  t1763 = t162 * t1762;
  t1775 = 0.4e1 / 0.9e1 * t407 * t1693 + 0.4e1 / 0.9e1 * t407 * t1698 + 0.2e1 / 0.9e1 * t407 * t1702 - 0.32e2 / 0.27e2 * t407 * t1705 - 0.64e2 / 0.27e2 * t407 * t1708 - 0.64e2 / 0.27e2 * t407 * t1712 - 0.32e2 / 0.27e2 * t407 * t1715 - 0.4e1 / 0.9e1 * t407 * t1719 - 0.4e1 / 0.3e1 * t407 * t1724 + 0.32e2 / 0.27e2 * t36 * t137 * t718 - 0.2e1 / 0.9e1 * t36 * t42 * t1748 + 0.32e2 / 0.27e2 * t36 * t137 * t741 - 0.2e1 / 0.9e1 * t36 * t42 * t1763 + 0.4e1 / 0.9e1 * t36 * t411 - 0.176e3 / 0.81e2 * t36 * t388 * t293 - 0.176e3 / 0.81e2 * t36 * t388 * t284;
  t1776 = t1691 + t1775;
  t1781 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t297 - t1608 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t745 + t1615 - t1617 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t1776);
  tv3rho2sigma0 = t1781 * t7 + 0.2e1 * t750;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1788 = t6 * t484 * t326;
  t1792 = t6 * t488 * t326 / 0.12e2;
  t1794 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t326 - t1788 / 0.4e1 + t1792);
  tv3rho2sigma2 = t1794 * t7 + 0.2e1 * t759;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1800 = t6 * t509 * t297;
  t1808 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t297 - t1800 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t745 - t1608 / 0.8e1 + t1615 - t1617 / 0.8e1);
  tv3rho2sigma3 = t1808 * t7 + t750 + t765;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1814 = t6 * t533 * t326;
  t1821 = t6 * t193 * t839;
  t1824 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t326 - t1814 / 0.8e1 - t1788 / 0.8e1 + t1792 - 0.3e1 / 0.8e1 * t6 * t189 * t839 - t1821 / 0.8e1);
  tv3rho2sigma5 = t1824 * t7 + t759 + t844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1832 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t297 - t1800 / 0.4e1 + t1615);
  tv3rho2sigma6 = t1832 * t7 + 0.2e1 * t765;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1843 = t106 * t633;
  t1847 = t248 * t657;
  t1851 = t639 * t641;
  t1855 = t106 * t602;
  t1862 = t223 * t96;
  t1870 = t609 * t639;
  t1871 = t321 * t242;
  t1872 = t1871 * t259;
  t1876 = t786 * t248;
  t1877 = t312 * t242;
  t1878 = t1877 * t259;
  t1892 = t626 * t629;
  t1896 = t1520 * t82;
  t1898 = 0.1e1 / t1896 * t1532;
  t1902 = 0.14e2 / 0.9e1 * t43 * t305 * t616 * t92 + 0.74e2 / 0.9e1 * t43 * t588 * t238 - 0.62e2 / 0.9e1 * t43 * t1892 * sigma[2] + 0.8e1 / 0.3e1 * t43 * t1898 * t316;
  t1903 = t230 * t1902;
  t1910 = t649 * t317;
  t1917 = -0.2e1 * t1910 * t85 - 0.32e2 / 0.3e1 * t829 * t97 - 0.8e2 / 0.9e1 * t318 * t84;
  t1918 = t249 * t1917;
  t1930 = -0.2e1 / 0.9e1 * t36 * t609 * t1843 - 0.2e1 / 0.9e1 * t36 * t778 * t1847 + 0.4e1 / 0.9e1 * t36 * t778 * t1851 + 0.4e1 / 0.9e1 * t36 * t786 * t1855 + 0.32e2 / 0.27e2 * t36 * t1591 * t774 + 0.32e2 / 0.27e2 * t36 * t1862 * t779 + 0.176e3 / 0.81e2 * t272 * t34 * t588 * t107 - 0.8e1 / 0.9e1 * t608 * t1870 * t1872 - 0.8e1 / 0.9e1 * t608 * t1876 * t1878 + 0.32e2 / 0.27e2 * t36 * t224 * t812 - 0.2e1 / 0.9e1 * t36 * t87 * t1903 + 0.32e2 / 0.27e2 * t36 * t224 * t835 - 0.2e1 / 0.9e1 * t36 * t87 * t1918 + 0.4e1 / 0.9e1 * t36 * t612 - 0.176e3 / 0.81e2 * t36 * t589 * t322 - 0.176e3 / 0.81e2 * t36 * t589 * t313;
  t1931 = t639 * t834;
  t1932 = t1931 * t259;
  t1933 = t778 * t1932;
  t1936 = t824 * t657;
  t1937 = t778 * t1936;
  t1940 = t223 * t600;
  t1941 = t1940 * t788;
  t1944 = t1591 * t793;
  t1947 = t106 * t811;
  t1948 = t1947 * t242;
  t1949 = t786 * t1948;
  t1952 = t787 * t633;
  t1953 = t786 * t1952;
  t1956 = t639 * t312;
  t1957 = t1956 * t641;
  t1958 = t609 * t1957;
  t1961 = t819 * t602;
  t1962 = t786 * t1961;
  t1965 = t1547 * t321;
  t1966 = t1965 * t641;
  t1967 = t778 * t1966;
  t1970 = t86 * t1563;
  t1971 = t787 * t602;
  t1972 = t1970 * t1971;
  t1975 = t248 * t811;
  t1976 = t1975 * t259;
  t1977 = t609 * t1976;
  t1980 = t792 * t657;
  t1981 = t609 * t1980;
  t1984 = t1591 * t820;
  t1987 = t1862 * t825;
  t1990 = t248 * t834;
  t1991 = t1990 * t242;
  t1992 = t609 * t1991;
  t1995 = t819 * t633;
  t1996 = t609 * t1995;
  t1999 = 0.8e1 / 0.9e1 * t608 * t1933 + 0.4e1 / 0.9e1 * t608 * t1937 - 0.64e2 / 0.27e2 * t608 * t1941 - 0.32e2 / 0.27e2 * t608 * t1944 + 0.8e1 / 0.9e1 * t608 * t1949 + 0.4e1 / 0.9e1 * t608 * t1953 - 0.4e1 / 0.9e1 * t608 * t1958 - 0.4e1 / 0.9e1 * t608 * t1962 - 0.4e1 / 0.3e1 * t608 * t1967 - 0.4e1 / 0.3e1 * t608 * t1972 + 0.4e1 / 0.9e1 * t608 * t1977 + 0.2e1 / 0.9e1 * t608 * t1981 - 0.32e2 / 0.27e2 * t608 * t1984 - 0.64e2 / 0.27e2 * t608 * t1987 + 0.4e1 / 0.9e1 * t608 * t1992 + 0.2e1 / 0.9e1 * t608 * t1996;
  t2000 = t1930 + t1999;
  t2005 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t326 - t1814 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t839 + t1792 - t1821 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t2000);
  tv3rho2sigma8 = t2005 * t7 + 0.2e1 * t844;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t2008 = t5 * t364;
  t2009 = t2008 * t332;
  t2012 = t399 * t161;
  t2013 = t2012 * t401;
  t2014 = t860 * t2013;
  t2016 = t860 * t142;
  t2017 = t1155 * t172;
  t2018 = t2016 * t2017;
  t2021 = t1162 * t440;
  t2022 = t860 * t2021;
  t2025 = t846 * t850;
  t2026 = t2025 * t336;
  t2030 = t846 * t858;
  t2034 = t377 * params->beta;
  t2035 = t331 * t2034;
  t2037 = t2035 * t336 / 0.9e1;
  t2038 = t851 * t855;
  t2040 = t850 * t33;
  t2041 = t331 * t2040;
  t2042 = t2041 * t863;
  t2044 = t2041 * t867;
  t2047 = t35 * t1630 * t161;
  t2050 = t273 * t862;
  t2053 = t273 * t866;
  t2056 = t861 * t432;
  t2057 = t860 * t2056;
  t2060 = t439 * t456;
  t2061 = t860 * t2060;
  t2063 = -t2009 * t336 / 0.2e1 - t859 * t2014 - 0.2e1 * t859 * t2018 - 0.3e1 * t859 * t2022 - t2026 / 0.3e1 + 0.5e1 / 0.3e1 * t847 * t855 + t2030 * t863 + 0.2e1 * t2030 * t867 + t2037 + 0.5e1 / 0.9e1 * t2038 + t2042 / 0.3e1 + 0.2e1 / 0.3e1 * t2044 - 0.2e2 / 0.9e1 * t333 * t2047 - 0.5e1 / 0.3e1 * t859 * t2050 - 0.1e2 / 0.3e1 * t859 * t2053 + t859 * t2057 / 0.2e1 + t859 * t2061;
  t2064 = my_piecewise3(t2, 0, t2063);
  tv3rho2lapl0 = t2064 * t7 + 0.2e1 * t870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t2067 = t5 * t479;
  t2068 = t2067 * t332;
  t2071 = t872 * t850;
  t2072 = t2071 * t344;
  t2074 = t340 * t2034;
  t2076 = t2074 * t344 / 0.9e1;
  t2078 = my_piecewise3(t72, 0, -t2068 * t344 / 0.2e1 - t2072 / 0.3e1 + t2076);
  tv3rho2lapl1 = t2078 * t7 + 0.2e1 * t880;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2080 = t5 * t504;
  t2081 = t2080 * t332;
  t2084 = t882 * t850;
  t2085 = t2084 * t336;
  t2089 = t882 * t858;
  t2098 = my_piecewise3(t2, 0, -t2081 * t336 / 0.2e1 - t2085 / 0.6e1 + 0.5e1 / 0.6e1 * t883 * t855 + t2089 * t863 / 0.2e1 + t2089 * t867 - t2026 / 0.6e1 + t2037 + 0.5e1 / 0.18e2 * t2038 + t2042 / 0.6e1 + t2044 / 0.3e1);
  tv3rho2lapl2 = t2098 * t7 + t870 + t887;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2100 = t5 * t528;
  t2101 = t2100 * t332;
  t2104 = t889 * t850;
  t2105 = t2104 * t344;
  t2110 = t876 * t894;
  t2112 = t872 * t858;
  t2115 = t340 * t2040;
  t2116 = t2115 * t901;
  t2119 = t2115 * t905;
  t2122 = my_piecewise3(t72, 0, -t2101 * t344 / 0.2e1 - t2105 / 0.6e1 - t2072 / 0.6e1 + t2076 + 0.5e1 / 0.6e1 * t873 * t894 + 0.5e1 / 0.18e2 * t2110 + t2112 * t901 / 0.2e1 + t2116 / 0.6e1 + t2112 * t905 + t2119 / 0.3e1);
  tv3rho2lapl3 = t2122 * t7 + t880 + t908;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2125 = t5 * t559;
  t2126 = t2125 * t332;
  t2131 = my_piecewise3(t2, 0, -t2126 * t336 / 0.2e1 - t2085 / 0.3e1 + t2037);
  tv3rho2lapl4 = t2131 * t7 + 0.2e1 * t887;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2135 = t35 * t1862 * t248;
  t2138 = t302 * t900;
  t2141 = t302 * t904;
  t2144 = t899 * t633;
  t2145 = t898 * t2144;
  t2148 = t640 * t657;
  t2149 = t898 * t2148;
  t2153 = t889 * t858;
  t2159 = t5 * t576;
  t2160 = t2159 * t332;
  t2163 = t600 * t248;
  t2164 = t2163 * t602;
  t2165 = t898 * t2164;
  t2167 = t898 * t229;
  t2168 = t1541 * t259;
  t2169 = t2167 * t2168;
  t2172 = t1548 * t641;
  t2173 = t898 * t2172;
  t2178 = -0.2e2 / 0.9e1 * t341 * t2135 - 0.5e1 / 0.3e1 * t897 * t2138 - 0.1e2 / 0.3e1 * t897 * t2141 + t897 * t2145 / 0.2e1 + t897 * t2149 + 0.5e1 / 0.3e1 * t890 * t894 + t2153 * t901 + 0.2e1 * t2153 * t905 + 0.5e1 / 0.9e1 * t2110 - t2105 / 0.3e1 - t2160 * t344 / 0.2e1 - t897 * t2165 - 0.2e1 * t897 * t2169 - 0.3e1 * t897 * t2173 + t2116 / 0.3e1 + 0.2e1 / 0.3e1 * t2119 + t2076;
  t2179 = my_piecewise3(t72, 0, t2178);
  tv3rho2lapl5 = t2179 * t7 + 0.2e1 * t908;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2186 = t6 * t130 * t959 / 0.8e1;
  t2199 = t283 * t292;
  t2200 = t2199 * t155;
  t2204 = t2199 * t172;
  t2220 = t166 * t950;
  t2225 = 0.4e1 * t2220 * t40 + 0.32e2 / 0.3e1 * t951 * t53;
  t2226 = t162 * t2225;
  t2236 = -0.4e1 / 0.9e1 * t36 * t408 * t1686 - 0.4e1 / 0.9e1 * t36 * t684 * t1668 + 0.32e2 / 0.27e2 * t36 * t1205 * t693 + 0.32e2 / 0.27e2 * t36 * t1630 * t725 - 0.8e1 / 0.9e1 * t407 * t1652 * t2200 - 0.8e1 / 0.9e1 * t407 * t1646 * t2204 + 0.16e2 / 0.27e2 * t36 * t137 * t940 - 0.32e2 / 0.27e2 * t36 * t137 * t945 + 0.16e2 / 0.27e2 * t36 * t137 * t955 - 0.32e2 / 0.27e2 * t36 * t137 * t917 - 0.2e1 / 0.9e1 * t36 * t42 * t2226 + 0.8e1 / 0.9e1 * t36 * t695 + 0.4e1 / 0.9e1 * t36 * t700 + 0.4e1 / 0.9e1 * t36 * t727;
  t2249 = t1115 * rho[0];
  t2251 = 0.1e1 / t2249 * t1127;
  t2254 = t43 * t926 * t145 * t48 / 0.3e1 - t43 * t57 * t136 * t151 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t713 - t43 * t2251 * sigma[0];
  t2255 = t143 * t2254;
  t2259 = t1205 * t921;
  t2262 = t62 * t939;
  t2263 = t2262 * t155;
  t2264 = t692 * t2263;
  t2267 = t161 * t939;
  t2268 = t2267 * t172;
  t2269 = t408 * t2268;
  t2272 = t438 * t944;
  t2273 = t2272 * t155;
  t2274 = t408 * t2273;
  t2277 = t1161 * t944;
  t2278 = t2277 * t172;
  t2279 = t684 * t2278;
  t2282 = t730 * t740;
  t2283 = t684 * t2282;
  t2286 = t161 * t954;
  t2287 = t2286 * t155;
  t2288 = t408 * t2287;
  t2291 = t438 * t954;
  t2292 = t2291 * t172;
  t2293 = t684 * t2292;
  t2296 = t62 * t916;
  t2297 = t2296 * t155;
  t2298 = t1658 * t2297;
  t2301 = t161 * t916;
  t2302 = t2301 * t172;
  t2303 = t692 * t2302;
  t2306 = t693 * t717;
  t2307 = t692 * t2306;
  t2310 = t1696 * t292;
  t2311 = t408 * t2310;
  t2314 = t698 * t740;
  t2315 = t408 * t2314;
  t2318 = 0.8e1 / 0.9e1 * t36 * t732 - 0.2e1 / 0.9e1 * t36 * t42 * t2255 - 0.32e2 / 0.27e2 * t407 * t2259 + 0.4e1 / 0.9e1 * t407 * t2264 + 0.2e1 / 0.9e1 * t407 * t2269 - 0.4e1 / 0.9e1 * t407 * t2274 - 0.4e1 / 0.3e1 * t407 * t2279 + 0.8e1 / 0.9e1 * t407 * t2283 + 0.2e1 / 0.9e1 * t407 * t2288 + 0.4e1 / 0.9e1 * t407 * t2293 - 0.4e1 / 0.3e1 * t407 * t2298 - 0.4e1 / 0.9e1 * t407 * t2303 + 0.8e1 / 0.9e1 * t407 * t2307 + 0.4e1 / 0.9e1 * t407 * t2311 + 0.4e1 / 0.9e1 * t407 * t2315;
  t2319 = t2236 + t2318;
  t2324 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t959 - t2186 - 0.3e1 / 0.8e1 * t6 * t28 * t2319);
  tv3rhosigma20 = t2324 * t7 + t963;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2331 = t6 * t193 * t1013 / 0.8e1;
  t2333 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t1013 - t2331);
  tv3rhosigma25 = t2333 * t7 + t1017;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2339 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t959 - t2186);
  tv3rhosigma26 = t2339 * t7 + t963;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2356 = t312 * t321;
  t2357 = t2356 * t242;
  t2361 = t2356 * t259;
  t2391 = t1520 * rho[1];
  t2393 = 0.1e1 / t2391 * t1532;
  t2396 = t43 * t980 * t232 * t92 / 0.3e1 - t43 * t101 * t223 * t238 / 0.3e1 + 0.5e1 / 0.3e1 * t43 * t807 - t43 * t2393 * sigma[2];
  t2397 = t230 * t2396;
  t2401 = t253 * t1004;
  t2406 = 0.4e1 * t2401 * t85 + 0.32e2 / 0.3e1 * t1005 * t97;
  t2407 = t249 * t2406;
  t2411 = -0.4e1 / 0.9e1 * t36 * t609 * t1947 - 0.4e1 / 0.9e1 * t36 * t778 * t1990 + 0.32e2 / 0.27e2 * t36 * t1862 * t819 + 0.32e2 / 0.27e2 * t36 * t1591 * t787 - 0.8e1 / 0.9e1 * t608 * t1876 * t2357 - 0.8e1 / 0.9e1 * t608 * t1870 * t2361 + 0.16e2 / 0.27e2 * t36 * t224 * t994 - 0.32e2 / 0.27e2 * t36 * t224 * t999 + 0.16e2 / 0.27e2 * t36 * t224 * t1009 - 0.32e2 / 0.27e2 * t36 * t224 * t971 + 0.4e1 / 0.9e1 * t36 * t821 + 0.8e1 / 0.9e1 * t36 * t826 - 0.2e1 / 0.9e1 * t36 * t87 * t2397 - 0.2e1 / 0.9e1 * t36 * t87 * t2407;
  t2416 = t824 * t834;
  t2417 = t778 * t2416;
  t2420 = t248 * t1008;
  t2421 = t2420 * t242;
  t2422 = t609 * t2421;
  t2425 = t106 * t970;
  t2426 = t2425 * t242;
  t2427 = t1970 * t2426;
  t2430 = t248 * t970;
  t2431 = t2430 * t259;
  t2432 = t786 * t2431;
  t2435 = t1591 * t975;
  t2438 = t639 * t1008;
  t2439 = t2438 * t259;
  t2440 = t778 * t2439;
  t2443 = t787 * t811;
  t2444 = t786 * t2443;
  t2447 = t1975 * t321;
  t2448 = t609 * t2447;
  t2451 = t792 * t834;
  t2452 = t609 * t2451;
  t2455 = t106 * t993;
  t2456 = t2455 * t242;
  t2457 = t786 * t2456;
  t2460 = t248 * t993;
  t2461 = t2460 * t259;
  t2462 = t609 * t2461;
  t2465 = t639 * t998;
  t2466 = t2465 * t242;
  t2467 = t609 * t2466;
  t2470 = t1547 * t998;
  t2471 = t2470 * t259;
  t2472 = t778 * t2471;
  t2475 = 0.8e1 / 0.9e1 * t36 * t789 + 0.4e1 / 0.9e1 * t36 * t794 + 0.8e1 / 0.9e1 * t608 * t2417 + 0.2e1 / 0.9e1 * t608 * t2422 - 0.4e1 / 0.3e1 * t608 * t2427 - 0.4e1 / 0.9e1 * t608 * t2432 - 0.32e2 / 0.27e2 * t608 * t2435 + 0.4e1 / 0.9e1 * t608 * t2440 + 0.8e1 / 0.9e1 * t608 * t2444 + 0.4e1 / 0.9e1 * t608 * t2448 + 0.4e1 / 0.9e1 * t608 * t2452 + 0.4e1 / 0.9e1 * t608 * t2457 + 0.2e1 / 0.9e1 * t608 * t2462 - 0.4e1 / 0.9e1 * t608 * t2467 - 0.4e1 / 0.3e1 * t608 * t2472;
  t2476 = t2411 + t2475;
  t2481 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t1013 - t2331 - 0.3e1 / 0.8e1 * t6 * t81 * t2476);
  tv3rhosigma211 = t2481 * t7 + t1017;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2486 = t2041 * t1019 / 0.6e1;
  t2487 = t273 * t1018;
  t2490 = t860 * t399;
  t2491 = t698 * t155;
  t2492 = t2490 * t2491;
  t2494 = t1663 * t172;
  t2495 = t2016 * t2494;
  t2497 = t861 * t717;
  t2498 = t860 * t2497;
  t2503 = t2041 * t1023 / 0.3e1;
  t2504 = t273 * t1022;
  t2507 = t730 * t155;
  t2508 = t2016 * t2507;
  t2510 = t860 * t52;
  t2511 = t1722 * t172;
  t2512 = t2510 * t2511;
  t2515 = t439 * t740;
  t2516 = t860 * t2515;
  t2518 = t2030 * t1019 / 0.2e1 + t2486 - 0.5e1 / 0.6e1 * t859 * t2487 - t859 * t2492 - t859 * t2495 + t859 * t2498 / 0.2e1 + t2030 * t1023 + t2503 - 0.5e1 / 0.3e1 * t859 * t2504 - t859 * t2508 - 0.3e1 * t859 * t2512 + t859 * t2516;
  t2519 = my_piecewise3(t2, 0, t2518);
  tv3rhosigmalapl0 = t2519 * t7 + t1026;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2524 = t2115 * t1028 / 0.6e1;
  t2527 = t2115 * t1032 / 0.3e1;
  t2529 = my_piecewise3(t72, 0, t2112 * t1028 / 0.2e1 + t2524 + t2112 * t1032 + t2527);
  tv3rhosigmalapl5 = t2529 * t7 + t1035;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2535 = my_piecewise3(t2, 0, t2089 * t1019 / 0.2e1 + t2486 + t2089 * t1023 + t2503);
  tv3rhosigmalapl6 = t2535 * t7 + t1026;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2539 = t302 * t1027;
  t2542 = t898 * t600;
  t2543 = t792 * t242;
  t2544 = t2542 * t2543;
  t2546 = t1956 * t259;
  t2547 = t2167 * t2546;
  t2549 = t899 * t811;
  t2550 = t898 * t2549;
  t2554 = t302 * t1031;
  t2557 = t824 * t242;
  t2558 = t2167 * t2557;
  t2560 = t898 * t96;
  t2561 = t1965 * t259;
  t2562 = t2560 * t2561;
  t2565 = t640 * t834;
  t2566 = t898 * t2565;
  t2568 = t2153 * t1028 / 0.2e1 + t2524 - 0.5e1 / 0.6e1 * t897 * t2539 - t897 * t2544 - t897 * t2547 + t897 * t2550 / 0.2e1 + t2153 * t1032 + t2527 - 0.5e1 / 0.3e1 * t897 * t2554 - t897 * t2558 - 0.3e1 * t897 * t2562 + t897 * t2566;
  t2569 = my_piecewise3(t72, 0, t2568);
  tv3rhosigmalapl11 = t2569 * t7 + t1035;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2574 = 0.2e1 / 0.3e1 * t2041 * t1039;
  t2575 = t860 * t1038;
  t2578 = t1037 * t142;
  t2579 = t438 * t57;
  t2580 = t2579 * t155;
  t2581 = t2578 * t2580;
  t2584 = t1037 * t52;
  t2585 = t1161 * t57;
  t2586 = t2585 * t172;
  t2587 = t2584 * t2586;
  t2591 = my_piecewise3(t2, 0, -0.2e1 * t2030 * t1039 - t2574 + 0.4e1 / 0.3e1 * t859 * t2575 + 0.2e1 * t859 * t2581 + 0.6e1 * t859 * t2587);
  tv3rholapl20 = t2591 * t7 + t1042;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2596 = 0.2e1 / 0.3e1 * t2115 * t1046;
  t2598 = my_piecewise3(t72, 0, -0.2e1 * t1046 * t2112 - t2596);
  tv3rholapl22 = t2598 * t7 + t1049;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2603 = my_piecewise3(t2, 0, -0.2e1 * t1039 * t2089 - t2574);
  tv3rholapl23 = t2603 * t7 + t1042;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2607 = t898 * t1045;
  t2610 = t1044 * t229;
  t2611 = t639 * t101;
  t2612 = t2611 * t242;
  t2613 = t2610 * t2612;
  t2616 = t1044 * t96;
  t2617 = t1547 * t101;
  t2618 = t2617 * t259;
  t2619 = t2616 * t2618;
  t2623 = my_piecewise3(t72, 0, -0.2e1 * t2153 * t1046 - t2596 + 0.4e1 / 0.3e1 * t897 * t2607 + 0.2e1 * t897 * t2613 + 0.6e1 * t897 * t2619);
  tv3rholapl25 = t2623 * t7 + t1049;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2631 = t1663 * t944;
  t2632 = t408 * t2631;
  t2635 = t287 * t287;
  t2636 = 0.1e1 / t2635;
  t2637 = t56 * t2636;
  t2640 = -0.12e2 * t2637 * t40 + 0.12e2 * t950;
  t2641 = t162 * t2640;
  t2654 = 0.1e1 / t44 / t287;
  t2667 = 0.1e1 / t1115;
  t2671 = 0.3e1 / 0.8e1 * t43 * t2654 * t46 * t48 - 0.3e1 / 0.8e1 * t43 * t288 * t41 * t151 - t43 * t57 * t935 * t428 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2667 * t1127;
  t2672 = t143 * t2671;
  t2676 = t2301 * t292;
  t2677 = t692 * t2676;
  t2680 = t693 * t939;
  t2681 = t692 * t2680;
  t2684 = t2267 * t292;
  t2685 = t408 * t2684;
  t2688 = t698 * t954;
  t2689 = t408 * t2688;
  t2692 = t944 * t292;
  t2693 = t1162 * t2692;
  t2697 = t730 * t954;
  t2698 = t684 * t2697;
  t2701 = t916 * t283;
  t2702 = t1178 * t2701;
  t2706 = -0.2e1 / 0.3e1 * t36 * t408 * t2262 - 0.2e1 / 0.3e1 * t36 * t684 * t2286 - 0.4e1 / 0.3e1 * t407 * t2632 - 0.2e1 / 0.9e1 * t36 * t42 * t2641 + 0.4e1 / 0.3e1 * t36 * t692 * t2296 + 0.4e1 / 0.3e1 * t36 * t922 + 0.4e1 / 0.3e1 * t36 * t684 * t2272 - 0.2e1 / 0.9e1 * t36 * t42 * t2672 - 0.4e1 / 0.3e1 * t407 * t2677 + 0.4e1 / 0.3e1 * t407 * t2681 + 0.2e1 / 0.3e1 * t407 * t2685 + 0.2e1 / 0.3e1 * t407 * t2689 - 0.4e1 / 0.3e1 * t36 * t42 * t2693 + 0.4e1 / 0.3e1 * t407 * t2698 - 0.4e1 / 0.3e1 * t36 * t42 * t2702;
  t2710 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t2706);
  tv3sigma30 = t7 * t2710;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2717 = t1956 * t998;
  t2718 = t609 * t2717;
  t2721 = t316 * t316;
  t2722 = 0.1e1 / t2721;
  t2723 = t100 * t2722;
  t2726 = -0.12e2 * t2723 * t85 + 0.12e2 * t1004;
  t2727 = t249 * t2726;
  t2740 = 0.1e1 / t88 / t316;
  t2753 = 0.1e1 / t1520;
  t2757 = 0.3e1 / 0.8e1 * t43 * t2740 * t90 * t92 - 0.3e1 / 0.8e1 * t43 * t317 * t86 * t238 - t43 * t101 * t989 * t629 / 0.8e1 + 0.3e1 / 0.8e1 * t43 * t2753 * t1532;
  t2758 = t230 * t2757;
  t2762 = t824 * t1008;
  t2763 = t778 * t2762;
  t2766 = t970 * t312;
  t2767 = t1564 * t2766;
  t2771 = t2430 * t321;
  t2772 = t786 * t2771;
  t2775 = t787 * t993;
  t2776 = t786 * t2775;
  t2779 = t2460 * t321;
  t2780 = t609 * t2779;
  t2783 = t792 * t1008;
  t2784 = t609 * t2783;
  t2787 = t998 * t321;
  t2788 = t1548 * t2787;
  t2792 = -0.2e1 / 0.3e1 * t36 * t609 * t2455 - 0.2e1 / 0.3e1 * t36 * t778 * t2420 - 0.4e1 / 0.3e1 * t608 * t2718 - 0.2e1 / 0.9e1 * t36 * t87 * t2727 + 0.4e1 / 0.3e1 * t36 * t786 * t2425 + 0.4e1 / 0.3e1 * t36 * t976 + 0.4e1 / 0.3e1 * t36 * t778 * t2465 - 0.2e1 / 0.9e1 * t36 * t87 * t2758 + 0.4e1 / 0.3e1 * t608 * t2763 - 0.4e1 / 0.3e1 * t36 * t87 * t2767 - 0.4e1 / 0.3e1 * t608 * t2772 + 0.4e1 / 0.3e1 * t608 * t2776 + 0.2e1 / 0.3e1 * t608 * t2780 + 0.2e1 / 0.3e1 * t608 * t2784 - 0.4e1 / 0.3e1 * t36 * t87 * t2788;
  t2796 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * t2792);
  tv3sigma39 = t7 * t2796;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t2797 = t2012 * t916;
  t2798 = t860 * t2797;
  t2800 = t1663 * t292;
  t2801 = t2016 * t2800;
  t2804 = t861 * t939;
  t2805 = t860 * t2804;
  t2808 = t1162 * t944;
  t2809 = t860 * t2808;
  t2812 = t439 * t954;
  t2813 = t860 * t2812;
  t2816 = my_piecewise3(t2, 0, -t859 * t2798 - 0.2e1 * t859 * t2801 + t859 * t2805 / 0.2e1 - 0.3e1 * t859 * t2809 + t859 * t2813);
  tv3sigma2lapl0 = t7 * t2816;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t2817 = t2163 * t970;
  t2818 = t898 * t2817;
  t2820 = t1956 * t321;
  t2821 = t2167 * t2820;
  t2824 = t899 * t993;
  t2825 = t898 * t2824;
  t2828 = t1548 * t998;
  t2829 = t898 * t2828;
  t2832 = t640 * t1008;
  t2833 = t898 * t2832;
  t2836 = my_piecewise3(t72, 0, -t897 * t2818 - 0.2e1 * t897 * t2821 + t897 * t2825 / 0.2e1 - 0.3e1 * t897 * t2829 + t897 * t2833);
  tv3sigma2lapl11 = t7 * t2836;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t2837 = t2579 * t283;
  t2838 = t2578 * t2837;
  t2841 = t2585 * t292;
  t2842 = t2584 * t2841;
  t2845 = t439 * t288;
  t2846 = t1037 * t2845;
  t2850 = my_piecewise3(t2, 0, 0.2e1 * t2838 * t859 + 0.6e1 * t2842 * t859 + 0.2e1 * t2846 * t859);
  tv3sigmalapl20 = t7 * t2850;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t2851 = t2611 * t312;
  t2852 = t2610 * t2851;
  t2855 = t2617 * t321;
  t2856 = t2616 * t2855;
  t2859 = t640 * t317;
  t2860 = t1044 * t2859;
  t2864 = my_piecewise3(t72, 0, 0.2e1 * t2852 * t897 + 0.6e1 * t2856 * t897 + 0.2e1 * t2860 * t897);
  tv3sigmalapl28 = t7 * t2864;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t2865 = t34 * t38;
  t2866 = t1162 * t288;
  t2867 = t2865 * t2866;
  t2870 = my_piecewise3(t2, 0, -0.12e2 * t859 * t2867);
  tv3lapl30 = t7 * t2870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t2871 = t34 * t83;
  t2872 = t1548 * t317;
  t2873 = t2871 * t2872;
  t2876 = my_piecewise3(t72, 0, -0.12e2 * t897 * t2873);
  tv3lapl33 = t7 * t2876;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t2881 = sigma[0] / t39 / t710;
  t2885 = t155 * t172;
  t2916 = t1115 * t385;
  t2928 = 0.1e1 / t150 / t1125 / t149;
  t2970 = 0.1e1 / t1176 / t51;
  t2971 = t2970 * t62;
  t2972 = t401 * t401;
  t2977 = t432 * t432;
  t2989 = 0.1e1 / t1160 / t61;
  t2990 = t52 * t2989;
  t2991 = t440 * t440;
  t2996 = t456 * t456;
  t3004 = 0.41888e5 / 0.729e3 * t36 * t2881 * t63 - 0.16e2 / 0.3e1 * t407 * t1652 * t2885 * t432 - 0.16e2 / 0.3e1 * t407 * t1646 * t2885 * t456 + 0.9856e4 / 0.243e3 * t36 * t1111 * t156 + 0.9856e4 / 0.243e3 * t36 * t1111 * t173 - 0.352e3 / 0.27e2 * t36 * t388 * t433 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (0.364e4 / 0.81e2 * t43 * t44 * t935 * t48 + 0.5768e4 / 0.27e2 * t43 * t2881 * t151 - 0.18608e5 / 0.81e2 * t43 * t287 / t38 / t2249 * t428 + 0.448e4 / 0.27e2 * t43 * t949 / t2916 * t1127 - 0.128e4 / 0.27e2 * t43 * t2635 / t39 / t1115 / t710 * t2928) - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (0.2e1 * (0.20944e5 / 0.81e2 * t2881 - 0.616e4 / 0.81e2 * lapl[0] * t1110) * t57 * t40 + 0.64e2 / 0.3e1 * t1140 * t53 + 0.16e3 / 0.3e1 * t449 * t39 + 0.64e3 / 0.27e2 * t167 * t1147 - 0.16e3 / 0.81e2 * t58 * t46) - 0.352e3 / 0.27e2 * t36 * t388 * t457 + 0.704e3 / 0.27e2 * t36 * t388 * t402 + 0.704e3 / 0.27e2 * t36 * t388 * t441 + 0.128e3 / 0.9e1 * t36 * t137 * t1180 + 0.16e2 / 0.3e1 * t36 * t42 * t2971 * t2972 + 0.4e1 / 0.3e1 * t36 * t42 * t400 * t2977 + 0.64e2 / 0.27e2 * t36 * t137 * t1151 + 0.128e3 / 0.9e1 * t36 * t137 * t1164 + 0.16e2 / 0.3e1 * t36 * t42 * t2990 * t2991 + 0.4e1 / 0.3e1 * t36 * t42 * t439 * t2996 + 0.64e2 / 0.27e2 * t36 * t137 * t1132;
  t3005 = t1161 * t155;
  t3018 = t387 * t142;
  t3037 = t438 * t401;
  t3059 = t62 * t1131;
  t3069 = t161 * t1150;
  t3079 = t438 * t432;
  t3084 = 0.16e2 / 0.3e1 * t407 * t408 * t3005 * t1163 - 0.128e3 / 0.9e1 * t407 * t1630 * t1169 - 0.8e1 * t407 * t684 * t1161 * t440 * t456 + 0.704e3 / 0.27e2 * t407 * t3018 * t410 + 0.128e3 / 0.9e1 * t407 * t1711 * t1185 - 0.128e3 / 0.9e1 * t407 * t1711 * t1189 - 0.64e2 / 0.9e1 * t407 * t1205 * t1194 - 0.64e2 / 0.9e1 * t407 * t1205 * t1198 + 0.128e3 / 0.9e1 * t407 * t1205 * t1156 + 0.16e2 / 0.3e1 * t407 * t692 * t3037 * t440 + 0.4e1 / 0.3e1 * t407 * t408 * t1193 * t456 + 0.16e2 / 0.3e1 * t407 * t1658 * t161 * t1179 * t172 - 0.8e1 * t407 * t1658 * t1623 * t432 - 0.8e1 / 0.3e1 * t407 * t692 * t1184 * t456 + 0.16e2 / 0.9e1 * t407 * t692 * t3059 * t155 + 0.8e1 / 0.9e1 * t407 * t408 * t161 * t1131 * t172 + 0.8e1 / 0.9e1 * t407 * t408 * t3069 * t155 + 0.16e2 / 0.9e1 * t407 * t684 * t438 * t1150 * t172 - 0.8e1 / 0.3e1 * t407 * t408 * t3079 * t440;
  t3089 = t20 * t20;
  t3091 = 0.1e1 / t350 / t3089;
  t3092 = t352 * t352;
  t3098 = t360 * t360;
  t3104 = 0.1e1 / t1060 / t7;
  t3105 = t17 * t3104;
  t3108 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1061 + 0.24e2 * t3105);
  t3112 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3091 * t3092 - 0.16e2 / 0.9e1 * t1053 * t352 * t360 + 0.4e1 / 0.3e1 * t351 * t3098 + 0.16e2 / 0.9e1 * t1057 * t1065 + 0.4e1 / 0.3e1 * t24 * t3108);
  t3121 = t6 * t1074 * t177;
  t3127 = t6 * t1081 * t177;
  t3129 = t6 * t369 * t461;
  t3135 = t6 * t1093 * t177;
  t3138 = t6 * t378 * t461;
  t3141 = t6 * t130 * t1224;
  t3145 = t6 * t1069 * t129 * t67;
  t3149 = t6 * t364 * t377 * t67;
  t3153 = t6 * t123 * t1092 * t67;
  t3156 = 0.1e1 / t128 / t355;
  t3160 = 0.1e2 / 0.27e2 * t6 * t26 * t3156 * t67;
  t3161 = -0.3e1 / 0.8e1 * t6 * t28 * (t3004 + t3084) - 0.3e1 / 0.8e1 * t6 * t3112 * t27 * t67 - 0.3e1 / 0.2e1 * t6 * t1070 * t177 - 0.3e1 / 0.2e1 * t3121 - 0.9e1 / 0.4e1 * t6 * t365 * t461 + t3127 - 0.3e1 / 0.2e1 * t3129 - 0.3e1 / 0.2e1 * t6 * t124 * t1224 - 0.5e1 / 0.9e1 * t3135 + t3138 / 0.2e1 - t3141 / 0.2e1 - t3145 / 0.2e1 + t3149 / 0.2e1 - 0.5e1 / 0.9e1 * t3153 + t3160;
  t3162 = my_piecewise3(t2, 0, t3161);
  t3163 = t76 * t76;
  t3165 = 0.1e1 / t467 / t3163;
  t3166 = t469 * t469;
  t3172 = t475 * t475;
  t3177 = t73 * t3104;
  t3180 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1061 + 0.24e2 * t3177);
  t3184 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t3166 - 0.16e2 / 0.9e1 * t1231 * t469 * t475 + 0.4e1 / 0.3e1 * t468 * t3172 + 0.16e2 / 0.9e1 * t1235 * t1241 + 0.4e1 / 0.3e1 * t78 * t3180);
  t3191 = t6 * t1245 * t129 * t111;
  t3195 = t6 * t479 * t377 * t111;
  t3199 = t6 * t188 * t1092 * t111;
  t3204 = 0.1e2 / 0.27e2 * t6 * t80 * t3156 * t111;
  t3206 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t3184 * t27 * t111 - t3191 / 0.2e1 + t3195 / 0.2e1 - 0.5e1 / 0.9e1 * t3199 + t3204);
  tv4rho40 = 0.4e1 * t1229 + 0.4e1 * t1263 + t7 * (t3162 + t3206);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3227 = 0.12e2 * t1061;
  t3228 = 0.24e2 * t3105;
  t3230 = my_piecewise5(t11, 0, t15, 0, -t3227 + t3228);
  t3234 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3091 * t202 * t1054 - 0.8e1 / 0.9e1 * t1053 * t500 * t352 - 0.8e1 / 0.9e1 * t1268 * t120 * t360 + 0.4e1 / 0.3e1 * t351 * t1279 * t120 + 0.4e1 / 0.3e1 * t1271 * t360 + 0.4e1 / 0.9e1 * t496 * t1065 + 0.4e1 / 0.3e1 * t24 * t3230);
  t3243 = t6 * t1288 * t177;
  t3249 = t6 * t1295 * t177;
  t3250 = t3249 / 0.4e1;
  t3252 = t6 * t509 * t461;
  t3265 = t6 * t1283 * t129 * t67;
  t3269 = t6 * t504 * t377 * t67;
  t3270 = t3269 / 0.4e1;
  t3273 = t6 * t205 * t1092 * t67;
  t3278 = -0.3e1 / 0.8e1 * t6 * t3234 * t27 * t67 - 0.9e1 / 0.8e1 * t6 * t1284 * t177 - 0.3e1 / 0.4e1 * t3243 - 0.9e1 / 0.8e1 * t6 * t505 * t461 + t3250 - 0.3e1 / 0.8e1 * t3252 - 0.3e1 / 0.8e1 * t6 * t206 * t1224 - 0.3e1 / 0.8e1 * t3121 + t3127 / 0.2e1 - 0.3e1 / 0.8e1 * t3129 - 0.5e1 / 0.12e2 * t3135 + t3138 / 0.4e1 - t3141 / 0.8e1 - 0.3e1 / 0.8e1 * t3265 + t3270 - 0.5e1 / 0.36e2 * t3273 - t3145 / 0.8e1 + t3149 / 0.4e1 - 0.5e1 / 0.12e2 * t3153 + t3160;
  t3279 = my_piecewise3(t2, 0, t3278);
  t3296 = 0.24e2 * t3177;
  t3298 = my_piecewise5(t15, 0, t11, 0, t3227 + t3296);
  t3302 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t213 * t1232 - 0.8e1 / 0.9e1 * t1231 * t524 * t469 - 0.8e1 / 0.9e1 * t1312 * t185 * t475 + 0.4e1 / 0.3e1 * t468 * t1322 * t185 + 0.4e1 / 0.3e1 * t1315 * t475 + 0.4e1 / 0.9e1 * t520 * t1241 + 0.4e1 / 0.3e1 * t78 * t3298);
  t3309 = t6 * t1326 * t129 * t111;
  t3313 = t6 * t528 * t377 * t111;
  t3314 = t3313 / 0.4e1;
  t3317 = t6 * t216 * t1092 * t111;
  t3326 = t6 * t1250 * t264;
  t3329 = t6 * t1254 * t264;
  t3330 = t3329 / 0.4e1;
  t3332 = t6 * t1258 * t264;
  t3334 = -0.3e1 / 0.8e1 * t6 * t3302 * t27 * t111 - 0.3e1 / 0.8e1 * t3309 + t3314 - 0.5e1 / 0.36e2 * t3317 - t3191 / 0.8e1 + t3195 / 0.4e1 - 0.5e1 / 0.12e2 * t3199 + t3204 - 0.3e1 / 0.8e1 * t6 * t1246 * t264 - 0.3e1 / 0.8e1 * t3326 + t3330 - 0.5e1 / 0.36e2 * t3332;
  t3335 = my_piecewise3(t72, 0, t3334);
  tv4rho41 = t1229 + t1263 + 0.3e1 * t1311 + 0.3e1 * t1351 + t7 * (t3279 + t3335);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t3344 = t6 * t559 * t377 * t67;
  t3354 = t500 * t500;
  t3367 = my_piecewise5(t11, 0, t15, 0, t3228);
  t3371 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3091 * t550 * t352 - 0.32e2 / 0.27e2 * t1268 * t120 * t500 - 0.8e1 / 0.27e2 * t1354 * t360 + 0.8e1 / 0.9e1 * t351 * t3354 + 0.8e1 / 0.9e1 * t496 * t1279 - 0.8e1 / 0.27e2 * t1053 * t555 * t352 + 0.8e1 / 0.9e1 * t351 * t1363 * t120 + 0.4e1 / 0.9e1 * t1359 * t360 + 0.4e1 / 0.3e1 * t24 * t3367);
  t3380 = t6 * t1372 * t177;
  t3393 = t6 * t1367 * t129 * t67;
  t3400 = t3344 / 0.12e2 - 0.3e1 / 0.8e1 * t6 * t3371 * t27 * t67 - 0.3e1 / 0.4e1 * t6 * t1368 * t177 - t3380 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t560 * t461 - t3243 / 0.2e1 + t3249 / 0.3e1 - t3252 / 0.4e1 + t3127 / 0.6e1 - 0.5e1 / 0.18e2 * t3135 + t3138 / 0.12e2 - t3393 / 0.4e1 - t3265 / 0.4e1 + t3269 / 0.3e1 - 0.5e1 / 0.18e2 * t3273 + t3149 / 0.12e2 - 0.5e1 / 0.18e2 * t3153 + t3160;
  t3401 = my_piecewise3(t2, 0, t3400);
  t3410 = t524 * t524;
  t3423 = my_piecewise5(t15, 0, t11, 0, t3296);
  t3427 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t567 * t469 - 0.32e2 / 0.27e2 * t1312 * t185 * t524 - 0.8e1 / 0.27e2 * t1384 * t475 + 0.8e1 / 0.9e1 * t468 * t3410 + 0.8e1 / 0.9e1 * t520 * t1322 - 0.8e1 / 0.27e2 * t1231 * t572 * t469 + 0.8e1 / 0.9e1 * t468 * t1393 * t185 + 0.4e1 / 0.9e1 * t1389 * t475 + 0.4e1 / 0.3e1 * t78 * t3423);
  t3434 = t6 * t1397 * t129 * t111;
  t3438 = t6 * t576 * t377 * t111;
  t3447 = t6 * t1331 * t264;
  t3450 = t6 * t1335 * t264;
  t3461 = t6 * t484 * t662;
  t3464 = t6 * t488 * t662;
  t3466 = -0.3e1 / 0.8e1 * t6 * t3427 * t27 * t111 - t3434 / 0.4e1 + t3438 / 0.12e2 - t3309 / 0.4e1 + t3313 / 0.3e1 - 0.5e1 / 0.18e2 * t3317 - 0.3e1 / 0.4e1 * t6 * t1327 * t264 - t3447 / 0.2e1 + t3450 / 0.6e1 + t3195 / 0.12e2 - 0.5e1 / 0.18e2 * t3199 + t3204 - t3326 / 0.4e1 + t3329 / 0.3e1 - 0.5e1 / 0.18e2 * t3332 - 0.3e1 / 0.8e1 * t6 * t480 * t662 - t3461 / 0.4e1 + t3464 / 0.12e2;
  t3467 = my_piecewise3(t72, 0, t3466);
  tv4rho42 = 0.2e1 * t1311 + 0.2e1 * t1351 + 0.2e1 * t1383 + 0.2e1 * t1422 + t7 * (t3401 + t3467);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t3488 = my_piecewise5(t11, 0, t15, 0, t3227 + t3228);
  t3492 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3091 * t1427 * t120 - 0.8e1 / 0.9e1 * t1354 * t500 - 0.8e1 / 0.9e1 * t1268 * t555 * t120 + 0.4e1 / 0.3e1 * t1271 * t555 + 0.4e1 / 0.3e1 * t496 * t1363 + 0.4e1 / 0.9e1 * t351 * t1434 * t120 + 0.4e1 / 0.3e1 * t24 * t3488);
  t3499 = t6 * t1438 * t129 * t67;
  t3510 = -0.3e1 / 0.8e1 * t6 * t3492 * t27 * t67 - t3499 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1439 * t177 - 0.3e1 / 0.8e1 * t3393 + t3344 / 0.4e1 - 0.3e1 / 0.8e1 * t3380 + t3270 - 0.5e1 / 0.12e2 * t3273 + t3250 - 0.5e1 / 0.36e2 * t3153 + t3160 - 0.5e1 / 0.36e2 * t3135;
  t3511 = my_piecewise3(t2, 0, t3510);
  t3528 = my_piecewise5(t15, 0, t11, 0, -t3227 + t3296);
  t3532 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t1447 * t185 - 0.8e1 / 0.9e1 * t1384 * t524 - 0.8e1 / 0.9e1 * t1312 * t572 * t185 + 0.4e1 / 0.3e1 * t1315 * t572 + 0.4e1 / 0.3e1 * t520 * t1393 + 0.4e1 / 0.9e1 * t468 * t1454 * t185 + 0.4e1 / 0.3e1 * t78 * t3528);
  t3539 = t6 * t1458 * t129 * t111;
  t3547 = t6 * t1402 * t264;
  t3556 = t6 * t533 * t662;
  t3566 = t6 * t193 * t1595;
  t3568 = -0.3e1 / 0.8e1 * t6 * t3532 * t27 * t111 - t3539 / 0.8e1 - 0.3e1 / 0.8e1 * t3434 + t3438 / 0.4e1 - 0.9e1 / 0.8e1 * t6 * t1398 * t264 - 0.3e1 / 0.8e1 * t3547 + t3314 - 0.5e1 / 0.12e2 * t3317 - 0.3e1 / 0.4e1 * t3447 + t3450 / 0.2e1 - 0.9e1 / 0.8e1 * t6 * t529 * t662 - 0.3e1 / 0.8e1 * t3556 - 0.5e1 / 0.36e2 * t3199 + t3204 + t3330 - 0.5e1 / 0.12e2 * t3332 - 0.3e1 / 0.8e1 * t3461 + t3464 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t189 * t1595 - t3566 / 0.8e1;
  t3569 = my_piecewise3(t72, 0, t3568);
  tv4rho43 = 0.3e1 * t1383 + 0.3e1 * t1422 + t1446 + t1600 + t7 * (t3511 + t3569);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t3574 = t550 * t550;
  t3579 = t555 * t555;
  t3586 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1061 + 0.24e2 * t3105);
  t3590 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t3091 * t3574 - 0.16e2 / 0.9e1 * t1354 * t555 + 0.4e1 / 0.3e1 * t351 * t3579 + 0.16e2 / 0.9e1 * t496 * t1434 + 0.4e1 / 0.3e1 * t24 * t3586);
  t3599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t3590 * t27 * t67 - t3499 / 0.2e1 + t3344 / 0.2e1 - 0.5e1 / 0.9e1 * t3273 + t3160);
  t3609 = t639 * t602;
  t3614 = t1547 * t242;
  t3642 = t106 * t1536;
  t3652 = t248 * t1491;
  t3662 = t588 * t229;
  t3683 = t639 * t633;
  t3688 = 0.16e2 / 0.3e1 * t608 * t786 * t3609 * t641 + 0.16e2 / 0.3e1 * t608 * t609 * t3614 * t1549 + 0.128e3 / 0.9e1 * t608 * t1940 * t1571 + 0.128e3 / 0.9e1 * t608 * t1591 * t1542 - 0.8e1 * t608 * t778 * t1547 * t641 * t657 - 0.128e3 / 0.9e1 * t608 * t1940 * t1575 - 0.64e2 / 0.9e1 * t608 * t1591 * t1580 - 0.64e2 / 0.9e1 * t608 * t1591 * t1584 - 0.128e3 / 0.9e1 * t608 * t1862 * t1555 + 0.16e2 / 0.9e1 * t608 * t786 * t3642 * t242 + 0.8e1 / 0.9e1 * t608 * t609 * t248 * t1536 * t259 + 0.8e1 / 0.9e1 * t608 * t609 * t3652 * t242 + 0.16e2 / 0.9e1 * t608 * t778 * t639 * t1491 * t259 + 0.704e3 / 0.27e2 * t608 * t3662 * t611 + 0.16e2 / 0.3e1 * t608 * t1970 * t248 * t1565 * t259 - 0.8e1 * t608 * t1970 * t1855 * t633 - 0.8e1 / 0.3e1 * t608 * t786 * t1570 * t657 + 0.4e1 / 0.3e1 * t608 * t609 * t1579 * t657 - 0.8e1 / 0.3e1 * t608 * t609 * t3683 * t641;
  t3689 = t633 * t633;
  t3698 = 0.1e1 / t1546 / t105;
  t3699 = t96 * t3698;
  t3700 = t641 * t641;
  t3705 = t657 * t657;
  t3725 = sigma[2] / t84 / t804;
  t3735 = t1520 * t586;
  t3747 = 0.1e1 / t237 / t1530 / t236;
  t3795 = 0.1e1 / t1562 / t95;
  t3796 = t3795 * t106;
  t3797 = t602 * t602;
  t3802 = t242 * t259;
  t3814 = 0.4e1 / 0.3e1 * t36 * t87 * t601 * t3689 + 0.128e3 / 0.9e1 * t36 * t224 * t1550 + 0.16e2 / 0.3e1 * t36 * t87 * t3699 * t3700 + 0.4e1 / 0.3e1 * t36 * t87 * t640 * t3705 + 0.704e3 / 0.27e2 * t36 * t589 * t642 + 0.64e2 / 0.27e2 * t36 * t224 * t1492 + 0.704e3 / 0.27e2 * t36 * t589 * t603 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (0.364e4 / 0.81e2 * t43 * t88 * t989 * t92 + 0.5768e4 / 0.27e2 * t43 * t3725 * t238 - 0.18608e5 / 0.81e2 * t43 * t316 / t83 / t2391 * t629 + 0.448e4 / 0.27e2 * t43 * t1003 / t3735 * t1532 - 0.128e4 / 0.27e2 * t43 * t2721 / t84 / t1520 / t804 * t3747) - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (0.2e1 * (0.20944e5 / 0.81e2 * t3725 - 0.616e4 / 0.81e2 * lapl[1] * t1475) * t101 * t85 + 0.64e2 / 0.3e1 * t1481 * t97 + 0.16e3 / 0.3e1 * t650 * t84 + 0.64e3 / 0.27e2 * t254 * t1488 - 0.16e3 / 0.81e2 * t102 * t90) + 0.9856e4 / 0.243e3 * t36 * t1476 * t243 + 0.9856e4 / 0.243e3 * t36 * t1476 * t260 - 0.352e3 / 0.27e2 * t36 * t589 * t634 - 0.352e3 / 0.27e2 * t36 * t589 * t658 + 0.64e2 / 0.27e2 * t36 * t224 * t1537 + 0.128e3 / 0.9e1 * t36 * t224 * t1566 + 0.16e2 / 0.3e1 * t36 * t87 * t3796 * t3797 - 0.16e2 / 0.3e1 * t608 * t1870 * t3802 * t657 - 0.16e2 / 0.3e1 * t608 * t1876 * t3802 * t633 + 0.41888e5 / 0.729e3 * t36 * t3725 * t107;
  t3819 = t567 * t567;
  t3824 = t572 * t572;
  t3831 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1061 + 0.24e2 * t3177);
  t3835 = my_piecewise3(t77, 0, 0.4e2 / 0.81e2 * t3165 * t3819 - 0.16e2 / 0.9e1 * t1384 * t572 + 0.4e1 / 0.3e1 * t468 * t3824 + 0.16e2 / 0.9e1 * t520 * t1454 + 0.4e1 / 0.3e1 * t78 * t3831);
  t3848 = -t3539 / 0.2e1 - 0.3e1 / 0.2e1 * t3547 - 0.3e1 / 0.2e1 * t3556 - t3566 / 0.2e1 + t3438 / 0.2e1 + t3450 + t3464 / 0.2e1 - 0.3e1 / 0.2e1 * t6 * t217 * t1595 - 0.3e1 / 0.8e1 * t6 * t81 * (t3688 + t3814) - 0.3e1 / 0.8e1 * t6 * t3835 * t27 * t111 - 0.3e1 / 0.2e1 * t6 * t1459 * t264 - 0.9e1 / 0.4e1 * t6 * t577 * t662 - 0.5e1 / 0.9e1 * t3317 - 0.5e1 / 0.9e1 * t3332 + t3204;
  t3849 = my_piecewise3(t72, 0, t3848);
  tv4rho44 = 0.4e1 * t1446 + 0.4e1 * t1600 + t7 * (t3599 + t3849);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t3857 = t6 * t1074 * t297;
  t3863 = t6 * t1081 * t297;
  t3866 = t6 * t369 * t745;
  t3873 = 0.5e1 / 0.36e2 * t6 * t1093 * t297;
  t3875 = t6 * t378 * t745;
  t3878 = t6 * t130 * t1776;
  t3891 = t161 * t1747;
  t3902 = t161 * t1762;
  t3921 = t387 * t52;
  t3949 = t1161 * t740;
  t3954 = -0.2464e4 / 0.243e3 * t272 * t34 * t1110 * t63 + 0.32e2 / 0.9e1 * t407 * t1711 * t1718 + 0.4e1 / 0.3e1 * t407 * t1658 * t725 * t1179 + 0.2e1 / 0.3e1 * t407 * t408 * t3891 * t172 - 0.32e2 / 0.9e1 * t407 * t1205 * t1669 - 0.64e2 / 0.9e1 * t407 * t1630 * t1678 + 0.2e1 / 0.3e1 * t407 * t408 * t3902 * t155 + 0.4e1 / 0.3e1 * t407 * t684 * t438 * t1762 * t172 - 0.64e2 / 0.9e1 * t407 * t1711 * t1687 - 0.32e2 / 0.9e1 * t407 * t1205 * t1697 + 0.176e3 / 0.27e2 * t407 * t3018 * t726 + 0.352e3 / 0.27e2 * t407 * t3921 * t731 + 0.2e1 / 0.9e1 * t407 * t408 * t725 * t1131 + 0.4e1 / 0.3e1 * t407 * t684 * t1677 * t456 + 0.4e1 / 0.9e1 * t407 * t684 * t730 * t1150 + 0.4e1 / 0.3e1 * t407 * t692 * t1686 * t432 + 0.4e1 / 0.9e1 * t407 * t692 * t693 * t1131 - 0.4e1 / 0.3e1 * t407 * t692 * t1668 * t401 - 0.4e1 * t407 * t684 * t3949 * t440;
  t3959 = t438 * t717;
  t3968 = t62 * t1747;
  t3985 = t1161 * t283;
  t3996 = t2989 * t292;
  t4001 = t136 * t1177;
  t4005 = t41 * t2970;
  t4031 = -0.4e1 * t407 * t1658 * t1686 * t401 - 0.4e1 / 0.3e1 * t407 * t408 * t3959 * t440 + 0.2e1 / 0.3e1 * t407 * t408 * t1668 * t432 + 0.4e1 / 0.3e1 * t407 * t692 * t3968 * t155 - 0.32e2 / 0.9e1 * t407 * t1711 * t1692 - 0.16e2 / 0.9e1 * t407 * t1205 * t1701 - 0.32e2 / 0.9e1 * t407 * t1630 * t1682 + 0.32e2 / 0.9e1 * t407 * t1205 * t1664 + 0.4e1 / 0.3e1 * t407 * t408 * t3985 * t1163 - 0.16e2 / 0.9e1 * t407 * t1205 * t1673 + 0.32e2 / 0.3e1 * t407 * t1630 * t1723 + 0.16e2 / 0.3e1 * t407 * t684 * t3996 * t1163 + 0.32e2 / 0.3e1 * t407 * t4001 * t1659 + 0.16e2 / 0.3e1 * t407 * t4005 * t693 * t1179 + 0.352e3 / 0.27e2 * t407 * t387 * t399 * t694 + 0.176e3 / 0.27e2 * t407 * t3018 * t699 + 0.2e1 / 0.3e1 * t407 * t408 * t1696 * t456 + 0.2e1 / 0.9e1 * t407 * t408 * t698 * t1150 + 0.2464e4 / 0.243e3 * t36 * t1111 * t284 + 0.2464e4 / 0.243e3 * t36 * t1111 * t293;
  t4100 = t692 * t438;
  t4106 = t1205 * t438;
  t4110 = t408 * t1161;
  t4115 = t1711 * t161;
  t4123 = t684 * t1161;
  t4124 = t292 * t172;
  t4129 = -0.176e3 / 0.27e2 * t36 * t388 * t741 - 0.32e2 / 0.9e1 * t36 * t1206 - 0.176e3 / 0.27e2 * t36 * t388 * t718 - 0.4e1 / 0.3e1 * t36 * t1186 + 0.4e1 / 0.3e1 * t36 * t1190 + 0.2e1 / 0.3e1 * t36 * t1195 + 0.2e1 / 0.3e1 * t36 * t1199 - 0.4e1 / 0.3e1 * t36 * t1157 + 0.4e1 / 0.3e1 * t36 * t1170 + 0.16e2 / 0.9e1 * t36 * t137 * t1748 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-0.14e3 / 0.27e2 * t43 * t276 * t1104 * t48 - 0.364e3 / 0.9e1 * t43 * t1110 * t151 + 0.166e4 / 0.27e2 * t43 * t1117 * t428 * sigma[0] - 0.488e3 / 0.9e1 * t43 * t1123 * t1127 * t287 + 0.16e3 / 0.9e1 * t43 / t39 / t1115 / t933 * t2928 * t949) + 0.16e2 / 0.9e1 * t36 * t137 * t1763 - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (-0.2e1 * t1139 * t288 * t40 - 0.16e2 * t1755 * t53 - 0.8e2 / 0.3e1 * t735 * t39 - 0.16e3 / 0.27e2 * t289 * t1147) + 0.8e1 / 0.3e1 * t407 * t4100 * t292 * t401 * t172 + 0.64e2 / 0.9e1 * t407 * t4106 * t1648 + 0.4e1 * t407 * t4110 * t1647 * t440 + 0.64e2 / 0.9e1 * t407 * t4115 * t1654 + 0.8e1 / 0.3e1 * t407 * t4100 * t1653 * t440 - 0.4e1 * t407 * t4123 * t4124 * t456;
  t4130 = t1658 * t161;
  t4136 = t1658 * t62;
  t4155 = t283 * t172;
  t4210 = 0.4e1 * t407 * t4130 * t283 * t401 * t172 - 0.4e1 * t407 * t4136 * t1653 * t432 - 0.8e1 / 0.3e1 * t407 * t1652 * t717 * t155 * t172 - 0.4e1 / 0.3e1 * t407 * t1652 * t283 * t432 * t172 - 0.4e1 / 0.3e1 * t407 * t1652 * t1653 * t456 - 0.4e1 / 0.3e1 * t407 * t1646 * t4155 * t456 - 0.4e1 / 0.3e1 * t407 * t1652 * t1647 * t432 - 0.8e1 / 0.3e1 * t407 * t1646 * t740 * t155 * t172 - 0.4e1 / 0.3e1 * t407 * t1646 * t292 * t432 * t172 - 0.4e1 / 0.3e1 * t407 * t1646 * t1647 * t456 - 0.176e3 / 0.27e2 * t36 * t3018 * t680 - 0.176e3 / 0.27e2 * t36 * t3921 * t685 + 0.16e2 / 0.9e1 * t36 * t1205 * t1634 + 0.16e2 / 0.9e1 * t36 * t1630 * t1638 - 0.2e1 / 0.9e1 * t36 * t408 * t3059 - 0.2e1 / 0.9e1 * t36 * t684 * t3069 - 0.32e2 / 0.9e1 * t36 * t1711 * t1623 - 0.4e1 / 0.3e1 * t36 * t1658 * t62 * t1179 - 0.32e2 / 0.9e1 * t36 * t1630 * t1619 - 0.4e1 / 0.3e1 * t36 * t684 * t1161 * t1163;
  t4217 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1070 * t297 - 0.3e1 / 0.8e1 * t3857 - 0.9e1 / 0.8e1 * t6 * t365 * t745 + t3863 / 0.4e1 - 0.3e1 / 0.4e1 * t3866 - 0.9e1 / 0.8e1 * t6 * t124 * t1776 - t3873 + t3875 / 0.4e1 - 0.3e1 / 0.8e1 * t3878 - 0.3e1 / 0.8e1 * t6 * t28 * (t3954 + t4031 + t4129 + t4210));
  tv4rho3sigma0 = t4217 * t7 + 0.3e1 * t1781;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t4224 = t6 * t1250 * t326;
  t4227 = t6 * t1254 * t326;
  t4231 = 0.5e1 / 0.36e2 * t6 * t1258 * t326;
  t4233 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1246 * t326 - 0.3e1 / 0.8e1 * t4224 + t4227 / 0.4e1 - t4231);
  tv4rho3sigma2 = t4233 * t7 + 0.3e1 * t1794;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t4235 = 0.2e1 * t1808;
  t4241 = t6 * t1288 * t297 / 0.4e1;
  t4246 = t6 * t1295 * t297;
  t4250 = t6 * t509 * t745 / 0.4e1;
  t4259 = -0.3e1 / 0.8e1 * t6 * t1284 * t297 - t4241 - 0.3e1 / 0.4e1 * t6 * t505 * t745 + t4246 / 0.12e2 - t4250 - 0.3e1 / 0.8e1 * t6 * t206 * t1776 - t3857 / 0.8e1 + t3863 / 0.6e1 - t3866 / 0.4e1 - t3873 + t3875 / 0.6e1 - t3878 / 0.8e1;
  t4260 = my_piecewise3(t2, 0, t4259);
  tv4rho3sigma3 = t4260 * t7 + t1781 + t4235;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t4262 = 0.2e1 * t1824;
  t4268 = t6 * t1331 * t326 / 0.4e1;
  t4270 = t6 * t1335 * t326;
  t4279 = t6 * t484 * t839 / 0.4e1;
  t4281 = t6 * t488 * t839;
  t4284 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1327 * t326 - t4268 + t4270 / 0.12e2 - t4224 / 0.8e1 + t4227 / 0.6e1 - t4231 - 0.3e1 / 0.8e1 * t6 * t480 * t839 - t4279 + t4281 / 0.12e2);
  tv4rho3sigma5 = t4284 * t7 + t1794 + t4262;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t4290 = t6 * t1372 * t297;
  t4299 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1368 * t297 - t4290 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t560 * t745 - t4241 + t4246 / 0.6e1 - t4250 + t3863 / 0.12e2 - t3873 + t3875 / 0.12e2);
  tv4rho3sigma6 = t4299 * t7 + t1832 + t4235;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t4305 = t6 * t1402 * t326;
  t4312 = t6 * t533 * t839;
  t4320 = t6 * t193 * t2000;
  t4322 = -0.3e1 / 0.8e1 * t6 * t1398 * t326 - t4305 / 0.8e1 - t4268 + t4270 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t529 * t839 - t4312 / 0.4e1 + t4227 / 0.12e2 - t4231 - t4279 + t4281 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t189 * t2000 - t4320 / 0.8e1;
  t4323 = my_piecewise3(t72, 0, t4322);
  tv4rho3sigma8 = t4323 * t7 + t2005 + t4262;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t4332 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1439 * t297 - 0.3e1 / 0.8e1 * t4290 + t4246 / 0.4e1 - t3873);
  tv4rho3sigma9 = t4332 * t7 + 0.3e1 * t1832;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t4353 = t3698 * t321;
  t4358 = t223 * t1563;
  t4362 = t86 * t3795;
  t4370 = t1547 * t312;
  t4388 = t248 * t1917;
  t4398 = t639 * t811;
  t4409 = t106 * t1902;
  t4414 = t248 * t1902;
  t4426 = -0.2464e4 / 0.243e3 * t272 * t34 * t1475 * t107 + 0.16e2 / 0.3e1 * t608 * t778 * t4353 * t1549 + 0.32e2 / 0.3e1 * t608 * t4358 * t1971 + 0.16e2 / 0.3e1 * t608 * t4362 * t787 * t1565 + 0.32e2 / 0.9e1 * t608 * t1591 * t1957 + 0.4e1 / 0.3e1 * t608 * t609 * t4370 * t1549 + 0.32e2 / 0.9e1 * t608 * t1940 * t1961 + 0.4e1 / 0.3e1 * t608 * t1970 * t819 * t1565 - 0.32e2 / 0.9e1 * t608 * t1591 * t1991 - 0.64e2 / 0.9e1 * t608 * t1862 * t1932 + 0.2e1 / 0.3e1 * t608 * t609 * t4388 * t242 + 0.4e1 / 0.3e1 * t608 * t778 * t639 * t1917 * t259 - 0.4e1 / 0.3e1 * t608 * t609 * t4398 * t641 - 0.64e2 / 0.9e1 * t608 * t1940 * t1948 - 0.32e2 / 0.9e1 * t608 * t1591 * t1976 + 0.4e1 / 0.3e1 * t608 * t786 * t4409 * t242 + 0.2e1 / 0.3e1 * t608 * t609 * t4414 * t259 + 0.2e1 / 0.9e1 * t608 * t609 * t792 * t1491 + 0.176e3 / 0.27e2 * t608 * t3662 * t820;
  t4451 = t588 * t96;
  t4473 = t1547 * t834;
  t4511 = -0.16e2 / 0.9e1 * t608 * t1591 * t1980 + 0.32e2 / 0.3e1 * t608 * t1862 * t1966 + 0.4e1 / 0.3e1 * t608 * t778 * t1931 * t657 + 0.4e1 / 0.9e1 * t608 * t778 * t824 * t1491 + 0.352e3 / 0.27e2 * t608 * t588 * t600 * t788 + 0.176e3 / 0.27e2 * t608 * t3662 * t793 - 0.32e2 / 0.9e1 * t608 * t1940 * t1952 + 0.352e3 / 0.27e2 * t608 * t4451 * t825 - 0.16e2 / 0.9e1 * t608 * t1591 * t1995 - 0.32e2 / 0.9e1 * t608 * t1862 * t1936 + 0.2e1 / 0.3e1 * t608 * t609 * t1990 * t633 + 0.2e1 / 0.9e1 * t608 * t609 * t819 * t1536 - 0.4e1 / 0.3e1 * t608 * t786 * t1990 * t602 - 0.4e1 * t608 * t778 * t4473 * t641 - 0.4e1 * t608 * t1970 * t1947 * t602 + 0.2e1 / 0.3e1 * t608 * t609 * t1975 * t657 + 0.4e1 / 0.3e1 * t608 * t786 * t1947 * t633 + 0.4e1 / 0.9e1 * t608 * t786 * t787 * t1536 - 0.176e3 / 0.27e2 * t36 * t589 * t812 - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (-0.2e1 * t1480 * t317 * t85 - 0.16e2 * t1910 * t97 - 0.8e2 / 0.3e1 * t829 * t84 - 0.16e3 / 0.27e2 * t318 * t1488);
  t4569 = t786 * t639;
  t4580 = t1940 * t248;
  t4584 = t1591 * t639;
  t4588 = t609 * t1547;
  t4598 = -0.4e1 / 0.3e1 * t36 * t1572 + 0.2e1 / 0.3e1 * t36 * t1585 + 0.4e1 / 0.3e1 * t36 * t1556 - 0.4e1 / 0.3e1 * t36 * t1543 + 0.16e2 / 0.9e1 * t36 * t224 * t1903 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-0.14e3 / 0.27e2 * t43 * t305 * t1512 * t92 - 0.364e3 / 0.9e1 * t43 * t1475 * t238 + 0.166e4 / 0.27e2 * t43 * t1522 * t629 * sigma[2] - 0.488e3 / 0.9e1 * t43 * t1528 * t1532 * t316 + 0.16e3 / 0.9e1 * t43 / t84 / t1520 / t987 * t3747 * t1003) + 0.16e2 / 0.9e1 * t36 * t224 * t1918 - 0.32e2 / 0.9e1 * t36 * t1592 + 0.4e1 / 0.3e1 * t36 * t1576 + 0.2e1 / 0.3e1 * t36 * t1581 - 0.176e3 / 0.27e2 * t36 * t589 * t835 + 0.2464e4 / 0.243e3 * t36 * t1476 * t313 + 0.2464e4 / 0.243e3 * t36 * t1476 * t322 + 0.8e1 / 0.3e1 * t608 * t4569 * t312 * t641 * t242 - 0.4e1 / 0.3e1 * t608 * t1870 * t312 * t259 * t657 + 0.64e2 / 0.9e1 * t608 * t4580 * t1878 + 0.64e2 / 0.9e1 * t608 * t4584 * t1872 + 0.4e1 * t608 * t4588 * t1871 * t641 - 0.8e1 / 0.3e1 * t608 * t1876 * t811 * t242 * t259;
  t4631 = t778 * t1547;
  t4632 = t321 * t259;
  t4637 = t1970 * t248;
  t4643 = t1970 * t106;
  t4680 = -0.4e1 / 0.3e1 * t608 * t1876 * t312 * t633 * t259 - 0.4e1 / 0.3e1 * t608 * t1876 * t1877 * t657 + 0.8e1 / 0.3e1 * t608 * t4569 * t321 * t602 * t259 - 0.4e1 / 0.3e1 * t608 * t1876 * t1871 * t633 - 0.8e1 / 0.3e1 * t608 * t1870 * t834 * t242 * t259 - 0.4e1 / 0.3e1 * t608 * t1870 * t321 * t633 * t259 - 0.4e1 / 0.3e1 * t608 * t1870 * t1871 * t657 - 0.4e1 * t608 * t4631 * t4632 * t657 + 0.4e1 * t608 * t4637 * t312 * t602 * t259 - 0.4e1 * t608 * t4643 * t1877 * t633 - 0.4e1 / 0.3e1 * t36 * t1970 * t106 * t1565 - 0.4e1 / 0.3e1 * t36 * t778 * t1547 * t1549 - 0.32e2 / 0.9e1 * t36 * t1940 * t1855 - 0.32e2 / 0.9e1 * t36 * t1862 * t1851 - 0.2e1 / 0.9e1 * t36 * t778 * t3652 - 0.176e3 / 0.27e2 * t36 * t3662 * t774 - 0.176e3 / 0.27e2 * t36 * t4451 * t779 + 0.16e2 / 0.9e1 * t36 * t1591 * t1843 + 0.16e2 / 0.9e1 * t36 * t1862 * t1847 - 0.2e1 / 0.9e1 * t36 * t609 * t3642;
  t4687 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t1459 * t326 - 0.3e1 / 0.8e1 * t4305 - 0.9e1 / 0.8e1 * t6 * t577 * t839 + t4270 / 0.4e1 - 0.3e1 / 0.4e1 * t4312 - 0.9e1 / 0.8e1 * t6 * t217 * t2000 - t4231 + t4281 / 0.4e1 - 0.3e1 / 0.8e1 * t4320 - 0.3e1 / 0.8e1 * t6 * t81 * (t4426 + t4511 + t4598 + t4680));
  tv4rho3sigma11 = t4687 * t7 + 0.3e1 * t2005;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t4694 = t2041 * t2014;
  t4695 = t846 * t2040;
  t4696 = t4695 * t863;
  t4697 = t4695 * t867;
  t4707 = t2008 * t858;
  t4714 = 0.12e2 * t859 * t860 * t2990 * t1163 - t4694 + t4696 + 0.2e1 * t4697 - 0.5e1 * t2030 * t2050 - 0.1e2 * t2030 * t2053 + 0.3e1 / 0.2e1 * t2030 * t2057 + 0.3e1 * t2030 * t2061 + 0.3e1 / 0.2e1 * t4707 * t863 + 0.3e1 * t4707 * t867 - 0.3e1 * t2030 * t2014;
  t4720 = t1177 * t161;
  t4725 = t2041 * t2022;
  t4743 = t2034 * t33;
  t4744 = t331 * t4743;
  t4745 = t4744 * t863;
  t4747 = t4744 * t867;
  t4749 = t2041 * t2050;
  t4751 = -0.9e1 * t2030 * t2022 + 0.5e1 * t859 * t273 * t2013 + 0.3e1 * t859 * t860 * t4720 * t1179 - 0.3e1 * t4725 + 0.15e2 * t859 * t273 * t2021 - 0.5e1 / 0.2e1 * t859 * t273 * t2056 - 0.5e1 * t859 * t273 * t2060 + t859 * t860 * t861 * t1131 / 0.2e1 + t859 * t860 * t439 * t1150 - t4745 / 0.3e1 - 0.2e1 / 0.3e1 * t4747 - 0.5e1 / 0.3e1 * t4749;
  t4753 = t2041 * t2053;
  t4755 = t2041 * t2057;
  t4757 = t2041 * t2061;
  t4768 = t1092 * params->beta;
  t4771 = 0.5e1 / 0.27e2 * t331 * t4768 * t336;
  t4772 = t2035 * t855;
  t4774 = t851 * t2047;
  t4777 = t846 * t2034 * t336;
  t4779 = t2025 * t855;
  t4783 = -0.1e2 / 0.3e1 * t4753 + t4755 / 0.2e1 + t4757 + 0.2e2 / 0.3e1 * t859 * t676 * t862 + 0.4e2 / 0.3e1 * t859 * t676 * t866 + 0.22e3 / 0.27e2 * t333 * t35 * t3921 * t161 - t4771 - 0.5e1 / 0.9e1 * t4772 - 0.2e2 / 0.9e1 * t4774 + t4777 / 0.3e1 + 0.5e1 / 0.3e1 * t4779 - 0.2e2 / 0.3e1 * t847 * t2047;
  t4785 = t2008 * t850 * t336;
  t4808 = t2041 * t2018;
  t4810 = t273 * t142;
  t4826 = -t4785 / 0.2e1 + 0.5e1 / 0.2e1 * t2009 * t855 - t5 * t1069 * t332 * t336 / 0.2e1 - 0.6e1 * t2030 * t2018 - 0.3e1 * t859 * t2016 * t3079 * t172 - 0.3e1 * t859 * t2016 * t1155 * t456 - 0.9e1 * t859 * t2510 * t1161 * t172 * t456 - 0.2e1 * t4808 + 0.1e2 * t859 * t4810 * t2017 + 0.9e1 * t859 * t2016 * t3005 * t440 + 0.6e1 * t859 * t2490 * t3037 * t172 - 0.3e1 * t859 * t2490 * t409 * t432;
  t4829 = my_piecewise3(t2, 0, t4714 + t4751 + t4783 + t4826);
  tv4rho3lapl0 = t4829 * t7 + 0.3e1 * t2064;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t4837 = t2067 * t850 * t344;
  t4840 = t872 * t2034 * t344;
  t4844 = 0.5e1 / 0.27e2 * t340 * t4768 * t344;
  t4846 = my_piecewise3(t72, 0, -t5 * t1245 * t332 * t344 / 0.2e1 - t4837 / 0.2e1 + t4840 / 0.3e1 - t4844);
  tv4rho3lapl1 = t4846 * t7 + 0.3e1 * t2078;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t4848 = 0.2e1 * t2098;
  t4854 = t2080 * t858;
  t4858 = t882 * t2040;
  t4860 = t4858 * t863 / 0.3e1;
  t4862 = 0.2e1 / 0.3e1 * t4858 * t867;
  t4874 = -t2089 * t2014 - 0.3e1 * t2089 * t2022 - t4694 / 0.3e1 + t2089 * t2061 + t4854 * t863 + 0.2e1 * t4854 * t867 + t4860 + t4862 - 0.5e1 / 0.3e1 * t2089 * t2050 - 0.1e2 / 0.3e1 * t2089 * t2053 + t2089 * t2057 / 0.2e1 + t4696 / 0.3e1 + 0.2e1 / 0.3e1 * t4697 - t4725 - 0.2e1 / 0.9e1 * t4745 - 0.4e1 / 0.9e1 * t4747 - 0.5e1 / 0.9e1 * t4749;
  t4880 = t2080 * t850 * t336 / 0.3e1;
  t4893 = t882 * t2034 * t336;
  t4896 = 0.5e1 / 0.9e1 * t2084 * t855;
  t4902 = -0.1e2 / 0.9e1 * t4753 + t4755 / 0.6e1 + t4757 / 0.3e1 - t4880 - t5 * t1283 * t332 * t336 / 0.2e1 - t4771 - 0.1e2 / 0.27e2 * t4772 - 0.2e2 / 0.27e2 * t4774 + 0.2e1 / 0.9e1 * t4777 + 0.5e1 / 0.9e1 * t4779 - t4785 / 0.6e1 + 0.5e1 / 0.3e1 * t2081 * t855 + t4893 / 0.9e1 + t4896 - 0.2e2 / 0.9e1 * t883 * t2047 - 0.2e1 * t2089 * t2018 - 0.2e1 / 0.3e1 * t4808;
  t4904 = my_piecewise3(t2, 0, t4874 + t4902);
  tv4rho3lapl2 = t4904 * t7 + t2064 + t4848;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t4906 = 0.2e1 * t2122;
  t4913 = t2100 * t850 * t344 / 0.3e1;
  t4915 = t889 * t2034 * t344;
  t4922 = 0.5e1 / 0.9e1 * t2071 * t894;
  t4923 = t2074 * t894;
  t4925 = t2067 * t858;
  t4928 = t872 * t2040;
  t4930 = t4928 * t901 / 0.3e1;
  t4931 = t340 * t4743;
  t4932 = t4931 * t901;
  t4936 = 0.2e1 / 0.3e1 * t4928 * t905;
  t4937 = t4931 * t905;
  t4939 = -t5 * t1326 * t332 * t344 / 0.2e1 - t4913 + t4915 / 0.9e1 - t4837 / 0.6e1 + 0.2e1 / 0.9e1 * t4840 - t4844 + 0.5e1 / 0.6e1 * t2068 * t894 + t4922 - 0.5e1 / 0.27e2 * t4923 + t4925 * t901 / 0.2e1 + t4930 - t4932 / 0.9e1 + t4925 * t905 + t4936 - 0.2e1 / 0.9e1 * t4937;
  t4940 = my_piecewise3(t72, 0, t4939);
  tv4rho3lapl3 = t4940 * t7 + t2078 + t4906;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t4947 = t2125 * t850 * t336;
  t4951 = t2125 * t858;
  t4960 = -t5 * t1367 * t332 * t336 / 0.2e1 - t4947 / 0.6e1 + 0.5e1 / 0.6e1 * t2126 * t855 + t4951 * t863 / 0.2e1 + t4951 * t867 - t4880 + 0.2e1 / 0.9e1 * t4893 + t4896 + t4860 + t4862 + t4777 / 0.9e1 - t4771 - 0.5e1 / 0.27e2 * t4772 - t4745 / 0.9e1 - 0.2e1 / 0.9e1 * t4747;
  t4961 = my_piecewise3(t2, 0, t4960);
  tv4rho3lapl4 = t4961 * t7 + t2131 + t4848;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t4965 = t2115 * t2173;
  t4966 = t889 * t2040;
  t4967 = t4966 * t905;
  t4969 = t2115 * t2165;
  t4971 = t2115 * t2145;
  t4973 = t2115 * t2149;
  t4975 = t4966 * t901;
  t4977 = t2115 * t2138;
  t4979 = t2115 * t2141;
  t4981 = t2100 * t858;
  t4993 = -0.5e1 / 0.3e1 * t2112 * t2138 - t4965 + 0.2e1 / 0.3e1 * t4967 - t4969 / 0.3e1 + t4971 / 0.6e1 + t4973 / 0.3e1 + t4975 / 0.3e1 - 0.5e1 / 0.9e1 * t4977 - 0.1e2 / 0.9e1 * t4979 + 0.2e1 * t4981 * t905 - t2112 * t2165 - 0.3e1 * t2112 * t2173 - 0.1e2 / 0.3e1 * t2112 * t2141 + t2112 * t2145 / 0.2e1 + t2112 * t2149 + t4981 * t901 + t4930;
  t4997 = t2159 * t850 * t344;
  t4999 = t2104 * t894;
  t5001 = t876 * t2135;
  t5014 = t2115 * t2169;
  t5018 = -0.2e1 / 0.9e1 * t4932 + t4936 - 0.4e1 / 0.9e1 * t4937 - t4997 / 0.6e1 + 0.5e1 / 0.9e1 * t4999 - 0.2e2 / 0.27e2 * t5001 - 0.2e2 / 0.9e1 * t873 * t2135 + 0.5e1 / 0.3e1 * t2101 * t894 - t5 * t1397 * t332 * t344 / 0.2e1 - t4913 + 0.2e1 / 0.9e1 * t4915 + t4922 - 0.1e2 / 0.27e2 * t4923 + t4840 / 0.9e1 - t4844 - 0.2e1 / 0.3e1 * t5014 - 0.2e1 * t2112 * t2169;
  t5020 = my_piecewise3(t72, 0, t4993 + t5018);
  tv4rho3lapl5 = t5020 * t7 + t2179 + t4906;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t5030 = my_piecewise3(t2, 0, -t5 * t1438 * t332 * t336 / 0.2e1 - t4947 / 0.2e1 + t4893 / 0.3e1 - t4771);
  tv4rho3lapl6 = t5030 * t7 + 0.3e1 * t2131;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t5054 = t1563 * t248;
  t5067 = t897 * t898 * t899 * t1536 / 0.2e1 + 0.3e1 * t2153 * t2149 + t897 * t898 * t640 * t1491 + 0.2e2 / 0.3e1 * t897 * t770 * t900 + 0.4e2 / 0.3e1 * t897 * t770 * t904 + 0.5e1 * t897 * t302 * t2164 + 0.15e2 * t897 * t302 * t2172 + 0.3e1 * t897 * t898 * t5054 * t1565 + 0.12e2 * t897 * t898 * t3699 * t1549 - 0.3e1 * t2153 * t2165 - 0.9e1 * t2153 * t2173;
  t5068 = t2159 * t858;
  t5088 = 0.3e1 / 0.2e1 * t5068 * t901 + 0.3e1 * t5068 * t905 - 0.5e1 * t2153 * t2138 - 0.5e1 / 0.2e1 * t897 * t302 * t2144 - 0.1e2 * t2153 * t2141 - 0.5e1 * t897 * t302 * t2148 + 0.3e1 / 0.2e1 * t2153 * t2145 - 0.3e1 * t4965 + 0.2e1 * t4967 - t4969 + t4971 / 0.2e1 + t4973;
  t5109 = t4975 - 0.5e1 / 0.3e1 * t4977 - 0.1e2 / 0.3e1 * t4979 - t4932 / 0.3e1 - 0.2e1 / 0.3e1 * t4937 - 0.2e2 / 0.3e1 * t890 * t2135 + 0.5e1 / 0.2e1 * t2160 * t894 - t5 * t1458 * t332 * t344 / 0.2e1 - t4997 / 0.2e1 + 0.5e1 / 0.3e1 * t4999 - 0.2e2 / 0.9e1 * t5001 + 0.22e3 / 0.27e2 * t341 * t35 * t4451 * t248;
  t5116 = t302 * t229;
  t5145 = t4915 / 0.3e1 - 0.5e1 / 0.9e1 * t4923 - t4844 + 0.9e1 * t897 * t2167 * t3614 * t641 + 0.1e2 * t897 * t5116 * t2168 - 0.3e1 * t897 * t2542 * t1579 * t242 - 0.3e1 * t897 * t2167 * t3683 * t259 - 0.2e1 * t5014 + 0.6e1 * t897 * t2542 * t3609 * t259 - 0.3e1 * t897 * t2167 * t639 * t657 * t242 - 0.9e1 * t897 * t2560 * t1547 * t657 * t259 - 0.6e1 * t2153 * t2169;
  t5148 = my_piecewise3(t72, 0, t5067 + t5088 + t5109 + t5145);
  tv4rho3lapl7 = t5148 * t7 + 0.3e1 * t2179;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t5155 = t6 * t369 * t959;
  t5162 = t6 * t378 * t959 / 0.12e2;
  t5164 = t6 * t130 * t2319;
  t5174 = t62 * t2254;
  t5183 = t161 * t2254;
  t5208 = t438 * t916;
  t5213 = 0.32e2 / 0.9e1 * t272 * t34 * sigma[0] * t41 * t399 * t438 * t283 * t1648 + 0.8e1 / 0.9e1 * t407 * t692 * t5174 * t155 + 0.4e1 / 0.9e1 * t407 * t692 * t2262 * t432 + 0.4e1 / 0.9e1 * t407 * t408 * t5183 * t172 + 0.2e1 / 0.9e1 * t407 * t408 * t2267 * t456 + 0.64e2 / 0.27e2 * t407 * t1205 * t2273 + 0.64e2 / 0.9e1 * t407 * t1630 * t2278 - 0.128e3 / 0.27e2 * t407 * t1630 * t2282 - 0.4e1 / 0.9e1 * t407 * t408 * t2272 * t432 - 0.64e2 / 0.27e2 * t407 * t1711 * t2263 + 0.8e1 / 0.9e1 * t407 * t692 * t5208 * t440;
  t5221 = t1161 * t954;
  t5234 = t2989 * t944;
  t5243 = t438 * t939;
  t5259 = -0.64e2 / 0.27e2 * t407 * t1205 * t2310 - 0.4e1 / 0.9e1 * t407 * t692 * t2286 * t401 - 0.4e1 / 0.3e1 * t407 * t684 * t5221 * t440 + 0.16e2 / 0.3e1 * t407 * t4005 * t2296 * t401 + 0.8e1 / 0.9e1 * t407 * t692 * t2272 * t401 + 0.16e2 / 0.3e1 * t407 * t684 * t5234 * t440 - 0.4e1 / 0.3e1 * t407 * t1658 * t2262 * t401 - 0.4e1 / 0.9e1 * t407 * t408 * t5243 * t440 - 0.4e1 / 0.3e1 * t407 * t684 * t2277 * t456 + 0.8e1 / 0.9e1 * t407 * t684 * t730 * t1762 - 0.32e2 / 0.27e2 * t407 * t1205 * t2287;
  t5264 = t161 * t2225;
  t5286 = t30 * t35 * t41;
  t5287 = t142 * t438;
  t5304 = -0.64e2 / 0.27e2 * t407 * t1630 * t2292 + 0.4e1 / 0.9e1 * t407 * t408 * t5264 * t155 + 0.2e1 / 0.9e1 * t407 * t408 * t2286 * t432 + 0.8e1 / 0.9e1 * t407 * t684 * t438 * t2225 * t172 + 0.4e1 / 0.9e1 * t407 * t684 * t2291 * t456 - 0.32e2 / 0.27e2 * t407 * t1205 * t2268 - 0.16e2 / 0.9e1 * t5286 * t5287 * t1648 + 0.4e1 / 0.9e1 * t407 * t408 * t698 * t1762 - 0.16e2 / 0.9e1 * t5286 * t2012 * t1654 + 0.64e2 / 0.9e1 * t407 * t4001 * t2297 + 0.64e2 / 0.27e2 * t407 * t1711 * t2302;
  t5343 = -0.128e3 / 0.27e2 * t407 * t1711 * t2306 - 0.4e1 / 0.3e1 * t407 * t1658 * t2296 * t432 - 0.4e1 / 0.9e1 * t407 * t692 * t2301 * t456 + 0.8e1 / 0.9e1 * t407 * t692 * t693 * t1747 + 0.4e1 / 0.9e1 * t407 * t408 * t3891 * t292 + 0.8e1 / 0.9e1 * t407 * t408 * t1696 * t740 - 0.64e2 / 0.27e2 * t407 * t1205 * t2314 + 0.352e3 / 0.81e2 * t407 * t3018 * t921 + 0.8e1 / 0.9e1 * t36 * t1698 - 0.176e3 / 0.81e2 * t36 * t388 * t940 + 0.4e1 / 0.9e1 * t36 * t1674 + 0.8e1 / 0.9e1 * t36 * t1683;
  t5401 = -0.2e1 / 0.9e1 * t36 * t42 * t143 * (-0.7e1 / 0.9e1 * t43 * t926 * t415 * t48 + 0.7e1 / 0.9e1 * t43 * t57 * t387 * t151 - 0.11e2 * t43 * t1737 + 0.47e2 / 0.3e1 * t43 * t1743 * sigma[0] - 0.2e2 / 0.3e1 * t43 / t39 / t2916 * t2928 * t287) + 0.8e1 / 0.9e1 * t36 * t1670 + 0.16e2 / 0.9e1 * t36 * t1679 - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (0.4e1 * t448 * t950 * t40 + 0.64e2 / 0.3e1 * t2220 * t53 + 0.16e3 / 0.9e1 * t951 * t39) - 0.128e3 / 0.27e2 * t36 * t1712 - 0.64e2 / 0.27e2 * t36 * t1715 + 0.8e1 / 0.9e1 * t36 * t1693 + 0.4e1 / 0.9e1 * t36 * t1702 - 0.64e2 / 0.27e2 * t36 * t1705 - 0.128e3 / 0.27e2 * t36 * t1708 + 0.32e2 / 0.27e2 * t36 * t137 * t2255;
  t5418 = t717 * t717;
  t5423 = t740 * t740;
  t5438 = 0.32e2 / 0.27e2 * t36 * t137 * t2226 + 0.16e2 / 0.9e1 * t36 * t1688 - 0.8e1 / 0.9e1 * t36 * t1665 - 0.8e1 / 0.9e1 * t36 * t1719 - 0.8e1 / 0.3e1 * t36 * t1724 - 0.8e1 / 0.3e1 * t36 * t1660 + 0.352e3 / 0.81e2 * t36 * t388 * t917 + 0.8e1 / 0.9e1 * t36 * t42 * t400 * t5418 + 0.8e1 / 0.9e1 * t36 * t42 * t439 * t5423 - 0.176e3 / 0.81e2 * t36 * t388 * t955 + 0.352e3 / 0.81e2 * t36 * t388 * t945 + 0.8e1 / 0.3e1 * t407 * t4110 * t2199 * t440;
  t5455 = t717 * t292;
  t5487 = 0.8e1 / 0.3e1 * t407 * t4130 * t2199 * t401 + 0.128e3 / 0.27e2 * t407 * t4106 * t2204 - 0.16e2 / 0.3e1 * t407 * t4136 * t1653 * t717 - 0.16e2 / 0.9e1 * t407 * t1652 * t4155 * t717 - 0.16e2 / 0.9e1 * t407 * t1652 * t5455 * t155 - 0.16e2 / 0.9e1 * t407 * t1646 * t5455 * t172 - 0.8e1 / 0.9e1 * t407 * t1646 * t954 * t155 * t172 + 0.8e1 / 0.3e1 * t407 * t4130 * t916 * t155 * t172 + 0.8e1 / 0.3e1 * t407 * t4110 * t944 * t155 * t172 - 0.16e2 / 0.9e1 * t407 * t1646 * t1647 * t740 - 0.16e2 / 0.3e1 * t407 * t4123 * t4124 * t740;
  t5501 = t283 * t740;
  t5531 = -0.8e1 / 0.9e1 * t407 * t1652 * t939 * t155 * t172 - 0.8e1 / 0.9e1 * t407 * t1652 * t2199 * t432 - 0.8e1 / 0.9e1 * t407 * t1646 * t2199 * t456 - 0.16e2 / 0.9e1 * t407 * t1652 * t5501 * t155 - 0.16e2 / 0.9e1 * t407 * t1646 * t5501 * t172 + 0.128e3 / 0.27e2 * t407 * t4115 * t2200 - 0.4e1 / 0.9e1 * t36 * t684 * t3902 - 0.4e1 / 0.9e1 * t36 * t408 * t3968 - 0.352e3 / 0.81e2 * t36 * t3018 * t693 - 0.352e3 / 0.81e2 * t36 * t3921 * t725 + 0.64e2 / 0.27e2 * t36 * t1205 * t1686 + 0.64e2 / 0.27e2 * t36 * t1630 * t1668;
  t5539 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t365 * t959 - t5155 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t124 * t2319 + t5162 - t5164 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t5213 + t5259 + t5304 + t5343 + t5401 + t5438 + t5487 + t5531));
  tv4rho2sigma20 = t5539 * t7 + 0.2e1 * t2324;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t5546 = t6 * t484 * t1013;
  t5550 = t6 * t488 * t1013 / 0.12e2;
  t5552 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t480 * t1013 - t5546 / 0.4e1 + t5550);
  tv4rho2sigma25 = t5552 * t7 + 0.2e1 * t2333;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t5558 = t6 * t509 * t959;
  t5566 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t505 * t959 - t5558 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t206 * t2319 - t5155 / 0.8e1 + t5162 - t5164 / 0.8e1);
  tv4rho2sigma26 = t5566 * t7 + t2324 + t2339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t5572 = t6 * t533 * t1013;
  t5579 = t6 * t193 * t2476;
  t5582 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t529 * t1013 - t5572 / 0.8e1 - t5546 / 0.8e1 + t5550 - 0.3e1 / 0.8e1 * t6 * t189 * t2476 - t5579 / 0.8e1);
  tv4rho2sigma211 = t5582 * t7 + t2333 + t2481;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t5590 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t560 * t959 - t5558 / 0.4e1 + t5162);
  tv4rho2sigma212 = t5590 * t7 + 0.2e1 * t2339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t5629 = t639 * t970;
  t5638 = t3698 * t998;
  t5650 = 0.32e2 / 0.9e1 * t272 * t34 * sigma[2] * t86 * t600 * t639 * t312 * t1872 + 0.8e1 / 0.9e1 * t608 * t778 * t639 * t2406 * t259 + 0.4e1 / 0.9e1 * t608 * t778 * t2438 * t657 + 0.352e3 / 0.81e2 * t608 * t3662 * t975 - 0.4e1 / 0.9e1 * t608 * t786 * t2420 * t602 + 0.16e2 / 0.3e1 * t608 * t4362 * t2425 * t602 + 0.8e1 / 0.9e1 * t608 * t786 * t5629 * t641 + 0.8e1 / 0.9e1 * t608 * t786 * t2465 * t602 + 0.16e2 / 0.3e1 * t608 * t778 * t5638 * t641 - 0.64e2 / 0.27e2 * t608 * t1591 * t2451 - 0.4e1 / 0.3e1 * t608 * t1970 * t2455 * t602;
  t5651 = t639 * t993;
  t5659 = t1547 * t1008;
  t5691 = -0.4e1 / 0.9e1 * t608 * t609 * t5651 * t641 - 0.64e2 / 0.27e2 * t608 * t1862 * t2439 - 0.4e1 / 0.3e1 * t608 * t778 * t5659 * t641 - 0.128e3 / 0.27e2 * t608 * t1940 * t2443 - 0.64e2 / 0.27e2 * t608 * t1591 * t2447 + 0.2e1 / 0.9e1 * t608 * t609 * t2460 * t657 + 0.64e2 / 0.27e2 * t608 * t1591 * t2466 + 0.64e2 / 0.9e1 * t608 * t1862 * t2471 - 0.128e3 / 0.27e2 * t608 * t1862 * t2416 - 0.4e1 / 0.9e1 * t608 * t609 * t2465 * t633 - 0.4e1 / 0.3e1 * t608 * t778 * t2470 * t657;
  t5719 = t106 * t2396;
  t5729 = t30 * t35 * t86;
  t5737 = 0.8e1 / 0.9e1 * t608 * t778 * t824 * t1917 + 0.8e1 / 0.9e1 * t608 * t786 * t787 * t1902 + 0.4e1 / 0.9e1 * t608 * t609 * t4414 * t321 + 0.8e1 / 0.9e1 * t608 * t609 * t1975 * t834 + 0.4e1 / 0.9e1 * t608 * t609 * t792 * t1917 - 0.64e2 / 0.27e2 * t608 * t1940 * t2456 - 0.32e2 / 0.27e2 * t608 * t1591 * t2461 + 0.8e1 / 0.9e1 * t608 * t786 * t5719 * t242 + 0.4e1 / 0.9e1 * t608 * t786 * t2455 * t633 - 0.16e2 / 0.9e1 * t5729 * t2163 * t1878 - 0.4e1 / 0.9e1 * t608 * t786 * t2430 * t657;
  t5738 = t229 * t639;
  t5745 = t248 * t2406;
  t5764 = t248 * t2396;
  t5810 = -0.16e2 / 0.9e1 * t5729 * t5738 * t1872 - 0.32e2 / 0.27e2 * t608 * t1591 * t2421 + 0.4e1 / 0.9e1 * t608 * t609 * t5745 * t242 + 0.2e1 / 0.9e1 * t608 * t609 * t2420 * t633 + 0.64e2 / 0.9e1 * t608 * t4358 * t2426 + 0.64e2 / 0.27e2 * t608 * t1940 * t2431 - 0.4e1 / 0.3e1 * t608 * t1970 * t2425 * t633 + 0.4e1 / 0.9e1 * t608 * t609 * t5764 * t259 - 0.176e3 / 0.81e2 * t36 * t589 * t994 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-0.7e1 / 0.9e1 * t43 * t980 * t616 * t92 + 0.7e1 / 0.9e1 * t43 * t101 * t588 * t238 - 0.11e2 * t43 * t1892 + 0.47e2 / 0.3e1 * t43 * t1898 * sigma[2] - 0.2e2 / 0.3e1 * t43 / t84 / t3735 * t3747 * t316) - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (0.4e1 * t649 * t1004 * t85 + 0.64e2 / 0.3e1 * t2401 * t97 + 0.16e3 / 0.9e1 * t1005 * t84) - 0.128e3 / 0.27e2 * t36 * t1941;
  t5835 = -0.64e2 / 0.27e2 * t36 * t1944 + 0.8e1 / 0.9e1 * t36 * t1953 + 0.4e1 / 0.9e1 * t36 * t1981 + 0.16e2 / 0.9e1 * t36 * t1949 + 0.8e1 / 0.9e1 * t36 * t1977 + 0.8e1 / 0.9e1 * t36 * t1992 + 0.16e2 / 0.9e1 * t36 * t1933 - 0.64e2 / 0.27e2 * t36 * t1984 - 0.128e3 / 0.27e2 * t36 * t1987 + 0.4e1 / 0.9e1 * t36 * t1996 + 0.8e1 / 0.9e1 * t36 * t1937;
  t5859 = t834 * t834;
  t5864 = t811 * t811;
  t5869 = t312 * t811;
  t5874 = 0.32e2 / 0.27e2 * t36 * t224 * t2397 + 0.32e2 / 0.27e2 * t36 * t224 * t2407 - 0.8e1 / 0.3e1 * t36 * t1972 - 0.8e1 / 0.9e1 * t36 * t1958 - 0.8e1 / 0.9e1 * t36 * t1962 - 0.8e1 / 0.3e1 * t36 * t1967 - 0.176e3 / 0.81e2 * t36 * t589 * t1009 + 0.352e3 / 0.81e2 * t36 * t589 * t971 + 0.352e3 / 0.81e2 * t36 * t589 * t999 + 0.8e1 / 0.9e1 * t36 * t87 * t640 * t5859 + 0.8e1 / 0.9e1 * t36 * t87 * t601 * t5864 - 0.16e2 / 0.9e1 * t608 * t1876 * t5869 * t259;
  t5876 = t811 * t321;
  t5911 = t312 * t834;
  t5925 = -0.16e2 / 0.9e1 * t608 * t1876 * t5876 * t242 - 0.16e2 / 0.9e1 * t608 * t1870 * t5876 * t259 + 0.8e1 / 0.3e1 * t608 * t4637 * t2356 * t602 + 0.8e1 / 0.3e1 * t608 * t4588 * t2356 * t641 + 0.8e1 / 0.3e1 * t608 * t4637 * t970 * t242 * t259 + 0.8e1 / 0.3e1 * t608 * t4588 * t998 * t242 * t259 - 0.16e2 / 0.9e1 * t608 * t1870 * t1871 * t834 - 0.16e2 / 0.3e1 * t608 * t4631 * t4632 * t834 - 0.16e2 / 0.9e1 * t608 * t1876 * t5911 * t242 - 0.16e2 / 0.9e1 * t608 * t1870 * t5911 * t259 - 0.8e1 / 0.9e1 * t608 * t1876 * t993 * t242 * t259;
  t5967 = -0.8e1 / 0.9e1 * t608 * t1870 * t1008 * t259 * t242 - 0.16e2 / 0.3e1 * t608 * t4643 * t5869 * t242 - 0.8e1 / 0.9e1 * t608 * t1870 * t2356 * t657 + 0.128e3 / 0.27e2 * t608 * t4580 * t2357 + 0.128e3 / 0.27e2 * t608 * t4584 * t2361 - 0.8e1 / 0.9e1 * t608 * t1876 * t2356 * t633 - 0.4e1 / 0.9e1 * t36 * t609 * t4409 - 0.4e1 / 0.9e1 * t36 * t778 * t4388 - 0.352e3 / 0.81e2 * t36 * t3662 * t787 + 0.64e2 / 0.27e2 * t36 * t1591 * t1947 + 0.64e2 / 0.27e2 * t36 * t1862 * t1990 - 0.352e3 / 0.81e2 * t36 * t4451 * t819;
  t5975 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t577 * t1013 - t5572 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t217 * t2476 + t5550 - t5579 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * (t5650 + t5691 + t5737 + t5810 + t5835 + t5874 + t5925 + t5967));
  tv4rho2sigma217 = t5975 * t7 + 0.2e1 * t2481;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t5980 = params->beta * t33 * t34;
  t5981 = t331 * t27 * t5980;
  t5983 = t54 * t142 * t1161;
  t5988 = t54 * t399 * t438;
  t5992 = t2041 * t2487;
  t5997 = t2041 * t2498;
  t6007 = t4695 * t1023;
  t6011 = 0.6e1 * t5981 * t5983 * t1648 + 0.4e1 * t5981 * t5988 * t1654 - 0.5e1 / 0.9e1 * t5992 + t4707 * t1019 / 0.2e1 + t2030 * t2498 + t5997 / 0.3e1 - 0.5e1 / 0.3e1 * t859 * t273 * t2497 + t859 * t860 * t861 * t1747 / 0.2e1 + t4707 * t1023 + 0.2e1 / 0.3e1 * t6007 - 0.1e2 / 0.3e1 * t2030 * t2504;
  t6013 = 0.2e1 / 0.9e1 * t4744 * t1023;
  t6014 = t2041 * t2504;
  t6022 = t4695 * t1019;
  t6027 = t4744 * t1019 / 0.9e1;
  t6030 = t2041 * t2516;
  t6038 = t2041 * t2492;
  t6040 = -t6013 - 0.1e2 / 0.9e1 * t6014 + 0.4e2 / 0.9e1 * t859 * t676 * t1022 + 0.2e2 / 0.9e1 * t859 * t676 * t1018 + t6022 / 0.3e1 - 0.5e1 / 0.3e1 * t2030 * t2487 - t6027 + 0.2e1 * t2030 * t2516 + 0.2e1 / 0.3e1 * t6030 - 0.1e2 / 0.3e1 * t859 * t273 * t2515 + t859 * t860 * t439 * t1762 - 0.2e1 / 0.3e1 * t6038;
  t6042 = t2041 * t2495;
  t6052 = t860 * t1177;
  t6065 = t2041 * t2508;
  t6067 = t2041 * t2512;
  t6076 = -0.2e1 / 0.3e1 * t6042 + 0.2e1 * t859 * t2490 * t730 * t401 + 0.12e2 * t859 * t2510 * t3996 * t440 + 0.3e1 * t859 * t6052 * t698 * t401 + 0.3e1 * t859 * t2016 * t3985 * t440 - 0.2e1 * t2030 * t2508 - 0.6e1 * t2030 * t2512 - 0.2e1 / 0.3e1 * t6065 - 0.2e1 * t6067 + 0.1e2 / 0.3e1 * t859 * t4810 * t2507 + 0.1e2 / 0.3e1 * t859 * t273 * t399 * t2491;
  t6117 = 0.1e2 / 0.3e1 * t859 * t4810 * t2494 - 0.2e1 * t859 * t2490 * t1696 * t155 - t859 * t2490 * t698 * t432 - 0.2e1 * t859 * t2016 * t3959 * t172 - t859 * t2016 * t1663 * t456 - 0.2e1 * t2030 * t2492 - 0.2e1 * t2030 * t2495 + 0.1e2 * t859 * t273 * t52 * t2511 - 0.2e1 * t859 * t2016 * t1677 * t155 - t859 * t2016 * t730 * t432 - 0.6e1 * t859 * t2510 * t3949 * t172 - 0.3e1 * t859 * t2510 * t1722 * t456;
  t6120 = my_piecewise3(t2, 0, t6011 + t6040 + t6076 + t6117);
  tv4rho2sigmalapl0 = t6120 * t7 + 0.2e1 * t2519;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t6125 = t4928 * t1028;
  t6128 = t4931 * t1028 / 0.9e1;
  t6130 = t4928 * t1032;
  t6133 = 0.2e1 / 0.9e1 * t4931 * t1032;
  t6135 = my_piecewise3(t72, 0, t4925 * t1028 / 0.2e1 + t6125 / 0.3e1 - t6128 + t4925 * t1032 + 0.2e1 / 0.3e1 * t6130 - t6133);
  tv4rho2sigmalapl5 = t6135 * t7 + 0.2e1 * t2529;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t6139 = t4858 * t1019;
  t6152 = t4854 * t1019 / 0.2e1 + t6139 / 0.6e1 - 0.5e1 / 0.6e1 * t2089 * t2487 - t2089 * t2492 - t2089 * t2495 + t2089 * t2498 / 0.2e1 + t6022 / 0.6e1 - t6027 - 0.5e1 / 0.18e2 * t5992 - t6038 / 0.3e1 - t6042 / 0.3e1 + t5997 / 0.6e1;
  t6154 = t4858 * t1023;
  t6166 = t4854 * t1023 + t6154 / 0.3e1 - 0.5e1 / 0.3e1 * t2089 * t2504 - t2089 * t2508 - 0.3e1 * t2089 * t2512 + t2089 * t2516 + t6007 / 0.3e1 - t6013 - 0.5e1 / 0.9e1 * t6014 - t6065 / 0.3e1 - t6067 + t6030 / 0.3e1;
  t6168 = my_piecewise3(t2, 0, t6152 + t6166);
  tv4rho2sigmalapl6 = t6168 * t7 + t2519 + t2535;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t6172 = t4966 * t1028;
  t6177 = t2115 * t2539;
  t6180 = t2115 * t2544;
  t6183 = t2115 * t2547;
  t6187 = t2115 * t2550;
  t6189 = t4981 * t1028 / 0.2e1 + t6172 / 0.6e1 + t6125 / 0.6e1 - t6128 - 0.5e1 / 0.6e1 * t2112 * t2539 - 0.5e1 / 0.18e2 * t6177 - t2112 * t2544 - t6180 / 0.3e1 - t2112 * t2547 - t6183 / 0.3e1 + t2112 * t2550 / 0.2e1 + t6187 / 0.6e1;
  t6191 = t4966 * t1032;
  t6196 = t2115 * t2554;
  t6199 = t2115 * t2558;
  t6203 = t2115 * t2562;
  t6205 = t2115 * t2566;
  t6207 = t4981 * t1032 + t6191 / 0.3e1 + t6130 / 0.3e1 - t6133 - 0.5e1 / 0.3e1 * t2112 * t2554 - 0.5e1 / 0.9e1 * t6196 - t2112 * t2558 - t6199 / 0.3e1 - 0.3e1 * t2112 * t2562 - t6203 + t2112 * t2566 + t6205 / 0.3e1;
  t6209 = my_piecewise3(t72, 0, t6189 + t6207);
  tv4rho2sigmalapl11 = t6209 * t7 + t2529 + t2569;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t6218 = my_piecewise3(t2, 0, t4951 * t1019 / 0.2e1 + t6139 / 0.3e1 - t6027 + t4951 * t1023 + 0.2e1 / 0.3e1 * t6154 - t6013);
  tv4rho2sigmalapl12 = t6218 * t7 + 0.2e1 * t2535;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t6222 = t340 * t27 * t5980;
  t6224 = t98 * t600 * t639;
  t6229 = t98 * t229 * t1547;
  t6254 = 0.4e1 * t6222 * t6224 * t1878 + 0.6e1 * t6222 * t6229 * t1872 - 0.5e1 / 0.3e1 * t2153 * t2539 - 0.5e1 / 0.3e1 * t897 * t302 * t2549 + t897 * t898 * t899 * t1902 / 0.2e1 + t5068 * t1032 + 0.2e1 * t2153 * t2566 - 0.1e2 / 0.3e1 * t897 * t302 * t2565 + t897 * t898 * t640 * t1917 + t5068 * t1028 / 0.2e1 + t2153 * t2550;
  t6273 = -0.1e2 / 0.9e1 * t6196 + 0.2e1 / 0.3e1 * t6205 - 0.1e2 / 0.3e1 * t2153 * t2554 + 0.4e2 / 0.9e1 * t897 * t770 * t1031 + 0.2e2 / 0.9e1 * t897 * t770 * t1027 + t6172 / 0.3e1 - 0.5e1 / 0.9e1 * t6177 + t6187 / 0.3e1 + 0.2e1 / 0.3e1 * t6191 - t6128 - t6133 + 0.2e1 * t897 * t2542 * t824 * t602;
  t6279 = t898 * t1563;
  t6313 = 0.12e2 * t897 * t2560 * t4353 * t641 + 0.3e1 * t897 * t6279 * t792 * t602 + 0.3e1 * t897 * t2167 * t4370 * t641 + 0.1e2 / 0.3e1 * t897 * t5116 * t2546 - 0.2e1 * t897 * t2542 * t1975 * t242 - t897 * t2542 * t792 * t633 - 0.2e1 * t897 * t2167 * t4398 * t259 - t897 * t2167 * t1956 * t657 - 0.2e1 * t2153 * t2544 - 0.2e1 * t2153 * t2547 + 0.1e2 * t897 * t302 * t96 * t2561;
  t6344 = -0.2e1 * t897 * t2167 * t1931 * t242 - t897 * t2167 * t824 * t633 - 0.6e1 * t897 * t2560 * t4473 * t259 - 0.3e1 * t897 * t2560 * t1965 * t657 - 0.2e1 * t2153 * t2558 - 0.6e1 * t2153 * t2562 + 0.1e2 / 0.3e1 * t897 * t5116 * t2557 + 0.1e2 / 0.3e1 * t897 * t302 * t600 * t2543 - 0.2e1 / 0.3e1 * t6180 - 0.2e1 / 0.3e1 * t6183 - 0.2e1 / 0.3e1 * t6199 - 0.2e1 * t6203;
  t6347 = my_piecewise3(t72, 0, t6254 + t6273 + t6313 + t6344);
  tv4rho2sigmalapl17 = t6347 * t7 + 0.2e1 * t2569;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t6350 = t2041 * t2575;
  t6352 = t2041 * t2581;
  t6354 = t2041 * t2587;
  t6373 = t4695 * t1039;
  t6382 = 0.4e1 / 0.9e1 * t4744 * t1039;
  t6385 = t1037 * t399;
  t6391 = t1036 * t142 * t1161;
  t6397 = t2989 * t57;
  t6402 = 0.8e1 / 0.9e1 * t6350 + 0.4e1 / 0.3e1 * t6352 + 0.4e1 * t6354 - 0.2e2 / 0.9e1 * t859 * t273 * t1038 - 0.8e1 / 0.3e1 * t859 * t2016 * t2580 - 0.8e1 * t859 * t2510 * t2586 + 0.2e1 * t859 * t2578 * t2579 * t432 + 0.6e1 * t859 * t2584 * t2585 * t456 - 0.4e1 / 0.3e1 * t6373 + 0.8e1 / 0.3e1 * t2030 * t2575 + 0.4e1 * t2030 * t2581 + 0.12e2 * t2030 * t2587 + t6382 - 0.2e1 * t4707 * t1039 - 0.4e1 * t859 * t6385 * t2579 * t401 - 0.12e2 * t5981 * t6391 * t57 * t155 * t172 - 0.24e2 * t859 * t2584 * t6397 * t440;
  t6403 = my_piecewise3(t2, 0, t6402);
  tv4rho2lapl20 = t6403 * t7 + 0.2e1 * t2591;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t6408 = t4928 * t1046;
  t6411 = 0.4e1 / 0.9e1 * t4931 * t1046;
  t6413 = my_piecewise3(t72, 0, -0.2e1 * t4925 * t1046 - 0.4e1 / 0.3e1 * t6408 + t6411);
  tv4rho2lapl22 = t6413 * t7 + 0.2e1 * t2598;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t6417 = t4858 * t1039;
  t6430 = my_piecewise3(t2, 0, -0.2e1 * t4854 * t1039 - 0.2e1 / 0.3e1 * t6417 + 0.4e1 / 0.3e1 * t2089 * t2575 + 0.2e1 * t2089 * t2581 + 0.6e1 * t2089 * t2587 - 0.2e1 / 0.3e1 * t6373 + t6382 + 0.4e1 / 0.9e1 * t6350 + 0.2e1 / 0.3e1 * t6352 + 0.2e1 * t6354);
  tv4rho2lapl23 = t6430 * t7 + t2591 + t2603;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t6434 = t4966 * t1046;
  t6439 = t2115 * t2607;
  t6443 = t2115 * t2613;
  t6447 = t2115 * t2619;
  t6450 = my_piecewise3(t72, 0, -0.2e1 * t4981 * t1046 - 0.2e1 / 0.3e1 * t6434 - 0.2e1 / 0.3e1 * t6408 + t6411 + 0.4e1 / 0.3e1 * t2112 * t2607 + 0.4e1 / 0.9e1 * t6439 + 0.2e1 * t2112 * t2613 + 0.2e1 / 0.3e1 * t6443 + 0.6e1 * t2112 * t2619 + 0.2e1 * t6447);
  tv4rho2lapl25 = t6450 * t7 + t2598 + t2623;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t6457 = my_piecewise3(t2, 0, -0.2e1 * t4951 * t1039 - 0.4e1 / 0.3e1 * t6417 + t6382);
  tv4rho2lapl26 = t6457 * t7 + 0.2e1 * t2603;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t6487 = t1044 * t600;
  t6493 = t1043 * t229 * t1547;
  t6499 = t3698 * t101;
  t6506 = 0.6e1 * t897 * t2616 * t2617 * t657 - 0.2e2 / 0.9e1 * t897 * t302 * t1045 - 0.8e1 / 0.3e1 * t897 * t2167 * t2612 - 0.8e1 * t897 * t2560 * t2618 + 0.2e1 * t897 * t2610 * t2611 * t633 + 0.8e1 / 0.3e1 * t2153 * t2607 + 0.4e1 * t2153 * t2613 + 0.12e2 * t2153 * t2619 - 0.4e1 / 0.3e1 * t6434 + 0.8e1 / 0.9e1 * t6439 + t6411 - 0.2e1 * t5068 * t1046 - 0.4e1 * t897 * t6487 * t2611 * t602 - 0.12e2 * t6222 * t6493 * t101 * t242 * t259 - 0.24e2 * t897 * t2616 * t6499 * t641 + 0.4e1 / 0.3e1 * t6443 + 0.4e1 * t6447;
  t6507 = my_piecewise3(t72, 0, t6506);
  tv4rho2lapl28 = t6507 * t7 + 0.2e1 * t2623;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t6514 = t6 * t130 * t2706 / 0.8e1;
  t6521 = t62 * t2671;
  t6526 = t161 * t2671;
  t6566 = t62 * t2701;
  t6571 = t161 * t2701;
  t6576 = -0.8e1 / 0.3e1 * t5286 * t2012 * t2200 - 0.8e1 / 0.3e1 * t5286 * t5287 * t2204 + 0.4e1 / 0.9e1 * t407 * t692 * t6521 * t155 + 0.2e1 / 0.9e1 * t407 * t408 * t6526 * t172 - 0.32e2 / 0.9e1 * t407 * t1630 * t2697 - 0.32e2 / 0.9e1 * t407 * t1711 * t2680 - 0.16e2 / 0.9e1 * t407 * t1205 * t2684 - 0.16e2 / 0.9e1 * t407 * t1205 * t2688 + 0.32e2 / 0.9e1 * t407 * t1205 * t2631 + 0.32e2 / 0.9e1 * t407 * t1711 * t2676 + 0.16e2 / 0.3e1 * t407 * t684 * t2989 * t2692 * t172 - 0.4e1 * t407 * t684 * t2277 * t740 + 0.4e1 / 0.3e1 * t407 * t684 * t1677 * t954 + 0.4e1 / 0.3e1 * t407 * t684 * t730 * t2225 + 0.16e2 / 0.3e1 * t407 * t4005 * t6566 * t155 + 0.4e1 / 0.3e1 * t407 * t1658 * t6571 * t172;
  t6609 = t1161 * t2692;
  t6618 = t161 * t2640;
  t6623 = t438 * t2640;
  t6661 = -0.4e1 * t407 * t1658 * t2296 * t717 - 0.4e1 / 0.3e1 * t407 * t692 * t2301 * t740 + 0.4e1 / 0.3e1 * t407 * t692 * t1686 * t939 + 0.4e1 / 0.3e1 * t407 * t692 * t693 * t2254 + 0.2e1 / 0.3e1 * t407 * t408 * t5183 * t292 + 0.2e1 / 0.3e1 * t407 * t408 * t2267 * t740 + 0.2e1 / 0.3e1 * t407 * t408 * t1696 * t954 + 0.2e1 / 0.3e1 * t407 * t408 * t698 * t2225 + 0.4e1 / 0.3e1 * t407 * t408 * t6609 * t155 - 0.4e1 / 0.3e1 * t407 * t408 * t3959 * t944 + 0.2e1 / 0.9e1 * t407 * t408 * t6618 * t155 + 0.4e1 / 0.9e1 * t407 * t684 * t6623 * t172 + 0.8e1 / 0.3e1 * t36 * t2283 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-t43 * t2654 * t145 * t48 / 0.2e1 + t43 * t288 * t136 * t151 / 0.2e1 + t43 * t57 * t712 * t428 / 0.6e1 - 0.7e1 / 0.2e1 * t43 * t2251 + 0.5e1 / 0.2e1 * t43 / t39 / t1122 * t2928 * sigma[0]) + 0.4e1 / 0.3e1 * t36 * t2264 + 0.2e1 / 0.3e1 * t36 * t2269 + 0.2e1 / 0.3e1 * t36 * t2288;
  t6675 = t916 * t292;
  t6688 = t283 * t939;
  t6697 = t939 * t292;
  t6706 = t283 * t954;
  t6715 = t283 * t944;
  t6728 = t292 * t954;
  t6740 = 0.4e1 / 0.3e1 * t36 * t2293 - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (-0.12e2 * t166 * t2636 * t40 - 0.32e2 * t2637 * t53) + 0.4e1 * t407 * t4130 * t6675 * t155 + 0.8e1 / 0.3e1 * t407 * t4100 * t6675 * t172 - 0.8e1 / 0.3e1 * t407 * t1652 * t2199 * t717 - 0.4e1 * t407 * t4136 * t6688 * t155 - 0.4e1 / 0.3e1 * t407 * t1652 * t6688 * t172 - 0.4e1 / 0.3e1 * t407 * t1652 * t6697 * t155 - 0.4e1 / 0.3e1 * t407 * t1646 * t6697 * t172 - 0.4e1 / 0.3e1 * t407 * t1652 * t6706 * t155 - 0.4e1 / 0.3e1 * t407 * t1646 * t6706 * t172 + 0.8e1 / 0.3e1 * t407 * t4100 * t6715 * t155 + 0.4e1 * t407 * t4110 * t6715 * t172 - 0.8e1 / 0.3e1 * t407 * t1646 * t2199 * t740 - 0.4e1 / 0.3e1 * t407 * t1646 * t6728 * t155 - 0.4e1 * t407 * t4123 * t6728 * t172 + 0.32e2 / 0.9e1 * t36 * t137 * t2702;
  t6784 = 0.32e2 / 0.9e1 * t36 * t137 * t2693 + 0.16e2 / 0.27e2 * t36 * t137 * t2641 - 0.32e2 / 0.9e1 * t36 * t2259 + 0.16e2 / 0.27e2 * t36 * t137 * t2672 - 0.4e1 * t36 * t2298 - 0.4e1 / 0.3e1 * t36 * t2303 + 0.8e1 / 0.3e1 * t36 * t2307 + 0.4e1 / 0.3e1 * t36 * t2311 + 0.4e1 / 0.3e1 * t36 * t2315 - 0.4e1 / 0.3e1 * t36 * t2274 - 0.4e1 * t36 * t2279 - 0.2e1 / 0.3e1 * t36 * t408 * t5174 - 0.2e1 / 0.3e1 * t36 * t684 * t5264 - 0.32e2 / 0.9e1 * t36 * t1711 * t2296 - 0.32e2 / 0.9e1 * t36 * t1630 * t2272 + 0.16e2 / 0.9e1 * t36 * t1205 * t2262 + 0.16e2 / 0.9e1 * t36 * t1630 * t2286;
  t6791 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t124 * t2706 - t6514 - 0.3e1 / 0.8e1 * t6 * t28 * (t6576 + t6661 + t6740 + t6784));
  tv4rhosigma30 = t6791 * t7 + t2710;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t6798 = t6 * t193 * t2792 / 0.8e1;
  t6800 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t189 * t2792 - t6798);
  tv4rhosigma39 = t6800 * t7 + t2796;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t6806 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t206 * t2706 - t6514);
  tv4rhosigma310 = t6806 * t7 + t2710;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t6876 = t639 * t2726;
  t6881 = 0.4e1 / 0.3e1 * t36 * t2452 - 0.4e1 / 0.3e1 * t36 * t2467 - 0.4e1 * t36 * t2472 + 0.8e1 / 0.3e1 * t36 * t2417 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-t43 * t2740 * t232 * t92 / 0.2e1 + t43 * t317 * t223 * t238 / 0.2e1 + t43 * t101 * t806 * t629 / 0.6e1 - 0.7e1 / 0.2e1 * t43 * t2393 + 0.5e1 / 0.2e1 * t43 / t84 / t1527 * t3747 * sigma[2]) + 0.4e1 / 0.3e1 * t36 * t2457 + 0.2e1 / 0.3e1 * t36 * t2462 + 0.2e1 / 0.3e1 * t36 * t2422 + 0.4e1 / 0.3e1 * t36 * t2440 - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (-0.12e2 * t253 * t2722 * t85 - 0.32e2 * t2723 * t97) + 0.32e2 / 0.9e1 * t36 * t224 * t2788 + 0.16e2 / 0.27e2 * t36 * t224 * t2758 + 0.32e2 / 0.9e1 * t36 * t224 * t2767 + 0.16e2 / 0.27e2 * t36 * t224 * t2727 - 0.32e2 / 0.9e1 * t36 * t2435 + 0.4e1 / 0.9e1 * t608 * t778 * t6876 * t259;
  t6920 = t1547 * t2787;
  t6940 = t106 * t2757;
  t6945 = 0.32e2 / 0.9e1 * t608 * t1940 * t2771 - 0.32e2 / 0.9e1 * t608 * t1940 * t2775 - 0.16e2 / 0.9e1 * t608 * t1591 * t2779 - 0.16e2 / 0.9e1 * t608 * t1591 * t2783 + 0.32e2 / 0.9e1 * t608 * t1591 * t2717 - 0.32e2 / 0.9e1 * t608 * t1862 * t2762 + 0.4e1 / 0.3e1 * t608 * t786 * t787 * t2396 + 0.2e1 / 0.3e1 * t608 * t609 * t5764 * t321 + 0.2e1 / 0.3e1 * t608 * t609 * t2460 * t834 + 0.2e1 / 0.3e1 * t608 * t609 * t1975 * t1008 + 0.2e1 / 0.3e1 * t608 * t609 * t792 * t2406 + 0.4e1 / 0.3e1 * t608 * t609 * t6920 * t242 + 0.16e2 / 0.3e1 * t608 * t778 * t3698 * t2787 * t259 - 0.4e1 * t608 * t778 * t2470 * t834 - 0.8e1 / 0.3e1 * t5729 * t2163 * t2357 - 0.8e1 / 0.3e1 * t5729 * t5738 * t2361 + 0.4e1 / 0.9e1 * t608 * t786 * t6940 * t242;
  t6947 = t248 * t2757;
  t6960 = t106 * t2766;
  t6965 = t248 * t2766;
  t6978 = t248 * t2726;
  t6999 = t312 * t993;
  t7008 = t993 * t321;
  t7013 = 0.2e1 / 0.9e1 * t608 * t609 * t6947 * t259 + 0.4e1 / 0.3e1 * t608 * t778 * t1931 * t1008 + 0.4e1 / 0.3e1 * t608 * t778 * t824 * t2406 + 0.16e2 / 0.3e1 * t608 * t4362 * t6960 * t242 + 0.4e1 / 0.3e1 * t608 * t1970 * t6965 * t259 - 0.4e1 * t608 * t1970 * t2425 * t811 - 0.4e1 / 0.3e1 * t608 * t609 * t4398 * t998 + 0.2e1 / 0.9e1 * t608 * t609 * t6978 * t242 - 0.4e1 / 0.3e1 * t608 * t786 * t2430 * t834 + 0.4e1 / 0.3e1 * t608 * t786 * t1947 * t993 - 0.4e1 * t36 * t2427 - 0.4e1 / 0.3e1 * t36 * t2432 + 0.8e1 / 0.3e1 * t36 * t2444 + 0.4e1 / 0.3e1 * t36 * t2448 - 0.4e1 * t608 * t4643 * t6999 * t242 - 0.4e1 / 0.3e1 * t608 * t1876 * t6999 * t259 - 0.4e1 / 0.3e1 * t608 * t1876 * t7008 * t242;
  t7018 = t312 * t998;
  t7031 = t321 * t1008;
  t7040 = t970 * t321;
  t7053 = t312 * t1008;
  t7080 = -0.4e1 / 0.3e1 * t608 * t1870 * t7008 * t259 + 0.8e1 / 0.3e1 * t608 * t4569 * t7018 * t242 + 0.4e1 * t608 * t4588 * t7018 * t259 - 0.8e1 / 0.3e1 * t608 * t1870 * t2356 * t834 - 0.4e1 / 0.3e1 * t608 * t1870 * t7031 * t242 - 0.4e1 * t608 * t4631 * t7031 * t259 + 0.4e1 * t608 * t4637 * t7040 * t242 + 0.8e1 / 0.3e1 * t608 * t4569 * t7040 * t259 - 0.8e1 / 0.3e1 * t608 * t1876 * t2356 * t811 - 0.4e1 / 0.3e1 * t608 * t1876 * t7053 * t242 - 0.4e1 / 0.3e1 * t608 * t1870 * t7053 * t259 - 0.32e2 / 0.9e1 * t36 * t1940 * t2425 - 0.32e2 / 0.9e1 * t36 * t1862 * t2465 + 0.16e2 / 0.9e1 * t36 * t1591 * t2455 + 0.16e2 / 0.9e1 * t36 * t1862 * t2420 - 0.2e1 / 0.3e1 * t36 * t609 * t5719 - 0.2e1 / 0.3e1 * t36 * t778 * t5745;
  t7087 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t217 * t2792 - t6798 - 0.3e1 / 0.8e1 * t6 * t81 * (t6881 + t6945 + t7013 + t7080));
  tv4rhosigma319 = t7 * t7087 + t2796;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t7096 = t2041 * t2809;
  t7101 = t2041 * t2813 / 0.3e1;
  t7106 = t2041 * t2798 / 0.3e1;
  t7111 = t2041 * t2805 / 0.6e1;
  t7125 = t2030 * t2813 + t859 * t860 * t439 * t2225 - 0.5e1 / 0.6e1 * t859 * t273 * t2804 - t7096 + 0.5e1 * t859 * t273 * t2808 + t7101 - 0.5e1 / 0.3e1 * t859 * t273 * t2812 - t7106 + 0.5e1 / 0.3e1 * t859 * t273 * t2797 + t7111 - t2030 * t2798 + t2030 * t2805 / 0.2e1 + t859 * t860 * t861 * t2254 / 0.2e1 - 0.3e1 * t2030 * t2809 + 0.2e1 * t859 * t2490 * t5208 * t172;
  t7141 = 0.2e1 / 0.3e1 * t2041 * t2801;
  t7180 = -0.2e1 * t859 * t2490 * t698 * t717 - 0.2e1 * t2030 * t2801 - 0.2e1 * t859 * t2016 * t3959 * t292 - 0.2e1 * t859 * t2016 * t1663 * t740 - t7141 + 0.1e2 / 0.3e1 * t859 * t4810 * t2800 - t859 * t2490 * t2267 * t155 - t859 * t2016 * t5243 * t172 + 0.3e1 * t859 * t2016 * t2277 * t155 + 0.12e2 * t859 * t2510 * t5234 * t172 - 0.6e1 * t859 * t2510 * t1722 * t740 - t859 * t2016 * t2291 * t155 - 0.3e1 * t859 * t2510 * t5221 * t172 + 0.3e1 * t859 * t6052 * t2301 * t155 + 0.4e1 * t5981 * t5988 * t2200 + 0.6e1 * t5981 * t5983 * t2204;
  t7182 = my_piecewise3(t2, 0, t7125 + t7180);
  tv4rhosigma2lapl0 = t7 * t7182 + t2816;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t7186 = t2115 * t2818 / 0.3e1;
  t7190 = 0.2e1 / 0.3e1 * t2115 * t2821;
  t7194 = t2115 * t2825 / 0.6e1;
  t7197 = t2115 * t2829;
  t7200 = t2115 * t2833 / 0.3e1;
  t7202 = my_piecewise3(t72, 0, -t2112 * t2818 - t7186 - 0.2e1 * t2112 * t2821 - t7190 + t2112 * t2825 / 0.2e1 + t7194 - 0.3e1 * t2112 * t2829 - t7197 + t2112 * t2833 + t7200);
  tv4rhosigma2lapl11 = t7 * t7202 + t2836;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t7213 = my_piecewise3(t2, 0, -t2089 * t2798 - t7106 - 0.2e1 * t2089 * t2801 - t7141 + t2089 * t2805 / 0.2e1 + t7111 - 0.3e1 * t2089 * t2809 - t7096 + t2089 * t2813 + t7101);
  tv4rhosigma2lapl12 = t7 * t7213 + t2816;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t7243 = 0.5e1 * t897 * t302 * t2828 - 0.5e1 / 0.3e1 * t897 * t302 * t2832 + 0.5e1 / 0.3e1 * t897 * t302 * t2817 - 0.5e1 / 0.6e1 * t897 * t302 * t2824 + t2153 * t2825 / 0.2e1 + t897 * t898 * t899 * t2396 / 0.2e1 - 0.3e1 * t2153 * t2829 + t2153 * t2833 + t897 * t898 * t640 * t2406 - t2153 * t2818 - t7186 + t7194 - t7197 + t7200 + 0.1e2 / 0.3e1 * t897 * t5116 * t2820;
  t7297 = -0.2e1 * t1956 * t2167 * t834 * t897 - 0.6e1 * t1965 * t2560 * t834 * t897 - t2167 * t242 * t2438 * t897 + 0.3e1 * t2167 * t242 * t2470 * t897 - t2167 * t259 * t5651 * t897 - 0.2e1 * t2167 * t321 * t4398 * t897 + 0.3e1 * t242 * t2430 * t6279 * t897 - t242 * t2460 * t2542 * t897 + 0.2e1 * t2542 * t259 * t5629 * t897 - 0.2e1 * t2542 * t792 * t811 * t897 + 0.12e2 * t2560 * t259 * t5638 * t897 - 0.3e1 * t2560 * t259 * t5659 * t897 + 0.4e1 * t2357 * t6222 * t6224 + 0.6e1 * t2361 * t6222 * t6229 - 0.2e1 * t2153 * t2821 - t7190;
  t7299 = my_piecewise3(t72, 0, t7243 + t7297);
  tv4rhosigma2lapl23 = t7 * t7299 + t2836;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t7304 = 0.2e1 / 0.3e1 * t2041 * t2838;
  t7310 = t57 * t283;
  t7326 = 0.2e1 * t2041 * t2842;
  t7330 = t57 * t292;
  t7348 = 0.2e1 / 0.3e1 * t2041 * t2846;
  t7352 = t438 * t288;
  t7357 = t1161 * t288;
  t7362 = 0.2e1 * t2030 * t2838 + t7304 - 0.4e1 / 0.3e1 * t859 * t2016 * t2837 - 0.4e1 * t5981 * t1036 * t399 * t438 * t7310 * t155 - 0.6e1 * t5981 * t6391 * t7310 * t172 + 0.2e1 * t859 * t2578 * t2579 * t717 + 0.6e1 * t2030 * t2842 + t7326 - 0.4e1 * t859 * t2510 * t2841 - 0.6e1 * t5981 * t6391 * t7330 * t155 - 0.24e2 * t5981 * t1036 * t52 * t2989 * t7330 * t172 + 0.6e1 * t859 * t2584 * t2585 * t740 + 0.2e1 * t2030 * t2846 + t7348 - 0.4e1 / 0.3e1 * t859 * t860 * t2845 - 0.2e1 * t859 * t2578 * t7352 * t155 - 0.6e1 * t859 * t2584 * t7357 * t172;
  t7363 = my_piecewise3(t2, 0, t7362);
  tv4rhosigmalapl20 = t7 * t7363 + t2850;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t7368 = 0.2e1 / 0.3e1 * t2115 * t2852;
  t7372 = 0.2e1 * t2115 * t2856;
  t7376 = 0.2e1 / 0.3e1 * t2115 * t2860;
  t7378 = my_piecewise3(t72, 0, 0.2e1 * t2112 * t2852 + 0.6e1 * t2112 * t2856 + 0.2e1 * t2112 * t2860 + t7368 + t7372 + t7376);
  tv4rhosigmalapl28 = t7 * t7378 + t2864;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t7387 = my_piecewise3(t2, 0, 0.2e1 * t2089 * t2838 + 0.6e1 * t2089 * t2842 + 0.2e1 * t2089 * t2846 + t7304 + t7326 + t7348);
  tv4rhosigmalapl29 = t7 * t7387 + t2850;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t7396 = t101 * t312;
  t7414 = t101 * t321;
  t7434 = t639 * t317;
  t7439 = t1547 * t317;
  t7444 = 0.2e1 * t2153 * t2852 + t7368 - 0.4e1 / 0.3e1 * t897 * t2167 * t2851 - 0.4e1 * t6222 * t1043 * t600 * t639 * t7396 * t242 - 0.6e1 * t6222 * t6493 * t7396 * t259 + 0.2e1 * t897 * t2610 * t2611 * t811 + 0.6e1 * t2153 * t2856 + t7372 - 0.4e1 * t897 * t2560 * t2855 - 0.6e1 * t6222 * t6493 * t7414 * t242 - 0.24e2 * t6222 * t1043 * t96 * t3698 * t7414 * t259 + 0.6e1 * t897 * t2616 * t2617 * t834 + 0.2e1 * t2153 * t2860 + t7376 - 0.4e1 / 0.3e1 * t897 * t898 * t2859 - 0.2e1 * t897 * t2610 * t7434 * t242 - 0.6e1 * t897 * t2616 * t7439 * t259;
  t7445 = my_piecewise3(t72, 0, t7444);
  tv4rhosigmalapl217 = t7 * t7445 + t2864;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t7450 = 0.4e1 * t2041 * t2867;
  t7454 = t2865 * t142;
  t7459 = t2865 * t52;
  t7460 = t2989 * t288;
  t7466 = my_piecewise3(t2, 0, 0.12e2 * t155 * t7357 * t7454 * t859 + 0.48e2 * t172 * t7459 * t7460 * t859 - 0.4e1 * t1037 * t2866 * t859 - 0.12e2 * t2030 * t2867 - t7450);
  tv4rholapl30 = t7 * t7466 + t2870;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t7471 = 0.4e1 * t2115 * t2873;
  t7473 = my_piecewise3(t72, 0, -0.12e2 * t2112 * t2873 - t7471);
  tv4rholapl33 = t7 * t7473 + t2876;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t7478 = my_piecewise3(t2, 0, -0.12e2 * t2089 * t2867 - t7450);
  tv4rholapl34 = t7 * t7478 + t2870;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t7485 = t2871 * t229;
  t7490 = t2871 * t96;
  t7491 = t3698 * t317;
  t7497 = my_piecewise3(t72, 0, 0.12e2 * t242 * t7439 * t7485 * t897 + 0.48e2 * t259 * t7490 * t7491 * t897 - 0.4e1 * t1044 * t2872 * t897 - 0.12e2 * t2153 * t2873 - t7471);
  tv4rholapl37 = t7 * t7497 + t2876;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t7537 = t944 * t944;
  t7542 = t954 * t954;
  t7547 = t916 * t916;
  t7552 = t939 * t939;
  t7581 = -0.16e2 / 0.3e1 * t36 * t2677 - 0.2e1 / 0.9e1 * t36 * t42 * t143 * (-0.15e2 / 0.16e2 * t43 / t44 / t949 * t46 * t48 + 0.15e2 / 0.16e2 * t43 * t950 * t41 * t151 + 0.5e1 / 0.16e2 * t43 * t288 * t935 * t428 + 0.3e1 / 0.16e2 * t43 * t57 * t2667 * t1127 - 0.15e2 / 0.16e2 * t43 / t39 / t1741 * t2928) + 0.16e2 / 0.3e1 * t36 * t2681 + 0.8e1 / 0.3e1 * t36 * t2685 + 0.8e1 / 0.3e1 * t36 * t2689 + 0.16e2 / 0.3e1 * t36 * t2698 + 0.16e2 / 0.3e1 * t36 * t42 * t2990 * t7537 + 0.4e1 / 0.3e1 * t36 * t42 * t439 * t7542 + 0.16e2 / 0.3e1 * t36 * t42 * t2971 * t7547 + 0.4e1 / 0.3e1 * t36 * t42 * t400 * t7552 - 0.16e2 / 0.3e1 * t36 * t2632 - 0.2e1 / 0.9e1 * t36 * t42 * t162 * (-0.48e2 * t2636 + 0.48e2 * t56 / t2635 / sigma[0] * t40) - 0.8e1 / 0.3e1 * t407 * t408 * t5243 * t944 + 0.8e1 / 0.9e1 * t407 * t408 * t6618 * t283 + 0.16e2 / 0.9e1 * t407 * t684 * t6623 * t292;
  t7638 = 0.16e2 / 0.3e1 * t407 * t1658 * t6571 * t292 - 0.8e1 * t407 * t1658 * t2296 * t939 + 0.16e2 / 0.3e1 * t407 * t692 * t5208 * t944 + 0.16e2 / 0.3e1 * t407 * t408 * t3985 * t2692 - 0.8e1 * t407 * t684 * t2277 * t954 + 0.16e2 / 0.9e1 * t407 * t692 * t6521 * t283 + 0.8e1 / 0.9e1 * t407 * t408 * t6526 * t292 - 0.8e1 / 0.3e1 * t407 * t692 * t2301 * t954 + 0.4e1 / 0.3e1 * t407 * t408 * t2267 * t954 - 0.16e2 / 0.3e1 * t407 * t1652 * t2199 * t939 - 0.16e2 / 0.3e1 * t407 * t1646 * t2199 * t954 - 0.16e2 / 0.3e1 * t36 * t1658 * t6566 - 0.16e2 / 0.3e1 * t36 * t684 * t6609 - 0.8e1 / 0.9e1 * t36 * t408 * t6521 - 0.8e1 / 0.9e1 * t36 * t684 * t6618;
  t7643 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t7581 + t7638));
  tv4sigma40 = t7 * t7643;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t7656 = t998 * t998;
  t7661 = t1008 * t1008;
  t7666 = t970 * t970;
  t7671 = t993 * t993;
  t7726 = 0.16e2 / 0.3e1 * t36 * t2763 - 0.2e1 / 0.9e1 * t36 * t87 * t249 * (-0.48e2 * t2722 + 0.48e2 * t100 / t2721 / sigma[2] * t85) + 0.16e2 / 0.3e1 * t36 * t87 * t3699 * t7656 + 0.4e1 / 0.3e1 * t36 * t87 * t640 * t7661 + 0.16e2 / 0.3e1 * t36 * t87 * t3796 * t7666 + 0.4e1 / 0.3e1 * t36 * t87 * t601 * t7671 - 0.16e2 / 0.3e1 * t36 * t2718 - 0.16e2 / 0.3e1 * t36 * t2772 - 0.2e1 / 0.9e1 * t36 * t87 * t230 * (-0.15e2 / 0.16e2 * t43 / t88 / t1003 * t90 * t92 + 0.15e2 / 0.16e2 * t43 * t1004 * t86 * t238 + 0.5e1 / 0.16e2 * t43 * t317 * t989 * t629 + 0.3e1 / 0.16e2 * t43 * t101 * t2753 * t1532 - 0.15e2 / 0.16e2 * t43 / t84 / t1896 * t3747) + 0.16e2 / 0.3e1 * t36 * t2776 + 0.8e1 / 0.3e1 * t36 * t2780 + 0.8e1 / 0.3e1 * t36 * t2784 - 0.8e1 / 0.3e1 * t608 * t609 * t5651 * t998 + 0.8e1 / 0.9e1 * t608 * t609 * t6978 * t312 + 0.16e2 / 0.9e1 * t608 * t778 * t6876 * t321;
  t7783 = 0.16e2 / 0.3e1 * t608 * t786 * t5629 * t998 + 0.16e2 / 0.3e1 * t608 * t609 * t4370 * t2787 - 0.8e1 * t608 * t778 * t2470 * t1008 + 0.4e1 / 0.3e1 * t608 * t609 * t2460 * t1008 + 0.16e2 / 0.9e1 * t608 * t786 * t6940 * t312 + 0.8e1 / 0.9e1 * t608 * t609 * t6947 * t321 + 0.16e2 / 0.3e1 * t608 * t1970 * t6965 * t321 - 0.8e1 * t608 * t1970 * t2425 * t993 - 0.8e1 / 0.3e1 * t608 * t786 * t2430 * t1008 - 0.16e2 / 0.3e1 * t608 * t1876 * t2356 * t993 - 0.16e2 / 0.3e1 * t608 * t1870 * t2356 * t1008 - 0.16e2 / 0.3e1 * t36 * t1970 * t6960 - 0.16e2 / 0.3e1 * t36 * t778 * t6920 - 0.8e1 / 0.9e1 * t36 * t609 * t6940 - 0.8e1 / 0.9e1 * t36 * t778 * t6978;
  t7788 = my_piecewise3(t72, 0, -0.3e1 / 0.8e1 * t6 * t81 * (t7726 + t7783));
  tv4sigma414 = t7 * t7788;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t7829 = my_piecewise3(t2, 0, 0.3e1 * t859 * t860 * t4720 * t2701 + 0.6e1 * t859 * t2490 * t5208 * t292 - 0.3e1 * t859 * t2490 * t698 * t939 + 0.9e1 * t859 * t2016 * t3985 * t944 - 0.3e1 * t859 * t2016 * t5243 * t292 - 0.3e1 * t859 * t2016 * t1663 * t954 + t859 * t860 * t861 * t2671 / 0.2e1 + 0.12e2 * t859 * t860 * t2990 * t2692 - 0.9e1 * t859 * t2510 * t1722 * t954 + t859 * t860 * t439 * t2640);
  tv4sigma3lapl0 = t7 * t7829;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t7870 = my_piecewise3(t72, 0, 0.3e1 * t897 * t898 * t5054 * t2766 + 0.6e1 * t897 * t2542 * t5629 * t321 - 0.3e1 * t897 * t2542 * t792 * t993 + 0.9e1 * t897 * t2167 * t4370 * t998 - 0.3e1 * t897 * t2167 * t5651 * t321 - 0.3e1 * t897 * t2167 * t1956 * t1008 + t897 * t898 * t899 * t2757 / 0.2e1 + 0.12e2 * t897 * t898 * t3699 * t2787 - 0.9e1 * t897 * t2560 * t1965 * t1008 + t897 * t898 * t640 * t2726);
  tv4sigma3lapl19 = t7 * t7870;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t7904 = my_piecewise3(t2, 0, -0.4e1 * t1037 * t439 * t859 * t950 + 0.2e1 * t2578 * t2579 * t859 * t939 - 0.4e1 * t2578 * t283 * t7352 * t859 - 0.4e1 * t2579 * t6385 * t859 * t916 + 0.6e1 * t2584 * t2585 * t859 * t954 - 0.12e2 * t2584 * t292 * t7357 * t859 - 0.24e2 * t2584 * t6397 * t859 * t944 - 0.12e2 * t292 * t5981 * t6391 * t7310);
  tv4sigma2lapl20 = t7 * t7904;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t7938 = my_piecewise3(t72, 0, -0.4e1 * t1004 * t1044 * t640 * t897 + 0.6e1 * t1008 * t2616 * t2617 * t897 + 0.2e1 * t2610 * t2611 * t897 * t993 - 0.4e1 * t2610 * t312 * t7434 * t897 - 0.4e1 * t2611 * t6487 * t897 * t970 - 0.12e2 * t2616 * t321 * t7439 * t897 - 0.24e2 * t2616 * t6499 * t897 * t998 - 0.12e2 * t321 * t6222 * t6493 * t7396);
  tv4sigma2lapl217 = t7 * t7938;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t7952 = my_piecewise3(t2, 0, 0.24e2 * t1162 * t2865 * t859 * t950 + 0.12e2 * t283 * t7357 * t7454 * t859 + 0.48e2 * t292 * t7459 * t7460 * t859);
  tv4sigmalapl30 = t7 * t7952;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t7966 = my_piecewise3(t72, 0, 0.24e2 * t1004 * t1548 * t2871 * t897 + 0.12e2 * t312 * t7439 * t7485 * t897 + 0.48e2 * t321 * t7490 * t7491 * t897);
  tv4sigmalapl311 = t7 * t7966;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t7972 = my_piecewise3(t2, 0, -0.96e2 * t859 * t34 * t45 * t2990 * t950);
  tv4lapl40 = t7 * t7972;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t7978 = my_piecewise3(t72, 0, -0.96e2 * t897 * t34 * t89 * t3699 * t1004);
  tv4lapl44 = t7 * t7978;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

