/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_c_lyp.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t12, t13, t15, t16, t18, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t31, t35;
  double t36, t37, t40, t41, t44, t45, t48, t49;
  double t50, t53, t54, t56, t62, tzk0;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->d * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t7 = exp(-params->c * t2);
  t8 = params->b * t7;
  t9 = rho[0] * rho[0];
  t10 = t1 * t1;
  t12 = 0.1e1 / t10 / t9;
  t13 = sigma[0] * t12;
  t15 = params->d * t5 + params->c;
  t16 = t15 * t2;
  t18 = -0.1e1 / 0.72e2 - 0.7e1 / 0.72e2 * t16;
  t20 = M_CBRT3;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t26 = 0.1e1 <= p->zeta_threshold;
  t27 = p->zeta_threshold * p->zeta_threshold;
  t28 = POW_1_3(p->zeta_threshold);
  t29 = t28 * t28;
  t31 = my_piecewise3(t26, t29 * t27, 1);
  t35 = 0.5e1 / 0.2e1 - t16 / 0.18e2;
  t36 = t35 * sigma[0];
  t37 = t12 * t31;
  t40 = t16 - 0.11e2;
  t41 = t40 * sigma[0];
  t44 = my_piecewise3(t26, t29 * t27 * p->zeta_threshold, 1);
  t45 = t12 * t44;
  t48 = M_CBRT2;
  t49 = t48 * t48;
  t50 = sigma[0] * t49;
  t53 = my_piecewise3(t26, t27, 1);
  t54 = t53 * sigma[0];
  t56 = t49 * t12 * t31;
  t62 = -t13 * t18 - 0.3e1 / 0.1e2 * t21 * t24 * t31 + t36 * t37 / 0.8e1 + t41 * t45 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t50 * t37 - t54 * t56 / 0.2e1) / 0.8e1;
  tzk0 = params->a * (t8 * t5 * t62 - t5);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t12, t13, t15, t16, t18, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t31, t35;
  double t36, t37, t40, t41, t44, t45, t48, t49;
  double t50, t53, t54, t56, t62, tzk0;

  double t66, t67, t68, t69, t71, t74, t75, t76;
  double t77, t80, t81, t85, t87, t88, t91, t92;
  double t94, t97, t98, t100, t101, t104, t108, t109;
  double t112, t118, t124, t127, tvrho0, t129, t138, t144;
  double t145, tvsigma0;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->d * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t7 = exp(-params->c * t2);
  t8 = params->b * t7;
  t9 = rho[0] * rho[0];
  t10 = t1 * t1;
  t12 = 0.1e1 / t10 / t9;
  t13 = sigma[0] * t12;
  t15 = params->d * t5 + params->c;
  t16 = t15 * t2;
  t18 = -0.1e1 / 0.72e2 - 0.7e1 / 0.72e2 * t16;
  t20 = M_CBRT3;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t26 = 0.1e1 <= p->zeta_threshold;
  t27 = p->zeta_threshold * p->zeta_threshold;
  t28 = POW_1_3(p->zeta_threshold);
  t29 = t28 * t28;
  t31 = my_piecewise3(t26, t29 * t27, 1);
  t35 = 0.5e1 / 0.2e1 - t16 / 0.18e2;
  t36 = t35 * sigma[0];
  t37 = t12 * t31;
  t40 = t16 - 0.11e2;
  t41 = t40 * sigma[0];
  t44 = my_piecewise3(t26, t29 * t27 * p->zeta_threshold, 1);
  t45 = t12 * t44;
  t48 = M_CBRT2;
  t49 = t48 * t48;
  t50 = sigma[0] * t49;
  t53 = my_piecewise3(t26, t27, 1);
  t54 = t53 * sigma[0];
  t56 = t49 * t12 * t31;
  t62 = -t13 * t18 - 0.3e1 / 0.1e2 * t21 * t24 * t31 + t36 * t37 / 0.8e1 + t41 * t45 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t50 * t37 - t54 * t56 / 0.2e1) / 0.8e1;
  tzk0 = params->a * (t8 * t5 * t62 - t5);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = rho[0] * params->a;
  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t68 * params->d;
  t71 = 0.1e1 / t1 / rho[0];
  t74 = params->b * params->c;
  t75 = t74 * t71;
  t76 = t7 * t5;
  t77 = t76 * t62;
  t80 = t8 * t68;
  t81 = t62 * params->d;
  t85 = t9 * rho[0];
  t87 = 0.1e1 / t10 / t85;
  t88 = sigma[0] * t87;
  t91 = params->d * params->d;
  t92 = t91 * t68;
  t94 = 0.1e1 / t10 / rho[0];
  t97 = t15 * t71 - t92 * t94;
  t98 = 0.7e1 / 0.216e3 * t97;
  t100 = t97 / 0.54e2;
  t101 = t100 * sigma[0];
  t104 = t87 * t31;
  t108 = -t97 / 0.3e1;
  t109 = t108 * sigma[0];
  t112 = t87 * t44;
  t118 = t49 * t87 * t31;
  t124 = 0.8e1 / 0.3e1 * t88 * t18 - t13 * t98 + t101 * t37 / 0.8e1 - t36 * t104 / 0.3e1 + t109 * t45 / 0.144e3 - t41 * t112 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t50 * t104 + 0.4e1 / 0.3e1 * t54 * t118) / 0.8e1;
  t127 = -t69 * t71 / 0.3e1 + t75 * t77 / 0.3e1 + t80 * t81 * t71 / 0.3e1 + t8 * t5 * t124;
  tvrho0 = t66 * t127 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t129 = t66 * params->b;
  t138 = t53 * t49;
  t144 = -t12 * t18 + t35 * t12 * t31 / 0.8e1 + t40 * t12 * t44 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t56 - t138 * t37 / 0.2e1) / 0.8e1;
  t145 = t76 * t144;
  tvsigma0 = t129 * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t12, t13, t15, t16, t18, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t31, t35;
  double t36, t37, t40, t41, t44, t45, t48, t49;
  double t50, t53, t54, t56, t62, tzk0;

  double t66, t67, t68, t69, t71, t74, t75, t76;
  double t77, t80, t81, t85, t87, t88, t91, t92;
  double t94, t97, t98, t100, t101, t104, t108, t109;
  double t112, t118, t124, t127, tvrho0, t129, t138, t144;
  double t145, tvsigma0;

  double t149, t150, t154, t157, t160, t161, t162, t165;
  double t166, t167, t170, t173, t174, t178, t185, t187;
  double t188, t193, t194, t195, t196, t198, t200, t202;
  double t207, t208, t213, t219, t220, t225, t231, t237;
  double t240, tv2rho20, t242, t245, t246, t247, t252, t276;
  double t277, tv2rhosigma0, tv2sigma20;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->d * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t7 = exp(-params->c * t2);
  t8 = params->b * t7;
  t9 = rho[0] * rho[0];
  t10 = t1 * t1;
  t12 = 0.1e1 / t10 / t9;
  t13 = sigma[0] * t12;
  t15 = params->d * t5 + params->c;
  t16 = t15 * t2;
  t18 = -0.1e1 / 0.72e2 - 0.7e1 / 0.72e2 * t16;
  t20 = M_CBRT3;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t26 = 0.1e1 <= p->zeta_threshold;
  t27 = p->zeta_threshold * p->zeta_threshold;
  t28 = POW_1_3(p->zeta_threshold);
  t29 = t28 * t28;
  t31 = my_piecewise3(t26, t29 * t27, 1);
  t35 = 0.5e1 / 0.2e1 - t16 / 0.18e2;
  t36 = t35 * sigma[0];
  t37 = t12 * t31;
  t40 = t16 - 0.11e2;
  t41 = t40 * sigma[0];
  t44 = my_piecewise3(t26, t29 * t27 * p->zeta_threshold, 1);
  t45 = t12 * t44;
  t48 = M_CBRT2;
  t49 = t48 * t48;
  t50 = sigma[0] * t49;
  t53 = my_piecewise3(t26, t27, 1);
  t54 = t53 * sigma[0];
  t56 = t49 * t12 * t31;
  t62 = -t13 * t18 - 0.3e1 / 0.1e2 * t21 * t24 * t31 + t36 * t37 / 0.8e1 + t41 * t45 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t50 * t37 - t54 * t56 / 0.2e1) / 0.8e1;
  tzk0 = params->a * (t8 * t5 * t62 - t5);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = rho[0] * params->a;
  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t68 * params->d;
  t71 = 0.1e1 / t1 / rho[0];
  t74 = params->b * params->c;
  t75 = t74 * t71;
  t76 = t7 * t5;
  t77 = t76 * t62;
  t80 = t8 * t68;
  t81 = t62 * params->d;
  t85 = t9 * rho[0];
  t87 = 0.1e1 / t10 / t85;
  t88 = sigma[0] * t87;
  t91 = params->d * params->d;
  t92 = t91 * t68;
  t94 = 0.1e1 / t10 / rho[0];
  t97 = t15 * t71 - t92 * t94;
  t98 = 0.7e1 / 0.216e3 * t97;
  t100 = t97 / 0.54e2;
  t101 = t100 * sigma[0];
  t104 = t87 * t31;
  t108 = -t97 / 0.3e1;
  t109 = t108 * sigma[0];
  t112 = t87 * t44;
  t118 = t49 * t87 * t31;
  t124 = 0.8e1 / 0.3e1 * t88 * t18 - t13 * t98 + t101 * t37 / 0.8e1 - t36 * t104 / 0.3e1 + t109 * t45 / 0.144e3 - t41 * t112 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t50 * t104 + 0.4e1 / 0.3e1 * t54 * t118) / 0.8e1;
  t127 = -t69 * t71 / 0.3e1 + t75 * t77 / 0.3e1 + t80 * t81 * t71 / 0.3e1 + t8 * t5 * t124;
  tvrho0 = t66 * t127 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t129 = t66 * params->b;
  t138 = t53 * t49;
  t144 = -t12 * t18 + t35 * t12 * t31 / 0.8e1 + t40 * t12 * t44 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t56 - t138 * t37 / 0.2e1) / 0.8e1;
  t145 = t76 * t144;
  tvsigma0 = t129 * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t149 = 0.1e1 / t67 / t4;
  t150 = t149 * t91;
  t154 = 0.1e1 / t1 / t9;
  t157 = t74 * t154;
  t160 = params->c * params->c;
  t161 = params->b * t160;
  t162 = t161 * t12;
  t165 = t74 * t12;
  t166 = t7 * t68;
  t167 = t166 * t81;
  t170 = t76 * t124;
  t173 = t8 * t149;
  t174 = t62 * t91;
  t178 = t124 * params->d;
  t185 = t9 * t9;
  t187 = 0.1e1 / t10 / t185;
  t188 = sigma[0] * t187;
  t193 = t91 * params->d;
  t194 = t193 * t149;
  t195 = 0.1e1 / t85;
  t196 = t194 * t195;
  t198 = t92 * t12;
  t200 = t15 * t154;
  t202 = -0.7e1 / 0.324e3 * t196 + 0.7e1 / 0.108e3 * t198 - 0.7e1 / 0.162e3 * t200;
  t207 = -t196 / 0.81e2 + t198 / 0.27e2 - 0.2e1 / 0.81e2 * t200;
  t208 = t207 * sigma[0];
  t213 = t187 * t31;
  t219 = 0.2e1 / 0.9e1 * t196 - 0.2e1 / 0.3e1 * t198 + 0.4e1 / 0.9e1 * t200;
  t220 = t219 * sigma[0];
  t225 = t187 * t44;
  t231 = t49 * t187 * t31;
  t237 = -0.88e2 / 0.9e1 * t188 * t18 + 0.16e2 / 0.3e1 * t88 * t98 - t13 * t202 + t208 * t37 / 0.8e1 - 0.2e1 / 0.3e1 * t101 * t104 + 0.11e2 / 0.9e1 * t36 * t213 + t220 * t45 / 0.144e3 - t109 * t112 / 0.27e2 + 0.11e2 / 0.162e3 * t41 * t225 - t48 * (0.352e3 / 0.27e2 * t50 * t213 - 0.44e2 / 0.9e1 * t54 * t231) / 0.8e1;
  t240 = -0.2e1 / 0.9e1 * t150 * t12 + 0.4e1 / 0.9e1 * t69 * t154 - 0.4e1 / 0.9e1 * t157 * t77 + t162 * t77 / 0.9e1 + 0.2e1 / 0.9e1 * t165 * t167 + 0.2e1 / 0.3e1 * t75 * t170 + 0.2e1 / 0.9e1 * t173 * t174 * t12 + 0.2e1 / 0.3e1 * t80 * t178 * t71 - 0.4e1 / 0.9e1 * t80 * t81 * t154 + t8 * t5 * t237;
  tv2rho20 = 0.2e1 * params->a * t127 + t66 * t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t242 = params->a * params->b;
  t245 = t2 * params->a * params->b;
  t246 = params->c * t7;
  t247 = t5 * t144;
  t252 = t166 * t144 * params->d;
  t276 = 0.8e1 / 0.3e1 * t87 * t18 - t12 * t98 + t100 * t12 * t31 / 0.8e1 - t35 * t87 * t31 / 0.3e1 + t108 * t12 * t44 / 0.144e3 - t40 * t87 * t44 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t118 + 0.4e1 / 0.3e1 * t138 * t104) / 0.8e1;
  t277 = t76 * t276;
  tv2rhosigma0 = t242 * t145 + t245 * t246 * t247 / 0.3e1 + t245 * t252 / 0.3e1 + t129 * t277;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2sigma20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t12, t13, t15, t16, t18, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t31, t35;
  double t36, t37, t40, t41, t44, t45, t48, t49;
  double t50, t53, t54, t56, t62, tzk0;

  double t66, t67, t68, t69, t71, t74, t75, t76;
  double t77, t80, t81, t85, t87, t88, t91, t92;
  double t94, t97, t98, t100, t101, t104, t108, t109;
  double t112, t118, t124, t127, tvrho0, t129, t138, t144;
  double t145, tvsigma0;

  double t149, t150, t154, t157, t160, t161, t162, t165;
  double t166, t167, t170, t173, t174, t178, t185, t187;
  double t188, t193, t194, t195, t196, t198, t200, t202;
  double t207, t208, t213, t219, t220, t225, t231, t237;
  double t240, tv2rho20, t242, t245, t246, t247, t252, t276;
  double t277, tv2rhosigma0, tv2sigma20;

  double t284, t287, t289, t290, t297, t298, t299, t300;
  double t302, t303, t305, t306, t308, t310, t312, t318;
  double t319, t325, t332, t333, t340, t346, t352, t355;
  double t358, t361, t364, t367, t370, t371, t372, t386;
  double t391, t392, t393, t396, t398, t402, t403, t407;
  double t410, tv3rho30, t412, t413, t417, t418, t419, t425;
  double t426, t427, t431, t434, t439, t443, t475, t476;
  double tv3rho2sigma0, tv3rhosigma20, tv3sigma30;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->d * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t7 = exp(-params->c * t2);
  t8 = params->b * t7;
  t9 = rho[0] * rho[0];
  t10 = t1 * t1;
  t12 = 0.1e1 / t10 / t9;
  t13 = sigma[0] * t12;
  t15 = params->d * t5 + params->c;
  t16 = t15 * t2;
  t18 = -0.1e1 / 0.72e2 - 0.7e1 / 0.72e2 * t16;
  t20 = M_CBRT3;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t26 = 0.1e1 <= p->zeta_threshold;
  t27 = p->zeta_threshold * p->zeta_threshold;
  t28 = POW_1_3(p->zeta_threshold);
  t29 = t28 * t28;
  t31 = my_piecewise3(t26, t29 * t27, 1);
  t35 = 0.5e1 / 0.2e1 - t16 / 0.18e2;
  t36 = t35 * sigma[0];
  t37 = t12 * t31;
  t40 = t16 - 0.11e2;
  t41 = t40 * sigma[0];
  t44 = my_piecewise3(t26, t29 * t27 * p->zeta_threshold, 1);
  t45 = t12 * t44;
  t48 = M_CBRT2;
  t49 = t48 * t48;
  t50 = sigma[0] * t49;
  t53 = my_piecewise3(t26, t27, 1);
  t54 = t53 * sigma[0];
  t56 = t49 * t12 * t31;
  t62 = -t13 * t18 - 0.3e1 / 0.1e2 * t21 * t24 * t31 + t36 * t37 / 0.8e1 + t41 * t45 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t50 * t37 - t54 * t56 / 0.2e1) / 0.8e1;
  tzk0 = params->a * (t8 * t5 * t62 - t5);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = rho[0] * params->a;
  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t68 * params->d;
  t71 = 0.1e1 / t1 / rho[0];
  t74 = params->b * params->c;
  t75 = t74 * t71;
  t76 = t7 * t5;
  t77 = t76 * t62;
  t80 = t8 * t68;
  t81 = t62 * params->d;
  t85 = t9 * rho[0];
  t87 = 0.1e1 / t10 / t85;
  t88 = sigma[0] * t87;
  t91 = params->d * params->d;
  t92 = t91 * t68;
  t94 = 0.1e1 / t10 / rho[0];
  t97 = t15 * t71 - t92 * t94;
  t98 = 0.7e1 / 0.216e3 * t97;
  t100 = t97 / 0.54e2;
  t101 = t100 * sigma[0];
  t104 = t87 * t31;
  t108 = -t97 / 0.3e1;
  t109 = t108 * sigma[0];
  t112 = t87 * t44;
  t118 = t49 * t87 * t31;
  t124 = 0.8e1 / 0.3e1 * t88 * t18 - t13 * t98 + t101 * t37 / 0.8e1 - t36 * t104 / 0.3e1 + t109 * t45 / 0.144e3 - t41 * t112 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t50 * t104 + 0.4e1 / 0.3e1 * t54 * t118) / 0.8e1;
  t127 = -t69 * t71 / 0.3e1 + t75 * t77 / 0.3e1 + t80 * t81 * t71 / 0.3e1 + t8 * t5 * t124;
  tvrho0 = t66 * t127 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t129 = t66 * params->b;
  t138 = t53 * t49;
  t144 = -t12 * t18 + t35 * t12 * t31 / 0.8e1 + t40 * t12 * t44 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t56 - t138 * t37 / 0.2e1) / 0.8e1;
  t145 = t76 * t144;
  tvsigma0 = t129 * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t149 = 0.1e1 / t67 / t4;
  t150 = t149 * t91;
  t154 = 0.1e1 / t1 / t9;
  t157 = t74 * t154;
  t160 = params->c * params->c;
  t161 = params->b * t160;
  t162 = t161 * t12;
  t165 = t74 * t12;
  t166 = t7 * t68;
  t167 = t166 * t81;
  t170 = t76 * t124;
  t173 = t8 * t149;
  t174 = t62 * t91;
  t178 = t124 * params->d;
  t185 = t9 * t9;
  t187 = 0.1e1 / t10 / t185;
  t188 = sigma[0] * t187;
  t193 = t91 * params->d;
  t194 = t193 * t149;
  t195 = 0.1e1 / t85;
  t196 = t194 * t195;
  t198 = t92 * t12;
  t200 = t15 * t154;
  t202 = -0.7e1 / 0.324e3 * t196 + 0.7e1 / 0.108e3 * t198 - 0.7e1 / 0.162e3 * t200;
  t207 = -t196 / 0.81e2 + t198 / 0.27e2 - 0.2e1 / 0.81e2 * t200;
  t208 = t207 * sigma[0];
  t213 = t187 * t31;
  t219 = 0.2e1 / 0.9e1 * t196 - 0.2e1 / 0.3e1 * t198 + 0.4e1 / 0.9e1 * t200;
  t220 = t219 * sigma[0];
  t225 = t187 * t44;
  t231 = t49 * t187 * t31;
  t237 = -0.88e2 / 0.9e1 * t188 * t18 + 0.16e2 / 0.3e1 * t88 * t98 - t13 * t202 + t208 * t37 / 0.8e1 - 0.2e1 / 0.3e1 * t101 * t104 + 0.11e2 / 0.9e1 * t36 * t213 + t220 * t45 / 0.144e3 - t109 * t112 / 0.27e2 + 0.11e2 / 0.162e3 * t41 * t225 - t48 * (0.352e3 / 0.27e2 * t50 * t213 - 0.44e2 / 0.9e1 * t54 * t231) / 0.8e1;
  t240 = -0.2e1 / 0.9e1 * t150 * t12 + 0.4e1 / 0.9e1 * t69 * t154 - 0.4e1 / 0.9e1 * t157 * t77 + t162 * t77 / 0.9e1 + 0.2e1 / 0.9e1 * t165 * t167 + 0.2e1 / 0.3e1 * t75 * t170 + 0.2e1 / 0.9e1 * t173 * t174 * t12 + 0.2e1 / 0.3e1 * t80 * t178 * t71 - 0.4e1 / 0.9e1 * t80 * t81 * t154 + t8 * t5 * t237;
  tv2rho20 = 0.2e1 * params->a * t127 + t66 * t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t242 = params->a * params->b;
  t245 = t2 * params->a * params->b;
  t246 = params->c * t7;
  t247 = t5 * t144;
  t252 = t166 * t144 * params->d;
  t276 = 0.8e1 / 0.3e1 * t87 * t18 - t12 * t98 + t100 * t12 * t31 / 0.8e1 - t35 * t87 * t31 / 0.3e1 + t108 * t12 * t44 / 0.144e3 - t40 * t87 * t44 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t118 + 0.4e1 / 0.3e1 * t138 * t104) / 0.8e1;
  t277 = t76 * t276;
  tv2rhosigma0 = t242 * t145 + t245 * t246 * t247 / 0.3e1 + t245 * t252 / 0.3e1 + t129 * t277;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2sigma20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t284 = 0.1e1 / t1 / t85;
  t287 = t185 * rho[0];
  t289 = 0.1e1 / t10 / t287;
  t290 = sigma[0] * t289;
  t297 = t91 * t91;
  t298 = t67 * t67;
  t299 = 0.1e1 / t298;
  t300 = t297 * t299;
  t302 = 0.1e1 / t1 / t185;
  t303 = t300 * t302;
  t305 = 0.1e1 / t185;
  t306 = t194 * t305;
  t308 = t92 * t87;
  t310 = t15 * t284;
  t312 = -0.7e1 / 0.324e3 * t303 + 0.35e2 / 0.324e3 * t306 - 0.91e2 / 0.486e3 * t308 + 0.49e2 / 0.486e3 * t310;
  t318 = -t303 / 0.81e2 + 0.5e1 / 0.81e2 * t306 - 0.26e2 / 0.243e3 * t308 + 0.14e2 / 0.243e3 * t310;
  t319 = t318 * sigma[0];
  t325 = t289 * t31;
  t332 = 0.2e1 / 0.9e1 * t303 - 0.1e2 / 0.9e1 * t306 + 0.52e2 / 0.27e2 * t308 - 0.28e2 / 0.27e2 * t310;
  t333 = t332 * sigma[0];
  t340 = t289 * t44;
  t346 = t49 * t289 * t31;
  t352 = 0.1232e4 / 0.27e2 * t290 * t18 - 0.88e2 / 0.3e1 * t188 * t98 + 0.8e1 * t88 * t202 - t13 * t312 + t319 * t37 / 0.8e1 - t208 * t104 + 0.11e2 / 0.3e1 * t101 * t213 - 0.154e3 / 0.27e2 * t36 * t325 + t333 * t45 / 0.144e3 - t220 * t112 / 0.18e2 + 0.11e2 / 0.54e2 * t109 * t225 - 0.77e2 / 0.243e3 * t41 * t340 - t48 * (-0.4928e4 / 0.81e2 * t50 * t325 + 0.616e3 / 0.27e2 * t54 * t346) / 0.8e1;
  t355 = t299 * t193;
  t358 = t74 * t284;
  t361 = t74 * t87;
  t364 = t161 * t305;
  t367 = t166 * t178;
  t370 = t74 * t305;
  t371 = t7 * t149;
  t372 = t371 * t174;
  t386 = t161 * t87;
  t391 = t160 * params->c;
  t392 = params->b * t391;
  t393 = t392 * t305;
  t396 = t76 * t237;
  t398 = t124 * t91;
  t402 = t8 * t299;
  t403 = t62 * t193;
  t407 = t237 * params->d;
  t410 = 0.8e1 / 0.9e1 * t150 * t87 - 0.28e2 / 0.27e2 * t69 * t284 + t8 * t5 * t352 - 0.2e1 / 0.9e1 * t355 * t305 + 0.28e2 / 0.27e2 * t358 * t77 - 0.8e1 / 0.9e1 * t361 * t167 + t364 * t167 / 0.9e1 + 0.2e1 / 0.3e1 * t165 * t367 + 0.2e1 / 0.9e1 * t370 * t372 - 0.8e1 / 0.9e1 * t173 * t174 * t87 - 0.4e1 / 0.3e1 * t80 * t178 * t154 + 0.28e2 / 0.27e2 * t80 * t81 * t284 - 0.4e1 / 0.3e1 * t157 * t170 - 0.4e1 / 0.9e1 * t386 * t77 + t162 * t170 / 0.3e1 + t393 * t77 / 0.27e2 + t75 * t396 + 0.2e1 / 0.3e1 * t173 * t398 * t12 + 0.2e1 / 0.9e1 * t402 * t403 * t305 + t80 * t407 * t71;
  tv3rho30 = 0.3e1 * params->a * t240 + t66 * t410;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t412 = t242 * params->c;
  t413 = t71 * t7;
  t417 = t242 * t7;
  t418 = t68 * t144;
  t419 = params->d * t71;
  t425 = t94 * params->a;
  t426 = t425 * params->b;
  t427 = t160 * t7;
  t431 = t425 * t74;
  t434 = t5 * t276;
  t439 = t371 * t144 * t91;
  t443 = t166 * t276 * params->d;
  t475 = -0.88e2 / 0.9e1 * t187 * t18 + 0.16e2 / 0.3e1 * t87 * t98 - t12 * t202 + t207 * t12 * t31 / 0.8e1 - 0.2e1 / 0.3e1 * t100 * t87 * t31 + 0.11e2 / 0.9e1 * t35 * t187 * t31 + t219 * t12 * t44 / 0.144e3 - t108 * t87 * t44 / 0.27e2 + 0.11e2 / 0.162e3 * t40 * t187 * t44 - t48 * (0.352e3 / 0.27e2 * t231 - 0.44e2 / 0.9e1 * t138 * t213) / 0.8e1;
  t476 = t76 * t475;
  tv3rho2sigma0 = 0.2e1 / 0.9e1 * t412 * t413 * t247 + 0.2e1 / 0.9e1 * t417 * t418 * t419 + 0.2e1 * t242 * t277 + t426 * t427 * t247 / 0.9e1 + 0.2e1 / 0.9e1 * t431 * t252 + 0.2e1 / 0.3e1 * t245 * t246 * t434 + 0.2e1 / 0.9e1 * t426 * t439 + 0.2e1 / 0.3e1 * t245 * t443 + t129 * t476;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3sigma30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t10;
  double t12, t13, t15, t16, t18, t20, t21, t22;
  double t23, t24, t26, t27, t28, t29, t31, t35;
  double t36, t37, t40, t41, t44, t45, t48, t49;
  double t50, t53, t54, t56, t62, tzk0;

  double t66, t67, t68, t69, t71, t74, t75, t76;
  double t77, t80, t81, t85, t87, t88, t91, t92;
  double t94, t97, t98, t100, t101, t104, t108, t109;
  double t112, t118, t124, t127, tvrho0, t129, t138, t144;
  double t145, tvsigma0;

  double t149, t150, t154, t157, t160, t161, t162, t165;
  double t166, t167, t170, t173, t174, t178, t185, t187;
  double t188, t193, t194, t195, t196, t198, t200, t202;
  double t207, t208, t213, t219, t220, t225, t231, t237;
  double t240, tv2rho20, t242, t245, t246, t247, t252, t276;
  double t277, tv2rhosigma0, tv2sigma20;

  double t284, t287, t289, t290, t297, t298, t299, t300;
  double t302, t303, t305, t306, t308, t310, t312, t318;
  double t319, t325, t332, t333, t340, t346, t352, t355;
  double t358, t361, t364, t367, t370, t371, t372, t386;
  double t391, t392, t393, t396, t398, t402, t403, t407;
  double t410, tv3rho30, t412, t413, t417, t418, t419, t425;
  double t426, t427, t431, t434, t439, t443, t475, t476;
  double tv3rho2sigma0, tv3rhosigma20, tv3sigma30;

  double t480, t484, t487, t502, t503, t523, t525, t527;
  double t529, t531, t565, t594, t604, t643, t661, tv4rho40;
  double t684, t685, t742, tv4rho3sigma0, tv4rho2sigma20, tv4rhosigma30, tv4sigma40;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = POW_1_3(rho[0]);
  t2 = 0.1e1 / t1;
  t4 = params->d * t2 + 0.1e1;
  t5 = 0.1e1 / t4;
  t7 = exp(-params->c * t2);
  t8 = params->b * t7;
  t9 = rho[0] * rho[0];
  t10 = t1 * t1;
  t12 = 0.1e1 / t10 / t9;
  t13 = sigma[0] * t12;
  t15 = params->d * t5 + params->c;
  t16 = t15 * t2;
  t18 = -0.1e1 / 0.72e2 - 0.7e1 / 0.72e2 * t16;
  t20 = M_CBRT3;
  t21 = t20 * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t26 = 0.1e1 <= p->zeta_threshold;
  t27 = p->zeta_threshold * p->zeta_threshold;
  t28 = POW_1_3(p->zeta_threshold);
  t29 = t28 * t28;
  t31 = my_piecewise3(t26, t29 * t27, 1);
  t35 = 0.5e1 / 0.2e1 - t16 / 0.18e2;
  t36 = t35 * sigma[0];
  t37 = t12 * t31;
  t40 = t16 - 0.11e2;
  t41 = t40 * sigma[0];
  t44 = my_piecewise3(t26, t29 * t27 * p->zeta_threshold, 1);
  t45 = t12 * t44;
  t48 = M_CBRT2;
  t49 = t48 * t48;
  t50 = sigma[0] * t49;
  t53 = my_piecewise3(t26, t27, 1);
  t54 = t53 * sigma[0];
  t56 = t49 * t12 * t31;
  t62 = -t13 * t18 - 0.3e1 / 0.1e2 * t21 * t24 * t31 + t36 * t37 / 0.8e1 + t41 * t45 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t50 * t37 - t54 * t56 / 0.2e1) / 0.8e1;
  tzk0 = params->a * (t8 * t5 * t62 - t5);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = rho[0] * params->a;
  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t68 * params->d;
  t71 = 0.1e1 / t1 / rho[0];
  t74 = params->b * params->c;
  t75 = t74 * t71;
  t76 = t7 * t5;
  t77 = t76 * t62;
  t80 = t8 * t68;
  t81 = t62 * params->d;
  t85 = t9 * rho[0];
  t87 = 0.1e1 / t10 / t85;
  t88 = sigma[0] * t87;
  t91 = params->d * params->d;
  t92 = t91 * t68;
  t94 = 0.1e1 / t10 / rho[0];
  t97 = t15 * t71 - t92 * t94;
  t98 = 0.7e1 / 0.216e3 * t97;
  t100 = t97 / 0.54e2;
  t101 = t100 * sigma[0];
  t104 = t87 * t31;
  t108 = -t97 / 0.3e1;
  t109 = t108 * sigma[0];
  t112 = t87 * t44;
  t118 = t49 * t87 * t31;
  t124 = 0.8e1 / 0.3e1 * t88 * t18 - t13 * t98 + t101 * t37 / 0.8e1 - t36 * t104 / 0.3e1 + t109 * t45 / 0.144e3 - t41 * t112 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t50 * t104 + 0.4e1 / 0.3e1 * t54 * t118) / 0.8e1;
  t127 = -t69 * t71 / 0.3e1 + t75 * t77 / 0.3e1 + t80 * t81 * t71 / 0.3e1 + t8 * t5 * t124;
  tvrho0 = t66 * t127 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t129 = t66 * params->b;
  t138 = t53 * t49;
  t144 = -t12 * t18 + t35 * t12 * t31 / 0.8e1 + t40 * t12 * t44 / 0.144e3 - t48 * (0.4e1 / 0.3e1 * t56 - t138 * t37 / 0.2e1) / 0.8e1;
  t145 = t76 * t144;
  tvsigma0 = t129 * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t149 = 0.1e1 / t67 / t4;
  t150 = t149 * t91;
  t154 = 0.1e1 / t1 / t9;
  t157 = t74 * t154;
  t160 = params->c * params->c;
  t161 = params->b * t160;
  t162 = t161 * t12;
  t165 = t74 * t12;
  t166 = t7 * t68;
  t167 = t166 * t81;
  t170 = t76 * t124;
  t173 = t8 * t149;
  t174 = t62 * t91;
  t178 = t124 * params->d;
  t185 = t9 * t9;
  t187 = 0.1e1 / t10 / t185;
  t188 = sigma[0] * t187;
  t193 = t91 * params->d;
  t194 = t193 * t149;
  t195 = 0.1e1 / t85;
  t196 = t194 * t195;
  t198 = t92 * t12;
  t200 = t15 * t154;
  t202 = -0.7e1 / 0.324e3 * t196 + 0.7e1 / 0.108e3 * t198 - 0.7e1 / 0.162e3 * t200;
  t207 = -t196 / 0.81e2 + t198 / 0.27e2 - 0.2e1 / 0.81e2 * t200;
  t208 = t207 * sigma[0];
  t213 = t187 * t31;
  t219 = 0.2e1 / 0.9e1 * t196 - 0.2e1 / 0.3e1 * t198 + 0.4e1 / 0.9e1 * t200;
  t220 = t219 * sigma[0];
  t225 = t187 * t44;
  t231 = t49 * t187 * t31;
  t237 = -0.88e2 / 0.9e1 * t188 * t18 + 0.16e2 / 0.3e1 * t88 * t98 - t13 * t202 + t208 * t37 / 0.8e1 - 0.2e1 / 0.3e1 * t101 * t104 + 0.11e2 / 0.9e1 * t36 * t213 + t220 * t45 / 0.144e3 - t109 * t112 / 0.27e2 + 0.11e2 / 0.162e3 * t41 * t225 - t48 * (0.352e3 / 0.27e2 * t50 * t213 - 0.44e2 / 0.9e1 * t54 * t231) / 0.8e1;
  t240 = -0.2e1 / 0.9e1 * t150 * t12 + 0.4e1 / 0.9e1 * t69 * t154 - 0.4e1 / 0.9e1 * t157 * t77 + t162 * t77 / 0.9e1 + 0.2e1 / 0.9e1 * t165 * t167 + 0.2e1 / 0.3e1 * t75 * t170 + 0.2e1 / 0.9e1 * t173 * t174 * t12 + 0.2e1 / 0.3e1 * t80 * t178 * t71 - 0.4e1 / 0.9e1 * t80 * t81 * t154 + t8 * t5 * t237;
  tv2rho20 = 0.2e1 * params->a * t127 + t66 * t240;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t242 = params->a * params->b;
  t245 = t2 * params->a * params->b;
  t246 = params->c * t7;
  t247 = t5 * t144;
  t252 = t166 * t144 * params->d;
  t276 = 0.8e1 / 0.3e1 * t87 * t18 - t12 * t98 + t100 * t12 * t31 / 0.8e1 - t35 * t87 * t31 / 0.3e1 + t108 * t12 * t44 / 0.144e3 - t40 * t87 * t44 / 0.54e2 - t48 * (-0.32e2 / 0.9e1 * t118 + 0.4e1 / 0.3e1 * t138 * t104) / 0.8e1;
  t277 = t76 * t276;
  tv2rhosigma0 = t242 * t145 + t245 * t246 * t247 / 0.3e1 + t245 * t252 / 0.3e1 + t129 * t277;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2sigma20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t284 = 0.1e1 / t1 / t85;
  t287 = t185 * rho[0];
  t289 = 0.1e1 / t10 / t287;
  t290 = sigma[0] * t289;
  t297 = t91 * t91;
  t298 = t67 * t67;
  t299 = 0.1e1 / t298;
  t300 = t297 * t299;
  t302 = 0.1e1 / t1 / t185;
  t303 = t300 * t302;
  t305 = 0.1e1 / t185;
  t306 = t194 * t305;
  t308 = t92 * t87;
  t310 = t15 * t284;
  t312 = -0.7e1 / 0.324e3 * t303 + 0.35e2 / 0.324e3 * t306 - 0.91e2 / 0.486e3 * t308 + 0.49e2 / 0.486e3 * t310;
  t318 = -t303 / 0.81e2 + 0.5e1 / 0.81e2 * t306 - 0.26e2 / 0.243e3 * t308 + 0.14e2 / 0.243e3 * t310;
  t319 = t318 * sigma[0];
  t325 = t289 * t31;
  t332 = 0.2e1 / 0.9e1 * t303 - 0.1e2 / 0.9e1 * t306 + 0.52e2 / 0.27e2 * t308 - 0.28e2 / 0.27e2 * t310;
  t333 = t332 * sigma[0];
  t340 = t289 * t44;
  t346 = t49 * t289 * t31;
  t352 = 0.1232e4 / 0.27e2 * t290 * t18 - 0.88e2 / 0.3e1 * t188 * t98 + 0.8e1 * t88 * t202 - t13 * t312 + t319 * t37 / 0.8e1 - t208 * t104 + 0.11e2 / 0.3e1 * t101 * t213 - 0.154e3 / 0.27e2 * t36 * t325 + t333 * t45 / 0.144e3 - t220 * t112 / 0.18e2 + 0.11e2 / 0.54e2 * t109 * t225 - 0.77e2 / 0.243e3 * t41 * t340 - t48 * (-0.4928e4 / 0.81e2 * t50 * t325 + 0.616e3 / 0.27e2 * t54 * t346) / 0.8e1;
  t355 = t299 * t193;
  t358 = t74 * t284;
  t361 = t74 * t87;
  t364 = t161 * t305;
  t367 = t166 * t178;
  t370 = t74 * t305;
  t371 = t7 * t149;
  t372 = t371 * t174;
  t386 = t161 * t87;
  t391 = t160 * params->c;
  t392 = params->b * t391;
  t393 = t392 * t305;
  t396 = t76 * t237;
  t398 = t124 * t91;
  t402 = t8 * t299;
  t403 = t62 * t193;
  t407 = t237 * params->d;
  t410 = 0.8e1 / 0.9e1 * t150 * t87 - 0.28e2 / 0.27e2 * t69 * t284 + t8 * t5 * t352 - 0.2e1 / 0.9e1 * t355 * t305 + 0.28e2 / 0.27e2 * t358 * t77 - 0.8e1 / 0.9e1 * t361 * t167 + t364 * t167 / 0.9e1 + 0.2e1 / 0.3e1 * t165 * t367 + 0.2e1 / 0.9e1 * t370 * t372 - 0.8e1 / 0.9e1 * t173 * t174 * t87 - 0.4e1 / 0.3e1 * t80 * t178 * t154 + 0.28e2 / 0.27e2 * t80 * t81 * t284 - 0.4e1 / 0.3e1 * t157 * t170 - 0.4e1 / 0.9e1 * t386 * t77 + t162 * t170 / 0.3e1 + t393 * t77 / 0.27e2 + t75 * t396 + 0.2e1 / 0.3e1 * t173 * t398 * t12 + 0.2e1 / 0.9e1 * t402 * t403 * t305 + t80 * t407 * t71;
  tv3rho30 = 0.3e1 * params->a * t240 + t66 * t410;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t412 = t242 * params->c;
  t413 = t71 * t7;
  t417 = t242 * t7;
  t418 = t68 * t144;
  t419 = params->d * t71;
  t425 = t94 * params->a;
  t426 = t425 * params->b;
  t427 = t160 * t7;
  t431 = t425 * t74;
  t434 = t5 * t276;
  t439 = t371 * t144 * t91;
  t443 = t166 * t276 * params->d;
  t475 = -0.88e2 / 0.9e1 * t187 * t18 + 0.16e2 / 0.3e1 * t87 * t98 - t12 * t202 + t207 * t12 * t31 / 0.8e1 - 0.2e1 / 0.3e1 * t100 * t87 * t31 + 0.11e2 / 0.9e1 * t35 * t187 * t31 + t219 * t12 * t44 / 0.144e3 - t108 * t87 * t44 / 0.27e2 + 0.11e2 / 0.162e3 * t40 * t187 * t44 - t48 * (0.352e3 / 0.27e2 * t231 - 0.44e2 / 0.9e1 * t138 * t213) / 0.8e1;
  t476 = t76 * t475;
  tv3rho2sigma0 = 0.2e1 / 0.9e1 * t412 * t413 * t247 + 0.2e1 / 0.9e1 * t417 * t418 * t419 + 0.2e1 * t242 * t277 + t426 * t427 * t247 / 0.9e1 + 0.2e1 / 0.9e1 * t431 * t252 + 0.2e1 / 0.3e1 * t245 * t246 * t434 + 0.2e1 / 0.9e1 * t426 * t439 + 0.2e1 / 0.3e1 * t245 * t443 + t129 * t476;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rhosigma20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3sigma30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t480 = 0.1e1 / t287;
  t484 = 0.1e1 / t298 / t4;
  t487 = 0.1e1 / t1 / t287;
  t502 = 0.1e1 / t10 / t185 / t9;
  t503 = t502 * t31;
  t523 = t297 * params->d * t484 * t289;
  t525 = t300 * t487;
  t527 = t194 * t480;
  t529 = t92 * t187;
  t531 = t15 * t302;
  t565 = -0.4e1 / 0.3e1 * t319 * t104 + 0.22e2 / 0.3e1 * t208 * t213 - 0.616e3 / 0.27e2 * t101 * t325 + 0.2618e4 / 0.81e2 * t36 * t503 - 0.2e1 / 0.27e2 * t333 * t112 + 0.11e2 / 0.27e2 * t220 * t225 - 0.308e3 / 0.243e3 * t109 * t340 + 0.1309e4 / 0.729e3 * t41 * t502 * t44 + 0.4928e4 / 0.27e2 * t290 * t98 - 0.176e3 / 0.3e1 * t188 * t202 + 0.32e2 / 0.3e1 * t88 * t312 - t13 * (-0.7e1 / 0.243e3 * t523 + 0.49e2 / 0.243e3 * t525 - 0.406e3 / 0.729e3 * t527 + 0.175e3 / 0.243e3 * t529 - 0.245e3 / 0.729e3 * t531) - 0.20944e5 / 0.81e2 * sigma[0] * t502 * t18 + (-0.4e1 / 0.243e3 * t523 + 0.28e2 / 0.243e3 * t525 - 0.232e3 / 0.729e3 * t527 + 0.1e3 / 0.243e3 * t529 - 0.14e3 / 0.729e3 * t531) * sigma[0] * t37 / 0.8e1 + (0.8e1 / 0.27e2 * t523 - 0.56e2 / 0.27e2 * t525 + 0.464e3 / 0.81e2 * t527 - 0.2e3 / 0.27e2 * t529 + 0.28e3 / 0.81e2 * t531) * sigma[0] * t45 / 0.144e3 - t48 * (0.83776e5 / 0.243e3 * t50 * t503 - 0.10472e5 / 0.81e2 * t54 * t49 * t502 * t31) / 0.8e1;
  t594 = t7 * t299;
  t604 = 0.16e2 / 0.9e1 * t355 * t480 - 0.8e1 / 0.27e2 * t484 * t297 * t487 - 0.32e3 / 0.81e2 * t150 * t187 + 0.28e3 / 0.81e2 * t69 * t302 + t8 * t5 * t565 + 0.32e3 / 0.81e2 * t74 * t187 * t167 - 0.32e2 / 0.9e1 * t361 * t367 - 0.8e1 / 0.9e1 * t161 * t480 * t167 - 0.16e2 / 0.9e1 * t74 * t480 * t372 + 0.4e1 / 0.9e1 * t364 * t367 + 0.4e1 / 0.81e2 * t392 * t487 * t167 + 0.4e1 / 0.27e2 * t161 * t487 * t372 + 0.4e1 / 0.3e1 * t165 * t166 * t407 + 0.8e1 / 0.9e1 * t370 * t371 * t398 + 0.8e1 / 0.27e2 * t74 * t487 * t594 * t403 - 0.28e3 / 0.81e2 * t74 * t302 * t77 + 0.32e3 / 0.81e2 * t173 * t174 * t187;
  t643 = t160 * t160;
  t661 = 0.112e3 / 0.27e2 * t80 * t178 * t284 - 0.28e3 / 0.81e2 * t80 * t81 * t302 + 0.4e1 / 0.3e1 * t75 * t76 * t352 + 0.4e1 / 0.3e1 * t80 * t352 * params->d * t71 + 0.112e3 / 0.27e2 * t358 * t170 + 0.16e3 / 0.81e2 * t161 * t187 * t77 - 0.32e2 / 0.9e1 * t173 * t398 * t87 - 0.16e2 / 0.9e1 * t402 * t403 * t480 - 0.8e1 / 0.3e1 * t80 * t407 * t154 - 0.8e1 / 0.3e1 * t157 * t396 - 0.16e2 / 0.9e1 * t386 * t170 - 0.8e1 / 0.27e2 * t392 * t480 * t77 + 0.2e1 / 0.3e1 * t162 * t396 + 0.4e1 / 0.27e2 * t393 * t170 + params->b * t643 * t487 * t77 / 0.81e2 + 0.4e1 / 0.3e1 * t173 * t237 * t91 * t12 + 0.8e1 / 0.9e1 * t402 * t124 * t193 * t305 + 0.8e1 / 0.27e2 * t8 * t484 * t62 * t297 * t487;
  tv4rho40 = 0.4e1 * params->a * t410 + t66 * (t604 + t661);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t684 = t195 * params->a;
  t685 = t684 * params->b;
  t742 = 0.1232e4 / 0.27e2 * t289 * t18 - 0.88e2 / 0.3e1 * t187 * t98 + 0.8e1 * t87 * t202 - t12 * t312 + t318 * t12 * t31 / 0.8e1 - t207 * t87 * t31 + 0.11e2 / 0.3e1 * t100 * t187 * t31 - 0.154e3 / 0.27e2 * t35 * t289 * t31 + t332 * t12 * t44 / 0.144e3 - t219 * t87 * t44 / 0.18e2 + 0.11e2 / 0.54e2 * t108 * t187 * t44 - 0.77e2 / 0.243e3 * t40 * t289 * t44 - t48 * (-0.4928e4 / 0.81e2 * t346 + 0.616e3 / 0.27e2 * t138 * t325) / 0.8e1;
  tv4rho3sigma0 = 0.2e1 / 0.3e1 * t412 * t413 * t434 - t242 * t160 * t12 * t7 * t247 / 0.9e1 + 0.2e1 / 0.3e1 * t417 * t68 * t276 * t419 - 0.2e1 / 0.9e1 * t417 * t149 * t144 * t91 * t12 + t426 * t427 * t434 / 0.3e1 + t685 * t391 * t7 * t247 / 0.27e2 + t245 * t246 * t5 * t475 + 0.2e1 / 0.3e1 * t426 * t371 * t276 * t91 + 0.2e1 / 0.9e1 * t685 * t594 * t144 * t193 + t245 * t166 * t475 * params->d + 0.3e1 * t242 * t476 + t129 * t76 * t742 - 0.8e1 / 0.27e2 * t412 * t154 * t7 * t247 - 0.2e1 / 0.9e1 * t242 * params->c * t12 * t252 - 0.8e1 / 0.27e2 * t417 * t418 * params->d * t154 + t684 * t161 * t252 / 0.9e1 + 0.2e1 / 0.3e1 * t431 * t443 + 0.2e1 / 0.9e1 * t684 * t74 * t439;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rhosigma30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4sigma40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t9;
  double t11, t12, t15, t16, t18, t19, t21, t22;
  double t24, t25, t27, t30, t32, t33, t34, t35;
  double t36, t37, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t49, t50, t51;
  double t52, t53, t54, t55, t56, t57, t58, t62;
  double t63, t65, t66, t67, t68, t70, t71, t72;
  double t73, t74, t75, t77, t78, t79, t80, t81;
  double t84, t86, t89, t93, t95, t96, t101, t102;
  double t103, t106, t107, t108, t114, tzk0;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = POW_1_3(t3);
  t9 = 0.1e1 / t8;
  t11 = params->d * t9 + 0.1e1;
  t12 = 0.1e1 / t11;
  t15 = exp(-params->c * t9);
  t16 = params->b * t15;
  t18 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t19 = t8 * t8;
  t21 = 0.1e1 / t19 / t4;
  t22 = t18 * t21;
  t24 = params->d * t12 + params->c;
  t25 = t24 * t9;
  t27 = 0.47e2 - 0.7e1 * t25;
  t30 = t7 * t27 / 0.72e2 - 0.2e1 / 0.3e1;
  t32 = M_CBRT3;
  t33 = t32 * t32;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = t33 * t36;
  t38 = 0.1e1 / t3;
  t39 = t1 * t38;
  t40 = 0.1e1 + t39;
  t41 = t40 <= p->zeta_threshold;
  t42 = p->zeta_threshold * p->zeta_threshold;
  t43 = POW_1_3(p->zeta_threshold);
  t44 = t43 * t43;
  t45 = t44 * t42;
  t46 = t40 * t40;
  t47 = POW_1_3(t40);
  t48 = t47 * t47;
  t49 = t48 * t46;
  t50 = my_piecewise3(t41, t45, t49);
  t51 = 0.1e1 - t39;
  t52 = t51 <= p->zeta_threshold;
  t53 = t51 * t51;
  t54 = POW_1_3(t51);
  t55 = t54 * t54;
  t56 = t55 * t53;
  t57 = my_piecewise3(t52, t45, t56);
  t58 = t50 + t57;
  t62 = M_CBRT2;
  t63 = t62 * t7;
  t65 = 0.5e1 / 0.2e1 - t25 / 0.18e2;
  t66 = rho[0] * rho[0];
  t67 = POW_1_3(rho[0]);
  t68 = t67 * t67;
  t70 = 0.1e1 / t68 / t66;
  t71 = sigma[0] * t70;
  t72 = t71 * t50;
  t73 = rho[1] * rho[1];
  t74 = POW_1_3(rho[1]);
  t75 = t74 * t74;
  t77 = 0.1e1 / t75 / t73;
  t78 = sigma[2] * t77;
  t79 = t78 * t57;
  t80 = t72 + t79;
  t81 = t65 * t80;
  t84 = t25 - 0.11e2;
  t86 = t44 * t42 * p->zeta_threshold;
  t89 = my_piecewise3(t41, t86, t48 * t46 * t40);
  t93 = my_piecewise3(t52, t86, t55 * t53 * t51);
  t95 = t71 * t89 + t78 * t93;
  t96 = t84 * t95;
  t101 = my_piecewise3(t41, t42, t46);
  t102 = t101 * sigma[2];
  t103 = t77 * t57;
  t106 = my_piecewise3(t52, t42, t53);
  t107 = t106 * sigma[0];
  t108 = t70 * t50;
  t114 = -t22 * t30 - 0.3e1 / 0.2e2 * t37 * t7 * t58 + t63 * t81 / 0.32e2 + t63 * t96 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t72 + 0.2e1 / 0.3e1 * t79 - t102 * t103 / 0.4e1 - t107 * t108 / 0.4e1) / 0.8e1;
  tzk0 = params->a * (t16 * t12 * t114 - t7 * t12);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t9;
  double t11, t12, t15, t16, t18, t19, t21, t22;
  double t24, t25, t27, t30, t32, t33, t34, t35;
  double t36, t37, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t49, t50, t51;
  double t52, t53, t54, t55, t56, t57, t58, t62;
  double t63, t65, t66, t67, t68, t70, t71, t72;
  double t73, t74, t75, t77, t78, t79, t80, t81;
  double t84, t86, t89, t93, t95, t96, t101, t102;
  double t103, t106, t107, t108, t114, tzk0;

  double t118, t119, t120, t121, t122, t124, t126, t127;
  double t128, t130, t131, t133, t134, t135, t136, t137;
  double t139, t140, t141, t144, t146, t147, t149, t151;
  double t152, t154, t157, t158, t159, t161, t166, t167;
  double t168, t170, t171, t172, t173, t175, t176, t180;
  double t183, t184, t186, t189, t190, t191, t193, t194;
  double t195, t196, t202, t203, t205, t210, t214, t216;
  double t217, t225, t226, t229, t234, t235, t238, t241;
  double t247, t250, tvrho0, t253, t257, t262, t263, t265;
  double t266, t267, t269, t270, t274, t277, t280, t281;
  double t282, t284, t285, t286, t293, t299, t301, t302;
  double t310, t311, t314, t317, t322, t323, t326, t332;
  double t335, tvrho1, t337, t338, t339, t340, t343, t344;
  double t348, t354, t355, tvsigma0, t356, t357, t358, tvsigma1;
  double t361, t362, t365, t366, t370, t376, t377, tvsigma2;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = POW_1_3(t3);
  t9 = 0.1e1 / t8;
  t11 = params->d * t9 + 0.1e1;
  t12 = 0.1e1 / t11;
  t15 = exp(-params->c * t9);
  t16 = params->b * t15;
  t18 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t19 = t8 * t8;
  t21 = 0.1e1 / t19 / t4;
  t22 = t18 * t21;
  t24 = params->d * t12 + params->c;
  t25 = t24 * t9;
  t27 = 0.47e2 - 0.7e1 * t25;
  t30 = t7 * t27 / 0.72e2 - 0.2e1 / 0.3e1;
  t32 = M_CBRT3;
  t33 = t32 * t32;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = t33 * t36;
  t38 = 0.1e1 / t3;
  t39 = t1 * t38;
  t40 = 0.1e1 + t39;
  t41 = t40 <= p->zeta_threshold;
  t42 = p->zeta_threshold * p->zeta_threshold;
  t43 = POW_1_3(p->zeta_threshold);
  t44 = t43 * t43;
  t45 = t44 * t42;
  t46 = t40 * t40;
  t47 = POW_1_3(t40);
  t48 = t47 * t47;
  t49 = t48 * t46;
  t50 = my_piecewise3(t41, t45, t49);
  t51 = 0.1e1 - t39;
  t52 = t51 <= p->zeta_threshold;
  t53 = t51 * t51;
  t54 = POW_1_3(t51);
  t55 = t54 * t54;
  t56 = t55 * t53;
  t57 = my_piecewise3(t52, t45, t56);
  t58 = t50 + t57;
  t62 = M_CBRT2;
  t63 = t62 * t7;
  t65 = 0.5e1 / 0.2e1 - t25 / 0.18e2;
  t66 = rho[0] * rho[0];
  t67 = POW_1_3(rho[0]);
  t68 = t67 * t67;
  t70 = 0.1e1 / t68 / t66;
  t71 = sigma[0] * t70;
  t72 = t71 * t50;
  t73 = rho[1] * rho[1];
  t74 = POW_1_3(rho[1]);
  t75 = t74 * t74;
  t77 = 0.1e1 / t75 / t73;
  t78 = sigma[2] * t77;
  t79 = t78 * t57;
  t80 = t72 + t79;
  t81 = t65 * t80;
  t84 = t25 - 0.11e2;
  t86 = t44 * t42 * p->zeta_threshold;
  t89 = my_piecewise3(t41, t86, t48 * t46 * t40);
  t93 = my_piecewise3(t52, t86, t55 * t53 * t51);
  t95 = t71 * t89 + t78 * t93;
  t96 = t84 * t95;
  t101 = my_piecewise3(t41, t42, t46);
  t102 = t101 * sigma[2];
  t103 = t77 * t57;
  t106 = my_piecewise3(t52, t42, t53);
  t107 = t106 * sigma[0];
  t108 = t70 * t50;
  t114 = -t22 * t30 - 0.3e1 / 0.2e2 * t37 * t7 * t58 + t63 * t81 / 0.32e2 + t63 * t96 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t72 + 0.2e1 / 0.3e1 * t79 - t102 * t103 / 0.4e1 - t107 * t108 / 0.4e1) / 0.8e1;
  tzk0 = params->a * (t16 * t12 * t114 - t7 * t12);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t118 = t3 * params->a;
  t119 = t1 * t5;
  t120 = t4 * t3;
  t121 = 0.1e1 / t120;
  t122 = t2 * t121;
  t124 = -0.2e1 * t119 + 0.2e1 * t122;
  t126 = t11 * t11;
  t127 = 0.1e1 / t126;
  t128 = t7 * t127;
  t130 = 0.1e1 / t8 / t3;
  t131 = params->d * t130;
  t133 = t128 * t131 / 0.3e1;
  t134 = params->b * params->c;
  t135 = t134 * t130;
  t136 = t15 * t12;
  t137 = t136 * t114;
  t139 = t135 * t137 / 0.3e1;
  t140 = t16 * t127;
  t141 = t114 * params->d;
  t144 = t140 * t141 * t130 / 0.3e1;
  t146 = 0.1e1 / t19 / t120;
  t147 = t18 * t146;
  t149 = 0.8e1 / 0.3e1 * t147 * t30;
  t151 = params->d * params->d;
  t152 = t151 * t127;
  t154 = 0.1e1 / t19 / t3;
  t157 = t24 * t130 - t152 * t154;
  t158 = 0.7e1 / 0.3e1 * t157;
  t159 = t7 * t158;
  t161 = t124 * t27 / 0.72e2 + t159 / 0.72e2;
  t166 = t48 * t40;
  t167 = t38 - t119;
  t168 = t166 * t167;
  t170 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t168);
  t171 = t55 * t51;
  t172 = -t167;
  t173 = t171 * t172;
  t175 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t173);
  t176 = t170 + t175;
  t180 = t62 * t124;
  t183 = t157 / 0.54e2;
  t184 = t183 * t80;
  t186 = t63 * t184 / 0.32e2;
  t189 = 0.1e1 / t68 / t66 / rho[0];
  t190 = sigma[0] * t189;
  t191 = t190 * t50;
  t193 = t71 * t170;
  t194 = t78 * t175;
  t195 = -0.8e1 / 0.3e1 * t191 + t193 + t194;
  t196 = t65 * t195;
  t202 = -t157 / 0.3e1;
  t203 = t202 * t95;
  t205 = t63 * t203 / 0.576e3;
  t210 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t167);
  t214 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t172);
  t216 = -0.8e1 / 0.3e1 * t190 * t89 + t71 * t210 + t78 * t214;
  t217 = t84 * t216;
  t225 = my_piecewise3(t41, 0, 0.2e1 * t40 * t167);
  t226 = t225 * sigma[2];
  t229 = t77 * t175;
  t234 = my_piecewise3(t52, 0, 0.2e1 * t51 * t172);
  t235 = t234 * sigma[0];
  t238 = t189 * t50;
  t241 = t70 * t170;
  t247 = t149 - t22 * t161 - 0.3e1 / 0.2e2 * t37 * t124 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t176 + t180 * t81 / 0.32e2 + t186 + t63 * t196 / 0.32e2 + t180 * t96 / 0.576e3 + t205 + t63 * t217 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t191 + 0.2e1 / 0.3e1 * t193 + 0.2e1 / 0.3e1 * t194 - t226 * t103 / 0.4e1 - t102 * t229 / 0.4e1 - t235 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t238 - t107 * t241 / 0.4e1) / 0.8e1;
  t250 = t16 * t12 * t247 - t124 * t12 - t133 + t139 + t144;
  tvrho0 = t118 * t250 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t253 = 0.2e1 * t119 + 0.2e1 * t122;
  t257 = t253 * t27 / 0.72e2 + t159 / 0.72e2;
  t262 = -t38 - t119;
  t263 = t166 * t262;
  t265 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t263);
  t266 = -t262;
  t267 = t171 * t266;
  t269 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t267);
  t270 = t265 + t269;
  t274 = t62 * t253;
  t277 = t71 * t265;
  t280 = 0.1e1 / t75 / t73 / rho[1];
  t281 = sigma[2] * t280;
  t282 = t281 * t57;
  t284 = t78 * t269;
  t285 = t277 - 0.8e1 / 0.3e1 * t282 + t284;
  t286 = t65 * t285;
  t293 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t262);
  t299 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t266);
  t301 = t71 * t293 - 0.8e1 / 0.3e1 * t281 * t93 + t78 * t299;
  t302 = t84 * t301;
  t310 = my_piecewise3(t41, 0, 0.2e1 * t40 * t262);
  t311 = t310 * sigma[2];
  t314 = t280 * t57;
  t317 = t77 * t269;
  t322 = my_piecewise3(t52, 0, 0.2e1 * t51 * t266);
  t323 = t322 * sigma[0];
  t326 = t70 * t265;
  t332 = t149 - t22 * t257 - 0.3e1 / 0.2e2 * t37 * t253 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t270 + t274 * t81 / 0.32e2 + t186 + t63 * t286 / 0.32e2 + t274 * t96 / 0.576e3 + t205 + t63 * t302 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t277 - 0.16e2 / 0.9e1 * t282 + 0.2e1 / 0.3e1 * t284 - t311 * t103 / 0.4e1 + 0.2e1 / 0.3e1 * t102 * t314 - t102 * t317 / 0.4e1 - t323 * t108 / 0.4e1 - t107 * t326 / 0.4e1) / 0.8e1;
  t335 = t16 * t12 * t332 - t253 * t12 - t133 + t139 + t144;
  tvrho1 = t118 * t335 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t337 = t118 * params->b;
  t338 = t21 * t30;
  t339 = t65 * t70;
  t340 = t339 * t50;
  t343 = t84 * t70;
  t344 = t343 * t89;
  t348 = t106 * t70;
  t354 = -t338 + t63 * t340 / 0.32e2 + t63 * t344 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t108 - t348 * t50 / 0.4e1) / 0.8e1;
  t355 = t136 * t354;
  tvsigma0 = t337 * t355;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t356 = t154 * params->a;
  t357 = t356 * params->b;
  t358 = t136 * t30;
  tvsigma1 = -0.2e1 * t357 * t358;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t361 = t65 * t77;
  t362 = t361 * t57;
  t365 = t84 * t77;
  t366 = t365 * t93;
  t370 = t101 * t77;
  t376 = -t338 + t63 * t362 / 0.32e2 + t63 * t366 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t103 - t370 * t57 / 0.4e1) / 0.8e1;
  t377 = t136 * t376;
  tvsigma2 = t337 * t377;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t9;
  double t11, t12, t15, t16, t18, t19, t21, t22;
  double t24, t25, t27, t30, t32, t33, t34, t35;
  double t36, t37, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t49, t50, t51;
  double t52, t53, t54, t55, t56, t57, t58, t62;
  double t63, t65, t66, t67, t68, t70, t71, t72;
  double t73, t74, t75, t77, t78, t79, t80, t81;
  double t84, t86, t89, t93, t95, t96, t101, t102;
  double t103, t106, t107, t108, t114, tzk0;

  double t118, t119, t120, t121, t122, t124, t126, t127;
  double t128, t130, t131, t133, t134, t135, t136, t137;
  double t139, t140, t141, t144, t146, t147, t149, t151;
  double t152, t154, t157, t158, t159, t161, t166, t167;
  double t168, t170, t171, t172, t173, t175, t176, t180;
  double t183, t184, t186, t189, t190, t191, t193, t194;
  double t195, t196, t202, t203, t205, t210, t214, t216;
  double t217, t225, t226, t229, t234, t235, t238, t241;
  double t247, t250, tvrho0, t253, t257, t262, t263, t265;
  double t266, t267, t269, t270, t274, t277, t280, t281;
  double t282, t284, t285, t286, t293, t299, t301, t302;
  double t310, t311, t314, t317, t322, t323, t326, t332;
  double t335, tvrho1, t337, t338, t339, t340, t343, t344;
  double t348, t354, t355, tvsigma0, t356, t357, t358, tvsigma1;
  double t361, t362, t365, t366, t370, t376, t377, tvsigma2;

  double t378, t380, t381, t382, t383, t384, t386, t387;
  double t389, t390, t393, t394, t395, t397, t399, t400;
  double t402, t403, t405, t406, t407, t408, t410, t411;
  double t412, t413, t415, t416, t417, t419, t420, t423;
  double t424, t426, t430, t432, t433, t435, t442, t443;
  double t446, t450, t451, t452, t454, t458, t459, t463;
  double t466, t470, t471, t472, t474, t476, t478, t479;
  double t481, t482, t483, t485, t487, t488, t489, t491;
  double t493, t494, t495, t496, t501, t508, t509, t511;
  double t512, t513, t524, t531, t533, t534, t537, t541;
  double t546, t547, t548, t549, t558, t559, t564, t570;
  double t571, t578, t581, t584, t587, t590, t593, tv2rho20;
  double t595, t596, t598, t599, t604, t605, t607, t609;
  double t611, t613, t616, t620, t621, t623, t625, t628;
  double t632, t633, t637, t641, t642, t649, t654, t659;
  double t663, t664, t673, t676, t679, t683, t685, t687;
  double t692, t693, t696, t699, t705, t706, t712, t716;
  double t722, t726, t728, t729, t735, t742, t748, t754;
  double t755, t761, t762, t765, tv2rho21, t768, t784, t785;
  double t788, t789, t792, t793, t794, t796, t797, t800;
  double t801, t805, t810, t811, t813, t814, t815, t817;
  double t819, t820, t821, t833, t844, t846, t847, t853;
  double t862, t863, t870, t873, t876, t882, t883, t888;
  double t891, t894, t897, tv2rho22, t899, t900, t902, t903;
  double t904, t907, t909, t911, t913, t914, t917, t918;
  double t920, t921, t922, t925, t930, t931, t933, t934;
  double t935, t938, t943, t946, t954, t955, tv2rhosigma0, t958;
  double t960, t961, t962, t963, t964, t966, t968, t970;
  double t971, tv2rhosigma1, t974, t975, t978, t980, t982, t985;
  double t986, t988, t989, t994, t995, t997, t998, t1002;
  double t1010, t1011, tv2rhosigma2, t1013, t1016, t1021, t1025, t1033;
  double t1034, tv2rhosigma3, t1036, tv2rhosigma4, t1041, t1042, t1045, t1050;
  double t1051, t1054, t1059, t1062, t1070, t1071, tv2rhosigma5, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = POW_1_3(t3);
  t9 = 0.1e1 / t8;
  t11 = params->d * t9 + 0.1e1;
  t12 = 0.1e1 / t11;
  t15 = exp(-params->c * t9);
  t16 = params->b * t15;
  t18 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t19 = t8 * t8;
  t21 = 0.1e1 / t19 / t4;
  t22 = t18 * t21;
  t24 = params->d * t12 + params->c;
  t25 = t24 * t9;
  t27 = 0.47e2 - 0.7e1 * t25;
  t30 = t7 * t27 / 0.72e2 - 0.2e1 / 0.3e1;
  t32 = M_CBRT3;
  t33 = t32 * t32;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = t33 * t36;
  t38 = 0.1e1 / t3;
  t39 = t1 * t38;
  t40 = 0.1e1 + t39;
  t41 = t40 <= p->zeta_threshold;
  t42 = p->zeta_threshold * p->zeta_threshold;
  t43 = POW_1_3(p->zeta_threshold);
  t44 = t43 * t43;
  t45 = t44 * t42;
  t46 = t40 * t40;
  t47 = POW_1_3(t40);
  t48 = t47 * t47;
  t49 = t48 * t46;
  t50 = my_piecewise3(t41, t45, t49);
  t51 = 0.1e1 - t39;
  t52 = t51 <= p->zeta_threshold;
  t53 = t51 * t51;
  t54 = POW_1_3(t51);
  t55 = t54 * t54;
  t56 = t55 * t53;
  t57 = my_piecewise3(t52, t45, t56);
  t58 = t50 + t57;
  t62 = M_CBRT2;
  t63 = t62 * t7;
  t65 = 0.5e1 / 0.2e1 - t25 / 0.18e2;
  t66 = rho[0] * rho[0];
  t67 = POW_1_3(rho[0]);
  t68 = t67 * t67;
  t70 = 0.1e1 / t68 / t66;
  t71 = sigma[0] * t70;
  t72 = t71 * t50;
  t73 = rho[1] * rho[1];
  t74 = POW_1_3(rho[1]);
  t75 = t74 * t74;
  t77 = 0.1e1 / t75 / t73;
  t78 = sigma[2] * t77;
  t79 = t78 * t57;
  t80 = t72 + t79;
  t81 = t65 * t80;
  t84 = t25 - 0.11e2;
  t86 = t44 * t42 * p->zeta_threshold;
  t89 = my_piecewise3(t41, t86, t48 * t46 * t40);
  t93 = my_piecewise3(t52, t86, t55 * t53 * t51);
  t95 = t71 * t89 + t78 * t93;
  t96 = t84 * t95;
  t101 = my_piecewise3(t41, t42, t46);
  t102 = t101 * sigma[2];
  t103 = t77 * t57;
  t106 = my_piecewise3(t52, t42, t53);
  t107 = t106 * sigma[0];
  t108 = t70 * t50;
  t114 = -t22 * t30 - 0.3e1 / 0.2e2 * t37 * t7 * t58 + t63 * t81 / 0.32e2 + t63 * t96 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t72 + 0.2e1 / 0.3e1 * t79 - t102 * t103 / 0.4e1 - t107 * t108 / 0.4e1) / 0.8e1;
  tzk0 = params->a * (t16 * t12 * t114 - t7 * t12);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t118 = t3 * params->a;
  t119 = t1 * t5;
  t120 = t4 * t3;
  t121 = 0.1e1 / t120;
  t122 = t2 * t121;
  t124 = -0.2e1 * t119 + 0.2e1 * t122;
  t126 = t11 * t11;
  t127 = 0.1e1 / t126;
  t128 = t7 * t127;
  t130 = 0.1e1 / t8 / t3;
  t131 = params->d * t130;
  t133 = t128 * t131 / 0.3e1;
  t134 = params->b * params->c;
  t135 = t134 * t130;
  t136 = t15 * t12;
  t137 = t136 * t114;
  t139 = t135 * t137 / 0.3e1;
  t140 = t16 * t127;
  t141 = t114 * params->d;
  t144 = t140 * t141 * t130 / 0.3e1;
  t146 = 0.1e1 / t19 / t120;
  t147 = t18 * t146;
  t149 = 0.8e1 / 0.3e1 * t147 * t30;
  t151 = params->d * params->d;
  t152 = t151 * t127;
  t154 = 0.1e1 / t19 / t3;
  t157 = t24 * t130 - t152 * t154;
  t158 = 0.7e1 / 0.3e1 * t157;
  t159 = t7 * t158;
  t161 = t124 * t27 / 0.72e2 + t159 / 0.72e2;
  t166 = t48 * t40;
  t167 = t38 - t119;
  t168 = t166 * t167;
  t170 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t168);
  t171 = t55 * t51;
  t172 = -t167;
  t173 = t171 * t172;
  t175 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t173);
  t176 = t170 + t175;
  t180 = t62 * t124;
  t183 = t157 / 0.54e2;
  t184 = t183 * t80;
  t186 = t63 * t184 / 0.32e2;
  t189 = 0.1e1 / t68 / t66 / rho[0];
  t190 = sigma[0] * t189;
  t191 = t190 * t50;
  t193 = t71 * t170;
  t194 = t78 * t175;
  t195 = -0.8e1 / 0.3e1 * t191 + t193 + t194;
  t196 = t65 * t195;
  t202 = -t157 / 0.3e1;
  t203 = t202 * t95;
  t205 = t63 * t203 / 0.576e3;
  t210 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t167);
  t214 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t172);
  t216 = -0.8e1 / 0.3e1 * t190 * t89 + t71 * t210 + t78 * t214;
  t217 = t84 * t216;
  t225 = my_piecewise3(t41, 0, 0.2e1 * t40 * t167);
  t226 = t225 * sigma[2];
  t229 = t77 * t175;
  t234 = my_piecewise3(t52, 0, 0.2e1 * t51 * t172);
  t235 = t234 * sigma[0];
  t238 = t189 * t50;
  t241 = t70 * t170;
  t247 = t149 - t22 * t161 - 0.3e1 / 0.2e2 * t37 * t124 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t176 + t180 * t81 / 0.32e2 + t186 + t63 * t196 / 0.32e2 + t180 * t96 / 0.576e3 + t205 + t63 * t217 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t191 + 0.2e1 / 0.3e1 * t193 + 0.2e1 / 0.3e1 * t194 - t226 * t103 / 0.4e1 - t102 * t229 / 0.4e1 - t235 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t238 - t107 * t241 / 0.4e1) / 0.8e1;
  t250 = t16 * t12 * t247 - t124 * t12 - t133 + t139 + t144;
  tvrho0 = t118 * t250 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t253 = 0.2e1 * t119 + 0.2e1 * t122;
  t257 = t253 * t27 / 0.72e2 + t159 / 0.72e2;
  t262 = -t38 - t119;
  t263 = t166 * t262;
  t265 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t263);
  t266 = -t262;
  t267 = t171 * t266;
  t269 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t267);
  t270 = t265 + t269;
  t274 = t62 * t253;
  t277 = t71 * t265;
  t280 = 0.1e1 / t75 / t73 / rho[1];
  t281 = sigma[2] * t280;
  t282 = t281 * t57;
  t284 = t78 * t269;
  t285 = t277 - 0.8e1 / 0.3e1 * t282 + t284;
  t286 = t65 * t285;
  t293 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t262);
  t299 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t266);
  t301 = t71 * t293 - 0.8e1 / 0.3e1 * t281 * t93 + t78 * t299;
  t302 = t84 * t301;
  t310 = my_piecewise3(t41, 0, 0.2e1 * t40 * t262);
  t311 = t310 * sigma[2];
  t314 = t280 * t57;
  t317 = t77 * t269;
  t322 = my_piecewise3(t52, 0, 0.2e1 * t51 * t266);
  t323 = t322 * sigma[0];
  t326 = t70 * t265;
  t332 = t149 - t22 * t257 - 0.3e1 / 0.2e2 * t37 * t253 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t270 + t274 * t81 / 0.32e2 + t186 + t63 * t286 / 0.32e2 + t274 * t96 / 0.576e3 + t205 + t63 * t302 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t277 - 0.16e2 / 0.9e1 * t282 + 0.2e1 / 0.3e1 * t284 - t311 * t103 / 0.4e1 + 0.2e1 / 0.3e1 * t102 * t314 - t102 * t317 / 0.4e1 - t323 * t108 / 0.4e1 - t107 * t326 / 0.4e1) / 0.8e1;
  t335 = t16 * t12 * t332 - t253 * t12 - t133 + t139 + t144;
  tvrho1 = t118 * t335 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t337 = t118 * params->b;
  t338 = t21 * t30;
  t339 = t65 * t70;
  t340 = t339 * t50;
  t343 = t84 * t70;
  t344 = t343 * t89;
  t348 = t106 * t70;
  t354 = -t338 + t63 * t340 / 0.32e2 + t63 * t344 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t108 - t348 * t50 / 0.4e1) / 0.8e1;
  t355 = t136 * t354;
  tvsigma0 = t337 * t355;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t356 = t154 * params->a;
  t357 = t356 * params->b;
  t358 = t136 * t30;
  tvsigma1 = -0.2e1 * t357 * t358;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t361 = t65 * t77;
  t362 = t361 * t57;
  t365 = t84 * t77;
  t366 = t365 * t93;
  t370 = t101 * t77;
  t376 = -t338 + t63 * t362 / 0.32e2 + t63 * t366 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t103 - t370 * t57 / 0.4e1) / 0.8e1;
  t377 = t136 * t376;
  tvsigma2 = t337 * t377;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t378 = params->a * t250;
  t380 = 0.2e1 * t5;
  t381 = t1 * t121;
  t382 = 0.8e1 * t381;
  t383 = t4 * t4;
  t384 = 0.1e1 / t383;
  t386 = 0.6e1 * t2 * t384;
  t387 = -t380 + t382 - t386;
  t389 = t124 * t127;
  t390 = t389 * t131;
  t393 = 0.1e1 / t126 / t11;
  t394 = t7 * t393;
  t395 = t151 * t21;
  t397 = 0.2e1 / 0.9e1 * t394 * t395;
  t399 = 0.1e1 / t8 / t4;
  t400 = params->d * t399;
  t402 = 0.4e1 / 0.9e1 * t128 * t400;
  t403 = t134 * t399;
  t405 = 0.4e1 / 0.9e1 * t403 * t137;
  t406 = params->c * params->c;
  t407 = params->b * t406;
  t408 = t407 * t21;
  t410 = t408 * t137 / 0.9e1;
  t411 = t134 * t21;
  t412 = t15 * t127;
  t413 = t412 * t141;
  t415 = 0.2e1 / 0.9e1 * t411 * t413;
  t416 = t136 * t247;
  t417 = t135 * t416;
  t419 = t16 * t393;
  t420 = t114 * t151;
  t423 = 0.2e1 / 0.9e1 * t419 * t420 * t21;
  t424 = t247 * params->d;
  t426 = t140 * t424 * t130;
  t430 = 0.4e1 / 0.9e1 * t140 * t141 * t399;
  t432 = 0.1e1 / t19 / t383;
  t433 = t18 * t432;
  t435 = 0.88e2 / 0.9e1 * t433 * t30;
  t442 = t167 * t167;
  t443 = t48 * t442;
  t446 = -0.2e1 * t5 + 0.2e1 * t381;
  t450 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t443 + 0.8e1 / 0.3e1 * t166 * t446);
  t451 = t172 * t172;
  t452 = t55 * t451;
  t454 = -t446;
  t458 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t452 + 0.8e1 / 0.3e1 * t171 * t454);
  t459 = t450 + t458;
  t463 = t62 * t387;
  t466 = t180 * t184;
  t470 = t151 * params->d;
  t471 = t470 * t393;
  t472 = t471 * t121;
  t474 = t152 * t21;
  t476 = t24 * t399;
  t478 = -t472 / 0.81e2 + t474 / 0.27e2 - 0.2e1 / 0.81e2 * t476;
  t479 = t478 * t80;
  t481 = t63 * t479 / 0.32e2;
  t482 = t183 * t195;
  t483 = t63 * t482;
  t485 = t66 * t66;
  t487 = 0.1e1 / t68 / t485;
  t488 = sigma[0] * t487;
  t489 = t488 * t50;
  t491 = t190 * t170;
  t493 = t71 * t450;
  t494 = t78 * t458;
  t495 = 0.88e2 / 0.9e1 * t489 - 0.16e2 / 0.3e1 * t491 + t493 + t494;
  t496 = t65 * t495;
  t501 = t180 * t203;
  t508 = 0.2e1 / 0.9e1 * t472 - 0.2e1 / 0.3e1 * t474 + 0.4e1 / 0.9e1 * t476;
  t509 = t508 * t95;
  t511 = t63 * t509 / 0.576e3;
  t512 = t202 * t216;
  t513 = t63 * t512;
  t524 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t166 * t442 + 0.11e2 / 0.3e1 * t49 * t446);
  t531 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t171 * t451 + 0.11e2 / 0.3e1 * t56 * t454);
  t533 = 0.88e2 / 0.9e1 * t488 * t89 - 0.16e2 / 0.3e1 * t190 * t210 + t71 * t524 + t78 * t531;
  t534 = t84 * t533;
  t537 = t147 * t161;
  t541 = t124 * t158;
  t546 = -0.14e2 / 0.9e1 * t472 + 0.14e2 / 0.3e1 * t474 - 0.28e2 / 0.9e1 * t476;
  t547 = t7 * t546;
  t548 = t547 / 0.72e2;
  t549 = t387 * t27 / 0.72e2 + t541 / 0.36e2 + t548;
  t558 = my_piecewise3(t41, 0, 0.2e1 * t40 * t446 + 0.2e1 * t442);
  t559 = t558 * sigma[2];
  t564 = t77 * t458;
  t570 = my_piecewise3(t52, 0, 0.2e1 * t51 * t454 + 0.2e1 * t451);
  t571 = t570 * sigma[0];
  t578 = t487 * t50;
  t581 = t189 * t170;
  t584 = t70 * t450;
  t587 = 0.176e3 / 0.27e2 * t489 - 0.32e2 / 0.9e1 * t491 + 0.2e1 / 0.3e1 * t493 + 0.2e1 / 0.3e1 * t494 - t559 * t103 / 0.4e1 - t226 * t229 / 0.2e1 - t102 * t564 / 0.4e1 - t571 * t108 / 0.4e1 + 0.4e1 / 0.3e1 * t235 * t238 - t235 * t241 / 0.2e1 - 0.22e2 / 0.9e1 * t107 * t578 + 0.4e1 / 0.3e1 * t107 * t581 - t107 * t584 / 0.4e1;
  t590 = -t435 - 0.3e1 / 0.2e2 * t37 * t387 * t58 - 0.3e1 / 0.1e2 * t37 * t124 * t176 - 0.3e1 / 0.2e2 * t37 * t7 * t459 + t463 * t81 / 0.32e2 + t466 / 0.16e2 + t180 * t196 / 0.16e2 + t481 + t483 / 0.16e2 + t63 * t496 / 0.32e2 + t463 * t96 / 0.576e3 + t501 / 0.288e3 + t180 * t217 / 0.288e3 + t511 + t513 / 0.288e3 + t63 * t534 / 0.576e3 + 0.16e2 / 0.3e1 * t537 - t22 * t549 - t62 * t587 / 0.8e1;
  t593 = -t387 * t12 - 0.2e1 / 0.3e1 * t390 - t397 + t402 - t405 + t410 + t415 + 0.2e1 / 0.3e1 * t417 + t423 + 0.2e1 / 0.3e1 * t426 - t430 + t16 * t12 * t590;
  tv2rho20 = t118 * t593 + 0.2e1 * t378;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t595 = params->a * t335;
  t596 = t380 - t386;
  t598 = t253 * t127;
  t599 = t598 * t131;
  t604 = t136 * t332;
  t605 = t135 * t604;
  t607 = t332 * params->d;
  t609 = t140 * t607 * t130;
  t611 = t190 * t265;
  t613 = t48 * t262;
  t616 = t166 * t1;
  t620 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t613 * t167 + 0.16e2 / 0.3e1 * t616 * t121);
  t621 = t71 * t620;
  t623 = t281 * t175;
  t625 = t55 * t266;
  t628 = t171 * t1;
  t632 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t625 * t172 - 0.16e2 / 0.3e1 * t628 * t121);
  t633 = t78 * t632;
  t637 = t40 * t1;
  t641 = my_piecewise3(t41, 0, 0.4e1 * t637 * t121 + 0.2e1 * t167 * t262);
  t642 = t641 * sigma[2];
  t649 = t280 * t175;
  t654 = t77 * t632;
  t659 = t51 * t1;
  t663 = my_piecewise3(t52, 0, -0.4e1 * t659 * t121 + 0.2e1 * t172 * t266);
  t664 = t663 * sigma[0];
  t673 = t189 * t265;
  t676 = t70 * t620;
  t679 = -0.16e2 / 0.9e1 * t611 + 0.2e1 / 0.3e1 * t621 - 0.16e2 / 0.9e1 * t623 + 0.2e1 / 0.3e1 * t633 - t642 * t103 / 0.4e1 - t311 * t229 / 0.4e1 + 0.2e1 / 0.3e1 * t226 * t314 + 0.2e1 / 0.3e1 * t102 * t649 - t226 * t317 / 0.4e1 - t102 * t654 / 0.4e1 - t664 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t323 * t238 - t323 * t241 / 0.4e1 - t235 * t326 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t673 - t107 * t676 / 0.4e1;
  t683 = t253 * t158;
  t685 = t596 * t27 / 0.72e2 + t541 / 0.72e2 + t547 / 0.72e2 + t683 / 0.72e2;
  t687 = t147 * t257;
  t692 = -0.8e1 / 0.3e1 * t611 + t621 - 0.8e1 / 0.3e1 * t623 + t633;
  t693 = t65 * t692;
  t696 = t62 * t596;
  t699 = t274 * t203;
  t705 = t202 * t301;
  t706 = t63 * t705;
  t712 = t49 * t1;
  t716 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t263 * t167 + 0.22e2 / 0.3e1 * t712 * t121);
  t722 = t56 * t1;
  t726 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t267 * t172 - 0.22e2 / 0.3e1 * t722 * t121);
  t728 = -0.8e1 / 0.3e1 * t190 * t293 + t71 * t716 - 0.8e1 / 0.3e1 * t281 * t214 + t78 * t726;
  t729 = t84 * t728;
  t735 = -t62 * t679 / 0.8e1 - t22 * t685 + 0.8e1 / 0.3e1 * t687 + 0.8e1 / 0.3e1 * t537 - t435 + t63 * t693 / 0.32e2 + t696 * t96 / 0.576e3 + t699 / 0.576e3 + t274 * t217 / 0.576e3 + t180 * t302 / 0.576e3 + t706 / 0.576e3 + t63 * t729 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t596 * t58;
  t742 = t620 + t632;
  t748 = t274 * t184;
  t754 = t183 * t285;
  t755 = t63 * t754;
  t761 = -0.3e1 / 0.2e2 * t37 * t253 * t176 - 0.3e1 / 0.2e2 * t37 * t124 * t270 - 0.3e1 / 0.2e2 * t37 * t7 * t742 + t696 * t81 / 0.32e2 + t748 / 0.32e2 + t274 * t196 / 0.32e2 + t180 * t286 / 0.32e2 + t755 / 0.32e2 + t466 / 0.32e2 + t481 + t483 / 0.32e2 + t501 / 0.576e3 + t511 + t513 / 0.576e3;
  t762 = t735 + t761;
  t765 = -t596 * t12 - t599 / 0.3e1 - t390 / 0.3e1 - t397 + t402 - t405 + t410 + t415 + t417 / 0.3e1 + t423 + t426 / 0.3e1 - t430 + t605 / 0.3e1 + t609 / 0.3e1 + t16 * t12 * t762;
  tv2rho21 = t118 * t765 + t378 + t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t768 = -t380 - t382 - t386;
  t784 = t262 * t262;
  t785 = t48 * t784;
  t788 = 0.2e1 * t5 + 0.2e1 * t381;
  t789 = t166 * t788;
  t792 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t785 + 0.8e1 / 0.3e1 * t789);
  t793 = t266 * t266;
  t794 = t55 * t793;
  t796 = -t788;
  t797 = t171 * t796;
  t800 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t794 + 0.8e1 / 0.3e1 * t797);
  t801 = t792 + t800;
  t805 = t62 * t768;
  t810 = t71 * t792;
  t811 = t73 * t73;
  t813 = 0.1e1 / t75 / t811;
  t814 = sigma[2] * t813;
  t815 = t814 * t57;
  t817 = t281 * t269;
  t819 = t78 * t800;
  t820 = t810 + 0.88e2 / 0.9e1 * t815 - 0.16e2 / 0.3e1 * t817 + t819;
  t821 = t65 * t820;
  t833 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t166 * t784 + 0.11e2 / 0.3e1 * t49 * t788);
  t844 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t171 * t793 + 0.11e2 / 0.3e1 * t56 * t796);
  t846 = t71 * t833 + 0.88e2 / 0.9e1 * t814 * t93 - 0.16e2 / 0.3e1 * t281 * t299 + t78 * t844;
  t847 = t84 * t846;
  t853 = t768 * t27 / 0.72e2 + t683 / 0.36e2 + t548;
  t862 = my_piecewise3(t41, 0, 0.2e1 * t40 * t788 + 0.2e1 * t784);
  t863 = t862 * sigma[2];
  t870 = t813 * t57;
  t873 = t280 * t269;
  t876 = t77 * t800;
  t882 = my_piecewise3(t52, 0, 0.2e1 * t51 * t796 + 0.2e1 * t793);
  t883 = t882 * sigma[0];
  t888 = t70 * t792;
  t891 = 0.2e1 / 0.3e1 * t810 + 0.176e3 / 0.27e2 * t815 - 0.32e2 / 0.9e1 * t817 + 0.2e1 / 0.3e1 * t819 - t863 * t103 / 0.4e1 + 0.4e1 / 0.3e1 * t311 * t314 - t311 * t317 / 0.2e1 - 0.22e2 / 0.9e1 * t102 * t870 + 0.4e1 / 0.3e1 * t102 * t873 - t102 * t876 / 0.4e1 - t883 * t108 / 0.4e1 - t323 * t326 / 0.2e1 - t107 * t888 / 0.4e1;
  t894 = -t435 + t481 + t511 + 0.16e2 / 0.3e1 * t687 + t748 / 0.16e2 + t755 / 0.16e2 + t699 / 0.288e3 + t706 / 0.288e3 - 0.3e1 / 0.2e2 * t37 * t768 * t58 - 0.3e1 / 0.1e2 * t37 * t253 * t270 - 0.3e1 / 0.2e2 * t37 * t7 * t801 + t805 * t81 / 0.32e2 + t274 * t286 / 0.16e2 + t63 * t821 / 0.32e2 + t805 * t96 / 0.576e3 + t274 * t302 / 0.288e3 + t63 * t847 / 0.576e3 - t22 * t853 - t62 * t891 / 0.8e1;
  t897 = -t768 * t12 - 0.2e1 / 0.3e1 * t599 - t397 + t402 - t405 + t410 + t415 + 0.2e1 / 0.3e1 * t605 + t423 + 0.2e1 / 0.3e1 * t609 - t430 + t16 * t12 * t894;
  tv2rho22 = t118 * t897 + 0.2e1 * t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t899 = params->a * params->b;
  t900 = t899 * t355;
  t902 = t9 * params->a * params->b;
  t903 = params->c * t15;
  t904 = t12 * t354;
  t907 = t902 * t903 * t904 / 0.3e1;
  t909 = t412 * t354 * params->d;
  t911 = t902 * t909 / 0.3e1;
  t913 = 0.8e1 / 0.3e1 * t146 * t30;
  t914 = t21 * t161;
  t917 = t183 * t70;
  t918 = t917 * t50;
  t920 = t63 * t918 / 0.32e2;
  t921 = t65 * t189;
  t922 = t921 * t50;
  t925 = t339 * t170;
  t930 = t202 * t70;
  t931 = t930 * t89;
  t933 = t63 * t931 / 0.576e3;
  t934 = t84 * t189;
  t935 = t934 * t89;
  t938 = t343 * t210;
  t943 = t234 * t70;
  t946 = t106 * t189;
  t954 = t913 - t914 + t180 * t340 / 0.32e2 + t920 - t63 * t922 / 0.12e2 + t63 * t925 / 0.32e2 + t180 * t344 / 0.576e3 + t933 - t63 * t935 / 0.216e3 + t63 * t938 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t238 + 0.2e1 / 0.3e1 * t241 - t943 * t50 / 0.4e1 + 0.2e1 / 0.3e1 * t946 * t50 - t348 * t170 / 0.4e1) / 0.8e1;
  t955 = t136 * t954;
  tv2rhosigma0 = t337 * t955 + t900 + t907 + t911;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t958 = t21 * params->a * params->b;
  t960 = 0.1e2 / 0.3e1 * t958 * t358;
  t961 = t121 * params->a;
  t962 = t961 * params->b;
  t963 = t12 * t30;
  t964 = t903 * t963;
  t966 = 0.2e1 / 0.3e1 * t962 * t964;
  t968 = t412 * t30 * params->d;
  t970 = 0.2e1 / 0.3e1 * t962 * t968;
  t971 = t136 * t161;
  tv2rhosigma1 = -0.2e1 * t357 * t971 + t960 - t966 - t970;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t974 = t899 * t377;
  t975 = t12 * t376;
  t978 = t902 * t903 * t975 / 0.3e1;
  t980 = t412 * t376 * params->d;
  t982 = t902 * t980 / 0.3e1;
  t985 = t183 * t77;
  t986 = t985 * t57;
  t988 = t63 * t986 / 0.32e2;
  t989 = t361 * t175;
  t994 = t202 * t77;
  t995 = t994 * t93;
  t997 = t63 * t995 / 0.576e3;
  t998 = t365 * t214;
  t1002 = t225 * t77;
  t1010 = t913 - t914 + t180 * t362 / 0.32e2 + t988 + t63 * t989 / 0.32e2 + t180 * t366 / 0.576e3 + t997 + t63 * t998 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t229 - t1002 * t57 / 0.4e1 - t370 * t175 / 0.4e1) / 0.8e1;
  t1011 = t136 * t1010;
  tv2rhosigma2 = t337 * t1011 + t974 + t978 + t982;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1013 = t21 * t257;
  t1016 = t339 * t265;
  t1021 = t343 * t293;
  t1025 = t322 * t70;
  t1033 = t913 - t1013 + t274 * t340 / 0.32e2 + t920 + t63 * t1016 / 0.32e2 + t274 * t344 / 0.576e3 + t933 + t63 * t1021 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t326 - t1025 * t50 / 0.4e1 - t348 * t265 / 0.4e1) / 0.8e1;
  t1034 = t136 * t1033;
  tv2rhosigma3 = t337 * t1034 + t900 + t907 + t911;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1036 = t136 * t257;
  tv2rhosigma4 = -0.2e1 * t357 * t1036 + t960 - t966 - t970;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t1041 = t65 * t280;
  t1042 = t1041 * t57;
  t1045 = t361 * t269;
  t1050 = t84 * t280;
  t1051 = t1050 * t93;
  t1054 = t365 * t299;
  t1059 = t310 * t77;
  t1062 = t101 * t280;
  t1070 = t913 - t1013 + t274 * t362 / 0.32e2 + t988 - t63 * t1042 / 0.12e2 + t63 * t1045 / 0.32e2 + t274 * t366 / 0.576e3 + t997 - t63 * t1051 / 0.216e3 + t63 * t1054 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t314 + 0.2e1 / 0.3e1 * t317 - t1059 * t57 / 0.4e1 + 0.2e1 / 0.3e1 * t1062 * t57 - t370 * t269 / 0.4e1) / 0.8e1;
  t1071 = t136 * t1070;
  tv2rhosigma5 = t337 * t1071 + t974 + t978 + t982;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2sigma20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t9;
  double t11, t12, t15, t16, t18, t19, t21, t22;
  double t24, t25, t27, t30, t32, t33, t34, t35;
  double t36, t37, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t49, t50, t51;
  double t52, t53, t54, t55, t56, t57, t58, t62;
  double t63, t65, t66, t67, t68, t70, t71, t72;
  double t73, t74, t75, t77, t78, t79, t80, t81;
  double t84, t86, t89, t93, t95, t96, t101, t102;
  double t103, t106, t107, t108, t114, tzk0;

  double t118, t119, t120, t121, t122, t124, t126, t127;
  double t128, t130, t131, t133, t134, t135, t136, t137;
  double t139, t140, t141, t144, t146, t147, t149, t151;
  double t152, t154, t157, t158, t159, t161, t166, t167;
  double t168, t170, t171, t172, t173, t175, t176, t180;
  double t183, t184, t186, t189, t190, t191, t193, t194;
  double t195, t196, t202, t203, t205, t210, t214, t216;
  double t217, t225, t226, t229, t234, t235, t238, t241;
  double t247, t250, tvrho0, t253, t257, t262, t263, t265;
  double t266, t267, t269, t270, t274, t277, t280, t281;
  double t282, t284, t285, t286, t293, t299, t301, t302;
  double t310, t311, t314, t317, t322, t323, t326, t332;
  double t335, tvrho1, t337, t338, t339, t340, t343, t344;
  double t348, t354, t355, tvsigma0, t356, t357, t358, tvsigma1;
  double t361, t362, t365, t366, t370, t376, t377, tvsigma2;

  double t378, t380, t381, t382, t383, t384, t386, t387;
  double t389, t390, t393, t394, t395, t397, t399, t400;
  double t402, t403, t405, t406, t407, t408, t410, t411;
  double t412, t413, t415, t416, t417, t419, t420, t423;
  double t424, t426, t430, t432, t433, t435, t442, t443;
  double t446, t450, t451, t452, t454, t458, t459, t463;
  double t466, t470, t471, t472, t474, t476, t478, t479;
  double t481, t482, t483, t485, t487, t488, t489, t491;
  double t493, t494, t495, t496, t501, t508, t509, t511;
  double t512, t513, t524, t531, t533, t534, t537, t541;
  double t546, t547, t548, t549, t558, t559, t564, t570;
  double t571, t578, t581, t584, t587, t590, t593, tv2rho20;
  double t595, t596, t598, t599, t604, t605, t607, t609;
  double t611, t613, t616, t620, t621, t623, t625, t628;
  double t632, t633, t637, t641, t642, t649, t654, t659;
  double t663, t664, t673, t676, t679, t683, t685, t687;
  double t692, t693, t696, t699, t705, t706, t712, t716;
  double t722, t726, t728, t729, t735, t742, t748, t754;
  double t755, t761, t762, t765, tv2rho21, t768, t784, t785;
  double t788, t789, t792, t793, t794, t796, t797, t800;
  double t801, t805, t810, t811, t813, t814, t815, t817;
  double t819, t820, t821, t833, t844, t846, t847, t853;
  double t862, t863, t870, t873, t876, t882, t883, t888;
  double t891, t894, t897, tv2rho22, t899, t900, t902, t903;
  double t904, t907, t909, t911, t913, t914, t917, t918;
  double t920, t921, t922, t925, t930, t931, t933, t934;
  double t935, t938, t943, t946, t954, t955, tv2rhosigma0, t958;
  double t960, t961, t962, t963, t964, t966, t968, t970;
  double t971, tv2rhosigma1, t974, t975, t978, t980, t982, t985;
  double t986, t988, t989, t994, t995, t997, t998, t1002;
  double t1010, t1011, tv2rhosigma2, t1013, t1016, t1021, t1025, t1033;
  double t1034, tv2rhosigma3, t1036, tv2rhosigma4, t1041, t1042, t1045, t1050;
  double t1051, t1054, t1059, t1062, t1070, t1071, tv2rhosigma5, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  double t1073, t1075, t1076, t1077, t1078, t1080, t1081, t1082;
  double t1083, t1085, t1088, t1089, t1090, t1092, t1094, t1096;
  double t1100, t1101, t1108, t1109, t1112, t1115, t1119, t1120;
  double t1123, t1128, t1129, t1138, t1141, t1144, t1145, t1148;
  double t1154, t1155, t1162, t1165, t1167, t1169, t1171, t1173;
  double t1176, t1178, t1180, t1181, t1182, t1183, t1185, t1186;
  double t1189, t1191, t1193, t1194, t1196, t1197, t1199, t1201;
  double t1204, t1205, t1207, t1209, t1210, t1213, t1214, t1216;
  double t1221, t1222, t1224, t1225, t1226, t1228, t1229, t1244;
  double t1253, t1255, t1256, t1262, t1266, t1269, t1273, t1274;
  double t1276, t1284, t1285, t1287, t1288, t1289, t1291, t1292;
  double t1297, t1298, t1303, t1307, t1309, t1319, t1320, t1323;
  double t1325, t1327, t1328, t1330, t1331, t1332, t1334, t1335;
  double t1336, t1337, t1339, t1341, t1342, t1345, t1346, t1348;
  double t1349, t1350, t1352, t1354, t1355, t1357, t1358, t1360;
  double t1361, t1363, t1364, t1366, t1367, t1368, t1370, t1371;
  double t1372, t1374, t1377, t1379, t1383, t1385, t1386, tv3rho30;
  double t1389, t1390, t1392, t1394, t1395, t1396, t1404, t1409;
  double t1410, t1417, t1418, t1429, t1436, t1439, t1440, t1445;
  double t1450, t1451, t1454, t1457, t1458, t1465, t1466, t1479;
  double t1482, t1485, t1486, t1491, t1496, t1497, t1500, t1502;
  double t1504, t1506, t1508, t1510, t1517, t1520, t1521, t1523;
  double t1525, t1541, t1556, t1558, t1559, t1565, t1569, t1570;
  double t1571, t1572, t1576, t1579, t1580, t1583, t1589, t1592;
  double t1593, t1595, t1597, t1601, t1602, t1608, t1611, t1613;
  double t1616, t1632, t1636, t1637, t1641, t1643, t1647, t1658;
  double t1660, t1666, t1668, t1669, t1671, t1674, t1675, t1677;
  double t1679, t1682, t1685, t1691, t1692, t1696, t1697, tv3rho31;
  double t1699, t1704, t1706, t1707, t1709, t1711, t1717, t1724;
  double t1725, t1731, t1734, t1740, t1745, t1750, t1751, t1754;
  double t1755, t1757, t1759, t1761, t1766, t1769, t1770, t1773;
  double t1774, t1776, t1784, t1791, t1794, t1797, t1802, t1803;
  double t1806, t1819, t1824, t1829, t1832, t1835, t1840, t1841;
  double t1846, t1850, t1854, t1858, t1871, t1886, t1888, t1889;
  double t1892, t1893, t1898, t1899, t1902, t1905, t1911, t1917;
  double t1918, t1920, t1936, t1942, t1948, t1954, t1956, t1959;
  double t1960, tv3rho32, t1967, t1971, t1985, t1986, t1989, t1990;
  double t1995, t1996, t1999, t2000, t2002, t2004, t2006, t2007;
  double t2011, t2012, t2015, t2016, t2018, t2019, t2026, t2027;
  double t2036, t2039, t2042, t2050, t2051, t2058, t2061, t2068;
  double t2079, t2094, t2096, t2097, t2103, t2110, t2114, t2124;
  double t2125, t2138, t2139, t2142, t2143, tv3rho33, t2145, t2146;
  double t2149, t2150, t2151, t2154, t2155, t2157, t2160, t2161;
  double t2163, t2164, t2166, t2169, t2171, t2173, t2174, t2178;
  double t2179, t2180, t2182, t2183, t2188, t2189, t2190, t2192;
  double t2193, t2198, t2202, t2203, t2205, t2206, t2207, t2209;
  double t2212, t2213, t2218, t2222, t2223, t2225, t2226, t2227;
  double t2229, t2232, t2236, t2237, t2238, t2239, t2243, t2246;
  double t2251, t2261, t2262, t2263, tv3rho2sigma0, t2266, t2268, t2270;
  double t2272, t2274, t2275, t2277, t2278, t2279, t2281, t2282;
  double t2284, t2285, t2286, t2287, t2290, t2292, t2294, t2295;
  double t2297, tv3rho2sigma1, t2302, t2303, t2306, t2307, t2311, t2313;
  double t2314, t2316, t2319, t2321, t2323, t2324, t2328, t2332;
  double t2333, t2335, t2336, t2337, t2339, t2344, t2348, t2349;
  double t2351, t2352, t2353, t2355, t2359, t2369, t2370, tv3rho2sigma2;
  double t2374, t2375, t2377, t2380, t2381, t2383, t2386, t2389;
  double t2403, t2404, t2405, t2410, t2416, t2417, t2419, t2424;
  double t2429, t2432, t2435, t2441, t2442, t2450, t2451, t2452;
  double t2453, tv3rho2sigma3, t2458, t2460, t2461, t2462, t2465, t2466;
  double t2468, tv3rho2sigma4, t2473, t2474, t2476, t2479, t2480, t2484;
  double t2490, t2491, t2492, t2494, t2499, t2500, t2502, t2507;
  double t2511, t2514, t2515, t2516, t2518, t2523, t2524, t2526;
  double t2535, t2540, t2552, t2553, t2554, tv3rho2sigma5, t2559, t2560;
  double t2567, t2576, t2580, t2590, t2591, tv3rho2sigma6, t2596, tv3rho2sigma7;
  double t2604, t2605, t2610, t2611, t2620, t2625, t2628, t2635;
  double t2638, t2644, t2647, t2652, t2662, t2663, t2664, tv3rho2sigma8;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, tv3rhosigma26, tv3rhosigma27;
  double tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = POW_1_3(t3);
  t9 = 0.1e1 / t8;
  t11 = params->d * t9 + 0.1e1;
  t12 = 0.1e1 / t11;
  t15 = exp(-params->c * t9);
  t16 = params->b * t15;
  t18 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t19 = t8 * t8;
  t21 = 0.1e1 / t19 / t4;
  t22 = t18 * t21;
  t24 = params->d * t12 + params->c;
  t25 = t24 * t9;
  t27 = 0.47e2 - 0.7e1 * t25;
  t30 = t7 * t27 / 0.72e2 - 0.2e1 / 0.3e1;
  t32 = M_CBRT3;
  t33 = t32 * t32;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = t33 * t36;
  t38 = 0.1e1 / t3;
  t39 = t1 * t38;
  t40 = 0.1e1 + t39;
  t41 = t40 <= p->zeta_threshold;
  t42 = p->zeta_threshold * p->zeta_threshold;
  t43 = POW_1_3(p->zeta_threshold);
  t44 = t43 * t43;
  t45 = t44 * t42;
  t46 = t40 * t40;
  t47 = POW_1_3(t40);
  t48 = t47 * t47;
  t49 = t48 * t46;
  t50 = my_piecewise3(t41, t45, t49);
  t51 = 0.1e1 - t39;
  t52 = t51 <= p->zeta_threshold;
  t53 = t51 * t51;
  t54 = POW_1_3(t51);
  t55 = t54 * t54;
  t56 = t55 * t53;
  t57 = my_piecewise3(t52, t45, t56);
  t58 = t50 + t57;
  t62 = M_CBRT2;
  t63 = t62 * t7;
  t65 = 0.5e1 / 0.2e1 - t25 / 0.18e2;
  t66 = rho[0] * rho[0];
  t67 = POW_1_3(rho[0]);
  t68 = t67 * t67;
  t70 = 0.1e1 / t68 / t66;
  t71 = sigma[0] * t70;
  t72 = t71 * t50;
  t73 = rho[1] * rho[1];
  t74 = POW_1_3(rho[1]);
  t75 = t74 * t74;
  t77 = 0.1e1 / t75 / t73;
  t78 = sigma[2] * t77;
  t79 = t78 * t57;
  t80 = t72 + t79;
  t81 = t65 * t80;
  t84 = t25 - 0.11e2;
  t86 = t44 * t42 * p->zeta_threshold;
  t89 = my_piecewise3(t41, t86, t48 * t46 * t40);
  t93 = my_piecewise3(t52, t86, t55 * t53 * t51);
  t95 = t71 * t89 + t78 * t93;
  t96 = t84 * t95;
  t101 = my_piecewise3(t41, t42, t46);
  t102 = t101 * sigma[2];
  t103 = t77 * t57;
  t106 = my_piecewise3(t52, t42, t53);
  t107 = t106 * sigma[0];
  t108 = t70 * t50;
  t114 = -t22 * t30 - 0.3e1 / 0.2e2 * t37 * t7 * t58 + t63 * t81 / 0.32e2 + t63 * t96 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t72 + 0.2e1 / 0.3e1 * t79 - t102 * t103 / 0.4e1 - t107 * t108 / 0.4e1) / 0.8e1;
  tzk0 = params->a * (t16 * t12 * t114 - t7 * t12);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t118 = t3 * params->a;
  t119 = t1 * t5;
  t120 = t4 * t3;
  t121 = 0.1e1 / t120;
  t122 = t2 * t121;
  t124 = -0.2e1 * t119 + 0.2e1 * t122;
  t126 = t11 * t11;
  t127 = 0.1e1 / t126;
  t128 = t7 * t127;
  t130 = 0.1e1 / t8 / t3;
  t131 = params->d * t130;
  t133 = t128 * t131 / 0.3e1;
  t134 = params->b * params->c;
  t135 = t134 * t130;
  t136 = t15 * t12;
  t137 = t136 * t114;
  t139 = t135 * t137 / 0.3e1;
  t140 = t16 * t127;
  t141 = t114 * params->d;
  t144 = t140 * t141 * t130 / 0.3e1;
  t146 = 0.1e1 / t19 / t120;
  t147 = t18 * t146;
  t149 = 0.8e1 / 0.3e1 * t147 * t30;
  t151 = params->d * params->d;
  t152 = t151 * t127;
  t154 = 0.1e1 / t19 / t3;
  t157 = t24 * t130 - t152 * t154;
  t158 = 0.7e1 / 0.3e1 * t157;
  t159 = t7 * t158;
  t161 = t124 * t27 / 0.72e2 + t159 / 0.72e2;
  t166 = t48 * t40;
  t167 = t38 - t119;
  t168 = t166 * t167;
  t170 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t168);
  t171 = t55 * t51;
  t172 = -t167;
  t173 = t171 * t172;
  t175 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t173);
  t176 = t170 + t175;
  t180 = t62 * t124;
  t183 = t157 / 0.54e2;
  t184 = t183 * t80;
  t186 = t63 * t184 / 0.32e2;
  t189 = 0.1e1 / t68 / t66 / rho[0];
  t190 = sigma[0] * t189;
  t191 = t190 * t50;
  t193 = t71 * t170;
  t194 = t78 * t175;
  t195 = -0.8e1 / 0.3e1 * t191 + t193 + t194;
  t196 = t65 * t195;
  t202 = -t157 / 0.3e1;
  t203 = t202 * t95;
  t205 = t63 * t203 / 0.576e3;
  t210 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t167);
  t214 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t172);
  t216 = -0.8e1 / 0.3e1 * t190 * t89 + t71 * t210 + t78 * t214;
  t217 = t84 * t216;
  t225 = my_piecewise3(t41, 0, 0.2e1 * t40 * t167);
  t226 = t225 * sigma[2];
  t229 = t77 * t175;
  t234 = my_piecewise3(t52, 0, 0.2e1 * t51 * t172);
  t235 = t234 * sigma[0];
  t238 = t189 * t50;
  t241 = t70 * t170;
  t247 = t149 - t22 * t161 - 0.3e1 / 0.2e2 * t37 * t124 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t176 + t180 * t81 / 0.32e2 + t186 + t63 * t196 / 0.32e2 + t180 * t96 / 0.576e3 + t205 + t63 * t217 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t191 + 0.2e1 / 0.3e1 * t193 + 0.2e1 / 0.3e1 * t194 - t226 * t103 / 0.4e1 - t102 * t229 / 0.4e1 - t235 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t238 - t107 * t241 / 0.4e1) / 0.8e1;
  t250 = t16 * t12 * t247 - t124 * t12 - t133 + t139 + t144;
  tvrho0 = t118 * t250 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t253 = 0.2e1 * t119 + 0.2e1 * t122;
  t257 = t253 * t27 / 0.72e2 + t159 / 0.72e2;
  t262 = -t38 - t119;
  t263 = t166 * t262;
  t265 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t263);
  t266 = -t262;
  t267 = t171 * t266;
  t269 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t267);
  t270 = t265 + t269;
  t274 = t62 * t253;
  t277 = t71 * t265;
  t280 = 0.1e1 / t75 / t73 / rho[1];
  t281 = sigma[2] * t280;
  t282 = t281 * t57;
  t284 = t78 * t269;
  t285 = t277 - 0.8e1 / 0.3e1 * t282 + t284;
  t286 = t65 * t285;
  t293 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t262);
  t299 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t266);
  t301 = t71 * t293 - 0.8e1 / 0.3e1 * t281 * t93 + t78 * t299;
  t302 = t84 * t301;
  t310 = my_piecewise3(t41, 0, 0.2e1 * t40 * t262);
  t311 = t310 * sigma[2];
  t314 = t280 * t57;
  t317 = t77 * t269;
  t322 = my_piecewise3(t52, 0, 0.2e1 * t51 * t266);
  t323 = t322 * sigma[0];
  t326 = t70 * t265;
  t332 = t149 - t22 * t257 - 0.3e1 / 0.2e2 * t37 * t253 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t270 + t274 * t81 / 0.32e2 + t186 + t63 * t286 / 0.32e2 + t274 * t96 / 0.576e3 + t205 + t63 * t302 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t277 - 0.16e2 / 0.9e1 * t282 + 0.2e1 / 0.3e1 * t284 - t311 * t103 / 0.4e1 + 0.2e1 / 0.3e1 * t102 * t314 - t102 * t317 / 0.4e1 - t323 * t108 / 0.4e1 - t107 * t326 / 0.4e1) / 0.8e1;
  t335 = t16 * t12 * t332 - t253 * t12 - t133 + t139 + t144;
  tvrho1 = t118 * t335 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t337 = t118 * params->b;
  t338 = t21 * t30;
  t339 = t65 * t70;
  t340 = t339 * t50;
  t343 = t84 * t70;
  t344 = t343 * t89;
  t348 = t106 * t70;
  t354 = -t338 + t63 * t340 / 0.32e2 + t63 * t344 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t108 - t348 * t50 / 0.4e1) / 0.8e1;
  t355 = t136 * t354;
  tvsigma0 = t337 * t355;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t356 = t154 * params->a;
  t357 = t356 * params->b;
  t358 = t136 * t30;
  tvsigma1 = -0.2e1 * t357 * t358;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t361 = t65 * t77;
  t362 = t361 * t57;
  t365 = t84 * t77;
  t366 = t365 * t93;
  t370 = t101 * t77;
  t376 = -t338 + t63 * t362 / 0.32e2 + t63 * t366 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t103 - t370 * t57 / 0.4e1) / 0.8e1;
  t377 = t136 * t376;
  tvsigma2 = t337 * t377;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t378 = params->a * t250;
  t380 = 0.2e1 * t5;
  t381 = t1 * t121;
  t382 = 0.8e1 * t381;
  t383 = t4 * t4;
  t384 = 0.1e1 / t383;
  t386 = 0.6e1 * t2 * t384;
  t387 = -t380 + t382 - t386;
  t389 = t124 * t127;
  t390 = t389 * t131;
  t393 = 0.1e1 / t126 / t11;
  t394 = t7 * t393;
  t395 = t151 * t21;
  t397 = 0.2e1 / 0.9e1 * t394 * t395;
  t399 = 0.1e1 / t8 / t4;
  t400 = params->d * t399;
  t402 = 0.4e1 / 0.9e1 * t128 * t400;
  t403 = t134 * t399;
  t405 = 0.4e1 / 0.9e1 * t403 * t137;
  t406 = params->c * params->c;
  t407 = params->b * t406;
  t408 = t407 * t21;
  t410 = t408 * t137 / 0.9e1;
  t411 = t134 * t21;
  t412 = t15 * t127;
  t413 = t412 * t141;
  t415 = 0.2e1 / 0.9e1 * t411 * t413;
  t416 = t136 * t247;
  t417 = t135 * t416;
  t419 = t16 * t393;
  t420 = t114 * t151;
  t423 = 0.2e1 / 0.9e1 * t419 * t420 * t21;
  t424 = t247 * params->d;
  t426 = t140 * t424 * t130;
  t430 = 0.4e1 / 0.9e1 * t140 * t141 * t399;
  t432 = 0.1e1 / t19 / t383;
  t433 = t18 * t432;
  t435 = 0.88e2 / 0.9e1 * t433 * t30;
  t442 = t167 * t167;
  t443 = t48 * t442;
  t446 = -0.2e1 * t5 + 0.2e1 * t381;
  t450 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t443 + 0.8e1 / 0.3e1 * t166 * t446);
  t451 = t172 * t172;
  t452 = t55 * t451;
  t454 = -t446;
  t458 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t452 + 0.8e1 / 0.3e1 * t171 * t454);
  t459 = t450 + t458;
  t463 = t62 * t387;
  t466 = t180 * t184;
  t470 = t151 * params->d;
  t471 = t470 * t393;
  t472 = t471 * t121;
  t474 = t152 * t21;
  t476 = t24 * t399;
  t478 = -t472 / 0.81e2 + t474 / 0.27e2 - 0.2e1 / 0.81e2 * t476;
  t479 = t478 * t80;
  t481 = t63 * t479 / 0.32e2;
  t482 = t183 * t195;
  t483 = t63 * t482;
  t485 = t66 * t66;
  t487 = 0.1e1 / t68 / t485;
  t488 = sigma[0] * t487;
  t489 = t488 * t50;
  t491 = t190 * t170;
  t493 = t71 * t450;
  t494 = t78 * t458;
  t495 = 0.88e2 / 0.9e1 * t489 - 0.16e2 / 0.3e1 * t491 + t493 + t494;
  t496 = t65 * t495;
  t501 = t180 * t203;
  t508 = 0.2e1 / 0.9e1 * t472 - 0.2e1 / 0.3e1 * t474 + 0.4e1 / 0.9e1 * t476;
  t509 = t508 * t95;
  t511 = t63 * t509 / 0.576e3;
  t512 = t202 * t216;
  t513 = t63 * t512;
  t524 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t166 * t442 + 0.11e2 / 0.3e1 * t49 * t446);
  t531 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t171 * t451 + 0.11e2 / 0.3e1 * t56 * t454);
  t533 = 0.88e2 / 0.9e1 * t488 * t89 - 0.16e2 / 0.3e1 * t190 * t210 + t71 * t524 + t78 * t531;
  t534 = t84 * t533;
  t537 = t147 * t161;
  t541 = t124 * t158;
  t546 = -0.14e2 / 0.9e1 * t472 + 0.14e2 / 0.3e1 * t474 - 0.28e2 / 0.9e1 * t476;
  t547 = t7 * t546;
  t548 = t547 / 0.72e2;
  t549 = t387 * t27 / 0.72e2 + t541 / 0.36e2 + t548;
  t558 = my_piecewise3(t41, 0, 0.2e1 * t40 * t446 + 0.2e1 * t442);
  t559 = t558 * sigma[2];
  t564 = t77 * t458;
  t570 = my_piecewise3(t52, 0, 0.2e1 * t51 * t454 + 0.2e1 * t451);
  t571 = t570 * sigma[0];
  t578 = t487 * t50;
  t581 = t189 * t170;
  t584 = t70 * t450;
  t587 = 0.176e3 / 0.27e2 * t489 - 0.32e2 / 0.9e1 * t491 + 0.2e1 / 0.3e1 * t493 + 0.2e1 / 0.3e1 * t494 - t559 * t103 / 0.4e1 - t226 * t229 / 0.2e1 - t102 * t564 / 0.4e1 - t571 * t108 / 0.4e1 + 0.4e1 / 0.3e1 * t235 * t238 - t235 * t241 / 0.2e1 - 0.22e2 / 0.9e1 * t107 * t578 + 0.4e1 / 0.3e1 * t107 * t581 - t107 * t584 / 0.4e1;
  t590 = -t435 - 0.3e1 / 0.2e2 * t37 * t387 * t58 - 0.3e1 / 0.1e2 * t37 * t124 * t176 - 0.3e1 / 0.2e2 * t37 * t7 * t459 + t463 * t81 / 0.32e2 + t466 / 0.16e2 + t180 * t196 / 0.16e2 + t481 + t483 / 0.16e2 + t63 * t496 / 0.32e2 + t463 * t96 / 0.576e3 + t501 / 0.288e3 + t180 * t217 / 0.288e3 + t511 + t513 / 0.288e3 + t63 * t534 / 0.576e3 + 0.16e2 / 0.3e1 * t537 - t22 * t549 - t62 * t587 / 0.8e1;
  t593 = -t387 * t12 - 0.2e1 / 0.3e1 * t390 - t397 + t402 - t405 + t410 + t415 + 0.2e1 / 0.3e1 * t417 + t423 + 0.2e1 / 0.3e1 * t426 - t430 + t16 * t12 * t590;
  tv2rho20 = t118 * t593 + 0.2e1 * t378;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t595 = params->a * t335;
  t596 = t380 - t386;
  t598 = t253 * t127;
  t599 = t598 * t131;
  t604 = t136 * t332;
  t605 = t135 * t604;
  t607 = t332 * params->d;
  t609 = t140 * t607 * t130;
  t611 = t190 * t265;
  t613 = t48 * t262;
  t616 = t166 * t1;
  t620 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t613 * t167 + 0.16e2 / 0.3e1 * t616 * t121);
  t621 = t71 * t620;
  t623 = t281 * t175;
  t625 = t55 * t266;
  t628 = t171 * t1;
  t632 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t625 * t172 - 0.16e2 / 0.3e1 * t628 * t121);
  t633 = t78 * t632;
  t637 = t40 * t1;
  t641 = my_piecewise3(t41, 0, 0.4e1 * t637 * t121 + 0.2e1 * t167 * t262);
  t642 = t641 * sigma[2];
  t649 = t280 * t175;
  t654 = t77 * t632;
  t659 = t51 * t1;
  t663 = my_piecewise3(t52, 0, -0.4e1 * t659 * t121 + 0.2e1 * t172 * t266);
  t664 = t663 * sigma[0];
  t673 = t189 * t265;
  t676 = t70 * t620;
  t679 = -0.16e2 / 0.9e1 * t611 + 0.2e1 / 0.3e1 * t621 - 0.16e2 / 0.9e1 * t623 + 0.2e1 / 0.3e1 * t633 - t642 * t103 / 0.4e1 - t311 * t229 / 0.4e1 + 0.2e1 / 0.3e1 * t226 * t314 + 0.2e1 / 0.3e1 * t102 * t649 - t226 * t317 / 0.4e1 - t102 * t654 / 0.4e1 - t664 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t323 * t238 - t323 * t241 / 0.4e1 - t235 * t326 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t673 - t107 * t676 / 0.4e1;
  t683 = t253 * t158;
  t685 = t596 * t27 / 0.72e2 + t541 / 0.72e2 + t547 / 0.72e2 + t683 / 0.72e2;
  t687 = t147 * t257;
  t692 = -0.8e1 / 0.3e1 * t611 + t621 - 0.8e1 / 0.3e1 * t623 + t633;
  t693 = t65 * t692;
  t696 = t62 * t596;
  t699 = t274 * t203;
  t705 = t202 * t301;
  t706 = t63 * t705;
  t712 = t49 * t1;
  t716 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t263 * t167 + 0.22e2 / 0.3e1 * t712 * t121);
  t722 = t56 * t1;
  t726 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t267 * t172 - 0.22e2 / 0.3e1 * t722 * t121);
  t728 = -0.8e1 / 0.3e1 * t190 * t293 + t71 * t716 - 0.8e1 / 0.3e1 * t281 * t214 + t78 * t726;
  t729 = t84 * t728;
  t735 = -t62 * t679 / 0.8e1 - t22 * t685 + 0.8e1 / 0.3e1 * t687 + 0.8e1 / 0.3e1 * t537 - t435 + t63 * t693 / 0.32e2 + t696 * t96 / 0.576e3 + t699 / 0.576e3 + t274 * t217 / 0.576e3 + t180 * t302 / 0.576e3 + t706 / 0.576e3 + t63 * t729 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t596 * t58;
  t742 = t620 + t632;
  t748 = t274 * t184;
  t754 = t183 * t285;
  t755 = t63 * t754;
  t761 = -0.3e1 / 0.2e2 * t37 * t253 * t176 - 0.3e1 / 0.2e2 * t37 * t124 * t270 - 0.3e1 / 0.2e2 * t37 * t7 * t742 + t696 * t81 / 0.32e2 + t748 / 0.32e2 + t274 * t196 / 0.32e2 + t180 * t286 / 0.32e2 + t755 / 0.32e2 + t466 / 0.32e2 + t481 + t483 / 0.32e2 + t501 / 0.576e3 + t511 + t513 / 0.576e3;
  t762 = t735 + t761;
  t765 = -t596 * t12 - t599 / 0.3e1 - t390 / 0.3e1 - t397 + t402 - t405 + t410 + t415 + t417 / 0.3e1 + t423 + t426 / 0.3e1 - t430 + t605 / 0.3e1 + t609 / 0.3e1 + t16 * t12 * t762;
  tv2rho21 = t118 * t765 + t378 + t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t768 = -t380 - t382 - t386;
  t784 = t262 * t262;
  t785 = t48 * t784;
  t788 = 0.2e1 * t5 + 0.2e1 * t381;
  t789 = t166 * t788;
  t792 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t785 + 0.8e1 / 0.3e1 * t789);
  t793 = t266 * t266;
  t794 = t55 * t793;
  t796 = -t788;
  t797 = t171 * t796;
  t800 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t794 + 0.8e1 / 0.3e1 * t797);
  t801 = t792 + t800;
  t805 = t62 * t768;
  t810 = t71 * t792;
  t811 = t73 * t73;
  t813 = 0.1e1 / t75 / t811;
  t814 = sigma[2] * t813;
  t815 = t814 * t57;
  t817 = t281 * t269;
  t819 = t78 * t800;
  t820 = t810 + 0.88e2 / 0.9e1 * t815 - 0.16e2 / 0.3e1 * t817 + t819;
  t821 = t65 * t820;
  t833 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t166 * t784 + 0.11e2 / 0.3e1 * t49 * t788);
  t844 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t171 * t793 + 0.11e2 / 0.3e1 * t56 * t796);
  t846 = t71 * t833 + 0.88e2 / 0.9e1 * t814 * t93 - 0.16e2 / 0.3e1 * t281 * t299 + t78 * t844;
  t847 = t84 * t846;
  t853 = t768 * t27 / 0.72e2 + t683 / 0.36e2 + t548;
  t862 = my_piecewise3(t41, 0, 0.2e1 * t40 * t788 + 0.2e1 * t784);
  t863 = t862 * sigma[2];
  t870 = t813 * t57;
  t873 = t280 * t269;
  t876 = t77 * t800;
  t882 = my_piecewise3(t52, 0, 0.2e1 * t51 * t796 + 0.2e1 * t793);
  t883 = t882 * sigma[0];
  t888 = t70 * t792;
  t891 = 0.2e1 / 0.3e1 * t810 + 0.176e3 / 0.27e2 * t815 - 0.32e2 / 0.9e1 * t817 + 0.2e1 / 0.3e1 * t819 - t863 * t103 / 0.4e1 + 0.4e1 / 0.3e1 * t311 * t314 - t311 * t317 / 0.2e1 - 0.22e2 / 0.9e1 * t102 * t870 + 0.4e1 / 0.3e1 * t102 * t873 - t102 * t876 / 0.4e1 - t883 * t108 / 0.4e1 - t323 * t326 / 0.2e1 - t107 * t888 / 0.4e1;
  t894 = -t435 + t481 + t511 + 0.16e2 / 0.3e1 * t687 + t748 / 0.16e2 + t755 / 0.16e2 + t699 / 0.288e3 + t706 / 0.288e3 - 0.3e1 / 0.2e2 * t37 * t768 * t58 - 0.3e1 / 0.1e2 * t37 * t253 * t270 - 0.3e1 / 0.2e2 * t37 * t7 * t801 + t805 * t81 / 0.32e2 + t274 * t286 / 0.16e2 + t63 * t821 / 0.32e2 + t805 * t96 / 0.576e3 + t274 * t302 / 0.288e3 + t63 * t847 / 0.576e3 - t22 * t853 - t62 * t891 / 0.8e1;
  t897 = -t768 * t12 - 0.2e1 / 0.3e1 * t599 - t397 + t402 - t405 + t410 + t415 + 0.2e1 / 0.3e1 * t605 + t423 + 0.2e1 / 0.3e1 * t609 - t430 + t16 * t12 * t894;
  tv2rho22 = t118 * t897 + 0.2e1 * t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t899 = params->a * params->b;
  t900 = t899 * t355;
  t902 = t9 * params->a * params->b;
  t903 = params->c * t15;
  t904 = t12 * t354;
  t907 = t902 * t903 * t904 / 0.3e1;
  t909 = t412 * t354 * params->d;
  t911 = t902 * t909 / 0.3e1;
  t913 = 0.8e1 / 0.3e1 * t146 * t30;
  t914 = t21 * t161;
  t917 = t183 * t70;
  t918 = t917 * t50;
  t920 = t63 * t918 / 0.32e2;
  t921 = t65 * t189;
  t922 = t921 * t50;
  t925 = t339 * t170;
  t930 = t202 * t70;
  t931 = t930 * t89;
  t933 = t63 * t931 / 0.576e3;
  t934 = t84 * t189;
  t935 = t934 * t89;
  t938 = t343 * t210;
  t943 = t234 * t70;
  t946 = t106 * t189;
  t954 = t913 - t914 + t180 * t340 / 0.32e2 + t920 - t63 * t922 / 0.12e2 + t63 * t925 / 0.32e2 + t180 * t344 / 0.576e3 + t933 - t63 * t935 / 0.216e3 + t63 * t938 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t238 + 0.2e1 / 0.3e1 * t241 - t943 * t50 / 0.4e1 + 0.2e1 / 0.3e1 * t946 * t50 - t348 * t170 / 0.4e1) / 0.8e1;
  t955 = t136 * t954;
  tv2rhosigma0 = t337 * t955 + t900 + t907 + t911;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t958 = t21 * params->a * params->b;
  t960 = 0.1e2 / 0.3e1 * t958 * t358;
  t961 = t121 * params->a;
  t962 = t961 * params->b;
  t963 = t12 * t30;
  t964 = t903 * t963;
  t966 = 0.2e1 / 0.3e1 * t962 * t964;
  t968 = t412 * t30 * params->d;
  t970 = 0.2e1 / 0.3e1 * t962 * t968;
  t971 = t136 * t161;
  tv2rhosigma1 = -0.2e1 * t357 * t971 + t960 - t966 - t970;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t974 = t899 * t377;
  t975 = t12 * t376;
  t978 = t902 * t903 * t975 / 0.3e1;
  t980 = t412 * t376 * params->d;
  t982 = t902 * t980 / 0.3e1;
  t985 = t183 * t77;
  t986 = t985 * t57;
  t988 = t63 * t986 / 0.32e2;
  t989 = t361 * t175;
  t994 = t202 * t77;
  t995 = t994 * t93;
  t997 = t63 * t995 / 0.576e3;
  t998 = t365 * t214;
  t1002 = t225 * t77;
  t1010 = t913 - t914 + t180 * t362 / 0.32e2 + t988 + t63 * t989 / 0.32e2 + t180 * t366 / 0.576e3 + t997 + t63 * t998 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t229 - t1002 * t57 / 0.4e1 - t370 * t175 / 0.4e1) / 0.8e1;
  t1011 = t136 * t1010;
  tv2rhosigma2 = t337 * t1011 + t974 + t978 + t982;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1013 = t21 * t257;
  t1016 = t339 * t265;
  t1021 = t343 * t293;
  t1025 = t322 * t70;
  t1033 = t913 - t1013 + t274 * t340 / 0.32e2 + t920 + t63 * t1016 / 0.32e2 + t274 * t344 / 0.576e3 + t933 + t63 * t1021 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t326 - t1025 * t50 / 0.4e1 - t348 * t265 / 0.4e1) / 0.8e1;
  t1034 = t136 * t1033;
  tv2rhosigma3 = t337 * t1034 + t900 + t907 + t911;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1036 = t136 * t257;
  tv2rhosigma4 = -0.2e1 * t357 * t1036 + t960 - t966 - t970;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t1041 = t65 * t280;
  t1042 = t1041 * t57;
  t1045 = t361 * t269;
  t1050 = t84 * t280;
  t1051 = t1050 * t93;
  t1054 = t365 * t299;
  t1059 = t310 * t77;
  t1062 = t101 * t280;
  t1070 = t913 - t1013 + t274 * t362 / 0.32e2 + t988 - t63 * t1042 / 0.12e2 + t63 * t1045 / 0.32e2 + t274 * t366 / 0.576e3 + t997 - t63 * t1051 / 0.216e3 + t63 * t1054 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t314 + 0.2e1 / 0.3e1 * t317 - t1059 * t57 / 0.4e1 + 0.2e1 / 0.3e1 * t1062 * t57 - t370 * t269 / 0.4e1) / 0.8e1;
  t1071 = t136 * t1070;
  tv2rhosigma5 = t337 * t1071 + t974 + t978 + t982;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2sigma20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1073 = params->a * t593;
  t1075 = t387 * t127;
  t1076 = t1075 * t131;
  t1077 = t124 * t393;
  t1078 = t1077 * t395;
  t1080 = t126 * t126;
  t1081 = 0.1e1 / t1080;
  t1082 = t7 * t1081;
  t1083 = t470 * t384;
  t1085 = 0.2e1 / 0.9e1 * t1082 * t1083;
  t1088 = 0.1e1 / t68 / t485 / rho[0];
  t1089 = sigma[0] * t1088;
  t1090 = t1089 * t50;
  t1092 = t167 * t446;
  t1094 = t1 * t384;
  t1096 = 0.6e1 * t121 - 0.6e1 * t1094;
  t1100 = my_piecewise3(t41, 0, 0.2e1 * t40 * t1096 + 0.6e1 * t1092);
  t1101 = t1100 * sigma[2];
  t1108 = 0.1e1 / t54;
  t1109 = t451 * t172;
  t1112 = t55 * t172;
  t1115 = -t1096;
  t1119 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t1108 * t1109 + 0.4e2 / 0.3e1 * t1112 * t454 + 0.8e1 / 0.3e1 * t171 * t1115);
  t1120 = t77 * t1119;
  t1123 = t172 * t454;
  t1128 = my_piecewise3(t52, 0, 0.2e1 * t51 * t1115 + 0.6e1 * t1123);
  t1129 = t1128 * sigma[0];
  t1138 = t487 * t170;
  t1141 = t189 * t450;
  t1144 = 0.1e1 / t47;
  t1145 = t442 * t167;
  t1148 = t48 * t167;
  t1154 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1144 * t1145 + 0.4e2 / 0.3e1 * t1148 * t446 + 0.8e1 / 0.3e1 * t166 * t1096);
  t1155 = t70 * t1154;
  t1162 = t1088 * t50;
  t1165 = t488 * t170;
  t1167 = t190 * t450;
  t1169 = t71 * t1154;
  t1171 = t78 * t1119;
  t1173 = -0.2464e4 / 0.81e2 * t1090 - t1101 * t103 / 0.4e1 - 0.3e1 / 0.4e1 * t559 * t229 - 0.3e1 / 0.4e1 * t226 * t564 - t102 * t1120 / 0.4e1 - t1129 * t108 / 0.4e1 - 0.3e1 / 0.4e1 * t571 * t241 + 0.4e1 * t235 * t581 - 0.3e1 / 0.4e1 * t235 * t584 - 0.22e2 / 0.3e1 * t107 * t1138 + 0.2e1 * t107 * t1141 - t107 * t1155 / 0.4e1 + 0.2e1 * t571 * t238 - 0.22e2 / 0.3e1 * t235 * t578 + 0.308e3 / 0.27e2 * t107 * t1162 + 0.176e3 / 0.9e1 * t1165 - 0.16e2 / 0.3e1 * t1167 + 0.2e1 / 0.3e1 * t1169 + 0.2e1 / 0.3e1 * t1171;
  t1176 = t433 * t161;
  t1178 = t147 * t549;
  t1180 = 0.12e2 * t121;
  t1181 = 0.36e2 * t1094;
  t1182 = t383 * t3;
  t1183 = 0.1e1 / t1182;
  t1185 = 0.24e2 * t2 * t1183;
  t1186 = t1180 - t1181 + t1185;
  t1189 = t387 * t158;
  t1191 = t124 * t546;
  t1193 = t151 * t151;
  t1194 = t1193 * t1081;
  t1196 = 0.1e1 / t8 / t383;
  t1197 = t1194 * t1196;
  t1199 = t471 * t384;
  t1201 = t152 * t146;
  t1204 = 0.1e1 / t8 / t120;
  t1205 = t24 * t1204;
  t1207 = -0.14e2 / 0.9e1 * t1197 + 0.7e2 / 0.9e1 * t1199 - 0.364e3 / 0.27e2 * t1201 + 0.196e3 / 0.27e2 * t1205;
  t1209 = t7 * t1207 / 0.72e2;
  t1210 = t1186 * t27 / 0.72e2 + t1189 / 0.24e2 + t1191 / 0.24e2 + t1209;
  t1213 = 0.1e1 / t19 / t1182;
  t1214 = t18 * t1213;
  t1216 = 0.1232e4 / 0.27e2 * t1214 * t30;
  t1221 = 0.2e1 / 0.9e1 * t1197 - 0.1e2 / 0.9e1 * t1199 + 0.52e2 / 0.27e2 * t1201 - 0.28e2 / 0.27e2 * t1205;
  t1222 = t1221 * t95;
  t1224 = t63 * t1222 / 0.576e3;
  t1225 = t508 * t216;
  t1226 = t63 * t1225;
  t1228 = t202 * t533;
  t1229 = t63 * t1228;
  t1244 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t48 * t1145 + 0.88e2 / 0.3e1 * t168 * t446 + 0.11e2 / 0.3e1 * t49 * t1096);
  t1253 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t55 * t1109 + 0.88e2 / 0.3e1 * t173 * t454 + 0.11e2 / 0.3e1 * t56 * t1115);
  t1255 = -0.1232e4 / 0.27e2 * t1089 * t89 + 0.88e2 / 0.3e1 * t488 * t210 - 0.8e1 * t190 * t524 + t71 * t1244 + t78 * t1253;
  t1256 = t84 * t1255;
  t1262 = t1154 + t1119;
  t1266 = t62 * t1186;
  t1269 = t463 * t184;
  t1273 = -t62 * t1173 / 0.8e1 - 0.88e2 / 0.3e1 * t1176 + 0.8e1 * t1178 - t22 * t1210 + t1216 + t1224 + t1226 / 0.192e3 + t1229 / 0.192e3 + t63 * t1256 / 0.576e3 - 0.9e1 / 0.2e2 * t37 * t124 * t459 - 0.3e1 / 0.2e2 * t37 * t7 * t1262 + t1266 * t81 / 0.32e2 + 0.3e1 / 0.32e2 * t1269 + 0.3e1 / 0.32e2 * t463 * t196;
  t1274 = t180 * t479;
  t1276 = t180 * t482;
  t1284 = -t1197 / 0.81e2 + 0.5e1 / 0.81e2 * t1199 - 0.26e2 / 0.243e3 * t1201 + 0.14e2 / 0.243e3 * t1205;
  t1285 = t1284 * t80;
  t1287 = t63 * t1285 / 0.32e2;
  t1288 = t478 * t195;
  t1289 = t63 * t1288;
  t1291 = t183 * t495;
  t1292 = t63 * t1291;
  t1297 = -0.1232e4 / 0.27e2 * t1090 + 0.88e2 / 0.3e1 * t1165 - 0.8e1 * t1167 + t1169 + t1171;
  t1298 = t65 * t1297;
  t1303 = t463 * t203;
  t1307 = t180 * t509;
  t1309 = t180 * t512;
  t1319 = 0.3e1 / 0.32e2 * t1274 + 0.3e1 / 0.16e2 * t1276 + 0.3e1 / 0.32e2 * t180 * t496 + t1287 + 0.3e1 / 0.32e2 * t1289 + 0.3e1 / 0.32e2 * t1292 + t63 * t1298 / 0.32e2 + t1266 * t96 / 0.576e3 + t1303 / 0.192e3 + t463 * t217 / 0.192e3 + t1307 / 0.192e3 + t1309 / 0.96e2 + t180 * t534 / 0.192e3 - 0.3e1 / 0.2e2 * t37 * t1186 * t58 - 0.9e1 / 0.2e2 * t37 * t387 * t176;
  t1320 = t1273 + t1319;
  t1323 = t403 * t416;
  t1325 = t407 * t146;
  t1327 = 0.4e1 / 0.9e1 * t1325 * t137;
  t1328 = t408 * t416;
  t1330 = t406 * params->c;
  t1331 = params->b * t1330;
  t1332 = t1331 * t384;
  t1334 = t1332 * t137 / 0.27e2;
  t1335 = t136 * t590;
  t1336 = t135 * t1335;
  t1337 = t247 * t151;
  t1339 = t419 * t1337 * t21;
  t1341 = t16 * t1081;
  t1342 = t114 * t470;
  t1345 = 0.2e1 / 0.9e1 * t1341 * t1342 * t384;
  t1346 = t590 * params->d;
  t1348 = t140 * t1346 * t130;
  t1349 = -t1076 - 0.2e1 / 0.3e1 * t1078 - t1085 + t16 * t12 * t1320 - 0.4e1 / 0.3e1 * t1323 - t1327 + t1328 / 0.3e1 + t1334 + t1336 + 0.2e1 / 0.3e1 * t1339 + t1345 + t1348;
  t1350 = t389 * t400;
  t1352 = t151 * t146;
  t1354 = 0.8e1 / 0.9e1 * t394 * t1352;
  t1355 = params->d * t1204;
  t1357 = 0.28e2 / 0.27e2 * t128 * t1355;
  t1358 = t134 * t1204;
  t1360 = 0.28e2 / 0.27e2 * t1358 * t137;
  t1361 = t134 * t146;
  t1363 = 0.8e1 / 0.9e1 * t1361 * t413;
  t1364 = t407 * t384;
  t1366 = t1364 * t413 / 0.9e1;
  t1367 = t412 * t424;
  t1368 = t411 * t1367;
  t1370 = t134 * t384;
  t1371 = t15 * t393;
  t1372 = t1371 * t420;
  t1374 = 0.2e1 / 0.9e1 * t1370 * t1372;
  t1377 = 0.8e1 / 0.9e1 * t419 * t420 * t146;
  t1379 = t140 * t424 * t399;
  t1383 = 0.28e2 / 0.27e2 * t140 * t141 * t1204;
  t1385 = 0.4e1 / 0.3e1 * t1350 + t1354 - t1357 + t1360 - t1363 + t1366 + 0.2e1 / 0.3e1 * t1368 + t1374 - t1377 - 0.4e1 / 0.3e1 * t1379 + t1383 - t1186 * t12;
  t1386 = t1349 + t1385;
  tv3rho30 = t118 * t1386 + 0.3e1 * t1073;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1389 = 0.2e1 * params->a * t765;
  t1390 = t598 * t400;
  t1392 = t596 * t127;
  t1394 = 0.2e1 / 0.3e1 * t1392 * t131;
  t1395 = t253 * t393;
  t1396 = t1395 * t395;
  t1404 = t487 * t265;
  t1409 = t167 * t1;
  t1410 = t1409 * t121;
  t1417 = my_piecewise3(t41, 0, 0.4e1 * t40 * t121 + 0.2e1 * t446 * t262 - 0.12e2 * t637 * t384 + 0.8e1 * t1410);
  t1418 = t1417 * sigma[2];
  t1429 = t280 * t458;
  t1436 = t1108 * t266;
  t1439 = t55 * t1;
  t1440 = t172 * t121;
  t1445 = t171 * t121;
  t1450 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t1436 * t451 - 0.16e3 / 0.9e1 * t1439 * t1440 + 0.4e2 / 0.9e1 * t625 * t454 - 0.16e2 / 0.3e1 * t1445 + 0.16e2 * t628 * t384);
  t1451 = t77 * t1450;
  t1454 = 0.4e1 / 0.3e1 * t664 * t238 - 0.22e2 / 0.9e1 * t323 * t578 + 0.4e1 / 0.3e1 * t235 * t673 - 0.22e2 / 0.9e1 * t107 * t1404 - t1418 * t103 / 0.4e1 - t642 * t229 / 0.2e1 - t311 * t564 / 0.4e1 + 0.2e1 / 0.3e1 * t559 * t314 + 0.4e1 / 0.3e1 * t226 * t649 + 0.2e1 / 0.3e1 * t102 * t1429 - t559 * t317 / 0.4e1 - t226 * t654 / 0.2e1 - t102 * t1451 / 0.4e1;
  t1457 = t172 * t1;
  t1458 = t1457 * t121;
  t1465 = my_piecewise3(t52, 0, -0.4e1 * t51 * t121 + 0.2e1 * t454 * t266 + 0.12e2 * t659 * t384 - 0.8e1 * t1458);
  t1466 = t1465 * sigma[0];
  t1479 = t189 * t620;
  t1482 = t1144 * t262;
  t1485 = t48 * t1;
  t1486 = t167 * t121;
  t1491 = t166 * t121;
  t1496 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1482 * t442 + 0.16e3 / 0.9e1 * t1485 * t1486 + 0.4e2 / 0.9e1 * t613 * t446 + 0.16e2 / 0.3e1 * t1491 - 0.16e2 * t616 * t384);
  t1497 = t70 * t1496;
  t1500 = t78 * t1450;
  t1502 = t488 * t265;
  t1504 = t190 * t620;
  t1506 = t71 * t1496;
  t1508 = t281 * t458;
  t1510 = -t1466 * t108 / 0.4e1 - t664 * t241 / 0.2e1 + 0.4e1 / 0.3e1 * t323 * t581 - t323 * t584 / 0.4e1 - t571 * t326 / 0.4e1 - t235 * t676 / 0.2e1 + 0.4e1 / 0.3e1 * t107 * t1479 - t107 * t1497 / 0.4e1 + 0.2e1 / 0.3e1 * t1500 + 0.176e3 / 0.27e2 * t1502 - 0.32e2 / 0.9e1 * t1504 + 0.2e1 / 0.3e1 * t1506 - 0.16e2 / 0.9e1 * t1508;
  t1517 = t180 * t705 / 0.288e3;
  t1520 = t508 * t301;
  t1521 = t63 * t1520;
  t1523 = t202 * t728;
  t1525 = t63 * t1523 / 0.288e3;
  t1541 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t613 * t442 + 0.352e3 / 0.9e1 * t616 * t1486 + 0.88e2 / 0.9e1 * t263 * t446 + 0.22e2 / 0.3e1 * t49 * t121 - 0.22e2 * t712 * t384);
  t1556 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t625 * t451 - 0.352e3 / 0.9e1 * t628 * t1440 + 0.88e2 / 0.9e1 * t267 * t454 - 0.22e2 / 0.3e1 * t56 * t121 + 0.22e2 * t722 * t384);
  t1558 = 0.88e2 / 0.9e1 * t488 * t293 - 0.16e2 / 0.3e1 * t190 * t716 + t71 * t1541 - 0.8e1 / 0.3e1 * t281 * t531 + t78 * t1556;
  t1559 = t84 * t1558;
  t1565 = t1496 + t1450;
  t1569 = 0.4e1 * t121;
  t1570 = 0.12e2 * t1094;
  t1571 = -t1569 - t1570 + t1185;
  t1572 = t62 * t1571;
  t1576 = t696 * t184 / 0.16e2;
  t1579 = -t62 * (t1454 + t1510) / 0.8e1 + t463 * t302 / 0.576e3 + t1517 + t180 * t729 / 0.288e3 + t1521 / 0.576e3 + t1525 + t63 * t1559 / 0.576e3 - 0.3e1 / 0.1e2 * t37 * t124 * t742 - 0.3e1 / 0.2e2 * t37 * t7 * t1565 + t1572 * t81 / 0.32e2 + t1576 + t696 * t196 / 0.16e2;
  t1580 = t274 * t479;
  t1583 = t274 * t482 / 0.16e2;
  t1589 = t180 * t754 / 0.16e2;
  t1592 = t478 * t285;
  t1593 = t63 * t1592;
  t1595 = t183 * t692;
  t1597 = t63 * t1595 / 0.16e2;
  t1601 = 0.88e2 / 0.9e1 * t1502 - 0.16e2 / 0.3e1 * t1504 + t1506 - 0.8e1 / 0.3e1 * t1508 + t1500;
  t1602 = t65 * t1601;
  t1608 = t696 * t203 / 0.288e3;
  t1611 = t1580 / 0.32e2 + t1583 + t274 * t496 / 0.32e2 + t463 * t286 / 0.32e2 + t1589 + t180 * t693 / 0.16e2 + t1593 / 0.32e2 + t1597 + t63 * t1602 / 0.32e2 + t1572 * t96 / 0.576e3 + t1608 + t696 * t217 / 0.288e3;
  t1613 = t274 * t509;
  t1616 = t274 * t512 / 0.288e3;
  t1632 = 0.16e2 / 0.3e1 * t147 * t685;
  t1636 = t596 * t158 / 0.36e2;
  t1637 = t253 * t546;
  t1641 = t1571 * t27 / 0.72e2 + t1636 + t1637 / 0.72e2 + t1189 / 0.72e2 + t1191 / 0.36e2 + t1209;
  t1643 = t433 * t257;
  t1647 = t1613 / 0.576e3 + t1616 + t274 * t534 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t253 * t459 - 0.3e1 / 0.2e2 * t37 * t387 * t270 - 0.3e1 / 0.2e2 * t37 * t1571 * t58 - 0.3e1 / 0.1e2 * t37 * t596 * t176 + t1632 - t22 * t1641 - 0.88e2 / 0.9e1 * t1643 - 0.176e3 / 0.9e1 * t1176 + 0.8e1 / 0.3e1 * t1178;
  t1658 = t1216 + t1224 + t1226 / 0.288e3 + t1229 / 0.576e3 + t1269 / 0.32e2 + t1274 / 0.16e2 + t1276 / 0.16e2 + t1287 + t1289 / 0.16e2 + t1292 / 0.32e2 + t1303 / 0.576e3 + t1307 / 0.288e3 + t1309 / 0.288e3;
  t1660 = t1579 + t1611 + t1647 + t1658;
  t1666 = t136 * t762;
  t1668 = 0.2e1 / 0.3e1 * t135 * t1666;
  t1669 = t408 * t604;
  t1671 = t762 * params->d;
  t1674 = 0.2e1 / 0.3e1 * t140 * t1671 * t130;
  t1675 = t332 * t151;
  t1677 = t419 * t1675 * t21;
  t1679 = t403 * t604;
  t1682 = t140 * t607 * t399;
  t1685 = 0.4e1 / 0.9e1 * t1390 - t1394 - 0.2e1 / 0.9e1 * t1396 + t16 * t12 * t1660 + 0.8e1 / 0.9e1 * t1350 + t1354 - t1357 - t1076 / 0.3e1 - 0.4e1 / 0.9e1 * t1078 - t1085 + t1668 + t1669 / 0.9e1 + t1674 + 0.2e1 / 0.9e1 * t1677 - 0.4e1 / 0.9e1 * t1679 - 0.4e1 / 0.9e1 * t1682 - 0.8e1 / 0.9e1 * t1323;
  t1691 = t412 * t607;
  t1692 = t411 * t1691;
  t1696 = -t1327 + 0.2e1 / 0.9e1 * t1328 + t1334 + t1336 / 0.3e1 + 0.4e1 / 0.9e1 * t1339 + t1345 + t1348 / 0.3e1 + t1360 - t1377 - 0.8e1 / 0.9e1 * t1379 + t1383 + 0.2e1 / 0.9e1 * t1692 - t1363 + t1366 + 0.4e1 / 0.9e1 * t1368 + t1374 - t1571 * t12;
  t1697 = t1685 + t1696;
  tv3rho31 = t118 * t1697 + t1073 + t1389;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1699 = params->a * t897;
  t1704 = -t1569 + t1570 + t1185;
  t1706 = t136 * t894;
  t1707 = t135 * t1706;
  t1709 = t894 * params->d;
  t1711 = t140 * t1709 * t130;
  t1717 = 0.8e1 / 0.9e1 * t1390 - t1394 - 0.4e1 / 0.9e1 * t1396 + 0.4e1 / 0.9e1 * t1350 + t1354 - t1357 - 0.2e1 / 0.9e1 * t1078 - t1085 - t1704 * t12 + t1707 / 0.3e1 + t1711 / 0.3e1 + t1668 + 0.2e1 / 0.9e1 * t1669 + t1674 + 0.4e1 / 0.9e1 * t1677 - 0.8e1 / 0.9e1 * t1679 - 0.8e1 / 0.9e1 * t1682;
  t1724 = t768 * t127;
  t1725 = t1724 * t131;
  t1731 = t1517 + t1521 / 0.288e3 + t1525 + t1576 + t1580 / 0.16e2 + t1583 + t1589 + t1593 / 0.16e2 + t1597 + t1608 + t1613 / 0.288e3 + t1616;
  t1734 = t147 * t853;
  t1740 = t1144 * t784;
  t1745 = t48 * t788;
  t1750 = -0.2e1 * t121 - 0.6e1 * t1094;
  t1751 = t166 * t1750;
  t1754 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1740 * t167 + 0.16e3 / 0.9e1 * t613 * t381 + 0.4e2 / 0.9e1 * t1745 * t167 + 0.8e1 / 0.3e1 * t1751);
  t1755 = t71 * t1754;
  t1757 = t814 * t175;
  t1759 = t281 * t632;
  t1761 = t1108 * t793;
  t1766 = t55 * t796;
  t1769 = -t1750;
  t1770 = t171 * t1769;
  t1773 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t1761 * t172 - 0.16e3 / 0.9e1 * t625 * t381 + 0.4e2 / 0.9e1 * t1766 * t172 + 0.8e1 / 0.3e1 * t1770);
  t1774 = t78 * t1773;
  t1776 = t190 * t792;
  t1784 = t70 * t1754;
  t1791 = t189 * t792;
  t1794 = t262 * t1;
  t1797 = t167 * t788;
  t1802 = my_piecewise3(t41, 0, 0.8e1 * t1794 * t121 + 0.2e1 * t40 * t1750 + 0.2e1 * t1797);
  t1803 = t1802 * sigma[2];
  t1806 = 0.2e1 / 0.3e1 * t1755 + 0.176e3 / 0.27e2 * t1757 - 0.32e2 / 0.9e1 * t1759 + 0.2e1 / 0.3e1 * t1774 - 0.16e2 / 0.9e1 * t1776 - t664 * t326 / 0.2e1 - t323 * t676 / 0.2e1 - t235 * t888 / 0.4e1 - t107 * t1784 / 0.4e1 + 0.2e1 / 0.3e1 * t883 * t238 + 0.4e1 / 0.3e1 * t323 * t673 + 0.2e1 / 0.3e1 * t107 * t1791 - t1803 * t103 / 0.4e1;
  t1819 = t813 * t175;
  t1824 = t280 * t632;
  t1829 = t77 * t1773;
  t1832 = t266 * t1;
  t1835 = t172 * t796;
  t1840 = my_piecewise3(t52, 0, -0.8e1 * t1832 * t121 + 0.2e1 * t51 * t1769 + 0.2e1 * t1835);
  t1841 = t1840 * sigma[0];
  t1846 = -t863 * t229 / 0.4e1 + 0.4e1 / 0.3e1 * t642 * t314 + 0.4e1 / 0.3e1 * t311 * t649 - t642 * t317 / 0.2e1 - t311 * t654 / 0.2e1 - 0.22e2 / 0.9e1 * t226 * t870 - 0.22e2 / 0.9e1 * t102 * t1819 + 0.4e1 / 0.3e1 * t226 * t873 + 0.4e1 / 0.3e1 * t102 * t1824 - t226 * t876 / 0.4e1 - t102 * t1829 / 0.4e1 - t1841 * t108 / 0.4e1 - t883 * t241 / 0.4e1;
  t1850 = t1632 - 0.176e3 / 0.9e1 * t1643 - 0.88e2 / 0.9e1 * t1176 + 0.8e1 / 0.3e1 * t1734 + t1216 + t1224 + t1226 / 0.576e3 + t1274 / 0.32e2 + t1287 + t1289 / 0.32e2 + t1307 / 0.576e3 - t62 * (t1806 + t1846) / 0.8e1;
  t1854 = t768 * t158;
  t1858 = t1704 * t27 / 0.72e2 + t1854 / 0.72e2 + t1636 + t1637 / 0.36e2 + t1191 / 0.72e2 + t1209;
  t1871 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t785 * t167 + 0.352e3 / 0.9e1 * t263 * t381 + 0.88e2 / 0.9e1 * t789 * t167 + 0.11e2 / 0.3e1 * t49 * t1750);
  t1886 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t794 * t172 - 0.352e3 / 0.9e1 * t267 * t381 + 0.88e2 / 0.9e1 * t797 * t172 + 0.11e2 / 0.3e1 * t56 * t1769);
  t1888 = -0.8e1 / 0.3e1 * t190 * t833 + t71 * t1871 + 0.88e2 / 0.9e1 * t814 * t214 - 0.16e2 / 0.3e1 * t281 * t726 + t78 * t1886;
  t1889 = t84 * t1888;
  t1892 = t183 * t820;
  t1893 = t63 * t1892;
  t1898 = -0.8e1 / 0.3e1 * t1776 + t1755 + 0.88e2 / 0.9e1 * t1757 - 0.16e2 / 0.3e1 * t1759 + t1774;
  t1899 = t65 * t1898;
  t1902 = t62 * t1704;
  t1905 = t805 * t203;
  t1911 = t274 * t705;
  t1917 = t202 * t846;
  t1918 = t63 * t1917;
  t1920 = -t22 * t1858 + t63 * t1889 / 0.576e3 + t1893 / 0.32e2 + t63 * t1899 / 0.32e2 + t1902 * t96 / 0.576e3 + t1905 / 0.576e3 + t805 * t217 / 0.576e3 + t696 * t302 / 0.288e3 + t1911 / 0.288e3 + t274 * t729 / 0.288e3 + t180 * t847 / 0.576e3 + t1918 / 0.576e3;
  t1936 = t1754 + t1773;
  t1942 = t805 * t184;
  t1948 = t274 * t754;
  t1954 = -0.3e1 / 0.2e2 * t37 * t1704 * t58 - 0.3e1 / 0.2e2 * t37 * t768 * t176 - 0.3e1 / 0.1e2 * t37 * t596 * t270 - 0.3e1 / 0.1e2 * t37 * t253 * t742 - 0.3e1 / 0.2e2 * t37 * t124 * t801 - 0.3e1 / 0.2e2 * t37 * t7 * t1936 + t1902 * t81 / 0.32e2 + t1942 / 0.32e2 + t805 * t196 / 0.32e2 + t696 * t286 / 0.16e2 + t1948 / 0.16e2 + t274 * t693 / 0.16e2 + t180 * t821 / 0.32e2;
  t1956 = t1731 + t1850 + t1920 + t1954;
  t1959 = -0.4e1 / 0.9e1 * t1323 - t1327 + t1328 / 0.9e1 + t1334 + 0.2e1 / 0.9e1 * t1339 + t1345 + t1360 - t1377 - 0.4e1 / 0.9e1 * t1379 + t1383 + 0.4e1 / 0.9e1 * t1692 - t1363 + t1366 + 0.2e1 / 0.9e1 * t1368 + t1374 - t1725 / 0.3e1 + t16 * t12 * t1956;
  t1960 = t1717 + t1959;
  tv3rho32 = t118 * t1960 + t1389 + t1699;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1967 = -t1085 - 0.2e1 / 0.3e1 * t1396 - t1327 + t1334 + t1345 + t1669 / 0.3e1 + 0.2e1 / 0.3e1 * t1677 + t1707 + t1711 + t1354 - t1357 + 0.4e1 / 0.3e1 * t1390;
  t1971 = t1180 + t1181 + t1185;
  t1985 = 0.1e1 / t75 / t811 / rho[1];
  t1986 = t1985 * t57;
  t1989 = t784 * t262;
  t1990 = t1144 * t1989;
  t1995 = -0.6e1 * t121 - 0.6e1 * t1094;
  t1996 = t166 * t1995;
  t1999 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1990 + 0.4e2 / 0.3e1 * t613 * t788 + 0.8e1 / 0.3e1 * t1996);
  t2000 = t71 * t1999;
  t2002 = t814 * t269;
  t2004 = t281 * t800;
  t2006 = t793 * t266;
  t2007 = t1108 * t2006;
  t2011 = -t1995;
  t2012 = t171 * t2011;
  t2015 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t2007 + 0.4e2 / 0.3e1 * t625 * t796 + 0.8e1 / 0.3e1 * t2012);
  t2016 = t78 * t2015;
  t2018 = sigma[2] * t1985;
  t2019 = t2018 * t57;
  t2026 = my_piecewise3(t41, 0, 0.2e1 * t40 * t1995 + 0.6e1 * t262 * t788);
  t2027 = t2026 * sigma[2];
  t2036 = t813 * t269;
  t2039 = t280 * t800;
  t2042 = t77 * t2015;
  t2050 = my_piecewise3(t52, 0, 0.2e1 * t51 * t2011 + 0.6e1 * t266 * t796);
  t2051 = t2050 * sigma[0];
  t2058 = t70 * t1999;
  t2061 = 0.2e1 * t863 * t314 - 0.22e2 / 0.3e1 * t311 * t870 + 0.308e3 / 0.27e2 * t102 * t1986 + 0.2e1 / 0.3e1 * t2000 + 0.176e3 / 0.9e1 * t2002 - 0.16e2 / 0.3e1 * t2004 + 0.2e1 / 0.3e1 * t2016 - 0.2464e4 / 0.81e2 * t2019 - t2027 * t103 / 0.4e1 - 0.3e1 / 0.4e1 * t863 * t317 + 0.4e1 * t311 * t873 - 0.3e1 / 0.4e1 * t311 * t876 - 0.22e2 / 0.3e1 * t102 * t2036 + 0.2e1 * t102 * t2039 - t102 * t2042 / 0.4e1 - t2051 * t108 / 0.4e1 - 0.3e1 / 0.4e1 * t883 * t326 - 0.3e1 / 0.4e1 * t323 * t888 - t107 * t2058 / 0.4e1;
  t2068 = t1971 * t27 / 0.72e2 + t1854 / 0.24e2 + t1637 / 0.24e2 + t1209;
  t2079 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t48 * t1989 + 0.88e2 / 0.3e1 * t263 * t788 + 0.11e2 / 0.3e1 * t49 * t1995);
  t2094 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t55 * t2006 + 0.88e2 / 0.3e1 * t267 * t796 + 0.11e2 / 0.3e1 * t56 * t2011);
  t2096 = t71 * t2079 - 0.1232e4 / 0.27e2 * t2018 * t93 + 0.88e2 / 0.3e1 * t814 * t299 - 0.8e1 * t281 * t844 + t78 * t2094;
  t2097 = t84 * t2096;
  t2103 = t1521 / 0.192e3 + 0.3e1 / 0.32e2 * t1580 + 0.3e1 / 0.32e2 * t1593 + t1613 / 0.192e3 - 0.88e2 / 0.3e1 * t1643 + 0.8e1 * t1734 + t1216 + t1224 + t1287 - t62 * t2061 / 0.8e1 - t22 * t2068 + t274 * t847 / 0.192e3 + t63 * t2097 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t1971 * t58;
  t2110 = t1999 + t2015;
  t2114 = t62 * t1971;
  t2124 = t2000 - 0.1232e4 / 0.27e2 * t2019 + 0.88e2 / 0.3e1 * t2002 - 0.8e1 * t2004 + t2016;
  t2125 = t65 * t2124;
  t2138 = -0.9e1 / 0.2e2 * t37 * t768 * t270 - 0.9e1 / 0.2e2 * t37 * t253 * t801 - 0.3e1 / 0.2e2 * t37 * t7 * t2110 + t2114 * t81 / 0.32e2 + 0.3e1 / 0.32e2 * t805 * t286 + 0.3e1 / 0.32e2 * t274 * t821 + t63 * t2125 / 0.32e2 + t2114 * t96 / 0.576e3 + t805 * t302 / 0.192e3 + 0.3e1 / 0.32e2 * t1893 + t1905 / 0.192e3 + t1911 / 0.96e2 + t1918 / 0.192e3 + 0.3e1 / 0.32e2 * t1942 + 0.3e1 / 0.16e2 * t1948;
  t2139 = t2103 + t2138;
  t2142 = t1360 - t1363 + t1366 + t1374 - t1377 + t1383 - 0.4e1 / 0.3e1 * t1679 + 0.2e1 / 0.3e1 * t1692 - 0.4e1 / 0.3e1 * t1682 - t1971 * t12 - t1725 + t16 * t12 * t2139;
  t2143 = t1967 + t2142;
  tv3rho33 = t118 * t2143 + 0.3e1 * t1699;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2145 = t899 * params->c;
  t2146 = t130 * t15;
  t2149 = 0.2e1 / 0.9e1 * t2145 * t2146 * t904;
  t2150 = t899 * t15;
  t2151 = t127 * t354;
  t2154 = 0.2e1 / 0.9e1 * t2150 * t2151 * t131;
  t2155 = t899 * t955;
  t2157 = t406 * t15;
  t2160 = t357 * t2157 * t904 / 0.9e1;
  t2161 = t356 * t134;
  t2163 = 0.2e1 / 0.9e1 * t2161 * t909;
  t2164 = t12 * t954;
  t2166 = t902 * t903 * t2164;
  t2169 = t1371 * t354 * t151;
  t2171 = 0.2e1 / 0.9e1 * t357 * t2169;
  t2173 = t412 * t954 * params->d;
  t2174 = t902 * t2173;
  t2178 = t183 * t189;
  t2179 = t2178 * t50;
  t2180 = t63 * t2179;
  t2182 = t65 * t487;
  t2183 = t2182 * t50;
  t2188 = t202 * t189;
  t2189 = t2188 * t89;
  t2190 = t63 * t2189;
  t2192 = t84 * t487;
  t2193 = t2192 * t89;
  t2198 = t180 * t918;
  t2202 = t478 * t70;
  t2203 = t2202 * t50;
  t2205 = t63 * t2203 / 0.32e2;
  t2206 = t917 * t170;
  t2207 = t63 * t2206;
  t2209 = t921 * t170;
  t2212 = -t180 * t922 / 0.6e1 - t2180 / 0.6e1 + 0.11e2 / 0.36e2 * t63 * t2183 - t180 * t935 / 0.108e3 - t2190 / 0.108e3 + 0.11e2 / 0.648e3 * t63 * t2193 + t463 * t340 / 0.32e2 + t2198 / 0.16e2 + t180 * t925 / 0.16e2 + t2205 + t2207 / 0.16e2 - t63 * t2209 / 0.6e1;
  t2213 = t339 * t450;
  t2218 = t180 * t931;
  t2222 = t508 * t70;
  t2223 = t2222 * t89;
  t2225 = t63 * t2223 / 0.576e3;
  t2226 = t930 * t210;
  t2227 = t63 * t2226;
  t2229 = t934 * t210;
  t2232 = t343 * t524;
  t2236 = 0.88e2 / 0.9e1 * t432 * t30;
  t2237 = t146 * t161;
  t2238 = 0.16e2 / 0.3e1 * t2237;
  t2239 = t21 * t549;
  t2243 = t570 * t70;
  t2246 = t234 * t189;
  t2251 = t106 * t487;
  t2261 = t63 * t2213 / 0.32e2 + t463 * t344 / 0.576e3 + t2218 / 0.288e3 + t180 * t938 / 0.288e3 + t2225 + t2227 / 0.288e3 - t63 * t2229 / 0.108e3 + t63 * t2232 / 0.576e3 - t2236 + t2238 - t2239 - t62 * (0.176e3 / 0.27e2 * t578 - 0.32e2 / 0.9e1 * t581 + 0.2e1 / 0.3e1 * t584 - t2243 * t50 / 0.4e1 + 0.4e1 / 0.3e1 * t2246 * t50 - t943 * t170 / 0.2e1 - 0.22e2 / 0.9e1 * t2251 * t50 + 0.4e1 / 0.3e1 * t946 * t170 - t348 * t450 / 0.4e1) / 0.8e1;
  t2262 = t2212 + t2261;
  t2263 = t136 * t2262;
  tv3rho2sigma0 = t2149 + t2154 + 0.2e1 * t2155 + t2160 + t2163 + 0.2e1 / 0.3e1 * t2166 + t2171 + 0.2e1 / 0.3e1 * t2174 + t337 * t2263;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t2266 = t146 * params->a * params->b;
  t2268 = 0.8e2 / 0.9e1 * t2266 * t358;
  t2270 = t384 * params->a * params->b;
  t2272 = 0.28e2 / 0.9e1 * t2270 * t964;
  t2274 = 0.28e2 / 0.9e1 * t2270 * t968;
  t2275 = t958 * t971;
  t2277 = t1196 * params->a;
  t2278 = t2277 * params->b;
  t2279 = t2157 * t963;
  t2281 = 0.2e1 / 0.9e1 * t2278 * t2279;
  t2282 = t2277 * t134;
  t2284 = 0.4e1 / 0.9e1 * t2282 * t968;
  t2285 = t12 * t161;
  t2286 = t903 * t2285;
  t2287 = t962 * t2286;
  t2290 = t1371 * t30 * t151;
  t2292 = 0.4e1 / 0.9e1 * t2278 * t2290;
  t2294 = t412 * t161 * params->d;
  t2295 = t962 * t2294;
  t2297 = t136 * t549;
  tv3rho2sigma1 = -t2268 + t2272 + t2274 + 0.2e2 / 0.3e1 * t2275 - t2281 - t2284 - 0.4e1 / 0.3e1 * t2287 - t2292 - 0.4e1 / 0.3e1 * t2295 - 0.2e1 * t357 * t2297;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2302 = 0.2e1 / 0.9e1 * t2145 * t2146 * t975;
  t2303 = t127 * t376;
  t2306 = 0.2e1 / 0.9e1 * t2150 * t2303 * t131;
  t2307 = t899 * t1011;
  t2311 = t357 * t2157 * t975 / 0.9e1;
  t2313 = 0.2e1 / 0.9e1 * t2161 * t980;
  t2314 = t12 * t1010;
  t2316 = t902 * t903 * t2314;
  t2319 = t1371 * t376 * t151;
  t2321 = 0.2e1 / 0.9e1 * t357 * t2319;
  t2323 = t412 * t1010 * params->d;
  t2324 = t902 * t2323;
  t2328 = t180 * t986;
  t2332 = t478 * t77;
  t2333 = t2332 * t57;
  t2335 = t63 * t2333 / 0.32e2;
  t2336 = t985 * t175;
  t2337 = t63 * t2336;
  t2339 = t361 * t458;
  t2344 = t180 * t995;
  t2348 = t508 * t77;
  t2349 = t2348 * t93;
  t2351 = t63 * t2349 / 0.576e3;
  t2352 = t994 * t214;
  t2353 = t63 * t2352;
  t2355 = t365 * t531;
  t2359 = t558 * t77;
  t2369 = -t2236 + t2238 - t2239 + t463 * t362 / 0.32e2 + t2328 / 0.16e2 + t180 * t989 / 0.16e2 + t2335 + t2337 / 0.16e2 + t63 * t2339 / 0.32e2 + t463 * t366 / 0.576e3 + t2344 / 0.288e3 + t180 * t998 / 0.288e3 + t2351 + t2353 / 0.288e3 + t63 * t2355 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t564 - t2359 * t57 / 0.4e1 - t1002 * t175 / 0.2e1 - t370 * t458 / 0.4e1) / 0.8e1;
  t2370 = t136 * t2369;
  tv3rho2sigma2 = t2302 + t2306 + 0.2e1 * t2307 + t2311 + t2313 + 0.2e1 / 0.3e1 * t2316 + t2321 + 0.2e1 / 0.3e1 * t2324 + t337 * t2370;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2374 = t899 * t1034;
  t2375 = t12 * t1033;
  t2377 = t902 * t903 * t2375;
  t2380 = t412 * t1033 * params->d;
  t2381 = t902 * t2380;
  t2383 = t21 * t685;
  t2386 = t663 * t70;
  t2389 = t322 * t189;
  t2403 = t146 * t257;
  t2404 = 0.8e1 / 0.3e1 * t2403;
  t2405 = t339 * t620;
  t2410 = t274 * t931;
  t2416 = t930 * t293;
  t2417 = t63 * t2416;
  t2419 = t343 * t716;
  t2424 = t921 * t265;
  t2429 = t934 * t293;
  t2432 = -t2383 - t62 * (-0.16e2 / 0.9e1 * t673 + 0.2e1 / 0.3e1 * t676 - t2386 * t50 / 0.4e1 + 0.2e1 / 0.3e1 * t2389 * t50 - t1025 * t170 / 0.4e1 - t943 * t265 / 0.4e1 + 0.2e1 / 0.3e1 * t946 * t265 - t348 * t620 / 0.4e1) / 0.8e1 + t2404 + t63 * t2405 / 0.32e2 + t696 * t344 / 0.576e3 + t2410 / 0.576e3 + t274 * t938 / 0.576e3 + t180 * t1021 / 0.576e3 + t2417 / 0.576e3 + t63 * t2419 / 0.576e3 - t274 * t922 / 0.12e2 - t63 * t2424 / 0.12e2 - t274 * t935 / 0.216e3 - t63 * t2429 / 0.216e3;
  t2435 = t274 * t918;
  t2441 = t917 * t265;
  t2442 = t63 * t2441;
  t2450 = 0.8e1 / 0.3e1 * t2237;
  t2451 = t696 * t340 / 0.32e2 + t2435 / 0.32e2 + t274 * t925 / 0.32e2 + t180 * t1016 / 0.32e2 + t2442 / 0.32e2 - t2180 / 0.12e2 - t2190 / 0.216e3 + t2198 / 0.32e2 + t2205 + t2207 / 0.32e2 + t2218 / 0.576e3 + t2225 + t2227 / 0.576e3 - t2236 + t2450;
  t2452 = t2432 + t2451;
  t2453 = t136 * t2452;
  tv3rho2sigma3 = t2149 + t2154 + t2155 + t2160 + t2163 + t2166 / 0.3e1 + t2171 + t2174 / 0.3e1 + t2374 + t2377 / 0.3e1 + t2381 / 0.3e1 + t337 * t2453;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t2458 = t958 * t1036;
  t2460 = t12 * t257;
  t2461 = t903 * t2460;
  t2462 = t962 * t2461;
  t2465 = t412 * t257 * params->d;
  t2466 = t962 * t2465;
  t2468 = t136 * t685;
  tv3rho2sigma4 = -t2268 + t2272 + t2274 + 0.1e2 / 0.3e1 * t2275 - t2281 - t2284 - 0.2e1 / 0.3e1 * t2287 - t2292 - 0.2e1 / 0.3e1 * t2295 + 0.1e2 / 0.3e1 * t2458 - 0.2e1 / 0.3e1 * t2462 - 0.2e1 / 0.3e1 * t2466 - 0.2e1 * t357 * t2468;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2473 = t899 * t1071;
  t2474 = t12 * t1070;
  t2476 = t902 * t903 * t2474;
  t2479 = t412 * t1070 * params->d;
  t2480 = t902 * t2479;
  t2484 = t274 * t986;
  t2490 = t183 * t280;
  t2491 = t2490 * t57;
  t2492 = t63 * t2491;
  t2494 = t1041 * t175;
  t2499 = t985 * t269;
  t2500 = t63 * t2499;
  t2502 = t361 * t632;
  t2507 = t274 * t995;
  t2511 = -t2383 + t2404 + t696 * t362 / 0.32e2 + t2484 / 0.32e2 + t274 * t989 / 0.32e2 - t180 * t1042 / 0.12e2 - t2492 / 0.12e2 - t63 * t2494 / 0.12e2 + t180 * t1045 / 0.32e2 + t2500 / 0.32e2 + t63 * t2502 / 0.32e2 + t696 * t366 / 0.576e3 + t2507 / 0.576e3 + t274 * t998 / 0.576e3;
  t2514 = t202 * t280;
  t2515 = t2514 * t93;
  t2516 = t63 * t2515;
  t2518 = t1050 * t214;
  t2523 = t994 * t299;
  t2524 = t63 * t2523;
  t2526 = t365 * t726;
  t2535 = t641 * t77;
  t2540 = t225 * t280;
  t2552 = -t180 * t1051 / 0.216e3 - t2516 / 0.216e3 - t63 * t2518 / 0.216e3 + t180 * t1054 / 0.576e3 + t2524 / 0.576e3 + t63 * t2526 / 0.576e3 + t2328 / 0.32e2 + t2335 + t2337 / 0.32e2 + t2344 / 0.576e3 + t2351 + t2353 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t649 + 0.2e1 / 0.3e1 * t654 - t2535 * t57 / 0.4e1 - t1059 * t175 / 0.4e1 + 0.2e1 / 0.3e1 * t2540 * t57 + 0.2e1 / 0.3e1 * t1062 * t175 - t1002 * t269 / 0.4e1 - t370 * t632 / 0.4e1) / 0.8e1 - t2236 + t2450;
  t2553 = t2511 + t2552;
  t2554 = t136 * t2553;
  tv3rho2sigma5 = t2302 + t2306 + t2307 + t2311 + t2313 + t2316 / 0.3e1 + t2321 + t2324 / 0.3e1 + t2473 + t2476 / 0.3e1 + t2480 / 0.3e1 + t337 * t2554;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2559 = 0.16e2 / 0.3e1 * t2403;
  t2560 = t21 * t853;
  t2567 = t339 * t792;
  t2576 = t343 * t833;
  t2580 = t882 * t70;
  t2590 = -t2236 + t2559 - t2560 + t805 * t340 / 0.32e2 + t2435 / 0.16e2 + t274 * t1016 / 0.16e2 + t2205 + t2442 / 0.16e2 + t63 * t2567 / 0.32e2 + t805 * t344 / 0.576e3 + t2410 / 0.288e3 + t274 * t1021 / 0.288e3 + t2225 + t2417 / 0.288e3 + t63 * t2576 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t888 - t2580 * t50 / 0.4e1 - t1025 * t265 / 0.2e1 - t348 * t792 / 0.4e1) / 0.8e1;
  t2591 = t136 * t2590;
  tv3rho2sigma6 = t2149 + t2154 + 0.2e1 * t2374 + t2160 + t2163 + 0.2e1 / 0.3e1 * t2377 + t2171 + 0.2e1 / 0.3e1 * t2381 + t337 * t2591;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t2596 = t136 * t853;
  tv3rho2sigma7 = -t2268 + t2272 + t2274 + 0.2e2 / 0.3e1 * t2458 - t2281 - t2284 - 0.4e1 / 0.3e1 * t2462 - t2292 - 0.4e1 / 0.3e1 * t2466 - 0.2e1 * t357 * t2596;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2604 = t65 * t813;
  t2605 = t2604 * t57;
  t2610 = t84 * t813;
  t2611 = t2610 * t93;
  t2620 = -t274 * t1042 / 0.6e1 + 0.11e2 / 0.36e2 * t63 * t2605 - t274 * t1051 / 0.108e3 + 0.11e2 / 0.648e3 * t63 * t2611 + t2335 + t2351 + t2484 / 0.16e2 - t2492 / 0.6e1 + t2500 / 0.16e2 + t2507 / 0.288e3 - t2516 / 0.108e3 + t2524 / 0.288e3;
  t2625 = t1041 * t269;
  t2628 = t361 * t800;
  t2635 = t1050 * t299;
  t2638 = t365 * t844;
  t2644 = t862 * t77;
  t2647 = t310 * t280;
  t2652 = t101 * t813;
  t2662 = t805 * t362 / 0.32e2 + t274 * t1045 / 0.16e2 - t63 * t2625 / 0.6e1 + t63 * t2628 / 0.32e2 + t805 * t366 / 0.576e3 + t274 * t1054 / 0.288e3 - t63 * t2635 / 0.108e3 + t63 * t2638 / 0.576e3 - t2236 + t2559 - t2560 - t62 * (0.176e3 / 0.27e2 * t870 - 0.32e2 / 0.9e1 * t873 + 0.2e1 / 0.3e1 * t876 - t2644 * t57 / 0.4e1 + 0.4e1 / 0.3e1 * t2647 * t57 - t1059 * t269 / 0.2e1 - 0.22e2 / 0.9e1 * t2652 * t57 + 0.4e1 / 0.3e1 * t1062 * t269 - t370 * t800 / 0.4e1) / 0.8e1;
  t2663 = t2620 + t2662;
  t2664 = t136 * t2663;
  tv3rho2sigma8 = t2302 + t2306 + 0.2e1 * t2473 + t2311 + t2313 + 0.2e1 / 0.3e1 * t2476 + t2321 + 0.2e1 / 0.3e1 * t2480 + t337 * t2664;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rhosigma20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3sigma30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t9;
  double t11, t12, t15, t16, t18, t19, t21, t22;
  double t24, t25, t27, t30, t32, t33, t34, t35;
  double t36, t37, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t49, t50, t51;
  double t52, t53, t54, t55, t56, t57, t58, t62;
  double t63, t65, t66, t67, t68, t70, t71, t72;
  double t73, t74, t75, t77, t78, t79, t80, t81;
  double t84, t86, t89, t93, t95, t96, t101, t102;
  double t103, t106, t107, t108, t114, tzk0;

  double t118, t119, t120, t121, t122, t124, t126, t127;
  double t128, t130, t131, t133, t134, t135, t136, t137;
  double t139, t140, t141, t144, t146, t147, t149, t151;
  double t152, t154, t157, t158, t159, t161, t166, t167;
  double t168, t170, t171, t172, t173, t175, t176, t180;
  double t183, t184, t186, t189, t190, t191, t193, t194;
  double t195, t196, t202, t203, t205, t210, t214, t216;
  double t217, t225, t226, t229, t234, t235, t238, t241;
  double t247, t250, tvrho0, t253, t257, t262, t263, t265;
  double t266, t267, t269, t270, t274, t277, t280, t281;
  double t282, t284, t285, t286, t293, t299, t301, t302;
  double t310, t311, t314, t317, t322, t323, t326, t332;
  double t335, tvrho1, t337, t338, t339, t340, t343, t344;
  double t348, t354, t355, tvsigma0, t356, t357, t358, tvsigma1;
  double t361, t362, t365, t366, t370, t376, t377, tvsigma2;

  double t378, t380, t381, t382, t383, t384, t386, t387;
  double t389, t390, t393, t394, t395, t397, t399, t400;
  double t402, t403, t405, t406, t407, t408, t410, t411;
  double t412, t413, t415, t416, t417, t419, t420, t423;
  double t424, t426, t430, t432, t433, t435, t442, t443;
  double t446, t450, t451, t452, t454, t458, t459, t463;
  double t466, t470, t471, t472, t474, t476, t478, t479;
  double t481, t482, t483, t485, t487, t488, t489, t491;
  double t493, t494, t495, t496, t501, t508, t509, t511;
  double t512, t513, t524, t531, t533, t534, t537, t541;
  double t546, t547, t548, t549, t558, t559, t564, t570;
  double t571, t578, t581, t584, t587, t590, t593, tv2rho20;
  double t595, t596, t598, t599, t604, t605, t607, t609;
  double t611, t613, t616, t620, t621, t623, t625, t628;
  double t632, t633, t637, t641, t642, t649, t654, t659;
  double t663, t664, t673, t676, t679, t683, t685, t687;
  double t692, t693, t696, t699, t705, t706, t712, t716;
  double t722, t726, t728, t729, t735, t742, t748, t754;
  double t755, t761, t762, t765, tv2rho21, t768, t784, t785;
  double t788, t789, t792, t793, t794, t796, t797, t800;
  double t801, t805, t810, t811, t813, t814, t815, t817;
  double t819, t820, t821, t833, t844, t846, t847, t853;
  double t862, t863, t870, t873, t876, t882, t883, t888;
  double t891, t894, t897, tv2rho22, t899, t900, t902, t903;
  double t904, t907, t909, t911, t913, t914, t917, t918;
  double t920, t921, t922, t925, t930, t931, t933, t934;
  double t935, t938, t943, t946, t954, t955, tv2rhosigma0, t958;
  double t960, t961, t962, t963, t964, t966, t968, t970;
  double t971, tv2rhosigma1, t974, t975, t978, t980, t982, t985;
  double t986, t988, t989, t994, t995, t997, t998, t1002;
  double t1010, t1011, tv2rhosigma2, t1013, t1016, t1021, t1025, t1033;
  double t1034, tv2rhosigma3, t1036, tv2rhosigma4, t1041, t1042, t1045, t1050;
  double t1051, t1054, t1059, t1062, t1070, t1071, tv2rhosigma5, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  double t1073, t1075, t1076, t1077, t1078, t1080, t1081, t1082;
  double t1083, t1085, t1088, t1089, t1090, t1092, t1094, t1096;
  double t1100, t1101, t1108, t1109, t1112, t1115, t1119, t1120;
  double t1123, t1128, t1129, t1138, t1141, t1144, t1145, t1148;
  double t1154, t1155, t1162, t1165, t1167, t1169, t1171, t1173;
  double t1176, t1178, t1180, t1181, t1182, t1183, t1185, t1186;
  double t1189, t1191, t1193, t1194, t1196, t1197, t1199, t1201;
  double t1204, t1205, t1207, t1209, t1210, t1213, t1214, t1216;
  double t1221, t1222, t1224, t1225, t1226, t1228, t1229, t1244;
  double t1253, t1255, t1256, t1262, t1266, t1269, t1273, t1274;
  double t1276, t1284, t1285, t1287, t1288, t1289, t1291, t1292;
  double t1297, t1298, t1303, t1307, t1309, t1319, t1320, t1323;
  double t1325, t1327, t1328, t1330, t1331, t1332, t1334, t1335;
  double t1336, t1337, t1339, t1341, t1342, t1345, t1346, t1348;
  double t1349, t1350, t1352, t1354, t1355, t1357, t1358, t1360;
  double t1361, t1363, t1364, t1366, t1367, t1368, t1370, t1371;
  double t1372, t1374, t1377, t1379, t1383, t1385, t1386, tv3rho30;
  double t1389, t1390, t1392, t1394, t1395, t1396, t1404, t1409;
  double t1410, t1417, t1418, t1429, t1436, t1439, t1440, t1445;
  double t1450, t1451, t1454, t1457, t1458, t1465, t1466, t1479;
  double t1482, t1485, t1486, t1491, t1496, t1497, t1500, t1502;
  double t1504, t1506, t1508, t1510, t1517, t1520, t1521, t1523;
  double t1525, t1541, t1556, t1558, t1559, t1565, t1569, t1570;
  double t1571, t1572, t1576, t1579, t1580, t1583, t1589, t1592;
  double t1593, t1595, t1597, t1601, t1602, t1608, t1611, t1613;
  double t1616, t1632, t1636, t1637, t1641, t1643, t1647, t1658;
  double t1660, t1666, t1668, t1669, t1671, t1674, t1675, t1677;
  double t1679, t1682, t1685, t1691, t1692, t1696, t1697, tv3rho31;
  double t1699, t1704, t1706, t1707, t1709, t1711, t1717, t1724;
  double t1725, t1731, t1734, t1740, t1745, t1750, t1751, t1754;
  double t1755, t1757, t1759, t1761, t1766, t1769, t1770, t1773;
  double t1774, t1776, t1784, t1791, t1794, t1797, t1802, t1803;
  double t1806, t1819, t1824, t1829, t1832, t1835, t1840, t1841;
  double t1846, t1850, t1854, t1858, t1871, t1886, t1888, t1889;
  double t1892, t1893, t1898, t1899, t1902, t1905, t1911, t1917;
  double t1918, t1920, t1936, t1942, t1948, t1954, t1956, t1959;
  double t1960, tv3rho32, t1967, t1971, t1985, t1986, t1989, t1990;
  double t1995, t1996, t1999, t2000, t2002, t2004, t2006, t2007;
  double t2011, t2012, t2015, t2016, t2018, t2019, t2026, t2027;
  double t2036, t2039, t2042, t2050, t2051, t2058, t2061, t2068;
  double t2079, t2094, t2096, t2097, t2103, t2110, t2114, t2124;
  double t2125, t2138, t2139, t2142, t2143, tv3rho33, t2145, t2146;
  double t2149, t2150, t2151, t2154, t2155, t2157, t2160, t2161;
  double t2163, t2164, t2166, t2169, t2171, t2173, t2174, t2178;
  double t2179, t2180, t2182, t2183, t2188, t2189, t2190, t2192;
  double t2193, t2198, t2202, t2203, t2205, t2206, t2207, t2209;
  double t2212, t2213, t2218, t2222, t2223, t2225, t2226, t2227;
  double t2229, t2232, t2236, t2237, t2238, t2239, t2243, t2246;
  double t2251, t2261, t2262, t2263, tv3rho2sigma0, t2266, t2268, t2270;
  double t2272, t2274, t2275, t2277, t2278, t2279, t2281, t2282;
  double t2284, t2285, t2286, t2287, t2290, t2292, t2294, t2295;
  double t2297, tv3rho2sigma1, t2302, t2303, t2306, t2307, t2311, t2313;
  double t2314, t2316, t2319, t2321, t2323, t2324, t2328, t2332;
  double t2333, t2335, t2336, t2337, t2339, t2344, t2348, t2349;
  double t2351, t2352, t2353, t2355, t2359, t2369, t2370, tv3rho2sigma2;
  double t2374, t2375, t2377, t2380, t2381, t2383, t2386, t2389;
  double t2403, t2404, t2405, t2410, t2416, t2417, t2419, t2424;
  double t2429, t2432, t2435, t2441, t2442, t2450, t2451, t2452;
  double t2453, tv3rho2sigma3, t2458, t2460, t2461, t2462, t2465, t2466;
  double t2468, tv3rho2sigma4, t2473, t2474, t2476, t2479, t2480, t2484;
  double t2490, t2491, t2492, t2494, t2499, t2500, t2502, t2507;
  double t2511, t2514, t2515, t2516, t2518, t2523, t2524, t2526;
  double t2535, t2540, t2552, t2553, t2554, tv3rho2sigma5, t2559, t2560;
  double t2567, t2576, t2580, t2590, t2591, tv3rho2sigma6, t2596, tv3rho2sigma7;
  double t2604, t2605, t2610, t2611, t2620, t2625, t2628, t2635;
  double t2638, t2644, t2647, t2652, t2662, t2663, t2664, tv3rho2sigma8;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, tv3rhosigma26, tv3rhosigma27;
  double tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, tv3rhosigma211, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, tv3sigma39;

  double t2666, t2668, t2669, t2670, t2671, t2672, t2673, t2674;
  double t2675, t2678, t2682, t2684, t2686, t2690, t2691, t2693;
  double t2695, t2698, t2701, t2704, t2709, t2712, t2717, t2718;
  double t2722, t2724, t2728, t2730, t2734, t2737, t2739, t2743;
  double t2744, t2746, t2750, t2751, t2755, t2757, t2760, t2763;
  double t2766, t2769, t2772, t2775, t2777, t2779, t2783, t2784;
  double t2788, t2791, t2793, t2796, t2799, t2804, t2806, t2807;
  double t2813, t2819, t2823, t2833, t2850, t2851, t2857, t2862;
  double t2866, t2876, t2884, t2900, t2904, t2905, t2907, t2909;
  double t2911, t2913, t2915, t2917, t2921, t2927, t2929, t2933;
  double t2935, t2937, t2939, t2941, t2947, t2949, t2951, t2953;
  double t2955, t2960, t2962, t2965, t2968, t2978, t2981, t2983;
  double t3002, t3006, t3008, t3013, t3015, t3017, t3021, t3023;
  double t3025, t3034, t3041, t3050, t3052, t3055, t3058, t3079;
  double t3092, t3098, t3103, tv4rho40, t3107, t3110, t3112, t3113;
  double t3115, t3125, t3132, t3135, t3143, t3145, t3151, t3158;
  double t3161, t3169, t3171, t3200, t3202, t3223, t3225, t3230;
  double t3231, t3232, t3235, t3239, t3240, t3241, t3245, t3251;
  double t3255, t3256, t3257, t3262, t3265, t3266, t3267, t3269;
  double t3271, t3273, t3274, t3275, t3279, t3280, t3281, t3287;
  double t3289, t3290, t3291, t3298, t3299, t3300, t3302, t3304;
  double t3306, t3308, t3310, t3311, t3313, t3335, t3340, t3342;
  double t3343, t3344, t3350, t3354, t3355, t3356, t3361, t3364;
  double t3365, t3367, t3389, t3391, t3417, t3453, t3455, t3476;
  double t3484, t3502, t3507, t3508, t3509, t3511, t3520, t3529;
  double t3530, t3531, t3532, t3536, t3537, t3538, t3542, t3545;
  double t3546, t3547, t3548, t3551, t3552, t3554, t3556, t3559;
  double t3565, t3567, t3568, t3569, t3572, t3574, t3582, tv4rho41;
  double t3587, t3595, t3608, t3614, t3617, t3619, t3671, t3676;
  double t3686, t3726, t3734, t3752, t3779, t3781, t3783, t3785;
  double t3787, t3789, t3791, t3796, t3799, t3809, t3812, t3814;
  double t3826, t3830, t3832, t3838, t3840, t3844, t3870, t3874;
  double t3877, t3879, t3891, t3896, t3899, t3902, t3928, t3954;
  double t3960, t3962, t3968, t3970, t3974, t3976, t3982, t3989;
  double t3999, t4006, t4009, t4016, t4029, t4038, t4040, t4044;
  double t4048, t4050, t4053, t4059, t4065, t4072, tv4rho42, t4077;
  double t4080, t4082, t4091, t4101, t4105, t4106, t4108, t4110;
  double t4112, t4121, t4129, t4133, t4134, t4165, t4180, t4221;
  double t4229, t4252, t4275, t4281, t4307, t4310, t4312, t4316;
  double t4318, t4324, t4336, t4342, t4348, t4356, t4358, t4364;
  double t4380, t4385, t4406, t4419, t4426, t4436, t4440, t4445;
  double t4453, tv4rho43, t4459, t4486, t4497, t4502, t4506, t4522;
  double t4527, t4532, t4536, t4546, t4550, t4555, t4567, t4577;
  double t4581, t4583, t4584, t4586, t4588, t4590, t4592, t4594;
  double t4614, t4651, t4672, t4685, t4696, t4710, tv4rho44, t4714;
  double t4717, t4719, t4721, t4724, t4725, t4727, t4728, t4730;
  double t4732, t4733, t4762, t4765, t4766, t4767, t4768, t4770;
  double t4776, t4778, t4781, t4789, t4792, t4796, t4798, t4805;
  double t4807, t4810, t4818, t4824, t4834, t4842, t4848, t4851;
  double t4853, t4859, t4865, t4868, t4875, t4879, t4881, t4883;
  double t4888, t4891, t4893, t4894, t4897, t4900, t4905, t4907;
  double t4909, t4912, t4915, t4918, t4923, t4926, tv4rho3sigma0, t4927;
  double t4930, t4931, t4934, t4935, t4939, t4940, t4942, t4950;
  double t4952, t4954, t4956, t4957, t4959, t4961, t4962, t4965;
  double t4967, t4969, t4972, t4975, t4979, t4984, t4987, tv4rho3sigma1;
  double t4991, t4993, t4996, t4998, t4999, t5002, t5018, t5022;
  double t5024, t5031, t5032, t5034, t5037, t5042, t5044, t5051;
  double t5053, t5056, t5065, t5067, t5071, t5074, t5078, t5081;
  double t5086, t5088, t5092, t5095, t5098, t5103, t5106, tv4rho3sigma2;
  double t5108, t5111, t5116, t5118, t5123, t5126, t5129, t5133;
  double t5139, t5141, t5142, t5145, t5152, t5159, t5166, t5173;
  double t5177, t5181, t5184, t5187, t5193, t5197, t5201, t5208;
  double t5211, t5214, t5215, t5222, t5226, t5228, t5259, t5263;
  double t5264, t5265, t5278, t5295, t5300, tv4rho3sigma3, t5306, t5308;
  double t5313, t5316, t5318, t5320, t5325, t5330, t5332, t5335;
  double t5339, tv4rho3sigma4, t5341, t5348, t5351, t5354, t5360, t5365;
  double t5369, t5373, t5377, t5381, t5385, t5392, t5395, t5398;
  double t5404, t5405, t5411, t5415, t5422, t5426, t5430, t5431;
  double t5464, t5467, t5474, t5478, t5483, t5485, t5490, t5492;
  double t5495, t5502, t5504, tv4rho3sigma5, t5507, t5511, t5518, t5524;
  double t5527, t5530, t5531, t5532, t5555, t5558, t5561, t5579;
  double t5586, t5591, t5594, t5600, t5607, t5614, t5622, t5627;
  double t5628, tv4rho3sigma6, t5632, t5636, t5644, t5652, t5655, tv4rho3sigma7;
  double t5658, t5662, t5669, t5705, t5713, t5724, t5727, t5734;
  double t5740, t5747, t5755, t5762, t5766, t5771, t5778, t5786;
  double t5793, t5799, t5806, t5808, t5813, t5814, tv4rho3sigma8, t5819;
  double t5820, t5821, t5837, t5860, tv4rho3sigma9, tv4rho3sigma10, t5888, t5913;
  double t5969, t5972, t5985, tv4rho3sigma11, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23;
  double tv4rho2sigma24, tv4rho2sigma25, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, tv4rho2sigma211;
  double tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, tv4rhosigma30, tv4rhosigma31;
  double tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, tv4rhosigma39;
  double tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, tv4rhosigma319, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45;
  double tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413;
  double tv4sigma414;

  gga_c_lyp_params *params;

  assert(p->params != NULL);
  params = (gga_c_lyp_params * )(p->params);

  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = POW_1_3(t3);
  t9 = 0.1e1 / t8;
  t11 = params->d * t9 + 0.1e1;
  t12 = 0.1e1 / t11;
  t15 = exp(-params->c * t9);
  t16 = params->b * t15;
  t18 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t19 = t8 * t8;
  t21 = 0.1e1 / t19 / t4;
  t22 = t18 * t21;
  t24 = params->d * t12 + params->c;
  t25 = t24 * t9;
  t27 = 0.47e2 - 0.7e1 * t25;
  t30 = t7 * t27 / 0.72e2 - 0.2e1 / 0.3e1;
  t32 = M_CBRT3;
  t33 = t32 * t32;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t37 = t33 * t36;
  t38 = 0.1e1 / t3;
  t39 = t1 * t38;
  t40 = 0.1e1 + t39;
  t41 = t40 <= p->zeta_threshold;
  t42 = p->zeta_threshold * p->zeta_threshold;
  t43 = POW_1_3(p->zeta_threshold);
  t44 = t43 * t43;
  t45 = t44 * t42;
  t46 = t40 * t40;
  t47 = POW_1_3(t40);
  t48 = t47 * t47;
  t49 = t48 * t46;
  t50 = my_piecewise3(t41, t45, t49);
  t51 = 0.1e1 - t39;
  t52 = t51 <= p->zeta_threshold;
  t53 = t51 * t51;
  t54 = POW_1_3(t51);
  t55 = t54 * t54;
  t56 = t55 * t53;
  t57 = my_piecewise3(t52, t45, t56);
  t58 = t50 + t57;
  t62 = M_CBRT2;
  t63 = t62 * t7;
  t65 = 0.5e1 / 0.2e1 - t25 / 0.18e2;
  t66 = rho[0] * rho[0];
  t67 = POW_1_3(rho[0]);
  t68 = t67 * t67;
  t70 = 0.1e1 / t68 / t66;
  t71 = sigma[0] * t70;
  t72 = t71 * t50;
  t73 = rho[1] * rho[1];
  t74 = POW_1_3(rho[1]);
  t75 = t74 * t74;
  t77 = 0.1e1 / t75 / t73;
  t78 = sigma[2] * t77;
  t79 = t78 * t57;
  t80 = t72 + t79;
  t81 = t65 * t80;
  t84 = t25 - 0.11e2;
  t86 = t44 * t42 * p->zeta_threshold;
  t89 = my_piecewise3(t41, t86, t48 * t46 * t40);
  t93 = my_piecewise3(t52, t86, t55 * t53 * t51);
  t95 = t71 * t89 + t78 * t93;
  t96 = t84 * t95;
  t101 = my_piecewise3(t41, t42, t46);
  t102 = t101 * sigma[2];
  t103 = t77 * t57;
  t106 = my_piecewise3(t52, t42, t53);
  t107 = t106 * sigma[0];
  t108 = t70 * t50;
  t114 = -t22 * t30 - 0.3e1 / 0.2e2 * t37 * t7 * t58 + t63 * t81 / 0.32e2 + t63 * t96 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t72 + 0.2e1 / 0.3e1 * t79 - t102 * t103 / 0.4e1 - t107 * t108 / 0.4e1) / 0.8e1;
  tzk0 = params->a * (t16 * t12 * t114 - t7 * t12);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t118 = t3 * params->a;
  t119 = t1 * t5;
  t120 = t4 * t3;
  t121 = 0.1e1 / t120;
  t122 = t2 * t121;
  t124 = -0.2e1 * t119 + 0.2e1 * t122;
  t126 = t11 * t11;
  t127 = 0.1e1 / t126;
  t128 = t7 * t127;
  t130 = 0.1e1 / t8 / t3;
  t131 = params->d * t130;
  t133 = t128 * t131 / 0.3e1;
  t134 = params->b * params->c;
  t135 = t134 * t130;
  t136 = t15 * t12;
  t137 = t136 * t114;
  t139 = t135 * t137 / 0.3e1;
  t140 = t16 * t127;
  t141 = t114 * params->d;
  t144 = t140 * t141 * t130 / 0.3e1;
  t146 = 0.1e1 / t19 / t120;
  t147 = t18 * t146;
  t149 = 0.8e1 / 0.3e1 * t147 * t30;
  t151 = params->d * params->d;
  t152 = t151 * t127;
  t154 = 0.1e1 / t19 / t3;
  t157 = t24 * t130 - t152 * t154;
  t158 = 0.7e1 / 0.3e1 * t157;
  t159 = t7 * t158;
  t161 = t124 * t27 / 0.72e2 + t159 / 0.72e2;
  t166 = t48 * t40;
  t167 = t38 - t119;
  t168 = t166 * t167;
  t170 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t168);
  t171 = t55 * t51;
  t172 = -t167;
  t173 = t171 * t172;
  t175 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t173);
  t176 = t170 + t175;
  t180 = t62 * t124;
  t183 = t157 / 0.54e2;
  t184 = t183 * t80;
  t186 = t63 * t184 / 0.32e2;
  t189 = 0.1e1 / t68 / t66 / rho[0];
  t190 = sigma[0] * t189;
  t191 = t190 * t50;
  t193 = t71 * t170;
  t194 = t78 * t175;
  t195 = -0.8e1 / 0.3e1 * t191 + t193 + t194;
  t196 = t65 * t195;
  t202 = -t157 / 0.3e1;
  t203 = t202 * t95;
  t205 = t63 * t203 / 0.576e3;
  t210 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t167);
  t214 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t172);
  t216 = -0.8e1 / 0.3e1 * t190 * t89 + t71 * t210 + t78 * t214;
  t217 = t84 * t216;
  t225 = my_piecewise3(t41, 0, 0.2e1 * t40 * t167);
  t226 = t225 * sigma[2];
  t229 = t77 * t175;
  t234 = my_piecewise3(t52, 0, 0.2e1 * t51 * t172);
  t235 = t234 * sigma[0];
  t238 = t189 * t50;
  t241 = t70 * t170;
  t247 = t149 - t22 * t161 - 0.3e1 / 0.2e2 * t37 * t124 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t176 + t180 * t81 / 0.32e2 + t186 + t63 * t196 / 0.32e2 + t180 * t96 / 0.576e3 + t205 + t63 * t217 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t191 + 0.2e1 / 0.3e1 * t193 + 0.2e1 / 0.3e1 * t194 - t226 * t103 / 0.4e1 - t102 * t229 / 0.4e1 - t235 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t238 - t107 * t241 / 0.4e1) / 0.8e1;
  t250 = t16 * t12 * t247 - t124 * t12 - t133 + t139 + t144;
  tvrho0 = t118 * t250 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t253 = 0.2e1 * t119 + 0.2e1 * t122;
  t257 = t253 * t27 / 0.72e2 + t159 / 0.72e2;
  t262 = -t38 - t119;
  t263 = t166 * t262;
  t265 = my_piecewise3(t41, 0, 0.8e1 / 0.3e1 * t263);
  t266 = -t262;
  t267 = t171 * t266;
  t269 = my_piecewise3(t52, 0, 0.8e1 / 0.3e1 * t267);
  t270 = t265 + t269;
  t274 = t62 * t253;
  t277 = t71 * t265;
  t280 = 0.1e1 / t75 / t73 / rho[1];
  t281 = sigma[2] * t280;
  t282 = t281 * t57;
  t284 = t78 * t269;
  t285 = t277 - 0.8e1 / 0.3e1 * t282 + t284;
  t286 = t65 * t285;
  t293 = my_piecewise3(t41, 0, 0.11e2 / 0.3e1 * t49 * t262);
  t299 = my_piecewise3(t52, 0, 0.11e2 / 0.3e1 * t56 * t266);
  t301 = t71 * t293 - 0.8e1 / 0.3e1 * t281 * t93 + t78 * t299;
  t302 = t84 * t301;
  t310 = my_piecewise3(t41, 0, 0.2e1 * t40 * t262);
  t311 = t310 * sigma[2];
  t314 = t280 * t57;
  t317 = t77 * t269;
  t322 = my_piecewise3(t52, 0, 0.2e1 * t51 * t266);
  t323 = t322 * sigma[0];
  t326 = t70 * t265;
  t332 = t149 - t22 * t257 - 0.3e1 / 0.2e2 * t37 * t253 * t58 - 0.3e1 / 0.2e2 * t37 * t7 * t270 + t274 * t81 / 0.32e2 + t186 + t63 * t286 / 0.32e2 + t274 * t96 / 0.576e3 + t205 + t63 * t302 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t277 - 0.16e2 / 0.9e1 * t282 + 0.2e1 / 0.3e1 * t284 - t311 * t103 / 0.4e1 + 0.2e1 / 0.3e1 * t102 * t314 - t102 * t317 / 0.4e1 - t323 * t108 / 0.4e1 - t107 * t326 / 0.4e1) / 0.8e1;
  t335 = t16 * t12 * t332 - t253 * t12 - t133 + t139 + t144;
  tvrho1 = t118 * t335 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t337 = t118 * params->b;
  t338 = t21 * t30;
  t339 = t65 * t70;
  t340 = t339 * t50;
  t343 = t84 * t70;
  t344 = t343 * t89;
  t348 = t106 * t70;
  t354 = -t338 + t63 * t340 / 0.32e2 + t63 * t344 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t108 - t348 * t50 / 0.4e1) / 0.8e1;
  t355 = t136 * t354;
  tvsigma0 = t337 * t355;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t356 = t154 * params->a;
  t357 = t356 * params->b;
  t358 = t136 * t30;
  tvsigma1 = -0.2e1 * t357 * t358;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t361 = t65 * t77;
  t362 = t361 * t57;
  t365 = t84 * t77;
  t366 = t365 * t93;
  t370 = t101 * t77;
  t376 = -t338 + t63 * t362 / 0.32e2 + t63 * t366 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t103 - t370 * t57 / 0.4e1) / 0.8e1;
  t377 = t136 * t376;
  tvsigma2 = t337 * t377;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t378 = params->a * t250;
  t380 = 0.2e1 * t5;
  t381 = t1 * t121;
  t382 = 0.8e1 * t381;
  t383 = t4 * t4;
  t384 = 0.1e1 / t383;
  t386 = 0.6e1 * t2 * t384;
  t387 = -t380 + t382 - t386;
  t389 = t124 * t127;
  t390 = t389 * t131;
  t393 = 0.1e1 / t126 / t11;
  t394 = t7 * t393;
  t395 = t151 * t21;
  t397 = 0.2e1 / 0.9e1 * t394 * t395;
  t399 = 0.1e1 / t8 / t4;
  t400 = params->d * t399;
  t402 = 0.4e1 / 0.9e1 * t128 * t400;
  t403 = t134 * t399;
  t405 = 0.4e1 / 0.9e1 * t403 * t137;
  t406 = params->c * params->c;
  t407 = params->b * t406;
  t408 = t407 * t21;
  t410 = t408 * t137 / 0.9e1;
  t411 = t134 * t21;
  t412 = t15 * t127;
  t413 = t412 * t141;
  t415 = 0.2e1 / 0.9e1 * t411 * t413;
  t416 = t136 * t247;
  t417 = t135 * t416;
  t419 = t16 * t393;
  t420 = t114 * t151;
  t423 = 0.2e1 / 0.9e1 * t419 * t420 * t21;
  t424 = t247 * params->d;
  t426 = t140 * t424 * t130;
  t430 = 0.4e1 / 0.9e1 * t140 * t141 * t399;
  t432 = 0.1e1 / t19 / t383;
  t433 = t18 * t432;
  t435 = 0.88e2 / 0.9e1 * t433 * t30;
  t442 = t167 * t167;
  t443 = t48 * t442;
  t446 = -0.2e1 * t5 + 0.2e1 * t381;
  t450 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t443 + 0.8e1 / 0.3e1 * t166 * t446);
  t451 = t172 * t172;
  t452 = t55 * t451;
  t454 = -t446;
  t458 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t452 + 0.8e1 / 0.3e1 * t171 * t454);
  t459 = t450 + t458;
  t463 = t62 * t387;
  t466 = t180 * t184;
  t470 = t151 * params->d;
  t471 = t470 * t393;
  t472 = t471 * t121;
  t474 = t152 * t21;
  t476 = t24 * t399;
  t478 = -t472 / 0.81e2 + t474 / 0.27e2 - 0.2e1 / 0.81e2 * t476;
  t479 = t478 * t80;
  t481 = t63 * t479 / 0.32e2;
  t482 = t183 * t195;
  t483 = t63 * t482;
  t485 = t66 * t66;
  t487 = 0.1e1 / t68 / t485;
  t488 = sigma[0] * t487;
  t489 = t488 * t50;
  t491 = t190 * t170;
  t493 = t71 * t450;
  t494 = t78 * t458;
  t495 = 0.88e2 / 0.9e1 * t489 - 0.16e2 / 0.3e1 * t491 + t493 + t494;
  t496 = t65 * t495;
  t501 = t180 * t203;
  t508 = 0.2e1 / 0.9e1 * t472 - 0.2e1 / 0.3e1 * t474 + 0.4e1 / 0.9e1 * t476;
  t509 = t508 * t95;
  t511 = t63 * t509 / 0.576e3;
  t512 = t202 * t216;
  t513 = t63 * t512;
  t524 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t166 * t442 + 0.11e2 / 0.3e1 * t49 * t446);
  t531 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t171 * t451 + 0.11e2 / 0.3e1 * t56 * t454);
  t533 = 0.88e2 / 0.9e1 * t488 * t89 - 0.16e2 / 0.3e1 * t190 * t210 + t71 * t524 + t78 * t531;
  t534 = t84 * t533;
  t537 = t147 * t161;
  t541 = t124 * t158;
  t546 = -0.14e2 / 0.9e1 * t472 + 0.14e2 / 0.3e1 * t474 - 0.28e2 / 0.9e1 * t476;
  t547 = t7 * t546;
  t548 = t547 / 0.72e2;
  t549 = t387 * t27 / 0.72e2 + t541 / 0.36e2 + t548;
  t558 = my_piecewise3(t41, 0, 0.2e1 * t40 * t446 + 0.2e1 * t442);
  t559 = t558 * sigma[2];
  t564 = t77 * t458;
  t570 = my_piecewise3(t52, 0, 0.2e1 * t51 * t454 + 0.2e1 * t451);
  t571 = t570 * sigma[0];
  t578 = t487 * t50;
  t581 = t189 * t170;
  t584 = t70 * t450;
  t587 = 0.176e3 / 0.27e2 * t489 - 0.32e2 / 0.9e1 * t491 + 0.2e1 / 0.3e1 * t493 + 0.2e1 / 0.3e1 * t494 - t559 * t103 / 0.4e1 - t226 * t229 / 0.2e1 - t102 * t564 / 0.4e1 - t571 * t108 / 0.4e1 + 0.4e1 / 0.3e1 * t235 * t238 - t235 * t241 / 0.2e1 - 0.22e2 / 0.9e1 * t107 * t578 + 0.4e1 / 0.3e1 * t107 * t581 - t107 * t584 / 0.4e1;
  t590 = -t435 - 0.3e1 / 0.2e2 * t37 * t387 * t58 - 0.3e1 / 0.1e2 * t37 * t124 * t176 - 0.3e1 / 0.2e2 * t37 * t7 * t459 + t463 * t81 / 0.32e2 + t466 / 0.16e2 + t180 * t196 / 0.16e2 + t481 + t483 / 0.16e2 + t63 * t496 / 0.32e2 + t463 * t96 / 0.576e3 + t501 / 0.288e3 + t180 * t217 / 0.288e3 + t511 + t513 / 0.288e3 + t63 * t534 / 0.576e3 + 0.16e2 / 0.3e1 * t537 - t22 * t549 - t62 * t587 / 0.8e1;
  t593 = -t387 * t12 - 0.2e1 / 0.3e1 * t390 - t397 + t402 - t405 + t410 + t415 + 0.2e1 / 0.3e1 * t417 + t423 + 0.2e1 / 0.3e1 * t426 - t430 + t16 * t12 * t590;
  tv2rho20 = t118 * t593 + 0.2e1 * t378;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t595 = params->a * t335;
  t596 = t380 - t386;
  t598 = t253 * t127;
  t599 = t598 * t131;
  t604 = t136 * t332;
  t605 = t135 * t604;
  t607 = t332 * params->d;
  t609 = t140 * t607 * t130;
  t611 = t190 * t265;
  t613 = t48 * t262;
  t616 = t166 * t1;
  t620 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t613 * t167 + 0.16e2 / 0.3e1 * t616 * t121);
  t621 = t71 * t620;
  t623 = t281 * t175;
  t625 = t55 * t266;
  t628 = t171 * t1;
  t632 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t625 * t172 - 0.16e2 / 0.3e1 * t628 * t121);
  t633 = t78 * t632;
  t637 = t40 * t1;
  t641 = my_piecewise3(t41, 0, 0.4e1 * t637 * t121 + 0.2e1 * t167 * t262);
  t642 = t641 * sigma[2];
  t649 = t280 * t175;
  t654 = t77 * t632;
  t659 = t51 * t1;
  t663 = my_piecewise3(t52, 0, -0.4e1 * t659 * t121 + 0.2e1 * t172 * t266);
  t664 = t663 * sigma[0];
  t673 = t189 * t265;
  t676 = t70 * t620;
  t679 = -0.16e2 / 0.9e1 * t611 + 0.2e1 / 0.3e1 * t621 - 0.16e2 / 0.9e1 * t623 + 0.2e1 / 0.3e1 * t633 - t642 * t103 / 0.4e1 - t311 * t229 / 0.4e1 + 0.2e1 / 0.3e1 * t226 * t314 + 0.2e1 / 0.3e1 * t102 * t649 - t226 * t317 / 0.4e1 - t102 * t654 / 0.4e1 - t664 * t108 / 0.4e1 + 0.2e1 / 0.3e1 * t323 * t238 - t323 * t241 / 0.4e1 - t235 * t326 / 0.4e1 + 0.2e1 / 0.3e1 * t107 * t673 - t107 * t676 / 0.4e1;
  t683 = t253 * t158;
  t685 = t596 * t27 / 0.72e2 + t541 / 0.72e2 + t547 / 0.72e2 + t683 / 0.72e2;
  t687 = t147 * t257;
  t692 = -0.8e1 / 0.3e1 * t611 + t621 - 0.8e1 / 0.3e1 * t623 + t633;
  t693 = t65 * t692;
  t696 = t62 * t596;
  t699 = t274 * t203;
  t705 = t202 * t301;
  t706 = t63 * t705;
  t712 = t49 * t1;
  t716 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t263 * t167 + 0.22e2 / 0.3e1 * t712 * t121);
  t722 = t56 * t1;
  t726 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t267 * t172 - 0.22e2 / 0.3e1 * t722 * t121);
  t728 = -0.8e1 / 0.3e1 * t190 * t293 + t71 * t716 - 0.8e1 / 0.3e1 * t281 * t214 + t78 * t726;
  t729 = t84 * t728;
  t735 = -t62 * t679 / 0.8e1 - t22 * t685 + 0.8e1 / 0.3e1 * t687 + 0.8e1 / 0.3e1 * t537 - t435 + t63 * t693 / 0.32e2 + t696 * t96 / 0.576e3 + t699 / 0.576e3 + t274 * t217 / 0.576e3 + t180 * t302 / 0.576e3 + t706 / 0.576e3 + t63 * t729 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t596 * t58;
  t742 = t620 + t632;
  t748 = t274 * t184;
  t754 = t183 * t285;
  t755 = t63 * t754;
  t761 = -0.3e1 / 0.2e2 * t37 * t253 * t176 - 0.3e1 / 0.2e2 * t37 * t124 * t270 - 0.3e1 / 0.2e2 * t37 * t7 * t742 + t696 * t81 / 0.32e2 + t748 / 0.32e2 + t274 * t196 / 0.32e2 + t180 * t286 / 0.32e2 + t755 / 0.32e2 + t466 / 0.32e2 + t481 + t483 / 0.32e2 + t501 / 0.576e3 + t511 + t513 / 0.576e3;
  t762 = t735 + t761;
  t765 = -t596 * t12 - t599 / 0.3e1 - t390 / 0.3e1 - t397 + t402 - t405 + t410 + t415 + t417 / 0.3e1 + t423 + t426 / 0.3e1 - t430 + t605 / 0.3e1 + t609 / 0.3e1 + t16 * t12 * t762;
  tv2rho21 = t118 * t765 + t378 + t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t768 = -t380 - t382 - t386;
  t784 = t262 * t262;
  t785 = t48 * t784;
  t788 = 0.2e1 * t5 + 0.2e1 * t381;
  t789 = t166 * t788;
  t792 = my_piecewise3(t41, 0, 0.4e2 / 0.9e1 * t785 + 0.8e1 / 0.3e1 * t789);
  t793 = t266 * t266;
  t794 = t55 * t793;
  t796 = -t788;
  t797 = t171 * t796;
  t800 = my_piecewise3(t52, 0, 0.4e2 / 0.9e1 * t794 + 0.8e1 / 0.3e1 * t797);
  t801 = t792 + t800;
  t805 = t62 * t768;
  t810 = t71 * t792;
  t811 = t73 * t73;
  t813 = 0.1e1 / t75 / t811;
  t814 = sigma[2] * t813;
  t815 = t814 * t57;
  t817 = t281 * t269;
  t819 = t78 * t800;
  t820 = t810 + 0.88e2 / 0.9e1 * t815 - 0.16e2 / 0.3e1 * t817 + t819;
  t821 = t65 * t820;
  t833 = my_piecewise3(t41, 0, 0.88e2 / 0.9e1 * t166 * t784 + 0.11e2 / 0.3e1 * t49 * t788);
  t844 = my_piecewise3(t52, 0, 0.88e2 / 0.9e1 * t171 * t793 + 0.11e2 / 0.3e1 * t56 * t796);
  t846 = t71 * t833 + 0.88e2 / 0.9e1 * t814 * t93 - 0.16e2 / 0.3e1 * t281 * t299 + t78 * t844;
  t847 = t84 * t846;
  t853 = t768 * t27 / 0.72e2 + t683 / 0.36e2 + t548;
  t862 = my_piecewise3(t41, 0, 0.2e1 * t40 * t788 + 0.2e1 * t784);
  t863 = t862 * sigma[2];
  t870 = t813 * t57;
  t873 = t280 * t269;
  t876 = t77 * t800;
  t882 = my_piecewise3(t52, 0, 0.2e1 * t51 * t796 + 0.2e1 * t793);
  t883 = t882 * sigma[0];
  t888 = t70 * t792;
  t891 = 0.2e1 / 0.3e1 * t810 + 0.176e3 / 0.27e2 * t815 - 0.32e2 / 0.9e1 * t817 + 0.2e1 / 0.3e1 * t819 - t863 * t103 / 0.4e1 + 0.4e1 / 0.3e1 * t311 * t314 - t311 * t317 / 0.2e1 - 0.22e2 / 0.9e1 * t102 * t870 + 0.4e1 / 0.3e1 * t102 * t873 - t102 * t876 / 0.4e1 - t883 * t108 / 0.4e1 - t323 * t326 / 0.2e1 - t107 * t888 / 0.4e1;
  t894 = -t435 + t481 + t511 + 0.16e2 / 0.3e1 * t687 + t748 / 0.16e2 + t755 / 0.16e2 + t699 / 0.288e3 + t706 / 0.288e3 - 0.3e1 / 0.2e2 * t37 * t768 * t58 - 0.3e1 / 0.1e2 * t37 * t253 * t270 - 0.3e1 / 0.2e2 * t37 * t7 * t801 + t805 * t81 / 0.32e2 + t274 * t286 / 0.16e2 + t63 * t821 / 0.32e2 + t805 * t96 / 0.576e3 + t274 * t302 / 0.288e3 + t63 * t847 / 0.576e3 - t22 * t853 - t62 * t891 / 0.8e1;
  t897 = -t768 * t12 - 0.2e1 / 0.3e1 * t599 - t397 + t402 - t405 + t410 + t415 + 0.2e1 / 0.3e1 * t605 + t423 + 0.2e1 / 0.3e1 * t609 - t430 + t16 * t12 * t894;
  tv2rho22 = t118 * t897 + 0.2e1 * t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t899 = params->a * params->b;
  t900 = t899 * t355;
  t902 = t9 * params->a * params->b;
  t903 = params->c * t15;
  t904 = t12 * t354;
  t907 = t902 * t903 * t904 / 0.3e1;
  t909 = t412 * t354 * params->d;
  t911 = t902 * t909 / 0.3e1;
  t913 = 0.8e1 / 0.3e1 * t146 * t30;
  t914 = t21 * t161;
  t917 = t183 * t70;
  t918 = t917 * t50;
  t920 = t63 * t918 / 0.32e2;
  t921 = t65 * t189;
  t922 = t921 * t50;
  t925 = t339 * t170;
  t930 = t202 * t70;
  t931 = t930 * t89;
  t933 = t63 * t931 / 0.576e3;
  t934 = t84 * t189;
  t935 = t934 * t89;
  t938 = t343 * t210;
  t943 = t234 * t70;
  t946 = t106 * t189;
  t954 = t913 - t914 + t180 * t340 / 0.32e2 + t920 - t63 * t922 / 0.12e2 + t63 * t925 / 0.32e2 + t180 * t344 / 0.576e3 + t933 - t63 * t935 / 0.216e3 + t63 * t938 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t238 + 0.2e1 / 0.3e1 * t241 - t943 * t50 / 0.4e1 + 0.2e1 / 0.3e1 * t946 * t50 - t348 * t170 / 0.4e1) / 0.8e1;
  t955 = t136 * t954;
  tv2rhosigma0 = t337 * t955 + t900 + t907 + t911;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t958 = t21 * params->a * params->b;
  t960 = 0.1e2 / 0.3e1 * t958 * t358;
  t961 = t121 * params->a;
  t962 = t961 * params->b;
  t963 = t12 * t30;
  t964 = t903 * t963;
  t966 = 0.2e1 / 0.3e1 * t962 * t964;
  t968 = t412 * t30 * params->d;
  t970 = 0.2e1 / 0.3e1 * t962 * t968;
  t971 = t136 * t161;
  tv2rhosigma1 = -0.2e1 * t357 * t971 + t960 - t966 - t970;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t974 = t899 * t377;
  t975 = t12 * t376;
  t978 = t902 * t903 * t975 / 0.3e1;
  t980 = t412 * t376 * params->d;
  t982 = t902 * t980 / 0.3e1;
  t985 = t183 * t77;
  t986 = t985 * t57;
  t988 = t63 * t986 / 0.32e2;
  t989 = t361 * t175;
  t994 = t202 * t77;
  t995 = t994 * t93;
  t997 = t63 * t995 / 0.576e3;
  t998 = t365 * t214;
  t1002 = t225 * t77;
  t1010 = t913 - t914 + t180 * t362 / 0.32e2 + t988 + t63 * t989 / 0.32e2 + t180 * t366 / 0.576e3 + t997 + t63 * t998 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t229 - t1002 * t57 / 0.4e1 - t370 * t175 / 0.4e1) / 0.8e1;
  t1011 = t136 * t1010;
  tv2rhosigma2 = t337 * t1011 + t974 + t978 + t982;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1013 = t21 * t257;
  t1016 = t339 * t265;
  t1021 = t343 * t293;
  t1025 = t322 * t70;
  t1033 = t913 - t1013 + t274 * t340 / 0.32e2 + t920 + t63 * t1016 / 0.32e2 + t274 * t344 / 0.576e3 + t933 + t63 * t1021 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t326 - t1025 * t50 / 0.4e1 - t348 * t265 / 0.4e1) / 0.8e1;
  t1034 = t136 * t1033;
  tv2rhosigma3 = t337 * t1034 + t900 + t907 + t911;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  t1036 = t136 * t257;
  tv2rhosigma4 = -0.2e1 * t357 * t1036 + t960 - t966 - t970;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t1041 = t65 * t280;
  t1042 = t1041 * t57;
  t1045 = t361 * t269;
  t1050 = t84 * t280;
  t1051 = t1050 * t93;
  t1054 = t365 * t299;
  t1059 = t310 * t77;
  t1062 = t101 * t280;
  t1070 = t913 - t1013 + t274 * t362 / 0.32e2 + t988 - t63 * t1042 / 0.12e2 + t63 * t1045 / 0.32e2 + t274 * t366 / 0.576e3 + t997 - t63 * t1051 / 0.216e3 + t63 * t1054 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t314 + 0.2e1 / 0.3e1 * t317 - t1059 * t57 / 0.4e1 + 0.2e1 / 0.3e1 * t1062 * t57 - t370 * t269 / 0.4e1) / 0.8e1;
  t1071 = t136 * t1070;
  tv2rhosigma5 = t337 * t1071 + t974 + t978 + t982;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2sigma20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t1073 = params->a * t593;
  t1075 = t387 * t127;
  t1076 = t1075 * t131;
  t1077 = t124 * t393;
  t1078 = t1077 * t395;
  t1080 = t126 * t126;
  t1081 = 0.1e1 / t1080;
  t1082 = t7 * t1081;
  t1083 = t470 * t384;
  t1085 = 0.2e1 / 0.9e1 * t1082 * t1083;
  t1088 = 0.1e1 / t68 / t485 / rho[0];
  t1089 = sigma[0] * t1088;
  t1090 = t1089 * t50;
  t1092 = t167 * t446;
  t1094 = t1 * t384;
  t1096 = 0.6e1 * t121 - 0.6e1 * t1094;
  t1100 = my_piecewise3(t41, 0, 0.2e1 * t40 * t1096 + 0.6e1 * t1092);
  t1101 = t1100 * sigma[2];
  t1108 = 0.1e1 / t54;
  t1109 = t451 * t172;
  t1112 = t55 * t172;
  t1115 = -t1096;
  t1119 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t1108 * t1109 + 0.4e2 / 0.3e1 * t1112 * t454 + 0.8e1 / 0.3e1 * t171 * t1115);
  t1120 = t77 * t1119;
  t1123 = t172 * t454;
  t1128 = my_piecewise3(t52, 0, 0.2e1 * t51 * t1115 + 0.6e1 * t1123);
  t1129 = t1128 * sigma[0];
  t1138 = t487 * t170;
  t1141 = t189 * t450;
  t1144 = 0.1e1 / t47;
  t1145 = t442 * t167;
  t1148 = t48 * t167;
  t1154 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1144 * t1145 + 0.4e2 / 0.3e1 * t1148 * t446 + 0.8e1 / 0.3e1 * t166 * t1096);
  t1155 = t70 * t1154;
  t1162 = t1088 * t50;
  t1165 = t488 * t170;
  t1167 = t190 * t450;
  t1169 = t71 * t1154;
  t1171 = t78 * t1119;
  t1173 = -0.2464e4 / 0.81e2 * t1090 - t1101 * t103 / 0.4e1 - 0.3e1 / 0.4e1 * t559 * t229 - 0.3e1 / 0.4e1 * t226 * t564 - t102 * t1120 / 0.4e1 - t1129 * t108 / 0.4e1 - 0.3e1 / 0.4e1 * t571 * t241 + 0.4e1 * t235 * t581 - 0.3e1 / 0.4e1 * t235 * t584 - 0.22e2 / 0.3e1 * t107 * t1138 + 0.2e1 * t107 * t1141 - t107 * t1155 / 0.4e1 + 0.2e1 * t571 * t238 - 0.22e2 / 0.3e1 * t235 * t578 + 0.308e3 / 0.27e2 * t107 * t1162 + 0.176e3 / 0.9e1 * t1165 - 0.16e2 / 0.3e1 * t1167 + 0.2e1 / 0.3e1 * t1169 + 0.2e1 / 0.3e1 * t1171;
  t1176 = t433 * t161;
  t1178 = t147 * t549;
  t1180 = 0.12e2 * t121;
  t1181 = 0.36e2 * t1094;
  t1182 = t383 * t3;
  t1183 = 0.1e1 / t1182;
  t1185 = 0.24e2 * t2 * t1183;
  t1186 = t1180 - t1181 + t1185;
  t1189 = t387 * t158;
  t1191 = t124 * t546;
  t1193 = t151 * t151;
  t1194 = t1193 * t1081;
  t1196 = 0.1e1 / t8 / t383;
  t1197 = t1194 * t1196;
  t1199 = t471 * t384;
  t1201 = t152 * t146;
  t1204 = 0.1e1 / t8 / t120;
  t1205 = t24 * t1204;
  t1207 = -0.14e2 / 0.9e1 * t1197 + 0.7e2 / 0.9e1 * t1199 - 0.364e3 / 0.27e2 * t1201 + 0.196e3 / 0.27e2 * t1205;
  t1209 = t7 * t1207 / 0.72e2;
  t1210 = t1186 * t27 / 0.72e2 + t1189 / 0.24e2 + t1191 / 0.24e2 + t1209;
  t1213 = 0.1e1 / t19 / t1182;
  t1214 = t18 * t1213;
  t1216 = 0.1232e4 / 0.27e2 * t1214 * t30;
  t1221 = 0.2e1 / 0.9e1 * t1197 - 0.1e2 / 0.9e1 * t1199 + 0.52e2 / 0.27e2 * t1201 - 0.28e2 / 0.27e2 * t1205;
  t1222 = t1221 * t95;
  t1224 = t63 * t1222 / 0.576e3;
  t1225 = t508 * t216;
  t1226 = t63 * t1225;
  t1228 = t202 * t533;
  t1229 = t63 * t1228;
  t1244 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t48 * t1145 + 0.88e2 / 0.3e1 * t168 * t446 + 0.11e2 / 0.3e1 * t49 * t1096);
  t1253 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t55 * t1109 + 0.88e2 / 0.3e1 * t173 * t454 + 0.11e2 / 0.3e1 * t56 * t1115);
  t1255 = -0.1232e4 / 0.27e2 * t1089 * t89 + 0.88e2 / 0.3e1 * t488 * t210 - 0.8e1 * t190 * t524 + t71 * t1244 + t78 * t1253;
  t1256 = t84 * t1255;
  t1262 = t1154 + t1119;
  t1266 = t62 * t1186;
  t1269 = t463 * t184;
  t1273 = -t62 * t1173 / 0.8e1 - 0.88e2 / 0.3e1 * t1176 + 0.8e1 * t1178 - t22 * t1210 + t1216 + t1224 + t1226 / 0.192e3 + t1229 / 0.192e3 + t63 * t1256 / 0.576e3 - 0.9e1 / 0.2e2 * t37 * t124 * t459 - 0.3e1 / 0.2e2 * t37 * t7 * t1262 + t1266 * t81 / 0.32e2 + 0.3e1 / 0.32e2 * t1269 + 0.3e1 / 0.32e2 * t463 * t196;
  t1274 = t180 * t479;
  t1276 = t180 * t482;
  t1284 = -t1197 / 0.81e2 + 0.5e1 / 0.81e2 * t1199 - 0.26e2 / 0.243e3 * t1201 + 0.14e2 / 0.243e3 * t1205;
  t1285 = t1284 * t80;
  t1287 = t63 * t1285 / 0.32e2;
  t1288 = t478 * t195;
  t1289 = t63 * t1288;
  t1291 = t183 * t495;
  t1292 = t63 * t1291;
  t1297 = -0.1232e4 / 0.27e2 * t1090 + 0.88e2 / 0.3e1 * t1165 - 0.8e1 * t1167 + t1169 + t1171;
  t1298 = t65 * t1297;
  t1303 = t463 * t203;
  t1307 = t180 * t509;
  t1309 = t180 * t512;
  t1319 = 0.3e1 / 0.32e2 * t1274 + 0.3e1 / 0.16e2 * t1276 + 0.3e1 / 0.32e2 * t180 * t496 + t1287 + 0.3e1 / 0.32e2 * t1289 + 0.3e1 / 0.32e2 * t1292 + t63 * t1298 / 0.32e2 + t1266 * t96 / 0.576e3 + t1303 / 0.192e3 + t463 * t217 / 0.192e3 + t1307 / 0.192e3 + t1309 / 0.96e2 + t180 * t534 / 0.192e3 - 0.3e1 / 0.2e2 * t37 * t1186 * t58 - 0.9e1 / 0.2e2 * t37 * t387 * t176;
  t1320 = t1273 + t1319;
  t1323 = t403 * t416;
  t1325 = t407 * t146;
  t1327 = 0.4e1 / 0.9e1 * t1325 * t137;
  t1328 = t408 * t416;
  t1330 = t406 * params->c;
  t1331 = params->b * t1330;
  t1332 = t1331 * t384;
  t1334 = t1332 * t137 / 0.27e2;
  t1335 = t136 * t590;
  t1336 = t135 * t1335;
  t1337 = t247 * t151;
  t1339 = t419 * t1337 * t21;
  t1341 = t16 * t1081;
  t1342 = t114 * t470;
  t1345 = 0.2e1 / 0.9e1 * t1341 * t1342 * t384;
  t1346 = t590 * params->d;
  t1348 = t140 * t1346 * t130;
  t1349 = -t1076 - 0.2e1 / 0.3e1 * t1078 - t1085 + t16 * t12 * t1320 - 0.4e1 / 0.3e1 * t1323 - t1327 + t1328 / 0.3e1 + t1334 + t1336 + 0.2e1 / 0.3e1 * t1339 + t1345 + t1348;
  t1350 = t389 * t400;
  t1352 = t151 * t146;
  t1354 = 0.8e1 / 0.9e1 * t394 * t1352;
  t1355 = params->d * t1204;
  t1357 = 0.28e2 / 0.27e2 * t128 * t1355;
  t1358 = t134 * t1204;
  t1360 = 0.28e2 / 0.27e2 * t1358 * t137;
  t1361 = t134 * t146;
  t1363 = 0.8e1 / 0.9e1 * t1361 * t413;
  t1364 = t407 * t384;
  t1366 = t1364 * t413 / 0.9e1;
  t1367 = t412 * t424;
  t1368 = t411 * t1367;
  t1370 = t134 * t384;
  t1371 = t15 * t393;
  t1372 = t1371 * t420;
  t1374 = 0.2e1 / 0.9e1 * t1370 * t1372;
  t1377 = 0.8e1 / 0.9e1 * t419 * t420 * t146;
  t1379 = t140 * t424 * t399;
  t1383 = 0.28e2 / 0.27e2 * t140 * t141 * t1204;
  t1385 = 0.4e1 / 0.3e1 * t1350 + t1354 - t1357 + t1360 - t1363 + t1366 + 0.2e1 / 0.3e1 * t1368 + t1374 - t1377 - 0.4e1 / 0.3e1 * t1379 + t1383 - t1186 * t12;
  t1386 = t1349 + t1385;
  tv3rho30 = t118 * t1386 + 0.3e1 * t1073;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1389 = 0.2e1 * params->a * t765;
  t1390 = t598 * t400;
  t1392 = t596 * t127;
  t1394 = 0.2e1 / 0.3e1 * t1392 * t131;
  t1395 = t253 * t393;
  t1396 = t1395 * t395;
  t1404 = t487 * t265;
  t1409 = t167 * t1;
  t1410 = t1409 * t121;
  t1417 = my_piecewise3(t41, 0, 0.4e1 * t40 * t121 + 0.2e1 * t446 * t262 - 0.12e2 * t637 * t384 + 0.8e1 * t1410);
  t1418 = t1417 * sigma[2];
  t1429 = t280 * t458;
  t1436 = t1108 * t266;
  t1439 = t55 * t1;
  t1440 = t172 * t121;
  t1445 = t171 * t121;
  t1450 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t1436 * t451 - 0.16e3 / 0.9e1 * t1439 * t1440 + 0.4e2 / 0.9e1 * t625 * t454 - 0.16e2 / 0.3e1 * t1445 + 0.16e2 * t628 * t384);
  t1451 = t77 * t1450;
  t1454 = 0.4e1 / 0.3e1 * t664 * t238 - 0.22e2 / 0.9e1 * t323 * t578 + 0.4e1 / 0.3e1 * t235 * t673 - 0.22e2 / 0.9e1 * t107 * t1404 - t1418 * t103 / 0.4e1 - t642 * t229 / 0.2e1 - t311 * t564 / 0.4e1 + 0.2e1 / 0.3e1 * t559 * t314 + 0.4e1 / 0.3e1 * t226 * t649 + 0.2e1 / 0.3e1 * t102 * t1429 - t559 * t317 / 0.4e1 - t226 * t654 / 0.2e1 - t102 * t1451 / 0.4e1;
  t1457 = t172 * t1;
  t1458 = t1457 * t121;
  t1465 = my_piecewise3(t52, 0, -0.4e1 * t51 * t121 + 0.2e1 * t454 * t266 + 0.12e2 * t659 * t384 - 0.8e1 * t1458);
  t1466 = t1465 * sigma[0];
  t1479 = t189 * t620;
  t1482 = t1144 * t262;
  t1485 = t48 * t1;
  t1486 = t167 * t121;
  t1491 = t166 * t121;
  t1496 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1482 * t442 + 0.16e3 / 0.9e1 * t1485 * t1486 + 0.4e2 / 0.9e1 * t613 * t446 + 0.16e2 / 0.3e1 * t1491 - 0.16e2 * t616 * t384);
  t1497 = t70 * t1496;
  t1500 = t78 * t1450;
  t1502 = t488 * t265;
  t1504 = t190 * t620;
  t1506 = t71 * t1496;
  t1508 = t281 * t458;
  t1510 = -t1466 * t108 / 0.4e1 - t664 * t241 / 0.2e1 + 0.4e1 / 0.3e1 * t323 * t581 - t323 * t584 / 0.4e1 - t571 * t326 / 0.4e1 - t235 * t676 / 0.2e1 + 0.4e1 / 0.3e1 * t107 * t1479 - t107 * t1497 / 0.4e1 + 0.2e1 / 0.3e1 * t1500 + 0.176e3 / 0.27e2 * t1502 - 0.32e2 / 0.9e1 * t1504 + 0.2e1 / 0.3e1 * t1506 - 0.16e2 / 0.9e1 * t1508;
  t1517 = t180 * t705 / 0.288e3;
  t1520 = t508 * t301;
  t1521 = t63 * t1520;
  t1523 = t202 * t728;
  t1525 = t63 * t1523 / 0.288e3;
  t1541 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t613 * t442 + 0.352e3 / 0.9e1 * t616 * t1486 + 0.88e2 / 0.9e1 * t263 * t446 + 0.22e2 / 0.3e1 * t49 * t121 - 0.22e2 * t712 * t384);
  t1556 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t625 * t451 - 0.352e3 / 0.9e1 * t628 * t1440 + 0.88e2 / 0.9e1 * t267 * t454 - 0.22e2 / 0.3e1 * t56 * t121 + 0.22e2 * t722 * t384);
  t1558 = 0.88e2 / 0.9e1 * t488 * t293 - 0.16e2 / 0.3e1 * t190 * t716 + t71 * t1541 - 0.8e1 / 0.3e1 * t281 * t531 + t78 * t1556;
  t1559 = t84 * t1558;
  t1565 = t1496 + t1450;
  t1569 = 0.4e1 * t121;
  t1570 = 0.12e2 * t1094;
  t1571 = -t1569 - t1570 + t1185;
  t1572 = t62 * t1571;
  t1576 = t696 * t184 / 0.16e2;
  t1579 = -t62 * (t1454 + t1510) / 0.8e1 + t463 * t302 / 0.576e3 + t1517 + t180 * t729 / 0.288e3 + t1521 / 0.576e3 + t1525 + t63 * t1559 / 0.576e3 - 0.3e1 / 0.1e2 * t37 * t124 * t742 - 0.3e1 / 0.2e2 * t37 * t7 * t1565 + t1572 * t81 / 0.32e2 + t1576 + t696 * t196 / 0.16e2;
  t1580 = t274 * t479;
  t1583 = t274 * t482 / 0.16e2;
  t1589 = t180 * t754 / 0.16e2;
  t1592 = t478 * t285;
  t1593 = t63 * t1592;
  t1595 = t183 * t692;
  t1597 = t63 * t1595 / 0.16e2;
  t1601 = 0.88e2 / 0.9e1 * t1502 - 0.16e2 / 0.3e1 * t1504 + t1506 - 0.8e1 / 0.3e1 * t1508 + t1500;
  t1602 = t65 * t1601;
  t1608 = t696 * t203 / 0.288e3;
  t1611 = t1580 / 0.32e2 + t1583 + t274 * t496 / 0.32e2 + t463 * t286 / 0.32e2 + t1589 + t180 * t693 / 0.16e2 + t1593 / 0.32e2 + t1597 + t63 * t1602 / 0.32e2 + t1572 * t96 / 0.576e3 + t1608 + t696 * t217 / 0.288e3;
  t1613 = t274 * t509;
  t1616 = t274 * t512 / 0.288e3;
  t1632 = 0.16e2 / 0.3e1 * t147 * t685;
  t1636 = t596 * t158 / 0.36e2;
  t1637 = t253 * t546;
  t1641 = t1571 * t27 / 0.72e2 + t1636 + t1637 / 0.72e2 + t1189 / 0.72e2 + t1191 / 0.36e2 + t1209;
  t1643 = t433 * t257;
  t1647 = t1613 / 0.576e3 + t1616 + t274 * t534 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t253 * t459 - 0.3e1 / 0.2e2 * t37 * t387 * t270 - 0.3e1 / 0.2e2 * t37 * t1571 * t58 - 0.3e1 / 0.1e2 * t37 * t596 * t176 + t1632 - t22 * t1641 - 0.88e2 / 0.9e1 * t1643 - 0.176e3 / 0.9e1 * t1176 + 0.8e1 / 0.3e1 * t1178;
  t1658 = t1216 + t1224 + t1226 / 0.288e3 + t1229 / 0.576e3 + t1269 / 0.32e2 + t1274 / 0.16e2 + t1276 / 0.16e2 + t1287 + t1289 / 0.16e2 + t1292 / 0.32e2 + t1303 / 0.576e3 + t1307 / 0.288e3 + t1309 / 0.288e3;
  t1660 = t1579 + t1611 + t1647 + t1658;
  t1666 = t136 * t762;
  t1668 = 0.2e1 / 0.3e1 * t135 * t1666;
  t1669 = t408 * t604;
  t1671 = t762 * params->d;
  t1674 = 0.2e1 / 0.3e1 * t140 * t1671 * t130;
  t1675 = t332 * t151;
  t1677 = t419 * t1675 * t21;
  t1679 = t403 * t604;
  t1682 = t140 * t607 * t399;
  t1685 = 0.4e1 / 0.9e1 * t1390 - t1394 - 0.2e1 / 0.9e1 * t1396 + t16 * t12 * t1660 + 0.8e1 / 0.9e1 * t1350 + t1354 - t1357 - t1076 / 0.3e1 - 0.4e1 / 0.9e1 * t1078 - t1085 + t1668 + t1669 / 0.9e1 + t1674 + 0.2e1 / 0.9e1 * t1677 - 0.4e1 / 0.9e1 * t1679 - 0.4e1 / 0.9e1 * t1682 - 0.8e1 / 0.9e1 * t1323;
  t1691 = t412 * t607;
  t1692 = t411 * t1691;
  t1696 = -t1327 + 0.2e1 / 0.9e1 * t1328 + t1334 + t1336 / 0.3e1 + 0.4e1 / 0.9e1 * t1339 + t1345 + t1348 / 0.3e1 + t1360 - t1377 - 0.8e1 / 0.9e1 * t1379 + t1383 + 0.2e1 / 0.9e1 * t1692 - t1363 + t1366 + 0.4e1 / 0.9e1 * t1368 + t1374 - t1571 * t12;
  t1697 = t1685 + t1696;
  tv3rho31 = t118 * t1697 + t1073 + t1389;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1699 = params->a * t897;
  t1704 = -t1569 + t1570 + t1185;
  t1706 = t136 * t894;
  t1707 = t135 * t1706;
  t1709 = t894 * params->d;
  t1711 = t140 * t1709 * t130;
  t1717 = 0.8e1 / 0.9e1 * t1390 - t1394 - 0.4e1 / 0.9e1 * t1396 + 0.4e1 / 0.9e1 * t1350 + t1354 - t1357 - 0.2e1 / 0.9e1 * t1078 - t1085 - t1704 * t12 + t1707 / 0.3e1 + t1711 / 0.3e1 + t1668 + 0.2e1 / 0.9e1 * t1669 + t1674 + 0.4e1 / 0.9e1 * t1677 - 0.8e1 / 0.9e1 * t1679 - 0.8e1 / 0.9e1 * t1682;
  t1724 = t768 * t127;
  t1725 = t1724 * t131;
  t1731 = t1517 + t1521 / 0.288e3 + t1525 + t1576 + t1580 / 0.16e2 + t1583 + t1589 + t1593 / 0.16e2 + t1597 + t1608 + t1613 / 0.288e3 + t1616;
  t1734 = t147 * t853;
  t1740 = t1144 * t784;
  t1745 = t48 * t788;
  t1750 = -0.2e1 * t121 - 0.6e1 * t1094;
  t1751 = t166 * t1750;
  t1754 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1740 * t167 + 0.16e3 / 0.9e1 * t613 * t381 + 0.4e2 / 0.9e1 * t1745 * t167 + 0.8e1 / 0.3e1 * t1751);
  t1755 = t71 * t1754;
  t1757 = t814 * t175;
  t1759 = t281 * t632;
  t1761 = t1108 * t793;
  t1766 = t55 * t796;
  t1769 = -t1750;
  t1770 = t171 * t1769;
  t1773 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t1761 * t172 - 0.16e3 / 0.9e1 * t625 * t381 + 0.4e2 / 0.9e1 * t1766 * t172 + 0.8e1 / 0.3e1 * t1770);
  t1774 = t78 * t1773;
  t1776 = t190 * t792;
  t1784 = t70 * t1754;
  t1791 = t189 * t792;
  t1794 = t262 * t1;
  t1797 = t167 * t788;
  t1802 = my_piecewise3(t41, 0, 0.8e1 * t1794 * t121 + 0.2e1 * t40 * t1750 + 0.2e1 * t1797);
  t1803 = t1802 * sigma[2];
  t1806 = 0.2e1 / 0.3e1 * t1755 + 0.176e3 / 0.27e2 * t1757 - 0.32e2 / 0.9e1 * t1759 + 0.2e1 / 0.3e1 * t1774 - 0.16e2 / 0.9e1 * t1776 - t664 * t326 / 0.2e1 - t323 * t676 / 0.2e1 - t235 * t888 / 0.4e1 - t107 * t1784 / 0.4e1 + 0.2e1 / 0.3e1 * t883 * t238 + 0.4e1 / 0.3e1 * t323 * t673 + 0.2e1 / 0.3e1 * t107 * t1791 - t1803 * t103 / 0.4e1;
  t1819 = t813 * t175;
  t1824 = t280 * t632;
  t1829 = t77 * t1773;
  t1832 = t266 * t1;
  t1835 = t172 * t796;
  t1840 = my_piecewise3(t52, 0, -0.8e1 * t1832 * t121 + 0.2e1 * t51 * t1769 + 0.2e1 * t1835);
  t1841 = t1840 * sigma[0];
  t1846 = -t863 * t229 / 0.4e1 + 0.4e1 / 0.3e1 * t642 * t314 + 0.4e1 / 0.3e1 * t311 * t649 - t642 * t317 / 0.2e1 - t311 * t654 / 0.2e1 - 0.22e2 / 0.9e1 * t226 * t870 - 0.22e2 / 0.9e1 * t102 * t1819 + 0.4e1 / 0.3e1 * t226 * t873 + 0.4e1 / 0.3e1 * t102 * t1824 - t226 * t876 / 0.4e1 - t102 * t1829 / 0.4e1 - t1841 * t108 / 0.4e1 - t883 * t241 / 0.4e1;
  t1850 = t1632 - 0.176e3 / 0.9e1 * t1643 - 0.88e2 / 0.9e1 * t1176 + 0.8e1 / 0.3e1 * t1734 + t1216 + t1224 + t1226 / 0.576e3 + t1274 / 0.32e2 + t1287 + t1289 / 0.32e2 + t1307 / 0.576e3 - t62 * (t1806 + t1846) / 0.8e1;
  t1854 = t768 * t158;
  t1858 = t1704 * t27 / 0.72e2 + t1854 / 0.72e2 + t1636 + t1637 / 0.36e2 + t1191 / 0.72e2 + t1209;
  t1871 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t785 * t167 + 0.352e3 / 0.9e1 * t263 * t381 + 0.88e2 / 0.9e1 * t789 * t167 + 0.11e2 / 0.3e1 * t49 * t1750);
  t1886 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t794 * t172 - 0.352e3 / 0.9e1 * t267 * t381 + 0.88e2 / 0.9e1 * t797 * t172 + 0.11e2 / 0.3e1 * t56 * t1769);
  t1888 = -0.8e1 / 0.3e1 * t190 * t833 + t71 * t1871 + 0.88e2 / 0.9e1 * t814 * t214 - 0.16e2 / 0.3e1 * t281 * t726 + t78 * t1886;
  t1889 = t84 * t1888;
  t1892 = t183 * t820;
  t1893 = t63 * t1892;
  t1898 = -0.8e1 / 0.3e1 * t1776 + t1755 + 0.88e2 / 0.9e1 * t1757 - 0.16e2 / 0.3e1 * t1759 + t1774;
  t1899 = t65 * t1898;
  t1902 = t62 * t1704;
  t1905 = t805 * t203;
  t1911 = t274 * t705;
  t1917 = t202 * t846;
  t1918 = t63 * t1917;
  t1920 = -t22 * t1858 + t63 * t1889 / 0.576e3 + t1893 / 0.32e2 + t63 * t1899 / 0.32e2 + t1902 * t96 / 0.576e3 + t1905 / 0.576e3 + t805 * t217 / 0.576e3 + t696 * t302 / 0.288e3 + t1911 / 0.288e3 + t274 * t729 / 0.288e3 + t180 * t847 / 0.576e3 + t1918 / 0.576e3;
  t1936 = t1754 + t1773;
  t1942 = t805 * t184;
  t1948 = t274 * t754;
  t1954 = -0.3e1 / 0.2e2 * t37 * t1704 * t58 - 0.3e1 / 0.2e2 * t37 * t768 * t176 - 0.3e1 / 0.1e2 * t37 * t596 * t270 - 0.3e1 / 0.1e2 * t37 * t253 * t742 - 0.3e1 / 0.2e2 * t37 * t124 * t801 - 0.3e1 / 0.2e2 * t37 * t7 * t1936 + t1902 * t81 / 0.32e2 + t1942 / 0.32e2 + t805 * t196 / 0.32e2 + t696 * t286 / 0.16e2 + t1948 / 0.16e2 + t274 * t693 / 0.16e2 + t180 * t821 / 0.32e2;
  t1956 = t1731 + t1850 + t1920 + t1954;
  t1959 = -0.4e1 / 0.9e1 * t1323 - t1327 + t1328 / 0.9e1 + t1334 + 0.2e1 / 0.9e1 * t1339 + t1345 + t1360 - t1377 - 0.4e1 / 0.9e1 * t1379 + t1383 + 0.4e1 / 0.9e1 * t1692 - t1363 + t1366 + 0.2e1 / 0.9e1 * t1368 + t1374 - t1725 / 0.3e1 + t16 * t12 * t1956;
  t1960 = t1717 + t1959;
  tv3rho32 = t118 * t1960 + t1389 + t1699;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1967 = -t1085 - 0.2e1 / 0.3e1 * t1396 - t1327 + t1334 + t1345 + t1669 / 0.3e1 + 0.2e1 / 0.3e1 * t1677 + t1707 + t1711 + t1354 - t1357 + 0.4e1 / 0.3e1 * t1390;
  t1971 = t1180 + t1181 + t1185;
  t1985 = 0.1e1 / t75 / t811 / rho[1];
  t1986 = t1985 * t57;
  t1989 = t784 * t262;
  t1990 = t1144 * t1989;
  t1995 = -0.6e1 * t121 - 0.6e1 * t1094;
  t1996 = t166 * t1995;
  t1999 = my_piecewise3(t41, 0, 0.8e2 / 0.27e2 * t1990 + 0.4e2 / 0.3e1 * t613 * t788 + 0.8e1 / 0.3e1 * t1996);
  t2000 = t71 * t1999;
  t2002 = t814 * t269;
  t2004 = t281 * t800;
  t2006 = t793 * t266;
  t2007 = t1108 * t2006;
  t2011 = -t1995;
  t2012 = t171 * t2011;
  t2015 = my_piecewise3(t52, 0, 0.8e2 / 0.27e2 * t2007 + 0.4e2 / 0.3e1 * t625 * t796 + 0.8e1 / 0.3e1 * t2012);
  t2016 = t78 * t2015;
  t2018 = sigma[2] * t1985;
  t2019 = t2018 * t57;
  t2026 = my_piecewise3(t41, 0, 0.2e1 * t40 * t1995 + 0.6e1 * t262 * t788);
  t2027 = t2026 * sigma[2];
  t2036 = t813 * t269;
  t2039 = t280 * t800;
  t2042 = t77 * t2015;
  t2050 = my_piecewise3(t52, 0, 0.2e1 * t51 * t2011 + 0.6e1 * t266 * t796);
  t2051 = t2050 * sigma[0];
  t2058 = t70 * t1999;
  t2061 = 0.2e1 * t863 * t314 - 0.22e2 / 0.3e1 * t311 * t870 + 0.308e3 / 0.27e2 * t102 * t1986 + 0.2e1 / 0.3e1 * t2000 + 0.176e3 / 0.9e1 * t2002 - 0.16e2 / 0.3e1 * t2004 + 0.2e1 / 0.3e1 * t2016 - 0.2464e4 / 0.81e2 * t2019 - t2027 * t103 / 0.4e1 - 0.3e1 / 0.4e1 * t863 * t317 + 0.4e1 * t311 * t873 - 0.3e1 / 0.4e1 * t311 * t876 - 0.22e2 / 0.3e1 * t102 * t2036 + 0.2e1 * t102 * t2039 - t102 * t2042 / 0.4e1 - t2051 * t108 / 0.4e1 - 0.3e1 / 0.4e1 * t883 * t326 - 0.3e1 / 0.4e1 * t323 * t888 - t107 * t2058 / 0.4e1;
  t2068 = t1971 * t27 / 0.72e2 + t1854 / 0.24e2 + t1637 / 0.24e2 + t1209;
  t2079 = my_piecewise3(t41, 0, 0.44e3 / 0.27e2 * t48 * t1989 + 0.88e2 / 0.3e1 * t263 * t788 + 0.11e2 / 0.3e1 * t49 * t1995);
  t2094 = my_piecewise3(t52, 0, 0.44e3 / 0.27e2 * t55 * t2006 + 0.88e2 / 0.3e1 * t267 * t796 + 0.11e2 / 0.3e1 * t56 * t2011);
  t2096 = t71 * t2079 - 0.1232e4 / 0.27e2 * t2018 * t93 + 0.88e2 / 0.3e1 * t814 * t299 - 0.8e1 * t281 * t844 + t78 * t2094;
  t2097 = t84 * t2096;
  t2103 = t1521 / 0.192e3 + 0.3e1 / 0.32e2 * t1580 + 0.3e1 / 0.32e2 * t1593 + t1613 / 0.192e3 - 0.88e2 / 0.3e1 * t1643 + 0.8e1 * t1734 + t1216 + t1224 + t1287 - t62 * t2061 / 0.8e1 - t22 * t2068 + t274 * t847 / 0.192e3 + t63 * t2097 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t1971 * t58;
  t2110 = t1999 + t2015;
  t2114 = t62 * t1971;
  t2124 = t2000 - 0.1232e4 / 0.27e2 * t2019 + 0.88e2 / 0.3e1 * t2002 - 0.8e1 * t2004 + t2016;
  t2125 = t65 * t2124;
  t2138 = -0.9e1 / 0.2e2 * t37 * t768 * t270 - 0.9e1 / 0.2e2 * t37 * t253 * t801 - 0.3e1 / 0.2e2 * t37 * t7 * t2110 + t2114 * t81 / 0.32e2 + 0.3e1 / 0.32e2 * t805 * t286 + 0.3e1 / 0.32e2 * t274 * t821 + t63 * t2125 / 0.32e2 + t2114 * t96 / 0.576e3 + t805 * t302 / 0.192e3 + 0.3e1 / 0.32e2 * t1893 + t1905 / 0.192e3 + t1911 / 0.96e2 + t1918 / 0.192e3 + 0.3e1 / 0.32e2 * t1942 + 0.3e1 / 0.16e2 * t1948;
  t2139 = t2103 + t2138;
  t2142 = t1360 - t1363 + t1366 + t1374 - t1377 + t1383 - 0.4e1 / 0.3e1 * t1679 + 0.2e1 / 0.3e1 * t1692 - 0.4e1 / 0.3e1 * t1682 - t1971 * t12 - t1725 + t16 * t12 * t2139;
  t2143 = t1967 + t2142;
  tv3rho33 = t118 * t2143 + 0.3e1 * t1699;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2145 = t899 * params->c;
  t2146 = t130 * t15;
  t2149 = 0.2e1 / 0.9e1 * t2145 * t2146 * t904;
  t2150 = t899 * t15;
  t2151 = t127 * t354;
  t2154 = 0.2e1 / 0.9e1 * t2150 * t2151 * t131;
  t2155 = t899 * t955;
  t2157 = t406 * t15;
  t2160 = t357 * t2157 * t904 / 0.9e1;
  t2161 = t356 * t134;
  t2163 = 0.2e1 / 0.9e1 * t2161 * t909;
  t2164 = t12 * t954;
  t2166 = t902 * t903 * t2164;
  t2169 = t1371 * t354 * t151;
  t2171 = 0.2e1 / 0.9e1 * t357 * t2169;
  t2173 = t412 * t954 * params->d;
  t2174 = t902 * t2173;
  t2178 = t183 * t189;
  t2179 = t2178 * t50;
  t2180 = t63 * t2179;
  t2182 = t65 * t487;
  t2183 = t2182 * t50;
  t2188 = t202 * t189;
  t2189 = t2188 * t89;
  t2190 = t63 * t2189;
  t2192 = t84 * t487;
  t2193 = t2192 * t89;
  t2198 = t180 * t918;
  t2202 = t478 * t70;
  t2203 = t2202 * t50;
  t2205 = t63 * t2203 / 0.32e2;
  t2206 = t917 * t170;
  t2207 = t63 * t2206;
  t2209 = t921 * t170;
  t2212 = -t180 * t922 / 0.6e1 - t2180 / 0.6e1 + 0.11e2 / 0.36e2 * t63 * t2183 - t180 * t935 / 0.108e3 - t2190 / 0.108e3 + 0.11e2 / 0.648e3 * t63 * t2193 + t463 * t340 / 0.32e2 + t2198 / 0.16e2 + t180 * t925 / 0.16e2 + t2205 + t2207 / 0.16e2 - t63 * t2209 / 0.6e1;
  t2213 = t339 * t450;
  t2218 = t180 * t931;
  t2222 = t508 * t70;
  t2223 = t2222 * t89;
  t2225 = t63 * t2223 / 0.576e3;
  t2226 = t930 * t210;
  t2227 = t63 * t2226;
  t2229 = t934 * t210;
  t2232 = t343 * t524;
  t2236 = 0.88e2 / 0.9e1 * t432 * t30;
  t2237 = t146 * t161;
  t2238 = 0.16e2 / 0.3e1 * t2237;
  t2239 = t21 * t549;
  t2243 = t570 * t70;
  t2246 = t234 * t189;
  t2251 = t106 * t487;
  t2261 = t63 * t2213 / 0.32e2 + t463 * t344 / 0.576e3 + t2218 / 0.288e3 + t180 * t938 / 0.288e3 + t2225 + t2227 / 0.288e3 - t63 * t2229 / 0.108e3 + t63 * t2232 / 0.576e3 - t2236 + t2238 - t2239 - t62 * (0.176e3 / 0.27e2 * t578 - 0.32e2 / 0.9e1 * t581 + 0.2e1 / 0.3e1 * t584 - t2243 * t50 / 0.4e1 + 0.4e1 / 0.3e1 * t2246 * t50 - t943 * t170 / 0.2e1 - 0.22e2 / 0.9e1 * t2251 * t50 + 0.4e1 / 0.3e1 * t946 * t170 - t348 * t450 / 0.4e1) / 0.8e1;
  t2262 = t2212 + t2261;
  t2263 = t136 * t2262;
  tv3rho2sigma0 = t2149 + t2154 + 0.2e1 * t2155 + t2160 + t2163 + 0.2e1 / 0.3e1 * t2166 + t2171 + 0.2e1 / 0.3e1 * t2174 + t337 * t2263;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t2266 = t146 * params->a * params->b;
  t2268 = 0.8e2 / 0.9e1 * t2266 * t358;
  t2270 = t384 * params->a * params->b;
  t2272 = 0.28e2 / 0.9e1 * t2270 * t964;
  t2274 = 0.28e2 / 0.9e1 * t2270 * t968;
  t2275 = t958 * t971;
  t2277 = t1196 * params->a;
  t2278 = t2277 * params->b;
  t2279 = t2157 * t963;
  t2281 = 0.2e1 / 0.9e1 * t2278 * t2279;
  t2282 = t2277 * t134;
  t2284 = 0.4e1 / 0.9e1 * t2282 * t968;
  t2285 = t12 * t161;
  t2286 = t903 * t2285;
  t2287 = t962 * t2286;
  t2290 = t1371 * t30 * t151;
  t2292 = 0.4e1 / 0.9e1 * t2278 * t2290;
  t2294 = t412 * t161 * params->d;
  t2295 = t962 * t2294;
  t2297 = t136 * t549;
  tv3rho2sigma1 = -t2268 + t2272 + t2274 + 0.2e2 / 0.3e1 * t2275 - t2281 - t2284 - 0.4e1 / 0.3e1 * t2287 - t2292 - 0.4e1 / 0.3e1 * t2295 - 0.2e1 * t357 * t2297;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2302 = 0.2e1 / 0.9e1 * t2145 * t2146 * t975;
  t2303 = t127 * t376;
  t2306 = 0.2e1 / 0.9e1 * t2150 * t2303 * t131;
  t2307 = t899 * t1011;
  t2311 = t357 * t2157 * t975 / 0.9e1;
  t2313 = 0.2e1 / 0.9e1 * t2161 * t980;
  t2314 = t12 * t1010;
  t2316 = t902 * t903 * t2314;
  t2319 = t1371 * t376 * t151;
  t2321 = 0.2e1 / 0.9e1 * t357 * t2319;
  t2323 = t412 * t1010 * params->d;
  t2324 = t902 * t2323;
  t2328 = t180 * t986;
  t2332 = t478 * t77;
  t2333 = t2332 * t57;
  t2335 = t63 * t2333 / 0.32e2;
  t2336 = t985 * t175;
  t2337 = t63 * t2336;
  t2339 = t361 * t458;
  t2344 = t180 * t995;
  t2348 = t508 * t77;
  t2349 = t2348 * t93;
  t2351 = t63 * t2349 / 0.576e3;
  t2352 = t994 * t214;
  t2353 = t63 * t2352;
  t2355 = t365 * t531;
  t2359 = t558 * t77;
  t2369 = -t2236 + t2238 - t2239 + t463 * t362 / 0.32e2 + t2328 / 0.16e2 + t180 * t989 / 0.16e2 + t2335 + t2337 / 0.16e2 + t63 * t2339 / 0.32e2 + t463 * t366 / 0.576e3 + t2344 / 0.288e3 + t180 * t998 / 0.288e3 + t2351 + t2353 / 0.288e3 + t63 * t2355 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t564 - t2359 * t57 / 0.4e1 - t1002 * t175 / 0.2e1 - t370 * t458 / 0.4e1) / 0.8e1;
  t2370 = t136 * t2369;
  tv3rho2sigma2 = t2302 + t2306 + 0.2e1 * t2307 + t2311 + t2313 + 0.2e1 / 0.3e1 * t2316 + t2321 + 0.2e1 / 0.3e1 * t2324 + t337 * t2370;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2374 = t899 * t1034;
  t2375 = t12 * t1033;
  t2377 = t902 * t903 * t2375;
  t2380 = t412 * t1033 * params->d;
  t2381 = t902 * t2380;
  t2383 = t21 * t685;
  t2386 = t663 * t70;
  t2389 = t322 * t189;
  t2403 = t146 * t257;
  t2404 = 0.8e1 / 0.3e1 * t2403;
  t2405 = t339 * t620;
  t2410 = t274 * t931;
  t2416 = t930 * t293;
  t2417 = t63 * t2416;
  t2419 = t343 * t716;
  t2424 = t921 * t265;
  t2429 = t934 * t293;
  t2432 = -t2383 - t62 * (-0.16e2 / 0.9e1 * t673 + 0.2e1 / 0.3e1 * t676 - t2386 * t50 / 0.4e1 + 0.2e1 / 0.3e1 * t2389 * t50 - t1025 * t170 / 0.4e1 - t943 * t265 / 0.4e1 + 0.2e1 / 0.3e1 * t946 * t265 - t348 * t620 / 0.4e1) / 0.8e1 + t2404 + t63 * t2405 / 0.32e2 + t696 * t344 / 0.576e3 + t2410 / 0.576e3 + t274 * t938 / 0.576e3 + t180 * t1021 / 0.576e3 + t2417 / 0.576e3 + t63 * t2419 / 0.576e3 - t274 * t922 / 0.12e2 - t63 * t2424 / 0.12e2 - t274 * t935 / 0.216e3 - t63 * t2429 / 0.216e3;
  t2435 = t274 * t918;
  t2441 = t917 * t265;
  t2442 = t63 * t2441;
  t2450 = 0.8e1 / 0.3e1 * t2237;
  t2451 = t696 * t340 / 0.32e2 + t2435 / 0.32e2 + t274 * t925 / 0.32e2 + t180 * t1016 / 0.32e2 + t2442 / 0.32e2 - t2180 / 0.12e2 - t2190 / 0.216e3 + t2198 / 0.32e2 + t2205 + t2207 / 0.32e2 + t2218 / 0.576e3 + t2225 + t2227 / 0.576e3 - t2236 + t2450;
  t2452 = t2432 + t2451;
  t2453 = t136 * t2452;
  tv3rho2sigma3 = t2149 + t2154 + t2155 + t2160 + t2163 + t2166 / 0.3e1 + t2171 + t2174 / 0.3e1 + t2374 + t2377 / 0.3e1 + t2381 / 0.3e1 + t337 * t2453;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t2458 = t958 * t1036;
  t2460 = t12 * t257;
  t2461 = t903 * t2460;
  t2462 = t962 * t2461;
  t2465 = t412 * t257 * params->d;
  t2466 = t962 * t2465;
  t2468 = t136 * t685;
  tv3rho2sigma4 = -t2268 + t2272 + t2274 + 0.1e2 / 0.3e1 * t2275 - t2281 - t2284 - 0.2e1 / 0.3e1 * t2287 - t2292 - 0.2e1 / 0.3e1 * t2295 + 0.1e2 / 0.3e1 * t2458 - 0.2e1 / 0.3e1 * t2462 - 0.2e1 / 0.3e1 * t2466 - 0.2e1 * t357 * t2468;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2473 = t899 * t1071;
  t2474 = t12 * t1070;
  t2476 = t902 * t903 * t2474;
  t2479 = t412 * t1070 * params->d;
  t2480 = t902 * t2479;
  t2484 = t274 * t986;
  t2490 = t183 * t280;
  t2491 = t2490 * t57;
  t2492 = t63 * t2491;
  t2494 = t1041 * t175;
  t2499 = t985 * t269;
  t2500 = t63 * t2499;
  t2502 = t361 * t632;
  t2507 = t274 * t995;
  t2511 = -t2383 + t2404 + t696 * t362 / 0.32e2 + t2484 / 0.32e2 + t274 * t989 / 0.32e2 - t180 * t1042 / 0.12e2 - t2492 / 0.12e2 - t63 * t2494 / 0.12e2 + t180 * t1045 / 0.32e2 + t2500 / 0.32e2 + t63 * t2502 / 0.32e2 + t696 * t366 / 0.576e3 + t2507 / 0.576e3 + t274 * t998 / 0.576e3;
  t2514 = t202 * t280;
  t2515 = t2514 * t93;
  t2516 = t63 * t2515;
  t2518 = t1050 * t214;
  t2523 = t994 * t299;
  t2524 = t63 * t2523;
  t2526 = t365 * t726;
  t2535 = t641 * t77;
  t2540 = t225 * t280;
  t2552 = -t180 * t1051 / 0.216e3 - t2516 / 0.216e3 - t63 * t2518 / 0.216e3 + t180 * t1054 / 0.576e3 + t2524 / 0.576e3 + t63 * t2526 / 0.576e3 + t2328 / 0.32e2 + t2335 + t2337 / 0.32e2 + t2344 / 0.576e3 + t2351 + t2353 / 0.576e3 - t62 * (-0.16e2 / 0.9e1 * t649 + 0.2e1 / 0.3e1 * t654 - t2535 * t57 / 0.4e1 - t1059 * t175 / 0.4e1 + 0.2e1 / 0.3e1 * t2540 * t57 + 0.2e1 / 0.3e1 * t1062 * t175 - t1002 * t269 / 0.4e1 - t370 * t632 / 0.4e1) / 0.8e1 - t2236 + t2450;
  t2553 = t2511 + t2552;
  t2554 = t136 * t2553;
  tv3rho2sigma5 = t2302 + t2306 + t2307 + t2311 + t2313 + t2316 / 0.3e1 + t2321 + t2324 / 0.3e1 + t2473 + t2476 / 0.3e1 + t2480 / 0.3e1 + t337 * t2554;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2559 = 0.16e2 / 0.3e1 * t2403;
  t2560 = t21 * t853;
  t2567 = t339 * t792;
  t2576 = t343 * t833;
  t2580 = t882 * t70;
  t2590 = -t2236 + t2559 - t2560 + t805 * t340 / 0.32e2 + t2435 / 0.16e2 + t274 * t1016 / 0.16e2 + t2205 + t2442 / 0.16e2 + t63 * t2567 / 0.32e2 + t805 * t344 / 0.576e3 + t2410 / 0.288e3 + t274 * t1021 / 0.288e3 + t2225 + t2417 / 0.288e3 + t63 * t2576 / 0.576e3 - t62 * (0.2e1 / 0.3e1 * t888 - t2580 * t50 / 0.4e1 - t1025 * t265 / 0.2e1 - t348 * t792 / 0.4e1) / 0.8e1;
  t2591 = t136 * t2590;
  tv3rho2sigma6 = t2149 + t2154 + 0.2e1 * t2374 + t2160 + t2163 + 0.2e1 / 0.3e1 * t2377 + t2171 + 0.2e1 / 0.3e1 * t2381 + t337 * t2591;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  t2596 = t136 * t853;
  tv3rho2sigma7 = -t2268 + t2272 + t2274 + 0.2e2 / 0.3e1 * t2458 - t2281 - t2284 - 0.4e1 / 0.3e1 * t2462 - t2292 - 0.4e1 / 0.3e1 * t2466 - 0.2e1 * t357 * t2596;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2604 = t65 * t813;
  t2605 = t2604 * t57;
  t2610 = t84 * t813;
  t2611 = t2610 * t93;
  t2620 = -t274 * t1042 / 0.6e1 + 0.11e2 / 0.36e2 * t63 * t2605 - t274 * t1051 / 0.108e3 + 0.11e2 / 0.648e3 * t63 * t2611 + t2335 + t2351 + t2484 / 0.16e2 - t2492 / 0.6e1 + t2500 / 0.16e2 + t2507 / 0.288e3 - t2516 / 0.108e3 + t2524 / 0.288e3;
  t2625 = t1041 * t269;
  t2628 = t361 * t800;
  t2635 = t1050 * t299;
  t2638 = t365 * t844;
  t2644 = t862 * t77;
  t2647 = t310 * t280;
  t2652 = t101 * t813;
  t2662 = t805 * t362 / 0.32e2 + t274 * t1045 / 0.16e2 - t63 * t2625 / 0.6e1 + t63 * t2628 / 0.32e2 + t805 * t366 / 0.576e3 + t274 * t1054 / 0.288e3 - t63 * t2635 / 0.108e3 + t63 * t2638 / 0.576e3 - t2236 + t2559 - t2560 - t62 * (0.176e3 / 0.27e2 * t870 - 0.32e2 / 0.9e1 * t873 + 0.2e1 / 0.3e1 * t876 - t2644 * t57 / 0.4e1 + 0.4e1 / 0.3e1 * t2647 * t57 - t1059 * t269 / 0.2e1 - 0.22e2 / 0.9e1 * t2652 * t57 + 0.4e1 / 0.3e1 * t1062 * t269 - t370 * t800 / 0.4e1) / 0.8e1;
  t2663 = t2620 + t2662;
  t2664 = t136 * t2663;
  tv3rho2sigma8 = t2302 + t2306 + 0.2e1 * t2473 + t2311 + t2313 + 0.2e1 / 0.3e1 * t2476 + t2321 + 0.2e1 / 0.3e1 * t2480 + t337 * t2664;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rhosigma20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  tv3rhosigma26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3sigma30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t2666 = params->a * t1386;
  t2668 = 0.72e2 * t384;
  t2669 = t1 * t1183;
  t2670 = 0.192e3 * t2669;
  t2671 = t383 * t4;
  t2672 = 0.1e1 / t2671;
  t2673 = t2 * t2672;
  t2674 = 0.12e3 * t2673;
  t2675 = -t2668 + t2670 - t2674;
  t2678 = t135 * t136 * t1320;
  t2682 = t140 * t1320 * params->d * t130;
  t2684 = t403 * t1335;
  t2686 = t1325 * t416;
  t2690 = 0.8e1 / 0.27e2 * t1331 * t1183 * t137;
  t2691 = t408 * t1335;
  t2693 = t1332 * t416;
  t2695 = t406 * t406;
  t2698 = 0.1e1 / t8 / t1182;
  t2701 = params->b * t2695 * t2698 * t137 / 0.81e2;
  t2704 = t419 * t590 * t151 * t21;
  t2709 = t1341 * t247 * t470 * t384;
  t2712 = 0.1e1 / t1080 / t11;
  t2717 = 0.8e1 / 0.27e2 * t16 * t2712 * t114 * t1193 * t2698;
  t2718 = t1358 * t416;
  t2722 = 0.16e3 / 0.81e2 * t407 * t432 * t137;
  t2724 = t419 * t1337 * t146;
  t2728 = 0.16e2 / 0.9e1 * t1341 * t1342 * t1183;
  t2730 = t140 * t1346 * t399;
  t2734 = 0.28e3 / 0.81e2 * t134 * t1196 * t137;
  t2737 = 0.32e3 / 0.81e2 * t419 * t420 * t432;
  t2739 = t140 * t424 * t1204;
  t2743 = 0.28e3 / 0.81e2 * t140 * t141 * t1196;
  t2744 = 0.8e1 / 0.9e1 * t2709 + t2717 + 0.112e3 / 0.27e2 * t2718 + t2722 - 0.32e2 / 0.9e1 * t2724 - t2728 - 0.8e1 / 0.3e1 * t2730 - t2734 + t2737 + 0.112e3 / 0.27e2 * t2739 - t2743;
  t2746 = t1361 * t1367;
  t2750 = 0.8e1 / 0.9e1 * t407 * t1183 * t413;
  t2751 = t1364 * t1367;
  t2755 = 0.4e1 / 0.81e2 * t1331 * t2698 * t413;
  t2757 = t411 * t412 * t1346;
  t2760 = t1370 * t1371 * t1337;
  t2763 = t15 * t1081;
  t2766 = 0.8e1 / 0.27e2 * t134 * t2698 * t2763 * t1342;
  t2769 = 0.32e3 / 0.81e2 * t134 * t432 * t413;
  t2772 = 0.16e2 / 0.9e1 * t134 * t1183 * t1372;
  t2775 = 0.4e1 / 0.27e2 * t407 * t2698 * t1372;
  t2777 = t1075 * t400;
  t2779 = t1077 * t1352;
  t2783 = 0.16e2 / 0.9e1 * t1082 * t470 * t1183;
  t2784 = t389 * t1355;
  t2788 = 0.32e3 / 0.81e2 * t394 * t151 * t432;
  t2791 = 0.28e3 / 0.81e2 * t128 * params->d * t1196;
  t2793 = t1186 * t127 * t131;
  t2796 = t387 * t393 * t395;
  t2799 = t124 * t1081 * t1083;
  t2804 = 0.8e1 / 0.27e2 * t7 * t2712 * t1193 * t2698;
  t2806 = 0.1e1 / t54 / t51;
  t2807 = t451 * t451;
  t2813 = t454 * t454;
  t2819 = 0.24e2 * t384 - 0.24e2 * t2669;
  t2823 = my_piecewise3(t52, 0, -0.8e2 / 0.81e2 * t2806 * t2807 + 0.16e3 / 0.9e1 * t1108 * t451 * t454 + 0.4e2 / 0.3e1 * t55 * t2813 + 0.16e3 / 0.9e1 * t1112 * t1115 + 0.8e1 / 0.3e1 * t171 * t2819);
  t2833 = my_piecewise3(t52, 0, 0.8e1 * t172 * t1115 + 0.2e1 * t51 * t2819 + 0.6e1 * t2813);
  t2850 = 0.1e1 / t47 / t40;
  t2851 = t442 * t442;
  t2857 = t446 * t446;
  t2862 = -t2819;
  t2866 = my_piecewise3(t41, 0, -0.8e2 / 0.81e2 * t2850 * t2851 + 0.16e3 / 0.9e1 * t1144 * t442 * t446 + 0.4e2 / 0.3e1 * t48 * t2857 + 0.16e3 / 0.9e1 * t1148 * t1096 + 0.8e1 / 0.3e1 * t166 * t2862);
  t2876 = my_piecewise3(t41, 0, 0.8e1 * t167 * t1096 + 0.2e1 * t40 * t2862 + 0.6e1 * t2857);
  t2884 = -t102 * t77 * t2823 / 0.4e1 - t2833 * sigma[0] * t108 / 0.4e1 - t1129 * t241 - 0.3e1 / 0.2e1 * t571 * t584 + 0.8e1 * t235 * t1141 - t235 * t1155 - 0.44e2 / 0.3e1 * t107 * t487 * t450 + 0.8e1 / 0.3e1 * t107 * t189 * t1154 - t107 * t70 * t2866 / 0.4e1 - t2876 * sigma[2] * t103 / 0.4e1 - t1101 * t229 - 0.3e1 / 0.2e1 * t559 * t564 - t226 * t1120;
  t2900 = 0.1e1 / t68 / t485 / t66;
  t2904 = sigma[0] * t2900;
  t2905 = t2904 * t50;
  t2907 = t1089 * t170;
  t2909 = t488 * t450;
  t2911 = t190 * t1154;
  t2913 = t71 * t2866;
  t2915 = t78 * t2823;
  t2917 = 0.8e1 / 0.3e1 * t1129 * t238 + 0.8e1 * t571 * t581 - 0.88e2 / 0.3e1 * t235 * t1138 + 0.1232e4 / 0.27e2 * t107 * t1088 * t170 - 0.44e2 / 0.3e1 * t571 * t578 + 0.1232e4 / 0.27e2 * t235 * t1162 - 0.5236e4 / 0.81e2 * t107 * t2900 * t50 + 0.41888e5 / 0.243e3 * t2905 - 0.9856e4 / 0.81e2 * t2907 + 0.352e3 / 0.9e1 * t2909 - 0.64e2 / 0.9e1 * t2911 + 0.2e1 / 0.3e1 * t2913 + 0.2e1 / 0.3e1 * t2915;
  t2921 = t180 * t1228;
  t2927 = t463 * t509;
  t2929 = t463 * t512;
  t2933 = t180 * t1222;
  t2935 = t180 * t1225;
  t2937 = t180 * t1285;
  t2939 = t180 * t1288;
  t2941 = t180 * t1291;
  t2947 = t1193 * params->d * t2712 * t1213;
  t2949 = t1194 * t2698;
  t2951 = t471 * t1183;
  t2953 = t152 * t432;
  t2955 = t24 * t1196;
  t2960 = t63 * (-0.4e1 / 0.243e3 * t2947 + 0.28e2 / 0.243e3 * t2949 - 0.232e3 / 0.729e3 * t2951 + 0.1e3 / 0.243e3 * t2953 - 0.14e3 / 0.729e3 * t2955) * t80 / 0.32e2;
  t2962 = t63 * t1284 * t195;
  t2965 = t63 * t478 * t495;
  t2968 = t63 * t183 * t1297;
  t2978 = t62 * t2675;
  t2981 = t1266 * t203;
  t2983 = -t62 * (t2884 + t2917) / 0.8e1 + t2921 / 0.48e2 + t180 * t1256 / 0.144e3 + t1266 * t217 / 0.144e3 + t2927 / 0.96e2 + t2929 / 0.48e2 + t463 * t534 / 0.96e2 + t2933 / 0.144e3 + t2935 / 0.48e2 + t2937 / 0.8e1 + 0.3e1 / 0.8e1 * t2939 + 0.3e1 / 0.8e1 * t2941 + t180 * t1298 / 0.8e1 + t2960 + t2962 / 0.8e1 + 0.3e1 / 0.16e2 * t2965 + t2968 / 0.8e1 + t63 * t65 * (0.20944e5 / 0.81e2 * t2905 - 0.4928e4 / 0.27e2 * t2907 + 0.176e3 / 0.3e1 * t2909 - 0.32e2 / 0.3e1 * t2911 + t2913 + t2915) / 0.32e2 + t2978 * t96 / 0.576e3 + t2981 / 0.144e3;
  t3002 = t1266 * t184;
  t3006 = t463 * t479;
  t3008 = t463 * t482;
  t3013 = t1214 * t161;
  t3015 = t433 * t549;
  t3017 = t147 * t1210;
  t3021 = t1186 * t158;
  t3023 = t387 * t546;
  t3025 = t124 * t1207;
  t3034 = t7 * (-0.56e2 / 0.27e2 * t2947 + 0.392e3 / 0.27e2 * t2949 - 0.3248e4 / 0.81e2 * t2951 + 0.14e4 / 0.27e2 * t2953 - 0.196e4 / 0.81e2 * t2955) / 0.72e2;
  t3041 = 0.20944e5 / 0.81e2 * t18 / t19 / t2671 * t30;
  t3050 = t63 * (0.8e1 / 0.27e2 * t2947 - 0.56e2 / 0.27e2 * t2949 + 0.464e3 / 0.81e2 * t2951 - 0.2e3 / 0.27e2 * t2953 + 0.28e3 / 0.81e2 * t2955) * t95 / 0.576e3;
  t3052 = t63 * t1221 * t216;
  t3055 = t63 * t508 * t533;
  t3058 = t63 * t202 * t1255;
  t3079 = my_piecewise3(t41, 0, 0.88e3 / 0.81e2 * t1144 * t2851 + 0.88e3 / 0.9e1 * t443 * t446 + 0.88e2 / 0.3e1 * t166 * t2857 + 0.352e3 / 0.9e1 * t168 * t1096 + 0.11e2 / 0.3e1 * t49 * t2862);
  t3092 = my_piecewise3(t52, 0, 0.88e3 / 0.81e2 * t1108 * t2807 + 0.88e3 / 0.9e1 * t452 * t454 + 0.88e2 / 0.3e1 * t171 * t2813 + 0.352e3 / 0.9e1 * t173 * t1115 + 0.11e2 / 0.3e1 * t56 * t2819);
  t3098 = 0.3e1 / 0.16e2 * t463 * t496 + 0.4928e4 / 0.27e2 * t3013 - 0.176e3 / 0.3e1 * t3015 + 0.32e2 / 0.3e1 * t3017 - t22 * (t2675 * t27 / 0.72e2 + t3021 / 0.18e2 + t3023 / 0.12e2 + t3025 / 0.18e2 + t3034) - t3041 + t3050 + t3052 / 0.144e3 + t3055 / 0.96e2 + t3058 / 0.144e3 + t63 * t84 * (0.20944e5 / 0.81e2 * t2904 * t89 - 0.4928e4 / 0.27e2 * t1089 * t210 + 0.176e3 / 0.3e1 * t488 * t524 - 0.32e2 / 0.3e1 * t190 * t1244 + t71 * t3079 + t78 * t3092) / 0.576e3;
  t3103 = 0.8e1 / 0.3e1 * t2777 + 0.32e2 / 0.9e1 * t2779 + t2783 - 0.112e3 / 0.27e2 * t2784 - t2788 + t2791 - 0.4e1 / 0.3e1 * t2793 - 0.4e1 / 0.3e1 * t2796 - 0.8e1 / 0.9e1 * t2799 - t2804 + t16 * t12 * (t2983 - 0.3e1 / 0.2e2 * t37 * t2675 * t58 - 0.3e1 / 0.5e1 * t37 * t1186 * t176 - 0.9e1 / 0.1e2 * t37 * t387 * t459 - 0.3e1 / 0.5e1 * t37 * t124 * t1262 - 0.3e1 / 0.2e2 * t37 * t7 * (t2866 + t2823) + t2978 * t81 / 0.32e2 + t3002 / 0.8e1 + t1266 * t196 / 0.8e1 + 0.3e1 / 0.16e2 * t3006 + 0.3e1 / 0.8e1 * t3008 + t3098);
  tv4rho40 = 0.4e1 * t2666 + t118 * (-t2675 * t12 + 0.4e1 / 0.3e1 * t2678 + 0.4e1 / 0.3e1 * t2682 - 0.8e1 / 0.3e1 * t2684 - 0.16e2 / 0.9e1 * t2686 - t2690 + 0.2e1 / 0.3e1 * t2691 + 0.4e1 / 0.27e2 * t2693 + t2701 + 0.4e1 / 0.3e1 * t2704 + t2744 - 0.32e2 / 0.9e1 * t2746 - t2750 + 0.4e1 / 0.9e1 * t2751 + t2755 + 0.4e1 / 0.3e1 * t2757 + 0.8e1 / 0.9e1 * t2760 + t2766 + t2769 - t2772 + t2775 + t3103);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3107 = params->a * t1697;
  t3110 = t1571 * t127 * t131;
  t3112 = t596 * t393 * t395;
  t3113 = 0.2e1 / 0.3e1 * t3112;
  t3115 = t253 * t1081 * t1083;
  t3125 = t121 * t442;
  t3132 = t384 * t167;
  t3135 = t121 * t446;
  t3143 = 0.88e2 * t712 * t1183;
  t3145 = my_piecewise3(t41, 0, 0.88e3 / 0.81e2 * t1482 * t1145 + 0.88e3 / 0.9e1 * t1485 * t3125 + 0.44e3 / 0.9e1 * t613 * t1092 + 0.176e3 / 0.3e1 * t1491 * t167 - 0.176e3 * t616 * t3132 + 0.176e3 / 0.3e1 * t616 * t3135 + 0.88e2 / 0.9e1 * t263 * t1096 - 0.44e2 * t49 * t384 + t3143);
  t3151 = t121 * t451;
  t3158 = t384 * t172;
  t3161 = t121 * t454;
  t3169 = 0.88e2 * t722 * t1183;
  t3171 = my_piecewise3(t52, 0, 0.88e3 / 0.81e2 * t1436 * t1109 - 0.88e3 / 0.9e1 * t1439 * t3151 + 0.44e3 / 0.9e1 * t625 * t1123 - 0.176e3 / 0.3e1 * t1445 * t172 + 0.176e3 * t628 * t3158 - 0.176e3 / 0.3e1 * t628 * t3161 + 0.88e2 / 0.9e1 * t267 * t1115 + 0.44e2 * t56 * t384 - t3169);
  t3200 = 0.64e2 * t616 * t1183;
  t3202 = my_piecewise3(t41, 0, -0.8e2 / 0.81e2 * t2850 * t262 * t1145 + 0.16e3 / 0.9e1 * t1144 * t1 * t3125 + 0.8e2 / 0.9e1 * t1482 * t1092 + 0.8e2 / 0.3e1 * t48 * t121 * t167 - 0.8e2 * t1485 * t3132 + 0.8e2 / 0.3e1 * t1485 * t3135 + 0.4e2 / 0.9e1 * t613 * t1096 - 0.32e2 * t166 * t384 + t3200);
  t3223 = 0.64e2 * t628 * t1183;
  t3225 = my_piecewise3(t52, 0, -0.8e2 / 0.81e2 * t2806 * t266 * t1109 - 0.16e3 / 0.9e1 * t1108 * t1 * t3151 + 0.8e2 / 0.9e1 * t1436 * t1123 - 0.8e2 / 0.3e1 * t55 * t121 * t172 + 0.8e2 * t1439 * t3158 - 0.8e2 / 0.3e1 * t1439 * t3161 + 0.4e2 / 0.9e1 * t625 * t1115 + 0.32e2 * t171 * t384 - t3223);
  t3230 = 0.96e2 * t2669;
  t3231 = t3230 - t2674;
  t3232 = t62 * t3231;
  t3235 = t1572 * t184;
  t3239 = t696 * t479;
  t3240 = 0.3e1 / 0.32e2 * t3239;
  t3241 = t696 * t482;
  t3245 = t274 * t1228;
  t3251 = t463 * t705;
  t3255 = t180 * t1520;
  t3256 = t3255 / 0.192e3;
  t3257 = t180 * t1523;
  t3262 = t63 * t1221 * t301;
  t3265 = t63 * t508 * t728;
  t3266 = t3265 / 0.192e3;
  t3267 = t63 * t84 * (-0.1232e4 / 0.27e2 * t1089 * t293 + 0.88e2 / 0.3e1 * t488 * t716 - 0.8e1 * t190 * t1541 + t71 * t3145 - 0.8e1 / 0.3e1 * t281 * t1253 + t78 * t3171) / 0.576e3 - 0.9e1 / 0.2e2 * t37 * t124 * t1565 - 0.3e1 / 0.2e2 * t37 * t7 * (t3202 + t3225) + t3232 * t81 / 0.32e2 + 0.3e1 / 0.32e2 * t3235 + 0.3e1 / 0.32e2 * t1572 * t196 + t3240 + 0.3e1 / 0.16e2 * t3241 + 0.3e1 / 0.32e2 * t696 * t496 + t3245 / 0.192e3 + t274 * t1256 / 0.576e3 + t1266 * t302 / 0.576e3 + t3251 / 0.192e3 + t463 * t729 / 0.192e3 + t3256 + t3257 / 0.96e2 + t180 * t1559 / 0.192e3 + t3262 / 0.576e3 + t3266;
  t3269 = t63 * t202 * t1558;
  t3271 = t274 * t1222;
  t3273 = t274 * t1225;
  t3274 = t3273 / 0.192e3;
  t3275 = t1572 * t203;
  t3279 = t696 * t509;
  t3280 = t3279 / 0.192e3;
  t3281 = t696 * t512;
  t3287 = t1571 * t158;
  t3289 = t596 * t546;
  t3290 = t3289 / 0.24e2;
  t3291 = t253 * t1207;
  t3298 = t433 * t685;
  t3299 = 0.88e2 / 0.3e1 * t3298;
  t3300 = t147 * t1641;
  t3302 = t1214 * t257;
  t3304 = t1089 * t265;
  t3306 = t488 * t620;
  t3308 = t190 * t1496;
  t3310 = t71 * t3202;
  t3311 = t281 * t1119;
  t3313 = t78 * t3225;
  t3335 = t3269 / 0.192e3 + t3271 / 0.576e3 + t3274 + t3275 / 0.192e3 + t1572 * t217 / 0.192e3 + t3280 + t3281 / 0.96e2 + t696 * t534 / 0.192e3 - t22 * (t3231 * t27 / 0.72e2 + t3287 / 0.24e2 + t3290 + t3291 / 0.72e2 + t3021 / 0.72e2 + t3023 / 0.24e2 + t3025 / 0.24e2 + t3034) - t3299 + 0.8e1 * t3300 + 0.1232e4 / 0.27e2 * t3302 + t63 * t65 * (-0.1232e4 / 0.27e2 * t3304 + 0.88e2 / 0.3e1 * t3306 - 0.8e1 * t3308 + t3310 - 0.8e1 / 0.3e1 * t3311 + t3313) / 0.32e2 + t3232 * t96 / 0.576e3 - 0.3e1 / 0.2e2 * t37 * t253 * t1262 - 0.3e1 / 0.2e2 * t37 * t1186 * t270 - 0.9e1 / 0.2e2 * t37 * t387 * t742 - 0.3e1 / 0.2e2 * t37 * t3231 * t58 - 0.9e1 / 0.2e2 * t37 * t1571 * t176;
  t3340 = t274 * t1285;
  t3342 = t274 * t1288;
  t3343 = 0.3e1 / 0.32e2 * t3342;
  t3344 = t274 * t1291;
  t3350 = t463 * t754;
  t3354 = t180 * t1592;
  t3355 = 0.3e1 / 0.32e2 * t3354;
  t3356 = t180 * t1595;
  t3361 = t63 * t1284 * t285;
  t3364 = t63 * t478 * t692;
  t3365 = 0.3e1 / 0.32e2 * t3364;
  t3367 = t63 * t183 * t1601;
  t3389 = 0.48e2 * t637 * t1183;
  t3391 = my_piecewise3(t41, 0, 0.12e2 * t446 * t1 * t121 + 0.2e1 * t1096 * t262 - 0.36e2 * t1409 * t384 - 0.24e2 * t40 * t384 + 0.12e2 * t1486 + t3389);
  t3417 = -0.2464e4 / 0.81e2 * t3304 + 0.176e3 / 0.9e1 * t3306 - 0.16e2 / 0.3e1 * t3308 + 0.2e1 / 0.3e1 * t3310 - 0.16e2 / 0.9e1 * t3311 + 0.2e1 / 0.3e1 * t3313 - t107 * t70 * t3202 / 0.4e1 - t3391 * sigma[2] * t103 / 0.4e1 - 0.3e1 / 0.4e1 * t1418 * t229 - 0.3e1 / 0.4e1 * t642 * t564 - t311 * t1120 / 0.4e1 + 0.2e1 / 0.3e1 * t1101 * t314 + 0.2e1 * t559 * t649 + 0.2e1 * t226 * t1429 + 0.2e1 * t1466 * t238 + 0.4e1 * t664 * t581 - 0.22e2 / 0.3e1 * t323 * t1138 + 0.2e1 * t571 * t673 + 0.4e1 * t235 * t1479;
  t3453 = 0.48e2 * t659 * t1183;
  t3455 = my_piecewise3(t52, 0, -0.12e2 * t454 * t1 * t121 + 0.2e1 * t1115 * t266 + 0.36e2 * t1457 * t384 + 0.24e2 * t51 * t384 - 0.12e2 * t1440 - t3453);
  t3476 = -0.22e2 / 0.3e1 * t107 * t487 * t620 - 0.22e2 / 0.3e1 * t664 * t578 + 0.308e3 / 0.27e2 * t323 * t1162 - 0.22e2 / 0.3e1 * t235 * t1404 + 0.308e3 / 0.27e2 * t107 * t1088 * t265 + 0.2e1 / 0.3e1 * t102 * t280 * t1119 - t1101 * t317 / 0.4e1 - 0.3e1 / 0.4e1 * t559 * t654 - 0.3e1 / 0.4e1 * t226 * t1451 - t102 * t77 * t3225 / 0.4e1 - t3455 * sigma[0] * t108 / 0.4e1 - 0.3e1 / 0.4e1 * t1466 * t241 - 0.3e1 / 0.4e1 * t664 * t584 + 0.2e1 * t323 * t1141 - t323 * t1155 / 0.4e1 - t1129 * t326 / 0.4e1 - 0.3e1 / 0.4e1 * t571 * t676 - 0.3e1 / 0.4e1 * t235 * t1497 + 0.2e1 * t107 * t189 * t1496;
  t3484 = -0.9e1 / 0.2e2 * t37 * t596 * t459 + t3340 / 0.32e2 + t3343 + 0.3e1 / 0.32e2 * t3344 + t274 * t1298 / 0.32e2 + t1266 * t286 / 0.32e2 + 0.3e1 / 0.32e2 * t3350 + 0.3e1 / 0.32e2 * t463 * t693 + t3355 + 0.3e1 / 0.16e2 * t3356 + 0.3e1 / 0.32e2 * t180 * t1602 + t3361 / 0.32e2 + t3365 + 0.3e1 / 0.32e2 * t3367 - t62 * (t3417 + t3476) / 0.8e1 + t2921 / 0.192e3 + t2927 / 0.192e3 + t2929 / 0.192e3 + t2933 / 0.192e3;
  t3502 = t2935 / 0.96e2 + 0.3e1 / 0.32e2 * t2937 + 0.3e1 / 0.16e2 * t2939 + 0.3e1 / 0.32e2 * t2941 + t2960 + 0.3e1 / 0.32e2 * t2962 + 0.3e1 / 0.32e2 * t2965 + t2968 / 0.32e2 + t2981 / 0.576e3 + t3002 / 0.32e2 + 0.3e1 / 0.32e2 * t3006 + 0.3e1 / 0.32e2 * t3008 + 0.1232e4 / 0.9e1 * t3013 - 0.88e2 / 0.3e1 * t3015 + 0.8e1 / 0.3e1 * t3017 - t3041 + t3050 + t3052 / 0.192e3 + t3055 / 0.192e3 + t3058 / 0.576e3;
  t3507 = t1392 * t400;
  t3508 = 0.4e1 / 0.3e1 * t3507;
  t3509 = t1395 * t1352;
  t3511 = t598 * t1355;
  t3520 = -t3110 - t3113 - 0.2e1 / 0.9e1 * t3115 + t16 * t12 * (t3267 + t3335 + t3484 + t3502) + t3508 + 0.8e1 / 0.9e1 * t3509 - 0.28e2 / 0.27e2 * t3511 - t3231 * t12 + t2678 / 0.3e1 + t2682 / 0.3e1 - 0.4e1 / 0.3e1 * t2684 - 0.4e1 / 0.3e1 * t2686 - t2690 + t2691 / 0.3e1 + t2693 / 0.9e1 + t2701;
  t3529 = t140 * t1660 * params->d * t130;
  t3530 = t408 * t1666;
  t3531 = t3530 / 0.3e1;
  t3532 = t1332 * t604;
  t3536 = t419 * t762 * t151 * t21;
  t3537 = 0.2e1 / 0.3e1 * t3536;
  t3538 = 0.2e1 / 0.3e1 * t2704 + 0.2e1 / 0.3e1 * t2709 + t2717 + 0.28e2 / 0.9e1 * t2718 + t2722 - 0.8e1 / 0.3e1 * t2724 - t2728 - 0.4e1 / 0.3e1 * t2730 - t2734 + t2737 + 0.28e2 / 0.9e1 * t2739 - t2743 + t3529 + t3531 + t3532 / 0.27e2 + t3537;
  t3542 = t1341 * t332 * t470 * t384;
  t3545 = t135 * t136 * t1660;
  t3546 = t403 * t1666;
  t3547 = 0.4e1 / 0.3e1 * t3546;
  t3548 = t1325 * t604;
  t3551 = t140 * t1671 * t399;
  t3552 = 0.4e1 / 0.3e1 * t3551;
  t3554 = t419 * t1675 * t146;
  t3556 = t1358 * t604;
  t3559 = t140 * t607 * t1204;
  t3565 = 0.2e1 / 0.9e1 * t3542 + t3545 - t3547 - 0.4e1 / 0.9e1 * t3548 - t3552 - 0.8e1 / 0.9e1 * t3554 + 0.28e2 / 0.27e2 * t3556 + 0.28e2 / 0.27e2 * t3559 - 0.8e1 / 0.3e1 * t2746 - t2750 + t2751 / 0.3e1 + t2755 + 0.2e1 / 0.3e1 * t2757 + 0.2e1 / 0.3e1 * t2760 + t2766 + t2769;
  t3567 = t411 * t412 * t1671;
  t3568 = 0.2e1 / 0.3e1 * t3567;
  t3569 = t1364 * t1691;
  t3572 = t1370 * t1371 * t1675;
  t3574 = t1361 * t1691;
  t3582 = -t2772 + t2775 + t3568 + t3569 / 0.9e1 + 0.2e1 / 0.9e1 * t3572 - 0.8e1 / 0.9e1 * t3574 + 0.4e1 / 0.3e1 * t2777 + 0.8e1 / 0.3e1 * t2779 + t2783 - 0.28e2 / 0.9e1 * t2784 - t2788 + t2791 - t2793 / 0.3e1 - 0.2e1 / 0.3e1 * t2796 - 0.2e1 / 0.3e1 * t2799 - t2804;
  tv4rho41 = t2666 + 0.3e1 * t3107 + t118 * (t3520 + t3538 + t3565 + t3582);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t3587 = params->a * t1960;
  t3595 = t1724 * t400;
  t3608 = t3235 / 0.16e2 + t3239 / 0.8e1 + t3241 / 0.8e1 + t3245 / 0.288e3 + t3251 / 0.288e3 + t3255 / 0.144e3 + t3257 / 0.144e3 + t3262 / 0.288e3 + t3265 / 0.144e3 + t3269 / 0.288e3 + t3271 / 0.288e3;
  t3614 = 0.24e2 * t384 - t2674;
  t3617 = t1704 * t158;
  t3619 = t768 * t546;
  t3671 = my_piecewise3(t52, 0, -0.8e2 / 0.81e2 * t2806 * t793 * t451 - 0.64e3 / 0.27e2 * t1436 * t1458 + 0.8e2 / 0.27e2 * t1761 * t454 + 0.32e3 / 0.9e1 * t55 * t2 * t2672 - 0.16e3 / 0.9e1 * t625 * t121 + 0.16e3 / 0.3e1 * t625 * t1094 + 0.8e2 / 0.27e2 * t1108 * t796 * t451 + 0.8e2 / 0.9e1 * t55 * t1769 * t172 + 0.4e2 / 0.9e1 * t1766 * t454 - t3223);
  t3676 = 0.16e2 * t2673;
  t3686 = my_piecewise3(t52, 0, -0.8e1 * t266 * t121 + 0.4e1 * t172 * t1769 + 0.24e2 * t1832 * t384 + 0.2e1 * t454 * t796 - t3453 + t3676);
  t3726 = my_piecewise3(t41, 0, -0.8e2 / 0.81e2 * t2850 * t784 * t442 + 0.64e3 / 0.27e2 * t1482 * t1410 + 0.8e2 / 0.27e2 * t1740 * t446 + 0.32e3 / 0.9e1 * t48 * t2 * t2672 + 0.16e3 / 0.9e1 * t613 * t121 - 0.16e3 / 0.3e1 * t613 * t1094 + 0.8e2 / 0.27e2 * t1144 * t788 * t442 + 0.8e2 / 0.9e1 * t48 * t1750 * t167 + 0.4e2 / 0.9e1 * t1745 * t446 + t3200);
  t3734 = -t3686 * sigma[0] * t108 / 0.4e1 - t1841 * t241 / 0.2e1 - t883 * t584 / 0.4e1 - t1466 * t326 / 0.2e1 - t664 * t676 - t323 * t1497 / 0.2e1 - t571 * t888 / 0.4e1 - t235 * t1784 / 0.2e1 - t107 * t70 * t3726 / 0.4e1 + 0.4e1 / 0.3e1 * t883 * t581 + 0.8e1 / 0.3e1 * t664 * t673;
  t3752 = my_piecewise3(t41, 0, 0.8e1 * t262 * t121 + 0.4e1 * t167 * t1750 - 0.24e2 * t1794 * t384 + 0.2e1 * t446 * t788 + t3389 + t3676);
  t3779 = t488 * t792;
  t3781 = t190 * t1754;
  t3783 = t71 * t3726;
  t3785 = t814 * t458;
  t3787 = t281 * t1450;
  t3789 = t78 * t3671;
  t3791 = -t642 * t654 + 0.4e1 / 0.3e1 * t1841 * t238 - 0.22e2 / 0.9e1 * t883 * t578 - 0.44e2 / 0.9e1 * t323 * t1404 - 0.22e2 / 0.9e1 * t107 * t487 * t792 + 0.176e3 / 0.27e2 * t3779 - 0.32e2 / 0.9e1 * t3781 + 0.2e1 / 0.3e1 * t3783 + 0.176e3 / 0.27e2 * t3785 - 0.32e2 / 0.9e1 * t3787 + 0.2e1 / 0.3e1 * t3789;
  t3796 = t147 * t1858;
  t3799 = t63 * t183 * t1898;
  t3809 = t62 * t3614;
  t3812 = t1902 * t203;
  t3814 = t3273 / 0.144e3 + t3275 / 0.288e3 + t3279 / 0.144e3 + t3281 / 0.144e3 - t22 * (t3614 * t27 / 0.72e2 + t3617 / 0.36e2 + t3619 / 0.72e2 + t3287 / 0.36e2 + t3289 / 0.18e2 + t3291 / 0.36e2 + t3023 / 0.72e2 + t3025 / 0.36e2 + t3034) - t62 * (-t311 * t1451 / 0.2e1 - 0.22e2 / 0.9e1 * t559 * t870 - 0.44e2 / 0.9e1 * t226 * t1819 - 0.22e2 / 0.9e1 * t102 * t813 * t458 + 0.4e1 / 0.3e1 * t559 * t873 + 0.8e1 / 0.3e1 * t226 * t1824 + 0.4e1 / 0.3e1 * t102 * t280 * t1450 - t559 * t876 / 0.4e1 - t226 * t1829 / 0.2e1 - t102 * t77 * t3671 / 0.4e1 + t3734 + 0.8e1 / 0.3e1 * t323 * t1479 + 0.4e1 / 0.3e1 * t235 * t1791 + 0.4e1 / 0.3e1 * t107 * t189 * t1754 - t3752 * sigma[2] * t103 / 0.4e1 - t1803 * t229 / 0.2e1 - t863 * t564 / 0.4e1 + 0.4e1 / 0.3e1 * t1418 * t314 + 0.8e1 / 0.3e1 * t642 * t649 + 0.4e1 / 0.3e1 * t311 * t1429 - t1418 * t317 / 0.2e1 + t3791) / 0.8e1 + 0.16e2 / 0.3e1 * t3796 + t3799 / 0.16e2 + t63 * t65 * (0.88e2 / 0.9e1 * t3779 - 0.16e2 / 0.3e1 * t3781 + t3783 + 0.88e2 / 0.9e1 * t3785 - 0.16e2 / 0.3e1 * t3787 + t3789) / 0.32e2 + t3809 * t96 / 0.576e3 + t3812 / 0.288e3;
  t3826 = t696 * t754;
  t3830 = t274 * t1592;
  t3832 = t274 * t1595;
  t3838 = t180 * t1892;
  t3840 = t1902 * t217 / 0.288e3 - 0.3e1 / 0.2e2 * t37 * t3614 * t58 - 0.3e1 / 0.1e2 * t37 * t1704 * t176 + t1572 * t286 / 0.16e2 + t3826 / 0.8e1 + t696 * t693 / 0.8e1 + t3830 / 0.16e2 + t3832 / 0.8e1 + t274 * t1602 / 0.16e2 + t463 * t821 / 0.32e2 + t3838 / 0.16e2;
  t3844 = t63 * t478 * t820;
  t3870 = t1902 * t184;
  t3874 = t180 * t1899 / 0.16e2 + t3844 / 0.32e2 - 0.3e1 / 0.2e2 * t37 * t768 * t459 - 0.3e1 / 0.1e2 * t37 * t1571 * t270 - 0.3e1 / 0.5e1 * t37 * t596 * t742 - 0.3e1 / 0.1e2 * t37 * t253 * t1565 - 0.3e1 / 0.2e2 * t37 * t387 * t801 - 0.3e1 / 0.1e2 * t37 * t124 * t1936 - 0.3e1 / 0.2e2 * t37 * t7 * (t3726 + t3671) + t3809 * t81 / 0.32e2 + t3870 / 0.16e2 + t1902 * t196 / 0.16e2;
  t3877 = t805 * t479;
  t3879 = t805 * t482;
  t3891 = t3877 / 0.32e2 + t3879 / 0.16e2 + t805 * t496 / 0.32e2 - 0.352e3 / 0.9e1 * t3298 + 0.16e2 / 0.3e1 * t3300 + 0.2464e4 / 0.27e2 * t3302 + t3340 / 0.16e2 + t3342 / 0.8e1 + t3344 / 0.16e2 + t3350 / 0.16e2 + t3354 / 0.8e1;
  t3896 = t433 * t853;
  t3899 = t63 * t508 * t846;
  t3902 = t63 * t202 * t1888;
  t3928 = my_piecewise3(t41, 0, 0.88e3 / 0.81e2 * t1740 * t442 + 0.352e4 / 0.27e2 * t613 * t1410 + 0.44e3 / 0.27e2 * t785 * t446 + 0.704e3 / 0.9e1 * t166 * t2 * t2672 + 0.352e3 / 0.9e1 * t263 * t121 - 0.352e3 / 0.3e1 * t263 * t1094 + 0.44e3 / 0.27e2 * t1745 * t442 + 0.176e3 / 0.9e1 * t1751 * t167 + 0.88e2 / 0.9e1 * t789 * t446 + t3143);
  t3954 = my_piecewise3(t52, 0, 0.88e3 / 0.81e2 * t1761 * t451 - 0.352e4 / 0.27e2 * t625 * t1458 + 0.44e3 / 0.27e2 * t794 * t454 + 0.704e3 / 0.9e1 * t171 * t2 * t2672 - 0.352e3 / 0.9e1 * t267 * t121 + 0.352e3 / 0.3e1 * t267 * t1094 + 0.44e3 / 0.27e2 * t1766 * t451 + 0.176e3 / 0.9e1 * t1770 * t172 + 0.88e2 / 0.9e1 * t797 * t454 - t3169);
  t3960 = t805 * t509;
  t3962 = t805 * t512;
  t3968 = t3356 / 0.8e1 + t3361 / 0.16e2 + t3364 / 0.8e1 + t3367 / 0.16e2 - 0.88e2 / 0.9e1 * t3896 + t3899 / 0.576e3 + t3902 / 0.288e3 + t63 * t84 * (0.88e2 / 0.9e1 * t488 * t833 - 0.16e2 / 0.3e1 * t190 * t1871 + t71 * t3928 + 0.88e2 / 0.9e1 * t814 * t531 - 0.16e2 / 0.3e1 * t281 * t1556 + t78 * t3954) / 0.576e3 + t3960 / 0.576e3 + t3962 / 0.288e3 + t805 * t534 / 0.576e3 + t1572 * t302 / 0.288e3;
  t3970 = t696 * t705;
  t3974 = t274 * t1520;
  t3976 = t274 * t1523;
  t3982 = t180 * t1917;
  t3989 = t3970 / 0.144e3 + t696 * t729 / 0.144e3 + t3974 / 0.288e3 + t3976 / 0.144e3 + t274 * t1559 / 0.288e3 + t463 * t847 / 0.576e3 + t3982 / 0.288e3 + t180 * t1889 / 0.288e3 + t2927 / 0.576e3 + t2933 / 0.288e3 + t2935 / 0.288e3;
  t3999 = t2937 / 0.16e2 + t2939 / 0.16e2 + t2960 + t2962 / 0.16e2 + t2965 / 0.32e2 + t3006 / 0.32e2 + 0.2464e4 / 0.27e2 * t3013 - 0.88e2 / 0.9e1 * t3015 - t3041 + t3050 + t3052 / 0.288e3 + t3055 / 0.576e3;
  t4006 = t1704 * t127 * t131;
  t4009 = t768 * t393 * t395;
  t4016 = -0.2e1 / 0.3e1 * t3110 - 0.8e1 / 0.9e1 * t3112 - 0.4e1 / 0.9e1 * t3115 + 0.16e2 / 0.9e1 * t3507 + 0.16e2 / 0.9e1 * t3509 - 0.56e2 / 0.27e2 * t3511 + 0.4e1 / 0.9e1 * t3595 + t16 * t12 * (t3608 + t3814 + t3840 + t3874 + t3891 + t3968 + t3989 + t3999) - 0.2e1 / 0.3e1 * t4006 - 0.2e1 / 0.9e1 * t4009 - t3614 * t12 - 0.4e1 / 0.9e1 * t2684 - 0.8e1 / 0.9e1 * t2686 - t2690 + t2691 / 0.9e1 + 0.2e1 / 0.27e2 * t2693 + t2701;
  t4029 = 0.2e1 / 0.9e1 * t2704 + 0.4e1 / 0.9e1 * t2709 + t2717 + 0.56e2 / 0.27e2 * t2718 + t2722 - 0.16e2 / 0.9e1 * t2724 - t2728 - 0.4e1 / 0.9e1 * t2730 - t2734 + t2737 + 0.56e2 / 0.27e2 * t2739 - t2743 + 0.2e1 / 0.3e1 * t3529 + 0.4e1 / 0.9e1 * t3530 + 0.2e1 / 0.27e2 * t3532 + 0.8e1 / 0.9e1 * t3536 + 0.4e1 / 0.9e1 * t3542 + 0.2e1 / 0.3e1 * t3545;
  t4038 = t135 * t136 * t1956;
  t4040 = t408 * t1706;
  t4044 = t140 * t1956 * params->d * t130;
  t4048 = t419 * t894 * t151 * t21;
  t4050 = t403 * t1706;
  t4053 = t140 * t1709 * t399;
  t4059 = -0.16e2 / 0.9e1 * t3546 - 0.8e1 / 0.9e1 * t3548 - 0.16e2 / 0.9e1 * t3551 - 0.16e2 / 0.9e1 * t3554 + 0.56e2 / 0.27e2 * t3556 + 0.56e2 / 0.27e2 * t3559 + 0.2e1 / 0.3e1 * t4038 + t4040 / 0.9e1 + 0.2e1 / 0.3e1 * t4044 + 0.2e1 / 0.9e1 * t4048 - 0.4e1 / 0.9e1 * t4050 - 0.4e1 / 0.9e1 * t4053 - 0.16e2 / 0.9e1 * t2746 - t2750 + 0.2e1 / 0.9e1 * t2751 + t2755 + 0.2e1 / 0.9e1 * t2757 + 0.4e1 / 0.9e1 * t2760;
  t4065 = t411 * t412 * t1709;
  t4072 = t2766 + t2769 - t2772 + t2775 + 0.8e1 / 0.9e1 * t3567 + 0.2e1 / 0.9e1 * t3569 + 0.4e1 / 0.9e1 * t3572 - 0.16e2 / 0.9e1 * t3574 + 0.2e1 / 0.9e1 * t4065 + 0.4e1 / 0.9e1 * t2777 + 0.16e2 / 0.9e1 * t2779 + t2783 - 0.56e2 / 0.27e2 * t2784 - t2788 + t2791 - 0.2e1 / 0.9e1 * t2796 - 0.4e1 / 0.9e1 * t2799 - t2804;
  tv4rho42 = 0.2e1 * t3107 + 0.2e1 * t3587 + t118 * (t4016 + t4029 + t4059 + t4072);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4077 = params->a * t2143;
  t4080 = t1971 * t127 * t131;
  t4082 = t190 * t1999;
  t4091 = t121 * t788;
  t4101 = 0.12e2 * t384 + 0.24e2 * t2669;
  t4105 = my_piecewise3(t41, 0, -0.8e2 / 0.81e2 * t2850 * t1989 * t167 + 0.16e3 / 0.9e1 * t1740 * t381 + 0.8e2 / 0.9e1 * t1482 * t1797 + 0.8e2 / 0.3e1 * t1485 * t4091 + 0.4e2 / 0.3e1 * t613 * t1750 + 0.4e2 / 0.9e1 * t48 * t1995 * t167 + 0.8e1 / 0.3e1 * t166 * t4101);
  t4106 = t71 * t4105;
  t4108 = t2018 * t175;
  t4110 = t814 * t632;
  t4112 = t281 * t1773;
  t4121 = t121 * t796;
  t4129 = -t4101;
  t4133 = my_piecewise3(t52, 0, -0.8e2 / 0.81e2 * t2806 * t2006 * t172 - 0.16e3 / 0.9e1 * t1761 * t381 + 0.8e2 / 0.9e1 * t1436 * t1835 - 0.8e2 / 0.3e1 * t1439 * t4121 + 0.4e2 / 0.3e1 * t625 * t1769 + 0.4e2 / 0.9e1 * t55 * t2011 * t172 + 0.8e1 / 0.3e1 * t171 * t4129);
  t4134 = t78 * t4133;
  t4165 = -0.16e2 / 0.9e1 * t4082 + 0.2e1 / 0.3e1 * t4106 - 0.2464e4 / 0.81e2 * t4108 + 0.176e3 / 0.9e1 * t4110 - 0.16e2 / 0.3e1 * t4112 + 0.2e1 / 0.3e1 * t4134 + 0.2e1 / 0.3e1 * t2051 * t238 + 0.2e1 * t883 * t673 + 0.2e1 * t323 * t1791 + 0.2e1 / 0.3e1 * t107 * t189 * t1999 - 0.3e1 / 0.4e1 * t863 * t654 + 0.4e1 * t642 * t873 + 0.4e1 * t311 * t1824 - 0.3e1 / 0.4e1 * t642 * t876 - 0.3e1 / 0.4e1 * t311 * t1829 - 0.22e2 / 0.3e1 * t226 * t2036 - 0.22e2 / 0.3e1 * t102 * t813 * t632 + 0.2e1 * t226 * t2039 + 0.2e1 * t102 * t280 * t1773;
  t4180 = my_piecewise3(t52, 0, 0.2e1 * t172 * t2011 + 0.6e1 * t266 * t1769 - 0.12e2 * t381 * t796 + 0.2e1 * t51 * t4129);
  t4221 = my_piecewise3(t41, 0, 0.2e1 * t167 * t1995 + 0.6e1 * t262 * t1750 + 0.12e2 * t381 * t788 + 0.2e1 * t40 * t4101);
  t4229 = -t226 * t2042 / 0.4e1 - t102 * t77 * t4133 / 0.4e1 - t4180 * sigma[0] * t108 / 0.4e1 - t2051 * t241 / 0.4e1 - 0.3e1 / 0.4e1 * t1841 * t326 - 0.3e1 / 0.4e1 * t883 * t676 - 0.3e1 / 0.4e1 * t664 * t888 - 0.3e1 / 0.4e1 * t323 * t1784 - t235 * t2058 / 0.4e1 - t107 * t70 * t4105 / 0.4e1 + 0.2e1 * t1803 * t314 + 0.2e1 * t863 * t649 - 0.22e2 / 0.3e1 * t642 * t870 - 0.22e2 / 0.3e1 * t311 * t1819 + 0.308e3 / 0.27e2 * t226 * t1986 + 0.308e3 / 0.27e2 * t102 * t1985 * t175 - t4221 * sigma[2] * t103 / 0.4e1 - t2027 * t229 / 0.4e1 - 0.3e1 / 0.4e1 * t1803 * t317;
  t4252 = my_piecewise3(t41, 0, 0.88e3 / 0.81e2 * t1990 * t167 + 0.88e3 / 0.9e1 * t785 * t381 + 0.44e3 / 0.9e1 * t613 * t1797 + 0.176e3 / 0.3e1 * t616 * t4091 + 0.88e2 / 0.3e1 * t263 * t1750 + 0.88e2 / 0.9e1 * t1996 * t167 + 0.11e2 / 0.3e1 * t49 * t4101);
  t4275 = my_piecewise3(t52, 0, 0.88e3 / 0.81e2 * t2007 * t172 - 0.88e3 / 0.9e1 * t794 * t381 + 0.44e3 / 0.9e1 * t625 * t1835 - 0.176e3 / 0.3e1 * t628 * t4121 + 0.88e2 / 0.3e1 * t267 * t1769 + 0.88e2 / 0.9e1 * t2012 * t172 + 0.11e2 / 0.3e1 * t56 * t4129);
  t4281 = -t3230 - t2674;
  t4307 = t62 * t4281;
  t4310 = t2114 * t184;
  t4312 = -t62 * (t4165 + t4229) / 0.8e1 + t3240 + t3256 + t3262 / 0.192e3 + t3266 + t3271 / 0.192e3 + t3274 + t63 * t84 * (-0.8e1 / 0.3e1 * t190 * t2079 + t71 * t4252 - 0.1232e4 / 0.27e2 * t2018 * t214 + 0.88e2 / 0.3e1 * t814 * t726 - 0.8e1 * t281 * t1886 + t78 * t4275) / 0.576e3 + t3280 - 0.3e1 / 0.2e2 * t37 * t4281 * t58 - 0.3e1 / 0.2e2 * t37 * t1971 * t176 - 0.9e1 / 0.2e2 * t37 * t1704 * t270 - 0.9e1 / 0.2e2 * t37 * t768 * t742 - 0.9e1 / 0.2e2 * t37 * t596 * t801 - 0.9e1 / 0.2e2 * t37 * t253 * t1936 - 0.3e1 / 0.2e2 * t37 * t124 * t2110 - 0.3e1 / 0.2e2 * t37 * t7 * (t4105 + t4133) + t4307 * t81 / 0.32e2 + t4310 / 0.32e2;
  t4316 = t63 * t202 * t2096;
  t4318 = t147 * t2068;
  t4324 = t63 * t183 * t2124;
  t4336 = t2114 * t203;
  t4342 = t805 * t705;
  t4348 = t274 * t1917;
  t4356 = t805 * t754;
  t4358 = t180 * t2097 / 0.576e3 + t4316 / 0.576e3 + 0.8e1 / 0.3e1 * t4318 + 0.8e1 * t3796 + t180 * t2125 / 0.32e2 + t4324 / 0.32e2 + t63 * t65 * (-0.8e1 / 0.3e1 * t4082 + t4106 - 0.1232e4 / 0.27e2 * t4108 + 0.88e2 / 0.3e1 * t4110 - 0.8e1 * t4112 + t4134) / 0.32e2 + t4307 * t96 / 0.576e3 + t4336 / 0.576e3 + t2114 * t217 / 0.576e3 + t1902 * t302 / 0.192e3 + t4342 / 0.192e3 + t805 * t729 / 0.192e3 + t696 * t847 / 0.192e3 + t4348 / 0.192e3 + t274 * t1889 / 0.192e3 + t2114 * t196 / 0.32e2 + 0.3e1 / 0.32e2 * t1902 * t286 + 0.3e1 / 0.32e2 * t4356;
  t4364 = t274 * t1892;
  t4380 = 0.3e1 / 0.32e2 * t805 * t693 + 0.3e1 / 0.32e2 * t696 * t821 + 0.3e1 / 0.32e2 * t4364 + 0.3e1 / 0.32e2 * t274 * t1899 + 0.3e1 / 0.32e2 * t3799 + t3812 / 0.192e3 + 0.3e1 / 0.16e2 * t3826 + 0.3e1 / 0.16e2 * t3830 + 0.3e1 / 0.16e2 * t3832 + 0.3e1 / 0.32e2 * t3838 + 0.3e1 / 0.32e2 * t3844 + 0.3e1 / 0.32e2 * t3870 + 0.3e1 / 0.32e2 * t3877 + 0.3e1 / 0.32e2 * t3879 - t3299 + 0.1232e4 / 0.9e1 * t3302 + 0.3e1 / 0.32e2 * t3340 + t3343 + t3355;
  t4385 = t1971 * t158;
  t4406 = 0.3e1 / 0.32e2 * t3361 + t3365 - 0.88e2 / 0.3e1 * t3896 - t22 * (t4281 * t27 / 0.72e2 + t4385 / 0.72e2 + t3617 / 0.24e2 + t3619 / 0.24e2 + t3290 + t3291 / 0.24e2 + t3025 / 0.72e2 + t3034) + t3899 / 0.192e3 + t3902 / 0.192e3 + t3960 / 0.192e3 + t3962 / 0.192e3 + t3970 / 0.96e2 + t3974 / 0.96e2 + t3976 / 0.96e2 + t3982 / 0.192e3 + t2933 / 0.576e3 + t2937 / 0.32e2 + t2960 + t2962 / 0.32e2 + 0.1232e4 / 0.27e2 * t3013 - t3041 + t3050 + t3052 / 0.576e3;
  t4419 = -t3113 - 0.2e1 / 0.3e1 * t3115 - t4080 / 0.3e1 + t16 * t12 * (t4312 + t4358 + t4380 + t4406) + t3508 + 0.8e1 / 0.3e1 * t3509 - 0.28e2 / 0.9e1 * t3511 + 0.4e1 / 0.3e1 * t3595 - t4006 - 0.2e1 / 0.3e1 * t4009 - t4281 * t12 - 0.4e1 / 0.9e1 * t2686 - t2690 + t2693 / 0.27e2 + t2701 + 0.2e1 / 0.9e1 * t2709;
  t4426 = t2717 + 0.28e2 / 0.27e2 * t2718 + t2722 - 0.8e1 / 0.9e1 * t2724 - t2728 - t2734 + t2737 + 0.28e2 / 0.27e2 * t2739 - t2743 + t3531 + t3532 / 0.9e1 + t3537 + 0.2e1 / 0.3e1 * t3542 - t3547 - 0.4e1 / 0.3e1 * t3548 - t3552;
  t4436 = t135 * t136 * t2139;
  t4440 = t140 * t2139 * params->d * t130;
  t4445 = -0.8e1 / 0.3e1 * t3554 + 0.28e2 / 0.9e1 * t3556 + 0.28e2 / 0.9e1 * t3559 + t4038 + t4040 / 0.3e1 + t4044 + 0.2e1 / 0.3e1 * t4048 - 0.4e1 / 0.3e1 * t4050 - 0.4e1 / 0.3e1 * t4053 + t4436 / 0.3e1 + t4440 / 0.3e1 - 0.8e1 / 0.9e1 * t2746 - t2750 + t2751 / 0.9e1 + t2755 + 0.2e1 / 0.9e1 * t2760;
  t4453 = t2766 + t2769 - t2772 + t2775 + t3568 + t3569 / 0.3e1 + 0.2e1 / 0.3e1 * t3572 - 0.8e1 / 0.3e1 * t3574 + 0.2e1 / 0.3e1 * t4065 + 0.8e1 / 0.9e1 * t2779 + t2783 - 0.28e2 / 0.27e2 * t2784 - t2788 + t2791 - 0.2e1 / 0.9e1 * t2799 - t2804;
  tv4rho43 = 0.3e1 * t3587 + t4077 + t118 * (t4419 + t4426 + t4445 + t4453);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4459 = -t2668 - t2670 - t2674;
  t4486 = t3262 / 0.144e3 + t3271 / 0.144e3 + t4310 / 0.8e1 + t4316 / 0.144e3 + 0.32e2 / 0.3e1 * t4318 + t4324 / 0.8e1 + t4336 / 0.144e3 + t4342 / 0.48e2 + t4348 / 0.48e2 + 0.3e1 / 0.8e1 * t4356 + 0.3e1 / 0.8e1 * t4364 + 0.3e1 / 0.8e1 * t3830 + 0.3e1 / 0.16e2 * t3844 + 0.3e1 / 0.16e2 * t3877 + 0.4928e4 / 0.27e2 * t3302 + t3340 / 0.8e1 + t3361 / 0.8e1 - 0.176e3 / 0.3e1 * t3896 + t3899 / 0.96e2 + t3960 / 0.96e2;
  t4497 = t788 * t788;
  t4502 = 0.24e2 * t384 + 0.24e2 * t2669;
  t4506 = my_piecewise3(t41, 0, 0.8e1 * t262 * t1995 + 0.2e1 * t40 * t4502 + 0.6e1 * t4497);
  t4522 = t793 * t793;
  t4527 = t796 * t796;
  t4532 = -t4502;
  t4536 = my_piecewise3(t52, 0, -0.8e2 / 0.81e2 * t2806 * t4522 + 0.16e3 / 0.9e1 * t1761 * t796 + 0.4e2 / 0.3e1 * t55 * t4527 + 0.16e3 / 0.9e1 * t625 * t2011 + 0.8e1 / 0.3e1 * t171 * t4532);
  t4546 = my_piecewise3(t52, 0, 0.8e1 * t266 * t2011 + 0.2e1 * t51 * t4532 + 0.6e1 * t4527);
  t4550 = 0.8e1 / 0.3e1 * t2027 * t314 + 0.8e1 * t863 * t873 - 0.88e2 / 0.3e1 * t311 * t2036 + 0.1232e4 / 0.27e2 * t102 * t1985 * t269 - t4506 * sigma[2] * t103 / 0.4e1 - t2027 * t317 - 0.3e1 / 0.2e1 * t863 * t876 + 0.8e1 * t311 * t2039 - t311 * t2042 - 0.44e2 / 0.3e1 * t102 * t813 * t800 + 0.8e1 / 0.3e1 * t102 * t280 * t2015 - t102 * t77 * t4536 / 0.4e1 - t4546 * sigma[0] * t108 / 0.4e1;
  t4555 = t784 * t784;
  t4567 = my_piecewise3(t41, 0, -0.8e2 / 0.81e2 * t2850 * t4555 + 0.16e3 / 0.9e1 * t1740 * t788 + 0.4e2 / 0.3e1 * t48 * t4497 + 0.16e3 / 0.9e1 * t613 * t1995 + 0.8e1 / 0.3e1 * t166 * t4502);
  t4577 = 0.1e1 / t75 / t811 / t73;
  t4581 = t71 * t4567;
  t4583 = sigma[2] * t4577;
  t4584 = t4583 * t57;
  t4586 = t2018 * t269;
  t4588 = t814 * t800;
  t4590 = t281 * t2015;
  t4592 = t78 * t4536;
  t4594 = -t2051 * t326 - 0.3e1 / 0.2e1 * t883 * t888 - t323 * t2058 - t107 * t70 * t4567 / 0.4e1 - 0.44e2 / 0.3e1 * t863 * t870 + 0.1232e4 / 0.27e2 * t311 * t1986 - 0.5236e4 / 0.81e2 * t102 * t4577 * t57 + 0.2e1 / 0.3e1 * t4581 + 0.41888e5 / 0.243e3 * t4584 - 0.9856e4 / 0.81e2 * t4586 + 0.352e3 / 0.9e1 * t4588 - 0.64e2 / 0.9e1 * t4590 + 0.2e1 / 0.3e1 * t4592;
  t4614 = t62 * t4459;
  t4651 = my_piecewise3(t41, 0, 0.88e3 / 0.81e2 * t1144 * t4555 + 0.88e3 / 0.9e1 * t785 * t788 + 0.88e2 / 0.3e1 * t166 * t4497 + 0.352e3 / 0.9e1 * t263 * t1995 + 0.11e2 / 0.3e1 * t49 * t4502);
  t4672 = my_piecewise3(t52, 0, 0.88e3 / 0.81e2 * t1108 * t4522 + 0.88e3 / 0.9e1 * t794 * t796 + 0.88e2 / 0.3e1 * t171 * t4527 + 0.352e3 / 0.9e1 * t267 * t2011 + 0.11e2 / 0.3e1 * t56 * t4532);
  t4685 = 0.3e1 / 0.16e2 * t805 * t821 + t274 * t2125 / 0.8e1 + t63 * t65 * (t4581 + 0.20944e5 / 0.81e2 * t4584 - 0.4928e4 / 0.27e2 * t4586 + 0.176e3 / 0.3e1 * t4588 - 0.32e2 / 0.3e1 * t4590 + t4592) / 0.32e2 + t4614 * t96 / 0.576e3 + t2114 * t302 / 0.144e3 + t805 * t847 / 0.96e2 + t274 * t2097 / 0.144e3 + t63 * t84 * (t71 * t4651 + 0.20944e5 / 0.81e2 * t4583 * t93 - 0.4928e4 / 0.27e2 * t2018 * t299 + 0.176e3 / 0.3e1 * t814 * t844 - 0.32e2 / 0.3e1 * t281 * t2094 + t78 * t4672) / 0.576e3 - t22 * (t4459 * t27 / 0.72e2 + t4385 / 0.18e2 + t3619 / 0.12e2 + t3291 / 0.18e2 + t3034) - t3041 + t3050;
  t4696 = t2717 + t2722 - t2728 - t2734 + t2737 - t2743 + 0.4e1 / 0.27e2 * t3532 + 0.8e1 / 0.9e1 * t3542 - 0.16e2 / 0.9e1 * t3548 - 0.32e2 / 0.9e1 * t3554 + 0.112e3 / 0.27e2 * t3556;
  t4710 = t2769 - t2772 + t2775 + 0.4e1 / 0.9e1 * t3569 + 0.8e1 / 0.9e1 * t3572 - 0.32e2 / 0.9e1 * t3574 + 0.4e1 / 0.3e1 * t4065 + t2783 - t2788 + t2791 - t2804;
  tv4rho44 = 0.4e1 * t4077 + t118 * (-0.8e1 / 0.9e1 * t3115 - t4459 * t12 - 0.4e1 / 0.3e1 * t4080 + 0.32e2 / 0.9e1 * t3509 - 0.112e3 / 0.27e2 * t3511 + 0.8e1 / 0.3e1 * t3595 - 0.4e1 / 0.3e1 * t4009 + t16 * t12 * (t4486 + t3974 / 0.48e2 - t62 * (t4550 + t4594) / 0.8e1 + t2960 - 0.3e1 / 0.2e2 * t37 * t4459 * t58 - 0.3e1 / 0.5e1 * t37 * t1971 * t270 - 0.9e1 / 0.1e2 * t37 * t768 * t801 - 0.3e1 / 0.5e1 * t37 * t253 * t2110 - 0.3e1 / 0.2e2 * t37 * t7 * (t4567 + t4536) + t4614 * t81 / 0.32e2 + t2114 * t286 / 0.8e1 + t4685) - t2690 + t2701 + t4696 + 0.112e3 / 0.27e2 * t3559 + 0.2e1 / 0.3e1 * t4040 + 0.4e1 / 0.3e1 * t4048 - 0.8e1 / 0.3e1 * t4050 - 0.8e1 / 0.3e1 * t4053 + 0.4e1 / 0.3e1 * t4436 + 0.4e1 / 0.3e1 * t4440 - t2750 + t2755 + t2766 + t4710);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4714 = t399 * t15;
  t4717 = 0.8e1 / 0.27e2 * t2145 * t4714 * t904;
  t4719 = t899 * params->c * t21;
  t4721 = 0.2e1 / 0.9e1 * t4719 * t909;
  t4724 = 0.8e1 / 0.27e2 * t2150 * t2151 * t400;
  t4725 = t961 * t407;
  t4727 = t4725 * t909 / 0.9e1;
  t4728 = t2161 * t2173;
  t4730 = t961 * t134;
  t4732 = 0.2e1 / 0.9e1 * t4730 * t2169;
  t4733 = t21 * t1210;
  t4762 = -0.2464e4 / 0.81e2 * t1162 + 0.176e3 / 0.9e1 * t1138 - 0.16e2 / 0.3e1 * t1141 + 0.2e1 / 0.3e1 * t1155 - t1128 * t70 * t50 / 0.4e1 + 0.2e1 * t570 * t189 * t50 - 0.3e1 / 0.4e1 * t2243 * t170 - 0.22e2 / 0.3e1 * t234 * t487 * t50 + 0.4e1 * t2246 * t170 - 0.3e1 / 0.4e1 * t943 * t450 + 0.308e3 / 0.27e2 * t106 * t1088 * t50 - 0.22e2 / 0.3e1 * t2251 * t170 + 0.2e1 * t946 * t450 - t348 * t1154 / 0.4e1;
  t4765 = t432 * t161;
  t4766 = 0.88e2 / 0.3e1 * t4765;
  t4767 = t146 * t549;
  t4768 = 0.8e1 * t4767;
  t4770 = 0.1232e4 / 0.27e2 * t1213 * t30;
  t4776 = t63 * t1284 * t70 * t50 / 0.32e2;
  t4778 = t63 * t2202 * t170;
  t4781 = t63 * t917 * t450;
  t4789 = -t4733 - t62 * t4762 / 0.8e1 - t4766 + t4768 + t4770 + 0.3e1 / 0.32e2 * t180 * t2213 + t4776 + 0.3e1 / 0.32e2 * t4778 + 0.3e1 / 0.32e2 * t4781 - t63 * t921 * t450 / 0.4e1 + t63 * t339 * t1154 / 0.32e2;
  t4792 = t463 * t931;
  t4796 = t180 * t2223;
  t4798 = t180 * t2226;
  t4805 = t63 * t1221 * t70 * t89 / 0.576e3;
  t4807 = t63 * t2222 * t210;
  t4810 = t63 * t930 * t524;
  t4818 = t1266 * t344 / 0.576e3 + t4792 / 0.192e3 + t463 * t938 / 0.192e3 + t4796 / 0.192e3 + t4798 / 0.96e2 + t180 * t2232 / 0.192e3 + t4805 + t4807 / 0.192e3 + t4810 / 0.192e3 - t63 * t934 * t524 / 0.72e2 + t63 * t343 * t1244 / 0.576e3;
  t4824 = t63 * t183 * t487 * t50;
  t4834 = t63 * t202 * t487 * t89;
  t4842 = t180 * t2179;
  t4848 = t63 * t478 * t189 * t50;
  t4851 = t63 * t2178 * t170;
  t4853 = 0.11e2 / 0.12e2 * t180 * t2183 + 0.11e2 / 0.12e2 * t4824 - 0.77e2 / 0.54e2 * t63 * t65 * t1088 * t50 + 0.11e2 / 0.216e3 * t180 * t2193 + 0.11e2 / 0.216e3 * t4834 - 0.77e2 / 0.972e3 * t63 * t84 * t1088 * t89 - t463 * t922 / 0.4e1 - t4842 / 0.2e1 - t180 * t2209 / 0.2e1 - t4848 / 0.4e1 - t4851 / 0.2e1;
  t4859 = t180 * t2189;
  t4865 = t63 * t508 * t189 * t89;
  t4868 = t63 * t2188 * t210;
  t4875 = t463 * t918;
  t4879 = t180 * t2203;
  t4881 = t180 * t2206;
  t4883 = 0.11e2 / 0.12e2 * t63 * t2182 * t170 - t463 * t935 / 0.72e2 - t4859 / 0.36e2 - t180 * t2229 / 0.36e2 - t4865 / 0.72e2 - t4868 / 0.36e2 + 0.11e2 / 0.216e3 * t63 * t2192 * t210 + t1266 * t340 / 0.32e2 + 0.3e1 / 0.32e2 * t4875 + 0.3e1 / 0.32e2 * t463 * t925 + 0.3e1 / 0.32e2 * t4879 + 0.3e1 / 0.16e2 * t4881;
  t4888 = t899 * t2263;
  t4891 = t2145 * t2146 * t2164;
  t4893 = t899 * t406;
  t4894 = t21 * t15;
  t4897 = t4893 * t4894 * t904 / 0.9e1;
  t4900 = t2150 * t127 * t954 * t131;
  t4905 = 0.2e1 / 0.9e1 * t2150 * t393 * t354 * t395;
  t4907 = t357 * t2157 * t2164;
  t4909 = t1330 * t15;
  t4912 = t962 * t4909 * t904 / 0.27e2;
  t4915 = t902 * t903 * t12 * t2262;
  t4918 = t357 * t1371 * t954 * t151;
  t4923 = 0.2e1 / 0.9e1 * t962 * t2763 * t354 * t470;
  t4926 = t902 * t412 * t2262 * params->d;
  tv4rho3sigma0 = -t4717 - t4721 - t4724 + t4727 + 0.2e1 / 0.3e1 * t4728 + t4732 + t337 * t136 * (t4789 + t4818 + t4853 + t4883) + 0.3e1 * t4888 + 0.2e1 / 0.3e1 * t4891 - t4897 + 0.2e1 / 0.3e1 * t4900 - t4905 + t4907 / 0.3e1 + t4912 + t4915 + 0.2e1 / 0.3e1 * t4918 + t4923 + t4926;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t4927 = t2698 * params->a;
  t4930 = 0.4e1 * t4927 * t134 * t968;
  t4931 = t1213 * params->a;
  t4934 = 0.2e1 / 0.9e1 * t4931 * t407 * t968;
  t4935 = t2282 * t2294;
  t4939 = 0.4e1 / 0.9e1 * t4931 * t134 * t2290;
  t4940 = t2266 * t971;
  t4942 = t958 * t2297;
  t4950 = 0.88e3 / 0.27e2 * t432 * params->a * params->b * t358;
  t4952 = t1183 * params->a * params->b;
  t4954 = 0.416e3 / 0.27e2 * t4952 * t964;
  t4956 = 0.416e3 / 0.27e2 * t4952 * t968;
  t4957 = t2270 * t2286;
  t4959 = t4927 * params->b;
  t4961 = 0.2e1 * t4959 * t2279;
  t4962 = t2270 * t2294;
  t4965 = 0.4e1 * t4959 * t2290;
  t4967 = t2278 * t2157 * t2285;
  t4969 = t4931 * params->b;
  t4972 = 0.2e1 / 0.27e2 * t4969 * t4909 * t963;
  t4975 = t962 * t903 * t12 * t549;
  t4979 = t2278 * t1371 * t161 * t151;
  t4984 = 0.4e1 / 0.9e1 * t4969 * t2763 * t30 * t470;
  t4987 = t962 * t412 * t549 * params->d;
  tv4rho3sigma1 = t4930 - t4934 - 0.4e1 / 0.3e1 * t4935 - t4939 - 0.8e2 / 0.3e1 * t4940 + 0.1e2 * t4942 - 0.2e1 * t357 * t136 * t1210 + t4950 - t4954 - t4956 + 0.28e2 / 0.3e1 * t4957 + t4961 + 0.28e2 / 0.3e1 * t4962 + t4965 - 0.2e1 / 0.3e1 * t4967 - t4972 - 0.2e1 * t4975 - 0.4e1 / 0.3e1 * t4979 - t4984 - 0.2e1 * t4987;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t4991 = 0.8e1 / 0.27e2 * t2145 * t4714 * t975;
  t4993 = 0.2e1 / 0.9e1 * t4719 * t980;
  t4996 = 0.8e1 / 0.27e2 * t2150 * t2303 * t400;
  t4998 = t4725 * t980 / 0.9e1;
  t4999 = t2161 * t2323;
  t5002 = 0.2e1 / 0.9e1 * t4730 * t2319;
  t5018 = t463 * t995;
  t5022 = t180 * t2349;
  t5024 = t180 * t2352;
  t5031 = t63 * t1221 * t77 * t93 / 0.576e3;
  t5032 = -t62 * (0.2e1 / 0.3e1 * t1120 - t1100 * t77 * t57 / 0.4e1 - 0.3e1 / 0.4e1 * t2359 * t175 - 0.3e1 / 0.4e1 * t1002 * t458 - t370 * t1119 / 0.4e1) / 0.8e1 - t4733 - t4766 + t4768 + t4770 + t1266 * t366 / 0.576e3 + t5018 / 0.192e3 + t463 * t998 / 0.192e3 + t5022 / 0.192e3 + t5024 / 0.96e2 + t180 * t2355 / 0.192e3 + t5031;
  t5034 = t63 * t2348 * t214;
  t5037 = t63 * t994 * t531;
  t5042 = t180 * t2333;
  t5044 = t180 * t2336;
  t5051 = t63 * t1284 * t77 * t57 / 0.32e2;
  t5053 = t63 * t2332 * t175;
  t5056 = t63 * t985 * t458;
  t5065 = t463 * t986;
  t5067 = t5034 / 0.192e3 + t5037 / 0.192e3 + t63 * t365 * t1253 / 0.576e3 + 0.3e1 / 0.32e2 * t5042 + 0.3e1 / 0.16e2 * t5044 + 0.3e1 / 0.32e2 * t180 * t2339 + t5051 + 0.3e1 / 0.32e2 * t5053 + 0.3e1 / 0.32e2 * t5056 + t63 * t361 * t1119 / 0.32e2 + 0.3e1 / 0.32e2 * t463 * t989 + t1266 * t362 / 0.32e2 + 0.3e1 / 0.32e2 * t5065;
  t5071 = t899 * t2370;
  t5074 = t2145 * t2146 * t2314;
  t5078 = t4893 * t4894 * t975 / 0.9e1;
  t5081 = t2150 * t127 * t1010 * t131;
  t5086 = 0.2e1 / 0.9e1 * t2150 * t393 * t376 * t395;
  t5088 = t357 * t2157 * t2314;
  t5092 = t962 * t4909 * t975 / 0.27e2;
  t5095 = t902 * t903 * t12 * t2369;
  t5098 = t357 * t1371 * t1010 * t151;
  t5103 = 0.2e1 / 0.9e1 * t962 * t2763 * t376 * t470;
  t5106 = t902 * t412 * t2369 * params->d;
  tv4rho3sigma2 = -t4991 - t4993 - t4996 + t4998 + 0.2e1 / 0.3e1 * t4999 + t5002 + t337 * t136 * (t5032 + t5067) + 0.3e1 * t5071 + 0.2e1 / 0.3e1 * t5074 - t5078 + 0.2e1 / 0.3e1 * t5081 - t5086 + t5088 / 0.3e1 + t5092 + t5095 + 0.2e1 / 0.3e1 * t5098 + t5103 + t5106;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5108 = 0.2e1 * t899 * t2453;
  t5111 = t2150 * t127 * t1033 * t131;
  t5116 = 0.2e1 / 0.3e1 * t902 * t903 * t12 * t2452;
  t5118 = t357 * t2157 * t2375;
  t5123 = 0.2e1 / 0.3e1 * t902 * t412 * t2452 * params->d;
  t5126 = t357 * t1371 * t1033 * t151;
  t5129 = t2145 * t2146 * t2375;
  t5133 = t5108 + t4888 + 0.2e1 / 0.9e1 * t5111 + t5116 + t5118 / 0.9e1 + t5123 + 0.2e1 / 0.9e1 * t5126 + 0.2e1 / 0.9e1 * t5129 - t4717 - t4724 + 0.4e1 / 0.9e1 * t4891 - t4897 + 0.4e1 / 0.9e1 * t4900;
  t5139 = t2161 * t2380;
  t5141 = 0.176e3 / 0.9e1 * t4765;
  t5142 = 0.8e1 / 0.3e1 * t4767;
  t5145 = t63 * t930 * t716 / 0.288e3;
  t5152 = t274 * t2179 / 0.6e1;
  t5159 = t63 * t2178 * t265 / 0.6e1;
  t5166 = t274 * t2189 / 0.108e3;
  t5173 = t63 * t2188 * t293 / 0.108e3;
  t5177 = -t5141 + t5142 + t5145 + t63 * t343 * t1541 / 0.576e3 - t696 * t922 / 0.6e1 - t5152 - t274 * t2209 / 0.6e1 - t180 * t2424 / 0.6e1 - t5159 - t63 * t921 * t620 / 0.6e1 - t696 * t935 / 0.108e3 - t5166 - t274 * t2229 / 0.108e3 - t180 * t2429 / 0.108e3 - t5173 - t63 * t934 * t716 / 0.108e3;
  t5181 = t696 * t918 / 0.16e2;
  t5184 = t274 * t2203;
  t5187 = t274 * t2206 / 0.16e2;
  t5193 = t180 * t2441 / 0.16e2;
  t5197 = t63 * t2202 * t265;
  t5201 = t63 * t917 * t620 / 0.16e2;
  t5208 = t696 * t931 / 0.288e3;
  t5211 = t274 * t2223;
  t5214 = t274 * t2226 / 0.288e3;
  t5215 = t1572 * t340 / 0.32e2 + t5181 + t696 * t925 / 0.16e2 + t5184 / 0.32e2 + t5187 + t274 * t2213 / 0.32e2 + t463 * t1016 / 0.32e2 + t5193 + t180 * t2405 / 0.16e2 + t5197 / 0.32e2 + t5201 + t63 * t339 * t1496 / 0.32e2 + t1572 * t344 / 0.576e3 + t5208 + t696 * t938 / 0.288e3 + t5211 / 0.576e3 + t5214;
  t5222 = t180 * t2416 / 0.288e3;
  t5226 = t63 * t2222 * t293;
  t5228 = t21 * t1641;
  t5259 = 0.176e3 / 0.27e2 * t1404 - 0.32e2 / 0.9e1 * t1479 + 0.2e1 / 0.3e1 * t1497 - t1465 * t70 * t50 / 0.4e1 + 0.4e1 / 0.3e1 * t663 * t189 * t50 - t2386 * t170 / 0.2e1 - 0.22e2 / 0.9e1 * t322 * t487 * t50 + 0.4e1 / 0.3e1 * t2389 * t170 - t1025 * t450 / 0.4e1 - t2243 * t265 / 0.4e1 + 0.4e1 / 0.3e1 * t2246 * t265 - t943 * t620 / 0.2e1 - 0.22e2 / 0.9e1 * t2251 * t265 + 0.4e1 / 0.3e1 * t946 * t620 - t348 * t1496 / 0.4e1;
  t5263 = 0.16e2 / 0.3e1 * t146 * t685;
  t5264 = t432 * t257;
  t5265 = 0.88e2 / 0.9e1 * t5264;
  t5278 = t274 * t2232 / 0.576e3 + t463 * t1021 / 0.576e3 + t5222 + t180 * t2419 / 0.288e3 + t5226 / 0.576e3 + t4770 - t5228 - t62 * t5259 / 0.8e1 + t5263 - t5265 + 0.11e2 / 0.36e2 * t274 * t2183 + 0.11e2 / 0.36e2 * t63 * t2182 * t265 + 0.11e2 / 0.648e3 * t274 * t2193 + 0.11e2 / 0.648e3 * t63 * t2192 * t293 + t4776 + t4778 / 0.16e2 + t4781 / 0.32e2;
  t5295 = t4792 / 0.576e3 + t4796 / 0.288e3 + t4798 / 0.288e3 + t4805 + t4807 / 0.288e3 + t4810 / 0.576e3 + 0.11e2 / 0.36e2 * t4824 + 0.11e2 / 0.648e3 * t4834 - t4842 / 0.6e1 - t4848 / 0.6e1 - t4851 / 0.6e1 - t4859 / 0.108e3 - t4865 / 0.108e3 - t4868 / 0.108e3 + t4875 / 0.32e2 + t4879 / 0.16e2 + t4881 / 0.16e2;
  t5300 = -t4905 + 0.2e1 / 0.9e1 * t4907 + t4912 + t4915 / 0.3e1 + 0.4e1 / 0.9e1 * t4918 + t4923 + t4926 / 0.3e1 - t4721 + t4727 + 0.4e1 / 0.9e1 * t4728 + t4732 + 0.2e1 / 0.9e1 * t5139 + t337 * t136 * (t5177 + t5215 + t5278 + t5295);
  tv4rho3sigma3 = t5133 + t5300;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  t5306 = 0.4e1 / 0.3e1 * t962 * t903 * t12 * t685;
  t5308 = t2278 * t2157 * t2460;
  t5313 = 0.4e1 / 0.3e1 * t962 * t412 * t685 * params->d;
  t5316 = t2278 * t1371 * t257 * t151;
  t5318 = t2270 * t2461;
  t5320 = t2270 * t2465;
  t5325 = -0.16e3 / 0.9e1 * t4940 + 0.1e2 / 0.3e1 * t4942 + t4950 - t5306 - 0.2e1 / 0.9e1 * t5308 - t5313 - 0.4e1 / 0.9e1 * t5316 + 0.28e2 / 0.9e1 * t5318 + 0.28e2 / 0.9e1 * t5320 - 0.4e1 / 0.9e1 * t4967 - t4972 - 0.2e1 / 0.3e1 * t4975 - 0.8e1 / 0.9e1 * t4979 - t4984;
  t5330 = t2282 * t2465;
  t5332 = t2266 * t1036;
  t5335 = 0.2e2 / 0.3e1 * t958 * t2468;
  t5339 = -0.2e1 / 0.3e1 * t4987 - t4954 - t4956 + 0.56e2 / 0.9e1 * t4957 + t4961 + 0.56e2 / 0.9e1 * t4962 + t4965 + t4930 - t4934 - 0.8e1 / 0.9e1 * t4935 - t4939 - 0.4e1 / 0.9e1 * t5330 - 0.8e2 / 0.9e1 * t5332 + t5335 - 0.2e1 * t357 * t136 * t1641;
  tv4rho3sigma4 = t5325 + t5339;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5341 = 0.2e1 * t899 * t2554;
  t5348 = t696 * t995 / 0.288e3;
  t5351 = t274 * t2349;
  t5354 = t274 * t2352 / 0.288e3;
  t5360 = t180 * t2515 / 0.108e3;
  t5365 = t63 * t508 * t280 * t93;
  t5369 = t63 * t2514 * t214 / 0.108e3;
  t5373 = t63 * t361 * t1450 / 0.32e2 + t1572 * t366 / 0.576e3 + t5348 + t696 * t998 / 0.288e3 + t5351 / 0.576e3 + t5354 + t274 * t2355 / 0.576e3 - t463 * t1051 / 0.216e3 - t5360 - t180 * t2518 / 0.108e3 - t5365 / 0.216e3 - t5369 - t63 * t1050 * t531 / 0.216e3;
  t5377 = t180 * t2523 / 0.288e3;
  t5381 = t63 * t2348 * t299;
  t5385 = t63 * t994 * t726 / 0.288e3;
  t5392 = t696 * t986 / 0.16e2;
  t5395 = t274 * t2333;
  t5398 = t274 * t2336 / 0.16e2;
  t5404 = t180 * t2491 / 0.6e1;
  t5405 = t463 * t1054 / 0.576e3 + t5377 + t180 * t2526 / 0.288e3 + t5381 / 0.576e3 + t5385 + t63 * t365 * t1556 / 0.576e3 + t1572 * t362 / 0.32e2 + t5392 + t696 * t989 / 0.16e2 + t5395 / 0.32e2 + t5398 + t274 * t2339 / 0.32e2 - t463 * t1042 / 0.12e2 - t5404;
  t5411 = t63 * t478 * t280 * t57;
  t5415 = t63 * t2490 * t175 / 0.6e1;
  t5422 = t180 * t2499 / 0.16e2;
  t5426 = t63 * t2332 * t269;
  t5430 = t63 * t985 * t632 / 0.16e2;
  t5431 = -t180 * t2494 / 0.6e1 - t5411 / 0.12e2 - t5415 - t63 * t1041 * t458 / 0.12e2 + t463 * t1045 / 0.32e2 + t5422 + t180 * t2502 / 0.16e2 + t5426 / 0.32e2 + t5430 - t5141 + t5142 + t4770 - t5228 + t5263;
  t5464 = -0.16e2 / 0.9e1 * t1429 + 0.2e1 / 0.3e1 * t1451 - t1417 * t77 * t57 / 0.4e1 - t2535 * t175 / 0.2e1 - t1059 * t458 / 0.4e1 + 0.2e1 / 0.3e1 * t558 * t280 * t57 + 0.4e1 / 0.3e1 * t2540 * t175 + 0.2e1 / 0.3e1 * t1062 * t458 - t2359 * t269 / 0.4e1 - t1002 * t632 / 0.2e1 - t370 * t1450 / 0.4e1;
  t5467 = -t5265 + t5018 / 0.576e3 + t5022 / 0.288e3 + t5024 / 0.288e3 + t5031 + t5034 / 0.288e3 + t5037 / 0.576e3 + t5042 / 0.16e2 + t5044 / 0.16e2 + t5051 + t5053 / 0.16e2 + t5056 / 0.32e2 + t5065 / 0.32e2 - t62 * t5464 / 0.8e1;
  t5474 = t357 * t1371 * t1070 * t151;
  t5478 = t2150 * t127 * t1070 * t131;
  t5483 = 0.2e1 / 0.3e1 * t902 * t903 * t12 * t2553;
  t5485 = t357 * t2157 * t2474;
  t5490 = 0.2e1 / 0.3e1 * t902 * t412 * t2553 * params->d;
  t5492 = t2145 * t2146 * t2474;
  t5495 = t5341 + t5071 + t337 * t136 * (t5373 + t5405 + t5431 + t5467) + 0.2e1 / 0.9e1 * t5474 + 0.2e1 / 0.9e1 * t5478 + t5483 + t5485 / 0.9e1 + t5490 + 0.2e1 / 0.9e1 * t5492 - t4991 - t4996 + 0.4e1 / 0.9e1 * t5074 - t5078;
  t5502 = t2161 * t2479;
  t5504 = 0.4e1 / 0.9e1 * t5081 - t5086 + 0.2e1 / 0.9e1 * t5088 + t5092 + t5095 / 0.3e1 + 0.4e1 / 0.9e1 * t5098 + t5103 + t5106 / 0.3e1 - t4993 + t4998 + 0.4e1 / 0.9e1 * t4999 + t5002 + 0.2e1 / 0.9e1 * t5502;
  tv4rho3sigma5 = t5495 + t5504;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5507 = t902 * t412 * t2590 * params->d;
  t5511 = t902 * t903 * t12 * t2590;
  t5518 = t5108 + t5507 / 0.3e1 + t5511 / 0.3e1 + 0.4e1 / 0.9e1 * t5111 + t5116 + 0.2e1 / 0.9e1 * t5118 + t5123 + 0.4e1 / 0.9e1 * t5126 + 0.4e1 / 0.9e1 * t5129 - t4717 - t4724 + 0.2e1 / 0.9e1 * t4891 - t4897;
  t5524 = 0.88e2 / 0.9e1 * t4765;
  t5527 = -t5524 + t5145 - t5152 - t5159 - t5166 - t5173 + t5181 + t5184 / 0.16e2 + t5187 + t5193 + t5197 / 0.16e2 + t5201 + t5208;
  t5530 = t146 * t853;
  t5531 = 0.8e1 / 0.3e1 * t5530;
  t5532 = t21 * t1858;
  t5555 = -0.16e2 / 0.9e1 * t1791 + 0.2e1 / 0.3e1 * t1784 - t1840 * t70 * t50 / 0.4e1 + 0.2e1 / 0.3e1 * t882 * t189 * t50 - t2580 * t170 / 0.4e1 - t2386 * t265 / 0.2e1 + 0.4e1 / 0.3e1 * t2389 * t265 - t1025 * t620 / 0.2e1 - t943 * t792 / 0.4e1 + 0.2e1 / 0.3e1 * t946 * t792 - t348 * t1754 / 0.4e1;
  t5558 = 0.176e3 / 0.9e1 * t5264;
  t5561 = t5211 / 0.288e3 + t5214 + t5222 + t5226 / 0.288e3 + t4770 + t5263 + t5531 - t5532 - t62 * t5555 / 0.8e1 - t5558 + t4776 + t4778 / 0.32e2 + t4796 / 0.576e3 + t4805;
  t5579 = t274 * t2416;
  t5586 = t63 * t930 * t833;
  t5591 = t4807 / 0.576e3 - t4848 / 0.12e2 - t4865 / 0.216e3 + t4879 / 0.32e2 - t63 * t921 * t792 / 0.12e2 - t805 * t935 / 0.216e3 - t274 * t2429 / 0.108e3 - t63 * t934 * t833 / 0.216e3 + t696 * t1021 / 0.288e3 + t5579 / 0.288e3 + t274 * t2419 / 0.288e3 + t180 * t2576 / 0.576e3 + t5586 / 0.576e3 + t63 * t343 * t1871 / 0.576e3;
  t5594 = t805 * t918;
  t5600 = t274 * t2441;
  t5607 = t63 * t917 * t792;
  t5614 = t805 * t931;
  t5622 = t1902 * t340 / 0.32e2 + t5594 / 0.32e2 + t805 * t925 / 0.32e2 + t696 * t1016 / 0.16e2 + t5600 / 0.16e2 + t274 * t2405 / 0.16e2 + t180 * t2567 / 0.32e2 + t5607 / 0.32e2 + t63 * t339 * t1754 / 0.32e2 + t1902 * t344 / 0.576e3 + t5614 / 0.576e3 + t805 * t938 / 0.576e3 - t805 * t922 / 0.12e2 - t274 * t2424 / 0.6e1;
  t5627 = t899 * t2591;
  t5628 = 0.2e1 / 0.9e1 * t4900 - t4905 + t4907 / 0.9e1 + t4912 + 0.2e1 / 0.9e1 * t4918 + t4923 - t4721 + t4727 + 0.2e1 / 0.9e1 * t4728 + t4732 + 0.4e1 / 0.9e1 * t5139 + t337 * t136 * (t5527 + t5561 + t5591 + t5622) + t5627;
  tv4rho3sigma6 = t5518 + t5628;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  t5632 = t962 * t903 * t12 * t853;
  t5636 = t962 * t412 * t853 * params->d;
  t5644 = -0.8e2 / 0.9e1 * t4940 + t4950 - 0.2e1 / 0.3e1 * t5632 - 0.2e1 / 0.3e1 * t5636 - t5306 - 0.4e1 / 0.9e1 * t5308 - t5313 - 0.8e1 / 0.9e1 * t5316 + 0.56e2 / 0.9e1 * t5318 + 0.56e2 / 0.9e1 * t5320 - 0.2e1 / 0.9e1 * t4967 - t4972 - 0.4e1 / 0.9e1 * t4979 - t4984;
  t5652 = t958 * t2596;
  t5655 = -t4954 - t4956 + 0.28e2 / 0.9e1 * t4957 + t4961 + 0.28e2 / 0.9e1 * t4962 + t4965 + t4930 - t4934 - 0.4e1 / 0.9e1 * t4935 - t4939 - 0.8e1 / 0.9e1 * t5330 - 0.2e1 * t357 * t136 * t1858 + 0.1e2 / 0.3e1 * t5652 - 0.16e3 / 0.9e1 * t5332 + t5335;
  tv4rho3sigma7 = t5644 + t5655;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5658 = t902 * t903 * t12 * t2663;
  t5662 = t902 * t412 * t2663 * params->d;
  t5669 = t5341 + t5658 / 0.3e1 + t5662 / 0.3e1 + 0.4e1 / 0.9e1 * t5474 + 0.4e1 / 0.9e1 * t5478 + t5483 + 0.2e1 / 0.9e1 * t5485 + t5490 + 0.4e1 / 0.9e1 * t5492 - t4991 - t4996 + 0.2e1 / 0.9e1 * t5074 - t5078;
  t5705 = 0.176e3 / 0.27e2 * t1819 - 0.32e2 / 0.9e1 * t1824 + 0.2e1 / 0.3e1 * t1829 - t1802 * t77 * t57 / 0.4e1 - t2644 * t175 / 0.4e1 + 0.4e1 / 0.3e1 * t641 * t280 * t57 + 0.4e1 / 0.3e1 * t2647 * t175 - t2535 * t269 / 0.2e1 - t1059 * t632 / 0.2e1 - 0.22e2 / 0.9e1 * t225 * t813 * t57 - 0.22e2 / 0.9e1 * t2652 * t175 + 0.4e1 / 0.3e1 * t2540 * t269 + 0.4e1 / 0.3e1 * t1062 * t632 - t1002 * t800 / 0.4e1 - t370 * t1773 / 0.4e1;
  t5713 = -t62 * t5705 / 0.8e1 + t5348 + t5351 / 0.288e3 + t5354 - t5360 - t5365 / 0.108e3 - t5369 + t5377 + t5381 / 0.288e3 + t5385 + t5392 + t5395 / 0.16e2 + t5398 - t5404 - t5411 / 0.6e1 - t5415;
  t5724 = t5422 + t5426 / 0.16e2 + t5430 - t5524 + t4770 + t5263 + t5531 - t5532 - t5558 + t5022 / 0.576e3 + t5031 + t5034 / 0.576e3 + t5042 / 0.32e2 + t5051 + t5053 / 0.32e2 - t63 * t1041 * t632 / 0.6e1 + t180 * t2628 / 0.32e2;
  t5727 = t63 * t985 * t800;
  t5734 = t805 * t995;
  t5740 = t274 * t2523;
  t5747 = t63 * t2514 * t299;
  t5755 = t63 * t994 * t844;
  t5762 = t274 * t2491;
  t5766 = t5727 / 0.32e2 + t63 * t361 * t1773 / 0.32e2 + t1902 * t366 / 0.576e3 + t5734 / 0.576e3 + t805 * t998 / 0.576e3 + t696 * t1054 / 0.288e3 + t5740 / 0.288e3 + t274 * t2526 / 0.288e3 - t180 * t2635 / 0.108e3 - t5747 / 0.108e3 - t63 * t1050 * t726 / 0.108e3 + t180 * t2638 / 0.576e3 + t5755 / 0.576e3 + t63 * t365 * t1886 / 0.576e3 - t696 * t1042 / 0.6e1 - t5762 / 0.6e1 - t274 * t2494 / 0.6e1;
  t5771 = t63 * t183 * t813 * t57;
  t5778 = t274 * t2515;
  t5786 = t63 * t202 * t813 * t93;
  t5793 = t805 * t986;
  t5799 = t274 * t2499;
  t5806 = t63 * t2490 * t269;
  t5808 = 0.11e2 / 0.36e2 * t180 * t2605 + 0.11e2 / 0.36e2 * t5771 + 0.11e2 / 0.36e2 * t63 * t2604 * t175 - t696 * t1051 / 0.108e3 - t5778 / 0.108e3 - t274 * t2518 / 0.108e3 + 0.11e2 / 0.648e3 * t180 * t2611 + 0.11e2 / 0.648e3 * t5786 + 0.11e2 / 0.648e3 * t63 * t2610 * t214 + t1902 * t362 / 0.32e2 + t5793 / 0.32e2 + t805 * t989 / 0.32e2 + t696 * t1045 / 0.16e2 + t5799 / 0.16e2 + t274 * t2502 / 0.16e2 - t180 * t2625 / 0.6e1 - t5806 / 0.6e1;
  t5813 = t899 * t2664;
  t5814 = 0.2e1 / 0.9e1 * t5081 - t5086 + t5088 / 0.9e1 + t5092 + 0.2e1 / 0.9e1 * t5098 + t5103 - t4993 + t4998 + 0.2e1 / 0.9e1 * t4999 + t5002 + 0.4e1 / 0.9e1 * t5502 + t337 * t136 * (t5713 + t5724 + t5766 + t5808) + t5813;
  tv4rho3sigma8 = t5669 + t5814;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5819 = 0.8e1 * t5530;
  t5820 = 0.88e2 / 0.3e1 * t5264;
  t5821 = t21 * t2068;
  t5837 = 0.3e1 / 0.32e2 * t5184 + 0.3e1 / 0.32e2 * t5197 + t5211 / 0.192e3 + t5226 / 0.192e3 + t4770 + t5819 - t5820 - t5821 - t62 * (0.2e1 / 0.3e1 * t2058 - t2050 * t70 * t50 / 0.4e1 - 0.3e1 / 0.4e1 * t2580 * t265 - 0.3e1 / 0.4e1 * t1025 * t792 - t348 * t1999 / 0.4e1) / 0.8e1 + t4776 + t4805 + t2114 * t340 / 0.32e2;
  t5860 = 0.3e1 / 0.32e2 * t805 * t1016 + 0.3e1 / 0.32e2 * t274 * t2567 + t63 * t339 * t1999 / 0.32e2 + t2114 * t344 / 0.576e3 + t805 * t1021 / 0.192e3 + t274 * t2576 / 0.192e3 + t63 * t343 * t2079 / 0.576e3 + t5579 / 0.96e2 + t5586 / 0.192e3 + 0.3e1 / 0.32e2 * t5594 + 0.3e1 / 0.16e2 * t5600 + 0.3e1 / 0.32e2 * t5607 + t5614 / 0.192e3;
  tv4rho3sigma9 = t337 * t136 * (t5837 + t5860) + t5507 + t5511 + 0.2e1 / 0.3e1 * t5126 - t4717 - t4721 - t4724 + t4727 + t4732 + 0.2e1 / 0.3e1 * t5139 + 0.3e1 * t5627 - t4897 - t4905 + t4912 + t4923 + 0.2e1 / 0.3e1 * t5129 + 0.2e1 / 0.3e1 * t5111 + t5118 / 0.3e1;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = -0.2e1 * t357 * t136 * t2068 + 0.1e2 * t5652 - 0.2e1 * t5632 - 0.2e1 * t5636 - 0.2e1 / 0.3e1 * t5308 - 0.4e1 / 0.3e1 * t5316 - 0.8e2 / 0.3e1 * t5332 + 0.28e2 / 0.3e1 * t5318 + 0.28e2 / 0.3e1 * t5320 + t4930 - t4934 - t4939 - 0.4e1 / 0.3e1 * t5330 + t4950 - t4954 - t4956 + t4961 + t4965 - t4972 - t4984;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5888 = t5351 / 0.192e3 - t5365 / 0.72e2 + t5381 / 0.192e3 + 0.3e1 / 0.32e2 * t5395 - t5411 / 0.4e1 + 0.3e1 / 0.32e2 * t5426 + t4770 + t5819 - t5820 - t5821 + t5031;
  t5913 = 0.11e2 / 0.216e3 * t63 * t2610 * t299 + t5051 - t274 * t2635 / 0.36e2 - t805 * t1051 / 0.72e2 - t805 * t1042 / 0.4e1 - t274 * t2625 / 0.2e1 + 0.11e2 / 0.12e2 * t63 * t2604 * t269 + t63 * t365 * t2094 / 0.576e3 + t805 * t1054 / 0.192e3 + t274 * t2638 / 0.192e3 - t63 * t1050 * t844 / 0.72e2;
  t5969 = -0.2464e4 / 0.81e2 * t1986 + 0.176e3 / 0.9e1 * t2036 - 0.16e2 / 0.3e1 * t2039 + 0.2e1 / 0.3e1 * t2042 - t2026 * t77 * t57 / 0.4e1 + 0.2e1 * t862 * t280 * t57 - 0.3e1 / 0.4e1 * t2644 * t269 - 0.22e2 / 0.3e1 * t310 * t813 * t57 + 0.4e1 * t2647 * t269 - 0.3e1 / 0.4e1 * t1059 * t800 + 0.308e3 / 0.27e2 * t101 * t1985 * t57 - 0.22e2 / 0.3e1 * t2652 * t269 + 0.2e1 * t1062 * t800 - t370 * t2015 / 0.4e1;
  t5972 = 0.11e2 / 0.12e2 * t274 * t2605 - 0.77e2 / 0.54e2 * t63 * t65 * t1985 * t57 + 0.11e2 / 0.216e3 * t274 * t2611 - 0.77e2 / 0.972e3 * t63 * t84 * t1985 * t93 + t2114 * t362 / 0.32e2 + 0.3e1 / 0.32e2 * t805 * t1045 + 0.3e1 / 0.32e2 * t274 * t2628 - t63 * t1041 * t800 / 0.4e1 + t63 * t361 * t2015 / 0.32e2 + t2114 * t366 / 0.576e3 - t62 * t5969 / 0.8e1;
  t5985 = 0.3e1 / 0.32e2 * t5727 + t5734 / 0.192e3 + t5740 / 0.96e2 - t5747 / 0.36e2 + t5755 / 0.192e3 - t5762 / 0.2e1 + 0.11e2 / 0.12e2 * t5771 - t5778 / 0.36e2 + 0.11e2 / 0.216e3 * t5786 + 0.3e1 / 0.32e2 * t5793 + 0.3e1 / 0.16e2 * t5799 - t5806 / 0.2e1;
  tv4rho3sigma11 = t337 * t136 * (t5888 + t5913 + t5972 + t5985) + 0.3e1 * t5813 + t5658 + t5662 + 0.2e1 / 0.3e1 * t5492 + 0.2e1 / 0.3e1 * t5478 + t5485 / 0.3e1 + 0.2e1 / 0.3e1 * t5474 - t4991 - t4993 - t4996 + t4998 + t5002 + 0.2e1 / 0.3e1 * t5502 - t5078 - t5086 + t5092 + t5103;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho2sigma20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  tv4rho2sigma26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  tv4rho2sigma212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rhosigma30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  tv4rhosigma310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4sigma40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

