// SPDX-License-Identifier: MIT
#ifndef _LMS_NAMESPACE_H
#define _LMS_NAMESPACE_H 

#define LMS_NAMESPACE(s) OQS_LMS_NAMESPACE_##s

#define get_bigendian LMS_NAMESPACE(get_bigendian)
#define put_bigendian LMS_NAMESPACE(put_bigendian)
#define hss_finalize_hash_context LMS_NAMESPACE(hss_finalize_hash_context)
#define hss_hash LMS_NAMESPACE(hss_hash)
#define hss_hash_blocksize LMS_NAMESPACE(hss_hash_blocksize)
#define hss_hash_ctx LMS_NAMESPACE(hss_hash_ctx)
#define hss_hash_length LMS_NAMESPACE(hss_hash_length)
#define hss_init_hash_context LMS_NAMESPACE(hss_init_hash_context)
#define hss_update_hash_context LMS_NAMESPACE(hss_update_hash_context)
#define hss_extra_info_set_threads LMS_NAMESPACE(hss_extra_info_set_threads)
#define hss_extra_info_test_error_code LMS_NAMESPACE(hss_extra_info_test_error_code)
#define hss_extra_info_test_last_signature LMS_NAMESPACE(hss_extra_info_test_last_signature)
#define hss_generate_child_seed_I_value LMS_NAMESPACE(hss_generate_child_seed_I_value)
#define hss_generate_root_seed_I_value LMS_NAMESPACE(hss_generate_root_seed_I_value)
#define hss_init_extra_info LMS_NAMESPACE(hss_init_extra_info)
#define hss_load_private_key LMS_NAMESPACE(hss_load_private_key)

#define allocate_working_key LMS_NAMESPACE(allocate_working_key)

#define hss_free_working_key LMS_NAMESPACE(hss_free_working_key)
#define hss_smallest_subtree_size LMS_NAMESPACE(hss_smallest_subtree_size)
#define hss_expand_aux_data LMS_NAMESPACE(hss_expand_aux_data)
#define hss_extract_aux_data LMS_NAMESPACE(hss_extract_aux_data)
#define hss_finalize_aux_data LMS_NAMESPACE(hss_finalize_aux_data)
#define hss_get_aux_data_len LMS_NAMESPACE(hss_get_aux_data_len)
#define hss_optimal_aux_level LMS_NAMESPACE(hss_optimal_aux_level)
#define hss_save_aux_data LMS_NAMESPACE(hss_save_aux_data)
#define hss_store_aux_marker LMS_NAMESPACE(hss_store_aux_marker)

#define hss_get_public_key_len LMS_NAMESPACE(hss_get_public_key_len)
#define hss_get_signature_len LMS_NAMESPACE(hss_get_signature_len)
#define hss_combine_internal_nodes LMS_NAMESPACE(hss_combine_internal_nodes)
#define hss_gen_intermediate_tree LMS_NAMESPACE(hss_gen_intermediate_tree)
#define hss_seed_derive LMS_NAMESPACE(hss_seed_derive)
#define hss_seed_derive_done LMS_NAMESPACE(hss_seed_derive_done)
#define hss_seed_derive_init LMS_NAMESPACE(hss_seed_derive_init)
#define hss_seed_derive_set_j LMS_NAMESPACE(hss_seed_derive_set_j)
#define hss_seed_derive_set_q LMS_NAMESPACE(hss_seed_derive_set_q)
#define hss_generate_working_key LMS_NAMESPACE(hss_generate_working_key)

#define hss_generate_private_key LMS_NAMESPACE(hss_generate_private_key)
#define hss_get_private_key_len LMS_NAMESPACE(hss_get_private_key_len)
#define hss_compress_param_set LMS_NAMESPACE(hss_compress_param_set)
#define hss_get_parameter_set LMS_NAMESPACE(hss_get_parameter_set)
#define hss_advance_count LMS_NAMESPACE(hss_advance_count)
#define hss_reserve_signature LMS_NAMESPACE(hss_reserve_signature)
#define hss_set_autoreserve LMS_NAMESPACE(hss_set_autoreserve)
#define hss_set_reserve_count LMS_NAMESPACE(hss_set_reserve_count)
#define hss_create_signed_public_key LMS_NAMESPACE(hss_create_signed_public_key)
#define hss_generate_signature LMS_NAMESPACE(hss_generate_signature)
#define hss_get_signature_len_from_working_key LMS_NAMESPACE(hss_get_signature_len_from_working_key)
#define hss_sign_finalize LMS_NAMESPACE(hss_sign_finalize)
#define hss_sign_init LMS_NAMESPACE(hss_sign_init)
#define hss_sign_update LMS_NAMESPACE(hss_sign_update)
#define hss_thread_after_write LMS_NAMESPACE(hss_thread_after_write)
#define hss_thread_before_write LMS_NAMESPACE(hss_thread_before_write)
#define hss_thread_done LMS_NAMESPACE(hss_thread_done)
#define hss_thread_init LMS_NAMESPACE(hss_thread_init)
#define hss_thread_issue_work LMS_NAMESPACE(hss_thread_issue_work)
#define hss_thread_num_tracks LMS_NAMESPACE(hss_thread_num_tracks)
#define hss_validate_signature LMS_NAMESPACE(hss_validate_signature)

#define validate_internal_sig LMS_NAMESPACE(validate_internal_sig)

#define hss_validate_signature_finalize LMS_NAMESPACE(hss_validate_signature_finalize)
#define hss_validate_signature_init LMS_NAMESPACE(hss_validate_signature_init)
#define hss_validate_signature_update LMS_NAMESPACE(hss_validate_signature_update)
#define hss_zeroize LMS_NAMESPACE(hss_zeroize)

#define lm_get_public_key_len LMS_NAMESPACE(lm_get_public_key_len)
#define lm_get_signature_len LMS_NAMESPACE(lm_get_signature_len)
#define lm_look_up_parameter_set LMS_NAMESPACE(lm_look_up_parameter_set)

#define lm_ots_coef LMS_NAMESPACE(lm_ots_coef)
#define lm_ots_compute_checksum LMS_NAMESPACE(lm_ots_compute_checksum)
#define lm_ots_get_public_key_len LMS_NAMESPACE(lm_ots_get_public_key_len)
#define lm_ots_get_signature_len LMS_NAMESPACE(lm_ots_get_signature_len)
#define lm_ots_hashes_per_public_key LMS_NAMESPACE(lm_ots_hashes_per_public_key)
#define lm_ots_look_up_parameter_set LMS_NAMESPACE(lm_ots_look_up_parameter_set)
#define lm_ots_generate_public_key LMS_NAMESPACE(lm_ots_generate_public_key)
#define lm_ots_generate_randomizer LMS_NAMESPACE(lm_ots_generate_randomizer)
#define lm_ots_generate_signature LMS_NAMESPACE(lm_ots_generate_signature)
#define lm_ots_validate_signature_compute LMS_NAMESPACE(lm_ots_validate_signature_compute)
#define lm_validate_signature LMS_NAMESPACE(lm_validate_signature)

#define SHA256_Final LMS_NAMESPACE(SHA256_Final)
#define LMS_randombytes LMS_NAMESPACE(LMS_randombytes)

#endif //_LMS_NAMESPACE_H
