(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[   3320023,      89017]
NotebookOptionsPosition[   3316826,      88949]
NotebookOutlinePosition[   3317223,      88965]
CellTagsIndexPosition[   3317180,      88962]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Definitions", "Section",
 CellChangeTimes->{{3.631785592207478*^9, 
  3.631785605336968*^9}},ExpressionUUID->"1c26d3f8-d1ac-4a1f-906e-\
5efac4bee200"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tprec", "=", "40"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "target", " ", "precision", " ", "for", " ", "interpolated", " ", "Gm"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tprecmax", "=", "16384"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "max", " ", "internal", " ", "precision", " ", "used", " ", "to", " ", 
    "evaluate", " ", "Gm"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prec", "=", 
    RowBox[{"10", "*", "tprec"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "precision", " ", "for", " ", "interpolation", " ", "should", " ", "be", 
    " ", "sufficient", " ", "to", " ", "get", " ", "at", " ", "least", " ", 
    "16", " ", "digits"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"order", "=", "15"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"polynomial", " ", "order"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mmax", "=", "36"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"enough", " ", "to", " ", "use", " ", "9", "Z", " ", "basis"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testPrec", "=", "False"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "set", " ", "this", " ", "to", " ", "True", " ", "to", " ", "estimate", 
      " ", "errors"}], " ", "..."}], " ", "slows", " ", "everything", " ", 
    "down", " ", "by", " ", "x5"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"printDebug", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TminLog2", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TmaxLog2", "=", "9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UminLog10", "=", 
   RowBox[{"-", "7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UmaxLog10", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<will compute Gm[T,U], m\[Element][-1,\>\"", ",", "mmax", ",", 
    "\"\<], on T\[Element][0,\>\"", ",", 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"TmaxLog2", "+", "1"}], ")"}]}], ",", "\"\<],U\[Element][\>\"", 
    ",", 
    RowBox[{"10", "^", "UminLog10"}], ",", "\"\<,\>\"", ",", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"UmaxLog10", "+", "1"}], ")"}]}], ",", 
    "\"\<], precision will \>\"", ",", 
    RowBox[{"If", "[", 
     RowBox[{"testPrec", ",", "\"\<\>\"", ",", "\"\<NOT \>\""}], "]"}], ",", 
    "\"\<be estimated\>\""}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.742762814790414*^9, 3.74276285547929*^9}, {
   3.742762890002511*^9, 3.742762890539143*^9}, {3.7427629211671743`*^9, 
   3.7427629221444607`*^9}, {3.7427629933012953`*^9, 3.74276299340679*^9}, {
   3.742763024463047*^9, 3.742763024786479*^9}, {3.742763372023538*^9, 
   3.7427633721234627`*^9}, {3.7427636428774147`*^9, 3.742763643080106*^9}, {
   3.742764215418693*^9, 3.742764218150586*^9}, {3.742764313195992*^9, 
   3.742764313367366*^9}, {3.742764348104638*^9, 3.742764348200674*^9}, {
   3.742764414218543*^9, 3.742764416113223*^9}, 3.742765102960291*^9, {
   3.742765312787507*^9, 3.742765334349514*^9}, {3.742765745122888*^9, 
   3.7427657492189302`*^9}, {3.742765854386057*^9, 3.742765858391019*^9}, {
   3.742766122272573*^9, 3.74276612275801*^9}, {3.742766187537434*^9, 
   3.742766187900062*^9}, {3.742766291593989*^9, 3.7427663126188498`*^9}, {
   3.7427808530647163`*^9, 3.7427808532532043`*^9}, {3.7428073676525097`*^9, 
   3.742807448777418*^9}, {3.7428074851886*^9, 3.742807551761373*^9}, {
   3.742808021774563*^9, 3.742808022899118*^9}, {3.7428080581539097`*^9, 
   3.742808058264624*^9}, {3.742911902170772*^9, 3.742911922148844*^9}, {
   3.742913004277212*^9, 3.742913004453404*^9}, {3.7429130694361267`*^9, 
   3.742913090102882*^9}, {3.742913291644978*^9, 3.742913296678021*^9}, {
   3.743152181711075*^9, 3.743152290808125*^9}, 3.743152572076511*^9, {
   3.917362103984454*^9, 3.9173621690071487`*^9}, {3.917362212252632*^9, 
   3.917362219884931*^9}, {3.917362811452249*^9, 3.917362817167618*^9}, {
   3.917363498263295*^9, 3.91736349836481*^9}, {3.917363634364266*^9, 
   3.917363634464443*^9}, {3.917365284613358*^9, 3.91736546999413*^9}, {
   3.917394373608485*^9, 3.917394374131345*^9}, {3.917427086738965*^9, 
   3.917427163056547*^9}, {3.917427309649791*^9, 3.9174273485251904`*^9}, {
   3.917427990852419*^9, 3.917428016682291*^9}, {3.9174284530656137`*^9, 
   3.917428454201033*^9}, {3.9174284843587027`*^9, 3.917428484780007*^9}, 
   3.9174285414579268`*^9, {3.91742872337425*^9, 3.917428724485667*^9}, {
   3.917429244123803*^9, 3.917429249572494*^9}, {3.917429358728945*^9, 
   3.917429369518654*^9}, {3.917430302155798*^9, 3.9174303025254374`*^9}, {
   3.91743307070824*^9, 3.917433071041108*^9}, {3.917433270356542*^9, 
   3.917433273225874*^9}, {3.917433420840582*^9, 3.917433460010796*^9}, {
   3.9174337500654793`*^9, 3.917433750152114*^9}, {3.917433808240944*^9, 
   3.9174338176327553`*^9}, {3.917433942328967*^9, 3.917433943045968*^9}, {
   3.917434075771146*^9, 3.917434076236719*^9}, {3.9174344055640907`*^9, 
   3.917434420922584*^9}, {3.9174347550687923`*^9, 3.91743475555928*^9}},
 CellLabel->
  "In[1795]:=",ExpressionUUID->"ee7f37a3-85f1-43db-9747-eac52a120235"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"will compute Gm[T,U], m\[Element][-1,\"\>", 
   "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\"], on T\[Element][0,\"\>", "\[InvisibleSpace]", 
   "1024", "\[InvisibleSpace]", "\<\"],U\[Element][\"\>", "\[InvisibleSpace]", 
   FractionBox["1", "10000000"], "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "1000", 
   "\[InvisibleSpace]", "\<\"], precision will \"\>", 
   "\[InvisibleSpace]", "\<\"NOT \"\>", 
   "\[InvisibleSpace]", "\<\"be estimated\"\>"}],
  SequenceForm[
  "will compute Gm[T,U], m\[Element][-1,", 36, "], on T\[Element][0,", 1024, 
   "],U\[Element][", 
   Rational[1, 10000000], ",", 1000, "], precision will ", "NOT ", 
   "be estimated"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.917365470825082*^9, 3.917392615572775*^9, 3.917394375247669*^9, 
   3.917423478537763*^9, 3.917427236493985*^9, 3.9174273508973913`*^9, {
   3.917427995985642*^9, 3.9174280170984287`*^9}, 3.917428486807629*^9, 
   3.917428542681705*^9, {3.917429348861228*^9, 3.9174293700754757`*^9}, 
   3.917430139055839*^9, 3.917430303660228*^9, 3.917433275795385*^9, 
   3.917433460762413*^9, 3.917433756655322*^9, 3.9174338989461946`*^9, 
   3.91743398527535*^9, 3.9174340818432302`*^9, 3.917434567670587*^9, {
   3.9174347374478273`*^9, 3.917434756468564*^9}},
 CellLabel->
  "During evaluation of \
In[1795]:=",ExpressionUUID->"e7651957-f40b-43e4-984f-292ec4dcac25"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Evaluate Ten-no function in analytic form to guarantee precision\
\>", "Section",
 CellChangeTimes->{{3.631785592207478*^9, 3.631785605336968*^9}, {
  3.7431522982904387`*^9, 3.743152349081682*^9}, {3.91736491478911*^9, 
  3.91736491624337*^9}},ExpressionUUID->"c24c55e6-e98c-4360-8866-\
08b05abecf3d"],

Cell[CellGroupData[{

Cell["Compute ...", "Subsection",
 CellChangeTimes->{{3.91736492188553*^9, 
  3.917364955562252*^9}},ExpressionUUID->"0ca13e56-c88e-4c72-8db3-\
4dacdac83282"],

Cell["\<\
This takes ~1000 seconds on a 2023 M2Max MBPro for mmax=40 ... grab a \
leisurely coffee\
\>", "Text",
 CellChangeTimes->{{3.743152374115336*^9, 3.743152426360208*^9}, {
   3.743152598504655*^9, 3.743152601398768*^9}, {3.7431527270104237`*^9, 
   3.7431527353163843`*^9}, {3.743152853404661*^9, 3.743152881985073*^9}, {
   3.9173635792730017`*^9, 3.917363608630962*^9}, {3.91736487061156*^9, 
   3.9173648840745363`*^9}, 
   3.917366303542631*^9},ExpressionUUID->"1d8afba0-24a3-4978-8aa7-\
b8bf306972e3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gm", "[", 
    RowBox[{"m_", ",", "T_", ",", "U_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ",", 
     RowBox[{
      RowBox[{"Assert", "[", 
       RowBox[{"m", ">=", 
        RowBox[{"-", "1"}]}], "]"}], ";", 
      RowBox[{"Return", "[", 
       RowBox[{"Assuming", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "\[Element]", "Reals"}], "&&", 
          RowBox[{"U", "\[Element]", "Reals"}], "&&", " ", 
          RowBox[{
           RowBox[{"Re", "[", "T", "]"}], "\[GreaterEqual]", "0"}], "&&", 
          RowBox[{
           RowBox[{"Re", "[", "U", "]"}], "\[GreaterEqual]", "0"}]}], ",", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"t", "^", 
             RowBox[{"(", 
              RowBox[{"2", " ", "m"}], ")"}]}], " ", 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "T"}], " ", 
               RowBox[{"t", "^", "2"}]}], "+", 
              RowBox[{"U", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"1", "/", 
                  RowBox[{"t", "^", "2"}]}]}], ")"}]}]}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"timer", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Gm", "[", 
       RowBox[{"m", ",", "T", ",", "U"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"-", "1"}], ",", "mmax"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Tabulated Ten-no function for m=[-1,\>\"", ",", "mmax", ",", 
    "\"\<] in \>\"", ",", 
    RowBox[{"timer", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< seconds\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GmTable", "=", 
   RowBox[{"timer", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.631724847966943*^9, 3.631724849282702*^9}, {
   3.631725025728188*^9, 3.631725082719846*^9}, {3.631725277124423*^9, 
   3.631725474937468*^9}, {3.631725519887945*^9, 3.631725520539823*^9}, {
   3.631725558869402*^9, 3.63172559377052*^9}, {3.631725631762908*^9, 
   3.631725679180015*^9}, {3.631726301325945*^9, 3.631726306768448*^9}, {
   3.631726511418322*^9, 3.6317265196294527`*^9}, {3.631727105386652*^9, 
   3.631727124427184*^9}, {3.631727160412551*^9, 3.63172716168251*^9}, {
   3.6317288643434467`*^9, 3.631728924278867*^9}, {3.742753354373749*^9, 
   3.7427533651021233`*^9}, {3.742753750440608*^9, 3.742753842082946*^9}, {
   3.7427543757100286`*^9, 3.742754380253879*^9}, {3.7427544314466133`*^9, 
   3.742754688102932*^9}, 3.742755432315812*^9, {3.742755625633939*^9, 
   3.742755645778689*^9}, {3.742755723585278*^9, 3.742755872417356*^9}, {
   3.742755903250635*^9, 3.742755908749509*^9}, {3.7427568524002542`*^9, 
   3.742756884816918*^9}, {3.7427570186889057`*^9, 3.7427571659762287`*^9}, {
   3.742757255063735*^9, 3.74275734442767*^9}, {3.742757383030265*^9, 
   3.742757387860334*^9}, {3.742757476000267*^9, 3.742757476439623*^9}, {
   3.742758285412916*^9, 3.742758306170966*^9}, {3.742758608299591*^9, 
   3.742758635220738*^9}, {3.742760771042169*^9, 3.7427607715568027`*^9}, {
   3.742761649666996*^9, 3.742761659645108*^9}, {3.742761717799102*^9, 
   3.742761718531191*^9}, {3.742761775564724*^9, 3.742761784131337*^9}, {
   3.7427638562939777`*^9, 3.742764185275682*^9}, {3.7427650007312183`*^9, 
   3.742765003922306*^9}, {3.7427650640987043`*^9, 3.7427650753786697`*^9}, {
   3.742765261380588*^9, 3.7427652618591623`*^9}, {3.742765429951522*^9, 
   3.742765490987946*^9}, {3.74276554488976*^9, 3.742765550462858*^9}, 
   3.742766185200663*^9, {3.7431523896591673`*^9, 3.7431523978010674`*^9}, {
   3.7431524540032263`*^9, 3.743152583102118*^9}, {3.917362648466151*^9, 
   3.9173626863366623`*^9}, {3.917362721168622*^9, 3.917362793359508*^9}, {
   3.9173634528202887`*^9, 3.917363456054699*^9}, 3.9173634941079283`*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"96de454f-1630-43ee-b110-94612399b6a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tabulated Ten-no function for m=[-1,\"\>", "\[InvisibleSpace]",
    "40", "\[InvisibleSpace]", "\<\"] in \"\>", "\[InvisibleSpace]", 
   "986.442035`", "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  "Tabulated Ten-no function for m=[-1,", 40, "] in ", 986.442035, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9173635688504257`*^9, 3.9173646369092207`*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"c03f6469-c662-48bb-8264-7cb61c64e9f9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["... or load pre-computed table", "Subsection",
 CellChangeTimes->{{3.917364941275711*^9, 
  3.917364969650084*^9}},ExpressionUUID->"f723cb5f-361a-4e4e-afc0-\
291ebcea0db5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GmTable", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          RowBox[{"Erfc", "[", 
           RowBox[{
            SqrtBox["T"], "+", 
            SqrtBox["U"]}], "]"}]}]}], ")"}]}], 
      RowBox[{"4", " ", 
       SqrtBox["U"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{"Erfc", "[", 
           RowBox[{
            SqrtBox["T"], "-", 
            SqrtBox["U"]}], "]"}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]], " ", 
           RowBox[{"Erfc", "[", 
            RowBox[{
             SqrtBox["T"], "+", 
             SqrtBox["U"]}], "]"}]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SqrtBox["T"]}]]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"3", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{"T", " ", "U"}]]}]}], ")"}], " ", 
              RowBox[{"Erfc", "[", 
               RowBox[{
                SqrtBox["T"], "-", 
                SqrtBox["U"]}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"4", " ", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}], " ", 
            RowBox[{"Erfc", "[", 
             RowBox[{
              SqrtBox["T"], "+", 
              SqrtBox["U"]}], "]"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"16", " ", 
        SuperscriptBox["T", 
         RowBox[{"5", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "T"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"4", " ", "T", " ", "U"}], "+", 
           RowBox[{"6", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"4", " ", "T", " ", "U"}], "+", 
                RowBox[{"6", " ", 
                 SqrtBox[
                  RowBox[{"T", " ", "U"}]]}]}], ")"}], " ", 
              RowBox[{"Erfc", "[", 
               RowBox[{
                SqrtBox["T"], "-", 
                SqrtBox["U"]}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"4", " ", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "-", 
              RowBox[{"4", " ", "T", " ", "U"}], "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}], " ", 
            RowBox[{"Erfc", "[", 
             RowBox[{
              SqrtBox["T"], "+", 
              SqrtBox["U"]}], "]"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"32", " ", 
        SuperscriptBox["T", 
         RowBox[{"7", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"2", " ", "T", " ", 
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{"2", " ", "T"}], "+", 
              RowBox[{"2", " ", "U"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{"15", "+", 
           RowBox[{"30", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], "+", 
           RowBox[{"8", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"15", "+", 
                RowBox[{"30", " ", 
                 SqrtBox[
                  RowBox[{"T", " ", "U"}]]}], "+", 
                RowBox[{"8", " ", "T", " ", "U", " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   SqrtBox[
                    RowBox[{"T", " ", "U"}]]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"Erfc", "[", 
               RowBox[{
                SqrtBox["T"], "-", 
                SqrtBox["U"]}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"4", " ", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "15"}], "+", 
              RowBox[{"30", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}], "+", 
              RowBox[{"8", " ", "T", " ", "U", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", 
                 SqrtBox[
                  RowBox[{"T", " ", "U"}]]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"Erfc", "[", 
             RowBox[{
              SqrtBox["T"], "+", 
              SqrtBox["U"]}], "]"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"9", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"105", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"105", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"420", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"112", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"180", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"180", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"210", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"210", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"80", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"80", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{"105", "+", 
           RowBox[{"180", " ", "T", " ", "U"}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"]}], "+", 
           RowBox[{"210", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], "+", 
           RowBox[{"80", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"T", " ", "U"}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "105"}], "-", 
           RowBox[{"180", " ", "T", " ", "U"}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"]}], "+", 
           RowBox[{"210", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], "+", 
           RowBox[{"80", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"T", " ", "U"}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"128", " ", 
        SuperscriptBox["T", 
         RowBox[{"11", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"945", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"945", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"3780", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"2520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"1008", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"1680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"1680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"1680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"448", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"1890", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"1890", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"840", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"945", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"840", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "15"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"945", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"256", " ", 
        SuperscriptBox["T", 
         RowBox[{"13", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10395", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"10395", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"41580", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"27720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"11088", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"3168", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"704", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"18900", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"18900", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"20160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"3360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1344", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"20790", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"20790", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"10080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"10080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"672", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"672", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"]}], "+", 
           RowBox[{"672", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"5", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"10395", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1260", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"]}], "+", 
           RowBox[{"672", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"10395", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1260", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "15"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"15", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"135135", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"135135", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"540540", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"360360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"144144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"41184", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"9152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"1664", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"249480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"249480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"277200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"88704", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"19008", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2816", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"50400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"50400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"24192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"1792", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1792", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"270270", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"270270", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"138600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"138600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"12096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"12096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"128", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"14", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"135135", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"27720", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"9", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"25", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"128", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "14"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"135135", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"27720", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "9"}], "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "25"}], "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", 
         RowBox[{"17", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2027025", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"2027025", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"8108100", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"5405400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"2162160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"617760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"137280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"24960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"3840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"3783780", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"3783780", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"4324320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1441440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"329472", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"54912", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6656", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"831600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"831600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"443520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"76032", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"8448", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"40320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"40320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"9216", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"4054050", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"4054050", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"2162160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"2162160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"221760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"221760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"4608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"4608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"256", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"]}], "+", 
           RowBox[{"2027025", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"540540", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"7", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"55440", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1152", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"35", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "256"}], " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"]}], "+", 
           RowBox[{"2027025", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1152", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "35"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"55440", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "15"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"540540", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "7"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", 
         RowBox[{"19", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"34459425", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"34459425", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"137837700", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"91891800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"36756720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"10501920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"2333760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"424320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"65280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"8704", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"64864800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"64864800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"75675600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"25945920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6177600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1098240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"149760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"15360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"15135120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"15135120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"8648640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1647360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"219648", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"19968", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"887040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"887040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"253440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"22528", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"11520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"11520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"68918850", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"68918850", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"37837800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"37837800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"4324320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"4324320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"126720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"126720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"126720", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"7", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"34459425", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2162160", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"7", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"256", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"45", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"5405400", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"12", "+", 
              RowBox[{"7", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"126720", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "7"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"256", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "45"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2162160", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "7"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"34459425", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"5405400", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12"}], "+", 
              RowBox[{"7", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"21", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"654729075", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"654729075", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"2618916300", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"1745944200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"698377680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"199536480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"44341440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"8062080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"1240320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"165376", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"19456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"1240539300", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"1240539300", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"1470268800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"514594080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"126023040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"23337600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"3394560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"391680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"34816", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"302702400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"302702400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"181621440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"37065600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5491200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"599040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"46080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"20180160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"20180160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"6589440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"732160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"53248", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"380160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"380160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"56320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"1309458150", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"1309458150", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"735134400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"735134400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"90810720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"90810720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"3294720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"3294720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"28160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"28160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1024", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"]}], "+", 
           RowBox[{"654729075", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"14080", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"27", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"30270240", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"10", "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"411840", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"49", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"45945900", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"27", "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1024"}], " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"]}], "+", 
           RowBox[{"14080", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "27"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"654729075", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"30270240", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "10"}], "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"411840", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "49"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"45945900", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "27"}], "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"23", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"13749310575", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"13749310575", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"54997242300", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"36664828200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"14665931280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"4190266080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"931170240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"169303680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"26046720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"3472896", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"408576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"43008", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "+", 
        RowBox[{"26189163000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"26189163000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"31426995600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"11174042880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2793510720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"532097280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"80620800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"9922560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"992256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"77824", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"6616209600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"6616209600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4116752640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"882161280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"140025600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"16972800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1566720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"104448", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"484323840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"484323840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"172972800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"21964800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1996800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"122880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"11531520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"11531520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2196480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"133120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"67584", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"67584", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"27498621150", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"27498621150", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"15713497800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"15713497800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"2058376320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2058376320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"86486400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"86486400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"1098240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"1098240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"2048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2048", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"33", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"13749310575", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"549120", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"21", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"5237832600", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"5", "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"17297280", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"28", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"147026880", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"45", "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2048", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "33"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"549120", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "21"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"13749310575", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"5237832600", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5"}], "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"17297280", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "28"}], "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"147026880", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "45"}], "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", 
         RowBox[{"25", "/", "2"}]]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"316234143225", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"316234143225", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"1264936572900", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"843291048600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"337316419440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"96376119840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"21416915520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"3893984640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"599074560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"79876608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"9397248", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"989184", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"94208", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "+", 
        RowBox[{"604969665300", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"604969665300", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"733296564000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"263986763040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"67044257280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"13036383360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2031644160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"260467200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"27783168", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2451456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"172032", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"157134978000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"157134978000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"100566385920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"22348085760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3724680960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"483724800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"49612800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3969024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"233472", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"12350257920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"12350257920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"4704860160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"653452800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"67891200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"5222400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"278528", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"345945600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"345945600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"76876800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"5990400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"307200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"3075072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"3075072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"319488", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"4096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"632468286450", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"632468286450", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"366648282000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"366648282000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"50283192960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"50283192960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2352430080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"2352430080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"38438400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"38438400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"159744", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"159744", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U"}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4096", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"]}], "+", 
           RowBox[{"38438400", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"9", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"316234143225", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"588107520", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"21", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"39936", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"77", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"6285399120", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"25", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"18332414100", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"33", "+", 
              RowBox[{"20", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"T", "+", "U", "+", 
           RowBox[{"4", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4096", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"]}], "-", 
           RowBox[{"38438400", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "9"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"316234143225", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"39936", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "77"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"588107520", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "21"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"6285399120", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "25"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"18332414100", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "33"}], "+", 
              RowBox[{"20", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7905853580625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"7905853580625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"31623414322500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"21082276215000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"8432910486000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"2409402996000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"535422888000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"97349616000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"14976864000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"1996915200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"234931200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"24729600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"2355200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"204800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "+", 
        RowBox[{"15179238874800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"15179238874800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"18552403069200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6746328388800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1734770157120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"342670648320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"54515784960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"7188894720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"798766080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"75177984", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5935104", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"376832", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"4033131102000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4033131102000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2639867630400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"603398315520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"104291066880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"14221509120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1562803200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"138915840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"9805824", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"516096", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"335221286400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"335221286400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"134088514560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"19864965120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2257382400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"198451200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"13230080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"622592", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"10585935360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"10585935360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2613811200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"237619200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"15667200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"696320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"123002880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"123002880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"16773120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"737280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"372736", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"372736", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"15811707161250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"15811707161250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"9276201534600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"9276201534600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"1319933815200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"1319933815200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"67044257280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"67044257280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"1306905600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"1306905600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"8386560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"8386560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"8192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"67044257280", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"5", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"7905853580625", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"4096", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"91", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2795520", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"44", "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"130690560", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"81", "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"843291048600", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"18", "+", 
              RowBox[{"11", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"73329656400", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"55", "+", 
              RowBox[{"18", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "67044257280"}], " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"4096", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "91"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"7905853580625", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"2795520", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "44"}], "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"130690560", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "81"}], "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"843291048600", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "18"}], "+", 
              RowBox[{"11", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"73329656400", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "55"}], "+", 
              RowBox[{"18", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"213458046676875", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"213458046676875", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"853832186707500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"569221457805000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"227688583122000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"65053880892000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"14456417976000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"2628439632000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"404375328000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"53916710400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"6343142400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"667699200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"63590400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"5529600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"442368", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "+", 
        RowBox[{"411104386192500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"411104386192500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"505974629160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"185524030692000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"48188059920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"9637611984000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1557593856000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"209676096000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"23962982400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2349312000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"197836800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"14131200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"819200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"111314418415200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"111314418415200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"74209612276800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"17347701571200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3084035834880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"436126279680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"50322263040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4792596480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"375889920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"23740416", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1130496", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"9679514644800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"9679514644800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"4022655436800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"625746401280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"75848048640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"7293081600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"555663360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"32686080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1376256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"335221286400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"335221286400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"89392343040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"9029529600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"694579200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"39690240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1556480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"4704860160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"4704860160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"760381440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"43868160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1671168", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"22364160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"22364160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"1720320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"16384", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"426916093353750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"426916093353750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"252987314580000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"252987314580000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"37104806138400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"37104806138400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2011327718400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"2011327718400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"44696171520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"44696171520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"380190720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"380190720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"860160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"860160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16384", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"]}], "+", 
           RowBox[{"37104806138400", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"860160", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"26", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"213458046676875", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"22348085760", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"31623414322500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"13", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"47523840", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"99", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"125707982400", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"77", "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16384", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"]}], "-", 
           RowBox[{"860160", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "26"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"37104806138400", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"22348085760", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "15"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"213458046676875", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"47523840", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "99"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"31623414322500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "13"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"125707982400", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "77"}], "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6190283353629375", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"6190283353629375", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"24761133414517500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"16507422276345000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"6602968910538000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"1886562545868000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"419236121304000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"76224749328000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"11726884512000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"1563584601600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"183951129600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"19363276800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"1844121600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"160358400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"12828672", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"950272", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "+", 
        RowBox[{"11953650613905000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"11953650613905000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"14799757902930000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5464525994928000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1431185379624000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"289128359520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"47311913376000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6470005248000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"754833945600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"76117708800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6676992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"508723200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"33177600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1769472", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"3288835089540000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3288835089540000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2226288368304000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"530068659120000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"96376119840000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"14018344704000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1677408768000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"167740876800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"14095872000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"989184000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"56524800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2457600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"296838449107200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"296838449107200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"127216478188800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"20560238899200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2616757678080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"268385402880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"22365450240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1503559680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"79134720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3014656", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"11062302451200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"11062302451200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"3128732006400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"341316218880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"29172326400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1944821760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"98058240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"3440640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"178784686080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"178784686080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"32506306560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"2222653440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"111132672", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"3735552", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"1140572160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"1140572160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"116981760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"3899392", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"1966080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"1966080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"12380566707258750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"12380566707258750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"7399878951465000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"7399878951465000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"1113144184152000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"1113144184152000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"63608239094400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"63608239094400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"1564366003200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"1564366003200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"16253153280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"16253153280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"58490880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"58490880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"32768", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16253153280", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"11", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"32768", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"60", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"6190283353629375", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"29245440", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"39", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"21202746364800", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"14", "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"569221457805000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"21", "+", 
              RowBox[{"13", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"111740428800", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"99", "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"50597462916000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"65", "+", 
              RowBox[{"22", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "32768"}], " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "60"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"16253153280", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "11"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"29245440", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "39"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"6190283353629375", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"21202746364800", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "14"}], "+", 
              RowBox[{"3", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"569221457805000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "21"}], "+", 
              RowBox[{"13", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"111740428800", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "99"}], "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"50597462916000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "65"}], "+", 
              RowBox[{"22", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"191898783962510625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"191898783962510625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"767595135850042500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"511730090566695000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"204692036226678000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"58483438921908000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"12996319760424000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"2362967229168000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"363533419872000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"48471122649600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"5702485017600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"600261580800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"57167769600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"4971110400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"397688832", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"29458432", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"2031616", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "+", 
        RowBox[{"371417001217762500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"371417001217762500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"462207823737660000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"171677191673988000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"45277501100832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"9223194668688000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1524494986560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"211083921216000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"25017353625600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2575315814400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"232359321600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"18441216000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1282867200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"76972032", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"3801088", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"103598305320510000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"103598305320510000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"71038837934064000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"17174224555488000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3180411954720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"473119133760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"58230047232000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"6038671564800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"532823961600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"40061952000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2543616000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"132710400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5308416", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"9647249595984000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"9647249595984000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"4240549272960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"706758212160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"93455631360000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"10064452608000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"894618009600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"65780736000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3956736000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"188416000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"6553600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"381649434566400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"381649434566400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"113081313945600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"13083788390400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1207734312960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"89461800960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"5262458880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"237404160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"7536640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"6883210414080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"6883210414080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1365264875520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"105020375040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"6223429632", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"274563072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"8257536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"54177177600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"54177177600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"6667960320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"296353792", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"8716288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"150405120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"150405120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"8912896", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"65536", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"383797567925021250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"383797567925021250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"231103911868830000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"231103911868830000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"35519418967032000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"35519418967032000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2120274636480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"2120274636480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"56540656972800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"56540656972800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"682632437760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"682632437760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"3333980160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"3333980160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"4456448", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"4456448", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"65536", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"]}], "+", 
           RowBox[{"191898783962510625", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"14135164243200", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"27", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"833495040", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"65", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1114112", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"135", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2959951580586000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"35", "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"56886036480", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"121", "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"106013731824000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"91", "+", 
              RowBox[{"20", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"8253711138172500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"45", "+", 
              RowBox[{"28", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"65536", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"]}], "-", 
           RowBox[{"191898783962510625", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"1114112", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "135"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"833495040", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "65"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"14135164243200", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "27"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"56886036480", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "121"}], "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"2959951580586000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "35"}], "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"106013731824000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "91"}], "+", 
              RowBox[{"20", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"8253711138172500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "45"}], "+", 
              RowBox[{"28", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6332659870762850625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"6332659870762850625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"25330639483051402500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"16887092988700935000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"6754837195480374000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"1929953484422964000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"428878552093992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"77977918562544000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"11996602855776000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"1599547047436800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"188182005580800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"19808632166400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"1886536396800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"164046643200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"13123731456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"972128256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"67043328", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"4325376", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]]}], "+", 
        RowBox[{"12281522173600680000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"12281522173600680000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"15351902717000850000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5731377014346984000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1520569411969608000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"311911674250176000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"51985279041696000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"7270668397440000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"872480207692800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"91239760281600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"8403662131200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"686013235200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"49711104000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"3181510656", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"176750592", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"8126464", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"3466558678032450000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3466558678032450000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2403480683435832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"588607514310816000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"110678336024256000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"16769444852160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2110839212160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"225156182630400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"20602526515200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1626515251200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"110647296000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"6414336000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"307888128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"11403264", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"331514577025632000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"331514577025632000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"148843279480896000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"25443295637760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3469540314240000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"388200314880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"36232029388800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2841727795200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"186955776000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"10174464000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"442368000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"14155776", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"13781785137120000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"13781785137120000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"4240549272960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"514005972480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"50322263040000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"4025781043200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"263122944000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"13848576000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"565248000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"16384000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"271395153469440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"271395153469440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"57568668917760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"4830937251840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"322062483456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"16839868416", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"664731648", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"18087936", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"2502985605120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"2502985605120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"350067916800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"18670288896", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"732168192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"19267584", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"9525657600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"9525657600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"762052608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"19922944", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"10027008", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"10027008", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"12665319741525701250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"12665319741525701250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"7675951358500425000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"7675951358500425000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"1201740341717916000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"1201740341717916000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"74421639740448000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"74421639740448000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"2120274636480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"2120274636480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"28784334458880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"28784334458880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"175033958400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"175033958400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"381026304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"381026304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"131072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"381026304", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"25", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"6332659870762850625", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1060137318240000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"13", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"65536", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"153", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1535190271700085000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"4112047779840", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"66", "+", 
              RowBox[{"7", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"17503395840", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"143", "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"6765603612768000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"49", "+", 
              RowBox[{"11", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"46220782373766000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"75", "+", 
              RowBox[{"26", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "381026304"}], " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "25"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"65536", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "153"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"1060137318240000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "13"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"6332659870762850625", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"1535190271700085000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"4112047779840", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "66"}], "+", 
              RowBox[{"7", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"17503395840", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "143"}], "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"6765603612768000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "49"}], "+", 
              RowBox[{"11", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"46220782373766000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "75"}], "+", 
              RowBox[{"26", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"221643095476699771875", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"221643095476699771875", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"886572381906799087500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"591048254604532725000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"236419301841813090000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"67548371954803740000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"15010749323289720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"2729227149689040000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"419881099952160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"55984146660288000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"6586370195328000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"693302125824000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"66028773888000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"5741632512000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"459330600960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"34024488960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"2346516480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"151388160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "-", 
        RowBox[{"9175040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]]}], "+", 
        RowBox[{"430620871211873842500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"430620871211873842500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"540386975638429920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"202645115864411220000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"54038697563842992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"11150842354443792000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1871470045501056000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"263925262827072000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"31990940948736000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"3387276100454400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"316938114662400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"26411509555200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1968559718400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"131237314560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"7777026048", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"402259968", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"17301504", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"122815221736006800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"122815221736006800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"85970655215204760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"21287971767574512000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4054851765252288000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"623823348500352000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"79977352371840000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"8724802076928000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"821157842534400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"67229297049600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4802092646400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"298266624000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"15907553280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"707002368", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"24379392", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"12017403417179160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"12017403417179160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"5493670133567616000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"959212245543552000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"134155558817280000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"15479487555840000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1501041217536000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"123615159091200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"8674748006400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"516354048000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"25657344000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1026293760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"30408704", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"520951478183136000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"520951478183136000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"165381421645440000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"20817241885440000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2135101731840000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"181160146944000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"12787775078400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"747823104000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"35610624000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1327104000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"35389440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"11025428109696000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"11025428109696000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"2467228667904000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"221417957376000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"16103124172800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"947242598400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"44315443200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1582694400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"39321600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"115137337835520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"115137337835520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"17713436590080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"1073541611520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"50519605248", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"1772617728", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"42205184", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"550106726400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"550106726400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"53343682560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"1882718208", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"44040192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"952565760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"952565760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"44826624", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"262144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "+", 
        RowBox[{"443286190953399543750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"443286190953399543750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"270193487819214960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"270193487819214960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"42985327607602380000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"42985327607602380000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2746835066783808000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"2746835066783808000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"82690710822720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"82690710822720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"1233614333952000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"1233614333952000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"8856718295040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"8856718295040", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"26671841280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"26671841280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"22413312", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"22413312", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"262144", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"]}], "+", 
           RowBox[{"8856718295040", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"13", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"221643095476699771875", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"11206656", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"85", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"6140761086800340000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"20", "+", 
              RowBox[{"7", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"343354383347976000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"35", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"3333980160", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"165", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"8269071082272000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"63", "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"77100895872000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"143", "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"8443546494350467500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"51", "+", 
              RowBox[{"32", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"262144", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"]}], "-", 
           RowBox[{"8856718295040", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "13"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"11206656", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "85"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"221643095476699771875", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"6140761086800340000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "20"}], "+", 
              RowBox[{"7", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"3333980160", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "165"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"343354383347976000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "35"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"8269071082272000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "63"}], "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"77100895872000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "143"}], "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"8443546494350467500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "51"}], "+", 
              RowBox[{"32", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8200794532637891559375", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"8200794532637891559375", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"32803178130551566237500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"21868785420367710825000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"8747514168147084330000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"2499289762327738380000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"555397724961719640000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"100981404538494480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"15535600698229920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"2071413426430656000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"243695697227136000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"25652178655488000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"2443064633856000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"212440402944000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"16995232235520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"1258906091520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"86821109760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"5601361920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "-", 
        RowBox[{"339476480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]]}], "-", 
        RowBox[{"19398656", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]]}], "+", 
        RowBox[{"15958302874322383575000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"15958302874322383575000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"20095640656554112650000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"7565417658938018880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2026451158644112200000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"420300981052112160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"70959905891915040000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"10077146398851840000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1231651226526336000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"131727403906560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"12479438264832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1056460382208000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"80382855168000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5511967211520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"340244889600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"18772131840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"908328960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"36700160", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"4593289292926654320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4593289292926654320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3242321853830579520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"810580463457644880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"156111792962213088000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"24329110591513728000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3167103153924864000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"351900350436096000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"33872761004544000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2852443031961600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"211292076441600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"13779918028800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"787423887360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"38885130240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1609039872", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"51904512", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"458510161147758720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"458510161147758720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"212879717675745120000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"37845283142354688000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"5406469020336384000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"639818818974720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"63981881897472000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"5474385616896000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"403375782297600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"25611160780800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1391910912000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"63630213120", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2356674560", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"65011712", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"20601263000878560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"20601263000878560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"6714485718804864000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"872011132312320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"92876925335040000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"8255726696448000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"618075795456000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"39036366028800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2065416192000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"89800704000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"3078881280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"76021760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"463067980607232000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"463067980607232000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"108249657804288000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"10248488312832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"797104646553600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"51151100313600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"2692163174400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"113953996800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"3715891200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"84934656", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"5345662113792000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"5345662113792000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"885671829504000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"59044788633600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"3157475328000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"132946329600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"4220518400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"91750400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"30365891297280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"30365891297280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"3373987921920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"144341729280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"4558159872", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"96468992", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"73347563520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"73347563520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"4706795520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"99090432", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"49807360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"49807360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "+", 
        RowBox[{"16401589065275783118750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"16401589065275783118750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"10047820328277056325000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"10047820328277056325000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"1621160926915289760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"1621160926915289760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"106439858837872560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"106439858837872560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"3357242859402432000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"3357242859402432000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"54124828902144000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"54124828902144000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"442835914752000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"442835914752000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"1686993960960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"1686993960960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"2353397760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"2353397760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"524288", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1686993960960", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"18", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"524288", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{"95", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"8200794532637891559375", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"270193487819214960000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"17", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"392232960", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"187", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"6013869878016000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"77", "+", 
              RowBox[{"9", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"8187681449067120000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"56", "+", 
              RowBox[{"13", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"31631136768000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"169", "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"591048254604532725000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"27", "+", 
              RowBox[{"17", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"152601948154656000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"135", "+", 
              RowBox[{"22", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "524288"}], " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "95"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"1686993960960", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "18"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"8200794532637891559375", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"392232960", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "187"}], "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"270193487819214960000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "17"}], "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"6013869878016000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "77"}], "+", 
              RowBox[{"9", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"8187681449067120000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "56"}], "+", 
              RowBox[{"13", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"31631136768000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "169"}], "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"591048254604532725000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "27"}], "+", 
              RowBox[{"17", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"152601948154656000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "135"}], "+", 
              RowBox[{"22", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"319830986772877770815625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"319830986772877770815625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"1279323947091511083262500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"852882631394340722175000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"341153052557736288870000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"97472300730781796820000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"21660511273507065960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"3938274777001284720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"605888427230966880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"80785123630795584000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"9504132191858304000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"1000434967564032000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"95279520720384000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"8285175714816000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"662814057185280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"49097337569280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"3386023280640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"218453114880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "-", 
        RowBox[{"13239582720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]]}], "-", 
        RowBox[{"756547584", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]]}], "-", 
        RowBox[{"40894464", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"39", "/", "2"}]]}], "+", 
        RowBox[{"623260384480479758512500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"623260384480479758512500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"787276275133237589700000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"297415481717000867220000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"79977272394487628160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"16661931748851589200000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2827479327077845440000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"403925618153977920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"49713922234335744000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5361305338996992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"513043573109760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"43975163409408000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"3399046447104000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"237933251297280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"15106873098240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"868211097600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"44810895360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2036858880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"77594624", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"180860765908987013850000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"180860765908987013850000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"128612100201946320960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"32423218538305795200000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"6304514715781682400000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"993438682486810560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"131002903185073920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"14779814718316032000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1449001442972160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"124794382648320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"9508143439872000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"643062841344000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"38583770480640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2041469337600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"93860659200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"3633315840", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"110100480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"18373157171706617280000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"18373157171706617280000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"8646191610214878720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1561117929622130880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"227071698854128128000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"27448227334015488000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2815202803488768000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"248400247366656000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"19016286879744000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1267752458649600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"73492896153600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3674644807680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"155540520960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"5363466240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"138412032", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"851518870702980480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"851518870702980480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"283839623567660160000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"37845283142354688000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"4158822323335680000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"383891291384832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"30109120892928000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2016878911488000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"115250223513600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"5567643648000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"222705745920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"7070023680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"162529280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"20143457156414592000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"20143457156414592000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"4883262340948992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"482960011742208000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"39627488142950400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"2719533500006400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"156145464115200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"7435498291200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"287362252800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"8620867584", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"182452224", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"252582534876672000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"252582534876672000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"44410116022272000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"3188418586214400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"187554034483200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"8973877248000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"341861990400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"9909043200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"198180864", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"1644819111936000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"1644819111936000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"202439275315200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"9923493888000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"379846656000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"10852761600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"209715200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"5060981882880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"5060981882880", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"396939755520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"11395399680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"217055232", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"5752750080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"5752750080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"220200960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "+", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "10"], " ", 
         SuperscriptBox["U", "10"]}], "-", 
        RowBox[{"1048576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "10"], " ", 
         SuperscriptBox["U", "10"]}], "+", 
        RowBox[{"639661973545755541631250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"639661973545755541631250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"393638137566618794850000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"393638137566618794850000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"64306050100973160480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"64306050100973160480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"4323095805107439360000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"4323095805107439360000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"141919811783830080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"141919811783830080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"2441631170474496000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"2441631170474496000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"22205058011136000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"22205058011136000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"101219637657600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"101219637657600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"198469877760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"198469877760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"110100480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"110100480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1048576", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"]}], "+", 
           RowBox[{"141919811783830080000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"6", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"319830986772877770815625", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"99234938880", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"51", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1080773951276859840000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"17", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"610407792618624000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"33", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"25304909414400", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"65", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"27525120", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{"209", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2775632251392000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"91", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"32803178130551566237500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"19", "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"4019128131310822530000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"45", "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1048576", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"]}], "-", 
           RowBox[{"141919811783830080000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "6"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"99234938880", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "51"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"319830986772877770815625", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"27525120", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "209"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"25304909414400", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "65"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"610407792618624000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "33"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"1080773951276859840000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "17"}], "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"2775632251392000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "91"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"32803178130551566237500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "19"}], "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"4019128131310822530000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "45"}], "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"13113070457687988603440625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"13113070457687988603440625", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"52452281830751954413762500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"34968187887167969609175000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"13987275154867187843670000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"3996364329962053669620000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"888080962213789704360000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"161469265857052673520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"24841425516469642080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"3312190068862618944000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"389669419866190464000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"41017833670125312000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"3906460349535744000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"339692204307456000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"27175376344596480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"2012990840340480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"138826954506240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"8956577710080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "-", 
        RowBox[{"542822891520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]]}], "-", 
        RowBox[{"31018450944", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]]}], "-", 
        RowBox[{"1676673024", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]]}], "-", 
        RowBox[{"85983232", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"39", "/", "2"}]]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"41", "/", "2"}]]}], "+", 
        RowBox[{"25586478941830221665250000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"25586478941830221665250000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"32409539992984947442650000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"12281509892078506399320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"3314058224846581091880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"693136360752226110720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"118148243310038541600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"16964875962467072640000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2100413214400685184000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"228099172604599296000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"22009569286408704000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1905590414407680000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"149133162866688000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"10605024914964480", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"687362725969920", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"40632279367680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"2184531148800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"105916661760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"4539285504", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"163577856", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"39", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"7479124613765757102150000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"7479124613765757102150000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5353478670906015609960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1359613630706289678720000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"266590907981625427200000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"42412189906167681600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5654958654155690880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"646280989046364672000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"64335664067963904000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5643479304207360000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"439751634094080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"30591418023936000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1903466010378240", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"105748111687680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5209266585600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"224054476800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"8147435520", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"232783872", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"771672601211677925760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"771672601211677925760000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"367463143434132345600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"67248156968337945600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"9934386824868105600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"1222693763060689920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"128091727558738944000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"11592011543777280000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"915158806087680000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"63387622932480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3858377048064000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"205780109230080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"9526856908800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"375442636800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"12111052800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"293601280", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"36746314343413234560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"36746314343413234560000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"12488943436977047040000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1703037741405960960000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"192137591338108416000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"18298818222676992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1490401484199936000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"104589577838592000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"6338762293248000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"330718032691200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"14698579230720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"544391823360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"16090398720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"346030080", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"908286795416512512000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"908286795416512512000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"227071698854128128000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"23289405010679808000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1996234715201126400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"144523780286054400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"8874267210547200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"461000894054400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"20043517132800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"712658386944", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"19796066304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"390070272", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"12208155852372480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"12208155852372480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"2253813388130304000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"171719115286118400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"10878134000025600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"572533368422400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"24784994304000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"862086758400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"22988980224", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"425721856", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"88820232044544000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"88820232044544000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"11842697605939200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"643042403942400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"28203614208000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"976748544000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"25480396800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"452984832", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"328963822387200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"328963822387200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"29770481664000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"1044578304000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"27131904000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"471859200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"529253007360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"529253007360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"27855421440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"482344960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "+", 
        RowBox[{"242221056", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "10"], " ", 
         SuperscriptBox["U", "10"]}], "-", 
        RowBox[{"242221056", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "10"], " ", 
         SuperscriptBox["U", "10"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "10"]}], "+", 
        RowBox[{"26226140915375977206881250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"26226140915375977206881250", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"16204769996492473721325000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"16204769996492473721325000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"2676739335453007804980000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2676739335453007804980000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"183731571717066172800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"183731571717066172800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"6244471718488523520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"6244471718488523520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"113535849427064064000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"113535849427064064000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"1126906694065152000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"1126906694065152000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"5921348802969600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"5921348802969600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"14885240832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"14885240832000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"13927710720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"13927710720", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"21", "/", "2"}]]}], "+", 
        RowBox[{"2097152", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"21", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"113535849427064064000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"5921348802969600", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"15", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"13927710720", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{"38", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"13113070457687988603440625", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1048576", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{"231", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"36746314343413234560000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"21", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"187817782344192000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"65", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1488524083200", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"221", "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"852882631394340722175000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"30", "+", 
              RowBox[{"19", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"240171989172635520000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"153", "+", 
              RowBox[{"26", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"78727627513323758970000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"95", "+", 
              RowBox[{"34", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "13927710720"}], " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "38"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"5921348802969600", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "15"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"113535849427064064000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"1048576", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "231"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"13113070457687988603440625", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"36746314343413234560000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "21"}], "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"187817782344192000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "65"}], "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"1488524083200", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "221"}], "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"852882631394340722175000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "30"}], "+", 
              RowBox[{"19", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"240171989172635520000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "153"}], "+", 
              RowBox[{"26", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"78727627513323758970000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "95"}], "+", 
              RowBox[{"34", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"563862029680583509947946875", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"563862029680583509947946875", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"]}], "-", 
        RowBox[{"2255448118722334039791787500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SqrtBox["T"]}], "-", 
        RowBox[{"1503632079148222693194525000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"601452831659289077277810000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"171843666188368307793660000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"38187481375192957287480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"6943178431853264961360000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"1068181297208194609440000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"142424172961092614592000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]]}], "-", 
        RowBox[{"16755785054246189952000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"1763766847815388416000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"167977795030036992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]]}], "-", 
        RowBox[{"14606764785220608000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]]}], "-", 
        RowBox[{"1168541182817648640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]]}], "-", 
        RowBox[{"86558606134640640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]]}], "-", 
        RowBox[{"5969559043768320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]]}], "-", 
        RowBox[{"385132841533440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]]}], "-", 
        RowBox[{"23341384335360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]]}], "-", 
        RowBox[{"1333793390592", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]]}], "-", 
        RowBox[{"72096940032", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]]}], "-", 
        RowBox[{"3697278976", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"39", "/", "2"}]]}], "-", 
        RowBox[{"180355072", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"41", "/", "2"}]]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"43", "/", "2"}]]}], "+", 
        RowBox[{"1101497918445791042689012500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"1101497918445791042689012500", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", "T", " ", "U"}], "-", 
        RowBox[{"1398727515486718784367000000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"3", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"531516455884953138059460000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"143869115878633932106320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"30194752715268849948240000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5167016507425685552640000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"745242765494089262400000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"92741321928153330432000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"10131404916520952064000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"984428008083007488000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"85942127689786368000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"6793844086149120000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"489156774202736640", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"32207853445447680", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"1943577363087360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"107478932520960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"5428228915200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"248147607552", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"10060038144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"343932928", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"39", "/", "2"}]], " ", "U"}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"41", "/", "2"}]], " ", "U"}], "+", 
        RowBox[{"324095399929849474426500000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"324095399929849474426500000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "2"], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"233348687949491621587080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"5", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"59653048047238459653840000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"11783318132787843882240000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1890371892960616665600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"254473139437006089600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"29405785001609592576000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"2965289243859790848000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"264114831436904448000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"20961494558484480000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"1491331628666880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"95445224234680320", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"5498901807759360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"284425955573760", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"13107186892800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"529583308800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"18157142016", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"490733568", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"39", "/", "2"}]], " ", 
         SuperscriptBox["U", "2"]}], "+", 
        RowBox[{"33905364915738098863080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"33905364915738098863080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "3"], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"16315363568475476144640000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"7", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3021363623791754841600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"452396692332455270400000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"56549586541556908800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"6031955897766070272000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"557575755255687168000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"45147834433658880000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"3224845316689920000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"203942786826240000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"11420796062269440", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"563989929000960", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"24309910732800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"896217907200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"27158118400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"620756992", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"37", "/", "2"}]], " ", 
         SuperscriptBox["U", "3"]}], "+", 
        RowBox[{"1653584145453595555200000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1653584145453595555200000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "4"], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"571609334230872537600000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"9", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"79475094598944844800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"9170203222955174400000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"896642092911172608000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"75348075034552320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"5490952836526080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"348631926128640000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"19291885240320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"926010491535360", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"38107427635200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"1314049228800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"36333158400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"734003200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"35", "/", "2"}]], " ", 
         SuperscriptBox["U", "4"]}], "+", 
        RowBox[{"42462407685721959936000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"42462407685721959936000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "5"], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"10899441544998150144000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"11", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1152825548028650496000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"102473382046991155200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"7750087717839667200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"502029973625241600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"27890554090291200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1322872130764800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"52914885230592", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"1742053834752", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"45053116416", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"830472192", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"33", "/", "2"}]], " ", 
         SuperscriptBox["U", "5"]}], "+", 
        RowBox[{"605524530277675008000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"605524530277675008000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "6"], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"116447025053399040000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"13", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"9315762004271923200", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"626269714572902400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"35497068842188800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"1690336611532800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"66811723776000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"2137975160832", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"52789510144", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"910163968", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"31", "/", "2"}]], " ", 
         SuperscriptBox["U", "6"]}], "+", 
        RowBox[{"4829600117422080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"4829600117422080000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "7"], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"686876461144473600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"15", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"40404497714380800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"1962971548876800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"77895696384000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"2463105024000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"59114520576", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"973078528", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"29", "/", "2"}]], " ", 
         SuperscriptBox["U", "7"]}], "+", 
        RowBox[{"20724720810393600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"20724720810393600", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "8"], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"2089887812812800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"17", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"84610842624000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"2686058496000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"63700992000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"1019215872", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"27", "/", "2"}]], " ", 
         SuperscriptBox["U", "8"]}], "+", 
        RowBox[{"43001806848000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"43001806848000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "9"], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"2785542144000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"19", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"66322432000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"1048576000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"25", "/", "2"}]], " ", 
         SuperscriptBox["U", "9"]}], "+", 
        RowBox[{"33426505728", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "10"], " ", 
         SuperscriptBox["U", "10"]}], "-", 
        RowBox[{"33426505728", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "10"], " ", 
         SuperscriptBox["U", "10"]}], "-", 
        RowBox[{"1061158912", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"21", "/", "2"}]], " ", 
         SuperscriptBox["U", "10"]}], "-", 
        RowBox[{"8388608", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "T"}]], " ", 
         SuperscriptBox["T", 
          RowBox[{"23", "/", "2"}]], " ", 
         SuperscriptBox["U", "10"]}], "+", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "11"], " ", 
         SuperscriptBox["U", "11"]}], "-", 
        RowBox[{"4194304", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox["T", "11"], " ", 
         SuperscriptBox["U", "11"]}], "+", 
        RowBox[{"1127724059361167019895893750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"1127724059361167019895893750", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SqrtBox[
          RowBox[{"T", " ", "U"}]]}], "+", 
        RowBox[{"699363757743359392183500000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"699363757743359392183500000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"116674343974745810793540000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"116674343974745810793540000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"8157681784237738072320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"8157681784237738072320000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"285804667115436268800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"285804667115436268800000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"5449720772499075072000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"5449720772499075072000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"58223512526699520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"58223512526699520000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"13", "/", "2"}]]}], "+", 
        RowBox[{"343438230572236800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"343438230572236800", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"1044943906406400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"1044943906406400", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"17", "/", "2"}]]}], "+", 
        RowBox[{"1392771072000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"1392771072000", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"19", "/", "2"}]]}], "+", 
        RowBox[{"530579456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"21", "/", "2"}]]}], "+", 
        RowBox[{"530579456", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", " ", "U"}], ")"}], 
          RowBox[{"21", "/", "2"}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "-", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4194304", " ", 
            SuperscriptBox["T", "11"], " ", 
            SuperscriptBox["U", "11"]}], "+", 
           RowBox[{"530579456", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{"63", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"563862029680583509947946875", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"11644702505339904000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"52", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"174157317734400", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"119", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"174096384000", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{"247", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"12963815997193978977060000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"25", "+", 
              RowBox[{"9", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"20414619079674019200000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"81", "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"21464889410764800", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"225", "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"227071698854128128000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"187", "+", 
              RowBox[{"24", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"254927555757429314760000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"133", "+", 
              RowBox[{"32", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"17484093943583984804587500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"63", "+", 
              RowBox[{"40", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"U", "+", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4194304", " ", 
            SuperscriptBox["T", "11"], " ", 
            SuperscriptBox["U", "11"]}], "-", 
           RowBox[{"530579456", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "63"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
           RowBox[{"563862029680583509947946875", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"11644702505339904000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "52"}], "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"174157317734400", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "119"}], "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"174096384000", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "247"}], "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"12963815997193978977060000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "25"}], "+", 
              RowBox[{"9", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"20414619079674019200000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "81"}], "+", 
              RowBox[{"14", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"21464889410764800", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "225"}], "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"227071698854128128000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "187"}], "+", 
              RowBox[{"24", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"254927555757429314760000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "133"}], "+", 
              RowBox[{"32", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
           RowBox[{"17484093943583984804587500", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "63"}], "+", 
              RowBox[{"40", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"25373791335626257947657609375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"33554432", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"25373791335626257947657609375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"33554432", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"25373791335626257947657609375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"8457930445208752649219203125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"1691586089041750529843840625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"241655155577392932834834375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"26850572841932548092759375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"2440961167448413462978125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"187766243649877958690625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"12517749576658530579375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"736338210391678269375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"38754642652193593125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1845459173913980625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"80237355387564375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"3209494215502575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"118870156129725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"4098970901025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"132224867775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"4006814175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"114480405", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"3094065", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"79335", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"1935", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{"45", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "2"]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], 
       RowBox[{"2", " ", "T"}]], "+", 
      FractionBox[
       RowBox[{"25373791335626257947657609375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"25373791335626257947657609375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"6202482326486418609427415625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"6202482326486418609427415625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3947034207764084569635628125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"187954009893527836649315625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"102032176799343682752485625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"5370114568386509618551875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"922140885480511752680625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"4172583192219510193125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"4172583192219510193125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"114541499394261064125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"11195785655078149125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"123030611594265375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"19613575761404625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"356610468389175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"23774031225945", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"91088242245", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"20568312765", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"267120945", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"12720045", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"68757", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"5289", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"43", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "2"]}]], "+", 
      FractionBox[
       RowBox[{"3947034207764084569635628125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"3947034207764084569635628125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"458957466019079601120421875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"458957466019079601120421875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"83049446232023927821790625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"21355571888234724297031875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"2123068550292341011985625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"21445136871639808201875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"1455552276355643090625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"679257728965966775625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"34628825398264972875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"781101324772894125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"31472947152021375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"2280648344349375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"74639400360525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"552884447115", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"14828318505", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"1434998565", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"31060575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"295815", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"4797", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"123", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "+", 
      FractionBox[
       RowBox[{"83049446232023927821790625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"83049446232023927821790625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"6076788748684677645496875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"6076788748684677645496875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2951583106503986284955625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"17260719921075943186875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"2615260594102415634375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"82836308410483753125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"71791467289085919375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"844605497518657875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"69854590020340125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1279388095610625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"166876708123125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"606824393175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"31464968535", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"361666305", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"58333275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"252525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"7215", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"39", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       SuperscriptBox["T", "5"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "4"]}]], "+", 
      FractionBox[
       RowBox[{"2951583106503986284955625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"2951583106503986284955625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"75681618115486827819375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"75681618115486827819375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"6638738431183055071875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"469405747659407934375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"27612102803494584375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"5522420560698916875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"238222063402698375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"8955716669274375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"295243406679375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"4278889951875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"108917198775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"2420382195", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"46367475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"1495725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"19425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"185", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "5"]}]], "+", 
      FractionBox[
       RowBox[{"6638738431183055071875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"6638738431183055071875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"251195508206926408125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"251195508206926408125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"32985268754444881875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"447763829245858125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"328360141446962625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"6438434146018875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"435683513640375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1595910306375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"161903944125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"1766224845", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"65415735", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"250635", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"24255", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"105", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "6"]}]], "+", 
      FractionBox[
       RowBox[{"32985268754444881875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"32985268754444881875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"942436250126996625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"942436250126996625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"46908591635280375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"15636197211760125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"551865783944475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"4149366796575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"106394020425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"4625826975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"84105945", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"623007", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"7161", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"231", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "+", 
      FractionBox[
       RowBox[{"46908591635280375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"46908591635280375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"1015337481283125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1015337481283125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"609202488769875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"2389029367725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"125738387775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1381740525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"100126125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"364095", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"8091", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"62", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       SuperscriptBox["T", "9"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "8"]}]], "+", 
      FractionBox[
       RowBox[{"609202488769875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"609202488769875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"19651693186125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"19651693186125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"539458244325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"12168231075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"222861375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"3229875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"35235", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"261", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "+", 
      FractionBox[
       RowBox[{"539458244325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"539458244325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"6200669475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"6200669475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"233107875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"853875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"37125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"135", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "+", 
      FractionBox[
       RowBox[{"233107875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"233107875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"1726725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1726725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"18975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "+", 
      FractionBox[
       RowBox[{"18975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{"18975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{"69", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", 
         RowBox[{"25", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"69", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", 
         RowBox[{"25", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "12"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "12"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "12"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"33554432", " ", 
         SuperscriptBox["T", 
          RowBox[{"47", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{"138", "+", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
         RowBox[{"25373791335626257947657609375", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"39793459200", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"91", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"6654115717337088000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"40", "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"24443132313600", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"133", "+", 
            RowBox[{"5", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"4510896237444668079583575000", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{"11", "+", 
            RowBox[{"7", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1359613630706289678720000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"57", "+", 
            RowBox[{"10", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"20785793972031728640000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"99", "+", 
            RowBox[{"13", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"5050562214297600", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"255", "+", 
            RowBox[{"14", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"22223684566618249674960000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"70", "+", 
            RowBox[{"17", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"139736430064078848000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"221", "+", 
            RowBox[{"22", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"139872751548671878436700000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"105", "+", 
            RowBox[{"38", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "-", 
         SqrtBox["U"]}], "]"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"33554432", " ", 
         SuperscriptBox["T", 
          RowBox[{"47", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "138"}], "+", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
         RowBox[{"39793459200", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "91"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"25373791335626257947657609375", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"6654115717337088000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "40"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"24443132313600", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "133"}], "+", 
            RowBox[{"5", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"4510896237444668079583575000", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11"}], "+", 
            RowBox[{"7", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1359613630706289678720000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "57"}], "+", 
            RowBox[{"10", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"20785793972031728640000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "99"}], "+", 
            RowBox[{"13", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"5050562214297600", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "255"}], "+", 
            RowBox[{"14", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"22223684566618249674960000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "70"}], "+", 
            RowBox[{"17", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"139736430064078848000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "221"}], "+", 
            RowBox[{"22", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"139872751548671878436700000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "105"}], "+", 
            RowBox[{"38", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "+", 
         SqrtBox["U"]}], "]"}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"1192568192774434123539907640625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", 
         RowBox[{"49", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1192568192774434123539907640625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", 
         RowBox[{"49", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1192568192774434123539907640625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "24"]}]], "-", 
      FractionBox[
       RowBox[{"397522730924811374513302546875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"79504546184962274902660509375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"11357792312137467843237215625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"1261976923570829760359690625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"114725174870075432759971875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"8825013451544264058459375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"588334230102950937230625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"34607895888408878660625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1821468204653098876875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"86736581173957089375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"3771155703215525625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"150846228128621025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"5586897338097075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"192651632348175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"6214568785425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"188320266225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"5380579035", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"145421055", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"3728745", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"90945", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"2115", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{"47", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "2"]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], 
       RowBox[{"2", " ", "T"}]], "+", 
      FractionBox[
       RowBox[{"1192568192774434123539907640625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"33554432", " ", 
        SuperscriptBox["T", "24"]}]], "+", 
      FractionBox[
       RowBox[{"1192568192774434123539907640625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"33554432", " ", 
        SuperscriptBox["T", "24"]}]], "+", 
      FractionBox[
       RowBox[{"583597200719403932796125015625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"583597200719403932796125015625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"93037234897296279141411234375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"35523307869876761126720653125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"1208275777886964664174171875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"510160883996718413762428125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"21968650507035721166803125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"3192026142047925297740625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"12517749576658530579375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"11045073155875174040625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"271282498565355151875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"23990969260881748125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"240712066162693125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"35304436370528325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"594350780648625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"36890738109225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"132224867775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"28047699225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"343441215", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"15470325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"79335", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"5805", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"45", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "2"]}]], "+", 
      FractionBox[
       RowBox[{"93037234897296279141411234375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"93037234897296279141411234375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"43417376285404930265991909375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"43417376285404930265991909375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3947034207764084569635628125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"510160883996718413762428125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"102032176799343682752485625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"8299267969324605774125625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"70933914267731673283125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"4172583192219510193125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"1718122490913915961875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"78370499585547043875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"1599397950725449875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"58840727284213875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"3922715152280925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"118870156129725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"819794180205", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"20568312765", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"1869846615", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"38160135", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"343785", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"5289", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"129", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "+", 
      FractionBox[
       RowBox[{"3947034207764084569635628125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"3947034207764084569635628125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"581346123624167494752534375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"581346123624167494752534375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"35592619813724540495053125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"13446100818518159742575625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"64335410614919424605625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"8248129566015310846875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"226419242988655591875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"173144126991324864375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1822569757803419625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"136382770992092625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"2280648344349375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"273677801321925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"921474078525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"44484955515", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"478332855", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"72474675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"295815", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"7995", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"41", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       SuperscriptBox["T", "5"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "4"]}]], "+", 
      FractionBox[
       RowBox[{"35592619813724540495053125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"35592619813724540495053125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"14757915532519931424778125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"14757915532519931424778125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"327953678500442920550625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"23537345346921740709375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"1408217242978223803125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"71791467289085919375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"12669082462779868125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"488982130142380875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"16632045242938125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"500630124369375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"6675068324925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"157324842675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"3254996745", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"58333275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"1767675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"21645", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"195", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "5"]}]], "+", 
      FractionBox[
       RowBox[{"327953678500442920550625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"327953678500442920550625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"25227206038495609273125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"25227206038495609273125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"844930345786934281875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"93881149531881586875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"1104484112139783375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"714666190208095125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"12538003336984125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"767632857366375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"2567333971125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"239617837305", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"2420382195", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"83461455", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"299145", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"27195", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"111", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "6"]}]], "+", 
      FractionBox[
       RowBox[{"844930345786934281875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"844930345786934281875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"98955806263334645625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"98955806263334645625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2537328365726529375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"109453380482320875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"32192170730094375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1016594865160875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"6915611327625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"161903944125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"6476157765", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"109026225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"751905", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"8085", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"245", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "+", 
      FractionBox[
       RowBox[{"2537328365726529375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"2537328365726529375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"113920865399966625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"113920865399966625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2233742458822875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"1182569537023875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"4149366796575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"197588895075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1982497275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"132166485", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"445005", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"9207", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"66", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       SuperscriptBox["T", "9"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "8"]}]], "+", 
      FractionBox[
       RowBox[{"2233742458822875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"2233742458822875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"609202488769875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"609202488769875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"35835440515875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"880168714425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"17962626825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"300378375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"4005045", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"40455", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"279", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "+", 
      FractionBox[
       RowBox[{"35835440515875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"35835440515875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"899097073875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"899097073875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"9464179725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"321910875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1076625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"43065", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"145", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "+", 
      FractionBox[
       RowBox[{"9464179725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"9464179725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"326351025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"326351025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2220075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"22275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"297", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "+", 
      FractionBox[
       RowBox[{"2220075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"2220075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"22425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"22425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"75", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       SuperscriptBox["T", "13"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "12"]}]], "+", 
      FractionBox[
       RowBox[{"75", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{"75", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", 
         RowBox[{"25", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", 
         RowBox[{"25", "/", "2"}]]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"67108864", " ", 
         SuperscriptBox["T", 
          RowBox[{"49", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16777216", " ", 
          SuperscriptBox["T", "12"], " ", 
          SuperscriptBox["U", "12"]}], "+", 
         RowBox[{"4697022859296768000", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"17", "+", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
         RowBox[{"1192568192774434123539907640625", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"63152547324225353114170050000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"11", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"41571587944063457280000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"39", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"292781091562831872000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"51", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"2480977929830400", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"95", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"2327917363200", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"147", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"629145600", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{"299", "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"83956141696113387660960000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"45", "+", 
            RowBox[{"8", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1518618445385580394455600000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"49", "+", 
            RowBox[{"12", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"494404956620468974080000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"209", "+", 
            RowBox[{"28", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"33831721780835010596876812500", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{"69", "+", 
            RowBox[{"44", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "-", 
         SqrtBox["U"]}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"67108864", " ", 
         SuperscriptBox["T", 
          RowBox[{"49", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16777216", " ", 
          SuperscriptBox["T", "12"], " ", 
          SuperscriptBox["U", "12"]}], "-", 
         RowBox[{"4697022859296768000", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "17"}], "+", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
         RowBox[{"1192568192774434123539907640625", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"629145600", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "299"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"2327917363200", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "147"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"2480977929830400", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "95"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"292781091562831872000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "51"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"41571587944063457280000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "39"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"63152547324225353114170050000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11"}], "+", 
            RowBox[{"4", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"83956141696113387660960000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "45"}], "+", 
            RowBox[{"8", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"1518618445385580394455600000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "49"}], "+", 
            RowBox[{"12", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"494404956620468974080000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "209"}], "+", 
            RowBox[{"28", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"33831721780835010596876812500", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "69"}], "+", 
            RowBox[{"44", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "+", 
         SqrtBox["U"]}], "]"}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"134217728", " ", 
        SuperscriptBox["T", 
         RowBox[{"51", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"134217728", " ", 
        SuperscriptBox["T", 
         RowBox[{"51", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"33554432", " ", 
        SuperscriptBox["T", "25"]}]], "-", 
      FractionBox[
       RowBox[{"19478613815315757351151824796875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "24"]}]], "-", 
      FractionBox[
       RowBox[{"3895722763063151470230364959375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"556531823294735924318623565625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"61836869254970658257624840625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"5621533568633696205238621875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"432425659125668938864509375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"28828377275044595924300625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"1695786898532035054370625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"89251942028001844966875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"4250092477523897379375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"184786629457560755625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"7391465178302430225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"273757969566756675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"9439929985060575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"304513870485825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"9227693045025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"263648372715", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"7125631695", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"182708505", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"4456305", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"103635", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"2303", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{"49", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "2"]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], 
       RowBox[{"2", " ", "T"}]], "+", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", "25"]}]], "+", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", "25"]}]], "+", 
      FractionBox[
       RowBox[{"3577704578323302370619722921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"49", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3577704578323302370619722921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"49", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"9143022811270661613805958578125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "24"]}]], "-", 
      FractionBox[
       RowBox[{"874550008034585023929265603125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"238513638554886824707981528125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"6309884617854148801798453125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"2179778322531433222439465625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"79425121063898376526134375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"10001681911750165932920625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"34607895888408878660625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"27322023069796483153125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"607156068217699625625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"49025024141801833125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"452538684385863075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"61455870719067825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"963258161740875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"55931119068825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"188320266225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"37664053245", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"436263165", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"18643725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"90945", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"6345", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"47", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "2"]}]], "+", 
      FractionBox[
       RowBox[{"9143022811270661613805958578125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "24"]}]], "+", 
      FractionBox[
       RowBox[{"9143022811270661613805958578125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "24"]}]], "+", 
      FractionBox[
       RowBox[{"2139856402637814420252458390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2139856402637814420252458390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"390756386568644372393927184375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"25373791335626257947657609375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"2550804419983592068812140625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"417404359633678702169259375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"28728235278431327679665625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"212801742803195019849375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"11045073155875174040625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"4069237478480327278125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"167936784826172236875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"3129256860115010625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"105913309111584975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"6537858587134875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"184453690546125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"1190023809975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"28047699225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"2404088505", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"46410975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"396675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"5805", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"135", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "+", 
      FractionBox[
       RowBox[{"390756386568644372393927184375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"390756386568644372393927184375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"14472458761801643421997303125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"14472458761801643421997303125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3571126187977028896336996875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"170053627998906137920809375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"52562030472389169902795625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"212801742803195019849375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"23644638089243891094375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"572707496971305320625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"391852497927735219375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"3731928551692716375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"254976484898260125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"3922715152280925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"435857239142325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"1366323633675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"61704938295", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"623282205", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"89040315", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"343785", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"8815", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"43", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       SuperscriptBox["T", "5"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "4"]}]], "+", 
      FractionBox[
       RowBox[{"3571126187977028896336996875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"3571126187977028896336996875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"747445016088215350396115625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"747445016088215350396115625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"67230504092590798712878125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"1222372801683469067506875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"74233166094137797621875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"3849127130807145061875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"173144126991324864375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"27338546367051294375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"954679396944648375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"29648428476541875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"821033403965775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"10136214863775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"222424777575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"4304995695", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"72474675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"2070705", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"23985", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"205", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "5"]}]], "+", 
      FractionBox[
       RowBox[{"67230504092590798712878125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"67230504092590798712878125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"327953678500442920550625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"327953678500442920550625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"89441912318302614695625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"2534791037360802845625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"244090988782892125875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"2533816492555973625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"1466946390427142625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"23284863340113375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"1301638323360375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"4005040994955", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"346114653885", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"3254996745", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"104999895", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"353535", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"30303", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"117", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "6"]}]], "+", 
      FractionBox[
       RowBox[{"89441912318302614695625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"89441912318302614695625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"5351225523317250451875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"5351225523317250451875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"281643448595644760625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"6258743302125439125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"238222063402698375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"62690016684920625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1791143333854875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"11125113874875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"239617837305", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"8874734715", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"139102425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"897435", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"9065", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"259", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "+", 
      FractionBox[
       RowBox[{"281643448595644760625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"281643448595644760625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"3262279327362680625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3262279327362680625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"265815352599922125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"4598881532870625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"2178417568201875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"6915611327625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"300678753375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"2775496185", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"171326925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"537075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"10395", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"70", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       SuperscriptBox["T", "9"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "8"]}]], "+", 
      FractionBox[
       RowBox[{"265815352599922125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"265815352599922125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"37973621799988875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"37973621799988875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1182569537023875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"62240501948625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1383122265525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"25772464575", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"396499455", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"4895055", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"46035", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"297", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "+", 
      FractionBox[
       RowBox[{"1182569537023875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"1182569537023875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"3981715612875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3981715612875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1466947857375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"13970931975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"433879875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1335015", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"49445", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"155", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "+", 
      FractionBox[
       RowBox[{"1466947857375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"1466947857375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"28392539175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"28392539175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"450675225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"2799225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"25839", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"319", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "+", 
      FractionBox[
       RowBox[{"450675225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"450675225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"1412775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1412775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"26325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"81", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       SuperscriptBox["T", "13"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "12"]}]], "+", 
      FractionBox[
       RowBox[{"26325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"26325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"25", "/", "2"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"25", "/", "2"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"134217728", " ", 
         SuperscriptBox["T", 
          RowBox[{"51", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"58435841445947272053455474390625", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"4614446261791043758080000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"19", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"472567224729600", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"63", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"16777216", " ", 
          SuperscriptBox["T", "12"], " ", 
          SuperscriptBox["U", "12"], " ", 
          RowBox[{"(", 
           RowBox[{"325", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"244236048570511673195520000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"22", "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"147220070400", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{"161", "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"109871879749632000", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"152", "+", 
            RowBox[{"7", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"6334718162904907776000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"135", "+", 
            RowBox[{"11", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"17222417150754816000", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"289", "+", 
            RowBox[{"18", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"48116226532743126182224800000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"77", "+", 
            RowBox[{"19", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"3180181847398490996106420375000", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{"36", "+", 
            RowBox[{"23", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1012412296923720262970400000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"189", "+", 
            RowBox[{"34", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"297719151671348093252515950000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"115", "+", 
            RowBox[{"42", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "-", 
         SqrtBox["U"]}], "]"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"134217728", " ", 
         SuperscriptBox["T", 
          RowBox[{"51", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16777216", " ", 
          SuperscriptBox["T", "12"], " ", 
          SuperscriptBox["U", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "325"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"472567224729600", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "63"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"4614446261791043758080000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "19"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"58435841445947272053455474390625", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"147220070400", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "161"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"244236048570511673195520000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "22"}], "+", 
            RowBox[{"3", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"109871879749632000", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "152"}], "+", 
            RowBox[{"7", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"6334718162904907776000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "135"}], "+", 
            RowBox[{"11", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"17222417150754816000", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "289"}], "+", 
            RowBox[{"18", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"48116226532743126182224800000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "77"}], "+", 
            RowBox[{"19", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"3180181847398490996106420375000", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "36"}], "+", 
            RowBox[{"23", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1012412296923720262970400000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "189"}], "+", 
            RowBox[{"34", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"297719151671348093252515950000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "115"}], "+", 
            RowBox[{"42", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "+", 
         SqrtBox["U"]}], "]"}]}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"2980227913743310874726229193921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"268435456", " ", 
        SuperscriptBox["T", 
         RowBox[{"53", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2980227913743310874726229193921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"268435456", " ", 
        SuperscriptBox["T", 
         RowBox[{"53", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2980227913743310874726229193921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", "26"]}]], "-", 
      FractionBox[
       RowBox[{"993409304581103624908743064640625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"33554432", " ", 
        SuperscriptBox["T", "25"]}]], "-", 
      FractionBox[
       RowBox[{"198681860916220724981748612928125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16777216", " ", 
        SuperscriptBox["T", "24"]}]], "-", 
      FractionBox[
       RowBox[{"28383122988031532140249801846875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"3153680332003503571138866871875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"286698212000318506467169715625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"22053708615409115882089978125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"1470247241027274392139331875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"86485131825133787772901875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"4551849043428094093310625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"216754716353718766348125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"9424118102335598536875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"376964724093423941475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"13961656447904590425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"481436429238089325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"15530207394777075", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"470612345296275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"13446067008465", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"363407216445", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"9318133755", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"227271555", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"5285385", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"117453", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"2499", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{"51", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "2"]}]], "-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], 
       RowBox[{"2", " ", "T"}]], "+", 
      FractionBox[
       RowBox[{"2980227913743310874726229193921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"134217728", " ", 
        SuperscriptBox["T", "26"]}]], "+", 
      FractionBox[
       RowBox[{"2980227913743310874726229193921875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SqrtBox["U"]}], 
       RowBox[{"134217728", " ", 
        SuperscriptBox["T", "26"]}]], "+", 
      FractionBox[
       RowBox[{"1460896036148681801336386859765625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", 
         RowBox[{"51", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1460896036148681801336386859765625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", "U"}], 
       RowBox[{"67108864", " ", 
        SuperscriptBox["T", 
         RowBox[{"51", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "25"]}]], "-", 
      FractionBox[
       RowBox[{"89601623550452483815298394065625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "24"]}]], "-", 
      FractionBox[
       RowBox[{"6121850056242095167504859221875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"1298574254354383823410121653125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"28107667843168481026193109375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"8216087523387709838425678125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"259455395475401363318705625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"28828377275044595924300625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"89251942028001844966875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"63751387162858460690625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32768", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1293506406202925289375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"96089047317931592925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"821273908700270025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"103839229835666325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"1522569352429125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"83049237405225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"263648372715", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"49879421865", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"548125515", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"22281525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"103635", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"6909", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{"49", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", "U"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "2"]}]], "+", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "25"]}]], "+", 
      FractionBox[
       RowBox[{"58435841445947272053455474390625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"3", "/", "2"}]]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "25"]}]], "+", 
      FractionBox[
       RowBox[{"27429068433811984841417875734375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"49", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"27429068433811984841417875734375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"49", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"20114650184795455550373108871875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", "24"]}]], "-", 
      FractionBox[
       RowBox[{"2623650024103755071787796809375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2097152", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"132507576974937124837767515625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"10898891612657166112197328125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"1509077300214069153996553125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"90015137205751493396285625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"588334230102950937230625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"27322023069796483153125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"9107341023265494384375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"343175168992612831875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"5883002897016219975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"184367612157203475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"10595839779149625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"279655595344125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"1694882396025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"37664053245", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"3053842155", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"55931175", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"454725", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"6345", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "5"]}]], "-", 
      FractionBox[
       RowBox[{"141", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "4"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "2"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "3"]}]], "+", 
      FractionBox[
       RowBox[{"20114650184795455550373108871875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "24"]}]], "+", 
      FractionBox[
       RowBox[{"20114650184795455550373108871875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"8388608", " ", 
        SuperscriptBox["T", "24"]}]], "+", 
      FractionBox[
       RowBox[{"2995798963692940188353441746875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2995798963692940188353441746875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4194304", " ", 
        SuperscriptBox["T", 
         RowBox[{"47", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"93037234897296279141411234375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "23"]}]], "-", 
      FractionBox[
       RowBox[{"17855630939885144481684984375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"695673932722797836948765625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"65536", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"181945490096731741971215625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"638405228409585059548125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"62588747883292652896875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"1356412492826775759375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"839683924130861184375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"7301599340268358125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"458957672816868225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"6537858587134875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"676330198669125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"1983373016625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"84143097675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"801362835", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"108292275", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"396675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"9675", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{"45", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       SuperscriptBox["T", "5"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "3"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "4"]}]], "+", 
      FractionBox[
       RowBox[{"93037234897296279141411234375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"93037234897296279141411234375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "23"]}]], "+", 
      FractionBox[
       RowBox[{"39282388067747317859706965625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"39282388067747317859706965625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"1048576", " ", 
        SuperscriptBox["T", 
         RowBox[{"45", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"3571126187977028896336996875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", "22"]}]], "-", 
      FractionBox[
       RowBox[{"262810152361945849513978125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"131072", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"4043233113260705377138125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16384", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"212801742803195019849375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"9736027448512190450625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"391852497927735219375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"55978928275390745625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"1784835394287820875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"50995296979652025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1307571717426975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"15029559970425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"308524691475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"5609539845", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"89040315", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"2406495", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"26445", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{"215", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "6"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "4"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "5"]}]], "+", 
      FractionBox[
       RowBox[{"3571126187977028896336996875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"3571126187977028896336996875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"524288", " ", 
        SuperscriptBox["T", "22"]}]], "+", 
      FractionBox[
       RowBox[{"282368117188881354594088125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"282368117188881354594088125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"262144", " ", 
        SuperscriptBox["T", 
         RowBox[{"43", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1222372801683469067506875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "21"]}]], "-", 
      FractionBox[
       RowBox[{"282086031157723630963125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"6928428835452861111375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"588690031770504538875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"5467709273410258875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"2864038190833945125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"41507799867158625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"2134686850311015", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"6081728918265", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"489334510665", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"4304995695", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"130454415", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"414141", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"33579", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{"123", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "5"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "6"]}]], "+", 
      FractionBox[
       RowBox[{"1222372801683469067506875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"1222372801683469067506875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"11", "/", "2"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "21"]}]], "+", 
      FractionBox[
       RowBox[{"149069853863837691159375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"149069853863837691159375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", 
         RowBox[{"41", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"16053676569951751355625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", "20"]}]], "-", 
      FractionBox[
       RowBox[{"732272966348676377625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"14358293457817183875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"488982130142380875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"116424316700566875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"3037156087840875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"17355177644805", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"346114653885", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"11934988065", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"174999825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"1060605", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"10101", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "-", 
      FractionBox[
       RowBox[{"273", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "8"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "6"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "7"]}]], "+", 
      FractionBox[
       RowBox[{"16053676569951751355625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"16053676569951751355625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"13", "/", "2"}]]}], 
       RowBox[{"8192", " ", 
        SuperscriptBox["T", "20"]}]], "+", 
      FractionBox[
       RowBox[{"764460789045321493125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"764460789045321493125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"4096", " ", 
        SuperscriptBox["T", 
         RowBox[{"39", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"8046955674161278875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "19"]}]], "-", 
      FractionBox[
       RowBox[{"578539296835124625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"8955716669274375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"3838164286831875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"11125113874875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"445004554995", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"3803457735", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"218589525", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"641025", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"11655", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{"74", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       SuperscriptBox["T", "9"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "7"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "8"]}]], "+", 
      FractionBox[
       RowBox[{"8046955674161278875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"8046955674161278875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"15", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "19"]}]], "+", 
      FractionBox[
       RowBox[{"2392338173399299125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2392338173399299125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"2048", " ", 
        SuperscriptBox["T", 
         RowBox[{"37", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"78180986058800625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", "18"]}]], "-", 
      FractionBox[
       RowBox[{"2178417568201875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"103734169914375", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"256", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"2104751273625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"36081450405", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"513980775", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"5907825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"51975", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{"315", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "10"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "8"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "9"]}]], "+", 
      FractionBox[
       RowBox[{"78180986058800625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"78180986058800625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"17", "/", "2"}]]}], 
       RowBox[{"1024", " ", 
        SuperscriptBox["T", "18"]}]], "+", 
      FractionBox[
       RowBox[{"2233742458822875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"2233742458822875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"512", " ", 
        SuperscriptBox["T", 
         RowBox[{"35", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"6915611327625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", "17"]}]], "-", 
      FractionBox[
       RowBox[{"2305203775875", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"20045250225", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"572721435", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"1631685", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"56265", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{"165", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "9"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "10"]}]], "+", 
      FractionBox[
       RowBox[{"6915611327625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"6915611327625", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"19", "/", "2"}]]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "17"]}]], "+", 
      FractionBox[
       RowBox[{"293389571475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"293389571475", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", 
         RowBox[{"33", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"41912795925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", "16"]}]], "-", 
      FractionBox[
       RowBox[{"607431825", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"3471039", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"29667", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "13"]}]], "-", 
      FractionBox[
       RowBox[{"341", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "12"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "10"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "11"]}]], "+", 
      FractionBox[
       RowBox[{"41912795925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"41912795925", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"21", "/", "2"}]]}], 
       RowBox[{"128", " ", 
        SuperscriptBox["T", "16"]}]], "+", 
      FractionBox[
       RowBox[{"614557125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"614557125", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"64", " ", 
        SuperscriptBox["T", 
         RowBox[{"31", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"1781325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "15"]}]], "-", 
      FractionBox[
       RowBox[{"30537", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{"87", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       SuperscriptBox["T", "13"]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "11"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "12"]}]], "+", 
      FractionBox[
       RowBox[{"1781325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"1781325", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"23", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "15"]}]], "+", 
      FractionBox[
       RowBox[{"61425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"61425", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"16", " ", 
        SuperscriptBox["T", 
         RowBox[{"29", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{"351", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", "14"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "T"}]], " ", 
        SuperscriptBox["U", "12"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["T", "13"]}]], "+", 
      FractionBox[
       RowBox[{"351", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"25", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{"351", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", 
         RowBox[{"25", "/", "2"}]]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["T", "14"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "13"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"U", "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]}]], " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["U", "13"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["T", 
         RowBox[{"27", "/", "2"}]]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"268435456", " ", 
         SuperscriptBox["T", 
          RowBox[{"53", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "-", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", "13"], " ", 
          SuperscriptBox["U", "13"]}], "+", 
         RowBox[{"87897503799705600", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"28", "+", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
         RowBox[{"2980227913743310874726229193921875", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"914208304122119397462271200000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"11", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"5888802816", " ", 
          SuperscriptBox["T", "12"], " ", 
          SuperscriptBox["U", "12"], " ", 
          RowBox[{"(", 
           RowBox[{"175", "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"75149553406311284060160000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"65", "+", 
            RowBox[{"7", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"527365287061833572352000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"95", "+", 
            RowBox[{"8", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"7471418572800", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{"345", "+", 
            RowBox[{"8", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"2049467640939823104000", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"153", "+", 
            RowBox[{"10", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"58515345992132234328358134900000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"30", "+", 
            RowBox[{"11", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"233743365783789088213821897562500", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{"25", "+", 
            RowBox[{"16", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"3625772031737856000", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"323", "+", 
            RowBox[{"16", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1251709748923872325127040000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"231", "+", 
            RowBox[{"32", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
         RowBox[{"1190876606685392373010063800000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"161", "+", 
            RowBox[{"40", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "-", 
         SqrtBox["U"]}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"268435456", " ", 
         SuperscriptBox["T", 
          RowBox[{"53", "/", "2"}]]}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"U", "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}]}]], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", "13"], " ", 
          SuperscriptBox["U", "13"]}], "-", 
         RowBox[{"87897503799705600", " ", 
          SuperscriptBox["T", "10"], " ", 
          SuperscriptBox["U", "10"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "28"}], "+", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}], ")"}]}], "-", 
         RowBox[{"5888802816", " ", 
          SuperscriptBox["T", "12"], " ", 
          SuperscriptBox["U", "12"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "175"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"914208304122119397462271200000", " ", 
          SuperscriptBox["T", "4"], " ", 
          SuperscriptBox["U", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "11"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"2980227913743310874726229193921875", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"75149553406311284060160000", " ", 
          SuperscriptBox["T", "6"], " ", 
          SuperscriptBox["U", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "65"}], "+", 
            RowBox[{"7", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"7471418572800", " ", 
          SuperscriptBox["T", "11"], " ", 
          SuperscriptBox["U", "11"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "345"}], "+", 
            RowBox[{"8", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"527365287061833572352000", " ", 
          SuperscriptBox["T", "7"], " ", 
          SuperscriptBox["U", "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "95"}], "+", 
            RowBox[{"8", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"2049467640939823104000", " ", 
          SuperscriptBox["T", "8"], " ", 
          SuperscriptBox["U", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "153"}], "+", 
            RowBox[{"10", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"58515345992132234328358134900000", " ", 
          SuperscriptBox["T", "2"], " ", 
          SuperscriptBox["U", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "30"}], "+", 
            RowBox[{"11", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"3625772031737856000", " ", 
          SuperscriptBox["T", "9"], " ", 
          SuperscriptBox["U", "9"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "323"}], "+", 
            RowBox[{"16", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"233743365783789088213821897562500", " ", "T", " ", "U", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "25"}], "+", 
            RowBox[{"16", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"1251709748923872325127040000", " ", 
          SuperscriptBox["T", "5"], " ", 
          SuperscriptBox["U", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "231"}], "+", 
            RowBox[{"32", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "-", 
         RowBox[{"1190876606685392373010063800000", " ", 
          SuperscriptBox["T", "3"], " ", 
          SuperscriptBox["U", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "161"}], "+", 
            RowBox[{"40", " ", 
             SqrtBox[
              RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{
         SqrtBox["T"], "+", 
         SqrtBox["U"]}], "]"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "U"], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"157952079428395476360490147277859375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"]}], 
         RowBox[{"536870912", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"157952079428395476360490147277859375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"]}], 
         RowBox[{"536870912", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"157952079428395476360490147277859375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"134217728", " ", 
          SuperscriptBox["T", "27"]}]], "-", 
        FractionBox[
         RowBox[{"52650693142798492120163382425953125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", "26"]}]], "-", 
        FractionBox[
         RowBox[{"10530138628559698424032676485190625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"1504305518365671203433239497884375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"16777216", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"167145057596185689270359944209375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"15195005236016880842759994928125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"1168846556616683141750768840625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"77923103774445542783384589375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"4583711986732090751963799375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"241247999301688986945463125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"11487999966747094616450625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"499478259423786722454375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"65536", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"19979130376951468898175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"32768", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"739967791738943292525", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"25516130749618734225", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"823100991923184975", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"24942454300702575", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"712641551448645", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"19260582471585", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"493861089015", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"12045392415", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"280125405", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"6225009", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "5"]}]], "-", 
        FractionBox[
         RowBox[{"132447", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "4"]}]], "-", 
        FractionBox[
         RowBox[{"2703", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "3"]}]], "-", 
        FractionBox[
         RowBox[{"53", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "2"]}]], "-", 
        FractionBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "T"}], "-", "U"}]], 
         RowBox[{"2", " ", "T"}]], "+", 
        FractionBox[
         RowBox[{"157952079428395476360490147277859375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SqrtBox["U"]}], 
         RowBox[{"134217728", " ", 
          SuperscriptBox["T", "27"]}]], "+", 
        FractionBox[
         RowBox[{"38742962878663041371440979520984375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", "U"}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"53", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"38742962878663041371440979520984375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", "U"}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"53", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"24835232614527590622718576616015625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "26"]}]], "-", 
        FractionBox[
         RowBox[{"596045582748662174945245838784375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"652811828724725239225745442478125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"34690483652038539282527535590625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"6020662452006688635810564028125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"110268543077045579410449890625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"27934697579518213450647305625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"778366186426204089956116875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"77381433738277599586280625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"216754716353718766348125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"141361771535033978053125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32768", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"2638753068653967590325", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"181501533822759675525", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"1444309287714267975", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"170832281342547825", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"2353061726481375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"121014603076185", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"363407216445", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"65226936285", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"681814665", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"26426925", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"117453", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "5"]}]], "-", 
        FractionBox[
         RowBox[{"7497", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "4"]}]], "-", 
        FractionBox[
         RowBox[{"51", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "3"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "2"]}]], "+", 
        FractionBox[
         RowBox[{"24835232614527590622718576616015625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "26"]}]], "+", 
        FractionBox[
         RowBox[{"1460896036148681801336386859765625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", 
           RowBox[{"51", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"1460896036148681801336386859765625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", 
           RowBox[{"51", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"268804870651357451445895182196875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"140802551293568188852611762103125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"14284316797898222057511338184375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"590261024706538101550055296875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"41080437616938549192128390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"4929652514032625903055406875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"259455395475401363318705625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"1517283014476031364436875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"63751387162858460690625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"19402596093043879340625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"672623331225521150475", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"10676560813103510325", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"311517689506998975", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"16748262876720375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"415246187026125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"2372835354435", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"49879421865", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"3836878605", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"66844575", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"518175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"6909", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "5"]}]], "-", 
        FractionBox[
         RowBox[{"147", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "4"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "3"]}]], "+", 
        FractionBox[
         RowBox[{"268804870651357451445895182196875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"5", "/", "2"}]]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "25"]}]], "+", 
        FractionBox[
         RowBox[{"20114650184795455550373108871875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"20114650184795455550373108871875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"20114650184795455550373108871875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"485861115574769457738480890625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"76292241288600162785381296875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"2515128833690115256660921875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"65536", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"570095868969759458176475625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"1765002690308852811691875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"154824797395513404534375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"3035780341088498128125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"1715875844963064159375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"13727006759704513275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"798926319347881725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"10595839779149625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"1025403849595125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"2824803993375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"112992159735", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"1017947385", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"130506075", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"454725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"10575", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"47", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         SuperscriptBox["T", "5"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "4"]}]], "+", 
        FractionBox[
         RowBox[{"20114650184795455550373108871875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"7", "/", "2"}]]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "24"]}]], "+", 
        FractionBox[
         RowBox[{"2139856402637814420252458390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"2139856402637814420252458390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"196411940338736589298534828125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"14609152587178754575924078125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"909727450483658709856078125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"12129699339782116131414375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"563298730949633876071875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"23059012378055187909375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"839683924130861184375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"109523990104025371875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"3212703709718077575", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"84992161632753375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"2028990596007375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"21817103182875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"420715488375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"7212265515", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"108292275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"2776725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"29025", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"225", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "5"]}]], "+", 
        FractionBox[
         RowBox[{"196411940338736589298534828125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"9", "/", "2"}]]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "23"]}]], "+", 
        FractionBox[
         RowBox[{"7856477613549463571941393125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"7856477613549463571941393125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"1103802639920172567958708125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"4043233113260705377138125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"808646622652141075427625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"17524849407321942811125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"1332298492954299745875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"11195785655078149125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"5354506182863462625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"71393415771512835", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"3399686465310135", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"9017735982255", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"678754321245", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"5609539845", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"160272567", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"481299", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"37023", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"129", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "6"]}]], "+", 
        FractionBox[
         RowBox[{"1103802639920172567958708125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"11", "/", "2"}]]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "22"]}]], "+", 
        FractionBox[
         RowBox[{"8556609611784283472548125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"8556609611784283472548125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"470143385262872718271875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"43880049291201453705375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"1766070095311513616625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"30983685882658133625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"954679396944648375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"207538999335793125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"4980935984059035", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"26354158645815", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"489334510665", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"15784984215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"217424025", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"1242423", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"11193", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"287", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "7"]}]], "+", 
        FractionBox[
         RowBox[{"470143385262872718271875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"13", "/", "2"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "21"]}]], "+", 
        FractionBox[
         RowBox[{"11466911835679822396875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"11466911835679822396875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"1987598051517835882125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"18460663017193522125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"1187528030345782125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"16632045242938125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"6508191616801875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"17355177644805", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"642784357215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"5114994885", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"274999725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"757575", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"12987", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"78", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         SuperscriptBox["T", "9"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "8"]}]], "+", 
        FractionBox[
         RowBox[{"1987598051517835882125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"15", "/", "2"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "20"]}]], "+", 
        FractionBox[
         RowBox[{"152892157809064298625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"152892157809064298625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"5206853671516121625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"152247183377664375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"3838164286831875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"166876708123125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"3115031884965", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"49444950555", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"655768575", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"7051275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"58275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"333", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "9"]}]], "+", 
        FractionBox[
         RowBox[{"5206853671516121625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"17", "/", "2"}]]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "19"]}]], "+", 
        FractionBox[
         RowBox[{"78180986058800625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"78180986058800625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"4114788739936875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"11526018879375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"3507918789375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"28063350315", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"742416675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"1969275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"63525", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "10"]}]], "+", 
        FractionBox[
         RowBox[{"4114788739936875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"19", "/", "2"}]]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "18"]}]], "+", 
        FractionBox[
         RowBox[{"23513078513925", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", 
           RowBox[{"35", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"23513078513925", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", 
           RowBox[{"35", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"461040755175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"60135750675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"801810009", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"4242381", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"33759", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"363", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "11"]}]], "+", 
        FractionBox[
         RowBox[{"461040755175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"21", "/", "2"}]]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "17"]}]], "+", 
        FractionBox[
         RowBox[{"3810254175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"3810254175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"828316125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"2208843", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"35061", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"93", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         SuperscriptBox["T", "13"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "12"]}]], "+", 
        FractionBox[
         RowBox[{"828316125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"23", "/", "2"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "16"]}]], "+", 
        FractionBox[
         RowBox[{"8906625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"8906625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"71253", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"377", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "13"]}]], "+", 
        FractionBox[
         RowBox[{"71253", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"25", "/", "2"}]]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "15"]}]], "+", 
        FractionBox[
         RowBox[{"189", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"29", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"189", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"29", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "14"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"27", "/", "2"}]]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"157952079428395476360490147277859375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"268435456", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"157952079428395476360490147277859375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"268435456", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"20114650184795455550373108871875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"20114650184795455550373108871875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"196411940338736589298534828125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"196411940338736589298534828125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"1103802639920172567958708125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"1103802639920172567958708125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"470143385262872718271875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"470143385262872718271875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"1987598051517835882125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"1987598051517835882125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"5206853671516121625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"5206853671516121625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"4114788739936875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"4114788739936875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"828316125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"828316125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"71253", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"71253", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"29", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"29", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"24835232614527590622718576616015625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"24835232614527590622718576616015625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"461040755175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"461040755175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"268804870651357451445895182196875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"268804870651357451445895182196875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "+", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"536870912", " ", 
           SuperscriptBox["T", 
            RowBox[{"55", "/", "2"}]]}]], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2574675223653818310447757935600000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"4314668717768048640000", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{"19", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"134217728", " ", 
            SuperscriptBox["T", "13"], " ", 
            SuperscriptBox["U", "13"], " ", 
            RowBox[{"(", 
             RowBox[{"189", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"157952079428395476360490147277859375", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"3867490167187046400", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{"51", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1195426971648", " ", 
            SuperscriptBox["T", "12"], " ", 
            SuperscriptBox["U", "12"], " ", 
            RowBox[{"(", 
             RowBox[{"125", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1389683854540800", " ", 
            SuperscriptBox["T", "11"], " ", 
            SuperscriptBox["U", "11"], " ", 
            RowBox[{"(", 
             RowBox[{"184", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"3081131689658762646466560000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"91", "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"20039880908349675749376000", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"150", "+", 
              RowBox[{"13", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"132975753326853730539966720000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"121", "+", 
              RowBox[{"17", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"62042974948451008512000", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"323", "+", 
              RowBox[{"22", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{
           "7947274436648828999269944517125000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{"39", "+", 
              RowBox[{"25", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2646392459300871940022364000000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"207", "+", 
              RowBox[{"38", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"747978770508125082284230072200000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"125", "+", 
              RowBox[{"46", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "-", 
           SqrtBox["U"]}], "]"}]}], "-", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"536870912", " ", 
           SuperscriptBox["T", 
            RowBox[{"55", "/", "2"}]]}]], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"134217728", " ", 
            SuperscriptBox["T", "13"], " ", 
            SuperscriptBox["U", "13"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "189"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"4314668717768048640000", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "19"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"2574675223653818310447757935600000", " ", 
            SuperscriptBox["T", "3"], " ", 
            SuperscriptBox["U", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"1195426971648", " ", 
            SuperscriptBox["T", "12"], " ", 
            SuperscriptBox["U", "12"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "125"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"3867490167187046400", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "51"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"157952079428395476360490147277859375", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1389683854540800", " ", 
            SuperscriptBox["T", "11"], " ", 
            SuperscriptBox["U", "11"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "184"}], "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"3081131689658762646466560000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "91"}], "+", 
              RowBox[{"10", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"20039880908349675749376000", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "150"}], "+", 
              RowBox[{"13", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"132975753326853730539966720000", " ", 
            SuperscriptBox["T", "5"], " ", 
            SuperscriptBox["U", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "121"}], "+", 
              RowBox[{"17", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"62042974948451008512000", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "323"}], "+", 
              RowBox[{"22", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{
           "7947274436648828999269944517125000", " ", "T", " ", "U", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "39"}], "+", 
              RowBox[{"25", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"2646392459300871940022364000000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "207"}], "+", 
              RowBox[{"38", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"747978770508125082284230072200000", " ", 
            SuperscriptBox["T", "2"], " ", 
            SuperscriptBox["U", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "125"}], "+", 
              RowBox[{"46", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"Erf", "[", 
          RowBox[{
           SqrtBox["T"], "+", 
           SqrtBox["U"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "U"], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"8687364368561751199826958100282265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"]}], 
         RowBox[{"1073741824", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"8687364368561751199826958100282265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"]}], 
         RowBox[{"1073741824", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"8687364368561751199826958100282265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"268435456", " ", 
          SuperscriptBox["T", "28"]}]], "-", 
        FractionBox[
         RowBox[{"2895788122853917066608986033427421875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"134217728", " ", 
          SuperscriptBox["T", "27"]}]], "-", 
        FractionBox[
         RowBox[{"579157624570783413321797206685484375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", "26"]}]], "-", 
        FractionBox[
         RowBox[{"82736803510111916188828172383640625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"9192978167790212909869796931515625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"16777216", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"835725287980928446351799721046875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"64286560613917572796292286234375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"4285770707594504853086152415625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"252104159270264991358008965625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"13268639961592894282000471875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"631839998171090203904784375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"27471304268308269734990625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"1098852170732330789399625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"65536", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"40698228545641881088875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"32768", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"1403387191229030382375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"45270554555775173625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"1371834986538641625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"39195285329675475", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"1059332035937175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"27162359895825", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"662496582825", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"15406897275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"342375495", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"7284585", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "5"]}]], "-", 
        FractionBox[
         RowBox[{"148665", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "4"]}]], "-", 
        FractionBox[
         RowBox[{"2915", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "3"]}]], "-", 
        FractionBox[
         RowBox[{"55", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "2"]}]], "-", 
        FractionBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "T"}], "-", "U"}]], 
         RowBox[{"2", " ", "T"}]], "+", 
        FractionBox[
         RowBox[{"8687364368561751199826958100282265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SqrtBox["U"]}], 
         RowBox[{"268435456", " ", 
          SuperscriptBox["T", "28"]}]], "+", 
        FractionBox[
         RowBox[{"4264706144566677861733233976502203125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", "U"}], 
         RowBox[{"268435456", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"4264706144566677861733233976502203125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", "U"}], 
         RowBox[{"268435456", " ", 
          SuperscriptBox["T", 
           RowBox[{"55", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"684459010856380397562123971537390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "27"]}]], "-", 
        FractionBox[
         RowBox[{"263253465713992460600816912129765625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "26"]}]], "-", 
        FractionBox[
         RowBox[{"4512916555097013610299718493653125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"3844336324712270853218278716815625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"167145057596185689270359944209375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"24545777688950345976766145653125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"389615518872227713916922946875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"87090527747909724287312188125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"2171231993715200882509168125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"195295999434700608479660625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"499478259423786722454375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"299686955654272033472625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32768", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"5179774542172603047675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"331709699745043544925", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"2469302975769554925", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"274366997307728325", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"3563207757243225", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"173345242244265", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"493861089015", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"84317746905", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"840376215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"31125045", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"132447", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "5"]}]], "-", 
        FractionBox[
         RowBox[{"8109", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "4"]}]], "-", 
        FractionBox[
         RowBox[{"53", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "3"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", "U"}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "2"]}]], "+", 
        FractionBox[
         RowBox[{"684459010856380397562123971537390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"33554432", " ", 
          SuperscriptBox["T", "27"]}]], "+", 
        FractionBox[
         RowBox[{"322858023988858678095341496008203125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"53", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"322858023988858678095341496008203125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"53", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"14901139568716554373631145969609375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", "26"]}]], "-", 
        FractionBox[
         RowBox[{"1958435486174175717677236327434375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"797881123996886403498133318584375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"66227286972073574993916204309375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"2315639404617957167619447703125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"139673487897591067253236528125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"14788957542097877709166220625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"696432903644498396276525625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"3684830178013219027918125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"141361771535033978053125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"39581296029809513854875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"1270510736759317728675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"18776020740285483675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"512496844027643475", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"25883678991295125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"605073015380925", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"3270664948005", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"65226936285", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"4772702655", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"79280775", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"587265", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"7497", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "5"]}]], "-", 
        FractionBox[
         RowBox[{"153", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "4"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "3"]}]], "+", 
        FractionBox[
         RowBox[{"14901139568716554373631145969609375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"5", "/", "2"}]]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", "26"]}]], "+", 
        FractionBox[
         RowBox[{"2240040588761312095382459851640625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", 
           RowBox[{"51", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"2240040588761312095382459851640625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4194304", " ", 
          SuperscriptBox["T", 
           RowBox[{"51", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"140802551293568188852611762103125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "25"]}]], "-", 
        FractionBox[
         RowBox[{"109513095450553035774253592746875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"2164290423923973039016869421875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"287563063318569844344898734375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"8216087523387709838425678125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"65536", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"1643217504677541967685135625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"4551849043428094093310625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"361257860589531277246875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"6467532031014626446875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"3363116656127605752375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"24911975230574857425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"1349909987863662225", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"16748262876720375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"1522569352429125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"3954725590725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"149638265595", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"1278959535", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"155970675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"518175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"11515", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{"49", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         SuperscriptBox["T", "5"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "3"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "4"]}]], "+", 
        FractionBox[
         RowBox[{"140802551293568188852611762103125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"7", "/", "2"}]]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "25"]}]], "+", 
        FractionBox[
         RowBox[{"60343950554386366651119326615625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"60343950554386366651119326615625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"11174805658219697527985060484375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", "24"]}]], "-", 
        FractionBox[
         RowBox[{"839214654174601790639194265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"524288", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"52817705507492420389879359375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"2850479344848797290882378125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"33535051115868203422145625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"1393423176559620640809375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"51608265798504468178125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"1715875844963064159375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"205905101395567699125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"5592484235435172075", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"137745917128945125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"3076211548785375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"31072843927125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"564960798675", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"9161526465", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"130506075", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"3183075", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"31725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{"235", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "6"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "4"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "5"]}]], "+", 
        FractionBox[
         RowBox[{"11174805658219697527985060484375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"9", "/", "2"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", "24"]}]], "+", 
        FractionBox[
         RowBox[{"903494925558188310773260209375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"903494925558188310773260209375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"32140135691793260067032971875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "23"]}]], "-", 
        FractionBox[
         RowBox[{"3820855292031366581395528125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"12129699339782116131414375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"2140535177608608729073125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"41506222280499338236875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"2854925342044928026875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"21904798020805074375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"9638111129154232725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"118989026285854725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"5275375549619175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"13090261909725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"925574074425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"7212265515", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"194926095", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"555345", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"40635", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{"135", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "7"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "5"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "6"]}]], "+", 
        FractionBox[
         RowBox[{"32140135691793260067032971875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"11", "/", "2"}]]}], 
         RowBox[{"131072", " ", 
          SuperscriptBox["T", "23"]}]], "+", 
        FractionBox[
         RowBox[{"4047276346373966082515263125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"4047276346373966082515263125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"28302631792824937639966875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "22"]}]], "-", 
        FractionBox[
         RowBox[{"1347744371086901792379375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"110990712913038971137125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"3996895478862899237625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"63442785378776178375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"1784835394287820875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"356967078857564175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"7932601752390315", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"39076855923105", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"678754321245", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"20568312765", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"267120945", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"1443897", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"12341", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "9"]}]], "-", 
        FractionBox[
         RowBox[{"301", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "8"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "6"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "7"]}]], "+", 
        FractionBox[
         RowBox[{"28302631792824937639966875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"13", "/", "2"}]]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", "22"]}]], "+", 
        FractionBox[
         RowBox[{"1410430155788618154815625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"1410430155788618154815625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"31342892350858181218125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "21"]}]], "-", 
        FractionBox[
         RowBox[{"4793618830131251245125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"39836167563417600375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"2318507106865574625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"29648428476541875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"10673434251555075", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"26354158645815", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"908764091235", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"6764993235", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"341666325", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"887445", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"14391", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{"82", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         SuperscriptBox["T", "9"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "7"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "8"]}]], "+", 
        FractionBox[
         RowBox[{"31342892350858181218125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"15", "/", "2"}]]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "21"]}]], "+", 
        FractionBox[
         RowBox[{"9937990257589179410625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"9937990257589179410625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"8192", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"350752597326676920375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "20"]}]], "-", 
        FractionBox[
         RowBox[{"10687752273112039125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"1024", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"282744769129948125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"6508191616801875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"260327664672075", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"4499490500505", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"66494933505", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"824999175", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"8333325", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"64935", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{"351", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "10"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "8"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "9"]}]], "+", 
        FractionBox[
         RowBox[{"350752597326676920375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"17", "/", "2"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", "20"]}]], "+", 
        FractionBox[
         RowBox[{"10992246639867367875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"10992246639867367875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"152247183377664375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "19"]}]], "-", 
        FractionBox[
         RowBox[{"7249865875126875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"18541856458125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"5191719808275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"128", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"38457183765", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"947221275", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"2350425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"71225", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{"185", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "11"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "9"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "10"]}]], "+", 
        FractionBox[
         RowBox[{"152247183377664375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"19", "/", "2"}]]}], 
         RowBox[{"256", " ", 
          SuperscriptBox["T", "19"]}]], "+", 
        FractionBox[
         RowBox[{"7406619731886375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"7406619731886375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"37", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"39188464189875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "18"]}]], "-", 
        FractionBox[
         RowBox[{"701583757875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"84190050945", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"1039383345", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"5120115", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"38115", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "13"]}]], "-", 
        FractionBox[
         RowBox[{"385", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "12"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "10"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "11"]}]], "+", 
        FractionBox[
         RowBox[{"39188464189875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"21", "/", "2"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "18"]}]], "+", 
        FractionBox[
         RowBox[{"712517530725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"35", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"712517530725", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"35", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"5466886425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "17"]}]], "-", 
        FractionBox[
         RowBox[{"1093377285", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"2699697", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"39897", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{"99", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         SuperscriptBox["T", "13"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "11"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "12"]}]], "+", 
        FractionBox[
         RowBox[{"5466886425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"23", "/", "2"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "17"]}]], "+", 
        FractionBox[
         RowBox[{"276105375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"276105375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"11044215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "16"]}]], "-", 
        FractionBox[
         RowBox[{"81809", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{"403", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", "14"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "12"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "13"]}]], "+", 
        FractionBox[
         RowBox[{"11044215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"25", "/", "2"}]]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", "16"]}]], "+", 
        FractionBox[
         RowBox[{"82215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"82215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"16", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"203", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "15"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], "-", "U"}]], " ", 
          SuperscriptBox["U", "13"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "14"]}]], "+", 
        FractionBox[
         RowBox[{"203", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", 
           RowBox[{"27", "/", "2"}]]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["T", "15"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "14"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"29", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "14"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"29", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"8687364368561751199826958100282265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"536870912", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"8687364368561751199826958100282265625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"536870912", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"140802551293568188852611762103125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"51", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"140802551293568188852611762103125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "3"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"1048576", " ", 
          SuperscriptBox["T", 
           RowBox[{"51", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"11174805658219697527985060484375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"11174805658219697527985060484375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "4"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"2097152", " ", 
          SuperscriptBox["T", 
           RowBox[{"49", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"32140135691793260067032971875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"32140135691793260067032971875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "5"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"262144", " ", 
          SuperscriptBox["T", 
           RowBox[{"47", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"28302631792824937639966875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"28302631792824937639966875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "6"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"16384", " ", 
          SuperscriptBox["T", 
           RowBox[{"45", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"31342892350858181218125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"31342892350858181218125", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "7"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"2048", " ", 
          SuperscriptBox["T", 
           RowBox[{"43", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"350752597326676920375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"350752597326676920375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "8"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4096", " ", 
          SuperscriptBox["T", 
           RowBox[{"41", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"152247183377664375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"152247183377664375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"512", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"5466886425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", 
           RowBox[{"35", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"5466886425", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "11"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"8", " ", 
          SuperscriptBox["T", 
           RowBox[{"35", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"11044215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"11044215", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "12"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"32", " ", 
          SuperscriptBox["T", 
           RowBox[{"33", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"203", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"203", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "13"], " ", 
          SqrtBox[
           RowBox[{"T", " ", "U"}]]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["T", 
           RowBox[{"31", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"684459010856380397562123971537390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"684459010856380397562123971537390625", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"67108864", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"39188464189875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"39188464189875", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox["U", "9"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], 
         RowBox[{"64", " ", 
          SuperscriptBox["T", 
           RowBox[{"39", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{"14901139568716554373631145969609375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "+", 
        FractionBox[
         RowBox[{"14901139568716554373631145969609375", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"T", " ", "U"}]]}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"T", " ", "U"}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], 
         RowBox[{"8388608", " ", 
          SuperscriptBox["T", 
           RowBox[{"57", "/", "2"}]]}]], "+", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"1073741824", " ", 
           SuperscriptBox["T", 
            RowBox[{"57", "/", "2"}]]}]], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SqrtBox[
            RowBox[{"T", " ", "U"}]]}]], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"268435456", " ", 
            SuperscriptBox["T", "14"], " ", 
            SuperscriptBox["U", "14"]}], "+", 
           RowBox[{"370582361210880", " ", 
            SuperscriptBox["T", "12"], " ", 
            SuperscriptBox["U", "12"], " ", 
            RowBox[{"(", 
             RowBox[{"50", "+", 
              SqrtBox[
               RowBox[{"T", " ", "U"}]]}], ")"}]}], "+", 
           RowBox[{"8687364368561751199826958100282265625", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"4108175586211683528622080000", " ", 
            SuperscriptBox["T", "7"], " ", 
            SuperscriptBox["U", "7"], " ", 
            RowBox[{"(", 
             RowBox[{"45", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"13623099392", " ", 
            SuperscriptBox["T", "13"], " ", 
            SuperscriptBox["U", "13"], " ", 
            RowBox[{"(", 
             RowBox[{"405", "+", 
              RowBox[{"4", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"1144300099401697026865670193600000", " ", 
            SuperscriptBox["T", "4"], " ", 
            SuperscriptBox["U", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"27", "+", 
              RowBox[{"5", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"15324614812267399102464000", " ", 
            SuperscriptBox["T", "8"], " ", 
            SuperscriptBox["U", "8"], " ", 
            RowBox[{"(", 
             RowBox[{"85", "+", 
              RowBox[{"6", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"82184166052724736000", " ", 
            SuperscriptBox["T", "10"], " ", 
            SuperscriptBox["U", "10"], " ", 
            RowBox[{"(", 
             RowBox[{"189", "+", 
              RowBox[{"8", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"61146089599795200", " ", 
            SuperscriptBox["T", "11"], " ", 
            SuperscriptBox["U", "11"], " ", 
            RowBox[{"(", 
             RowBox[{"391", "+", 
              RowBox[{"12", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"115927579823410944573304320000", " ", 
            SuperscriptBox["T", "6"], " ", 
            SuperscriptBox["U", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"143", "+", 
              RowBox[{"16", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"15964274255741779968000", " ", 
            SuperscriptBox["T", "9"], " ", 
            SuperscriptBox["U", "9"], " ", 
            RowBox[{"(", 
             RowBox[{"361", "+", 
              RowBox[{"20", " ", 
               SqrtBox[
                RowBox[{"T", " ", "U"}]]}]}], ")"}]}], "+", 
           RowBox[{"794727443664882899926994