; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -wasm-disable-explicit-locals -wasm-keep-registers -fast-isel -fast-isel-abort=1 | FileCheck %s

; TODO: Merge this with offset.ll when fast-isel matches better.

target triple = "wasm32-unknown-unknown"

define void @store_i8_with_variable_gep_offset(ptr %p, i32 %idx) {
; CHECK-LABEL: store_i8_with_variable_gep_offset:
; CHECK:         .functype store_i8_with_variable_gep_offset (i32, i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.add $push1=, $0, $1
; CHECK-NEXT:    i32.const $push0=, 0
; CHECK-NEXT:    i32.store8 0($pop1), $pop0
; CHECK-NEXT:    # fallthrough-return
  %s = getelementptr inbounds i8, ptr %p, i32 %idx
  store i8 0, ptr %s
  ret void
}

define hidden void @store_i8_with_array_alloca_gep(i32 %idx) {
; CHECK-LABEL: store_i8_with_array_alloca_gep:
; CHECK:         .functype store_i8_with_array_alloca_gep (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push3=, __stack_pointer
; CHECK-NEXT:    i32.const $push4=, 32
; CHECK-NEXT:    i32.sub $push5=, $pop3, $pop4
; CHECK-NEXT:    local.copy $push1=, $pop5
; CHECK-NEXT:    i32.add $push2=, $pop1, $0
; CHECK-NEXT:    i32.const $push0=, 0
; CHECK-NEXT:    i32.store8 0($pop2), $pop0
; CHECK-NEXT:    # fallthrough-return
  %A = alloca [30 x i8], align 16
  %s = getelementptr inbounds [30 x i8], ptr %A, i32 0, i32 %idx
  store i8 0, ptr %s, align 1
  ret void
}

define void @store_i32_with_unfolded_gep_offset(ptr %p) {
; CHECK-LABEL: store_i32_with_unfolded_gep_offset:
; CHECK:         .functype store_i32_with_unfolded_gep_offset (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push1=, 24
; CHECK-NEXT:    i32.add $push2=, $0, $pop1
; CHECK-NEXT:    i32.const $push0=, 0
; CHECK-NEXT:    i32.store 0($pop2), $pop0
; CHECK-NEXT:    # fallthrough-return
  %s = getelementptr i32, ptr %p, i32 6
  store i32 0, ptr %s
  ret void
}

define void @store_i32_with_folded_gep_offset(ptr %p) {
; CHECK-LABEL: store_i32_with_folded_gep_offset:
; CHECK:         .functype store_i32_with_folded_gep_offset (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 0
; CHECK-NEXT:    i32.store 24($0), $pop0
; CHECK-NEXT:    # fallthrough-return
  %s = getelementptr inbounds i32, ptr %p, i32 6
  store i32 0, ptr %s
  ret void
}

define i32 @load_i32_with_folded_gep_offset(ptr %p) {
; CHECK-LABEL: load_i32_with_folded_gep_offset:
; CHECK:         .functype load_i32_with_folded_gep_offset (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.load $push0=, 24($0)
; CHECK-NEXT:    # fallthrough-return
  %s = getelementptr inbounds i32, ptr %p, i32 6
  %t = load i32, ptr %s
  ret i32 %t
}

define void @store_i64_with_unfolded_gep_offset(ptr %p) {
; CHECK-LABEL: store_i64_with_unfolded_gep_offset:
; CHECK:         .functype store_i64_with_unfolded_gep_offset (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push1=, 24
; CHECK-NEXT:    i32.add $push2=, $0, $pop1
; CHECK-NEXT:    i64.const $push0=, 0
; CHECK-NEXT:    i64.store 0($pop2), $pop0
; CHECK-NEXT:    # fallthrough-return
  %s = getelementptr i64, ptr %p, i32 3
  store i64 0, ptr %s
  ret void
}

define void @store_i8_with_folded_gep_offset(ptr %p) {
; CHECK-LABEL: store_i8_with_folded_gep_offset:
; CHECK:         .functype store_i8_with_folded_gep_offset (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 0
; CHECK-NEXT:    i32.store8 24($0), $pop0
; CHECK-NEXT:    # fallthrough-return
  %s = getelementptr inbounds i8, ptr %p, i32 24
  store i8 0, ptr %s
  ret void
}

define i32 @load_i8_u_with_folded_offset(ptr %p) {
; CHECK-LABEL: load_i8_u_with_folded_offset:
; CHECK:         .functype load_i8_u_with_folded_offset (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.load8_u $push2=, 24($0)
; CHECK-NEXT:    i32.const $push0=, 255
; CHECK-NEXT:    i32.and $push1=, $pop2, $pop0
; CHECK-NEXT:    # fallthrough-return
  %q = ptrtoint ptr %p to i32
  %r = add nuw i32 %q, 24
  %s = inttoptr i32 %r to ptr
  %t = load i8, ptr %s
  %u = zext i8 %t to i32
  ret i32 %u
}

; TODO: this should be load8_s, need to fold sign-/zero-extend in fast-isel
define i32 @load_i8_s_with_folded_offset(ptr %p) {
; CHECK-LABEL: load_i8_s_with_folded_offset:
; CHECK:         .functype load_i8_s_with_folded_offset (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.load8_u $push3=, 24($0)
; CHECK-NEXT:    i32.const $push0=, 24
; CHECK-NEXT:    i32.shl $push1=, $pop3, $pop0
; CHECK-NEXT:    i32.const $push4=, 24
; CHECK-NEXT:    i32.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    # fallthrough-return
  %q = ptrtoint ptr %p to i32
  %r = add nuw i32 %q, 24
  %s = inttoptr i32 %r to ptr
  %t = load i8, ptr %s
  %u = sext i8 %t to i32
  ret i32 %u
}
