# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,EM3
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m4 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,EM4
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m5 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,EM5

sdiv	w0, w1, w2
udiv	x1, x2, x3

mul	w2, w3, w4
msub	x3, x4, x5, x6

smull	x4, w5, w6
umulh	x5, x6, x7

# ALL:      Iterations:        100
# ALL-NEXT: Instructions:      600

# EM3-NEXT: Total Cycles:      3305
# EM4-NEXT: Total Cycles:      3303
# EM5-NEXT: Total Cycles:      2603

# ALL-NEXT: Total uOps:        600

# ALL:      Dispatch Width:    6

# EM3-NEXT: uOps Per Cycle:    0.18
# EM3-NEXT: IPC:               0.18
# EM3-NEXT: Block RThroughput: 33.0

# EM4-NEXT: uOps Per Cycle:    0.18
# EM4-NEXT: IPC:               0.18
# EM4-NEXT: Block RThroughput: 33.0

# EM5-NEXT: uOps Per Cycle:    0.23
# EM5-NEXT: IPC:               0.23
# EM5-NEXT: Block RThroughput: 26.0

# ALL:      Instruction Info:
# ALL-NEXT: [1]: #uOps
# ALL-NEXT: [2]: Latency
# ALL-NEXT: [3]: RThroughput
# ALL-NEXT: [4]: MayLoad
# ALL-NEXT: [5]: MayStore
# ALL-NEXT: [6]: HasSideEffects (U)

# ALL:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:

# EM3-NEXT:  1      12    12.00                       sdiv	w0, w1, w2
# EM3-NEXT:  1      21    21.00                       udiv	x1, x2, x3
# EM3-NEXT:  1      3     0.50                        mul	w2, w3, w4
# EM3-NEXT:  1      4     1.00                        msub	x3, x4, x5, x6
# EM3-NEXT:  1      3     0.50                        smull	x4, w5, w6
# EM3-NEXT:  1      4     1.00                        umulh	x5, x6, x7

# EM4-NEXT:  1      12    12.00                       sdiv	w0, w1, w2
# EM4-NEXT:  1      21    21.00                       udiv	x1, x2, x3
# EM4-NEXT:  1      3     0.50                        mul	w2, w3, w4
# EM4-NEXT:  1      4     1.00                        msub	x3, x4, x5, x6
# EM4-NEXT:  1      3     0.50                        smull	x4, w5, w6
# EM4-NEXT:  1      4     1.00                        umulh	x5, x6, x7

# EM5-NEXT:  1      10    10.00                       sdiv	w0, w1, w2
# EM5-NEXT:  1      16    16.00                       udiv	x1, x2, x3
# EM5-NEXT:  1      2     0.50                        mul	w2, w3, w4
# EM5-NEXT:  1      3     1.00                        msub	x3, x4, x5, x6
# EM5-NEXT:  1      2     0.50                        smull	x4, w5, w6
# EM5-NEXT:  1      3     1.00                        umulh	x5, x6, x7
