; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride5_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride5_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm4 = mem[0],zero
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm0, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm5[0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,1,1,1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    movq %xmm2, 32(%r9)
; SSE-NEXT:    movaps %xmm6, (%r9)
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride5_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2,2,1,4,6,6,5]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[u,u,0,2,u,5,7,u]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6],ymm2[7]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4],ymm0[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[3,3,3,3]
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm3[1],xmm1[2,3]
; AVX-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride5_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq (%r8), %rax
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [0,2,4,6,0,1,3,5]
; AVX2-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vpbroadcastd %xmm3, %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4],ymm0[5,6,7]
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-NEXT:    vmovq %xmm1, 32(%r9)
; AVX2-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride5_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq (%r8), %rax
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovq %rax, %xmm2
; AVX2-FP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [0,2,4,6,0,1,3,5]
; AVX2-FP-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-FP-NEXT:    vmovd %eax, %xmm3
; AVX2-FP-NEXT:    vpbroadcastd %xmm3, %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-FP-NEXT:    vmovq %xmm1, 32(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride5_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq (%r8), %rax
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovq %rax, %xmm2
; AVX2-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [0,2,4,6,0,1,3,5]
; AVX2-FCP-NEXT:    vpermd %ymm0, %ymm3, %ymm0
; AVX2-FCP-NEXT:    vmovd %eax, %xmm3
; AVX2-FCP-NEXT:    vpbroadcastd %xmm3, %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-FCP-NEXT:    vmovq %xmm1, 32(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride5_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512-NEXT:    vmovaps %ymm0, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride5_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512-FCP-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride5_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512DQ-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512DQ-NEXT:    vmovaps %ymm0, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride5_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512DQ-FCP-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512DQ-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride5_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512BW-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512BW-NEXT:    vmovaps %ymm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride5_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512BW-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512BW-FCP-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512BW-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride5_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-BW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512DQ-BW-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512DQ-BW-NEXT:    vmovaps %ymm0, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride5_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512DQ-BW-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vinsertf32x4 $2, %xmm1, %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,1,3,5,7,9,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovlps %xmm1, 32(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i32>, ptr %in.vecptr4, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i32> %in.vec2, <2 x i32> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <4 x i32> %1, <4 x i32> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <2 x i32> %in.vec4, <2 x i32> poison, <8 x i32> <i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <8 x i32> %3, <8 x i32> %4, <10 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9>
  %interleaved.vec = shufflevector <10 x i32> %5, <10 x i32> poison, <10 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 1, i32 3, i32 5, i32 7, i32 9>
  store <10 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride5_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride5_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm0, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm5[0]
; SSE-NEXT:    movaps %xmm3, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm4[3,3]
; SSE-NEXT:    movaps %xmm1, %xmm7
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm2[2],xmm7[3],xmm2[3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[0,2]
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,1],xmm4[2,3]
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm5[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm5[0,1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm4[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm3, 32(%r9)
; SSE-NEXT:    movaps %xmm8, 48(%r9)
; SSE-NEXT:    movaps %xmm7, 64(%r9)
; SSE-NEXT:    movaps %xmm6, (%r9)
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride5_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps (%rdx), %xmm2
; AVX-NEXT:    vmovaps (%rcx), %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm4
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm5
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm6
; AVX-NEXT:    vunpcklps {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0,0,2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm4[0],ymm1[0],ymm4[1],ymm1[1],ymm4[4],ymm1[4],ymm4[5],ymm1[5]
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0,0,3,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1],ymm5[2,3],ymm7[4,5,6],ymm5[7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm7 = mem[0,1,0,1]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1,2,3],ymm0[4],ymm5[5,6,7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[u,u,u,2,u,u,u,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm4[2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vpermilps {{.*#+}} ymm4 = ymm6[1,u,u,u,6,u,u,u]
; AVX-NEXT:    vbroadcastss 8(%rcx), %ymm5
; AVX-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1],ymm1[2,3],ymm4[4,5],ymm1[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm7[1],ymm1[2,3,4,5],ymm7[6],ymm1[7]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; AVX-NEXT:    vbroadcastss 12(%rsi), %xmm3
; AVX-NEXT:    vblendps {{.*#+}} xmm2 = xmm3[0],xmm2[1,2,3]
; AVX-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1,2],xmm7[3]
; AVX-NEXT:    vmovaps %xmm2, 64(%r9)
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride5_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-NEXT:    vmovaps (%r8), %xmm4
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm5
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm6
; AVX2-NEXT:    vmovaps {{.*#+}} ymm7 = [u,u,0,4,u,u,u,1]
; AVX2-NEXT:    vpermps %ymm6, %ymm7, %ymm7
; AVX2-NEXT:    vmovaps {{.*#+}} ymm8 = [u,4,u,u,u,1,5,u]
; AVX2-NEXT:    vpermps %ymm5, %ymm8, %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3],ymm8[4,5,6],ymm7[7]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm7[1,2,3],ymm0[4],ymm7[5,6,7]
; AVX2-NEXT:    vmovaps {{.*#+}} ymm7 = [u,u,2,6,u,u,u,3]
; AVX2-NEXT:    vpermps %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vmovaps {{.*#+}} ymm7 = [5,u,u,u,2,6,u,u]
; AVX2-NEXT:    vpermps %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2,3],ymm6[4,5],ymm5[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm4[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3,4,5],ymm6[6],ymm5[7]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[3],xmm2[1,2],zero
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1,2],xmm4[3]
; AVX2-NEXT:    vmovaps %xmm1, 64(%r9)
; AVX2-NEXT:    vmovaps %ymm5, 32(%r9)
; AVX2-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride5_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm4
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm5
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm6
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm7 = [u,u,0,4,u,u,u,1]
; AVX2-FP-NEXT:    vpermps %ymm6, %ymm7, %ymm7
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm8 = [u,4,u,u,u,1,5,u]
; AVX2-FP-NEXT:    vpermps %ymm5, %ymm8, %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3],ymm8[4,5,6],ymm7[7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm7[1,2,3],ymm0[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm7 = [u,u,2,6,u,u,u,3]
; AVX2-FP-NEXT:    vpermps %ymm5, %ymm7, %ymm5
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm7 = [5,u,u,u,2,6,u,u]
; AVX2-FP-NEXT:    vpermps %ymm6, %ymm7, %ymm6
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2,3],ymm6[4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm4[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3,4,5],ymm6[6],ymm5[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; AVX2-FP-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[3],xmm2[1,2],zero
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1,2],xmm4[3]
; AVX2-FP-NEXT:    vmovaps %xmm1, 64(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm5, 32(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride5_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm3
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm2, %ymm2
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm5 = [u,u,0,4,u,u,u,1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm5, %ymm5
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm6 = [u,4,u,u,u,1,5,u]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm6, %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2,3],ymm6[4,5,6],ymm5[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1,2,3],ymm0[4],ymm5[5,6,7]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm5 = [u,u,2,6,u,u,u,3]
; AVX2-FCP-NEXT:    vpermps %ymm4, %ymm5, %ymm4
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm5 = [5,u,u,u,2,6,u,u]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm5, %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm3[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3,4,5],ymm5[6],ymm4[7]
; AVX2-FCP-NEXT:    vbroadcastsd {{.*#+}} ymm5 = [7,3,7,3,7,3,7,3]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm5, %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[3,3,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1,2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm4, 32(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1,2],xmm3[3]
; AVX2-FCP-NEXT:    vmovaps %xmm0, 64(%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride5_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride5_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512-FCP-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride5_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride5_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride5_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512BW-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride5_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride5_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride5_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} xmm1 = [7,11,15,19]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,4,8,12,16,1,5,9,13,17,2,6,10,14,18,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm1, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i32>, ptr %in.vecptr4, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %in.vec2, <4 x i32> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <8 x i32> %1, <8 x i32> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <4 x i32> %in.vec4, <4 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <16 x i32> %3, <16 x i32> %4, <20 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19>
  %interleaved.vec = shufflevector <20 x i32> %5, <20 x i32> poison, <20 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 1, i32 5, i32 9, i32 13, i32 17, i32 2, i32 6, i32 10, i32 14, i32 18, i32 3, i32 7, i32 11, i32 15, i32 19>
  store <20 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride5_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride5_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm5
; SSE-NEXT:    movdqa (%rsi), %xmm6
; SSE-NEXT:    movdqa 16(%rsi), %xmm3
; SSE-NEXT:    movdqa (%rdx), %xmm7
; SSE-NEXT:    movdqa 16(%rdx), %xmm10
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm2
; SSE-NEXT:    movaps (%r8), %xmm0
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps %xmm2, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm11[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm10[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm12[0],xmm8[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm9[0,2]
; SSE-NEXT:    movaps %xmm4, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[3,3],xmm0[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm6[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm9 = xmm13[0],xmm9[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm12[0,2]
; SSE-NEXT:    movaps %xmm5, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[3,1],xmm11[2,3]
; SSE-NEXT:    movaps %xmm2, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm13[2,0]
; SSE-NEXT:    movaps %xmm5, %xmm13
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm3[2],xmm13[3],xmm3[3]
; SSE-NEXT:    movaps %xmm10, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm2[0],xmm14[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm11[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm13[0,1]
; SSE-NEXT:    movaps %xmm5, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm3[0],xmm13[1],xmm3[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm14[0]
; SSE-NEXT:    movaps %xmm1, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[3,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm15
; SSE-NEXT:    punpckhdq {{.*#+}} xmm15 = xmm15[2],xmm4[2],xmm15[3],xmm4[3]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm14[2,0]
; SSE-NEXT:    movaps %xmm1, %xmm14
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm14 = xmm14[2],xmm6[2],xmm14[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm7, %xmm6
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm14[0,1]
; SSE-NEXT:    movaps %xmm1, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm0[0],xmm14[1],xmm0[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm6[0]
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    # xmm10 = xmm10[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm10[2,0]
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm11[0],xmm5[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm7[2,0]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm14, (%r9)
; SSE-NEXT:    movaps %xmm4, 32(%r9)
; SSE-NEXT:    movaps %xmm15, 48(%r9)
; SSE-NEXT:    movaps %xmm13, 80(%r9)
; SSE-NEXT:    movaps %xmm2, 112(%r9)
; SSE-NEXT:    movaps %xmm12, 128(%r9)
; SSE-NEXT:    movaps %xmm1, 16(%r9)
; SSE-NEXT:    movaps %xmm9, 64(%r9)
; SSE-NEXT:    movaps %xmm5, 96(%r9)
; SSE-NEXT:    movaps %xmm8, 144(%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride5_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vmovaps (%rsi), %ymm3
; AVX-NEXT:    vmovaps (%rdx), %ymm2
; AVX-NEXT:    vmovaps (%rcx), %ymm4
; AVX-NEXT:    vmovaps (%r8), %ymm0
; AVX-NEXT:    vmovaps (%rsi), %xmm6
; AVX-NEXT:    vmovaps 16(%rsi), %xmm7
; AVX-NEXT:    vmovaps (%rdi), %xmm8
; AVX-NEXT:    vmovaps 16(%rdi), %xmm9
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = zero,xmm8[1],xmm6[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm10 = xmm8[0],xmm6[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm10, %ymm5
; AVX-NEXT:    vmovaps (%rdx), %xmm11
; AVX-NEXT:    vmovaps (%rcx), %xmm12
; AVX-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm12[0],xmm11[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm13[0,1,2,0]
; AVX-NEXT:    vbroadcastss 4(%rdx), %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm13, %ymm13
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm13[2,3],ymm5[4,5,6],ymm13[7]
; AVX-NEXT:    vinsertf128 $1, (%r8), %ymm10, %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0],ymm5[1,2,3],ymm10[4],ymm5[5,6,7]
; AVX-NEXT:    vinsertps {{.*#+}} xmm10 = zero,zero,xmm9[2],xmm7[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm9[1,1],xmm7[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm7
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm4[1,1],ymm2[1,1],ymm4[5,5],ymm2[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm9[3,4],ymm7[5,6,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0],ymm7[1,2,3,4],ymm9[5],ymm7[6,7]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm10 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX-NEXT:    vbroadcastss 4(%rcx), %xmm11
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX-NEXT:    vinsertps {{.*#+}} xmm6 = zero,zero,xmm8[2],xmm6[2]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm6, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm10[0,1],ymm6[2,3],ymm10[4,5],ymm6[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm8 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm8[1],ymm6[2,3,4,5],ymm8[6],ymm6[7]
; AVX-NEXT:    vmovaps 16(%rcx), %xmm8
; AVX-NEXT:    vmovaps 16(%rdx), %xmm10
; AVX-NEXT:    vshufps {{.*#+}} xmm11 = xmm10[3,3],xmm8[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm10[2],xmm8[2],xmm10[3],xmm8[3]
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm8, %ymm8
; AVX-NEXT:    vshufps {{.*#+}} ymm10 = ymm3[3,3],ymm1[3,3],ymm3[7,7],ymm1[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm10[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2],ymm10[3,4],ymm8[5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4,5,6],ymm9[7]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4],ymm3[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5,6],ymm3[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5],ymm2[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX-NEXT:    vmovaps %ymm8, 128(%r9)
; AVX-NEXT:    vmovaps %ymm6, 32(%r9)
; AVX-NEXT:    vmovaps %ymm7, 96(%r9)
; AVX-NEXT:    vmovaps %ymm5, (%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride5_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovaps (%rcx), %ymm4
; AVX2-NEXT:    vmovaps (%r8), %ymm0
; AVX2-NEXT:    vmovaps (%rcx), %xmm6
; AVX2-NEXT:    vmovaps (%rdx), %xmm7
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,0,2,1]
; AVX2-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-NEXT:    vmovaps (%rdi), %xmm9
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0,1],ymm5[2,3],ymm11[4,5,6],ymm5[7]
; AVX2-NEXT:    vinsertf128 $1, (%r8), %ymm10, %ymm10
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0],ymm5[1,2,3],ymm10[4],ymm5[5,6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2],xmm6[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm8[2,3],ymm6[4,5],ymm8[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm0[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5],ymm7[6],ymm6[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm2[1],ymm7[2,3,4],ymm2[5],ymm7[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,2,2,2]
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm1[1,2],ymm8[3,4],ymm1[5,6],ymm8[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2],ymm7[3,4],ymm8[5,6,7]
; AVX2-NEXT:    vbroadcastsd 16(%r8), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3,4],ymm8[5],ymm7[6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[6],ymm1[6],ymm3[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[3,3,3,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm4[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1,2],ymm10[3,4],ymm9[5,6],ymm10[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2],ymm8[3,4],ymm9[5,6,7]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4,5,6],ymm9[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4],ymm3[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5,6],ymm3[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-NEXT:    vmovaps %ymm8, 128(%r9)
; AVX2-NEXT:    vmovaps %ymm7, 96(%r9)
; AVX2-NEXT:    vmovaps %ymm6, 32(%r9)
; AVX2-NEXT:    vmovaps %ymm5, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride5_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm4
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm6
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm7
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm9
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0,1],ymm5[2,3],ymm11[4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vinsertf128 $1, (%r8), %ymm10, %ymm10
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0],ymm5[1,2,3],ymm10[4],ymm5[5,6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2],xmm6[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm8[2,3],ymm6[4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm0[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5],ymm7[6],ymm6[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm2[1],ymm7[2,3,4],ymm2[5],ymm7[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,2,2,2]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm1[1,2],ymm8[3,4],ymm1[5,6],ymm8[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2],ymm7[3,4],ymm8[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r8), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3,4],ymm8[5],ymm7[6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[6],ymm1[6],ymm3[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[3,3,3,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm4[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1,2],ymm10[3,4],ymm9[5,6],ymm10[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2],ymm8[3,4],ymm9[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm9
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4,5,6],ymm9[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4],ymm3[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5,6],ymm3[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm8, 128(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm7, 96(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm6, 32(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm5, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride5_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm4
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm7
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm8 = [0,1,0,1,u,u,2,2]
; AVX2-FCP-NEXT:    vpermps %ymm5, %ymm8, %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm9
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm10
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm11 = xmm10[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm9[2],xmm11[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0,1],ymm5[2,3],ymm11[4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm0[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm11[1],ymm5[2,3,4,5],ymm11[6],ymm5[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; AVX2-FCP-NEXT:    vpermps %ymm9, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm7 = [0,1,u,u,3,2,3,u]
; AVX2-FCP-NEXT:    vpermps %ymm6, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3],ymm7[4,5,6],ymm8[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, (%r8), %ymm6, %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2,3],ymm6[4],ymm7[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm2[1],ymm7[2,3,4],ymm2[5],ymm7[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,2,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm3[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm1[1,2],ymm8[3,4],ymm1[5,6],ymm8[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2],ymm7[3,4],ymm8[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r8), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3,4],ymm8[5],ymm7[6,7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[6],ymm1[6],ymm3[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[3,3,3,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm4[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0],ymm9[1,2],ymm10[3,4],ymm9[5,6],ymm10[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2],ymm8[3,4],ymm9[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4,5,6],ymm9[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4],ymm3[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5,6],ymm3[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 128(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 96(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm6, (%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 32(%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride5_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride5_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512-FCP-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512-FCP-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride5_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512DQ-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512DQ-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride5_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512DQ-FCP-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride5_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512BW-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512BW-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride5_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512BW-FCP-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride5_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512DQ-BW-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512DQ-BW-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride5_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm3 = [6,14,0,23,31,7,15,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [11,19,27,0,4,12,20,28,0,5,13,21,29,0,6,14]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,8,16,24,0,1,9,17,25,0,2,10,18,26,0,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm4, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpbroadcastq 24(%r8), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, 128(%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i32>, ptr %in.vecptr4, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i32> %in.vec2, <8 x i32> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <16 x i32> %1, <16 x i32> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <8 x i32> %in.vec4, <8 x i32> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <32 x i32> %3, <32 x i32> %4, <40 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39>
  %interleaved.vec = shufflevector <40 x i32> %5, <40 x i32> poison, <40 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 1, i32 9, i32 17, i32 25, i32 33, i32 2, i32 10, i32 18, i32 26, i32 34, i32 3, i32 11, i32 19, i32 27, i32 35, i32 4, i32 12, i32 20, i32 28, i32 36, i32 5, i32 13, i32 21, i32 29, i32 37, i32 6, i32 14, i32 22, i32 30, i32 38, i32 7, i32 15, i32 23, i32 31, i32 39>
  store <40 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride5_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride5_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $168, %rsp
; SSE-NEXT:    movdqa (%rsi), %xmm8
; SSE-NEXT:    movdqa 16(%rsi), %xmm6
; SSE-NEXT:    movdqa 32(%rsi), %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdx), %xmm10
; SSE-NEXT:    movdqa 16(%rdx), %xmm7
; SSE-NEXT:    movdqa 32(%rdx), %xmm4
; SSE-NEXT:    movaps (%rcx), %xmm5
; SSE-NEXT:    movaps 16(%rcx), %xmm14
; SSE-NEXT:    movaps 32(%rcx), %xmm12
; SSE-NEXT:    movaps (%r8), %xmm3
; SSE-NEXT:    movaps 16(%r8), %xmm15
; SSE-NEXT:    movaps 32(%r8), %xmm11
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm3[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm15[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm11[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdx), %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rcx), %xmm9
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE-NEXT:    movdqa (%rdi), %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm3[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm14[0],xmm0[1],xmm14[1]
; SSE-NEXT:    movdqa 16(%rdi), %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm6[0],xmm8[1],xmm6[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    movaps %xmm14, %xmm10
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm15[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm0[0,1]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm15[2,3]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm14 = xmm14[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,0],xmm0[2,0]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm12[0],xmm0[1],xmm12[1]
; SSE-NEXT:    movdqa 32(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm6 = xmm6[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    punpckhdq {{.*#+}} xmm15 = xmm15[2],xmm12[2],xmm15[3],xmm12[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm0[0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm0[2,0]
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1]
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movaps %xmm9, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,3]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm9 = xmm9[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm0[2,0]
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm13 = xmm0[0],xmm13[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm7 = xmm0[0],xmm7[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm0[0],xmm3[1,2,3]
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm11[2,0]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm9, 288(%r9)
; SSE-NEXT:    movaps %xmm4, 272(%r9)
; SSE-NEXT:    movdqa %xmm5, 240(%r9)
; SSE-NEXT:    movaps %xmm15, 208(%r9)
; SSE-NEXT:    movaps %xmm12, 192(%r9)
; SSE-NEXT:    movdqa %xmm6, 160(%r9)
; SSE-NEXT:    movaps %xmm14, 128(%r9)
; SSE-NEXT:    movaps %xmm10, 112(%r9)
; SSE-NEXT:    movdqa %xmm8, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r9)
; SSE-NEXT:    movaps %xmm2, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps %xmm3, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps %xmm7, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps %xmm13, 16(%r9)
; SSE-NEXT:    addq $168, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride5_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX-NEXT:    vmovaps (%rsi), %xmm6
; AVX-NEXT:    vmovaps 32(%rsi), %xmm8
; AVX-NEXT:    vmovaps (%rdi), %xmm10
; AVX-NEXT:    vmovaps 32(%rdi), %xmm9
; AVX-NEXT:    vinsertps {{.*#+}} xmm4 = zero,xmm10[1],xmm6[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = xmm10[0],xmm6[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX-NEXT:    vmovaps (%rdx), %xmm11
; AVX-NEXT:    vmovaps (%rcx), %xmm12
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm12[0],xmm11[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,0]
; AVX-NEXT:    vbroadcastss 4(%rdx), %xmm13
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm7, %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm7[2,3],ymm4[4,5,6],ymm7[7]
; AVX-NEXT:    vinsertf128 $1, (%r8), %ymm5, %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1,2,3],ymm5[4],ymm4[5,6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = zero,xmm9[1],xmm8[1],zero
; AVX-NEXT:    vmovaps 32(%rdx), %xmm13
; AVX-NEXT:    vmovaps 32(%rcx), %xmm14
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm14[0],xmm13[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,0]
; AVX-NEXT:    vbroadcastss 36(%rdx), %xmm15
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm7, %ymm7
; AVX-NEXT:    vinsertps {{.*#+}} xmm15 = xmm9[0],xmm8[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm15, %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm7[2,3],ymm5[4,5,6],ymm7[7]
; AVX-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX-NEXT:    vinsertf128 $1, 32(%r8), %ymm15, %ymm15
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm15[0],ymm5[1,2,3],ymm15[4],ymm5[5,6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhps {{.*#+}} xmm11 = xmm11[2],xmm12[2],xmm11[3],xmm12[3]
; AVX-NEXT:    vbroadcastss 4(%rcx), %xmm12
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm12, %ymm11
; AVX-NEXT:    vinsertps {{.*#+}} xmm6 = zero,zero,xmm10[2],xmm6[2]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm6, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0,1],ymm6[2,3],ymm11[4,5],ymm6[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm10 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0],ymm10[1],ymm6[2,3,4,5],ymm10[6],ymm6[7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rsi), %xmm10
; AVX-NEXT:    vmovaps 48(%rdi), %xmm11
; AVX-NEXT:    vinsertps {{.*#+}} xmm12 = zero,zero,xmm11[2],xmm10[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm10 = xmm11[1,1],xmm10[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm10, %ymm10
; AVX-NEXT:    vshufps {{.*#+}} ymm11 = ymm7[1,1],ymm2[1,1],ymm7[5,5],ymm2[5,5]
; AVX-NEXT:    vmovaps %ymm2, %ymm6
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2],ymm11[3,4],ymm10[5,6,7]
; AVX-NEXT:    vmovaps 48(%rcx), %xmm11
; AVX-NEXT:    vmovaps 48(%rdx), %xmm12
; AVX-NEXT:    vshufps {{.*#+}} xmm15 = xmm12[3,3],xmm11[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm11 = xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX-NEXT:    vmovaps 32(%r8), %ymm12
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm11, %ymm11
; AVX-NEXT:    vshufps {{.*#+}} ymm15 = ymm3[3,3],ymm1[3,3],ymm3[7,7],ymm1[7,7]
; AVX-NEXT:    vmovaps %ymm1, %ymm2
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm15[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2],ymm15[3,4],ymm11[5,6,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm12[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm15[0],ymm10[1,2,3,4],ymm15[5],ymm10[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm15[2],ymm11[3,4,5,6],ymm15[7]
; AVX-NEXT:    vmovaps (%rsi), %ymm15
; AVX-NEXT:    vunpckhps {{.*#+}} xmm13 = xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; AVX-NEXT:    vbroadcastss 36(%rcx), %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX-NEXT:    vinsertps {{.*#+}} xmm8 = zero,zero,xmm9[2],xmm8[2]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm8, %ymm8
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2,3],ymm13[4,5],ymm8[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm9 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1],ymm8[2,3,4,5],ymm9[6],ymm8[7]
; AVX-NEXT:    vmovaps 16(%rcx), %xmm9
; AVX-NEXT:    vmovaps 16(%rdx), %xmm13
; AVX-NEXT:    vshufps {{.*#+}} xmm14 = xmm13[3,3],xmm9[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm13[2],xmm9[2],xmm13[3],xmm9[3]
; AVX-NEXT:    vmovaps 16(%rsi), %xmm13
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm9, %ymm9
; AVX-NEXT:    vmovaps %ymm0, %ymm5
; AVX-NEXT:    vshufps {{.*#+}} ymm14 = ymm15[3,3],ymm0[3,3],ymm15[7,7],ymm0[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2],ymm14[3,4],ymm9[5,6,7]
; AVX-NEXT:    vmovaps 16(%rdi), %xmm14
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,zero,xmm14[2],xmm13[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm13 = xmm14[1,1],xmm13[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm13, %ymm0
; AVX-NEXT:    vmovaps (%rdx), %ymm13
; AVX-NEXT:    vmovaps (%rcx), %ymm14
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm14[1,1],ymm13[1,1],ymm14[5,5],ymm13[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2],ymm4[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps (%r8), %ymm4
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm4[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm0[2],ymm9[3,4,5,6],ymm0[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4],ymm0[5],ymm1[6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4],ymm1[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm7[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm6[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5,6],ymm3[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5],ymm2[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm12[3],ymm1[4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm15[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4],ymm2[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm14[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm13[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm7[0,1],ymm3[2],ymm7[3,4,5,6],ymm3[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3],ymm2[4,5],ymm3[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm4[3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovaps %ymm2, 64(%r9)
; AVX-NEXT:    vmovaps %ymm1, 224(%r9)
; AVX-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX-NEXT:    vmovaps %ymm9, 128(%r9)
; AVX-NEXT:    vmovaps %ymm8, 192(%r9)
; AVX-NEXT:    vmovaps %ymm11, 288(%r9)
; AVX-NEXT:    vmovaps %ymm10, 256(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride5_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm4
; AVX2-NEXT:    vmovaps (%rcx), %ymm2
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX2-NEXT:    vmovaps (%r8), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r8), %ymm6
; AVX2-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm11
; AVX2-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,0,2,1]
; AVX2-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-NEXT:    vmovaps (%rcx), %xmm14
; AVX2-NEXT:    vshufps {{.*#+}} xmm15 = xmm14[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],xmm13[2],xmm15[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1],ymm8[2,3],ymm15[4,5],ymm8[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm0[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0],ymm15[1],ymm8[2,3,4,5],ymm15[6],ymm8[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm15
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm13[0],xmm14[0],xmm13[1],xmm14[1]
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm14
; AVX2-NEXT:    vshufps {{.*#+}} xmm13 = xmm13[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,0,2,1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm9[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm13[2,3],ymm10[4,5,6],ymm13[7]
; AVX2-NEXT:    vinsertf128 $1, (%r8), %ymm9, %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0],ymm10[1,2,3],ymm9[4],ymm10[5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm10 = xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm13 = xmm14[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0,1],xmm15[2],xmm13[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0,1],ymm10[2,3],ymm13[4,5],ymm10[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm6[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm13[1],ymm10[2,3,4,5],ymm13[6],ymm10[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm13 = xmm13[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,0,2,1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm13[2,3],ymm12[4,5,6],ymm13[7]
; AVX2-NEXT:    vinsertf128 $1, 32(%r8), %ymm11, %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm12[1,2,3],ymm11[4],ymm12[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm12 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm4[1],ymm12[2,3,4],ymm4[5],ymm12[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[2,2,2,2]
; AVX2-NEXT:    vshufps {{.*#+}} ymm13 = ymm5[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm3[1,2],ymm13[3,4],ymm3[5,6],ymm13[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2],ymm12[3,4],ymm13[5,6,7]
; AVX2-NEXT:    vbroadcastsd 48(%r8), %ymm13
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0],ymm12[1,2,3,4],ymm13[5],ymm12[6,7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm13 = ymm5[2],ymm3[2],ymm5[3],ymm3[3],ymm5[6],ymm3[6],ymm5[7],ymm3[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[3,3,3,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm14 = ymm7[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3,4],ymm14[5,6],ymm15[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2],ymm13[3,4],ymm14[5,6,7]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm14[2],ymm13[3,4,5,6],ymm14[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm14 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3,4],ymm14[5,6],ymm15[7]
; AVX2-NEXT:    vmovaps (%rdi), %ymm15
; AVX2-NEXT:    vmovaps (%rsi), %ymm0
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm0[2],ymm15[2],ymm0[3],ymm15[3],ymm0[6],ymm15[6],ymm0[7],ymm15[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm14[0,1,2],ymm8[3,4],ymm14[5,6,7]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm14[2],ymm8[3,4,5,6],ymm14[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm14 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm1[1],ymm14[2,3,4],ymm1[5],ymm14[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,2,2,2]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm15[1,2],ymm9[3,4],ymm15[5,6],ymm9[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2],ymm14[3,4],ymm9[5,6,7]
; AVX2-NEXT:    vbroadcastsd 16(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm14[0],ymm9[1,2,3,4],ymm14[5],ymm9[6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4],ymm5[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm7[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4,5,6],ymm5[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2],ymm6[3],ymm3[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4],ymm0[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5,6],ymm2[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-NEXT:    vmovaps %ymm3, 224(%r9)
; AVX2-NEXT:    vmovaps %ymm9, 96(%r9)
; AVX2-NEXT:    vmovaps %ymm8, 128(%r9)
; AVX2-NEXT:    vmovaps %ymm13, 288(%r9)
; AVX2-NEXT:    vmovaps %ymm12, 256(%r9)
; AVX2-NEXT:    vmovaps %ymm11, 160(%r9)
; AVX2-NEXT:    vmovaps %ymm10, 192(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride5_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm4
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm6
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm11
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm15 = xmm14[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],xmm13[2],xmm15[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1],ymm8[2,3],ymm15[4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm0[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0],ymm15[1],ymm8[2,3,4,5],ymm15[6],ymm8[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm15
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm13[0],xmm14[0],xmm13[1],xmm14[1]
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm13 = xmm13[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,0,2,1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm9[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm13[2,3],ymm10[4,5,6],ymm13[7]
; AVX2-FP-NEXT:    vinsertf128 $1, (%r8), %ymm9, %ymm9
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0],ymm10[1,2,3],ymm9[4],ymm10[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm10 = xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm13 = xmm14[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0,1],xmm15[2],xmm13[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0,1],ymm10[2,3],ymm13[4,5],ymm10[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm6[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm13[1],ymm10[2,3,4,5],ymm13[6],ymm10[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm13 = xmm13[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,0,2,1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm13[2,3],ymm12[4,5,6],ymm13[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%r8), %ymm11, %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm12[1,2,3],ymm11[4],ymm12[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm12 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm4[1],ymm12[2,3,4],ymm4[5],ymm12[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[2,2,2,2]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm13 = ymm5[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm3[1,2],ymm13[3,4],ymm3[5,6],ymm13[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2],ymm12[3,4],ymm13[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r8), %ymm13
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0],ymm12[1,2,3,4],ymm13[5],ymm12[6,7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm13 = ymm5[2],ymm3[2],ymm5[3],ymm3[3],ymm5[6],ymm3[6],ymm5[7],ymm3[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[3,3,3,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm14 = ymm7[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3,4],ymm14[5,6],ymm15[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2],ymm13[3,4],ymm14[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm14[2],ymm13[3,4,5,6],ymm14[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm14 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm1[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3,4],ymm14[5,6],ymm15[7]
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm15
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm0
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm0[2],ymm15[2],ymm0[3],ymm15[3],ymm0[6],ymm15[6],ymm0[7],ymm15[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm14[0,1,2],ymm8[3,4],ymm14[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm14[2],ymm8[3,4,5,6],ymm14[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm14 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm1[1],ymm14[2,3,4],ymm1[5],ymm14[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm14 = ymm14[2,2,2,2]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm15[1,2],ymm9[3,4],ymm15[5,6],ymm9[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2],ymm14[3,4],ymm9[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm14[0],ymm9[1,2,3,4],ymm14[5],ymm9[6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4],ymm5[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm7[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2],ymm6[3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm3, 224(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm9, 96(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm8, 128(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm13, 288(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm12, 256(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm11, 160(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm10, 192(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride5_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm4
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm9
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm10
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm12 = [0,1,0,1,u,u,2,2]
; AVX2-FCP-NEXT:    vpermps %ymm5, %ymm12, %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm14
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm11
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm15
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm7 = xmm11[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1],ymm5[2,3],ymm7[4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm4[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2,3,4,5],ymm7[6],ymm5[7]
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FCP-NEXT:    vpermps %ymm5, %ymm12, %ymm5
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm7 = xmm15[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm14[2],xmm7[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1],ymm5[2,3],ymm7[4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm3[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2,3,4,5],ymm7[6],ymm5[7]
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm8[0],xmm11[0],xmm8[1],xmm11[1]
; AVX2-FCP-NEXT:    vpermps %ymm8, %ymm12, %ymm8
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm0 = [0,1,3,2,3,2,3,2]
; AVX2-FCP-NEXT:    vpermps %ymm6, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1],ymm8[2,3],ymm11[4,5,6],ymm8[7]
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm11
; AVX2-FCP-NEXT:    vinsertf128 $1, (%r8), %ymm6, %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0],ymm8[1,2,3],ymm6[4],ymm8[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm11[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm7[1],ymm8[2,3,4],ymm7[5],ymm8[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm13 = ymm2[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0],ymm1[1,2],ymm13[3,4],ymm1[5,6],ymm13[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1,2],ymm8[3,4],ymm13[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r8), %ymm13
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0],ymm8[1,2,3,4],ymm13[5],ymm8[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm13 = ymm11[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm13[1,2],ymm5[3,4],ymm13[5,6],ymm5[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm13 = ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[6],ymm1[6],ymm2[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2],ymm13[3,4],ymm5[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm13
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm5[0,1],ymm13[2],ymm5[3,4,5,6],ymm13[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm14[0],xmm15[0],xmm14[1],xmm15[1]
; AVX2-FCP-NEXT:    vpermps %ymm5, %ymm12, %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm12
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm10
; AVX2-FCP-NEXT:    vpermps %ymm9, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3],ymm0[4,5,6],ymm5[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%r8), %ymm9, %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm5[0],ymm0[1,2,3],ymm5[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm10[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2],ymm5[3,4],ymm0[5,6],ymm5[7]
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm14
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm14[2],ymm5[2],ymm14[3],ymm5[3],ymm14[6],ymm5[6],ymm14[7],ymm5[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm15[2],ymm0[3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm10[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0],ymm12[1],ymm15[2,3,4],ymm12[5],ymm15[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm14[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm5[1,2],ymm6[3,4],ymm5[5,6],ymm6[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm15[3,4],ymm6[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r8), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm15[0],ymm6[1,2,3,4],ymm15[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm11[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0,1],ymm2[2],ymm7[3,4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm14[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm10[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm12[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2],ymm5[3,4,5,6],ymm3[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3],ymm2[4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm4[3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm2, 64(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 96(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 160(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 288(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 256(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride5_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride5_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512-FCP-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512-FCP-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride5_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512DQ-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512DQ-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512DQ-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512DQ-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride5_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-FCP-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride5_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512BW-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512BW-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512BW-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride5_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512BW-FCP-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512BW-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride5_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512DQ-BW-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512DQ-BW-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride5_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm5, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512DQ-BW-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm6, %zmm7 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm7, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm8
; AVX512DQ-BW-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm7 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm8, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm2, %zmm3, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm9, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm2 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm0 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 256(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, 192(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i32>, ptr %in.vecptr4, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i32> %in.vec2, <16 x i32> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <32 x i32> %1, <32 x i32> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <16 x i32> %in.vec4, <16 x i32> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <64 x i32> %3, <64 x i32> %4, <80 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79>
  %interleaved.vec = shufflevector <80 x i32> %5, <80 x i32> poison, <80 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 1, i32 17, i32 33, i32 49, i32 65, i32 2, i32 18, i32 34, i32 50, i32 66, i32 3, i32 19, i32 35, i32 51, i32 67, i32 4, i32 20, i32 36, i32 52, i32 68, i32 5, i32 21, i32 37, i32 53, i32 69, i32 6, i32 22, i32 38, i32 54, i32 70, i32 7, i32 23, i32 39, i32 55, i32 71, i32 8, i32 24, i32 40, i32 56, i32 72, i32 9, i32 25, i32 41, i32 57, i32 73, i32 10, i32 26, i32 42, i32 58, i32 74, i32 11, i32 27, i32 43, i32 59, i32 75, i32 12, i32 28, i32 44, i32 60, i32 76, i32 13, i32 29, i32 45, i32 61, i32 77, i32 14, i32 30, i32 46, i32 62, i32 78, i32 15, i32 31, i32 47, i32 63, i32 79>
  store <80 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride5_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride5_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $712, %rsp # imm = 0x2C8
; SSE-NEXT:    movdqa (%rsi), %xmm9
; SSE-NEXT:    movdqa 16(%rsi), %xmm7
; SSE-NEXT:    movdqa 32(%rsi), %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdx), %xmm11
; SSE-NEXT:    movdqa 16(%rdx), %xmm10
; SSE-NEXT:    movdqa 32(%rdx), %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps 16(%rcx), %xmm5
; SSE-NEXT:    movaps 32(%rcx), %xmm6
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps 16(%r8), %xmm13
; SSE-NEXT:    movaps 32(%r8), %xmm12
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm4[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm13[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm14[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm12[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm8
; SSE-NEXT:    movdqa 48(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rcx), %xmm2
; SSE-NEXT:    movaps 48(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rsi), %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm14[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rsi), %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm14[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rcx), %xmm15
; SSE-NEXT:    movaps 112(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE-NEXT:    movdqa (%rdi), %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm11
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm9[0],xmm11[1],xmm9[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm11 = xmm11[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm9[2],xmm0[3],xmm9[3]
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    punpckhdq {{.*#+}} xmm9 = xmm9[2],xmm3[2],xmm9[3],xmm3[3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm4[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE-NEXT:    movdqa 16(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm13[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm13[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; SSE-NEXT:    movaps 32(%rdi), %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm12[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm12[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movdqa 48(%rdi), %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 64(%rdi), %xmm9
; SSE-NEXT:    movaps %xmm9, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm2[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 80(%rdi), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm13
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm2[0],xmm13[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    movaps %xmm7, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm12
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm7, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm2[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm5
; SSE-NEXT:    movaps %xmm5, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm14, %xmm6
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm2[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm11
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm15[0],xmm11[1],xmm15[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm15[0],xmm4[1],xmm15[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm11[0]
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; SSE-NEXT:    movaps %xmm1, %xmm11
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm15[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm15[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm15 = xmm0[0],xmm15[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm10 = xmm0[0],xmm10[1,2,3]
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm9 = xmm0[0],xmm9[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm7 = xmm0[0],xmm7[1,2,3]
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    # xmm14 = xmm14[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm14[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm0[0],xmm5[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm0[0],xmm3[1,2,3]
; SSE-NEXT:    movaps %xmm1, 608(%r9)
; SSE-NEXT:    movaps %xmm11, 592(%r9)
; SSE-NEXT:    movaps %xmm4, 560(%r9)
; SSE-NEXT:    movaps %xmm6, 528(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%r9)
; SSE-NEXT:    movaps %xmm8, 480(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r9)
; SSE-NEXT:    movaps %xmm12, 432(%r9)
; SSE-NEXT:    movaps %xmm13, 400(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%r9)
; SSE-NEXT:    movaps %xmm3, 576(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%r9)
; SSE-NEXT:    movaps %xmm5, 496(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r9)
; SSE-NEXT:    movaps %xmm7, 416(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r9)
; SSE-NEXT:    movaps %xmm9, 336(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r9)
; SSE-NEXT:    movaps %xmm10, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps %xmm2, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps %xmm15, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    addq $712, %rsp # imm = 0x2C8
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride5_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $600, %rsp # imm = 0x258
; AVX-NEXT:    vmovaps (%rsi), %xmm6
; AVX-NEXT:    vmovaps 32(%rsi), %xmm3
; AVX-NEXT:    vmovaps (%rdi), %xmm9
; AVX-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm9[1],xmm6[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm9[0],xmm6[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovaps (%rdx), %xmm14
; AVX-NEXT:    vmovaps (%rcx), %xmm15
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm15[0],xmm14[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,0]
; AVX-NEXT:    vbroadcastss 4(%rdx), %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6],ymm2[7]
; AVX-NEXT:    vinsertf128 $1, (%r8), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm4[1],xmm3[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm4[0],xmm3[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm5[0],xmm2[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,0]
; AVX-NEXT:    vbroadcastss 36(%rdx), %xmm8
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm7, %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3],ymm0[4,5,6],ymm7[7]
; AVX-NEXT:    vinsertf128 $1, 32(%r8), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX-NEXT:    vmovaps 64(%rdx), %xmm7
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm8
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm8[0],xmm7[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,0]
; AVX-NEXT:    vbroadcastss 68(%rdx), %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm7
; AVX-NEXT:    vinsertps {{.*#+}} xmm10 = zero,xmm0[1],xmm1[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm11 = xmm0[0],xmm1[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1],ymm7[2,3],ymm10[4,5,6],ymm7[7]
; AVX-NEXT:    vinsertf128 $1, 64(%r8), %ymm11, %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0],ymm7[1,2,3],ymm10[4],ymm7[5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdx), %xmm10
; AVX-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm7
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm7[0],xmm10[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,0]
; AVX-NEXT:    vbroadcastss 100(%rdx), %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm7
; AVX-NEXT:    vmovaps 96(%rsi), %xmm13
; AVX-NEXT:    vmovaps 96(%rdi), %xmm12
; AVX-NEXT:    vinsertps {{.*#+}} xmm10 = zero,xmm12[1],xmm13[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm11 = xmm12[0],xmm13[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1],ymm7[2,3],ymm10[4,5,6],ymm7[7]
; AVX-NEXT:    vinsertf128 $1, 96(%r8), %ymm11, %ymm10
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0],ymm7[1,2,3],ymm10[4],ymm7[5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; AVX-NEXT:    vbroadcastss 4(%rcx), %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm10, %ymm7
; AVX-NEXT:    vinsertps {{.*#+}} xmm6 = zero,zero,xmm9[2],xmm6[2]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm6, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5],ymm6[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm7 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4,5],ymm7[6],ymm6[7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 16(%rsi), %xmm6
; AVX-NEXT:    vmovaps 16(%rdi), %xmm7
; AVX-NEXT:    vinsertps {{.*#+}} xmm9 = zero,zero,xmm7[2],xmm6[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[1,1],xmm6[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm6, %ymm6
; AVX-NEXT:    vmovaps (%rdx), %ymm15
; AVX-NEXT:    vmovaps (%rcx), %ymm7
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[1,1],ymm15[1,1],ymm7[5,5],ymm15[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm7[3,4],ymm6[5,6,7]
; AVX-NEXT:    vmovaps 16(%rcx), %xmm7
; AVX-NEXT:    vmovaps 16(%rdx), %xmm9
; AVX-NEXT:    vshufps {{.*#+}} xmm10 = xmm9[3,3],xmm7[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm9[2],xmm7[2],xmm9[3],xmm7[3]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm7
; AVX-NEXT:    vmovaps (%rdi), %ymm9
; AVX-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rsi), %ymm10
; AVX-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[3,3],ymm9[3,3],ymm10[7,7],ymm9[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm9[3,4],ymm7[5,6,7]
; AVX-NEXT:    vmovaps (%r8), %ymm9
; AVX-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0],ymm6[1,2,3,4],ymm9[5],ymm6[6,7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm9[2],ymm7[3,4,5,6],ymm9[7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; AVX-NEXT:    vbroadcastss 36(%rcx), %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm5, %ymm2
; AVX-NEXT:    vinsertps {{.*#+}} xmm3 = zero,zero,xmm4[2],xmm3[2]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm3 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5],ymm3[6],ymm2[7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rsi), %xmm2
; AVX-NEXT:    vmovaps 48(%rdi), %xmm3
; AVX-NEXT:    vinsertps {{.*#+}} xmm4 = zero,zero,xmm3[2],xmm2[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm3[1,1],xmm2[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX-NEXT:    vmovaps 32(%rdx), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[1,1],ymm3[1,1],ymm4[5,5],ymm3[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm3[3,4],ymm2[5,6,7]
; AVX-NEXT:    vmovaps 48(%rcx), %xmm3
; AVX-NEXT:    vmovaps 48(%rdx), %xmm4
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm4[3,3],xmm3[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %ymm14
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm14[3,3],ymm4[3,3],ymm14[7,7],ymm4[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2],ymm4[3,4],ymm3[5,6,7]
; AVX-NEXT:    vmovaps 32(%r8), %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0],ymm2[1,2,3,4],ymm4[5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm4[2],ymm3[3,4,5,6],ymm4[7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; AVX-NEXT:    vbroadcastss 68(%rcx), %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = zero,zero,xmm0[2],xmm1[2]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 80(%rsi), %xmm0
; AVX-NEXT:    vmovaps 80(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX-NEXT:    vmovaps 64(%rcx), %ymm9
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm9[1,1],ymm10[1,1],ymm9[5,5],ymm10[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 80(%rcx), %xmm0
; AVX-NEXT:    vmovaps 80(%rdx), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 64(%rdi), %ymm8
; AVX-NEXT:    vmovaps 64(%rsi), %ymm5
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[3,3],ymm8[3,3],ymm5[7,7],ymm8[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0,1,2],ymm4[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 64(%r8), %ymm6
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm6[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0],ymm3[1,2,3,4],ymm11[5],ymm3[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm11[2],ymm4[3,4,5,6],ymm11[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 100(%rcx), %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX-NEXT:    vinsertps {{.*#+}} xmm4 = zero,zero,xmm12[2],xmm13[2]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm4, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5],ymm4[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm4 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0],ymm4[1],ymm3[2,3,4,5],ymm4[6],ymm3[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 112(%rsi), %xmm3
; AVX-NEXT:    vmovaps 112(%rdi), %xmm4
; AVX-NEXT:    vinsertps {{.*#+}} xmm12 = zero,zero,xmm4[2],xmm3[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm4[1,1],xmm3[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm3, %ymm3
; AVX-NEXT:    vmovaps 96(%rdx), %ymm12
; AVX-NEXT:    vmovaps 96(%rcx), %ymm13
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm13[1,1],ymm12[1,1],ymm13[5,5],ymm12[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm3[0,1,2],ymm4[3,4],ymm3[5,6,7]
; AVX-NEXT:    vmovaps 112(%rcx), %xmm4
; AVX-NEXT:    vmovaps 112(%rdx), %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3],xmm4[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX-NEXT:    vmovaps 96(%rsi), %ymm4
; AVX-NEXT:    vshufps {{.*#+}} ymm11 = ymm4[3,3],ymm1[3,3],ymm4[7,7],ymm1[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0,1,2],ymm11[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 96(%r8), %ymm2
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm3[0],ymm7[1,2,3,4],ymm3[5],ymm7[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm11[0,1],ymm3[2],ymm11[3,4,5,6],ymm3[7]
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX-NEXT:    # ymm11 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX-NEXT:    # ymm11 = ymm11[0,1,2,3],mem[4],ymm11[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm15 = ymm15[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1],ymm0[2],ymm15[3,4,5,6],ymm0[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0],ymm0[1,2,3],ymm11[4,5],ymm0[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm11 = ymm14[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX-NEXT:    # ymm11 = ymm11[0,1,2,3],mem[4],ymm11[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX-NEXT:    # ymm14 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX-NEXT:    # ymm15 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4,5,6],ymm14[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm14[1,2,3],ymm11[4,5],ymm14[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX-NEXT:    # ymm11 = ymm11[0,1,2],mem[3],ymm11[4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm8[4],ymm5[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm9 = ymm10[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3,4,5,6],ymm8[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm8[1,2,3],ymm5[4,5],ymm8[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2],ymm6[3],ymm5[4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4],ymm4[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm13[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm12[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0,1],ymm4[2],ymm6[3,4,5,6],ymm4[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm4[1,2,3],ymm1[4,5],ymm4[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovaps %ymm1, 544(%r9)
; AVX-NEXT:    vmovaps %ymm5, 384(%r9)
; AVX-NEXT:    vmovaps %ymm11, 224(%r9)
; AVX-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX-NEXT:    vmovaps %ymm3, 608(%r9)
; AVX-NEXT:    vmovaps %ymm7, 576(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    addq $600, %rsp # imm = 0x258
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride5_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $552, %rsp # imm = 0x228
; AVX2-NEXT:    vmovaps (%r8), %ymm15
; AVX2-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r8), %ymm14
; AVX2-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%r8), %ymm13
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rcx), %xmm7
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX2-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm12[0,1],ymm5[2,3],ymm12[4,5,6],ymm5[7]
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX2-NEXT:    vinsertf128 $1, (%r8), %ymm11, %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0],ymm5[1,2,3],ymm11[4],ymm5[5,6,7]
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5],ymm9[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm15[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5],ymm8[6],ymm7[7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,0,2,1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm12[0],xmm6[0],xmm12[1],xmm6[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm8[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3],ymm9[4,5,6],ymm7[7]
; AVX2-NEXT:    vinsertf128 $1, 32(%r8), %ymm8, %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3],ymm8[4],ymm7[5,6,7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm12[2],xmm6[2],xmm12[3],xmm6[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm6[2,3],ymm3[4,5],ymm6[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3,4,5],ymm4[6],ymm3[7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm4[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6],ymm3[7]
; AVX2-NEXT:    vinsertf128 $1, 64(%r8), %ymm4, %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1,2,3],ymm4[4],ymm3[5,6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm13[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm3
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-NEXT:    vmovaps (%rdi), %ymm6
; AVX2-NEXT:    vinsertf128 $1, 96(%r8), %ymm5, %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %ymm5
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vmovaps (%rcx), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vmovaps 96(%r8), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups %ymm5, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4],ymm5[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps (%rsi), %ymm12
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm12[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1,2],ymm1[3,4],ymm6[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 16(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm12[2],ymm6[2],ymm12[3],ymm6[3],ymm12[6],ymm6[6],ymm12[7],ymm6[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm11
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm10
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm10[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm11[1],ymm0[2,3,4],ymm11[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm9
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm8
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm9[1,2],ymm1[3,4],ymm9[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 48(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm10[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm7
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm7[1],ymm0[2,3,4],ymm7[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm5
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1,2],ymm1[3,4],ymm5[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 80(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0],ymm1[1,2],ymm15[3,4],ymm1[5,6],ymm15[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2],ymm13[3,4],ymm15[5,6,7]
; AVX2-NEXT:    vbroadcastsd 112(%r8), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2,3,4],ymm15[5],ymm13[6,7]
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm13 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3,4],ymm13[5,6],ymm15[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2],ymm15[3,4],ymm13[5,6,7]
; AVX2-NEXT:    vbroadcastsd 120(%r8), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4,5,6],ymm15[7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm12 = ymm12[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm12 = ymm12[0,1,2,3],mem[4],ymm12[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm14 = ymm14[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vpermilps $78, (%rsp), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4,5,6],ymm14[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm14[1,2,3],ymm12[4,5],ymm14[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm12 = ymm12[0,1,2],mem[3],ymm12[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm8[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4],ymm8[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm11[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4,5,6],ymm9[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1,2,3],ymm8[4,5],ymm9[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm8 = ymm8[0,1,2],mem[3],ymm8[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4],ymm4[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4,5,6],ymm5[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm0, 544(%r9)
; AVX2-NEXT:    vmovaps %ymm4, 384(%r9)
; AVX2-NEXT:    vmovaps %ymm8, 224(%r9)
; AVX2-NEXT:    vmovaps %ymm12, 64(%r9)
; AVX2-NEXT:    vmovaps %ymm13, 608(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-NEXT:    addq $552, %rsp # imm = 0x228
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride5_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $552, %rsp # imm = 0x228
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm15
; AVX2-FP-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm14
; AVX2-FP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm13
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm7
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm12[0,1],ymm5[2,3],ymm12[4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX2-FP-NEXT:    vinsertf128 $1, (%r8), %ymm11, %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0],ymm5[1,2,3],ymm11[4],ymm5[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5],ymm9[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5],ymm8[6],ymm7[7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,0,2,1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm12[0],xmm6[0],xmm12[1],xmm6[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm8[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3],ymm9[4,5,6],ymm7[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%r8), %ymm8, %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3],ymm8[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm12[2],xmm6[2],xmm12[3],xmm6[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm6[2,3],ymm3[4,5],ymm6[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3,4,5],ymm4[6],ymm3[7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm4[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6],ymm3[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%r8), %ymm4, %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1,2,3],ymm4[4],ymm3[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm13[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm6
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%r8), %ymm5, %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm5
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vmovaps 96(%r8), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups %ymm5, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4],ymm5[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm12
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm12[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1,2],ymm1[3,4],ymm6[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm12[2],ymm6[2],ymm12[3],ymm6[3],ymm12[6],ymm6[6],ymm12[7],ymm6[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm11
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm10
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm10[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm11[1],ymm0[2,3,4],ymm11[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm9
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm8
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm9[1,2],ymm1[3,4],ymm9[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm10[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm7
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm7[1],ymm0[2,3,4],ymm7[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm5
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1,2],ymm1[3,4],ymm5[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 80(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0],ymm1[1,2],ymm15[3,4],ymm1[5,6],ymm15[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2],ymm13[3,4],ymm15[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 112(%r8), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2,3,4],ymm15[5],ymm13[6,7]
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm13 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3,4],ymm13[5,6],ymm15[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2],ymm15[3,4],ymm13[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 120(%r8), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4,5,6],ymm15[7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm12 = ymm12[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm12 = ymm12[0,1,2,3],mem[4],ymm12[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm14 = ymm14[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vpermilps $78, (%rsp), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4,5,6],ymm14[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0],ymm14[1,2,3],ymm12[4,5],ymm14[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm12 = ymm12[0,1,2],mem[3],ymm12[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm8[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4],ymm8[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm11[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4,5,6],ymm9[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1,2,3],ymm8[4,5],ymm9[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm8 = ymm8[0,1,2],mem[3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4],ymm4[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm4 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 544(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm4, 384(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm8, 224(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm12, 64(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm13, 608(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FP-NEXT:    addq $552, %rsp # imm = 0x228
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride5_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $600, %rsp # imm = 0x258
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm11
; AVX2-FCP-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm10
; AVX2-FCP-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm15
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm5
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm13
; AVX2-FCP-NEXT:    vmovaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm12 = [0,1,0,1,u,u,2,2]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm9[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm8[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm11[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm10[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm13[2],xmm15[2],xmm13[3],xmm15[3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm12, %ymm10
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm11 = xmm0[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm1[2],xmm11[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1],ymm10[2,3],ymm11[4,5],ymm10[6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm11
; AVX2-FCP-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm11[1],ymm10[2,3,4,5],ymm11[6],ymm10[7]
; AVX2-FCP-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm11
; AVX2-FCP-NEXT:    vmovaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm10
; AVX2-FCP-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm10 = xmm10[2],xmm11[2],xmm10[3],xmm11[3]
; AVX2-FCP-NEXT:    vpermps %ymm10, %ymm12, %ymm10
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm14
; AVX2-FCP-NEXT:    vmovaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm13
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm11 = xmm13[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm14[2],xmm11[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1],ymm10[2,3],ymm11[4,5],ymm10[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %ymm11
; AVX2-FCP-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm11[1],ymm10[2,3,4,5],ymm11[6],ymm10[7]
; AVX2-FCP-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vpermps %ymm8, %ymm12, %ymm7
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm11 = [0,1,3,2,3,2,3,2]
; AVX2-FCP-NEXT:    vpermps %ymm6, %ymm11, %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2,3],ymm8[4,5,6],ymm7[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, (%r8), %ymm6, %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2,3],ymm6[4],ymm7[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm7
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm8
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovaps %ymm8, %ymm9
; AVX2-FCP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3,4],ymm7[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm7, %ymm8
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm10
; AVX2-FCP-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm14
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm14[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm10[1,2],ymm7[3,4],ymm10[5,6],ymm7[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3,4],ymm7[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r8), %ymm7
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1,2,3,4],ymm7[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm9[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0],ymm6[1,2],ymm7[3,4],ymm6[5,6],ymm7[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm14[2],ymm10[2],ymm14[3],ymm10[3],ymm14[6],ymm10[6],ymm14[7],ymm10[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm7[3,4],ymm6[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm7
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm7[2],ymm6[3,4,5,6],ymm7[7]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm12, %ymm2
; AVX2-FCP-NEXT:    vpermps %ymm3, %ymm11, %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%r8), %ymm3, %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1,2,3],ymm3[4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm10
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm9
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm10[1],ymm2[2,3,4],ymm10[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm8
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm7
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm7[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm8[1,2],ymm3[3,4],ymm8[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2],ymm2[3,4],ymm3[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r8), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1,2,3,4],ymm3[5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1,2],ymm3[3,4],ymm2[5,6],ymm3[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm3 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2],ymm3[3,4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4,5,6],ymm3[7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm11, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm4
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4],ymm5[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm11, %ymm6
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm0[2,3],ymm6[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm12
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm13
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm12[1],ymm0[2,3,4],ymm12[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm1[1,2],ymm11[3,4],ymm1[5,6],ymm11[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0,1,2],ymm6[3,4],ymm11[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%r8), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0],ymm6[1,2,3,4],ymm11[5],ymm6[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm13[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm15[0],ymm6[1,2],ymm15[3,4],ymm6[5,6],ymm15[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2],ymm15[3,4],ymm6[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 120(%r8), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm15[2],ymm6[3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm14 = ymm14[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = ymm14[0,1,2,3],mem[4],ymm14[5,6,7]
; AVX2-FCP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm11 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm15[2],ymm11[3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0],ymm11[1,2,3],ymm14[4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm11 = ymm11[0,1,2],mem[3],ymm11[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4],ymm7[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm9[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3,4,5,6],ymm8[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1,2,3],ymm7[4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4],ymm2[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4,5,6],ymm3[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3],ymm2[4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = ymm2[0,1,2],mem[3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm12[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2],ymm3[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 544(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 384(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 224(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 64(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 608(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FCP-NEXT:    addq $600, %rsp # imm = 0x258
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride5_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512-NEXT:    kmovw %eax, %k3
; AVX512-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride5_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512-FCP-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512-FCP-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512-FCP-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512-FCP-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512-FCP-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512-FCP-NEXT:    kmovw %eax, %k3
; AVX512-FCP-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512-FCP-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512-FCP-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512-FCP-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512-FCP-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512-FCP-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride5_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512DQ-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512DQ-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512DQ-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512DQ-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512DQ-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512DQ-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512DQ-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-NEXT:    kmovw %eax, %k3
; AVX512DQ-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512DQ-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512DQ-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512DQ-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512DQ-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512DQ-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512DQ-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512DQ-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512DQ-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512DQ-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512DQ-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride5_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512DQ-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512DQ-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-FCP-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512DQ-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k3
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride5_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512BW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512BW-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512BW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512BW-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512BW-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512BW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512BW-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512BW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512BW-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512BW-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512BW-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512BW-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512BW-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512BW-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512BW-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512BW-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512BW-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512BW-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride5_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512BW-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512BW-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512BW-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512BW-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512BW-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512BW-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512BW-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512BW-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512BW-FCP-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512BW-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512BW-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride5_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-BW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512DQ-BW-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-BW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512DQ-BW-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-BW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-BW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512DQ-BW-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512DQ-BW-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512DQ-BW-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride5_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm16, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-BW-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm17, %zmm3
; AVX512DQ-BW-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm18 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm18, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm14, %zmm19, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm8, %zmm7
; AVX512DQ-BW-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm7 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm20 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm20, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm21, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-BW-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm12, %zmm10, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm15, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm22 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm22, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm23, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-BW-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm14, %zmm25, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm24, %zmm15 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm24 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm24, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-BW-FCP-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm14, %zmm26, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm29
; AVX512DQ-BW-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm27, %zmm29 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm27 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm27, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm14, %zmm16, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm11, %zmm17, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm13, %zmm18, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm19, %zmm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm20, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm4, %zmm6, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm21, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm22, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm2, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm6, %zmm4, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm23, %zmm25 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm24, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm26, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm28, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm4, %zmm1 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm27, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, 128(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 192(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, 256(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, 384(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 448(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 512(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 576(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i32>, ptr %in.vecptr4, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i32> %in.vec2, <32 x i32> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <64 x i32> %1, <64 x i32> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <32 x i32> %in.vec4, <32 x i32> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <128 x i32> %3, <128 x i32> %4, <160 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159>
  %interleaved.vec = shufflevector <160 x i32> %5, <160 x i32> poison, <160 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 1, i32 33, i32 65, i32 97, i32 129, i32 2, i32 34, i32 66, i32 98, i32 130, i32 3, i32 35, i32 67, i32 99, i32 131, i32 4, i32 36, i32 68, i32 100, i32 132, i32 5, i32 37, i32 69, i32 101, i32 133, i32 6, i32 38, i32 70, i32 102, i32 134, i32 7, i32 39, i32 71, i32 103, i32 135, i32 8, i32 40, i32 72, i32 104, i32 136, i32 9, i32 41, i32 73, i32 105, i32 137, i32 10, i32 42, i32 74, i32 106, i32 138, i32 11, i32 43, i32 75, i32 107, i32 139, i32 12, i32 44, i32 76, i32 108, i32 140, i32 13, i32 45, i32 77, i32 109, i32 141, i32 14, i32 46, i32 78, i32 110, i32 142, i32 15, i32 47, i32 79, i32 111, i32 143, i32 16, i32 48, i32 80, i32 112, i32 144, i32 17, i32 49, i32 81, i32 113, i32 145, i32 18, i32 50, i32 82, i32 114, i32 146, i32 19, i32 51, i32 83, i32 115, i32 147, i32 20, i32 52, i32 84, i32 116, i32 148, i32 21, i32 53, i32 85, i32 117, i32 149, i32 22, i32 54, i32 86, i32 118, i32 150, i32 23, i32 55, i32 87, i32 119, i32 151, i32 24, i32 56, i32 88, i32 120, i32 152, i32 25, i32 57, i32 89, i32 121, i32 153, i32 26, i32 58, i32 90, i32 122, i32 154, i32 27, i32 59, i32 91, i32 123, i32 155, i32 28, i32 60, i32 92, i32 124, i32 156, i32 29, i32 61, i32 93, i32 125, i32 157, i32 30, i32 62, i32 94, i32 126, i32 158, i32 31, i32 63, i32 95, i32 127, i32 159>
  store <160 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride5_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride5_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1736, %rsp # imm = 0x6C8
; SSE-NEXT:    movdqa (%rsi), %xmm10
; SSE-NEXT:    movdqa 16(%rsi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rsi), %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdx), %xmm8
; SSE-NEXT:    movdqa 16(%rdx), %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdx), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rcx), %xmm5
; SSE-NEXT:    movaps 16(%rcx), %xmm9
; SSE-NEXT:    movaps 32(%rcx), %xmm12
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps 32(%r8), %xmm14
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm4[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm11[3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rsi), %xmm12
; SSE-NEXT:    movdqa 48(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rcx), %xmm6
; SSE-NEXT:    movaps 48(%r8), %xmm7
; SSE-NEXT:    movaps %xmm6, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdx), %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm15[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 64(%rcx), %xmm13
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rcx), %xmm14
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 144(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 160(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 208(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 208(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 224(%rsi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 224(%rdx), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%r8), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 240(%rsi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 240(%rdx), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,3,3,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 240(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%r8), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm3[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm8, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm10[0],xmm8[1],xmm10[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,0],xmm4[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1]
; SSE-NEXT:    movaps 16(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm2[0],xmm8[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm11[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm11[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm5[2],xmm0[3],xmm5[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; SSE-NEXT:    movdqa 48(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm12[0],xmm4[1],xmm12[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm12[2],xmm0[3],xmm12[3]
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm7[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1]
; SSE-NEXT:    movdqa 64(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm15 = xmm15[2],xmm13[2],xmm15[3],xmm13[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm14[0],xmm0[1],xmm14[1]
; SSE-NEXT:    movaps 80(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movaps %xmm14, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm2[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movaps 128(%rdi), %xmm5
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 144(%rdi), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm2[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 160(%rdi), %xmm14
; SSE-NEXT:    movaps %xmm14, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm2[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 176(%rdi), %xmm11
; SSE-NEXT:    movaps %xmm11, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm2[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 192(%rdi), %xmm10
; SSE-NEXT:    movaps %xmm10, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm2[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 208(%rdi), %xmm12
; SSE-NEXT:    movaps %xmm12, %xmm13
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm2[0],xmm13[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm9
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm2[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movaps %xmm7, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movaps 224(%rdi), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm3[0],xmm8[1],xmm3[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm1[2],xmm7[3],xmm1[3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,0],xmm2[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movaps 240(%rdi), %xmm5
; SSE-NEXT:    movaps %xmm5, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm15[0],xmm6[1],xmm15[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm1[0]
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; SSE-NEXT:    movaps %xmm3, %xmm15
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm0[0,1]
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,3]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm2[1]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,0],xmm0[2,0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm15 = xmm0[0],xmm15[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm0[0],xmm2[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm14 = xmm0[0],xmm14[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm11 = xmm0[0],xmm11[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm10 = xmm0[0],xmm10[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm12 = xmm0[0],xmm12[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm4 = xmm0[0],xmm4[1,2,3]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,1],mem[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movss {{.*#+}} xmm5 = xmm0[0],xmm5[1,2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%r9)
; SSE-NEXT:    movaps %xmm3, 1232(%r9)
; SSE-NEXT:    movaps %xmm6, 1200(%r9)
; SSE-NEXT:    movaps %xmm7, 1168(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%r9)
; SSE-NEXT:    movaps %xmm8, 1120(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%r9)
; SSE-NEXT:    movaps %xmm9, 1072(%r9)
; SSE-NEXT:    movaps %xmm13, 1040(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%r9)
; SSE-NEXT:    movaps %xmm5, 1216(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%r9)
; SSE-NEXT:    movaps %xmm4, 1136(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%r9)
; SSE-NEXT:    movaps %xmm12, 1056(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%r9)
; SSE-NEXT:    movaps %xmm10, 976(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%r9)
; SSE-NEXT:    movaps %xmm11, 896(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%r9)
; SSE-NEXT:    movaps %xmm14, 816(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%r9)
; SSE-NEXT:    movaps %xmm2, 736(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%r9)
; SSE-NEXT:    movaps %xmm15, 656(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    addq $1736, %rsp # imm = 0x6C8
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride5_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $1784, %rsp # imm = 0x6F8
; AVX-NEXT:    vmovaps (%rsi), %xmm6
; AVX-NEXT:    vmovaps 32(%rsi), %xmm14
; AVX-NEXT:    vmovaps (%rdi), %xmm5
; AVX-NEXT:    vmovaps 32(%rdi), %xmm15
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm5[1],xmm6[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm3 = xmm5[0],xmm6[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vmovaps (%rdx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %xmm11
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm11[0],xmm0[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,2,0]
; AVX-NEXT:    vbroadcastss 4(%rdx), %xmm7
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3],ymm2[4,5,6],ymm4[7]
; AVX-NEXT:    vinsertf128 $1, (%r8), %ymm3, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0],ymm2[1,2,3],ymm3[4],ymm2[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm15[1],xmm14[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm3 = xmm15[0],xmm14[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX-NEXT:    vmovaps 32(%rdx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm1[0],xmm0[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,2,0]
; AVX-NEXT:    vbroadcastss 36(%rdx), %xmm7
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3],ymm2[4,5,6],ymm4[7]
; AVX-NEXT:    vinsertf128 $1, 32(%r8), %ymm3, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0],ymm2[1,2,3],ymm3[4],ymm2[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm13
; AVX-NEXT:    vmovaps 64(%rdi), %xmm10
; AVX-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,0]
; AVX-NEXT:    vbroadcastss 68(%rdx), %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX-NEXT:    vinsertps {{.*#+}} xmm3 = zero,xmm10[1],xmm13[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm4 = xmm10[0],xmm13[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6],ymm2[7]
; AVX-NEXT:    vinsertf128 $1, 64(%r8), %ymm4, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0],ymm2[1,2,3],ymm3[4],ymm2[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,0]
; AVX-NEXT:    vbroadcastss 100(%rdx), %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm3
; AVX-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm7
; AVX-NEXT:    vinsertps {{.*#+}} xmm4 = zero,xmm7[1],xmm0[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm9 = xmm7[0],xmm0[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm9, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3],ymm4[4,5,6],ymm3[7]
; AVX-NEXT:    vinsertf128 $1, 96(%r8), %ymm9, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm3[1,2,3],ymm4[4],ymm3[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rcx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm1[0],xmm0[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,0]
; AVX-NEXT:    vbroadcastss 132(%rdx), %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm4
; AVX-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %xmm8
; AVX-NEXT:    vinsertps {{.*#+}} xmm9 = zero,xmm8[1],xmm0[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm12 = xmm8[0],xmm0[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm12, %ymm9
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1],ymm4[2,3],ymm9[4,5,6],ymm4[7]
; AVX-NEXT:    vinsertf128 $1, 128(%r8), %ymm12, %ymm9
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0],ymm4[1,2,3],ymm9[4],ymm4[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rdx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rcx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm1[0],xmm0[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,2,0]
; AVX-NEXT:    vbroadcastss 164(%rdx), %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm4, %ymm9
; AVX-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rdi), %xmm4
; AVX-NEXT:    vinsertps {{.*#+}} xmm12 = zero,xmm4[1],xmm0[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm4[0],xmm0[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm12[0,1],ymm9[2,3],ymm12[4,5,6],ymm9[7]
; AVX-NEXT:    vinsertf128 $1, 160(%r8), %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm9[1,2,3],ymm0[4],ymm9[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rcx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,2,0]
; AVX-NEXT:    vbroadcastss 196(%rdx), %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rdi), %xmm9
; AVX-NEXT:    vinsertps {{.*#+}} xmm12 = zero,xmm9[1],xmm0[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm9[0],xmm0[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm12[0,1],ymm1[2,3],ymm12[4,5,6],ymm1[7]
; AVX-NEXT:    vinsertf128 $1, 192(%r8), %ymm0, %ymm0
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,2,0]
; AVX-NEXT:    vbroadcastss 228(%rdx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm3
; AVX-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,xmm0[1],xmm1[1],zero
; AVX-NEXT:    vinsertps {{.*#+}} xmm12 = xmm0[0],xmm1[0],zero,zero
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm12, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6],ymm3[7]
; AVX-NEXT:    vinsertf128 $1, 224(%r8), %ymm12, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm11[2],xmm0[3],xmm11[3]
; AVX-NEXT:    vbroadcastss 4(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = zero,zero,xmm5[2],xmm6[2]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 16(%rsi), %xmm0
; AVX-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX-NEXT:    vmovaps (%rdx), %ymm11
; AVX-NEXT:    vmovaps (%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm11[1,1],ymm1[5,5],ymm11[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 16(%rcx), %xmm1
; AVX-NEXT:    vmovaps 16(%rdx), %xmm5
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm5[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX-NEXT:    vmovaps (%rdi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rsi), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[3,3],ymm2[3,3],ymm3[7,7],ymm2[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm5[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps (%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2,3,4],ymm5[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm5[2],ymm1[3,4,5,6],ymm5[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 36(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = zero,zero,xmm15[2],xmm14[2]
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rsi), %xmm0
; AVX-NEXT:    vmovaps 48(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 32(%rdx), %ymm14
; AVX-NEXT:    vmovaps 32(%rcx), %ymm15
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm15[1,1],ymm14[1,1],ymm15[5,5],ymm14[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 48(%rcx), %xmm1
; AVX-NEXT:    vmovaps 48(%rdx), %xmm5
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm5[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[3,3],ymm2[3,3],ymm3[7,7],ymm2[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm5[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 32(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2,3,4],ymm5[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm5[2],ymm1[3,4,5,6],ymm5[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 68(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps {{.*#+}} xmm1 = zero,zero,xmm10[2],xmm13[2]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 80(%rsi), %xmm0
; AVX-NEXT:    vmovaps 80(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm5 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 64(%rdx), %ymm13
; AVX-NEXT:    vmovaps 64(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm13[1,1],ymm1[5,5],ymm13[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 80(%rcx), %xmm1
; AVX-NEXT:    vmovaps 80(%rdx), %xmm5
; AVX-NEXT:    vshufps {{.*#+}} xmm6 = xmm5[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[3,3],ymm2[3,3],ymm3[7,7],ymm2[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm5[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 64(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2,3,4],ymm5[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm5[2],ymm1[3,4,5,6],ymm5[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 100(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps $51, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = zero,zero,xmm7[2],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 112(%rsi), %xmm0
; AVX-NEXT:    vmovaps 112(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 112(%rcx), %xmm1
; AVX-NEXT:    vmovaps 112(%rdx), %xmm2
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm2[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,3],ymm3[3,3],ymm2[7,7],ymm3[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 96(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2],ymm1[3,4,5,6],ymm2[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 132(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps $51, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = zero,zero,xmm8[2],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 144(%rsi), %xmm0
; AVX-NEXT:    vmovaps 144(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm2[1,1],ymm1[5,5],ymm2[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 144(%rcx), %xmm1
; AVX-NEXT:    vmovaps 144(%rdx), %xmm2
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 128(%rdi), %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,3],ymm3[3,3],ymm2[7,7],ymm3[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 128(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2],ymm1[3,4,5,6],ymm2[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 164(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps $51, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = zero,zero,xmm4[2],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 176(%rsi), %xmm0
; AVX-NEXT:    vmovaps 176(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rcx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,1],ymm2[1,1],ymm1[5,5],ymm2[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 176(%rcx), %xmm1
; AVX-NEXT:    vmovaps 176(%rdx), %xmm2
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 160(%rdi), %ymm12
; AVX-NEXT:    vmovaps 160(%rsi), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[3,3],ymm12[3,3],ymm2[7,7],ymm12[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 160(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2],ymm1[3,4,5,6],ymm2[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 196(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vinsertps $51, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = zero,zero,xmm9[2],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 208(%rsi), %xmm0
; AVX-NEXT:    vmovaps 208(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rcx), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[1,1],ymm1[1,1],ymm2[5,5],ymm1[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 208(%rcx), %xmm1
; AVX-NEXT:    vmovaps 208(%rdx), %xmm2
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[3,3],xmm1[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 192(%rdi), %ymm8
; AVX-NEXT:    vmovaps 192(%rsi), %ymm9
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[3,3],ymm8[3,3],ymm9[7,7],ymm8[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 192(%r8), %ymm10
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm10[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2,3,4],ymm2[5],ymm0[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm2[2],ymm1[3,4,5,6],ymm2[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[2],mem[2],xmm0[3],mem[3]
; AVX-NEXT:    vbroadcastss 228(%rcx), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX-NEXT:    vinsertps $51, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = zero,zero,xmm2[2],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 240(%rsi), %xmm0
; AVX-NEXT:    vmovaps 240(%rdi), %xmm1
; AVX-NEXT:    vinsertps {{.*#+}} xmm2 = zero,zero,xmm1[2],xmm0[2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[1,1],xmm0[1,1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 224(%rdx), %ymm6
; AVX-NEXT:    vmovaps 224(%rcx), %ymm4
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[1,1],ymm6[1,1],ymm4[5,5],ymm6[5,5]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX-NEXT:    vmovaps 240(%rcx), %xmm0
; AVX-NEXT:    vmovaps 240(%rdx), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX-NEXT:    vmovaps 224(%rsi), %ymm0
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[3,3],ymm2[3,3],ymm0[7,7],ymm2[7,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0,1,2],ymm5[3,4],ymm1[5,6,7]
; AVX-NEXT:    vmovaps 224(%r8), %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3,2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm7[0],ymm3[1,2,3,4],ymm7[5],ymm3[6,7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm7[2],ymm5[3,4,5,6],ymm7[7]
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = ymm3[0,1,2,3],mem[4],ymm3[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX-NEXT:    # ymm5 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm11[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1],ymm5[2],ymm7[3,4,5,6],ymm5[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm5[1,2,3],ymm3[4,5],ymm5[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm11 # 32-byte Folded Reload
; AVX-NEXT:    # ymm11 = ymm3[0,1,2],mem[3],ymm3[4,5,6,7]
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = ymm3[0,1,2,3],mem[4],ymm3[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm15[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm14[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1],ymm5[2],ymm7[3,4,5,6],ymm5[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm5[1,2,3],ymm3[4,5],ymm5[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm7 # 32-byte Folded Reload
; AVX-NEXT:    # ymm7 = ymm3[0,1,2],mem[3],ymm3[4,5,6,7]
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = ymm3[0,1,2,3],mem[4],ymm3[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Folded Reload
; AVX-NEXT:    # ymm5 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm15 = ymm13[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm15[0,1],ymm5[2],ymm15[3,4,5,6],ymm5[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm5[1,2,3],ymm3[4,5],ymm5[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm5 # 32-byte Folded Reload
; AVX-NEXT:    # ymm5 = ymm3[0,1,2],mem[3],ymm3[4,5,6,7]
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = ymm3[0,1,2,3],mem[4],ymm3[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX-NEXT:    # ymm14 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4,5,6],ymm15[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm14[1,2,3],ymm3[4,5],ymm14[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    # ymm3 = ymm3[0,1,2],mem[3],ymm3[4,5,6,7]
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX-NEXT:    # ymm14 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX-NEXT:    # ymm14 = ymm14[0,1,2,3],mem[4],ymm14[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX-NEXT:    # ymm13 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4,5,6],ymm15[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2,3],ymm14[4,5],ymm13[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX-NEXT:    # ymm13 = ymm13[0,1,2],mem[3],ymm13[4,5,6,7]
; AVX-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX-NEXT:    # ymm14 = mem[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm12[4],ymm14[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX-NEXT:    # ymm12 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm15[2],ymm12[3,4,5,6],ymm15[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm12 = ymm14[0],ymm12[1,2,3],ymm14[4,5],ymm12[6,7]
; AVX-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX-NEXT:    # ymm12 = ymm12[0,1,2],mem[3],ymm12[4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4],ymm9[5,6,7]
; AVX-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX-NEXT:    # ymm9 = mem[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vpermilpd $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX-NEXT:    # ymm14 = mem[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm14[0,1],ymm9[2],ymm14[3,4,5,6],ymm9[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm9[1,2,3],ymm8[4,5],ymm9[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2],ymm10[3],ymm8[4,5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4],ymm0[5,6,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm4[0,1,3,0,4,5,7,4]
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm6[1,0,2,2]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2],ymm4[3,4,5,6],ymm2[7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm2[1,2,3],ymm0[4,5],ymm2[6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovaps %ymm0, 1184(%r9)
; AVX-NEXT:    vmovaps %ymm8, 1024(%r9)
; AVX-NEXT:    vmovaps %ymm12, 864(%r9)
; AVX-NEXT:    vmovaps %ymm13, 704(%r9)
; AVX-NEXT:    vmovaps %ymm3, 544(%r9)
; AVX-NEXT:    vmovaps %ymm5, 384(%r9)
; AVX-NEXT:    vmovaps %ymm7, 224(%r9)
; AVX-NEXT:    vmovaps %ymm11, 64(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1248(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1216(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1152(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1088(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1056(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 992(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 928(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 896(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 768(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 736(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 672(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%r9)
; AVX-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1120(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 960(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 800(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 640(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    addq $1784, %rsp # imm = 0x6F8
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride5_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $1736, %rsp # imm = 0x6C8
; AVX2-NEXT:    vmovaps (%r8), %ymm15
; AVX2-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r8), %ymm14
; AVX2-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%r8), %ymm13
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rcx), %xmm7
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX2-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm12[0,1],ymm5[2,3],ymm12[4,5,6],ymm5[7]
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX2-NEXT:    vinsertf128 $1, (%r8), %ymm11, %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0],ymm5[1,2,3],ymm11[4],ymm5[5,6,7]
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5],ymm9[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm15[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5],ymm8[6],ymm7[7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,0,2,1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm12[0],xmm6[0],xmm12[1],xmm6[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm8[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3],ymm9[4,5,6],ymm7[7]
; AVX2-NEXT:    vinsertf128 $1, 32(%r8), %ymm8, %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3],ymm8[4],ymm7[5,6,7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm12[2],xmm6[2],xmm12[3],xmm6[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm6[2,3],ymm3[4,5],ymm6[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3,4,5],ymm4[6],ymm3[7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm4[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6],ymm3[7]
; AVX2-NEXT:    vinsertf128 $1, 64(%r8), %ymm4, %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1,2,3],ymm4[4],ymm3[5,6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm13[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm3
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-NEXT:    vmovaps 96(%r8), %ymm6
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, 96(%r8), %ymm5, %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rcx), %xmm0
; AVX2-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps 128(%rsi), %xmm3
; AVX2-NEXT:    vmovaps 128(%rdi), %xmm4
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-NEXT:    vinsertf128 $1, 128(%r8), %ymm5, %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vmovaps 128(%r8), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rcx), %xmm0
; AVX2-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps 160(%rsi), %xmm3
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm4
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-NEXT:    vinsertf128 $1, 160(%r8), %ymm5, %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rcx), %xmm0
; AVX2-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps 192(%rsi), %xmm3
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm4
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-NEXT:    vinsertf128 $1, 192(%r8), %ymm5, %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX2-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-NEXT:    vmovaps 224(%rsi), %xmm3
; AVX2-NEXT:    vmovaps 224(%rdi), %xmm4
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-NEXT:    vinsertf128 $1, 224(%r8), %ymm5, %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %ymm15
; AVX2-NEXT:    vmovaps (%rcx), %ymm13
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovaps %ymm13, %ymm2
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3,4],ymm15[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps (%rdi), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rsi), %ymm13
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 16(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm15[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm3[2],ymm13[3],ymm3[3],ymm13[6],ymm3[6],ymm13[7],ymm3[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm13
; AVX2-NEXT:    vmovaps 32(%rcx), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps %ymm13, %ymm3
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm13
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 48(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm2[2],ymm13[3],ymm2[3],ymm13[6],ymm2[6],ymm13[7],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm13
; AVX2-NEXT:    vmovaps 64(%rcx), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps %ymm13, %ymm3
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 80(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm2[2],ymm13[3],ymm2[3],ymm13[6],ymm2[6],ymm13[7],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-NEXT:    vmovaps 96(%rcx), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovaps %ymm14, %ymm4
; AVX2-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm14[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 112(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm14[2],ymm2[2],ymm14[3],ymm2[3],ymm14[6],ymm2[6],ymm14[7],ymm2[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm13
; AVX2-NEXT:    vmovaps 128(%rcx), %ymm1
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps %ymm13, %ymm4
; AVX2-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm13
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 144(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm3[2],ymm13[3],ymm3[3],ymm13[6],ymm3[6],ymm13[7],ymm3[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-NEXT:    vmovaps 160(%rcx), %ymm12
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm10
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm9
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm9[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm10[1,2],ymm1[3,4],ymm10[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 176(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm9[2],ymm10[2],ymm9[3],ymm10[3],ymm9[6],ymm10[6],ymm9[7],ymm10[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm8
; AVX2-NEXT:    vmovaps 192(%rcx), %ymm6
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm8[1],ymm0[2,3,4],ymm8[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1,2],ymm1[3,4],ymm5[5,6],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-NEXT:    vbroadcastsd 208(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm3
; AVX2-NEXT:    vmovaps 224(%rcx), %ymm2
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm0[2,2,2,2]
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm1[1,2],ymm11[3,4],ymm1[5,6],ymm11[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1,2],ymm7[3,4],ymm11[5,6,7]
; AVX2-NEXT:    vbroadcastsd 240(%r8), %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0],ymm7[1,2,3,4],ymm11[5],ymm7[6,7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0],ymm7[1,2],ymm11[3,4],ymm7[5,6],ymm11[7]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[3,3,3,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm11[3,4],ymm7[5,6,7]
; AVX2-NEXT:    vbroadcastsd 248(%r8), %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm11[2],ymm7[3,4,5,6],ymm11[7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm15[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4,5,6],ymm11[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm11[1,2,3],ymm7[4,5],ymm11[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4,5,6],ymm11[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm11[1,2,3],ymm7[4,5],ymm11[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4,5,6],ymm11[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm11[1,2,3],ymm7[4,5],ymm11[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm14[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = mem[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4,5,6],ymm15[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm14[1,2,3],ymm7[4,5],ymm14[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm14 = ymm13[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = ymm14[0,1,2,3],mem[4],ymm14[5,6,7]
; AVX2-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm13 = mem[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4,5,6],ymm15[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2,3],ymm14[4,5],ymm13[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm13 = ymm13[0,1,2],mem[3],ymm13[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4],ymm9[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm12[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm12 = mem[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0,1],ymm10[2],ymm12[3,4,5,6],ymm10[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2,3],ymm9[4,5],ymm10[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm9 = ymm9[0,1,2],mem[3],ymm9[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4],ymm4[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm6 = ymm8[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4,5,6],ymm5[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4,5,6],ymm1[7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm0, 1184(%r9)
; AVX2-NEXT:    vmovaps %ymm4, 1024(%r9)
; AVX2-NEXT:    vmovaps %ymm9, 864(%r9)
; AVX2-NEXT:    vmovaps %ymm13, 704(%r9)
; AVX2-NEXT:    vmovaps %ymm7, 544(%r9)
; AVX2-NEXT:    vmovaps %ymm11, 384(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1248(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1216(%r9)
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1088(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1056(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 928(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 896(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 768(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 736(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 608(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1152(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1120(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 992(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 960(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 832(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-NEXT:    addq $1736, %rsp # imm = 0x6C8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride5_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $1736, %rsp # imm = 0x6C8
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm15
; AVX2-FP-NEXT:    vmovups %ymm15, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm14
; AVX2-FP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm13
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm7
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm10
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm12[0,1],ymm5[2,3],ymm12[4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX2-FP-NEXT:    vinsertf128 $1, (%r8), %ymm11, %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0],ymm5[1,2,3],ymm11[4],ymm5[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm9 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm8[2],xmm7[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5],ymm9[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3,4,5],ymm8[6],ymm7[7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,0,2,1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm12[0],xmm6[0],xmm12[1],xmm6[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm8 = xmm8[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm8[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3],ymm9[4,5,6],ymm7[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 32(%r8), %ymm8, %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0],ymm7[1,2,3],ymm8[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm12[2],xmm6[2],xmm12[3],xmm6[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2],xmm3[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm6[2,3],ymm3[4,5],ymm6[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3,4,5],ymm4[6],ymm3[7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm4[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3],ymm6[4,5,6],ymm3[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 64(%r8), %ymm4, %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1,2,3],ymm4[4],ymm3[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm13[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vmovaps 96(%r8), %ymm6
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, 96(%r8), %ymm5, %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %xmm4
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 128(%r8), %ymm5, %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vmovaps 128(%r8), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm4
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 160(%r8), %ymm5, %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm4
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 192(%r8), %ymm5, %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %xmm3
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %xmm4
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,1,3,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm5[0,1,1,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3],ymm6[4,5,6],ymm2[7]
; AVX2-FP-NEXT:    vinsertf128 $1, 224(%r8), %ymm5, %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3],ymm5[4],ymm2[5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2],xmm0[3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[0,1,2,2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4,5],ymm1[6],ymm0[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm15
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm13
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovaps %ymm13, %ymm2
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm15[1],ymm0[2,3,4],ymm15[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm13
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm15[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm3[2],ymm13[3],ymm3[3],ymm13[6],ymm3[6],ymm13[7],ymm3[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm13
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm13, %ymm3
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm13
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm2[2],ymm13[3],ymm2[3],ymm13[6],ymm2[6],ymm13[7],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm13
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm13, %ymm3
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 80(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm2[2],ymm13[3],ymm2[3],ymm13[6],ymm2[6],ymm13[7],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm13
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm14[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovaps %ymm14, %ymm4
; AVX2-FP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm14[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 112(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm4[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm14[2],ymm2[2],ymm14[3],ymm2[3],ymm14[6],ymm2[6],ymm14[7],ymm2[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm13
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %ymm1
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm13, %ymm4
; AVX2-FP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm13
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 144(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm3[2],ymm13[3],ymm3[3],ymm13[6],ymm3[6],ymm13[7],ymm3[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %ymm12
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm10
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm9
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm9[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm10[1,2],ymm1[3,4],ymm10[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 176(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm12[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm9[2],ymm10[2],ymm9[3],ymm10[3],ymm9[6],ymm10[6],ymm9[7],ymm10[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm8
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm8[1],ymm0[2,3,4],ymm8[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm4[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1,2],ymm1[3,4],ymm5[5,6],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 208(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm6[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm3
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %ymm2
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm0[2,2,2,2]
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm1[1,2],ymm11[3,4],ymm1[5,6],ymm11[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1,2],ymm7[3,4],ymm11[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 240(%r8), %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0],ymm7[1,2,3,4],ymm11[5],ymm7[6,7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0],ymm7[1,2],ymm11[3,4],ymm7[5,6],ymm11[7]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[3,3,3,3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[2,1,3,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2],ymm11[3,4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vbroadcastsd 248(%r8), %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm11[2],ymm7[3,4,5,6],ymm11[7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm15[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4,5,6],ymm11[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm11[1,2,3],ymm7[4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4,5,6],ymm11[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm11[1,2,3],ymm7[4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4,5,6],ymm11[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm11[1,2,3],ymm7[4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm14[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4],ymm7[5,6,7]
; AVX2-FP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = mem[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4,5,6],ymm15[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm14[1,2,3],ymm7[4,5],ymm14[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = ymm7[0,1,2],mem[3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm14 = ymm13[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = ymm14[0,1,2,3],mem[4],ymm14[5,6,7]
; AVX2-FP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm13 = mem[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4,5,6],ymm15[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2,3],ymm14[4,5],ymm13[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm13 = ymm13[0,1,2],mem[3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4],ymm9[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm12[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm12 = mem[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0,1],ymm10[2],ymm12[3,4,5,6],ymm10[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2,3],ymm9[4,5],ymm10[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm9 = ymm9[0,1,2],mem[3],ymm9[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4],ymm4[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm6 = ymm8[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3,4,5,6],ymm5[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1,2,3],ymm4[4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm4 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4,5,6],ymm1[7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 1184(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm4, 1024(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm9, 864(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm13, 704(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm7, 544(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm11, 384(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1248(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1216(%r9)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1088(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1056(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 928(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 896(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 768(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 736(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 608(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1152(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1120(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 992(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 960(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 832(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FP-NEXT:    addq $1736, %rsp # imm = 0x6C8
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride5_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $1800, %rsp # imm = 0x708
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm8
; AVX2-FCP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm11
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm13
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm14
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm14[2],xmm11[2],xmm14[3],xmm11[3]
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm9 = [0,1,0,1,u,u,2,2]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm15
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm4
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm3 = xmm4[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm15[2],xmm3[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm8[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm3[1],ymm2[2,3,4,5],ymm3[6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm7[2],xmm13[2],xmm7[3],xmm13[3]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm9, %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm3 = xmm12[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm10[2],xmm3[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm5[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm3[1],ymm2[2,3,4,5],ymm3[6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm9, %ymm2
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm8
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm6
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm3 = xmm6[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm8[2],xmm3[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm0[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm3[1],ymm2[2,3,4,5],ymm3[6],ymm2[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-FCP-NEXT:    vpermps %ymm2, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm5 = xmm3[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1],ymm0[2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm0[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm5[1],ymm1[2,3,4,5],ymm5[6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm5 = xmm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4,5],ymm5[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, (%rsp) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm5 = xmm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4,5],ymm5[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm5 = xmm2[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4,5],ymm5[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm2
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm5 = xmm0[1,1,2,2]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm1[2],xmm5[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,1,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm2[2,3],ymm5[4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4,5],ymm5[6],ymm0[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm15[0],xmm4[0],xmm15[1],xmm4[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm14[0],xmm11[0],xmm14[1],xmm11[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm4 = [0,1,3,2,3,2,3,2]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, (%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm15
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm15[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm11
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1,2],ymm1[3,4],ymm2[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm15[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm5[2],ymm2[2],ymm5[3],ymm2[3],ymm5[6],ymm2[6],ymm5[7],ymm2[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm10[0],xmm12[0],xmm10[1],xmm12[1]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm7[0],xmm13[0],xmm7[1],xmm13[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 32(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm5
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %ymm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm5[1],ymm0[2,3,4],ymm5[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm5, %ymm10
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm7
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm5[1,2],ymm1[3,4],ymm5[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm7[2],ymm5[2],ymm7[3],ymm5[3],ymm7[6],ymm5[6],ymm7[7],ymm5[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm8[0],xmm6[0],xmm8[1],xmm6[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 64(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovaps %ymm2, %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm7
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1,2],ymm1[3,4],ymm6[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm5[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[6],ymm6[6],ymm7[7],ymm6[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 96(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm14
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %ymm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm14[1],ymm0[2,3,4],ymm14[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm14, %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm14[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm14[2],ymm3[2],ymm14[3],ymm3[3],ymm14[6],ymm3[6],ymm14[7],ymm3[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 128(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm13
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %ymm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm13[1],ymm0[2,3,4],ymm13[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm13, %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm13
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm13[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm3[1,2],ymm1[3,4],ymm3[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 144(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm13[2],ymm3[2],ymm13[3],ymm3[3],ymm13[6],ymm3[6],ymm13[7],ymm3[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 160(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm1
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vmovaps %ymm2, %ymm3
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm1, %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm10
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm10[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm11[1,2],ymm1[3,4],ymm11[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 176(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm3[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm10[2],ymm11[2],ymm10[3],ymm11[3],ymm10[6],ymm11[6],ymm10[7],ymm11[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 192(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm8
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %ymm7
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm8[1],ymm0[2,3,4],ymm8[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm5
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm5[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1,2],ymm1[3,4],ymm6[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4],ymm1[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 208(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3,4],ymm1[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm7[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3,4],ymm0[5,6],ymm1[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3,4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vunpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FCP-NEXT:    vpermps %ymm1, %ymm4, %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6],ymm0[7]
; AVX2-FCP-NEXT:    vinsertf128 $1, 224(%r8), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm3
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm2[1,1,1,1,5,5,5,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1],ymm0[2,3,4],ymm3[5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[2,2,2,2]
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[1,1,2,2,5,5,6,6]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm1[1,2],ymm9[3,4],ymm1[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,2,2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0,1,2],ymm4[3,4],ymm9[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 240(%r8), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0],ymm4[1,2,3,4],ymm9[5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm2[0,2,3,3,4,6,7,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm9[0],ymm4[1,2],ymm9[3,4],ymm4[5,6],ymm9[7]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[3,3,3,3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,3,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2],ymm9[3,4],ymm4[5,6,7]
; AVX2-FCP-NEXT:    vbroadcastsd 248(%r8), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm9[2],ymm4[3,4,5,6],ymm9[7]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = mem[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm4[0,1,2,3],mem[4],ymm4[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm15[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm12 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm12[0,1],ymm9[2],ymm12[3,4,5,6],ymm9[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm9[1,2,3],ymm4[4,5],ymm9[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = mem[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm4[0,1,2,3],mem[4],ymm4[5,6,7]
; AVX2-FCP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm9 = mem[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm12 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm12[0,1],ymm9[2],ymm12[3,4,5,6],ymm9[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm9[1,2,3],ymm4[4,5],ymm9[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm12 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm12 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vpermilps $227, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = mem[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm4[0,1,2,3],mem[4],ymm4[5,6,7]
; AVX2-FCP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm9 = mem[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm15[0,1],ymm9[2],ymm15[3,4,5,6],ymm9[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm9[1,2,3],ymm4[4,5],ymm9[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm9 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm9 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm14[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm4[0,1,2,3],mem[4],ymm4[5,6,7]
; AVX2-FCP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm14[1,2,3],ymm4[4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = ymm4[0,1,2],mem[3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm14 = ymm13[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps $16, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = ymm14[0,1,2,3],mem[4],ymm14[5,6,7]
; AVX2-FCP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm13 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4,5,6],ymm15[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2,3],ymm14[4,5],ymm13[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm13 = ymm13[0,1,2],mem[3],ymm13[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm10 = ymm10[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4],ymm10[5,6,7]
; AVX2-FCP-NEXT:    vpermilps $52, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm11 = mem[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vpermilps $78, (%rsp), %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = mem[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0,1],ymm11[2],ymm14[3,4,5,6],ymm11[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0],ymm11[1,2,3],ymm10[4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm10 = ymm10[0,1,2],mem[3],ymm10[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4],ymm5[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm8[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4,5,6],ymm6[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1,2,3],ymm5[4,5],ymm6[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm5 = ymm5[0,1,2],mem[3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[3,0,2,3,7,4,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4],ymm0[5,6,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,1,3,0,4,5,7,4]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[2,3,0,1,6,7,4,5]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4,5,6],ymm1[7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vblendps $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm0[0,1,2],mem[3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1184(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 1024(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 864(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 704(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 544(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 384(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 224(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1248(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1216(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1120(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1088(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1056(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 960(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 928(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 896(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 768(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 736(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1152(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 992(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 832(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX2-FCP-NEXT:    addq $1800, %rsp # imm = 0x708
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride5_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512-NEXT:    kmovw %eax, %k3
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride5_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512-FCP-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512-FCP-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512-FCP-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512-FCP-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512-FCP-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512-FCP-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512-FCP-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512-FCP-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512-FCP-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512-FCP-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512-FCP-NEXT:    kmovw %eax, %k3
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512-FCP-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512-FCP-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride5_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512DQ-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512DQ-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512DQ-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512DQ-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512DQ-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512DQ-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512DQ-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512DQ-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512DQ-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512DQ-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512DQ-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512DQ-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512DQ-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-NEXT:    kmovw %eax, %k3
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512DQ-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512DQ-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512DQ-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512DQ-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512DQ-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512DQ-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512DQ-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride5_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-FCP-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-FCP-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512DQ-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k3
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512DQ-FCP-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride5_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512BW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512BW-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512BW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512BW-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512BW-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512BW-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512BW-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512BW-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512BW-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512BW-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512BW-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512BW-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512BW-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512BW-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512BW-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512BW-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512BW-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512BW-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512BW-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512BW-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512BW-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512BW-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride5_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512BW-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512BW-FCP-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512BW-FCP-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512BW-FCP-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512BW-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512BW-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512BW-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512BW-FCP-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride5_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-BW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512DQ-BW-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-BW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512DQ-BW-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512DQ-BW-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512DQ-BW-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512DQ-BW-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512DQ-BW-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512DQ-BW-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride5_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm29
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [17,0,0,16,2,18,0,1,17,0,0,16,2,18,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm21, %zmm28, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,16,2,18,0,1,17,3,0,16,2,18,0,1,17,3]
; AVX512DQ-BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [14,30,0,13,29,15,31,0,14,30,0,13,29,15,31,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [0,13,29,15,31,0,14,30,0,13,29,15,31,0,14,30]
; AVX512DQ-BW-FCP-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm18, %zmm17, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [27,0,10,26,12,28,0,11,27,0,10,26,12,28,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm18, %zmm2, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [9,27,11,0,26,10,28,12,9,27,11,0,26,10,28,12]
; AVX512DQ-BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm15, %zmm14, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [6,22,8,24,0,7,23,9,6,22,8,24,0,7,23,9]
; AVX512DQ-BW-FCP-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm13, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [0,3,19,5,21,0,4,20,0,3,19,5,21,0,4,20]
; AVX512DQ-BW-FCP-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm30, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm24, %zmm4, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm29, %zmm14, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm24, %zmm13, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm24, %zmm30, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm24, %zmm28, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm14, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm28, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [8,24,0,7,23,9,25,0,8,24,0,7,23,9,25,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm4, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm13, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm30, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm18, %zmm28, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm21, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm21, %zmm1, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm21, %zmm30, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [3,21,5,0,20,4,22,6,3,21,5,0,20,4,22,6]
; AVX512DQ-BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm23, %zmm2, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm18, %zmm7, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm17, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm5, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm28, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm19, %zmm2, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm7, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm7, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm0, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm17, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm5, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm28, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm25, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm25, %zmm2, %zmm1
; AVX512DQ-BW-FCP-NEXT:    movw $12684, %ax # imm = 0x318C
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movw $25368, %ax # imm = 0x6318
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm3 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm31 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm16, %zmm22 {%k2}
; AVX512DQ-BW-FCP-NEXT:    movw $6342, %ax # imm = 0x18C6
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm21 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm15, %zmm23 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm5 = [28,1,2,3,4,29,6,7,8,9,30,11,12,13,14,31]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm15 = [0,25,2,3,4,5,26,7,8,9,10,27,12,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm16 = [0,1,22,3,4,5,6,23,8,9,10,11,24,13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm25 = [0,1,2,19,4,5,6,7,20,9,10,11,12,21,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [0,1,2,3,16,5,6,7,8,17,10,11,12,13,18,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm18 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm11, %zmm20 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm12, %zmm27 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm30 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm29, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm6 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm10, %zmm24 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm9, %zmm26 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm2, %zmm4 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm7, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm3, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm5, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm15, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm16, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm25, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm3, %zmm17 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm5, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm3, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm15, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm28, %zmm13 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm16, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa32 %zmm3, %zmm1 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm25, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 128(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, 192(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 256(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 320(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 384(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, 448(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, 512(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 576(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, 640(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm30, 704(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, 768(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, 832(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, 896(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, 960(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, 1024(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, 1088(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm31, 1152(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm0, 1216(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r9)
; AVX512DQ-BW-FCP-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <64 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i32>, ptr %in.vecptr4, align 64
  %1 = shufflevector <64 x i32> %in.vec0, <64 x i32> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i32> %in.vec2, <64 x i32> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <128 x i32> %1, <128 x i32> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %4 = shufflevector <64 x i32> %in.vec4, <64 x i32> poison, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5 = shufflevector <256 x i32> %3, <256 x i32> %4, <320 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319>
  %interleaved.vec = shufflevector <320 x i32> %5, <320 x i32> poison, <320 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 1, i32 65, i32 129, i32 193, i32 257, i32 2, i32 66, i32 130, i32 194, i32 258, i32 3, i32 67, i32 131, i32 195, i32 259, i32 4, i32 68, i32 132, i32 196, i32 260, i32 5, i32 69, i32 133, i32 197, i32 261, i32 6, i32 70, i32 134, i32 198, i32 262, i32 7, i32 71, i32 135, i32 199, i32 263, i32 8, i32 72, i32 136, i32 200, i32 264, i32 9, i32 73, i32 137, i32 201, i32 265, i32 10, i32 74, i32 138, i32 202, i32 266, i32 11, i32 75, i32 139, i32 203, i32 267, i32 12, i32 76, i32 140, i32 204, i32 268, i32 13, i32 77, i32 141, i32 205, i32 269, i32 14, i32 78, i32 142, i32 206, i32 270, i32 15, i32 79, i32 143, i32 207, i32 271, i32 16, i32 80, i32 144, i32 208, i32 272, i32 17, i32 81, i32 145, i32 209, i32 273, i32 18, i32 82, i32 146, i32 210, i32 274, i32 19, i32 83, i32 147, i32 211, i32 275, i32 20, i32 84, i32 148, i32 212, i32 276, i32 21, i32 85, i32 149, i32 213, i32 277, i32 22, i32 86, i32 150, i32 214, i32 278, i32 23, i32 87, i32 151, i32 215, i32 279, i32 24, i32 88, i32 152, i32 216, i32 280, i32 25, i32 89, i32 153, i32 217, i32 281, i32 26, i32 90, i32 154, i32 218, i32 282, i32 27, i32 91, i32 155, i32 219, i32 283, i32 28, i32 92, i32 156, i32 220, i32 284, i32 29, i32 93, i32 157, i32 221, i32 285, i32 30, i32 94, i32 158, i32 222, i32 286, i32 31, i32 95, i32 159, i32 223, i32 287, i32 32, i32 96, i32 160, i32 224, i32 288, i32 33, i32 97, i32 161, i32 225, i32 289, i32 34, i32 98, i32 162, i32 226, i32 290, i32 35, i32 99, i32 163, i32 227, i32 291, i32 36, i32 100, i32 164, i32 228, i32 292, i32 37, i32 101, i32 165, i32 229, i32 293, i32 38, i32 102, i32 166, i32 230, i32 294, i32 39, i32 103, i32 167, i32 231, i32 295, i32 40, i32 104, i32 168, i32 232, i32 296, i32 41, i32 105, i32 169, i32 233, i32 297, i32 42, i32 106, i32 170, i32 234, i32 298, i32 43, i32 107, i32 171, i32 235, i32 299, i32 44, i32 108, i32 172, i32 236, i32 300, i32 45, i32 109, i32 173, i32 237, i32 301, i32 46, i32 110, i32 174, i32 238, i32 302, i32 47, i32 111, i32 175, i32 239, i32 303, i32 48, i32 112, i32 176, i32 240, i32 304, i32 49, i32 113, i32 177, i32 241, i32 305, i32 50, i32 114, i32 178, i32 242, i32 306, i32 51, i32 115, i32 179, i32 243, i32 307, i32 52, i32 116, i32 180, i32 244, i32 308, i32 53, i32 117, i32 181, i32 245, i32 309, i32 54, i32 118, i32 182, i32 246, i32 310, i32 55, i32 119, i32 183, i32 247, i32 311, i32 56, i32 120, i32 184, i32 248, i32 312, i32 57, i32 121, i32 185, i32 249, i32 313, i32 58, i32 122, i32 186, i32 250, i32 314, i32 59, i32 123, i32 187, i32 251, i32 315, i32 60, i32 124, i32 188, i32 252, i32 316, i32 61, i32 125, i32 189, i32 253, i32 317, i32 62, i32 126, i32 190, i32 254, i32 318, i32 63, i32 127, i32 191, i32 255, i32 319>
  store <320 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
