; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK,RV32I %s
; RUN: llc -relocation-model=pic -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=CHECK,RV32I-PIC %s

declare i32 @external_function(i32)

define i32 @test_call_external(i32 %a) nounwind {
; CHECK-LABEL: test_call_external:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    call external_function
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @external_function(i32 %a)
  ret i32 %1
}

declare dso_local i32 @dso_local_function(i32)

define i32 @test_call_dso_local(i32 %a) nounwind {
; CHECK-LABEL: test_call_dso_local:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    call dso_local_function
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @dso_local_function(i32 %a)
  ret i32 %1
}

define i32 @defined_function(i32 %a) nounwind {
; CHECK-LABEL: defined_function:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, 1
; CHECK-NEXT:    ret
  %1 = add i32 %a, 1
  ret i32 %1
}

define i32 @test_call_defined(i32 %a) nounwind {
; CHECK-LABEL: test_call_defined:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    call defined_function
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @defined_function(i32 %a)
  ret i32 %1
}

define i32 @test_call_indirect(ptr %a, i32 %b) nounwind {
; CHECK-LABEL: test_call_indirect:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    jalr a2
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 %a(i32 %b)
  ret i32 %1
}

; Make sure we don't use t0 as the source for jalr as that is a hint to pop the
; return address stack on some microarchitectures.
define i32 @test_call_indirect_no_t0(ptr %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h) nounwind {
; CHECK-LABEL: test_call_indirect_no_t0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv t1, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    mv a2, a3
; CHECK-NEXT:    mv a3, a4
; CHECK-NEXT:    mv a4, a5
; CHECK-NEXT:    mv a5, a6
; CHECK-NEXT:    mv a6, a7
; CHECK-NEXT:    jalr t1
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 %a(i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h)
  ret i32 %1
}

; Ensure that calls to fastcc functions aren't rejected. Such calls may be
; introduced when compiling with optimisation.

define fastcc i32 @fastcc_function(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: fastcc_function:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    ret
 %1 = add i32 %a, %b
 ret i32 %1
}

define i32 @test_call_fastcc(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: test_call_fastcc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    call fastcc_function
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fastcc i32 @fastcc_function(i32 %a, i32 %b)
  ret i32 %a
}

declare i32 @external_many_args(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) nounwind

define i32 @test_call_external_many_args(i32 %a) nounwind {
; CHECK-LABEL: test_call_external_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:    sw a0, 4(sp)
; CHECK-NEXT:    sw a0, 0(sp)
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a4, a0
; CHECK-NEXT:    mv a5, a0
; CHECK-NEXT:    mv a6, a0
; CHECK-NEXT:    mv a7, a0
; CHECK-NEXT:    call external_many_args
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @external_many_args(i32 %a, i32 %a, i32 %a, i32 %a, i32 %a,
                                    i32 %a, i32 %a, i32 %a, i32 %a, i32 %a)
  ret i32 %a
}

define i32 @defined_many_args(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32 %j) nounwind {
; CHECK-LABEL: defined_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw a0, 4(sp)
; CHECK-NEXT:    addi a0, a0, 1
; CHECK-NEXT:    ret
  %added = add i32 %j, 1
  ret i32 %added
}

define i32 @test_call_defined_many_args(i32 %a) nounwind {
; CHECK-LABEL: test_call_defined_many_args:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    sw a0, 4(sp)
; CHECK-NEXT:    sw a0, 0(sp)
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a4, a0
; CHECK-NEXT:    mv a5, a0
; CHECK-NEXT:    mv a6, a0
; CHECK-NEXT:    mv a7, a0
; CHECK-NEXT:    call defined_many_args
; CHECK-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @defined_many_args(i32 %a, i32 %a, i32 %a, i32 %a, i32 %a,
                                   i32 %a, i32 %a, i32 %a, i32 %a, i32 %a)
  ret i32 %1
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32I: {{.*}}
; RV32I-PIC: {{.*}}
