; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-PREP10,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-PREP10,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i8, ptr %0, align 1
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 8(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i8, ptr %add.ptr, align 1
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i8, ptr %add.ptr, align 1
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_uint8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i8, ptr %add.ptr, align 1
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_uint8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx f0, r3, r4
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i8, ptr %add.ptr, align 1
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_uint8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv1 = uitofp i8 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lbz r3, 24(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 8
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 16
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 4096
  %conv = uitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_uint8_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 4080(0)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align32_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lbz r3, -27108(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = uitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i8, ptr %0, align 1
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_int8_t(ptr nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 8(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i8, ptr %add.ptr, align 1
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_int8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i8, ptr %add.ptr, align 1
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_int8_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i8, ptr %add.ptr, align 1
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_int8_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx v2, r3, r4
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i8, ptr %add.ptr, align 1
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_int8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv1 = sitofp i8 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lbz r3, 24(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 8
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 16
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 1
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i8, ptr %0, align 4096
  %conv = sitofp i8 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_int8_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 4080(0)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_int8_t() {
; CHECK-P10-LABEL: ld_cst_align32_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lbz r3, -27108(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_int8_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = sitofp i8 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i16, ptr %0, align 2
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhz r3, 8(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i16, ptr %add.ptr, align 2
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_uint16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_uint16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx f0, r3, r4
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i16, ptr %add.ptr, align 2
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_uint16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv1 = uitofp i16 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lhz r3, 24(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 8
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 16
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsihzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsihzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 4096
  %conv = uitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_uint16_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxdsp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhz r3, 4080(0)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_uint16_t() {
; CHECK-P10-LABEL: ld_cst_align32_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsihzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsihzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lhz r3, -27108(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_uint16_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsihzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsihzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxdsp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = uitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i16, ptr %0, align 2
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_int16_t(ptr nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lha r3, 8(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i16, ptr %add.ptr, align 2
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_int16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_int16_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i16, ptr %add.ptr, align 2
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_int16_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx v2, r3, r4
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i16, ptr %add.ptr, align 2
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_int16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv1 = sitofp i16 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lha r3, 24(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 8
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 16
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 2
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i16, ptr %0, align 4096
  %conv = sitofp i16 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_int16_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxdsp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lha r3, 4080(0)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_int16_t() {
; CHECK-P10-LABEL: ld_cst_align32_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lha r3, -27108(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_int16_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxdsp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxdsp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxdsp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = sitofp i16 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_0_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i32, ptr %0, align 4
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i32, ptr %add.ptr, align 4
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_uint32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_uint32_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwzx f0, r3, r4
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i32, ptr %add.ptr, align 4
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_uint32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv1 = uitofp i32 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 8
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 16
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfiwzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfiwzx f0, 0, r3
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4096
  %conv = uitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_uint32_t() {
; CHECK-LABEL: ld_cst_align16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_uint32_t() {
; CHECK-P10-LABEL: ld_cst_align32_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lfiwzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align32_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    lfiwzx f0, 0, r3
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_uint32_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfiwzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfiwzx f0, 0, r3
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = uitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_0_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i32, ptr %0, align 4
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_int32_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i32, ptr %add.ptr, align 4
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_int32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_int32_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i32, ptr %add.ptr, align 4
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_int32_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwax f0, r3, r4
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i32, ptr %add.ptr, align 4
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_int32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv1 = sitofp i32 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 8
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_int32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 16
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_int32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfiwax f0, 0, r3
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfiwax f0, 0, r3
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_int32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i32, ptr %0, align 4096
  %conv = sitofp i32 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_int32_t() {
; CHECK-LABEL: ld_cst_align16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_int32_t() {
; CHECK-P10-LABEL: ld_cst_align32_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lfiwax f0, 0, r3
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align32_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    lfiwax f0, 0, r3
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 9999900 to ptr), align 4
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_int32_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfiwax f0, 0, r3
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfiwax f0, 0, r3
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = sitofp i32 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_0_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i64, ptr %0, align 8
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i64, ptr %add.ptr, align 8
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_uint64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_uint64_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i64, ptr %add.ptr, align 8
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_uint64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv1 = uitofp i64 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 16
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 4096
  %conv = uitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_uint64_t() {
; CHECK-LABEL: ld_cst_align16_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_uint64_t() {
; CHECK-LABEL: ld_cst_align32_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_uint64_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvuxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvuxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = uitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_0_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load i64, ptr %0, align 8
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_int64_t(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load i64, ptr %add.ptr, align 8
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_int64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_int64_t(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load i64, ptr %add.ptr, align 8
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_int64_t(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load i64, ptr %add.ptr, align 8
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_int64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv1 = sitofp i64 %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_int64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 16
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_int64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 8
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_int64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load i64, ptr %0, align 4096
  %conv = sitofp i64 %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_int64_t() {
; CHECK-LABEL: ld_cst_align16_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_int64_t() {
; CHECK-LABEL: ld_cst_align32_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_int64_t() {
; CHECK-P10-LABEL: ld_cst_align64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvsxdsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvsxdsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i64, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = sitofp i64 %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_float(i64 %ptr) {
; CHECK-LABEL: ld_0_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load float, ptr %0, align 4
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_float(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f1, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load float, ptr %add.ptr, align 4
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfs f1, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load float, ptr %add.ptr, align 4
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_float(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load float, ptr %add.ptr, align 4
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_float(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfsx f1, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load float, ptr %add.ptr, align 4
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_float(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_float(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfs f1, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 8
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfs f1, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 16
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfs f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load float, ptr %0, align 4096
  ret float %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_float() {
; CHECK-LABEL: ld_cst_align16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f1, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 4080 to ptr), align 16
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_float() {
; CHECK-LABEL: ld_cst_align32_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfs f1, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 9999900 to ptr), align 4
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_float() {
; CHECK-P10-LABEL: ld_cst_align64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfs f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load float, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret float %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_0_float_double(i64 %ptr) {
; CHECK-LABEL: ld_0_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align16_float_double(ptr nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align32_float_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    plfd f0, 99999000(r3), 0
; CHECK-P10-NEXT:    xsrsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xsrsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_align64_float_double(ptr nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xsrsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xsrsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_reg_float_double(ptr nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  %0 = load double, ptr %add.ptr, align 8
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_or_float_double(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv1 = fptrunc double %1 to float
  ret float %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint16_float_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align16_float_double(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint32_float_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align32_float_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    plfd f0, 999990000(r3), 0
; CHECK-P10-NEXT:    xsrsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xsrsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 16
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_not_disjoint64_float_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xsrsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xsrsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 8
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_disjoint_align64_float_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xsrsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xsrsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  %1 = load double, ptr %0, align 4096
  %conv = fptrunc double %1 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align16_float_double() {
; CHECK-LABEL: ld_cst_align16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 4080 to ptr), align 16
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align32_float_double() {
; CHECK-LABEL: ld_cst_align32_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xsrsp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 9999900 to ptr), align 8
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local float @ld_cst_align64_float_double() {
; CHECK-P10-LABEL: ld_cst_align64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xsrsp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xsrsp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load double, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  %conv = fptrunc double %0 to float
  ret float %conv
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_uint8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_0_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %0 = inttoptr i64 %ptr to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_uint8_t(ptr nocapture %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_align16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_uint8_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 1525
; CHECK-P8-NEXT:    ori r5, r5, 56600
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_uint8_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_uint8_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-POSTP8-LABEL: st_reg_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_uint8_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-POSTP8-LABEL: st_or1_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stb r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_uint8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_uint8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui float %str to i8
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_uint8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_uint8_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r5, r5, 41712
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui float %str to i8
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_uint8_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r5, 29
; CHECK-P8-NEXT:    rldic r5, r5, 35, 24
; CHECK-P8-NEXT:    oris r5, r5, 54437
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    ori r5, r5, 4097
; CHECK-P8-NEXT:    or r3, r3, r5
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_uint8_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui float %str to i8
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_uint8_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_float_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  store i8 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_uint8_t(float %str) {
; CHECK-P10-LABEL: st_cst_align32_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  store i8 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_uint8_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_float_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_float_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, 0(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i8
  store i8 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_int8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_0_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %0 = inttoptr i64 %ptr to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_int8_t(ptr nocapture %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_align16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_int8_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 1525
; CHECK-P8-NEXT:    ori r5, r5, 56600
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_int8_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_int8_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-POSTP8-LABEL: st_reg_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i8 %conv, ptr %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_int8_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-POSTP8-LABEL: st_or1_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stb r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_int8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_int8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi float %str to i8
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_int8_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_int8_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r5, r5, 41712
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi float %str to i8
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_int8_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r5, 29
; CHECK-P8-NEXT:    rldic r5, r5, 35, 24
; CHECK-P8-NEXT:    oris r5, r5, 54437
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    ori r5, r5, 4097
; CHECK-P8-NEXT:    or r3, r3, r5
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_int8_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stbx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi float %str to i8
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i8 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_int8_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_float_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  store i8 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_int8_t(float %str) {
; CHECK-P10-LABEL: st_cst_align32_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  store i8 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_int8_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_float_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_float_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, 0(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i8
  store i8 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_uint16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_0_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %0 = inttoptr i64 %ptr to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_uint16_t(ptr nocapture %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_align16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_uint16_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 1525
; CHECK-P8-NEXT:    ori r5, r5, 56600
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_uint16_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_uint16_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-POSTP8-LABEL: st_reg_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_uint16_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-POSTP8-LABEL: st_or1_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sth r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_uint16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_uint16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui float %str to i16
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_uint16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_uint16_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r5, r5, 41712
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui float %str to i16
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_uint16_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r5, 29
; CHECK-P8-NEXT:    rldic r5, r5, 35, 24
; CHECK-P8-NEXT:    oris r5, r5, 54437
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    ori r5, r5, 4097
; CHECK-P8-NEXT:    or r3, r3, r5
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_uint16_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui float %str to i16
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_uint16_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_float_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  store i16 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_uint16_t(float %str) {
; CHECK-P10-LABEL: st_cst_align32_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  store i16 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_uint16_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_float_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_float_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, 0(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i16
  store i16 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_int16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_0_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %0 = inttoptr i64 %ptr to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_int16_t(ptr nocapture %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_align16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_int16_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 1525
; CHECK-P8-NEXT:    ori r5, r5, 56600
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_int16_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_int16_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-POSTP8-LABEL: st_reg_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i16 %conv, ptr %add.ptr, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_int16_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-POSTP8-LABEL: st_or1_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sth r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_int16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_int16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi float %str to i16
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_int16_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_int16_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r5, r5, 41712
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi float %str to i16
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_int16_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r5, 29
; CHECK-P8-NEXT:    rldic r5, r5, 35, 24
; CHECK-P8-NEXT:    oris r5, r5, 54437
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    ori r5, r5, 4097
; CHECK-P8-NEXT:    or r3, r3, r5
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_int16_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r5, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r5, r5, 19025
; CHECK-P8-NEXT:    rldic r5, r5, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sthx r4, r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi float %str to i16
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i16 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_int16_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_float_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  store i16 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_int16_t(float %str) {
; CHECK-P10-LABEL: st_cst_align32_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  store i16 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_int16_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_float_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_float_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, 0(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i16
  store i16 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_uint32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_0_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %0 = inttoptr i64 %ptr to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_uint32_t(ptr nocapture %ptr, float %str) {
; CHECK-LABEL: st_align16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_uint32_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_uint32_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_uint32_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-LABEL: st_reg_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    stfiwx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_uint32_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-LABEL: st_or1_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_uint32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_uint32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_disjoint_align16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui float %str to i32
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_uint32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint32_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_uint32_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_uint32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfiwx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_uint32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    xscvdpuxws f0, f1
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    stfiwx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui float %str to i32
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_uint32_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_uint32_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui float %str to i32
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_uint32_t(float %str) {
; CHECK-LABEL: st_cst_align16_float_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  store i32 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_uint32_t(float %str) {
; CHECK-P10-LABEL: st_cst_align32_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align32_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  store i32 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_uint32_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_float_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i32
  store i32 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_int32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_0_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %0 = inttoptr i64 %ptr to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_int32_t(ptr nocapture %ptr, float %str) {
; CHECK-LABEL: st_align16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_int32_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_int32_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_int32_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-LABEL: st_reg_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    stfiwx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i32 %conv, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_int32_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-LABEL: st_or1_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_int32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_int32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_disjoint_align16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi float %str to i32
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_int32_t(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint32_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_int32_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_int32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfiwx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_int32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    stfiwx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi float %str to i32
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_int32_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_int32_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi float %str to i32
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i32 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_int32_t(float %str) {
; CHECK-LABEL: st_cst_align16_float_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  store i32 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_int32_t(float %str) {
; CHECK-P10-LABEL: st_cst_align32_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align32_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  store i32 %conv, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_int32_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_float_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i32
  store i32 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_uint64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_0_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %0 = inttoptr i64 %ptr to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_uint64_t(ptr nocapture %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_align16_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 8(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    li r4, 8
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_uint64_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds v2, f1
; CHECK-P10-NEXT:    pstxsd v2, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_uint64_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_uint64_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-LABEL: st_reg_float_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxds f0, f1
; CHECK-NEXT:    stxsdx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_uint64_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-POSTP8-LABEL: st_or1_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_uint64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_uint64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    stxsd v2, 24(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    ori r3, r3, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui float %str to i64
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_uint64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_uint64_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds v2, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pstxsd v2, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui float %str to i64
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_uint64_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds v2, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_float_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxds v2, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_uint64_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_float_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui float %str to i64
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_uint64_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 4080(0)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    li r3, 4080
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  store i64 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_uint64_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align32_float_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    lis r3, 153
; CHECK-POSTP8-NEXT:    stxsd v2, -27108(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    lis r3, 152
; CHECK-P8-NEXT:    ori r3, r3, 38428
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  store i64 %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_uint64_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds v2, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_float_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds v2, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_float_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui float %str to i64
  store i64 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_int64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_0_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %0 = inttoptr i64 %ptr to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_int64_t(ptr nocapture %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_align16_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 8(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    li r4, 8
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_int64_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds v2, f1
; CHECK-P10-NEXT:    pstxsd v2, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_int64_t(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_int64_t(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-LABEL: st_reg_float_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxds f0, f1
; CHECK-NEXT:    stxsdx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store i64 %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_int64_t(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-POSTP8-LABEL: st_or1_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_int64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_int64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    stxsd v2, 24(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    ori r3, r3, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi float %str to i64
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_int64_t(i64 %ptr, float %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_int64_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds v2, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pstxsd v2, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_float_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    lis r4, 15258
; CHECK-P8-NEXT:    ori r4, r4, 41712
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi float %str to i64
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_int64_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds v2, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_float_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxds v2, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_int64_t(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_float_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi float %str to i64
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store i64 %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_int64_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 4080(0)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    li r3, 4080
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  store i64 %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_int64_t(float %str) {
; CHECK-POSTP8-LABEL: st_cst_align32_float_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    lis r3, 153
; CHECK-POSTP8-NEXT:    stxsd v2, -27108(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    lis r3, 152
; CHECK-P8-NEXT:    ori r3, r3, 38428
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  store i64 %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_int64_t(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds v2, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_float_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds v2, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_float_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi float %str to i64
  store i64 %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_float(i64 %ptr, float %str) {
; CHECK-LABEL: st_0_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to ptr
  store float %str, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_float(ptr nocapture %ptr, float %str) {
; CHECK-LABEL: st_align16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfs f1, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store float %str, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_float(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstfs f1, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store float %str, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_float(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store float %str, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_float(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-LABEL: st_reg_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfsx f1, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store float %str, ptr %add.ptr, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_float(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-LABEL: st_or1_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_float(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_float(i64 %ptr, float %str) {
; CHECK-LABEL: st_disjoint_align16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stfs f1, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_float(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint32_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_float(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pstfs f1, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    stfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_float(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfs f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_float(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store float %str, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_float(float %str) {
; CHECK-LABEL: st_cst_align16_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfs f1, 4080(0)
; CHECK-NEXT:    blr
entry:
  store float %str, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_float(float %str) {
; CHECK-LABEL: st_cst_align32_float_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    stfs f1, -27108(r3)
; CHECK-NEXT:    blr
entry:
  store float %str, ptr inttoptr (i64 9999900 to ptr), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_float(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_float_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfs f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  store float %str, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_float_double(i64 %ptr, float %str) {
; CHECK-LABEL: st_0_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %0 = inttoptr i64 %ptr to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_float_double(ptr nocapture %ptr, float %str) {
; CHECK-LABEL: st_align16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 8
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_float_double(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align32_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pstfd f1, 99999000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 99999000
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_float_double(ptr nocapture %ptr, float %str) {
; CHECK-P10-LABEL: st_align64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 1000000000000
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_float_double(ptr nocapture %ptr, i64 %off, float %str) {
; CHECK-LABEL: st_reg_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfdx f1, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %add.ptr = getelementptr inbounds i8, ptr %ptr, i64 %off
  store double %conv, ptr %add.ptr, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_float_double(i64 %ptr, i8 zeroext %off, float %str) {
; CHECK-LABEL: st_or1_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_float_double(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_float_double(i64 %ptr, float %str) {
; CHECK-LABEL: st_disjoint_align16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stfd f1, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fpext float %str to double
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_float_double(i64 %ptr, float %str) {
; CHECK-LABEL: st_not_disjoint32_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_float_double(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align32_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pstfd f1, 999990000(r3), 0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align32_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    and r3, r3, r4
; CHECK-PREP10-NEXT:    lis r4, 15258
; CHECK-PREP10-NEXT:    ori r4, r4, 41712
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fpext float %str to double
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_float_double(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_not_disjoint64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfd f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfd f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fpext float %str to double
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_float_double(i64 %ptr, float %str) {
; CHECK-P10-LABEL: st_disjoint_align64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fpext float %str to double
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to ptr
  store double %conv, ptr %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_float_double(float %str) {
; CHECK-LABEL: st_cst_align16_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  store double %conv, ptr inttoptr (i64 4080 to ptr), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_float_double(float %str) {
; CHECK-LABEL: st_cst_align32_float_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    stfd f1, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fpext float %str to double
  store double %conv, ptr inttoptr (i64 9999900 to ptr), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_float_double(float %str) {
; CHECK-P10-LABEL: st_cst_align64_float_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfd f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_float_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfd f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fpext float %str to double
  store double %conv, ptr inttoptr (i64 1000000000000 to ptr), align 4096
  ret void
}

define dso_local void @st_reversed_float_from_i8(ptr %ptr) {
; CHECK-P10-LABEL: st_reversed_float_from_i8:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    li r4, 8
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xxspltidp vs2, -1023410176
; CHECK-P10-NEXT:    lxsibzx f1, r3, r4
; CHECK-P10-NEXT:    xscvuxdsp f0, f0
; CHECK-P10-NEXT:    xscvuxdsp f1, f1
; CHECK-P10-NEXT:    xsaddsp f0, f0, f2
; CHECK-P10-NEXT:    xsaddsp f1, f1, f2
; CHECK-P10-NEXT:    stfs f0, 8(r3)
; CHECK-P10-NEXT:    stfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_reversed_float_from_i8:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 8
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    lxsibzx f1, r3, r4
; CHECK-P9-NEXT:    addis r4, r2, .LCPI300_0@toc@ha
; CHECK-P9-NEXT:    lfs f2, .LCPI300_0@toc@l(r4)
; CHECK-P9-NEXT:    xscvuxdsp f0, f0
; CHECK-P9-NEXT:    xscvuxdsp f1, f1
; CHECK-P9-NEXT:    xsaddsp f0, f0, f2
; CHECK-P9-NEXT:    xsaddsp f1, f1, f2
; CHECK-P9-NEXT:    stfs f0, 8(r3)
; CHECK-P9-NEXT:    stfs f1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_reversed_float_from_i8:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r4, 0(r3)
; CHECK-P8-NEXT:    lbz r5, 8(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r4
; CHECK-P8-NEXT:    mtfprwz f1, r5
; CHECK-P8-NEXT:    addis r4, r2, .LCPI300_0@toc@ha
; CHECK-P8-NEXT:    lfs f2, .LCPI300_0@toc@l(r4)
; CHECK-P8-NEXT:    xscvuxdsp f0, f0
; CHECK-P8-NEXT:    xscvuxdsp f1, f1
; CHECK-P8-NEXT:    xsaddsp f0, f0, f2
; CHECK-P8-NEXT:    xsaddsp f1, f1, f2
; CHECK-P8-NEXT:    stfs f1, 0(r3)
; CHECK-P8-NEXT:    stfs f0, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %idx = getelementptr inbounds i8, ptr %ptr, i64 8
  %i0 = load i8, ptr %ptr, align 1
  %i1 = load i8, ptr %idx, align 1
  %f0 = uitofp i8 %i0 to float
  %f1 = uitofp i8 %i1 to float
  %a0 = fadd float %f0, -1.280000e+02
  %a1 = fadd float %f1, -1.280000e+02
  store float %a1, ptr %ptr, align 8
  store float %a0, ptr %idx, align 8
  ret void
}
