; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+d --target-abi=lp64d < %s \
; RUN:   | FileCheck %s

;; This file contains specific tests for the lp64d ABI.

;; Check pass floating-point arguments whith FPRs.

define i64 @callee_float_in_fpr(i64 %a, float %b, double %c) nounwind {
; CHECK-LABEL: callee_float_in_fpr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ftintrz.l.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.d $a1, $fa0
; CHECK-NEXT:    ftintrz.l.d $fa0, $fa1
; CHECK-NEXT:    movfr2gr.d $a2, $fa0
; CHECK-NEXT:    add.d $a0, $a0, $a1
; CHECK-NEXT:    add.d $a0, $a0, $a2
; CHECK-NEXT:    ret
  %b_fptosi = fptosi float %b to i64
  %c_fptosi = fptosi double %c to i64
  %1 = add i64 %a, %b_fptosi
  %2 = add i64 %1, %c_fptosi
  ret i64 %2
}

define i64 @caller_float_in_fpr() nounwind {
; CHECK-LABEL: caller_float_in_fpr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    movgr2fr.w $fa0, $zero
; CHECK-NEXT:    movgr2fr.d $fa1, $zero
; CHECK-NEXT:    ori $a0, $zero, 1
; CHECK-NEXT:    bl %plt(callee_float_in_fpr)
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call i64 @callee_float_in_fpr(i64 1, float 0.0, double 0.0)
  ret i64 %1
}

;; Check that the GPR is used once the FPRs are exhausted.

;; Must keep define on a single line due to an update_llc_test_checks.py limitation.
define i64 @callee_double_in_gpr_exhausted_fprs(double %a, double %b, double %c, double %d, double %e, double %f, double %g, double %h, double %i) nounwind {
; CHECK-LABEL: callee_double_in_gpr_exhausted_fprs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movgr2fr.d $fa0, $a0
; CHECK-NEXT:    ftintrz.l.d $fa1, $fa7
; CHECK-NEXT:    movfr2gr.d $a0, $fa1
; CHECK-NEXT:    ftintrz.l.d $fa0, $fa0
; CHECK-NEXT:    movfr2gr.d $a1, $fa0
; CHECK-NEXT:    add.d $a0, $a0, $a1
; CHECK-NEXT:    ret
  %h_fptosi = fptosi double %h to i64
  %i_fptosi = fptosi double %i to i64
  %1 = add i64 %h_fptosi, %i_fptosi
  ret i64 %1
}

define i64 @caller_double_in_gpr_exhausted_fprs() nounwind {
; CHECK-LABEL: caller_double_in_gpr_exhausted_fprs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_0)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_0)
; CHECK-NEXT:    fld.d $fa1, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_1)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_1)
; CHECK-NEXT:    fld.d $fa2, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_2)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_2)
; CHECK-NEXT:    fld.d $fa3, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_3)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_3)
; CHECK-NEXT:    fld.d $fa4, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_4)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_4)
; CHECK-NEXT:    fld.d $fa5, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_5)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_5)
; CHECK-NEXT:    fld.d $fa6, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_6)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI3_6)
; CHECK-NEXT:    fld.d $fa7, $a0, 0
; CHECK-NEXT:    addi.d $a0, $zero, 1
; CHECK-NEXT:    movgr2fr.d $fa0, $a0
; CHECK-NEXT:    ffint.d.l $fa0, $fa0
; CHECK-NEXT:    ori $a0, $zero, 0
; CHECK-NEXT:    lu32i.d $a0, 131072
; CHECK-NEXT:    lu52i.d $a0, $a0, 1026
; CHECK-NEXT:    bl %plt(callee_double_in_gpr_exhausted_fprs)
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call i64 @callee_double_in_gpr_exhausted_fprs(
      double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0,
      double 7.0, double 8.0, double 9.0)
  ret i64 %1
}

;; Check returning doubles.

define double @callee_double_ret() nounwind {
; CHECK-LABEL: callee_double_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $a0, $zero, 1
; CHECK-NEXT:    movgr2fr.d $fa0, $a0
; CHECK-NEXT:    ffint.d.l $fa0, $fa0
; CHECK-NEXT:    ret
  ret double 1.0
}

define i64 @caller_double_ret() nounwind {
; CHECK-LABEL: caller_double_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(callee_double_ret)
; CHECK-NEXT:    movfr2gr.d $a0, $fa0
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call double @callee_double_ret()
  %2 = bitcast double %1 to i64
  ret i64 %2
}
