; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

; If computeKnownBits can do a simple look-through for extractelement
; then instsimplify will know that %elt1 is non-negative at icmp.
define i1 @computeKnownBits_look_through_extractelt(<2 x i8> %vecin) {
; CHECK-LABEL: @computeKnownBits_look_through_extractelt(
; CHECK-NEXT:    ret i1 false
;
  %vec = zext <2 x i8> %vecin to <2 x i32>
  %elt1 = extractelement <2 x i32> %vec, i32 1
  %bool = icmp slt i32 %elt1, 0
  ret i1 %bool
}

; If computeNumSignBits can do a simple look-through for extractelement
; then instsimplify will remove the ashr.
define i32 @computeNumSignBits_look_through_extractelt(<2 x i1> %vecin) {
; CHECK-LABEL: @computeNumSignBits_look_through_extractelt(
; CHECK-NEXT:    [[VEC:%.*]] = sext <2 x i1> [[VEC:%.*]]in to <2 x i32>
; CHECK-NEXT:    [[ELT0:%.*]] = extractelement <2 x i32> [[VEC]], i32 0
; CHECK-NEXT:    ret i32 [[ELT0]]
;
  %vec = sext <2 x i1> %vecin to <2 x i32>
  %elt0 = extractelement <2 x i32> %vec, i32 0
  %ashr = ashr i32 %elt0, 5
  ret i32 %ashr
}
