; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=IC1 %s
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=2 -S %s | FileCheck --check-prefixes=IC2 %s

define void @switch4_default_common_dest_with_case(ptr %start, ptr %end) {
; IC1-LABEL: define void @switch4_default_common_dest_with_case(
; IC1-SAME: ptr [[START:%.*]], ptr [[END:%.*]]) {
; IC1-NEXT:  [[ENTRY:.*]]:
; IC1-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC1:       [[LOOP_HEADER]]:
; IC1-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC1-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 1
; IC1-NEXT:    switch i8 [[L]], label %[[DEFAULT:.*]] [
; IC1-NEXT:      i8 -12, label %[[IF_THEN_1:.*]]
; IC1-NEXT:      i8 13, label %[[IF_THEN_2:.*]]
; IC1-NEXT:      i8 0, label %[[DEFAULT]]
; IC1-NEXT:    ]
; IC1:       [[IF_THEN_1]]:
; IC1-NEXT:    store i8 42, ptr [[PTR_IV]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[IF_THEN_2]]:
; IC1-NEXT:    store i8 0, ptr [[PTR_IV]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[DEFAULT]]:
; IC1-NEXT:    store i8 2, ptr [[PTR_IV]], align 1
; IC1-NEXT:    br label %[[LOOP_LATCH]]
; IC1:       [[LOOP_LATCH]]:
; IC1-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i64 1
; IC1-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; IC1-NEXT:    br i1 [[EC]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; IC1:       [[EXIT]]:
; IC1-NEXT:    ret void
;
; IC2-LABEL: define void @switch4_default_common_dest_with_case(
; IC2-SAME: ptr [[START:%.*]], ptr [[END:%.*]]) {
; IC2-NEXT:  [[ENTRY:.*]]:
; IC2-NEXT:    br label %[[LOOP_HEADER:.*]]
; IC2:       [[LOOP_HEADER]]:
; IC2-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; IC2-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 1
; IC2-NEXT:    switch i8 [[L]], label %[[DEFAULT:.*]] [
; IC2-NEXT:      i8 -12, label %[[IF_THEN_1:.*]]
; IC2-NEXT:      i8 13, label %[[IF_THEN_2:.*]]
; IC2-NEXT:      i8 0, label %[[DEFAULT]]
; IC2-NEXT:    ]
; IC2:       [[IF_THEN_1]]:
; IC2-NEXT:    store i8 42, ptr [[PTR_IV]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[IF_THEN_2]]:
; IC2-NEXT:    store i8 0, ptr [[PTR_IV]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[DEFAULT]]:
; IC2-NEXT:    store i8 2, ptr [[PTR_IV]], align 1
; IC2-NEXT:    br label %[[LOOP_LATCH]]
; IC2:       [[LOOP_LATCH]]:
; IC2-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i64 1
; IC2-NEXT:    [[EC:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; IC2-NEXT:    br i1 [[EC]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; IC2:       [[EXIT]]:
; IC2-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %entry ], [ %ptr.iv.next, %loop.latch ]
  %l = load i8, ptr %ptr.iv, align 1
  switch i8 %l, label %default [
  i8 -12, label %if.then.1
  i8 13, label %if.then.2
  i8 0, label %default
  ]

if.then.1:
  store i8 42, ptr %ptr.iv, align 1
  br label %loop.latch

if.then.2:
  store i8 0, ptr %ptr.iv, align 1
  br label %loop.latch

default:
  store i8 2, ptr %ptr.iv, align 1
  br label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i64 1
  %ec = icmp eq ptr %ptr.iv.next, %end
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}
