; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv64 -mattr=+v -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,POSTRA
; RUN: llc < %s -mtriple=riscv64 -mattr=+v -riscv-vsetvl-after-rvv-regalloc=false -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,PRERA

define void @vid(ptr %p) {
; POSTRA-LABEL: vid:
; POSTRA:       # %bb.0:
; POSTRA-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; POSTRA-NEXT:    vid.v v8
; POSTRA-NEXT:    vs8r.v v8, (a0)
; POSTRA-NEXT:    vl8re64.v v16, (a0)
; POSTRA-NEXT:    vl8re64.v v24, (a0)
; POSTRA-NEXT:    vl8re64.v v0, (a0)
; POSTRA-NEXT:    vl8re64.v v8, (a0)
; POSTRA-NEXT:    vs8r.v v8, (a0)
; POSTRA-NEXT:    vs8r.v v0, (a0)
; POSTRA-NEXT:    vs8r.v v24, (a0)
; POSTRA-NEXT:    vs8r.v v16, (a0)
; POSTRA-NEXT:    vid.v v8
; POSTRA-NEXT:    vs8r.v v8, (a0)
; POSTRA-NEXT:    ret
;
; PRERA-LABEL: vid:
; PRERA:       # %bb.0:
; PRERA-NEXT:    addi sp, sp, -16
; PRERA-NEXT:    .cfi_def_cfa_offset 16
; PRERA-NEXT:    csrr a1, vlenb
; PRERA-NEXT:    slli a1, a1, 3
; PRERA-NEXT:    sub sp, sp, a1
; PRERA-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; PRERA-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; PRERA-NEXT:    vid.v v8
; PRERA-NEXT:    vs8r.v v8, (a0)
; PRERA-NEXT:    vl8re64.v v16, (a0)
; PRERA-NEXT:    addi a1, sp, 16
; PRERA-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; PRERA-NEXT:    vl8re64.v v24, (a0)
; PRERA-NEXT:    vl8re64.v v0, (a0)
; PRERA-NEXT:    vl8re64.v v16, (a0)
; PRERA-NEXT:    vs8r.v v16, (a0)
; PRERA-NEXT:    vs8r.v v0, (a0)
; PRERA-NEXT:    vs8r.v v24, (a0)
; PRERA-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; PRERA-NEXT:    vs8r.v v16, (a0)
; PRERA-NEXT:    vs8r.v v8, (a0)
; PRERA-NEXT:    csrr a0, vlenb
; PRERA-NEXT:    slli a0, a0, 3
; PRERA-NEXT:    add sp, sp, a0
; PRERA-NEXT:    addi sp, sp, 16
; PRERA-NEXT:    ret
  %vid = call <vscale x 8 x i64> @llvm.riscv.vid.nxv8i64(<vscale x 8 x i64> poison, i64 -1)
  store volatile <vscale x 8 x i64> %vid, ptr %p

  %a = load volatile <vscale x 8 x i64>, ptr %p
  %b = load volatile <vscale x 8 x i64>, ptr %p
  %c = load volatile <vscale x 8 x i64>, ptr %p
  %d = load volatile <vscale x 8 x i64>, ptr %p
  store volatile <vscale x 8 x i64> %d, ptr %p
  store volatile <vscale x 8 x i64> %c, ptr %p
  store volatile <vscale x 8 x i64> %b, ptr %p
  store volatile <vscale x 8 x i64> %a, ptr %p

  store volatile <vscale x 8 x i64> %vid, ptr %p
  ret void
}


define void @vid_passthru(ptr %p, <vscale x 8 x i64> %v) {
; CHECK-LABEL: vid_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, tu, ma
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vl8re64.v v16, (a0)
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    vl8re64.v v24, (a0)
; CHECK-NEXT:    vl8re64.v v0, (a0)
; CHECK-NEXT:    vl8re64.v v16, (a0)
; CHECK-NEXT:    vs8r.v v16, (a0)
; CHECK-NEXT:    vs8r.v v0, (a0)
; CHECK-NEXT:    vs8r.v v24, (a0)
; CHECK-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; CHECK-NEXT:    vs8r.v v16, (a0)
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %vid = call <vscale x 8 x i64> @llvm.riscv.vid.nxv8i64(<vscale x 8 x i64> %v, i64 1)
  store volatile <vscale x 8 x i64> %vid, ptr %p

  %a = load volatile <vscale x 8 x i64>, ptr %p
  %b = load volatile <vscale x 8 x i64>, ptr %p
  %c = load volatile <vscale x 8 x i64>, ptr %p
  %d = load volatile <vscale x 8 x i64>, ptr %p
  store volatile <vscale x 8 x i64> %d, ptr %p
  store volatile <vscale x 8 x i64> %c, ptr %p
  store volatile <vscale x 8 x i64> %b, ptr %p
  store volatile <vscale x 8 x i64> %a, ptr %p

  store volatile <vscale x 8 x i64> %vid, ptr %p
  ret void
}
