; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv32 -mattr=+a -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32IA,RV32IA-WMO %s
; RUN: llc -mtriple=riscv32 -mattr=+a,+experimental-zacas -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32IA,RV32IA-ZACAS,RV32IA-WMO-ZACAS %s
; RUN: llc -mtriple=riscv32 -mattr=+a,+ztso -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32IA,RV32IA-TSO %s
; RUN: llc -mtriple=riscv32 -mattr=+a,+ztso,+experimental-zacas -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32IA,RV32IA-ZACAS,RV32IA-TSO-ZACAS %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s
; RUN: llc -mtriple=riscv64 -mattr=+a -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-WMO %s
; RUN: llc -mtriple=riscv64 -mattr=+a,+experimental-zacas -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-ZACAS,RV64IA-WMO-ZACAS %s
; RUN: llc -mtriple=riscv64 -mattr=+a,+experimental-zacas,+zabha -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-ZABHA,RV64IA-WMO-ZABHA %s
; RUN: llc -mtriple=riscv64 -mattr=+a,+ztso -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-TSO %s
; RUN: llc -mtriple=riscv64 -mattr=+a,+ztso,+experimental-zacas -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-ZACAS,RV64IA-TSO-ZACAS %s
; RUN: llc -mtriple=riscv64 -mattr=+a,+ztso,+experimental-zacas,+zabha -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64IA,RV64IA-ZABHA,RV64IA-TSO-ZABHA %s

define void @cmpxchg_i8_monotonic_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    andi a2, a2, 255
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a2, (a3)
; RV32IA-NEXT:    and a5, a2, a4
; RV32IA-NEXT:    bne a5, a1, .LBB0_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB0_1 Depth=1
; RV32IA-NEXT:    xor a5, a2, a0
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a2, a5
; RV32IA-NEXT:    sc.w a5, a5, (a3)
; RV32IA-NEXT:    bnez a5, .LBB0_1
; RV32IA-NEXT:  .LBB0_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB0_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB0_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB0_1
; RV64IA-WMO-NEXT:  .LBB0_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    li a4, 255
; RV64IA-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-ZACAS-NEXT:    bne a5, a1, .LBB0_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB0_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-ZACAS-NEXT:    bnez a5, .LBB0_1
; RV64IA-ZACAS-NEXT:  .LBB0_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-ZABHA-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV64IA-ZABHA:       # %bb.0:
; RV64IA-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_monotonic_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB0_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB0_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB0_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB0_1
; RV64IA-TSO-NEXT:  .LBB0_3:
; RV64IA-TSO-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i8_acquire_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_acquire_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i8_acquire_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    andi a2, a2, 255
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a5, a2, a4
; RV32IA-WMO-NEXT:    bne a5, a1, .LBB1_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a2, a0
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a2, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-WMO-NEXT:    bnez a5, .LBB1_1
; RV32IA-WMO-NEXT:  .LBB1_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i8_acquire_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    li a4, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB1_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a5, .LBB1_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB1_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i8_acquire_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    andi a2, a2, 255
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a5, a2, a4
; RV32IA-TSO-NEXT:    bne a5, a1, .LBB1_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a2, a0
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a2, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-NEXT:    bnez a5, .LBB1_1
; RV32IA-TSO-NEXT:  .LBB1_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i8_acquire_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    li a4, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB1_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a5, .LBB1_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB1_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB1_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB1_1
; RV64IA-WMO-NEXT:  .LBB1_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    li a4, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB1_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a5, .LBB1_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB1_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB1_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB1_1
; RV64IA-TSO-NEXT:  .LBB1_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    li a4, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB1_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB1_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB1_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a5, .LBB1_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB1_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_acquire_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val acquire monotonic
  ret void
}

define void @cmpxchg_i8_acquire_acquire(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_acquire_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i8_acquire_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    andi a2, a2, 255
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a5, a2, a4
; RV32IA-WMO-NEXT:    bne a5, a1, .LBB2_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a2, a0
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a2, a5
; RV32IA-WMO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-WMO-NEXT:    bnez a5, .LBB2_1
; RV32IA-WMO-NEXT:  .LBB2_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i8_acquire_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    li a4, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB2_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a5, .LBB2_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB2_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i8_acquire_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    andi a2, a2, 255
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a5, a2, a4
; RV32IA-TSO-NEXT:    bne a5, a1, .LBB2_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a2, a0
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a2, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-NEXT:    bnez a5, .LBB2_1
; RV32IA-TSO-NEXT:  .LBB2_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i8_acquire_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    li a4, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB2_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a5, .LBB2_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB2_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_acquire_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_acquire_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB2_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB2_1
; RV64IA-WMO-NEXT:  .LBB2_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i8_acquire_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    li a4, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB2_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a5, .LBB2_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB2_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_acquire_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_acquire_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB2_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB2_1
; RV64IA-TSO-NEXT:  .LBB2_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i8_acquire_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    li a4, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB2_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB2_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB2_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a5, .LBB2_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB2_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_acquire_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val acquire acquire
  ret void
}

define void @cmpxchg_i8_release_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_release_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i8_release_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    andi a2, a2, 255
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a2, (a3)
; RV32IA-WMO-NEXT:    and a5, a2, a4
; RV32IA-WMO-NEXT:    bne a5, a1, .LBB3_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a2, a0
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a2, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-NEXT:    bnez a5, .LBB3_1
; RV32IA-WMO-NEXT:  .LBB3_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i8_release_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    li a4, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB3_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a5, .LBB3_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB3_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i8_release_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    andi a2, a2, 255
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a5, a2, a4
; RV32IA-TSO-NEXT:    bne a5, a1, .LBB3_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a2, a0
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a2, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-NEXT:    bnez a5, .LBB3_1
; RV32IA-TSO-NEXT:  .LBB3_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i8_release_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    li a4, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB3_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a5, .LBB3_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB3_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_release_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_release_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB3_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB3_1
; RV64IA-WMO-NEXT:  .LBB3_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i8_release_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    li a4, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB3_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a5, .LBB3_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB3_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_release_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.rl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_release_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB3_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB3_1
; RV64IA-TSO-NEXT:  .LBB3_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i8_release_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    li a4, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB3_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB3_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB3_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a5, .LBB3_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB3_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_release_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val release monotonic
  ret void
}

define void @cmpxchg_i8_release_acquire(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_release_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i8_release_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    andi a2, a2, 255
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a5, a2, a4
; RV32IA-WMO-NEXT:    bne a5, a1, .LBB4_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a2, a0
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a2, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-NEXT:    bnez a5, .LBB4_1
; RV32IA-WMO-NEXT:  .LBB4_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i8_release_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    li a4, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB4_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a5, .LBB4_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB4_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i8_release_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    andi a2, a2, 255
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a5, a2, a4
; RV32IA-TSO-NEXT:    bne a5, a1, .LBB4_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a2, a0
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a2, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-NEXT:    bnez a5, .LBB4_1
; RV32IA-TSO-NEXT:  .LBB4_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i8_release_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    li a4, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB4_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a5, .LBB4_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB4_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_release_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_release_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB4_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB4_1
; RV64IA-WMO-NEXT:  .LBB4_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i8_release_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    li a4, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB4_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a5, .LBB4_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB4_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_release_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_release_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB4_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB4_1
; RV64IA-TSO-NEXT:  .LBB4_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i8_release_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    li a4, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB4_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB4_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB4_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a5, .LBB4_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB4_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_release_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val release acquire
  ret void
}

define void @cmpxchg_i8_acq_rel_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    andi a2, a2, 255
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a5, a2, a4
; RV32IA-WMO-NEXT:    bne a5, a1, .LBB5_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a2, a0
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a2, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-NEXT:    bnez a5, .LBB5_1
; RV32IA-WMO-NEXT:  .LBB5_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    li a4, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB5_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a5, .LBB5_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB5_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    andi a2, a2, 255
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a5, a2, a4
; RV32IA-TSO-NEXT:    bne a5, a1, .LBB5_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a2, a0
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a2, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-NEXT:    bnez a5, .LBB5_1
; RV32IA-TSO-NEXT:  .LBB5_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    li a4, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB5_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a5, .LBB5_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB5_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB5_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB5_1
; RV64IA-WMO-NEXT:  .LBB5_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    li a4, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB5_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a5, .LBB5_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB5_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB5_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB5_1
; RV64IA-TSO-NEXT:  .LBB5_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    li a4, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB5_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB5_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB5_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a5, .LBB5_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB5_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_acq_rel_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val acq_rel monotonic
  ret void
}

define void @cmpxchg_i8_acq_rel_acquire(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    li a4, 255
; RV32IA-WMO-NEXT:    sll a4, a4, a0
; RV32IA-WMO-NEXT:    andi a1, a1, 255
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    andi a2, a2, 255
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a5, a2, a4
; RV32IA-WMO-NEXT:    bne a5, a1, .LBB6_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV32IA-WMO-NEXT:    xor a5, a2, a0
; RV32IA-WMO-NEXT:    and a5, a5, a4
; RV32IA-WMO-NEXT:    xor a5, a2, a5
; RV32IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-NEXT:    bnez a5, .LBB6_1
; RV32IA-WMO-NEXT:  .LBB6_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    li a4, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB6_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a5, .LBB6_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB6_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    li a4, 255
; RV32IA-TSO-NEXT:    sll a4, a4, a0
; RV32IA-TSO-NEXT:    andi a1, a1, 255
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    andi a2, a2, 255
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a5, a2, a4
; RV32IA-TSO-NEXT:    bne a5, a1, .LBB6_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV32IA-TSO-NEXT:    xor a5, a2, a0
; RV32IA-TSO-NEXT:    and a5, a5, a4
; RV32IA-TSO-NEXT:    xor a5, a2, a5
; RV32IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-NEXT:    bnez a5, .LBB6_1
; RV32IA-TSO-NEXT:  .LBB6_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    li a4, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a4, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB6_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV32IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a5, .LBB6_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB6_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB6_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB6_1
; RV64IA-WMO-NEXT:  .LBB6_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    li a4, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    bne a5, a1, .LBB6_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-WMO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a5, .LBB6_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB6_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB6_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB6_1
; RV64IA-TSO-NEXT:  .LBB6_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    li a4, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB6_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    bne a5, a1, .LBB6_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB6_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-TSO-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    sc.w a5, a5, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a5, .LBB6_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB6_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_acq_rel_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val acq_rel acquire
  ret void
}

define void @cmpxchg_i8_seq_cst_monotonic(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    andi a2, a2, 255
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a3)
; RV32IA-NEXT:    and a5, a2, a4
; RV32IA-NEXT:    bne a5, a1, .LBB7_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB7_1 Depth=1
; RV32IA-NEXT:    xor a5, a2, a0
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a2, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-NEXT:    bnez a5, .LBB7_1
; RV32IA-NEXT:  .LBB7_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB7_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB7_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB7_1
; RV64IA-WMO-NEXT:  .LBB7_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    li a4, 255
; RV64IA-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-ZACAS-NEXT:    bne a5, a1, .LBB7_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB7_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-ZACAS-NEXT:    bnez a5, .LBB7_1
; RV64IA-ZACAS-NEXT:  .LBB7_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB7_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB7_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB7_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB7_1
; RV64IA-TSO-NEXT:  .LBB7_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_seq_cst_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val seq_cst monotonic
  ret void
}

define void @cmpxchg_i8_seq_cst_acquire(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    andi a2, a2, 255
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a3)
; RV32IA-NEXT:    and a5, a2, a4
; RV32IA-NEXT:    bne a5, a1, .LBB8_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB8_1 Depth=1
; RV32IA-NEXT:    xor a5, a2, a0
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a2, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-NEXT:    bnez a5, .LBB8_1
; RV32IA-NEXT:  .LBB8_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB8_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB8_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB8_1
; RV64IA-WMO-NEXT:  .LBB8_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    li a4, 255
; RV64IA-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-ZACAS-NEXT:    bne a5, a1, .LBB8_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB8_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-ZACAS-NEXT:    bnez a5, .LBB8_1
; RV64IA-ZACAS-NEXT:  .LBB8_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB8_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB8_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB8_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB8_1
; RV64IA-TSO-NEXT:  .LBB8_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_seq_cst_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val seq_cst acquire
  ret void
}

define void @cmpxchg_i8_seq_cst_seq_cst(ptr %ptr, i8 %cmp, i8 %val) nounwind {
; RV32I-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sb a1, 11(sp)
; RV32I-NEXT:    addi a1, sp, 11
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    call __atomic_compare_exchange_1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    li a4, 255
; RV32IA-NEXT:    sll a4, a4, a0
; RV32IA-NEXT:    andi a1, a1, 255
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    andi a2, a2, 255
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a3)
; RV32IA-NEXT:    and a5, a2, a4
; RV32IA-NEXT:    bne a5, a1, .LBB9_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB9_1 Depth=1
; RV32IA-NEXT:    xor a5, a2, a0
; RV32IA-NEXT:    and a5, a5, a4
; RV32IA-NEXT:    xor a5, a2, a5
; RV32IA-NEXT:    sc.w.rl a5, a5, (a3)
; RV32IA-NEXT:    bnez a5, .LBB9_1
; RV32IA-NEXT:  .LBB9_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sb a1, 7(sp)
; RV64I-NEXT:    addi a1, sp, 7
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    call __atomic_compare_exchange_1
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    li a4, 255
; RV64IA-WMO-NEXT:    sllw a4, a4, a0
; RV64IA-WMO-NEXT:    andi a1, a1, 255
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    andi a2, a2, 255
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-WMO-NEXT:    and a5, a2, a4
; RV64IA-WMO-NEXT:    bne a5, a1, .LBB9_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB9_1 Depth=1
; RV64IA-WMO-NEXT:    xor a5, a2, a0
; RV64IA-WMO-NEXT:    and a5, a5, a4
; RV64IA-WMO-NEXT:    xor a5, a2, a5
; RV64IA-WMO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-WMO-NEXT:    bnez a5, .LBB9_1
; RV64IA-WMO-NEXT:  .LBB9_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    li a4, 255
; RV64IA-ZACAS-NEXT:    sllw a4, a4, a0
; RV64IA-ZACAS-NEXT:    andi a1, a1, 255
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    andi a2, a2, 255
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-ZACAS-NEXT:    and a5, a2, a4
; RV64IA-ZACAS-NEXT:    bne a5, a1, .LBB9_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB9_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a5, a2, a0
; RV64IA-ZACAS-NEXT:    and a5, a5, a4
; RV64IA-ZACAS-NEXT:    xor a5, a2, a5
; RV64IA-ZACAS-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-ZACAS-NEXT:    bnez a5, .LBB9_1
; RV64IA-ZACAS-NEXT:  .LBB9_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.b.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    li a4, 255
; RV64IA-TSO-NEXT:    sllw a4, a4, a0
; RV64IA-TSO-NEXT:    andi a1, a1, 255
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    andi a2, a2, 255
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB9_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-TSO-NEXT:    and a5, a2, a4
; RV64IA-TSO-NEXT:    bne a5, a1, .LBB9_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB9_1 Depth=1
; RV64IA-TSO-NEXT:    xor a5, a2, a0
; RV64IA-TSO-NEXT:    and a5, a5, a4
; RV64IA-TSO-NEXT:    xor a5, a2, a5
; RV64IA-TSO-NEXT:    sc.w.rl a5, a5, (a3)
; RV64IA-TSO-NEXT:    bnez a5, .LBB9_1
; RV64IA-TSO-NEXT:  .LBB9_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i8_seq_cst_seq_cst:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.b a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i8 %cmp, i8 %val seq_cst seq_cst
  ret void
}

define void @cmpxchg_i16_monotonic_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a5, a4, a0
; RV32IA-NEXT:    and a1, a1, a4
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    and a2, a2, a4
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w a2, (a3)
; RV32IA-NEXT:    and a4, a2, a5
; RV32IA-NEXT:    bne a4, a1, .LBB10_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB10_1 Depth=1
; RV32IA-NEXT:    xor a4, a2, a0
; RV32IA-NEXT:    and a4, a4, a5
; RV32IA-NEXT:    xor a4, a2, a4
; RV32IA-NEXT:    sc.w a4, a4, (a3)
; RV32IA-NEXT:    bnez a4, .LBB10_1
; RV32IA-NEXT:  .LBB10_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB10_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB10_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB10_1
; RV64IA-WMO-NEXT:  .LBB10_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    lui a4, 16
; RV64IA-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-ZACAS-NEXT:    bne a4, a1, .LBB10_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB10_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-ZACAS-NEXT:    bnez a4, .LBB10_1
; RV64IA-ZACAS-NEXT:  .LBB10_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-ZABHA-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV64IA-ZABHA:       # %bb.0:
; RV64IA-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_monotonic_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB10_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB10_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB10_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB10_1
; RV64IA-TSO-NEXT:  .LBB10_3:
; RV64IA-TSO-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i16_acquire_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_acquire_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i16_acquire_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a5, a4, a0
; RV32IA-WMO-NEXT:    and a1, a1, a4
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    and a2, a2, a4
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a4, a2, a5
; RV32IA-WMO-NEXT:    bne a4, a1, .LBB11_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV32IA-WMO-NEXT:    xor a4, a2, a0
; RV32IA-WMO-NEXT:    and a4, a4, a5
; RV32IA-WMO-NEXT:    xor a4, a2, a4
; RV32IA-WMO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-WMO-NEXT:    bnez a4, .LBB11_1
; RV32IA-WMO-NEXT:  .LBB11_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i16_acquire_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV32IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-WMO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB11_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a4, .LBB11_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB11_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i16_acquire_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a5, a4, a0
; RV32IA-TSO-NEXT:    and a1, a1, a4
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    and a2, a2, a4
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a4, a2, a5
; RV32IA-TSO-NEXT:    bne a4, a1, .LBB11_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV32IA-TSO-NEXT:    xor a4, a2, a0
; RV32IA-TSO-NEXT:    and a4, a4, a5
; RV32IA-TSO-NEXT:    xor a4, a2, a4
; RV32IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-NEXT:    bnez a4, .LBB11_1
; RV32IA-TSO-NEXT:  .LBB11_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i16_acquire_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV32IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-TSO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB11_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a4, .LBB11_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB11_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB11_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB11_1
; RV64IA-WMO-NEXT:  .LBB11_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV64IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-WMO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB11_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a4, .LBB11_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB11_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB11_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB11_1
; RV64IA-TSO-NEXT:  .LBB11_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV64IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-TSO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB11_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB11_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB11_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a4, .LBB11_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB11_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_acquire_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val acquire monotonic
  ret void
}

define void @cmpxchg_i16_acquire_acquire(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_acquire_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i16_acquire_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a5, a4, a0
; RV32IA-WMO-NEXT:    and a1, a1, a4
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    and a2, a2, a4
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a4, a2, a5
; RV32IA-WMO-NEXT:    bne a4, a1, .LBB12_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV32IA-WMO-NEXT:    xor a4, a2, a0
; RV32IA-WMO-NEXT:    and a4, a4, a5
; RV32IA-WMO-NEXT:    xor a4, a2, a4
; RV32IA-WMO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-WMO-NEXT:    bnez a4, .LBB12_1
; RV32IA-WMO-NEXT:  .LBB12_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i16_acquire_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV32IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-WMO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB12_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a4, .LBB12_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB12_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i16_acquire_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a5, a4, a0
; RV32IA-TSO-NEXT:    and a1, a1, a4
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    and a2, a2, a4
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a4, a2, a5
; RV32IA-TSO-NEXT:    bne a4, a1, .LBB12_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV32IA-TSO-NEXT:    xor a4, a2, a0
; RV32IA-TSO-NEXT:    and a4, a4, a5
; RV32IA-TSO-NEXT:    xor a4, a2, a4
; RV32IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-NEXT:    bnez a4, .LBB12_1
; RV32IA-TSO-NEXT:  .LBB12_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i16_acquire_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV32IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-TSO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB12_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a4, .LBB12_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB12_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_acquire_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_acquire_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB12_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB12_1
; RV64IA-WMO-NEXT:  .LBB12_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i16_acquire_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV64IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-WMO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB12_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a4, .LBB12_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB12_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_acquire_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_acquire_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB12_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB12_1
; RV64IA-TSO-NEXT:  .LBB12_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i16_acquire_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV64IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-TSO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB12_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB12_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB12_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a4, .LBB12_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB12_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_acquire_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val acquire acquire
  ret void
}

define void @cmpxchg_i16_release_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_release_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i16_release_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a5, a4, a0
; RV32IA-WMO-NEXT:    and a1, a1, a4
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    and a2, a2, a4
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a2, (a3)
; RV32IA-WMO-NEXT:    and a4, a2, a5
; RV32IA-WMO-NEXT:    bne a4, a1, .LBB13_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV32IA-WMO-NEXT:    xor a4, a2, a0
; RV32IA-WMO-NEXT:    and a4, a4, a5
; RV32IA-WMO-NEXT:    xor a4, a2, a4
; RV32IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-NEXT:    bnez a4, .LBB13_1
; RV32IA-WMO-NEXT:  .LBB13_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i16_release_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV32IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-WMO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB13_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a4, .LBB13_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB13_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i16_release_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a5, a4, a0
; RV32IA-TSO-NEXT:    and a1, a1, a4
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    and a2, a2, a4
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a4, a2, a5
; RV32IA-TSO-NEXT:    bne a4, a1, .LBB13_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV32IA-TSO-NEXT:    xor a4, a2, a0
; RV32IA-TSO-NEXT:    and a4, a4, a5
; RV32IA-TSO-NEXT:    xor a4, a2, a4
; RV32IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-NEXT:    bnez a4, .LBB13_1
; RV32IA-TSO-NEXT:  .LBB13_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i16_release_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV32IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-TSO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB13_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a4, .LBB13_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB13_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_release_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_release_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB13_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB13_1
; RV64IA-WMO-NEXT:  .LBB13_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i16_release_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV64IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-WMO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB13_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a4, .LBB13_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB13_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_release_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.rl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_release_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB13_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB13_1
; RV64IA-TSO-NEXT:  .LBB13_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i16_release_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV64IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-TSO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB13_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB13_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB13_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a4, .LBB13_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB13_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_release_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val release monotonic
  ret void
}

define void @cmpxchg_i16_release_acquire(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_release_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i16_release_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a5, a4, a0
; RV32IA-WMO-NEXT:    and a1, a1, a4
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    and a2, a2, a4
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a4, a2, a5
; RV32IA-WMO-NEXT:    bne a4, a1, .LBB14_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV32IA-WMO-NEXT:    xor a4, a2, a0
; RV32IA-WMO-NEXT:    and a4, a4, a5
; RV32IA-WMO-NEXT:    xor a4, a2, a4
; RV32IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-NEXT:    bnez a4, .LBB14_1
; RV32IA-WMO-NEXT:  .LBB14_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i16_release_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV32IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-WMO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB14_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a4, .LBB14_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB14_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i16_release_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a5, a4, a0
; RV32IA-TSO-NEXT:    and a1, a1, a4
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    and a2, a2, a4
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a4, a2, a5
; RV32IA-TSO-NEXT:    bne a4, a1, .LBB14_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV32IA-TSO-NEXT:    xor a4, a2, a0
; RV32IA-TSO-NEXT:    and a4, a4, a5
; RV32IA-TSO-NEXT:    xor a4, a2, a4
; RV32IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-NEXT:    bnez a4, .LBB14_1
; RV32IA-TSO-NEXT:  .LBB14_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i16_release_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV32IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-TSO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB14_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a4, .LBB14_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB14_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_release_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_release_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB14_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB14_1
; RV64IA-WMO-NEXT:  .LBB14_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i16_release_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV64IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-WMO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB14_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a4, .LBB14_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB14_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_release_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_release_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB14_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB14_1
; RV64IA-TSO-NEXT:  .LBB14_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i16_release_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV64IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-TSO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB14_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB14_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB14_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a4, .LBB14_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB14_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_release_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val release acquire
  ret void
}

define void @cmpxchg_i16_acq_rel_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a5, a4, a0
; RV32IA-WMO-NEXT:    and a1, a1, a4
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    and a2, a2, a4
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a4, a2, a5
; RV32IA-WMO-NEXT:    bne a4, a1, .LBB15_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV32IA-WMO-NEXT:    xor a4, a2, a0
; RV32IA-WMO-NEXT:    and a4, a4, a5
; RV32IA-WMO-NEXT:    xor a4, a2, a4
; RV32IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-NEXT:    bnez a4, .LBB15_1
; RV32IA-WMO-NEXT:  .LBB15_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV32IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-WMO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB15_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a4, .LBB15_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB15_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a5, a4, a0
; RV32IA-TSO-NEXT:    and a1, a1, a4
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    and a2, a2, a4
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a4, a2, a5
; RV32IA-TSO-NEXT:    bne a4, a1, .LBB15_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV32IA-TSO-NEXT:    xor a4, a2, a0
; RV32IA-TSO-NEXT:    and a4, a4, a5
; RV32IA-TSO-NEXT:    xor a4, a2, a4
; RV32IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-NEXT:    bnez a4, .LBB15_1
; RV32IA-TSO-NEXT:  .LBB15_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV32IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-TSO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB15_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a4, .LBB15_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB15_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB15_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB15_1
; RV64IA-WMO-NEXT:  .LBB15_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV64IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-WMO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB15_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a4, .LBB15_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB15_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB15_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB15_1
; RV64IA-TSO-NEXT:  .LBB15_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV64IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-TSO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB15_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB15_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB15_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a4, .LBB15_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB15_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_acq_rel_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val acq_rel monotonic
  ret void
}

define void @cmpxchg_i16_acq_rel_acquire(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:    andi a3, a0, -4
; RV32IA-WMO-NEXT:    slli a0, a0, 3
; RV32IA-WMO-NEXT:    lui a4, 16
; RV32IA-WMO-NEXT:    addi a4, a4, -1
; RV32IA-WMO-NEXT:    sll a5, a4, a0
; RV32IA-WMO-NEXT:    and a1, a1, a4
; RV32IA-WMO-NEXT:    sll a1, a1, a0
; RV32IA-WMO-NEXT:    and a2, a2, a4
; RV32IA-WMO-NEXT:    sll a0, a2, a0
; RV32IA-WMO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-NEXT:    and a4, a2, a5
; RV32IA-WMO-NEXT:    bne a4, a1, .LBB16_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV32IA-WMO-NEXT:    xor a4, a2, a0
; RV32IA-WMO-NEXT:    and a4, a4, a5
; RV32IA-WMO-NEXT:    xor a4, a2, a4
; RV32IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-NEXT:    bnez a4, .LBB16_1
; RV32IA-WMO-NEXT:  .LBB16_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV32IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-WMO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-WMO-ZACAS-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV32IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB16_3
; RV32IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-WMO-ZACAS-NEXT:    bnez a4, .LBB16_1
; RV32IA-WMO-ZACAS-NEXT:  .LBB16_3:
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:    andi a3, a0, -4
; RV32IA-TSO-NEXT:    slli a0, a0, 3
; RV32IA-TSO-NEXT:    lui a4, 16
; RV32IA-TSO-NEXT:    addi a4, a4, -1
; RV32IA-TSO-NEXT:    sll a5, a4, a0
; RV32IA-TSO-NEXT:    and a1, a1, a4
; RV32IA-TSO-NEXT:    sll a1, a1, a0
; RV32IA-TSO-NEXT:    and a2, a2, a4
; RV32IA-TSO-NEXT:    sll a0, a2, a0
; RV32IA-TSO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-NEXT:    and a4, a2, a5
; RV32IA-TSO-NEXT:    bne a4, a1, .LBB16_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV32IA-TSO-NEXT:    xor a4, a2, a0
; RV32IA-TSO-NEXT:    and a4, a4, a5
; RV32IA-TSO-NEXT:    xor a4, a2, a4
; RV32IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-NEXT:    bnez a4, .LBB16_1
; RV32IA-TSO-NEXT:  .LBB16_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV32IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV32IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV32IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV32IA-TSO-ZACAS-NEXT:    sll a5, a4, a0
; RV32IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a1, a1, a0
; RV32IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sll a0, a2, a0
; RV32IA-TSO-ZACAS-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV32IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV32IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB16_3
; RV32IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV32IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV32IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV32IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV32IA-TSO-ZACAS-NEXT:    bnez a4, .LBB16_1
; RV32IA-TSO-ZACAS-NEXT:  .LBB16_3:
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB16_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB16_1
; RV64IA-WMO-NEXT:  .LBB16_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-WMO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-WMO-ZACAS-NEXT:    lui a4, 16
; RV64IA-WMO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-WMO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-ZACAS-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-ZACAS-NEXT:    lr.w.aq a2, (a3)
; RV64IA-WMO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-WMO-ZACAS-NEXT:    bne a4, a1, .LBB16_3
; RV64IA-WMO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-WMO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-WMO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-WMO-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-ZACAS-NEXT:    bnez a4, .LBB16_1
; RV64IA-WMO-ZACAS-NEXT:  .LBB16_3:
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB16_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB16_1
; RV64IA-TSO-NEXT:  .LBB16_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-TSO-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-TSO-ZACAS-NEXT:    lui a4, 16
; RV64IA-TSO-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-TSO-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-ZACAS-NEXT:  .LBB16_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-ZACAS-NEXT:    lr.w a2, (a3)
; RV64IA-TSO-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-TSO-ZACAS-NEXT:    bne a4, a1, .LBB16_3
; RV64IA-TSO-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB16_1 Depth=1
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-TSO-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-TSO-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-TSO-ZACAS-NEXT:    sc.w a4, a4, (a3)
; RV64IA-TSO-ZACAS-NEXT:    bnez a4, .LBB16_1
; RV64IA-TSO-ZACAS-NEXT:  .LBB16_3:
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_acq_rel_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val acq_rel acquire
  ret void
}

define void @cmpxchg_i16_seq_cst_monotonic(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a5, a4, a0
; RV32IA-NEXT:    and a1, a1, a4
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    and a2, a2, a4
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a3)
; RV32IA-NEXT:    and a4, a2, a5
; RV32IA-NEXT:    bne a4, a1, .LBB17_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB17_1 Depth=1
; RV32IA-NEXT:    xor a4, a2, a0
; RV32IA-NEXT:    and a4, a4, a5
; RV32IA-NEXT:    xor a4, a2, a4
; RV32IA-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-NEXT:    bnez a4, .LBB17_1
; RV32IA-NEXT:  .LBB17_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB17_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB17_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB17_1
; RV64IA-WMO-NEXT:  .LBB17_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    lui a4, 16
; RV64IA-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-ZACAS-NEXT:    bne a4, a1, .LBB17_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB17_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-ZACAS-NEXT:    bnez a4, .LBB17_1
; RV64IA-ZACAS-NEXT:  .LBB17_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB17_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB17_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB17_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB17_1
; RV64IA-TSO-NEXT:  .LBB17_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_seq_cst_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val seq_cst monotonic
  ret void
}

define void @cmpxchg_i16_seq_cst_acquire(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a5, a4, a0
; RV32IA-NEXT:    and a1, a1, a4
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    and a2, a2, a4
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a3)
; RV32IA-NEXT:    and a4, a2, a5
; RV32IA-NEXT:    bne a4, a1, .LBB18_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB18_1 Depth=1
; RV32IA-NEXT:    xor a4, a2, a0
; RV32IA-NEXT:    and a4, a4, a5
; RV32IA-NEXT:    xor a4, a2, a4
; RV32IA-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-NEXT:    bnez a4, .LBB18_1
; RV32IA-NEXT:  .LBB18_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB18_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB18_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB18_1
; RV64IA-WMO-NEXT:  .LBB18_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    lui a4, 16
; RV64IA-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-ZACAS-NEXT:    bne a4, a1, .LBB18_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB18_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-ZACAS-NEXT:    bnez a4, .LBB18_1
; RV64IA-ZACAS-NEXT:  .LBB18_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB18_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB18_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB18_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB18_1
; RV64IA-TSO-NEXT:  .LBB18_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_seq_cst_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val seq_cst acquire
  ret void
}

define void @cmpxchg_i16_seq_cst_seq_cst(ptr %ptr, i16 %cmp, i16 %val) nounwind {
; RV32I-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sh a1, 10(sp)
; RV32I-NEXT:    addi a1, sp, 10
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    call __atomic_compare_exchange_2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    andi a3, a0, -4
; RV32IA-NEXT:    slli a0, a0, 3
; RV32IA-NEXT:    lui a4, 16
; RV32IA-NEXT:    addi a4, a4, -1
; RV32IA-NEXT:    sll a5, a4, a0
; RV32IA-NEXT:    and a1, a1, a4
; RV32IA-NEXT:    sll a1, a1, a0
; RV32IA-NEXT:    and a2, a2, a4
; RV32IA-NEXT:    sll a0, a2, a0
; RV32IA-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; RV32IA-NEXT:    lr.w.aqrl a2, (a3)
; RV32IA-NEXT:    and a4, a2, a5
; RV32IA-NEXT:    bne a4, a1, .LBB19_3
; RV32IA-NEXT:  # %bb.2: # in Loop: Header=BB19_1 Depth=1
; RV32IA-NEXT:    xor a4, a2, a0
; RV32IA-NEXT:    and a4, a4, a5
; RV32IA-NEXT:    xor a4, a2, a4
; RV32IA-NEXT:    sc.w.rl a4, a4, (a3)
; RV32IA-NEXT:    bnez a4, .LBB19_1
; RV32IA-NEXT:  .LBB19_3:
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sh a1, 6(sp)
; RV64I-NEXT:    addi a1, sp, 6
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    call __atomic_compare_exchange_2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    andi a3, a0, -4
; RV64IA-WMO-NEXT:    slli a0, a0, 3
; RV64IA-WMO-NEXT:    lui a4, 16
; RV64IA-WMO-NEXT:    addi a4, a4, -1
; RV64IA-WMO-NEXT:    sllw a5, a4, a0
; RV64IA-WMO-NEXT:    and a1, a1, a4
; RV64IA-WMO-NEXT:    sllw a1, a1, a0
; RV64IA-WMO-NEXT:    and a2, a2, a4
; RV64IA-WMO-NEXT:    sllw a0, a2, a0
; RV64IA-WMO-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-WMO-NEXT:    and a4, a2, a5
; RV64IA-WMO-NEXT:    bne a4, a1, .LBB19_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB19_1 Depth=1
; RV64IA-WMO-NEXT:    xor a4, a2, a0
; RV64IA-WMO-NEXT:    and a4, a4, a5
; RV64IA-WMO-NEXT:    xor a4, a2, a4
; RV64IA-WMO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-WMO-NEXT:    bnez a4, .LBB19_1
; RV64IA-WMO-NEXT:  .LBB19_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    andi a3, a0, -4
; RV64IA-ZACAS-NEXT:    slli a0, a0, 3
; RV64IA-ZACAS-NEXT:    lui a4, 16
; RV64IA-ZACAS-NEXT:    addi a4, a4, -1
; RV64IA-ZACAS-NEXT:    sllw a5, a4, a0
; RV64IA-ZACAS-NEXT:    and a1, a1, a4
; RV64IA-ZACAS-NEXT:    sllw a1, a1, a0
; RV64IA-ZACAS-NEXT:    and a2, a2, a4
; RV64IA-ZACAS-NEXT:    sllw a0, a2, a0
; RV64IA-ZACAS-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; RV64IA-ZACAS-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-ZACAS-NEXT:    and a4, a2, a5
; RV64IA-ZACAS-NEXT:    bne a4, a1, .LBB19_3
; RV64IA-ZACAS-NEXT:  # %bb.2: # in Loop: Header=BB19_1 Depth=1
; RV64IA-ZACAS-NEXT:    xor a4, a2, a0
; RV64IA-ZACAS-NEXT:    and a4, a4, a5
; RV64IA-ZACAS-NEXT:    xor a4, a2, a4
; RV64IA-ZACAS-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-ZACAS-NEXT:    bnez a4, .LBB19_1
; RV64IA-ZACAS-NEXT:  .LBB19_3:
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.h.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    andi a3, a0, -4
; RV64IA-TSO-NEXT:    slli a0, a0, 3
; RV64IA-TSO-NEXT:    lui a4, 16
; RV64IA-TSO-NEXT:    addi a4, a4, -1
; RV64IA-TSO-NEXT:    sllw a5, a4, a0
; RV64IA-TSO-NEXT:    and a1, a1, a4
; RV64IA-TSO-NEXT:    sllw a1, a1, a0
; RV64IA-TSO-NEXT:    and a2, a2, a4
; RV64IA-TSO-NEXT:    sllw a0, a2, a0
; RV64IA-TSO-NEXT:  .LBB19_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a2, (a3)
; RV64IA-TSO-NEXT:    and a4, a2, a5
; RV64IA-TSO-NEXT:    bne a4, a1, .LBB19_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB19_1 Depth=1
; RV64IA-TSO-NEXT:    xor a4, a2, a0
; RV64IA-TSO-NEXT:    and a4, a4, a5
; RV64IA-TSO-NEXT:    xor a4, a2, a4
; RV64IA-TSO-NEXT:    sc.w.rl a4, a4, (a3)
; RV64IA-TSO-NEXT:    bnez a4, .LBB19_1
; RV64IA-TSO-NEXT:  .LBB19_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i16_seq_cst_seq_cst:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.h a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i16 %cmp, i16 %val seq_cst seq_cst
  ret void
}

define void @cmpxchg_i32_monotonic_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB20_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB20_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB20_1
; RV32IA-WMO-NEXT:  .LBB20_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-ZACAS-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV32IA-ZACAS:       # %bb.0:
; RV32IA-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB20_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB20_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB20_1
; RV32IA-TSO-NEXT:  .LBB20_3:
; RV32IA-TSO-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB20_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB20_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB20_1
; RV64IA-WMO-NEXT:  .LBB20_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-ZABHA-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV64IA-ZABHA:       # %bb.0:
; RV64IA-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_monotonic_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB20_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB20_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB20_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB20_1
; RV64IA-TSO-NEXT:  .LBB20_3:
; RV64IA-TSO-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i32_acquire_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_acquire_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_acquire_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB21_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB21_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB21_1
; RV32IA-WMO-NEXT:  .LBB21_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_acquire_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aq a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_acquire_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB21_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB21_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB21_1
; RV32IA-TSO-NEXT:  .LBB21_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_acquire_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB21_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB21_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB21_1
; RV64IA-WMO-NEXT:  .LBB21_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aq a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB21_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB21_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB21_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB21_1
; RV64IA-TSO-NEXT:  .LBB21_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_acquire_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val acquire monotonic
  ret void
}

define void @cmpxchg_i32_acquire_acquire(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_acquire_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 2
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_acquire_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB22_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB22_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB22_1
; RV32IA-WMO-NEXT:  .LBB22_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_acquire_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aq a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_acquire_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB22_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB22_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB22_1
; RV32IA-TSO-NEXT:  .LBB22_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_acquire_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_acquire_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_acquire_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB22_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB22_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB22_1
; RV64IA-WMO-NEXT:  .LBB22_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_acquire_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aq a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_acquire_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_acquire_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB22_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB22_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB22_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB22_1
; RV64IA-TSO-NEXT:  .LBB22_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_acquire_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_acquire_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val acquire acquire
  ret void
}

define void @cmpxchg_i32_release_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_release_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_release_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB23_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB23_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB23_1
; RV32IA-WMO-NEXT:  .LBB23_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_release_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.rl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_release_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB23_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB23_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB23_1
; RV32IA-TSO-NEXT:  .LBB23_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_release_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_release_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_release_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB23_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB23_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB23_1
; RV64IA-WMO-NEXT:  .LBB23_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_release_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.rl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_release_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.rl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_release_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB23_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB23_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB23_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB23_1
; RV64IA-TSO-NEXT:  .LBB23_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_release_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_release_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val release monotonic
  ret void
}

define void @cmpxchg_i32_release_acquire(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_release_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 3
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_release_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB24_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB24_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB24_1
; RV32IA-WMO-NEXT:  .LBB24_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_release_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_release_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB24_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB24_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB24_1
; RV32IA-TSO-NEXT:  .LBB24_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_release_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_release_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_release_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB24_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB24_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB24_1
; RV64IA-WMO-NEXT:  .LBB24_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_release_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_release_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_release_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB24_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB24_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB24_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB24_1
; RV64IA-TSO-NEXT:  .LBB24_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_release_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_release_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val release acquire
  ret void
}

define void @cmpxchg_i32_acq_rel_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB25_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB25_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB25_1
; RV32IA-WMO-NEXT:  .LBB25_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB25_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB25_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB25_1
; RV32IA-TSO-NEXT:  .LBB25_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB25_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB25_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB25_1
; RV64IA-WMO-NEXT:  .LBB25_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB25_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB25_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB25_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB25_1
; RV64IA-TSO-NEXT:  .LBB25_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_acq_rel_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val acq_rel monotonic
  ret void
}

define void @cmpxchg_i32_acq_rel_acquire(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 4
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB26_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB26_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB26_1
; RV32IA-WMO-NEXT:  .LBB26_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB26_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB26_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB26_1
; RV32IA-TSO-NEXT:  .LBB26_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB26_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB26_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB26_1
; RV64IA-WMO-NEXT:  .LBB26_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB26_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB26_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB26_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB26_1
; RV64IA-TSO-NEXT:  .LBB26_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_acq_rel_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val acq_rel acquire
  ret void
}

define void @cmpxchg_i32_seq_cst_monotonic(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB27_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aqrl a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB27_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB27_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB27_1
; RV32IA-WMO-NEXT:  .LBB27_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB27_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w.aqrl a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB27_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB27_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB27_1
; RV32IA-TSO-NEXT:  .LBB27_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB27_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB27_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB27_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB27_1
; RV64IA-WMO-NEXT:  .LBB27_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB27_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB27_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB27_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB27_1
; RV64IA-TSO-NEXT:  .LBB27_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_seq_cst_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val seq_cst monotonic
  ret void
}

define void @cmpxchg_i32_seq_cst_acquire(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB28_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aqrl a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB28_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB28_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB28_1
; RV32IA-WMO-NEXT:  .LBB28_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB28_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w.aqrl a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB28_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB28_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB28_1
; RV32IA-TSO-NEXT:  .LBB28_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB28_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB28_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB28_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB28_1
; RV64IA-WMO-NEXT:  .LBB28_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB28_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB28_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB28_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB28_1
; RV64IA-TSO-NEXT:  .LBB28_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_seq_cst_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val seq_cst acquire
  ret void
}

define void @cmpxchg_i32_seq_cst_seq_cst(ptr %ptr, i32 %cmp, i32 %val) nounwind {
; RV32I-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a1, 8(sp)
; RV32I-NEXT:    addi a1, sp, 8
; RV32I-NEXT:    li a3, 5
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    call __atomic_compare_exchange_4
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-WMO-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV32IA-WMO:       # %bb.0:
; RV32IA-WMO-NEXT:  .LBB29_1: # =>This Inner Loop Header: Depth=1
; RV32IA-WMO-NEXT:    lr.w.aqrl a3, (a0)
; RV32IA-WMO-NEXT:    bne a3, a1, .LBB29_3
; RV32IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB29_1 Depth=1
; RV32IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-WMO-NEXT:    bnez a4, .LBB29_1
; RV32IA-WMO-NEXT:  .LBB29_3:
; RV32IA-WMO-NEXT:    ret
;
; RV32IA-WMO-ZACAS-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV32IA-WMO-ZACAS:       # %bb.0:
; RV32IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV32IA-WMO-ZACAS-NEXT:    ret
;
; RV32IA-TSO-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV32IA-TSO:       # %bb.0:
; RV32IA-TSO-NEXT:  .LBB29_1: # =>This Inner Loop Header: Depth=1
; RV32IA-TSO-NEXT:    lr.w.aqrl a3, (a0)
; RV32IA-TSO-NEXT:    bne a3, a1, .LBB29_3
; RV32IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB29_1 Depth=1
; RV32IA-TSO-NEXT:    sc.w.rl a4, a2, (a0)
; RV32IA-TSO-NEXT:    bnez a4, .LBB29_1
; RV32IA-TSO-NEXT:  .LBB29_3:
; RV32IA-TSO-NEXT:    ret
;
; RV32IA-TSO-ZACAS-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV32IA-TSO-ZACAS:       # %bb.0:
; RV32IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV32IA-TSO-ZACAS-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sw a1, 4(sp)
; RV64I-NEXT:    addi a1, sp, 4
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    call __atomic_compare_exchange_4
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:    sext.w a1, a1
; RV64IA-WMO-NEXT:  .LBB29_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.w.aqrl a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB29_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB29_1 Depth=1
; RV64IA-WMO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB29_1
; RV64IA-WMO-NEXT:  .LBB29_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.w.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:    sext.w a1, a1
; RV64IA-TSO-NEXT:  .LBB29_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.w.aqrl a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB29_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB29_1 Depth=1
; RV64IA-TSO-NEXT:    sc.w.rl a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB29_1
; RV64IA-TSO-NEXT:  .LBB29_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i32_seq_cst_seq_cst:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.w a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i32 %cmp, i32 %val seq_cst seq_cst
  ret void
}

define void @cmpxchg_i64_monotonic_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a4
; RV32I-NEXT:    li a4, 0
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a4
; RV32IA-NEXT:    li a4, 0
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 0
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB30_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB30_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB30_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB30_1
; RV64IA-WMO-NEXT:  .LBB30_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-ZACAS-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV64IA-ZACAS:       # %bb.0:
; RV64IA-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-ZACAS-NEXT:    ret
;
; RV64IA-ZABHA-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV64IA-ZABHA:       # %bb.0:
; RV64IA-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_monotonic_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB30_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB30_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB30_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB30_1
; RV64IA-TSO-NEXT:  .LBB30_3:
; RV64IA-TSO-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val monotonic monotonic
  ret void
}

define void @cmpxchg_i64_acquire_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_acquire_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a5, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_acquire_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 2
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB31_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB31_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB31_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB31_1
; RV64IA-WMO-NEXT:  .LBB31_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aq a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB31_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB31_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB31_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB31_1
; RV64IA-TSO-NEXT:  .LBB31_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_acquire_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val acquire monotonic
  ret void
}

define void @cmpxchg_i64_acquire_acquire(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_acquire_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a6, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 2
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_acquire_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a6, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 2
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a6
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_acquire_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 2
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_acquire_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB32_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB32_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB32_1
; RV64IA-WMO-NEXT:  .LBB32_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_acquire_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aq a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_acquire_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aq a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_acquire_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB32_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB32_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB32_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB32_1
; RV64IA-TSO-NEXT:  .LBB32_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_acquire_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_acquire_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val acquire acquire
  ret void
}

define void @cmpxchg_i64_release_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_release_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a5, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 3
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_release_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 3
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_release_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_release_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB33_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB33_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB33_1
; RV64IA-WMO-NEXT:  .LBB33_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_release_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.rl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_release_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.rl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_release_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB33_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB33_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB33_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB33_1
; RV64IA-TSO-NEXT:  .LBB33_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_release_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_release_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val release monotonic
  ret void
}

define void @cmpxchg_i64_release_acquire(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_release_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a6, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 3
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_release_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a6, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 3
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a6
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_release_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 3
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_release_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB34_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB34_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB34_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB34_1
; RV64IA-WMO-NEXT:  .LBB34_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_release_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_release_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_release_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB34_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB34_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB34_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB34_1
; RV64IA-TSO-NEXT:  .LBB34_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_release_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_release_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val release acquire
  ret void
}

define void @cmpxchg_i64_acq_rel_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a5, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 4
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 4
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB35_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB35_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB35_1
; RV64IA-WMO-NEXT:  .LBB35_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB35_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB35_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB35_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB35_1
; RV64IA-TSO-NEXT:  .LBB35_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_acq_rel_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val acq_rel monotonic
  ret void
}

define void @cmpxchg_i64_acq_rel_acquire(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a6, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 4
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a6, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 4
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a6
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 4
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB36_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aq a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB36_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB36_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB36_1
; RV64IA-WMO-NEXT:  .LBB36_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB36_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB36_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB36_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB36_1
; RV64IA-TSO-NEXT:  .LBB36_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_acq_rel_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val acq_rel acquire
  ret void
}

define void @cmpxchg_i64_seq_cst_monotonic(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a5, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a5
; RV32I-NEXT:    li a5, 0
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a5, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a5
; RV32IA-NEXT:    li a5, 0
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 0
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB37_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aqrl a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB37_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB37_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB37_1
; RV64IA-WMO-NEXT:  .LBB37_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB37_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d.aqrl a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB37_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB37_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB37_1
; RV64IA-TSO-NEXT:  .LBB37_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_seq_cst_monotonic:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val seq_cst monotonic
  ret void
}

define void @cmpxchg_i64_seq_cst_acquire(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a6, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    li a5, 2
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a6, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    li a5, 2
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a6
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 2
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB38_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aqrl a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB38_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB38_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB38_1
; RV64IA-WMO-NEXT:  .LBB38_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB38_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d.aqrl a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB38_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB38_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB38_1
; RV64IA-TSO-NEXT:  .LBB38_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_seq_cst_acquire:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val seq_cst acquire
  ret void
}

define void @cmpxchg_i64_seq_cst_seq_cst(ptr %ptr, i64 %cmp, i64 %val) nounwind {
; RV32I-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv a6, a4
; RV32I-NEXT:    sw a2, 4(sp)
; RV32I-NEXT:    sw a1, 0(sp)
; RV32I-NEXT:    mv a1, sp
; RV32I-NEXT:    li a4, 5
; RV32I-NEXT:    li a5, 5
; RV32I-NEXT:    mv a2, a3
; RV32I-NEXT:    mv a3, a6
; RV32I-NEXT:    call __atomic_compare_exchange_8
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32IA-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV32IA:       # %bb.0:
; RV32IA-NEXT:    addi sp, sp, -16
; RV32IA-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IA-NEXT:    mv a6, a4
; RV32IA-NEXT:    sw a2, 4(sp)
; RV32IA-NEXT:    sw a1, 0(sp)
; RV32IA-NEXT:    mv a1, sp
; RV32IA-NEXT:    li a4, 5
; RV32IA-NEXT:    li a5, 5
; RV32IA-NEXT:    mv a2, a3
; RV32IA-NEXT:    mv a3, a6
; RV32IA-NEXT:    call __atomic_compare_exchange_8
; RV32IA-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IA-NEXT:    addi sp, sp, 16
; RV32IA-NEXT:    ret
;
; RV64I-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd a1, 0(sp)
; RV64I-NEXT:    mv a1, sp
; RV64I-NEXT:    li a3, 5
; RV64I-NEXT:    li a4, 5
; RV64I-NEXT:    call __atomic_compare_exchange_8
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64IA-WMO-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64IA-WMO:       # %bb.0:
; RV64IA-WMO-NEXT:  .LBB39_1: # =>This Inner Loop Header: Depth=1
; RV64IA-WMO-NEXT:    lr.d.aqrl a3, (a0)
; RV64IA-WMO-NEXT:    bne a3, a1, .LBB39_3
; RV64IA-WMO-NEXT:  # %bb.2: # in Loop: Header=BB39_1 Depth=1
; RV64IA-WMO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-WMO-NEXT:    bnez a4, .LBB39_1
; RV64IA-WMO-NEXT:  .LBB39_3:
; RV64IA-WMO-NEXT:    ret
;
; RV64IA-WMO-ZACAS-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64IA-WMO-ZACAS:       # %bb.0:
; RV64IA-WMO-ZACAS-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZACAS-NEXT:    ret
;
; RV64IA-WMO-ZABHA-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64IA-WMO-ZABHA:       # %bb.0:
; RV64IA-WMO-ZABHA-NEXT:    amocas.d.aqrl a1, a2, (a0)
; RV64IA-WMO-ZABHA-NEXT:    ret
;
; RV64IA-TSO-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64IA-TSO:       # %bb.0:
; RV64IA-TSO-NEXT:  .LBB39_1: # =>This Inner Loop Header: Depth=1
; RV64IA-TSO-NEXT:    lr.d.aqrl a3, (a0)
; RV64IA-TSO-NEXT:    bne a3, a1, .LBB39_3
; RV64IA-TSO-NEXT:  # %bb.2: # in Loop: Header=BB39_1 Depth=1
; RV64IA-TSO-NEXT:    sc.d.rl a4, a2, (a0)
; RV64IA-TSO-NEXT:    bnez a4, .LBB39_1
; RV64IA-TSO-NEXT:  .LBB39_3:
; RV64IA-TSO-NEXT:    ret
;
; RV64IA-TSO-ZACAS-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64IA-TSO-ZACAS:       # %bb.0:
; RV64IA-TSO-ZACAS-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZACAS-NEXT:    ret
;
; RV64IA-TSO-ZABHA-LABEL: cmpxchg_i64_seq_cst_seq_cst:
; RV64IA-TSO-ZABHA:       # %bb.0:
; RV64IA-TSO-ZABHA-NEXT:    amocas.d a1, a2, (a0)
; RV64IA-TSO-ZABHA-NEXT:    ret
  %res = cmpxchg ptr %ptr, i64 %cmp, i64 %val seq_cst seq_cst
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV64IA: {{.*}}
