# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=neoverse-v1 --timeline --timeline-max-iterations=4 < %s | FileCheck %s

# LLVM-MCA-BEGIN GPR32-bit
ldr w0, [sp]
add x0, x0, x0
# LLVM-MCA-END

# LLVM-MCA-BEGIN FPR8-bit
ldr b0, [sp]
fadd d0, d0, d0
# LLVM-MCA-END

# LLVM-MCA-BEGIN FPR16-bit
ldr h0, [sp]
fadd d0, d0, d0
# LLVM-MCA-END

# LLVM-MCA-BEGIN FPR32-bit
ldr s0, [sp]
fadd d0, d0, d0
# LLVM-MCA-END

# LLVM-MCA-BEGIN SIMD64-bit-b
ld1 {v0.8b}, [sp]
add v0.16b, v0.16b, v0.16b
# LLVM-MCA-END

# LLVM-MCA-BEGIN SIMD64-bit-h
ld1 {v0.4h}, [sp]
add v0.8h, v0.8h, v0.8h
# LLVM-MCA-END

# LLVM-MCA-BEGIN SIMD64-bit-s
ld1 {v0.2s}, [sp]
add v0.4s, v0.4s, v0.4s
# LLVM-MCA-END

# LLVM-MCA-BEGIN SIMD64-bit-d
ld1 {v0.1d}, [sp]
add v0.2d, v0.2d, v0.2d
# LLVM-MCA-END

# LLVM-MCA-BEGIN ins
ins v0.b[0], v1.b[1]
add v0.16b, v0.16b, v0.16b
# LLVM-MCA-END

# LLVM-MCA-BEGIN lanewise-load
ld1 {v0.b}[0], [sp]
add v0.16b, v0.16b, v0.16b
# LLVM-MCA-END

# CHECK:      [0] Code Region - GPR32-bit

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      41
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.88
# CHECK-NEXT: IPC:               4.88
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     0.33    *                   ldr	w0, [sp]
# CHECK-NEXT:  1      1     0.25                        add	x0, x0, x0

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34   0.22   0.22   0.28   0.28    -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ldr	w0, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -     0.22   0.22   0.28   0.28    -      -      -      -     add	x0, x0, x0

# CHECK:      Timeline view:
# CHECK-NEXT: Index     012345678

# CHECK:      [0,0]     DeeeeER .   ldr	w0, [sp]
# CHECK-NEXT: [0,1]     D====eER.   add	x0, x0, x0
# CHECK-NEXT: [1,0]     DeeeeE-R.   ldr	w0, [sp]
# CHECK-NEXT: [1,1]     D====eER.   add	x0, x0, x0
# CHECK-NEXT: [2,0]     DeeeeE-R.   ldr	w0, [sp]
# CHECK-NEXT: [2,1]     D====eER.   add	x0, x0, x0
# CHECK-NEXT: [3,0]     D=eeeeER.   ldr	w0, [sp]
# CHECK-NEXT: [3,1]     D=====eER   add	x0, x0, x0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    0.5       ldr	w0, [sp]
# CHECK-NEXT: 1.     4     5.3    0.0    0.0       add	x0, x0, x0
# CHECK-NEXT:        4     3.3    0.6    0.3       <total>

# CHECK:      [1] Code Region - FPR8-bit

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ldr	b0, [sp]
# CHECK-NEXT:  1      2     0.25                        fadd	d0, d0, d0

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ldr	b0, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fadd	d0, d0, d0

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ldr	b0, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ldr	b0, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ldr	b0, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ldr	b0, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   fadd	d0, d0, d0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ldr	b0, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       fadd	d0, d0, d0
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [2] Code Region - FPR16-bit

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ldr	h0, [sp]
# CHECK-NEXT:  1      2     0.25                        fadd	d0, d0, d0

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ldr	h0, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fadd	d0, d0, d0

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ldr	h0, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ldr	h0, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ldr	h0, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ldr	h0, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   fadd	d0, d0, d0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ldr	h0, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       fadd	d0, d0, d0
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [3] Code Region - FPR32-bit

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ldr	s0, [sp]
# CHECK-NEXT:  1      2     0.25                        fadd	d0, d0, d0

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ldr	s0, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fadd	d0, d0, d0

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ldr	s0, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ldr	s0, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ldr	s0, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   fadd	d0, d0, d0
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ldr	s0, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   fadd	d0, d0, d0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ldr	s0, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       fadd	d0, d0, d0
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [4] Code Region - SIMD64-bit-b

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ld1	{ v0.8b }, [sp]
# CHECK-NEXT:  1      2     0.25                        add	v0.16b, v0.16b, v0.16b

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ld1	{ v0.8b }, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   add	v0.16b, v0.16b, v0.16b

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ld1	{ v0.8b }, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ld1	{ v0.8b }, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ld1	{ v0.8b }, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ld1	{ v0.8b }, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   add	v0.16b, v0.16b, v0.16b

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ld1	{ v0.8b }, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [5] Code Region - SIMD64-bit-h

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ld1	{ v0.4h }, [sp]
# CHECK-NEXT:  1      2     0.25                        add	v0.8h, v0.8h, v0.8h

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ld1	{ v0.4h }, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   add	v0.8h, v0.8h, v0.8h

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ld1	{ v0.4h }, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   add	v0.8h, v0.8h, v0.8h
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ld1	{ v0.4h }, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   add	v0.8h, v0.8h, v0.8h
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ld1	{ v0.4h }, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   add	v0.8h, v0.8h, v0.8h
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ld1	{ v0.4h }, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   add	v0.8h, v0.8h, v0.8h

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ld1	{ v0.4h }, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       add	v0.8h, v0.8h, v0.8h
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [6] Code Region - SIMD64-bit-s

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ld1	{ v0.2s }, [sp]
# CHECK-NEXT:  1      2     0.25                        add	v0.4s, v0.4s, v0.4s

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ld1	{ v0.2s }, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   add	v0.4s, v0.4s, v0.4s

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ld1	{ v0.2s }, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   add	v0.4s, v0.4s, v0.4s
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ld1	{ v0.2s }, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   add	v0.4s, v0.4s, v0.4s
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ld1	{ v0.2s }, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   add	v0.4s, v0.4s, v0.4s
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ld1	{ v0.2s }, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   add	v0.4s, v0.4s, v0.4s

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ld1	{ v0.2s }, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       add	v0.4s, v0.4s, v0.4s
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [7] Code Region - SIMD64-bit-d

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      44
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    4.55
# CHECK-NEXT: IPC:               4.55
# CHECK-NEXT: Block RThroughput: 0.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      6     0.33    *                   ld1	{ v0.1d }, [sp]
# CHECK-NEXT:  1      2     0.25                        add	v0.2d, v0.2d, v0.2d

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -     0.25   0.25   0.25   0.25

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.34    -      -      -      -      -      -      -      -     ld1	{ v0.1d }, [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   add	v0.2d, v0.2d, v0.2d

# CHECK:      Timeline view:
# CHECK-NEXT:                     01
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeeeeeER ..   ld1	{ v0.1d }, [sp]
# CHECK-NEXT: [0,1]     D======eeER.   add	v0.2d, v0.2d, v0.2d
# CHECK-NEXT: [1,0]     DeeeeeeE--R.   ld1	{ v0.1d }, [sp]
# CHECK-NEXT: [1,1]     D======eeER.   add	v0.2d, v0.2d, v0.2d
# CHECK-NEXT: [2,0]     DeeeeeeE--R.   ld1	{ v0.1d }, [sp]
# CHECK-NEXT: [2,1]     D======eeER.   add	v0.2d, v0.2d, v0.2d
# CHECK-NEXT: [3,0]     D=eeeeeeE-R.   ld1	{ v0.1d }, [sp]
# CHECK-NEXT: [3,1]     D=======eeER   add	v0.2d, v0.2d, v0.2d

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     1.3    1.3    1.3       ld1	{ v0.1d }, [sp]
# CHECK-NEXT: 1.     4     7.3    0.0    0.0       add	v0.2d, v0.2d, v0.2d
# CHECK-NEXT:        4     4.3    0.6    0.6       <total>

# CHECK:      [8] Code Region - ins

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      403
# CHECK-NEXT: Total uOps:        200

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    0.50
# CHECK-NEXT: IPC:               0.50
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      2     0.25                        mov	v0.b[0], v1.b[1]
# CHECK-NEXT:  1      2     0.25                        add	v0.16b, v0.16b, v0.16b

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -     0.50    -     0.50   mov	v0.b[0], v1.b[1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.50    -     0.50    -     add	v0.16b, v0.16b, v0.16b

# CHECK:      Timeline view:
# CHECK-NEXT:                     012345678
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DeeER.    .    .  .   mov	v0.b[0], v1.b[1]
# CHECK-NEXT: [0,1]     D==eeER   .    .  .   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [1,0]     D====eeER .    .  .   mov	v0.b[0], v1.b[1]
# CHECK-NEXT: [1,1]     D======eeER    .  .   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [2,0]     D========eeER  .  .   mov	v0.b[0], v1.b[1]
# CHECK-NEXT: [2,1]     D==========eeER.  .   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [3,0]     D============eeER .   mov	v0.b[0], v1.b[1]
# CHECK-NEXT: [3,1]     D==============eeER   add	v0.16b, v0.16b, v0.16b

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     7.0    0.3    0.0       mov	v0.b[0], v1.b[1]
# CHECK-NEXT: 1.     4     9.0    0.0    0.0       add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT:        4     8.0    0.1    0.0       <total>

# CHECK:      [9] Code Region - lanewise-load

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      200
# CHECK-NEXT: Total Cycles:      1003
# CHECK-NEXT: Total uOps:        300

# CHECK:      Dispatch Width:    15
# CHECK-NEXT: uOps Per Cycle:    0.30
# CHECK-NEXT: IPC:               0.20
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  2      8     0.33    *                   ld1	{ v0.b }[0], [sp]
# CHECK-NEXT:  1      2     0.25                        add	v0.16b, v0.16b, v0.16b

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2]   - V1UnitL2
# CHECK-NEXT: [3.0] - V1UnitL01
# CHECK-NEXT: [3.1] - V1UnitL01
# CHECK-NEXT: [4]   - V1UnitM0
# CHECK-NEXT: [5]   - V1UnitM1
# CHECK-NEXT: [6.0] - V1UnitS
# CHECK-NEXT: [6.1] - V1UnitS
# CHECK-NEXT: [7]   - V1UnitV0
# CHECK-NEXT: [8]   - V1UnitV1
# CHECK-NEXT: [9]   - V1UnitV2
# CHECK-NEXT: [10]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]
# CHECK-NEXT:  -      -      -      -      -     0.50   0.50    -      -      -      -     0.50   0.50   0.50   0.50

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    [9]    [10]   Instructions:
# CHECK-NEXT:  -      -      -      -      -     0.50   0.50    -      -      -      -      -     0.50    -     0.50   ld1	{ v0.b }[0], [sp]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     0.50    -     0.50    -     add	v0.16b, v0.16b, v0.16b

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          012

# CHECK:      [0,0]     DeeeeeeeeER    .    .    .    .    .    . .   ld1	{ v0.b }[0], [sp]
# CHECK-NEXT: [0,1]     D========eeER  .    .    .    .    .    . .   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [1,0]     D==========eeeeeeeeER    .    .    .    . .   ld1	{ v0.b }[0], [sp]
# CHECK-NEXT: [1,1]     D==================eeER  .    .    .    . .   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [2,0]     D====================eeeeeeeeER    .    . .   ld1	{ v0.b }[0], [sp]
# CHECK-NEXT: [2,1]     D============================eeER  .    . .   add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT: [3,0]     D==============================eeeeeeeeER .   ld1	{ v0.b }[0], [sp]
# CHECK-NEXT: [3,1]     D======================================eeER   add	v0.16b, v0.16b, v0.16b

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     4     16.0   0.3    0.0       ld1	{ v0.b }[0], [sp]
# CHECK-NEXT: 1.     4     24.0   0.0    0.0       add	v0.16b, v0.16b, v0.16b
# CHECK-NEXT:        4     20.0   0.1    0.0       <total>
