; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i64 @test_select_agg_constant_agg(i64 %val, i1 %cond) {
; CHECK-LABEL: define i64 @test_select_agg_constant_agg(
; CHECK-SAME: i64 [[VAL:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RET:%.*]] = zext i1 [[COND]] to i64
; CHECK-NEXT:    ret i64 [[RET]]
;
entry:
  %sel = select i1 %cond, { i64, i64 } {i64 1, i64 2}, { i64, i64 } {i64 0, i64 3}
  %ret = extractvalue { i64, i64 } %sel, 0
  ret i64 %ret
}

define void @test_select_agg_constant_agg_multiuse(i64 %val, i1 %cond) {
; CHECK-LABEL: define void @test_select_agg_constant_agg_multiuse(
; CHECK-SAME: i64 [[VAL:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RET:%.*]] = zext i1 [[COND]] to i64
; CHECK-NEXT:    call void @use(i64 [[RET]])
; CHECK-NEXT:    [[V1:%.*]] = select i1 [[COND]], i64 2, i64 3
; CHECK-NEXT:    call void @use(i64 [[V1]])
; CHECK-NEXT:    ret void
;
entry:
  %sel = select i1 %cond, { i64, i64 } {i64 1, i64 2}, { i64, i64 } {i64 0, i64 3}
  %v0 = extractvalue { i64, i64 } %sel, 0
  call void @use(i64 %v0)
  %v1 = extractvalue { i64, i64 } %sel, 1
  call void @use(i64 %v1)
  ret void
}

; TODO: it can be folded to zext i1 %cond to i64
define i64 @test_select_agg_constant(i64 %val, i1 %cond) {
; CHECK-LABEL: define i64 @test_select_agg_constant(
; CHECK-SAME: i64 [[VAL:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = insertvalue { i64, i64 } { i64 1, i64 poison }, i64 [[VAL]], 1
; CHECK-NEXT:    [[B:%.*]] = insertvalue { i64, i64 } { i64 0, i64 poison }, i64 [[VAL]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], { i64, i64 } [[A]], { i64, i64 } [[B]]
; CHECK-NEXT:    [[RET:%.*]] = extractvalue { i64, i64 } [[SEL]], 0
; CHECK-NEXT:    ret i64 [[RET]]
;
entry:
  %a = insertvalue { i64, i64 } { i64 1, i64 poison }, i64 %val, 1
  %b = insertvalue { i64, i64 } { i64 0, i64 poison }, i64 %val, 1
  %sel = select i1 %cond, { i64, i64 } %a, { i64, i64 } %b
  %ret = extractvalue { i64, i64 } %sel, 0
  ret i64 %ret
}

define void @test_select_agg_multiuse(i1 %cond, i64 %v1, i64 %v2, i64 %v3, i64 %v4) {
; CHECK-LABEL: define void @test_select_agg_multiuse(
; CHECK-SAME: i1 [[COND:%.*]], i64 [[V1:%.*]], i64 [[V2:%.*]], i64 [[V3:%.*]], i64 [[V4:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A0:%.*]] = insertvalue { i64, i64 } poison, i64 [[V1]], 0
; CHECK-NEXT:    [[A1:%.*]] = insertvalue { i64, i64 } [[A0]], i64 [[V2]], 1
; CHECK-NEXT:    [[B0:%.*]] = insertvalue { i64, i64 } poison, i64 [[V3]], 0
; CHECK-NEXT:    [[B1:%.*]] = insertvalue { i64, i64 } [[B0]], i64 [[V4]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND]], { i64, i64 } [[A1]], { i64, i64 } [[B1]]
; CHECK-NEXT:    [[X:%.*]] = extractvalue { i64, i64 } [[SEL]], 0
; CHECK-NEXT:    call void @use(i64 [[X]])
; CHECK-NEXT:    [[Y:%.*]] = extractvalue { i64, i64 } [[SEL]], 1
; CHECK-NEXT:    call void @use(i64 [[Y]])
; CHECK-NEXT:    ret void
;
entry:
  %a0 = insertvalue { i64, i64 } poison, i64 %v1, 0
  %a1 = insertvalue { i64, i64 } %a0, i64 %v2, 1
  %b0 = insertvalue { i64, i64 } poison, i64 %v3, 0
  %b1 = insertvalue { i64, i64 } %b0, i64 %v4, 1
  %sel = select i1 %cond, { i64, i64 } %a1, { i64, i64 } %b1
  %x = extractvalue { i64, i64 } %sel, 0
  call void @use(i64 %x)
  %y = extractvalue { i64, i64 } %sel, 1
  call void @use(i64 %y)
  ret void
}

declare void @use(i64)
