; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 | FileCheck %s --check-prefix=RV32I
; RUN: llc < %s -mtriple=riscv64 | FileCheck %s --check-prefix=RV64I

define i8 @ucmp.8.8(i8 zeroext %x, i8 zeroext %y) nounwind {
; RV32I-LABEL: ucmp.8.8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a0, a1
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @ucmp.8.16(i16 zeroext %x, i16 zeroext %y) nounwind {
; RV32I-LABEL: ucmp.8.16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a0, a1
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @ucmp.8.32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: ucmp.8.32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a0, a1
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    srli a1, a1, 32
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @ucmp.8.64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: ucmp.8.64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a1, a3, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu a4, a1, a3
; RV32I-NEXT:    sltu a0, a3, a1
; RV32I-NEXT:    sub a0, a0, a4
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    sltu a4, a0, a2
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    sub a0, a0, a4
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @ucmp.8.128(i128 %x, i128 %y) nounwind {
; RV32I-LABEL: ucmp.8.128:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lw a2, 4(a1)
; RV32I-NEXT:    lw a3, 4(a0)
; RV32I-NEXT:    lw a4, 8(a1)
; RV32I-NEXT:    lw a5, 12(a1)
; RV32I-NEXT:    lw a6, 12(a0)
; RV32I-NEXT:    lw a7, 8(a0)
; RV32I-NEXT:    beq a6, a5, .LBB4_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu t2, a6, a5
; RV32I-NEXT:    j .LBB4_3
; RV32I-NEXT:  .LBB4_2:
; RV32I-NEXT:    sltu t2, a7, a4
; RV32I-NEXT:  .LBB4_3:
; RV32I-NEXT:    lw a1, 0(a1)
; RV32I-NEXT:    lw t0, 0(a0)
; RV32I-NEXT:    beq a3, a2, .LBB4_5
; RV32I-NEXT:  # %bb.4:
; RV32I-NEXT:    sltu a0, a3, a2
; RV32I-NEXT:    j .LBB4_6
; RV32I-NEXT:  .LBB4_5:
; RV32I-NEXT:    sltu a0, t0, a1
; RV32I-NEXT:  .LBB4_6:
; RV32I-NEXT:    xor t1, a6, a5
; RV32I-NEXT:    xor t3, a7, a4
; RV32I-NEXT:    or t1, t3, t1
; RV32I-NEXT:    beqz t1, .LBB4_8
; RV32I-NEXT:  # %bb.7:
; RV32I-NEXT:    mv a0, t2
; RV32I-NEXT:  .LBB4_8:
; RV32I-NEXT:    beq a6, a5, .LBB4_11
; RV32I-NEXT:  # %bb.9:
; RV32I-NEXT:    sltu a4, a5, a6
; RV32I-NEXT:    bne a3, a2, .LBB4_12
; RV32I-NEXT:  .LBB4_10:
; RV32I-NEXT:    sltu a1, a1, t0
; RV32I-NEXT:    bnez t1, .LBB4_13
; RV32I-NEXT:    j .LBB4_14
; RV32I-NEXT:  .LBB4_11:
; RV32I-NEXT:    sltu a4, a4, a7
; RV32I-NEXT:    beq a3, a2, .LBB4_10
; RV32I-NEXT:  .LBB4_12:
; RV32I-NEXT:    sltu a1, a2, a3
; RV32I-NEXT:    beqz t1, .LBB4_14
; RV32I-NEXT:  .LBB4_13:
; RV32I-NEXT:    mv a1, a4
; RV32I-NEXT:  .LBB4_14:
; RV32I-NEXT:    sub a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.128:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beq a1, a3, .LBB4_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    sltu a4, a1, a3
; RV64I-NEXT:    sltu a0, a3, a1
; RV64I-NEXT:    sub a0, a0, a4
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB4_2:
; RV64I-NEXT:    sltu a4, a0, a2
; RV64I-NEXT:    sltu a0, a2, a0
; RV64I-NEXT:    sub a0, a0, a4
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @ucmp.32.32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: ucmp.32.32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a0, a1
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.32.32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    srli a1, a1, 32
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: ucmp.32.64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a1, a3, .LBB6_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu a4, a1, a3
; RV32I-NEXT:    sltu a0, a3, a1
; RV32I-NEXT:    sub a0, a0, a4
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB6_2:
; RV32I-NEXT:    sltu a4, a0, a2
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    sub a0, a0, a4
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.32.64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @ucmp.64.64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: ucmp.64.64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a1, a3, .LBB7_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu a4, a1, a3
; RV32I-NEXT:    sltu a0, a3, a1
; RV32I-NEXT:    j .LBB7_3
; RV32I-NEXT:  .LBB7_2:
; RV32I-NEXT:    sltu a4, a0, a2
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:  .LBB7_3:
; RV32I-NEXT:    sub a0, a0, a4
; RV32I-NEXT:    srai a1, a0, 31
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.64.64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
  %1 = call i64 @llvm.ucmp(i64 %x, i64 %y)
  ret i64 %1
}
