; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;
; Test that the fls library call simplifier works correctly even for
; targets with 16-bit int.  Although fls is available on a number of
; targets it's supported (hardcoded as available) only on FreeBSD.
;
; RUN: opt < %s -mtriple=avr-freebsd -passes=instcombine -S | FileCheck %s --check-prefix=AVR
; RUN: opt < %s -mtriple=msp430-freebsd -passes=instcombine -S | FileCheck %s --check-prefix=MSP430
; REQUIRES: avr-registered-target,msp430-registered-target

declare i16 @fls(i16)

declare void @sink(i16)


define void @fold_fls(i16 %x) {
; AVR-LABEL: @fold_fls(
; AVR-NEXT:    call addrspace(1) void @sink(i16 0)
; AVR-NEXT:    call addrspace(1) void @sink(i16 1)
; AVR-NEXT:    [[CTLZ:%.*]] = call addrspace(1) i16 @llvm.ctlz.i16(i16 [[X:%.*]], i1 false), !range [[RNG0:![0-9]+]]
; AVR-NEXT:    [[NX:%.*]] = sub nuw nsw i16 16, [[CTLZ]]
; AVR-NEXT:    call addrspace(1) void @sink(i16 [[NX]])
; AVR-NEXT:    ret void
;
; MSP430-LABEL: @fold_fls(
; MSP430-NEXT:    call void @sink(i16 0)
; MSP430-NEXT:    call void @sink(i16 1)
; MSP430-NEXT:    [[CTLZ:%.*]] = call i16 @llvm.ctlz.i16(i16 [[X:%.*]], i1 false), !range [[RNG0:![0-9]+]]
; MSP430-NEXT:    [[NX:%.*]] = sub nuw nsw i16 16, [[CTLZ]]
; MSP430-NEXT:    call void @sink(i16 [[NX]])
; MSP430-NEXT:    ret void
;
  %n0 = call i16 @fls(i16 0)
  call void @sink(i16 %n0)

  %n1 = call i16 @fls(i16 1)
  call void @sink(i16 %n1)

  %nx = call i16 @fls(i16 %x)
  call void @sink(i16 %nx)

  ret void
}
