// RUN: llvm-mc -triple=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

image_load v5, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v252, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0xfc,0x02,0x00]

image_load v5, v252, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0xfc,0x05,0x02,0x00]

image_load v5, v1, s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x03,0x00]

image_load v5, v1, s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x17,0x00]

image_load v5, v1, ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x1d,0x00]

image_load v5, v1, s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v1, s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v1, s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v1, s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v1, s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:8], v1, s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:3], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x00,0xf2,0x01,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x01,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x02,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v1, s[8:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x02,0x80]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v252, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0xfc,0x02,0x00]

image_load_mip v5, v[252:253], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x03,0x00]

image_load_mip v5, v[1:2], s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x17,0x00]

image_load_mip v5, v[1:2], ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x1d,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:2], s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:2], s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:2], s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:2], s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:8], v[1:2], s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:3], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x04,0xf2,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x05,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x06,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:2], s[8:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x02,0x80]

image_load_pck v5, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v252, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0xfc,0x02,0x00]

image_load_pck v5, v252, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0xfc,0x05,0x02,0x00]

image_load_pck v5, v1, s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x03,0x00]

image_load_pck v5, v1, s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x17,0x00]

image_load_pck v5, v1, ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x1d,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:7], v1, s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:7], v1, s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:7], v1, s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:7], v1, s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:8], v1, s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v[1:3], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x08,0xf2,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x0a,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v252, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0xfc,0x02,0x00]

image_load_pck_sgn v5, v252, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0xfc,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x03,0x00]

image_load_pck_sgn v5, v1, s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x17,0x00]

image_load_pck_sgn v5, v1, ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x1d,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:7], v1, s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:7], v1, s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:7], v1, s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:7], v1, s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:8], v1, s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v[1:3], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x0c,0xf2,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x0e,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v252, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0xfc,0x02,0x00]

image_load_mip_pck v5, v[252:253], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0x05,0x03,0x00]

image_load_mip_pck v5, v[1:2], s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0x05,0x17,0x00]

image_load_mip_pck v5, v[1:2], ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0x05,0x1d,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:7], v[1:2], s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:7], v[1:2], s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:7], v[1:2], s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:7], v[1:2], s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:8], v[1:2], s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:3], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x10,0xf2,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x11,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x12,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v5, v[1:2], s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v252, v[1:2], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0xfc,0x02,0x00]

image_load_mip_pck_sgn v5, v[252:253], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0x05,0x03,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0x05,0x17,0x00]

image_load_mip_pck_sgn v5, v[1:2], ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0x05,0x1d,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:7], v[1:2], s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:7], v[1:2], s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:7], v[1:2], s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:7], v[1:2], s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:8], v[1:2], s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:3], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x14,0xf2,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x15,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x16,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v5, v[1:2], s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x14,0xf0,0x01,0x05,0x02,0x00]

image_store v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0xfc,0x03,0x00]

image_store v1, v252, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0xfc,0x01,0x03,0x00]

image_store v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x04,0x00]

image_store v1, v2, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x17,0x00]

image_store v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x1d,0x00]

image_store v1, v2, s[12:19] dmask:0x2 unorm
// CHECK: [0x00,0x12,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x4 unorm
// CHECK: [0x00,0x14,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x5 unorm
// CHECK: [0x00,0x15,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x6 unorm
// CHECK: [0x00,0x16,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v2, s[12:19] dmask:0x7 unorm
// CHECK: [0x00,0x17,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x8 unorm
// CHECK: [0x00,0x18,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x9 unorm
// CHECK: [0x00,0x19,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0xa unorm
// CHECK: [0x00,0x1a,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v2, s[12:19] dmask:0xb unorm
// CHECK: [0x00,0x1b,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0xc unorm
// CHECK: [0x00,0x1c,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v2, s[12:19] dmask:0xd unorm
// CHECK: [0x00,0x1d,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v2, s[12:19] dmask:0xe unorm
// CHECK: [0x00,0x1e,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:4], v2, s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x0 unorm
// CHECK: [0x00,0x10,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:3], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:4], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x20,0xf2,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x22,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v2, s[12:19] dmask:0x1 unorm d16
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x03,0x80]

image_store_mip v1, v[2:3], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v252, v[2:3], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0xfc,0x03,0x00]

image_store_mip v1, v[252:253], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x04,0x00]

image_store_mip v1, v[2:3], s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x17,0x00]

image_store_mip v1, v[2:3], ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x1d,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x2 unorm
// CHECK: [0x00,0x12,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x4 unorm
// CHECK: [0x00,0x14,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x5 unorm
// CHECK: [0x00,0x15,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x6 unorm
// CHECK: [0x00,0x16,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:3], s[12:19] dmask:0x7 unorm
// CHECK: [0x00,0x17,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x8 unorm
// CHECK: [0x00,0x18,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x9 unorm
// CHECK: [0x00,0x19,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0xa unorm
// CHECK: [0x00,0x1a,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:3], s[12:19] dmask:0xb unorm
// CHECK: [0x00,0x1b,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0xc unorm
// CHECK: [0x00,0x1c,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:3], s[12:19] dmask:0xd unorm
// CHECK: [0x00,0x1d,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:3], s[12:19] dmask:0xe unorm
// CHECK: [0x00,0x1e,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:4], v[2:3], s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x0 unorm
// CHECK: [0x00,0x10,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:4], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x24,0xf2,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x26,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x1 unorm d16
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x03,0x80]

image_store_pck v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0xfc,0x03,0x00]

image_store_pck v1, v252, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0xfc,0x01,0x03,0x00]

image_store_pck v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x04,0x00]

image_store_pck v1, v2, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x17,0x00]

image_store_pck v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x1d,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x2 unorm
// CHECK: [0x00,0x12,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x4 unorm
// CHECK: [0x00,0x14,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x5 unorm
// CHECK: [0x00,0x15,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x6 unorm
// CHECK: [0x00,0x16,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:3], v2, s[12:19] dmask:0x7 unorm
// CHECK: [0x00,0x17,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x8 unorm
// CHECK: [0x00,0x18,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x9 unorm
// CHECK: [0x00,0x19,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0xa unorm
// CHECK: [0x00,0x1a,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:3], v2, s[12:19] dmask:0xb unorm
// CHECK: [0x00,0x1b,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0xc unorm
// CHECK: [0x00,0x1c,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:3], v2, s[12:19] dmask:0xd unorm
// CHECK: [0x00,0x1d,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:3], v2, s[12:19] dmask:0xe unorm
// CHECK: [0x00,0x1e,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:4], v2, s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x0 unorm
// CHECK: [0x00,0x10,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v[2:3], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v[2:4], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x28,0xf2,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x2a,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v252, v[2:3], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0xfc,0x03,0x00]

image_store_mip_pck v1, v[252:253], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0x01,0x04,0x00]

image_store_mip_pck v1, v[2:3], s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0x01,0x17,0x00]

image_store_mip_pck v1, v[2:3], ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0x01,0x1d,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x2 unorm
// CHECK: [0x00,0x12,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x4 unorm
// CHECK: [0x00,0x14,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x5 unorm
// CHECK: [0x00,0x15,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x6 unorm
// CHECK: [0x00,0x16,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:3], v[2:3], s[12:19] dmask:0x7 unorm
// CHECK: [0x00,0x17,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x8 unorm
// CHECK: [0x00,0x18,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x9 unorm
// CHECK: [0x00,0x19,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0xa unorm
// CHECK: [0x00,0x1a,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:3], v[2:3], s[12:19] dmask:0xb unorm
// CHECK: [0x00,0x1b,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0xc unorm
// CHECK: [0x00,0x1c,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:3], v[2:3], s[12:19] dmask:0xd unorm
// CHECK: [0x00,0x1d,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:3], v[2:3], s[12:19] dmask:0xe unorm
// CHECK: [0x00,0x1e,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:4], v[2:3], s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x0 unorm
// CHECK: [0x00,0x10,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:4], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x2c,0xf2,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x2e,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v252, v1, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0xfc,0x02,0x00]

image_get_resinfo v5, v252, s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0xfc,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x03,0x00]

image_get_resinfo v5, v1, s[92:99] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x17,0x00]

image_get_resinfo v5, v1, ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x1d,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v1, s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v1, s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v1, s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v1, s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:8], v1, s[8:15] dmask:0xf
// CHECK: [0x00,0x0f,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x38,0xf2,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x39,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x3a,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x38,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_swap v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0xff,0x05,0x02,0x00]

image_atomic_swap v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x03,0x00]

image_atomic_swap v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x17,0x00]

image_atomic_swap v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_swap v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x40,0xf2,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x42,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x40,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[252:253], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_cmpswap v[5:6], v255, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0xff,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v1, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x03,0x00]

image_atomic_cmpswap v[5:6], v1, s[92:99] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x17,0x00]

image_atomic_cmpswap v[5:6], v1, ttmp[4:11] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_cmpswap v[5:8], v1, s[8:15] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v[1:2], s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v[1:3], s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v[1:4], s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v1, s[8:15] dmask:0x3 unorm glc
// CHECK: [0x00,0x33,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v1, s[8:15] dmask:0x3 unorm slc
// CHECK: [0x00,0x13,0x44,0xf2,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v1, s[8:15] dmask:0x3 unorm lwe
// CHECK: [0x00,0x13,0x46,0xf0,0x01,0x05,0x02,0x00]

image_atomic_cmpswap v[5:6], v1, s[8:15] dmask:0x3 unorm da
// CHECK: [0x00,0x53,0x44,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_add v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0xff,0x05,0x02,0x00]

image_atomic_add v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x03,0x00]

image_atomic_add v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x17,0x00]

image_atomic_add v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_add v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x48,0xf2,0x01,0x05,0x02,0x00]

image_atomic_add v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x4a,0xf0,0x01,0x05,0x02,0x00]

image_atomic_add v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x48,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_sub v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0xff,0x05,0x02,0x00]

image_atomic_sub v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x03,0x00]

image_atomic_sub v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x17,0x00]

image_atomic_sub v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_sub v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x4c,0xf2,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x4e,0xf0,0x01,0x05,0x02,0x00]

image_atomic_sub v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x4c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_smin v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0xff,0x05,0x02,0x00]

image_atomic_smin v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x03,0x00]

image_atomic_smin v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x17,0x00]

image_atomic_smin v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_smin v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x50,0xf2,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x52,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smin v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x50,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_umin v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0xff,0x05,0x02,0x00]

image_atomic_umin v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x03,0x00]

image_atomic_umin v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x17,0x00]

image_atomic_umin v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_umin v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x54,0xf2,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x56,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umin v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x54,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_smax v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0xff,0x05,0x02,0x00]

image_atomic_smax v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x03,0x00]

image_atomic_smax v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x17,0x00]

image_atomic_smax v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_smax v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x58,0xf2,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x5a,0xf0,0x01,0x05,0x02,0x00]

image_atomic_smax v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x58,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_umax v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0xff,0x05,0x02,0x00]

image_atomic_umax v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x03,0x00]

image_atomic_umax v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x17,0x00]

image_atomic_umax v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_umax v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x5c,0xf2,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x5e,0xf0,0x01,0x05,0x02,0x00]

image_atomic_umax v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_and v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0xff,0x05,0x02,0x00]

image_atomic_and v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x03,0x00]

image_atomic_and v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x17,0x00]

image_atomic_and v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_and v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x60,0xf2,0x01,0x05,0x02,0x00]

image_atomic_and v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x62,0xf0,0x01,0x05,0x02,0x00]

image_atomic_and v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x60,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_or v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0xff,0x05,0x02,0x00]

image_atomic_or v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x03,0x00]

image_atomic_or v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x17,0x00]

image_atomic_or v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_or v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x64,0xf2,0x01,0x05,0x02,0x00]

image_atomic_or v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x66,0xf0,0x01,0x05,0x02,0x00]

image_atomic_or v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x64,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_xor v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0xff,0x05,0x02,0x00]

image_atomic_xor v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x03,0x00]

image_atomic_xor v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x17,0x00]

image_atomic_xor v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_xor v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x68,0xf2,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x6a,0xf0,0x01,0x05,0x02,0x00]

image_atomic_xor v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x68,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_inc v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0xff,0x05,0x02,0x00]

image_atomic_inc v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x03,0x00]

image_atomic_inc v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x17,0x00]

image_atomic_inc v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_inc v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x6c,0xf2,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x6e,0xf0,0x01,0x05,0x02,0x00]

image_atomic_inc v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x6c,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v252, v1, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0xfc,0x02,0x00]

image_atomic_dec v5, v255, s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0xff,0x05,0x02,0x00]

image_atomic_dec v5, v1, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x03,0x00]

image_atomic_dec v5, v1, s[92:99] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x17,0x00]

image_atomic_dec v5, v1, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x1d,0x00]

image_atomic_dec v[5:6], v1, s[8:15] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x70,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v[1:2], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v[1:3], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v1, s[8:15] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x70,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v1, s[8:15] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x70,0xf2,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v1, s[8:15] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x72,0xf0,0x01,0x05,0x02,0x00]

image_atomic_dec v5, v1, s[8:15] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x70,0xf0,0x01,0x05,0x02,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v252, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0xfc,0x62,0x00]

image_sample v5, v252, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0xfc,0x05,0x62,0x00]

image_sample v5, v1, s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x63,0x00]

image_sample v5, v1, s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x77,0x00]

image_sample v5, v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x7d,0x00]

image_sample v5, v1, s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x82,0x00]

image_sample v5, v1, s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x02,0x03]

image_sample v5, v1, s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0xc2,0x03]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v1, s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v1, s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v1, s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v1, s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:8], v1, s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x80,0xf2,0x01,0x05,0x62,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x81,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x82,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v1, s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x62,0x80]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0xfc,0x62,0x00]

image_sample_cl v5, v[252:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0xfc,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x63,0x00]

image_sample_cl v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x77,0x00]

image_sample_cl v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x7d,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x82,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x02,0x03]

image_sample_cl v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0xc2,0x03]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x84,0xf2,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x85,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x86,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x62,0x80]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0xfc,0x62,0x00]

image_sample_d v5, v[246:248], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0xf6,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x63,0x00]

image_sample_d v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x77,0x00]

image_sample_d v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x7d,0x00]

image_sample_d v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x82,0x00]

image_sample_d v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x02,0x03]

image_sample_d v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0xc2,0x03]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:9], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x88,0xf2,0x01,0x05,0x62,0x00]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x89,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x8a,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x88,0xf0,0x01,0x05,0x62,0x00]

image_sample_d v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x88,0xf0,0x01,0x05,0x62,0x80]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0xfc,0x62,0x00]

image_sample_d_cl v5, v[246:249], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0xf6,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x63,0x00]

image_sample_d_cl v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x77,0x00]

image_sample_d_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x7d,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x82,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x02,0x03]

image_sample_d_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0xc2,0x03]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x8c,0xf2,0x01,0x05,0x62,0x00]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x8d,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x8e,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x8c,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x8c,0xf0,0x01,0x05,0x62,0x80]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0xfc,0x62,0x00]

image_sample_l v5, v[252:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0xfc,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x63,0x00]

image_sample_l v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x77,0x00]

image_sample_l v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x7d,0x00]

image_sample_l v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x82,0x00]

image_sample_l v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x02,0x03]

image_sample_l v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0xc2,0x03]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x90,0xf2,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x91,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x92,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x62,0x80]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0xfc,0x62,0x00]

image_sample_b v5, v[252:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0xfc,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x63,0x00]

image_sample_b v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x77,0x00]

image_sample_b v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x7d,0x00]

image_sample_b v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x82,0x00]

image_sample_b v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x02,0x03]

image_sample_b v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0xc2,0x03]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x94,0xf2,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x95,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x96,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x62,0x80]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0xfc,0x62,0x00]

image_sample_b_cl v5, v[252:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0xfc,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x63,0x00]

image_sample_b_cl v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x77,0x00]

image_sample_b_cl v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x7d,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x82,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x02,0x03]

image_sample_b_cl v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0xc2,0x03]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x98,0xf2,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x99,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x9a,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x62,0x80]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v252, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0xfc,0x62,0x00]

image_sample_lz v5, v252, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0xfc,0x05,0x62,0x00]

image_sample_lz v5, v1, s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x63,0x00]

image_sample_lz v5, v1, s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x77,0x00]

image_sample_lz v5, v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x7d,0x00]

image_sample_lz v5, v1, s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x82,0x00]

image_sample_lz v5, v1, s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x02,0x03]

image_sample_lz v5, v1, s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0xc2,0x03]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v1, s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v1, s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v1, s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v1, s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:8], v1, s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x9c,0xf2,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x9d,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x9e,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v1, s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x62,0x80]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c v5, v[252:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x63,0x00]

image_sample_c v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x77,0x00]

image_sample_c v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x82,0x00]

image_sample_c v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x02,0x03]

image_sample_c v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa0,0xf2,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa1,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xa2,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_cl v5, v[252:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_cl v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_cl v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_cl v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa4,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa5,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xa6,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_d v5, v[246:249], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0xf6,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_d v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_d v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_d v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa8,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa9,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xaa,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_d_cl v5, v[246:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0xf6,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_d_cl v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_d_cl v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_d_cl v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xac,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xad,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xae,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xac,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xac,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_l v5, v[252:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_l v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_l v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_l v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb0,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb1,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xb2,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_b v5, v[252:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_b v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_b v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_b v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb4,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb5,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xb6,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_b_cl v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_b_cl v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_b_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_b_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb8,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb9,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xba,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_lz v5, v[252:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_lz v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_lz v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_lz v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xbc,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xbd,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xbe,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x62,0x80]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_o v5, v[251:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0xfb,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x63,0x00]

image_sample_o v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x77,0x00]

image_sample_o v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_o v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x82,0x00]

image_sample_o v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x02,0x03]

image_sample_o v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xc0,0xf2,0x01,0x05,0x62,0x00]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xc1,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xc2,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xc0,0xf0,0x01,0x05,0x62,0x00]

image_sample_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xc0,0xf0,0x01,0x05,0x62,0x80]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_cl_o v5, v[251:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0xfb,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x63,0x00]

image_sample_cl_o v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x77,0x00]

image_sample_cl_o v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x82,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x02,0x03]

image_sample_cl_o v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xc4,0xf2,0x01,0x05,0x62,0x00]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xc5,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xc6,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xc4,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xc4,0xf0,0x01,0x05,0x62,0x80]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_d_o v5, v[245:248], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0xf5,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x63,0x00]

image_sample_d_o v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x77,0x00]

image_sample_d_o v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x82,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x02,0x03]

image_sample_d_o v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xc8,0xf2,0x01,0x05,0x62,0x00]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xc9,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xca,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xc8,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xc8,0xf0,0x01,0x05,0x62,0x80]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0xfc,0x62,0x00]

image_sample_d_cl_o v5, v[245:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0xf5,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x63,0x00]

image_sample_d_cl_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x77,0x00]

image_sample_d_cl_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x7d,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x82,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x02,0x03]

image_sample_d_cl_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0xc2,0x03]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xcc,0xf2,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xcd,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xce,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xcc,0xf0,0x01,0x05,0x62,0x00]

image_sample_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xcc,0xf0,0x01,0x05,0x62,0x80]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_l_o v5, v[251:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0xfb,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x63,0x00]

image_sample_l_o v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x77,0x00]

image_sample_l_o v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x82,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x02,0x03]

image_sample_l_o v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xd0,0xf2,0x01,0x05,0x62,0x00]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xd1,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xd2,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xd0,0xf0,0x01,0x05,0x62,0x00]

image_sample_l_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xd0,0xf0,0x01,0x05,0x62,0x80]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_b_o v5, v[251:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0xfb,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x63,0x00]

image_sample_b_o v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x77,0x00]

image_sample_b_o v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x82,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x02,0x03]

image_sample_b_o v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xd4,0xf2,0x01,0x05,0x62,0x00]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xd5,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xd6,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xd4,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xd4,0xf0,0x01,0x05,0x62,0x80]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_b_cl_o v5, v[251:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0xfb,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x63,0x00]

image_sample_b_cl_o v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x77,0x00]

image_sample_b_cl_o v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x82,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x02,0x03]

image_sample_b_cl_o v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xd8,0xf2,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xd9,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xda,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xd8,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xd8,0xf0,0x01,0x05,0x62,0x80]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v252, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0xfc,0x62,0x00]

image_sample_lz_o v5, v[251:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0xfb,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x63,0x00]

image_sample_lz_o v5, v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x77,0x00]

image_sample_lz_o v5, v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x7d,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x82,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x02,0x03]

image_sample_lz_o v5, v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0xc2,0x03]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:8], v[1:2], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xdc,0xf2,0x01,0x05,0x62,0x00]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xdd,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xde,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xdc,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz_o v5, v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xdc,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_o v5, v[251:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0xfb,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_o v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_o v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_o v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xe0,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xe1,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xe2,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xe0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xe0,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_cl_o v5, v[251:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0xfb,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_cl_o v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_cl_o v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_cl_o v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xe4,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xe5,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xe6,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xe4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xe4,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_d_o v5, v[245:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0xf5,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_d_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_d_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_d_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xe8,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xe9,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xea,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xe8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xe8,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_d_cl_o v5, v[245:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0xf5,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_d_cl_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xec,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xed,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xee,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xec,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xec,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_l_o v5, v[251:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0xfb,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_l_o v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_l_o v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_l_o v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xf0,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xf1,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xf2,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xf0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xf0,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_b_o v5, v[251:254], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0xfb,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_b_o v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_b_o v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_b_o v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xf4,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xf5,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xf6,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xf4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xf4,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_b_cl_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xf8,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xf9,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xfa,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xf8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xf8,0xf0,0x01,0x05,0x62,0x80]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_lz_o v5, v[251:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0xfb,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_lz_o v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x77,0x00]

image_sample_c_lz_o v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x02,0x03]

image_sample_c_lz_o v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xfc,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xfd,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xfe,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xfc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xfc,0xf0,0x01,0x05,0x62,0x80]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[252:255], v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0xfc,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x63,0x00]

image_gather4 v[5:8], v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x77,0x00]

image_gather4 v[5:8], v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x7d,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x82,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x02,0x03]

image_gather4 v[5:8], v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0xc2,0x03]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x00,0xf3,0x01,0x05,0x62,0x00]

image_gather4 v[5:9], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x01,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x02,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x62,0x80]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x63,0x00]

image_gather4_cl v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x77,0x00]

image_gather4_cl v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x82,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x02,0x03]

image_gather4_cl v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x04,0xf3,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x05,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x06,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x62,0x80]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x63,0x00]

image_gather4_l v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x77,0x00]

image_gather4_l v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x82,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x02,0x03]

image_gather4_l v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x10,0xf3,0x01,0x05,0x62,0x00]

image_gather4_l v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x11,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x12,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x62,0x80]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x77,0x00]

image_gather4_b v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x02,0x03]

image_gather4_b v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x14,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x15,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x16,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x62,0x80]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x77,0x00]

image_gather4_b_cl v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x02,0x03]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x18,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x19,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x1a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x62,0x80]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[252:255], v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_lz v[5:8], v[1:2], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x77,0x00]

image_gather4_lz v[5:8], v[1:2], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x02,0x03]

image_gather4_lz v[5:8], v[1:2], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x1c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:9], v[1:2], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x1d,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x1e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x20,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x21,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x22,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_cl v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x24,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x25,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x26,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_l v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_l v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_l v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x30,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x31,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x32,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_b v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_b v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x34,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x35,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x36,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x38,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:9], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x39,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x3a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_lz v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x3c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x3d,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x3e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x62,0x80]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x63,0x00]

image_gather4_o v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x77,0x00]

image_gather4_o v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x82,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x02,0x03]

image_gather4_o v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x40,0xf3,0x01,0x05,0x62,0x00]

image_gather4_o v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x41,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x42,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x62,0x80]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x63,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x77,0x00]

image_gather4_cl_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x82,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x02,0x03]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x44,0xf3,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x45,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x46,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x62,0x80]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x63,0x00]

image_gather4_l_o v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x77,0x00]

image_gather4_l_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x82,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x02,0x03]

image_gather4_l_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x50,0xf3,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x51,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x52,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x62,0x80]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b_o v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x77,0x00]

image_gather4_b_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x02,0x03]

image_gather4_b_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x54,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x55,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x56,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x62,0x80]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x77,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x02,0x03]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x58,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:9], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x59,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x5a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x62,0x80]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[252:255], v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x77,0x00]

image_gather4_lz_o v[5:8], v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x02,0x03]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x5c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:9], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x5d,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x5e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_o v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x60,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x61,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x62,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x64,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:9], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x65,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x66,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_l_o v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x70,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:9], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x71,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x72,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_b_o v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x74,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:9], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x75,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x76,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x78,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:9], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x79,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x7a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x62,0x80]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x77,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x02,0x03]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x7c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:9], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x7d,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x7e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x62,0x80]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v252, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0xfc,0x62,0x00]

image_get_lod v5, v255, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0xff,0x05,0x62,0x00]

image_get_lod v5, v1, s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x63,0x00]

image_get_lod v5, v1, s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x77,0x00]

image_get_lod v5, v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x7d,0x00]

image_get_lod v5, v1, s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x82,0x00]

image_get_lod v5, v1, s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x02,0x03]

image_get_lod v5, v1, s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0xc2,0x03]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:8], v1, s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v[1:2], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x80,0xf3,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x81,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x82,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x80,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v252, v[1:3], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0xfc,0x62,0x00]

image_sample_cd v5, v[246:248], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0xf6,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x63,0x00]

image_sample_cd v5, v[1:3], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x77,0x00]

image_sample_cd v5, v[1:3], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x7d,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x82,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x02,0x03]

image_sample_cd v5, v[1:3], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0xc2,0x03]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:7], v[1:3], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v[5:8], v[1:3], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:9], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa0,0xf3,0x01,0x05,0x62,0x00]

image_sample_cd v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa1,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xa2,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd v5, v[1:3], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xa0,0xf1,0x01,0x05,0x62,0x80]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0xfc,0x62,0x00]

image_sample_cd_cl v5, v[246:249], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0xf6,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x63,0x00]

image_sample_cd_cl v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x77,0x00]

image_sample_cd_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x7d,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x82,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x02,0x03]

image_sample_cd_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0xc2,0x03]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa4,0xf3,0x01,0x05,0x62,0x00]

image_sample_cd_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa5,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xa6,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xa4,0xf1,0x01,0x05,0x62,0x80]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0xfc,0x62,0x00]

image_sample_c_cd v5, v[246:249], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0xf6,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x63,0x00]

image_sample_c_cd v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x77,0x00]

image_sample_c_cd v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x7d,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x82,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x02,0x03]

image_sample_c_cd v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0xc2,0x03]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa8,0xf3,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa9,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xaa,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x62,0x80]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0xfc,0x62,0x00]

image_sample_c_cd_cl v5, v[246:253], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0xf6,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x63,0x00]

image_sample_c_cd_cl v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x77,0x00]

image_sample_c_cd_cl v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x7d,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x82,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x02,0x03]

image_sample_c_cd_cl v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0xc2,0x03]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xac,0xf3,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xad,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xae,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xac,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xac,0xf1,0x01,0x05,0x62,0x80]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0xfc,0x62,0x00]

image_sample_cd_o v5, v[245:248], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0xf5,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x63,0x00]

image_sample_cd_o v5, v[1:4], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x77,0x00]

image_sample_cd_o v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x7d,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x82,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x02,0x03]

image_sample_cd_o v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0xc2,0x03]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb0,0xf3,0x01,0x05,0x62,0x00]

image_sample_cd_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb1,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xb2,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb0,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_o v5, v[1:4], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xb0,0xf1,0x01,0x05,0x62,0x80]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0xfc,0x62,0x00]

image_sample_cd_cl_o v5, v[245:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0xf5,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x63,0x00]

image_sample_cd_cl_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x77,0x00]

image_sample_cd_cl_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x7d,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x82,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x02,0x03]

image_sample_cd_cl_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0xc2,0x03]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb4,0xf3,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb5,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xb6,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb4,0xf1,0x01,0x05,0x62,0x00]

image_sample_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xb4,0xf1,0x01,0x05,0x62,0x80]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0xfc,0x62,0x00]

image_sample_c_cd_o v5, v[245:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0xf5,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x63,0x00]

image_sample_c_cd_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x77,0x00]

image_sample_c_cd_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x7d,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x82,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x02,0x03]

image_sample_c_cd_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0xc2,0x03]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb8,0xf3,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb9,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xba,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xb8,0xf1,0x01,0x05,0x62,0x80]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v252, v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0xfc,0x62,0x00]

image_sample_c_cd_cl_o v5, v[245:252], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0xf5,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x63,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[92:99], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x77,0x00]

image_sample_c_cd_cl_o v5, v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x7d,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x82,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[96:99] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x02,0x03]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0xc2,0x03]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0xf
// CHECK: [0x00,0x0f,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:10], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xbc,0xf3,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xbd,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xbe,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xbc,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd_cl_o v5, v[1:8], s[8:15], s[12:15] dmask:0x1 d16
// CHECK: [0x00,0x01,0xbc,0xf1,0x01,0x05,0x62,0x80]
