// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1013 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck %s

image_bvh64_intersect_ray v[5:8], v[1:12], s[8:11]
// CHECK: [0x01,0x9f,0x9c,0xf1,0x01,0x05,0x02,0x00]

image_bvh64_intersect_ray v[5:8], v[247:255], s[8:11] a16
// CHECK: [0x01,0x9f,0x9c,0xf1,0xf7,0x05,0x02,0x40]

image_bvh64_intersect_ray v[5:8], v[1:12], ttmp[12:15]
// CHECK: [0x01,0x9f,0x9c,0xf1,0x01,0x05,0x1e,0x00]

image_bvh64_intersect_ray v[39:42], [v50, v46, v23, v17, v16, v15, v21, v20, v19, v37, v40, v42], s[12:15]
// CHECK: [0x07,0x9f,0x9c,0xf1,0x32,0x27,0x03,0x00,0x2e,0x17,0x11,0x10,0x0f,0x15,0x14,0x13,0x25,0x28,0x2a,0x00]

image_bvh_intersect_ray v[252:255], v[1:11], s[8:11]
// CHECK: [0x01,0x9f,0x98,0xf1,0x01,0xfc,0x02,0x00]

image_bvh_intersect_ray v[5:8], v[248:255], s[8:11] a16
// CHECK: [0x01,0x9f,0x98,0xf1,0xf8,0x05,0x02,0x40]

image_bvh_intersect_ray v[5:8], v[1:11], ttmp[12:15]
// CHECK: [0x01,0x9f,0x98,0xf1,0x01,0x05,0x1e,0x00]

image_bvh_intersect_ray v[39:42], [v50, v46, v23, v17, v16, v15, v21, v20, v19, v37, v40], s[12:15]
// CHECK: [0x07,0x9f,0x98,0xf1,0x32,0x27,0x03,0x00,0x2e,0x17,0x11,0x10,0x0f,0x15,0x14,0x13,0x25,0x28,0x00,0x00]

image_msaa_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// CHECK: [0x39,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[5:7], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY tfe
// CHECK: [0x39,0x03,0x01,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v5, v[1:4], s[8:15] dmask:0x8 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY d16
// CHECK: [0x39,0x08,0x00,0xf0,0x01,0x05,0x02,0x80]

image_msaa_load v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// CHECK: [0x39,0x03,0x00,0xf0,0x01,0x05,0x02,0x40]

image_msaa_load v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// CHECK: [0x31,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// CHECK: [0x39,0x13,0x00,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY glc
// CHECK: [0x39,0x23,0x00,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY slc
// CHECK: [0x39,0x03,0x00,0xf2,0x01,0x05,0x02,0x00]

image_msaa_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY dlc
// CHECK: [0xb9,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY lwe
// CHECK: [0x39,0x03,0x02,0xf0,0x01,0x05,0x02,0x00]
