; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX

define { <4 x i1>, <4 x i1> } @uaddo(<4 x i1> %a) {
; SSE-LABEL: uaddo:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: uaddo:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps %xmm0, %xmm1
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %f = call { <4 x i1>, <4 x i1> } @llvm.uadd.with.overflow.v4i1(<4 x i1> %a, <4 x i1> %a)
  ret { <4 x i1>, <4 x i1> } %f
}
declare { <4 x i1>, <4 x i1> } @llvm.uadd.with.overflow.v4i1(<4 x i1>, <4 x i1>)

define { <4 x i1>, <4 x i1> } @saddo(<4 x i1> %a) {
; SSE-LABEL: saddo:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: saddo:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps %xmm0, %xmm1
; AVX-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %f = call { <4 x i1>, <4 x i1> } @llvm.sadd.with.overflow.v4i1(<4 x i1> %a, <4 x i1> %a)
  ret { <4 x i1>, <4 x i1> } %f
}
declare { <4 x i1>, <4 x i1> } @llvm.sadd.with.overflow.v4i1(<4 x i1>, <4 x i1>)
