# ===----------------------------------------------------------------------===##
#
# Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#
# ===----------------------------------------------------------------------===##

import os.path

import libcxx.header_information

header_restrictions = libcxx.header_information.header_restrictions

libcxx_include_directory = os.path.join(
    os.path.dirname(os.path.dirname(os.path.realpath(__file__))), "include"
)
with open(
    os.path.join(libcxx_include_directory, "__std_clang_module"), "w"
) as std_clang_module_header:
    std_clang_module_header.write(
        """\
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING, this entire header is generated by
// utils/generate_std_clang_module_header.py
// DO NOT MODIFY!

// This header should not be directly included, it's exclusively to import all
// of the libc++ public clang modules for the `std` clang module to export. In
// other words, it's to facilitate `@import std;` in Objective-C++ and `import std`
// in Swift to expose all of the libc++ interfaces. This is generally not
// recommended, however there are some clients that need to import all of libc++
// without knowing what "all" is.
#if !__building_module(std)
#  error "Do not include this header directly, include individual headers instead"
#endif

#include <__config>

#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#  pragma GCC system_header
#endif

"""
    )
    # Include the angle brackets in sorting so that <a.h> sorts before <a>
    # like check-format wants.
    for include, header in sorted([(f"<{header}>", header) for header in libcxx.header_information.public_headers]):
        header_restriction = header_restrictions.get(header)
        if header_restriction:
            std_clang_module_header.write(f"#if {header_restriction}\n")
            std_clang_module_header.write(f"#  include {include}\n")
            std_clang_module_header.write(f"#endif\n")
        else:
            std_clang_module_header.write(f"#include {include}\n")
