; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -mve-max-interleave-factor=4 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define ptr @vst4_v4i32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x i32>, ptr %src, align 4
  %s2 = getelementptr <4 x i32>, ptr %src, i32 1
  %l2 = load <4 x i32>, ptr %s2, align 4
  %s3 = getelementptr <4 x i32>, ptr %src, i32 2
  %l3 = load <4 x i32>, ptr %s3, align 4
  %s4 = getelementptr <4 x i32>, ptr %src, i32 3
  %l4 = load <4 x i32>, ptr %s4, align 4
  %t1 = shufflevector <4 x i32> %l1, <4 x i32> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i32> %l3, <4 x i32> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x i32> %t1, <8 x i32> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x i32> %s, ptr %dst
  %ret = getelementptr inbounds <16 x i32>, ptr %dst, i32 1
  ret ptr %ret
}

; i16

define ptr @vst4_v8i16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.16 {q0, q1, q2, q3}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x i16>, ptr %src, align 4
  %s2 = getelementptr <8 x i16>, ptr %src, i32 1
  %l2 = load <8 x i16>, ptr %s2, align 4
  %s3 = getelementptr <8 x i16>, ptr %src, i32 2
  %l3 = load <8 x i16>, ptr %s3, align 4
  %s4 = getelementptr <8 x i16>, ptr %src, i32 3
  %l4 = load <8 x i16>, ptr %s4, align 4
  %t1 = shufflevector <8 x i16> %l1, <8 x i16> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i16> %l3, <8 x i16> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x i16> %t1, <16 x i16> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x i16> %s, ptr %dst
  %ret = getelementptr inbounds <32 x i16>, ptr %dst, i32 1
  ret ptr %ret
}

; i8

define ptr @vst4_v16i8(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.8 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.8 {q0, q1, q2, q3}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <16 x i8>, ptr %src, align 4
  %s2 = getelementptr <16 x i8>, ptr %src, i32 1
  %l2 = load <16 x i8>, ptr %s2, align 4
  %s3 = getelementptr <16 x i8>, ptr %src, i32 2
  %l3 = load <16 x i8>, ptr %s3, align 4
  %s4 = getelementptr <16 x i8>, ptr %src, i32 3
  %l4 = load <16 x i8>, ptr %s4, align 4
  %t1 = shufflevector <16 x i8> %l1, <16 x i8> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i8> %l3, <16 x i8> %l4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %s = shufflevector <32 x i8> %t1, <32 x i8> %t2, <64 x i32> <i32 0, i32 16, i32 32, i32 48, i32 1, i32 17, i32 33, i32 49, i32 2, i32 18, i32 34, i32 50, i32 3, i32 19, i32 35, i32 51, i32 4, i32 20, i32 36, i32 52, i32 5, i32 21, i32 37, i32 53, i32 6, i32 22, i32 38, i32 54, i32 7, i32 23, i32 39, i32 55, i32 8, i32 24, i32 40, i32 56, i32 9, i32 25, i32 41, i32 57, i32 10, i32 26, i32 42, i32 58, i32 11, i32 27, i32 43, i32 59, i32 12, i32 28, i32 44, i32 60, i32 13, i32 29, i32 45, i32 61, i32 14, i32 30, i32 46, i32 62, i32 15, i32 31, i32 47, i32 63>
  store <64 x i8> %s, ptr %dst
  %ret = getelementptr inbounds <64 x i8>, ptr %dst, i32 1
  ret ptr %ret
}

; i64

define ptr @vst4_v2i64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #32]
; CHECK-NEXT:    vmov.f64 d2, d6
; CHECK-NEXT:    vmov.f64 d3, d0
; CHECK-NEXT:    vmov.f64 d0, d7
; CHECK-NEXT:    vmov.f64 d7, d4
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vmov.f64 d6, d8
; CHECK-NEXT:    vmov.f64 d4, d9
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vstrw.32 q2, [r1, #48]
; CHECK-NEXT:    vstrw.32 q1, [r1], #64
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x i64>, ptr %src, align 4
  %s2 = getelementptr <2 x i64>, ptr %src, i32 1
  %l2 = load <2 x i64>, ptr %s2, align 4
  %s3 = getelementptr <2 x i64>, ptr %src, i32 2
  %l3 = load <2 x i64>, ptr %s3, align 4
  %s4 = getelementptr <2 x i64>, ptr %src, i32 3
  %l4 = load <2 x i64>, ptr %s4, align 4
  %t1 = shufflevector <2 x i64> %l1, <2 x i64> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i64> %l3, <2 x i64> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x i64> %t1, <4 x i64> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x i64> %s, ptr %dst
  %ret = getelementptr inbounds <8 x i64>, ptr %dst, i32 1
  ret ptr %ret
}

; f32

define ptr @vst4_v4f32(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.32 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.32 {q0, q1, q2, q3}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <4 x float>, ptr %src, align 4
  %s2 = getelementptr <4 x float>, ptr %src, i32 1
  %l2 = load <4 x float>, ptr %s2, align 4
  %s3 = getelementptr <4 x float>, ptr %src, i32 2
  %l3 = load <4 x float>, ptr %s3, align 4
  %s4 = getelementptr <4 x float>, ptr %src, i32 3
  %l4 = load <4 x float>, ptr %s4, align 4
  %t1 = shufflevector <4 x float> %l1, <4 x float> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x float> %l3, <4 x float> %l4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %s = shufflevector <8 x float> %t1, <8 x float> %t2, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  store <16 x float> %s, ptr %dst
  %ret = getelementptr inbounds <16 x float>, ptr %dst, i32 1
  ret ptr %ret
}

; f16

define ptr @vst4_v8f16(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vst40.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst41.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst42.16 {q0, q1, q2, q3}, [r1]
; CHECK-NEXT:    vst43.16 {q0, q1, q2, q3}, [r1]!
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <8 x half>, ptr %src, align 4
  %s2 = getelementptr <8 x half>, ptr %src, i32 1
  %l2 = load <8 x half>, ptr %s2, align 4
  %s3 = getelementptr <8 x half>, ptr %src, i32 2
  %l3 = load <8 x half>, ptr %s3, align 4
  %s4 = getelementptr <8 x half>, ptr %src, i32 3
  %l4 = load <8 x half>, ptr %s4, align 4
  %t1 = shufflevector <8 x half> %l1, <8 x half> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x half> %l3, <8 x half> %l4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %s = shufflevector <16 x half> %t1, <16 x half> %t2, <32 x i32> <i32 0, i32 8, i32 16, i32 24, i32 1, i32 9, i32 17, i32 25, i32 2, i32 10, i32 18, i32 26, i32 3, i32 11, i32 19, i32 27, i32 4, i32 12, i32 20, i32 28, i32 5, i32 13, i32 21, i32 29, i32 6, i32 14, i32 22, i32 30, i32 7, i32 15, i32 23, i32 31>
  store <32 x half> %s, ptr %dst
  %ret = getelementptr inbounds <32 x half>, ptr %dst, i32 1
  ret ptr %ret
}

; f64

define ptr @vst4_v2f64(ptr %src, ptr %dst) {
; CHECK-LABEL: vst4_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #32]
; CHECK-NEXT:    vmov.f64 d2, d6
; CHECK-NEXT:    vmov.f64 d3, d0
; CHECK-NEXT:    vmov.f64 d0, d7
; CHECK-NEXT:    vmov.f64 d7, d4
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vmov.f64 d6, d8
; CHECK-NEXT:    vmov.f64 d4, d9
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vstrw.32 q2, [r1, #48]
; CHECK-NEXT:    vstrw.32 q1, [r1], #64
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %l1 = load <2 x double>, ptr %src, align 4
  %s2 = getelementptr <2 x double>, ptr %src, i32 1
  %l2 = load <2 x double>, ptr %s2, align 4
  %s3 = getelementptr <2 x double>, ptr %src, i32 2
  %l3 = load <2 x double>, ptr %s3, align 4
  %s4 = getelementptr <2 x double>, ptr %src, i32 3
  %l4 = load <2 x double>, ptr %s4, align 4
  %t1 = shufflevector <2 x double> %l1, <2 x double> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x double> %l3, <2 x double> %l4, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %s = shufflevector <4 x double> %t1, <4 x double> %t2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  store <8 x double> %s, ptr %dst
  %ret = getelementptr inbounds <8 x double>, ptr %dst, i32 1
  ret ptr %ret
}
